import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface QuotaRateLimitConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set, when a client reaches a rate limit threshold, the client will be prohibited from any further requests until after the 'block_interval' in seconds has elapsed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#block_interval QuotaRateLimit#block_interval}
    */
    readonly blockInterval?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#id QuotaRateLimit#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The duration in seconds to enforce rate limiting for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#interval QuotaRateLimit#interval}
    */
    readonly interval?: number;
    /**
    * The name of the quota.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#name QuotaRateLimit#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#namespace QuotaRateLimit#namespace}
    */
    readonly namespace?: string;
    /**
    * Path of the mount or namespace to apply the quota. A blank path configures a global rate limit quota.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#path QuotaRateLimit#path}
    */
    readonly path?: string;
    /**
    * The maximum number of requests at any given second to be allowed by the quota rule. The rate must be positive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#rate QuotaRateLimit#rate}
    */
    readonly rate: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit vault_quota_rate_limit}
*/
export declare class QuotaRateLimit extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_quota_rate_limit";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit vault_quota_rate_limit} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options QuotaRateLimitConfig
    */
    constructor(scope: Construct, id: string, config: QuotaRateLimitConfig);
    private _blockInterval?;
    get blockInterval(): number;
    set blockInterval(value: number);
    resetBlockInterval(): void;
    get blockIntervalInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _rate?;
    get rate(): number;
    set rate(value: number);
    get rateInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
