"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
const global_table_coordinator_1 = require("./global-table-coordinator");
/**
 * This class works by deploying an AWS DynamoDB table into each region specified in  GlobalTableProps.regions[],
 * then triggering a CloudFormation Custom Resource Lambda to link them all together to create linked AWS Global DynamoDB tables.
 *
 * @deprecated use `@aws-cdk/aws-dynamodb.Table.replicationRegions` instead
 */
class GlobalTable extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Creates dynamoDB tables across regions that will be able to be globbed together into a global table
         */
        this._regionalTables = new Array();
        this.node.addWarning('The @aws-cdk/aws-dynamodb-global module has been deprecated in favor of @aws-cdk/aws-dynamodb.Table.replicationRegions');
        this._regionalTables = [];
        if (props.stream != null && props.stream !== dynamodb.StreamViewType.NEW_AND_OLD_IMAGES) {
            throw new Error('dynamoProps.stream MUST be set to dynamodb.StreamViewType.NEW_AND_OLD_IMAGES');
        }
        // need to set this stream specification, otherwise global tables don't work
        // And no way to set a default value in an interface
        const regionalTableProps = {
            ...props,
            removalPolicy: props.removalPolicy,
            stream: dynamodb.StreamViewType.NEW_AND_OLD_IMAGES,
        };
        this.lambdaGlobalTableCoordinator = new global_table_coordinator_1.GlobalTableCoordinator(scope, id + '-CustomResource', props);
        const scopeStack = cdk.Stack.of(scope);
        // here we loop through the configured regions.
        // in each region we'll deploy a separate stack with a DynamoDB Table with identical properties in the individual stacks
        for (const region of props.regions) {
            const regionalStack = new cdk.Stack(this, id + '-' + region, { env: { region, account: scopeStack.account } });
            const regionalTable = new dynamodb.Table(regionalStack, `${id}-GlobalTable-${region}`, regionalTableProps);
            this._regionalTables.push(regionalTable);
            // deploy the regional stack before the Lambda coordinator stack
            this.lambdaGlobalTableCoordinator.addDependency(regionalStack);
        }
    }
    /**
     * Obtain tables deployed in other each region
     */
    get regionalTables() {
        return this._regionalTables.map(x => x);
    }
}
exports.GlobalTable = GlobalTable;
//# sourceMappingURL=data:application/json;base64,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