"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineDeployStackAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn = require("@aws-cdk/aws-cloudformation");
const cpactions = require("@aws-cdk/aws-codepipeline-actions");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const cdk = require("@aws-cdk/core");
/**
 * A class to deploy a stack that is part of a CDK App, using CodePipeline.
 * This composite Action takes care of preparing and executing a CloudFormation ChangeSet.
 *
 * It currently does *not* support stacks that make use of ``Asset``s, and
 * requires the deployed stack is in the same account and region where the
 * CodePipeline is hosted.
 */
class PipelineDeployStackAction {
    constructor(props) {
        var _b, _c;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction", "");
            jsiiDeprecationWarnings._aws_cdk_app_delivery_PipelineDeployStackActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.stack = props.stack;
        const assets = this.stack.node.metadata.filter(md => md.type === cxschema.ArtifactMetadataEntryType.ASSET);
        if (assets.length > 0) {
            // FIXME: Implement the necessary actions to publish assets
            throw new Error(`Cannot deploy the stack ${this.stack.stackName} because it references ${assets.length} asset(s)`);
        }
        const createChangeSetRunOrder = props.createChangeSetRunOrder || 1;
        const executeChangeSetRunOrder = props.executeChangeSetRunOrder || (createChangeSetRunOrder + 1);
        if (createChangeSetRunOrder >= executeChangeSetRunOrder) {
            throw new Error(`createChangeSetRunOrder (${createChangeSetRunOrder}) must be < executeChangeSetRunOrder (${executeChangeSetRunOrder})`);
        }
        const changeSetName = props.changeSetName || 'CDK-CodePipeline-ChangeSet';
        const capabilities = cfnCapabilities(props.adminPermissions, props.capabilities);
        this.prepareChangeSetAction = new cpactions.CloudFormationCreateReplaceChangeSetAction({
            actionName: (_b = props.createChangeSetActionName) !== null && _b !== void 0 ? _b : 'ChangeSet',
            changeSetName,
            runOrder: createChangeSetRunOrder,
            stackName: props.stack.stackName,
            templatePath: props.input.atPath(props.stack.templateFile),
            adminPermissions: props.adminPermissions,
            deploymentRole: props.role,
            capabilities,
        });
        this.executeChangeSetAction = new cpactions.CloudFormationExecuteChangeSetAction({
            actionName: (_c = props.executeChangeSetActionName) !== null && _c !== void 0 ? _c : 'Execute',
            changeSetName,
            runOrder: executeChangeSetRunOrder,
            stackName: this.stack.stackName,
        });
    }
    bind(scope, stage, options) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#bind", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.stack.environment !== cdk.Stack.of(scope).environment) {
            // FIXME: Add the necessary to extend to stacks in a different account
            throw new Error('Cross-environment deployment is not supported');
        }
        stage.addAction(this.prepareChangeSetAction);
        this._deploymentRole = this.prepareChangeSetAction.deploymentRole;
        return this.executeChangeSetAction.bind(scope, stage, options);
    }
    get deploymentRole() {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#deploymentRole", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "deploymentRole").get);
            }
            throw error;
        }
        if (!this._deploymentRole) {
            throw new Error('Use this action in a pipeline first before accessing \'deploymentRole\'');
        }
        return this._deploymentRole;
    }
    /**
     * Add policy statements to the role deploying the stack.
     *
     * This role is passed to CloudFormation and must have the IAM permissions
     * necessary to deploy the stack or you can grant this role `adminPermissions`
     * by using that option during creation. If you do not grant
     * `adminPermissions` you need to identify the proper statements to add to
     * this role based on the CloudFormation Resources in your stack.
     */
    addToDeploymentRolePolicy(statement) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#addToDeploymentRolePolicy", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToDeploymentRolePolicy);
            }
            throw error;
        }
        this.deploymentRole.addToPolicy(statement);
    }
    onStateChange(name, target, options) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#onStateChange", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onStateChange);
            }
            throw error;
        }
        return this.executeChangeSetAction.onStateChange(name, target, options);
    }
    get actionProperties() {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/app-delivery.PipelineDeployStackAction#actionProperties", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "actionProperties").get);
            }
            throw error;
        }
        return this.executeChangeSetAction.actionProperties;
    }
}
exports.PipelineDeployStackAction = PipelineDeployStackAction;
_a = JSII_RTTI_SYMBOL_1;
PipelineDeployStackAction[_a] = { fqn: "@aws-cdk/app-delivery.PipelineDeployStackAction", version: "1.159.0" };
function cfnCapabilities(adminPermissions, capabilities) {
    if (adminPermissions && capabilities === undefined) {
        // admin true default capability to NamedIAM and AutoExpand
        return [cfn.CloudFormationCapabilities.NAMED_IAM, cfn.CloudFormationCapabilities.AUTO_EXPAND];
    }
    else if (capabilities === undefined) {
        // else capabilities are undefined set AnonymousIAM and AutoExpand
        return [cfn.CloudFormationCapabilities.ANONYMOUS_IAM, cfn.CloudFormationCapabilities.AUTO_EXPAND];
    }
    else {
        // else capabilities are defined use them
        return capabilities;
    }
}
//# sourceMappingURL=data:application/json;base64,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