macro(find_dependency_win)
    # curl
    x_vcpkg_pkgconfig_get_modules(PREFIX CURL MODULES --msvc-syntax libcurl INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "CURL_INC=${CURL_INCLUDE_DIRS_RELEASE}" "CURL_LIB=${CURL_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "CURL_INC=${CURL_INCLUDE_DIRS_DEBUG}" "CURL_LIB=${CURL_LIBS_DEBUG}")

    # expat
    list(APPEND NMAKE_OPTIONS "EXPAT_DIR=YES")
    x_vcpkg_pkgconfig_get_modules(PREFIX EXPAT MODULES --msvc-syntax expat INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "EXPAT_INCLUDE=${EXPAT_INCLUDE_DIRS}" "EXPAT_LIB=${EXPAT_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "EXPAT_INCLUDE=${EXPAT_INCLUDE_DIRS}" "EXPAT_LIB=${EXPAT_LIBS_DEBUG}")

    # geos
    x_vcpkg_pkgconfig_get_modules(PREFIX GEOS MODULES --msvc-syntax geos INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "GEOS_CFLAGS=${GEOS_INCLUDE_DIRS_RELEASE} -DHAVE_GEOS" "GEOS_LIB=${GEOS_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "GEOS_CFLAGS=${GEOS_INCLUDE_DIRS_DEBUG} -DHAVE_GEOS" "GEOS_LIB=${GEOS_LIBS_DEBUG}")

    # libgeotiff
    list(APPEND NMAKE_OPTIONS "GEOTIFF_INC=-I${CURRENT_INSTALLED_DIR}/include")
    if(VCPKG_LIBRARY_LINKAGE STREQUAL "dynamic")
        list(APPEND NMAKE_OPTIONS_REL "GEOTIFF_LIB=${CURRENT_INSTALLED_DIR}/lib/geotiff_i.lib")
        list(APPEND NMAKE_OPTIONS_DBG "GEOTIFF_LIB=${CURRENT_INSTALLED_DIR}/debug/lib/geotiff_d_i.lib")
    else()
        # libgeotiff may need tiff and proj4, but these are added separately, with all transitive deps.
        list(APPEND NMAKE_OPTIONS_REL "GEOTIFF_LIB=${CURRENT_INSTALLED_DIR}/lib/geotiff.lib")
        list(APPEND NMAKE_OPTIONS_DBG "GEOTIFF_LIB=${CURRENT_INSTALLED_DIR}/debug/lib/geotiff_d.lib")
    endif()

    # libiconv
    # There is no pc file, and CMake added the Find module in version 3.11.
    list(APPEND extra_exports ICONV)
    set(ICONV_LIBS_RELEASE "${CURRENT_INSTALLED_DIR}/lib/iconv.lib ${CURRENT_INSTALLED_DIR}/lib/charset.lib")
    set(ICONV_LIBS_DEBUG "${CURRENT_INSTALLED_DIR}/debug/lib/iconv.lib ${CURRENT_INSTALLED_DIR}/debug/lib/charset.lib")
    list(APPEND NMAKE_OPTIONS "LIBICONV_INCLUDE=-I${CURRENT_INSTALLED_DIR}/include" "LIBICONV_CFLAGS=-DICONV_CONST=")
    list(APPEND NMAKE_OPTIONS_REL "LIBICONV_LIBRARY=${ICONV_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "LIBICONV_LIBRARY=${ICONV_LIBS_DEBUG}")

    # libjpeg-turbo
    list(APPEND NMAKE_OPTIONS "JPEG_EXTERNAL_LIB=1" "JPEGDIR=${CURRENT_INSTALLED_DIR}/include")
    x_vcpkg_pkgconfig_get_modules(PREFIX JPEG MODULES --msvc-syntax libjpeg LIBS)
    list(APPEND NMAKE_OPTIONS_REL "JPEG_LIB=${JPEG_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "JPEG_LIB=${JPEG_LIBS_DEBUG}")

    # liblzma
    x_vcpkg_pkgconfig_get_modules(PREFIX LZMA MODULES --msvc-syntax liblzma INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "LZMA_CFLAGS=${LZMA_INCLUDE_DIRS_RELEASE}" "LZMA_LIBS=${LZMA_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "LZMA_CFLAGS=${LZMA_INCLUDE_DIRS_DEBUG}" "LZMA_LIBS=${LZMA_LIBS_DEBUG}")

    # libpng
    list(APPEND NMAKE_OPTIONS "PNG_EXTERNAL_LIB=1" "PNGDIR=${CURRENT_INSTALLED_DIR}/include")
    x_vcpkg_pkgconfig_get_modules(PREFIX PNG MODULES --msvc-syntax libpng LIBS)
    list(APPEND NMAKE_OPTIONS_REL "PNG_LIB=${PNG_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "PNG_LIB=${PNG_LIBS_DEBUG}")

    # libwebp
    list(APPEND NMAKE_OPTIONS "WEBP_ENABLED=YES")
    x_vcpkg_pkgconfig_get_modules(PREFIX WEBP MODULES --msvc-syntax libwebp INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "WEBP_CFLAGS=${WEBP_INCLUDE_DIRS_RELEASE}" "WEBP_LIBS=${WEBP_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "WEBP_CFLAGS=${WEBP_INCLUDE_DIRS_DEBUG}" "WEBP_LIBS=${WEBP_LIBS_DEBUG}")

    # libxml2
    x_vcpkg_pkgconfig_get_modules(PREFIX LIBXML2 MODULES --msvc-syntax libxml-2.0 INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "LIBXML2_INC=${LIBXML2_INCLUDE_DIRS_RELEASE}" "LIBXML2_LIB=${LIBXML2_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "LIBXML2_INC=${LIBXML2_INCLUDE_DIRS_DEBUG}" "LIBXML2_LIB=${LIBXML2_LIBS_DEBUG}")

    # openjpeg
    list(APPEND NMAKE_OPTIONS "OPENJPEG_ENABLED=YES")
    x_vcpkg_pkgconfig_get_modules(PREFIX OPENJPEG MODULES --msvc-syntax libopenjp2 INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "OPENJPEG_CFLAGS=${OPENJPEG_INCLUDE_DIRS_RELEASE}" "OPENJPEG_LIB=${OPENJPEG_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "OPENJPEG_CFLAGS=${OPENJPEG_INCLUDE_DIRS_DEBUG}" "OPENJPEG_LIB=${OPENJPEG_LIBS_DEBUG}")

    # proj
    x_vcpkg_pkgconfig_get_modules(PREFIX PROJ MODULES --msvc-syntax proj INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "PROJ_INCLUDE=${PROJ_INCLUDE_DIRS_RELEASE}" "PROJ_LIBRARY=${PROJ_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "PROJ_INCLUDE=${PROJ_INCLUDE_DIRS_DEBUG}" "PROJ_LIBRARY=${PROJ_LIBS_DEBUG}")

    # sqlite3 and spatialite
    if ("libspatialite" IN_LIST FEATURES)
        list(APPEND extra_exports SPATIALITE)
        list(APPEND NMAKE_OPTIONS "SPATIALITE_412_OR_LATER=yes")
        x_vcpkg_pkgconfig_get_modules(PREFIX SQLITE MODULES --msvc-syntax spatialite sqlite3 INCLUDE_DIRS LIBS)
        string(APPEND SQLITE_INCLUDE_DIRS_RELEASE " -DHAVE_SPATIALITE")
        string(APPEND SQLITE_INCLUDE_DIRS_DEBUG " -DHAVE_SPATIALITE")
    else()
        x_vcpkg_pkgconfig_get_modules(PREFIX SQLITE MODULES --msvc-syntax sqlite3 INCLUDE_DIRS LIBS)
    endif()
    list(APPEND NMAKE_OPTIONS_REL "SQLITE_INC=${SQLITE_INCLUDE_DIRS_RELEASE}" "SQLITE_LIB=${SQLITE_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "SQLITE_INC=${SQLITE_INCLUDE_DIRS_DEBUG}" "SQLITE_LIB=${SQLITE_LIBS_DEBUG}")

    # tiff
    x_vcpkg_pkgconfig_get_modules(PREFIX TIFF MODULES --msvc-syntax libtiff-4 INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "TIFF_INC=${TIFF_INCLUDE_DIRS_RELEASE} -DBIGTIFF_SUPPORT" "TIFF_LIB=${TIFF_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "TIFF_INC=${TIFF_INCLUDE_DIRS_DEBUG} -DBIGTIFF_SUPPORT" "TIFF_LIB=${TIFF_LIBS_DEBUG}")

    # zlib
    list(APPEND NMAKE_OPTIONS "ZLIB_EXTERNAL_LIB=1")
    x_vcpkg_pkgconfig_get_modules(PREFIX ZLIB MODULES --msvc-syntax zlib INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "ZLIB_INC=${ZLIB_INCLUDE_DIRS_RELEASE}" "ZLIB_LIB=${ZLIB_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "ZLIB_INC=${ZLIB_INCLUDE_DIRS_DEBUG}" "ZLIB_LIB=${ZLIB_LIBS_DEBUG}")

    # zstd
    x_vcpkg_pkgconfig_get_modules(PREFIX ZSTD MODULES --msvc-syntax libzstd INCLUDE_DIRS LIBS)
    list(APPEND NMAKE_OPTIONS_REL "ZSTD_CFLAGS=${ZSTD_INCLUDE_DIRS_RELEASE}" "ZSTD_LIBS=${ZSTD_LIBS_RELEASE}")
    list(APPEND NMAKE_OPTIONS_DBG "ZSTD_CFLAGS=${ZSTD_INCLUDE_DIRS_DEBUG}" "ZSTD_LIBS=${ZSTD_LIBS_DEBUG}")

    # Features

    if ("cfitsio" IN_LIST FEATURES)
        list(APPEND NMAKE_OPTIONS "FITS_INC_DIR=${CURRENT_INSTALLED_DIR}/include" "FITS_PLUGIN=NO")
        list(APPEND NMAKE_OPTIONS_REL "FITS_LIB=${CURRENT_INSTALLED_DIR}/lib/cfitsio.lib")
        list(APPEND NMAKE_OPTIONS_DBG "FITS_LIB=${CURRENT_INSTALLED_DIR}/debug/lib/cfitsio.lib")
    endif()

    if("hdf5" IN_LIST FEATURES)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}" HDF5_DIR)
        x_vcpkg_pkgconfig_get_modules(PREFIX HDF5 MODULES --msvc-syntax hdf5 LIBS)
        list(APPEND NMAKE_OPTIONS "HDF5_DIR=${CURRENT_INSTALLED_DIR}" "HDF5_PLUGIN=NO")
        list(APPEND NMAKE_OPTIONS_REL "HDF5_LIB=${HDF5_LIBS_RELEASE}")
        list(APPEND NMAKE_OPTIONS_DBG "HDF5_LIB=${HDF5_LIBS_DEBUG}")
        if(VCPKG_LIBRARY_LINKAGE STREQUAL "dynamic")
            list(APPEND NMAKE_OPTIONS "HDF5_H5_IS_DLL=YES")
        endif()
    endif()

    if("mysql-libmariadb" IN_LIST FEATURES)
        list(APPEND NMAKE_OPTIONS "MYSQL_INC_DIR=${CURRENT_INSTALLED_DIR}/include/mysql")
        list(APPEND NMAKE_OPTIONS_REL "MYSQL_LIB=${CURRENT_INSTALLED_DIR}/lib/libmariadb.lib")
        list(APPEND NMAKE_OPTIONS_DBG "MYSQL_LIB=${CURRENT_INSTALLED_DIR}/debug/lib/libmariadb.lib")
    endif()

    if("netcdf" IN_LIST FEATURES)
        list(APPEND NMAKE_OPTIONS "NETCDF_INC_DIR=${CURRENT_INSTALLED_DIR}/include" "NETCDF_SETTING=yes" "NETCDF_PLUGIN=NO")
        x_vcpkg_pkgconfig_get_modules(PREFIX NETCDF MODULES --msvc-syntax netcdf LIBS)
        list(APPEND NMAKE_OPTIONS_REL "NETCDF_LIB=${NETCDF_LIBS_RELEASE}")
        list(APPEND NMAKE_OPTIONS_DBG "NETCDF_LIB=${NETCDF_LIBS_DEBUG}")
    endif()

    if("poppler" IN_LIST FEATURES)
        list(APPEND NMAKE_OPTIONS "POPPLER_ENABLED=YES")
        list(APPEND NMAKE_OPTIONS "POPPLER_MAJOR_VERSION=22" "POPPLER_MINOR_VERSION=3") # Bump as needed
        list(APPEND NMAKE_OPTIONS "POPPLER_CFLAGS=-I${CURRENT_INSTALLED_DIR}/include -I${CURRENT_INSTALLED_DIR}/include/poppler /std:c++17")
        x_vcpkg_pkgconfig_get_modules(PREFIX POPPLER MODULES --msvc-syntax poppler LIBS)
        list(APPEND NMAKE_OPTIONS_REL "POPPLER_LIBS=${POPPLER_LIBS_RELEASE}")
        list(APPEND NMAKE_OPTIONS_DBG "POPPLER_LIBS=${POPPLER_LIBS_DEBUG}")
    endif()

    if("postgresql" IN_LIST FEATURES)
        list(APPEND NMAKE_OPTIONS "PG_INC_DIR=${CURRENT_INSTALLED_DIR}/include")
        x_vcpkg_pkgconfig_get_modules(PREFIX OPENSSL MODULES --msvc-syntax openssl LIBS)
        set(PGSQL_LIBRARY_REL "${CURRENT_INSTALLED_DIR}/lib/libpq.lib ${CURRENT_INSTALLED_DIR}/lib/libpgcommon.lib ${CURRENT_INSTALLED_DIR}/lib/libpgport.lib")
        list(APPEND NMAKE_OPTIONS_REL "PG_LIB=${PGSQL_LIBRARY_REL} Secur32.lib Shell32.lib Advapi32.lib Crypt32.lib Gdi32.lib ${OPENSSL_LIBS_RELEASE}")
        set(PGSQL_LIBRARY_DBG "${CURRENT_INSTALLED_DIR}/debug/lib/libpq.lib ${CURRENT_INSTALLED_DIR}/debug/lib/libpgcommon.lib ${CURRENT_INSTALLED_DIR}/debug/lib/libpgport.lib")
        list(APPEND NMAKE_OPTIONS_DBG "PG_LIB=${PGSQL_LIBRARY_DBG} Secur32.lib Shell32.lib Advapi32.lib Crypt32.lib Gdi32.lib ${OPENSSL_LIBS_DEBUG}")
    endif()

    # Dependencies which are not in vpckg.json

    # cryptopp
    if("system-libraries" IN_LIST FEATURES AND EXISTS "${CURRENT_INSTALLED_DIR}/lib/cryptopp-static.lib")
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/include" CRYPTOPP_INCLUDE)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/cryptopp-static.lib" CRYPTOPP_LIBRARY_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/cryptopp-static.lib" CRYPTOPP_LIBRARY_DBG)
        list(APPEND NMAKE_OPTIONS CRYPTOPP_INC=-I${CRYPTOPP_INCLUDE})
        list(APPEND NMAKE_OPTIONS_REL CRYPTOPP_LIB=${CRYPTOPP_LIBRARY_REL})
        list(APPEND NMAKE_OPTIONS_DBG CRYPTOPP_LIB=${CRYPTOPP_LIBRARY_DBG})
    endif()

    # freexl
    if("system-libraries" IN_LIST FEATURES AND EXISTS "${CURRENT_INSTALLED_DIR}/lib/freexl.lib")
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/include" FREEXL_INCLUDE)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/freexl.lib" FREEXL_LIBRARY_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/freexl.lib" FREEXL_LIBRARY_DBG)
        list(APPEND NMAKE_OPTIONS FREEXL_CFLAGS=-I${FREEXL_INCLUDE})
        list(APPEND NMAKE_OPTIONS_REL FREEXL_LIBS=${FREEXL_LIBRARY_REL})
        list(APPEND NMAKE_OPTIONS_DBG FREEXL_LIBS=${FREEXL_LIBRARY_DBG})
    endif()

    # libkml
    if("system-libraries" IN_LIST FEATURES AND EXISTS "${CURRENT_INSTALLED_DIR}/lib/kmlbase.lib")
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}" LIBKML_DIR)
        list(APPEND NMAKE_OPTIONS LIBKML_DIR=${LIBKML_DIR})
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/include" LIBKML_INCLUDE)
        list(APPEND NMAKE_OPTIONS LIBKML_INCLUDE=-I${LIBKML_INCLUDE})
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/kmlbase.lib" KMLBASE_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/kmlbase.lib" KMLBASE_DBG)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/kmlconvenience.lib" KMLCONVENIENCE_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/kmlconvenience.lib" KMLCONVENIENCE_DBG)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/kmldom.lib" KMLDOM_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/kmldom.lib" KMLDOM_DBG)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/kmlengine.lib" KMLENGINE_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/kmlengine.lib" KMLENGINE_DBG)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/kmlregionator.lib" KMLREGIONATOR_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/kmlregionator.lib" KMLREGIONATOR_DBG)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/kmlxsd.lib" KMLXSD_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/kmlxsd.lib" KMLXSD_DBG)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/bz2.lib" BZIP2_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/bz2d.lib" BZIP2_DBG)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/minizip.lib" MINIZIP_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/minizip.lib" MINIZIP_DBG)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/uriparser.lib" URIPARSER_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/uriparser.lib" URIPARSER_DBG)
        list(APPEND NMAKE_OPTIONS_REL "LIBKML_LIBS=${KMLBASE_REL} ${KMLCONVENIENCE_REL} ${KMLDOM_REL} ${KMLENGINE_REL} ${KMLREGIONATOR_REL} ${KMLXSD_REL} ${BZIP2_REL} ${MINIZIP_REL} ${URIPARSER_REL} ${EXPAT_LIBRARY_REL} ${ZLIB_LIBRARY_REL}")
        list(APPEND NMAKE_OPTIONS_DBG "LIBKML_LIBS=${KMLBASE_DBG} ${KMLCONVENIENCE_DBG} ${KMLDOM_DBG} ${KMLENGINE_DBG} ${KMLREGIONATOR_DBG} ${KMLXSD_DBG} ${BZIP2_DBG} ${MINIZIP_DBG} ${URIPARSER_DBG} ${EXPAT_LIBRARY_DBG} ${ZLIB_LIBRARY_DBG}")
    endif()

    # xerces-c
    if("system-libraries" IN_LIST FEATURES AND EXISTS "${CURRENT_INSTALLED_DIR}/lib/xerces-c_3.lib")
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}" XERCES_DIR)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/include" XERCES_INCLUDE)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/lib/xerces-c_3.lib" XERCES_LIBRARY_REL)
        file(TO_NATIVE_PATH "${CURRENT_INSTALLED_DIR}/debug/lib/xerces-c_3D.lib" XERCES_LIBRARY_DBG)
        list(APPEND NMAKE_OPTIONS ILI_ENABLED=YES)
        list(APPEND NMAKE_OPTIONS XERCES_DIR=${XERCES_DIR})
        list(APPEND NMAKE_OPTIONS "XERCES_INCLUDE=-I${XERCES_INCLUDE} -I${XERCES_INCLUDE}/xercesc")
        list(APPEND NMAKE_OPTIONS_REL XERCES_LIB=${XERCES_LIBRARY_REL})
        list(APPEND NMAKE_OPTIONS_DBG XERCES_LIB=${XERCES_LIBRARY_DBG})
    endif()

endmacro()
