# Every update requires an update of these hashes and the version within the control file of each of the 32 ports.
# So it is probably better to have a central location for these hashes and let the ports update via a script
set(QT_MAJOR_MINOR_VER 5.15)
set(QT_PATCH_VER 4)
set(QT_UPDATE_VERSION 0) # Switch to update qt and not build qt. Creates a file cmake/qt_new_hashes.cmake in qt5-base with the new hashes.

set(QT_PORT_LIST base 3d activeqt charts connectivity datavis3d declarative gamepad graphicaleffects imageformats location macextras mqtt multimedia networkauth
                 purchasing quickcontrols quickcontrols2 remoteobjects script scxml sensors serialport speech svg tools virtualkeyboard webchannel websockets
                 webview winextras xmlpatterns doc x11extras androidextras translations serialbus webengine webglplugin wayland)

set(QT_HASH_qt5-base             91a1d95c2891939ae55134e8897cbc423142bd8eda954a1e65bb563b0932ed9e2da34db374fd86858b4a819e8abe824a967b31f4fb316528ec8aaf15016c6ad3)
set(QT_HASH_qt5-3d               cb2ea961109a153e78147450310408f4f573186d12412ebdd71511eb273ca78113d3aede583ec8aa44fe19f5268bb6fab3386c5501142ad6a22e10890ce52f62)
set(QT_HASH_qt5-activeqt         39ef01523583cbdea80143fae25afb1cfeb7131769430ab153a82edd6c5478383c558a06ea7053b8d99b8945a6422c4f38765ffb72cd87f0f34cc9ad78ebc603)
set(QT_HASH_qt5-androidextras    527471c0dc9b51ffccdb6c8134b78be4f6d2039bc8dee22529a117457e8153aaf1b081e23704864cc6999ba3059876a85bd3a27b9bcc9fbfda618816c92b719b)
set(QT_HASH_qt5-charts           e7a4cac3b3a0c60c7ab509d5a533521dd8dc0cb5ad69d66a87f12671c73c1928d902e0be377efb77e0ddadefe1ef8800c0cf07e8213f44367bcd80a787342bcf)
set(QT_HASH_qt5-connectivity     3f2c0a59ff6be9531f5ebc81a4344e0b12c8ef92fbfa466f2777d4ed3b4b08657214e93e0aada856a0c6475b6b760aeeb06f0b2be894e61cd7b344c49fefaf95)
set(QT_HASH_qt5-datavis3d        044cdee342ef4d9beb62b910cee59f9cb362c85d517e19a1c0327dfa2b518b2fa484e36756ee9302fb043cc506340b501202861a858d374a5f69cbcddec18301)
set(QT_HASH_qt5-declarative      8a4ff61238fde7cc563f9d94b5d1f4fd71ecb95ace447e57d08f71da82400b37c42f4f1ecdcd561116bffa1ed483219e06fb550f91c90842e5a43487bc4706b6)
set(QT_HASH_qt5-doc              2552501dfbc5ad8e42f211a621340902fa85634bc8a2a62ce457029d6f7cbd534a29a671c33aa1d034198a1491fd6d257db7177b0ca5e1ef57b84272a392cf06)
set(QT_HASH_qt5-gamepad          37eaad5338b6c5114571c6983fb806ff6537ba7d3dc4bf8d02899e693198a22ce17b0b3ddf2aa52447fcebb0ef97a3baa8e1bc3a7e3f265ad047509f53160ee9)
set(QT_HASH_qt5-graphicaleffects 00cf02057dfc1624c84079e1a08a65ceb6fb7df712f05ac9cb0006de0add9241e56a8e3909eeb04d1f6a90d5032909a41d59341e002750ab99d2449f635e64e3)
set(QT_HASH_qt5-imageformats     388a9ceebdca6d32f606615af37233f2d8394856d067c9a80486b88ad5714eac90263cd6555a3efd9c1b5fdcc27431b7f99eed6fc02760b1a9974515bfe70274)
set(QT_HASH_qt5-location         6208052d6ac173d19dc77496d8108558e7f31696dc5792fcbbeef2029539db76a60c5a51a7d198f54ea6c0ec23977a57cd8c8f8fa80fe5eac9528d2510c3dbb3)
set(QT_HASH_qt5-macextras        93985001db49985c69360dc58f6260ce2e26f861696c2f5989be9da3e239292fa5b954e0d036869a2e3d6fb046053e39ae113e4307ec762d8db1aa17af1998f5)
set(QT_HASH_qt5-mqtt             7a81d0bec0c59cb5574e96a2f9b33c0eea04789731909247544d14c87a0fa854214b8bfd35ee69831747e9487b616b75bbc9dfd9e78f33acd6b7a69dfaacdd75)
set(QT_HASH_qt5-multimedia       bb0ada7560093b89751b5b3c0e1a573de215a388d621d356bc3c0e1acfffc2d696230c67b7a7cef037b18c4da900c7eb3d315bd2e73ce12f9aedd0e340399117)
set(QT_HASH_qt5-networkauth      a36ce21151cb98bcbc99a819e873ef10f68d988aebfbae9aaaa7dc85bd4a693ad7510c47627f0f3841c5ef50173b21cdebe6a602fa429839fd9ad9bcc02d6c3c)
set(QT_HASH_qt5-purchasing       6455cff7b3dd2bbf5fc85ba9067b86bb042723b73d0b8984ab43ffdf444e50b5a68bb992ec82b133ac0e0cc3e18ca784cff8357e1e61ffe9fbbef1ff0f21a55f)
set(QT_HASH_qt5-quickcontrols    887a8f5fdcd3764575f9068ec8428526a049bb09ae0c214daef3652527d5e448baa53738dccf316b20ccf18f36951ecebd570aee3a27f9c32b9213ef7629de10)
set(QT_HASH_qt5-quickcontrols2   4ebbb0199db156307140406b6da4fa83c47aee2105e8c46c0da96313ddc4d6d7ea2f1f85691856144eb8c5109c108bb6810ba0693a2d2411b4feaeed1ec9a8f4)
set(QT_HASH_qt5-remoteobjects    6702f9419d5198572e37f0ee6883c2af38f4a249036365d9e084cd4acb30478f6935835493330b101482e998153d4e4f515004e0ffd428b64a86bba17eb203d6)
set(QT_HASH_qt5-script           01d3b03eec23f462a7931e268eb8572d85ed560dd8b24f85b420ff8ebb1932d4c18f47c8d5fad7b7c09c147158b02b6cceb9c571b10249ba4008b363e23d7f95)
set(QT_HASH_qt5-scxml            2664e4e707fd10aa2ef832fdfc133695da3f6f80c2a611dc94b4e22b34c3226d5baa1e5afc77db2115317c654460ebb60896c006aa93b324fe67d6860ae9b431)
set(QT_HASH_qt5-sensors          b8b9ffedfdcd392bd5c1ab76db3f621d16094f444e14900726378a289c04c08a75b82628cb61f4ca66bba8c1eeba2a56d9f90d9a82adfdc90fc00ac1b579c63e)
set(QT_HASH_qt5-serialbus        931362b171799fd8e449d418c3ae80c029c39edffc66b5c3fa054991332950241803d282e1ae1e5f72c8395f88f9d82d6a2d04f00b3907b5e9f7fb5be4f555e7)
set(QT_HASH_qt5-serialport       d8bc3d0b89bb4fc05bfe27a4c76bc3732ef5f8ba889400c8116f18c2ed58db7a3b99c4bda1cd60d1e8051121d31a4b55b95d20e89578a6e523d527e6182262ba)
set(QT_HASH_qt5-speech           6582fe36950aee8428c72582ff2eda2dae433ad969c323e0c6e8be611be7d81766ceb1cae85a10dcd4d266e33a0cf782fe857e1502d7f3863e0dfb2306af2aed)
set(QT_HASH_qt5-svg              364400e17cdc659ff1a521f7bd171c5dfe537136f263cd5f64c6b5e27b0398d83ae0b5fe46e77847f3a2feccf0ea75f9591ff4b932d0250e5859272630b5a31c)
set(QT_HASH_qt5-tools            26edf546a1ec7195f1ff5a9e40e430fdd0c7ebb7d86e44ed22b093426c23ff25b2c972fa520abd1064369d32609019746c2fe972a3f593c6f7539d339642f06e)
set(QT_HASH_qt5-translations     56b20c0174cb68c3e4def85ec6c113576bc8872d1cdac318bc3d9a121645f67ce68e9bd3a73e32fd53617fcef641fb95831b37c40f1250c1c05e109e55b41ee2)
set(QT_HASH_qt5-virtualkeyboard  870279299a5e166badea0746a2d4badc758c66f8404e36d1df05997dcfeb66733154fc2a9830c433fbacf885b7afb44bc8dc8a5aacc02713966630ce98231ba3)
set(QT_HASH_qt5-wayland          58ae262f7aa0455fb577a36fe9413a969398a2043160642501bac064d6fbc3280f76aa566e62b9d73c67a8c3606849b1b97bcb9b0250d26c269ec921112f40e4)
set(QT_HASH_qt5-webchannel       18d5e6f44b780c7dfc94e1620ba76d7b0731d671df537b2e29fef062a0775e8dc973deb6c949b37000f5e8a49bdd31a723aa069bafcb9ecdc3259d0bf97e5a26)
set(QT_HASH_qt5-webengine        935c5a21ec2529d8cc3dbaf906e1f68f6e0879da212719d2da9fc1c97efd572563e8d12a6742a0a995efa5014ce5378235833eafb8d463ebe4060b60a590c476)
set(QT_HASH_qt5-webglplugin      e637abc9388f6c9c6641a38c7f33cef781320616be7d181d7fc63aa6f3ed6d378ec3cef91c8feebda52ff669bb3eb2df771bc2a2e447d482ce940abe4c1edce9)
set(QT_HASH_qt5-websockets       01714b9927c3a234fac9386a596aa3dc3833d9cfe8cc152892fec969e51b428bed00f501c16b8e4f810452739ff8491e5c64f9b936aa10e1a839c09c8f2832ce)
set(QT_HASH_qt5-webview          fb5177f0e8f79490598120f01b6cdd78ce5cbac8f313c0e088ded7b4daada290d2c058ecd6eebdba76fd15efd2e198bc03cbaf544fba664d49efb55709703be6)
set(QT_HASH_qt5-winextras        cac1b2b2194f3c21cba73e0c49384957a40e3297965b3fcf625eba0d069e3955202cae5e545a6186a9fad51df18afddd27fe55535265d2acf15fe2ba9e71a1d5)
set(QT_HASH_qt5-x11extras        79c718eff9daba9ff3f361d38f828f8f3c447b87486d652d4ed1f964ec686259ae4d0a1a50b7b6b9349453ba3f8b56b3c20c8a5f26971d5cc3c8f99d668744d6)
set(QT_HASH_qt5-xmlpatterns      fc4b4723407f6a1e765933d9d76ec4ffe874cb4a70e47bc4110def2c4a491b86fa753c33ef31ef95ad1a6eaa3de1fadbc49deb7783d32d8fc2f51672670d5a87)

if(QT_UPDATE_VERSION)
    message(STATUS "Running Qt in automatic version port update mode!")
    set(_VCPKG_INTERNAL_NO_HASH_CHECK 1)
    if("${PORT}" MATCHES "qt5-base")
        function(update_qt_version_in_manifest _port_name)
            set(_current_control "${VCPKG_ROOT_DIR}/ports/${_port_name}/vcpkg.json")
            file(READ ${_current_control} _control_contents)
            #message(STATUS "Before: \n${_control_contents}")
            string(REGEX REPLACE "\"version.*\": \"[0-9]+\.[0-9]+\.[0-9]+\",\n" "\"version\": \"${QT_MAJOR_MINOR_VER}.${QT_PATCH_VER}\",\n" _control_contents "${_control_contents}")
            string(REGEX REPLACE "\n  \"port-version\": [0-9]+," "" _control_contents "${_control_contents}")
            #message(STATUS "After: \n${_control_contents}")
            file(WRITE ${_current_control} "${_control_contents}")
            configure_file("${_current_control}" "${_current_control}" @ONLY NEWLINE_STYLE LF)
        endfunction()

        update_qt_version_in_manifest("qt5")
        foreach(_current_qt_port_basename ${QT_PORT_LIST})
            update_qt_version_in_manifest("qt5-${_current_qt_port_basename}")
        endforeach()
    endif()
endif()
