# AUTOGENERATED - modify shared_anyscale_util in root directory to make changes
from enum import Enum, unique
import random
import string


@unique
class IDTypes(Enum):
    projects = "prj"
    snapshots = "sna"
    users = "usr"
    organizations = "org"
    organization_invitations = "orginv"
    sessions = "ses"
    applied_snapshots = "asn"
    clouds = "cld"
    cloud_resources = "cldrsrc"
    permissions_projects = "ppr"
    permissions_sessions = "pse"
    permissions_snapshots = "psn"
    permissions_clouds = "pcl"
    permissions_organizations = "por"
    identities = "ide"
    autosync_sessions = "aus"
    session_state_transitions = "sst"
    server_sessions = "sss"
    session_commands = "scd"
    instances = "ins"
    instances_unique = "asi"
    application_templates = "apt"
    builds = "bld"
    session_operations = "sop"
    compute_templates = "cpt"
    usage_snapshots = "usp"
    usage_export_jobs = "uej"
    namespaces = "nsp"
    runtime_environments = "rte"
    actors = "act"
    jobs = "job"
    ray_job_submissions = "rjs"
    ha_job_notifications = "hjn"
    anonymous_jobs = "ajb"
    anonymous_actors = "aac"
    sso_configs = "sso"
    serve_deployments = "srvdep"
    ha_jobs = "prodjob"
    service = "service"
    ha_job_configs = "hjc"
    ha_job_state = "hjs"
    anyscale_customer_zone = "acz"
    ha_job_goal_state = "hjgs"
    audit_log = "alg"
    cluster_statuses = "cstat"
    recent_activities = "ract"
    support_requests = "supr"
    experimental_workspaces = "expwrk"
    structured_outputs = "output"
    experimental_integrations = "expint"
    cron_job = "cronjob"
    cluster_startups = "csu"


class IDGenerator:
    def __init__(self, type: IDTypes):
        self.type = type.value

        self.rand = random.SystemRandom()
        self.possible_characters = list(
            set(string.ascii_letters + string.digits)
            - {"I", "l", "o", "O", "0"}  # No confusing characters # noqa: W503
        )

    def generate_id(self, k: int = 24) -> str:
        id_part = "".join(self.rand.choices(self.possible_characters, k=k))
        return f"{self.type}_{id_part}"


# Use this to avoid global variables due to cloudpickle not having great support for them.
def generate_id(type: IDTypes, k: int = 24) -> str:
    generator = IDGenerator(type)
    return generator.generate_id(k=k)
