# -*- coding: utf-8 -*-

BANCO_DO_BRASIL = {
    'valid_combinations': [
        {'bank_code': '001', 'branch': '1584', 'branch_digit': '9', 'account': '00210169', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '0395', 'branch_digit': '6', 'account': '45939', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '2995', 'branch_digit': '5', 'account': '14728', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '7071', 'branch_digit': '8', 'account': '6801908', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '3477', 'branch_digit': '0', 'account': '26135', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '0229', 'branch_digit': '1', 'account': '12351', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '1403', 'branch_digit': '6', 'account': '2315999', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '3456', 'branch_digit': '8', 'account': '38582', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '4556', 'branch_digit': 'X', 'account': '5159', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '6512', 'branch_digit': '9', 'account': '1167', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '5766', 'branch_digit': '5', 'account': '548811', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '3007', 'branch_digit': '4', 'account': '33084', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '4438', 'branch_digit': '5', 'account': '6723', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '4850', 'branch_digit': 'X', 'account': '6649', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '0107', 'branch_digit': '4', 'account': '8428', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '4267', 'branch_digit': '6', 'account': '45542', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '2443', 'branch_digit': '0', 'account': '5341', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '4723', 'branch_digit': '6', 'account': '300696', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '4392', 'branch_digit': '3', 'account': '49881', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '1668', 'branch_digit': '3', 'account': '16170', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '3007', 'branch_digit': '4', 'account': '17526', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '1613', 'branch_digit': '6', 'account': '8439875', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '4852', 'branch_digit': '6', 'account': '953521', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '3254', 'branch_digit': '9', 'account': '10513', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '3061', 'branch_digit': '9', 'account': '32611', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '0452', 'branch_digit': '9', 'account': '41981', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '0296', 'branch_digit': '8', 'account': '022356', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '0048', 'branch_digit': '5', 'account': '124564', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '1196', 'branch_digit': '7', 'account': '29639', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '5560', 'branch_digit': '3', 'account': '106662', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '3497', 'branch_digit': '5', 'account': '10540', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '3049', 'branch_digit': 'X', 'account': '17110', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '0312', 'branch_digit': '3', 'account': '19981', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '7080', 'branch_digit': '7', 'account': '2241395', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '4763', 'branch_digit': '5', 'account': '16980', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '1869', 'branch_digit': '4', 'account': '35615', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '2795', 'branch_digit': '2', 'account': '84800', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '0386', 'branch_digit': '7', 'account': '86324', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '3653', 'branch_digit': '6', 'account': '18115', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '3006', 'branch_digit': '6', 'account': '6010', 'account_digit': '0'},
        {'bank_code': '001', 'branch': '0726', 'branch_digit': '9', 'account': '5523', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '6960', 'branch_digit': '4', 'account': '6903', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '0987', 'branch_digit': '3', 'account': '5993', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '0675', 'branch_digit': '0', 'account': '8376', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '1245', 'branch_digit': '9', 'account': '34087', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '1578', 'branch_digit': '4', 'account': '2965033', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '3510', 'branch_digit': '6', 'account': '29111', 'account_digit': '0'},
        {'bank_code': '001', 'branch': '3430', 'branch_digit': '4', 'account': '22566', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '5899', 'branch_digit': '8', 'account': '52739', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '6812', 'branch_digit': '8', 'account': '19734', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '1244', 'branch_digit': '0', 'account': '8782', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '2305', 'branch_digit': '1', 'account': '6044', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '3007', 'branch_digit': '4', 'account': '39624', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '0386', 'branch_digit': '7', 'account': '78427', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '2447', 'branch_digit': '3', 'account': '45811', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '3055', 'branch_digit': '4', 'account': '18232', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '1101', 'branch_digit': '0', 'account': '22471', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '6986', 'branch_digit': '8', 'account': '800217', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '6838', 'branch_digit': '1', 'account': '217959', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '3137', 'branch_digit': '2', 'account': '17297', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '2705', 'branch_digit': '7', 'account': '22159', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '4881', 'branch_digit': 'X', 'account': '6056', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '7081', 'branch_digit': '5', 'account': '21515', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '2960', 'branch_digit': '2', 'account': '19064', 'account_digit': '0'},
        {'bank_code': '001', 'branch': '0387', 'branch_digit': '5', 'account': '40878', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '0080', 'branch_digit': '9', 'account': '66548', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '4598', 'branch_digit': '5', 'account': '16496', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '2324', 'branch_digit': '8', 'account': '27638', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '2897', 'branch_digit': '5', 'account': '32356', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '3512', 'branch_digit': '2', 'account': '4556849', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '4451', 'branch_digit': '2', 'account': '7819', 'account_digit': '0'},
        {'bank_code': '001', 'branch': '1237', 'branch_digit': '8', 'account': '552615', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '8687', 'branch_digit': '8', 'account': '2258318', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '1173', 'branch_digit': '8', 'account': '10952', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '3478', 'branch_digit': '9', 'account': '41098', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '1573', 'branch_digit': '3', 'account': '18835', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '1585', 'branch_digit': '7', 'account': '18636', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '3574', 'branch_digit': '2', 'account': '32059', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '2947', 'branch_digit': '5', 'account': '16296', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '0073', 'branch_digit': '6', 'account': '71811', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '3884', 'branch_digit': '9', 'account': '41843', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '4267', 'branch_digit': '6', 'account': '9290624', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '3005', 'branch_digit': '8', 'account': '27480', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '1227', 'branch_digit': '0', 'account': '57915', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '6801', 'branch_digit': '2', 'account': '15577', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '1612', 'branch_digit': '8', 'account': '15760', 'account_digit': '0'},
        {'bank_code': '001', 'branch': '1230', 'branch_digit': '0', 'account': '39215', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '5959', 'branch_digit': '5', 'account': '6750954', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '1838', 'branch_digit': '4', 'account': '3810473', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '2764', 'branch_digit': '2', 'account': '29031', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '7075', 'branch_digit': '0', 'account': '21090', 'account_digit': '0'},
        {'bank_code': '001', 'branch': '2945', 'branch_digit': '9', 'account': '721086', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '2047', 'branch_digit': '8', 'account': '9792', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '2363', 'branch_digit': '9', 'account': '22204', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '3556', 'branch_digit': '4', 'account': '21812', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '8328', 'branch_digit': '3', 'account': '8745', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '5761', 'branch_digit': '4', 'account': '746063', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '6761', 'branch_digit': 'X', 'account': '58766', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '6970', 'branch_digit': '1', 'account': '17096', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '6954', 'branch_digit': 'X', 'account': '8225', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '2279', 'branch_digit': '9', 'account': '30078', 'account_digit': '0'},
        {'bank_code': '001', 'branch': '3242', 'branch_digit': '5', 'account': '16764', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '0001', 'branch_digit': '9', 'account': '746173', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '0607', 'branch_digit': '6', 'account': '12173', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '3136', 'branch_digit': '4', 'account': '8638', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '6842', 'branch_digit': 'X', 'account': '12372', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '2175', 'branch_digit': 'X', 'account': '36287', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '4683', 'branch_digit': '3', 'account': '6619', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '3277', 'branch_digit': '8', 'account': '23624', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '6807', 'branch_digit': '1', 'account': '8399', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '3613', 'branch_digit': '7', 'account': '30983', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '0729', 'branch_digit': '3', 'account': '67384', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '6884', 'branch_digit': '5', 'account': '21837', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '2365', 'branch_digit': '5', 'account': '6954141', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '0313', 'branch_digit': '1', 'account': '19457', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '0103', 'branch_digit': '1', 'account': '34705', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '3605', 'branch_digit': '6', 'account': '75007', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '2128', 'branch_digit': '8', 'account': '14589', 'account_digit': '0'},
        {'bank_code': '001', 'branch': '3790', 'branch_digit': '7', 'account': '34668', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '1885', 'branch_digit': '6', 'account': '6079', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '4574', 'branch_digit': '8', 'account': '8981', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '0204', 'branch_digit': '6', 'account': '9812510', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '2883', 'branch_digit': '5', 'account': '23564', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '1517', 'branch_digit': '2', 'account': '28060', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '2902', 'branch_digit': '5', 'account': '25709', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '3590', 'branch_digit': '4', 'account': '12329', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '1629', 'branch_digit': '2', 'account': '413202', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '6554', 'branch_digit': '4', 'account': '13852', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '4314', 'branch_digit': '1', 'account': '22123', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '7019', 'branch_digit': 'X', 'account': '783', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '1617', 'branch_digit': '9', 'account': '17374', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '3417', 'branch_digit': '7', 'account': '16313', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '3396', 'branch_digit': '0', 'account': '27057', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '1609', 'branch_digit': '8', 'account': '48102', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '4572', 'branch_digit': '1', 'account': '6903', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '3193', 'branch_digit': '3', 'account': '14237', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '3620', 'branch_digit': 'X', 'account': '6794004', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '6501', 'branch_digit': '3', 'account': '5750', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '1458', 'branch_digit': '3', 'account': '21520', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '0023', 'branch_digit': 'X', 'account': '32769', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '3871', 'branch_digit': '7', 'account': '8654', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '3589', 'branch_digit': '0', 'account': '47621', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '1267', 'branch_digit': 'X', 'account': '30369', 'account_digit': '0'},
        {'bank_code': '001', 'branch': '7150', 'branch_digit': '1', 'account': '302262', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '4599', 'branch_digit': '3', 'account': '6939', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '3283', 'branch_digit': '2', 'account': '12995', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '3330', 'branch_digit': '8', 'account': '0723084', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '8428', 'branch_digit': 'X', 'account': '107369', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '3599', 'branch_digit': '8', 'account': '20075', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '2299', 'branch_digit': '3', 'account': '6937', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '6882', 'branch_digit': '9', 'account': '45288', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '0098', 'branch_digit': '1', 'account': '8143', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '0210', 'branch_digit': '0', 'account': '39891', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '1252', 'branch_digit': '1', 'account': '10172', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '0188', 'branch_digit': '0', 'account': '31630', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '2944', 'branch_digit': '0', 'account': '29443', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '5378', 'branch_digit': '3', 'account': '6204', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '3847', 'branch_digit': '4', 'account': '120569', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '0539', 'branch_digit': '8', 'account': '4538658', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '3595', 'branch_digit': '5', 'account': '6851', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '3449', 'branch_digit': '5', 'account': '31100', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '2002', 'branch_digit': '8', 'account': '1360', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '6531', 'branch_digit': '5', 'account': '10075', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '6917', 'branch_digit': '5', 'account': '6388', 'account_digit': '6'},
        {'bank_code': '001', 'branch': '7082', 'branch_digit': '3', 'account': '23813', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '0037', 'branch_digit': 'X', 'account': '68663', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '0742', 'branch_digit': '0', 'account': '8116529', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '4318', 'branch_digit': '4', 'account': '24565', 'account_digit': '8'},
        {'bank_code': '001', 'branch': '4292', 'branch_digit': '7', 'account': '8067', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '0194', 'branch_digit': '5', 'account': '14891', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '3517', 'branch_digit': '3', 'account': '21014', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '2762', 'branch_digit': '6', 'account': '13358', 'account_digit': '2'},
        {'bank_code': '001', 'branch': '4886', 'branch_digit': '0', 'account': '177777', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '2800', 'branch_digit': '2', 'account': '21681', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '3648', 'branch_digit': 'X', 'account': '23784', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '6522', 'branch_digit': '6', 'account': '7519', 'account_digit': '1'},
        {'bank_code': '001', 'branch': '7076', 'branch_digit': '9', 'account': '6090508', 'account_digit': '5'},
        {'bank_code': '001', 'branch': '1192', 'branch_digit': '4', 'account': '35774', 'account_digit': 'X'},
        {'bank_code': '001', 'branch': '3599', 'branch_digit': '8', 'account': '2', 'account_digit': '7'},
        {'bank_code': '001', 'branch': '3602', 'branch_digit': '1', 'account': '0437963', 'account_digit': '2'},
    ],
    'invalid_combinations': [
        {'bank_code': '001', 'branch': '0395', 'branch_digit': '6', 'account': '45939', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '2995', 'branch_digit': '5', 'account': '14728', 'account_digit': '9'},
        {'bank_code': '001', 'branch': '7071', 'branch_digit': '8', 'account': '6801908', 'account_digit': '3'},
        {'bank_code': '001', 'branch': '0229', 'branch_digit': '1', 'account': '12351', 'account_digit': '4'},
        {'bank_code': '001', 'branch': '0742', 'branch_digit': '0', 'account': '8116529', 'account_digit': '1'},
    ]
}

SANTANDER = {
    'valid_combinations': [
        {'bank_code': '033', 'branch': '2006', 'branch_digit': '', 'account': '01008407', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '3488', 'branch_digit': '', 'account': '01000334', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '3003', 'branch_digit': '', 'account': '01000491', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '3415', 'branch_digit': '', 'account': '01089302', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '3899', 'branch_digit': '', 'account': '01002217', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '3004', 'branch_digit': '', 'account': '01003220', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '0562', 'branch_digit': '', 'account': '01015946', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '1318', 'branch_digit': '', 'account': '01007168', 'account_digit': '0'},
        {'bank_code': '033', 'branch': '3409', 'branch_digit': '', 'account': '01019131', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '3128', 'branch_digit': '', 'account': '01072280', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '1653', 'branch_digit': '', 'account': '01000226', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '4580', 'branch_digit': '', 'account': '01003115', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '3719', 'branch_digit': '', 'account': '01003141', 'account_digit': '2'},
        {'bank_code': '033', 'branch': '4749', 'branch_digit': '', 'account': '01081666', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '2167', 'branch_digit': '', 'account': '01006952', 'account_digit': '5'},
        {'bank_code': '033', 'branch': '0250', 'branch_digit': '', 'account': '01016748', 'account_digit': '0'},
        {'bank_code': '033', 'branch': '0236', 'branch_digit': '', 'account': '01012421', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '0642', 'branch_digit': '', 'account': '01028759', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '3311', 'branch_digit': '', 'account': '01082068', 'account_digit': '9'},
        {'bank_code': '033', 'branch': '3553', 'branch_digit': '', 'account': '01083325', 'account_digit': '0'},
        {'bank_code': '033', 'branch': '0085', 'branch_digit': '', 'account': '01019802', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '0658', 'branch_digit': '', 'account': '01047326', 'account_digit': '0'},
        {'bank_code': '033', 'branch': '3664', 'branch_digit': '', 'account': '01006243', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '3919', 'branch_digit': '', 'account': '01003572', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '1181', 'branch_digit': '', 'account': '01001574', 'account_digit': '5'},
        {'bank_code': '033', 'branch': '0319', 'branch_digit': '', 'account': '01052162', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '0982', 'branch_digit': '', 'account': '01002319', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '3767', 'branch_digit': '', 'account': '01081803', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '0900', 'branch_digit': '', 'account': '01015746', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '2115', 'branch_digit': '', 'account': '01008573', 'account_digit': '9'},
        {'bank_code': '033', 'branch': '2183', 'branch_digit': '', 'account': '13001676', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '4727', 'branch_digit': '', 'account': '01021891', 'account_digit': '0'},
        {'bank_code': '033', 'branch': '3140', 'branch_digit': '', 'account': '01081522', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '0105', 'branch_digit': '', 'account': '01050748', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '0628', 'branch_digit': '', 'account': '01033262', 'account_digit': '9'},
        {'bank_code': '033', 'branch': '4762', 'branch_digit': '', 'account': '01019136', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '0903', 'branch_digit': '', 'account': '01004867', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '3678', 'branch_digit': '', 'account': '01001778', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '0097', 'branch_digit': '', 'account': '01014173', 'account_digit': '5'},
        {'bank_code': '033', 'branch': '1637', 'branch_digit': '', 'account': '01003221', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '0220', 'branch_digit': '', 'account': '01021953', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '3137', 'branch_digit': '', 'account': '01013057', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '3716', 'branch_digit': '', 'account': '01001508', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '0680', 'branch_digit': '', 'account': '01020880', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '0129', 'branch_digit': '', 'account': '01068263', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '3083', 'branch_digit': '', 'account': '01000412', 'account_digit': '0'},
        {'bank_code': '033', 'branch': '4653', 'branch_digit': '', 'account': '01020964', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '0001', 'branch_digit': '', 'account': '02006073', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '0986', 'branch_digit': '', 'account': '01001039', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '4310', 'branch_digit': '', 'account': '01000386', 'account_digit': '2'},
        {'bank_code': '033', 'branch': '3476', 'branch_digit': '', 'account': '02000708', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '4679', 'branch_digit': '', 'account': '01000571', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '4259', 'branch_digit': '', 'account': '01002748', 'account_digit': '2'},
        {'bank_code': '033', 'branch': '0301', 'branch_digit': '', 'account': '01015734', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '3966', 'branch_digit': '', 'account': '01066137', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '0112', 'branch_digit': '', 'account': '01026747', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '0037', 'branch_digit': '', 'account': '01083383', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '3472', 'branch_digit': '', 'account': '01008201', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '4478', 'branch_digit': '', 'account': '01073210', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '3501', 'branch_digit': '', 'account': '01006602', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '0535', 'branch_digit': '', 'account': '01019251', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '3750', 'branch_digit': '', 'account': '01001880', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '1330', 'branch_digit': '', 'account': '01019096', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '0142', 'branch_digit': '', 'account': '01042867', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '3717', 'branch_digit': '', 'account': '01004637', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '4647', 'branch_digit': '', 'account': '01000073', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '3522', 'branch_digit': '', 'account': '01003302', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '4779', 'branch_digit': '', 'account': '01000483', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '0319', 'branch_digit': '', 'account': '01041485', 'account_digit': '0'},
        {'bank_code': '033', 'branch': '0445', 'branch_digit': '', 'account': '001009300', 'account_digit': '2'},
        {'bank_code': '033', 'branch': '1431', 'branch_digit': '', 'account': '01002389', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '0248', 'branch_digit': '', 'account': '01013538', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '4230', 'branch_digit': '', 'account': '01085717', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '3409', 'branch_digit': '', 'account': '02002962', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '0643', 'branch_digit': '', 'account': '01038220', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '4776', 'branch_digit': '', 'account': '01000729', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '3004', 'branch_digit': '', 'account': '1004420', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '1568', 'branch_digit': '', 'account': '01003687', 'account_digit': '9'},
        {'bank_code': '033', 'branch': '0114', 'branch_digit': '', 'account': '01034968', 'account_digit': '9'},
        {'bank_code': '033', 'branch': '4268', 'branch_digit': '', 'account': '01063682', 'account_digit': '0'},
        {'bank_code': '033', 'branch': '0811', 'branch_digit': '', 'account': '01000575', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '0697', 'branch_digit': '', 'account': '01000315', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '3409', 'branch_digit': '', 'account': '01086346', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '2146', 'branch_digit': '', 'account': '01009275', 'account_digit': '9'},
        {'bank_code': '033', 'branch': '0576', 'branch_digit': '', 'account': '01007506', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '3922', 'branch_digit': '', 'account': '01081275', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '0060', 'branch_digit': '', 'account': '01080281', 'account_digit': '4'},
        {'bank_code': '033', 'branch': '2093', 'branch_digit': '', 'account': '01019648', 'account_digit': '7'},
        {'bank_code': '033', 'branch': '3731', 'branch_digit': '', 'account': '01001830', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '4715', 'branch_digit': '', 'account': '01086178', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '1181', 'branch_digit': '', 'account': '01004801', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '2269', 'branch_digit': '', 'account': '01019042', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '3067', 'branch_digit': '', 'account': '01078324', 'account_digit': '9'},
        {'bank_code': '033', 'branch': '3822', 'branch_digit': '', 'account': '01008987', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '4052', 'branch_digit': '', 'account': '01000202', 'account_digit': '6'},
        {'bank_code': '033', 'branch': '3041', 'branch_digit': '', 'account': '01014802', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '0252', 'branch_digit': '', 'account': '01011089', 'account_digit': '5'},
        {'bank_code': '033', 'branch': '3997', 'branch_digit': '', 'account': '01001154', 'account_digit': '2'},
        {'bank_code': '033', 'branch': '2290', 'branch_digit': '', 'account': '01000409', 'account_digit': '1'},
        {'bank_code': '033', 'branch': '3878', 'branch_digit': '', 'account': '01085729', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '3397', 'branch_digit': '', 'account': '01009421', 'account_digit': '9'},
        {'bank_code': '033', 'branch': '0120', 'branch_digit': '', 'account': '01058564', 'account_digit': '8'},
        {'bank_code': '033', 'branch': '0445', 'branch_digit': '', 'account': '01015526', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '1582', 'branch_digit': '', 'account': '13000418', 'account_digit': '3'},
        {'bank_code': '033', 'branch': '4260', 'branch_digit': '', 'account': '01001451', 'account_digit': '0'},
        {'bank_code': '033', 'branch': '0929', 'branch_digit': '', 'account': '01001725', 'account_digit': '2'},
        {'bank_code': '033', 'branch': '0179', 'branch_digit': '', 'account': '13006152', 'account_digit': '7'},
    ],
    'invalid_combinations': [
        {'bank_code': '033', 'branch': '3003', 'branch_digit': '', 'account': '01000491', 'account_digit': '5'},
        {'bank_code': '033', 'branch': '3415', 'branch_digit': '', 'account': '01089302', 'account_digit': '6'},
    ]
}

BANRISUL = {
    'correct_agency': [
        ('2664', '18'),
        ('0196', '66'),
        ('0668', '42'),
        ('0330', '14'),
        ('0584', '32'),
        ('0137', '06'),
        ('0130', '56'),
        ('1104', '93'),
        ('0128', '90'),
        ('1105', '66'),
        ('0150', '32'),
        ('0990', '23'),
        ('0141', '25'),
        ('0270', '06'),
        ('0906', '89'),
        ('0283', '20'),
        ('0288', '19'),
        ('1073', '60'),
        ('0100', '81'),
        ('1015', '75'),
        ('0028', '28'),
        ('0831', '86'),
        ('0843', '36'),
        ('0025', '77'),
        ('1004', '12'),
        ('0844', '17'),
        ('0030', '77'),
        ('1151', '18'),
        ('1069', '41'),
        ('0845', '81'),
        ('0031', '58'),
        ('0049', '79'),
        ('0032', '39'),
        ('0835', '93'),
        ('0702', '11'),
        ('1042', '13'),
        ('0597', '57'),
        ('0035', '65'),
        ('0624', '72'),
        ('0015', '89'),
        ('0036', '46'),
        ('0039', '80'),
        ('1081', '97'),
        ('0040', '65'),
        ('0041', '46'),
        ('0042', '27'),
        ('0018', '21'),
        ('0839', '17'),
        ('0045', '53'),
        ('0047', '15'),
        ('0016', '78'),
        ('0838', '36'),
        ('0156', '01'),
        ('0050', '53'),
        ('1075', '14'),
        ('0055', '41'),
        ('0060', '41'),
        ('1098', '35'),
        ('0062', '03'),
        ('0065', '48'),
        ('0100', '81'),
        ('0100', '81'),
        ('0051', '34'),
        ('0047', '15'),
        ('0030', '77'),
        ('0835', '93'),
        ('0040', '65'),
        ('0065', '48'),
        ('0065', '48'),
        ('0845', '81'),
        ('0030', '77'),
        ('0100', '81'),
        ('0051', '34'),
        ('0041', '46'),
        ('0621', '38'),
        ('0621', '38'),
        ('0797', '15'),
        ('0065', '48'),
        ('0027', '39'),
        ('0042', '27'),
        ('1004', '12'),
        ('0100', '81'),
        ('0030', '77'),
        ('0040', '65'),
        ('0040', '65'),
        ('0041', '46'),
        ('0051', '34'),
        ('0100', '81'),
        ('0835', '93'),
        ('0835', '93'),
        ('0100', '81'),
        ('0100', '81'),
        ('0100', '81'),
        ('0041', '46'),
        ('0100', '81'),
        ('0026', '58'),
        ('0100', '81'),
        ('0042', '27'),
        ('0085', '16'),
        ('0050', '53'),
        ('0060', '41'),
        ('1099', '16'),
        ('0834', '29'),
        ('0077', '81'),
        ('0065', '48'),
        ('0070', '48'),
        ('0075', '28'),
        ('0621', '38'),
        ('0011', '71'),
        ('0257', '63'),
        ('0847', '43'),
        ('0797', '15'),
        ('1140', '30'),
        ('0073', '74'),
        ('0080', '28'),
        ('0026', '58'),
        ('0643', '78'),
        ('0082', '81'),
        ('0027', '39'),
        ('1103', '10'),
        ('0085', '16'),
        ('0051', '34'),
        ('0852', '43'),
        ('1009', '00'),
        ('0043', '08'),
        ('0856', '50'),
        ('0851', '62'),
    ],
    'correct_account': [
        ('358507671', '8'),
        ('358507670', '6'),
        ('358507675', '0')
    ]
}

CAIXA_ECONOMICA_FEDERAL = {
    'valid_combinations': [
        {'bank_code': '104', 'branch': '3009', 'branch_digit': '', 'account': '00100000448', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '3009', 'branch_digit': '', 'account': '00100022679', 'account_digit': '9'},
        {'bank_code': '104', 'branch': '4074', 'branch_digit': '', 'account': '00100023064', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '0323', 'branch_digit': '', 'account': '00100013906', 'account_digit': '2'},
        {'bank_code': '104', 'branch': '3586', 'branch_digit': '', 'account': '00100024125', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '1041', 'branch_digit': '', 'account': '00100000663', 'account_digit': '1'},
        {'bank_code': '104', 'branch': '3664', 'branch_digit': '', 'account': '00100020627', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '0376', 'branch_digit': '', 'account': '00100023641', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '1029', 'branch_digit': '', 'account': '00100000704', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '0081', 'branch_digit': '', 'account': '00100402345', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '0274', 'branch_digit': '', 'account': '00100002205', 'account_digit': '4'},
        {'bank_code': '104', 'branch': '0138', 'branch_digit': '', 'account': '00100025179', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '0097', 'branch_digit': '', 'account': '00100024764', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0007', 'branch_digit': '', 'account': '00100026579', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '0330', 'branch_digit': '', 'account': '00100027000', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '2929', 'branch_digit': '', 'account': '00100023108', 'account_digit': '2'},
        {'bank_code': '104', 'branch': '3093', 'branch_digit': '', 'account': '00100022680', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0377', 'branch_digit': '', 'account': '00100024431', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '3529', 'branch_digit': '', 'account': '00100020826', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '3708', 'branch_digit': '', 'account': '00100022028', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '0238', 'branch_digit': '', 'account': '00100029117', 'account_digit': '2'},
        {'bank_code': '104', 'branch': '1209', 'branch_digit': '', 'account': '00100022432', 'account_digit': '1'},
        {'bank_code': '104', 'branch': '1005', 'branch_digit': '', 'account': '00100001442', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '0974', 'branch_digit': '', 'account': '00100024066', 'account_digit': '9'},
        {'bank_code': '104', 'branch': '1655', 'branch_digit': '', 'account': '00100021870', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0973', 'branch_digit': '', 'account': '00100024056', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '1374', 'branch_digit': '', 'account': '00100032594', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '3234', 'branch_digit': '', 'account': '00100020302', 'account_digit': '4'},
        {'bank_code': '104', 'branch': '3178', 'branch_digit': '', 'account': '00100003275', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '0180', 'branch_digit': '', 'account': '01300026644', 'account_digit': '4'},
        {'bank_code': '104', 'branch': '2879', 'branch_digit': '', 'account': '00100001151', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0740', 'branch_digit': '', 'account': '00100006300', 'account_digit': '4'},
        {'bank_code': '104', 'branch': '1626', 'branch_digit': '', 'account': '00100020593', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '2256', 'branch_digit': '', 'account': '01300022084', 'account_digit': '1'},
        {'bank_code': '104', 'branch': '2272', 'branch_digit': '', 'account': '01300018769', 'account_digit': '8'},
        {'bank_code': '104', 'branch': '1286', 'branch_digit': '', 'account': '00100021202', 'account_digit': '1'},
        {'bank_code': '104', 'branch': '1631', 'branch_digit': '', 'account': '00100024975', 'account_digit': '2'},
        {'bank_code': '104', 'branch': '3016', 'branch_digit': '', 'account': '00100032801', 'account_digit': '8'},
        {'bank_code': '104', 'branch': '4004', 'branch_digit': '', 'account': '00100024929', 'account_digit': '8'},
        {'bank_code': '104', 'branch': '3518', 'branch_digit': '', 'account': '00100878787', 'account_digit': '8'},
        {'bank_code': '104', 'branch': '1448', 'branch_digit': '', 'account': '00100005206', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '4076', 'branch_digit': '', 'account': '00100022873', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '1656', 'branch_digit': '', 'account': '00100000199', 'account_digit': '4'},
        {'bank_code': '104', 'branch': '0253', 'branch_digit': '', 'account': '00100021172', 'account_digit': '3'},
        {'bank_code': '104', 'branch': '0659', 'branch_digit': '', 'account': '00100024087', 'account_digit': '9'},
        {'bank_code': '104', 'branch': '0369', 'branch_digit': '', 'account': '00100027307', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0678', 'branch_digit': '', 'account': '00100000478', 'account_digit': '8'},
        {'bank_code': '104', 'branch': '4018', 'branch_digit': '', 'account': '00100002956', 'account_digit': '1'},
        {'bank_code': '104', 'branch': '2717', 'branch_digit': '', 'account': '00100000419', 'account_digit': '9'},
        {'bank_code': '104', 'branch': '3725', 'branch_digit': '', 'account': '00100021781', 'account_digit': '4'},
        {'bank_code': '104', 'branch': '2161', 'branch_digit': '', 'account': '00100002257', 'account_digit': '8'},
        {'bank_code': '104', 'branch': '2885', 'branch_digit': '', 'account': '01300009226', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '0607', 'branch_digit': '', 'account': '01300029203', 'account_digit': '8'},
        {'bank_code': '104', 'branch': '1173', 'branch_digit': '', 'account': '00100020283', 'account_digit': '8'},
        {'bank_code': '104', 'branch': '1746', 'branch_digit': '', 'account': '00100024048', 'account_digit': '3'},
        {'bank_code': '104', 'branch': '0371', 'branch_digit': '', 'account': '01300074967', 'account_digit': '2'},
        {'bank_code': '104', 'branch': '3825', 'branch_digit': '', 'account': '00100020712', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '1831', 'branch_digit': '', 'account': '00100000935', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '3898', 'branch_digit': '', 'account': '00100020341', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '0655', 'branch_digit': '', 'account': '00100026077', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0974', 'branch_digit': '', 'account': '01300018935', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '0566', 'branch_digit': '', 'account': '00100029057', 'account_digit': '9'},
        {'bank_code': '104', 'branch': '1337', 'branch_digit': '', 'account': '00100020993', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '2387', 'branch_digit': '', 'account': '00100006984', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '1529', 'branch_digit': '', 'account': '00100003499', 'account_digit': '9'},
        {'bank_code': '104', 'branch': '1529', 'branch_digit': '', 'account': '00100022437', 'account_digit': '2'},
        {'bank_code': '104', 'branch': '1433', 'branch_digit': '', 'account': '00100020291', 'account_digit': '1'},
        {'bank_code': '104', 'branch': '3532', 'branch_digit': '', 'account': '00100023661', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '0920', 'branch_digit': '', 'account': '00100005838', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '0240', 'branch_digit': '', 'account': '00100003162', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '1282', 'branch_digit': '', 'account': '00100022936', 'account_digit': '4'},
        {'bank_code': '104', 'branch': '0867', 'branch_digit': '', 'account': '00100028748', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '0132', 'branch_digit': '', 'account': '01300092032', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0183', 'branch_digit': '', 'account': '01300110073', 'account_digit': '2'},
        {'bank_code': '104', 'branch': '0344', 'branch_digit': '', 'account': '00100104739', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '1294', 'branch_digit': '', 'account': '00100004122', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0039', 'branch_digit': '', 'account': '00100001289', 'account_digit': '1'},
        {'bank_code': '104', 'branch': '3653', 'branch_digit': '', 'account': '00100020040', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '0250', 'branch_digit': '', 'account': '01300049677', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '0037', 'branch_digit': '', 'account': '02300001126', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '0800', 'branch_digit': '', 'account': '00100007246', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '4139', 'branch_digit': '', 'account': '00100005660', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '1370', 'branch_digit': '', 'account': '00100001501', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0081', 'branch_digit': '', 'account': '00100028566', 'account_digit': '8'},
        {'bank_code': '104', 'branch': '1746', 'branch_digit': '', 'account': '00100000545', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '1399', 'branch_digit': '', 'account': '00100020206', 'account_digit': '3'},
        {'bank_code': '104', 'branch': '4695', 'branch_digit': '', 'account': '00100021292', 'account_digit': '9'},
        {'bank_code': '104', 'branch': '0161', 'branch_digit': '', 'account': '00100050132', 'account_digit': '2'},
        {'bank_code': '104', 'branch': '1989', 'branch_digit': '', 'account': '01300065849', 'account_digit': '1'},
        {'bank_code': '104', 'branch': '2960', 'branch_digit': '', 'account': '00100023169', 'account_digit': '3'},
        {'bank_code': '104', 'branch': '2289', 'branch_digit': '', 'account': '00100030924', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '0797', 'branch_digit': '', 'account': '00100023335', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '4716', 'branch_digit': '', 'account': '00100020483', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0259', 'branch_digit': '', 'account': '00100022168', 'account_digit': '3'},
        {'bank_code': '104', 'branch': '4082', 'branch_digit': '', 'account': '01300022302', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '1942', 'branch_digit': '', 'account': '00100061950', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0893', 'branch_digit': '', 'account': '01300051113', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '2987', 'branch_digit': '', 'account': '00100021099', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '3463', 'branch_digit': '', 'account': '01300006936', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '0694', 'branch_digit': '', 'account': '00100021543', 'account_digit': '3'},
        {'bank_code': '104', 'branch': '0145', 'branch_digit': '', 'account': '001013005390', 'account_digit': '9'},
        {'bank_code': '104', 'branch': '0293', 'branch_digit': '', 'account': '00100031362', 'account_digit': '1'},
        {'bank_code': '104', 'branch': '2712', 'branch_digit': '', 'account': '01300030597', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '0893', 'branch_digit': '', 'account': '00100032983', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '1464', 'branch_digit': '', 'account': '00100022843', 'account_digit': '0'},
        {'bank_code': '104', 'branch': '2862', 'branch_digit': '', 'account': '00100021709', 'account_digit': '4'},
        {'bank_code': '104', 'branch': '0081', 'branch_digit': '', 'account': '00100000526', 'account_digit': '6'},
    ],
    'invalid_combinations': [
        {'bank_code': '104', 'branch': '3009', 'branch_digit': '', 'account': '00100022679', 'account_digit': '6'},
        {'bank_code': '104', 'branch': '0797', 'branch_digit': '', 'account': '00100023335', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '4716', 'branch_digit': '', 'account': '00100020483', 'account_digit': '3'},
        {'bank_code': '104', 'branch': '0259', 'branch_digit': '', 'account': '00100022168', 'account_digit': '5'},
        {'bank_code': '104', 'branch': '4082', 'branch_digit': '', 'account': '01300022302', 'account_digit': '4'},
        {'bank_code': '104', 'branch': '1942', 'branch_digit': '', 'account': '00100061950', 'account_digit': '7'},
        {'bank_code': '104', 'branch': '0893', 'branch_digit': '', 'account': '01300051113', 'account_digit': '1'},
    ]
}

BRADESCO = {
    'valid_combinations': [
        {'bank_code': '237', 'branch': '2377', 'branch_digit': '9', 'account': '0238069', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '2377', 'branch_digit': '9', 'account': '0002158', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '1842', 'branch_digit': '2', 'account': '42582', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '2308', 'branch_digit': '6', 'account': '8743', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '2883', 'branch_digit': '5', 'account': '19678', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '1493', 'branch_digit': '1', 'account': '0004218', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '0138', 'branch_digit': '4', 'account': '0125350', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '3209', 'branch_digit': '3', 'account': '82826', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '3568', 'branch_digit': '8', 'account': '0572396', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '1838', 'branch_digit': '4', 'account': '383', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '0224', 'branch_digit': '0', 'account': '0213608', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '2877', 'branch_digit': '0', 'account': '2205', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '0135', 'branch_digit': '0', 'account': '0091562', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '1764', 'branch_digit': '7', 'account': '1488', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '0046', 'branch_digit': '9', 'account': '368740', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '3061', 'branch_digit': '9', 'account': '928', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '1039', 'branch_digit': '1', 'account': '11490', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '0593', 'branch_digit': '2', 'account': '206610', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '0823', 'branch_digit': '0', 'account': '1123', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '0215', 'branch_digit': '1', 'account': '0509042', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '3019', 'branch_digit': '8', 'account': '0096751', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '2731', 'branch_digit': '6', 'account': '0518055', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '3141', 'branch_digit': '0', 'account': '16750', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '0323', 'branch_digit': '9', 'account': '72888', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '2451', 'branch_digit': '1', 'account': '21734', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '0154', 'branch_digit': '6', 'account': '201402', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '2856', 'branch_digit': '8', 'account': '727', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '2671', 'branch_digit': '9', 'account': '10080', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '2601', 'branch_digit': '8', 'account': '0001112', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '0682', 'branch_digit': '3', 'account': '53757', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '0504', 'branch_digit': '5', 'account': '43142', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '2773', 'branch_digit': '1', 'account': '0015781', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '1669', 'branch_digit': '1', 'account': '11437', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '1125', 'branch_digit': '8', 'account': '0300024', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '2102', 'branch_digit': '4', 'account': '9719', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '3327', 'branch_digit': '8', 'account': '0000444', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '2200', 'branch_digit': '4', 'account': '22793', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '1249', 'branch_digit': '1', 'account': '100122', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '6734', 'branch_digit': '2', 'account': '751', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '3113', 'branch_digit': '5', 'account': '14812', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '1997', 'branch_digit': '6', 'account': '6955', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '0486', 'branch_digit': '3', 'account': '0061408', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '2875', 'branch_digit': '4', 'account': '0009608', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '1451', 'branch_digit': '6', 'account': '63080', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '0666', 'branch_digit': '1', 'account': '0550207', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '0769', 'branch_digit': '2', 'account': '8356', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '1330', 'branch_digit': '7', 'account': '5516', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '0081', 'branch_digit': '7', 'account': '106923', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '3428', 'branch_digit': '2', 'account': '0021838', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '1785', 'branch_digit': '0', 'account': '0020480', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '1701', 'branch_digit': '9', 'account': '58001', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '3137', 'branch_digit': '2', 'account': '0009348', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '3100', 'branch_digit': '3', 'account': '0447884', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '6005', 'branch_digit': '4', 'account': '0001165', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '0423', 'branch_digit': '5', 'account': '110106', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '0568', 'branch_digit': '1', 'account': '10889', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '0601', 'branch_digit': '7', 'account': '7559', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '3636', 'branch_digit': '6', 'account': '7550', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '2214', 'branch_digit': '4', 'account': '0600632', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '3469', 'branch_digit': '0', 'account': '7953', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '3210', 'branch_digit': '7', 'account': '0100725', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '1522', 'branch_digit': '9', 'account': '1459', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '0156', 'branch_digit': '2', 'account': '0218147', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '0095', 'branch_digit': '7', 'account': '265154', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '1084', 'branch_digit': '7', 'account': '0039561', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '1262', 'branch_digit': '9', 'account': '0020629', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '6898', 'branch_digit': '5', 'account': '1670', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '1691', 'branch_digit': '8', 'account': '0001579', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '2369', 'branch_digit': '8', 'account': '0006512', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '1526', 'branch_digit': '1', 'account': '9901', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '0165', 'branch_digit': '1', 'account': '0102598', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '2614', 'branch_digit': '0', 'account': '0502683', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '0495', 'branch_digit': '2', 'account': '0106571', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '2784', 'branch_digit': '7', 'account': '9202', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '0214', 'branch_digit': '3', 'account': '075866', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '1045', 'branch_digit': '6', 'account': '186055', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '1431', 'branch_digit': '1', 'account': '0057991', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '0220', 'branch_digit': '8', 'account': '0006140', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '0497', 'branch_digit': '9', 'account': '63630', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '0027', 'branch_digit': '2', 'account': '51474', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '2062', 'branch_digit': '1', 'account': '97387', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '2201', 'branch_digit': '2', 'account': '0044649', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '3526', 'branch_digit': '2', 'account': '18273', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '2918', 'branch_digit': '1', 'account': '1001156', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '0943', 'branch_digit': '1', 'account': '000561', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '3014', 'branch_digit': '7', 'account': '0010704', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '0055', 'branch_digit': '8', 'account': '0767584', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '1489', 'branch_digit': '3', 'account': '0007197', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '0562', 'branch_digit': '2', 'account': '53934', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '2274', 'branch_digit': '8', 'account': '23502', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '2701', 'branch_digit': '4', 'account': '19898', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '1095', 'branch_digit': '2', 'account': '44644', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '1382', 'branch_digit': '0', 'account': '0169241', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '0779', 'branch_digit': '0', 'account': '102722', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '1051', 'branch_digit': '0', 'account': '73884', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '2892', 'branch_digit': '4', 'account': '0003862', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '2856', 'branch_digit': '8', 'account': '565337', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '0649', 'branch_digit': '1', 'account': '9756', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '2716', 'branch_digit': '2', 'account': '7971', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '3191', 'branch_digit': '7', 'account': '20350', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '0138', 'branch_digit': '4', 'account': '0161646', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '3424', 'branch_digit': '0', 'account': '37725', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '0224', 'branch_digit': '0', 'account': '14273', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '3221', 'branch_digit': '2', 'account': '20247', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '3035', 'branch_digit': '0', 'account': '099897', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '3071', 'branch_digit': '6', 'account': '0031989', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '2330', 'branch_digit': '2', 'account': '100010', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '2856', 'branch_digit': '8', 'account': '243751', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '0653', 'branch_digit': '0', 'account': '15955', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '2272', 'branch_digit': '1', 'account': '011441', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '0782', 'branch_digit': '0', 'account': '274', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '3739', 'branch_digit': '7', 'account': '0024845', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '0081', 'branch_digit': '7', 'account': '3289', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '0254', 'branch_digit': '2', 'account': '0015422', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '0093', 'branch_digit': '0', 'account': '000046', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '0113', 'branch_digit': '9', 'account': '128695', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '1975', 'branch_digit': '5', 'account': '64289', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '1709', 'branch_digit': '4', 'account': '0510794', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '1644', 'branch_digit': '6', 'account': '0013252', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '2137', 'branch_digit': '7', 'account': '35347', 'account_digit': '7'},
        {'bank_code': '237', 'branch': '2423', 'branch_digit': '6', 'account': '1580', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '3267', 'branch_digit': '0', 'account': '799', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '1365', 'branch_digit': '0', 'account': '32868', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '0456', 'branch_digit': '1', 'account': '61580', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '3726', 'branch_digit': '5', 'account': '82155', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '1792', 'branch_digit': '2', 'account': '12870', 'account_digit': '8'},
        {'bank_code': '237', 'branch': '1786', 'branch_digit': '8', 'account': '0027105', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '2344', 'branch_digit': '2', 'account': '4113', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '2811', 'branch_digit': '8', 'account': '0010400', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '2856', 'branch_digit': '8', 'account': '572390', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '0105', 'branch_digit': '8', 'account': '0243332', 'account_digit': '0'},
        {'bank_code': '237', 'branch': '2375', 'branch_digit': '2', 'account': '0107478', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '3539', 'branch_digit': '4', 'account': '98845', 'account_digit': '6'},
        {'bank_code': '237', 'branch': '0843', 'branch_digit': '5', 'account': '12555', 'account_digit': '5'},
        {'bank_code': '237', 'branch': '1625', 'branch_digit': '0', 'account': '769', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '0292', 'branch_digit': '5', 'account': '0107680', 'account_digit': '9'},
        {'bank_code': '237', 'branch': '2485', 'branch_digit': '6', 'account': '0024089', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '0111', 'branch_digit': '2', 'account': '98952', 'account_digit': '5'},
    ],
    'invalid_combinations': [
        {'bank_code': '237', 'branch': '2377', 'branch_digit': '9', 'account': '0002158', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '1842', 'branch_digit': '2', 'account': '42582', 'account_digit': '4'},
        {'bank_code': '237', 'branch': '2308', 'branch_digit': '6', 'account': '8743', 'account_digit': '3'},
        {'bank_code': '237', 'branch': '2883', 'branch_digit': '5', 'account': '19678', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '1493', 'branch_digit': '1', 'account': '00004218', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '0105', 'branch_digit': '8', 'account': '0243332', 'account_digit': '1'},
        {'bank_code': '237', 'branch': '2375', 'branch_digit': '2', 'account': '0107478', 'account_digit': '2'},
        {'bank_code': '237', 'branch': '3539', 'branch_digit': '4', 'account': '98845', 'account_digit': '3'}
    ]
}

ITAU = {
    'valid_combinations': [
        {'bank_code': '341', 'branch': '2545', 'branch_digit': '', 'account': '02366', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '4122', 'branch_digit': '', 'account': '08781', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '6629', 'branch_digit': '', 'account': '00487', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '8613', 'branch_digit': '', 'account': '30393', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '1688', 'branch_digit': '', 'account': '42768', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '9097', 'branch_digit': '', 'account': '30404', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '0164', 'branch_digit': '', 'account': '83940', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '3069', 'branch_digit': '', 'account': '17061', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '9649', 'branch_digit': '', 'account': '00947', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '1165', 'branch_digit': '', 'account': '44378', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '3130', 'branch_digit': '', 'account': '20138', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '3004', 'branch_digit': '', 'account': '02729', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '0895', 'branch_digit': '', 'account': '51357', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '7041', 'branch_digit': '', 'account': '64676', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '0735', 'branch_digit': '', 'account': '03207', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '6241', 'branch_digit': '', 'account': '21842', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '9109', 'branch_digit': '', 'account': '15436', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '4300', 'branch_digit': '', 'account': '34939', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '3935', 'branch_digit': '', 'account': '23504', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '0368', 'branch_digit': '', 'account': '14365', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '9649', 'branch_digit': '', 'account': '00479', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '4465', 'branch_digit': '', 'account': '04952', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '8053', 'branch_digit': '', 'account': '02090', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '1538', 'branch_digit': '', 'account': '02328', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '7063', 'branch_digit': '', 'account': '02567', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '2944', 'branch_digit': '', 'account': '14795', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '8219', 'branch_digit': '', 'account': '00853', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '8574', 'branch_digit': '', 'account': '00273', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '0251', 'branch_digit': '', 'account': '76606', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '7012', 'branch_digit': '', 'account': '04430', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '0191', 'branch_digit': '', 'account': '71355', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '9699', 'branch_digit': '', 'account': '04962', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '6470', 'branch_digit': '', 'account': '10400', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '0024', 'branch_digit': '', 'account': '42560', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '0138', 'branch_digit': '', 'account': '01434', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '9286', 'branch_digit': '', 'account': '17593', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '1364', 'branch_digit': '', 'account': '08603', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '5928', 'branch_digit': '', 'account': '00599', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '6476', 'branch_digit': '', 'account': '04010', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '8142', 'branch_digit': '', 'account': '02166', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '7821', 'branch_digit': '', 'account': '01500', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '8605', 'branch_digit': '', 'account': '01535', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '6328', 'branch_digit': '', 'account': '07429', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '9283', 'branch_digit': '', 'account': '17700', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '1565', 'branch_digit': '', 'account': '28069', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '8614', 'branch_digit': '', 'account': '46724', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '9276', 'branch_digit': '', 'account': '00838', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '9103', 'branch_digit': '', 'account': '13602', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '3701', 'branch_digit': '', 'account': '26628', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '1481', 'branch_digit': '', 'account': '05860', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '7031', 'branch_digit': '', 'account': '07554', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '0715', 'branch_digit': '', 'account': '54473', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '6575', 'branch_digit': '', 'account': '00728', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '4052', 'branch_digit': '', 'account': '11881', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '6123', 'branch_digit': '', 'account': '06390', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '6665', 'branch_digit': '', 'account': '02753', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '0665', 'branch_digit': '', 'account': '39207', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '6234', 'branch_digit': '', 'account': '18342', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '3753', 'branch_digit': '', 'account': '13485', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '2924', 'branch_digit': '', 'account': '33488', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '2970', 'branch_digit': '', 'account': '19333', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '6695', 'branch_digit': '', 'account': '03256', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '3789', 'branch_digit': '', 'account': '09105', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '1616', 'branch_digit': '', 'account': '02167', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '8133', 'branch_digit': '', 'account': '03805', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '6220', 'branch_digit': '', 'account': '98133', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '1003', 'branch_digit': '', 'account': '58887', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '7048', 'branch_digit': '', 'account': '00156', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '4300', 'branch_digit': '', 'account': '08042', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '3705', 'branch_digit': '', 'account': '13502', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '9110', 'branch_digit': '', 'account': '22667', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '3765', 'branch_digit': '', 'account': '32387', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '1620', 'branch_digit': '', 'account': '11908', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '0522', 'branch_digit': '', 'account': '68967', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '8846', 'branch_digit': '', 'account': '14776', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '9293', 'branch_digit': '', 'account': '28334', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '1399', 'branch_digit': '', 'account': '57112', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '7437', 'branch_digit': '', 'account': '08739', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '5605', 'branch_digit': '', 'account': '08922', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '0210', 'branch_digit': '', 'account': '64727', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '3836', 'branch_digit': '', 'account': '34668', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '0150', 'branch_digit': '', 'account': '27317', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '8188', 'branch_digit': '', 'account': '05810', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '3040', 'branch_digit': '', 'account': '20210', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '2798', 'branch_digit': '', 'account': '10208', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '9663', 'branch_digit': '', 'account': '06276', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '0179', 'branch_digit': '', 'account': '31803', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '1063', 'branch_digit': '', 'account': '27533', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '8751', 'branch_digit': '', 'account': '01815', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '6540', 'branch_digit': '', 'account': '10045', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '4807', 'branch_digit': '', 'account': '02583', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '0310', 'branch_digit': '', 'account': '78327', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '5572', 'branch_digit': '', 'account': '17715', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '4339', 'branch_digit': '', 'account': '10697', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '3888', 'branch_digit': '', 'account': '15327', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '7344', 'branch_digit': '', 'account': '01533', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '2971', 'branch_digit': '', 'account': '25759', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '3203', 'branch_digit': '', 'account': '14059', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '3116', 'branch_digit': '', 'account': '13720', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '0285', 'branch_digit': '', 'account': '74139', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '8571', 'branch_digit': '', 'account': '07180', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '7048', 'branch_digit': '', 'account': '19193', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '1538', 'branch_digit': '', 'account': '50366', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '0566', 'branch_digit': '', 'account': '28945', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '0941', 'branch_digit': '', 'account': '56590', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '0572', 'branch_digit': '', 'account': '02913', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '1017', 'branch_digit': '', 'account': '58535', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '3836', 'branch_digit': '', 'account': '29578', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '1685', 'branch_digit': '', 'account': '30139', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '3130', 'branch_digit': '', 'account': '12254', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '3031', 'branch_digit': '', 'account': '18636', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '9286', 'branch_digit': '', 'account': '14450', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '7066', 'branch_digit': '', 'account': '62972', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '9362', 'branch_digit': '', 'account': '23929', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '7414', 'branch_digit': '', 'account': '16290', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '4099', 'branch_digit': '', 'account': '57717', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '6914', 'branch_digit': '', 'account': '04430', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '0310', 'branch_digit': '', 'account': '10426', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '7070', 'branch_digit': '', 'account': '07492', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '0445', 'branch_digit': '', 'account': '32128', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '9692', 'branch_digit': '', 'account': '00861', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '0646', 'branch_digit': '', 'account': '01639', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '8723', 'branch_digit': '', 'account': '09311', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '6968', 'branch_digit': '', 'account': '01098', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '9093', 'branch_digit': '', 'account': '01069', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '6097', 'branch_digit': '', 'account': '23964', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '6133', 'branch_digit': '', 'account': '01815', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '0265', 'branch_digit': '', 'account': '69144', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '8514', 'branch_digit': '', 'account': '08026', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '8313', 'branch_digit': '', 'account': '05018', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '3741', 'branch_digit': '', 'account': '44590', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '3099', 'branch_digit': '', 'account': '18807', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '3219', 'branch_digit': '', 'account': '10842', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '8062', 'branch_digit': '', 'account': '15147', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '0652', 'branch_digit': '', 'account': '08707', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '2000', 'branch_digit': '', 'account': '40299', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '0297', 'branch_digit': '', 'account': '64674', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '3825', 'branch_digit': '', 'account': '13677', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '8365', 'branch_digit': '', 'account': '09685', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '0655', 'branch_digit': '', 'account': '26754', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '1542', 'branch_digit': '', 'account': '13501', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '4446', 'branch_digit': '', 'account': '18030', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '4079', 'branch_digit': '', 'account': '07630', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '8482', 'branch_digit': '', 'account': '18902', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '1478', 'branch_digit': '', 'account': '53999', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '7425', 'branch_digit': '', 'account': '04011', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '8792', 'branch_digit': '', 'account': '29321', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '8719', 'branch_digit': '', 'account': '15778', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '8004', 'branch_digit': '', 'account': '05847', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '0262', 'branch_digit': '', 'account': '96414', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '2971', 'branch_digit': '', 'account': '13310', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '9134', 'branch_digit': '', 'account': '11428', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '0689', 'branch_digit': '', 'account': '01811', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '9635', 'branch_digit': '', 'account': '01209', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '6244', 'branch_digit': '', 'account': '14164', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '8498', 'branch_digit': '', 'account': '21429', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '0190', 'branch_digit': '', 'account': '54490', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '9051', 'branch_digit': '', 'account': '00646', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '0036', 'branch_digit': '', 'account': '58502', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '8708', 'branch_digit': '', 'account': '03545', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '4449', 'branch_digit': '', 'account': '01118', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '6939', 'branch_digit': '', 'account': '21568', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '0706', 'branch_digit': '', 'account': '03965', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '9391', 'branch_digit': '', 'account': '00570', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '0623', 'branch_digit': '', 'account': '00872', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '0940', 'branch_digit': '', 'account': '64043', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '8652', 'branch_digit': '', 'account': '04313', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '0709', 'branch_digit': '', 'account': '10314', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '7007', 'branch_digit': '', 'account': '00504', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '0776', 'branch_digit': '', 'account': '68025', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '2934', 'branch_digit': '', 'account': '09853', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '9134', 'branch_digit': '', 'account': '11428', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '8474', 'branch_digit': '', 'account': '16755', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '1001', 'branch_digit': '', 'account': '24612', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '3103', 'branch_digit': '', 'account': '20710', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '8121', 'branch_digit': '', 'account': '04852', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '0278', 'branch_digit': '', 'account': '89922', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '0477', 'branch_digit': '', 'account': '09974', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '2796', 'branch_digit': '', 'account': '05148', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '3758', 'branch_digit': '', 'account': '49828', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '8910', 'branch_digit': '', 'account': '25750', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '4085', 'branch_digit': '', 'account': '14921', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '0442', 'branch_digit': '', 'account': '02850', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '7387', 'branch_digit': '', 'account': '13978', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '9180', 'branch_digit': '', 'account': '17220', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '0844', 'branch_digit': '', 'account': '07076', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '0355', 'branch_digit': '', 'account': '92834', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '7446', 'branch_digit': '', 'account': '12709', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '0429', 'branch_digit': '', 'account': '47089', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '0525', 'branch_digit': '', 'account': '08970', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '3747', 'branch_digit': '', 'account': '02656', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '4088', 'branch_digit': '', 'account': '03382', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '0736', 'branch_digit': '', 'account': '45706', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '7157', 'branch_digit': '', 'account': '11004', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '8450', 'branch_digit': '', 'account': '13039', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '8463', 'branch_digit': '', 'account': '04333', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '4294', 'branch_digit': '', 'account': '10960', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '8447', 'branch_digit': '', 'account': '08572', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '8139', 'branch_digit': '', 'account': '11345', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '0459', 'branch_digit': '', 'account': '03822', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '0919', 'branch_digit': '', 'account': '07320', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '1623', 'branch_digit': '', 'account': '24594', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '7942', 'branch_digit': '', 'account': '12726', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '0251', 'branch_digit': '', 'account': '67048', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '0760', 'branch_digit': '', 'account': '16348', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '0756', 'branch_digit': '', 'account': '60266', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '3799', 'branch_digit': '', 'account': '01353', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '0654', 'branch_digit': '', 'account': '10024', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '0018', 'branch_digit': '', 'account': '72895', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '9283', 'branch_digit': '', 'account': '20288', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '1185', 'branch_digit': '', 'account': '60488', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '8279', 'branch_digit': '', 'account': '00834', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '0055', 'branch_digit': '', 'account': '34411', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '7943', 'branch_digit': '', 'account': '10155', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '8446', 'branch_digit': '', 'account': '06231', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '3613', 'branch_digit': '', 'account': '04687', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '3777', 'branch_digit': '', 'account': '06010', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '4011', 'branch_digit': '', 'account': '21222', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '7016', 'branch_digit': '', 'account': '07895', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '9667', 'branch_digit': '', 'account': '10898', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '6427', 'branch_digit': '', 'account': '18970', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '3075', 'branch_digit': '', 'account': '19116', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '4085', 'branch_digit': '', 'account': '03818', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '7157', 'branch_digit': '', 'account': '00345', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '8463', 'branch_digit': '', 'account': '09932', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '0572', 'branch_digit': '', 'account': '20513', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '0566', 'branch_digit': '', 'account': '30124', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '4374', 'branch_digit': '', 'account': '25304', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '4927', 'branch_digit': '', 'account': '30670', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '0061', 'branch_digit': '', 'account': '65341', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '6621', 'branch_digit': '', 'account': '06971', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '8878', 'branch_digit': '', 'account': '20048', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '3835', 'branch_digit': '', 'account': '38441', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '5520', 'branch_digit': '', 'account': '01668', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '6767', 'branch_digit': '', 'account': '06546', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '7062', 'branch_digit': '', 'account': '06579', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '9678', 'branch_digit': '', 'account': '00927', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '2978', 'branch_digit': '', 'account': '20731', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '1282', 'branch_digit': '', 'account': '54593', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '0012', 'branch_digit': '', 'account': '33700', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '6225', 'branch_digit': '', 'account': '03090', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '0556', 'branch_digit': '', 'account': '29212', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '8463', 'branch_digit': '', 'account': '14177', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '8450', 'branch_digit': '', 'account': '04753', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '6432', 'branch_digit': '', 'account': '12741', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '8913', 'branch_digit': '', 'account': '01700', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '4695', 'branch_digit': '', 'account': '04107', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '0874', 'branch_digit': '', 'account': '56578', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '8705', 'branch_digit': '', 'account': '06153', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '8725', 'branch_digit': '', 'account': '04874', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '3813', 'branch_digit': '', 'account': '16648', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '1269', 'branch_digit': '', 'account': '06760', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '0548', 'branch_digit': '', 'account': '35927', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '8809', 'branch_digit': '', 'account': '09885', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '1370', 'branch_digit': '', 'account': '06949', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '0129', 'branch_digit': '', 'account': '34430', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '2959', 'branch_digit': '', 'account': '13026', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '2960', 'branch_digit': '', 'account': '24455', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '1000', 'branch_digit': '', 'account': '18008', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '8781', 'branch_digit': '', 'account': '09876', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '3038', 'branch_digit': '', 'account': '30462', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '3130', 'branch_digit': '', 'account': '25578', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '1449', 'branch_digit': '', 'account': '26762', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '1335', 'branch_digit': '', 'account': '63145', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '3763', 'branch_digit': '', 'account': '43294', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '8462', 'branch_digit': '', 'account': '03293', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '1572', 'branch_digit': '', 'account': '18622', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '8600', 'branch_digit': '', 'account': '18728', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '3488', 'branch_digit': '', 'account': '09205', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '1025', 'branch_digit': '', 'account': '12775', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '0140', 'branch_digit': '', 'account': '27040', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '6684', 'branch_digit': '', 'account': '21031', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '0758', 'branch_digit': '', 'account': '46005', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '8379', 'branch_digit': '', 'account': '10307', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '5184', 'branch_digit': '', 'account': '00782', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '9718', 'branch_digit': '', 'account': '00834', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '1170', 'branch_digit': '', 'account': '07220', 'account_digit': '9'},
        {'bank_code': '341', 'branch': '4011', 'branch_digit': '', 'account': '10150', 'account_digit': '0'},
        {'bank_code': '341', 'branch': '0262', 'branch_digit': '', 'account': '02455', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '7757', 'branch_digit': '', 'account': '17788', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '8577', 'branch_digit': '', 'account': '08666', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '0098', 'branch_digit': '', 'account': '40365', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '0452', 'branch_digit': '', 'account': '01396', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '4091', 'branch_digit': '', 'account': '02245', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '0061', 'branch_digit': '', 'account': '05396', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '3789', 'branch_digit': '', 'account': '10367', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '4091', 'branch_digit': '', 'account': '02943', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '4525', 'branch_digit': '', 'account': '01062', 'account_digit': '7'},
    ],
    'invalid_combinations': [
        {'bank_code': '341', 'branch': '4122', 'branch_digit': '', 'account': '08781', 'account_digit': '5'},
        {'bank_code': '341', 'branch': '6629', 'branch_digit': '', 'account': '00487', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '8613', 'branch_digit': '', 'account': '30393', 'account_digit': '4'},
        {'bank_code': '341', 'branch': '1688', 'branch_digit': '', 'account': '42768', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '9097', 'branch_digit': '', 'account': '30404', 'account_digit': '7'},
        {'bank_code': '341', 'branch': '0164', 'branch_digit': '', 'account': '83940', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '3069', 'branch_digit': '', 'account': '17061', 'account_digit': '2'},
        {'bank_code': '341', 'branch': '9649', 'branch_digit': '', 'account': '00947', 'account_digit': '6'},
        {'bank_code': '341', 'branch': '1165', 'branch_digit': '', 'account': '44378', 'account_digit': '8'},
        {'bank_code': '341', 'branch': '3038', 'branch_digit': '', 'account': '30462', 'account_digit': '3'},
        {'bank_code': '341', 'branch': '3130', 'branch_digit': '', 'account': '25578', 'account_digit': '1'},
        {'bank_code': '341', 'branch': '1449', 'branch_digit': '', 'account': '26762', 'account_digit': '7'},
    ]
}

CITIBANK = {
    'valid_combinations': [
        {'bank_code': '745', 'branch': '0075', 'branch_digit': '', 'account': '0007500465', 'account_digit': '8'}
    ]
}

NUBANK = {
    'valid_combinations': [
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '9234876', 'account_digit': '7'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '34881901', 'account_digit': '4'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '8719182', 'account_digit': '5'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '2511392', 'account_digit': '1'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '49649347', 'account_digit': '9'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '4926441', 'account_digit': '3'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '2816358', 'account_digit': '3'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '7956865', 'account_digit': '6'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '94801151', 'account_digit': '6'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '37169257', 'account_digit': '2'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '1767020', 'account_digit': '2'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '3893072', 'account_digit': '9'},
        {'bank_code': '260', 'branch': '0001', 'branch_digit': '', 'account': '53698696', 'account_digit': '1'}
    ]
}