import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from ._jsii import *

import cdktf
import constructs


class AdvancedThreatProtection(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AdvancedThreatProtection",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        enabled: builtins.bool,
        target_resource_id: builtins.str,
        timeouts: typing.Optional["AdvancedThreatProtectionTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param enabled: -
        :param target_resource_id: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AdvancedThreatProtectionConfig(
            enabled=enabled,
            target_resource_id=target_resource_id,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AdvancedThreatProtection, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enabledInput")
    def enabled_input(self) -> builtins.bool:
        return jsii.get(self, "enabledInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="targetResourceIdInput")
    def target_resource_id_input(self) -> builtins.str:
        return jsii.get(self, "targetResourceIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AdvancedThreatProtectionTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> builtins.bool:
        return jsii.get(self, "enabled")

    @enabled.setter # type: ignore
    def enabled(self, value: builtins.bool) -> None:
        jsii.set(self, "enabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="targetResourceId")
    def target_resource_id(self) -> builtins.str:
        return jsii.get(self, "targetResourceId")

    @target_resource_id.setter # type: ignore
    def target_resource_id(self, value: builtins.str) -> None:
        jsii.set(self, "targetResourceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AdvancedThreatProtectionTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AdvancedThreatProtectionTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AdvancedThreatProtectionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "enabled": "enabled",
        "target_resource_id": "targetResourceId",
        "timeouts": "timeouts",
    },
)
class AdvancedThreatProtectionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        enabled: builtins.bool,
        target_resource_id: builtins.str,
        timeouts: typing.Optional["AdvancedThreatProtectionTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param enabled: -
        :param target_resource_id: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AdvancedThreatProtectionTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "enabled": enabled,
            "target_resource_id": target_resource_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def enabled(self) -> builtins.bool:
        result = self._values.get("enabled")
        assert result is not None, "Required property 'enabled' is missing"
        return result

    @builtins.property
    def target_resource_id(self) -> builtins.str:
        result = self._values.get("target_resource_id")
        assert result is not None, "Required property 'target_resource_id' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AdvancedThreatProtectionTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AdvancedThreatProtectionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AdvancedThreatProtectionTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AdvancedThreatProtectionTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AdvancedThreatProtectionTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AnalysisServicesServer(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AnalysisServicesServer",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        sku: builtins.str,
        admin_users: typing.Optional[typing.List[builtins.str]] = None,
        backup_blob_container_uri: typing.Optional[builtins.str] = None,
        enable_power_bi_service: typing.Optional[builtins.bool] = None,
        ipv4_firewall_rule: typing.Optional[typing.List["AnalysisServicesServerIpv4FirewallRule"]] = None,
        querypool_connection_mode: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AnalysisServicesServerTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param sku: -
        :param admin_users: -
        :param backup_blob_container_uri: -
        :param enable_power_bi_service: -
        :param ipv4_firewall_rule: ipv4_firewall_rule block.
        :param querypool_connection_mode: -
        :param tags: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AnalysisServicesServerConfig(
            location=location,
            name=name,
            resource_group_name=resource_group_name,
            sku=sku,
            admin_users=admin_users,
            backup_blob_container_uri=backup_blob_container_uri,
            enable_power_bi_service=enable_power_bi_service,
            ipv4_firewall_rule=ipv4_firewall_rule,
            querypool_connection_mode=querypool_connection_mode,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AnalysisServicesServer, self, [scope, id, config])

    @jsii.member(jsii_name="resetAdminUsers")
    def reset_admin_users(self) -> None:
        return jsii.invoke(self, "resetAdminUsers", [])

    @jsii.member(jsii_name="resetBackupBlobContainerUri")
    def reset_backup_blob_container_uri(self) -> None:
        return jsii.invoke(self, "resetBackupBlobContainerUri", [])

    @jsii.member(jsii_name="resetEnablePowerBiService")
    def reset_enable_power_bi_service(self) -> None:
        return jsii.invoke(self, "resetEnablePowerBiService", [])

    @jsii.member(jsii_name="resetIpv4FirewallRule")
    def reset_ipv4_firewall_rule(self) -> None:
        return jsii.invoke(self, "resetIpv4FirewallRule", [])

    @jsii.member(jsii_name="resetQuerypoolConnectionMode")
    def reset_querypool_connection_mode(self) -> None:
        return jsii.invoke(self, "resetQuerypoolConnectionMode", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="locationInput")
    def location_input(self) -> builtins.str:
        return jsii.get(self, "locationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serverFullName")
    def server_full_name(self) -> builtins.str:
        return jsii.get(self, "serverFullName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="skuInput")
    def sku_input(self) -> builtins.str:
        return jsii.get(self, "skuInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="adminUsersInput")
    def admin_users_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return jsii.get(self, "adminUsersInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="backupBlobContainerUriInput")
    def backup_blob_container_uri_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "backupBlobContainerUriInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enablePowerBiServiceInput")
    def enable_power_bi_service_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "enablePowerBiServiceInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipv4FirewallRuleInput")
    def ipv4_firewall_rule_input(
        self,
    ) -> typing.Optional[typing.List["AnalysisServicesServerIpv4FirewallRule"]]:
        return jsii.get(self, "ipv4FirewallRuleInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="querypoolConnectionModeInput")
    def querypool_connection_mode_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "querypoolConnectionModeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AnalysisServicesServerTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="adminUsers")
    def admin_users(self) -> typing.List[builtins.str]:
        return jsii.get(self, "adminUsers")

    @admin_users.setter # type: ignore
    def admin_users(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "adminUsers", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="backupBlobContainerUri")
    def backup_blob_container_uri(self) -> builtins.str:
        return jsii.get(self, "backupBlobContainerUri")

    @backup_blob_container_uri.setter # type: ignore
    def backup_blob_container_uri(self, value: builtins.str) -> None:
        jsii.set(self, "backupBlobContainerUri", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enablePowerBiService")
    def enable_power_bi_service(self) -> builtins.bool:
        return jsii.get(self, "enablePowerBiService")

    @enable_power_bi_service.setter # type: ignore
    def enable_power_bi_service(self, value: builtins.bool) -> None:
        jsii.set(self, "enablePowerBiService", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipv4FirewallRule")
    def ipv4_firewall_rule(
        self,
    ) -> typing.List["AnalysisServicesServerIpv4FirewallRule"]:
        return jsii.get(self, "ipv4FirewallRule")

    @ipv4_firewall_rule.setter # type: ignore
    def ipv4_firewall_rule(
        self,
        value: typing.List["AnalysisServicesServerIpv4FirewallRule"],
    ) -> None:
        jsii.set(self, "ipv4FirewallRule", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(self) -> builtins.str:
        return jsii.get(self, "location")

    @location.setter # type: ignore
    def location(self, value: builtins.str) -> None:
        jsii.set(self, "location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="querypoolConnectionMode")
    def querypool_connection_mode(self) -> builtins.str:
        return jsii.get(self, "querypoolConnectionMode")

    @querypool_connection_mode.setter # type: ignore
    def querypool_connection_mode(self, value: builtins.str) -> None:
        jsii.set(self, "querypoolConnectionMode", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sku")
    def sku(self) -> builtins.str:
        return jsii.get(self, "sku")

    @sku.setter # type: ignore
    def sku(self, value: builtins.str) -> None:
        jsii.set(self, "sku", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AnalysisServicesServerTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AnalysisServicesServerTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AnalysisServicesServerConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "location": "location",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "sku": "sku",
        "admin_users": "adminUsers",
        "backup_blob_container_uri": "backupBlobContainerUri",
        "enable_power_bi_service": "enablePowerBiService",
        "ipv4_firewall_rule": "ipv4FirewallRule",
        "querypool_connection_mode": "querypoolConnectionMode",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AnalysisServicesServerConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        sku: builtins.str,
        admin_users: typing.Optional[typing.List[builtins.str]] = None,
        backup_blob_container_uri: typing.Optional[builtins.str] = None,
        enable_power_bi_service: typing.Optional[builtins.bool] = None,
        ipv4_firewall_rule: typing.Optional[typing.List["AnalysisServicesServerIpv4FirewallRule"]] = None,
        querypool_connection_mode: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AnalysisServicesServerTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param sku: -
        :param admin_users: -
        :param backup_blob_container_uri: -
        :param enable_power_bi_service: -
        :param ipv4_firewall_rule: ipv4_firewall_rule block.
        :param querypool_connection_mode: -
        :param tags: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AnalysisServicesServerTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "location": location,
            "name": name,
            "resource_group_name": resource_group_name,
            "sku": sku,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if admin_users is not None:
            self._values["admin_users"] = admin_users
        if backup_blob_container_uri is not None:
            self._values["backup_blob_container_uri"] = backup_blob_container_uri
        if enable_power_bi_service is not None:
            self._values["enable_power_bi_service"] = enable_power_bi_service
        if ipv4_firewall_rule is not None:
            self._values["ipv4_firewall_rule"] = ipv4_firewall_rule
        if querypool_connection_mode is not None:
            self._values["querypool_connection_mode"] = querypool_connection_mode
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def location(self) -> builtins.str:
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def sku(self) -> builtins.str:
        result = self._values.get("sku")
        assert result is not None, "Required property 'sku' is missing"
        return result

    @builtins.property
    def admin_users(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("admin_users")
        return result

    @builtins.property
    def backup_blob_container_uri(self) -> typing.Optional[builtins.str]:
        result = self._values.get("backup_blob_container_uri")
        return result

    @builtins.property
    def enable_power_bi_service(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_power_bi_service")
        return result

    @builtins.property
    def ipv4_firewall_rule(
        self,
    ) -> typing.Optional[typing.List["AnalysisServicesServerIpv4FirewallRule"]]:
        """ipv4_firewall_rule block."""
        result = self._values.get("ipv4_firewall_rule")
        return result

    @builtins.property
    def querypool_connection_mode(self) -> typing.Optional[builtins.str]:
        result = self._values.get("querypool_connection_mode")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AnalysisServicesServerTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AnalysisServicesServerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AnalysisServicesServerIpv4FirewallRule",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "range_end": "rangeEnd",
        "range_start": "rangeStart",
    },
)
class AnalysisServicesServerIpv4FirewallRule:
    def __init__(
        self,
        *,
        name: builtins.str,
        range_end: builtins.str,
        range_start: builtins.str,
    ) -> None:
        """
        :param name: -
        :param range_end: -
        :param range_start: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "range_end": range_end,
            "range_start": range_start,
        }

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def range_end(self) -> builtins.str:
        result = self._values.get("range_end")
        assert result is not None, "Required property 'range_end' is missing"
        return result

    @builtins.property
    def range_start(self) -> builtins.str:
        result = self._values.get("range_start")
        assert result is not None, "Required property 'range_start' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AnalysisServicesServerIpv4FirewallRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AnalysisServicesServerTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AnalysisServicesServerTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AnalysisServicesServerTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagement(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagement",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        location: builtins.str,
        name: builtins.str,
        publisher_email: builtins.str,
        publisher_name: builtins.str,
        resource_group_name: builtins.str,
        sku_name: builtins.str,
        additional_location: typing.Optional[typing.List["ApiManagementAdditionalLocation"]] = None,
        certificate: typing.Optional[typing.List["ApiManagementCertificate"]] = None,
        hostname_configuration: typing.Optional[typing.List["ApiManagementHostnameConfiguration"]] = None,
        identity: typing.Optional[typing.List["ApiManagementIdentity"]] = None,
        notification_sender_email: typing.Optional[builtins.str] = None,
        policy: typing.Optional[typing.List["ApiManagementPolicy"]] = None,
        protocols: typing.Optional[typing.List["ApiManagementProtocols"]] = None,
        security: typing.Optional[typing.List["ApiManagementSecurity"]] = None,
        sign_in: typing.Optional[typing.List["ApiManagementSignIn"]] = None,
        sign_up: typing.Optional[typing.List["ApiManagementSignUp"]] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["ApiManagementTimeouts"] = None,
        virtual_network_configuration: typing.Optional[typing.List["ApiManagementVirtualNetworkConfiguration"]] = None,
        virtual_network_type: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param location: -
        :param name: -
        :param publisher_email: -
        :param publisher_name: -
        :param resource_group_name: -
        :param sku_name: -
        :param additional_location: additional_location block.
        :param certificate: certificate block.
        :param hostname_configuration: hostname_configuration block.
        :param identity: identity block.
        :param notification_sender_email: -
        :param policy: -
        :param protocols: protocols block.
        :param security: security block.
        :param sign_in: sign_in block.
        :param sign_up: sign_up block.
        :param tags: -
        :param timeouts: timeouts block.
        :param virtual_network_configuration: virtual_network_configuration block.
        :param virtual_network_type: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementConfig(
            location=location,
            name=name,
            publisher_email=publisher_email,
            publisher_name=publisher_name,
            resource_group_name=resource_group_name,
            sku_name=sku_name,
            additional_location=additional_location,
            certificate=certificate,
            hostname_configuration=hostname_configuration,
            identity=identity,
            notification_sender_email=notification_sender_email,
            policy=policy,
            protocols=protocols,
            security=security,
            sign_in=sign_in,
            sign_up=sign_up,
            tags=tags,
            timeouts=timeouts,
            virtual_network_configuration=virtual_network_configuration,
            virtual_network_type=virtual_network_type,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagement, self, [scope, id, config])

    @jsii.member(jsii_name="resetAdditionalLocation")
    def reset_additional_location(self) -> None:
        return jsii.invoke(self, "resetAdditionalLocation", [])

    @jsii.member(jsii_name="resetCertificate")
    def reset_certificate(self) -> None:
        return jsii.invoke(self, "resetCertificate", [])

    @jsii.member(jsii_name="resetHostnameConfiguration")
    def reset_hostname_configuration(self) -> None:
        return jsii.invoke(self, "resetHostnameConfiguration", [])

    @jsii.member(jsii_name="resetIdentity")
    def reset_identity(self) -> None:
        return jsii.invoke(self, "resetIdentity", [])

    @jsii.member(jsii_name="resetNotificationSenderEmail")
    def reset_notification_sender_email(self) -> None:
        return jsii.invoke(self, "resetNotificationSenderEmail", [])

    @jsii.member(jsii_name="resetPolicy")
    def reset_policy(self) -> None:
        return jsii.invoke(self, "resetPolicy", [])

    @jsii.member(jsii_name="resetProtocols")
    def reset_protocols(self) -> None:
        return jsii.invoke(self, "resetProtocols", [])

    @jsii.member(jsii_name="resetSecurity")
    def reset_security(self) -> None:
        return jsii.invoke(self, "resetSecurity", [])

    @jsii.member(jsii_name="resetSignIn")
    def reset_sign_in(self) -> None:
        return jsii.invoke(self, "resetSignIn", [])

    @jsii.member(jsii_name="resetSignUp")
    def reset_sign_up(self) -> None:
        return jsii.invoke(self, "resetSignUp", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetVirtualNetworkConfiguration")
    def reset_virtual_network_configuration(self) -> None:
        return jsii.invoke(self, "resetVirtualNetworkConfiguration", [])

    @jsii.member(jsii_name="resetVirtualNetworkType")
    def reset_virtual_network_type(self) -> None:
        return jsii.invoke(self, "resetVirtualNetworkType", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="developerPortalUrl")
    def developer_portal_url(self) -> builtins.str:
        return jsii.get(self, "developerPortalUrl")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="gatewayRegionalUrl")
    def gateway_regional_url(self) -> builtins.str:
        return jsii.get(self, "gatewayRegionalUrl")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="gatewayUrl")
    def gateway_url(self) -> builtins.str:
        return jsii.get(self, "gatewayUrl")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="locationInput")
    def location_input(self) -> builtins.str:
        return jsii.get(self, "locationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="managementApiUrl")
    def management_api_url(self) -> builtins.str:
        return jsii.get(self, "managementApiUrl")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="portalUrl")
    def portal_url(self) -> builtins.str:
        return jsii.get(self, "portalUrl")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="privateIpAddresses")
    def private_ip_addresses(self) -> typing.List[builtins.str]:
        return jsii.get(self, "privateIpAddresses")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="publicIpAddresses")
    def public_ip_addresses(self) -> typing.List[builtins.str]:
        return jsii.get(self, "publicIpAddresses")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="publisherEmailInput")
    def publisher_email_input(self) -> builtins.str:
        return jsii.get(self, "publisherEmailInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="publisherNameInput")
    def publisher_name_input(self) -> builtins.str:
        return jsii.get(self, "publisherNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="scmUrl")
    def scm_url(self) -> builtins.str:
        return jsii.get(self, "scmUrl")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="skuNameInput")
    def sku_name_input(self) -> builtins.str:
        return jsii.get(self, "skuNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="additionalLocationInput")
    def additional_location_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementAdditionalLocation"]]:
        return jsii.get(self, "additionalLocationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="certificateInput")
    def certificate_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementCertificate"]]:
        return jsii.get(self, "certificateInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostnameConfigurationInput")
    def hostname_configuration_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementHostnameConfiguration"]]:
        return jsii.get(self, "hostnameConfigurationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identityInput")
    def identity_input(self) -> typing.Optional[typing.List["ApiManagementIdentity"]]:
        return jsii.get(self, "identityInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="notificationSenderEmailInput")
    def notification_sender_email_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "notificationSenderEmailInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="policyInput")
    def policy_input(self) -> typing.Optional[typing.List["ApiManagementPolicy"]]:
        return jsii.get(self, "policyInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="protocolsInput")
    def protocols_input(self) -> typing.Optional[typing.List["ApiManagementProtocols"]]:
        return jsii.get(self, "protocolsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="securityInput")
    def security_input(self) -> typing.Optional[typing.List["ApiManagementSecurity"]]:
        return jsii.get(self, "securityInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="signInInput")
    def sign_in_input(self) -> typing.Optional[typing.List["ApiManagementSignIn"]]:
        return jsii.get(self, "signInInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="signUpInput")
    def sign_up_input(self) -> typing.Optional[typing.List["ApiManagementSignUp"]]:
        return jsii.get(self, "signUpInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="virtualNetworkConfigurationInput")
    def virtual_network_configuration_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementVirtualNetworkConfiguration"]]:
        return jsii.get(self, "virtualNetworkConfigurationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="virtualNetworkTypeInput")
    def virtual_network_type_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "virtualNetworkTypeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="additionalLocation")
    def additional_location(self) -> typing.List["ApiManagementAdditionalLocation"]:
        return jsii.get(self, "additionalLocation")

    @additional_location.setter # type: ignore
    def additional_location(
        self,
        value: typing.List["ApiManagementAdditionalLocation"],
    ) -> None:
        jsii.set(self, "additionalLocation", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="certificate")
    def certificate(self) -> typing.List["ApiManagementCertificate"]:
        return jsii.get(self, "certificate")

    @certificate.setter # type: ignore
    def certificate(self, value: typing.List["ApiManagementCertificate"]) -> None:
        jsii.set(self, "certificate", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostnameConfiguration")
    def hostname_configuration(
        self,
    ) -> typing.List["ApiManagementHostnameConfiguration"]:
        return jsii.get(self, "hostnameConfiguration")

    @hostname_configuration.setter # type: ignore
    def hostname_configuration(
        self,
        value: typing.List["ApiManagementHostnameConfiguration"],
    ) -> None:
        jsii.set(self, "hostnameConfiguration", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identity")
    def identity(self) -> typing.List["ApiManagementIdentity"]:
        return jsii.get(self, "identity")

    @identity.setter # type: ignore
    def identity(self, value: typing.List["ApiManagementIdentity"]) -> None:
        jsii.set(self, "identity", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(self) -> builtins.str:
        return jsii.get(self, "location")

    @location.setter # type: ignore
    def location(self, value: builtins.str) -> None:
        jsii.set(self, "location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="notificationSenderEmail")
    def notification_sender_email(self) -> builtins.str:
        return jsii.get(self, "notificationSenderEmail")

    @notification_sender_email.setter # type: ignore
    def notification_sender_email(self, value: builtins.str) -> None:
        jsii.set(self, "notificationSenderEmail", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="policy")
    def policy(self) -> typing.List["ApiManagementPolicy"]:
        return jsii.get(self, "policy")

    @policy.setter # type: ignore
    def policy(self, value: typing.List["ApiManagementPolicy"]) -> None:
        jsii.set(self, "policy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="protocols")
    def protocols(self) -> typing.List["ApiManagementProtocols"]:
        return jsii.get(self, "protocols")

    @protocols.setter # type: ignore
    def protocols(self, value: typing.List["ApiManagementProtocols"]) -> None:
        jsii.set(self, "protocols", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="publisherEmail")
    def publisher_email(self) -> builtins.str:
        return jsii.get(self, "publisherEmail")

    @publisher_email.setter # type: ignore
    def publisher_email(self, value: builtins.str) -> None:
        jsii.set(self, "publisherEmail", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="publisherName")
    def publisher_name(self) -> builtins.str:
        return jsii.get(self, "publisherName")

    @publisher_name.setter # type: ignore
    def publisher_name(self, value: builtins.str) -> None:
        jsii.set(self, "publisherName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="security")
    def security(self) -> typing.List["ApiManagementSecurity"]:
        return jsii.get(self, "security")

    @security.setter # type: ignore
    def security(self, value: typing.List["ApiManagementSecurity"]) -> None:
        jsii.set(self, "security", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="signIn")
    def sign_in(self) -> typing.List["ApiManagementSignIn"]:
        return jsii.get(self, "signIn")

    @sign_in.setter # type: ignore
    def sign_in(self, value: typing.List["ApiManagementSignIn"]) -> None:
        jsii.set(self, "signIn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="signUp")
    def sign_up(self) -> typing.List["ApiManagementSignUp"]:
        return jsii.get(self, "signUp")

    @sign_up.setter # type: ignore
    def sign_up(self, value: typing.List["ApiManagementSignUp"]) -> None:
        jsii.set(self, "signUp", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="skuName")
    def sku_name(self) -> builtins.str:
        return jsii.get(self, "skuName")

    @sku_name.setter # type: ignore
    def sku_name(self, value: builtins.str) -> None:
        jsii.set(self, "skuName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="virtualNetworkConfiguration")
    def virtual_network_configuration(
        self,
    ) -> typing.List["ApiManagementVirtualNetworkConfiguration"]:
        return jsii.get(self, "virtualNetworkConfiguration")

    @virtual_network_configuration.setter # type: ignore
    def virtual_network_configuration(
        self,
        value: typing.List["ApiManagementVirtualNetworkConfiguration"],
    ) -> None:
        jsii.set(self, "virtualNetworkConfiguration", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="virtualNetworkType")
    def virtual_network_type(self) -> builtins.str:
        return jsii.get(self, "virtualNetworkType")

    @virtual_network_type.setter # type: ignore
    def virtual_network_type(self, value: builtins.str) -> None:
        jsii.set(self, "virtualNetworkType", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementAdditionalLocation",
    jsii_struct_bases=[],
    name_mapping={
        "location": "location",
        "virtual_network_configuration": "virtualNetworkConfiguration",
    },
)
class ApiManagementAdditionalLocation:
    def __init__(
        self,
        *,
        location: builtins.str,
        virtual_network_configuration: typing.Optional[typing.List["ApiManagementAdditionalLocationVirtualNetworkConfiguration"]] = None,
    ) -> None:
        """
        :param location: -
        :param virtual_network_configuration: virtual_network_configuration block.
        """
        self._values: typing.Dict[str, typing.Any] = {
            "location": location,
        }
        if virtual_network_configuration is not None:
            self._values["virtual_network_configuration"] = virtual_network_configuration

    @builtins.property
    def location(self) -> builtins.str:
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def virtual_network_configuration(
        self,
    ) -> typing.Optional[typing.List["ApiManagementAdditionalLocationVirtualNetworkConfiguration"]]:
        """virtual_network_configuration block."""
        result = self._values.get("virtual_network_configuration")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementAdditionalLocation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementAdditionalLocationVirtualNetworkConfiguration",
    jsii_struct_bases=[],
    name_mapping={"subnet_id": "subnetId"},
)
class ApiManagementAdditionalLocationVirtualNetworkConfiguration:
    def __init__(self, *, subnet_id: builtins.str) -> None:
        """
        :param subnet_id: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "subnet_id": subnet_id,
        }

    @builtins.property
    def subnet_id(self) -> builtins.str:
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementAdditionalLocationVirtualNetworkConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementApi(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementApi",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        path: builtins.str,
        protocols: typing.List[builtins.str],
        resource_group_name: builtins.str,
        revision: builtins.str,
        description: typing.Optional[builtins.str] = None,
        import_: typing.Optional[typing.List["ApiManagementApiImport"]] = None,
        oauth2_authorization: typing.Optional[typing.List["ApiManagementApiOauth2Authorization"]] = None,
        openid_authentication: typing.Optional[typing.List["ApiManagementApiOpenidAuthentication"]] = None,
        service_url: typing.Optional[builtins.str] = None,
        soap_pass_through: typing.Optional[builtins.bool] = None,
        subscription_key_parameter_names: typing.Optional[typing.List["ApiManagementApiSubscriptionKeyParameterNames"]] = None,
        subscription_required: typing.Optional[builtins.bool] = None,
        timeouts: typing.Optional["ApiManagementApiTimeouts"] = None,
        version: typing.Optional[builtins.str] = None,
        version_set_id: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param path: -
        :param protocols: -
        :param resource_group_name: -
        :param revision: -
        :param description: -
        :param import_: import block.
        :param oauth2_authorization: oauth2_authorization block.
        :param openid_authentication: openid_authentication block.
        :param service_url: -
        :param soap_pass_through: -
        :param subscription_key_parameter_names: subscription_key_parameter_names block.
        :param subscription_required: -
        :param timeouts: timeouts block.
        :param version: -
        :param version_set_id: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementApiConfig(
            api_management_name=api_management_name,
            display_name=display_name,
            name=name,
            path=path,
            protocols=protocols,
            resource_group_name=resource_group_name,
            revision=revision,
            description=description,
            import_=import_,
            oauth2_authorization=oauth2_authorization,
            openid_authentication=openid_authentication,
            service_url=service_url,
            soap_pass_through=soap_pass_through,
            subscription_key_parameter_names=subscription_key_parameter_names,
            subscription_required=subscription_required,
            timeouts=timeouts,
            version=version,
            version_set_id=version_set_id,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementApi, self, [scope, id, config])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return jsii.invoke(self, "resetDescription", [])

    @jsii.member(jsii_name="resetImport")
    def reset_import(self) -> None:
        return jsii.invoke(self, "resetImport", [])

    @jsii.member(jsii_name="resetOauth2Authorization")
    def reset_oauth2_authorization(self) -> None:
        return jsii.invoke(self, "resetOauth2Authorization", [])

    @jsii.member(jsii_name="resetOpenidAuthentication")
    def reset_openid_authentication(self) -> None:
        return jsii.invoke(self, "resetOpenidAuthentication", [])

    @jsii.member(jsii_name="resetServiceUrl")
    def reset_service_url(self) -> None:
        return jsii.invoke(self, "resetServiceUrl", [])

    @jsii.member(jsii_name="resetSoapPassThrough")
    def reset_soap_pass_through(self) -> None:
        return jsii.invoke(self, "resetSoapPassThrough", [])

    @jsii.member(jsii_name="resetSubscriptionKeyParameterNames")
    def reset_subscription_key_parameter_names(self) -> None:
        return jsii.invoke(self, "resetSubscriptionKeyParameterNames", [])

    @jsii.member(jsii_name="resetSubscriptionRequired")
    def reset_subscription_required(self) -> None:
        return jsii.invoke(self, "resetSubscriptionRequired", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetVersion")
    def reset_version(self) -> None:
        return jsii.invoke(self, "resetVersion", [])

    @jsii.member(jsii_name="resetVersionSetId")
    def reset_version_set_id(self) -> None:
        return jsii.invoke(self, "resetVersionSetId", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="isCurrent")
    def is_current(self) -> builtins.bool:
        return jsii.get(self, "isCurrent")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="isOnline")
    def is_online(self) -> builtins.bool:
        return jsii.get(self, "isOnline")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="pathInput")
    def path_input(self) -> builtins.str:
        return jsii.get(self, "pathInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="protocolsInput")
    def protocols_input(self) -> typing.List[builtins.str]:
        return jsii.get(self, "protocolsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="revisionInput")
    def revision_input(self) -> builtins.str:
        return jsii.get(self, "revisionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "descriptionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="importInput")
    def import_input(self) -> typing.Optional[typing.List["ApiManagementApiImport"]]:
        return jsii.get(self, "importInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="oauth2AuthorizationInput")
    def oauth2_authorization_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOauth2Authorization"]]:
        return jsii.get(self, "oauth2AuthorizationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="openidAuthenticationInput")
    def openid_authentication_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOpenidAuthentication"]]:
        return jsii.get(self, "openidAuthenticationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serviceUrlInput")
    def service_url_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "serviceUrlInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="soapPassThroughInput")
    def soap_pass_through_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "soapPassThroughInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionKeyParameterNamesInput")
    def subscription_key_parameter_names_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiSubscriptionKeyParameterNames"]]:
        return jsii.get(self, "subscriptionKeyParameterNamesInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionRequiredInput")
    def subscription_required_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "subscriptionRequiredInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementApiTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="versionInput")
    def version_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "versionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="versionSetIdInput")
    def version_set_id_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "versionSetIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="import")
    def import_(self) -> typing.List["ApiManagementApiImport"]:
        return jsii.get(self, "import")

    @import_.setter # type: ignore
    def import_(self, value: typing.List["ApiManagementApiImport"]) -> None:
        jsii.set(self, "import", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="oauth2Authorization")
    def oauth2_authorization(
        self,
    ) -> typing.List["ApiManagementApiOauth2Authorization"]:
        return jsii.get(self, "oauth2Authorization")

    @oauth2_authorization.setter # type: ignore
    def oauth2_authorization(
        self,
        value: typing.List["ApiManagementApiOauth2Authorization"],
    ) -> None:
        jsii.set(self, "oauth2Authorization", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="openidAuthentication")
    def openid_authentication(
        self,
    ) -> typing.List["ApiManagementApiOpenidAuthentication"]:
        return jsii.get(self, "openidAuthentication")

    @openid_authentication.setter # type: ignore
    def openid_authentication(
        self,
        value: typing.List["ApiManagementApiOpenidAuthentication"],
    ) -> None:
        jsii.set(self, "openidAuthentication", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="path")
    def path(self) -> builtins.str:
        return jsii.get(self, "path")

    @path.setter # type: ignore
    def path(self, value: builtins.str) -> None:
        jsii.set(self, "path", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="protocols")
    def protocols(self) -> typing.List[builtins.str]:
        return jsii.get(self, "protocols")

    @protocols.setter # type: ignore
    def protocols(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "protocols", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="revision")
    def revision(self) -> builtins.str:
        return jsii.get(self, "revision")

    @revision.setter # type: ignore
    def revision(self, value: builtins.str) -> None:
        jsii.set(self, "revision", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serviceUrl")
    def service_url(self) -> builtins.str:
        return jsii.get(self, "serviceUrl")

    @service_url.setter # type: ignore
    def service_url(self, value: builtins.str) -> None:
        jsii.set(self, "serviceUrl", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="soapPassThrough")
    def soap_pass_through(self) -> builtins.bool:
        return jsii.get(self, "soapPassThrough")

    @soap_pass_through.setter # type: ignore
    def soap_pass_through(self, value: builtins.bool) -> None:
        jsii.set(self, "soapPassThrough", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionKeyParameterNames")
    def subscription_key_parameter_names(
        self,
    ) -> typing.List["ApiManagementApiSubscriptionKeyParameterNames"]:
        return jsii.get(self, "subscriptionKeyParameterNames")

    @subscription_key_parameter_names.setter # type: ignore
    def subscription_key_parameter_names(
        self,
        value: typing.List["ApiManagementApiSubscriptionKeyParameterNames"],
    ) -> None:
        jsii.set(self, "subscriptionKeyParameterNames", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionRequired")
    def subscription_required(self) -> builtins.bool:
        return jsii.get(self, "subscriptionRequired")

    @subscription_required.setter # type: ignore
    def subscription_required(self, value: builtins.bool) -> None:
        jsii.set(self, "subscriptionRequired", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementApiTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementApiTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="version")
    def version(self) -> builtins.str:
        return jsii.get(self, "version")

    @version.setter # type: ignore
    def version(self, value: builtins.str) -> None:
        jsii.set(self, "version", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="versionSetId")
    def version_set_id(self) -> builtins.str:
        return jsii.get(self, "versionSetId")

    @version_set_id.setter # type: ignore
    def version_set_id(self, value: builtins.str) -> None:
        jsii.set(self, "versionSetId", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "display_name": "displayName",
        "name": "name",
        "path": "path",
        "protocols": "protocols",
        "resource_group_name": "resourceGroupName",
        "revision": "revision",
        "description": "description",
        "import_": "import",
        "oauth2_authorization": "oauth2Authorization",
        "openid_authentication": "openidAuthentication",
        "service_url": "serviceUrl",
        "soap_pass_through": "soapPassThrough",
        "subscription_key_parameter_names": "subscriptionKeyParameterNames",
        "subscription_required": "subscriptionRequired",
        "timeouts": "timeouts",
        "version": "version",
        "version_set_id": "versionSetId",
    },
)
class ApiManagementApiConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        path: builtins.str,
        protocols: typing.List[builtins.str],
        resource_group_name: builtins.str,
        revision: builtins.str,
        description: typing.Optional[builtins.str] = None,
        import_: typing.Optional[typing.List["ApiManagementApiImport"]] = None,
        oauth2_authorization: typing.Optional[typing.List["ApiManagementApiOauth2Authorization"]] = None,
        openid_authentication: typing.Optional[typing.List["ApiManagementApiOpenidAuthentication"]] = None,
        service_url: typing.Optional[builtins.str] = None,
        soap_pass_through: typing.Optional[builtins.bool] = None,
        subscription_key_parameter_names: typing.Optional[typing.List["ApiManagementApiSubscriptionKeyParameterNames"]] = None,
        subscription_required: typing.Optional[builtins.bool] = None,
        timeouts: typing.Optional["ApiManagementApiTimeouts"] = None,
        version: typing.Optional[builtins.str] = None,
        version_set_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param path: -
        :param protocols: -
        :param resource_group_name: -
        :param revision: -
        :param description: -
        :param import_: import block.
        :param oauth2_authorization: oauth2_authorization block.
        :param openid_authentication: openid_authentication block.
        :param service_url: -
        :param soap_pass_through: -
        :param subscription_key_parameter_names: subscription_key_parameter_names block.
        :param subscription_required: -
        :param timeouts: timeouts block.
        :param version: -
        :param version_set_id: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementApiTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "display_name": display_name,
            "name": name,
            "path": path,
            "protocols": protocols,
            "resource_group_name": resource_group_name,
            "revision": revision,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if import_ is not None:
            self._values["import_"] = import_
        if oauth2_authorization is not None:
            self._values["oauth2_authorization"] = oauth2_authorization
        if openid_authentication is not None:
            self._values["openid_authentication"] = openid_authentication
        if service_url is not None:
            self._values["service_url"] = service_url
        if soap_pass_through is not None:
            self._values["soap_pass_through"] = soap_pass_through
        if subscription_key_parameter_names is not None:
            self._values["subscription_key_parameter_names"] = subscription_key_parameter_names
        if subscription_required is not None:
            self._values["subscription_required"] = subscription_required
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if version is not None:
            self._values["version"] = version
        if version_set_id is not None:
            self._values["version_set_id"] = version_set_id

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def path(self) -> builtins.str:
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return result

    @builtins.property
    def protocols(self) -> typing.List[builtins.str]:
        result = self._values.get("protocols")
        assert result is not None, "Required property 'protocols' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def revision(self) -> builtins.str:
        result = self._values.get("revision")
        assert result is not None, "Required property 'revision' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def import_(self) -> typing.Optional[typing.List["ApiManagementApiImport"]]:
        """import block."""
        result = self._values.get("import_")
        return result

    @builtins.property
    def oauth2_authorization(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOauth2Authorization"]]:
        """oauth2_authorization block."""
        result = self._values.get("oauth2_authorization")
        return result

    @builtins.property
    def openid_authentication(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOpenidAuthentication"]]:
        """openid_authentication block."""
        result = self._values.get("openid_authentication")
        return result

    @builtins.property
    def service_url(self) -> typing.Optional[builtins.str]:
        result = self._values.get("service_url")
        return result

    @builtins.property
    def soap_pass_through(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("soap_pass_through")
        return result

    @builtins.property
    def subscription_key_parameter_names(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiSubscriptionKeyParameterNames"]]:
        """subscription_key_parameter_names block."""
        result = self._values.get("subscription_key_parameter_names")
        return result

    @builtins.property
    def subscription_required(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("subscription_required")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementApiTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("version")
        return result

    @builtins.property
    def version_set_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("version_set_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementApiDiagnostic(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementApiDiagnostic",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_logger_id: builtins.str,
        api_management_name: builtins.str,
        api_name: builtins.str,
        identifier: builtins.str,
        resource_group_name: builtins.str,
        always_log_errors: typing.Optional[builtins.bool] = None,
        backend_request: typing.Optional[typing.List["ApiManagementApiDiagnosticBackendRequest"]] = None,
        backend_response: typing.Optional[typing.List["ApiManagementApiDiagnosticBackendResponse"]] = None,
        frontend_request: typing.Optional[typing.List["ApiManagementApiDiagnosticFrontendRequest"]] = None,
        frontend_response: typing.Optional[typing.List["ApiManagementApiDiagnosticFrontendResponse"]] = None,
        http_correlation_protocol: typing.Optional[builtins.str] = None,
        log_client_ip: typing.Optional[builtins.bool] = None,
        timeouts: typing.Optional["ApiManagementApiDiagnosticTimeouts"] = None,
        verbosity: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_logger_id: -
        :param api_management_name: -
        :param api_name: -
        :param identifier: -
        :param resource_group_name: -
        :param always_log_errors: -
        :param backend_request: backend_request block.
        :param backend_response: backend_response block.
        :param frontend_request: frontend_request block.
        :param frontend_response: frontend_response block.
        :param http_correlation_protocol: -
        :param log_client_ip: -
        :param timeouts: timeouts block.
        :param verbosity: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementApiDiagnosticConfig(
            api_management_logger_id=api_management_logger_id,
            api_management_name=api_management_name,
            api_name=api_name,
            identifier=identifier,
            resource_group_name=resource_group_name,
            always_log_errors=always_log_errors,
            backend_request=backend_request,
            backend_response=backend_response,
            frontend_request=frontend_request,
            frontend_response=frontend_response,
            http_correlation_protocol=http_correlation_protocol,
            log_client_ip=log_client_ip,
            timeouts=timeouts,
            verbosity=verbosity,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementApiDiagnostic, self, [scope, id, config])

    @jsii.member(jsii_name="resetAlwaysLogErrors")
    def reset_always_log_errors(self) -> None:
        return jsii.invoke(self, "resetAlwaysLogErrors", [])

    @jsii.member(jsii_name="resetBackendRequest")
    def reset_backend_request(self) -> None:
        return jsii.invoke(self, "resetBackendRequest", [])

    @jsii.member(jsii_name="resetBackendResponse")
    def reset_backend_response(self) -> None:
        return jsii.invoke(self, "resetBackendResponse", [])

    @jsii.member(jsii_name="resetFrontendRequest")
    def reset_frontend_request(self) -> None:
        return jsii.invoke(self, "resetFrontendRequest", [])

    @jsii.member(jsii_name="resetFrontendResponse")
    def reset_frontend_response(self) -> None:
        return jsii.invoke(self, "resetFrontendResponse", [])

    @jsii.member(jsii_name="resetHttpCorrelationProtocol")
    def reset_http_correlation_protocol(self) -> None:
        return jsii.invoke(self, "resetHttpCorrelationProtocol", [])

    @jsii.member(jsii_name="resetLogClientIp")
    def reset_log_client_ip(self) -> None:
        return jsii.invoke(self, "resetLogClientIp", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetVerbosity")
    def reset_verbosity(self) -> None:
        return jsii.invoke(self, "resetVerbosity", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementLoggerIdInput")
    def api_management_logger_id_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementLoggerIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiNameInput")
    def api_name_input(self) -> builtins.str:
        return jsii.get(self, "apiNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identifierInput")
    def identifier_input(self) -> builtins.str:
        return jsii.get(self, "identifierInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="alwaysLogErrorsInput")
    def always_log_errors_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "alwaysLogErrorsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="backendRequestInput")
    def backend_request_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiDiagnosticBackendRequest"]]:
        return jsii.get(self, "backendRequestInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="backendResponseInput")
    def backend_response_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiDiagnosticBackendResponse"]]:
        return jsii.get(self, "backendResponseInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="frontendRequestInput")
    def frontend_request_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiDiagnosticFrontendRequest"]]:
        return jsii.get(self, "frontendRequestInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="frontendResponseInput")
    def frontend_response_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiDiagnosticFrontendResponse"]]:
        return jsii.get(self, "frontendResponseInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="httpCorrelationProtocolInput")
    def http_correlation_protocol_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "httpCorrelationProtocolInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logClientIpInput")
    def log_client_ip_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "logClientIpInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementApiDiagnosticTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="verbosityInput")
    def verbosity_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "verbosityInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="alwaysLogErrors")
    def always_log_errors(self) -> builtins.bool:
        return jsii.get(self, "alwaysLogErrors")

    @always_log_errors.setter # type: ignore
    def always_log_errors(self, value: builtins.bool) -> None:
        jsii.set(self, "alwaysLogErrors", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementLoggerId")
    def api_management_logger_id(self) -> builtins.str:
        return jsii.get(self, "apiManagementLoggerId")

    @api_management_logger_id.setter # type: ignore
    def api_management_logger_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementLoggerId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiName")
    def api_name(self) -> builtins.str:
        return jsii.get(self, "apiName")

    @api_name.setter # type: ignore
    def api_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="backendRequest")
    def backend_request(
        self,
    ) -> typing.List["ApiManagementApiDiagnosticBackendRequest"]:
        return jsii.get(self, "backendRequest")

    @backend_request.setter # type: ignore
    def backend_request(
        self,
        value: typing.List["ApiManagementApiDiagnosticBackendRequest"],
    ) -> None:
        jsii.set(self, "backendRequest", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="backendResponse")
    def backend_response(
        self,
    ) -> typing.List["ApiManagementApiDiagnosticBackendResponse"]:
        return jsii.get(self, "backendResponse")

    @backend_response.setter # type: ignore
    def backend_response(
        self,
        value: typing.List["ApiManagementApiDiagnosticBackendResponse"],
    ) -> None:
        jsii.set(self, "backendResponse", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="frontendRequest")
    def frontend_request(
        self,
    ) -> typing.List["ApiManagementApiDiagnosticFrontendRequest"]:
        return jsii.get(self, "frontendRequest")

    @frontend_request.setter # type: ignore
    def frontend_request(
        self,
        value: typing.List["ApiManagementApiDiagnosticFrontendRequest"],
    ) -> None:
        jsii.set(self, "frontendRequest", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="frontendResponse")
    def frontend_response(
        self,
    ) -> typing.List["ApiManagementApiDiagnosticFrontendResponse"]:
        return jsii.get(self, "frontendResponse")

    @frontend_response.setter # type: ignore
    def frontend_response(
        self,
        value: typing.List["ApiManagementApiDiagnosticFrontendResponse"],
    ) -> None:
        jsii.set(self, "frontendResponse", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="httpCorrelationProtocol")
    def http_correlation_protocol(self) -> builtins.str:
        return jsii.get(self, "httpCorrelationProtocol")

    @http_correlation_protocol.setter # type: ignore
    def http_correlation_protocol(self, value: builtins.str) -> None:
        jsii.set(self, "httpCorrelationProtocol", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identifier")
    def identifier(self) -> builtins.str:
        return jsii.get(self, "identifier")

    @identifier.setter # type: ignore
    def identifier(self, value: builtins.str) -> None:
        jsii.set(self, "identifier", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logClientIp")
    def log_client_ip(self) -> builtins.bool:
        return jsii.get(self, "logClientIp")

    @log_client_ip.setter # type: ignore
    def log_client_ip(self, value: builtins.bool) -> None:
        jsii.set(self, "logClientIp", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementApiDiagnosticTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementApiDiagnosticTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="verbosity")
    def verbosity(self) -> builtins.str:
        return jsii.get(self, "verbosity")

    @verbosity.setter # type: ignore
    def verbosity(self, value: builtins.str) -> None:
        jsii.set(self, "verbosity", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiDiagnosticBackendRequest",
    jsii_struct_bases=[],
    name_mapping={"body_bytes": "bodyBytes", "headers_to_log": "headersToLog"},
)
class ApiManagementApiDiagnosticBackendRequest:
    def __init__(
        self,
        *,
        body_bytes: typing.Optional[jsii.Number] = None,
        headers_to_log: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param body_bytes: -
        :param headers_to_log: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if body_bytes is not None:
            self._values["body_bytes"] = body_bytes
        if headers_to_log is not None:
            self._values["headers_to_log"] = headers_to_log

    @builtins.property
    def body_bytes(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("body_bytes")
        return result

    @builtins.property
    def headers_to_log(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("headers_to_log")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiDiagnosticBackendRequest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiDiagnosticBackendResponse",
    jsii_struct_bases=[],
    name_mapping={"body_bytes": "bodyBytes", "headers_to_log": "headersToLog"},
)
class ApiManagementApiDiagnosticBackendResponse:
    def __init__(
        self,
        *,
        body_bytes: typing.Optional[jsii.Number] = None,
        headers_to_log: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param body_bytes: -
        :param headers_to_log: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if body_bytes is not None:
            self._values["body_bytes"] = body_bytes
        if headers_to_log is not None:
            self._values["headers_to_log"] = headers_to_log

    @builtins.property
    def body_bytes(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("body_bytes")
        return result

    @builtins.property
    def headers_to_log(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("headers_to_log")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiDiagnosticBackendResponse(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiDiagnosticConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_logger_id": "apiManagementLoggerId",
        "api_management_name": "apiManagementName",
        "api_name": "apiName",
        "identifier": "identifier",
        "resource_group_name": "resourceGroupName",
        "always_log_errors": "alwaysLogErrors",
        "backend_request": "backendRequest",
        "backend_response": "backendResponse",
        "frontend_request": "frontendRequest",
        "frontend_response": "frontendResponse",
        "http_correlation_protocol": "httpCorrelationProtocol",
        "log_client_ip": "logClientIp",
        "timeouts": "timeouts",
        "verbosity": "verbosity",
    },
)
class ApiManagementApiDiagnosticConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_logger_id: builtins.str,
        api_management_name: builtins.str,
        api_name: builtins.str,
        identifier: builtins.str,
        resource_group_name: builtins.str,
        always_log_errors: typing.Optional[builtins.bool] = None,
        backend_request: typing.Optional[typing.List[ApiManagementApiDiagnosticBackendRequest]] = None,
        backend_response: typing.Optional[typing.List[ApiManagementApiDiagnosticBackendResponse]] = None,
        frontend_request: typing.Optional[typing.List["ApiManagementApiDiagnosticFrontendRequest"]] = None,
        frontend_response: typing.Optional[typing.List["ApiManagementApiDiagnosticFrontendResponse"]] = None,
        http_correlation_protocol: typing.Optional[builtins.str] = None,
        log_client_ip: typing.Optional[builtins.bool] = None,
        timeouts: typing.Optional["ApiManagementApiDiagnosticTimeouts"] = None,
        verbosity: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_logger_id: -
        :param api_management_name: -
        :param api_name: -
        :param identifier: -
        :param resource_group_name: -
        :param always_log_errors: -
        :param backend_request: backend_request block.
        :param backend_response: backend_response block.
        :param frontend_request: frontend_request block.
        :param frontend_response: frontend_response block.
        :param http_correlation_protocol: -
        :param log_client_ip: -
        :param timeouts: timeouts block.
        :param verbosity: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementApiDiagnosticTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_logger_id": api_management_logger_id,
            "api_management_name": api_management_name,
            "api_name": api_name,
            "identifier": identifier,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if always_log_errors is not None:
            self._values["always_log_errors"] = always_log_errors
        if backend_request is not None:
            self._values["backend_request"] = backend_request
        if backend_response is not None:
            self._values["backend_response"] = backend_response
        if frontend_request is not None:
            self._values["frontend_request"] = frontend_request
        if frontend_response is not None:
            self._values["frontend_response"] = frontend_response
        if http_correlation_protocol is not None:
            self._values["http_correlation_protocol"] = http_correlation_protocol
        if log_client_ip is not None:
            self._values["log_client_ip"] = log_client_ip
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if verbosity is not None:
            self._values["verbosity"] = verbosity

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_logger_id(self) -> builtins.str:
        result = self._values.get("api_management_logger_id")
        assert result is not None, "Required property 'api_management_logger_id' is missing"
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def api_name(self) -> builtins.str:
        result = self._values.get("api_name")
        assert result is not None, "Required property 'api_name' is missing"
        return result

    @builtins.property
    def identifier(self) -> builtins.str:
        result = self._values.get("identifier")
        assert result is not None, "Required property 'identifier' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def always_log_errors(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("always_log_errors")
        return result

    @builtins.property
    def backend_request(
        self,
    ) -> typing.Optional[typing.List[ApiManagementApiDiagnosticBackendRequest]]:
        """backend_request block."""
        result = self._values.get("backend_request")
        return result

    @builtins.property
    def backend_response(
        self,
    ) -> typing.Optional[typing.List[ApiManagementApiDiagnosticBackendResponse]]:
        """backend_response block."""
        result = self._values.get("backend_response")
        return result

    @builtins.property
    def frontend_request(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiDiagnosticFrontendRequest"]]:
        """frontend_request block."""
        result = self._values.get("frontend_request")
        return result

    @builtins.property
    def frontend_response(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiDiagnosticFrontendResponse"]]:
        """frontend_response block."""
        result = self._values.get("frontend_response")
        return result

    @builtins.property
    def http_correlation_protocol(self) -> typing.Optional[builtins.str]:
        result = self._values.get("http_correlation_protocol")
        return result

    @builtins.property
    def log_client_ip(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("log_client_ip")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementApiDiagnosticTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def verbosity(self) -> typing.Optional[builtins.str]:
        result = self._values.get("verbosity")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiDiagnosticConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiDiagnosticFrontendRequest",
    jsii_struct_bases=[],
    name_mapping={"body_bytes": "bodyBytes", "headers_to_log": "headersToLog"},
)
class ApiManagementApiDiagnosticFrontendRequest:
    def __init__(
        self,
        *,
        body_bytes: typing.Optional[jsii.Number] = None,
        headers_to_log: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param body_bytes: -
        :param headers_to_log: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if body_bytes is not None:
            self._values["body_bytes"] = body_bytes
        if headers_to_log is not None:
            self._values["headers_to_log"] = headers_to_log

    @builtins.property
    def body_bytes(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("body_bytes")
        return result

    @builtins.property
    def headers_to_log(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("headers_to_log")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiDiagnosticFrontendRequest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiDiagnosticFrontendResponse",
    jsii_struct_bases=[],
    name_mapping={"body_bytes": "bodyBytes", "headers_to_log": "headersToLog"},
)
class ApiManagementApiDiagnosticFrontendResponse:
    def __init__(
        self,
        *,
        body_bytes: typing.Optional[jsii.Number] = None,
        headers_to_log: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param body_bytes: -
        :param headers_to_log: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if body_bytes is not None:
            self._values["body_bytes"] = body_bytes
        if headers_to_log is not None:
            self._values["headers_to_log"] = headers_to_log

    @builtins.property
    def body_bytes(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("body_bytes")
        return result

    @builtins.property
    def headers_to_log(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("headers_to_log")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiDiagnosticFrontendResponse(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiDiagnosticTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementApiDiagnosticTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiDiagnosticTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiImport",
    jsii_struct_bases=[],
    name_mapping={
        "content_format": "contentFormat",
        "content_value": "contentValue",
        "wsdl_selector": "wsdlSelector",
    },
)
class ApiManagementApiImport:
    def __init__(
        self,
        *,
        content_format: builtins.str,
        content_value: builtins.str,
        wsdl_selector: typing.Optional[typing.List["ApiManagementApiImportWsdlSelector"]] = None,
    ) -> None:
        """
        :param content_format: -
        :param content_value: -
        :param wsdl_selector: wsdl_selector block.
        """
        self._values: typing.Dict[str, typing.Any] = {
            "content_format": content_format,
            "content_value": content_value,
        }
        if wsdl_selector is not None:
            self._values["wsdl_selector"] = wsdl_selector

    @builtins.property
    def content_format(self) -> builtins.str:
        result = self._values.get("content_format")
        assert result is not None, "Required property 'content_format' is missing"
        return result

    @builtins.property
    def content_value(self) -> builtins.str:
        result = self._values.get("content_value")
        assert result is not None, "Required property 'content_value' is missing"
        return result

    @builtins.property
    def wsdl_selector(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiImportWsdlSelector"]]:
        """wsdl_selector block."""
        result = self._values.get("wsdl_selector")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiImport(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiImportWsdlSelector",
    jsii_struct_bases=[],
    name_mapping={"endpoint_name": "endpointName", "service_name": "serviceName"},
)
class ApiManagementApiImportWsdlSelector:
    def __init__(
        self,
        *,
        endpoint_name: builtins.str,
        service_name: builtins.str,
    ) -> None:
        """
        :param endpoint_name: -
        :param service_name: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "endpoint_name": endpoint_name,
            "service_name": service_name,
        }

    @builtins.property
    def endpoint_name(self) -> builtins.str:
        result = self._values.get("endpoint_name")
        assert result is not None, "Required property 'endpoint_name' is missing"
        return result

    @builtins.property
    def service_name(self) -> builtins.str:
        result = self._values.get("service_name")
        assert result is not None, "Required property 'service_name' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiImportWsdlSelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOauth2Authorization",
    jsii_struct_bases=[],
    name_mapping={
        "authorization_server_name": "authorizationServerName",
        "scope": "scope",
    },
)
class ApiManagementApiOauth2Authorization:
    def __init__(
        self,
        *,
        authorization_server_name: builtins.str,
        scope: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param authorization_server_name: -
        :param scope: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "authorization_server_name": authorization_server_name,
        }
        if scope is not None:
            self._values["scope"] = scope

    @builtins.property
    def authorization_server_name(self) -> builtins.str:
        result = self._values.get("authorization_server_name")
        assert result is not None, "Required property 'authorization_server_name' is missing"
        return result

    @builtins.property
    def scope(self) -> typing.Optional[builtins.str]:
        result = self._values.get("scope")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOauth2Authorization(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOpenidAuthentication",
    jsii_struct_bases=[],
    name_mapping={
        "openid_provider_name": "openidProviderName",
        "bearer_token_sending_methods": "bearerTokenSendingMethods",
    },
)
class ApiManagementApiOpenidAuthentication:
    def __init__(
        self,
        *,
        openid_provider_name: builtins.str,
        bearer_token_sending_methods: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param openid_provider_name: -
        :param bearer_token_sending_methods: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "openid_provider_name": openid_provider_name,
        }
        if bearer_token_sending_methods is not None:
            self._values["bearer_token_sending_methods"] = bearer_token_sending_methods

    @builtins.property
    def openid_provider_name(self) -> builtins.str:
        result = self._values.get("openid_provider_name")
        assert result is not None, "Required property 'openid_provider_name' is missing"
        return result

    @builtins.property
    def bearer_token_sending_methods(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("bearer_token_sending_methods")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOpenidAuthentication(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementApiOperation(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementApiOperation",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        api_name: builtins.str,
        display_name: builtins.str,
        method: builtins.str,
        operation_id: builtins.str,
        resource_group_name: builtins.str,
        url_template: builtins.str,
        description: typing.Optional[builtins.str] = None,
        request: typing.Optional[typing.List["ApiManagementApiOperationRequest"]] = None,
        response: typing.Optional[typing.List["ApiManagementApiOperationResponse"]] = None,
        template_parameter: typing.Optional[typing.List["ApiManagementApiOperationTemplateParameter"]] = None,
        timeouts: typing.Optional["ApiManagementApiOperationTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param api_name: -
        :param display_name: -
        :param method: -
        :param operation_id: -
        :param resource_group_name: -
        :param url_template: -
        :param description: -
        :param request: request block.
        :param response: response block.
        :param template_parameter: template_parameter block.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementApiOperationConfig(
            api_management_name=api_management_name,
            api_name=api_name,
            display_name=display_name,
            method=method,
            operation_id=operation_id,
            resource_group_name=resource_group_name,
            url_template=url_template,
            description=description,
            request=request,
            response=response,
            template_parameter=template_parameter,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementApiOperation, self, [scope, id, config])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return jsii.invoke(self, "resetDescription", [])

    @jsii.member(jsii_name="resetRequest")
    def reset_request(self) -> None:
        return jsii.invoke(self, "resetRequest", [])

    @jsii.member(jsii_name="resetResponse")
    def reset_response(self) -> None:
        return jsii.invoke(self, "resetResponse", [])

    @jsii.member(jsii_name="resetTemplateParameter")
    def reset_template_parameter(self) -> None:
        return jsii.invoke(self, "resetTemplateParameter", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiNameInput")
    def api_name_input(self) -> builtins.str:
        return jsii.get(self, "apiNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="methodInput")
    def method_input(self) -> builtins.str:
        return jsii.get(self, "methodInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="operationIdInput")
    def operation_id_input(self) -> builtins.str:
        return jsii.get(self, "operationIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="urlTemplateInput")
    def url_template_input(self) -> builtins.str:
        return jsii.get(self, "urlTemplateInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "descriptionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="requestInput")
    def request_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationRequest"]]:
        return jsii.get(self, "requestInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="responseInput")
    def response_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationResponse"]]:
        return jsii.get(self, "responseInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="templateParameterInput")
    def template_parameter_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationTemplateParameter"]]:
        return jsii.get(self, "templateParameterInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementApiOperationTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiName")
    def api_name(self) -> builtins.str:
        return jsii.get(self, "apiName")

    @api_name.setter # type: ignore
    def api_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="method")
    def method(self) -> builtins.str:
        return jsii.get(self, "method")

    @method.setter # type: ignore
    def method(self, value: builtins.str) -> None:
        jsii.set(self, "method", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="operationId")
    def operation_id(self) -> builtins.str:
        return jsii.get(self, "operationId")

    @operation_id.setter # type: ignore
    def operation_id(self, value: builtins.str) -> None:
        jsii.set(self, "operationId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="request")
    def request(self) -> typing.List["ApiManagementApiOperationRequest"]:
        return jsii.get(self, "request")

    @request.setter # type: ignore
    def request(self, value: typing.List["ApiManagementApiOperationRequest"]) -> None:
        jsii.set(self, "request", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="response")
    def response(self) -> typing.List["ApiManagementApiOperationResponse"]:
        return jsii.get(self, "response")

    @response.setter # type: ignore
    def response(self, value: typing.List["ApiManagementApiOperationResponse"]) -> None:
        jsii.set(self, "response", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="templateParameter")
    def template_parameter(
        self,
    ) -> typing.List["ApiManagementApiOperationTemplateParameter"]:
        return jsii.get(self, "templateParameter")

    @template_parameter.setter # type: ignore
    def template_parameter(
        self,
        value: typing.List["ApiManagementApiOperationTemplateParameter"],
    ) -> None:
        jsii.set(self, "templateParameter", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementApiOperationTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementApiOperationTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="urlTemplate")
    def url_template(self) -> builtins.str:
        return jsii.get(self, "urlTemplate")

    @url_template.setter # type: ignore
    def url_template(self, value: builtins.str) -> None:
        jsii.set(self, "urlTemplate", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "api_name": "apiName",
        "display_name": "displayName",
        "method": "method",
        "operation_id": "operationId",
        "resource_group_name": "resourceGroupName",
        "url_template": "urlTemplate",
        "description": "description",
        "request": "request",
        "response": "response",
        "template_parameter": "templateParameter",
        "timeouts": "timeouts",
    },
)
class ApiManagementApiOperationConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        api_name: builtins.str,
        display_name: builtins.str,
        method: builtins.str,
        operation_id: builtins.str,
        resource_group_name: builtins.str,
        url_template: builtins.str,
        description: typing.Optional[builtins.str] = None,
        request: typing.Optional[typing.List["ApiManagementApiOperationRequest"]] = None,
        response: typing.Optional[typing.List["ApiManagementApiOperationResponse"]] = None,
        template_parameter: typing.Optional[typing.List["ApiManagementApiOperationTemplateParameter"]] = None,
        timeouts: typing.Optional["ApiManagementApiOperationTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param api_name: -
        :param display_name: -
        :param method: -
        :param operation_id: -
        :param resource_group_name: -
        :param url_template: -
        :param description: -
        :param request: request block.
        :param response: response block.
        :param template_parameter: template_parameter block.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementApiOperationTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "api_name": api_name,
            "display_name": display_name,
            "method": method,
            "operation_id": operation_id,
            "resource_group_name": resource_group_name,
            "url_template": url_template,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if request is not None:
            self._values["request"] = request
        if response is not None:
            self._values["response"] = response
        if template_parameter is not None:
            self._values["template_parameter"] = template_parameter
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def api_name(self) -> builtins.str:
        result = self._values.get("api_name")
        assert result is not None, "Required property 'api_name' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def method(self) -> builtins.str:
        result = self._values.get("method")
        assert result is not None, "Required property 'method' is missing"
        return result

    @builtins.property
    def operation_id(self) -> builtins.str:
        result = self._values.get("operation_id")
        assert result is not None, "Required property 'operation_id' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def url_template(self) -> builtins.str:
        result = self._values.get("url_template")
        assert result is not None, "Required property 'url_template' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def request(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationRequest"]]:
        """request block."""
        result = self._values.get("request")
        return result

    @builtins.property
    def response(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationResponse"]]:
        """response block."""
        result = self._values.get("response")
        return result

    @builtins.property
    def template_parameter(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationTemplateParameter"]]:
        """template_parameter block."""
        result = self._values.get("template_parameter")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementApiOperationTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementApiOperationPolicy(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementApiOperationPolicy",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        api_name: builtins.str,
        operation_id: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementApiOperationPolicyTimeouts"] = None,
        xml_content: typing.Optional[builtins.str] = None,
        xml_link: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param api_name: -
        :param operation_id: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param xml_content: -
        :param xml_link: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementApiOperationPolicyConfig(
            api_management_name=api_management_name,
            api_name=api_name,
            operation_id=operation_id,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            xml_content=xml_content,
            xml_link=xml_link,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementApiOperationPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetXmlContent")
    def reset_xml_content(self) -> None:
        return jsii.invoke(self, "resetXmlContent", [])

    @jsii.member(jsii_name="resetXmlLink")
    def reset_xml_link(self) -> None:
        return jsii.invoke(self, "resetXmlLink", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiNameInput")
    def api_name_input(self) -> builtins.str:
        return jsii.get(self, "apiNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="operationIdInput")
    def operation_id_input(self) -> builtins.str:
        return jsii.get(self, "operationIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["ApiManagementApiOperationPolicyTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlContentInput")
    def xml_content_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "xmlContentInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlLinkInput")
    def xml_link_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "xmlLinkInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiName")
    def api_name(self) -> builtins.str:
        return jsii.get(self, "apiName")

    @api_name.setter # type: ignore
    def api_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="operationId")
    def operation_id(self) -> builtins.str:
        return jsii.get(self, "operationId")

    @operation_id.setter # type: ignore
    def operation_id(self, value: builtins.str) -> None:
        jsii.set(self, "operationId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementApiOperationPolicyTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementApiOperationPolicyTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlContent")
    def xml_content(self) -> builtins.str:
        return jsii.get(self, "xmlContent")

    @xml_content.setter # type: ignore
    def xml_content(self, value: builtins.str) -> None:
        jsii.set(self, "xmlContent", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlLink")
    def xml_link(self) -> builtins.str:
        return jsii.get(self, "xmlLink")

    @xml_link.setter # type: ignore
    def xml_link(self, value: builtins.str) -> None:
        jsii.set(self, "xmlLink", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationPolicyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "api_name": "apiName",
        "operation_id": "operationId",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
        "xml_content": "xmlContent",
        "xml_link": "xmlLink",
    },
)
class ApiManagementApiOperationPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        api_name: builtins.str,
        operation_id: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementApiOperationPolicyTimeouts"] = None,
        xml_content: typing.Optional[builtins.str] = None,
        xml_link: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param api_name: -
        :param operation_id: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param xml_content: -
        :param xml_link: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementApiOperationPolicyTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "api_name": api_name,
            "operation_id": operation_id,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if xml_content is not None:
            self._values["xml_content"] = xml_content
        if xml_link is not None:
            self._values["xml_link"] = xml_link

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def api_name(self) -> builtins.str:
        result = self._values.get("api_name")
        assert result is not None, "Required property 'api_name' is missing"
        return result

    @builtins.property
    def operation_id(self) -> builtins.str:
        result = self._values.get("operation_id")
        assert result is not None, "Required property 'operation_id' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementApiOperationPolicyTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def xml_content(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_content")
        return result

    @builtins.property
    def xml_link(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_link")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationPolicyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationPolicyTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementApiOperationPolicyTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationPolicyTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationRequest",
    jsii_struct_bases=[],
    name_mapping={
        "description": "description",
        "header": "header",
        "query_parameter": "queryParameter",
        "representation": "representation",
    },
)
class ApiManagementApiOperationRequest:
    def __init__(
        self,
        *,
        description: typing.Optional[builtins.str] = None,
        header: typing.Optional[typing.List["ApiManagementApiOperationRequestHeader"]] = None,
        query_parameter: typing.Optional[typing.List["ApiManagementApiOperationRequestQueryParameter"]] = None,
        representation: typing.Optional[typing.List["ApiManagementApiOperationRequestRepresentation"]] = None,
    ) -> None:
        """
        :param description: -
        :param header: header block.
        :param query_parameter: query_parameter block.
        :param representation: representation block.
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if description is not None:
            self._values["description"] = description
        if header is not None:
            self._values["header"] = header
        if query_parameter is not None:
            self._values["query_parameter"] = query_parameter
        if representation is not None:
            self._values["representation"] = representation

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def header(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationRequestHeader"]]:
        """header block."""
        result = self._values.get("header")
        return result

    @builtins.property
    def query_parameter(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationRequestQueryParameter"]]:
        """query_parameter block."""
        result = self._values.get("query_parameter")
        return result

    @builtins.property
    def representation(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationRequestRepresentation"]]:
        """representation block."""
        result = self._values.get("representation")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationRequest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationRequestHeader",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "required": "required",
        "type": "type",
        "default_value": "defaultValue",
        "description": "description",
        "values": "values",
    },
)
class ApiManagementApiOperationRequestHeader:
    def __init__(
        self,
        *,
        name: builtins.str,
        required: builtins.bool,
        type: builtins.str,
        default_value: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        values: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param name: -
        :param required: -
        :param type: -
        :param default_value: -
        :param description: -
        :param values: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "required": required,
            "type": type,
        }
        if default_value is not None:
            self._values["default_value"] = default_value
        if description is not None:
            self._values["description"] = description
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def required(self) -> builtins.bool:
        result = self._values.get("required")
        assert result is not None, "Required property 'required' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def default_value(self) -> typing.Optional[builtins.str]:
        result = self._values.get("default_value")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("values")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationRequestHeader(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationRequestQueryParameter",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "required": "required",
        "type": "type",
        "default_value": "defaultValue",
        "description": "description",
        "values": "values",
    },
)
class ApiManagementApiOperationRequestQueryParameter:
    def __init__(
        self,
        *,
        name: builtins.str,
        required: builtins.bool,
        type: builtins.str,
        default_value: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        values: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param name: -
        :param required: -
        :param type: -
        :param default_value: -
        :param description: -
        :param values: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "required": required,
            "type": type,
        }
        if default_value is not None:
            self._values["default_value"] = default_value
        if description is not None:
            self._values["description"] = description
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def required(self) -> builtins.bool:
        result = self._values.get("required")
        assert result is not None, "Required property 'required' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def default_value(self) -> typing.Optional[builtins.str]:
        result = self._values.get("default_value")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("values")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationRequestQueryParameter(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationRequestRepresentation",
    jsii_struct_bases=[],
    name_mapping={
        "content_type": "contentType",
        "form_parameter": "formParameter",
        "sample": "sample",
        "schema_id": "schemaId",
        "type_name": "typeName",
    },
)
class ApiManagementApiOperationRequestRepresentation:
    def __init__(
        self,
        *,
        content_type: builtins.str,
        form_parameter: typing.Optional[typing.List["ApiManagementApiOperationRequestRepresentationFormParameter"]] = None,
        sample: typing.Optional[builtins.str] = None,
        schema_id: typing.Optional[builtins.str] = None,
        type_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param content_type: -
        :param form_parameter: form_parameter block.
        :param sample: -
        :param schema_id: -
        :param type_name: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "content_type": content_type,
        }
        if form_parameter is not None:
            self._values["form_parameter"] = form_parameter
        if sample is not None:
            self._values["sample"] = sample
        if schema_id is not None:
            self._values["schema_id"] = schema_id
        if type_name is not None:
            self._values["type_name"] = type_name

    @builtins.property
    def content_type(self) -> builtins.str:
        result = self._values.get("content_type")
        assert result is not None, "Required property 'content_type' is missing"
        return result

    @builtins.property
    def form_parameter(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationRequestRepresentationFormParameter"]]:
        """form_parameter block."""
        result = self._values.get("form_parameter")
        return result

    @builtins.property
    def sample(self) -> typing.Optional[builtins.str]:
        result = self._values.get("sample")
        return result

    @builtins.property
    def schema_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("schema_id")
        return result

    @builtins.property
    def type_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("type_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationRequestRepresentation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationRequestRepresentationFormParameter",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "required": "required",
        "type": "type",
        "default_value": "defaultValue",
        "description": "description",
        "values": "values",
    },
)
class ApiManagementApiOperationRequestRepresentationFormParameter:
    def __init__(
        self,
        *,
        name: builtins.str,
        required: builtins.bool,
        type: builtins.str,
        default_value: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        values: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param name: -
        :param required: -
        :param type: -
        :param default_value: -
        :param description: -
        :param values: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "required": required,
            "type": type,
        }
        if default_value is not None:
            self._values["default_value"] = default_value
        if description is not None:
            self._values["description"] = description
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def required(self) -> builtins.bool:
        result = self._values.get("required")
        assert result is not None, "Required property 'required' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def default_value(self) -> typing.Optional[builtins.str]:
        result = self._values.get("default_value")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("values")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationRequestRepresentationFormParameter(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationResponse",
    jsii_struct_bases=[],
    name_mapping={
        "status_code": "statusCode",
        "description": "description",
        "header": "header",
        "representation": "representation",
    },
)
class ApiManagementApiOperationResponse:
    def __init__(
        self,
        *,
        status_code: jsii.Number,
        description: typing.Optional[builtins.str] = None,
        header: typing.Optional[typing.List["ApiManagementApiOperationResponseHeader"]] = None,
        representation: typing.Optional[typing.List["ApiManagementApiOperationResponseRepresentation"]] = None,
    ) -> None:
        """
        :param status_code: -
        :param description: -
        :param header: header block.
        :param representation: representation block.
        """
        self._values: typing.Dict[str, typing.Any] = {
            "status_code": status_code,
        }
        if description is not None:
            self._values["description"] = description
        if header is not None:
            self._values["header"] = header
        if representation is not None:
            self._values["representation"] = representation

    @builtins.property
    def status_code(self) -> jsii.Number:
        result = self._values.get("status_code")
        assert result is not None, "Required property 'status_code' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def header(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationResponseHeader"]]:
        """header block."""
        result = self._values.get("header")
        return result

    @builtins.property
    def representation(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationResponseRepresentation"]]:
        """representation block."""
        result = self._values.get("representation")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationResponse(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationResponseHeader",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "required": "required",
        "type": "type",
        "default_value": "defaultValue",
        "description": "description",
        "values": "values",
    },
)
class ApiManagementApiOperationResponseHeader:
    def __init__(
        self,
        *,
        name: builtins.str,
        required: builtins.bool,
        type: builtins.str,
        default_value: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        values: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param name: -
        :param required: -
        :param type: -
        :param default_value: -
        :param description: -
        :param values: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "required": required,
            "type": type,
        }
        if default_value is not None:
            self._values["default_value"] = default_value
        if description is not None:
            self._values["description"] = description
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def required(self) -> builtins.bool:
        result = self._values.get("required")
        assert result is not None, "Required property 'required' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def default_value(self) -> typing.Optional[builtins.str]:
        result = self._values.get("default_value")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("values")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationResponseHeader(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationResponseRepresentation",
    jsii_struct_bases=[],
    name_mapping={
        "content_type": "contentType",
        "form_parameter": "formParameter",
        "sample": "sample",
        "schema_id": "schemaId",
        "type_name": "typeName",
    },
)
class ApiManagementApiOperationResponseRepresentation:
    def __init__(
        self,
        *,
        content_type: builtins.str,
        form_parameter: typing.Optional[typing.List["ApiManagementApiOperationResponseRepresentationFormParameter"]] = None,
        sample: typing.Optional[builtins.str] = None,
        schema_id: typing.Optional[builtins.str] = None,
        type_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param content_type: -
        :param form_parameter: form_parameter block.
        :param sample: -
        :param schema_id: -
        :param type_name: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "content_type": content_type,
        }
        if form_parameter is not None:
            self._values["form_parameter"] = form_parameter
        if sample is not None:
            self._values["sample"] = sample
        if schema_id is not None:
            self._values["schema_id"] = schema_id
        if type_name is not None:
            self._values["type_name"] = type_name

    @builtins.property
    def content_type(self) -> builtins.str:
        result = self._values.get("content_type")
        assert result is not None, "Required property 'content_type' is missing"
        return result

    @builtins.property
    def form_parameter(
        self,
    ) -> typing.Optional[typing.List["ApiManagementApiOperationResponseRepresentationFormParameter"]]:
        """form_parameter block."""
        result = self._values.get("form_parameter")
        return result

    @builtins.property
    def sample(self) -> typing.Optional[builtins.str]:
        result = self._values.get("sample")
        return result

    @builtins.property
    def schema_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("schema_id")
        return result

    @builtins.property
    def type_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("type_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationResponseRepresentation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationResponseRepresentationFormParameter",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "required": "required",
        "type": "type",
        "default_value": "defaultValue",
        "description": "description",
        "values": "values",
    },
)
class ApiManagementApiOperationResponseRepresentationFormParameter:
    def __init__(
        self,
        *,
        name: builtins.str,
        required: builtins.bool,
        type: builtins.str,
        default_value: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        values: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param name: -
        :param required: -
        :param type: -
        :param default_value: -
        :param description: -
        :param values: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "required": required,
            "type": type,
        }
        if default_value is not None:
            self._values["default_value"] = default_value
        if description is not None:
            self._values["description"] = description
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def required(self) -> builtins.bool:
        result = self._values.get("required")
        assert result is not None, "Required property 'required' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def default_value(self) -> typing.Optional[builtins.str]:
        result = self._values.get("default_value")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("values")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationResponseRepresentationFormParameter(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationTemplateParameter",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "required": "required",
        "type": "type",
        "default_value": "defaultValue",
        "description": "description",
        "values": "values",
    },
)
class ApiManagementApiOperationTemplateParameter:
    def __init__(
        self,
        *,
        name: builtins.str,
        required: builtins.bool,
        type: builtins.str,
        default_value: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        values: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param name: -
        :param required: -
        :param type: -
        :param default_value: -
        :param description: -
        :param values: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "required": required,
            "type": type,
        }
        if default_value is not None:
            self._values["default_value"] = default_value
        if description is not None:
            self._values["description"] = description
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def required(self) -> builtins.bool:
        result = self._values.get("required")
        assert result is not None, "Required property 'required' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def default_value(self) -> typing.Optional[builtins.str]:
        result = self._values.get("default_value")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("values")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationTemplateParameter(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiOperationTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementApiOperationTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiOperationTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementApiPolicy(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementApiPolicy",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        api_name: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementApiPolicyTimeouts"] = None,
        xml_content: typing.Optional[builtins.str] = None,
        xml_link: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param api_name: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param xml_content: -
        :param xml_link: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementApiPolicyConfig(
            api_management_name=api_management_name,
            api_name=api_name,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            xml_content=xml_content,
            xml_link=xml_link,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementApiPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetXmlContent")
    def reset_xml_content(self) -> None:
        return jsii.invoke(self, "resetXmlContent", [])

    @jsii.member(jsii_name="resetXmlLink")
    def reset_xml_link(self) -> None:
        return jsii.invoke(self, "resetXmlLink", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiNameInput")
    def api_name_input(self) -> builtins.str:
        return jsii.get(self, "apiNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementApiPolicyTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlContentInput")
    def xml_content_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "xmlContentInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlLinkInput")
    def xml_link_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "xmlLinkInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiName")
    def api_name(self) -> builtins.str:
        return jsii.get(self, "apiName")

    @api_name.setter # type: ignore
    def api_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementApiPolicyTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementApiPolicyTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlContent")
    def xml_content(self) -> builtins.str:
        return jsii.get(self, "xmlContent")

    @xml_content.setter # type: ignore
    def xml_content(self, value: builtins.str) -> None:
        jsii.set(self, "xmlContent", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlLink")
    def xml_link(self) -> builtins.str:
        return jsii.get(self, "xmlLink")

    @xml_link.setter # type: ignore
    def xml_link(self, value: builtins.str) -> None:
        jsii.set(self, "xmlLink", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiPolicyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "api_name": "apiName",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
        "xml_content": "xmlContent",
        "xml_link": "xmlLink",
    },
)
class ApiManagementApiPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        api_name: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementApiPolicyTimeouts"] = None,
        xml_content: typing.Optional[builtins.str] = None,
        xml_link: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param api_name: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param xml_content: -
        :param xml_link: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementApiPolicyTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "api_name": api_name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if xml_content is not None:
            self._values["xml_content"] = xml_content
        if xml_link is not None:
            self._values["xml_link"] = xml_link

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def api_name(self) -> builtins.str:
        result = self._values.get("api_name")
        assert result is not None, "Required property 'api_name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementApiPolicyTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def xml_content(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_content")
        return result

    @builtins.property
    def xml_link(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_link")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiPolicyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiPolicyTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementApiPolicyTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiPolicyTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementApiSchema(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementApiSchema",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        api_name: builtins.str,
        content_type: builtins.str,
        resource_group_name: builtins.str,
        schema_id: builtins.str,
        value: builtins.str,
        timeouts: typing.Optional["ApiManagementApiSchemaTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param api_name: -
        :param content_type: -
        :param resource_group_name: -
        :param schema_id: -
        :param value: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementApiSchemaConfig(
            api_management_name=api_management_name,
            api_name=api_name,
            content_type=content_type,
            resource_group_name=resource_group_name,
            schema_id=schema_id,
            value=value,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementApiSchema, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiNameInput")
    def api_name_input(self) -> builtins.str:
        return jsii.get(self, "apiNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="contentTypeInput")
    def content_type_input(self) -> builtins.str:
        return jsii.get(self, "contentTypeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="schemaIdInput")
    def schema_id_input(self) -> builtins.str:
        return jsii.get(self, "schemaIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="valueInput")
    def value_input(self) -> builtins.str:
        return jsii.get(self, "valueInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementApiSchemaTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiName")
    def api_name(self) -> builtins.str:
        return jsii.get(self, "apiName")

    @api_name.setter # type: ignore
    def api_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="contentType")
    def content_type(self) -> builtins.str:
        return jsii.get(self, "contentType")

    @content_type.setter # type: ignore
    def content_type(self, value: builtins.str) -> None:
        jsii.set(self, "contentType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="schemaId")
    def schema_id(self) -> builtins.str:
        return jsii.get(self, "schemaId")

    @schema_id.setter # type: ignore
    def schema_id(self, value: builtins.str) -> None:
        jsii.set(self, "schemaId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementApiSchemaTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementApiSchemaTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="value")
    def value(self) -> builtins.str:
        return jsii.get(self, "value")

    @value.setter # type: ignore
    def value(self, value: builtins.str) -> None:
        jsii.set(self, "value", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiSchemaConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "api_name": "apiName",
        "content_type": "contentType",
        "resource_group_name": "resourceGroupName",
        "schema_id": "schemaId",
        "value": "value",
        "timeouts": "timeouts",
    },
)
class ApiManagementApiSchemaConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        api_name: builtins.str,
        content_type: builtins.str,
        resource_group_name: builtins.str,
        schema_id: builtins.str,
        value: builtins.str,
        timeouts: typing.Optional["ApiManagementApiSchemaTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param api_name: -
        :param content_type: -
        :param resource_group_name: -
        :param schema_id: -
        :param value: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementApiSchemaTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "api_name": api_name,
            "content_type": content_type,
            "resource_group_name": resource_group_name,
            "schema_id": schema_id,
            "value": value,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def api_name(self) -> builtins.str:
        result = self._values.get("api_name")
        assert result is not None, "Required property 'api_name' is missing"
        return result

    @builtins.property
    def content_type(self) -> builtins.str:
        result = self._values.get("content_type")
        assert result is not None, "Required property 'content_type' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def schema_id(self) -> builtins.str:
        result = self._values.get("schema_id")
        assert result is not None, "Required property 'schema_id' is missing"
        return result

    @builtins.property
    def value(self) -> builtins.str:
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementApiSchemaTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiSchemaConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiSchemaTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementApiSchemaTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiSchemaTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiSubscriptionKeyParameterNames",
    jsii_struct_bases=[],
    name_mapping={"header": "header", "query": "query"},
)
class ApiManagementApiSubscriptionKeyParameterNames:
    def __init__(self, *, header: builtins.str, query: builtins.str) -> None:
        """
        :param header: -
        :param query: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "header": header,
            "query": query,
        }

    @builtins.property
    def header(self) -> builtins.str:
        result = self._values.get("header")
        assert result is not None, "Required property 'header' is missing"
        return result

    @builtins.property
    def query(self) -> builtins.str:
        result = self._values.get("query")
        assert result is not None, "Required property 'query' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiSubscriptionKeyParameterNames(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementApiTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementApiVersionSet(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementApiVersionSet",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        versioning_scheme: builtins.str,
        description: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementApiVersionSetTimeouts"] = None,
        version_header_name: typing.Optional[builtins.str] = None,
        version_query_name: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param resource_group_name: -
        :param versioning_scheme: -
        :param description: -
        :param timeouts: timeouts block.
        :param version_header_name: -
        :param version_query_name: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementApiVersionSetConfig(
            api_management_name=api_management_name,
            display_name=display_name,
            name=name,
            resource_group_name=resource_group_name,
            versioning_scheme=versioning_scheme,
            description=description,
            timeouts=timeouts,
            version_header_name=version_header_name,
            version_query_name=version_query_name,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementApiVersionSet, self, [scope, id, config])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return jsii.invoke(self, "resetDescription", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetVersionHeaderName")
    def reset_version_header_name(self) -> None:
        return jsii.invoke(self, "resetVersionHeaderName", [])

    @jsii.member(jsii_name="resetVersionQueryName")
    def reset_version_query_name(self) -> None:
        return jsii.invoke(self, "resetVersionQueryName", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="versioningSchemeInput")
    def versioning_scheme_input(self) -> builtins.str:
        return jsii.get(self, "versioningSchemeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "descriptionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementApiVersionSetTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="versionHeaderNameInput")
    def version_header_name_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "versionHeaderNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="versionQueryNameInput")
    def version_query_name_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "versionQueryNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementApiVersionSetTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementApiVersionSetTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="versionHeaderName")
    def version_header_name(self) -> builtins.str:
        return jsii.get(self, "versionHeaderName")

    @version_header_name.setter # type: ignore
    def version_header_name(self, value: builtins.str) -> None:
        jsii.set(self, "versionHeaderName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="versioningScheme")
    def versioning_scheme(self) -> builtins.str:
        return jsii.get(self, "versioningScheme")

    @versioning_scheme.setter # type: ignore
    def versioning_scheme(self, value: builtins.str) -> None:
        jsii.set(self, "versioningScheme", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="versionQueryName")
    def version_query_name(self) -> builtins.str:
        return jsii.get(self, "versionQueryName")

    @version_query_name.setter # type: ignore
    def version_query_name(self, value: builtins.str) -> None:
        jsii.set(self, "versionQueryName", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiVersionSetConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "display_name": "displayName",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "versioning_scheme": "versioningScheme",
        "description": "description",
        "timeouts": "timeouts",
        "version_header_name": "versionHeaderName",
        "version_query_name": "versionQueryName",
    },
)
class ApiManagementApiVersionSetConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        versioning_scheme: builtins.str,
        description: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementApiVersionSetTimeouts"] = None,
        version_header_name: typing.Optional[builtins.str] = None,
        version_query_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param resource_group_name: -
        :param versioning_scheme: -
        :param description: -
        :param timeouts: timeouts block.
        :param version_header_name: -
        :param version_query_name: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementApiVersionSetTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "display_name": display_name,
            "name": name,
            "resource_group_name": resource_group_name,
            "versioning_scheme": versioning_scheme,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if version_header_name is not None:
            self._values["version_header_name"] = version_header_name
        if version_query_name is not None:
            self._values["version_query_name"] = version_query_name

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def versioning_scheme(self) -> builtins.str:
        result = self._values.get("versioning_scheme")
        assert result is not None, "Required property 'versioning_scheme' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementApiVersionSetTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def version_header_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("version_header_name")
        return result

    @builtins.property
    def version_query_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("version_query_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiVersionSetConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementApiVersionSetTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementApiVersionSetTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementApiVersionSetTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementAuthorizationServer(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementAuthorizationServer",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        authorization_endpoint: builtins.str,
        authorization_methods: typing.List[builtins.str],
        client_id: builtins.str,
        client_registration_endpoint: builtins.str,
        display_name: builtins.str,
        grant_types: typing.List[builtins.str],
        name: builtins.str,
        resource_group_name: builtins.str,
        bearer_token_sending_methods: typing.Optional[typing.List[builtins.str]] = None,
        client_authentication_method: typing.Optional[typing.List[builtins.str]] = None,
        client_secret: typing.Optional[builtins.str] = None,
        default_scope: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        resource_owner_password: typing.Optional[builtins.str] = None,
        resource_owner_username: typing.Optional[builtins.str] = None,
        support_state: typing.Optional[builtins.bool] = None,
        timeouts: typing.Optional["ApiManagementAuthorizationServerTimeouts"] = None,
        token_body_parameter: typing.Optional[typing.List["ApiManagementAuthorizationServerTokenBodyParameter"]] = None,
        token_endpoint: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param authorization_endpoint: -
        :param authorization_methods: -
        :param client_id: -
        :param client_registration_endpoint: -
        :param display_name: -
        :param grant_types: -
        :param name: -
        :param resource_group_name: -
        :param bearer_token_sending_methods: -
        :param client_authentication_method: -
        :param client_secret: -
        :param default_scope: -
        :param description: -
        :param resource_owner_password: -
        :param resource_owner_username: -
        :param support_state: -
        :param timeouts: timeouts block.
        :param token_body_parameter: token_body_parameter block.
        :param token_endpoint: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementAuthorizationServerConfig(
            api_management_name=api_management_name,
            authorization_endpoint=authorization_endpoint,
            authorization_methods=authorization_methods,
            client_id=client_id,
            client_registration_endpoint=client_registration_endpoint,
            display_name=display_name,
            grant_types=grant_types,
            name=name,
            resource_group_name=resource_group_name,
            bearer_token_sending_methods=bearer_token_sending_methods,
            client_authentication_method=client_authentication_method,
            client_secret=client_secret,
            default_scope=default_scope,
            description=description,
            resource_owner_password=resource_owner_password,
            resource_owner_username=resource_owner_username,
            support_state=support_state,
            timeouts=timeouts,
            token_body_parameter=token_body_parameter,
            token_endpoint=token_endpoint,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementAuthorizationServer, self, [scope, id, config])

    @jsii.member(jsii_name="resetBearerTokenSendingMethods")
    def reset_bearer_token_sending_methods(self) -> None:
        return jsii.invoke(self, "resetBearerTokenSendingMethods", [])

    @jsii.member(jsii_name="resetClientAuthenticationMethod")
    def reset_client_authentication_method(self) -> None:
        return jsii.invoke(self, "resetClientAuthenticationMethod", [])

    @jsii.member(jsii_name="resetClientSecret")
    def reset_client_secret(self) -> None:
        return jsii.invoke(self, "resetClientSecret", [])

    @jsii.member(jsii_name="resetDefaultScope")
    def reset_default_scope(self) -> None:
        return jsii.invoke(self, "resetDefaultScope", [])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return jsii.invoke(self, "resetDescription", [])

    @jsii.member(jsii_name="resetResourceOwnerPassword")
    def reset_resource_owner_password(self) -> None:
        return jsii.invoke(self, "resetResourceOwnerPassword", [])

    @jsii.member(jsii_name="resetResourceOwnerUsername")
    def reset_resource_owner_username(self) -> None:
        return jsii.invoke(self, "resetResourceOwnerUsername", [])

    @jsii.member(jsii_name="resetSupportState")
    def reset_support_state(self) -> None:
        return jsii.invoke(self, "resetSupportState", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetTokenBodyParameter")
    def reset_token_body_parameter(self) -> None:
        return jsii.invoke(self, "resetTokenBodyParameter", [])

    @jsii.member(jsii_name="resetTokenEndpoint")
    def reset_token_endpoint(self) -> None:
        return jsii.invoke(self, "resetTokenEndpoint", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationEndpointInput")
    def authorization_endpoint_input(self) -> builtins.str:
        return jsii.get(self, "authorizationEndpointInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationMethodsInput")
    def authorization_methods_input(self) -> typing.List[builtins.str]:
        return jsii.get(self, "authorizationMethodsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientIdInput")
    def client_id_input(self) -> builtins.str:
        return jsii.get(self, "clientIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientRegistrationEndpointInput")
    def client_registration_endpoint_input(self) -> builtins.str:
        return jsii.get(self, "clientRegistrationEndpointInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="grantTypesInput")
    def grant_types_input(self) -> typing.List[builtins.str]:
        return jsii.get(self, "grantTypesInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="bearerTokenSendingMethodsInput")
    def bearer_token_sending_methods_input(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        return jsii.get(self, "bearerTokenSendingMethodsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientAuthenticationMethodInput")
    def client_authentication_method_input(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        return jsii.get(self, "clientAuthenticationMethodInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecretInput")
    def client_secret_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "clientSecretInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultScopeInput")
    def default_scope_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "defaultScopeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "descriptionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceOwnerPasswordInput")
    def resource_owner_password_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "resourceOwnerPasswordInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceOwnerUsernameInput")
    def resource_owner_username_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "resourceOwnerUsernameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="supportStateInput")
    def support_state_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "supportStateInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["ApiManagementAuthorizationServerTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tokenBodyParameterInput")
    def token_body_parameter_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementAuthorizationServerTokenBodyParameter"]]:
        return jsii.get(self, "tokenBodyParameterInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tokenEndpointInput")
    def token_endpoint_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "tokenEndpointInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationEndpoint")
    def authorization_endpoint(self) -> builtins.str:
        return jsii.get(self, "authorizationEndpoint")

    @authorization_endpoint.setter # type: ignore
    def authorization_endpoint(self, value: builtins.str) -> None:
        jsii.set(self, "authorizationEndpoint", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizationMethods")
    def authorization_methods(self) -> typing.List[builtins.str]:
        return jsii.get(self, "authorizationMethods")

    @authorization_methods.setter # type: ignore
    def authorization_methods(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "authorizationMethods", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="bearerTokenSendingMethods")
    def bearer_token_sending_methods(self) -> typing.List[builtins.str]:
        return jsii.get(self, "bearerTokenSendingMethods")

    @bearer_token_sending_methods.setter # type: ignore
    def bearer_token_sending_methods(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "bearerTokenSendingMethods", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientAuthenticationMethod")
    def client_authentication_method(self) -> typing.List[builtins.str]:
        return jsii.get(self, "clientAuthenticationMethod")

    @client_authentication_method.setter # type: ignore
    def client_authentication_method(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "clientAuthenticationMethod", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientId")
    def client_id(self) -> builtins.str:
        return jsii.get(self, "clientId")

    @client_id.setter # type: ignore
    def client_id(self, value: builtins.str) -> None:
        jsii.set(self, "clientId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientRegistrationEndpoint")
    def client_registration_endpoint(self) -> builtins.str:
        return jsii.get(self, "clientRegistrationEndpoint")

    @client_registration_endpoint.setter # type: ignore
    def client_registration_endpoint(self, value: builtins.str) -> None:
        jsii.set(self, "clientRegistrationEndpoint", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecret")
    def client_secret(self) -> builtins.str:
        return jsii.get(self, "clientSecret")

    @client_secret.setter # type: ignore
    def client_secret(self, value: builtins.str) -> None:
        jsii.set(self, "clientSecret", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultScope")
    def default_scope(self) -> builtins.str:
        return jsii.get(self, "defaultScope")

    @default_scope.setter # type: ignore
    def default_scope(self, value: builtins.str) -> None:
        jsii.set(self, "defaultScope", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="grantTypes")
    def grant_types(self) -> typing.List[builtins.str]:
        return jsii.get(self, "grantTypes")

    @grant_types.setter # type: ignore
    def grant_types(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "grantTypes", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceOwnerPassword")
    def resource_owner_password(self) -> builtins.str:
        return jsii.get(self, "resourceOwnerPassword")

    @resource_owner_password.setter # type: ignore
    def resource_owner_password(self, value: builtins.str) -> None:
        jsii.set(self, "resourceOwnerPassword", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceOwnerUsername")
    def resource_owner_username(self) -> builtins.str:
        return jsii.get(self, "resourceOwnerUsername")

    @resource_owner_username.setter # type: ignore
    def resource_owner_username(self, value: builtins.str) -> None:
        jsii.set(self, "resourceOwnerUsername", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="supportState")
    def support_state(self) -> builtins.bool:
        return jsii.get(self, "supportState")

    @support_state.setter # type: ignore
    def support_state(self, value: builtins.bool) -> None:
        jsii.set(self, "supportState", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementAuthorizationServerTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementAuthorizationServerTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tokenBodyParameter")
    def token_body_parameter(
        self,
    ) -> typing.List["ApiManagementAuthorizationServerTokenBodyParameter"]:
        return jsii.get(self, "tokenBodyParameter")

    @token_body_parameter.setter # type: ignore
    def token_body_parameter(
        self,
        value: typing.List["ApiManagementAuthorizationServerTokenBodyParameter"],
    ) -> None:
        jsii.set(self, "tokenBodyParameter", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tokenEndpoint")
    def token_endpoint(self) -> builtins.str:
        return jsii.get(self, "tokenEndpoint")

    @token_endpoint.setter # type: ignore
    def token_endpoint(self, value: builtins.str) -> None:
        jsii.set(self, "tokenEndpoint", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementAuthorizationServerConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "authorization_endpoint": "authorizationEndpoint",
        "authorization_methods": "authorizationMethods",
        "client_id": "clientId",
        "client_registration_endpoint": "clientRegistrationEndpoint",
        "display_name": "displayName",
        "grant_types": "grantTypes",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "bearer_token_sending_methods": "bearerTokenSendingMethods",
        "client_authentication_method": "clientAuthenticationMethod",
        "client_secret": "clientSecret",
        "default_scope": "defaultScope",
        "description": "description",
        "resource_owner_password": "resourceOwnerPassword",
        "resource_owner_username": "resourceOwnerUsername",
        "support_state": "supportState",
        "timeouts": "timeouts",
        "token_body_parameter": "tokenBodyParameter",
        "token_endpoint": "tokenEndpoint",
    },
)
class ApiManagementAuthorizationServerConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        authorization_endpoint: builtins.str,
        authorization_methods: typing.List[builtins.str],
        client_id: builtins.str,
        client_registration_endpoint: builtins.str,
        display_name: builtins.str,
        grant_types: typing.List[builtins.str],
        name: builtins.str,
        resource_group_name: builtins.str,
        bearer_token_sending_methods: typing.Optional[typing.List[builtins.str]] = None,
        client_authentication_method: typing.Optional[typing.List[builtins.str]] = None,
        client_secret: typing.Optional[builtins.str] = None,
        default_scope: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        resource_owner_password: typing.Optional[builtins.str] = None,
        resource_owner_username: typing.Optional[builtins.str] = None,
        support_state: typing.Optional[builtins.bool] = None,
        timeouts: typing.Optional["ApiManagementAuthorizationServerTimeouts"] = None,
        token_body_parameter: typing.Optional[typing.List["ApiManagementAuthorizationServerTokenBodyParameter"]] = None,
        token_endpoint: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param authorization_endpoint: -
        :param authorization_methods: -
        :param client_id: -
        :param client_registration_endpoint: -
        :param display_name: -
        :param grant_types: -
        :param name: -
        :param resource_group_name: -
        :param bearer_token_sending_methods: -
        :param client_authentication_method: -
        :param client_secret: -
        :param default_scope: -
        :param description: -
        :param resource_owner_password: -
        :param resource_owner_username: -
        :param support_state: -
        :param timeouts: timeouts block.
        :param token_body_parameter: token_body_parameter block.
        :param token_endpoint: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementAuthorizationServerTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "authorization_endpoint": authorization_endpoint,
            "authorization_methods": authorization_methods,
            "client_id": client_id,
            "client_registration_endpoint": client_registration_endpoint,
            "display_name": display_name,
            "grant_types": grant_types,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if bearer_token_sending_methods is not None:
            self._values["bearer_token_sending_methods"] = bearer_token_sending_methods
        if client_authentication_method is not None:
            self._values["client_authentication_method"] = client_authentication_method
        if client_secret is not None:
            self._values["client_secret"] = client_secret
        if default_scope is not None:
            self._values["default_scope"] = default_scope
        if description is not None:
            self._values["description"] = description
        if resource_owner_password is not None:
            self._values["resource_owner_password"] = resource_owner_password
        if resource_owner_username is not None:
            self._values["resource_owner_username"] = resource_owner_username
        if support_state is not None:
            self._values["support_state"] = support_state
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if token_body_parameter is not None:
            self._values["token_body_parameter"] = token_body_parameter
        if token_endpoint is not None:
            self._values["token_endpoint"] = token_endpoint

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def authorization_endpoint(self) -> builtins.str:
        result = self._values.get("authorization_endpoint")
        assert result is not None, "Required property 'authorization_endpoint' is missing"
        return result

    @builtins.property
    def authorization_methods(self) -> typing.List[builtins.str]:
        result = self._values.get("authorization_methods")
        assert result is not None, "Required property 'authorization_methods' is missing"
        return result

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def client_registration_endpoint(self) -> builtins.str:
        result = self._values.get("client_registration_endpoint")
        assert result is not None, "Required property 'client_registration_endpoint' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def grant_types(self) -> typing.List[builtins.str]:
        result = self._values.get("grant_types")
        assert result is not None, "Required property 'grant_types' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def bearer_token_sending_methods(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("bearer_token_sending_methods")
        return result

    @builtins.property
    def client_authentication_method(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("client_authentication_method")
        return result

    @builtins.property
    def client_secret(self) -> typing.Optional[builtins.str]:
        result = self._values.get("client_secret")
        return result

    @builtins.property
    def default_scope(self) -> typing.Optional[builtins.str]:
        result = self._values.get("default_scope")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def resource_owner_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("resource_owner_password")
        return result

    @builtins.property
    def resource_owner_username(self) -> typing.Optional[builtins.str]:
        result = self._values.get("resource_owner_username")
        return result

    @builtins.property
    def support_state(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("support_state")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementAuthorizationServerTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def token_body_parameter(
        self,
    ) -> typing.Optional[typing.List["ApiManagementAuthorizationServerTokenBodyParameter"]]:
        """token_body_parameter block."""
        result = self._values.get("token_body_parameter")
        return result

    @builtins.property
    def token_endpoint(self) -> typing.Optional[builtins.str]:
        result = self._values.get("token_endpoint")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementAuthorizationServerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementAuthorizationServerTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementAuthorizationServerTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementAuthorizationServerTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementAuthorizationServerTokenBodyParameter",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class ApiManagementAuthorizationServerTokenBodyParameter:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        """
        :param name: -
        :param value: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def value(self) -> builtins.str:
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementAuthorizationServerTokenBodyParameter(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementBackend(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementBackend",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        name: builtins.str,
        protocol: builtins.str,
        resource_group_name: builtins.str,
        url: builtins.str,
        credentials: typing.Optional[typing.List["ApiManagementBackendCredentials"]] = None,
        description: typing.Optional[builtins.str] = None,
        proxy: typing.Optional[typing.List["ApiManagementBackendProxy"]] = None,
        resource_id: typing.Optional[builtins.str] = None,
        service_fabric_cluster: typing.Optional[typing.List["ApiManagementBackendServiceFabricCluster"]] = None,
        timeouts: typing.Optional["ApiManagementBackendTimeouts"] = None,
        title: typing.Optional[builtins.str] = None,
        tls: typing.Optional[typing.List["ApiManagementBackendTls"]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param name: -
        :param protocol: -
        :param resource_group_name: -
        :param url: -
        :param credentials: credentials block.
        :param description: -
        :param proxy: proxy block.
        :param resource_id: -
        :param service_fabric_cluster: service_fabric_cluster block.
        :param timeouts: timeouts block.
        :param title: -
        :param tls: tls block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementBackendConfig(
            api_management_name=api_management_name,
            name=name,
            protocol=protocol,
            resource_group_name=resource_group_name,
            url=url,
            credentials=credentials,
            description=description,
            proxy=proxy,
            resource_id=resource_id,
            service_fabric_cluster=service_fabric_cluster,
            timeouts=timeouts,
            title=title,
            tls=tls,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementBackend, self, [scope, id, config])

    @jsii.member(jsii_name="resetCredentials")
    def reset_credentials(self) -> None:
        return jsii.invoke(self, "resetCredentials", [])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return jsii.invoke(self, "resetDescription", [])

    @jsii.member(jsii_name="resetProxy")
    def reset_proxy(self) -> None:
        return jsii.invoke(self, "resetProxy", [])

    @jsii.member(jsii_name="resetResourceId")
    def reset_resource_id(self) -> None:
        return jsii.invoke(self, "resetResourceId", [])

    @jsii.member(jsii_name="resetServiceFabricCluster")
    def reset_service_fabric_cluster(self) -> None:
        return jsii.invoke(self, "resetServiceFabricCluster", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetTitle")
    def reset_title(self) -> None:
        return jsii.invoke(self, "resetTitle", [])

    @jsii.member(jsii_name="resetTls")
    def reset_tls(self) -> None:
        return jsii.invoke(self, "resetTls", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="protocolInput")
    def protocol_input(self) -> builtins.str:
        return jsii.get(self, "protocolInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="urlInput")
    def url_input(self) -> builtins.str:
        return jsii.get(self, "urlInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="credentialsInput")
    def credentials_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementBackendCredentials"]]:
        return jsii.get(self, "credentialsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "descriptionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="proxyInput")
    def proxy_input(self) -> typing.Optional[typing.List["ApiManagementBackendProxy"]]:
        return jsii.get(self, "proxyInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceIdInput")
    def resource_id_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "resourceIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serviceFabricClusterInput")
    def service_fabric_cluster_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementBackendServiceFabricCluster"]]:
        return jsii.get(self, "serviceFabricClusterInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementBackendTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="titleInput")
    def title_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "titleInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tlsInput")
    def tls_input(self) -> typing.Optional[typing.List["ApiManagementBackendTls"]]:
        return jsii.get(self, "tlsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="credentials")
    def credentials(self) -> typing.List["ApiManagementBackendCredentials"]:
        return jsii.get(self, "credentials")

    @credentials.setter # type: ignore
    def credentials(
        self,
        value: typing.List["ApiManagementBackendCredentials"],
    ) -> None:
        jsii.set(self, "credentials", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="protocol")
    def protocol(self) -> builtins.str:
        return jsii.get(self, "protocol")

    @protocol.setter # type: ignore
    def protocol(self, value: builtins.str) -> None:
        jsii.set(self, "protocol", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="proxy")
    def proxy(self) -> typing.List["ApiManagementBackendProxy"]:
        return jsii.get(self, "proxy")

    @proxy.setter # type: ignore
    def proxy(self, value: typing.List["ApiManagementBackendProxy"]) -> None:
        jsii.set(self, "proxy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> builtins.str:
        return jsii.get(self, "resourceId")

    @resource_id.setter # type: ignore
    def resource_id(self, value: builtins.str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serviceFabricCluster")
    def service_fabric_cluster(
        self,
    ) -> typing.List["ApiManagementBackendServiceFabricCluster"]:
        return jsii.get(self, "serviceFabricCluster")

    @service_fabric_cluster.setter # type: ignore
    def service_fabric_cluster(
        self,
        value: typing.List["ApiManagementBackendServiceFabricCluster"],
    ) -> None:
        jsii.set(self, "serviceFabricCluster", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementBackendTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementBackendTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="title")
    def title(self) -> builtins.str:
        return jsii.get(self, "title")

    @title.setter # type: ignore
    def title(self, value: builtins.str) -> None:
        jsii.set(self, "title", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tls")
    def tls(self) -> typing.List["ApiManagementBackendTls"]:
        return jsii.get(self, "tls")

    @tls.setter # type: ignore
    def tls(self, value: typing.List["ApiManagementBackendTls"]) -> None:
        jsii.set(self, "tls", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="url")
    def url(self) -> builtins.str:
        return jsii.get(self, "url")

    @url.setter # type: ignore
    def url(self, value: builtins.str) -> None:
        jsii.set(self, "url", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementBackendConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "name": "name",
        "protocol": "protocol",
        "resource_group_name": "resourceGroupName",
        "url": "url",
        "credentials": "credentials",
        "description": "description",
        "proxy": "proxy",
        "resource_id": "resourceId",
        "service_fabric_cluster": "serviceFabricCluster",
        "timeouts": "timeouts",
        "title": "title",
        "tls": "tls",
    },
)
class ApiManagementBackendConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        name: builtins.str,
        protocol: builtins.str,
        resource_group_name: builtins.str,
        url: builtins.str,
        credentials: typing.Optional[typing.List["ApiManagementBackendCredentials"]] = None,
        description: typing.Optional[builtins.str] = None,
        proxy: typing.Optional[typing.List["ApiManagementBackendProxy"]] = None,
        resource_id: typing.Optional[builtins.str] = None,
        service_fabric_cluster: typing.Optional[typing.List["ApiManagementBackendServiceFabricCluster"]] = None,
        timeouts: typing.Optional["ApiManagementBackendTimeouts"] = None,
        title: typing.Optional[builtins.str] = None,
        tls: typing.Optional[typing.List["ApiManagementBackendTls"]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param name: -
        :param protocol: -
        :param resource_group_name: -
        :param url: -
        :param credentials: credentials block.
        :param description: -
        :param proxy: proxy block.
        :param resource_id: -
        :param service_fabric_cluster: service_fabric_cluster block.
        :param timeouts: timeouts block.
        :param title: -
        :param tls: tls block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementBackendTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "name": name,
            "protocol": protocol,
            "resource_group_name": resource_group_name,
            "url": url,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if credentials is not None:
            self._values["credentials"] = credentials
        if description is not None:
            self._values["description"] = description
        if proxy is not None:
            self._values["proxy"] = proxy
        if resource_id is not None:
            self._values["resource_id"] = resource_id
        if service_fabric_cluster is not None:
            self._values["service_fabric_cluster"] = service_fabric_cluster
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if title is not None:
            self._values["title"] = title
        if tls is not None:
            self._values["tls"] = tls

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def protocol(self) -> builtins.str:
        result = self._values.get("protocol")
        assert result is not None, "Required property 'protocol' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def url(self) -> builtins.str:
        result = self._values.get("url")
        assert result is not None, "Required property 'url' is missing"
        return result

    @builtins.property
    def credentials(
        self,
    ) -> typing.Optional[typing.List["ApiManagementBackendCredentials"]]:
        """credentials block."""
        result = self._values.get("credentials")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def proxy(self) -> typing.Optional[typing.List["ApiManagementBackendProxy"]]:
        """proxy block."""
        result = self._values.get("proxy")
        return result

    @builtins.property
    def resource_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("resource_id")
        return result

    @builtins.property
    def service_fabric_cluster(
        self,
    ) -> typing.Optional[typing.List["ApiManagementBackendServiceFabricCluster"]]:
        """service_fabric_cluster block."""
        result = self._values.get("service_fabric_cluster")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementBackendTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        result = self._values.get("title")
        return result

    @builtins.property
    def tls(self) -> typing.Optional[typing.List["ApiManagementBackendTls"]]:
        """tls block."""
        result = self._values.get("tls")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementBackendCredentials",
    jsii_struct_bases=[],
    name_mapping={
        "authorization": "authorization",
        "certificate": "certificate",
        "header": "header",
        "query": "query",
    },
)
class ApiManagementBackendCredentials:
    def __init__(
        self,
        *,
        authorization: typing.Optional[typing.List["ApiManagementBackendCredentialsAuthorization"]] = None,
        certificate: typing.Optional[typing.List[builtins.str]] = None,
        header: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        query: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        """
        :param authorization: authorization block.
        :param certificate: -
        :param header: -
        :param query: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if authorization is not None:
            self._values["authorization"] = authorization
        if certificate is not None:
            self._values["certificate"] = certificate
        if header is not None:
            self._values["header"] = header
        if query is not None:
            self._values["query"] = query

    @builtins.property
    def authorization(
        self,
    ) -> typing.Optional[typing.List["ApiManagementBackendCredentialsAuthorization"]]:
        """authorization block."""
        result = self._values.get("authorization")
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def header(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("header")
        return result

    @builtins.property
    def query(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("query")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementBackendCredentials(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementBackendCredentialsAuthorization",
    jsii_struct_bases=[],
    name_mapping={"parameter": "parameter", "scheme": "scheme"},
)
class ApiManagementBackendCredentialsAuthorization:
    def __init__(
        self,
        *,
        parameter: typing.Optional[builtins.str] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param parameter: -
        :param scheme: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if parameter is not None:
            self._values["parameter"] = parameter
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def parameter(self) -> typing.Optional[builtins.str]:
        result = self._values.get("parameter")
        return result

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        result = self._values.get("scheme")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementBackendCredentialsAuthorization(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementBackendProxy",
    jsii_struct_bases=[],
    name_mapping={"url": "url", "username": "username", "password": "password"},
)
class ApiManagementBackendProxy:
    def __init__(
        self,
        *,
        url: builtins.str,
        username: builtins.str,
        password: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param url: -
        :param username: -
        :param password: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "url": url,
            "username": username,
        }
        if password is not None:
            self._values["password"] = password

    @builtins.property
    def url(self) -> builtins.str:
        result = self._values.get("url")
        assert result is not None, "Required property 'url' is missing"
        return result

    @builtins.property
    def username(self) -> builtins.str:
        result = self._values.get("username")
        assert result is not None, "Required property 'username' is missing"
        return result

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("password")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementBackendProxy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementBackendServiceFabricCluster",
    jsii_struct_bases=[],
    name_mapping={
        "client_certificate_thumbprint": "clientCertificateThumbprint",
        "management_endpoints": "managementEndpoints",
        "max_partition_resolution_retries": "maxPartitionResolutionRetries",
        "server_certificate_thumbprints": "serverCertificateThumbprints",
        "server_x509_name": "serverX509Name",
    },
)
class ApiManagementBackendServiceFabricCluster:
    def __init__(
        self,
        *,
        client_certificate_thumbprint: builtins.str,
        management_endpoints: typing.List[builtins.str],
        max_partition_resolution_retries: jsii.Number,
        server_certificate_thumbprints: typing.Optional[typing.List[builtins.str]] = None,
        server_x509_name: typing.Optional[typing.List["ApiManagementBackendServiceFabricClusterServerX509Name"]] = None,
    ) -> None:
        """
        :param client_certificate_thumbprint: -
        :param management_endpoints: -
        :param max_partition_resolution_retries: -
        :param server_certificate_thumbprints: -
        :param server_x509_name: server_x509_name block.
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_certificate_thumbprint": client_certificate_thumbprint,
            "management_endpoints": management_endpoints,
            "max_partition_resolution_retries": max_partition_resolution_retries,
        }
        if server_certificate_thumbprints is not None:
            self._values["server_certificate_thumbprints"] = server_certificate_thumbprints
        if server_x509_name is not None:
            self._values["server_x509_name"] = server_x509_name

    @builtins.property
    def client_certificate_thumbprint(self) -> builtins.str:
        result = self._values.get("client_certificate_thumbprint")
        assert result is not None, "Required property 'client_certificate_thumbprint' is missing"
        return result

    @builtins.property
    def management_endpoints(self) -> typing.List[builtins.str]:
        result = self._values.get("management_endpoints")
        assert result is not None, "Required property 'management_endpoints' is missing"
        return result

    @builtins.property
    def max_partition_resolution_retries(self) -> jsii.Number:
        result = self._values.get("max_partition_resolution_retries")
        assert result is not None, "Required property 'max_partition_resolution_retries' is missing"
        return result

    @builtins.property
    def server_certificate_thumbprints(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("server_certificate_thumbprints")
        return result

    @builtins.property
    def server_x509_name(
        self,
    ) -> typing.Optional[typing.List["ApiManagementBackendServiceFabricClusterServerX509Name"]]:
        """server_x509_name block."""
        result = self._values.get("server_x509_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementBackendServiceFabricCluster(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementBackendServiceFabricClusterServerX509Name",
    jsii_struct_bases=[],
    name_mapping={
        "issuer_certificate_thumbprint": "issuerCertificateThumbprint",
        "name": "name",
    },
)
class ApiManagementBackendServiceFabricClusterServerX509Name:
    def __init__(
        self,
        *,
        issuer_certificate_thumbprint: builtins.str,
        name: builtins.str,
    ) -> None:
        """
        :param issuer_certificate_thumbprint: -
        :param name: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "issuer_certificate_thumbprint": issuer_certificate_thumbprint,
            "name": name,
        }

    @builtins.property
    def issuer_certificate_thumbprint(self) -> builtins.str:
        result = self._values.get("issuer_certificate_thumbprint")
        assert result is not None, "Required property 'issuer_certificate_thumbprint' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementBackendServiceFabricClusterServerX509Name(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementBackendTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementBackendTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementBackendTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementBackendTls",
    jsii_struct_bases=[],
    name_mapping={
        "validate_certificate_chain": "validateCertificateChain",
        "validate_certificate_name": "validateCertificateName",
    },
)
class ApiManagementBackendTls:
    def __init__(
        self,
        *,
        validate_certificate_chain: typing.Optional[builtins.bool] = None,
        validate_certificate_name: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param validate_certificate_chain: -
        :param validate_certificate_name: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if validate_certificate_chain is not None:
            self._values["validate_certificate_chain"] = validate_certificate_chain
        if validate_certificate_name is not None:
            self._values["validate_certificate_name"] = validate_certificate_name

    @builtins.property
    def validate_certificate_chain(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("validate_certificate_chain")
        return result

    @builtins.property
    def validate_certificate_name(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("validate_certificate_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementBackendTls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCertificate",
    jsii_struct_bases=[],
    name_mapping={
        "certificate_password": "certificatePassword",
        "encoded_certificate": "encodedCertificate",
        "store_name": "storeName",
    },
)
class ApiManagementCertificate:
    def __init__(
        self,
        *,
        certificate_password: builtins.str,
        encoded_certificate: builtins.str,
        store_name: builtins.str,
    ) -> None:
        """
        :param certificate_password: -
        :param encoded_certificate: -
        :param store_name: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "certificate_password": certificate_password,
            "encoded_certificate": encoded_certificate,
            "store_name": store_name,
        }

    @builtins.property
    def certificate_password(self) -> builtins.str:
        result = self._values.get("certificate_password")
        assert result is not None, "Required property 'certificate_password' is missing"
        return result

    @builtins.property
    def encoded_certificate(self) -> builtins.str:
        result = self._values.get("encoded_certificate")
        assert result is not None, "Required property 'encoded_certificate' is missing"
        return result

    @builtins.property
    def store_name(self) -> builtins.str:
        result = self._values.get("store_name")
        assert result is not None, "Required property 'store_name' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCertificate(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementCertificateA(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementCertificateA",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        data: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        password: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementCertificateTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param data: -
        :param name: -
        :param resource_group_name: -
        :param password: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementCertificateAConfig(
            api_management_name=api_management_name,
            data=data,
            name=name,
            resource_group_name=resource_group_name,
            password=password,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementCertificateA, self, [scope, id, config])

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return jsii.invoke(self, "resetPassword", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="dataInput")
    def data_input(self) -> builtins.str:
        return jsii.get(self, "dataInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="expiration")
    def expiration(self) -> builtins.str:
        return jsii.get(self, "expiration")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subject")
    def subject(self) -> builtins.str:
        return jsii.get(self, "subject")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="thumbprint")
    def thumbprint(self) -> builtins.str:
        return jsii.get(self, "thumbprint")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "passwordInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementCertificateTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="data")
    def data(self) -> builtins.str:
        return jsii.get(self, "data")

    @data.setter # type: ignore
    def data(self, value: builtins.str) -> None:
        jsii.set(self, "data", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return jsii.get(self, "password")

    @password.setter # type: ignore
    def password(self, value: builtins.str) -> None:
        jsii.set(self, "password", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementCertificateTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementCertificateTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCertificateAConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "data": "data",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "password": "password",
        "timeouts": "timeouts",
    },
)
class ApiManagementCertificateAConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        data: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        password: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementCertificateTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param data: -
        :param name: -
        :param resource_group_name: -
        :param password: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementCertificateTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "data": data,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if password is not None:
            self._values["password"] = password
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def data(self) -> builtins.str:
        result = self._values.get("data")
        assert result is not None, "Required property 'data' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("password")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementCertificateTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCertificateAConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCertificateTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementCertificateTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCertificateTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "location": "location",
        "name": "name",
        "publisher_email": "publisherEmail",
        "publisher_name": "publisherName",
        "resource_group_name": "resourceGroupName",
        "sku_name": "skuName",
        "additional_location": "additionalLocation",
        "certificate": "certificate",
        "hostname_configuration": "hostnameConfiguration",
        "identity": "identity",
        "notification_sender_email": "notificationSenderEmail",
        "policy": "policy",
        "protocols": "protocols",
        "security": "security",
        "sign_in": "signIn",
        "sign_up": "signUp",
        "tags": "tags",
        "timeouts": "timeouts",
        "virtual_network_configuration": "virtualNetworkConfiguration",
        "virtual_network_type": "virtualNetworkType",
    },
)
class ApiManagementConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        location: builtins.str,
        name: builtins.str,
        publisher_email: builtins.str,
        publisher_name: builtins.str,
        resource_group_name: builtins.str,
        sku_name: builtins.str,
        additional_location: typing.Optional[typing.List[ApiManagementAdditionalLocation]] = None,
        certificate: typing.Optional[typing.List[ApiManagementCertificate]] = None,
        hostname_configuration: typing.Optional[typing.List["ApiManagementHostnameConfiguration"]] = None,
        identity: typing.Optional[typing.List["ApiManagementIdentity"]] = None,
        notification_sender_email: typing.Optional[builtins.str] = None,
        policy: typing.Optional[typing.List["ApiManagementPolicy"]] = None,
        protocols: typing.Optional[typing.List["ApiManagementProtocols"]] = None,
        security: typing.Optional[typing.List["ApiManagementSecurity"]] = None,
        sign_in: typing.Optional[typing.List["ApiManagementSignIn"]] = None,
        sign_up: typing.Optional[typing.List["ApiManagementSignUp"]] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["ApiManagementTimeouts"] = None,
        virtual_network_configuration: typing.Optional[typing.List["ApiManagementVirtualNetworkConfiguration"]] = None,
        virtual_network_type: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: -
        :param name: -
        :param publisher_email: -
        :param publisher_name: -
        :param resource_group_name: -
        :param sku_name: -
        :param additional_location: additional_location block.
        :param certificate: certificate block.
        :param hostname_configuration: hostname_configuration block.
        :param identity: identity block.
        :param notification_sender_email: -
        :param policy: -
        :param protocols: protocols block.
        :param security: security block.
        :param sign_in: sign_in block.
        :param sign_up: sign_up block.
        :param tags: -
        :param timeouts: timeouts block.
        :param virtual_network_configuration: virtual_network_configuration block.
        :param virtual_network_type: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "location": location,
            "name": name,
            "publisher_email": publisher_email,
            "publisher_name": publisher_name,
            "resource_group_name": resource_group_name,
            "sku_name": sku_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if additional_location is not None:
            self._values["additional_location"] = additional_location
        if certificate is not None:
            self._values["certificate"] = certificate
        if hostname_configuration is not None:
            self._values["hostname_configuration"] = hostname_configuration
        if identity is not None:
            self._values["identity"] = identity
        if notification_sender_email is not None:
            self._values["notification_sender_email"] = notification_sender_email
        if policy is not None:
            self._values["policy"] = policy
        if protocols is not None:
            self._values["protocols"] = protocols
        if security is not None:
            self._values["security"] = security
        if sign_in is not None:
            self._values["sign_in"] = sign_in
        if sign_up is not None:
            self._values["sign_up"] = sign_up
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if virtual_network_configuration is not None:
            self._values["virtual_network_configuration"] = virtual_network_configuration
        if virtual_network_type is not None:
            self._values["virtual_network_type"] = virtual_network_type

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def location(self) -> builtins.str:
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def publisher_email(self) -> builtins.str:
        result = self._values.get("publisher_email")
        assert result is not None, "Required property 'publisher_email' is missing"
        return result

    @builtins.property
    def publisher_name(self) -> builtins.str:
        result = self._values.get("publisher_name")
        assert result is not None, "Required property 'publisher_name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def sku_name(self) -> builtins.str:
        result = self._values.get("sku_name")
        assert result is not None, "Required property 'sku_name' is missing"
        return result

    @builtins.property
    def additional_location(
        self,
    ) -> typing.Optional[typing.List[ApiManagementAdditionalLocation]]:
        """additional_location block."""
        result = self._values.get("additional_location")
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[typing.List[ApiManagementCertificate]]:
        """certificate block."""
        result = self._values.get("certificate")
        return result

    @builtins.property
    def hostname_configuration(
        self,
    ) -> typing.Optional[typing.List["ApiManagementHostnameConfiguration"]]:
        """hostname_configuration block."""
        result = self._values.get("hostname_configuration")
        return result

    @builtins.property
    def identity(self) -> typing.Optional[typing.List["ApiManagementIdentity"]]:
        """identity block."""
        result = self._values.get("identity")
        return result

    @builtins.property
    def notification_sender_email(self) -> typing.Optional[builtins.str]:
        result = self._values.get("notification_sender_email")
        return result

    @builtins.property
    def policy(self) -> typing.Optional[typing.List["ApiManagementPolicy"]]:
        result = self._values.get("policy")
        return result

    @builtins.property
    def protocols(self) -> typing.Optional[typing.List["ApiManagementProtocols"]]:
        """protocols block."""
        result = self._values.get("protocols")
        return result

    @builtins.property
    def security(self) -> typing.Optional[typing.List["ApiManagementSecurity"]]:
        """security block."""
        result = self._values.get("security")
        return result

    @builtins.property
    def sign_in(self) -> typing.Optional[typing.List["ApiManagementSignIn"]]:
        """sign_in block."""
        result = self._values.get("sign_in")
        return result

    @builtins.property
    def sign_up(self) -> typing.Optional[typing.List["ApiManagementSignUp"]]:
        """sign_up block."""
        result = self._values.get("sign_up")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def virtual_network_configuration(
        self,
    ) -> typing.Optional[typing.List["ApiManagementVirtualNetworkConfiguration"]]:
        """virtual_network_configuration block."""
        result = self._values.get("virtual_network_configuration")
        return result

    @builtins.property
    def virtual_network_type(self) -> typing.Optional[builtins.str]:
        result = self._values.get("virtual_network_type")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementCustomDomain(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementCustomDomain",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_id: builtins.str,
        developer_portal: typing.Optional[typing.List["ApiManagementCustomDomainDeveloperPortal"]] = None,
        management: typing.Optional[typing.List["ApiManagementCustomDomainManagement"]] = None,
        portal: typing.Optional[typing.List["ApiManagementCustomDomainPortal"]] = None,
        proxy: typing.Optional[typing.List["ApiManagementCustomDomainProxy"]] = None,
        scm: typing.Optional[typing.List["ApiManagementCustomDomainScm"]] = None,
        timeouts: typing.Optional["ApiManagementCustomDomainTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_id: -
        :param developer_portal: developer_portal block.
        :param management: management block.
        :param portal: portal block.
        :param proxy: proxy block.
        :param scm: scm block.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementCustomDomainConfig(
            api_management_id=api_management_id,
            developer_portal=developer_portal,
            management=management,
            portal=portal,
            proxy=proxy,
            scm=scm,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementCustomDomain, self, [scope, id, config])

    @jsii.member(jsii_name="resetDeveloperPortal")
    def reset_developer_portal(self) -> None:
        return jsii.invoke(self, "resetDeveloperPortal", [])

    @jsii.member(jsii_name="resetManagement")
    def reset_management(self) -> None:
        return jsii.invoke(self, "resetManagement", [])

    @jsii.member(jsii_name="resetPortal")
    def reset_portal(self) -> None:
        return jsii.invoke(self, "resetPortal", [])

    @jsii.member(jsii_name="resetProxy")
    def reset_proxy(self) -> None:
        return jsii.invoke(self, "resetProxy", [])

    @jsii.member(jsii_name="resetScm")
    def reset_scm(self) -> None:
        return jsii.invoke(self, "resetScm", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementIdInput")
    def api_management_id_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="developerPortalInput")
    def developer_portal_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementCustomDomainDeveloperPortal"]]:
        return jsii.get(self, "developerPortalInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="managementInput")
    def management_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementCustomDomainManagement"]]:
        return jsii.get(self, "managementInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="portalInput")
    def portal_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementCustomDomainPortal"]]:
        return jsii.get(self, "portalInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="proxyInput")
    def proxy_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementCustomDomainProxy"]]:
        return jsii.get(self, "proxyInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="scmInput")
    def scm_input(self) -> typing.Optional[typing.List["ApiManagementCustomDomainScm"]]:
        return jsii.get(self, "scmInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementCustomDomainTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementId")
    def api_management_id(self) -> builtins.str:
        return jsii.get(self, "apiManagementId")

    @api_management_id.setter # type: ignore
    def api_management_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="developerPortal")
    def developer_portal(
        self,
    ) -> typing.List["ApiManagementCustomDomainDeveloperPortal"]:
        return jsii.get(self, "developerPortal")

    @developer_portal.setter # type: ignore
    def developer_portal(
        self,
        value: typing.List["ApiManagementCustomDomainDeveloperPortal"],
    ) -> None:
        jsii.set(self, "developerPortal", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="management")
    def management(self) -> typing.List["ApiManagementCustomDomainManagement"]:
        return jsii.get(self, "management")

    @management.setter # type: ignore
    def management(
        self,
        value: typing.List["ApiManagementCustomDomainManagement"],
    ) -> None:
        jsii.set(self, "management", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="portal")
    def portal(self) -> typing.List["ApiManagementCustomDomainPortal"]:
        return jsii.get(self, "portal")

    @portal.setter # type: ignore
    def portal(self, value: typing.List["ApiManagementCustomDomainPortal"]) -> None:
        jsii.set(self, "portal", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="proxy")
    def proxy(self) -> typing.List["ApiManagementCustomDomainProxy"]:
        return jsii.get(self, "proxy")

    @proxy.setter # type: ignore
    def proxy(self, value: typing.List["ApiManagementCustomDomainProxy"]) -> None:
        jsii.set(self, "proxy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="scm")
    def scm(self) -> typing.List["ApiManagementCustomDomainScm"]:
        return jsii.get(self, "scm")

    @scm.setter # type: ignore
    def scm(self, value: typing.List["ApiManagementCustomDomainScm"]) -> None:
        jsii.set(self, "scm", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementCustomDomainTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementCustomDomainTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCustomDomainConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_id": "apiManagementId",
        "developer_portal": "developerPortal",
        "management": "management",
        "portal": "portal",
        "proxy": "proxy",
        "scm": "scm",
        "timeouts": "timeouts",
    },
)
class ApiManagementCustomDomainConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_id: builtins.str,
        developer_portal: typing.Optional[typing.List["ApiManagementCustomDomainDeveloperPortal"]] = None,
        management: typing.Optional[typing.List["ApiManagementCustomDomainManagement"]] = None,
        portal: typing.Optional[typing.List["ApiManagementCustomDomainPortal"]] = None,
        proxy: typing.Optional[typing.List["ApiManagementCustomDomainProxy"]] = None,
        scm: typing.Optional[typing.List["ApiManagementCustomDomainScm"]] = None,
        timeouts: typing.Optional["ApiManagementCustomDomainTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_id: -
        :param developer_portal: developer_portal block.
        :param management: management block.
        :param portal: portal block.
        :param proxy: proxy block.
        :param scm: scm block.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementCustomDomainTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_id": api_management_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if developer_portal is not None:
            self._values["developer_portal"] = developer_portal
        if management is not None:
            self._values["management"] = management
        if portal is not None:
            self._values["portal"] = portal
        if proxy is not None:
            self._values["proxy"] = proxy
        if scm is not None:
            self._values["scm"] = scm
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_id(self) -> builtins.str:
        result = self._values.get("api_management_id")
        assert result is not None, "Required property 'api_management_id' is missing"
        return result

    @builtins.property
    def developer_portal(
        self,
    ) -> typing.Optional[typing.List["ApiManagementCustomDomainDeveloperPortal"]]:
        """developer_portal block."""
        result = self._values.get("developer_portal")
        return result

    @builtins.property
    def management(
        self,
    ) -> typing.Optional[typing.List["ApiManagementCustomDomainManagement"]]:
        """management block."""
        result = self._values.get("management")
        return result

    @builtins.property
    def portal(self) -> typing.Optional[typing.List["ApiManagementCustomDomainPortal"]]:
        """portal block."""
        result = self._values.get("portal")
        return result

    @builtins.property
    def proxy(self) -> typing.Optional[typing.List["ApiManagementCustomDomainProxy"]]:
        """proxy block."""
        result = self._values.get("proxy")
        return result

    @builtins.property
    def scm(self) -> typing.Optional[typing.List["ApiManagementCustomDomainScm"]]:
        """scm block."""
        result = self._values.get("scm")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementCustomDomainTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCustomDomainConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCustomDomainDeveloperPortal",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementCustomDomainDeveloperPortal:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCustomDomainDeveloperPortal(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCustomDomainManagement",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementCustomDomainManagement:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCustomDomainManagement(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCustomDomainPortal",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementCustomDomainPortal:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCustomDomainPortal(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCustomDomainProxy",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "default_ssl_binding": "defaultSslBinding",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementCustomDomainProxy:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        default_ssl_binding: typing.Optional[builtins.bool] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param default_ssl_binding: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if default_ssl_binding is not None:
            self._values["default_ssl_binding"] = default_ssl_binding
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def default_ssl_binding(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("default_ssl_binding")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCustomDomainProxy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCustomDomainScm",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementCustomDomainScm:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCustomDomainScm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementCustomDomainTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementCustomDomainTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementCustomDomainTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementDiagnostic(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementDiagnostic",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_logger_id: builtins.str,
        api_management_name: builtins.str,
        identifier: builtins.str,
        resource_group_name: builtins.str,
        enabled: typing.Optional[builtins.bool] = None,
        timeouts: typing.Optional["ApiManagementDiagnosticTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_logger_id: -
        :param api_management_name: -
        :param identifier: -
        :param resource_group_name: -
        :param enabled: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementDiagnosticConfig(
            api_management_logger_id=api_management_logger_id,
            api_management_name=api_management_name,
            identifier=identifier,
            resource_group_name=resource_group_name,
            enabled=enabled,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementDiagnostic, self, [scope, id, config])

    @jsii.member(jsii_name="resetEnabled")
    def reset_enabled(self) -> None:
        return jsii.invoke(self, "resetEnabled", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementLoggerIdInput")
    def api_management_logger_id_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementLoggerIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identifierInput")
    def identifier_input(self) -> builtins.str:
        return jsii.get(self, "identifierInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enabledInput")
    def enabled_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "enabledInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementDiagnosticTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementLoggerId")
    def api_management_logger_id(self) -> builtins.str:
        return jsii.get(self, "apiManagementLoggerId")

    @api_management_logger_id.setter # type: ignore
    def api_management_logger_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementLoggerId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> builtins.bool:
        return jsii.get(self, "enabled")

    @enabled.setter # type: ignore
    def enabled(self, value: builtins.bool) -> None:
        jsii.set(self, "enabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identifier")
    def identifier(self) -> builtins.str:
        return jsii.get(self, "identifier")

    @identifier.setter # type: ignore
    def identifier(self, value: builtins.str) -> None:
        jsii.set(self, "identifier", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementDiagnosticTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementDiagnosticTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementDiagnosticConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_logger_id": "apiManagementLoggerId",
        "api_management_name": "apiManagementName",
        "identifier": "identifier",
        "resource_group_name": "resourceGroupName",
        "enabled": "enabled",
        "timeouts": "timeouts",
    },
)
class ApiManagementDiagnosticConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_logger_id: builtins.str,
        api_management_name: builtins.str,
        identifier: builtins.str,
        resource_group_name: builtins.str,
        enabled: typing.Optional[builtins.bool] = None,
        timeouts: typing.Optional["ApiManagementDiagnosticTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_logger_id: -
        :param api_management_name: -
        :param identifier: -
        :param resource_group_name: -
        :param enabled: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementDiagnosticTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_logger_id": api_management_logger_id,
            "api_management_name": api_management_name,
            "identifier": identifier,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if enabled is not None:
            self._values["enabled"] = enabled
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_logger_id(self) -> builtins.str:
        result = self._values.get("api_management_logger_id")
        assert result is not None, "Required property 'api_management_logger_id' is missing"
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def identifier(self) -> builtins.str:
        result = self._values.get("identifier")
        assert result is not None, "Required property 'identifier' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enabled")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementDiagnosticTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementDiagnosticConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementDiagnosticTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementDiagnosticTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementDiagnosticTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementGroup(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementGroup",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        external_id: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementGroupTimeouts"] = None,
        type: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param resource_group_name: -
        :param description: -
        :param external_id: -
        :param timeouts: timeouts block.
        :param type: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementGroupConfig(
            api_management_name=api_management_name,
            display_name=display_name,
            name=name,
            resource_group_name=resource_group_name,
            description=description,
            external_id=external_id,
            timeouts=timeouts,
            type=type,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementGroup, self, [scope, id, config])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return jsii.invoke(self, "resetDescription", [])

    @jsii.member(jsii_name="resetExternalId")
    def reset_external_id(self) -> None:
        return jsii.invoke(self, "resetExternalId", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetType")
    def reset_type(self) -> None:
        return jsii.invoke(self, "resetType", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "descriptionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="externalIdInput")
    def external_id_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "externalIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementGroupTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "typeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="externalId")
    def external_id(self) -> builtins.str:
        return jsii.get(self, "externalId")

    @external_id.setter # type: ignore
    def external_id(self, value: builtins.str) -> None:
        jsii.set(self, "externalId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementGroupTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementGroupTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return jsii.get(self, "type")

    @type.setter # type: ignore
    def type(self, value: builtins.str) -> None:
        jsii.set(self, "type", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementGroupConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "display_name": "displayName",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "description": "description",
        "external_id": "externalId",
        "timeouts": "timeouts",
        "type": "type",
    },
)
class ApiManagementGroupConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        external_id: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementGroupTimeouts"] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param resource_group_name: -
        :param description: -
        :param external_id: -
        :param timeouts: timeouts block.
        :param type: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementGroupTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "display_name": display_name,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if external_id is not None:
            self._values["external_id"] = external_id
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def external_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("external_id")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementGroupTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        result = self._values.get("type")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementGroupConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementGroupTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementGroupTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementGroupTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementGroupUser(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementGroupUser",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        group_name: builtins.str,
        resource_group_name: builtins.str,
        user_id: builtins.str,
        timeouts: typing.Optional["ApiManagementGroupUserTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param group_name: -
        :param resource_group_name: -
        :param user_id: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementGroupUserConfig(
            api_management_name=api_management_name,
            group_name=group_name,
            resource_group_name=resource_group_name,
            user_id=user_id,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementGroupUser, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupNameInput")
    def group_name_input(self) -> builtins.str:
        return jsii.get(self, "groupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userIdInput")
    def user_id_input(self) -> builtins.str:
        return jsii.get(self, "userIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementGroupUserTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupName")
    def group_name(self) -> builtins.str:
        return jsii.get(self, "groupName")

    @group_name.setter # type: ignore
    def group_name(self, value: builtins.str) -> None:
        jsii.set(self, "groupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementGroupUserTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementGroupUserTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userId")
    def user_id(self) -> builtins.str:
        return jsii.get(self, "userId")

    @user_id.setter # type: ignore
    def user_id(self, value: builtins.str) -> None:
        jsii.set(self, "userId", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementGroupUserConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "group_name": "groupName",
        "resource_group_name": "resourceGroupName",
        "user_id": "userId",
        "timeouts": "timeouts",
    },
)
class ApiManagementGroupUserConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        group_name: builtins.str,
        resource_group_name: builtins.str,
        user_id: builtins.str,
        timeouts: typing.Optional["ApiManagementGroupUserTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param group_name: -
        :param resource_group_name: -
        :param user_id: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementGroupUserTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "group_name": group_name,
            "resource_group_name": resource_group_name,
            "user_id": user_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def group_name(self) -> builtins.str:
        result = self._values.get("group_name")
        assert result is not None, "Required property 'group_name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def user_id(self) -> builtins.str:
        result = self._values.get("user_id")
        assert result is not None, "Required property 'user_id' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementGroupUserTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementGroupUserConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementGroupUserTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementGroupUserTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementGroupUserTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementHostnameConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "developer_portal": "developerPortal",
        "management": "management",
        "portal": "portal",
        "proxy": "proxy",
        "scm": "scm",
    },
)
class ApiManagementHostnameConfiguration:
    def __init__(
        self,
        *,
        developer_portal: typing.Optional[typing.List["ApiManagementHostnameConfigurationDeveloperPortal"]] = None,
        management: typing.Optional[typing.List["ApiManagementHostnameConfigurationManagement"]] = None,
        portal: typing.Optional[typing.List["ApiManagementHostnameConfigurationPortal"]] = None,
        proxy: typing.Optional[typing.List["ApiManagementHostnameConfigurationProxy"]] = None,
        scm: typing.Optional[typing.List["ApiManagementHostnameConfigurationScm"]] = None,
    ) -> None:
        """
        :param developer_portal: developer_portal block.
        :param management: management block.
        :param portal: portal block.
        :param proxy: proxy block.
        :param scm: scm block.
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if developer_portal is not None:
            self._values["developer_portal"] = developer_portal
        if management is not None:
            self._values["management"] = management
        if portal is not None:
            self._values["portal"] = portal
        if proxy is not None:
            self._values["proxy"] = proxy
        if scm is not None:
            self._values["scm"] = scm

    @builtins.property
    def developer_portal(
        self,
    ) -> typing.Optional[typing.List["ApiManagementHostnameConfigurationDeveloperPortal"]]:
        """developer_portal block."""
        result = self._values.get("developer_portal")
        return result

    @builtins.property
    def management(
        self,
    ) -> typing.Optional[typing.List["ApiManagementHostnameConfigurationManagement"]]:
        """management block."""
        result = self._values.get("management")
        return result

    @builtins.property
    def portal(
        self,
    ) -> typing.Optional[typing.List["ApiManagementHostnameConfigurationPortal"]]:
        """portal block."""
        result = self._values.get("portal")
        return result

    @builtins.property
    def proxy(
        self,
    ) -> typing.Optional[typing.List["ApiManagementHostnameConfigurationProxy"]]:
        """proxy block."""
        result = self._values.get("proxy")
        return result

    @builtins.property
    def scm(
        self,
    ) -> typing.Optional[typing.List["ApiManagementHostnameConfigurationScm"]]:
        """scm block."""
        result = self._values.get("scm")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementHostnameConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementHostnameConfigurationDeveloperPortal",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementHostnameConfigurationDeveloperPortal:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementHostnameConfigurationDeveloperPortal(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementHostnameConfigurationManagement",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementHostnameConfigurationManagement:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementHostnameConfigurationManagement(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementHostnameConfigurationPortal",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementHostnameConfigurationPortal:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementHostnameConfigurationPortal(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementHostnameConfigurationProxy",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "default_ssl_binding": "defaultSslBinding",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementHostnameConfigurationProxy:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        default_ssl_binding: typing.Optional[builtins.bool] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param default_ssl_binding: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if default_ssl_binding is not None:
            self._values["default_ssl_binding"] = default_ssl_binding
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def default_ssl_binding(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("default_ssl_binding")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementHostnameConfigurationProxy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementHostnameConfigurationScm",
    jsii_struct_bases=[],
    name_mapping={
        "host_name": "hostName",
        "certificate": "certificate",
        "certificate_password": "certificatePassword",
        "key_vault_id": "keyVaultId",
        "negotiate_client_certificate": "negotiateClientCertificate",
    },
)
class ApiManagementHostnameConfigurationScm:
    def __init__(
        self,
        *,
        host_name: builtins.str,
        certificate: typing.Optional[builtins.str] = None,
        certificate_password: typing.Optional[builtins.str] = None,
        key_vault_id: typing.Optional[builtins.str] = None,
        negotiate_client_certificate: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param host_name: -
        :param certificate: -
        :param certificate_password: -
        :param key_vault_id: -
        :param negotiate_client_certificate: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "host_name": host_name,
        }
        if certificate is not None:
            self._values["certificate"] = certificate
        if certificate_password is not None:
            self._values["certificate_password"] = certificate_password
        if key_vault_id is not None:
            self._values["key_vault_id"] = key_vault_id
        if negotiate_client_certificate is not None:
            self._values["negotiate_client_certificate"] = negotiate_client_certificate

    @builtins.property
    def host_name(self) -> builtins.str:
        result = self._values.get("host_name")
        assert result is not None, "Required property 'host_name' is missing"
        return result

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate")
        return result

    @builtins.property
    def certificate_password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("certificate_password")
        return result

    @builtins.property
    def key_vault_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_id")
        return result

    @builtins.property
    def negotiate_client_certificate(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("negotiate_client_certificate")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementHostnameConfigurationScm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentity",
    jsii_struct_bases=[],
    name_mapping={"identity_ids": "identityIds", "type": "type"},
)
class ApiManagementIdentity:
    def __init__(
        self,
        *,
        identity_ids: typing.Optional[typing.List[builtins.str]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param identity_ids: -
        :param type: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if identity_ids is not None:
            self._values["identity_ids"] = identity_ids
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def identity_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("identity_ids")
        return result

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        result = self._values.get("type")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementIdentityProviderAad(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementIdentityProviderAad",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        allowed_tenants: typing.List[builtins.str],
        api_management_name: builtins.str,
        client_id: builtins.str,
        client_secret: builtins.str,
        resource_group_name: builtins.str,
        signin_tenant: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementIdentityProviderAadTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param allowed_tenants: -
        :param api_management_name: -
        :param client_id: -
        :param client_secret: -
        :param resource_group_name: -
        :param signin_tenant: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementIdentityProviderAadConfig(
            allowed_tenants=allowed_tenants,
            api_management_name=api_management_name,
            client_id=client_id,
            client_secret=client_secret,
            resource_group_name=resource_group_name,
            signin_tenant=signin_tenant,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementIdentityProviderAad, self, [scope, id, config])

    @jsii.member(jsii_name="resetSigninTenant")
    def reset_signin_tenant(self) -> None:
        return jsii.invoke(self, "resetSigninTenant", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="allowedTenantsInput")
    def allowed_tenants_input(self) -> typing.List[builtins.str]:
        return jsii.get(self, "allowedTenantsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientIdInput")
    def client_id_input(self) -> builtins.str:
        return jsii.get(self, "clientIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecretInput")
    def client_secret_input(self) -> builtins.str:
        return jsii.get(self, "clientSecretInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="signinTenantInput")
    def signin_tenant_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "signinTenantInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["ApiManagementIdentityProviderAadTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="allowedTenants")
    def allowed_tenants(self) -> typing.List[builtins.str]:
        return jsii.get(self, "allowedTenants")

    @allowed_tenants.setter # type: ignore
    def allowed_tenants(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "allowedTenants", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientId")
    def client_id(self) -> builtins.str:
        return jsii.get(self, "clientId")

    @client_id.setter # type: ignore
    def client_id(self, value: builtins.str) -> None:
        jsii.set(self, "clientId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecret")
    def client_secret(self) -> builtins.str:
        return jsii.get(self, "clientSecret")

    @client_secret.setter # type: ignore
    def client_secret(self, value: builtins.str) -> None:
        jsii.set(self, "clientSecret", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="signinTenant")
    def signin_tenant(self) -> builtins.str:
        return jsii.get(self, "signinTenant")

    @signin_tenant.setter # type: ignore
    def signin_tenant(self, value: builtins.str) -> None:
        jsii.set(self, "signinTenant", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementIdentityProviderAadTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementIdentityProviderAadTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderAadConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "allowed_tenants": "allowedTenants",
        "api_management_name": "apiManagementName",
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "resource_group_name": "resourceGroupName",
        "signin_tenant": "signinTenant",
        "timeouts": "timeouts",
    },
)
class ApiManagementIdentityProviderAadConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        allowed_tenants: typing.List[builtins.str],
        api_management_name: builtins.str,
        client_id: builtins.str,
        client_secret: builtins.str,
        resource_group_name: builtins.str,
        signin_tenant: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementIdentityProviderAadTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param allowed_tenants: -
        :param api_management_name: -
        :param client_id: -
        :param client_secret: -
        :param resource_group_name: -
        :param signin_tenant: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementIdentityProviderAadTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "allowed_tenants": allowed_tenants,
            "api_management_name": api_management_name,
            "client_id": client_id,
            "client_secret": client_secret,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if signin_tenant is not None:
            self._values["signin_tenant"] = signin_tenant
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def allowed_tenants(self) -> typing.List[builtins.str]:
        result = self._values.get("allowed_tenants")
        assert result is not None, "Required property 'allowed_tenants' is missing"
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def client_secret(self) -> builtins.str:
        result = self._values.get("client_secret")
        assert result is not None, "Required property 'client_secret' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def signin_tenant(self) -> typing.Optional[builtins.str]:
        result = self._values.get("signin_tenant")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementIdentityProviderAadTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderAadConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderAadTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementIdentityProviderAadTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderAadTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementIdentityProviderFacebook(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementIdentityProviderFacebook",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        app_id: builtins.str,
        app_secret: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementIdentityProviderFacebookTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param app_id: -
        :param app_secret: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementIdentityProviderFacebookConfig(
            api_management_name=api_management_name,
            app_id=app_id,
            app_secret=app_secret,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementIdentityProviderFacebook, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appIdInput")
    def app_id_input(self) -> builtins.str:
        return jsii.get(self, "appIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appSecretInput")
    def app_secret_input(self) -> builtins.str:
        return jsii.get(self, "appSecretInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["ApiManagementIdentityProviderFacebookTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appId")
    def app_id(self) -> builtins.str:
        return jsii.get(self, "appId")

    @app_id.setter # type: ignore
    def app_id(self, value: builtins.str) -> None:
        jsii.set(self, "appId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appSecret")
    def app_secret(self) -> builtins.str:
        return jsii.get(self, "appSecret")

    @app_secret.setter # type: ignore
    def app_secret(self, value: builtins.str) -> None:
        jsii.set(self, "appSecret", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementIdentityProviderFacebookTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementIdentityProviderFacebookTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderFacebookConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "app_id": "appId",
        "app_secret": "appSecret",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
    },
)
class ApiManagementIdentityProviderFacebookConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        app_id: builtins.str,
        app_secret: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementIdentityProviderFacebookTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param app_id: -
        :param app_secret: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementIdentityProviderFacebookTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "app_id": app_id,
            "app_secret": app_secret,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def app_id(self) -> builtins.str:
        result = self._values.get("app_id")
        assert result is not None, "Required property 'app_id' is missing"
        return result

    @builtins.property
    def app_secret(self) -> builtins.str:
        result = self._values.get("app_secret")
        assert result is not None, "Required property 'app_secret' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(
        self,
    ) -> typing.Optional["ApiManagementIdentityProviderFacebookTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderFacebookConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderFacebookTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementIdentityProviderFacebookTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderFacebookTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementIdentityProviderGoogle(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementIdentityProviderGoogle",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        client_id: builtins.str,
        client_secret: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementIdentityProviderGoogleTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param client_id: -
        :param client_secret: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementIdentityProviderGoogleConfig(
            api_management_name=api_management_name,
            client_id=client_id,
            client_secret=client_secret,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementIdentityProviderGoogle, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientIdInput")
    def client_id_input(self) -> builtins.str:
        return jsii.get(self, "clientIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecretInput")
    def client_secret_input(self) -> builtins.str:
        return jsii.get(self, "clientSecretInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["ApiManagementIdentityProviderGoogleTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientId")
    def client_id(self) -> builtins.str:
        return jsii.get(self, "clientId")

    @client_id.setter # type: ignore
    def client_id(self, value: builtins.str) -> None:
        jsii.set(self, "clientId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecret")
    def client_secret(self) -> builtins.str:
        return jsii.get(self, "clientSecret")

    @client_secret.setter # type: ignore
    def client_secret(self, value: builtins.str) -> None:
        jsii.set(self, "clientSecret", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementIdentityProviderGoogleTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementIdentityProviderGoogleTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderGoogleConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
    },
)
class ApiManagementIdentityProviderGoogleConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        client_id: builtins.str,
        client_secret: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementIdentityProviderGoogleTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param client_id: -
        :param client_secret: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementIdentityProviderGoogleTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "client_id": client_id,
            "client_secret": client_secret,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def client_secret(self) -> builtins.str:
        result = self._values.get("client_secret")
        assert result is not None, "Required property 'client_secret' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(
        self,
    ) -> typing.Optional["ApiManagementIdentityProviderGoogleTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderGoogleConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderGoogleTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementIdentityProviderGoogleTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderGoogleTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementIdentityProviderMicrosoft(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementIdentityProviderMicrosoft",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        client_id: builtins.str,
        client_secret: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementIdentityProviderMicrosoftTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param client_id: -
        :param client_secret: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementIdentityProviderMicrosoftConfig(
            api_management_name=api_management_name,
            client_id=client_id,
            client_secret=client_secret,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementIdentityProviderMicrosoft, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientIdInput")
    def client_id_input(self) -> builtins.str:
        return jsii.get(self, "clientIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecretInput")
    def client_secret_input(self) -> builtins.str:
        return jsii.get(self, "clientSecretInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["ApiManagementIdentityProviderMicrosoftTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientId")
    def client_id(self) -> builtins.str:
        return jsii.get(self, "clientId")

    @client_id.setter # type: ignore
    def client_id(self, value: builtins.str) -> None:
        jsii.set(self, "clientId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecret")
    def client_secret(self) -> builtins.str:
        return jsii.get(self, "clientSecret")

    @client_secret.setter # type: ignore
    def client_secret(self, value: builtins.str) -> None:
        jsii.set(self, "clientSecret", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementIdentityProviderMicrosoftTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementIdentityProviderMicrosoftTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderMicrosoftConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
    },
)
class ApiManagementIdentityProviderMicrosoftConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        client_id: builtins.str,
        client_secret: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementIdentityProviderMicrosoftTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param client_id: -
        :param client_secret: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementIdentityProviderMicrosoftTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "client_id": client_id,
            "client_secret": client_secret,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def client_secret(self) -> builtins.str:
        result = self._values.get("client_secret")
        assert result is not None, "Required property 'client_secret' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(
        self,
    ) -> typing.Optional["ApiManagementIdentityProviderMicrosoftTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderMicrosoftConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderMicrosoftTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementIdentityProviderMicrosoftTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderMicrosoftTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementIdentityProviderTwitter(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementIdentityProviderTwitter",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_key: builtins.str,
        api_management_name: builtins.str,
        api_secret_key: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementIdentityProviderTwitterTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_key: -
        :param api_management_name: -
        :param api_secret_key: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementIdentityProviderTwitterConfig(
            api_key=api_key,
            api_management_name=api_management_name,
            api_secret_key=api_secret_key,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementIdentityProviderTwitter, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiKeyInput")
    def api_key_input(self) -> builtins.str:
        return jsii.get(self, "apiKeyInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiSecretKeyInput")
    def api_secret_key_input(self) -> builtins.str:
        return jsii.get(self, "apiSecretKeyInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["ApiManagementIdentityProviderTwitterTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiKey")
    def api_key(self) -> builtins.str:
        return jsii.get(self, "apiKey")

    @api_key.setter # type: ignore
    def api_key(self, value: builtins.str) -> None:
        jsii.set(self, "apiKey", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiSecretKey")
    def api_secret_key(self) -> builtins.str:
        return jsii.get(self, "apiSecretKey")

    @api_secret_key.setter # type: ignore
    def api_secret_key(self, value: builtins.str) -> None:
        jsii.set(self, "apiSecretKey", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementIdentityProviderTwitterTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementIdentityProviderTwitterTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderTwitterConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_key": "apiKey",
        "api_management_name": "apiManagementName",
        "api_secret_key": "apiSecretKey",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
    },
)
class ApiManagementIdentityProviderTwitterConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_key: builtins.str,
        api_management_name: builtins.str,
        api_secret_key: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementIdentityProviderTwitterTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_key: -
        :param api_management_name: -
        :param api_secret_key: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementIdentityProviderTwitterTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_key": api_key,
            "api_management_name": api_management_name,
            "api_secret_key": api_secret_key,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_key(self) -> builtins.str:
        result = self._values.get("api_key")
        assert result is not None, "Required property 'api_key' is missing"
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def api_secret_key(self) -> builtins.str:
        result = self._values.get("api_secret_key")
        assert result is not None, "Required property 'api_secret_key' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(
        self,
    ) -> typing.Optional["ApiManagementIdentityProviderTwitterTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderTwitterConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementIdentityProviderTwitterTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementIdentityProviderTwitterTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementIdentityProviderTwitterTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementLogger(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementLogger",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        application_insights: typing.Optional[typing.List["ApiManagementLoggerApplicationInsights"]] = None,
        buffered: typing.Optional[builtins.bool] = None,
        description: typing.Optional[builtins.str] = None,
        eventhub: typing.Optional[typing.List["ApiManagementLoggerEventhub"]] = None,
        timeouts: typing.Optional["ApiManagementLoggerTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param name: -
        :param resource_group_name: -
        :param application_insights: application_insights block.
        :param buffered: -
        :param description: -
        :param eventhub: eventhub block.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementLoggerConfig(
            api_management_name=api_management_name,
            name=name,
            resource_group_name=resource_group_name,
            application_insights=application_insights,
            buffered=buffered,
            description=description,
            eventhub=eventhub,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementLogger, self, [scope, id, config])

    @jsii.member(jsii_name="resetApplicationInsights")
    def reset_application_insights(self) -> None:
        return jsii.invoke(self, "resetApplicationInsights", [])

    @jsii.member(jsii_name="resetBuffered")
    def reset_buffered(self) -> None:
        return jsii.invoke(self, "resetBuffered", [])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return jsii.invoke(self, "resetDescription", [])

    @jsii.member(jsii_name="resetEventhub")
    def reset_eventhub(self) -> None:
        return jsii.invoke(self, "resetEventhub", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="applicationInsightsInput")
    def application_insights_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementLoggerApplicationInsights"]]:
        return jsii.get(self, "applicationInsightsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="bufferedInput")
    def buffered_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "bufferedInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "descriptionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="eventhubInput")
    def eventhub_input(
        self,
    ) -> typing.Optional[typing.List["ApiManagementLoggerEventhub"]]:
        return jsii.get(self, "eventhubInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementLoggerTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="applicationInsights")
    def application_insights(
        self,
    ) -> typing.List["ApiManagementLoggerApplicationInsights"]:
        return jsii.get(self, "applicationInsights")

    @application_insights.setter # type: ignore
    def application_insights(
        self,
        value: typing.List["ApiManagementLoggerApplicationInsights"],
    ) -> None:
        jsii.set(self, "applicationInsights", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="buffered")
    def buffered(self) -> builtins.bool:
        return jsii.get(self, "buffered")

    @buffered.setter # type: ignore
    def buffered(self, value: builtins.bool) -> None:
        jsii.set(self, "buffered", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="eventhub")
    def eventhub(self) -> typing.List["ApiManagementLoggerEventhub"]:
        return jsii.get(self, "eventhub")

    @eventhub.setter # type: ignore
    def eventhub(self, value: typing.List["ApiManagementLoggerEventhub"]) -> None:
        jsii.set(self, "eventhub", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementLoggerTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementLoggerTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementLoggerApplicationInsights",
    jsii_struct_bases=[],
    name_mapping={"instrumentation_key": "instrumentationKey"},
)
class ApiManagementLoggerApplicationInsights:
    def __init__(self, *, instrumentation_key: builtins.str) -> None:
        """
        :param instrumentation_key: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "instrumentation_key": instrumentation_key,
        }

    @builtins.property
    def instrumentation_key(self) -> builtins.str:
        result = self._values.get("instrumentation_key")
        assert result is not None, "Required property 'instrumentation_key' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementLoggerApplicationInsights(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementLoggerConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "application_insights": "applicationInsights",
        "buffered": "buffered",
        "description": "description",
        "eventhub": "eventhub",
        "timeouts": "timeouts",
    },
)
class ApiManagementLoggerConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        application_insights: typing.Optional[typing.List[ApiManagementLoggerApplicationInsights]] = None,
        buffered: typing.Optional[builtins.bool] = None,
        description: typing.Optional[builtins.str] = None,
        eventhub: typing.Optional[typing.List["ApiManagementLoggerEventhub"]] = None,
        timeouts: typing.Optional["ApiManagementLoggerTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param name: -
        :param resource_group_name: -
        :param application_insights: application_insights block.
        :param buffered: -
        :param description: -
        :param eventhub: eventhub block.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementLoggerTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if application_insights is not None:
            self._values["application_insights"] = application_insights
        if buffered is not None:
            self._values["buffered"] = buffered
        if description is not None:
            self._values["description"] = description
        if eventhub is not None:
            self._values["eventhub"] = eventhub
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def application_insights(
        self,
    ) -> typing.Optional[typing.List[ApiManagementLoggerApplicationInsights]]:
        """application_insights block."""
        result = self._values.get("application_insights")
        return result

    @builtins.property
    def buffered(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("buffered")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def eventhub(self) -> typing.Optional[typing.List["ApiManagementLoggerEventhub"]]:
        """eventhub block."""
        result = self._values.get("eventhub")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementLoggerTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementLoggerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementLoggerEventhub",
    jsii_struct_bases=[],
    name_mapping={"connection_string": "connectionString", "name": "name"},
)
class ApiManagementLoggerEventhub:
    def __init__(self, *, connection_string: builtins.str, name: builtins.str) -> None:
        """
        :param connection_string: -
        :param name: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "connection_string": connection_string,
            "name": name,
        }

    @builtins.property
    def connection_string(self) -> builtins.str:
        result = self._values.get("connection_string")
        assert result is not None, "Required property 'connection_string' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementLoggerEventhub(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementLoggerTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementLoggerTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementLoggerTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementNamedValue(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementNamedValue",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        value: builtins.str,
        secret: typing.Optional[builtins.bool] = None,
        tags: typing.Optional[typing.List[builtins.str]] = None,
        timeouts: typing.Optional["ApiManagementNamedValueTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param resource_group_name: -
        :param value: -
        :param secret: -
        :param tags: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementNamedValueConfig(
            api_management_name=api_management_name,
            display_name=display_name,
            name=name,
            resource_group_name=resource_group_name,
            value=value,
            secret=secret,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementNamedValue, self, [scope, id, config])

    @jsii.member(jsii_name="resetSecret")
    def reset_secret(self) -> None:
        return jsii.invoke(self, "resetSecret", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="valueInput")
    def value_input(self) -> builtins.str:
        return jsii.get(self, "valueInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secretInput")
    def secret_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "secretInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementNamedValueTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secret")
    def secret(self) -> builtins.bool:
        return jsii.get(self, "secret")

    @secret.setter # type: ignore
    def secret(self, value: builtins.bool) -> None:
        jsii.set(self, "secret", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.List[builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementNamedValueTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementNamedValueTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="value")
    def value(self) -> builtins.str:
        return jsii.get(self, "value")

    @value.setter # type: ignore
    def value(self, value: builtins.str) -> None:
        jsii.set(self, "value", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementNamedValueConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "display_name": "displayName",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "value": "value",
        "secret": "secret",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class ApiManagementNamedValueConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        value: builtins.str,
        secret: typing.Optional[builtins.bool] = None,
        tags: typing.Optional[typing.List[builtins.str]] = None,
        timeouts: typing.Optional["ApiManagementNamedValueTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param resource_group_name: -
        :param value: -
        :param secret: -
        :param tags: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementNamedValueTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "display_name": display_name,
            "name": name,
            "resource_group_name": resource_group_name,
            "value": value,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if secret is not None:
            self._values["secret"] = secret
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def value(self) -> builtins.str:
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return result

    @builtins.property
    def secret(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("secret")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementNamedValueTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementNamedValueConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementNamedValueTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementNamedValueTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementNamedValueTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementOpenidConnectProvider(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementOpenidConnectProvider",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        client_id: builtins.str,
        client_secret: builtins.str,
        display_name: builtins.str,
        metadata_endpoint: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementOpenidConnectProviderTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param client_id: -
        :param client_secret: -
        :param display_name: -
        :param metadata_endpoint: -
        :param name: -
        :param resource_group_name: -
        :param description: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementOpenidConnectProviderConfig(
            api_management_name=api_management_name,
            client_id=client_id,
            client_secret=client_secret,
            display_name=display_name,
            metadata_endpoint=metadata_endpoint,
            name=name,
            resource_group_name=resource_group_name,
            description=description,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementOpenidConnectProvider, self, [scope, id, config])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return jsii.invoke(self, "resetDescription", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientIdInput")
    def client_id_input(self) -> builtins.str:
        return jsii.get(self, "clientIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecretInput")
    def client_secret_input(self) -> builtins.str:
        return jsii.get(self, "clientSecretInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="metadataEndpointInput")
    def metadata_endpoint_input(self) -> builtins.str:
        return jsii.get(self, "metadataEndpointInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "descriptionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["ApiManagementOpenidConnectProviderTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientId")
    def client_id(self) -> builtins.str:
        return jsii.get(self, "clientId")

    @client_id.setter # type: ignore
    def client_id(self, value: builtins.str) -> None:
        jsii.set(self, "clientId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientSecret")
    def client_secret(self) -> builtins.str:
        return jsii.get(self, "clientSecret")

    @client_secret.setter # type: ignore
    def client_secret(self, value: builtins.str) -> None:
        jsii.set(self, "clientSecret", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="metadataEndpoint")
    def metadata_endpoint(self) -> builtins.str:
        return jsii.get(self, "metadataEndpoint")

    @metadata_endpoint.setter # type: ignore
    def metadata_endpoint(self, value: builtins.str) -> None:
        jsii.set(self, "metadataEndpoint", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementOpenidConnectProviderTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementOpenidConnectProviderTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementOpenidConnectProviderConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "display_name": "displayName",
        "metadata_endpoint": "metadataEndpoint",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "description": "description",
        "timeouts": "timeouts",
    },
)
class ApiManagementOpenidConnectProviderConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        client_id: builtins.str,
        client_secret: builtins.str,
        display_name: builtins.str,
        metadata_endpoint: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementOpenidConnectProviderTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param client_id: -
        :param client_secret: -
        :param display_name: -
        :param metadata_endpoint: -
        :param name: -
        :param resource_group_name: -
        :param description: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementOpenidConnectProviderTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "client_id": client_id,
            "client_secret": client_secret,
            "display_name": display_name,
            "metadata_endpoint": metadata_endpoint,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def client_secret(self) -> builtins.str:
        result = self._values.get("client_secret")
        assert result is not None, "Required property 'client_secret' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def metadata_endpoint(self) -> builtins.str:
        result = self._values.get("metadata_endpoint")
        assert result is not None, "Required property 'metadata_endpoint' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementOpenidConnectProviderTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementOpenidConnectProviderConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementOpenidConnectProviderTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementOpenidConnectProviderTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementOpenidConnectProviderTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementPolicy",
    jsii_struct_bases=[],
    name_mapping={"xml_content": "xmlContent", "xml_link": "xmlLink"},
)
class ApiManagementPolicy:
    def __init__(
        self,
        *,
        xml_content: typing.Optional[builtins.str] = None,
        xml_link: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param xml_content: -
        :param xml_link: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if xml_content is not None:
            self._values["xml_content"] = xml_content
        if xml_link is not None:
            self._values["xml_link"] = xml_link

    @builtins.property
    def xml_content(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_content")
        return result

    @builtins.property
    def xml_link(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_link")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementPolicyA(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementPolicyA",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_id: builtins.str,
        timeouts: typing.Optional["ApiManagementPolicyTimeouts"] = None,
        xml_content: typing.Optional[builtins.str] = None,
        xml_link: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_id: -
        :param timeouts: timeouts block.
        :param xml_content: -
        :param xml_link: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementPolicyAConfig(
            api_management_id=api_management_id,
            timeouts=timeouts,
            xml_content=xml_content,
            xml_link=xml_link,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementPolicyA, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetXmlContent")
    def reset_xml_content(self) -> None:
        return jsii.invoke(self, "resetXmlContent", [])

    @jsii.member(jsii_name="resetXmlLink")
    def reset_xml_link(self) -> None:
        return jsii.invoke(self, "resetXmlLink", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementIdInput")
    def api_management_id_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementPolicyTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlContentInput")
    def xml_content_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "xmlContentInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlLinkInput")
    def xml_link_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "xmlLinkInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementId")
    def api_management_id(self) -> builtins.str:
        return jsii.get(self, "apiManagementId")

    @api_management_id.setter # type: ignore
    def api_management_id(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementPolicyTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementPolicyTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlContent")
    def xml_content(self) -> builtins.str:
        return jsii.get(self, "xmlContent")

    @xml_content.setter # type: ignore
    def xml_content(self, value: builtins.str) -> None:
        jsii.set(self, "xmlContent", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlLink")
    def xml_link(self) -> builtins.str:
        return jsii.get(self, "xmlLink")

    @xml_link.setter # type: ignore
    def xml_link(self, value: builtins.str) -> None:
        jsii.set(self, "xmlLink", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementPolicyAConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_id": "apiManagementId",
        "timeouts": "timeouts",
        "xml_content": "xmlContent",
        "xml_link": "xmlLink",
    },
)
class ApiManagementPolicyAConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_id: builtins.str,
        timeouts: typing.Optional["ApiManagementPolicyTimeouts"] = None,
        xml_content: typing.Optional[builtins.str] = None,
        xml_link: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_id: -
        :param timeouts: timeouts block.
        :param xml_content: -
        :param xml_link: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementPolicyTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_id": api_management_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if xml_content is not None:
            self._values["xml_content"] = xml_content
        if xml_link is not None:
            self._values["xml_link"] = xml_link

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_id(self) -> builtins.str:
        result = self._values.get("api_management_id")
        assert result is not None, "Required property 'api_management_id' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementPolicyTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def xml_content(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_content")
        return result

    @builtins.property
    def xml_link(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_link")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementPolicyAConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementPolicyTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementPolicyTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementPolicyTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementProduct(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementProduct",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        display_name: builtins.str,
        product_id: builtins.str,
        published: builtins.bool,
        resource_group_name: builtins.str,
        subscription_required: builtins.bool,
        approval_required: typing.Optional[builtins.bool] = None,
        description: typing.Optional[builtins.str] = None,
        subscriptions_limit: typing.Optional[jsii.Number] = None,
        terms: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementProductTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param display_name: -
        :param product_id: -
        :param published: -
        :param resource_group_name: -
        :param subscription_required: -
        :param approval_required: -
        :param description: -
        :param subscriptions_limit: -
        :param terms: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementProductConfig(
            api_management_name=api_management_name,
            display_name=display_name,
            product_id=product_id,
            published=published,
            resource_group_name=resource_group_name,
            subscription_required=subscription_required,
            approval_required=approval_required,
            description=description,
            subscriptions_limit=subscriptions_limit,
            terms=terms,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementProduct, self, [scope, id, config])

    @jsii.member(jsii_name="resetApprovalRequired")
    def reset_approval_required(self) -> None:
        return jsii.invoke(self, "resetApprovalRequired", [])

    @jsii.member(jsii_name="resetDescription")
    def reset_description(self) -> None:
        return jsii.invoke(self, "resetDescription", [])

    @jsii.member(jsii_name="resetSubscriptionsLimit")
    def reset_subscriptions_limit(self) -> None:
        return jsii.invoke(self, "resetSubscriptionsLimit", [])

    @jsii.member(jsii_name="resetTerms")
    def reset_terms(self) -> None:
        return jsii.invoke(self, "resetTerms", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productIdInput")
    def product_id_input(self) -> builtins.str:
        return jsii.get(self, "productIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="publishedInput")
    def published_input(self) -> builtins.bool:
        return jsii.get(self, "publishedInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionRequiredInput")
    def subscription_required_input(self) -> builtins.bool:
        return jsii.get(self, "subscriptionRequiredInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="approvalRequiredInput")
    def approval_required_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "approvalRequiredInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="descriptionInput")
    def description_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "descriptionInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionsLimitInput")
    def subscriptions_limit_input(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "subscriptionsLimitInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="termsInput")
    def terms_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "termsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementProductTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="approvalRequired")
    def approval_required(self) -> builtins.bool:
        return jsii.get(self, "approvalRequired")

    @approval_required.setter # type: ignore
    def approval_required(self, value: builtins.bool) -> None:
        jsii.set(self, "approvalRequired", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> builtins.str:
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: builtins.str) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productId")
    def product_id(self) -> builtins.str:
        return jsii.get(self, "productId")

    @product_id.setter # type: ignore
    def product_id(self, value: builtins.str) -> None:
        jsii.set(self, "productId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="published")
    def published(self) -> builtins.bool:
        return jsii.get(self, "published")

    @published.setter # type: ignore
    def published(self, value: builtins.bool) -> None:
        jsii.set(self, "published", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionRequired")
    def subscription_required(self) -> builtins.bool:
        return jsii.get(self, "subscriptionRequired")

    @subscription_required.setter # type: ignore
    def subscription_required(self, value: builtins.bool) -> None:
        jsii.set(self, "subscriptionRequired", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionsLimit")
    def subscriptions_limit(self) -> jsii.Number:
        return jsii.get(self, "subscriptionsLimit")

    @subscriptions_limit.setter # type: ignore
    def subscriptions_limit(self, value: jsii.Number) -> None:
        jsii.set(self, "subscriptionsLimit", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="terms")
    def terms(self) -> builtins.str:
        return jsii.get(self, "terms")

    @terms.setter # type: ignore
    def terms(self, value: builtins.str) -> None:
        jsii.set(self, "terms", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementProductTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementProductTimeouts") -> None:
        jsii.set(self, "timeouts", value)


class ApiManagementProductApi(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementProductApi",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        api_name: builtins.str,
        product_id: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementProductApiTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param api_name: -
        :param product_id: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementProductApiConfig(
            api_management_name=api_management_name,
            api_name=api_name,
            product_id=product_id,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementProductApi, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiNameInput")
    def api_name_input(self) -> builtins.str:
        return jsii.get(self, "apiNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productIdInput")
    def product_id_input(self) -> builtins.str:
        return jsii.get(self, "productIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementProductApiTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiName")
    def api_name(self) -> builtins.str:
        return jsii.get(self, "apiName")

    @api_name.setter # type: ignore
    def api_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productId")
    def product_id(self) -> builtins.str:
        return jsii.get(self, "productId")

    @product_id.setter # type: ignore
    def product_id(self, value: builtins.str) -> None:
        jsii.set(self, "productId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementProductApiTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementProductApiTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementProductApiConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "api_name": "apiName",
        "product_id": "productId",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
    },
)
class ApiManagementProductApiConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        api_name: builtins.str,
        product_id: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementProductApiTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param api_name: -
        :param product_id: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementProductApiTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "api_name": api_name,
            "product_id": product_id,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def api_name(self) -> builtins.str:
        result = self._values.get("api_name")
        assert result is not None, "Required property 'api_name' is missing"
        return result

    @builtins.property
    def product_id(self) -> builtins.str:
        result = self._values.get("product_id")
        assert result is not None, "Required property 'product_id' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementProductApiTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementProductApiConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementProductApiTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementProductApiTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementProductApiTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementProductConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "display_name": "displayName",
        "product_id": "productId",
        "published": "published",
        "resource_group_name": "resourceGroupName",
        "subscription_required": "subscriptionRequired",
        "approval_required": "approvalRequired",
        "description": "description",
        "subscriptions_limit": "subscriptionsLimit",
        "terms": "terms",
        "timeouts": "timeouts",
    },
)
class ApiManagementProductConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        display_name: builtins.str,
        product_id: builtins.str,
        published: builtins.bool,
        resource_group_name: builtins.str,
        subscription_required: builtins.bool,
        approval_required: typing.Optional[builtins.bool] = None,
        description: typing.Optional[builtins.str] = None,
        subscriptions_limit: typing.Optional[jsii.Number] = None,
        terms: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementProductTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param display_name: -
        :param product_id: -
        :param published: -
        :param resource_group_name: -
        :param subscription_required: -
        :param approval_required: -
        :param description: -
        :param subscriptions_limit: -
        :param terms: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementProductTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "display_name": display_name,
            "product_id": product_id,
            "published": published,
            "resource_group_name": resource_group_name,
            "subscription_required": subscription_required,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if approval_required is not None:
            self._values["approval_required"] = approval_required
        if description is not None:
            self._values["description"] = description
        if subscriptions_limit is not None:
            self._values["subscriptions_limit"] = subscriptions_limit
        if terms is not None:
            self._values["terms"] = terms
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def product_id(self) -> builtins.str:
        result = self._values.get("product_id")
        assert result is not None, "Required property 'product_id' is missing"
        return result

    @builtins.property
    def published(self) -> builtins.bool:
        result = self._values.get("published")
        assert result is not None, "Required property 'published' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def subscription_required(self) -> builtins.bool:
        result = self._values.get("subscription_required")
        assert result is not None, "Required property 'subscription_required' is missing"
        return result

    @builtins.property
    def approval_required(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("approval_required")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        result = self._values.get("description")
        return result

    @builtins.property
    def subscriptions_limit(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("subscriptions_limit")
        return result

    @builtins.property
    def terms(self) -> typing.Optional[builtins.str]:
        result = self._values.get("terms")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementProductTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementProductConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementProductGroup(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementProductGroup",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        group_name: builtins.str,
        product_id: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementProductGroupTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param group_name: -
        :param product_id: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementProductGroupConfig(
            api_management_name=api_management_name,
            group_name=group_name,
            product_id=product_id,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementProductGroup, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupNameInput")
    def group_name_input(self) -> builtins.str:
        return jsii.get(self, "groupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productIdInput")
    def product_id_input(self) -> builtins.str:
        return jsii.get(self, "productIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementProductGroupTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupName")
    def group_name(self) -> builtins.str:
        return jsii.get(self, "groupName")

    @group_name.setter # type: ignore
    def group_name(self, value: builtins.str) -> None:
        jsii.set(self, "groupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productId")
    def product_id(self) -> builtins.str:
        return jsii.get(self, "productId")

    @product_id.setter # type: ignore
    def product_id(self, value: builtins.str) -> None:
        jsii.set(self, "productId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementProductGroupTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementProductGroupTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementProductGroupConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "group_name": "groupName",
        "product_id": "productId",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
    },
)
class ApiManagementProductGroupConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        group_name: builtins.str,
        product_id: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementProductGroupTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param group_name: -
        :param product_id: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementProductGroupTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "group_name": group_name,
            "product_id": product_id,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def group_name(self) -> builtins.str:
        result = self._values.get("group_name")
        assert result is not None, "Required property 'group_name' is missing"
        return result

    @builtins.property
    def product_id(self) -> builtins.str:
        result = self._values.get("product_id")
        assert result is not None, "Required property 'product_id' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementProductGroupTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementProductGroupConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementProductGroupTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementProductGroupTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementProductGroupTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementProductPolicy(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementProductPolicy",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        product_id: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementProductPolicyTimeouts"] = None,
        xml_content: typing.Optional[builtins.str] = None,
        xml_link: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param product_id: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param xml_content: -
        :param xml_link: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementProductPolicyConfig(
            api_management_name=api_management_name,
            product_id=product_id,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            xml_content=xml_content,
            xml_link=xml_link,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementProductPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetXmlContent")
    def reset_xml_content(self) -> None:
        return jsii.invoke(self, "resetXmlContent", [])

    @jsii.member(jsii_name="resetXmlLink")
    def reset_xml_link(self) -> None:
        return jsii.invoke(self, "resetXmlLink", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productIdInput")
    def product_id_input(self) -> builtins.str:
        return jsii.get(self, "productIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementProductPolicyTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlContentInput")
    def xml_content_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "xmlContentInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlLinkInput")
    def xml_link_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "xmlLinkInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productId")
    def product_id(self) -> builtins.str:
        return jsii.get(self, "productId")

    @product_id.setter # type: ignore
    def product_id(self, value: builtins.str) -> None:
        jsii.set(self, "productId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementProductPolicyTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementProductPolicyTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlContent")
    def xml_content(self) -> builtins.str:
        return jsii.get(self, "xmlContent")

    @xml_content.setter # type: ignore
    def xml_content(self, value: builtins.str) -> None:
        jsii.set(self, "xmlContent", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="xmlLink")
    def xml_link(self) -> builtins.str:
        return jsii.get(self, "xmlLink")

    @xml_link.setter # type: ignore
    def xml_link(self, value: builtins.str) -> None:
        jsii.set(self, "xmlLink", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementProductPolicyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "product_id": "productId",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
        "xml_content": "xmlContent",
        "xml_link": "xmlLink",
    },
)
class ApiManagementProductPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        product_id: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["ApiManagementProductPolicyTimeouts"] = None,
        xml_content: typing.Optional[builtins.str] = None,
        xml_link: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param product_id: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param xml_content: -
        :param xml_link: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementProductPolicyTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "product_id": product_id,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if xml_content is not None:
            self._values["xml_content"] = xml_content
        if xml_link is not None:
            self._values["xml_link"] = xml_link

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def product_id(self) -> builtins.str:
        result = self._values.get("product_id")
        assert result is not None, "Required property 'product_id' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementProductPolicyTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def xml_content(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_content")
        return result

    @builtins.property
    def xml_link(self) -> typing.Optional[builtins.str]:
        result = self._values.get("xml_link")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementProductPolicyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementProductPolicyTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementProductPolicyTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementProductPolicyTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementProductTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementProductTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementProductTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementProperty(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementProperty",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        value: builtins.str,
        secret: typing.Optional[builtins.bool] = None,
        tags: typing.Optional[typing.List[builtins.str]] = None,
        timeouts: typing.Optional["ApiManagementPropertyTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param resource_group_name: -
        :param value: -
        :param secret: -
        :param tags: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementPropertyConfig(
            api_management_name=api_management_name,
            display_name=display_name,
            name=name,
            resource_group_name=resource_group_name,
            value=value,
            secret=secret,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementProperty, self, [scope, id, config])

    @jsii.member(jsii_name="resetSecret")
    def reset_secret(self) -> None:
        return jsii.invoke(self, "resetSecret", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="valueInput")
    def value_input(self) -> builtins.str:
        return jsii.get(self, "valueInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secretInput")
    def secret_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "secretInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementPropertyTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secret")
    def secret(self) -> builtins.bool:
        return jsii.get(self, "secret")

    @secret.setter # type: ignore
    def secret(self, value: builtins.bool) -> None:
        jsii.set(self, "secret", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.List[builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementPropertyTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementPropertyTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="value")
    def value(self) -> builtins.str:
        return jsii.get(self, "value")

    @value.setter # type: ignore
    def value(self, value: builtins.str) -> None:
        jsii.set(self, "value", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementPropertyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "display_name": "displayName",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "value": "value",
        "secret": "secret",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class ApiManagementPropertyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        display_name: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        value: builtins.str,
        secret: typing.Optional[builtins.bool] = None,
        tags: typing.Optional[typing.List[builtins.str]] = None,
        timeouts: typing.Optional["ApiManagementPropertyTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param display_name: -
        :param name: -
        :param resource_group_name: -
        :param value: -
        :param secret: -
        :param tags: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementPropertyTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "display_name": display_name,
            "name": name,
            "resource_group_name": resource_group_name,
            "value": value,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if secret is not None:
            self._values["secret"] = secret
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def value(self) -> builtins.str:
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return result

    @builtins.property
    def secret(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("secret")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementPropertyTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementPropertyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementPropertyTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementPropertyTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementPropertyTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementProtocols",
    jsii_struct_bases=[],
    name_mapping={"enable_http2": "enableHttp2"},
)
class ApiManagementProtocols:
    def __init__(self, *, enable_http2: typing.Optional[builtins.bool] = None) -> None:
        """
        :param enable_http2: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if enable_http2 is not None:
            self._values["enable_http2"] = enable_http2

    @builtins.property
    def enable_http2(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_http2")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementProtocols(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementSecurity",
    jsii_struct_bases=[],
    name_mapping={
        "enable_backend_ssl30": "enableBackendSsl30",
        "enable_backend_tls10": "enableBackendTls10",
        "enable_backend_tls11": "enableBackendTls11",
        "enable_frontend_ssl30": "enableFrontendSsl30",
        "enable_frontend_tls10": "enableFrontendTls10",
        "enable_frontend_tls11": "enableFrontendTls11",
        "enable_triple_des_ciphers": "enableTripleDesCiphers",
    },
)
class ApiManagementSecurity:
    def __init__(
        self,
        *,
        enable_backend_ssl30: typing.Optional[builtins.bool] = None,
        enable_backend_tls10: typing.Optional[builtins.bool] = None,
        enable_backend_tls11: typing.Optional[builtins.bool] = None,
        enable_frontend_ssl30: typing.Optional[builtins.bool] = None,
        enable_frontend_tls10: typing.Optional[builtins.bool] = None,
        enable_frontend_tls11: typing.Optional[builtins.bool] = None,
        enable_triple_des_ciphers: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param enable_backend_ssl30: -
        :param enable_backend_tls10: -
        :param enable_backend_tls11: -
        :param enable_frontend_ssl30: -
        :param enable_frontend_tls10: -
        :param enable_frontend_tls11: -
        :param enable_triple_des_ciphers: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if enable_backend_ssl30 is not None:
            self._values["enable_backend_ssl30"] = enable_backend_ssl30
        if enable_backend_tls10 is not None:
            self._values["enable_backend_tls10"] = enable_backend_tls10
        if enable_backend_tls11 is not None:
            self._values["enable_backend_tls11"] = enable_backend_tls11
        if enable_frontend_ssl30 is not None:
            self._values["enable_frontend_ssl30"] = enable_frontend_ssl30
        if enable_frontend_tls10 is not None:
            self._values["enable_frontend_tls10"] = enable_frontend_tls10
        if enable_frontend_tls11 is not None:
            self._values["enable_frontend_tls11"] = enable_frontend_tls11
        if enable_triple_des_ciphers is not None:
            self._values["enable_triple_des_ciphers"] = enable_triple_des_ciphers

    @builtins.property
    def enable_backend_ssl30(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_backend_ssl30")
        return result

    @builtins.property
    def enable_backend_tls10(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_backend_tls10")
        return result

    @builtins.property
    def enable_backend_tls11(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_backend_tls11")
        return result

    @builtins.property
    def enable_frontend_ssl30(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_frontend_ssl30")
        return result

    @builtins.property
    def enable_frontend_tls10(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_frontend_tls10")
        return result

    @builtins.property
    def enable_frontend_tls11(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_frontend_tls11")
        return result

    @builtins.property
    def enable_triple_des_ciphers(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_triple_des_ciphers")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementSecurity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementSignIn",
    jsii_struct_bases=[],
    name_mapping={"enabled": "enabled"},
)
class ApiManagementSignIn:
    def __init__(self, *, enabled: builtins.bool) -> None:
        """
        :param enabled: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "enabled": enabled,
        }

    @builtins.property
    def enabled(self) -> builtins.bool:
        result = self._values.get("enabled")
        assert result is not None, "Required property 'enabled' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementSignIn(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementSignUp",
    jsii_struct_bases=[],
    name_mapping={"enabled": "enabled", "terms_of_service": "termsOfService"},
)
class ApiManagementSignUp:
    def __init__(
        self,
        *,
        enabled: builtins.bool,
        terms_of_service: typing.List["ApiManagementSignUpTermsOfService"],
    ) -> None:
        """
        :param enabled: -
        :param terms_of_service: terms_of_service block.
        """
        self._values: typing.Dict[str, typing.Any] = {
            "enabled": enabled,
            "terms_of_service": terms_of_service,
        }

    @builtins.property
    def enabled(self) -> builtins.bool:
        result = self._values.get("enabled")
        assert result is not None, "Required property 'enabled' is missing"
        return result

    @builtins.property
    def terms_of_service(self) -> typing.List["ApiManagementSignUpTermsOfService"]:
        """terms_of_service block."""
        result = self._values.get("terms_of_service")
        assert result is not None, "Required property 'terms_of_service' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementSignUp(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementSignUpTermsOfService",
    jsii_struct_bases=[],
    name_mapping={
        "consent_required": "consentRequired",
        "enabled": "enabled",
        "text": "text",
    },
)
class ApiManagementSignUpTermsOfService:
    def __init__(
        self,
        *,
        consent_required: builtins.bool,
        enabled: builtins.bool,
        text: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param consent_required: -
        :param enabled: -
        :param text: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "consent_required": consent_required,
            "enabled": enabled,
        }
        if text is not None:
            self._values["text"] = text

    @builtins.property
    def consent_required(self) -> builtins.bool:
        result = self._values.get("consent_required")
        assert result is not None, "Required property 'consent_required' is missing"
        return result

    @builtins.property
    def enabled(self) -> builtins.bool:
        result = self._values.get("enabled")
        assert result is not None, "Required property 'enabled' is missing"
        return result

    @builtins.property
    def text(self) -> typing.Optional[builtins.str]:
        result = self._values.get("text")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementSignUpTermsOfService(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementSubscription(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementSubscription",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        display_name: builtins.str,
        resource_group_name: builtins.str,
        user_id: builtins.str,
        allow_tracing: typing.Optional[builtins.bool] = None,
        primary_key: typing.Optional[builtins.str] = None,
        product_id: typing.Optional[builtins.str] = None,
        secondary_key: typing.Optional[builtins.str] = None,
        state: typing.Optional[builtins.str] = None,
        subscription_id: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementSubscriptionTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param display_name: -
        :param resource_group_name: -
        :param user_id: -
        :param allow_tracing: -
        :param primary_key: -
        :param product_id: -
        :param secondary_key: -
        :param state: -
        :param subscription_id: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementSubscriptionConfig(
            api_management_name=api_management_name,
            display_name=display_name,
            resource_group_name=resource_group_name,
            user_id=user_id,
            allow_tracing=allow_tracing,
            primary_key=primary_key,
            product_id=product_id,
            secondary_key=secondary_key,
            state=state,
            subscription_id=subscription_id,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementSubscription, self, [scope, id, config])

    @jsii.member(jsii_name="resetAllowTracing")
    def reset_allow_tracing(self) -> None:
        return jsii.invoke(self, "resetAllowTracing", [])

    @jsii.member(jsii_name="resetPrimaryKey")
    def reset_primary_key(self) -> None:
        return jsii.invoke(self, "resetPrimaryKey", [])

    @jsii.member(jsii_name="resetProductId")
    def reset_product_id(self) -> None:
        return jsii.invoke(self, "resetProductId", [])

    @jsii.member(jsii_name="resetSecondaryKey")
    def reset_secondary_key(self) -> None:
        return jsii.invoke(self, "resetSecondaryKey", [])

    @jsii.member(jsii_name="resetState")
    def reset_state(self) -> None:
        return jsii.invoke(self, "resetState", [])

    @jsii.member(jsii_name="resetSubscriptionId")
    def reset_subscription_id(self) -> None:
        return jsii.invoke(self, "resetSubscriptionId", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayNameInput")
    def display_name_input(self) -> builtins.str:
        return jsii.get(self, "displayNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userIdInput")
    def user_id_input(self) -> builtins.str:
        return jsii.get(self, "userIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="allowTracingInput")
    def allow_tracing_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "allowTracingInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="primaryKeyInput")
    def primary_key_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "primaryKeyInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productIdInput")
    def product_id_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "productIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secondaryKeyInput")
    def secondary_key_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "secondaryKeyInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stateInput")
    def state_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "stateInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionIdInput")
    def subscription_id_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "subscriptionIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementSubscriptionTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="allowTracing")
    def allow_tracing(self) -> builtins.bool:
        return jsii.get(self, "allowTracing")

    @allow_tracing.setter # type: ignore
    def allow_tracing(self, value: builtins.bool) -> None:
        jsii.set(self, "allowTracing", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        return jsii.get(self, "displayName")

    @display_name.setter # type: ignore
    def display_name(self, value: builtins.str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="primaryKey")
    def primary_key(self) -> builtins.str:
        return jsii.get(self, "primaryKey")

    @primary_key.setter # type: ignore
    def primary_key(self, value: builtins.str) -> None:
        jsii.set(self, "primaryKey", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productId")
    def product_id(self) -> builtins.str:
        return jsii.get(self, "productId")

    @product_id.setter # type: ignore
    def product_id(self, value: builtins.str) -> None:
        jsii.set(self, "productId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secondaryKey")
    def secondary_key(self) -> builtins.str:
        return jsii.get(self, "secondaryKey")

    @secondary_key.setter # type: ignore
    def secondary_key(self, value: builtins.str) -> None:
        jsii.set(self, "secondaryKey", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="state")
    def state(self) -> builtins.str:
        return jsii.get(self, "state")

    @state.setter # type: ignore
    def state(self, value: builtins.str) -> None:
        jsii.set(self, "state", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        return jsii.get(self, "subscriptionId")

    @subscription_id.setter # type: ignore
    def subscription_id(self, value: builtins.str) -> None:
        jsii.set(self, "subscriptionId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementSubscriptionTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementSubscriptionTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userId")
    def user_id(self) -> builtins.str:
        return jsii.get(self, "userId")

    @user_id.setter # type: ignore
    def user_id(self, value: builtins.str) -> None:
        jsii.set(self, "userId", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementSubscriptionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "display_name": "displayName",
        "resource_group_name": "resourceGroupName",
        "user_id": "userId",
        "allow_tracing": "allowTracing",
        "primary_key": "primaryKey",
        "product_id": "productId",
        "secondary_key": "secondaryKey",
        "state": "state",
        "subscription_id": "subscriptionId",
        "timeouts": "timeouts",
    },
)
class ApiManagementSubscriptionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        display_name: builtins.str,
        resource_group_name: builtins.str,
        user_id: builtins.str,
        allow_tracing: typing.Optional[builtins.bool] = None,
        primary_key: typing.Optional[builtins.str] = None,
        product_id: typing.Optional[builtins.str] = None,
        secondary_key: typing.Optional[builtins.str] = None,
        state: typing.Optional[builtins.str] = None,
        subscription_id: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementSubscriptionTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param display_name: -
        :param resource_group_name: -
        :param user_id: -
        :param allow_tracing: -
        :param primary_key: -
        :param product_id: -
        :param secondary_key: -
        :param state: -
        :param subscription_id: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementSubscriptionTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "display_name": display_name,
            "resource_group_name": resource_group_name,
            "user_id": user_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if allow_tracing is not None:
            self._values["allow_tracing"] = allow_tracing
        if primary_key is not None:
            self._values["primary_key"] = primary_key
        if product_id is not None:
            self._values["product_id"] = product_id
        if secondary_key is not None:
            self._values["secondary_key"] = secondary_key
        if state is not None:
            self._values["state"] = state
        if subscription_id is not None:
            self._values["subscription_id"] = subscription_id
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def display_name(self) -> builtins.str:
        result = self._values.get("display_name")
        assert result is not None, "Required property 'display_name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def user_id(self) -> builtins.str:
        result = self._values.get("user_id")
        assert result is not None, "Required property 'user_id' is missing"
        return result

    @builtins.property
    def allow_tracing(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("allow_tracing")
        return result

    @builtins.property
    def primary_key(self) -> typing.Optional[builtins.str]:
        result = self._values.get("primary_key")
        return result

    @builtins.property
    def product_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("product_id")
        return result

    @builtins.property
    def secondary_key(self) -> typing.Optional[builtins.str]:
        result = self._values.get("secondary_key")
        return result

    @builtins.property
    def state(self) -> typing.Optional[builtins.str]:
        result = self._values.get("state")
        return result

    @builtins.property
    def subscription_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("subscription_id")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementSubscriptionTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementSubscriptionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementSubscriptionTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementSubscriptionTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementSubscriptionTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiManagementUser(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApiManagementUser",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        api_management_name: builtins.str,
        email: builtins.str,
        first_name: builtins.str,
        last_name: builtins.str,
        resource_group_name: builtins.str,
        user_id: builtins.str,
        confirmation: typing.Optional[builtins.str] = None,
        note: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        state: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementUserTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_management_name: -
        :param email: -
        :param first_name: -
        :param last_name: -
        :param resource_group_name: -
        :param user_id: -
        :param confirmation: -
        :param note: -
        :param password: -
        :param state: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiManagementUserConfig(
            api_management_name=api_management_name,
            email=email,
            first_name=first_name,
            last_name=last_name,
            resource_group_name=resource_group_name,
            user_id=user_id,
            confirmation=confirmation,
            note=note,
            password=password,
            state=state,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiManagementUser, self, [scope, id, config])

    @jsii.member(jsii_name="resetConfirmation")
    def reset_confirmation(self) -> None:
        return jsii.invoke(self, "resetConfirmation", [])

    @jsii.member(jsii_name="resetNote")
    def reset_note(self) -> None:
        return jsii.invoke(self, "resetNote", [])

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return jsii.invoke(self, "resetPassword", [])

    @jsii.member(jsii_name="resetState")
    def reset_state(self) -> None:
        return jsii.invoke(self, "resetState", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementNameInput")
    def api_management_name_input(self) -> builtins.str:
        return jsii.get(self, "apiManagementNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="emailInput")
    def email_input(self) -> builtins.str:
        return jsii.get(self, "emailInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="firstNameInput")
    def first_name_input(self) -> builtins.str:
        return jsii.get(self, "firstNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="lastNameInput")
    def last_name_input(self) -> builtins.str:
        return jsii.get(self, "lastNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userIdInput")
    def user_id_input(self) -> builtins.str:
        return jsii.get(self, "userIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="confirmationInput")
    def confirmation_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "confirmationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="noteInput")
    def note_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "noteInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "passwordInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stateInput")
    def state_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "stateInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["ApiManagementUserTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="apiManagementName")
    def api_management_name(self) -> builtins.str:
        return jsii.get(self, "apiManagementName")

    @api_management_name.setter # type: ignore
    def api_management_name(self, value: builtins.str) -> None:
        jsii.set(self, "apiManagementName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="confirmation")
    def confirmation(self) -> builtins.str:
        return jsii.get(self, "confirmation")

    @confirmation.setter # type: ignore
    def confirmation(self, value: builtins.str) -> None:
        jsii.set(self, "confirmation", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="email")
    def email(self) -> builtins.str:
        return jsii.get(self, "email")

    @email.setter # type: ignore
    def email(self, value: builtins.str) -> None:
        jsii.set(self, "email", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="firstName")
    def first_name(self) -> builtins.str:
        return jsii.get(self, "firstName")

    @first_name.setter # type: ignore
    def first_name(self, value: builtins.str) -> None:
        jsii.set(self, "firstName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="lastName")
    def last_name(self) -> builtins.str:
        return jsii.get(self, "lastName")

    @last_name.setter # type: ignore
    def last_name(self, value: builtins.str) -> None:
        jsii.set(self, "lastName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="note")
    def note(self) -> builtins.str:
        return jsii.get(self, "note")

    @note.setter # type: ignore
    def note(self, value: builtins.str) -> None:
        jsii.set(self, "note", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return jsii.get(self, "password")

    @password.setter # type: ignore
    def password(self, value: builtins.str) -> None:
        jsii.set(self, "password", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="state")
    def state(self) -> builtins.str:
        return jsii.get(self, "state")

    @state.setter # type: ignore
    def state(self, value: builtins.str) -> None:
        jsii.set(self, "state", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "ApiManagementUserTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "ApiManagementUserTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userId")
    def user_id(self) -> builtins.str:
        return jsii.get(self, "userId")

    @user_id.setter # type: ignore
    def user_id(self, value: builtins.str) -> None:
        jsii.set(self, "userId", value)


@jsii.data_type(
    jsii_type="azurerm.ApiManagementUserConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_management_name": "apiManagementName",
        "email": "email",
        "first_name": "firstName",
        "last_name": "lastName",
        "resource_group_name": "resourceGroupName",
        "user_id": "userId",
        "confirmation": "confirmation",
        "note": "note",
        "password": "password",
        "state": "state",
        "timeouts": "timeouts",
    },
)
class ApiManagementUserConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_management_name: builtins.str,
        email: builtins.str,
        first_name: builtins.str,
        last_name: builtins.str,
        resource_group_name: builtins.str,
        user_id: builtins.str,
        confirmation: typing.Optional[builtins.str] = None,
        note: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        state: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["ApiManagementUserTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_management_name: -
        :param email: -
        :param first_name: -
        :param last_name: -
        :param resource_group_name: -
        :param user_id: -
        :param confirmation: -
        :param note: -
        :param password: -
        :param state: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = ApiManagementUserTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "api_management_name": api_management_name,
            "email": email,
            "first_name": first_name,
            "last_name": last_name,
            "resource_group_name": resource_group_name,
            "user_id": user_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if confirmation is not None:
            self._values["confirmation"] = confirmation
        if note is not None:
            self._values["note"] = note
        if password is not None:
            self._values["password"] = password
        if state is not None:
            self._values["state"] = state
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def api_management_name(self) -> builtins.str:
        result = self._values.get("api_management_name")
        assert result is not None, "Required property 'api_management_name' is missing"
        return result

    @builtins.property
    def email(self) -> builtins.str:
        result = self._values.get("email")
        assert result is not None, "Required property 'email' is missing"
        return result

    @builtins.property
    def first_name(self) -> builtins.str:
        result = self._values.get("first_name")
        assert result is not None, "Required property 'first_name' is missing"
        return result

    @builtins.property
    def last_name(self) -> builtins.str:
        result = self._values.get("last_name")
        assert result is not None, "Required property 'last_name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def user_id(self) -> builtins.str:
        result = self._values.get("user_id")
        assert result is not None, "Required property 'user_id' is missing"
        return result

    @builtins.property
    def confirmation(self) -> typing.Optional[builtins.str]:
        result = self._values.get("confirmation")
        return result

    @builtins.property
    def note(self) -> typing.Optional[builtins.str]:
        result = self._values.get("note")
        return result

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("password")
        return result

    @builtins.property
    def state(self) -> typing.Optional[builtins.str]:
        result = self._values.get("state")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["ApiManagementUserTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementUserConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementUserTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class ApiManagementUserTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementUserTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.ApiManagementVirtualNetworkConfiguration",
    jsii_struct_bases=[],
    name_mapping={"subnet_id": "subnetId"},
)
class ApiManagementVirtualNetworkConfiguration:
    def __init__(self, *, subnet_id: builtins.str) -> None:
        """
        :param subnet_id: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "subnet_id": subnet_id,
        }

    @builtins.property
    def subnet_id(self) -> builtins.str:
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiManagementVirtualNetworkConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppConfiguration(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppConfiguration",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        identity: typing.Optional[typing.List["AppConfigurationIdentity"]] = None,
        sku: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppConfigurationTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param identity: identity block.
        :param sku: -
        :param tags: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppConfigurationConfig(
            location=location,
            name=name,
            resource_group_name=resource_group_name,
            identity=identity,
            sku=sku,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppConfiguration, self, [scope, id, config])

    @jsii.member(jsii_name="primaryReadKey")
    def primary_read_key(self, index: builtins.str) -> "AppConfigurationPrimaryReadKey":
        """
        :param index: -
        """
        return jsii.invoke(self, "primaryReadKey", [index])

    @jsii.member(jsii_name="primaryWriteKey")
    def primary_write_key(
        self,
        index: builtins.str,
    ) -> "AppConfigurationPrimaryWriteKey":
        """
        :param index: -
        """
        return jsii.invoke(self, "primaryWriteKey", [index])

    @jsii.member(jsii_name="resetIdentity")
    def reset_identity(self) -> None:
        return jsii.invoke(self, "resetIdentity", [])

    @jsii.member(jsii_name="resetSku")
    def reset_sku(self) -> None:
        return jsii.invoke(self, "resetSku", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="secondaryReadKey")
    def secondary_read_key(
        self,
        index: builtins.str,
    ) -> "AppConfigurationSecondaryReadKey":
        """
        :param index: -
        """
        return jsii.invoke(self, "secondaryReadKey", [index])

    @jsii.member(jsii_name="secondaryWriteKey")
    def secondary_write_key(
        self,
        index: builtins.str,
    ) -> "AppConfigurationSecondaryWriteKey":
        """
        :param index: -
        """
        return jsii.invoke(self, "secondaryWriteKey", [index])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="endpoint")
    def endpoint(self) -> builtins.str:
        return jsii.get(self, "endpoint")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="locationInput")
    def location_input(self) -> builtins.str:
        return jsii.get(self, "locationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identityInput")
    def identity_input(
        self,
    ) -> typing.Optional[typing.List["AppConfigurationIdentity"]]:
        return jsii.get(self, "identityInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="skuInput")
    def sku_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "skuInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppConfigurationTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identity")
    def identity(self) -> typing.List["AppConfigurationIdentity"]:
        return jsii.get(self, "identity")

    @identity.setter # type: ignore
    def identity(self, value: typing.List["AppConfigurationIdentity"]) -> None:
        jsii.set(self, "identity", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(self) -> builtins.str:
        return jsii.get(self, "location")

    @location.setter # type: ignore
    def location(self, value: builtins.str) -> None:
        jsii.set(self, "location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sku")
    def sku(self) -> builtins.str:
        return jsii.get(self, "sku")

    @sku.setter # type: ignore
    def sku(self, value: builtins.str) -> None:
        jsii.set(self, "sku", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppConfigurationTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppConfigurationTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppConfigurationConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "location": "location",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "identity": "identity",
        "sku": "sku",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AppConfigurationConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        identity: typing.Optional[typing.List["AppConfigurationIdentity"]] = None,
        sku: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppConfigurationTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param identity: identity block.
        :param sku: -
        :param tags: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppConfigurationTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "location": location,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if identity is not None:
            self._values["identity"] = identity
        if sku is not None:
            self._values["sku"] = sku
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def location(self) -> builtins.str:
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def identity(self) -> typing.Optional[typing.List["AppConfigurationIdentity"]]:
        """identity block."""
        result = self._values.get("identity")
        return result

    @builtins.property
    def sku(self) -> typing.Optional[builtins.str]:
        result = self._values.get("sku")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppConfigurationTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppConfigurationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppConfigurationIdentity",
    jsii_struct_bases=[],
    name_mapping={"type": "type"},
)
class AppConfigurationIdentity:
    def __init__(self, *, type: builtins.str) -> None:
        """
        :param type: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppConfigurationIdentity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppConfigurationPrimaryReadKey(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppConfigurationPrimaryReadKey",
):
    def __init__(
        self,
        terraform_resource: cdktf.ITerraformResource,
        terraform_attribute: builtins.str,
        index: builtins.str,
    ) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        :stability: experimental
        """
        jsii.create(AppConfigurationPrimaryReadKey, self, [terraform_resource, terraform_attribute, index])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionString")
    def connection_string(self) -> builtins.str:
        return jsii.get(self, "connectionString")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secret")
    def secret(self) -> builtins.str:
        return jsii.get(self, "secret")


class AppConfigurationPrimaryWriteKey(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppConfigurationPrimaryWriteKey",
):
    def __init__(
        self,
        terraform_resource: cdktf.ITerraformResource,
        terraform_attribute: builtins.str,
        index: builtins.str,
    ) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        :stability: experimental
        """
        jsii.create(AppConfigurationPrimaryWriteKey, self, [terraform_resource, terraform_attribute, index])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionString")
    def connection_string(self) -> builtins.str:
        return jsii.get(self, "connectionString")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secret")
    def secret(self) -> builtins.str:
        return jsii.get(self, "secret")


class AppConfigurationSecondaryReadKey(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppConfigurationSecondaryReadKey",
):
    def __init__(
        self,
        terraform_resource: cdktf.ITerraformResource,
        terraform_attribute: builtins.str,
        index: builtins.str,
    ) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        :stability: experimental
        """
        jsii.create(AppConfigurationSecondaryReadKey, self, [terraform_resource, terraform_attribute, index])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionString")
    def connection_string(self) -> builtins.str:
        return jsii.get(self, "connectionString")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secret")
    def secret(self) -> builtins.str:
        return jsii.get(self, "secret")


class AppConfigurationSecondaryWriteKey(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppConfigurationSecondaryWriteKey",
):
    def __init__(
        self,
        terraform_resource: cdktf.ITerraformResource,
        terraform_attribute: builtins.str,
        index: builtins.str,
    ) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        :stability: experimental
        """
        jsii.create(AppConfigurationSecondaryWriteKey, self, [terraform_resource, terraform_attribute, index])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionString")
    def connection_string(self) -> builtins.str:
        return jsii.get(self, "connectionString")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secret")
    def secret(self) -> builtins.str:
        return jsii.get(self, "secret")


@jsii.data_type(
    jsii_type="azurerm.AppConfigurationTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppConfigurationTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppConfigurationTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppService(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppService",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        app_service_plan_id: builtins.str,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        app_settings: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        auth_settings: typing.Optional[typing.List["AppServiceAuthSettings"]] = None,
        backup: typing.Optional[typing.List["AppServiceBackup"]] = None,
        client_affinity_enabled: typing.Optional[builtins.bool] = None,
        client_cert_enabled: typing.Optional[builtins.bool] = None,
        connection_string: typing.Optional[typing.List["AppServiceConnectionString"]] = None,
        enabled: typing.Optional[builtins.bool] = None,
        https_only: typing.Optional[builtins.bool] = None,
        identity: typing.Optional[typing.List["AppServiceIdentity"]] = None,
        logs: typing.Optional[typing.List["AppServiceLogs"]] = None,
        site_config: typing.Optional[typing.List["AppServiceSiteConfig"]] = None,
        source_control: typing.Optional[typing.List["AppServiceSourceControl"]] = None,
        storage_account: typing.Optional[typing.List["AppServiceStorageAccount"]] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param app_service_plan_id: -
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param app_settings: -
        :param auth_settings: auth_settings block.
        :param backup: backup block.
        :param client_affinity_enabled: -
        :param client_cert_enabled: -
        :param connection_string: connection_string block.
        :param enabled: -
        :param https_only: -
        :param identity: identity block.
        :param logs: logs block.
        :param site_config: site_config block.
        :param source_control: source_control block.
        :param storage_account: storage_account block.
        :param tags: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceConfig(
            app_service_plan_id=app_service_plan_id,
            location=location,
            name=name,
            resource_group_name=resource_group_name,
            app_settings=app_settings,
            auth_settings=auth_settings,
            backup=backup,
            client_affinity_enabled=client_affinity_enabled,
            client_cert_enabled=client_cert_enabled,
            connection_string=connection_string,
            enabled=enabled,
            https_only=https_only,
            identity=identity,
            logs=logs,
            site_config=site_config,
            source_control=source_control,
            storage_account=storage_account,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppService, self, [scope, id, config])

    @jsii.member(jsii_name="resetAppSettings")
    def reset_app_settings(self) -> None:
        return jsii.invoke(self, "resetAppSettings", [])

    @jsii.member(jsii_name="resetAuthSettings")
    def reset_auth_settings(self) -> None:
        return jsii.invoke(self, "resetAuthSettings", [])

    @jsii.member(jsii_name="resetBackup")
    def reset_backup(self) -> None:
        return jsii.invoke(self, "resetBackup", [])

    @jsii.member(jsii_name="resetClientAffinityEnabled")
    def reset_client_affinity_enabled(self) -> None:
        return jsii.invoke(self, "resetClientAffinityEnabled", [])

    @jsii.member(jsii_name="resetClientCertEnabled")
    def reset_client_cert_enabled(self) -> None:
        return jsii.invoke(self, "resetClientCertEnabled", [])

    @jsii.member(jsii_name="resetConnectionString")
    def reset_connection_string(self) -> None:
        return jsii.invoke(self, "resetConnectionString", [])

    @jsii.member(jsii_name="resetEnabled")
    def reset_enabled(self) -> None:
        return jsii.invoke(self, "resetEnabled", [])

    @jsii.member(jsii_name="resetHttpsOnly")
    def reset_https_only(self) -> None:
        return jsii.invoke(self, "resetHttpsOnly", [])

    @jsii.member(jsii_name="resetIdentity")
    def reset_identity(self) -> None:
        return jsii.invoke(self, "resetIdentity", [])

    @jsii.member(jsii_name="resetLogs")
    def reset_logs(self) -> None:
        return jsii.invoke(self, "resetLogs", [])

    @jsii.member(jsii_name="resetSiteConfig")
    def reset_site_config(self) -> None:
        return jsii.invoke(self, "resetSiteConfig", [])

    @jsii.member(jsii_name="resetSourceControl")
    def reset_source_control(self) -> None:
        return jsii.invoke(self, "resetSourceControl", [])

    @jsii.member(jsii_name="resetStorageAccount")
    def reset_storage_account(self) -> None:
        return jsii.invoke(self, "resetStorageAccount", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="siteCredential")
    def site_credential(self, index: builtins.str) -> "AppServiceSiteCredential":
        """
        :param index: -
        """
        return jsii.invoke(self, "siteCredential", [index])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServicePlanIdInput")
    def app_service_plan_id_input(self) -> builtins.str:
        return jsii.get(self, "appServicePlanIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> builtins.str:
        return jsii.get(self, "customDomainVerificationId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultSiteHostname")
    def default_site_hostname(self) -> builtins.str:
        return jsii.get(self, "defaultSiteHostname")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="locationInput")
    def location_input(self) -> builtins.str:
        return jsii.get(self, "locationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> builtins.str:
        return jsii.get(self, "outboundIpAddresses")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> builtins.str:
        return jsii.get(self, "possibleOutboundIpAddresses")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appSettingsInput")
    def app_settings_input(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "appSettingsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authSettingsInput")
    def auth_settings_input(
        self,
    ) -> typing.Optional[typing.List["AppServiceAuthSettings"]]:
        return jsii.get(self, "authSettingsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="backupInput")
    def backup_input(self) -> typing.Optional[typing.List["AppServiceBackup"]]:
        return jsii.get(self, "backupInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientAffinityEnabledInput")
    def client_affinity_enabled_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "clientAffinityEnabledInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientCertEnabledInput")
    def client_cert_enabled_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "clientCertEnabledInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionStringInput")
    def connection_string_input(
        self,
    ) -> typing.Optional[typing.List["AppServiceConnectionString"]]:
        return jsii.get(self, "connectionStringInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enabledInput")
    def enabled_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "enabledInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="httpsOnlyInput")
    def https_only_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "httpsOnlyInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identityInput")
    def identity_input(self) -> typing.Optional[typing.List["AppServiceIdentity"]]:
        return jsii.get(self, "identityInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logsInput")
    def logs_input(self) -> typing.Optional[typing.List["AppServiceLogs"]]:
        return jsii.get(self, "logsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="siteConfigInput")
    def site_config_input(self) -> typing.Optional[typing.List["AppServiceSiteConfig"]]:
        return jsii.get(self, "siteConfigInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourceControlInput")
    def source_control_input(
        self,
    ) -> typing.Optional[typing.List["AppServiceSourceControl"]]:
        return jsii.get(self, "sourceControlInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="storageAccountInput")
    def storage_account_input(
        self,
    ) -> typing.Optional[typing.List["AppServiceStorageAccount"]]:
        return jsii.get(self, "storageAccountInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServicePlanId")
    def app_service_plan_id(self) -> builtins.str:
        return jsii.get(self, "appServicePlanId")

    @app_service_plan_id.setter # type: ignore
    def app_service_plan_id(self, value: builtins.str) -> None:
        jsii.set(self, "appServicePlanId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appSettings")
    def app_settings(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "appSettings")

    @app_settings.setter # type: ignore
    def app_settings(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "appSettings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authSettings")
    def auth_settings(self) -> typing.List["AppServiceAuthSettings"]:
        return jsii.get(self, "authSettings")

    @auth_settings.setter # type: ignore
    def auth_settings(self, value: typing.List["AppServiceAuthSettings"]) -> None:
        jsii.set(self, "authSettings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="backup")
    def backup(self) -> typing.List["AppServiceBackup"]:
        return jsii.get(self, "backup")

    @backup.setter # type: ignore
    def backup(self, value: typing.List["AppServiceBackup"]) -> None:
        jsii.set(self, "backup", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> builtins.bool:
        return jsii.get(self, "clientAffinityEnabled")

    @client_affinity_enabled.setter # type: ignore
    def client_affinity_enabled(self, value: builtins.bool) -> None:
        jsii.set(self, "clientAffinityEnabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientCertEnabled")
    def client_cert_enabled(self) -> builtins.bool:
        return jsii.get(self, "clientCertEnabled")

    @client_cert_enabled.setter # type: ignore
    def client_cert_enabled(self, value: builtins.bool) -> None:
        jsii.set(self, "clientCertEnabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionString")
    def connection_string(self) -> typing.List["AppServiceConnectionString"]:
        return jsii.get(self, "connectionString")

    @connection_string.setter # type: ignore
    def connection_string(
        self,
        value: typing.List["AppServiceConnectionString"],
    ) -> None:
        jsii.set(self, "connectionString", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> builtins.bool:
        return jsii.get(self, "enabled")

    @enabled.setter # type: ignore
    def enabled(self, value: builtins.bool) -> None:
        jsii.set(self, "enabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="httpsOnly")
    def https_only(self) -> builtins.bool:
        return jsii.get(self, "httpsOnly")

    @https_only.setter # type: ignore
    def https_only(self, value: builtins.bool) -> None:
        jsii.set(self, "httpsOnly", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identity")
    def identity(self) -> typing.List["AppServiceIdentity"]:
        return jsii.get(self, "identity")

    @identity.setter # type: ignore
    def identity(self, value: typing.List["AppServiceIdentity"]) -> None:
        jsii.set(self, "identity", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(self) -> builtins.str:
        return jsii.get(self, "location")

    @location.setter # type: ignore
    def location(self, value: builtins.str) -> None:
        jsii.set(self, "location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logs")
    def logs(self) -> typing.List["AppServiceLogs"]:
        return jsii.get(self, "logs")

    @logs.setter # type: ignore
    def logs(self, value: typing.List["AppServiceLogs"]) -> None:
        jsii.set(self, "logs", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="siteConfig")
    def site_config(self) -> typing.List["AppServiceSiteConfig"]:
        return jsii.get(self, "siteConfig")

    @site_config.setter # type: ignore
    def site_config(self, value: typing.List["AppServiceSiteConfig"]) -> None:
        jsii.set(self, "siteConfig", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourceControl")
    def source_control(self) -> typing.List["AppServiceSourceControl"]:
        return jsii.get(self, "sourceControl")

    @source_control.setter # type: ignore
    def source_control(self, value: typing.List["AppServiceSourceControl"]) -> None:
        jsii.set(self, "sourceControl", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="storageAccount")
    def storage_account(self) -> typing.List["AppServiceStorageAccount"]:
        return jsii.get(self, "storageAccount")

    @storage_account.setter # type: ignore
    def storage_account(self, value: typing.List["AppServiceStorageAccount"]) -> None:
        jsii.set(self, "storageAccount", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceTimeouts") -> None:
        jsii.set(self, "timeouts", value)


class AppServiceActiveSlot(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceActiveSlot",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        app_service_name: builtins.str,
        app_service_slot_name: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["AppServiceActiveSlotTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param app_service_name: -
        :param app_service_slot_name: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceActiveSlotConfig(
            app_service_name=app_service_name,
            app_service_slot_name=app_service_slot_name,
            resource_group_name=resource_group_name,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceActiveSlot, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceNameInput")
    def app_service_name_input(self) -> builtins.str:
        return jsii.get(self, "appServiceNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceSlotNameInput")
    def app_service_slot_name_input(self) -> builtins.str:
        return jsii.get(self, "appServiceSlotNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceActiveSlotTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceName")
    def app_service_name(self) -> builtins.str:
        return jsii.get(self, "appServiceName")

    @app_service_name.setter # type: ignore
    def app_service_name(self, value: builtins.str) -> None:
        jsii.set(self, "appServiceName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceSlotName")
    def app_service_slot_name(self) -> builtins.str:
        return jsii.get(self, "appServiceSlotName")

    @app_service_slot_name.setter # type: ignore
    def app_service_slot_name(self, value: builtins.str) -> None:
        jsii.set(self, "appServiceSlotName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceActiveSlotTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceActiveSlotTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceActiveSlotConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "app_service_name": "appServiceName",
        "app_service_slot_name": "appServiceSlotName",
        "resource_group_name": "resourceGroupName",
        "timeouts": "timeouts",
    },
)
class AppServiceActiveSlotConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        app_service_name: builtins.str,
        app_service_slot_name: builtins.str,
        resource_group_name: builtins.str,
        timeouts: typing.Optional["AppServiceActiveSlotTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param app_service_name: -
        :param app_service_slot_name: -
        :param resource_group_name: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceActiveSlotTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "app_service_name": app_service_name,
            "app_service_slot_name": app_service_slot_name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def app_service_name(self) -> builtins.str:
        result = self._values.get("app_service_name")
        assert result is not None, "Required property 'app_service_name' is missing"
        return result

    @builtins.property
    def app_service_slot_name(self) -> builtins.str:
        result = self._values.get("app_service_slot_name")
        assert result is not None, "Required property 'app_service_slot_name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceActiveSlotTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceActiveSlotConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceActiveSlotTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceActiveSlotTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceActiveSlotTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceAuthSettings",
    jsii_struct_bases=[],
    name_mapping={
        "enabled": "enabled",
        "active_directory": "activeDirectory",
        "additional_login_params": "additionalLoginParams",
        "allowed_external_redirect_urls": "allowedExternalRedirectUrls",
        "default_provider": "defaultProvider",
        "facebook": "facebook",
        "google": "google",
        "issuer": "issuer",
        "microsoft": "microsoft",
        "runtime_version": "runtimeVersion",
        "token_refresh_extension_hours": "tokenRefreshExtensionHours",
        "token_store_enabled": "tokenStoreEnabled",
        "twitter": "twitter",
        "unauthenticated_client_action": "unauthenticatedClientAction",
    },
)
class AppServiceAuthSettings:
    def __init__(
        self,
        *,
        enabled: builtins.bool,
        active_directory: typing.Optional[typing.List["AppServiceAuthSettingsActiveDirectory"]] = None,
        additional_login_params: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        allowed_external_redirect_urls: typing.Optional[typing.List[builtins.str]] = None,
        default_provider: typing.Optional[builtins.str] = None,
        facebook: typing.Optional[typing.List["AppServiceAuthSettingsFacebook"]] = None,
        google: typing.Optional[typing.List["AppServiceAuthSettingsGoogle"]] = None,
        issuer: typing.Optional[builtins.str] = None,
        microsoft: typing.Optional[typing.List["AppServiceAuthSettingsMicrosoft"]] = None,
        runtime_version: typing.Optional[builtins.str] = None,
        token_refresh_extension_hours: typing.Optional[jsii.Number] = None,
        token_store_enabled: typing.Optional[builtins.bool] = None,
        twitter: typing.Optional[typing.List["AppServiceAuthSettingsTwitter"]] = None,
        unauthenticated_client_action: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param enabled: -
        :param active_directory: active_directory block.
        :param additional_login_params: -
        :param allowed_external_redirect_urls: -
        :param default_provider: -
        :param facebook: facebook block.
        :param google: google block.
        :param issuer: -
        :param microsoft: microsoft block.
        :param runtime_version: -
        :param token_refresh_extension_hours: -
        :param token_store_enabled: -
        :param twitter: twitter block.
        :param unauthenticated_client_action: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "enabled": enabled,
        }
        if active_directory is not None:
            self._values["active_directory"] = active_directory
        if additional_login_params is not None:
            self._values["additional_login_params"] = additional_login_params
        if allowed_external_redirect_urls is not None:
            self._values["allowed_external_redirect_urls"] = allowed_external_redirect_urls
        if default_provider is not None:
            self._values["default_provider"] = default_provider
        if facebook is not None:
            self._values["facebook"] = facebook
        if google is not None:
            self._values["google"] = google
        if issuer is not None:
            self._values["issuer"] = issuer
        if microsoft is not None:
            self._values["microsoft"] = microsoft
        if runtime_version is not None:
            self._values["runtime_version"] = runtime_version
        if token_refresh_extension_hours is not None:
            self._values["token_refresh_extension_hours"] = token_refresh_extension_hours
        if token_store_enabled is not None:
            self._values["token_store_enabled"] = token_store_enabled
        if twitter is not None:
            self._values["twitter"] = twitter
        if unauthenticated_client_action is not None:
            self._values["unauthenticated_client_action"] = unauthenticated_client_action

    @builtins.property
    def enabled(self) -> builtins.bool:
        result = self._values.get("enabled")
        assert result is not None, "Required property 'enabled' is missing"
        return result

    @builtins.property
    def active_directory(
        self,
    ) -> typing.Optional[typing.List["AppServiceAuthSettingsActiveDirectory"]]:
        """active_directory block."""
        result = self._values.get("active_directory")
        return result

    @builtins.property
    def additional_login_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("additional_login_params")
        return result

    @builtins.property
    def allowed_external_redirect_urls(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("allowed_external_redirect_urls")
        return result

    @builtins.property
    def default_provider(self) -> typing.Optional[builtins.str]:
        result = self._values.get("default_provider")
        return result

    @builtins.property
    def facebook(
        self,
    ) -> typing.Optional[typing.List["AppServiceAuthSettingsFacebook"]]:
        """facebook block."""
        result = self._values.get("facebook")
        return result

    @builtins.property
    def google(self) -> typing.Optional[typing.List["AppServiceAuthSettingsGoogle"]]:
        """google block."""
        result = self._values.get("google")
        return result

    @builtins.property
    def issuer(self) -> typing.Optional[builtins.str]:
        result = self._values.get("issuer")
        return result

    @builtins.property
    def microsoft(
        self,
    ) -> typing.Optional[typing.List["AppServiceAuthSettingsMicrosoft"]]:
        """microsoft block."""
        result = self._values.get("microsoft")
        return result

    @builtins.property
    def runtime_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("runtime_version")
        return result

    @builtins.property
    def token_refresh_extension_hours(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("token_refresh_extension_hours")
        return result

    @builtins.property
    def token_store_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("token_store_enabled")
        return result

    @builtins.property
    def twitter(self) -> typing.Optional[typing.List["AppServiceAuthSettingsTwitter"]]:
        """twitter block."""
        result = self._values.get("twitter")
        return result

    @builtins.property
    def unauthenticated_client_action(self) -> typing.Optional[builtins.str]:
        result = self._values.get("unauthenticated_client_action")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceAuthSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceAuthSettingsActiveDirectory",
    jsii_struct_bases=[],
    name_mapping={
        "client_id": "clientId",
        "allowed_audiences": "allowedAudiences",
        "client_secret": "clientSecret",
    },
)
class AppServiceAuthSettingsActiveDirectory:
    def __init__(
        self,
        *,
        client_id: builtins.str,
        allowed_audiences: typing.Optional[typing.List[builtins.str]] = None,
        client_secret: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param client_id: -
        :param allowed_audiences: -
        :param client_secret: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_id": client_id,
        }
        if allowed_audiences is not None:
            self._values["allowed_audiences"] = allowed_audiences
        if client_secret is not None:
            self._values["client_secret"] = client_secret

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def allowed_audiences(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("allowed_audiences")
        return result

    @builtins.property
    def client_secret(self) -> typing.Optional[builtins.str]:
        result = self._values.get("client_secret")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceAuthSettingsActiveDirectory(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceAuthSettingsFacebook",
    jsii_struct_bases=[],
    name_mapping={
        "app_id": "appId",
        "app_secret": "appSecret",
        "oauth_scopes": "oauthScopes",
    },
)
class AppServiceAuthSettingsFacebook:
    def __init__(
        self,
        *,
        app_id: builtins.str,
        app_secret: builtins.str,
        oauth_scopes: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param app_id: -
        :param app_secret: -
        :param oauth_scopes: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "app_id": app_id,
            "app_secret": app_secret,
        }
        if oauth_scopes is not None:
            self._values["oauth_scopes"] = oauth_scopes

    @builtins.property
    def app_id(self) -> builtins.str:
        result = self._values.get("app_id")
        assert result is not None, "Required property 'app_id' is missing"
        return result

    @builtins.property
    def app_secret(self) -> builtins.str:
        result = self._values.get("app_secret")
        assert result is not None, "Required property 'app_secret' is missing"
        return result

    @builtins.property
    def oauth_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("oauth_scopes")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceAuthSettingsFacebook(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceAuthSettingsGoogle",
    jsii_struct_bases=[],
    name_mapping={
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "oauth_scopes": "oauthScopes",
    },
)
class AppServiceAuthSettingsGoogle:
    def __init__(
        self,
        *,
        client_id: builtins.str,
        client_secret: builtins.str,
        oauth_scopes: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param client_id: -
        :param client_secret: -
        :param oauth_scopes: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_id": client_id,
            "client_secret": client_secret,
        }
        if oauth_scopes is not None:
            self._values["oauth_scopes"] = oauth_scopes

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def client_secret(self) -> builtins.str:
        result = self._values.get("client_secret")
        assert result is not None, "Required property 'client_secret' is missing"
        return result

    @builtins.property
    def oauth_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("oauth_scopes")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceAuthSettingsGoogle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceAuthSettingsMicrosoft",
    jsii_struct_bases=[],
    name_mapping={
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "oauth_scopes": "oauthScopes",
    },
)
class AppServiceAuthSettingsMicrosoft:
    def __init__(
        self,
        *,
        client_id: builtins.str,
        client_secret: builtins.str,
        oauth_scopes: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param client_id: -
        :param client_secret: -
        :param oauth_scopes: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_id": client_id,
            "client_secret": client_secret,
        }
        if oauth_scopes is not None:
            self._values["oauth_scopes"] = oauth_scopes

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def client_secret(self) -> builtins.str:
        result = self._values.get("client_secret")
        assert result is not None, "Required property 'client_secret' is missing"
        return result

    @builtins.property
    def oauth_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("oauth_scopes")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceAuthSettingsMicrosoft(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceAuthSettingsTwitter",
    jsii_struct_bases=[],
    name_mapping={"consumer_key": "consumerKey", "consumer_secret": "consumerSecret"},
)
class AppServiceAuthSettingsTwitter:
    def __init__(
        self,
        *,
        consumer_key: builtins.str,
        consumer_secret: builtins.str,
    ) -> None:
        """
        :param consumer_key: -
        :param consumer_secret: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "consumer_key": consumer_key,
            "consumer_secret": consumer_secret,
        }

    @builtins.property
    def consumer_key(self) -> builtins.str:
        result = self._values.get("consumer_key")
        assert result is not None, "Required property 'consumer_key' is missing"
        return result

    @builtins.property
    def consumer_secret(self) -> builtins.str:
        result = self._values.get("consumer_secret")
        assert result is not None, "Required property 'consumer_secret' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceAuthSettingsTwitter(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceBackup",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "schedule": "schedule",
        "storage_account_url": "storageAccountUrl",
        "enabled": "enabled",
    },
)
class AppServiceBackup:
    def __init__(
        self,
        *,
        name: builtins.str,
        schedule: typing.List["AppServiceBackupSchedule"],
        storage_account_url: builtins.str,
        enabled: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param name: -
        :param schedule: schedule block.
        :param storage_account_url: -
        :param enabled: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "schedule": schedule,
            "storage_account_url": storage_account_url,
        }
        if enabled is not None:
            self._values["enabled"] = enabled

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def schedule(self) -> typing.List["AppServiceBackupSchedule"]:
        """schedule block."""
        result = self._values.get("schedule")
        assert result is not None, "Required property 'schedule' is missing"
        return result

    @builtins.property
    def storage_account_url(self) -> builtins.str:
        result = self._values.get("storage_account_url")
        assert result is not None, "Required property 'storage_account_url' is missing"
        return result

    @builtins.property
    def enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enabled")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceBackup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceBackupSchedule",
    jsii_struct_bases=[],
    name_mapping={
        "frequency_interval": "frequencyInterval",
        "frequency_unit": "frequencyUnit",
        "keep_at_least_one_backup": "keepAtLeastOneBackup",
        "retention_period_in_days": "retentionPeriodInDays",
        "start_time": "startTime",
    },
)
class AppServiceBackupSchedule:
    def __init__(
        self,
        *,
        frequency_interval: jsii.Number,
        frequency_unit: builtins.str,
        keep_at_least_one_backup: typing.Optional[builtins.bool] = None,
        retention_period_in_days: typing.Optional[jsii.Number] = None,
        start_time: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param frequency_interval: -
        :param frequency_unit: -
        :param keep_at_least_one_backup: -
        :param retention_period_in_days: -
        :param start_time: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "frequency_interval": frequency_interval,
            "frequency_unit": frequency_unit,
        }
        if keep_at_least_one_backup is not None:
            self._values["keep_at_least_one_backup"] = keep_at_least_one_backup
        if retention_period_in_days is not None:
            self._values["retention_period_in_days"] = retention_period_in_days
        if start_time is not None:
            self._values["start_time"] = start_time

    @builtins.property
    def frequency_interval(self) -> jsii.Number:
        result = self._values.get("frequency_interval")
        assert result is not None, "Required property 'frequency_interval' is missing"
        return result

    @builtins.property
    def frequency_unit(self) -> builtins.str:
        result = self._values.get("frequency_unit")
        assert result is not None, "Required property 'frequency_unit' is missing"
        return result

    @builtins.property
    def keep_at_least_one_backup(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("keep_at_least_one_backup")
        return result

    @builtins.property
    def retention_period_in_days(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("retention_period_in_days")
        return result

    @builtins.property
    def start_time(self) -> typing.Optional[builtins.str]:
        result = self._values.get("start_time")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceBackupSchedule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceCertificate(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceCertificate",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        hosting_environment_profile_id: typing.Optional[builtins.str] = None,
        key_vault_secret_id: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        pfx_blob: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceCertificateTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param hosting_environment_profile_id: -
        :param key_vault_secret_id: -
        :param password: -
        :param pfx_blob: -
        :param tags: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceCertificateConfig(
            location=location,
            name=name,
            resource_group_name=resource_group_name,
            hosting_environment_profile_id=hosting_environment_profile_id,
            key_vault_secret_id=key_vault_secret_id,
            password=password,
            pfx_blob=pfx_blob,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceCertificate, self, [scope, id, config])

    @jsii.member(jsii_name="resetHostingEnvironmentProfileId")
    def reset_hosting_environment_profile_id(self) -> None:
        return jsii.invoke(self, "resetHostingEnvironmentProfileId", [])

    @jsii.member(jsii_name="resetKeyVaultSecretId")
    def reset_key_vault_secret_id(self) -> None:
        return jsii.invoke(self, "resetKeyVaultSecretId", [])

    @jsii.member(jsii_name="resetPassword")
    def reset_password(self) -> None:
        return jsii.invoke(self, "resetPassword", [])

    @jsii.member(jsii_name="resetPfxBlob")
    def reset_pfx_blob(self) -> None:
        return jsii.invoke(self, "resetPfxBlob", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="expirationDate")
    def expiration_date(self) -> builtins.str:
        return jsii.get(self, "expirationDate")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="friendlyName")
    def friendly_name(self) -> builtins.str:
        return jsii.get(self, "friendlyName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostNames")
    def host_names(self) -> typing.List[builtins.str]:
        return jsii.get(self, "hostNames")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="issueDate")
    def issue_date(self) -> builtins.str:
        return jsii.get(self, "issueDate")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="issuer")
    def issuer(self) -> builtins.str:
        return jsii.get(self, "issuer")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="locationInput")
    def location_input(self) -> builtins.str:
        return jsii.get(self, "locationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subjectName")
    def subject_name(self) -> builtins.str:
        return jsii.get(self, "subjectName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="thumbprint")
    def thumbprint(self) -> builtins.str:
        return jsii.get(self, "thumbprint")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostingEnvironmentProfileIdInput")
    def hosting_environment_profile_id_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "hostingEnvironmentProfileIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyVaultSecretIdInput")
    def key_vault_secret_id_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "keyVaultSecretIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="passwordInput")
    def password_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "passwordInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="pfxBlobInput")
    def pfx_blob_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "pfxBlobInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceCertificateTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostingEnvironmentProfileId")
    def hosting_environment_profile_id(self) -> builtins.str:
        return jsii.get(self, "hostingEnvironmentProfileId")

    @hosting_environment_profile_id.setter # type: ignore
    def hosting_environment_profile_id(self, value: builtins.str) -> None:
        jsii.set(self, "hostingEnvironmentProfileId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyVaultSecretId")
    def key_vault_secret_id(self) -> builtins.str:
        return jsii.get(self, "keyVaultSecretId")

    @key_vault_secret_id.setter # type: ignore
    def key_vault_secret_id(self, value: builtins.str) -> None:
        jsii.set(self, "keyVaultSecretId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(self) -> builtins.str:
        return jsii.get(self, "location")

    @location.setter # type: ignore
    def location(self, value: builtins.str) -> None:
        jsii.set(self, "location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return jsii.get(self, "password")

    @password.setter # type: ignore
    def password(self, value: builtins.str) -> None:
        jsii.set(self, "password", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="pfxBlob")
    def pfx_blob(self) -> builtins.str:
        return jsii.get(self, "pfxBlob")

    @pfx_blob.setter # type: ignore
    def pfx_blob(self, value: builtins.str) -> None:
        jsii.set(self, "pfxBlob", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceCertificateTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceCertificateTimeouts") -> None:
        jsii.set(self, "timeouts", value)


class AppServiceCertificateBinding(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceCertificateBinding",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        certificate_id: builtins.str,
        hostname_binding_id: builtins.str,
        ssl_state: builtins.str,
        timeouts: typing.Optional["AppServiceCertificateBindingTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param certificate_id: -
        :param hostname_binding_id: -
        :param ssl_state: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceCertificateBindingConfig(
            certificate_id=certificate_id,
            hostname_binding_id=hostname_binding_id,
            ssl_state=ssl_state,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceCertificateBinding, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceName")
    def app_service_name(self) -> builtins.str:
        return jsii.get(self, "appServiceName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="certificateIdInput")
    def certificate_id_input(self) -> builtins.str:
        return jsii.get(self, "certificateIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostname")
    def hostname(self) -> builtins.str:
        return jsii.get(self, "hostname")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostnameBindingIdInput")
    def hostname_binding_id_input(self) -> builtins.str:
        return jsii.get(self, "hostnameBindingIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sslStateInput")
    def ssl_state_input(self) -> builtins.str:
        return jsii.get(self, "sslStateInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="thumbprint")
    def thumbprint(self) -> builtins.str:
        return jsii.get(self, "thumbprint")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceCertificateBindingTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="certificateId")
    def certificate_id(self) -> builtins.str:
        return jsii.get(self, "certificateId")

    @certificate_id.setter # type: ignore
    def certificate_id(self, value: builtins.str) -> None:
        jsii.set(self, "certificateId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostnameBindingId")
    def hostname_binding_id(self) -> builtins.str:
        return jsii.get(self, "hostnameBindingId")

    @hostname_binding_id.setter # type: ignore
    def hostname_binding_id(self, value: builtins.str) -> None:
        jsii.set(self, "hostnameBindingId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sslState")
    def ssl_state(self) -> builtins.str:
        return jsii.get(self, "sslState")

    @ssl_state.setter # type: ignore
    def ssl_state(self, value: builtins.str) -> None:
        jsii.set(self, "sslState", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceCertificateBindingTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceCertificateBindingTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceCertificateBindingConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "certificate_id": "certificateId",
        "hostname_binding_id": "hostnameBindingId",
        "ssl_state": "sslState",
        "timeouts": "timeouts",
    },
)
class AppServiceCertificateBindingConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        certificate_id: builtins.str,
        hostname_binding_id: builtins.str,
        ssl_state: builtins.str,
        timeouts: typing.Optional["AppServiceCertificateBindingTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param certificate_id: -
        :param hostname_binding_id: -
        :param ssl_state: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceCertificateBindingTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "certificate_id": certificate_id,
            "hostname_binding_id": hostname_binding_id,
            "ssl_state": ssl_state,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def certificate_id(self) -> builtins.str:
        result = self._values.get("certificate_id")
        assert result is not None, "Required property 'certificate_id' is missing"
        return result

    @builtins.property
    def hostname_binding_id(self) -> builtins.str:
        result = self._values.get("hostname_binding_id")
        assert result is not None, "Required property 'hostname_binding_id' is missing"
        return result

    @builtins.property
    def ssl_state(self) -> builtins.str:
        result = self._values.get("ssl_state")
        assert result is not None, "Required property 'ssl_state' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceCertificateBindingTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceCertificateBindingConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceCertificateBindingTimeouts",
    jsii_struct_bases=[],
    name_mapping={"create": "create", "delete": "delete", "read": "read"},
)
class AppServiceCertificateBindingTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceCertificateBindingTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceCertificateConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "location": "location",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "hosting_environment_profile_id": "hostingEnvironmentProfileId",
        "key_vault_secret_id": "keyVaultSecretId",
        "password": "password",
        "pfx_blob": "pfxBlob",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AppServiceCertificateConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        hosting_environment_profile_id: typing.Optional[builtins.str] = None,
        key_vault_secret_id: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        pfx_blob: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceCertificateTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param hosting_environment_profile_id: -
        :param key_vault_secret_id: -
        :param password: -
        :param pfx_blob: -
        :param tags: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceCertificateTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "location": location,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if hosting_environment_profile_id is not None:
            self._values["hosting_environment_profile_id"] = hosting_environment_profile_id
        if key_vault_secret_id is not None:
            self._values["key_vault_secret_id"] = key_vault_secret_id
        if password is not None:
            self._values["password"] = password
        if pfx_blob is not None:
            self._values["pfx_blob"] = pfx_blob
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def location(self) -> builtins.str:
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def hosting_environment_profile_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("hosting_environment_profile_id")
        return result

    @builtins.property
    def key_vault_secret_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("key_vault_secret_id")
        return result

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        result = self._values.get("password")
        return result

    @builtins.property
    def pfx_blob(self) -> typing.Optional[builtins.str]:
        result = self._values.get("pfx_blob")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceCertificateTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceCertificateConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceCertificateOrder(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceCertificateOrder",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        auto_renew: typing.Optional[builtins.bool] = None,
        csr: typing.Optional[builtins.str] = None,
        distinguished_name: typing.Optional[builtins.str] = None,
        key_size: typing.Optional[jsii.Number] = None,
        product_type: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceCertificateOrderTimeouts"] = None,
        validity_in_years: typing.Optional[jsii.Number] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param auto_renew: -
        :param csr: -
        :param distinguished_name: -
        :param key_size: -
        :param product_type: -
        :param tags: -
        :param timeouts: timeouts block.
        :param validity_in_years: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceCertificateOrderConfig(
            location=location,
            name=name,
            resource_group_name=resource_group_name,
            auto_renew=auto_renew,
            csr=csr,
            distinguished_name=distinguished_name,
            key_size=key_size,
            product_type=product_type,
            tags=tags,
            timeouts=timeouts,
            validity_in_years=validity_in_years,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceCertificateOrder, self, [scope, id, config])

    @jsii.member(jsii_name="certificates")
    def certificates(
        self,
        index: builtins.str,
    ) -> "AppServiceCertificateOrderCertificates":
        """
        :param index: -
        """
        return jsii.invoke(self, "certificates", [index])

    @jsii.member(jsii_name="resetAutoRenew")
    def reset_auto_renew(self) -> None:
        return jsii.invoke(self, "resetAutoRenew", [])

    @jsii.member(jsii_name="resetCsr")
    def reset_csr(self) -> None:
        return jsii.invoke(self, "resetCsr", [])

    @jsii.member(jsii_name="resetDistinguishedName")
    def reset_distinguished_name(self) -> None:
        return jsii.invoke(self, "resetDistinguishedName", [])

    @jsii.member(jsii_name="resetKeySize")
    def reset_key_size(self) -> None:
        return jsii.invoke(self, "resetKeySize", [])

    @jsii.member(jsii_name="resetProductType")
    def reset_product_type(self) -> None:
        return jsii.invoke(self, "resetProductType", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetValidityInYears")
    def reset_validity_in_years(self) -> None:
        return jsii.invoke(self, "resetValidityInYears", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceCertificateNotRenewableReasons")
    def app_service_certificate_not_renewable_reasons(
        self,
    ) -> typing.List[builtins.str]:
        return jsii.get(self, "appServiceCertificateNotRenewableReasons")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainVerificationToken")
    def domain_verification_token(self) -> builtins.str:
        return jsii.get(self, "domainVerificationToken")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="expirationTime")
    def expiration_time(self) -> builtins.str:
        return jsii.get(self, "expirationTime")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="intermediateThumbprint")
    def intermediate_thumbprint(self) -> builtins.str:
        return jsii.get(self, "intermediateThumbprint")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="isPrivateKeyExternal")
    def is_private_key_external(self) -> builtins.bool:
        return jsii.get(self, "isPrivateKeyExternal")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="locationInput")
    def location_input(self) -> builtins.str:
        return jsii.get(self, "locationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="rootThumbprint")
    def root_thumbprint(self) -> builtins.str:
        return jsii.get(self, "rootThumbprint")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="signedCertificateThumbprint")
    def signed_certificate_thumbprint(self) -> builtins.str:
        return jsii.get(self, "signedCertificateThumbprint")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="status")
    def status(self) -> builtins.str:
        return jsii.get(self, "status")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="autoRenewInput")
    def auto_renew_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "autoRenewInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="csrInput")
    def csr_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "csrInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="distinguishedNameInput")
    def distinguished_name_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "distinguishedNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keySizeInput")
    def key_size_input(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "keySizeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productTypeInput")
    def product_type_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "productTypeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceCertificateOrderTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="validityInYearsInput")
    def validity_in_years_input(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "validityInYearsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="autoRenew")
    def auto_renew(self) -> builtins.bool:
        return jsii.get(self, "autoRenew")

    @auto_renew.setter # type: ignore
    def auto_renew(self, value: builtins.bool) -> None:
        jsii.set(self, "autoRenew", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="csr")
    def csr(self) -> builtins.str:
        return jsii.get(self, "csr")

    @csr.setter # type: ignore
    def csr(self, value: builtins.str) -> None:
        jsii.set(self, "csr", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="distinguishedName")
    def distinguished_name(self) -> builtins.str:
        return jsii.get(self, "distinguishedName")

    @distinguished_name.setter # type: ignore
    def distinguished_name(self, value: builtins.str) -> None:
        jsii.set(self, "distinguishedName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keySize")
    def key_size(self) -> jsii.Number:
        return jsii.get(self, "keySize")

    @key_size.setter # type: ignore
    def key_size(self, value: jsii.Number) -> None:
        jsii.set(self, "keySize", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(self) -> builtins.str:
        return jsii.get(self, "location")

    @location.setter # type: ignore
    def location(self, value: builtins.str) -> None:
        jsii.set(self, "location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="productType")
    def product_type(self) -> builtins.str:
        return jsii.get(self, "productType")

    @product_type.setter # type: ignore
    def product_type(self, value: builtins.str) -> None:
        jsii.set(self, "productType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceCertificateOrderTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceCertificateOrderTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="validityInYears")
    def validity_in_years(self) -> jsii.Number:
        return jsii.get(self, "validityInYears")

    @validity_in_years.setter # type: ignore
    def validity_in_years(self, value: jsii.Number) -> None:
        jsii.set(self, "validityInYears", value)


class AppServiceCertificateOrderCertificates(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceCertificateOrderCertificates",
):
    def __init__(
        self,
        terraform_resource: cdktf.ITerraformResource,
        terraform_attribute: builtins.str,
        index: builtins.str,
    ) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        :stability: experimental
        """
        jsii.create(AppServiceCertificateOrderCertificates, self, [terraform_resource, terraform_attribute, index])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="certificateName")
    def certificate_name(self) -> builtins.str:
        return jsii.get(self, "certificateName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyVaultId")
    def key_vault_id(self) -> builtins.str:
        return jsii.get(self, "keyVaultId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyVaultSecretName")
    def key_vault_secret_name(self) -> builtins.str:
        return jsii.get(self, "keyVaultSecretName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="provisioningState")
    def provisioning_state(self) -> builtins.str:
        return jsii.get(self, "provisioningState")


@jsii.data_type(
    jsii_type="azurerm.AppServiceCertificateOrderConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "location": "location",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "auto_renew": "autoRenew",
        "csr": "csr",
        "distinguished_name": "distinguishedName",
        "key_size": "keySize",
        "product_type": "productType",
        "tags": "tags",
        "timeouts": "timeouts",
        "validity_in_years": "validityInYears",
    },
)
class AppServiceCertificateOrderConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        auto_renew: typing.Optional[builtins.bool] = None,
        csr: typing.Optional[builtins.str] = None,
        distinguished_name: typing.Optional[builtins.str] = None,
        key_size: typing.Optional[jsii.Number] = None,
        product_type: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceCertificateOrderTimeouts"] = None,
        validity_in_years: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param auto_renew: -
        :param csr: -
        :param distinguished_name: -
        :param key_size: -
        :param product_type: -
        :param tags: -
        :param timeouts: timeouts block.
        :param validity_in_years: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceCertificateOrderTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "location": location,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if auto_renew is not None:
            self._values["auto_renew"] = auto_renew
        if csr is not None:
            self._values["csr"] = csr
        if distinguished_name is not None:
            self._values["distinguished_name"] = distinguished_name
        if key_size is not None:
            self._values["key_size"] = key_size
        if product_type is not None:
            self._values["product_type"] = product_type
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if validity_in_years is not None:
            self._values["validity_in_years"] = validity_in_years

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def location(self) -> builtins.str:
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def auto_renew(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("auto_renew")
        return result

    @builtins.property
    def csr(self) -> typing.Optional[builtins.str]:
        result = self._values.get("csr")
        return result

    @builtins.property
    def distinguished_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("distinguished_name")
        return result

    @builtins.property
    def key_size(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("key_size")
        return result

    @builtins.property
    def product_type(self) -> typing.Optional[builtins.str]:
        result = self._values.get("product_type")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceCertificateOrderTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def validity_in_years(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("validity_in_years")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceCertificateOrderConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceCertificateOrderTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceCertificateOrderTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceCertificateOrderTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceCertificateTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceCertificateTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceCertificateTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "app_service_plan_id": "appServicePlanId",
        "location": "location",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "app_settings": "appSettings",
        "auth_settings": "authSettings",
        "backup": "backup",
        "client_affinity_enabled": "clientAffinityEnabled",
        "client_cert_enabled": "clientCertEnabled",
        "connection_string": "connectionString",
        "enabled": "enabled",
        "https_only": "httpsOnly",
        "identity": "identity",
        "logs": "logs",
        "site_config": "siteConfig",
        "source_control": "sourceControl",
        "storage_account": "storageAccount",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AppServiceConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        app_service_plan_id: builtins.str,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        app_settings: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        auth_settings: typing.Optional[typing.List[AppServiceAuthSettings]] = None,
        backup: typing.Optional[typing.List[AppServiceBackup]] = None,
        client_affinity_enabled: typing.Optional[builtins.bool] = None,
        client_cert_enabled: typing.Optional[builtins.bool] = None,
        connection_string: typing.Optional[typing.List["AppServiceConnectionString"]] = None,
        enabled: typing.Optional[builtins.bool] = None,
        https_only: typing.Optional[builtins.bool] = None,
        identity: typing.Optional[typing.List["AppServiceIdentity"]] = None,
        logs: typing.Optional[typing.List["AppServiceLogs"]] = None,
        site_config: typing.Optional[typing.List["AppServiceSiteConfig"]] = None,
        source_control: typing.Optional[typing.List["AppServiceSourceControl"]] = None,
        storage_account: typing.Optional[typing.List["AppServiceStorageAccount"]] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param app_service_plan_id: -
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param app_settings: -
        :param auth_settings: auth_settings block.
        :param backup: backup block.
        :param client_affinity_enabled: -
        :param client_cert_enabled: -
        :param connection_string: connection_string block.
        :param enabled: -
        :param https_only: -
        :param identity: identity block.
        :param logs: logs block.
        :param site_config: site_config block.
        :param source_control: source_control block.
        :param storage_account: storage_account block.
        :param tags: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "app_service_plan_id": app_service_plan_id,
            "location": location,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if app_settings is not None:
            self._values["app_settings"] = app_settings
        if auth_settings is not None:
            self._values["auth_settings"] = auth_settings
        if backup is not None:
            self._values["backup"] = backup
        if client_affinity_enabled is not None:
            self._values["client_affinity_enabled"] = client_affinity_enabled
        if client_cert_enabled is not None:
            self._values["client_cert_enabled"] = client_cert_enabled
        if connection_string is not None:
            self._values["connection_string"] = connection_string
        if enabled is not None:
            self._values["enabled"] = enabled
        if https_only is not None:
            self._values["https_only"] = https_only
        if identity is not None:
            self._values["identity"] = identity
        if logs is not None:
            self._values["logs"] = logs
        if site_config is not None:
            self._values["site_config"] = site_config
        if source_control is not None:
            self._values["source_control"] = source_control
        if storage_account is not None:
            self._values["storage_account"] = storage_account
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def app_service_plan_id(self) -> builtins.str:
        result = self._values.get("app_service_plan_id")
        assert result is not None, "Required property 'app_service_plan_id' is missing"
        return result

    @builtins.property
    def location(self) -> builtins.str:
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def app_settings(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("app_settings")
        return result

    @builtins.property
    def auth_settings(self) -> typing.Optional[typing.List[AppServiceAuthSettings]]:
        """auth_settings block."""
        result = self._values.get("auth_settings")
        return result

    @builtins.property
    def backup(self) -> typing.Optional[typing.List[AppServiceBackup]]:
        """backup block."""
        result = self._values.get("backup")
        return result

    @builtins.property
    def client_affinity_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("client_affinity_enabled")
        return result

    @builtins.property
    def client_cert_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("client_cert_enabled")
        return result

    @builtins.property
    def connection_string(
        self,
    ) -> typing.Optional[typing.List["AppServiceConnectionString"]]:
        """connection_string block."""
        result = self._values.get("connection_string")
        return result

    @builtins.property
    def enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enabled")
        return result

    @builtins.property
    def https_only(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("https_only")
        return result

    @builtins.property
    def identity(self) -> typing.Optional[typing.List["AppServiceIdentity"]]:
        """identity block."""
        result = self._values.get("identity")
        return result

    @builtins.property
    def logs(self) -> typing.Optional[typing.List["AppServiceLogs"]]:
        """logs block."""
        result = self._values.get("logs")
        return result

    @builtins.property
    def site_config(self) -> typing.Optional[typing.List["AppServiceSiteConfig"]]:
        """site_config block."""
        result = self._values.get("site_config")
        return result

    @builtins.property
    def source_control(self) -> typing.Optional[typing.List["AppServiceSourceControl"]]:
        """source_control block."""
        result = self._values.get("source_control")
        return result

    @builtins.property
    def storage_account(
        self,
    ) -> typing.Optional[typing.List["AppServiceStorageAccount"]]:
        """storage_account block."""
        result = self._values.get("storage_account")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceConnectionString",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "type": "type", "value": "value"},
)
class AppServiceConnectionString:
    def __init__(
        self,
        *,
        name: builtins.str,
        type: builtins.str,
        value: builtins.str,
    ) -> None:
        """
        :param name: -
        :param type: -
        :param value: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "type": type,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def value(self) -> builtins.str:
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceConnectionString(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceCustomHostnameBinding(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceCustomHostnameBinding",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        app_service_name: builtins.str,
        hostname: builtins.str,
        resource_group_name: builtins.str,
        ssl_state: typing.Optional[builtins.str] = None,
        thumbprint: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["AppServiceCustomHostnameBindingTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param app_service_name: -
        :param hostname: -
        :param resource_group_name: -
        :param ssl_state: -
        :param thumbprint: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceCustomHostnameBindingConfig(
            app_service_name=app_service_name,
            hostname=hostname,
            resource_group_name=resource_group_name,
            ssl_state=ssl_state,
            thumbprint=thumbprint,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceCustomHostnameBinding, self, [scope, id, config])

    @jsii.member(jsii_name="resetSslState")
    def reset_ssl_state(self) -> None:
        return jsii.invoke(self, "resetSslState", [])

    @jsii.member(jsii_name="resetThumbprint")
    def reset_thumbprint(self) -> None:
        return jsii.invoke(self, "resetThumbprint", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceNameInput")
    def app_service_name_input(self) -> builtins.str:
        return jsii.get(self, "appServiceNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostnameInput")
    def hostname_input(self) -> builtins.str:
        return jsii.get(self, "hostnameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="virtualIp")
    def virtual_ip(self) -> builtins.str:
        return jsii.get(self, "virtualIp")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sslStateInput")
    def ssl_state_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "sslStateInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="thumbprintInput")
    def thumbprint_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "thumbprintInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["AppServiceCustomHostnameBindingTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceName")
    def app_service_name(self) -> builtins.str:
        return jsii.get(self, "appServiceName")

    @app_service_name.setter # type: ignore
    def app_service_name(self, value: builtins.str) -> None:
        jsii.set(self, "appServiceName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostname")
    def hostname(self) -> builtins.str:
        return jsii.get(self, "hostname")

    @hostname.setter # type: ignore
    def hostname(self, value: builtins.str) -> None:
        jsii.set(self, "hostname", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sslState")
    def ssl_state(self) -> builtins.str:
        return jsii.get(self, "sslState")

    @ssl_state.setter # type: ignore
    def ssl_state(self, value: builtins.str) -> None:
        jsii.set(self, "sslState", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="thumbprint")
    def thumbprint(self) -> builtins.str:
        return jsii.get(self, "thumbprint")

    @thumbprint.setter # type: ignore
    def thumbprint(self, value: builtins.str) -> None:
        jsii.set(self, "thumbprint", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceCustomHostnameBindingTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceCustomHostnameBindingTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceCustomHostnameBindingConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "app_service_name": "appServiceName",
        "hostname": "hostname",
        "resource_group_name": "resourceGroupName",
        "ssl_state": "sslState",
        "thumbprint": "thumbprint",
        "timeouts": "timeouts",
    },
)
class AppServiceCustomHostnameBindingConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        app_service_name: builtins.str,
        hostname: builtins.str,
        resource_group_name: builtins.str,
        ssl_state: typing.Optional[builtins.str] = None,
        thumbprint: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["AppServiceCustomHostnameBindingTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param app_service_name: -
        :param hostname: -
        :param resource_group_name: -
        :param ssl_state: -
        :param thumbprint: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceCustomHostnameBindingTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "app_service_name": app_service_name,
            "hostname": hostname,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if ssl_state is not None:
            self._values["ssl_state"] = ssl_state
        if thumbprint is not None:
            self._values["thumbprint"] = thumbprint
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def app_service_name(self) -> builtins.str:
        result = self._values.get("app_service_name")
        assert result is not None, "Required property 'app_service_name' is missing"
        return result

    @builtins.property
    def hostname(self) -> builtins.str:
        result = self._values.get("hostname")
        assert result is not None, "Required property 'hostname' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def ssl_state(self) -> typing.Optional[builtins.str]:
        result = self._values.get("ssl_state")
        return result

    @builtins.property
    def thumbprint(self) -> typing.Optional[builtins.str]:
        result = self._values.get("thumbprint")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceCustomHostnameBindingTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceCustomHostnameBindingConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceCustomHostnameBindingTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceCustomHostnameBindingTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceCustomHostnameBindingTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceEnvironment(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceEnvironment",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        name: builtins.str,
        subnet_id: builtins.str,
        allowed_user_ip_cidrs: typing.Optional[typing.List[builtins.str]] = None,
        front_end_scale_factor: typing.Optional[jsii.Number] = None,
        internal_load_balancing_mode: typing.Optional[builtins.str] = None,
        pricing_tier: typing.Optional[builtins.str] = None,
        resource_group_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceEnvironmentTimeouts"] = None,
        user_whitelisted_ip_ranges: typing.Optional[typing.List[builtins.str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: -
        :param subnet_id: -
        :param allowed_user_ip_cidrs: -
        :param front_end_scale_factor: -
        :param internal_load_balancing_mode: -
        :param pricing_tier: -
        :param resource_group_name: -
        :param tags: -
        :param timeouts: timeouts block.
        :param user_whitelisted_ip_ranges: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceEnvironmentConfig(
            name=name,
            subnet_id=subnet_id,
            allowed_user_ip_cidrs=allowed_user_ip_cidrs,
            front_end_scale_factor=front_end_scale_factor,
            internal_load_balancing_mode=internal_load_balancing_mode,
            pricing_tier=pricing_tier,
            resource_group_name=resource_group_name,
            tags=tags,
            timeouts=timeouts,
            user_whitelisted_ip_ranges=user_whitelisted_ip_ranges,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceEnvironment, self, [scope, id, config])

    @jsii.member(jsii_name="resetAllowedUserIpCidrs")
    def reset_allowed_user_ip_cidrs(self) -> None:
        return jsii.invoke(self, "resetAllowedUserIpCidrs", [])

    @jsii.member(jsii_name="resetFrontEndScaleFactor")
    def reset_front_end_scale_factor(self) -> None:
        return jsii.invoke(self, "resetFrontEndScaleFactor", [])

    @jsii.member(jsii_name="resetInternalLoadBalancingMode")
    def reset_internal_load_balancing_mode(self) -> None:
        return jsii.invoke(self, "resetInternalLoadBalancingMode", [])

    @jsii.member(jsii_name="resetPricingTier")
    def reset_pricing_tier(self) -> None:
        return jsii.invoke(self, "resetPricingTier", [])

    @jsii.member(jsii_name="resetResourceGroupName")
    def reset_resource_group_name(self) -> None:
        return jsii.invoke(self, "resetResourceGroupName", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetUserWhitelistedIpRanges")
    def reset_user_whitelisted_ip_ranges(self) -> None:
        return jsii.invoke(self, "resetUserWhitelistedIpRanges", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(self) -> builtins.str:
        return jsii.get(self, "location")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetIdInput")
    def subnet_id_input(self) -> builtins.str:
        return jsii.get(self, "subnetIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="allowedUserIpCidrsInput")
    def allowed_user_ip_cidrs_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return jsii.get(self, "allowedUserIpCidrsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="frontEndScaleFactorInput")
    def front_end_scale_factor_input(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "frontEndScaleFactorInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="internalLoadBalancingModeInput")
    def internal_load_balancing_mode_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "internalLoadBalancingModeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="pricingTierInput")
    def pricing_tier_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "pricingTierInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceEnvironmentTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userWhitelistedIpRangesInput")
    def user_whitelisted_ip_ranges_input(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        return jsii.get(self, "userWhitelistedIpRangesInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="allowedUserIpCidrs")
    def allowed_user_ip_cidrs(self) -> typing.List[builtins.str]:
        return jsii.get(self, "allowedUserIpCidrs")

    @allowed_user_ip_cidrs.setter # type: ignore
    def allowed_user_ip_cidrs(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "allowedUserIpCidrs", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="frontEndScaleFactor")
    def front_end_scale_factor(self) -> jsii.Number:
        return jsii.get(self, "frontEndScaleFactor")

    @front_end_scale_factor.setter # type: ignore
    def front_end_scale_factor(self, value: jsii.Number) -> None:
        jsii.set(self, "frontEndScaleFactor", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="internalLoadBalancingMode")
    def internal_load_balancing_mode(self) -> builtins.str:
        return jsii.get(self, "internalLoadBalancingMode")

    @internal_load_balancing_mode.setter # type: ignore
    def internal_load_balancing_mode(self, value: builtins.str) -> None:
        jsii.set(self, "internalLoadBalancingMode", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="pricingTier")
    def pricing_tier(self) -> builtins.str:
        return jsii.get(self, "pricingTier")

    @pricing_tier.setter # type: ignore
    def pricing_tier(self, value: builtins.str) -> None:
        jsii.set(self, "pricingTier", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceEnvironmentTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceEnvironmentTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userWhitelistedIpRanges")
    def user_whitelisted_ip_ranges(self) -> typing.List[builtins.str]:
        return jsii.get(self, "userWhitelistedIpRanges")

    @user_whitelisted_ip_ranges.setter # type: ignore
    def user_whitelisted_ip_ranges(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "userWhitelistedIpRanges", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceEnvironmentConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "subnet_id": "subnetId",
        "allowed_user_ip_cidrs": "allowedUserIpCidrs",
        "front_end_scale_factor": "frontEndScaleFactor",
        "internal_load_balancing_mode": "internalLoadBalancingMode",
        "pricing_tier": "pricingTier",
        "resource_group_name": "resourceGroupName",
        "tags": "tags",
        "timeouts": "timeouts",
        "user_whitelisted_ip_ranges": "userWhitelistedIpRanges",
    },
)
class AppServiceEnvironmentConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: builtins.str,
        subnet_id: builtins.str,
        allowed_user_ip_cidrs: typing.Optional[typing.List[builtins.str]] = None,
        front_end_scale_factor: typing.Optional[jsii.Number] = None,
        internal_load_balancing_mode: typing.Optional[builtins.str] = None,
        pricing_tier: typing.Optional[builtins.str] = None,
        resource_group_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceEnvironmentTimeouts"] = None,
        user_whitelisted_ip_ranges: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: -
        :param subnet_id: -
        :param allowed_user_ip_cidrs: -
        :param front_end_scale_factor: -
        :param internal_load_balancing_mode: -
        :param pricing_tier: -
        :param resource_group_name: -
        :param tags: -
        :param timeouts: timeouts block.
        :param user_whitelisted_ip_ranges: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceEnvironmentTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "subnet_id": subnet_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if allowed_user_ip_cidrs is not None:
            self._values["allowed_user_ip_cidrs"] = allowed_user_ip_cidrs
        if front_end_scale_factor is not None:
            self._values["front_end_scale_factor"] = front_end_scale_factor
        if internal_load_balancing_mode is not None:
            self._values["internal_load_balancing_mode"] = internal_load_balancing_mode
        if pricing_tier is not None:
            self._values["pricing_tier"] = pricing_tier
        if resource_group_name is not None:
            self._values["resource_group_name"] = resource_group_name
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if user_whitelisted_ip_ranges is not None:
            self._values["user_whitelisted_ip_ranges"] = user_whitelisted_ip_ranges

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def subnet_id(self) -> builtins.str:
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    @builtins.property
    def allowed_user_ip_cidrs(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("allowed_user_ip_cidrs")
        return result

    @builtins.property
    def front_end_scale_factor(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("front_end_scale_factor")
        return result

    @builtins.property
    def internal_load_balancing_mode(self) -> typing.Optional[builtins.str]:
        result = self._values.get("internal_load_balancing_mode")
        return result

    @builtins.property
    def pricing_tier(self) -> typing.Optional[builtins.str]:
        result = self._values.get("pricing_tier")
        return result

    @builtins.property
    def resource_group_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("resource_group_name")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceEnvironmentTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def user_whitelisted_ip_ranges(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("user_whitelisted_ip_ranges")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceEnvironmentConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceEnvironmentTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceEnvironmentTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceEnvironmentTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceHybridConnection(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceHybridConnection",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        app_service_name: builtins.str,
        hostname: builtins.str,
        port: jsii.Number,
        relay_id: builtins.str,
        resource_group_name: builtins.str,
        send_key_name: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["AppServiceHybridConnectionTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param app_service_name: -
        :param hostname: -
        :param port: -
        :param relay_id: -
        :param resource_group_name: -
        :param send_key_name: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceHybridConnectionConfig(
            app_service_name=app_service_name,
            hostname=hostname,
            port=port,
            relay_id=relay_id,
            resource_group_name=resource_group_name,
            send_key_name=send_key_name,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceHybridConnection, self, [scope, id, config])

    @jsii.member(jsii_name="resetSendKeyName")
    def reset_send_key_name(self) -> None:
        return jsii.invoke(self, "resetSendKeyName", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceNameInput")
    def app_service_name_input(self) -> builtins.str:
        return jsii.get(self, "appServiceNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostnameInput")
    def hostname_input(self) -> builtins.str:
        return jsii.get(self, "hostnameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="namespaceName")
    def namespace_name(self) -> builtins.str:
        return jsii.get(self, "namespaceName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="portInput")
    def port_input(self) -> jsii.Number:
        return jsii.get(self, "portInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="relayIdInput")
    def relay_id_input(self) -> builtins.str:
        return jsii.get(self, "relayIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="relayName")
    def relay_name(self) -> builtins.str:
        return jsii.get(self, "relayName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sendKeyValue")
    def send_key_value(self) -> builtins.str:
        return jsii.get(self, "sendKeyValue")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serviceBusNamespace")
    def service_bus_namespace(self) -> builtins.str:
        return jsii.get(self, "serviceBusNamespace")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serviceBusSuffix")
    def service_bus_suffix(self) -> builtins.str:
        return jsii.get(self, "serviceBusSuffix")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sendKeyNameInput")
    def send_key_name_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "sendKeyNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceHybridConnectionTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceName")
    def app_service_name(self) -> builtins.str:
        return jsii.get(self, "appServiceName")

    @app_service_name.setter # type: ignore
    def app_service_name(self, value: builtins.str) -> None:
        jsii.set(self, "appServiceName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostname")
    def hostname(self) -> builtins.str:
        return jsii.get(self, "hostname")

    @hostname.setter # type: ignore
    def hostname(self, value: builtins.str) -> None:
        jsii.set(self, "hostname", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="port")
    def port(self) -> jsii.Number:
        return jsii.get(self, "port")

    @port.setter # type: ignore
    def port(self, value: jsii.Number) -> None:
        jsii.set(self, "port", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="relayId")
    def relay_id(self) -> builtins.str:
        return jsii.get(self, "relayId")

    @relay_id.setter # type: ignore
    def relay_id(self, value: builtins.str) -> None:
        jsii.set(self, "relayId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sendKeyName")
    def send_key_name(self) -> builtins.str:
        return jsii.get(self, "sendKeyName")

    @send_key_name.setter # type: ignore
    def send_key_name(self, value: builtins.str) -> None:
        jsii.set(self, "sendKeyName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceHybridConnectionTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceHybridConnectionTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceHybridConnectionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "app_service_name": "appServiceName",
        "hostname": "hostname",
        "port": "port",
        "relay_id": "relayId",
        "resource_group_name": "resourceGroupName",
        "send_key_name": "sendKeyName",
        "timeouts": "timeouts",
    },
)
class AppServiceHybridConnectionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        app_service_name: builtins.str,
        hostname: builtins.str,
        port: jsii.Number,
        relay_id: builtins.str,
        resource_group_name: builtins.str,
        send_key_name: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional["AppServiceHybridConnectionTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param app_service_name: -
        :param hostname: -
        :param port: -
        :param relay_id: -
        :param resource_group_name: -
        :param send_key_name: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceHybridConnectionTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "app_service_name": app_service_name,
            "hostname": hostname,
            "port": port,
            "relay_id": relay_id,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if send_key_name is not None:
            self._values["send_key_name"] = send_key_name
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def app_service_name(self) -> builtins.str:
        result = self._values.get("app_service_name")
        assert result is not None, "Required property 'app_service_name' is missing"
        return result

    @builtins.property
    def hostname(self) -> builtins.str:
        result = self._values.get("hostname")
        assert result is not None, "Required property 'hostname' is missing"
        return result

    @builtins.property
    def port(self) -> jsii.Number:
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return result

    @builtins.property
    def relay_id(self) -> builtins.str:
        result = self._values.get("relay_id")
        assert result is not None, "Required property 'relay_id' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def send_key_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("send_key_name")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceHybridConnectionTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceHybridConnectionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceHybridConnectionTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceHybridConnectionTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceHybridConnectionTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceIdentity",
    jsii_struct_bases=[],
    name_mapping={"type": "type", "identity_ids": "identityIds"},
)
class AppServiceIdentity:
    def __init__(
        self,
        *,
        type: builtins.str,
        identity_ids: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param type: -
        :param identity_ids: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if identity_ids is not None:
            self._values["identity_ids"] = identity_ids

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def identity_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("identity_ids")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceIdentity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceLogs",
    jsii_struct_bases=[],
    name_mapping={"application_logs": "applicationLogs", "http_logs": "httpLogs"},
)
class AppServiceLogs:
    def __init__(
        self,
        *,
        application_logs: typing.Optional[typing.List["AppServiceLogsApplicationLogs"]] = None,
        http_logs: typing.Optional[typing.List["AppServiceLogsHttpLogs"]] = None,
    ) -> None:
        """
        :param application_logs: application_logs block.
        :param http_logs: http_logs block.
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if application_logs is not None:
            self._values["application_logs"] = application_logs
        if http_logs is not None:
            self._values["http_logs"] = http_logs

    @builtins.property
    def application_logs(
        self,
    ) -> typing.Optional[typing.List["AppServiceLogsApplicationLogs"]]:
        """application_logs block."""
        result = self._values.get("application_logs")
        return result

    @builtins.property
    def http_logs(self) -> typing.Optional[typing.List["AppServiceLogsHttpLogs"]]:
        """http_logs block."""
        result = self._values.get("http_logs")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceLogs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceLogsApplicationLogs",
    jsii_struct_bases=[],
    name_mapping={
        "azure_blob_storage": "azureBlobStorage",
        "file_system_level": "fileSystemLevel",
    },
)
class AppServiceLogsApplicationLogs:
    def __init__(
        self,
        *,
        azure_blob_storage: typing.Optional[typing.List["AppServiceLogsApplicationLogsAzureBlobStorage"]] = None,
        file_system_level: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param azure_blob_storage: azure_blob_storage block.
        :param file_system_level: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if azure_blob_storage is not None:
            self._values["azure_blob_storage"] = azure_blob_storage
        if file_system_level is not None:
            self._values["file_system_level"] = file_system_level

    @builtins.property
    def azure_blob_storage(
        self,
    ) -> typing.Optional[typing.List["AppServiceLogsApplicationLogsAzureBlobStorage"]]:
        """azure_blob_storage block."""
        result = self._values.get("azure_blob_storage")
        return result

    @builtins.property
    def file_system_level(self) -> typing.Optional[builtins.str]:
        result = self._values.get("file_system_level")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceLogsApplicationLogs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceLogsApplicationLogsAzureBlobStorage",
    jsii_struct_bases=[],
    name_mapping={
        "level": "level",
        "retention_in_days": "retentionInDays",
        "sas_url": "sasUrl",
    },
)
class AppServiceLogsApplicationLogsAzureBlobStorage:
    def __init__(
        self,
        *,
        level: builtins.str,
        retention_in_days: jsii.Number,
        sas_url: builtins.str,
    ) -> None:
        """
        :param level: -
        :param retention_in_days: -
        :param sas_url: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "level": level,
            "retention_in_days": retention_in_days,
            "sas_url": sas_url,
        }

    @builtins.property
    def level(self) -> builtins.str:
        result = self._values.get("level")
        assert result is not None, "Required property 'level' is missing"
        return result

    @builtins.property
    def retention_in_days(self) -> jsii.Number:
        result = self._values.get("retention_in_days")
        assert result is not None, "Required property 'retention_in_days' is missing"
        return result

    @builtins.property
    def sas_url(self) -> builtins.str:
        result = self._values.get("sas_url")
        assert result is not None, "Required property 'sas_url' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceLogsApplicationLogsAzureBlobStorage(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceLogsHttpLogs",
    jsii_struct_bases=[],
    name_mapping={
        "azure_blob_storage": "azureBlobStorage",
        "file_system": "fileSystem",
    },
)
class AppServiceLogsHttpLogs:
    def __init__(
        self,
        *,
        azure_blob_storage: typing.Optional[typing.List["AppServiceLogsHttpLogsAzureBlobStorage"]] = None,
        file_system: typing.Optional[typing.List["AppServiceLogsHttpLogsFileSystem"]] = None,
    ) -> None:
        """
        :param azure_blob_storage: azure_blob_storage block.
        :param file_system: file_system block.
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if azure_blob_storage is not None:
            self._values["azure_blob_storage"] = azure_blob_storage
        if file_system is not None:
            self._values["file_system"] = file_system

    @builtins.property
    def azure_blob_storage(
        self,
    ) -> typing.Optional[typing.List["AppServiceLogsHttpLogsAzureBlobStorage"]]:
        """azure_blob_storage block."""
        result = self._values.get("azure_blob_storage")
        return result

    @builtins.property
    def file_system(
        self,
    ) -> typing.Optional[typing.List["AppServiceLogsHttpLogsFileSystem"]]:
        """file_system block."""
        result = self._values.get("file_system")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceLogsHttpLogs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceLogsHttpLogsAzureBlobStorage",
    jsii_struct_bases=[],
    name_mapping={"retention_in_days": "retentionInDays", "sas_url": "sasUrl"},
)
class AppServiceLogsHttpLogsAzureBlobStorage:
    def __init__(
        self,
        *,
        retention_in_days: jsii.Number,
        sas_url: builtins.str,
    ) -> None:
        """
        :param retention_in_days: -
        :param sas_url: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "retention_in_days": retention_in_days,
            "sas_url": sas_url,
        }

    @builtins.property
    def retention_in_days(self) -> jsii.Number:
        result = self._values.get("retention_in_days")
        assert result is not None, "Required property 'retention_in_days' is missing"
        return result

    @builtins.property
    def sas_url(self) -> builtins.str:
        result = self._values.get("sas_url")
        assert result is not None, "Required property 'sas_url' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceLogsHttpLogsAzureBlobStorage(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceLogsHttpLogsFileSystem",
    jsii_struct_bases=[],
    name_mapping={
        "retention_in_days": "retentionInDays",
        "retention_in_mb": "retentionInMb",
    },
)
class AppServiceLogsHttpLogsFileSystem:
    def __init__(
        self,
        *,
        retention_in_days: jsii.Number,
        retention_in_mb: jsii.Number,
    ) -> None:
        """
        :param retention_in_days: -
        :param retention_in_mb: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "retention_in_days": retention_in_days,
            "retention_in_mb": retention_in_mb,
        }

    @builtins.property
    def retention_in_days(self) -> jsii.Number:
        result = self._values.get("retention_in_days")
        assert result is not None, "Required property 'retention_in_days' is missing"
        return result

    @builtins.property
    def retention_in_mb(self) -> jsii.Number:
        result = self._values.get("retention_in_mb")
        assert result is not None, "Required property 'retention_in_mb' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceLogsHttpLogsFileSystem(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceManagedCertificate(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceManagedCertificate",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        custom_hostname_binding_id: builtins.str,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceManagedCertificateTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param custom_hostname_binding_id: -
        :param tags: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceManagedCertificateConfig(
            custom_hostname_binding_id=custom_hostname_binding_id,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceManagedCertificate, self, [scope, id, config])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="canonicalName")
    def canonical_name(self) -> builtins.str:
        return jsii.get(self, "canonicalName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="customHostnameBindingIdInput")
    def custom_hostname_binding_id_input(self) -> builtins.str:
        return jsii.get(self, "customHostnameBindingIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="expirationDate")
    def expiration_date(self) -> builtins.str:
        return jsii.get(self, "expirationDate")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="friendlyName")
    def friendly_name(self) -> builtins.str:
        return jsii.get(self, "friendlyName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostNames")
    def host_names(self) -> typing.List[builtins.str]:
        return jsii.get(self, "hostNames")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="issueDate")
    def issue_date(self) -> builtins.str:
        return jsii.get(self, "issueDate")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="issuer")
    def issuer(self) -> builtins.str:
        return jsii.get(self, "issuer")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subjectName")
    def subject_name(self) -> builtins.str:
        return jsii.get(self, "subjectName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="thumbprint")
    def thumbprint(self) -> builtins.str:
        return jsii.get(self, "thumbprint")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceManagedCertificateTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="customHostnameBindingId")
    def custom_hostname_binding_id(self) -> builtins.str:
        return jsii.get(self, "customHostnameBindingId")

    @custom_hostname_binding_id.setter # type: ignore
    def custom_hostname_binding_id(self, value: builtins.str) -> None:
        jsii.set(self, "customHostnameBindingId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceManagedCertificateTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceManagedCertificateTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceManagedCertificateConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "custom_hostname_binding_id": "customHostnameBindingId",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AppServiceManagedCertificateConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        custom_hostname_binding_id: builtins.str,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceManagedCertificateTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param custom_hostname_binding_id: -
        :param tags: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceManagedCertificateTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "custom_hostname_binding_id": custom_hostname_binding_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def custom_hostname_binding_id(self) -> builtins.str:
        result = self._values.get("custom_hostname_binding_id")
        assert result is not None, "Required property 'custom_hostname_binding_id' is missing"
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceManagedCertificateTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceManagedCertificateConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceManagedCertificateTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceManagedCertificateTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceManagedCertificateTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServicePlan(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServicePlan",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        sku: typing.List["AppServicePlanSku"],
        app_service_environment_id: typing.Optional[builtins.str] = None,
        is_xenon: typing.Optional[builtins.bool] = None,
        kind: typing.Optional[builtins.str] = None,
        maximum_elastic_worker_count: typing.Optional[jsii.Number] = None,
        per_site_scaling: typing.Optional[builtins.bool] = None,
        reserved: typing.Optional[builtins.bool] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServicePlanTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param sku: sku block.
        :param app_service_environment_id: -
        :param is_xenon: -
        :param kind: -
        :param maximum_elastic_worker_count: -
        :param per_site_scaling: -
        :param reserved: -
        :param tags: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServicePlanConfig(
            location=location,
            name=name,
            resource_group_name=resource_group_name,
            sku=sku,
            app_service_environment_id=app_service_environment_id,
            is_xenon=is_xenon,
            kind=kind,
            maximum_elastic_worker_count=maximum_elastic_worker_count,
            per_site_scaling=per_site_scaling,
            reserved=reserved,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServicePlan, self, [scope, id, config])

    @jsii.member(jsii_name="resetAppServiceEnvironmentId")
    def reset_app_service_environment_id(self) -> None:
        return jsii.invoke(self, "resetAppServiceEnvironmentId", [])

    @jsii.member(jsii_name="resetIsXenon")
    def reset_is_xenon(self) -> None:
        return jsii.invoke(self, "resetIsXenon", [])

    @jsii.member(jsii_name="resetKind")
    def reset_kind(self) -> None:
        return jsii.invoke(self, "resetKind", [])

    @jsii.member(jsii_name="resetMaximumElasticWorkerCount")
    def reset_maximum_elastic_worker_count(self) -> None:
        return jsii.invoke(self, "resetMaximumElasticWorkerCount", [])

    @jsii.member(jsii_name="resetPerSiteScaling")
    def reset_per_site_scaling(self) -> None:
        return jsii.invoke(self, "resetPerSiteScaling", [])

    @jsii.member(jsii_name="resetReserved")
    def reset_reserved(self) -> None:
        return jsii.invoke(self, "resetReserved", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="locationInput")
    def location_input(self) -> builtins.str:
        return jsii.get(self, "locationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="maximumNumberOfWorkers")
    def maximum_number_of_workers(self) -> jsii.Number:
        return jsii.get(self, "maximumNumberOfWorkers")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="skuInput")
    def sku_input(self) -> typing.List["AppServicePlanSku"]:
        return jsii.get(self, "skuInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceEnvironmentIdInput")
    def app_service_environment_id_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "appServiceEnvironmentIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="isXenonInput")
    def is_xenon_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "isXenonInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="kindInput")
    def kind_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "kindInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="maximumElasticWorkerCountInput")
    def maximum_elastic_worker_count_input(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "maximumElasticWorkerCountInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="perSiteScalingInput")
    def per_site_scaling_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "perSiteScalingInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="reservedInput")
    def reserved_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "reservedInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServicePlanTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceEnvironmentId")
    def app_service_environment_id(self) -> builtins.str:
        return jsii.get(self, "appServiceEnvironmentId")

    @app_service_environment_id.setter # type: ignore
    def app_service_environment_id(self, value: builtins.str) -> None:
        jsii.set(self, "appServiceEnvironmentId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="isXenon")
    def is_xenon(self) -> builtins.bool:
        return jsii.get(self, "isXenon")

    @is_xenon.setter # type: ignore
    def is_xenon(self, value: builtins.bool) -> None:
        jsii.set(self, "isXenon", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        return jsii.get(self, "kind")

    @kind.setter # type: ignore
    def kind(self, value: builtins.str) -> None:
        jsii.set(self, "kind", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(self) -> builtins.str:
        return jsii.get(self, "location")

    @location.setter # type: ignore
    def location(self, value: builtins.str) -> None:
        jsii.set(self, "location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="maximumElasticWorkerCount")
    def maximum_elastic_worker_count(self) -> jsii.Number:
        return jsii.get(self, "maximumElasticWorkerCount")

    @maximum_elastic_worker_count.setter # type: ignore
    def maximum_elastic_worker_count(self, value: jsii.Number) -> None:
        jsii.set(self, "maximumElasticWorkerCount", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="perSiteScaling")
    def per_site_scaling(self) -> builtins.bool:
        return jsii.get(self, "perSiteScaling")

    @per_site_scaling.setter # type: ignore
    def per_site_scaling(self, value: builtins.bool) -> None:
        jsii.set(self, "perSiteScaling", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="reserved")
    def reserved(self) -> builtins.bool:
        return jsii.get(self, "reserved")

    @reserved.setter # type: ignore
    def reserved(self, value: builtins.bool) -> None:
        jsii.set(self, "reserved", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sku")
    def sku(self) -> typing.List["AppServicePlanSku"]:
        return jsii.get(self, "sku")

    @sku.setter # type: ignore
    def sku(self, value: typing.List["AppServicePlanSku"]) -> None:
        jsii.set(self, "sku", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServicePlanTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServicePlanTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppServicePlanConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "location": "location",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "sku": "sku",
        "app_service_environment_id": "appServiceEnvironmentId",
        "is_xenon": "isXenon",
        "kind": "kind",
        "maximum_elastic_worker_count": "maximumElasticWorkerCount",
        "per_site_scaling": "perSiteScaling",
        "reserved": "reserved",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AppServicePlanConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        sku: typing.List["AppServicePlanSku"],
        app_service_environment_id: typing.Optional[builtins.str] = None,
        is_xenon: typing.Optional[builtins.bool] = None,
        kind: typing.Optional[builtins.str] = None,
        maximum_elastic_worker_count: typing.Optional[jsii.Number] = None,
        per_site_scaling: typing.Optional[builtins.bool] = None,
        reserved: typing.Optional[builtins.bool] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServicePlanTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param sku: sku block.
        :param app_service_environment_id: -
        :param is_xenon: -
        :param kind: -
        :param maximum_elastic_worker_count: -
        :param per_site_scaling: -
        :param reserved: -
        :param tags: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServicePlanTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "location": location,
            "name": name,
            "resource_group_name": resource_group_name,
            "sku": sku,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if app_service_environment_id is not None:
            self._values["app_service_environment_id"] = app_service_environment_id
        if is_xenon is not None:
            self._values["is_xenon"] = is_xenon
        if kind is not None:
            self._values["kind"] = kind
        if maximum_elastic_worker_count is not None:
            self._values["maximum_elastic_worker_count"] = maximum_elastic_worker_count
        if per_site_scaling is not None:
            self._values["per_site_scaling"] = per_site_scaling
        if reserved is not None:
            self._values["reserved"] = reserved
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def location(self) -> builtins.str:
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def sku(self) -> typing.List["AppServicePlanSku"]:
        """sku block."""
        result = self._values.get("sku")
        assert result is not None, "Required property 'sku' is missing"
        return result

    @builtins.property
    def app_service_environment_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("app_service_environment_id")
        return result

    @builtins.property
    def is_xenon(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("is_xenon")
        return result

    @builtins.property
    def kind(self) -> typing.Optional[builtins.str]:
        result = self._values.get("kind")
        return result

    @builtins.property
    def maximum_elastic_worker_count(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("maximum_elastic_worker_count")
        return result

    @builtins.property
    def per_site_scaling(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("per_site_scaling")
        return result

    @builtins.property
    def reserved(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("reserved")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServicePlanTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServicePlanConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServicePlanSku",
    jsii_struct_bases=[],
    name_mapping={"size": "size", "tier": "tier", "capacity": "capacity"},
)
class AppServicePlanSku:
    def __init__(
        self,
        *,
        size: builtins.str,
        tier: builtins.str,
        capacity: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param size: -
        :param tier: -
        :param capacity: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "size": size,
            "tier": tier,
        }
        if capacity is not None:
            self._values["capacity"] = capacity

    @builtins.property
    def size(self) -> builtins.str:
        result = self._values.get("size")
        assert result is not None, "Required property 'size' is missing"
        return result

    @builtins.property
    def tier(self) -> builtins.str:
        result = self._values.get("tier")
        assert result is not None, "Required property 'tier' is missing"
        return result

    @builtins.property
    def capacity(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("capacity")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServicePlanSku(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServicePlanTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServicePlanTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServicePlanTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSiteConfig",
    jsii_struct_bases=[],
    name_mapping={
        "always_on": "alwaysOn",
        "app_command_line": "appCommandLine",
        "auto_swap_slot_name": "autoSwapSlotName",
        "cors": "cors",
        "default_documents": "defaultDocuments",
        "dotnet_framework_version": "dotnetFrameworkVersion",
        "ftps_state": "ftpsState",
        "health_check_path": "healthCheckPath",
        "http2_enabled": "http2Enabled",
        "ip_restriction": "ipRestriction",
        "java_container": "javaContainer",
        "java_container_version": "javaContainerVersion",
        "java_version": "javaVersion",
        "linux_fx_version": "linuxFxVersion",
        "local_mysql_enabled": "localMysqlEnabled",
        "managed_pipeline_mode": "managedPipelineMode",
        "min_tls_version": "minTlsVersion",
        "php_version": "phpVersion",
        "python_version": "pythonVersion",
        "remote_debugging_enabled": "remoteDebuggingEnabled",
        "remote_debugging_version": "remoteDebuggingVersion",
        "scm_ip_restriction": "scmIpRestriction",
        "scm_type": "scmType",
        "scm_use_main_ip_restriction": "scmUseMainIpRestriction",
        "use32_bit_worker_process": "use32BitWorkerProcess",
        "websockets_enabled": "websocketsEnabled",
        "windows_fx_version": "windowsFxVersion",
    },
)
class AppServiceSiteConfig:
    def __init__(
        self,
        *,
        always_on: typing.Optional[builtins.bool] = None,
        app_command_line: typing.Optional[builtins.str] = None,
        auto_swap_slot_name: typing.Optional[builtins.str] = None,
        cors: typing.Optional[typing.List["AppServiceSiteConfigCors"]] = None,
        default_documents: typing.Optional[typing.List[builtins.str]] = None,
        dotnet_framework_version: typing.Optional[builtins.str] = None,
        ftps_state: typing.Optional[builtins.str] = None,
        health_check_path: typing.Optional[builtins.str] = None,
        http2_enabled: typing.Optional[builtins.bool] = None,
        ip_restriction: typing.Optional[typing.List["AppServiceSiteConfigIpRestriction"]] = None,
        java_container: typing.Optional[builtins.str] = None,
        java_container_version: typing.Optional[builtins.str] = None,
        java_version: typing.Optional[builtins.str] = None,
        linux_fx_version: typing.Optional[builtins.str] = None,
        local_mysql_enabled: typing.Optional[builtins.bool] = None,
        managed_pipeline_mode: typing.Optional[builtins.str] = None,
        min_tls_version: typing.Optional[builtins.str] = None,
        php_version: typing.Optional[builtins.str] = None,
        python_version: typing.Optional[builtins.str] = None,
        remote_debugging_enabled: typing.Optional[builtins.bool] = None,
        remote_debugging_version: typing.Optional[builtins.str] = None,
        scm_ip_restriction: typing.Optional[typing.List["AppServiceSiteConfigScmIpRestriction"]] = None,
        scm_type: typing.Optional[builtins.str] = None,
        scm_use_main_ip_restriction: typing.Optional[builtins.bool] = None,
        use32_bit_worker_process: typing.Optional[builtins.bool] = None,
        websockets_enabled: typing.Optional[builtins.bool] = None,
        windows_fx_version: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param always_on: -
        :param app_command_line: -
        :param auto_swap_slot_name: -
        :param cors: cors block.
        :param default_documents: -
        :param dotnet_framework_version: -
        :param ftps_state: -
        :param health_check_path: -
        :param http2_enabled: -
        :param ip_restriction: -
        :param java_container: -
        :param java_container_version: -
        :param java_version: -
        :param linux_fx_version: -
        :param local_mysql_enabled: -
        :param managed_pipeline_mode: -
        :param min_tls_version: -
        :param php_version: -
        :param python_version: -
        :param remote_debugging_enabled: -
        :param remote_debugging_version: -
        :param scm_ip_restriction: -
        :param scm_type: -
        :param scm_use_main_ip_restriction: -
        :param use32_bit_worker_process: -
        :param websockets_enabled: -
        :param windows_fx_version: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if always_on is not None:
            self._values["always_on"] = always_on
        if app_command_line is not None:
            self._values["app_command_line"] = app_command_line
        if auto_swap_slot_name is not None:
            self._values["auto_swap_slot_name"] = auto_swap_slot_name
        if cors is not None:
            self._values["cors"] = cors
        if default_documents is not None:
            self._values["default_documents"] = default_documents
        if dotnet_framework_version is not None:
            self._values["dotnet_framework_version"] = dotnet_framework_version
        if ftps_state is not None:
            self._values["ftps_state"] = ftps_state
        if health_check_path is not None:
            self._values["health_check_path"] = health_check_path
        if http2_enabled is not None:
            self._values["http2_enabled"] = http2_enabled
        if ip_restriction is not None:
            self._values["ip_restriction"] = ip_restriction
        if java_container is not None:
            self._values["java_container"] = java_container
        if java_container_version is not None:
            self._values["java_container_version"] = java_container_version
        if java_version is not None:
            self._values["java_version"] = java_version
        if linux_fx_version is not None:
            self._values["linux_fx_version"] = linux_fx_version
        if local_mysql_enabled is not None:
            self._values["local_mysql_enabled"] = local_mysql_enabled
        if managed_pipeline_mode is not None:
            self._values["managed_pipeline_mode"] = managed_pipeline_mode
        if min_tls_version is not None:
            self._values["min_tls_version"] = min_tls_version
        if php_version is not None:
            self._values["php_version"] = php_version
        if python_version is not None:
            self._values["python_version"] = python_version
        if remote_debugging_enabled is not None:
            self._values["remote_debugging_enabled"] = remote_debugging_enabled
        if remote_debugging_version is not None:
            self._values["remote_debugging_version"] = remote_debugging_version
        if scm_ip_restriction is not None:
            self._values["scm_ip_restriction"] = scm_ip_restriction
        if scm_type is not None:
            self._values["scm_type"] = scm_type
        if scm_use_main_ip_restriction is not None:
            self._values["scm_use_main_ip_restriction"] = scm_use_main_ip_restriction
        if use32_bit_worker_process is not None:
            self._values["use32_bit_worker_process"] = use32_bit_worker_process
        if websockets_enabled is not None:
            self._values["websockets_enabled"] = websockets_enabled
        if windows_fx_version is not None:
            self._values["windows_fx_version"] = windows_fx_version

    @builtins.property
    def always_on(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("always_on")
        return result

    @builtins.property
    def app_command_line(self) -> typing.Optional[builtins.str]:
        result = self._values.get("app_command_line")
        return result

    @builtins.property
    def auto_swap_slot_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("auto_swap_slot_name")
        return result

    @builtins.property
    def cors(self) -> typing.Optional[typing.List["AppServiceSiteConfigCors"]]:
        """cors block."""
        result = self._values.get("cors")
        return result

    @builtins.property
    def default_documents(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("default_documents")
        return result

    @builtins.property
    def dotnet_framework_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("dotnet_framework_version")
        return result

    @builtins.property
    def ftps_state(self) -> typing.Optional[builtins.str]:
        result = self._values.get("ftps_state")
        return result

    @builtins.property
    def health_check_path(self) -> typing.Optional[builtins.str]:
        result = self._values.get("health_check_path")
        return result

    @builtins.property
    def http2_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("http2_enabled")
        return result

    @builtins.property
    def ip_restriction(
        self,
    ) -> typing.Optional[typing.List["AppServiceSiteConfigIpRestriction"]]:
        result = self._values.get("ip_restriction")
        return result

    @builtins.property
    def java_container(self) -> typing.Optional[builtins.str]:
        result = self._values.get("java_container")
        return result

    @builtins.property
    def java_container_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("java_container_version")
        return result

    @builtins.property
    def java_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("java_version")
        return result

    @builtins.property
    def linux_fx_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("linux_fx_version")
        return result

    @builtins.property
    def local_mysql_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("local_mysql_enabled")
        return result

    @builtins.property
    def managed_pipeline_mode(self) -> typing.Optional[builtins.str]:
        result = self._values.get("managed_pipeline_mode")
        return result

    @builtins.property
    def min_tls_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("min_tls_version")
        return result

    @builtins.property
    def php_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("php_version")
        return result

    @builtins.property
    def python_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("python_version")
        return result

    @builtins.property
    def remote_debugging_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("remote_debugging_enabled")
        return result

    @builtins.property
    def remote_debugging_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("remote_debugging_version")
        return result

    @builtins.property
    def scm_ip_restriction(
        self,
    ) -> typing.Optional[typing.List["AppServiceSiteConfigScmIpRestriction"]]:
        result = self._values.get("scm_ip_restriction")
        return result

    @builtins.property
    def scm_type(self) -> typing.Optional[builtins.str]:
        result = self._values.get("scm_type")
        return result

    @builtins.property
    def scm_use_main_ip_restriction(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("scm_use_main_ip_restriction")
        return result

    @builtins.property
    def use32_bit_worker_process(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("use32_bit_worker_process")
        return result

    @builtins.property
    def websockets_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("websockets_enabled")
        return result

    @builtins.property
    def windows_fx_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("windows_fx_version")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSiteConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSiteConfigCors",
    jsii_struct_bases=[],
    name_mapping={
        "allowed_origins": "allowedOrigins",
        "support_credentials": "supportCredentials",
    },
)
class AppServiceSiteConfigCors:
    def __init__(
        self,
        *,
        allowed_origins: typing.List[builtins.str],
        support_credentials: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param allowed_origins: -
        :param support_credentials: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "allowed_origins": allowed_origins,
        }
        if support_credentials is not None:
            self._values["support_credentials"] = support_credentials

    @builtins.property
    def allowed_origins(self) -> typing.List[builtins.str]:
        result = self._values.get("allowed_origins")
        assert result is not None, "Required property 'allowed_origins' is missing"
        return result

    @builtins.property
    def support_credentials(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("support_credentials")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSiteConfigCors(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSiteConfigIpRestriction",
    jsii_struct_bases=[],
    name_mapping={
        "action": "action",
        "ip_address": "ipAddress",
        "name": "name",
        "priority": "priority",
        "subnet_id": "subnetId",
        "virtual_network_subnet_id": "virtualNetworkSubnetId",
    },
)
class AppServiceSiteConfigIpRestriction:
    def __init__(
        self,
        *,
        action: typing.Optional[builtins.str] = None,
        ip_address: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        priority: typing.Optional[jsii.Number] = None,
        subnet_id: typing.Optional[builtins.str] = None,
        virtual_network_subnet_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param action: -
        :param ip_address: -
        :param name: -
        :param priority: -
        :param subnet_id: -
        :param virtual_network_subnet_id: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if action is not None:
            self._values["action"] = action
        if ip_address is not None:
            self._values["ip_address"] = ip_address
        if name is not None:
            self._values["name"] = name
        if priority is not None:
            self._values["priority"] = priority
        if subnet_id is not None:
            self._values["subnet_id"] = subnet_id
        if virtual_network_subnet_id is not None:
            self._values["virtual_network_subnet_id"] = virtual_network_subnet_id

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        result = self._values.get("action")
        return result

    @builtins.property
    def ip_address(self) -> typing.Optional[builtins.str]:
        result = self._values.get("ip_address")
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("name")
        return result

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("priority")
        return result

    @builtins.property
    def subnet_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("subnet_id")
        return result

    @builtins.property
    def virtual_network_subnet_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("virtual_network_subnet_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSiteConfigIpRestriction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSiteConfigScmIpRestriction",
    jsii_struct_bases=[],
    name_mapping={
        "action": "action",
        "ip_address": "ipAddress",
        "name": "name",
        "priority": "priority",
        "subnet_id": "subnetId",
        "virtual_network_subnet_id": "virtualNetworkSubnetId",
    },
)
class AppServiceSiteConfigScmIpRestriction:
    def __init__(
        self,
        *,
        action: typing.Optional[builtins.str] = None,
        ip_address: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        priority: typing.Optional[jsii.Number] = None,
        subnet_id: typing.Optional[builtins.str] = None,
        virtual_network_subnet_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param action: -
        :param ip_address: -
        :param name: -
        :param priority: -
        :param subnet_id: -
        :param virtual_network_subnet_id: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if action is not None:
            self._values["action"] = action
        if ip_address is not None:
            self._values["ip_address"] = ip_address
        if name is not None:
            self._values["name"] = name
        if priority is not None:
            self._values["priority"] = priority
        if subnet_id is not None:
            self._values["subnet_id"] = subnet_id
        if virtual_network_subnet_id is not None:
            self._values["virtual_network_subnet_id"] = virtual_network_subnet_id

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        result = self._values.get("action")
        return result

    @builtins.property
    def ip_address(self) -> typing.Optional[builtins.str]:
        result = self._values.get("ip_address")
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("name")
        return result

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("priority")
        return result

    @builtins.property
    def subnet_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("subnet_id")
        return result

    @builtins.property
    def virtual_network_subnet_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("virtual_network_subnet_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSiteConfigScmIpRestriction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceSiteCredential(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceSiteCredential",
):
    def __init__(
        self,
        terraform_resource: cdktf.ITerraformResource,
        terraform_attribute: builtins.str,
        index: builtins.str,
    ) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        :stability: experimental
        """
        jsii.create(AppServiceSiteCredential, self, [terraform_resource, terraform_attribute, index])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return jsii.get(self, "password")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="username")
    def username(self) -> builtins.str:
        return jsii.get(self, "username")


class AppServiceSlot(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceSlot",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        app_service_name: builtins.str,
        app_service_plan_id: builtins.str,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        app_settings: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        auth_settings: typing.Optional[typing.List["AppServiceSlotAuthSettings"]] = None,
        client_affinity_enabled: typing.Optional[builtins.bool] = None,
        connection_string: typing.Optional[typing.List["AppServiceSlotConnectionString"]] = None,
        enabled: typing.Optional[builtins.bool] = None,
        https_only: typing.Optional[builtins.bool] = None,
        identity: typing.Optional[typing.List["AppServiceSlotIdentity"]] = None,
        logs: typing.Optional[typing.List["AppServiceSlotLogs"]] = None,
        site_config: typing.Optional[typing.List["AppServiceSlotSiteConfig"]] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceSlotTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param app_service_name: -
        :param app_service_plan_id: -
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param app_settings: -
        :param auth_settings: auth_settings block.
        :param client_affinity_enabled: -
        :param connection_string: connection_string block.
        :param enabled: -
        :param https_only: -
        :param identity: identity block.
        :param logs: logs block.
        :param site_config: site_config block.
        :param tags: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceSlotConfig(
            app_service_name=app_service_name,
            app_service_plan_id=app_service_plan_id,
            location=location,
            name=name,
            resource_group_name=resource_group_name,
            app_settings=app_settings,
            auth_settings=auth_settings,
            client_affinity_enabled=client_affinity_enabled,
            connection_string=connection_string,
            enabled=enabled,
            https_only=https_only,
            identity=identity,
            logs=logs,
            site_config=site_config,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceSlot, self, [scope, id, config])

    @jsii.member(jsii_name="resetAppSettings")
    def reset_app_settings(self) -> None:
        return jsii.invoke(self, "resetAppSettings", [])

    @jsii.member(jsii_name="resetAuthSettings")
    def reset_auth_settings(self) -> None:
        return jsii.invoke(self, "resetAuthSettings", [])

    @jsii.member(jsii_name="resetClientAffinityEnabled")
    def reset_client_affinity_enabled(self) -> None:
        return jsii.invoke(self, "resetClientAffinityEnabled", [])

    @jsii.member(jsii_name="resetConnectionString")
    def reset_connection_string(self) -> None:
        return jsii.invoke(self, "resetConnectionString", [])

    @jsii.member(jsii_name="resetEnabled")
    def reset_enabled(self) -> None:
        return jsii.invoke(self, "resetEnabled", [])

    @jsii.member(jsii_name="resetHttpsOnly")
    def reset_https_only(self) -> None:
        return jsii.invoke(self, "resetHttpsOnly", [])

    @jsii.member(jsii_name="resetIdentity")
    def reset_identity(self) -> None:
        return jsii.invoke(self, "resetIdentity", [])

    @jsii.member(jsii_name="resetLogs")
    def reset_logs(self) -> None:
        return jsii.invoke(self, "resetLogs", [])

    @jsii.member(jsii_name="resetSiteConfig")
    def reset_site_config(self) -> None:
        return jsii.invoke(self, "resetSiteConfig", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="siteCredential")
    def site_credential(self, index: builtins.str) -> "AppServiceSlotSiteCredential":
        """
        :param index: -
        """
        return jsii.invoke(self, "siteCredential", [index])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceNameInput")
    def app_service_name_input(self) -> builtins.str:
        return jsii.get(self, "appServiceNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServicePlanIdInput")
    def app_service_plan_id_input(self) -> builtins.str:
        return jsii.get(self, "appServicePlanIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultSiteHostname")
    def default_site_hostname(self) -> builtins.str:
        return jsii.get(self, "defaultSiteHostname")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="locationInput")
    def location_input(self) -> builtins.str:
        return jsii.get(self, "locationInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> builtins.str:
        return jsii.get(self, "nameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> builtins.str:
        return jsii.get(self, "resourceGroupNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appSettingsInput")
    def app_settings_input(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "appSettingsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authSettingsInput")
    def auth_settings_input(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotAuthSettings"]]:
        return jsii.get(self, "authSettingsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientAffinityEnabledInput")
    def client_affinity_enabled_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "clientAffinityEnabledInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionStringInput")
    def connection_string_input(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotConnectionString"]]:
        return jsii.get(self, "connectionStringInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enabledInput")
    def enabled_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "enabledInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="httpsOnlyInput")
    def https_only_input(self) -> typing.Optional[builtins.bool]:
        return jsii.get(self, "httpsOnlyInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identityInput")
    def identity_input(self) -> typing.Optional[typing.List["AppServiceSlotIdentity"]]:
        return jsii.get(self, "identityInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logsInput")
    def logs_input(self) -> typing.Optional[typing.List["AppServiceSlotLogs"]]:
        return jsii.get(self, "logsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="siteConfigInput")
    def site_config_input(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotSiteConfig"]]:
        return jsii.get(self, "siteConfigInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagsInput")
    def tags_input(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return jsii.get(self, "tagsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceSlotTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceName")
    def app_service_name(self) -> builtins.str:
        return jsii.get(self, "appServiceName")

    @app_service_name.setter # type: ignore
    def app_service_name(self, value: builtins.str) -> None:
        jsii.set(self, "appServiceName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServicePlanId")
    def app_service_plan_id(self) -> builtins.str:
        return jsii.get(self, "appServicePlanId")

    @app_service_plan_id.setter # type: ignore
    def app_service_plan_id(self, value: builtins.str) -> None:
        jsii.set(self, "appServicePlanId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appSettings")
    def app_settings(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "appSettings")

    @app_settings.setter # type: ignore
    def app_settings(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "appSettings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authSettings")
    def auth_settings(self) -> typing.List["AppServiceSlotAuthSettings"]:
        return jsii.get(self, "authSettings")

    @auth_settings.setter # type: ignore
    def auth_settings(self, value: typing.List["AppServiceSlotAuthSettings"]) -> None:
        jsii.set(self, "authSettings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> builtins.bool:
        return jsii.get(self, "clientAffinityEnabled")

    @client_affinity_enabled.setter # type: ignore
    def client_affinity_enabled(self, value: builtins.bool) -> None:
        jsii.set(self, "clientAffinityEnabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionString")
    def connection_string(self) -> typing.List["AppServiceSlotConnectionString"]:
        return jsii.get(self, "connectionString")

    @connection_string.setter # type: ignore
    def connection_string(
        self,
        value: typing.List["AppServiceSlotConnectionString"],
    ) -> None:
        jsii.set(self, "connectionString", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> builtins.bool:
        return jsii.get(self, "enabled")

    @enabled.setter # type: ignore
    def enabled(self, value: builtins.bool) -> None:
        jsii.set(self, "enabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="httpsOnly")
    def https_only(self) -> builtins.bool:
        return jsii.get(self, "httpsOnly")

    @https_only.setter # type: ignore
    def https_only(self, value: builtins.bool) -> None:
        jsii.set(self, "httpsOnly", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="identity")
    def identity(self) -> typing.List["AppServiceSlotIdentity"]:
        return jsii.get(self, "identity")

    @identity.setter # type: ignore
    def identity(self, value: typing.List["AppServiceSlotIdentity"]) -> None:
        jsii.set(self, "identity", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="location")
    def location(self) -> builtins.str:
        return jsii.get(self, "location")

    @location.setter # type: ignore
    def location(self, value: builtins.str) -> None:
        jsii.set(self, "location", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logs")
    def logs(self) -> typing.List["AppServiceSlotLogs"]:
        return jsii.get(self, "logs")

    @logs.setter # type: ignore
    def logs(self, value: typing.List["AppServiceSlotLogs"]) -> None:
        jsii.set(self, "logs", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return jsii.get(self, "name")

    @name.setter # type: ignore
    def name(self, value: builtins.str) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return jsii.get(self, "resourceGroupName")

    @resource_group_name.setter # type: ignore
    def resource_group_name(self, value: builtins.str) -> None:
        jsii.set(self, "resourceGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="siteConfig")
    def site_config(self) -> typing.List["AppServiceSlotSiteConfig"]:
        return jsii.get(self, "siteConfig")

    @site_config.setter # type: ignore
    def site_config(self, value: typing.List["AppServiceSlotSiteConfig"]) -> None:
        jsii.set(self, "siteConfig", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Mapping[builtins.str, builtins.str]:
        return jsii.get(self, "tags")

    @tags.setter # type: ignore
    def tags(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceSlotTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceSlotTimeouts") -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotAuthSettings",
    jsii_struct_bases=[],
    name_mapping={
        "enabled": "enabled",
        "active_directory": "activeDirectory",
        "additional_login_params": "additionalLoginParams",
        "allowed_external_redirect_urls": "allowedExternalRedirectUrls",
        "default_provider": "defaultProvider",
        "facebook": "facebook",
        "google": "google",
        "issuer": "issuer",
        "microsoft": "microsoft",
        "runtime_version": "runtimeVersion",
        "token_refresh_extension_hours": "tokenRefreshExtensionHours",
        "token_store_enabled": "tokenStoreEnabled",
        "twitter": "twitter",
        "unauthenticated_client_action": "unauthenticatedClientAction",
    },
)
class AppServiceSlotAuthSettings:
    def __init__(
        self,
        *,
        enabled: builtins.bool,
        active_directory: typing.Optional[typing.List["AppServiceSlotAuthSettingsActiveDirectory"]] = None,
        additional_login_params: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        allowed_external_redirect_urls: typing.Optional[typing.List[builtins.str]] = None,
        default_provider: typing.Optional[builtins.str] = None,
        facebook: typing.Optional[typing.List["AppServiceSlotAuthSettingsFacebook"]] = None,
        google: typing.Optional[typing.List["AppServiceSlotAuthSettingsGoogle"]] = None,
        issuer: typing.Optional[builtins.str] = None,
        microsoft: typing.Optional[typing.List["AppServiceSlotAuthSettingsMicrosoft"]] = None,
        runtime_version: typing.Optional[builtins.str] = None,
        token_refresh_extension_hours: typing.Optional[jsii.Number] = None,
        token_store_enabled: typing.Optional[builtins.bool] = None,
        twitter: typing.Optional[typing.List["AppServiceSlotAuthSettingsTwitter"]] = None,
        unauthenticated_client_action: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param enabled: -
        :param active_directory: active_directory block.
        :param additional_login_params: -
        :param allowed_external_redirect_urls: -
        :param default_provider: -
        :param facebook: facebook block.
        :param google: google block.
        :param issuer: -
        :param microsoft: microsoft block.
        :param runtime_version: -
        :param token_refresh_extension_hours: -
        :param token_store_enabled: -
        :param twitter: twitter block.
        :param unauthenticated_client_action: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "enabled": enabled,
        }
        if active_directory is not None:
            self._values["active_directory"] = active_directory
        if additional_login_params is not None:
            self._values["additional_login_params"] = additional_login_params
        if allowed_external_redirect_urls is not None:
            self._values["allowed_external_redirect_urls"] = allowed_external_redirect_urls
        if default_provider is not None:
            self._values["default_provider"] = default_provider
        if facebook is not None:
            self._values["facebook"] = facebook
        if google is not None:
            self._values["google"] = google
        if issuer is not None:
            self._values["issuer"] = issuer
        if microsoft is not None:
            self._values["microsoft"] = microsoft
        if runtime_version is not None:
            self._values["runtime_version"] = runtime_version
        if token_refresh_extension_hours is not None:
            self._values["token_refresh_extension_hours"] = token_refresh_extension_hours
        if token_store_enabled is not None:
            self._values["token_store_enabled"] = token_store_enabled
        if twitter is not None:
            self._values["twitter"] = twitter
        if unauthenticated_client_action is not None:
            self._values["unauthenticated_client_action"] = unauthenticated_client_action

    @builtins.property
    def enabled(self) -> builtins.bool:
        result = self._values.get("enabled")
        assert result is not None, "Required property 'enabled' is missing"
        return result

    @builtins.property
    def active_directory(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotAuthSettingsActiveDirectory"]]:
        """active_directory block."""
        result = self._values.get("active_directory")
        return result

    @builtins.property
    def additional_login_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("additional_login_params")
        return result

    @builtins.property
    def allowed_external_redirect_urls(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("allowed_external_redirect_urls")
        return result

    @builtins.property
    def default_provider(self) -> typing.Optional[builtins.str]:
        result = self._values.get("default_provider")
        return result

    @builtins.property
    def facebook(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotAuthSettingsFacebook"]]:
        """facebook block."""
        result = self._values.get("facebook")
        return result

    @builtins.property
    def google(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotAuthSettingsGoogle"]]:
        """google block."""
        result = self._values.get("google")
        return result

    @builtins.property
    def issuer(self) -> typing.Optional[builtins.str]:
        result = self._values.get("issuer")
        return result

    @builtins.property
    def microsoft(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotAuthSettingsMicrosoft"]]:
        """microsoft block."""
        result = self._values.get("microsoft")
        return result

    @builtins.property
    def runtime_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("runtime_version")
        return result

    @builtins.property
    def token_refresh_extension_hours(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("token_refresh_extension_hours")
        return result

    @builtins.property
    def token_store_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("token_store_enabled")
        return result

    @builtins.property
    def twitter(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotAuthSettingsTwitter"]]:
        """twitter block."""
        result = self._values.get("twitter")
        return result

    @builtins.property
    def unauthenticated_client_action(self) -> typing.Optional[builtins.str]:
        result = self._values.get("unauthenticated_client_action")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotAuthSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotAuthSettingsActiveDirectory",
    jsii_struct_bases=[],
    name_mapping={
        "client_id": "clientId",
        "allowed_audiences": "allowedAudiences",
        "client_secret": "clientSecret",
    },
)
class AppServiceSlotAuthSettingsActiveDirectory:
    def __init__(
        self,
        *,
        client_id: builtins.str,
        allowed_audiences: typing.Optional[typing.List[builtins.str]] = None,
        client_secret: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param client_id: -
        :param allowed_audiences: -
        :param client_secret: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_id": client_id,
        }
        if allowed_audiences is not None:
            self._values["allowed_audiences"] = allowed_audiences
        if client_secret is not None:
            self._values["client_secret"] = client_secret

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def allowed_audiences(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("allowed_audiences")
        return result

    @builtins.property
    def client_secret(self) -> typing.Optional[builtins.str]:
        result = self._values.get("client_secret")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotAuthSettingsActiveDirectory(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotAuthSettingsFacebook",
    jsii_struct_bases=[],
    name_mapping={
        "app_id": "appId",
        "app_secret": "appSecret",
        "oauth_scopes": "oauthScopes",
    },
)
class AppServiceSlotAuthSettingsFacebook:
    def __init__(
        self,
        *,
        app_id: builtins.str,
        app_secret: builtins.str,
        oauth_scopes: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param app_id: -
        :param app_secret: -
        :param oauth_scopes: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "app_id": app_id,
            "app_secret": app_secret,
        }
        if oauth_scopes is not None:
            self._values["oauth_scopes"] = oauth_scopes

    @builtins.property
    def app_id(self) -> builtins.str:
        result = self._values.get("app_id")
        assert result is not None, "Required property 'app_id' is missing"
        return result

    @builtins.property
    def app_secret(self) -> builtins.str:
        result = self._values.get("app_secret")
        assert result is not None, "Required property 'app_secret' is missing"
        return result

    @builtins.property
    def oauth_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("oauth_scopes")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotAuthSettingsFacebook(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotAuthSettingsGoogle",
    jsii_struct_bases=[],
    name_mapping={
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "oauth_scopes": "oauthScopes",
    },
)
class AppServiceSlotAuthSettingsGoogle:
    def __init__(
        self,
        *,
        client_id: builtins.str,
        client_secret: builtins.str,
        oauth_scopes: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param client_id: -
        :param client_secret: -
        :param oauth_scopes: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_id": client_id,
            "client_secret": client_secret,
        }
        if oauth_scopes is not None:
            self._values["oauth_scopes"] = oauth_scopes

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def client_secret(self) -> builtins.str:
        result = self._values.get("client_secret")
        assert result is not None, "Required property 'client_secret' is missing"
        return result

    @builtins.property
    def oauth_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("oauth_scopes")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotAuthSettingsGoogle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotAuthSettingsMicrosoft",
    jsii_struct_bases=[],
    name_mapping={
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "oauth_scopes": "oauthScopes",
    },
)
class AppServiceSlotAuthSettingsMicrosoft:
    def __init__(
        self,
        *,
        client_id: builtins.str,
        client_secret: builtins.str,
        oauth_scopes: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param client_id: -
        :param client_secret: -
        :param oauth_scopes: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_id": client_id,
            "client_secret": client_secret,
        }
        if oauth_scopes is not None:
            self._values["oauth_scopes"] = oauth_scopes

    @builtins.property
    def client_id(self) -> builtins.str:
        result = self._values.get("client_id")
        assert result is not None, "Required property 'client_id' is missing"
        return result

    @builtins.property
    def client_secret(self) -> builtins.str:
        result = self._values.get("client_secret")
        assert result is not None, "Required property 'client_secret' is missing"
        return result

    @builtins.property
    def oauth_scopes(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("oauth_scopes")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotAuthSettingsMicrosoft(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotAuthSettingsTwitter",
    jsii_struct_bases=[],
    name_mapping={"consumer_key": "consumerKey", "consumer_secret": "consumerSecret"},
)
class AppServiceSlotAuthSettingsTwitter:
    def __init__(
        self,
        *,
        consumer_key: builtins.str,
        consumer_secret: builtins.str,
    ) -> None:
        """
        :param consumer_key: -
        :param consumer_secret: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "consumer_key": consumer_key,
            "consumer_secret": consumer_secret,
        }

    @builtins.property
    def consumer_key(self) -> builtins.str:
        result = self._values.get("consumer_key")
        assert result is not None, "Required property 'consumer_key' is missing"
        return result

    @builtins.property
    def consumer_secret(self) -> builtins.str:
        result = self._values.get("consumer_secret")
        assert result is not None, "Required property 'consumer_secret' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotAuthSettingsTwitter(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "app_service_name": "appServiceName",
        "app_service_plan_id": "appServicePlanId",
        "location": "location",
        "name": "name",
        "resource_group_name": "resourceGroupName",
        "app_settings": "appSettings",
        "auth_settings": "authSettings",
        "client_affinity_enabled": "clientAffinityEnabled",
        "connection_string": "connectionString",
        "enabled": "enabled",
        "https_only": "httpsOnly",
        "identity": "identity",
        "logs": "logs",
        "site_config": "siteConfig",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AppServiceSlotConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        app_service_name: builtins.str,
        app_service_plan_id: builtins.str,
        location: builtins.str,
        name: builtins.str,
        resource_group_name: builtins.str,
        app_settings: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        auth_settings: typing.Optional[typing.List[AppServiceSlotAuthSettings]] = None,
        client_affinity_enabled: typing.Optional[builtins.bool] = None,
        connection_string: typing.Optional[typing.List["AppServiceSlotConnectionString"]] = None,
        enabled: typing.Optional[builtins.bool] = None,
        https_only: typing.Optional[builtins.bool] = None,
        identity: typing.Optional[typing.List["AppServiceSlotIdentity"]] = None,
        logs: typing.Optional[typing.List["AppServiceSlotLogs"]] = None,
        site_config: typing.Optional[typing.List["AppServiceSlotSiteConfig"]] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["AppServiceSlotTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param app_service_name: -
        :param app_service_plan_id: -
        :param location: -
        :param name: -
        :param resource_group_name: -
        :param app_settings: -
        :param auth_settings: auth_settings block.
        :param client_affinity_enabled: -
        :param connection_string: connection_string block.
        :param enabled: -
        :param https_only: -
        :param identity: identity block.
        :param logs: logs block.
        :param site_config: site_config block.
        :param tags: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceSlotTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "app_service_name": app_service_name,
            "app_service_plan_id": app_service_plan_id,
            "location": location,
            "name": name,
            "resource_group_name": resource_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if app_settings is not None:
            self._values["app_settings"] = app_settings
        if auth_settings is not None:
            self._values["auth_settings"] = auth_settings
        if client_affinity_enabled is not None:
            self._values["client_affinity_enabled"] = client_affinity_enabled
        if connection_string is not None:
            self._values["connection_string"] = connection_string
        if enabled is not None:
            self._values["enabled"] = enabled
        if https_only is not None:
            self._values["https_only"] = https_only
        if identity is not None:
            self._values["identity"] = identity
        if logs is not None:
            self._values["logs"] = logs
        if site_config is not None:
            self._values["site_config"] = site_config
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def app_service_name(self) -> builtins.str:
        result = self._values.get("app_service_name")
        assert result is not None, "Required property 'app_service_name' is missing"
        return result

    @builtins.property
    def app_service_plan_id(self) -> builtins.str:
        result = self._values.get("app_service_plan_id")
        assert result is not None, "Required property 'app_service_plan_id' is missing"
        return result

    @builtins.property
    def location(self) -> builtins.str:
        result = self._values.get("location")
        assert result is not None, "Required property 'location' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def resource_group_name(self) -> builtins.str:
        result = self._values.get("resource_group_name")
        assert result is not None, "Required property 'resource_group_name' is missing"
        return result

    @builtins.property
    def app_settings(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("app_settings")
        return result

    @builtins.property
    def auth_settings(self) -> typing.Optional[typing.List[AppServiceSlotAuthSettings]]:
        """auth_settings block."""
        result = self._values.get("auth_settings")
        return result

    @builtins.property
    def client_affinity_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("client_affinity_enabled")
        return result

    @builtins.property
    def connection_string(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotConnectionString"]]:
        """connection_string block."""
        result = self._values.get("connection_string")
        return result

    @builtins.property
    def enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enabled")
        return result

    @builtins.property
    def https_only(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("https_only")
        return result

    @builtins.property
    def identity(self) -> typing.Optional[typing.List["AppServiceSlotIdentity"]]:
        """identity block."""
        result = self._values.get("identity")
        return result

    @builtins.property
    def logs(self) -> typing.Optional[typing.List["AppServiceSlotLogs"]]:
        """logs block."""
        result = self._values.get("logs")
        return result

    @builtins.property
    def site_config(self) -> typing.Optional[typing.List["AppServiceSlotSiteConfig"]]:
        """site_config block."""
        result = self._values.get("site_config")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        result = self._values.get("tags")
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceSlotTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotConnectionString",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "type": "type", "value": "value"},
)
class AppServiceSlotConnectionString:
    def __init__(
        self,
        *,
        name: builtins.str,
        type: builtins.str,
        value: builtins.str,
    ) -> None:
        """
        :param name: -
        :param type: -
        :param value: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "type": type,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def value(self) -> builtins.str:
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotConnectionString(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotIdentity",
    jsii_struct_bases=[],
    name_mapping={"type": "type", "identity_ids": "identityIds"},
)
class AppServiceSlotIdentity:
    def __init__(
        self,
        *,
        type: builtins.str,
        identity_ids: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """
        :param type: -
        :param identity_ids: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if identity_ids is not None:
            self._values["identity_ids"] = identity_ids

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def identity_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("identity_ids")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotIdentity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotLogs",
    jsii_struct_bases=[],
    name_mapping={"application_logs": "applicationLogs", "http_logs": "httpLogs"},
)
class AppServiceSlotLogs:
    def __init__(
        self,
        *,
        application_logs: typing.Optional[typing.List["AppServiceSlotLogsApplicationLogs"]] = None,
        http_logs: typing.Optional[typing.List["AppServiceSlotLogsHttpLogs"]] = None,
    ) -> None:
        """
        :param application_logs: application_logs block.
        :param http_logs: http_logs block.
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if application_logs is not None:
            self._values["application_logs"] = application_logs
        if http_logs is not None:
            self._values["http_logs"] = http_logs

    @builtins.property
    def application_logs(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotLogsApplicationLogs"]]:
        """application_logs block."""
        result = self._values.get("application_logs")
        return result

    @builtins.property
    def http_logs(self) -> typing.Optional[typing.List["AppServiceSlotLogsHttpLogs"]]:
        """http_logs block."""
        result = self._values.get("http_logs")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotLogs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotLogsApplicationLogs",
    jsii_struct_bases=[],
    name_mapping={
        "azure_blob_storage": "azureBlobStorage",
        "file_system_level": "fileSystemLevel",
    },
)
class AppServiceSlotLogsApplicationLogs:
    def __init__(
        self,
        *,
        azure_blob_storage: typing.Optional[typing.List["AppServiceSlotLogsApplicationLogsAzureBlobStorage"]] = None,
        file_system_level: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param azure_blob_storage: azure_blob_storage block.
        :param file_system_level: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if azure_blob_storage is not None:
            self._values["azure_blob_storage"] = azure_blob_storage
        if file_system_level is not None:
            self._values["file_system_level"] = file_system_level

    @builtins.property
    def azure_blob_storage(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotLogsApplicationLogsAzureBlobStorage"]]:
        """azure_blob_storage block."""
        result = self._values.get("azure_blob_storage")
        return result

    @builtins.property
    def file_system_level(self) -> typing.Optional[builtins.str]:
        result = self._values.get("file_system_level")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotLogsApplicationLogs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotLogsApplicationLogsAzureBlobStorage",
    jsii_struct_bases=[],
    name_mapping={
        "level": "level",
        "retention_in_days": "retentionInDays",
        "sas_url": "sasUrl",
    },
)
class AppServiceSlotLogsApplicationLogsAzureBlobStorage:
    def __init__(
        self,
        *,
        level: builtins.str,
        retention_in_days: jsii.Number,
        sas_url: builtins.str,
    ) -> None:
        """
        :param level: -
        :param retention_in_days: -
        :param sas_url: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "level": level,
            "retention_in_days": retention_in_days,
            "sas_url": sas_url,
        }

    @builtins.property
    def level(self) -> builtins.str:
        result = self._values.get("level")
        assert result is not None, "Required property 'level' is missing"
        return result

    @builtins.property
    def retention_in_days(self) -> jsii.Number:
        result = self._values.get("retention_in_days")
        assert result is not None, "Required property 'retention_in_days' is missing"
        return result

    @builtins.property
    def sas_url(self) -> builtins.str:
        result = self._values.get("sas_url")
        assert result is not None, "Required property 'sas_url' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotLogsApplicationLogsAzureBlobStorage(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotLogsHttpLogs",
    jsii_struct_bases=[],
    name_mapping={
        "azure_blob_storage": "azureBlobStorage",
        "file_system": "fileSystem",
    },
)
class AppServiceSlotLogsHttpLogs:
    def __init__(
        self,
        *,
        azure_blob_storage: typing.Optional[typing.List["AppServiceSlotLogsHttpLogsAzureBlobStorage"]] = None,
        file_system: typing.Optional[typing.List["AppServiceSlotLogsHttpLogsFileSystem"]] = None,
    ) -> None:
        """
        :param azure_blob_storage: azure_blob_storage block.
        :param file_system: file_system block.
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if azure_blob_storage is not None:
            self._values["azure_blob_storage"] = azure_blob_storage
        if file_system is not None:
            self._values["file_system"] = file_system

    @builtins.property
    def azure_blob_storage(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotLogsHttpLogsAzureBlobStorage"]]:
        """azure_blob_storage block."""
        result = self._values.get("azure_blob_storage")
        return result

    @builtins.property
    def file_system(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotLogsHttpLogsFileSystem"]]:
        """file_system block."""
        result = self._values.get("file_system")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotLogsHttpLogs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotLogsHttpLogsAzureBlobStorage",
    jsii_struct_bases=[],
    name_mapping={"retention_in_days": "retentionInDays", "sas_url": "sasUrl"},
)
class AppServiceSlotLogsHttpLogsAzureBlobStorage:
    def __init__(
        self,
        *,
        retention_in_days: jsii.Number,
        sas_url: builtins.str,
    ) -> None:
        """
        :param retention_in_days: -
        :param sas_url: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "retention_in_days": retention_in_days,
            "sas_url": sas_url,
        }

    @builtins.property
    def retention_in_days(self) -> jsii.Number:
        result = self._values.get("retention_in_days")
        assert result is not None, "Required property 'retention_in_days' is missing"
        return result

    @builtins.property
    def sas_url(self) -> builtins.str:
        result = self._values.get("sas_url")
        assert result is not None, "Required property 'sas_url' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotLogsHttpLogsAzureBlobStorage(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotLogsHttpLogsFileSystem",
    jsii_struct_bases=[],
    name_mapping={
        "retention_in_days": "retentionInDays",
        "retention_in_mb": "retentionInMb",
    },
)
class AppServiceSlotLogsHttpLogsFileSystem:
    def __init__(
        self,
        *,
        retention_in_days: jsii.Number,
        retention_in_mb: jsii.Number,
    ) -> None:
        """
        :param retention_in_days: -
        :param retention_in_mb: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "retention_in_days": retention_in_days,
            "retention_in_mb": retention_in_mb,
        }

    @builtins.property
    def retention_in_days(self) -> jsii.Number:
        result = self._values.get("retention_in_days")
        assert result is not None, "Required property 'retention_in_days' is missing"
        return result

    @builtins.property
    def retention_in_mb(self) -> jsii.Number:
        result = self._values.get("retention_in_mb")
        assert result is not None, "Required property 'retention_in_mb' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotLogsHttpLogsFileSystem(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotSiteConfig",
    jsii_struct_bases=[],
    name_mapping={
        "always_on": "alwaysOn",
        "app_command_line": "appCommandLine",
        "auto_swap_slot_name": "autoSwapSlotName",
        "cors": "cors",
        "default_documents": "defaultDocuments",
        "dotnet_framework_version": "dotnetFrameworkVersion",
        "ftps_state": "ftpsState",
        "health_check_path": "healthCheckPath",
        "http2_enabled": "http2Enabled",
        "ip_restriction": "ipRestriction",
        "java_container": "javaContainer",
        "java_container_version": "javaContainerVersion",
        "java_version": "javaVersion",
        "linux_fx_version": "linuxFxVersion",
        "local_mysql_enabled": "localMysqlEnabled",
        "managed_pipeline_mode": "managedPipelineMode",
        "min_tls_version": "minTlsVersion",
        "php_version": "phpVersion",
        "python_version": "pythonVersion",
        "remote_debugging_enabled": "remoteDebuggingEnabled",
        "remote_debugging_version": "remoteDebuggingVersion",
        "scm_ip_restriction": "scmIpRestriction",
        "scm_type": "scmType",
        "scm_use_main_ip_restriction": "scmUseMainIpRestriction",
        "use32_bit_worker_process": "use32BitWorkerProcess",
        "websockets_enabled": "websocketsEnabled",
        "windows_fx_version": "windowsFxVersion",
    },
)
class AppServiceSlotSiteConfig:
    def __init__(
        self,
        *,
        always_on: typing.Optional[builtins.bool] = None,
        app_command_line: typing.Optional[builtins.str] = None,
        auto_swap_slot_name: typing.Optional[builtins.str] = None,
        cors: typing.Optional[typing.List["AppServiceSlotSiteConfigCors"]] = None,
        default_documents: typing.Optional[typing.List[builtins.str]] = None,
        dotnet_framework_version: typing.Optional[builtins.str] = None,
        ftps_state: typing.Optional[builtins.str] = None,
        health_check_path: typing.Optional[builtins.str] = None,
        http2_enabled: typing.Optional[builtins.bool] = None,
        ip_restriction: typing.Optional[typing.List["AppServiceSlotSiteConfigIpRestriction"]] = None,
        java_container: typing.Optional[builtins.str] = None,
        java_container_version: typing.Optional[builtins.str] = None,
        java_version: typing.Optional[builtins.str] = None,
        linux_fx_version: typing.Optional[builtins.str] = None,
        local_mysql_enabled: typing.Optional[builtins.bool] = None,
        managed_pipeline_mode: typing.Optional[builtins.str] = None,
        min_tls_version: typing.Optional[builtins.str] = None,
        php_version: typing.Optional[builtins.str] = None,
        python_version: typing.Optional[builtins.str] = None,
        remote_debugging_enabled: typing.Optional[builtins.bool] = None,
        remote_debugging_version: typing.Optional[builtins.str] = None,
        scm_ip_restriction: typing.Optional[typing.List["AppServiceSlotSiteConfigScmIpRestriction"]] = None,
        scm_type: typing.Optional[builtins.str] = None,
        scm_use_main_ip_restriction: typing.Optional[builtins.bool] = None,
        use32_bit_worker_process: typing.Optional[builtins.bool] = None,
        websockets_enabled: typing.Optional[builtins.bool] = None,
        windows_fx_version: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param always_on: -
        :param app_command_line: -
        :param auto_swap_slot_name: -
        :param cors: cors block.
        :param default_documents: -
        :param dotnet_framework_version: -
        :param ftps_state: -
        :param health_check_path: -
        :param http2_enabled: -
        :param ip_restriction: -
        :param java_container: -
        :param java_container_version: -
        :param java_version: -
        :param linux_fx_version: -
        :param local_mysql_enabled: -
        :param managed_pipeline_mode: -
        :param min_tls_version: -
        :param php_version: -
        :param python_version: -
        :param remote_debugging_enabled: -
        :param remote_debugging_version: -
        :param scm_ip_restriction: -
        :param scm_type: -
        :param scm_use_main_ip_restriction: -
        :param use32_bit_worker_process: -
        :param websockets_enabled: -
        :param windows_fx_version: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if always_on is not None:
            self._values["always_on"] = always_on
        if app_command_line is not None:
            self._values["app_command_line"] = app_command_line
        if auto_swap_slot_name is not None:
            self._values["auto_swap_slot_name"] = auto_swap_slot_name
        if cors is not None:
            self._values["cors"] = cors
        if default_documents is not None:
            self._values["default_documents"] = default_documents
        if dotnet_framework_version is not None:
            self._values["dotnet_framework_version"] = dotnet_framework_version
        if ftps_state is not None:
            self._values["ftps_state"] = ftps_state
        if health_check_path is not None:
            self._values["health_check_path"] = health_check_path
        if http2_enabled is not None:
            self._values["http2_enabled"] = http2_enabled
        if ip_restriction is not None:
            self._values["ip_restriction"] = ip_restriction
        if java_container is not None:
            self._values["java_container"] = java_container
        if java_container_version is not None:
            self._values["java_container_version"] = java_container_version
        if java_version is not None:
            self._values["java_version"] = java_version
        if linux_fx_version is not None:
            self._values["linux_fx_version"] = linux_fx_version
        if local_mysql_enabled is not None:
            self._values["local_mysql_enabled"] = local_mysql_enabled
        if managed_pipeline_mode is not None:
            self._values["managed_pipeline_mode"] = managed_pipeline_mode
        if min_tls_version is not None:
            self._values["min_tls_version"] = min_tls_version
        if php_version is not None:
            self._values["php_version"] = php_version
        if python_version is not None:
            self._values["python_version"] = python_version
        if remote_debugging_enabled is not None:
            self._values["remote_debugging_enabled"] = remote_debugging_enabled
        if remote_debugging_version is not None:
            self._values["remote_debugging_version"] = remote_debugging_version
        if scm_ip_restriction is not None:
            self._values["scm_ip_restriction"] = scm_ip_restriction
        if scm_type is not None:
            self._values["scm_type"] = scm_type
        if scm_use_main_ip_restriction is not None:
            self._values["scm_use_main_ip_restriction"] = scm_use_main_ip_restriction
        if use32_bit_worker_process is not None:
            self._values["use32_bit_worker_process"] = use32_bit_worker_process
        if websockets_enabled is not None:
            self._values["websockets_enabled"] = websockets_enabled
        if windows_fx_version is not None:
            self._values["windows_fx_version"] = windows_fx_version

    @builtins.property
    def always_on(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("always_on")
        return result

    @builtins.property
    def app_command_line(self) -> typing.Optional[builtins.str]:
        result = self._values.get("app_command_line")
        return result

    @builtins.property
    def auto_swap_slot_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("auto_swap_slot_name")
        return result

    @builtins.property
    def cors(self) -> typing.Optional[typing.List["AppServiceSlotSiteConfigCors"]]:
        """cors block."""
        result = self._values.get("cors")
        return result

    @builtins.property
    def default_documents(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("default_documents")
        return result

    @builtins.property
    def dotnet_framework_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("dotnet_framework_version")
        return result

    @builtins.property
    def ftps_state(self) -> typing.Optional[builtins.str]:
        result = self._values.get("ftps_state")
        return result

    @builtins.property
    def health_check_path(self) -> typing.Optional[builtins.str]:
        result = self._values.get("health_check_path")
        return result

    @builtins.property
    def http2_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("http2_enabled")
        return result

    @builtins.property
    def ip_restriction(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotSiteConfigIpRestriction"]]:
        result = self._values.get("ip_restriction")
        return result

    @builtins.property
    def java_container(self) -> typing.Optional[builtins.str]:
        result = self._values.get("java_container")
        return result

    @builtins.property
    def java_container_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("java_container_version")
        return result

    @builtins.property
    def java_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("java_version")
        return result

    @builtins.property
    def linux_fx_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("linux_fx_version")
        return result

    @builtins.property
    def local_mysql_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("local_mysql_enabled")
        return result

    @builtins.property
    def managed_pipeline_mode(self) -> typing.Optional[builtins.str]:
        result = self._values.get("managed_pipeline_mode")
        return result

    @builtins.property
    def min_tls_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("min_tls_version")
        return result

    @builtins.property
    def php_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("php_version")
        return result

    @builtins.property
    def python_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("python_version")
        return result

    @builtins.property
    def remote_debugging_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("remote_debugging_enabled")
        return result

    @builtins.property
    def remote_debugging_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("remote_debugging_version")
        return result

    @builtins.property
    def scm_ip_restriction(
        self,
    ) -> typing.Optional[typing.List["AppServiceSlotSiteConfigScmIpRestriction"]]:
        result = self._values.get("scm_ip_restriction")
        return result

    @builtins.property
    def scm_type(self) -> typing.Optional[builtins.str]:
        result = self._values.get("scm_type")
        return result

    @builtins.property
    def scm_use_main_ip_restriction(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("scm_use_main_ip_restriction")
        return result

    @builtins.property
    def use32_bit_worker_process(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("use32_bit_worker_process")
        return result

    @builtins.property
    def websockets_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("websockets_enabled")
        return result

    @builtins.property
    def windows_fx_version(self) -> typing.Optional[builtins.str]:
        result = self._values.get("windows_fx_version")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotSiteConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotSiteConfigCors",
    jsii_struct_bases=[],
    name_mapping={
        "allowed_origins": "allowedOrigins",
        "support_credentials": "supportCredentials",
    },
)
class AppServiceSlotSiteConfigCors:
    def __init__(
        self,
        *,
        allowed_origins: typing.List[builtins.str],
        support_credentials: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param allowed_origins: -
        :param support_credentials: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "allowed_origins": allowed_origins,
        }
        if support_credentials is not None:
            self._values["support_credentials"] = support_credentials

    @builtins.property
    def allowed_origins(self) -> typing.List[builtins.str]:
        result = self._values.get("allowed_origins")
        assert result is not None, "Required property 'allowed_origins' is missing"
        return result

    @builtins.property
    def support_credentials(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("support_credentials")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotSiteConfigCors(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotSiteConfigIpRestriction",
    jsii_struct_bases=[],
    name_mapping={
        "action": "action",
        "ip_address": "ipAddress",
        "name": "name",
        "priority": "priority",
        "subnet_id": "subnetId",
        "virtual_network_subnet_id": "virtualNetworkSubnetId",
    },
)
class AppServiceSlotSiteConfigIpRestriction:
    def __init__(
        self,
        *,
        action: typing.Optional[builtins.str] = None,
        ip_address: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        priority: typing.Optional[jsii.Number] = None,
        subnet_id: typing.Optional[builtins.str] = None,
        virtual_network_subnet_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param action: -
        :param ip_address: -
        :param name: -
        :param priority: -
        :param subnet_id: -
        :param virtual_network_subnet_id: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if action is not None:
            self._values["action"] = action
        if ip_address is not None:
            self._values["ip_address"] = ip_address
        if name is not None:
            self._values["name"] = name
        if priority is not None:
            self._values["priority"] = priority
        if subnet_id is not None:
            self._values["subnet_id"] = subnet_id
        if virtual_network_subnet_id is not None:
            self._values["virtual_network_subnet_id"] = virtual_network_subnet_id

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        result = self._values.get("action")
        return result

    @builtins.property
    def ip_address(self) -> typing.Optional[builtins.str]:
        result = self._values.get("ip_address")
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("name")
        return result

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("priority")
        return result

    @builtins.property
    def subnet_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("subnet_id")
        return result

    @builtins.property
    def virtual_network_subnet_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("virtual_network_subnet_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotSiteConfigIpRestriction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotSiteConfigScmIpRestriction",
    jsii_struct_bases=[],
    name_mapping={
        "action": "action",
        "ip_address": "ipAddress",
        "name": "name",
        "priority": "priority",
        "subnet_id": "subnetId",
        "virtual_network_subnet_id": "virtualNetworkSubnetId",
    },
)
class AppServiceSlotSiteConfigScmIpRestriction:
    def __init__(
        self,
        *,
        action: typing.Optional[builtins.str] = None,
        ip_address: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        priority: typing.Optional[jsii.Number] = None,
        subnet_id: typing.Optional[builtins.str] = None,
        virtual_network_subnet_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param action: -
        :param ip_address: -
        :param name: -
        :param priority: -
        :param subnet_id: -
        :param virtual_network_subnet_id: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if action is not None:
            self._values["action"] = action
        if ip_address is not None:
            self._values["ip_address"] = ip_address
        if name is not None:
            self._values["name"] = name
        if priority is not None:
            self._values["priority"] = priority
        if subnet_id is not None:
            self._values["subnet_id"] = subnet_id
        if virtual_network_subnet_id is not None:
            self._values["virtual_network_subnet_id"] = virtual_network_subnet_id

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        result = self._values.get("action")
        return result

    @builtins.property
    def ip_address(self) -> typing.Optional[builtins.str]:
        result = self._values.get("ip_address")
        return result

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("name")
        return result

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        result = self._values.get("priority")
        return result

    @builtins.property
    def subnet_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("subnet_id")
        return result

    @builtins.property
    def virtual_network_subnet_id(self) -> typing.Optional[builtins.str]:
        result = self._values.get("virtual_network_subnet_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotSiteConfigScmIpRestriction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceSlotSiteCredential(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceSlotSiteCredential",
):
    def __init__(
        self,
        terraform_resource: cdktf.ITerraformResource,
        terraform_attribute: builtins.str,
        index: builtins.str,
    ) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        :stability: experimental
        """
        jsii.create(AppServiceSlotSiteCredential, self, [terraform_resource, terraform_attribute, index])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="password")
    def password(self) -> builtins.str:
        return jsii.get(self, "password")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="username")
    def username(self) -> builtins.str:
        return jsii.get(self, "username")


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceSlotTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceSlotVirtualNetworkSwiftConnection(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceSlotVirtualNetworkSwiftConnection",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        app_service_id: builtins.str,
        slot_name: builtins.str,
        subnet_id: builtins.str,
        timeouts: typing.Optional["AppServiceSlotVirtualNetworkSwiftConnectionTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param app_service_id: -
        :param slot_name: -
        :param subnet_id: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceSlotVirtualNetworkSwiftConnectionConfig(
            app_service_id=app_service_id,
            slot_name=slot_name,
            subnet_id=subnet_id,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceSlotVirtualNetworkSwiftConnection, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceIdInput")
    def app_service_id_input(self) -> builtins.str:
        return jsii.get(self, "appServiceIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="slotNameInput")
    def slot_name_input(self) -> builtins.str:
        return jsii.get(self, "slotNameInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetIdInput")
    def subnet_id_input(self) -> builtins.str:
        return jsii.get(self, "subnetIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["AppServiceSlotVirtualNetworkSwiftConnectionTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceId")
    def app_service_id(self) -> builtins.str:
        return jsii.get(self, "appServiceId")

    @app_service_id.setter # type: ignore
    def app_service_id(self, value: builtins.str) -> None:
        jsii.set(self, "appServiceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="slotName")
    def slot_name(self) -> builtins.str:
        return jsii.get(self, "slotName")

    @slot_name.setter # type: ignore
    def slot_name(self, value: builtins.str) -> None:
        jsii.set(self, "slotName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceSlotVirtualNetworkSwiftConnectionTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(
        self,
        value: "AppServiceSlotVirtualNetworkSwiftConnectionTimeouts",
    ) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotVirtualNetworkSwiftConnectionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "app_service_id": "appServiceId",
        "slot_name": "slotName",
        "subnet_id": "subnetId",
        "timeouts": "timeouts",
    },
)
class AppServiceSlotVirtualNetworkSwiftConnectionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        app_service_id: builtins.str,
        slot_name: builtins.str,
        subnet_id: builtins.str,
        timeouts: typing.Optional["AppServiceSlotVirtualNetworkSwiftConnectionTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param app_service_id: -
        :param slot_name: -
        :param subnet_id: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceSlotVirtualNetworkSwiftConnectionTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "app_service_id": app_service_id,
            "slot_name": slot_name,
            "subnet_id": subnet_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def app_service_id(self) -> builtins.str:
        result = self._values.get("app_service_id")
        assert result is not None, "Required property 'app_service_id' is missing"
        return result

    @builtins.property
    def slot_name(self) -> builtins.str:
        result = self._values.get("slot_name")
        assert result is not None, "Required property 'slot_name' is missing"
        return result

    @builtins.property
    def subnet_id(self) -> builtins.str:
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    @builtins.property
    def timeouts(
        self,
    ) -> typing.Optional["AppServiceSlotVirtualNetworkSwiftConnectionTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotVirtualNetworkSwiftConnectionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSlotVirtualNetworkSwiftConnectionTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceSlotVirtualNetworkSwiftConnectionTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSlotVirtualNetworkSwiftConnectionTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSourceControl",
    jsii_struct_bases=[],
    name_mapping={
        "branch": "branch",
        "manual_integration": "manualIntegration",
        "repo_url": "repoUrl",
        "rollback_enabled": "rollbackEnabled",
        "use_mercurial": "useMercurial",
    },
)
class AppServiceSourceControl:
    def __init__(
        self,
        *,
        branch: typing.Optional[builtins.str] = None,
        manual_integration: typing.Optional[builtins.bool] = None,
        repo_url: typing.Optional[builtins.str] = None,
        rollback_enabled: typing.Optional[builtins.bool] = None,
        use_mercurial: typing.Optional[builtins.bool] = None,
    ) -> None:
        """
        :param branch: -
        :param manual_integration: -
        :param repo_url: -
        :param rollback_enabled: -
        :param use_mercurial: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if branch is not None:
            self._values["branch"] = branch
        if manual_integration is not None:
            self._values["manual_integration"] = manual_integration
        if repo_url is not None:
            self._values["repo_url"] = repo_url
        if rollback_enabled is not None:
            self._values["rollback_enabled"] = rollback_enabled
        if use_mercurial is not None:
            self._values["use_mercurial"] = use_mercurial

    @builtins.property
    def branch(self) -> typing.Optional[builtins.str]:
        result = self._values.get("branch")
        return result

    @builtins.property
    def manual_integration(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("manual_integration")
        return result

    @builtins.property
    def repo_url(self) -> typing.Optional[builtins.str]:
        result = self._values.get("repo_url")
        return result

    @builtins.property
    def rollback_enabled(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("rollback_enabled")
        return result

    @builtins.property
    def use_mercurial(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("use_mercurial")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSourceControl(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceSourceControlToken(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceSourceControlToken",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        token: builtins.str,
        type: builtins.str,
        timeouts: typing.Optional["AppServiceSourceControlTokenTimeouts"] = None,
        token_secret: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param token: -
        :param type: -
        :param timeouts: timeouts block.
        :param token_secret: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceSourceControlTokenConfig(
            token=token,
            type=type,
            timeouts=timeouts,
            token_secret=token_secret,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceSourceControlToken, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetTokenSecret")
    def reset_token_secret(self) -> None:
        return jsii.invoke(self, "resetTokenSecret", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tokenInput")
    def token_input(self) -> builtins.str:
        return jsii.get(self, "tokenInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> builtins.str:
        return jsii.get(self, "typeInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(self) -> typing.Optional["AppServiceSourceControlTokenTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tokenSecretInput")
    def token_secret_input(self) -> typing.Optional[builtins.str]:
        return jsii.get(self, "tokenSecretInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceSourceControlTokenTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(self, value: "AppServiceSourceControlTokenTimeouts") -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="token")
    def token(self) -> builtins.str:
        return jsii.get(self, "token")

    @token.setter # type: ignore
    def token(self, value: builtins.str) -> None:
        jsii.set(self, "token", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tokenSecret")
    def token_secret(self) -> builtins.str:
        return jsii.get(self, "tokenSecret")

    @token_secret.setter # type: ignore
    def token_secret(self, value: builtins.str) -> None:
        jsii.set(self, "tokenSecret", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return jsii.get(self, "type")

    @type.setter # type: ignore
    def type(self, value: builtins.str) -> None:
        jsii.set(self, "type", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceSourceControlTokenConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "token": "token",
        "type": "type",
        "timeouts": "timeouts",
        "token_secret": "tokenSecret",
    },
)
class AppServiceSourceControlTokenConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        token: builtins.str,
        type: builtins.str,
        timeouts: typing.Optional["AppServiceSourceControlTokenTimeouts"] = None,
        token_secret: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param token: -
        :param type: -
        :param timeouts: timeouts block.
        :param token_secret: -
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceSourceControlTokenTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "token": token,
            "type": type,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if token_secret is not None:
            self._values["token_secret"] = token_secret

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def token(self) -> builtins.str:
        result = self._values.get("token")
        assert result is not None, "Required property 'token' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def timeouts(self) -> typing.Optional["AppServiceSourceControlTokenTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    @builtins.property
    def token_secret(self) -> typing.Optional[builtins.str]:
        result = self._values.get("token_secret")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSourceControlTokenConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceSourceControlTokenTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceSourceControlTokenTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceSourceControlTokenTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceStorageAccount",
    jsii_struct_bases=[],
    name_mapping={
        "access_key": "accessKey",
        "account_name": "accountName",
        "name": "name",
        "share_name": "shareName",
        "type": "type",
        "mount_path": "mountPath",
    },
)
class AppServiceStorageAccount:
    def __init__(
        self,
        *,
        access_key: builtins.str,
        account_name: builtins.str,
        name: builtins.str,
        share_name: builtins.str,
        type: builtins.str,
        mount_path: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param access_key: -
        :param account_name: -
        :param name: -
        :param share_name: -
        :param type: -
        :param mount_path: -
        """
        self._values: typing.Dict[str, typing.Any] = {
            "access_key": access_key,
            "account_name": account_name,
            "name": name,
            "share_name": share_name,
            "type": type,
        }
        if mount_path is not None:
            self._values["mount_path"] = mount_path

    @builtins.property
    def access_key(self) -> builtins.str:
        result = self._values.get("access_key")
        assert result is not None, "Required property 'access_key' is missing"
        return result

    @builtins.property
    def account_name(self) -> builtins.str:
        result = self._values.get("account_name")
        assert result is not None, "Required property 'account_name' is missing"
        return result

    @builtins.property
    def name(self) -> builtins.str:
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return result

    @builtins.property
    def share_name(self) -> builtins.str:
        result = self._values.get("share_name")
        assert result is not None, "Required property 'share_name' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def mount_path(self) -> typing.Optional[builtins.str]:
        result = self._values.get("mount_path")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceStorageAccount(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppServiceVirtualNetworkSwiftConnection(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.AppServiceVirtualNetworkSwiftConnection",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        app_service_id: builtins.str,
        subnet_id: builtins.str,
        timeouts: typing.Optional["AppServiceVirtualNetworkSwiftConnectionTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param app_service_id: -
        :param subnet_id: -
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppServiceVirtualNetworkSwiftConnectionConfig(
            app_service_id=app_service_id,
            subnet_id=subnet_id,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppServiceVirtualNetworkSwiftConnection, self, [scope, id, config])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceIdInput")
    def app_service_id_input(self) -> builtins.str:
        return jsii.get(self, "appServiceIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetIdInput")
    def subnet_id_input(self) -> builtins.str:
        return jsii.get(self, "subnetIdInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional["AppServiceVirtualNetworkSwiftConnectionTimeouts"]:
        return jsii.get(self, "timeoutsInput")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="appServiceId")
    def app_service_id(self) -> builtins.str:
        return jsii.get(self, "appServiceId")

    @app_service_id.setter # type: ignore
    def app_service_id(self, value: builtins.str) -> None:
        jsii.set(self, "appServiceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> "AppServiceVirtualNetworkSwiftConnectionTimeouts":
        return jsii.get(self, "timeouts")

    @timeouts.setter # type: ignore
    def timeouts(
        self,
        value: "AppServiceVirtualNetworkSwiftConnectionTimeouts",
    ) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="azurerm.AppServiceVirtualNetworkSwiftConnectionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "app_service_id": "appServiceId",
        "subnet_id": "subnetId",
        "timeouts": "timeouts",
    },
)
class AppServiceVirtualNetworkSwiftConnectionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        app_service_id: builtins.str,
        subnet_id: builtins.str,
        timeouts: typing.Optional["AppServiceVirtualNetworkSwiftConnectionTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param app_service_id: -
        :param subnet_id: -
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AppServiceVirtualNetworkSwiftConnectionTimeouts(**timeouts)
        self._values: typing.Dict[str, typing.Any] = {
            "app_service_id": app_service_id,
            "subnet_id": subnet_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        :stability: experimental
        """
        result = self._values.get("count")
        return result

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        """
        :stability: experimental
        """
        result = self._values.get("depends_on")
        return result

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        :stability: experimental
        """
        result = self._values.get("lifecycle")
        return result

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        :stability: experimental
        """
        result = self._values.get("provider")
        return result

    @builtins.property
    def app_service_id(self) -> builtins.str:
        result = self._values.get("app_service_id")
        assert result is not None, "Required property 'app_service_id' is missing"
        return result

    @builtins.property
    def subnet_id(self) -> builtins.str:
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    @builtins.property
    def timeouts(
        self,
    ) -> typing.Optional["AppServiceVirtualNetworkSwiftConnectionTimeouts"]:
        """timeouts block."""
        result = self._values.get("timeouts")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceVirtualNetworkSwiftConnectionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="azurerm.AppServiceVirtualNetworkSwiftConnectionTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class AppServiceVirtualNetworkSwiftConnectionTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param create: -
        :param delete: -
        :param read: -
        :param update: -
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        result = self._values.get("create")
        return result

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        result = self._values.get("delete")
        return result

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        result = self._values.get("read")
        return result

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        result = self._values.get("update")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppServiceVirtualNetworkSwiftConnectionTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApplicationGateway(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="azurerm.ApplicationGateway",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        backend_address_pool: typing.List["ApplicationGatewayBackendAddressPool"],
        backend_http_settings: typing.List["ApplicationGatewayBackendHttpSettings"],
        frontend_ip_configuration: typing.List["ApplicationGatewayFrontendIpConfiguration"],
        frontend_port: typing.List["ApplicationGatewayFrontendPort"],
        gateway_ip_configuration: typing.List["ApplicationGatewayGatewayIpConfiguration"],
        http_listener: typing.List["ApplicationGatewayHttpListener"],
        location: builtins.str,
        name: builtins.str,
        request_routing_rule: typing.List["ApplicationGatewayRequestRoutingRule"],
        resource_group_name: builtins.str,
        sku: typing.List["ApplicationGatewaySku"],
        authentication_certificate: typing.Optional[typing.List["ApplicationGatewayAuthenticationCertificate"]] = None,
        autoscale_configuration: typing.Optional[typing.List["ApplicationGatewayAutoscaleConfiguration"]] = None,
        custom_error_configuration: typing.Optional[typing.List["ApplicationGatewayCustomErrorConfiguration"]] = None,
        enable_http2: typing.Optional[builtins.bool] = None,
        firewall_policy_id: typing.Optional[builtins.str] = None,
        identity: typing.Optional[typing.List["ApplicationGatewayIdentity"]] = None,
        probe: typing.Optional[typing.List["ApplicationGatewayProbe"]] = None,
        redirect_configuration: typing.Optional[typing.List["ApplicationGatewayRedirectConfiguration"]] = None,
        rewrite_rule_set: typing.Optional[typing.List["ApplicationGatewayRewriteRuleSet"]] = None,
        ssl_certificate: typing.Optional[typing.List["ApplicationGatewaySslCertificate"]] = None,
        ssl_policy: typing.Optional[typing.List["ApplicationGatewaySslPolicy"]] = None,
        tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        timeouts: typing.Optional["ApplicationGatewayTimeouts"] = None,
        trusted_root_certificate: typing.Optional[typing.List["ApplicationGatewayTrustedRootCertificate"]] = None,
        url_path_map: typing.Optional[typing.List["ApplicationGatewayUrlPathMap"]] = None,
        waf_configuration: typing.Optional[typing.List["ApplicationGatewayWafConfiguration"]] = None,
        zones: typing.Optional[typing.List[builtins.str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.ITerraformDependable]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param backend_address_pool: backend_address_pool block.
        :param backend_http_settings: backend_http_settings block.
        :param frontend_ip_configuration: frontend_ip_configuration block.
        :param frontend_port: frontend_port block.
        :param gateway_ip_configuration: gateway_ip_configuration block.
        :param http_listener: http_listener block.
        :param location: -
        :param name: -
        :param request_routing_rule: request_routing_rule block.
        :param resource_group_name: -
        :param sku: sku block.
        :param authentication_certificate: authentication_certificate block.
        :param autoscale_configuration: autoscale_configuration block.
        :param custom_error_configuration: custom_error_configuration block.
        :param enable_http2: -
        :param firewall_policy_id: -
        :param identity: identity block.
        :param probe: probe block.
        :param redirect_configuration: redirect_configuration block.
        :param rewrite_rule_set: rewrite_rule_set block.
        :param ssl_certificate: ssl_certificate block.
        :param ssl_policy: ssl_policy block.
        :param tags: -
        :param timeouts: timeouts block.
        :param trusted_root_certificate: trusted_root_certificate block.
        :param url_path_map: url_path_map block.
        :param waf_configuration: waf_configuration block.
        :param zones: -
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApplicationGatewayConfig(
            backend_address_pool=backend_address_pool,
            backend_http_settings=backend_http_settings,
            frontend_ip_configuration=frontend_ip_configuration,
            frontend_port=frontend_port,
            gateway_ip_configuration=gateway_ip_configuration,
            http_listener=http_listener,
            location=location,
            name=name,
            request_routing_rule=request_routing_rule,
            resource_group_name=resource_group_name,
            sku=sku,
            authentication_certificate=authentication_certificate,
            autoscale_configuration=autoscale_configuration,
            custom_error_configuration=custom_error_configuration,
            enable_http2=enable_http2,
            firewall_policy_id=firewall_policy_id,
            identity=identity,
            probe=probe,
            redirect_configuration=redirect_configuration,
            rewrite_rule_set=rewrite_rule_set,
            ssl_certificate=ssl_certificate,
            ssl_policy=ssl_policy,
            tags=tags,
            timeouts=timeouts,
            trusted_root_certificate=trusted_root_certificate,
            url_path_map=url_path_map,
            waf_configuration=waf_configuration,
            zones=zones,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApplicationGateway, self, [scope, id, config])

    @jsii.member(jsii_name="resetAuthenticationCertificate")
    def reset_authentication_certificate(self) -> None:
        return jsii.invoke(self, "resetAuthenticationCertificate", [])

    @jsii.member(jsii_name="resetAutoscaleConfiguration")
    def reset_autoscale_configuration(self) -> None:
        return jsii.invoke(self, "resetAutoscaleConfiguration", [])

    @jsii.member(jsii_name="resetCustomErrorConfiguration")
    def reset_custom_error_configuration(self) -> None:
        return jsii.invoke(self, "resetCustomErrorConfiguration", [])

    @jsii.member(jsii_name="resetEnableHttp2")
    def reset_enable_http2(self) -> None:
        return jsii.invoke(self, "resetEnableHttp2", [])

    @jsii.member(jsii_name="resetFirewallPolicyId")
    def reset_firewall_policy_id(self) -> None:
        return jsii.invoke(self, "resetFirewallPolicyId", [])

    @jsii.member(jsii_name="resetIdentity")
    def reset_identity(self) -> None:
        return jsii.invoke(self, "resetIdentity", [])

    @jsii.member(jsii_name="resetProbe")
    def reset_probe(self) -> None:
        return jsii.invoke(self, "resetProbe", [])

    @jsii.member(jsii_name="resetRedirectConfiguration")
    def reset_redirect_configuration(self) -> None:
        return jsii.invoke(self, "resetRedirectConfiguration", [])

    @jsii.member(jsii_name="resetRewriteRuleSet")
    def reset_rewrite_rule_set(self) -> None:
        return jsii.invoke(self, "resetRewriteRuleSet", [])

    @jsii.member(jsii_name="resetSslCertificate")
    def reset_ssl_certificate(self) -> None:
        return jsii.invoke(self, "resetSslCertificate", [])

    @jsii.member(jsii_name="resetSslPolicy")
    def reset_ssl_policy(self) -> None:
        return jsii.invoke(self, "resetSslPolicy", [])

    @jsii.member(jsii_name="resetTags")
    def reset_tags(self) -> None:
        return jsii.invoke(self, "resetTags", [])

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return jsii.invoke(self, "resetTimeouts", [])

    @jsii.member(jsii_name="resetTrustedRootCertificate")
    def reset_trusted_root_certificate(self) -> None:
        return jsii.invoke(self, "resetTrustedRootCertificate", [])

    @jsii.member(jsii_name="resetUrlPathMap")
    def reset_url_path_map(self) -