# Generated by Django 4.2.11 on 2024-03-29 11:19

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import viewflow.workflow.fields
import viewflow.workflow.token


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Process',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('flow_class', viewflow.workflow.fields.FlowReferenceField(max_length=250, verbose_name='Flow')),
                ('status', models.CharField(choices=[('CANCELED', 'Canceled'), ('DONE', 'Done'), ('NEW', 'New')], default='NEW', max_length=50, verbose_name='Status')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Created')),
                ('finished', models.DateTimeField(blank=True, null=True, verbose_name='Finished')),
                ('data', models.JSONField(blank=True, default=dict)),
                ('artifact_object_id', models.PositiveIntegerField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Process',
                'verbose_name_plural': 'Process list',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('flow_task', viewflow.workflow.fields.TaskReferenceField(max_length=255, verbose_name='Task')),
                ('flow_task_type', models.CharField(max_length=50, verbose_name='Type')),
                ('status', models.CharField(choices=[('ASSIGNED', 'Assigned'), ('CANCELED', 'Canceled'), ('DONE', 'Done'), ('ERROR', 'Error'), ('NEW', 'New'), ('REVIVED', 'Revived'), ('SCHEDULED', 'Scheduled'), ('STARTED', 'Started')], db_index=True, default='NEW', max_length=50, verbose_name='Status')),
                ('created', models.DateTimeField(db_index=True, default=django.utils.timezone.now, verbose_name='Created')),
                ('assigned', models.DateTimeField(blank=True, null=True, verbose_name='Assigned')),
                ('started', models.DateTimeField(blank=True, null=True, verbose_name='Started')),
                ('finished', models.DateTimeField(blank=True, null=True, verbose_name='Finished')),
                ('token', viewflow.workflow.fields.TokenField(default=viewflow.workflow.token.Token('start'), max_length=150, verbose_name='Token')),
                ('external_task_id', models.CharField(blank=True, db_index=True, max_length=50, null=True, verbose_name='External Task ID')),
                ('owner', models.PositiveIntegerField(blank=True, null=True, verbose_name='Сотрудник')),
                ('owner_permission', models.CharField(blank=True, max_length=255, null=True, verbose_name='Permission')),
                ('owner_permission_obj_pk', models.CharField(blank=True, max_length=255, null=True)),
                ('data', models.JSONField(blank=True, default=dict)),
                ('artifact_object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('previous', models.ManyToManyField(related_name='leading', to='viewflow.task', verbose_name='Previous')),
                ('process', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='viewflow.process', verbose_name='Process')),
            ],
            options={
                'verbose_name': 'Task',
                'verbose_name_plural': 'Tasks',
                'ordering': ['-created'],
            },
        ),
        migrations.AddField(
            model_name='process',
            name='parent_task',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='viewflow.task'),
        ),
    ]
