# Generated by Django 2.1.8 on 2019-05-14 19:20

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("filer", "0011_auto_20190418_0137"),
        ("cms", "0022_auto_20180620_1551"),
        ("auth", "0009_alter_user_last_name_max_length"),
        ("courses", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="PageRole",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "role",
                    models.CharField(
                        choices=[("ADMIN", "Admin")],
                        help_text="A role describes all the permissions that should be granted to the user group.",
                        max_length=20,
                        verbose_name="role",
                    ),
                ),
                (
                    "folder",
                    models.OneToOneField(
                        blank=True,
                        editable=False,
                        help_text="Filer folder that this role controls.",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="role",
                        to="filer.Folder",
                        verbose_name="filer folder",
                    ),
                ),
                (
                    "group",
                    models.OneToOneField(
                        blank=True,
                        editable=False,
                        help_text="User group that this role controls.",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="role",
                        to="auth.Group",
                        verbose_name="group",
                    ),
                ),
                (
                    "page",
                    models.ForeignKey(
                        help_text="Page to which this role grants permissions.",
                        limit_choices_to={"publisher_is_draft": True},
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="roles",
                        to="cms.Page",
                        verbose_name="page",
                    ),
                ),
            ],
            options={"verbose_name": "page role", "db_table": "richie_page_role"},
        ),
        migrations.AlterField(
            model_name="personpluginmodel",
            name="page",
            field=models.ForeignKey(
                limit_choices_to={"person__isnull": False, "publisher_is_draft": True},
                on_delete=django.db.models.deletion.CASCADE,
                related_name="person_plugins",
                to="cms.Page",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="pagerole", unique_together={("page", "role")}
        ),
    ]
