# Generated by Django 3.1.13 on 2021-08-11 10:34

from django.db import migrations
from django.utils.text import slugify


def normalize_course_code(apps, schema_editor):
    """
    Normalize existing course codes with the format expected as of today for all codes.
    """
    Course = apps.get_model("courses", "Course")

    for course in Course.objects.only("id", "code").iterator():
        Course.objects.filter(id=course.id).update(
            code=slugify(course.code, allow_unicode=True).upper()
            if course.code
            else None
        )


class Migration(migrations.Migration):
    dependencies = [("courses", "0030_auto_20210225_1435")]

    operations = [
        migrations.RunPython(normalize_course_code, migrations.RunPython.noop)
    ]
