import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [auditmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsauditmanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Auditmanager extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [auditmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsauditmanager.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to associate an evidence folder with an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_AssociateAssessmentReportEvidenceFolder.html
     */
    toAssociateAssessmentReportEvidenceFolder(): this;
    /**
     * Grants permission to associate a list of evidence to an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html
     */
    toBatchAssociateAssessmentReportEvidence(): this;
    /**
     * Grants permission to create delegations for an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchCreateDelegationByAssessment.html
     */
    toBatchCreateDelegationByAssessment(): this;
    /**
     * Grants permission to delete delegations for an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchDeleteDelegationByAssessment.html
     */
    toBatchDeleteDelegationByAssessment(): this;
    /**
     * Grants permission to disassociate a list of evidence from an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchDisassociateAssessmentReportEvidence.html
     */
    toBatchDisassociateAssessmentReportEvidence(): this;
    /**
     * Grants permission to import a list of evidence to an assessment control in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchImportEvidenceToAssessmentControl.html
     */
    toBatchImportEvidenceToAssessmentControl(): this;
    /**
     * Grants permission to create an assessment to be used with AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html
     */
    toCreateAssessment(): this;
    /**
     * Grants permission to create a framework for use in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessmentFramework.html
     */
    toCreateAssessmentFramework(): this;
    /**
     * Grants permission to create an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessmentReport.html
     */
    toCreateAssessmentReport(): this;
    /**
     * Grants permission to create a control to be used in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateControl.html
     */
    toCreateControl(): this;
    /**
     * Grants permission to delete an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html
     */
    toDeleteAssessment(): this;
    /**
     * Grants permission to delete an assessment framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html
     */
    toDeleteAssessmentFramework(): this;
    /**
     * Grants permission to delete a share request for a custom framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html
     */
    toDeleteAssessmentFrameworkShare(): this;
    /**
     * Grants permission to delete an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html
     */
    toDeleteAssessmentReport(): this;
    /**
     * Grants permission to delete a control in AWS Audit Manager
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html
     */
    toDeleteControl(): this;
    /**
     * Grants permission to deregister an account in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ DeregisterAccount.html
     */
    toDeregisterAccount(): this;
    /**
     * Grants permission to deregister the delegated administrator account for AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterOrganizationAdminAccount.html
     */
    toDeregisterOrganizationAdminAccount(): this;
    /**
     * Grants permission to disassociate an evidence folder from an assessment report in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DisassociateAssessmentReportEvidenceFolder.html
     */
    toDisassociateAssessmentReportEvidenceFolder(): this;
    /**
     * Grants permission to get the status of an account in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAccountStatus.html
     */
    toGetAccountStatus(): this;
    /**
     * Grants permission to get an assessment created in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessment.html
     */
    toGetAssessment(): this;
    /**
     * Grants permission to get an assessment framework in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessmentFramework.html
     */
    toGetAssessmentFramework(): this;
    /**
     * Grants permission to get the URL for an assessment report in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessmentReportUrl.html
     */
    toGetAssessmentReportUrl(): this;
    /**
     * Grants permission to get changelogs for an assessment in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetChangeLogs.html
     */
    toGetChangeLogs(): this;
    /**
     * Grants permission to get a control in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetControl.html
     */
    toGetControl(): this;
    /**
     * Grants permission to get all delegations in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetDelegations.html
     */
    toGetDelegations(): this;
    /**
     * Grants permission to get evidence from AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidence.html
     */
    toGetEvidence(): this;
    /**
     * Grants permission to get all the evidence from an evidence folder in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceByEvidenceFolder.html
     */
    toGetEvidenceByEvidenceFolder(): this;
    /**
     * Grants permission to get the evidence folder from AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFolder.html
     */
    toGetEvidenceFolder(): this;
    /**
     * Grants permission to get the evidence folders from an assessment in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFoldersByAssessment.html
     */
    toGetEvidenceFoldersByAssessment(): this;
    /**
     * Grants permission to get the evidence folders from an assessment control in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFoldersByAssessmentControl.html
     */
    toGetEvidenceFoldersByAssessmentControl(): this;
    /**
     * Grants permission to get analytics data for all active assessments
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetInsights.html
     */
    toGetInsights(): this;
    /**
     * Grants permission to get analytics data for a specific active assessment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetInsightsByAssessment.html
     */
    toGetInsightsByAssessment(): this;
    /**
     * Grants permission to get the delegated administrator account in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetOrganizationAdminAccount.html
     */
    toGetOrganizationAdminAccount(): this;
    /**
     * Grants permission to get the services in scope for an assessment in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetServicesInScope.html
     */
    toGetServicesInScope(): this;
    /**
     * Grants permission to get all settings configured in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetSettings.html
     */
    toGetSettings(): this;
    /**
     * Grants permission to list analytics data for controls in a specific control domain and active assessment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentControlInsightsByControlDomain.html
     */
    toListAssessmentControlInsightsByControlDomain(): this;
    /**
     * Grants permission to list all sent or received share requests for custom frameworks in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentFrameworkShareRequests.html
     */
    toListAssessmentFrameworkShareRequests(): this;
    /**
     * Grants permission to list all assessment frameworks in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentFrameworks.html
     */
    toListAssessmentFrameworks(): this;
    /**
     * Grants permission to list all assessment reports in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentReports.html
     */
    toListAssessmentReports(): this;
    /**
     * Grants permission to list all assessments in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessments.html
     */
    toListAssessments(): this;
    /**
     * Grants permission to list analytics data for control domains across all active assessments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlDomainInsights.html
     */
    toListControlDomainInsights(): this;
    /**
     * Grants permission to list analytics data for control domains in a specific active assessment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlDomainInsightsByAssessment.html
     */
    toListControlDomainInsightsByAssessment(): this;
    /**
     * Grants permission to list analytics data for controls in a specific control domain across all active assessments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlInsightsByControlDomain.html
     */
    toListControlInsightsByControlDomain(): this;
    /**
     * Grants permission to list all controls in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControls.html
     */
    toListControls(): this;
    /**
     * Grants permission to list all the data source keywords in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListKeywordsForDataSource.html
     */
    toListKeywordsForDataSource(): this;
    /**
     * Grants permission to list all notifications in AWS Audit Manager
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListNotifications.html
     */
    toListNotifications(): this;
    /**
     * Grants permission to list tags for an AWS Audit Manager resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to register an account in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html
     */
    toRegisterAccount(): this;
    /**
     * Grants permission to register an account within the organization as the delegated administrator for AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterOrganizationAdminAccount.html
     */
    toRegisterOrganizationAdminAccount(): this;
    /**
     * Grants permission to create a share request for a custom framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_StartAssessmentFrameworkShare.html
     */
    toStartAssessmentFrameworkShare(): this;
    /**
     * Grants permission to tag an AWS Audit Manager resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag an AWS Audit Manager resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessment.html
     */
    toUpdateAssessment(): this;
    /**
     * Grants permission to update an assessment control in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentControl.html
     */
    toUpdateAssessmentControl(): this;
    /**
     * Grants permission to update the status of an assessment control set in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentControlSetStatus.html
     */
    toUpdateAssessmentControlSetStatus(): this;
    /**
     * Grants permission to update an assessment framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentFramework.html
     */
    toUpdateAssessmentFramework(): this;
    /**
     * Grants permission to update a share request for a custom framework in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentFrameworkShare.html
     */
    toUpdateAssessmentFrameworkShare(): this;
    /**
     * Grants permission to update the status of an assessment in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentStatus.html
     */
    toUpdateAssessmentStatus(): this;
    /**
     * Grants permission to update a control in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateControl.html
     */
    toUpdateControl(): this;
    /**
     * Grants permission to update settings in AWS Audit Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateSettings.html
     */
    toUpdateSettings(): this;
    /**
     * Grants permission to validate the integrity of an assessment report in AWS Audit Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ValidateAssessmentReportIntegrity.html
     */
    toValidateAssessmentReportIntegrity(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type assessment to the statement
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_Assessment.html
     *
     * @param assessmentId - Identifier for the assessmentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAssessment(assessmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type assessmentFramework to the statement
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_AssessmentFramework.html
     *
     * @param assessmentFrameworkId - Identifier for the assessmentFrameworkId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAssessmentFramework(assessmentFrameworkId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type assessmentControlSet to the statement
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_AssessmentControlSet.html
     *
     * @param assessmentId - Identifier for the assessmentId.
     * @param controlSetId - Identifier for the controlSetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAssessmentControlSet(assessmentId: string, controlSetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type control to the statement
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_Control.html
     *
     * @param controlId - Identifier for the controlId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onControl(controlId: string, account?: string, region?: string, partition?: string): this;
}
