"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySync = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [identity-sync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitysynchronizationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class IdentitySync extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [identity-sync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitysynchronizationservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'identity-sync';
        this.accessLevelList = {
            Write: [
                'CreateSyncFilter',
                'CreateSyncProfile',
                'CreateSyncTarget',
                'DeleteSyncFilter',
                'DeleteSyncProfile',
                'DeleteSyncTarget',
                'StartSync',
                'StopSync',
                'UpdateSyncTarget'
            ],
            Read: [
                'GetSyncProfile',
                'GetSyncTarget'
            ],
            List: [
                'ListSyncFilters'
            ]
        };
    }
    /**
     * Grants permission to create a sync filter on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncFilter() {
        return this.to('CreateSyncFilter');
    }
    /**
     * Grants permission to create a sync profile for the source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncProfile() {
        return this.to('CreateSyncProfile');
    }
    /**
     * Grants permission to create a sync target for the source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncTarget() {
        return this.to('CreateSyncTarget');
    }
    /**
     * Grants permission to delete a sync filter on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncFilter() {
        return this.to('DeleteSyncFilter');
    }
    /**
     * Grants permission to delete a sync profile on the source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncProfile() {
        return this.to('DeleteSyncProfile');
    }
    /**
     * Grants permission to delete a sync target on the source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncTarget() {
        return this.to('DeleteSyncTarget');
    }
    /**
     * Grants permission to retrieve a sync profile using sync profile name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toGetSyncProfile() {
        return this.to('GetSyncProfile');
    }
    /**
     * Grants permission to retrieve a sync target on the sync profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toGetSyncTarget() {
        return this.to('GetSyncTarget');
    }
    /**
     * Grants permission to list the sync filters on the sync profile
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toListSyncFilters() {
        return this.to('ListSyncFilters');
    }
    /**
     * Grants permission to start a synchronization process or to restart a synchronization that was previously stopped
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toStartSync() {
        return this.to('StartSync');
    }
    /**
     * Grants permission to stop any planned synchronizations in the synchronization schedule from starting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toStopSync() {
        return this.to('StopSync');
    }
    /**
     * Grants permission to update a sync target on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toUpdateSyncTarget() {
        return this.to('UpdateSyncTarget');
    }
    /**
     * Adds a resource of type SyncProfileResource to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     *
     * @param syncProfileName - Identifier for the syncProfileName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSyncProfileResource(syncProfileName, account, region, partition) {
        return this.on(`^arn:${partition || 'aws'}:identity-sync:${region || '*'}:${account || '*'}:profile/${syncProfileName}`);
    }
    /**
     * Adds a resource of type SyncTargetResource to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     *
     * @param syncProfileName - Identifier for the syncProfileName.
     * @param syncTargetName - Identifier for the syncTargetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSyncTargetResource(syncProfileName, syncTargetName, account, region, partition) {
        return this.on(`^arn:${partition || 'aws'}:identity-sync:${region || '*'}:${account || '*'}:target/${syncProfileName}/${syncTargetName}`);
    }
}
exports.IdentitySync = IdentitySync;
_a = JSII_RTTI_SYMBOL_1;
IdentitySync[_a] = { fqn: "iam-floyd.IdentitySync", version: "0.350.0" };
//# sourceMappingURL=data:application/json;base64,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