"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iotthingsgraph = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iotthingsgraph](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotthingsgraph.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iotthingsgraph extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iotthingsgraph](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotthingsgraph.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iotthingsgraph';
        this.accessLevelList = {
            Write: [
                'AssociateEntityToThing',
                'CreateFlowTemplate',
                'CreateSystemInstance',
                'CreateSystemTemplate',
                'DeleteFlowTemplate',
                'DeleteNamespace',
                'DeleteSystemInstance',
                'DeleteSystemTemplate',
                'DeploySystemInstance',
                'DeprecateFlowTemplate',
                'DeprecateSystemTemplate',
                'DissociateEntityFromThing',
                'UndeploySystemInstance',
                'UpdateFlowTemplate',
                'UpdateSystemTemplate',
                'UploadEntityDefinitions'
            ],
            Read: [
                'DescribeNamespace',
                'GetEntities',
                'GetFlowTemplate',
                'GetFlowTemplateRevisions',
                'GetNamespaceDeletionStatus',
                'GetSystemInstance',
                'GetSystemTemplate',
                'GetSystemTemplateRevisions',
                'GetUploadStatus',
                'SearchEntities',
                'SearchFlowExecutions',
                'SearchFlowTemplates',
                'SearchSystemInstances',
                'SearchSystemTemplates',
                'SearchThings'
            ],
            List: [
                'ListFlowExecutionMessages',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Associates a device with a concrete thing that is in the user's registry. A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     * - iot:DescribeThingGroup
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_AssociateEntityToThing.html
     */
    toAssociateEntityToThing() {
        return this.to('AssociateEntityToThing');
    }
    /**
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateFlowTemplate.html
     */
    toCreateFlowTemplate() {
        return this.to('CreateFlowTemplate');
    }
    /**
     * Creates an instance of a system with specified configurations and Things
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateSystemInstance.html
     */
    toCreateSystemInstance() {
        return this.to('CreateSystemInstance');
    }
    /**
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateSystemTemplate.html
     */
    toCreateSystemTemplate() {
        return this.to('CreateSystemTemplate');
    }
    /**
     * Deletes a workflow. Any new system or system instance that contains this workflow will fail to update or deploy. Existing system instances that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deploying the system instance)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteFlowTemplate.html
     */
    toDeleteFlowTemplate() {
        return this.to('DeleteFlowTemplate');
    }
    /**
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows in the namespace before performing this action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteNamespace.html
     */
    toDeleteNamespace() {
        return this.to('DeleteNamespace');
    }
    /**
     * Deletes a system instance. Only instances that have never been deployed, or that have been undeployed from the target can be deleted. Users can create a new system instance that has the same ID as a deleted system instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteSystemInstance.html
     */
    toDeleteSystemInstance() {
        return this.to('DeleteSystemInstance');
    }
    /**
     * Deletes a system. New system instances can't contain the system after its deletion. Existing system instances that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteSystemTemplate.html
     */
    toDeleteSystemTemplate() {
        return this.to('DeleteSystemTemplate');
    }
    /**
     * Deploys the system instance to the target specified in CreateSystemInstance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeploySystemInstance.html
     */
    toDeploySystemInstance() {
        return this.to('DeploySystemInstance');
    }
    /**
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing system instances that use the flow will continue to run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeprecateFlowTemplate.html
     */
    toDeprecateFlowTemplate() {
        return this.to('DeprecateFlowTemplate');
    }
    /**
     * Deprecates the specified system
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeprecateSystemTemplate.html
     */
    toDeprecateSystemTemplate() {
        return this.to('DeprecateSystemTemplate');
    }
    /**
     * Gets the latest version of the user's namespace and the public version that it is tracking
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DescribeNamespace.html
     */
    toDescribeNamespace() {
        return this.to('DescribeNamespace');
    }
    /**
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     * - iot:DescribeThingGroup
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DissociateEntityFromThing.html
     */
    toDissociateEntityFromThing() {
        return this.to('DissociateEntityFromThing');
    }
    /**
     * Gets descriptions of the specified entities. Uses the latest version of the user's namespace by default
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetEntities.html
     */
    toGetEntities() {
        return this.to('GetEntities');
    }
    /**
     * Gets the latest version of the DefinitionDocument and FlowTemplateSummary for the specified workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetFlowTemplate.html
     */
    toGetFlowTemplate() {
        return this.to('GetFlowTemplate');
    }
    /**
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetFlowTemplateRevisions.html
     */
    toGetFlowTemplateRevisions() {
        return this.to('GetFlowTemplateRevisions');
    }
    /**
     * Gets the status of a namespace deletion task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetNamespaceDeletionStatus.html
     */
    toGetNamespaceDeletionStatus() {
        return this.to('GetNamespaceDeletionStatus');
    }
    /**
     * Gets a system instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemInstance.html
     */
    toGetSystemInstance() {
        return this.to('GetSystemInstance');
    }
    /**
     * Gets a system
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemTemplate.html
     */
    toGetSystemTemplate() {
        return this.to('GetSystemTemplate');
    }
    /**
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemTemplateRevisions.html
     */
    toGetSystemTemplateRevisions() {
        return this.to('GetSystemTemplateRevisions');
    }
    /**
     * Gets the status of the specified upload
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetUploadStatus.html
     */
    toGetUploadStatus() {
        return this.to('GetUploadStatus');
    }
    /**
     * Lists details of a single workflow execution
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_ListFlowExecutionMessages.html
     */
    toListFlowExecutionMessages() {
        return this.to('ListFlowExecutionMessages');
    }
    /**
     * Lists all tags for a given resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchEntities.html
     */
    toSearchEntities() {
        return this.to('SearchEntities');
    }
    /**
     * Searches for workflow executions of a system instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchFlowExecutions.html
     */
    toSearchFlowExecutions() {
        return this.to('SearchFlowExecutions');
    }
    /**
     * Searches for summary information about workflows
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchFlowTemplates.html
     */
    toSearchFlowTemplates() {
        return this.to('SearchFlowTemplates');
    }
    /**
     * Searches for system instances in the user's account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchSystemInstances.html
     */
    toSearchSystemInstances() {
        return this.to('SearchSystemInstances');
    }
    /**
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchSystemTemplates.html
     */
    toSearchSystemTemplates() {
        return this.to('SearchSystemTemplates');
    }
    /**
     * Searches for things associated with the specified entity. You can search by both device and device model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchThings.html
     */
    toSearchThings() {
        return this.to('SearchThings');
    }
    /**
     * Tag a specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Removes the system instance and associated triggers from the target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UndeploySystemInstance.html
     */
    toUndeploySystemInstance() {
        return this.to('UndeploySystemInstance');
    }
    /**
     * Untag a specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. The workflow can contain only entities in the specified namespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UpdateFlowTemplate.html
     */
    toUpdateFlowTemplate() {
        return this.to('UpdateFlowTemplate');
    }
    /**
     * Updates the specified system. You don't need to run this action after updating a workflow. Any system instance that uses the system will see the changes in the system when it is redeployed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UpdateSystemTemplate.html
     */
    toUpdateSystemTemplate() {
        return this.to('UpdateSystemTemplate');
    }
    /**
     * Asynchronously uploads one or more entity definitions to the user's namespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UploadEntityDefinitions.html
     */
    toUploadEntityDefinitions() {
        return this.to('UploadEntityDefinitions');
    }
    /**
     * Adds a resource of type Workflow to the statement
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-workflow.html
     *
     * @param namespacePath - Identifier for the namespacePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onWorkflow(namespacePath, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotthingsgraph:${region || '*'}:${account || '*'}:Workflow/${namespacePath}`);
    }
    /**
     * Adds a resource of type System to the statement
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-system.html
     *
     * @param namespacePath - Identifier for the namespacePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSystem(namespacePath, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotthingsgraph:${region || '*'}:${account || '*'}:System/${namespacePath}`);
    }
    /**
     * Adds a resource of type SystemInstance to the statement
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-sdc-deployconfig.html
     *
     * @param namespacePath - Identifier for the namespacePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSystemInstance(namespacePath, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotthingsgraph:${region || '*'}:${account || '*'}:Deployment/${namespacePath}`);
    }
}
exports.Iotthingsgraph = Iotthingsgraph;
_a = JSII_RTTI_SYMBOL_1;
Iotthingsgraph[_a] = { fqn: "iam-floyd.Iotthingsgraph", version: "0.350.0" };
//# sourceMappingURL=data:application/json;base64,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