"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsmIncidents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [ssm-incidents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SsmIncidents extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ssm-incidents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanager.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'ssm-incidents';
        this.accessLevelList = {
            Write: [
                'CreateReplicationSet',
                'CreateResponsePlan',
                'CreateTimelineEvent',
                'DeleteIncidentRecord',
                'DeleteReplicationSet',
                'DeleteResponsePlan',
                'DeleteTimelineEvent',
                'StartIncident',
                'UpdateDeletionProtection',
                'UpdateIncidentRecord',
                'UpdateRelatedItems',
                'UpdateReplicationSet',
                'UpdateResponsePlan',
                'UpdateTimelineEvent'
            ],
            'Permissions management': [
                'DeleteResourcePolicy',
                'PutResourcePolicy'
            ],
            Read: [
                'GetIncidentRecord',
                'GetReplicationSet',
                'GetResourcePolicies',
                'GetResponsePlan',
                'GetTimelineEvent',
                'ListTagsForResource'
            ],
            List: [
                'ListIncidentRecords',
                'ListRelatedItems',
                'ListReplicationSets',
                'ListResponsePlans',
                'ListTimelineEvents'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create a replication set
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html
     */
    toCreateReplicationSet() {
        return this.to('CreateReplicationSet');
    }
    /**
     * Grants permission to create a response plan
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html
     */
    toCreateResponsePlan() {
        return this.to('CreateResponsePlan');
    }
    /**
     * Grants permission to create a timeline event for an incident record
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateTimelineEvent.html
     */
    toCreateTimelineEvent() {
        return this.to('CreateTimelineEvent');
    }
    /**
     * Grants permission to delete an incident record
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteIncidentRecord.html
     */
    toDeleteIncidentRecord() {
        return this.to('DeleteIncidentRecord');
    }
    /**
     * Grants permission to delete a replication set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteReplicationSet.html
     */
    toDeleteReplicationSet() {
        return this.to('DeleteReplicationSet');
    }
    /**
     * Grants permission to delete resource policy from a response plan
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * Grants permission to delete a response plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteResponsePlan.html
     */
    toDeleteResponsePlan() {
        return this.to('DeleteResponsePlan');
    }
    /**
     * Grants permission to delete a timeline event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteTimelineEvent.html
     */
    toDeleteTimelineEvent() {
        return this.to('DeleteTimelineEvent');
    }
    /**
     * Grants permission to view the contents of an incident record
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetIncidentRecord.html
     */
    toGetIncidentRecord() {
        return this.to('GetIncidentRecord');
    }
    /**
     * Grants permission to view the replication set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetReplicationSet.html
     */
    toGetReplicationSet() {
        return this.to('GetReplicationSet');
    }
    /**
     * Grants permission to view resource policies of a response plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetResourcePolicies.html
     */
    toGetResourcePolicies() {
        return this.to('GetResourcePolicies');
    }
    /**
     * Grants permission to view the contents of a specified response plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetResponsePlan.html
     */
    toGetResponsePlan() {
        return this.to('GetResponsePlan');
    }
    /**
     * Grants permission to view a timeline event
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetTimelineEvent.html
     */
    toGetTimelineEvent() {
        return this.to('GetTimelineEvent');
    }
    /**
     * Grants permission to list the contents of all incident records
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListIncidentRecords.html
     */
    toListIncidentRecords() {
        return this.to('ListIncidentRecords');
    }
    /**
     * Grants permission to list related items of an incident records
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListRelatedItems.html
     */
    toListRelatedItems() {
        return this.to('ListRelatedItems');
    }
    /**
     * Grants permission to list all replication sets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListReplicationSets.html
     */
    toListReplicationSets() {
        return this.to('ListReplicationSets');
    }
    /**
     * Grants permission to list all response plans
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListResponsePlans.html
     */
    toListResponsePlans() {
        return this.to('ListResponsePlans');
    }
    /**
     * Grants permission to view a list of resource tags for a specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list all timeline events for an incident record
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListTimelineEvents.html
     */
    toListTimelineEvents() {
        return this.to('ListTimelineEvents');
    }
    /**
     * Grants permission to put resource policy on a response plan
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy() {
        return this.to('PutResourcePolicy');
    }
    /**
     * Grants permission to start a new incident using a response plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_StartIncident.html
     */
    toStartIncident() {
        return this.to('StartIncident');
    }
    /**
     * Grants permission to add tags to a response plan
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a response plan
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update replication set deletion protection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateDeletionProtection.html
     */
    toUpdateDeletionProtection() {
        return this.to('UpdateDeletionProtection');
    }
    /**
     * Grants permission to update the contents of an incident record
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateIncidentRecord.html
     */
    toUpdateIncidentRecord() {
        return this.to('UpdateIncidentRecord');
    }
    /**
     * Grants permission to update related items of an incident record
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateRelatedItems.html
     */
    toUpdateRelatedItems() {
        return this.to('UpdateRelatedItems');
    }
    /**
     * Grants permission to update a replication set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateReplicationSet.html
     */
    toUpdateReplicationSet() {
        return this.to('UpdateReplicationSet');
    }
    /**
     * Grants permission to update the contents of a response plan
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateResponsePlan.html
     */
    toUpdateResponsePlan() {
        return this.to('UpdateResponsePlan');
    }
    /**
     * Grants permission to update a timeline event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateTimelineEvent.html
     */
    toUpdateTimelineEvent() {
        return this.to('UpdateTimelineEvent');
    }
    /**
     * Adds a resource of type response-plan to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/response-plans.html
     *
     * @param responsePlan - Identifier for the responsePlan.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onResponsePlan(responsePlan, account, partition) {
        return this.on(`arn:${partition || 'aws'}:ssm-incidents::${account || '*'}:response-plan/${responsePlan}`);
    }
    /**
     * Adds a resource of type incident-record to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-record.html
     *
     * @param responsePlan - Identifier for the responsePlan.
     * @param incidentRecord - Identifier for the incidentRecord.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onIncidentRecord(responsePlan, incidentRecord, account, partition) {
        return this.on(`arn:${partition || 'aws'}:ssm-incidents::${account || '*'}:incident-record/${responsePlan}/${incidentRecord}`);
    }
    /**
     * Adds a resource of type replication-set to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/replication-set.html
     *
     * @param replicationSet - Identifier for the replicationSet.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onReplicationSet(replicationSet, account, partition) {
        return this.on(`arn:${partition || 'aws'}:ssm-incidents::${account || '*'}:replication-set/${replicationSet}`);
    }
}
exports.SsmIncidents = SsmIncidents;
_a = JSII_RTTI_SYMBOL_1;
SsmIncidents[_a] = { fqn: "iam-floyd.SsmIncidents", version: "0.350.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3lzdGVtc21hbmFnZXJpbmNpZGVudG1hbmFnZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzeXN0ZW1zbWFuYWdlcmluY2lkZW50bWFuYWdlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNDQUE0QztBQUU1Qzs7OztHQUlHO0FBQ0gsTUFBYSxZQUFhLFNBQVEsd0JBQWU7SUFHL0M7Ozs7T0FJRztJQUNILFlBQVksR0FBWTtRQUN0QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFSTixrQkFBYSxHQUFHLGVBQWUsQ0FBQztRQW1WN0Isb0JBQWUsR0FBb0I7WUFDM0MsS0FBSyxFQUFFO2dCQUNMLHNCQUFzQjtnQkFDdEIsb0JBQW9CO2dCQUNwQixxQkFBcUI7Z0JBQ3JCLHNCQUFzQjtnQkFDdEIsc0JBQXNCO2dCQUN0QixvQkFBb0I7Z0JBQ3BCLHFCQUFxQjtnQkFDckIsZUFBZTtnQkFDZiwwQkFBMEI7Z0JBQzFCLHNCQUFzQjtnQkFDdEIsb0JBQW9CO2dCQUNwQixzQkFBc0I7Z0JBQ3RCLG9CQUFvQjtnQkFDcEIscUJBQXFCO2FBQ3RCO1lBQ0Qsd0JBQXdCLEVBQUU7Z0JBQ3hCLHNCQUFzQjtnQkFDdEIsbUJBQW1CO2FBQ3BCO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLG1CQUFtQjtnQkFDbkIsbUJBQW1CO2dCQUNuQixxQkFBcUI7Z0JBQ3JCLGlCQUFpQjtnQkFDakIsa0JBQWtCO2dCQUNsQixxQkFBcUI7YUFDdEI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0oscUJBQXFCO2dCQUNyQixrQkFBa0I7Z0JBQ2xCLHFCQUFxQjtnQkFDckIsbUJBQW1CO2dCQUNuQixvQkFBb0I7YUFDckI7WUFDRCxPQUFPLEVBQUU7Z0JBQ1AsYUFBYTtnQkFDYixlQUFlO2FBQ2hCO1NBQ0YsQ0FBQztJQWxYRixDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQTRDRDs7Ozs7Ozs7T0FRRztJQUNJLGNBQWMsQ0FBQyxZQUFvQixFQUFFLE9BQWdCLEVBQUUsU0FBa0I7UUFDOUUsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sbUJBQW9CLE9BQU8sSUFBSSxHQUFJLGtCQUFtQixZQUFhLEVBQUUsQ0FBQyxDQUFDO0lBQ25ILENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxnQkFBZ0IsQ0FBQyxZQUFvQixFQUFFLGNBQXNCLEVBQUUsT0FBZ0IsRUFBRSxTQUFrQjtRQUN4RyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksS0FBTSxtQkFBb0IsT0FBTyxJQUFJLEdBQUksb0JBQXFCLFlBQWEsSUFBSyxjQUFlLEVBQUUsQ0FBQyxDQUFDO0lBQ3pJLENBQUM7SUFFRDs7Ozs7Ozs7T0FRRztJQUNJLGdCQUFnQixDQUFDLGNBQXNCLEVBQUUsT0FBZ0IsRUFBRSxTQUFrQjtRQUNsRixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksS0FBTSxtQkFBb0IsT0FBTyxJQUFJLEdBQUksb0JBQXFCLGNBQWUsRUFBRSxDQUFDLENBQUM7SUFDdkgsQ0FBQzs7QUFwYUgsb0NBcWFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi9zaGFyZWQnO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbc3NtLWluY2lkZW50c10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYXdzc3lzdGVtc21hbmFnZXJpbmNpZGVudG1hbmFnZXIuaHRtbCkuXG4gKlxuICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBTc21JbmNpZGVudHMgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdzc20taW5jaWRlbnRzJztcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtzc20taW5jaWRlbnRzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3NzeXN0ZW1zbWFuYWdlcmluY2lkZW50bWFuYWdlci5odG1sKS5cbiAgICpcbiAgICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gICAqL1xuICBjb25zdHJ1Y3RvcihzaWQ/OiBzdHJpbmcpIHtcbiAgICBzdXBlcihzaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIHJlcGxpY2F0aW9uIHNldFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGlhbTpDcmVhdGVTZXJ2aWNlTGlua2VkUm9sZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVSZXBsaWNhdGlvblNldC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVSZXBsaWNhdGlvblNldCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlUmVwbGljYXRpb25TZXQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSByZXNwb25zZSBwbGFuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gaWFtOlBhc3NSb2xlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pbmNpZGVudC1tYW5hZ2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZVJlc3BvbnNlUGxhbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVSZXNwb25zZVBsYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVJlc3BvbnNlUGxhbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIHRpbWVsaW5lIGV2ZW50IGZvciBhbiBpbmNpZGVudCByZWNvcmRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVUaW1lbGluZUV2ZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVRpbWVsaW5lRXZlbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVRpbWVsaW5lRXZlbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYW4gaW5jaWRlbnQgcmVjb3JkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlSW5jaWRlbnRSZWNvcmQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlSW5jaWRlbnRSZWNvcmQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUluY2lkZW50UmVjb3JkJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgcmVwbGljYXRpb24gc2V0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlUmVwbGljYXRpb25TZXQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlUmVwbGljYXRpb25TZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVJlcGxpY2F0aW9uU2V0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIHJlc291cmNlIHBvbGljeSBmcm9tIGEgcmVzcG9uc2UgcGxhblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFBlcm1pc3Npb25zIG1hbmFnZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlUmVzb3VyY2VQb2xpY3kuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlUmVzb3VyY2VQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVJlc291cmNlUG9saWN5Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgcmVzcG9uc2UgcGxhblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pbmNpZGVudC1tYW5hZ2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZVJlc3BvbnNlUGxhbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVSZXNwb25zZVBsYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVJlc3BvbnNlUGxhbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIHRpbWVsaW5lIGV2ZW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlVGltZWxpbmVFdmVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVUaW1lbGluZUV2ZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVUaW1lbGluZUV2ZW50Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdmlldyB0aGUgY29udGVudHMgb2YgYW4gaW5jaWRlbnQgcmVjb3JkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRJbmNpZGVudFJlY29yZC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRJbmNpZGVudFJlY29yZCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0SW5jaWRlbnRSZWNvcmQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB2aWV3IHRoZSByZXBsaWNhdGlvbiBzZXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pbmNpZGVudC1tYW5hZ2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFJlcGxpY2F0aW9uU2V0Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlcGxpY2F0aW9uU2V0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRSZXBsaWNhdGlvblNldCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgcmVzb3VyY2UgcG9saWNpZXMgb2YgYSByZXNwb25zZSBwbGFuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRSZXNvdXJjZVBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlc291cmNlUG9saWNpZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFJlc291cmNlUG9saWNpZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB2aWV3IHRoZSBjb250ZW50cyBvZiBhIHNwZWNpZmllZCByZXNwb25zZSBwbGFuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRSZXNwb25zZVBsYW4uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0UmVzcG9uc2VQbGFuKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRSZXNwb25zZVBsYW4nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB2aWV3IGEgdGltZWxpbmUgZXZlbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pbmNpZGVudC1tYW5hZ2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFRpbWVsaW5lRXZlbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0VGltZWxpbmVFdmVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0VGltZWxpbmVFdmVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIGNvbnRlbnRzIG9mIGFsbCBpbmNpZGVudCByZWNvcmRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0SW5jaWRlbnRSZWNvcmRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RJbmNpZGVudFJlY29yZHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RJbmNpZGVudFJlY29yZHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHJlbGF0ZWQgaXRlbXMgb2YgYW4gaW5jaWRlbnQgcmVjb3Jkc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFJlbGF0ZWRJdGVtcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UmVsYXRlZEl0ZW1zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmVsYXRlZEl0ZW1zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBhbGwgcmVwbGljYXRpb24gc2V0c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFJlcGxpY2F0aW9uU2V0cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UmVwbGljYXRpb25TZXRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmVwbGljYXRpb25TZXRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBhbGwgcmVzcG9uc2UgcGxhbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pbmNpZGVudC1tYW5hZ2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RSZXNwb25zZVBsYW5zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RSZXNwb25zZVBsYW5zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmVzcG9uc2VQbGFucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgYSBsaXN0IG9mIHJlc291cmNlIHRhZ3MgZm9yIGEgc3BlY2lmaWVkIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0VGFnc0ZvclJlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUYWdzRm9yUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RUYWdzRm9yUmVzb3VyY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGFsbCB0aW1lbGluZSBldmVudHMgZm9yIGFuIGluY2lkZW50IHJlY29yZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFRpbWVsaW5lRXZlbnRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUaW1lbGluZUV2ZW50cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFRpbWVsaW5lRXZlbnRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcHV0IHJlc291cmNlIHBvbGljeSBvbiBhIHJlc3BvbnNlIHBsYW5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBQZXJtaXNzaW9ucyBtYW5hZ2VtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pbmNpZGVudC1tYW5hZ2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1B1dFJlc291cmNlUG9saWN5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1B1dFJlc291cmNlUG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdQdXRSZXNvdXJjZVBvbGljeScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHN0YXJ0IGEgbmV3IGluY2lkZW50IHVzaW5nIGEgcmVzcG9uc2UgcGxhblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pbmNpZGVudC1tYW5hZ2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1N0YXJ0SW5jaWRlbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RhcnRJbmNpZGVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3RhcnRJbmNpZGVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGFkZCB0YWdzIHRvIGEgcmVzcG9uc2UgcGxhblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVGFnUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVGFnUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1RhZ1Jlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmVtb3ZlIHRhZ3MgZnJvbSBhIHJlc3BvbnNlIHBsYW5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBUYWdnaW5nXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pbmNpZGVudC1tYW5hZ2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VudGFnUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVW50YWdSZXNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVW50YWdSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSByZXBsaWNhdGlvbiBzZXQgZGVsZXRpb24gcHJvdGVjdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pbmNpZGVudC1tYW5hZ2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZURlbGV0aW9uUHJvdGVjdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVEZWxldGlvblByb3RlY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZURlbGV0aW9uUHJvdGVjdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSB0aGUgY29udGVudHMgb2YgYW4gaW5jaWRlbnQgcmVjb3JkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlSW5jaWRlbnRSZWNvcmQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlSW5jaWRlbnRSZWNvcmQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUluY2lkZW50UmVjb3JkJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIHJlbGF0ZWQgaXRlbXMgb2YgYW4gaW5jaWRlbnQgcmVjb3JkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlUmVsYXRlZEl0ZW1zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVJlbGF0ZWRJdGVtcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlUmVsYXRlZEl0ZW1zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgcmVwbGljYXRpb24gc2V0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlUmVwbGljYXRpb25TZXQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlUmVwbGljYXRpb25TZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVJlcGxpY2F0aW9uU2V0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIHRoZSBjb250ZW50cyBvZiBhIHJlc3BvbnNlIHBsYW5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBpYW06UGFzc1JvbGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2luY2lkZW50LW1hbmFnZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlUmVzcG9uc2VQbGFuLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVJlc3BvbnNlUGxhbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlUmVzcG9uc2VQbGFuJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgdGltZWxpbmUgZXZlbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVUaW1lbGluZUV2ZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVRpbWVsaW5lRXZlbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVRpbWVsaW5lRXZlbnQnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0NyZWF0ZVJlcGxpY2F0aW9uU2V0JyxcbiAgICAgICdDcmVhdGVSZXNwb25zZVBsYW4nLFxuICAgICAgJ0NyZWF0ZVRpbWVsaW5lRXZlbnQnLFxuICAgICAgJ0RlbGV0ZUluY2lkZW50UmVjb3JkJyxcbiAgICAgICdEZWxldGVSZXBsaWNhdGlvblNldCcsXG4gICAgICAnRGVsZXRlUmVzcG9uc2VQbGFuJyxcbiAgICAgICdEZWxldGVUaW1lbGluZUV2ZW50JyxcbiAgICAgICdTdGFydEluY2lkZW50JyxcbiAgICAgICdVcGRhdGVEZWxldGlvblByb3RlY3Rpb24nLFxuICAgICAgJ1VwZGF0ZUluY2lkZW50UmVjb3JkJyxcbiAgICAgICdVcGRhdGVSZWxhdGVkSXRlbXMnLFxuICAgICAgJ1VwZGF0ZVJlcGxpY2F0aW9uU2V0JyxcbiAgICAgICdVcGRhdGVSZXNwb25zZVBsYW4nLFxuICAgICAgJ1VwZGF0ZVRpbWVsaW5lRXZlbnQnXG4gICAgXSxcbiAgICAnUGVybWlzc2lvbnMgbWFuYWdlbWVudCc6IFtcbiAgICAgICdEZWxldGVSZXNvdXJjZVBvbGljeScsXG4gICAgICAnUHV0UmVzb3VyY2VQb2xpY3knXG4gICAgXSxcbiAgICBSZWFkOiBbXG4gICAgICAnR2V0SW5jaWRlbnRSZWNvcmQnLFxuICAgICAgJ0dldFJlcGxpY2F0aW9uU2V0JyxcbiAgICAgICdHZXRSZXNvdXJjZVBvbGljaWVzJyxcbiAgICAgICdHZXRSZXNwb25zZVBsYW4nLFxuICAgICAgJ0dldFRpbWVsaW5lRXZlbnQnLFxuICAgICAgJ0xpc3RUYWdzRm9yUmVzb3VyY2UnXG4gICAgXSxcbiAgICBMaXN0OiBbXG4gICAgICAnTGlzdEluY2lkZW50UmVjb3JkcycsXG4gICAgICAnTGlzdFJlbGF0ZWRJdGVtcycsXG4gICAgICAnTGlzdFJlcGxpY2F0aW9uU2V0cycsXG4gICAgICAnTGlzdFJlc3BvbnNlUGxhbnMnLFxuICAgICAgJ0xpc3RUaW1lbGluZUV2ZW50cydcbiAgICBdLFxuICAgIFRhZ2dpbmc6IFtcbiAgICAgICdUYWdSZXNvdXJjZScsXG4gICAgICAnVW50YWdSZXNvdXJjZSdcbiAgICBdXG4gIH07XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIHJlc3BvbnNlLXBsYW4gdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvdXNlcmd1aWRlL3Jlc3BvbnNlLXBsYW5zLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHJlc3BvbnNlUGxhbiAtIElkZW50aWZpZXIgZm9yIHRoZSByZXNwb25zZVBsYW4uXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICovXG4gIHB1YmxpYyBvblJlc3BvbnNlUGxhbihyZXNwb25zZVBsYW46IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgJ2F3cycgfTpzc20taW5jaWRlbnRzOjokeyBhY2NvdW50IHx8ICcqJyB9OnJlc3BvbnNlLXBsYW4vJHsgcmVzcG9uc2VQbGFuIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBpbmNpZGVudC1yZWNvcmQgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvdXNlcmd1aWRlL2luY2lkZW50LXJlY29yZC5odG1sXG4gICAqXG4gICAqIEBwYXJhbSByZXNwb25zZVBsYW4gLSBJZGVudGlmaWVyIGZvciB0aGUgcmVzcG9uc2VQbGFuLlxuICAgKiBAcGFyYW0gaW5jaWRlbnRSZWNvcmQgLSBJZGVudGlmaWVyIGZvciB0aGUgaW5jaWRlbnRSZWNvcmQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICovXG4gIHB1YmxpYyBvbkluY2lkZW50UmVjb3JkKHJlc3BvbnNlUGxhbjogc3RyaW5nLCBpbmNpZGVudFJlY29yZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCAnYXdzJyB9OnNzbS1pbmNpZGVudHM6OiR7IGFjY291bnQgfHwgJyonIH06aW5jaWRlbnQtcmVjb3JkLyR7IHJlc3BvbnNlUGxhbiB9LyR7IGluY2lkZW50UmVjb3JkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSByZXBsaWNhdGlvbi1zZXQgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW5jaWRlbnQtbWFuYWdlci9sYXRlc3QvdXNlcmd1aWRlL3JlcGxpY2F0aW9uLXNldC5odG1sXG4gICAqXG4gICAqIEBwYXJhbSByZXBsaWNhdGlvblNldCAtIElkZW50aWZpZXIgZm9yIHRoZSByZXBsaWNhdGlvblNldC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKi9cbiAgcHVibGljIG9uUmVwbGljYXRpb25TZXQocmVwbGljYXRpb25TZXQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgJ2F3cycgfTpzc20taW5jaWRlbnRzOjokeyBhY2NvdW50IHx8ICcqJyB9OnJlcGxpY2F0aW9uLXNldC8keyByZXBsaWNhdGlvblNldCB9YCk7XG4gIH1cbn1cbiJdfQ==