"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workdocs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [workdocs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkdocs.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Workdocs extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [workdocs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkdocs.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'workdocs';
        this.accessLevelList = {
            Write: [
                'AbortDocumentVersionUpload',
                'ActivateUser',
                'AddResourcePermissions',
                'AddUserToGroup',
                'CreateComment',
                'CreateCustomMetadata',
                'CreateFolder',
                'CreateInstance',
                'CreateLabels',
                'CreateNotificationSubscription',
                'CreateUser',
                'DeactivateUser',
                'DeleteComment',
                'DeleteCustomMetadata',
                'DeleteDocument',
                'DeleteFolder',
                'DeleteFolderContents',
                'DeleteInstance',
                'DeleteLabels',
                'DeleteNotificationSubscription',
                'DeleteUser',
                'DeregisterDirectory',
                'InitiateDocumentVersionUpload',
                'RegisterDirectory',
                'RemoveAllResourcePermissions',
                'RemoveResourcePermission',
                'UpdateDocument',
                'UpdateDocumentVersion',
                'UpdateFolder',
                'UpdateInstanceAlias',
                'UpdateUser'
            ],
            Read: [
                'CheckAlias',
                'DownloadDocumentVersion',
                'GetCurrentUser',
                'GetDocument',
                'GetDocumentPath',
                'GetDocumentVersion',
                'GetFolder',
                'GetFolderPath',
                'GetGroup',
                'GetResources'
            ],
            List: [
                'DescribeActivities',
                'DescribeAvailableDirectories',
                'DescribeComments',
                'DescribeDocumentVersions',
                'DescribeFolderContents',
                'DescribeGroups',
                'DescribeInstances',
                'DescribeNotificationSubscriptions',
                'DescribeResourcePermissions',
                'DescribeRootFolders',
                'DescribeUsers'
            ]
        };
    }
    /**
     * Grants permission to abort the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AbortDocumentVersionUpload.html
     */
    toAbortDocumentVersionUpload() {
        return this.to('AbortDocumentVersionUpload');
    }
    /**
     * Grants permission to activate the specified user. Only active users can access Amazon WorkDocs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_ActivateUser.html
     */
    toActivateUser() {
        return this.to('ActivateUser');
    }
    /**
     * Grants permission to create a set of permissions for the specified folder or document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AddResourcePermissions.html
     */
    toAddResourcePermissions() {
        return this.to('AddResourcePermissions');
    }
    /**
     * Grants permission to add a user to a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage_set_admin.html
     */
    toAddUserToGroup() {
        return this.to('AddUserToGroup');
    }
    /**
     * Grants permission to check an alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/cloud_quick_start.html
     */
    toCheckAlias() {
        return this.to('CheckAlias');
    }
    /**
     * Grants permission to add a new comment to the specified document version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateComment.html
     */
    toCreateComment() {
        return this.to('CreateComment');
    }
    /**
     * Grants permission to add one or more custom properties to the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateCustomMetadata.html
     */
    toCreateCustomMetadata() {
        return this.to('CreateCustomMetadata');
    }
    /**
     * Grants permission to create a folder with the specified name and parent folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateFolder.html
     */
    toCreateFolder() {
        return this.to('CreateFolder');
    }
    /**
     * Grants permission to create an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toCreateInstance() {
        return this.to('CreateInstance');
    }
    /**
     * Grants permission to add labels to the given resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateLabels.html
     */
    toCreateLabels() {
        return this.to('CreateLabels');
    }
    /**
     * Grants permission to configure WorkDocs to use Amazon SNS notifications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateNotificationSubscription.html
     */
    toCreateNotificationSubscription() {
        return this.to('CreateNotificationSubscription');
    }
    /**
     * Grants permission to create a user in a Simple AD or Microsoft AD directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        return this.to('CreateUser');
    }
    /**
     * Grants permission to deactivate the specified user, which revokes the user's access to Amazon WorkDocs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeactivateUser.html
     */
    toDeactivateUser() {
        return this.to('DeactivateUser');
    }
    /**
     * Grants permission to delete the specified comment from the document version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteComment.html
     */
    toDeleteComment() {
        return this.to('DeleteComment');
    }
    /**
     * Grants permission to delete custom metadata from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteCustomMetadata.html
     */
    toDeleteCustomMetadata() {
        return this.to('DeleteCustomMetadata');
    }
    /**
     * Grants permission to permanently delete the specified document and its associated metadata.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteDocument.html
     */
    toDeleteDocument() {
        return this.to('DeleteDocument');
    }
    /**
     * Grants permission to permanently delete the specified folder and its contents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolder.html
     */
    toDeleteFolder() {
        return this.to('DeleteFolder');
    }
    /**
     * Grants permission to delete the contents of the specified folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolderContents.html
     */
    toDeleteFolderContents() {
        return this.to('DeleteFolderContents');
    }
    /**
     * Grants permission to delete an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     */
    toDeleteInstance() {
        return this.to('DeleteInstance');
    }
    /**
     * Grants permission to delete one or more labels from a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteLabels.html
     */
    toDeleteLabels() {
        return this.to('DeleteLabels');
    }
    /**
     * Grants permission to delete the specified subscription from the specified organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteNotificationSubscription.html
     */
    toDeleteNotificationSubscription() {
        return this.to('DeleteNotificationSubscription');
    }
    /**
     * Grants permission to delete the specified user from a Simple AD or Microsoft AD directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser() {
        return this.to('DeleteUser');
    }
    /**
     * Grants permission to deregister a directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     */
    toDeregisterDirectory() {
        return this.to('DeregisterDirectory');
    }
    /**
     * Grants permission to fetch user activities in a specified time period.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeActivities.html
     */
    toDescribeActivities() {
        return this.to('DescribeActivities');
    }
    /**
     * Grants permission to describe available directories.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toDescribeAvailableDirectories() {
        return this.to('DescribeAvailableDirectories');
    }
    /**
     * Grants permission to list all the comments for the specified document version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeComments.html
     */
    toDescribeComments() {
        return this.to('DescribeComments');
    }
    /**
     * Grants permission to retrieve the document versions for the specified document.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeDocumentVersions.html
     */
    toDescribeDocumentVersions() {
        return this.to('DescribeDocumentVersions');
    }
    /**
     * Grants permission to describe the contents of the specified folder, including its documents and sub-folders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeFolderContents.html
     */
    toDescribeFolderContents() {
        return this.to('DescribeFolderContents');
    }
    /**
     * Grants permission to describe the user groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeGroups.html
     */
    toDescribeGroups() {
        return this.to('DescribeGroups');
    }
    /**
     * Grants permission to describe instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toDescribeInstances() {
        return this.to('DescribeInstances');
    }
    /**
     * Grants permission to list the specified notification subscriptions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeNotificationSubscriptions.html
     */
    toDescribeNotificationSubscriptions() {
        return this.to('DescribeNotificationSubscriptions');
    }
    /**
     * Grants permission to view a description of a specified resource's permissions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeResourcePermissions.html
     */
    toDescribeResourcePermissions() {
        return this.to('DescribeResourcePermissions');
    }
    /**
     * Grants permission to describe the root folders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeRootFolders.html
     */
    toDescribeRootFolders() {
        return this.to('DescribeRootFolders');
    }
    /**
     * Grants permission to view a description of the specified users. You can describe all users or filter the results (for example, by status or organization).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeUsers.html
     */
    toDescribeUsers() {
        return this.to('DescribeUsers');
    }
    /**
     * Grants permission to download a specified document version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     */
    toDownloadDocumentVersion() {
        return this.to('DownloadDocumentVersion');
    }
    /**
     * Grants permission to retrieve the details of the current user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetCurrentUser.html
     */
    toGetCurrentUser() {
        return this.to('GetCurrentUser');
    }
    /**
     * Grants permission to retrieve the specified document object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocument.html
     */
    toGetDocument() {
        return this.to('GetDocument');
    }
    /**
     * Grants permission to retrieve the path information (the hierarchy from the root folder) for the requested document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentPath.html
     */
    toGetDocumentPath() {
        return this.to('GetDocumentPath');
    }
    /**
     * Grants permission to retrieve version metadata for the specified document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     */
    toGetDocumentVersion() {
        return this.to('GetDocumentVersion');
    }
    /**
     * Grants permission to retrieve the metadata of the specified folder.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolder.html
     */
    toGetFolder() {
        return this.to('GetFolder');
    }
    /**
     * Grants permission to retrieve the path information (the hierarchy from the root folder) for the specified folder.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolderPath.html
     */
    toGetFolderPath() {
        return this.to('GetFolderPath');
    }
    /**
     * Grants permission to retrieve details for the specified group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_Operations.html
     */
    toGetGroup() {
        return this.to('GetGroup');
    }
    /**
     * Grants permission to get a collection of resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetResources.html
     */
    toGetResources() {
        return this.to('GetResources');
    }
    /**
     * Grants permission to create a new document object and version object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_InitiateDocumentVersionUpload.html
     */
    toInitiateDocumentVersionUpload() {
        return this.to('InitiateDocumentVersionUpload');
    }
    /**
     * Grants permission to register a directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/existing-dir-setup.html
     */
    toRegisterDirectory() {
        return this.to('RegisterDirectory');
    }
    /**
     * Grants permission to remove all the permissions from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveAllResourcePermissions.html
     */
    toRemoveAllResourcePermissions() {
        return this.to('RemoveAllResourcePermissions');
    }
    /**
     * Grants permission to remove the permission for the specified principal from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveResourcePermission.html
     */
    toRemoveResourcePermission() {
        return this.to('RemoveResourcePermission');
    }
    /**
     * Grants permission to update the specified attributes of the specified document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocument.html
     */
    toUpdateDocument() {
        return this.to('UpdateDocument');
    }
    /**
     * Grants permission to change the status of the document version to ACTIVE.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocumentVersion.html
     */
    toUpdateDocumentVersion() {
        return this.to('UpdateDocumentVersion');
    }
    /**
     * Grants permission to update the specified attributes of the specified folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateFolder.html
     */
    toUpdateFolder() {
        return this.to('UpdateFolder');
    }
    /**
     * Grants permission to update an instance alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     */
    toUpdateInstanceAlias() {
        return this.to('UpdateInstanceAlias');
    }
    /**
     * Grants permission to update the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateUser.html
     */
    toUpdateUser() {
        return this.to('UpdateUser');
    }
}
exports.Workdocs = Workdocs;
_a = JSII_RTTI_SYMBOL_1;
Workdocs[_a] = { fqn: "iam-floyd.Workdocs", version: "0.350.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid29ya2RvY3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ3b3JrZG9jcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNDQUE0QztBQUU1Qzs7OztHQUlHO0FBQ0gsTUFBYSxRQUFTLFNBQVEsd0JBQWU7SUFHM0M7Ozs7T0FJRztJQUNILFlBQVksR0FBWTtRQUN0QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFSTixrQkFBYSxHQUFHLFVBQVUsQ0FBQztRQXVrQnhCLG9CQUFlLEdBQW9CO1lBQzNDLEtBQUssRUFBRTtnQkFDTCw0QkFBNEI7Z0JBQzVCLGNBQWM7Z0JBQ2Qsd0JBQXdCO2dCQUN4QixnQkFBZ0I7Z0JBQ2hCLGVBQWU7Z0JBQ2Ysc0JBQXNCO2dCQUN0QixjQUFjO2dCQUNkLGdCQUFnQjtnQkFDaEIsY0FBYztnQkFDZCxnQ0FBZ0M7Z0JBQ2hDLFlBQVk7Z0JBQ1osZ0JBQWdCO2dCQUNoQixlQUFlO2dCQUNmLHNCQUFzQjtnQkFDdEIsZ0JBQWdCO2dCQUNoQixjQUFjO2dCQUNkLHNCQUFzQjtnQkFDdEIsZ0JBQWdCO2dCQUNoQixjQUFjO2dCQUNkLGdDQUFnQztnQkFDaEMsWUFBWTtnQkFDWixxQkFBcUI7Z0JBQ3JCLCtCQUErQjtnQkFDL0IsbUJBQW1CO2dCQUNuQiw4QkFBOEI7Z0JBQzlCLDBCQUEwQjtnQkFDMUIsZ0JBQWdCO2dCQUNoQix1QkFBdUI7Z0JBQ3ZCLGNBQWM7Z0JBQ2QscUJBQXFCO2dCQUNyQixZQUFZO2FBQ2I7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osWUFBWTtnQkFDWix5QkFBeUI7Z0JBQ3pCLGdCQUFnQjtnQkFDaEIsYUFBYTtnQkFDYixpQkFBaUI7Z0JBQ2pCLG9CQUFvQjtnQkFDcEIsV0FBVztnQkFDWCxlQUFlO2dCQUNmLFVBQVU7Z0JBQ1YsY0FBYzthQUNmO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLG9CQUFvQjtnQkFDcEIsOEJBQThCO2dCQUM5QixrQkFBa0I7Z0JBQ2xCLDBCQUEwQjtnQkFDMUIsd0JBQXdCO2dCQUN4QixnQkFBZ0I7Z0JBQ2hCLG1CQUFtQjtnQkFDbkIsbUNBQW1DO2dCQUNuQyw2QkFBNkI7Z0JBQzdCLHFCQUFxQjtnQkFDckIsZUFBZTthQUNoQjtTQUNGLENBQUM7SUF6bkJGLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksWUFBWTtRQUNqQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQ0FBZ0M7UUFDckMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0NBQWdDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxZQUFZO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDhCQUE4QjtRQUNuQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsOEJBQThCLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1DQUFtQztRQUN4QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNkJBQTZCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksYUFBYTtRQUNsQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFVBQVU7UUFDZixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwrQkFBK0I7UUFDcEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksOEJBQThCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxZQUFZO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQixDQUFDOztBQXRrQkgsNEJBb29CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnLi4vc2hhcmVkJztcblxuLyoqXG4gKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW3dvcmtkb2NzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b253b3JrZG9jcy5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIFdvcmtkb2NzIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnd29ya2RvY3MnO1xuXG4gIC8qKlxuICAgKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW3dvcmtkb2NzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b253b3JrZG9jcy5odG1sKS5cbiAgICpcbiAgICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gICAqL1xuICBjb25zdHJ1Y3RvcihzaWQ/OiBzdHJpbmcpIHtcbiAgICBzdXBlcihzaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGFib3J0IHRoZSB1cGxvYWQgb2YgdGhlIHNwZWNpZmllZCBkb2N1bWVudCB2ZXJzaW9uIHRoYXQgd2FzIHByZXZpb3VzbHkgaW5pdGlhdGVkIGJ5IEluaXRpYXRlRG9jdW1lbnRWZXJzaW9uVXBsb2FkLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9BYm9ydERvY3VtZW50VmVyc2lvblVwbG9hZC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9BYm9ydERvY3VtZW50VmVyc2lvblVwbG9hZCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQWJvcnREb2N1bWVudFZlcnNpb25VcGxvYWQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBhY3RpdmF0ZSB0aGUgc3BlY2lmaWVkIHVzZXIuIE9ubHkgYWN0aXZlIHVzZXJzIGNhbiBhY2Nlc3MgQW1hem9uIFdvcmtEb2NzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9BY3RpdmF0ZVVzZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQWN0aXZhdGVVc2VyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBY3RpdmF0ZVVzZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBzZXQgb2YgcGVybWlzc2lvbnMgZm9yIHRoZSBzcGVjaWZpZWQgZm9sZGVyIG9yIGRvY3VtZW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9BZGRSZXNvdXJjZVBlcm1pc3Npb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0FkZFJlc291cmNlUGVybWlzc2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0FkZFJlc291cmNlUGVybWlzc2lvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBhZGQgYSB1c2VyIHRvIGEgZ3JvdXAuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9hZG1pbmd1aWRlL21hbmFnZV9zZXRfYWRtaW4uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQWRkVXNlclRvR3JvdXAoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0FkZFVzZXJUb0dyb3VwJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY2hlY2sgYW4gYWxpYXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L2FkbWluZ3VpZGUvY2xvdWRfcXVpY2tfc3RhcnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ2hlY2tBbGlhcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ2hlY2tBbGlhcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGFkZCBhIG5ldyBjb21tZW50IHRvIHRoZSBzcGVjaWZpZWQgZG9jdW1lbnQgdmVyc2lvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlQ29tbWVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVDb21tZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVDb21tZW50Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gYWRkIG9uZSBvciBtb3JlIGN1c3RvbSBwcm9wZXJ0aWVzIHRvIHRoZSBzcGVjaWZpZWQgcmVzb3VyY2UuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZUN1c3RvbU1ldGFkYXRhLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUN1c3RvbU1ldGFkYXRhKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVDdXN0b21NZXRhZGF0YScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIGZvbGRlciB3aXRoIHRoZSBzcGVjaWZpZWQgbmFtZSBhbmQgcGFyZW50IGZvbGRlci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlRm9sZGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUZvbGRlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlRm9sZGVyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGFuIGluc3RhbmNlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvYWRtaW5ndWlkZS9nZXR0aW5nX3N0YXJ0ZWQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlSW5zdGFuY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUluc3RhbmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gYWRkIGxhYmVscyB0byB0aGUgZ2l2ZW4gcmVzb3VyY2UuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZUxhYmVscy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVMYWJlbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUxhYmVscycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNvbmZpZ3VyZSBXb3JrRG9jcyB0byB1c2UgQW1hem9uIFNOUyBub3RpZmljYXRpb25zLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVOb3RpZmljYXRpb25TdWJzY3JpcHRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlTm90aWZpY2F0aW9uU3Vic2NyaXB0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVOb3RpZmljYXRpb25TdWJzY3JpcHRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSB1c2VyIGluIGEgU2ltcGxlIEFEIG9yIE1pY3Jvc29mdCBBRCBkaXJlY3RvcnkuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZVVzZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlVXNlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlVXNlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlYWN0aXZhdGUgdGhlIHNwZWNpZmllZCB1c2VyLCB3aGljaCByZXZva2VzIHRoZSB1c2VyJ3MgYWNjZXNzIHRvIEFtYXpvbiBXb3JrRG9jcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVhY3RpdmF0ZVVzZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVhY3RpdmF0ZVVzZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlYWN0aXZhdGVVc2VyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIHRoZSBzcGVjaWZpZWQgY29tbWVudCBmcm9tIHRoZSBkb2N1bWVudCB2ZXJzaW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVDb21tZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUNvbW1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUNvbW1lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgY3VzdG9tIG1ldGFkYXRhIGZyb20gdGhlIHNwZWNpZmllZCByZXNvdXJjZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlQ3VzdG9tTWV0YWRhdGEuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlQ3VzdG9tTWV0YWRhdGEoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUN1c3RvbU1ldGFkYXRhJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcGVybWFuZW50bHkgZGVsZXRlIHRoZSBzcGVjaWZpZWQgZG9jdW1lbnQgYW5kIGl0cyBhc3NvY2lhdGVkIG1ldGFkYXRhLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVEb2N1bWVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVEb2N1bWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlRG9jdW1lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBwZXJtYW5lbnRseSBkZWxldGUgdGhlIHNwZWNpZmllZCBmb2xkZXIgYW5kIGl0cyBjb250ZW50cy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlRm9sZGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUZvbGRlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlRm9sZGVyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIHRoZSBjb250ZW50cyBvZiB0aGUgc3BlY2lmaWVkIGZvbGRlci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlRm9sZGVyQ29udGVudHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlRm9sZGVyQ29udGVudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUZvbGRlckNvbnRlbnRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGFuIGluc3RhbmNlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvYWRtaW5ndWlkZS9tYW5hZ2Utc2l0ZXMuaHRtbCNkZWxldGVfc2l0ZVxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlSW5zdGFuY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUluc3RhbmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIG9uZSBvciBtb3JlIGxhYmVscyBmcm9tIGEgcmVzb3VyY2UuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZUxhYmVscy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVMYWJlbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUxhYmVscycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSB0aGUgc3BlY2lmaWVkIHN1YnNjcmlwdGlvbiBmcm9tIHRoZSBzcGVjaWZpZWQgb3JnYW5pemF0aW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVOb3RpZmljYXRpb25TdWJzY3JpcHRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlTm90aWZpY2F0aW9uU3Vic2NyaXB0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVOb3RpZmljYXRpb25TdWJzY3JpcHRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgdGhlIHNwZWNpZmllZCB1c2VyIGZyb20gYSBTaW1wbGUgQUQgb3IgTWljcm9zb2Z0IEFEIGRpcmVjdG9yeS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlVXNlci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVVc2VyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVVc2VyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVyZWdpc3RlciBhIGRpcmVjdG9yeS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L2FkbWluZ3VpZGUvbWFuYWdlLXNpdGVzLmh0bWwjZGVsZXRlX3NpdGVcbiAgICovXG4gIHB1YmxpYyB0b0RlcmVnaXN0ZXJEaXJlY3RvcnkoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlcmVnaXN0ZXJEaXJlY3RvcnknKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBmZXRjaCB1c2VyIGFjdGl2aXRpZXMgaW4gYSBzcGVjaWZpZWQgdGltZSBwZXJpb2QuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVBY3Rpdml0aWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQWN0aXZpdGllcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVBY3Rpdml0aWVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYXZhaWxhYmxlIGRpcmVjdG9yaWVzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9hZG1pbmd1aWRlL2dldHRpbmdfc3RhcnRlZC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUF2YWlsYWJsZURpcmVjdG9yaWVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZUF2YWlsYWJsZURpcmVjdG9yaWVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBhbGwgdGhlIGNvbW1lbnRzIGZvciB0aGUgc3BlY2lmaWVkIGRvY3VtZW50IHZlcnNpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVDb21tZW50cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUNvbW1lbnRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZUNvbW1lbnRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmV0cmlldmUgdGhlIGRvY3VtZW50IHZlcnNpb25zIGZvciB0aGUgc3BlY2lmaWVkIGRvY3VtZW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlRG9jdW1lbnRWZXJzaW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZURvY3VtZW50VmVyc2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlRG9jdW1lbnRWZXJzaW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIHRoZSBjb250ZW50cyBvZiB0aGUgc3BlY2lmaWVkIGZvbGRlciwgaW5jbHVkaW5nIGl0cyBkb2N1bWVudHMgYW5kIHN1Yi1mb2xkZXJzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlRm9sZGVyQ29udGVudHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVGb2xkZXJDb250ZW50cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVGb2xkZXJDb250ZW50cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIHRoZSB1c2VyIGdyb3Vwcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZUdyb3Vwcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUdyb3VwcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVHcm91cHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBpbnN0YW5jZXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L2FkbWluZ3VpZGUvZ2V0dGluZ19zdGFydGVkLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlSW5zdGFuY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZUluc3RhbmNlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIHNwZWNpZmllZCBub3RpZmljYXRpb24gc3Vic2NyaXB0aW9ucy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZU5vdGlmaWNhdGlvblN1YnNjcmlwdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVOb3RpZmljYXRpb25TdWJzY3JpcHRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZU5vdGlmaWNhdGlvblN1YnNjcmlwdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB2aWV3IGEgZGVzY3JpcHRpb24gb2YgYSBzcGVjaWZpZWQgcmVzb3VyY2UncyBwZXJtaXNzaW9ucy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZVJlc291cmNlUGVybWlzc2lvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVSZXNvdXJjZVBlcm1pc3Npb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZVJlc291cmNlUGVybWlzc2lvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSB0aGUgcm9vdCBmb2xkZXJzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlUm9vdEZvbGRlcnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVSb290Rm9sZGVycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVSb290Rm9sZGVycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgYSBkZXNjcmlwdGlvbiBvZiB0aGUgc3BlY2lmaWVkIHVzZXJzLiBZb3UgY2FuIGRlc2NyaWJlIGFsbCB1c2VycyBvciBmaWx0ZXIgdGhlIHJlc3VsdHMgKGZvciBleGFtcGxlLCBieSBzdGF0dXMgb3Igb3JnYW5pemF0aW9uKS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZVVzZXJzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlVXNlcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlVXNlcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkb3dubG9hZCBhIHNwZWNpZmllZCBkb2N1bWVudCB2ZXJzaW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldERvY3VtZW50VmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9Eb3dubG9hZERvY3VtZW50VmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRG93bmxvYWREb2N1bWVudFZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXRyaWV2ZSB0aGUgZGV0YWlscyBvZiB0aGUgY3VycmVudCB1c2VyLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEN1cnJlbnRVc2VyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEN1cnJlbnRVc2VyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRDdXJyZW50VXNlcicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJldHJpZXZlIHRoZSBzcGVjaWZpZWQgZG9jdW1lbnQgb2JqZWN0LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldERvY3VtZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldERvY3VtZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXREb2N1bWVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJldHJpZXZlIHRoZSBwYXRoIGluZm9ybWF0aW9uICh0aGUgaGllcmFyY2h5IGZyb20gdGhlIHJvb3QgZm9sZGVyKSBmb3IgdGhlIHJlcXVlc3RlZCBkb2N1bWVudC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXREb2N1bWVudFBhdGguaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RG9jdW1lbnRQYXRoKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXREb2N1bWVudFBhdGgnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXRyaWV2ZSB2ZXJzaW9uIG1ldGFkYXRhIGZvciB0aGUgc3BlY2lmaWVkIGRvY3VtZW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldERvY3VtZW50VmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXREb2N1bWVudFZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldERvY3VtZW50VmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJldHJpZXZlIHRoZSBtZXRhZGF0YSBvZiB0aGUgc3BlY2lmaWVkIGZvbGRlci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRGb2xkZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0Rm9sZGVyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRGb2xkZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZXRyaWV2ZSB0aGUgcGF0aCBpbmZvcm1hdGlvbiAodGhlIGhpZXJhcmNoeSBmcm9tIHRoZSByb290IGZvbGRlcikgZm9yIHRoZSBzcGVjaWZpZWQgZm9sZGVyLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEZvbGRlclBhdGguaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0Rm9sZGVyUGF0aCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0Rm9sZGVyUGF0aCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJldHJpZXZlIGRldGFpbHMgZm9yIHRoZSBzcGVjaWZpZWQgZ3JvdXAuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfT3BlcmF0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRHcm91cCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0R3JvdXAnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgYSBjb2xsZWN0aW9uIG9mIHJlc291cmNlcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRSZXNvdXJjZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0UmVzb3VyY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRSZXNvdXJjZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBuZXcgZG9jdW1lbnQgb2JqZWN0IGFuZCB2ZXJzaW9uIG9iamVjdC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfSW5pdGlhdGVEb2N1bWVudFZlcnNpb25VcGxvYWQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvSW5pdGlhdGVEb2N1bWVudFZlcnNpb25VcGxvYWQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0luaXRpYXRlRG9jdW1lbnRWZXJzaW9uVXBsb2FkJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmVnaXN0ZXIgYSBkaXJlY3RvcnkuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9hZG1pbmd1aWRlL2V4aXN0aW5nLWRpci1zZXR1cC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9SZWdpc3RlckRpcmVjdG9yeSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnUmVnaXN0ZXJEaXJlY3RvcnknKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZW1vdmUgYWxsIHRoZSBwZXJtaXNzaW9ucyBmcm9tIHRoZSBzcGVjaWZpZWQgcmVzb3VyY2UuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1JlbW92ZUFsbFJlc291cmNlUGVybWlzc2lvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUmVtb3ZlQWxsUmVzb3VyY2VQZXJtaXNzaW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnUmVtb3ZlQWxsUmVzb3VyY2VQZXJtaXNzaW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJlbW92ZSB0aGUgcGVybWlzc2lvbiBmb3IgdGhlIHNwZWNpZmllZCBwcmluY2lwYWwgZnJvbSB0aGUgc3BlY2lmaWVkIHJlc291cmNlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9SZW1vdmVSZXNvdXJjZVBlcm1pc3Npb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUmVtb3ZlUmVzb3VyY2VQZXJtaXNzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdSZW1vdmVSZXNvdXJjZVBlcm1pc3Npb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgdGhlIHNwZWNpZmllZCBhdHRyaWJ1dGVzIG9mIHRoZSBzcGVjaWZpZWQgZG9jdW1lbnQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZURvY3VtZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZURvY3VtZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVEb2N1bWVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNoYW5nZSB0aGUgc3RhdHVzIG9mIHRoZSBkb2N1bWVudCB2ZXJzaW9uIHRvIEFDVElWRS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlRG9jdW1lbnRWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZURvY3VtZW50VmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlRG9jdW1lbnRWZXJzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIHRoZSBzcGVjaWZpZWQgYXR0cmlidXRlcyBvZiB0aGUgc3BlY2lmaWVkIGZvbGRlci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd29ya2RvY3MvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlRm9sZGVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUZvbGRlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlRm9sZGVyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGFuIGluc3RhbmNlIGFsaWFzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS93b3JrZG9jcy9sYXRlc3QvYWRtaW5ndWlkZS9nZXR0aW5nX3N0YXJ0ZWQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlSW5zdGFuY2VBbGlhcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlSW5zdGFuY2VBbGlhcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSB0aGUgc3BlY2lmaWVkIGF0dHJpYnV0ZXMgb2YgdGhlIHNwZWNpZmllZCB1c2VyLCBhbmQgZ3JhbnRzIG9yIHJldm9rZXMgYWRtaW5pc3RyYXRpdmUgcHJpdmlsZWdlcyB0byB0aGUgQW1hem9uIFdvcmtEb2NzIHNpdGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dvcmtkb2NzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZVVzZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlVXNlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlVXNlcicpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFjY2Vzc0xldmVsTGlzdDogQWNjZXNzTGV2ZWxMaXN0ID0ge1xuICAgIFdyaXRlOiBbXG4gICAgICAnQWJvcnREb2N1bWVudFZlcnNpb25VcGxvYWQnLFxuICAgICAgJ0FjdGl2YXRlVXNlcicsXG4gICAgICAnQWRkUmVzb3VyY2VQZXJtaXNzaW9ucycsXG4gICAgICAnQWRkVXNlclRvR3JvdXAnLFxuICAgICAgJ0NyZWF0ZUNvbW1lbnQnLFxuICAgICAgJ0NyZWF0ZUN1c3RvbU1ldGFkYXRhJyxcbiAgICAgICdDcmVhdGVGb2xkZXInLFxuICAgICAgJ0NyZWF0ZUluc3RhbmNlJyxcbiAgICAgICdDcmVhdGVMYWJlbHMnLFxuICAgICAgJ0NyZWF0ZU5vdGlmaWNhdGlvblN1YnNjcmlwdGlvbicsXG4gICAgICAnQ3JlYXRlVXNlcicsXG4gICAgICAnRGVhY3RpdmF0ZVVzZXInLFxuICAgICAgJ0RlbGV0ZUNvbW1lbnQnLFxuICAgICAgJ0RlbGV0ZUN1c3RvbU1ldGFkYXRhJyxcbiAgICAgICdEZWxldGVEb2N1bWVudCcsXG4gICAgICAnRGVsZXRlRm9sZGVyJyxcbiAgICAgICdEZWxldGVGb2xkZXJDb250ZW50cycsXG4gICAgICAnRGVsZXRlSW5zdGFuY2UnLFxuICAgICAgJ0RlbGV0ZUxhYmVscycsXG4gICAgICAnRGVsZXRlTm90aWZpY2F0aW9uU3Vic2NyaXB0aW9uJyxcbiAgICAgICdEZWxldGVVc2VyJyxcbiAgICAgICdEZXJlZ2lzdGVyRGlyZWN0b3J5JyxcbiAgICAgICdJbml0aWF0ZURvY3VtZW50VmVyc2lvblVwbG9hZCcsXG4gICAgICAnUmVnaXN0ZXJEaXJlY3RvcnknLFxuICAgICAgJ1JlbW92ZUFsbFJlc291cmNlUGVybWlzc2lvbnMnLFxuICAgICAgJ1JlbW92ZVJlc291cmNlUGVybWlzc2lvbicsXG4gICAgICAnVXBkYXRlRG9jdW1lbnQnLFxuICAgICAgJ1VwZGF0ZURvY3VtZW50VmVyc2lvbicsXG4gICAgICAnVXBkYXRlRm9sZGVyJyxcbiAgICAgICdVcGRhdGVJbnN0YW5jZUFsaWFzJyxcbiAgICAgICdVcGRhdGVVc2VyJ1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0NoZWNrQWxpYXMnLFxuICAgICAgJ0Rvd25sb2FkRG9jdW1lbnRWZXJzaW9uJyxcbiAgICAgICdHZXRDdXJyZW50VXNlcicsXG4gICAgICAnR2V0RG9jdW1lbnQnLFxuICAgICAgJ0dldERvY3VtZW50UGF0aCcsXG4gICAgICAnR2V0RG9jdW1lbnRWZXJzaW9uJyxcbiAgICAgICdHZXRGb2xkZXInLFxuICAgICAgJ0dldEZvbGRlclBhdGgnLFxuICAgICAgJ0dldEdyb3VwJyxcbiAgICAgICdHZXRSZXNvdXJjZXMnXG4gICAgXSxcbiAgICBMaXN0OiBbXG4gICAgICAnRGVzY3JpYmVBY3Rpdml0aWVzJyxcbiAgICAgICdEZXNjcmliZUF2YWlsYWJsZURpcmVjdG9yaWVzJyxcbiAgICAgICdEZXNjcmliZUNvbW1lbnRzJyxcbiAgICAgICdEZXNjcmliZURvY3VtZW50VmVyc2lvbnMnLFxuICAgICAgJ0Rlc2NyaWJlRm9sZGVyQ29udGVudHMnLFxuICAgICAgJ0Rlc2NyaWJlR3JvdXBzJyxcbiAgICAgICdEZXNjcmliZUluc3RhbmNlcycsXG4gICAgICAnRGVzY3JpYmVOb3RpZmljYXRpb25TdWJzY3JpcHRpb25zJyxcbiAgICAgICdEZXNjcmliZVJlc291cmNlUGVybWlzc2lvbnMnLFxuICAgICAgJ0Rlc2NyaWJlUm9vdEZvbGRlcnMnLFxuICAgICAgJ0Rlc2NyaWJlVXNlcnMnXG4gICAgXVxuICB9O1xufVxuIl19