# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class ServiceACLEntriesv1(pulumi.CustomResource):
    acl_id: pulumi.Output[str]
    """
    The ID of the ACL that the items belong to
    """
    entries: pulumi.Output[list]
    """
    A Set ACL entries that are applied to the service. Defined below

      * `comment` (`str`) - A personal freeform descriptive note
      * `id` (`str`)
      * `ip` (`str`) - An IP address that is the focus for the ACL
      * `negated` (`bool`) - A boolean that will negate the match if true
      * `subnet` (`str`) - An optional subnet mask applied to the IP address
    """
    service_id: pulumi.Output[str]
    """
    The ID of the Service that the ACL belongs to
    """
    def __init__(__self__, resource_name, opts=None, acl_id=None, entries=None, service_id=None, __props__=None, __name__=None, __opts__=None):
        """
        Defines a set of Fastly ACL entries that can be used to populate a service ACL.  This resource will populate an ACL with the entries and will track their state.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_fastly as fastly

        config = pulumi.Config()
        myacl_name = config.get("myaclName")
        if myacl_name is None:
            myacl_name = "My ACL"
        myservice = fastly.Servicev1("myservice",
            domain=[{
                "name": "demo.notexample.com",
                "comment": "demo",
            }],
            backend=[{
                "address": "demo.notexample.com.s3-website-us-west-2.amazonaws.com",
                "name": "AWS S3 hosting",
                "port": 80,
            }],
            acl=[{
                "name": myacl_name,
            }],
            force_destroy=True)
        entries = fastly.ServiceACLEntriesv1("entries",
            service_id=myservice.id,
            acl_id=myservice.acls.apply(lambda acls: {d["name"]: d["acl_id"] for d in acls}[myacl_name]),
            entry=[{
                "ip": "127.0.0.1",
                "subnet": "24",
                "negated": False,
                "comment": "ALC Entry 1",
            }])
        ```

        ### Complex object usage

        ```python
        import pulumi
        import pulumi_fastly as fastly

        acl_name = "my_acl"
        acl_entries = [
            {
                "ip": "1.2.3.4",
                "comment": "acl_entry_1",
            },
            {
                "ip": "1.2.3.5",
                "comment": "acl_entry_2",
            },
            {
                "ip": "1.2.3.6",
                "comment": "acl_entry_3",
            },
        ]
        myservice = fastly.Servicev1("myservice",
            domain=[{
                "name": "demo.notexample.com",
                "comment": "demo",
            }],
            backend=[{
                "address": "1.2.3.4",
                "name": "localhost",
                "port": 80,
            }],
            acl=[{
                "name": acl_name,
            }],
            force_destroy=True)
        entries = fastly.ServiceACLEntriesv1("entries",
            service_id=myservice.id,
            acl_id=myservice.acls.apply(lambda acls: {d["name"]: d["acl_id"] for d in acls}[acl_name]),
            dynamic=[{
                "forEach": [{
                    "ip": e["ip"],
                    "comment": e["comment"],
                } for e in acl_entries],
                "content": [{
                    "ip": entry["value"]["ip"],
                    "subnet": 22,
                    "comment": entry["value"]["comment"],
                    "negated": False,
                }],
            }])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[list] entries: A Set ACL entries that are applied to the service. Defined below
        :param pulumi.Input[str] service_id: The ID of the Service that the ACL belongs to

        The **entries** object supports the following:

          * `comment` (`pulumi.Input[str]`) - A personal freeform descriptive note
          * `id` (`pulumi.Input[str]`)
          * `ip` (`pulumi.Input[str]`) - An IP address that is the focus for the ACL
          * `negated` (`pulumi.Input[bool]`) - A boolean that will negate the match if true
          * `subnet` (`pulumi.Input[str]`) - An optional subnet mask applied to the IP address
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if acl_id is None:
                raise TypeError("Missing required property 'acl_id'")
            __props__['acl_id'] = acl_id
            __props__['entries'] = entries
            if service_id is None:
                raise TypeError("Missing required property 'service_id'")
            __props__['service_id'] = service_id
        super(ServiceACLEntriesv1, __self__).__init__(
            'fastly:index/serviceACLEntriesv1:ServiceACLEntriesv1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, acl_id=None, entries=None, service_id=None):
        """
        Get an existing ServiceACLEntriesv1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[list] entries: A Set ACL entries that are applied to the service. Defined below
        :param pulumi.Input[str] service_id: The ID of the Service that the ACL belongs to

        The **entries** object supports the following:

          * `comment` (`pulumi.Input[str]`) - A personal freeform descriptive note
          * `id` (`pulumi.Input[str]`)
          * `ip` (`pulumi.Input[str]`) - An IP address that is the focus for the ACL
          * `negated` (`pulumi.Input[bool]`) - A boolean that will negate the match if true
          * `subnet` (`pulumi.Input[str]`) - An optional subnet mask applied to the IP address
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl_id"] = acl_id
        __props__["entries"] = entries
        __props__["service_id"] = service_id
        return ServiceACLEntriesv1(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

