import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KmsKeyRingImportJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * It must be unique within a KeyRing and match the regular expression [a-zA-Z0-9_-]{1,63}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job.html#import_job_id KmsKeyRingImportJob#import_job_id}
     *
     * @stability stable
     */
    readonly importJobId: string;
    /**
     * The wrapping method to be used for incoming key material. Possible values: ["RSA_OAEP_3072_SHA1_AES_256", "RSA_OAEP_4096_SHA1_AES_256"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job.html#import_method KmsKeyRingImportJob#import_method}
     *
     * @stability stable
     */
    readonly importMethod: string;
    /**
     * The KeyRing that this import job belongs to. Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}''.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job.html#key_ring KmsKeyRingImportJob#key_ring}
     *
     * @stability stable
     */
    readonly keyRing: string;
    /**
     * The protection level of the ImportJob.
     *
     * This must match the protectionLevel of the
     * versionTemplate on the CryptoKey you attempt to import into. Possible values: ["SOFTWARE", "HSM", "EXTERNAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job.html#protection_level KmsKeyRingImportJob#protection_level}
     *
     * @stability stable
     */
    readonly protectionLevel: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job.html#timeouts KmsKeyRingImportJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KmsKeyRingImportJobTimeouts;
}
/**
 * @stability stable
 */
export declare class KmsKeyRingImportJobAttestation extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    get format(): string;
}
/**
 * @stability stable
 */
export declare class KmsKeyRingImportJobPublicKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get pem(): string;
}
/**
 * @stability stable
 */
export interface KmsKeyRingImportJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job.html#create KmsKeyRingImportJob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job.html#delete KmsKeyRingImportJob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function kmsKeyRingImportJobTimeoutsToTerraform(struct?: KmsKeyRingImportJobTimeoutsOutputReference | KmsKeyRingImportJobTimeouts): any;
/**
 * @stability stable
 */
export declare class KmsKeyRingImportJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KmsKeyRingImportJobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KmsKeyRingImportJobTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job.html google_kms_key_ring_import_job}.
 *
 * @stability stable
 */
export declare class KmsKeyRingImportJob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring_import_job.html google_kms_key_ring_import_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KmsKeyRingImportJobConfig);
    /**
     * @stability stable
     */
    attestation(index: string): KmsKeyRingImportJobAttestation;
    /**
     * @stability stable
     */
    get expireTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _importJobId?;
    /**
     * @stability stable
     */
    get importJobId(): string;
    /**
     * @stability stable
     */
    set importJobId(value: string);
    /**
     * @stability stable
     */
    get importJobIdInput(): string | undefined;
    private _importMethod?;
    /**
     * @stability stable
     */
    get importMethod(): string;
    /**
     * @stability stable
     */
    set importMethod(value: string);
    /**
     * @stability stable
     */
    get importMethodInput(): string | undefined;
    private _keyRing?;
    /**
     * @stability stable
     */
    get keyRing(): string;
    /**
     * @stability stable
     */
    set keyRing(value: string);
    /**
     * @stability stable
     */
    get keyRingInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _protectionLevel?;
    /**
     * @stability stable
     */
    get protectionLevel(): string;
    /**
     * @stability stable
     */
    set protectionLevel(value: string);
    /**
     * @stability stable
     */
    get protectionLevelInput(): string | undefined;
    /**
     * @stability stable
     */
    publicKey(index: string): KmsKeyRingImportJobPublicKey;
    /**
     * @stability stable
     */
    get state(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KmsKeyRingImportJobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KmsKeyRingImportJobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KmsKeyRingImportJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
