# -*- coding:utf-8 -*-
"""
@Author  :   g1879
@Contact :   g1879@qq.com
"""
from typing import Union, Tuple, List, Any

from .chromium_element import ChromiumElement
from .chromium_base import ChromiumBase


class ChromiumFrame(ChromiumBase):
    """frame元素的类。
    frame既是元素，也是页面，可以获取元素属性和定位周边元素，也能跳转到网址。
    同域和异域的frame处理方式不一样，同域的当作元素看待，异域的当作页面看待。"""

    def __init__(self, page: ChromiumBase, ele: ChromiumElement):
        self.page: ChromiumBase = ...
        self.frame_id: str = ...
        self._frame_ele: ChromiumElement = ...
        self._backend_id: str = ...
        self.frame_page: ChromiumBase = ...
        self._doc_ele: ChromiumElement = ...
        self._is_diff_domain: bool = ...
        self.doc_ele: ChromiumElement = ...
        # self.is_loading: bool = ...

    def __call__(self,
                 loc_or_str: Union[Tuple[str, str], str],
                 timeout: float = ...) -> Union[ChromiumElement, ChromiumFrame, str, None]: ...

    def __repr__(self) -> str: ...

    def _get_new_document(self) -> None: ...

    @property
    def tab_id(self) -> str: ...

    @property
    def backend_id(self) -> str: ...

    @property
    def obj_id(self) -> str: ...

    @property
    def node_id(self) -> str: ...

    @property
    def frame_ele(self) -> ChromiumElement: ...

    @property
    def tag(self) -> str: ...

    @property
    def url(self) -> str: ...

    @property
    def html(self) -> str: ...

    @property
    def inner_html(self) -> str: ...

    @property
    def title(self) -> str: ...

    @property
    def cookies(self) -> dict: ...

    @property
    def attrs(self) -> dict: ...

    @property
    def frame_size(self) -> tuple: ...

    @property
    def size(self) -> tuple: ...

    @property
    def active_ele(self) -> ChromiumElement: ...

    @property
    def location(self) -> dict: ...

    @property
    def is_displayed(self) -> bool: ...

    @property
    def xpath(self) -> str: ...

    @property
    def css_path(self) -> str: ...

    def refresh(self) -> None: ...

    def attr(self, attr: str) -> Union[str, None]: ...

    def set_attr(self, attr: str, value: str) -> None: ...

    def remove_attr(self, attr: str) -> None: ...

    def run_script(self, script: str, as_expr: bool = ..., *args: Any) -> Any: ...

    def parent(self, level_or_loc: Union[tuple, str, int] = ...) -> Union[ChromiumElement, None]: ...

    def prev(self,
             filter_loc: Union[tuple, str] = ...,
             index: int = ...,
             timeout: float = ...) -> Union[ChromiumElement, ChromiumFrame, str, None]: ...

    def next(self,
             filter_loc: Union[tuple, str] = ...,
             index: int = ...,
             timeout: float = ...) -> Union[ChromiumElement, ChromiumFrame, str, None]: ...

    def before(self,
               filter_loc: Union[tuple, str] = ...,
               index: int = ...,
               timeout: float = ...) -> Union[ChromiumElement, ChromiumFrame, str, None]: ...

    def after(self,
              filter_loc: Union[tuple, str] = ...,
              index: int = ...,
              timeout: float = ...) -> Union[ChromiumElement, ChromiumFrame, str, None]: ...

    def prevs(self,
              filter_loc: Union[tuple, str] = ...,
              timeout: float = ...) -> List[Union[ChromiumElement, ChromiumFrame, str]]: ...

    def nexts(self,
              filter_loc: Union[tuple, str] = ...,
              timeout: float = ...) -> List[Union[ChromiumElement, ChromiumFrame, str]]: ...

    def befores(self,
                filter_loc: Union[tuple, str] = ...,
                timeout: float = ...) -> List[Union[ChromiumElement, ChromiumFrame, str]]: ...

    def _ele(self,
             loc_or_ele: Union[Tuple[str, str], str, ChromiumElement, ChromiumFrame],
             timeout: float = ..., single: bool = ..., relative: bool = ...) \
            -> Union[ChromiumElement, ChromiumFrame, None, List[Union[ChromiumElement, ChromiumFrame]]]: ...

    def _d_connect(self,
                   to_url: str,
                   times: int = ...,
                   interval: float = ...,
                   show_errmsg: bool = ...,
                   timeout: float = ...) -> Union[bool, None]: ...

    def _is_inner_frame(self) -> bool: ...
