# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetCurrentUserResult',
    'AwaitableGetCurrentUserResult',
    'get_current_user',
]

@pulumi.output_type
class GetCurrentUserResult:
    """
    A collection of values returned by getCurrentUser.
    """
    def __init__(__self__, alphanumeric=None, external_id=None, home=None, id=None, repos=None, user_name=None, workspace_url=None):
        if alphanumeric and not isinstance(alphanumeric, str):
            raise TypeError("Expected argument 'alphanumeric' to be a str")
        pulumi.set(__self__, "alphanumeric", alphanumeric)
        if external_id and not isinstance(external_id, str):
            raise TypeError("Expected argument 'external_id' to be a str")
        pulumi.set(__self__, "external_id", external_id)
        if home and not isinstance(home, str):
            raise TypeError("Expected argument 'home' to be a str")
        pulumi.set(__self__, "home", home)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repos and not isinstance(repos, str):
            raise TypeError("Expected argument 'repos' to be a str")
        pulumi.set(__self__, "repos", repos)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)
        if workspace_url and not isinstance(workspace_url, str):
            raise TypeError("Expected argument 'workspace_url' to be a str")
        pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter
    def alphanumeric(self) -> str:
        return pulumi.get(self, "alphanumeric")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def home(self) -> str:
        return pulumi.get(self, "home")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def repos(self) -> str:
        return pulumi.get(self, "repos")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> str:
        return pulumi.get(self, "workspace_url")


class AwaitableGetCurrentUserResult(GetCurrentUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCurrentUserResult(
            alphanumeric=self.alphanumeric,
            external_id=self.external_id,
            home=self.home,
            id=self.id,
            repos=self.repos,
            user_name=self.user_name,
            workspace_url=self.workspace_url)


def get_current_user(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCurrentUserResult:
    """
    ## Exported attributes

    Data source exposes the following attributes:

    * `id` -  The id of the calling user.
    * `external_id` - ID of the user in an external identity provider.
    * `user_name` - Name of the user, e.g. `mr.foo@example.com`. If the currently logged-in identity is a service principal, returns the application ID, e.g. `11111111-2222-3333-4444-555666777888`
    * `home` - Home folder of the user, e.g. `/Users/mr.foo@example.com`.
    * `repos` - Personal Repos location of the user, e.g. `/Repos/mr.foo@example.com`.
    * `alphanumeric` - Alphanumeric representation of user local name. e.g. `mr_foo`.
    * `workspace_url` - URL of the current Databricks workspace.

    ## Related Resources

    The following resources are used in the same context:

    * End to end workspace management guide
    * Directory to manage directories in [Databricks Workpace](https://docs.databricks.com/workspace/workspace-objects.html).
    * Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).
    * Repo to manage [Databricks Repos](https://docs.databricks.com/repos.html).
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getCurrentUser:getCurrentUser', __args__, opts=opts, typ=GetCurrentUserResult).value

    return AwaitableGetCurrentUserResult(
        alphanumeric=__ret__.alphanumeric,
        external_id=__ret__.external_id,
        home=__ret__.home,
        id=__ret__.id,
        repos=__ret__.repos,
        user_name=__ret__.user_name,
        workspace_url=__ret__.workspace_url)
