# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecipientArgs', 'Recipient']

@pulumi.input_type
class RecipientArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
                 ip_access_list: Optional[pulumi.Input['RecipientIpAccessListArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sharing_code: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]] = None):
        """
        The set of arguments for constructing a Recipient resource.
        :param pulumi.Input[str] authentication_type: The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        :param pulumi.Input[str] comment: Description about the recipient.
        :param pulumi.Input[str] data_recipient_global_metastore_id: Required when authentication_type is DATABRICKS.
        :param pulumi.Input['RecipientIpAccessListArgs'] ip_access_list: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[str] name: Name of recipient. Change forces creation of a new resource.
        :param pulumi.Input[str] sharing_code: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]] tokens: List of Recipient Tokens.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if data_recipient_global_metastore_id is not None:
            pulumi.set(__self__, "data_recipient_global_metastore_id", data_recipient_global_metastore_id)
        if ip_access_list is not None:
            pulumi.set(__self__, "ip_access_list", ip_access_list)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sharing_code is not None:
            pulumi.set(__self__, "sharing_code", sharing_code)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[str]:
        """
        The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Description about the recipient.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="dataRecipientGlobalMetastoreId")
    def data_recipient_global_metastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required when authentication_type is DATABRICKS.
        """
        return pulumi.get(self, "data_recipient_global_metastore_id")

    @data_recipient_global_metastore_id.setter
    def data_recipient_global_metastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_recipient_global_metastore_id", value)

    @property
    @pulumi.getter(name="ipAccessList")
    def ip_access_list(self) -> Optional[pulumi.Input['RecipientIpAccessListArgs']]:
        """
        The one-time sharing code provided by the data recipient.
        """
        return pulumi.get(self, "ip_access_list")

    @ip_access_list.setter
    def ip_access_list(self, value: Optional[pulumi.Input['RecipientIpAccessListArgs']]):
        pulumi.set(self, "ip_access_list", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of recipient. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sharingCode")
    def sharing_code(self) -> Optional[pulumi.Input[str]]:
        """
        The one-time sharing code provided by the data recipient.
        """
        return pulumi.get(self, "sharing_code")

    @sharing_code.setter
    def sharing_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharing_code", value)

    @property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]]:
        """
        List of Recipient Tokens.
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]]):
        pulumi.set(self, "tokens", value)


@pulumi.input_type
class _RecipientState:
    def __init__(__self__, *,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
                 ip_access_list: Optional[pulumi.Input['RecipientIpAccessListArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sharing_code: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]] = None):
        """
        Input properties used for looking up and filtering Recipient resources.
        :param pulumi.Input[str] authentication_type: The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        :param pulumi.Input[str] comment: Description about the recipient.
        :param pulumi.Input[str] data_recipient_global_metastore_id: Required when authentication_type is DATABRICKS.
        :param pulumi.Input['RecipientIpAccessListArgs'] ip_access_list: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[str] name: Name of recipient. Change forces creation of a new resource.
        :param pulumi.Input[str] sharing_code: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]] tokens: List of Recipient Tokens.
        """
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if data_recipient_global_metastore_id is not None:
            pulumi.set(__self__, "data_recipient_global_metastore_id", data_recipient_global_metastore_id)
        if ip_access_list is not None:
            pulumi.set(__self__, "ip_access_list", ip_access_list)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sharing_code is not None:
            pulumi.set(__self__, "sharing_code", sharing_code)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[str]]:
        """
        The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Description about the recipient.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="dataRecipientGlobalMetastoreId")
    def data_recipient_global_metastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required when authentication_type is DATABRICKS.
        """
        return pulumi.get(self, "data_recipient_global_metastore_id")

    @data_recipient_global_metastore_id.setter
    def data_recipient_global_metastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_recipient_global_metastore_id", value)

    @property
    @pulumi.getter(name="ipAccessList")
    def ip_access_list(self) -> Optional[pulumi.Input['RecipientIpAccessListArgs']]:
        """
        The one-time sharing code provided by the data recipient.
        """
        return pulumi.get(self, "ip_access_list")

    @ip_access_list.setter
    def ip_access_list(self, value: Optional[pulumi.Input['RecipientIpAccessListArgs']]):
        pulumi.set(self, "ip_access_list", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of recipient. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sharingCode")
    def sharing_code(self) -> Optional[pulumi.Input[str]]:
        """
        The one-time sharing code provided by the data recipient.
        """
        return pulumi.get(self, "sharing_code")

    @sharing_code.setter
    def sharing_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharing_code", value)

    @property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]]:
        """
        List of Recipient Tokens.
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecipientTokenArgs']]]]):
        pulumi.set(self, "tokens", value)


class Recipient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
                 ip_access_list: Optional[pulumi.Input[pulumi.InputType['RecipientIpAccessListArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sharing_code: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecipientTokenArgs']]]]] = None,
                 __props__=None):
        """
        Within a metastore, Unity Catalog provides the ability to create a recipient to attach delta shares to.

        A `Recipient` is contained within Metastore and can have permissions to `SELECT` from a list of shares.

        ## Example Usage
        ### Databricks Sharing with non databricks recipient

        Setting `authentication_type` type to `TOKEN` creates a temporary url to download a credentials file. This is used to
        authenticate to the sharing server to access data. This is for when the recipient is not using Databricks.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_random as random

        db2opensharecode = random.RandomPassword("db2opensharecode",
            length=16,
            special=True)
        current = databricks.get_current_user()
        db2open = databricks.Recipient("db2open",
            comment="made by terraform",
            authentication_type="TOKEN",
            sharing_code=db2opensharecode.result,
            ip_access_list=databricks.RecipientIpAccessListArgs(
                allowed_ip_addresses=[],
            ))
        ```
        ## Related Resources

        The following resources are often used in the same context:

        * Share to create Delta Sharing shares.
        * Grants to manage Delta Sharing permissions.
          *_get_shares_to read existing Delta Sharing shares.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authentication_type: The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        :param pulumi.Input[str] comment: Description about the recipient.
        :param pulumi.Input[str] data_recipient_global_metastore_id: Required when authentication_type is DATABRICKS.
        :param pulumi.Input[pulumi.InputType['RecipientIpAccessListArgs']] ip_access_list: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[str] name: Name of recipient. Change forces creation of a new resource.
        :param pulumi.Input[str] sharing_code: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecipientTokenArgs']]]] tokens: List of Recipient Tokens.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecipientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Within a metastore, Unity Catalog provides the ability to create a recipient to attach delta shares to.

        A `Recipient` is contained within Metastore and can have permissions to `SELECT` from a list of shares.

        ## Example Usage
        ### Databricks Sharing with non databricks recipient

        Setting `authentication_type` type to `TOKEN` creates a temporary url to download a credentials file. This is used to
        authenticate to the sharing server to access data. This is for when the recipient is not using Databricks.

        ```python
        import pulumi
        import pulumi_databricks as databricks
        import pulumi_random as random

        db2opensharecode = random.RandomPassword("db2opensharecode",
            length=16,
            special=True)
        current = databricks.get_current_user()
        db2open = databricks.Recipient("db2open",
            comment="made by terraform",
            authentication_type="TOKEN",
            sharing_code=db2opensharecode.result,
            ip_access_list=databricks.RecipientIpAccessListArgs(
                allowed_ip_addresses=[],
            ))
        ```
        ## Related Resources

        The following resources are often used in the same context:

        * Share to create Delta Sharing shares.
        * Grants to manage Delta Sharing permissions.
          *_get_shares_to read existing Delta Sharing shares.

        :param str resource_name: The name of the resource.
        :param RecipientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecipientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
                 ip_access_list: Optional[pulumi.Input[pulumi.InputType['RecipientIpAccessListArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sharing_code: Optional[pulumi.Input[str]] = None,
                 tokens: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecipientTokenArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecipientArgs.__new__(RecipientArgs)

            if authentication_type is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_type'")
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["comment"] = comment
            __props__.__dict__["data_recipient_global_metastore_id"] = data_recipient_global_metastore_id
            __props__.__dict__["ip_access_list"] = ip_access_list
            __props__.__dict__["name"] = name
            __props__.__dict__["sharing_code"] = None if sharing_code is None else pulumi.Output.secret(sharing_code)
            __props__.__dict__["tokens"] = tokens
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sharingCode"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Recipient, __self__).__init__(
            'databricks:index/recipient:Recipient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_type: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            data_recipient_global_metastore_id: Optional[pulumi.Input[str]] = None,
            ip_access_list: Optional[pulumi.Input[pulumi.InputType['RecipientIpAccessListArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            sharing_code: Optional[pulumi.Input[str]] = None,
            tokens: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecipientTokenArgs']]]]] = None) -> 'Recipient':
        """
        Get an existing Recipient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authentication_type: The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        :param pulumi.Input[str] comment: Description about the recipient.
        :param pulumi.Input[str] data_recipient_global_metastore_id: Required when authentication_type is DATABRICKS.
        :param pulumi.Input[pulumi.InputType['RecipientIpAccessListArgs']] ip_access_list: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[str] name: Name of recipient. Change forces creation of a new resource.
        :param pulumi.Input[str] sharing_code: The one-time sharing code provided by the data recipient.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RecipientTokenArgs']]]] tokens: List of Recipient Tokens.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecipientState.__new__(_RecipientState)

        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["comment"] = comment
        __props__.__dict__["data_recipient_global_metastore_id"] = data_recipient_global_metastore_id
        __props__.__dict__["ip_access_list"] = ip_access_list
        __props__.__dict__["name"] = name
        __props__.__dict__["sharing_code"] = sharing_code
        __props__.__dict__["tokens"] = tokens
        return Recipient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[str]:
        """
        The delta sharing authentication type. Valid values are `TOKEN` and `DATABRICKS`.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        Description about the recipient.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="dataRecipientGlobalMetastoreId")
    def data_recipient_global_metastore_id(self) -> pulumi.Output[Optional[str]]:
        """
        Required when authentication_type is DATABRICKS.
        """
        return pulumi.get(self, "data_recipient_global_metastore_id")

    @property
    @pulumi.getter(name="ipAccessList")
    def ip_access_list(self) -> pulumi.Output[Optional['outputs.RecipientIpAccessList']]:
        """
        The one-time sharing code provided by the data recipient.
        """
        return pulumi.get(self, "ip_access_list")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of recipient. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sharingCode")
    def sharing_code(self) -> pulumi.Output[Optional[str]]:
        """
        The one-time sharing code provided by the data recipient.
        """
        return pulumi.get(self, "sharing_code")

    @property
    @pulumi.getter
    def tokens(self) -> pulumi.Output[Sequence['outputs.RecipientToken']]:
        """
        List of Recipient Tokens.
        """
        return pulumi.get(self, "tokens")

