# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerBindingArgs', 'TriggerBinding']

@pulumi.input_type
class TriggerBindingArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['TriggerBindingActionArgs']]],
                 trigger: pulumi.Input[str]):
        """
        The set of arguments for constructing a TriggerBinding resource.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBindingActionArgs']]] actions: The actions bound to this trigger. For details, see
               Actions.
        :param pulumi.Input[str] trigger: The id of the trigger to bind with
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['TriggerBindingActionArgs']]]:
        """
        The actions bound to this trigger. For details, see
        Actions.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['TriggerBindingActionArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Input[str]:
        """
        The id of the trigger to bind with
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input[str]):
        pulumi.set(self, "trigger", value)


@pulumi.input_type
class _TriggerBindingState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBindingActionArgs']]]] = None,
                 trigger: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TriggerBinding resources.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBindingActionArgs']]] actions: The actions bound to this trigger. For details, see
               Actions.
        :param pulumi.Input[str] trigger: The id of the trigger to bind with
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBindingActionArgs']]]]:
        """
        The actions bound to this trigger. For details, see
        Actions.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBindingActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the trigger to bind with
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger", value)


class TriggerBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerBindingActionArgs']]]]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        With this resource, you can bind an action to a trigger. Once an action is
        created and deployed, it can be attached (i.e. bound) to a trigger so that it
        will be executed as part of a flow.

        The list of actions reflects the order in which they will be executed during the
        appropriate flow.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        action_foo = auth0.Action("actionFoo",
            supported_triggers=auth0.ActionSupportedTriggersArgs(
                id="post-login",
                version="v2",
            ),
            code=\"\"\"exports.onContinuePostLogin = async (event, api) => { 
        	console.log("foo") 
        };"
        \"\"\",
            deploy=True)
        action_bar = auth0.Action("actionBar",
            supported_triggers=auth0.ActionSupportedTriggersArgs(
                id="post-login",
                version="v2",
            ),
            code=\"\"\"exports.onContinuePostLogin = async (event, api) => { 
        	console.log("bar") 
        };"
        \"\"\",
            deploy=True)
        login_flow = auth0.TriggerBinding("loginFlow",
            trigger="post-login",
            actions=[
                auth0.TriggerBindingActionArgs(
                    id=action_foo.id,
                    display_name=action_foo.name,
                ),
                auth0.TriggerBindingActionArgs(
                    id=action_bar.id,
                    display_name=action_bar.name,
                ),
            ])
        ```

        ## Import

        auth0_trigger_binding can be imported using the bindings trigger ID, e.g.

        ```sh
         $ pulumi import auth0:index/triggerBinding:TriggerBinding example "post-login"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerBindingActionArgs']]]] actions: The actions bound to this trigger. For details, see
               Actions.
        :param pulumi.Input[str] trigger: The id of the trigger to bind with
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can bind an action to a trigger. Once an action is
        created and deployed, it can be attached (i.e. bound) to a trigger so that it
        will be executed as part of a flow.

        The list of actions reflects the order in which they will be executed during the
        appropriate flow.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        action_foo = auth0.Action("actionFoo",
            supported_triggers=auth0.ActionSupportedTriggersArgs(
                id="post-login",
                version="v2",
            ),
            code=\"\"\"exports.onContinuePostLogin = async (event, api) => { 
        	console.log("foo") 
        };"
        \"\"\",
            deploy=True)
        action_bar = auth0.Action("actionBar",
            supported_triggers=auth0.ActionSupportedTriggersArgs(
                id="post-login",
                version="v2",
            ),
            code=\"\"\"exports.onContinuePostLogin = async (event, api) => { 
        	console.log("bar") 
        };"
        \"\"\",
            deploy=True)
        login_flow = auth0.TriggerBinding("loginFlow",
            trigger="post-login",
            actions=[
                auth0.TriggerBindingActionArgs(
                    id=action_foo.id,
                    display_name=action_foo.name,
                ),
                auth0.TriggerBindingActionArgs(
                    id=action_bar.id,
                    display_name=action_bar.name,
                ),
            ])
        ```

        ## Import

        auth0_trigger_binding can be imported using the bindings trigger ID, e.g.

        ```sh
         $ pulumi import auth0:index/triggerBinding:TriggerBinding example "post-login"
        ```

        :param str resource_name: The name of the resource.
        :param TriggerBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerBindingActionArgs']]]]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerBindingArgs.__new__(TriggerBindingArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if trigger is None and not opts.urn:
                raise TypeError("Missing required property 'trigger'")
            __props__.__dict__["trigger"] = trigger
        super(TriggerBinding, __self__).__init__(
            'auth0:index/triggerBinding:TriggerBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerBindingActionArgs']]]]] = None,
            trigger: Optional[pulumi.Input[str]] = None) -> 'TriggerBinding':
        """
        Get an existing TriggerBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerBindingActionArgs']]]] actions: The actions bound to this trigger. For details, see
               Actions.
        :param pulumi.Input[str] trigger: The id of the trigger to bind with
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerBindingState.__new__(_TriggerBindingState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["trigger"] = trigger
        return TriggerBinding(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.TriggerBindingAction']]:
        """
        The actions bound to this trigger. For details, see
        Actions.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Output[str]:
        """
        The id of the trigger to bind with
        """
        return pulumi.get(self, "trigger")

