# Native OneID

## 需求
- 内部联系人
    - 默认分类
        - 部门
        - 角色
        - 标签
    - 自定义分类
        - a
        - b
        - ...

以上分类均有以下共性：
    1. 具有层级从属结构，一个节点只有一个上级节点，有0至多个下级节点。
    2. 每个节点下有0至多个人，每个人可属于0至多个节点。
    3. 节点在兄弟节点中有序排列，人在同节点的所有人中有序排列。

另外还有以下类组的需求:

- 子管理员
    1. 无层级结构，每个人可属于0-N个子管理员身份。

- 外部联系人
    1. 地位与内部联系人相同，且可与外部联系人相互转化。通过标签组织。

## 解决方案
### 部门 <--> Dept
可直接使用
已存在一个名(uid)为`root`的部门，其子节点视为公司，公司的子节点为部门。目前认为`root`下只有一个子节点，即只有一个公司。
该子节点在配置好公司基本信息后生成。 [root -> $company]

### 角色 <--> Group
已存在名(uid)为`root`, `intra`的两个组，两者为父子关系。`intra`为所有角色等组分类的父节点。
在`intra`下创建名为`role`的组。 [root -> intra -> role]
所有角色为`role`的子孙节点。

### 标签 <--> Group
在`intra`下创建名为`label`的组。 [root -> intra -> label]
所有标签为`label`的子孙节点。

### 自定义分类 <--> Group
在`intra`下创建组。[root -> intra -> $custom]
所有自定义子类为`$custom`的子孙节点。

### 管理员组 <--> Group
在`intra`下创建名为`manager`的组。[root -> intra -> manager]
所有管理员组为`manager`的子孙节点。

### 外部联系人标签 <--> Group
已存在名(uid)为`extern`的组，为`root`的子节点。`extern`为所有外部联系人标签的父节点。
所有外部联系人必属于`extern`，还可能属于`extern`的下属节点。
