# Generated by Django 2.0.13 on 2020-04-07 03:09

from django.db import migrations, models
import django.db.models.deletion
from ...oauth2_provider import generators

class Migration(migrations.Migration):

    dependencies = [
        ('oneid_meta', '0069_smsconfig_template_login'),
        ('oauth2_provider', '0008_auto_20190220_1058'),
    ]

    operations = [
        migrations.CreateModel(
            name='OidcAccessToken',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('token', models.CharField(max_length=255, unique=True)),
                ('expires', models.DateTimeField()),
                ('scope', models.TextField(blank=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('id_token', models.TextField(verbose_name='ID Token')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OidcApplication',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(default='', max_length=100)),
                ('client_type', models.CharField(choices=[('confidential', 'Confidential'), ('public', 'Public')], default='confidential', help_text='<b>Confidential</b> clients are capable of maintaining the confidentiality of their credentials. <b>Public</b> clients are incapable.', max_length=30, verbose_name='Client Type')),
                ('client_id', models.CharField(default=generators.generate_client_id, max_length=255, unique=True)),
                ('client_secret', models.CharField(blank=True, default=generators.generate_client_secret, max_length=255)),
                ('response_type', models.CharField(choices=[('code', 'code (Authorization Code Flow)'), ('id_token', 'id_token (Implicit Flow)'), ('id_token token', 'id_token token (Implicit Flow)'), ('code token', 'code token (Hybrid Flow)'), ('code id_token', 'code id_token (Hybrid Flow)'), ('code id_token token', 'code id_token token (Hybrid Flow)')], default='code', max_length=32)),
                ('jwt_alg', models.CharField(choices=[('HS256', 'HS256'), ('RS256', 'RS256')], default='RS256', help_text='Algorithm used to encode ID Tokens.', max_length=10)),
                ('date_created', models.DateField(auto_now_add=True)),
                ('website_url', models.CharField(blank=True, default='', max_length=255)),
                ('terms_url', models.CharField(blank=True, default='', help_text='External reference to the privacy policy of the client.', max_length=255)),
                ('contact_email', models.CharField(blank=True, default='', max_length=255)),
                ('logo', models.FileField(blank=True, default='', upload_to='oidc_provider/clients')),
                ('reuse_consent', models.BooleanField(default=True, help_text="If enabled, server will save the user consent given to a specific client, so that user won't be prompted for the same authorization multiple times.")),
                ('require_consent', models.BooleanField(default=True, help_text='If disabled, the Server will NEVER ask the user for consent.')),
                ('redirect_uris', models.TextField(default='', help_text='Enter each URI on a new line.')),
                ('_post_logout_redirect_uris', models.TextField(blank=True, default='', help_text='Enter each URI on a new line.')),
                ('_scope', models.TextField(blank=True, default='', help_text='Specifies the authorized scope values for the client app.')),
                ('skip_authorization', models.BooleanField(default=False)),
                ('app', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='oidc_app', to='oneid_meta.APP')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='oauth2_provider_oidcapplication', to='oneid_meta.User')),
            ],
            options={
                'abstract': False,
                'swappable': "OAUTH2_PROVIDER_OIDC_APPLICATION_MODEL"
            },
        ),
        migrations.CreateModel(
            name='OidcGrant',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('code', models.CharField(max_length=255, unique=True)),
                ('expires', models.DateTimeField()),
                ('redirect_uri', models.CharField(max_length=255)),
                ('scope', models.TextField(blank=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oauth2_provider.OidcApplication')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='oauth2_provider_oidcgrant', to='oneid_meta.User')),
                ('code_challenge', models.CharField(max_length=255, null=True, verbose_name='Code Challenge')),
                ('code_challenge_method', models.CharField(choices=[('plain', 'plain coded format'), ('S256', 'S256 coded format')], max_length=255, null=True, verbose_name='Code Challenge Method')),
                ('nonce', models.CharField(blank=True, default='', max_length=255, verbose_name='Nonce'))
            ],
            options={
                'swappable': "OAUTH2_PROVIDER_OIDC_GRANT_MODEL",
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OidcRefreshToken',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('token', models.CharField(max_length=255)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('revoked', models.DateTimeField(null=True)),
                ('access_token', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='refresh_token', to='oauth2_provider.OidcAccessToken')),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oauth2_provider.OidcApplication')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='oauth2_provider_oidcrefreshtoken', to='oneid_meta.User')),
            ],
            options={
                'swappable': "OAUTH2_PROVIDER_OIDC_REFRESH_TOKEN_MODEL",
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OidcRsaKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.TextField(help_text='Paste your private RSA Key here.', verbose_name='Key')),
            ],
            options={
                'verbose_name': 'RSA Key',
                'verbose_name_plural': 'RSA Keys',
                'swappable': 'OAUTH2_PROVIDER_OIDC_RSA_KEY'
            },
        ),
        migrations.AddField(
            model_name='oidcaccesstoken',
            name='application',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='oauth2_provider.OidcApplication'),
        ),
        migrations.AddField(
            model_name='oidcaccesstoken',
            name='source_refresh_token',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='refreshed_access_token', to='oauth2_provider.OidcRefreshToken'),
        ),
        migrations.AddField(
            model_name='oidcaccesstoken',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='oauth2_provider_oidcaccesstoken', to='oneid_meta.User'),
        ),
        migrations.AlterUniqueTogether(
            name='oidcrefreshtoken',
            unique_together={('token', 'revoked')},
        ),
    ]
