# Generated by Django 2.0.7 on 2019-01-14 08:02

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='APP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('uid', models.CharField(max_length=255, verbose_name='APP唯一标识')),
                ('name', models.CharField(blank=True, default='', max_length=255, verbose_name='权限名称')),
                ('remark', models.TextField(blank=True, default='', verbose_name='详细介绍')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Dept',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('uid', models.CharField(max_length=255, verbose_name='唯一标识')),
                ('name', models.CharField(max_length=255, verbose_name='部门名称')),
                ('remark', models.TextField(default='详细介绍')),
                ('order', models.IntegerField(verbose_name='在兄弟部门中的排序，小号在前')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='oneid_meta.Dept', verbose_name='父级节点')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeptMember',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('order', models.IntegerField(default=0, verbose_name='在部门中的排序')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='oneid_meta.Dept', verbose_name='所属部门')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeptPerm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('status', models.IntegerField(choices=[(-1, '显式拒绝'), (0, '随上级决定'), (1, '显式授权')], default=0, verbose_name='授权状态')),
                ('value', models.BooleanField(default=False, verbose_name='是否有权限')),
                ('onwer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oneid_meta.Dept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DingDept',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('uid', models.IntegerField(verbose_name='钉钉部门id')),
                ('order', models.IntegerField(verbose_name='在兄弟部门中的排序，小号在前')),
                ('dept', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='oneid_meta.Dept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DingUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('account', models.CharField(max_length=64, verbose_name='钉钉账号(手机)')),
                ('uid', models.CharField(max_length=255, verbose_name='员工在企业内的唯一标识')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('uid', models.CharField(max_length=255, verbose_name='唯一标识')),
                ('name', models.CharField(max_length=255, verbose_name='部门名称')),
                ('remark', models.TextField(default='详细介绍')),
                ('order', models.IntegerField(verbose_name='在兄弟部门中的排序，小号在前')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='oneid_meta.Group', verbose_name='父级节点')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupMember',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('order', models.IntegerField(default=0, verbose_name='在组中的排序')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='oneid_meta.Group', verbose_name='所属组')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupPerm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('status', models.IntegerField(choices=[(-1, '显式拒绝'), (0, '随上级决定'), (1, '显式授权')], default=0, verbose_name='授权状态')),
                ('value', models.BooleanField(default=False, verbose_name='是否有权限')),
                ('onwer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oneid_meta.Group')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Perm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('uid', models.CharField(max_length=255, verbose_name='权限唯一标识')),
                ('name', models.CharField(blank=True, default='', max_length=255, verbose_name='权限名称')),
                ('remark', models.TextField(blank=True, default='', verbose_name='详细介绍')),
                ('scope', models.CharField(max_length=128, verbose_name='权限作用域')),
                ('action', models.CharField(max_length=128, verbose_name='操作行为')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PosixUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('uid', models.IntegerField(blank=True, default=500)),
                ('gid', models.IntegerField(blank=True, default=500)),
                ('home', models.CharField(blank=True, default='', max_length=255, verbose_name='家目录')),
                ('pub_key', models.CharField(blank=True, default='', max_length=255, verbose_name='公钥')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('username', models.CharField(max_length=255, verbose_name='唯一标识')),
                ('password', models.CharField(max_length=1024, verbose_name='密码')),
                ('name', models.CharField(blank=True, default='', max_length=255, verbose_name='姓名')),
                ('email', models.CharField(blank=True, default='', max_length=255, verbose_name='邮箱')),
                ('mobile', models.CharField(blank=True, default='', max_length=64, verbose_name='手机')),
                ('employee_number', models.CharField(blank=True, default='', max_length=255, verbose_name='工号')),
                ('gender', models.IntegerField(choices=[(0, '男'), (1, '女')], default=0, verbose_name='性别')),
                ('django_user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UserPerm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('status', models.IntegerField(choices=[(-1, '显式拒绝'), (0, '随上级决定'), (1, '显式授权')], default=0, verbose_name='授权状态')),
                ('value', models.BooleanField(default=False, verbose_name='是否有权限')),
                ('dept_perm_value', models.BooleanField(default=False, verbose_name='部门权限校验结果')),
                ('group_perm_value', models.BooleanField(default=False, verbose_name='组权限校验结果')),
                ('onwer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oneid_meta.User')),
                ('perm', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oneid_meta.Perm', verbose_name='权限')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='posixuser',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, to='oneid_meta.User', verbose_name='用户'),
        ),
        migrations.AddField(
            model_name='groupperm',
            name='perm',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oneid_meta.Perm', verbose_name='权限'),
        ),
        migrations.AddField(
            model_name='groupmember',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='oneid_meta.User'),
        ),
        migrations.AddField(
            model_name='dinguser',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, to='oneid_meta.User', verbose_name='用户'),
        ),
        migrations.AddField(
            model_name='deptperm',
            name='perm',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oneid_meta.Perm', verbose_name='权限'),
        ),
        migrations.AddField(
            model_name='deptmember',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='oneid_meta.User'),
        ),
    ]
