# Generated by Django 2.0.7 on 2019-01-15 02:44

from django.db import migrations, models


def create_root_dept(apps, schema_editor):
    Dept = apps.get_model('oneid_meta', 'Dept')
    Dept.objects.create(
        uid='root',
        name='root',
        remark='所有顶级的部门的父级，可视为整个公司。请勿修改',
    )


def create_root_group(apps, schema_editor):
    Group = apps.get_model('oneid_meta', 'Group')
    Group.objects.create(
        uid='root',
        name='root',
        remark='所有顶级的组的父级，可视为整个公司。请勿修改',
        accept_user=False,
    )


class Migration(migrations.Migration):

    dependencies = [
        ('oneid_meta', '0002_group_accept_user'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='dept',
            name='order',
        ),
        migrations.RemoveField(
            model_name='deptmember',
            name='order',
        ),
        migrations.RemoveField(
            model_name='dingdept',
            name='order',
        ),
        migrations.RemoveField(
            model_name='group',
            name='order',
        ),
        migrations.RemoveField(
            model_name='groupmember',
            name='order',
        ),
        migrations.AddField(
            model_name='dept',
            name='order_no',
            field=models.IntegerField(default=0, verbose_name='排序号'),
        ),
        migrations.AddField(
            model_name='deptmember',
            name='order_no',
            field=models.IntegerField(default=0, verbose_name='排序号'),
        ),
        migrations.AddField(
            model_name='dingdept',
            name='data',
            field=models.TextField(blank=True, default='{}', verbose_name='钉钉部门详细数据(JSON)'),
        ),
        migrations.AddField(
            model_name='dingdept',
            name='order_no',
            field=models.IntegerField(default=0, verbose_name='排序号'),
        ),
        migrations.AddField(
            model_name='dinguser',
            name='data',
            field=models.TextField(blank=True, default='{}', verbose_name='钉钉员工详细数据(JSON)'),
        ),
        migrations.AddField(
            model_name='group',
            name='order_no',
            field=models.IntegerField(default=0, verbose_name='排序号'),
        ),
        migrations.AddField(
            model_name='groupmember',
            name='order_no',
            field=models.IntegerField(default=0, verbose_name='排序号'),
        ),

        migrations.RunPython(create_root_dept),
        migrations.RunPython(create_root_group),

    ]
