# Generated by Django 2.0.13 on 2019-09-10 11:56

from django.db import migrations, models


def init_extern_user_native_field(apps, schema_editor):
    '''
    初始化 extern_user 字段
    '''
    subject = 'extern_user'
    NativeField = apps.get_model('oneid_meta', 'NativeField')
    for native_field in NativeField.objects.all():
        native_field.subject = 'user'
        native_field.save()
    NativeField.objects.create(subject=subject, name='手机号', key='mobile', is_visible_editable=False)
    NativeField.objects.create(subject=subject, name='邮箱', key='email', is_visible_editable=False)
    NativeField.objects.create(subject=subject, name='用户名', key='username', is_visible_editable=False)
    NativeField.objects.create(subject=subject, name='标签', key='nodes',
            schema={'type': 'array', 'items': {
            'type': 'object',
            'properties': {
                'uid': {'type': 'string'},
                'name': {'type': 'string'},
            },
        }},
        is_visible_editable=False)

    NativeField.objects.create(subject=subject, name='姓名', key='name')
    NativeField.objects.create(subject=subject, name='备注', key='remark')


class Migration(migrations.Migration):

    dependencies = [
        ('oneid_meta', '0053_auto_20190910_1719'),
    ]

    operations = [
        migrations.AddField(
            model_name='user',
            name='remark',
            field=models.CharField(blank=True, default='', max_length=512, verbose_name='备注'),
        ),
        migrations.AlterField(
            model_name='nativefield',
            name='subject',
            field=models.CharField(choices=[('user', '内部联系人'), ('extern_user', '外部联系人')], default='user', max_length=128, verbose_name='字段分类'),
        ),
        migrations.RunPython(init_extern_user_native_field),
    ]
