# Generated by Django 2.0.13 on 2019-10-25 06:58

from django.db import migrations, models
import django.db.models.deletion
from ...oneid_meta.models import config
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('oneid_meta', '0059_auto_20191025_1324'),
    ]

    operations = [
        migrations.CreateModel(
            name='WorkWechatConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('corp_id', models.CharField(blank=True, default='', max_length=255, verbose_name='CORP ID')),
                ('agent_id', models.CharField(blank=True, default='', max_length=64, verbose_name='AGENT ID')),
                ('secret', models.CharField(blank=True, default='', max_length=255, verbose_name='SECRET')),
                ('qr_app_valid', models.BooleanField(default=False, verbose_name='扫码登录APP配置是否正确')),
                ('site', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='work_wechat_config', to='sites.Site')),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, config.SingletonConfigMixin),
        ),
        migrations.CreateModel(
            name='WorkWechatUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('work_wechat_user_id', models.TextField(blank=True, max_length=255, verbose_name='企业微信ID')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, related_name='work_wechat_user', to='oneid_meta.User', verbose_name='用户')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='accountconfig',
            name='allow_work_wechat_qr',
            field=models.BooleanField(default=False, verbose_name='是否开放企业微信扫码登录'),
        ),
    ]
