# Generated by Django 2.0.13 on 2019-11-25 11:40
from sys import _getframe

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion

from ...common.setup_utils import NotConfiguredException, validate_attr
from ...oneid_meta.models import config
import uuid


def init_storage_config(apps, schema_editor):

    StorageConfig = apps.get_model('oneid_meta', 'StorageConfig')
    MinioConfig = apps.get_model('oneid_meta', 'MinioConfig')
    Site = apps.get_model('sites', 'Site')
    validate_attr(_getframe().f_code.co_filename, _getframe().f_code.co_name, _getframe().f_lineno,
                  'SITE_ID')
    site, _ = Site.objects.get_or_create(id=settings.SITE_ID)
    storage_config, _ = StorageConfig.objects.get_or_create(site=site)
    minio_config, _ = MinioConfig.objects.get_or_create(site=site)

    validate_attr(_getframe().f_code.co_filename, _getframe().f_code.co_name, _getframe().f_lineno, 'TESTING')

    if not settings.TESTING:
        minio_config.end_point = getattr(settings, 'MINIO_ENDPOINT', '')
        minio_config.access_key = getattr(settings, 'MINIO_ACCESS_KEY', '')
        minio_config.secret_key = getattr(settings, 'MINIO_SECRET_KEY', '')
        minio_config.secure = getattr(settings, 'MINIO_SECURE', '')
        minio_config.location = getattr(settings, 'MINIO_LOCATION', '')
        minio_config.bucket = getattr(settings, 'MINIO_BUCKET', '')
        minio_config.save()

        if minio_config.access_key != '' and minio_config.secret_key != '':
            storage_config.method = 'minio'
            storage_config.save()


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('oneid_meta', '0065_auto_20191115_1422'),
    ]

    operations = [
        migrations.CreateModel(
            name='MinioConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('end_point', models.CharField(blank=True, default='', max_length=225, verbose_name='END POINT')),
                ('access_key', models.CharField(blank=True, default='', max_length=225, verbose_name='ACCESS KEY')),
                ('secret_key', models.CharField(blank=True, default='', max_length=225, verbose_name='SECRET KEY')),
                ('secure', models.BooleanField(default=True, max_length=225, verbose_name='SECURE')),
                ('location', models.CharField(blank=True, default='', max_length=225, verbose_name='LOCATION')),
                ('bucket', models.CharField(blank=True, default='', max_length=225, verbose_name='BUCKET')),
                ('site', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='minio_config', to='sites.Site')),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, config.SingletonConfigMixin),
        ),
        migrations.CreateModel(
            name='StorageConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, unique=True)),
                ('is_del', models.BooleanField(default=False, verbose_name='是否删除')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否可用')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='更新时间')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('method', models.CharField(blank=True, default='local', max_length=225, verbose_name='method')),
                ('site', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='storage_config', to='sites.Site')),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, config.SingletonConfigMixin),
        ),
        migrations.RunPython(init_storage_config),
    ]
