BEGIN TRANSACTION;
CREATE TABLE "auth_group" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(80) NOT NULL UNIQUE);
CREATE TABLE "auth_group_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" integer NOT NULL REFERENCES "auth_group" ("id") DEFERRABLE INITIALLY DEFERRED, "permission_id" integer NOT NULL REFERENCES "auth_permission" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "auth_permission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "content_type_id" integer NOT NULL REFERENCES "django_content_type" ("id") DEFERRABLE INITIALLY DEFERRED, "codename" varchar(100) NOT NULL, "name" varchar(255) NOT NULL);
INSERT INTO "auth_permission" VALUES(1,1,'add_logentry','Can add log entry');
INSERT INTO "auth_permission" VALUES(2,1,'change_logentry','Can change log entry');
INSERT INTO "auth_permission" VALUES(3,1,'delete_logentry','Can delete log entry');
INSERT INTO "auth_permission" VALUES(4,2,'add_permission','Can add permission');
INSERT INTO "auth_permission" VALUES(5,2,'change_permission','Can change permission');
INSERT INTO "auth_permission" VALUES(6,2,'delete_permission','Can delete permission');
INSERT INTO "auth_permission" VALUES(7,3,'add_group','Can add group');
INSERT INTO "auth_permission" VALUES(8,3,'change_group','Can change group');
INSERT INTO "auth_permission" VALUES(9,3,'delete_group','Can delete group');
INSERT INTO "auth_permission" VALUES(10,4,'add_user','Can add user');
INSERT INTO "auth_permission" VALUES(11,4,'change_user','Can change user');
INSERT INTO "auth_permission" VALUES(12,4,'delete_user','Can delete user');
INSERT INTO "auth_permission" VALUES(13,5,'add_contenttype','Can add content type');
INSERT INTO "auth_permission" VALUES(14,5,'change_contenttype','Can change content type');
INSERT INTO "auth_permission" VALUES(15,5,'delete_contenttype','Can delete content type');
INSERT INTO "auth_permission" VALUES(16,6,'add_session','Can add session');
INSERT INTO "auth_permission" VALUES(17,6,'change_session','Can change session');
INSERT INTO "auth_permission" VALUES(18,6,'delete_session','Can delete session');
INSERT INTO "auth_permission" VALUES(19,7,'add_site','Can add site');
INSERT INTO "auth_permission" VALUES(20,7,'change_site','Can change site');
INSERT INTO "auth_permission" VALUES(21,7,'delete_site','Can delete site');
INSERT INTO "auth_permission" VALUES(22,8,'add_taskresult','Can add task result');
INSERT INTO "auth_permission" VALUES(23,8,'change_taskresult','Can change task result');
INSERT INTO "auth_permission" VALUES(24,8,'delete_taskresult','Can delete task result');
INSERT INTO "auth_permission" VALUES(25,9,'add_crontabschedule','Can add crontab');
INSERT INTO "auth_permission" VALUES(26,9,'change_crontabschedule','Can change crontab');
INSERT INTO "auth_permission" VALUES(27,9,'delete_crontabschedule','Can delete crontab');
INSERT INTO "auth_permission" VALUES(28,10,'add_intervalschedule','Can add interval');
INSERT INTO "auth_permission" VALUES(29,10,'change_intervalschedule','Can change interval');
INSERT INTO "auth_permission" VALUES(30,10,'delete_intervalschedule','Can delete interval');
INSERT INTO "auth_permission" VALUES(31,11,'add_periodictask','Can add periodic task');
INSERT INTO "auth_permission" VALUES(32,11,'change_periodictask','Can change periodic task');
INSERT INTO "auth_permission" VALUES(33,11,'delete_periodictask','Can delete periodic task');
INSERT INTO "auth_permission" VALUES(34,12,'add_periodictasks','Can add periodic tasks');
INSERT INTO "auth_permission" VALUES(35,12,'change_periodictasks','Can change periodic tasks');
INSERT INTO "auth_permission" VALUES(36,12,'delete_periodictasks','Can delete periodic tasks');
INSERT INTO "auth_permission" VALUES(37,13,'add_solarschedule','Can add solar event');
INSERT INTO "auth_permission" VALUES(38,13,'change_solarschedule','Can change solar event');
INSERT INTO "auth_permission" VALUES(39,13,'delete_solarschedule','Can delete solar event');
INSERT INTO "auth_permission" VALUES(40,14,'add_corsmodel','Can add cors model');
INSERT INTO "auth_permission" VALUES(41,14,'change_corsmodel','Can change cors model');
INSERT INTO "auth_permission" VALUES(42,14,'delete_corsmodel','Can delete cors model');
INSERT INTO "auth_permission" VALUES(43,15,'add_token','Can add Token');
INSERT INTO "auth_permission" VALUES(44,15,'change_token','Can change Token');
INSERT INTO "auth_permission" VALUES(45,15,'delete_token','Can delete Token');
INSERT INTO "auth_permission" VALUES(46,16,'add_expiringtoken','Can add Token');
INSERT INTO "auth_permission" VALUES(47,16,'change_expiringtoken','Can change Token');
INSERT INTO "auth_permission" VALUES(48,16,'delete_expiringtoken','Can delete Token');
INSERT INTO "auth_permission" VALUES(49,17,'add_app','Can add app');
INSERT INTO "auth_permission" VALUES(50,17,'change_app','Can change app');
INSERT INTO "auth_permission" VALUES(51,17,'delete_app','Can delete app');
INSERT INTO "auth_permission" VALUES(52,18,'add_dept','Can add dept');
INSERT INTO "auth_permission" VALUES(53,18,'change_dept','Can change dept');
INSERT INTO "auth_permission" VALUES(54,18,'delete_dept','Can delete dept');
INSERT INTO "auth_permission" VALUES(55,19,'add_deptmember','Can add dept member');
INSERT INTO "auth_permission" VALUES(56,19,'change_deptmember','Can change dept member');
INSERT INTO "auth_permission" VALUES(57,19,'delete_deptmember','Can delete dept member');
INSERT INTO "auth_permission" VALUES(58,20,'add_deptperm','Can add dept perm');
INSERT INTO "auth_permission" VALUES(59,20,'change_deptperm','Can change dept perm');
INSERT INTO "auth_permission" VALUES(60,20,'delete_deptperm','Can delete dept perm');
INSERT INTO "auth_permission" VALUES(61,21,'add_dingdept','Can add ding dept');
INSERT INTO "auth_permission" VALUES(62,21,'change_dingdept','Can change ding dept');
INSERT INTO "auth_permission" VALUES(63,21,'delete_dingdept','Can delete ding dept');
INSERT INTO "auth_permission" VALUES(64,22,'add_dinguser','Can add ding user');
INSERT INTO "auth_permission" VALUES(65,22,'change_dinguser','Can change ding user');
INSERT INTO "auth_permission" VALUES(66,22,'delete_dinguser','Can delete ding user');
INSERT INTO "auth_permission" VALUES(67,23,'add_group','Can add group');
INSERT INTO "auth_permission" VALUES(68,23,'change_group','Can change group');
INSERT INTO "auth_permission" VALUES(69,23,'delete_group','Can delete group');
INSERT INTO "auth_permission" VALUES(70,24,'add_groupmember','Can add group member');
INSERT INTO "auth_permission" VALUES(71,24,'change_groupmember','Can change group member');
INSERT INTO "auth_permission" VALUES(72,24,'delete_groupmember','Can delete group member');
INSERT INTO "auth_permission" VALUES(73,25,'add_groupperm','Can add group perm');
INSERT INTO "auth_permission" VALUES(74,25,'change_groupperm','Can change group perm');
INSERT INTO "auth_permission" VALUES(75,25,'delete_groupperm','Can delete group perm');
INSERT INTO "auth_permission" VALUES(76,26,'add_perm','Can add perm');
INSERT INTO "auth_permission" VALUES(77,26,'change_perm','Can change perm');
INSERT INTO "auth_permission" VALUES(78,26,'delete_perm','Can delete perm');
INSERT INTO "auth_permission" VALUES(79,27,'add_posixuser','Can add posix user');
INSERT INTO "auth_permission" VALUES(80,27,'change_posixuser','Can change posix user');
INSERT INTO "auth_permission" VALUES(81,27,'delete_posixuser','Can delete posix user');
INSERT INTO "auth_permission" VALUES(82,28,'add_user','Can add user');
INSERT INTO "auth_permission" VALUES(83,28,'change_user','Can change user');
INSERT INTO "auth_permission" VALUES(84,28,'delete_user','Can delete user');
INSERT INTO "auth_permission" VALUES(85,29,'add_userperm','Can add user perm');
INSERT INTO "auth_permission" VALUES(86,29,'change_userperm','Can change user perm');
INSERT INTO "auth_permission" VALUES(87,29,'delete_userperm','Can delete user perm');
INSERT INTO "auth_permission" VALUES(88,30,'add_dinggroup','Can add ding group');
INSERT INTO "auth_permission" VALUES(89,30,'change_dinggroup','Can change ding group');
INSERT INTO "auth_permission" VALUES(90,30,'delete_dinggroup','Can delete ding group');
INSERT INTO "auth_permission" VALUES(91,31,'add_oauthapp','Can add o auth app');
INSERT INTO "auth_permission" VALUES(92,31,'change_oauthapp','Can change o auth app');
INSERT INTO "auth_permission" VALUES(93,31,'delete_oauthapp','Can delete o auth app');
INSERT INTO "auth_permission" VALUES(94,32,'add_dingconfig','Can add ding config');
INSERT INTO "auth_permission" VALUES(95,32,'change_dingconfig','Can change ding config');
INSERT INTO "auth_permission" VALUES(96,32,'delete_dingconfig','Can delete ding config');
INSERT INTO "auth_permission" VALUES(97,33,'add_companyconfig','Can add company config');
INSERT INTO "auth_permission" VALUES(98,33,'change_companyconfig','Can change company config');
INSERT INTO "auth_permission" VALUES(99,33,'delete_companyconfig','Can delete company config');
INSERT INTO "auth_permission" VALUES(100,34,'add_managergroup','Can add manager group');
INSERT INTO "auth_permission" VALUES(101,34,'change_managergroup','Can change manager group');
INSERT INTO "auth_permission" VALUES(102,34,'delete_managergroup','Can delete manager group');
INSERT INTO "auth_permission" VALUES(103,35,'add_customfield','Can add custom field');
INSERT INTO "auth_permission" VALUES(104,35,'change_customfield','Can change custom field');
INSERT INTO "auth_permission" VALUES(105,35,'delete_customfield','Can delete custom field');
INSERT INTO "auth_permission" VALUES(106,36,'add_customuser','Can add custom user');
INSERT INTO "auth_permission" VALUES(107,36,'change_customuser','Can change custom user');
INSERT INTO "auth_permission" VALUES(108,36,'delete_customuser','Can delete custom user');
INSERT INTO "auth_permission" VALUES(109,37,'add_nativefield','Can add native field');
INSERT INTO "auth_permission" VALUES(110,37,'change_nativefield','Can change native field');
INSERT INTO "auth_permission" VALUES(111,37,'delete_nativefield','Can delete native field');
INSERT INTO "auth_permission" VALUES(112,38,'add_invitation','Can add invitation');
INSERT INTO "auth_permission" VALUES(113,38,'change_invitation','Can change invitation');
INSERT INTO "auth_permission" VALUES(114,38,'delete_invitation','Can delete invitation');
INSERT INTO "auth_permission" VALUES(115,39,'add_accountconfig','Can add account config');
INSERT INTO "auth_permission" VALUES(116,39,'change_accountconfig','Can change account config');
INSERT INTO "auth_permission" VALUES(117,39,'delete_accountconfig','Can delete account config');
INSERT INTO "auth_permission" VALUES(118,40,'add_smsconfig','Can add sms config');
INSERT INTO "auth_permission" VALUES(119,40,'change_smsconfig','Can change sms config');
INSERT INTO "auth_permission" VALUES(120,40,'delete_smsconfig','Can delete sms config');
INSERT INTO "auth_permission" VALUES(121,41,'add_log','Can add log');
INSERT INTO "auth_permission" VALUES(122,41,'change_log','Can change log');
INSERT INTO "auth_permission" VALUES(123,41,'delete_log','Can delete log');
INSERT INTO "auth_permission" VALUES(124,42,'add_requestaccesslog','Can add request access log');
INSERT INTO "auth_permission" VALUES(125,42,'change_requestaccesslog','Can change request access log');
INSERT INTO "auth_permission" VALUES(126,42,'delete_requestaccesslog','Can delete request access log');
INSERT INTO "auth_permission" VALUES(127,43,'add_requestdataclientlog','Can add request data client log');
INSERT INTO "auth_permission" VALUES(128,43,'change_requestdataclientlog','Can change request data client log');
INSERT INTO "auth_permission" VALUES(129,43,'delete_requestdataclientlog','Can delete request data client log');
INSERT INTO "auth_permission" VALUES(130,44,'add_emailconfig','Can add email config');
INSERT INTO "auth_permission" VALUES(131,44,'change_emailconfig','Can change email config');
INSERT INTO "auth_permission" VALUES(132,44,'delete_emailconfig','Can delete email config');
INSERT INTO "auth_permission" VALUES(133,45,'add_httpapp','Can add httpapp');
INSERT INTO "auth_permission" VALUES(134,45,'change_httpapp','Can change httpapp');
INSERT INTO "auth_permission" VALUES(135,45,'delete_httpapp','Can delete httpapp');
INSERT INTO "auth_permission" VALUES(136,46,'add_ldapapp','Can add ldapapp');
INSERT INTO "auth_permission" VALUES(137,46,'change_ldapapp','Can change ldapapp');
INSERT INTO "auth_permission" VALUES(138,46,'delete_ldapapp','Can delete ldapapp');
INSERT INTO "auth_permission" VALUES(139,47,'add_alipayconfig','Can add alipay config');
INSERT INTO "auth_permission" VALUES(140,47,'change_alipayconfig','Can change alipay config');
INSERT INTO "auth_permission" VALUES(141,47,'delete_alipayconfig','Can delete alipay config');
INSERT INTO "auth_permission" VALUES(142,48,'add_alipayuser','Can add alipay user');
INSERT INTO "auth_permission" VALUES(143,48,'change_alipayuser','Can change alipay user');
INSERT INTO "auth_permission" VALUES(144,48,'delete_alipayuser','Can delete alipay user');
INSERT INTO "auth_permission" VALUES(145,49,'add_workwechatconfig','Can add work wechat config');
INSERT INTO "auth_permission" VALUES(146,49,'change_workwechatconfig','Can change work wechat config');
INSERT INTO "auth_permission" VALUES(147,49,'delete_workwechatconfig','Can delete work wechat config');
INSERT INTO "auth_permission" VALUES(148,50,'add_workwechatuser','Can add work wechat user');
INSERT INTO "auth_permission" VALUES(149,50,'change_workwechatuser','Can change work wechat user');
INSERT INTO "auth_permission" VALUES(150,50,'delete_workwechatuser','Can delete work wechat user');
INSERT INTO "auth_permission" VALUES(151,51,'add_wechatconfig','Can add wechat config');
INSERT INTO "auth_permission" VALUES(152,51,'change_wechatconfig','Can change wechat config');
INSERT INTO "auth_permission" VALUES(153,51,'delete_wechatconfig','Can delete wechat config');
INSERT INTO "auth_permission" VALUES(154,52,'add_wechatuser','Can add wechat user');
INSERT INTO "auth_permission" VALUES(155,52,'change_wechatuser','Can change wechat user');
INSERT INTO "auth_permission" VALUES(156,52,'delete_wechatuser','Can delete wechat user');
INSERT INTO "auth_permission" VALUES(157,53,'add_qqconfig','Can add qq config');
INSERT INTO "auth_permission" VALUES(158,53,'change_qqconfig','Can change qq config');
INSERT INTO "auth_permission" VALUES(159,53,'delete_qqconfig','Can delete qq config');
INSERT INTO "auth_permission" VALUES(160,54,'add_qquser','Can add qq user');
INSERT INTO "auth_permission" VALUES(161,54,'change_qquser','Can change qq user');
INSERT INTO "auth_permission" VALUES(162,54,'delete_qquser','Can delete qq user');
INSERT INTO "auth_permission" VALUES(163,55,'add_subaccount','Can add sub account');
INSERT INTO "auth_permission" VALUES(164,55,'change_subaccount','Can change sub account');
INSERT INTO "auth_permission" VALUES(165,55,'delete_subaccount','Can delete sub account');
INSERT INTO "auth_permission" VALUES(166,31,'add_application','Can add application');
INSERT INTO "auth_permission" VALUES(167,31,'change_application','Can change application');
INSERT INTO "auth_permission" VALUES(168,31,'delete_application','Can delete application');
INSERT INTO "auth_permission" VALUES(169,57,'add_accesstoken','Can add access token');
INSERT INTO "auth_permission" VALUES(170,57,'change_accesstoken','Can change access token');
INSERT INTO "auth_permission" VALUES(171,57,'delete_accesstoken','Can delete access token');
INSERT INTO "auth_permission" VALUES(172,58,'add_grant','Can add grant');
INSERT INTO "auth_permission" VALUES(173,58,'change_grant','Can change grant');
INSERT INTO "auth_permission" VALUES(174,58,'delete_grant','Can delete grant');
INSERT INTO "auth_permission" VALUES(175,59,'add_refreshtoken','Can add refresh token');
INSERT INTO "auth_permission" VALUES(176,59,'change_refreshtoken','Can change refresh token');
INSERT INTO "auth_permission" VALUES(177,59,'delete_refreshtoken','Can delete refresh token');
INSERT INTO "auth_permission" VALUES(178,60,'add_captchastore','Can add captcha store');
INSERT INTO "auth_permission" VALUES(179,60,'change_captchastore','Can change captcha store');
INSERT INTO "auth_permission" VALUES(180,60,'delete_captchastore','Can delete captcha store');
INSERT INTO "auth_permission" VALUES(181,61,'add_minioconfig','Can add minio config');
INSERT INTO "auth_permission" VALUES(182,61,'change_minioconfig','Can change minio config');
INSERT INTO "auth_permission" VALUES(183,61,'delete_minioconfig','Can delete minio config');
INSERT INTO "auth_permission" VALUES(184,62,'add_storageconfig','Can add storage config');
INSERT INTO "auth_permission" VALUES(185,62,'change_storageconfig','Can change storage config');
INSERT INTO "auth_permission" VALUES(186,62,'delete_storageconfig','Can delete storage config');
INSERT INTO "auth_permission" VALUES(187,63,'add_samlapp','Can add samlapp');
INSERT INTO "auth_permission" VALUES(188,63,'change_samlapp','Can change samlapp');
INSERT INTO "auth_permission" VALUES(189,63,'delete_samlapp','Can delete samlapp');
CREATE TABLE "auth_user" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "password" varchar(128) NOT NULL, "last_login" datetime NULL, "is_superuser" bool NOT NULL, "username" varchar(150) NOT NULL UNIQUE, "first_name" varchar(30) NOT NULL, "email" varchar(254) NOT NULL, "is_staff" bool NOT NULL, "is_active" bool NOT NULL, "date_joined" datetime NOT NULL, "last_name" varchar(150) NOT NULL);
INSERT INTO "auth_user" VALUES(1,'pbkdf2_sha256$100000$Y0SFU6QvBgDV$yDWSE3Av2dNIzZDT3UlLrMLEhno3N6zhsOzgd9ILeq4=',NULL,1,'superadmin','admin','admin@demo.com',1,1,'2019-11-16 11:35:32.999685','admin');
CREATE TABLE "auth_user_groups" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "group_id" integer NOT NULL REFERENCES "auth_group" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "auth_user_user_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "permission_id" integer NOT NULL REFERENCES "auth_permission" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "authtoken_token" ("key" varchar(40) NOT NULL PRIMARY KEY, "created" datetime NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "captcha_captchastore" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "challenge" varchar(32) NOT NULL, "response" varchar(32) NOT NULL, "hashkey" varchar(40) NOT NULL UNIQUE, "expiration" datetime NOT NULL);
CREATE TABLE "corsheaders_corsmodel" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "cors" varchar(255) NOT NULL);
CREATE TABLE "django_admin_log" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "object_id" text NULL, "object_repr" varchar(200) NOT NULL, "action_flag" smallint unsigned NOT NULL, "change_message" text NOT NULL, "content_type_id" integer NULL REFERENCES "django_content_type" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "action_time" datetime NOT NULL);
CREATE TABLE "django_celery_beat_crontabschedule" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "hour" varchar(96) NOT NULL, "day_of_week" varchar(64) NOT NULL, "day_of_month" varchar(124) NOT NULL, "month_of_year" varchar(64) NOT NULL, "minute" varchar(240) NOT NULL);
CREATE TABLE "django_celery_beat_intervalschedule" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "every" integer NOT NULL, "period" varchar(24) NOT NULL);
INSERT INTO "django_celery_beat_intervalschedule" VALUES(1,5,'minutes');
INSERT INTO "django_celery_beat_intervalschedule" VALUES(2,10,'minutes');
CREATE TABLE "django_celery_beat_periodictask" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(200) NOT NULL UNIQUE, "task" varchar(200) NOT NULL, "args" text NOT NULL, "kwargs" text NOT NULL, "queue" varchar(200) NULL, "exchange" varchar(200) NULL, "routing_key" varchar(200) NULL, "expires" datetime NULL, "enabled" bool NOT NULL, "last_run_at" datetime NULL, "total_run_count" integer unsigned NOT NULL, "date_changed" datetime NOT NULL, "description" text NOT NULL, "crontab_id" integer NULL REFERENCES "django_celery_beat_crontabschedule" ("id") DEFERRABLE INITIALLY DEFERRED, "interval_id" integer NULL REFERENCES "django_celery_beat_intervalschedule" ("id") DEFERRABLE INITIALLY DEFERRED, "solar_id" integer NULL REFERENCES "django_celery_beat_solarschedule" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "django_celery_beat_periodictask" VALUES(1,'flush_user_perm_in_db','tasksapp.tasks.flush_user_perm_in_db','[]','{}','perm',NULL,'perm',NULL,0,NULL,0,'2019-11-16 11:35:33.154231','',NULL,1,NULL);
INSERT INTO "django_celery_beat_periodictask" VALUES(2,'flush_user_perm_in_ldap','tasksapp.tasks.flush_user_perm_in_ldap','[]','{}','perm',NULL,'perm',NULL,1,'2019-12-27 11:30:42.514856',38,'2019-12-27 11:32:52.606332','',NULL,1,NULL);
INSERT INTO "django_celery_beat_periodictask" VALUES(3,'aggregate_user_in_ldap_dept','tasksapp.tasks.aggregate_user_in_ldap_dept','[]','{}','dept',NULL,'dept',NULL,1,'2019-12-27 11:30:42.511053',38,'2019-12-27 11:32:52.609745','',NULL,1,NULL);
INSERT INTO "django_celery_beat_periodictask" VALUES(4,'aggregate_user_in_ldap_group','tasksapp.tasks.aggregate_user_in_ldap_group','[]','{}','group',NULL,'group',NULL,1,'2019-12-27 11:30:42.508892',38,'2019-12-27 11:32:52.611483','',NULL,1,NULL);
INSERT INTO "django_celery_beat_periodictask" VALUES(5,'flush_all_perm_in_db','tasksapp.tasks.flush_all_perm_in_db','[]','{}','perm',NULL,'perm',NULL,1,'2019-12-27 11:30:42.516856',38,'2019-12-27 11:32:52.603550','',NULL,1,NULL);
INSERT INTO "django_celery_beat_periodictask" VALUES(6,'rm_unboned_user','taskapp.tasks.rm_unbonded_user_task','[]','{}','dept',NULL,'dept',NULL,1,'2019-12-27 11:30:42.512926',19,'2019-12-27 11:32:52.608015','',NULL,2,NULL);
CREATE TABLE "django_celery_beat_periodictasks" ("ident" smallint NOT NULL PRIMARY KEY, "last_update" datetime NOT NULL);
INSERT INTO "django_celery_beat_periodictasks" VALUES(1,'2019-11-16 11:35:33.207660');
CREATE TABLE "django_celery_beat_solarschedule" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "latitude" decimal NOT NULL, "longitude" decimal NOT NULL, "event" varchar(24) NOT NULL);
CREATE TABLE "django_celery_results_taskresult" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "task_id" varchar(255) NOT NULL UNIQUE, "status" varchar(50) NOT NULL, "content_type" varchar(128) NOT NULL, "content_encoding" varchar(64) NOT NULL, "result" text NULL, "date_done" datetime NOT NULL, "traceback" text NULL, "hidden" bool NOT NULL, "meta" text NULL);
INSERT INTO "django_celery_results_taskresult" VALUES(2,'904a4781-e6b7-4b68-b881-ee7c73a9ffe5','SUCCESS','application/json','utf-8','null','2019-12-27 04:08:32.140933',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(3,'016122fe-eca7-42aa-a246-ce06ab913fc9','SUCCESS','application/json','utf-8','null','2019-12-27 04:08:32.143090',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(4,'5727103d-e90a-485f-84cf-0d02161e748c','SUCCESS','application/json','utf-8','null','2019-12-27 04:08:32.193778',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(5,'a37eb786-1e4a-4caa-a366-197f3be4046b','SUCCESS','application/json','utf-8','null','2019-12-27 04:08:32.196306',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(6,'9350a0c7-69a4-437e-9141-18edb08a56ba','SUCCESS','application/json','utf-8','null','2019-12-27 04:08:38.574718',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(7,'8bf1e567-90ce-4a86-ab9b-43468c79ee21','SUCCESS','application/json','utf-8','null','2019-12-27 04:09:04.422650',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(8,'7326da6d-f1fc-44d2-bbbd-c6cc0b01ae83','SUCCESS','application/json','utf-8','null','2019-12-27 04:09:04.428535',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(9,'1df0a2e6-1366-4472-bf58-8ac524e3dc85','SUCCESS','application/json','utf-8','null','2019-12-27 04:09:04.459410',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(10,'9be3a7cd-e70e-410d-9e45-3e3bea2f3843','SUCCESS','application/json','utf-8','null','2019-12-27 04:09:04.475304',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(12,'7f4cc598-eb9c-42b5-91f1-4a941841a266','SUCCESS','application/json','utf-8','null','2019-12-27 04:13:36.021681',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(13,'5e334781-9021-4203-9859-8d2f87eb4ff6','SUCCESS','application/json','utf-8','null','2019-12-27 04:14:29.013448',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(14,'c91e7fab-f977-49a7-98aa-cf7d739b2ed5','SUCCESS','application/json','utf-8','null','2019-12-27 04:14:29.021234',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(15,'4cc7078e-7230-464b-bd3d-2c6335a6ab3f','SUCCESS','application/json','utf-8','null','2019-12-27 04:14:29.055237',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(16,'8f9255b2-94e8-4293-a5b1-cc81feb06633','SUCCESS','application/json','utf-8','null','2019-12-27 04:14:29.067483',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(17,'03dc1de8-b8c8-4cf6-9f9b-989cb85c9924','SUCCESS','application/json','utf-8','null','2019-12-27 04:15:03.338724',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(18,'1b3dc509-d611-4e66-8b53-ceb2dcbbf170','SUCCESS','application/json','utf-8','null','2019-12-27 04:15:03.345226',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(19,'c9c6bdab-a498-4daf-8852-d5eb1d895c29','SUCCESS','application/json','utf-8','null','2019-12-27 04:15:03.374881',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(20,'4fd9897a-d4d3-4382-a34a-31b183317aa0','SUCCESS','application/json','utf-8','null','2019-12-27 04:15:03.385322',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(22,'71362a23-504d-4b64-9df0-5fae824b494f','SUCCESS','application/json','utf-8','null','2019-12-27 09:06:02.514990',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(24,'82f4cb56-a517-4eb9-ba91-f12fdce7d2c4','SUCCESS','application/json','utf-8','null','2019-12-27 09:11:00.684476',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(26,'b84fff7f-61fd-4e03-9190-af5cfacce6be','SUCCESS','application/json','utf-8','null','2019-12-27 09:16:02.178555',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(27,'2f005363-26af-4072-89f8-b445d3178897','SUCCESS','application/json','utf-8','null','2019-12-27 09:19:15.143327',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(28,'fb3cdd63-e47d-42e8-89bf-02600c544486','SUCCESS','application/json','utf-8','null','2019-12-27 09:19:15.147108',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(30,'19bf7a15-800e-4c9e-910a-8dd5c9324bdf','SUCCESS','application/json','utf-8','null','2019-12-27 09:21:02.936484',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(32,'5cf1b118-63e6-4b5a-8f26-8bb7fd976073','SUCCESS','application/json','utf-8','null','2019-12-27 09:26:01.901842',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(34,'24aa77ba-786f-4877-a23a-cdb8ba555cc1','SUCCESS','application/json','utf-8','null','2019-12-27 09:31:00.605837',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(36,'5b865cf8-01fe-4ff7-be0d-68b0a651ef0e','SUCCESS','application/json','utf-8','null','2019-12-27 09:36:01.159561',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(38,'6d541922-b710-4310-8c26-bcf28f2a3d47','SUCCESS','application/json','utf-8','null','2019-12-27 09:41:00.991343',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(40,'38f9686c-e889-48e0-8e2f-914a7c79cfb0','SUCCESS','application/json','utf-8','null','2019-12-27 10:56:03.764267',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(42,'f96749fa-3313-4313-9e18-50d5b965a2f1','SUCCESS','application/json','utf-8','null','2019-12-27 11:01:01.731238',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(43,'79ae6096-09e4-4700-86d3-0461a4cdb220','SUCCESS','application/json','utf-8','null','2019-12-27 11:01:43.390536',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(44,'75316e8e-9dcd-4901-8bdf-83016a409919','SUCCESS','application/json','utf-8','null','2019-12-27 11:02:13.172562',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(45,'a1bdcdbf-c9cd-49ce-b25d-67a48db994a6','SUCCESS','application/json','utf-8','null','2019-12-27 11:02:34.712741',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(46,'40cdfac3-bd74-4163-aab5-482db75e0362','SUCCESS','application/json','utf-8','null','2019-12-27 11:02:53.281459',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(47,'699edd76-066b-4b12-8c24-2aa073e66ac3','SUCCESS','application/json','utf-8','null','2019-12-27 11:03:10.795772',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(48,'6dea4826-3154-4d07-976c-085555133b75','SUCCESS','application/json','utf-8','null','2019-12-27 11:03:32.605245',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(49,'14150b7c-8afc-48a4-8a88-d6a89c0a41fb','SUCCESS','application/json','utf-8','null','2019-12-27 11:03:48.753142',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(50,'e0595fe1-3a86-4706-9080-f479bb20b216','SUCCESS','application/json','utf-8','null','2019-12-27 11:04:07.111433',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(51,'ca70621d-d510-4919-b535-cb90f5f2e41c','SUCCESS','application/json','utf-8','null','2019-12-27 11:04:24.010749',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(52,'0e374ebb-de16-40be-a899-5775cf7aa6e7','SUCCESS','application/json','utf-8','null','2019-12-27 11:04:39.869279',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(53,'480e4561-7296-4678-a220-c1400d7fc914','SUCCESS','application/json','utf-8','null','2019-12-27 11:04:56.513371',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(54,'1213c41f-0e62-4264-9107-f302111ac4e3','SUCCESS','application/json','utf-8','null','2019-12-27 11:05:12.283482',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(55,'59fda9cd-d914-4ad1-890d-badea55ffb6b','SUCCESS','application/json','utf-8','null','2019-12-27 11:05:31.483619',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(57,'de556751-b344-4c73-ae80-99373a295fa0','SUCCESS','application/json','utf-8','null','2019-12-27 11:05:47.586045',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(58,'f7651f8f-ebfe-4899-be0d-e10268fba13c','SUCCESS','application/json','utf-8','null','2019-12-27 11:06:04.685239',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(59,'7a96c212-2cab-4bba-8e6c-ec0ce1521611','SUCCESS','application/json','utf-8','null','2019-12-27 11:06:05.140808',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(60,'f48475d9-bfd6-475b-80d9-16f667a64611','SUCCESS','application/json','utf-8','null','2019-12-27 11:06:23.653284',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(61,'63748afe-7731-458d-ad98-940154ee2962','SUCCESS','application/json','utf-8','null','2019-12-27 11:06:39.394334',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(62,'79db1de2-bdfb-4ebd-80b6-8f56d84da154','SUCCESS','application/json','utf-8','null','2019-12-27 11:06:56.402324',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(63,'07e47475-55b1-4b0e-a9ec-813a18f31560','SUCCESS','application/json','utf-8','null','2019-12-27 11:07:33.984388',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(64,'10aa72b6-9c29-4db7-802f-3c99ad60a139','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:00.219950',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(65,'a71f2163-57a1-488b-9b89-ca0af93d34c7','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:00.222173',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(66,'7cd8273e-3499-4a06-a4ea-17d5584d88c2','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:00.219945',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(67,'a7512d22-efdf-41e8-a226-6ab80d284f7f','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:00.250257',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(68,'797779e7-9f10-464b-aac0-42f2a0f651ef','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:07.488258',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(69,'08a77de2-a95e-4602-8687-82a780a7b429','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:07.489170',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(70,'b300a226-d3d9-4286-ab13-0ad1f7afacc0','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:07.490855',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(71,'bd72ff6e-0826-44c3-b778-6770239d574f','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:07.502979',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(72,'4a6dadec-ed37-4c26-8026-89f45ef4196b','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:13.690040',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(73,'74f85ff2-52c6-44ec-b807-b95830e09ff4','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:13.680594',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(74,'4a821bf9-92bf-43f6-9624-2423e6299f7b','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:13.705046',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(75,'2faad9c2-729d-4247-8189-d05872a7c1a5','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:13.707900',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(76,'701dfe04-9c01-43a6-b60d-69573baed6e2','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:20.392522',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(77,'0b7a2842-226a-4996-ada3-e98ecb1df6e8','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:20.396258',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(78,'c0c72d01-707e-4476-88e4-eab4a41ab1a4','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:20.398644',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(79,'d4acd66d-9b7b-4cea-a06a-c568c035824a','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:20.411940',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(80,'c68d3482-be91-4370-beb8-b3f222e354ad','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:28.683141',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(81,'fc1cb22b-4754-4a98-b77e-0ce66ba3daec','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:28.693447',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(82,'c6082348-f1a4-494f-a48c-845a2080871f','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:28.699334',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(83,'d947f6b5-5a22-41f2-ba08-1ad107d686f2','SUCCESS','application/json','utf-8','null','2019-12-27 11:08:28.704073',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(84,'c24b4da2-10db-434a-957a-7ef145d71271','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:03.483476',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(85,'23da92ca-1f5b-4eb2-95d7-94c0501d0832','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:03.478852',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(86,'1f9d83c0-313f-4e83-8262-b73a3550b182','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:03.492280',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(87,'f3210c14-8176-4a9b-b178-fd3dabf92bdb','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:03.507712',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(88,'cf1724ea-353f-4f06-b1b5-5aa2eac04dc3','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:23.536502',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(89,'e2a59f14-673f-4484-820e-fc1b1a99df5d','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:23.550259',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(90,'d641df6b-3acb-4afa-aed6-b6e8f5d45242','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:23.536480',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(91,'e137b942-d6ba-4eac-b8b4-bd2021499768','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:23.560909',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(92,'a6c3d76a-5e6a-4da1-a643-705dae487d4e','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:37.966329',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(93,'657fc066-e9d8-465c-afff-3bfc0e727ca0','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:37.958969',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(94,'85199e45-e172-4ed4-a34a-f8f7fefe745b','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:37.957024',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(95,'b09da394-eb33-4112-9dcb-81979376eab3','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:37.982999',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(96,'5765bd41-c263-46d9-98d3-6c099c64837b','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:51.830990',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(97,'accf818e-3426-458b-aac0-95314cbacc25','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:51.832051',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(98,'70d02f5f-1c10-45ec-8a7d-b445073f474a','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:51.823591',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(99,'23c7f73e-85de-4b10-b670-8e3227f3ac67','SUCCESS','application/json','utf-8','null','2019-12-27 11:09:51.847225',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(100,'eafc5ee0-9906-4e25-9915-b568c372c402','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:08.545772',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(101,'f54ab76b-3b66-48fd-9d0b-9f0cac1b5f4f','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:08.555791',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(102,'180de9df-882a-41fd-bf58-2e3e5f5efc30','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:08.545287',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(103,'a5c340fb-12a8-4d5b-bd5a-fd2fb3eed7d9','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:08.568291',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(104,'a9fb4cbb-a256-45b3-9d1f-7687226cbeb8','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:27.378005',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(105,'48ae826f-6043-47b6-bbca-3264a40d4d47','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:27.367333',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(106,'78f3eb04-1efe-47e5-8212-0f376ebb4ba2','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:27.385373',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(107,'b63aff76-5c37-44ed-b334-e62d1aa85dc1','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:27.397230',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(109,'baef3795-83a4-4814-bd38-199272582301','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:50.218648',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(110,'aae4c286-564d-42d2-8fbf-b3710d576413','SUCCESS','application/json','utf-8','null','2019-12-27 11:10:50.223618',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(111,'d557e22b-7468-4cb5-8716-e2f9ec866a5c','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:00.381690',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(112,'61bda3da-b11e-40ea-b45c-31dd1ef477f2','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:00.387055',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(113,'188fbdc7-0c06-4a33-a746-40c98c7bad07','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:06.468797',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(114,'aa3a814f-ed14-4fec-b70b-219fc22c1e4b','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:09.493969',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(115,'cb707289-fd7b-48fd-bec7-e4cf7eb67dbc','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:09.500134',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(116,'8cf34ac1-931c-4697-8a1e-c93d793829c7','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:17.425552',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(117,'20096d45-095c-49ae-8d46-f822f8ba8462','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:17.429174',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(118,'a63b0ef0-6314-4a3d-8c09-256576feff01','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:31.465732',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(119,'c818407f-1548-4809-aa02-5fe4ba4b4e96','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:31.468872',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(120,'323febdc-d1e2-485a-ab35-c6f61d1c24f1','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:41.050547',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(121,'f0ca763f-bf77-4cf1-b2be-7978501c1adf','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:41.055370',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(122,'f870e02c-7fb5-463d-b148-2eb24cc78a4d','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:50.141554',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(123,'58ed54a3-46be-4570-a7cd-789282557c5d','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:50.146161',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(124,'94450fa8-1074-4702-801b-b32cb9ae8c72','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:58.610025',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(125,'391bb6b4-b253-4026-9177-25efe66eafb1','SUCCESS','application/json','utf-8','null','2019-12-27 11:11:58.614981',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(126,'89e7745a-b739-40f5-ae72-ad4fc83d7a69','SUCCESS','application/json','utf-8','null','2019-12-27 11:12:11.313543',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(127,'6db900d3-8f50-4e4b-a75a-cd789ce177fd','SUCCESS','application/json','utf-8','null','2019-12-27 11:12:11.317793',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(128,'34635c0a-f4cc-44c0-a931-7b2b0c8296d8','SUCCESS','application/json','utf-8','null','2019-12-27 11:12:20.436690',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(129,'3d9d1d92-4cdf-43c2-b5bb-7e419ed8411e','SUCCESS','application/json','utf-8','null','2019-12-27 11:12:20.441560',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(130,'66f07245-5037-4afc-a5ca-00f48a5969e7','SUCCESS','application/json','utf-8','null','2019-12-27 11:12:29.097359',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(131,'9ed3e153-605f-4110-9600-8a4b89fee1af','SUCCESS','application/json','utf-8','null','2019-12-27 11:12:29.101773',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(132,'4601ee44-ef37-4ea9-89e3-1aa69dc58cc7','SUCCESS','application/json','utf-8','null','2019-12-27 11:12:37.096563',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(133,'96a10f29-6913-48db-8336-8f3cf4b14b5e','SUCCESS','application/json','utf-8','null','2019-12-27 11:12:37.099649',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(134,'dae63fc4-7dcc-477a-bb72-4b1f3da79c25','SUCCESS','application/json','utf-8','null','2019-12-27 11:14:52.921522',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(136,'66dbad9f-3882-4784-9a17-89ec61be29d5','SUCCESS','application/json','utf-8','null','2019-12-27 11:16:07.834661',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(138,'63dbf4ad-2e4f-4579-aa26-5cd7350b20c4','SUCCESS','application/json','utf-8','null','2019-12-27 11:21:07.576545',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(140,'07841dd5-7c2c-48ea-940c-7e1d7392091a','SUCCESS','application/json','utf-8','null','2019-12-27 11:26:07.212442',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(142,'5ac6fca3-5af9-4ea8-82d6-8f8a7aaffa4d','SUCCESS','application/json','utf-8','null','2019-12-27 11:31:07.644155',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(143,'b4707816-697e-4fe3-82be-2febb0e7a080','SUCCESS','application/json','utf-8','null','2019-12-27 11:31:32.485555',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(144,'0f44efca-e3f8-4d4d-8f4d-44aa09d7590b','SUCCESS','application/json','utf-8','null','2019-12-27 11:31:32.485662',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(145,'9b1d6d4a-3af5-4db3-a241-e2dddad93ec1','SUCCESS','application/json','utf-8','null','2019-12-27 11:31:32.473861',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(146,'52a990b2-8782-4717-a88e-33ba49c5e2db','SUCCESS','application/json','utf-8','null','2019-12-27 11:31:32.499970',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(147,'679d0a71-4113-422d-82ec-e4ad27d8f5ca','SUCCESS','application/json','utf-8','null','2019-12-27 11:31:51.953515',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(148,'59fac3e3-d3df-47b5-b73f-c70eaa4c88af','SUCCESS','application/json','utf-8','null','2019-12-27 11:31:51.964417',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(149,'cf853256-315d-4ef2-a474-0aea9fa75b4d','SUCCESS','application/json','utf-8','null','2019-12-27 11:31:51.972516',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(150,'c9b4ab25-40be-49be-9cba-40924e0851f5','SUCCESS','application/json','utf-8','null','2019-12-27 11:31:51.979866',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(151,'b700d118-5f7d-481f-8112-835087aa6860','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:05.833998',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(152,'95068bdc-eb8f-4b1a-b08c-91afe62754ce','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:05.834817',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(153,'7f9190f2-d617-471f-9427-7c59ab0326e3','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:05.834977',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(154,'8ed4d90c-4add-421b-807d-2731dc8779cd','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:05.846577',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(155,'75ab8cd6-3116-4e44-8dce-0daf6f09097a','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:25.916630',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(156,'02775ed9-f3f4-4101-9eb9-8abc662fedf6','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:25.923686',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(157,'ec02ec4b-7d24-4ab5-a935-815145d0e725','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:25.911515',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(158,'c7df572b-ecfd-49cb-af5e-d6912f54f4a1','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:25.938498',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(159,'ee54d4c6-d954-40c8-a063-661cc67a18d5','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:45.188506',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(160,'6b3dce67-ddac-4f90-8ac7-cefacc683925','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:45.199165',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(161,'6ec87919-ae72-43bd-990b-88cf3acb98b0','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:45.187825',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(162,'fb48b139-822f-43cb-84f1-83d08419733e','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:45.215423',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(163,'66f2f4a5-4f42-4d70-84db-f8882e00858a','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:58.920453',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(164,'87cc0aa0-77b1-44c9-bf6c-2a58d86e2e13','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:58.917321',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(165,'89c091ff-9122-4bbf-b536-9e3abbc6dfc8','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:58.936225',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(166,'2f29a8cb-c149-4d70-ae44-fb4074a24ae1','SUCCESS','application/json','utf-8','null','2019-12-27 11:32:58.942188',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(167,'7852b454-a36f-455c-a57b-ed3beefb702f','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:12.348689',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(168,'956b1545-fff1-48e8-86dc-b1a7fc290183','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:12.348843',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(169,'abb77eb2-947b-4ade-9e88-044840475729','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:12.330823',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(170,'ba68e36f-351d-478d-85dc-cabd725d009e','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:12.330771',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(171,'2cfe5357-34fb-4f7c-a4e8-d60b944a499d','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:25.109954',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(172,'7ec5ec0b-3e76-4d23-bbd4-a8daec1e7979','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:25.110462',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(173,'4ecce338-8c0f-4aee-b9fe-79c5c906fa06','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:25.131702',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(174,'76c55f3d-aa09-4827-a90a-ee9cfbbeef56','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:25.134496',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(175,'2cdfaaa0-c7e4-4e83-8bc7-03f06ee569a0','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:39.588311',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(176,'024d2bb3-11db-4d29-8a5b-e3f6a2e73912','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:39.589881',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(177,'772f7020-2836-46b7-a8ef-05a10a984c20','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:39.577607',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(178,'f1f089ec-4ac2-4627-9d78-e8b7992e3564','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:39.603583',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(179,'415eddb2-2ff9-44a5-ba0d-6cd016af30a2','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:54.938062',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(180,'204bedb9-2ebb-475e-9d98-c85f17e29f51','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:54.948114',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(181,'a1c95119-2a72-4a42-9f36-ade430fbdbff','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:54.950710',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(182,'5dcb161e-9069-4261-8c57-96d73a51a7b7','SUCCESS','application/json','utf-8','null','2019-12-27 11:33:54.963688',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(183,'d3b97224-0a49-4443-b383-ffcbe653d61b','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:12.637399',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(184,'789ceefe-01b1-4696-9b98-cea8c40f0c6a','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:12.639790',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(185,'42897c23-8852-4bcf-96b1-b8d2a6b6cae9','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:12.650673',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(186,'83ae7b4d-927e-4a26-b290-c8d4093f7354','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:12.662553',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(187,'3cffbd87-fb00-41cb-8cd1-143b4f0ce6d5','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:27.399700',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(188,'c1dbc2bc-a028-479e-8aba-b92a26af6f82','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:27.400048',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(189,'7d54302b-beb2-46c5-bcb2-82de0c4ed29b','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:27.385689',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(190,'c84bf591-3db6-4828-a0b6-78e702639b15','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:27.390581',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(191,'66b4cc39-a7ca-4fc7-aa0f-9c9866be9dab','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:45.366605',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(192,'875973c3-0c8c-4cb3-b97d-7f3023960e3b','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:45.362660',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(193,'336e398b-9b15-41a7-9ce9-99bc43a51ba2','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:45.376413',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(194,'46135ee3-b4ee-4d90-949e-61b29194a4f6','SUCCESS','application/json','utf-8','null','2019-12-27 11:34:45.391814',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(195,'d8846575-d10a-4204-a60a-c89ca6782fb6','SUCCESS','application/json','utf-8','null','2019-12-27 11:35:02.961769',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(196,'be6d56ab-8ee4-489e-9ebc-390add28d050','SUCCESS','application/json','utf-8','null','2019-12-27 11:35:02.944767',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(197,'1ea2c8cd-9cb8-43a1-ad56-51e2bf248665','SUCCESS','application/json','utf-8','null','2019-12-27 11:35:02.953769',NULL,0,'{"children": []}');
INSERT INTO "django_celery_results_taskresult" VALUES(198,'449f9fdd-6f56-48f1-8925-27cc5991971f','SUCCESS','application/json','utf-8','null','2019-12-27 11:35:02.974153',NULL,0,'{"children": []}');
CREATE TABLE "django_content_type" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app_label" varchar(100) NOT NULL, "model" varchar(100) NOT NULL);
INSERT INTO "django_content_type" VALUES(1,'admin','logentry');
INSERT INTO "django_content_type" VALUES(2,'auth','permission');
INSERT INTO "django_content_type" VALUES(3,'auth','group');
INSERT INTO "django_content_type" VALUES(4,'auth','user');
INSERT INTO "django_content_type" VALUES(5,'contenttypes','contenttype');
INSERT INTO "django_content_type" VALUES(6,'sessions','session');
INSERT INTO "django_content_type" VALUES(7,'sites','site');
INSERT INTO "django_content_type" VALUES(8,'django_celery_results','taskresult');
INSERT INTO "django_content_type" VALUES(9,'django_celery_beat','crontabschedule');
INSERT INTO "django_content_type" VALUES(10,'django_celery_beat','intervalschedule');
INSERT INTO "django_content_type" VALUES(11,'django_celery_beat','periodictask');
INSERT INTO "django_content_type" VALUES(12,'django_celery_beat','periodictasks');
INSERT INTO "django_content_type" VALUES(13,'django_celery_beat','solarschedule');
INSERT INTO "django_content_type" VALUES(14,'corsheaders','corsmodel');
INSERT INTO "django_content_type" VALUES(15,'authtoken','token');
INSERT INTO "django_content_type" VALUES(16,'drf_expiring_authtoken','expiringtoken');
INSERT INTO "django_content_type" VALUES(17,'oneid_meta','app');
INSERT INTO "django_content_type" VALUES(18,'oneid_meta','dept');
INSERT INTO "django_content_type" VALUES(19,'oneid_meta','deptmember');
INSERT INTO "django_content_type" VALUES(20,'oneid_meta','deptperm');
INSERT INTO "django_content_type" VALUES(21,'oneid_meta','dingdept');
INSERT INTO "django_content_type" VALUES(22,'oneid_meta','dinguser');
INSERT INTO "django_content_type" VALUES(23,'oneid_meta','group');
INSERT INTO "django_content_type" VALUES(24,'oneid_meta','groupmember');
INSERT INTO "django_content_type" VALUES(25,'oneid_meta','groupperm');
INSERT INTO "django_content_type" VALUES(26,'oneid_meta','perm');
INSERT INTO "django_content_type" VALUES(27,'oneid_meta','posixuser');
INSERT INTO "django_content_type" VALUES(28,'oneid_meta','user');
INSERT INTO "django_content_type" VALUES(29,'oneid_meta','userperm');
INSERT INTO "django_content_type" VALUES(30,'oneid_meta','dinggroup');
INSERT INTO "django_content_type" VALUES(31,'oauth2_provider','application');
INSERT INTO "django_content_type" VALUES(32,'oneid_meta','dingconfig');
INSERT INTO "django_content_type" VALUES(33,'oneid_meta','companyconfig');
INSERT INTO "django_content_type" VALUES(34,'oneid_meta','managergroup');
INSERT INTO "django_content_type" VALUES(35,'oneid_meta','customfield');
INSERT INTO "django_content_type" VALUES(36,'oneid_meta','customuser');
INSERT INTO "django_content_type" VALUES(37,'oneid_meta','nativefield');
INSERT INTO "django_content_type" VALUES(38,'oneid_meta','invitation');
INSERT INTO "django_content_type" VALUES(39,'oneid_meta','accountconfig');
INSERT INTO "django_content_type" VALUES(40,'oneid_meta','smsconfig');
INSERT INTO "django_content_type" VALUES(41,'oneid_meta','log');
INSERT INTO "django_content_type" VALUES(42,'oneid_meta','requestaccesslog');
INSERT INTO "django_content_type" VALUES(43,'oneid_meta','requestdataclientlog');
INSERT INTO "django_content_type" VALUES(44,'oneid_meta','emailconfig');
INSERT INTO "django_content_type" VALUES(45,'oneid_meta','httpapp');
INSERT INTO "django_content_type" VALUES(46,'oneid_meta','ldapapp');
INSERT INTO "django_content_type" VALUES(47,'oneid_meta','alipayconfig');
INSERT INTO "django_content_type" VALUES(48,'oneid_meta','alipayuser');
INSERT INTO "django_content_type" VALUES(49,'oneid_meta','workwechatconfig');
INSERT INTO "django_content_type" VALUES(50,'oneid_meta','workwechatuser');
INSERT INTO "django_content_type" VALUES(51,'oneid_meta','wechatconfig');
INSERT INTO "django_content_type" VALUES(52,'oneid_meta','wechatuser');
INSERT INTO "django_content_type" VALUES(53,'oneid_meta','qqconfig');
INSERT INTO "django_content_type" VALUES(54,'oneid_meta','qquser');
INSERT INTO "django_content_type" VALUES(55,'oneid_meta','subaccount');
INSERT INTO "django_content_type" VALUES(56,'oneid_meta','oauthapp');
INSERT INTO "django_content_type" VALUES(57,'oauth2_provider','accesstoken');
INSERT INTO "django_content_type" VALUES(58,'oauth2_provider','grant');
INSERT INTO "django_content_type" VALUES(59,'oauth2_provider','refreshtoken');
INSERT INTO "django_content_type" VALUES(60,'captcha','captchastore');
INSERT INTO "django_content_type" VALUES(61,'oneid_meta','minioconfig');
INSERT INTO "django_content_type" VALUES(62,'oneid_meta','storageconfig');
INSERT INTO "django_content_type" VALUES(63,'oneid_meta','samlapp');
CREATE TABLE "django_session" ("session_key" varchar(40) NOT NULL PRIMARY KEY, "session_data" text NOT NULL, "expire_date" datetime NOT NULL);
CREATE TABLE "django_site" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(50) NOT NULL, "domain" varchar(100) NOT NULL UNIQUE);
INSERT INTO "django_site" VALUES(1,'','');
CREATE TABLE "domain_component" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(128) NOT NULL, "dc" varchar(128) NOT NULL);
INSERT INTO "domain_component" VALUES(1,'example','example');
CREATE TABLE "drf_expiring_authtoken_expiringtoken" ("key" varchar(40) NOT NULL PRIMARY KEY, "created" datetime NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('db00ccf6b775601d49f4cb1ac06c63cdc34b90e9','2019-11-16 09:34:30.534027',2);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('b18aad7ef2a680209c0396551842bb32a4e279e2','2019-11-16 09:35:05.955569',3);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('d80aa32489e0641e1d7934a91ac0e8d5be26f8ef','2019-11-16 10:34:07.528921',13);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('530af3d67e8c9ab359f07988cfcb34c974f0be2a','2019-12-27 11:01:43.386965',15);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('aeb81288f0cdc3e8d8215825fc2efc8abd7d7f28','2019-12-27 11:02:13.168361',16);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('cab2829c682b77af560ce10854769912bedc979e','2019-12-27 11:02:34.707913',17);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('47420422b9e9fa05b08d833849d9f4e0556b2b8f','2019-12-27 11:02:53.277169',18);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('90da3e662e344b82bf28824b77622edfad84b816','2019-12-27 11:03:10.791848',19);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('b9716ed4c2feae58b24b53905efa4fd101f464c9','2019-12-27 11:03:32.602768',20);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('bbd956d74a9c525ef70dade34147c4c48c659a8f','2019-12-27 11:03:48.749778',21);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('43f17913390866c56af46622d8c1e2b315fcfdad','2019-12-27 11:04:07.108256',22);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('c2d5bbc8b2194d7179329cc68bf13ff20c76969d','2019-12-27 11:04:24.007550',23);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('16407639b71bb45b676ef4adeef98369ac3c5e2e','2019-12-27 11:04:39.866364',24);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('85756679bc8411ef8ba0b2e270300758ea0faf77','2019-12-27 11:04:56.510201',25);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('8b63872746c5262ee3ce7e90edbdc7499781fd7f','2019-12-27 11:05:31.479365',27);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('0f908023dfa492a3175be45818c63b9f87e54bc5','2019-12-27 11:05:47.586577',28);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('683598eb58aac5e89a26a08b1bf8325288f632b7','2019-12-27 11:06:04.677245',29);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('d020ff88a18d13bd90078dad9e19b5ab6e8e75ed','2019-12-27 11:06:23.649665',30);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('c98d6be5f5394acdcd3bb25146f87b2fa3a060e9','2019-12-27 11:06:39.391298',31);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('f7951e863a1254725b09290e6d517394610b3d0e','2019-12-27 11:06:56.398822',32);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('e1c48a92413959e6715cd9a3dac2053428764e8a','2019-12-27 11:07:33.980680',33);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('fc2a58be2ac11783a162610f8a3c488f1f6ef1f2','2019-12-27 11:14:52.917976',34);
INSERT INTO "drf_expiring_authtoken_expiringtoken" VALUES('4dfc045f503be7e1bef058c3dbf53663818ff9c8','2019-12-27 11:17:13.605817',1);
CREATE TABLE "ldap_attr_mappings" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(128) NOT NULL, "sel_expr" varchar(512) NOT NULL, "from_tbls" varchar(512) NOT NULL, "join_where" varchar(512) NULL, "create_proc" varchar(512) NULL, "delete_proc" varchar(512) NULL, "param_order" integer NOT NULL, "expect_return" integer NOT NULL, "oc_map_id" integer NOT NULL REFERENCES "ldap_oc_mappings" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "ldap_attr_mappings" VALUES(1,'dc','domain_component.dc','domain_component',NULL,NULL,NULL,3,0,1);
INSERT INTO "ldap_attr_mappings" VALUES(2,'o','organization.o','organization',NULL,NULL,NULL,3,0,2);
INSERT INTO "ldap_attr_mappings" VALUES(3,'ou','organization_unit.ou','organization_unit',NULL,NULL,NULL,3,0,3);
INSERT INTO "ldap_attr_mappings" VALUES(4,'uid','oneid_meta_user.username','oneid_meta_user','oneid_meta_user.is_del=FALSE',NULL,NULL,3,0,4);
INSERT INTO "ldap_attr_mappings" VALUES(5,'cn','oneid_meta_user.username','oneid_meta_user','oneid_meta_user.is_del=FALSE',NULL,NULL,3,0,4);
INSERT INTO "ldap_attr_mappings" VALUES(6,'userPassword','oneid_meta_user.password','oneid_meta_user','oneid_meta_user.is_del=FALSE',NULL,NULL,3,0,4);
CREATE TABLE "ldap_entry_objclasses" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "oc_name" varchar(128) NOT NULL, "entry_id" integer NOT NULL REFERENCES "raw_ldap_entries" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "ldap_entry_objclasses" VALUES(1,'organization',1);
CREATE TABLE "ldap_oc_mappings" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(128) NOT NULL, "keytbl" varchar(128) NOT NULL, "keycol" varchar(128) NOT NULL, "create_proc" varchar(512) NULL, "delete_proc" varchar(512) NULL, "expect_return" integer NOT NULL);
INSERT INTO "ldap_oc_mappings" VALUES(1,'dcObject','domain_component','id',NULL,NULL,0);
INSERT INTO "ldap_oc_mappings" VALUES(2,'organization','organization','id',NULL,NULL,0);
INSERT INTO "ldap_oc_mappings" VALUES(3,'organizationalUnit','organization_unit','id',NULL,NULL,0);
INSERT INTO "ldap_oc_mappings" VALUES(4,'inetOrgPerson','oneid_meta_user','id',NULL,NULL,0);
CREATE TABLE "oauth2_provider_accesstoken" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "token" varchar(255) NOT NULL UNIQUE, "expires" datetime NOT NULL, "scope" text NOT NULL, "application_id" bigint NULL REFERENCES "oauth2_provider_application" ("id") DEFERRABLE INITIALLY DEFERRED, "created" datetime NOT NULL, "updated" datetime NOT NULL, "source_refresh_token_id" bigint NULL UNIQUE REFERENCES "oauth2_provider_refreshtoken" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oauth2_provider_application" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "client_id" varchar(100) NOT NULL UNIQUE, "redirect_uris" text NOT NULL, "authorization_grant_type" varchar(32) NOT NULL, "client_secret" varchar(255) NOT NULL, "name" varchar(255) NOT NULL, "user_id" integer NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED, "skip_authorization" bool NOT NULL, "created" datetime NOT NULL, "updated" datetime NOT NULL, "app_id" integer NULL UNIQUE REFERENCES "oneid_meta_app" ("id") DEFERRABLE INITIALLY DEFERRED, "client_type" varchar(32) NOT NULL);
INSERT INTO "oauth2_provider_application" VALUES(1,'xvg5nRn64JsBTG9PHfb492HUCcYpTfrzhlunEvuT','adad','authorization-code','Q3tkBxt3AuJMVk0ZZfLxXvdM6cSZrxdGYN1SFcq5wAnFmG0E3XtTEp2uvMmshMQKg60xQlYCSnltr9XI8QfvC1tmlkWNUYS6buiJlwsoP5t387Adii224Mjv4bREA8mv','应用一',NULL,0,'2019-11-16 10:11:16.113860','2019-11-16 10:11:16.113890',5,'confidential');
CREATE TABLE "oauth2_provider_grant" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "code" varchar(255) NOT NULL UNIQUE, "expires" datetime NOT NULL, "redirect_uri" varchar(255) NOT NULL, "scope" text NOT NULL, "application_id" bigint NOT NULL REFERENCES "oauth2_provider_application" ("id") DEFERRABLE INITIALLY DEFERRED, "created" datetime NOT NULL, "updated" datetime NOT NULL, "user_id" integer NOT NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oauth2_provider_refreshtoken" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "token" varchar(255) NOT NULL, "access_token_id" bigint NULL UNIQUE REFERENCES "oauth2_provider_accesstoken" ("id") DEFERRABLE INITIALLY DEFERRED, "application_id" bigint NOT NULL REFERENCES "oauth2_provider_application" ("id") DEFERRABLE INITIALLY DEFERRED, "created" datetime NOT NULL, "updated" datetime NOT NULL, "revoked" datetime NULL, "user_id" integer NOT NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_accountconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED, "allow_email" bool NOT NULL, "allow_mobile" bool NOT NULL, "allow_register" bool NOT NULL, "allow_ding_qr" bool NOT NULL, "allow_alipay_qr" bool NOT NULL, "allow_work_wechat_qr" bool NOT NULL, "allow_wechat_qr" bool NOT NULL, "allow_qq_qr" bool NOT NULL);
INSERT INTO "oneid_meta_accountconfig" VALUES(1,'3978b9d7c64e4377b5a2f9362ce45e69',0,1,'2019-12-27 11:01:12.221477','2019-11-16 11:35:31.229229',1,0,1,1,0,0,0,0,0);
CREATE TABLE "oneid_meta_alipayconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "app_id" varchar(255) NOT NULL, "app_private_key" varchar(2048) NOT NULL, "alipay_public_key" varchar(512) NOT NULL, "qr_app_valid" bool NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_alipayuser" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "alipay_user_id" text NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_app" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "uid" varchar(255) NOT NULL, "remark" text NOT NULL, "editable" bool NOT NULL, "allow_any_user" bool NOT NULL, "logo" text NULL, "index" varchar(512) NULL, "name" varchar(255) NOT NULL);
INSERT INTO "oneid_meta_app" VALUES(1,'391653158b5648e785266ea5a0d24667',0,1,'2019-12-27 05:25:41.484632','2019-11-16 11:35:30.491172','oneid','OneID',1,0,'0','','OneID');
INSERT INTO "oneid_meta_app" VALUES(5,'e4495821d62b40e4a0b8090efc4341fa',0,1,'2019-12-27 05:25:41.487426','2019-11-16 10:11:16.111581','yingyongyi','应用一',1,0,'0','','应用一');
INSERT INTO "oneid_meta_app" VALUES(6,'c627fa7c19a34231b5cbff663fc91543',0,1,'2019-12-27 05:25:41.489293','2019-11-16 10:11:32.627220','yingyonger','应用二',1,0,'0','','应用二');
INSERT INTO "oneid_meta_app" VALUES(7,'b023f03a64c94f53b91d164aa9f8dbd6',0,1,'2019-12-27 05:25:41.491419','2019-11-16 10:11:37.902011','yingyongsan','应用三',1,0,'0','','应用三');
INSERT INTO "oneid_meta_app" VALUES(8,'40ba751b57ec42d1a8fa3cc0bdc39ece',0,1,'2019-12-27 05:25:41.493329','2019-11-16 10:11:43.653481','yingyongsi','应用四',1,0,'0','','应用四');
INSERT INTO "oneid_meta_app" VALUES(9,'206e49ca55c349ab8021f63eb8dccc93',0,1,'2019-12-27 05:25:41.495208','2019-11-16 10:11:51.616111','yingyongwu','应用五',1,0,'0','','应用五');
INSERT INTO "oneid_meta_app" VALUES(10,'b37e682548a84343ab25528ea633d2d7',0,1,'2019-12-27 05:25:41.497022','2019-11-16 10:36:53.305293','yingyongliu','应用六',1,0,'0','','应用六');
INSERT INTO "oneid_meta_app" VALUES(11,'02dce153198847128dae5fcb4006d27d',0,1,'2019-12-27 05:25:41.498889','2019-11-16 10:36:59.319673','yingyongqi','应用七',1,0,'0','','应用七');
INSERT INTO "oneid_meta_app" VALUES(12,'e898e7eb5a3a47de8af51d37039201ab',0,1,'2019-12-27 05:25:41.500829','2019-11-16 10:37:06.194073','yingyongba','应用八',1,0,'0','','应用八');
INSERT INTO "oneid_meta_app" VALUES(13,'e238f25cf92e49a7b1e26b7f7cd86f71',0,1,'2019-12-27 05:25:41.502795','2019-11-16 10:37:13.316372','yingyongjiu','应用九',1,0,'0','','应用九');
INSERT INTO "oneid_meta_app" VALUES(14,'c4412876332b42e8904149538fbb2543',0,1,'2019-12-27 05:25:41.504627','2019-11-16 10:37:18.749337','yingyongshi','应用十',1,0,'0','','应用十');
CREATE TABLE "oneid_meta_companyconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "name_cn" varchar(255) NOT NULL, "fullname_cn" varchar(255) NOT NULL, "name_en" varchar(255) NOT NULL, "fullname_en" varchar(255) NOT NULL, "icon" varchar(1024) NOT NULL, "address" varchar(255) NOT NULL, "domain" varchar(255) NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED, "color" varchar(256) NOT NULL);
INSERT INTO "oneid_meta_companyconfig" VALUES(1,'6df851c11f874bbd8acf175214019dff',0,1,'2019-11-16 11:35:30.662171','2019-11-16 11:35:30.662195','','','','','','','',1,'');
CREATE TABLE "oneid_meta_customfield" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "name" varchar(128) NOT NULL, "schema" text NOT NULL, "is_visible" bool NOT NULL, "subject" varchar(128) NOT NULL);
CREATE TABLE "oneid_meta_customuser" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "data" text NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_dept" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "uid" varchar(255) NOT NULL, "name" varchar(255) NOT NULL, "remark" text NOT NULL, "order_no" integer NOT NULL, "node_scope" text NOT NULL, "user_scope" text NOT NULL, "visibility" integer NOT NULL, "parent_id" integer NULL REFERENCES "oneid_meta_dept" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_dept" VALUES(1,'afe256171e6e48b1aef1d6f2496ccf84',0,1,'2019-11-16 11:35:32.810332','2019-11-16 11:35:29.385930','root','部门','所有顶级的部门的父级，可视为整个公司。请勿修改',0,'[]','[]',1,NULL);
INSERT INTO "oneid_meta_dept" VALUES(2,'d6a1146020d94439980dd7d3c374b44a',0,1,'2019-11-16 09:46:20.909245','2019-11-16 09:46:20.901305','bumenyi','部门一（所有人可见）','',7,'[]','[]',1,1);
INSERT INTO "oneid_meta_dept" VALUES(3,'f2e768171b774d2da8a7cc5779a7326a',0,1,'2019-11-16 09:46:33.776286','2019-11-16 09:46:33.771754','bumener','部门二（组内可见下属不可见）','',8,'[]','[]',2,1);
INSERT INTO "oneid_meta_dept" VALUES(4,'70c3a537a5c74f5ea04ab17f342bf400',0,1,'2019-11-16 09:46:54.795461','2019-11-16 09:46:54.787403','bumensan','部门三（组内成员及下属分组可见）','',9,'[]','[]',3,1);
INSERT INTO "oneid_meta_dept" VALUES(5,'fb77c04aa7be4ca8bb2c3d73357df0c8',0,1,'2019-11-16 09:48:52.402955','2019-11-16 09:48:52.397918','bumensisuoyourenbukejian','部门四（所有人不可见）','',10,'[]','[]',5,1);
INSERT INTO "oneid_meta_dept" VALUES(6,'cd83bb2ec92443c4aacd2caa20edc5ce',0,1,'2019-11-16 09:49:31.061620','2019-11-16 09:49:31.057041','bumenwubufenrenkejian','部门五（部分人可见）','',11,'[]','[]',4,1);
INSERT INTO "oneid_meta_dept" VALUES(7,'b503a346be4d4854a8125b1a4d045162',0,1,'2019-11-16 09:50:21.302269','2019-11-16 09:50:21.289583','bumenyiyi','部门一（一）','',0,'[]','[]',1,2);
INSERT INTO "oneid_meta_dept" VALUES(8,'25a0125a8bcd4e4ea7474dc0b7c84aeb',0,1,'2019-11-16 09:50:49.446972','2019-11-16 09:50:49.443991','bumenyier','部门一（二）','',1,'[]','[]',2,2);
INSERT INTO "oneid_meta_dept" VALUES(9,'a1890ba0223c42df8e930ddf6a753acb',0,1,'2019-11-16 09:51:01.681066','2019-11-16 09:51:01.676146','bumenyisan','部门一（三）','',2,'[]','[]',3,2);
INSERT INTO "oneid_meta_dept" VALUES(10,'0c721c7f78174b1e8919189b7042e493',0,1,'2019-11-16 09:51:11.817294','2019-11-16 09:51:11.813012','bumenyisi','部门一（四）','',3,'[]','[]',5,2);
INSERT INTO "oneid_meta_dept" VALUES(11,'b0d4a9a5f2cf4820b76c54f887abcd81',0,1,'2019-11-16 09:51:21.655231','2019-11-16 09:51:21.647212','bumenyiwu','部门一（五）','',4,'[]','[]',4,2);
INSERT INTO "oneid_meta_dept" VALUES(12,'63a33b89a7fa48b9bf43dd87abb196a5',0,1,'2019-11-16 09:51:35.502390','2019-11-16 09:51:35.496278','bumeneryi','部门二（一）','',0,'[]','[]',1,3);
INSERT INTO "oneid_meta_dept" VALUES(13,'9ed667ffd230406b9c1a9da47770d6d3',0,1,'2019-11-16 09:51:44.954357','2019-11-16 09:51:44.946395','bumenerer','部门二（二）','',1,'[]','[]',2,3);
INSERT INTO "oneid_meta_dept" VALUES(14,'b37420c9226645f6bf8a4a8ba569f63b',0,1,'2019-11-16 09:51:55.226276','2019-11-16 09:51:55.218036','bumenersan','部门二（三）','',2,'[]','[]',3,3);
INSERT INTO "oneid_meta_dept" VALUES(15,'519d7484154f499494030c105ad6dd85',0,1,'2019-11-16 09:52:07.241354','2019-11-16 09:52:07.232574','bumenersi','部门二（四）','',3,'[]','[]',5,3);
INSERT INTO "oneid_meta_dept" VALUES(16,'30c037b3ca6946388639d9dda3b42a6c',0,1,'2019-11-16 09:52:19.818882','2019-11-16 09:52:19.810767','bumenerwu','部门二（五）','',4,'[]','[]',4,3);
INSERT INTO "oneid_meta_dept" VALUES(17,'d8bcf3b600244a7baa1620c9b51194c0',0,1,'2019-11-16 10:03:28.514589','2019-11-16 10:03:28.505517','bumensanyi','部门三（一）','',0,'[]','[]',1,4);
INSERT INTO "oneid_meta_dept" VALUES(18,'dc5ac62d882b4624a9df31981a388995',0,1,'2019-11-16 10:03:39.672635','2019-11-16 10:03:39.663841','bumensiyi','部门四（一）','',0,'[]','[]',1,5);
INSERT INTO "oneid_meta_dept" VALUES(19,'5904f6988df5429d9fc3973920f33f93',0,1,'2019-11-16 10:03:52.519549','2019-11-16 10:03:52.510065','bumenwuyi','部门五（一）','',0,'[]','[]',1,6);
INSERT INTO "oneid_meta_dept" VALUES(20,'d280e92636a54e1cb3a958e5a01ade61',0,1,'2019-12-27 11:10:50.140294','2019-12-27 11:10:50.136610','bumensaner','部门三（二）','',1,'[]','[]',2,4);
INSERT INTO "oneid_meta_dept" VALUES(21,'27c1dadf35144e4885508e1e63a430b7',0,1,'2019-12-27 11:11:00.321750','2019-12-27 11:11:00.317452','bumensansan','部门三（三）','',2,'[]','[]',3,4);
INSERT INTO "oneid_meta_dept" VALUES(22,'bf09955400e549ac8efd4b5a2b409ac0',0,1,'2019-12-27 11:11:09.436413','2019-12-27 11:11:09.427952','bumensansi','部门三（四）','',3,'[]','[]',5,4);
INSERT INTO "oneid_meta_dept" VALUES(23,'a3cf054f10fb4c8187bc1eb84a467930',0,1,'2019-12-27 11:11:17.369490','2019-12-27 11:11:17.359648','bumensanwu','部门三（五）','',4,'[]','[]',4,4);
INSERT INTO "oneid_meta_dept" VALUES(24,'8ea6ed1bf8f9481a80b9cedf803154fe',0,1,'2019-12-27 11:11:31.408231','2019-12-27 11:11:31.399238','bumensier','部门四（二）','',1,'[]','[]',2,5);
INSERT INTO "oneid_meta_dept" VALUES(25,'82d0c683266b4011a1a622d63570e227',0,1,'2019-12-27 11:11:40.993005','2019-12-27 11:11:40.984149','bumensisan','部门四（三）','',2,'[]','[]',3,5);
INSERT INTO "oneid_meta_dept" VALUES(26,'367f2f95aeeb4008883f3513a4ea11e9',0,1,'2019-12-27 11:11:50.083028','2019-12-27 11:11:50.074217','bumensisi','部门四（四）','',3,'[]','[]',5,5);
INSERT INTO "oneid_meta_dept" VALUES(27,'2cee98a8e63140199e967e0b58a39aab',0,1,'2019-12-27 11:11:58.555198','2019-12-27 11:11:58.546549','bumensiwu','部门四（五）','',4,'[]','[]',4,5);
INSERT INTO "oneid_meta_dept" VALUES(28,'6671f0b7f6d24bd8b7fef96decc97e5e',0,1,'2019-12-27 11:12:11.257859','2019-12-27 11:12:11.249532','bumenwuer','部门五（二）','',1,'[]','[]',2,6);
INSERT INTO "oneid_meta_dept" VALUES(29,'1661abb8a6c94cbd80ce4357eadcf9d1',0,1,'2019-12-27 11:12:20.380967','2019-12-27 11:12:20.371865','bumenwusan','部门五（三）','',2,'[]','[]',3,6);
INSERT INTO "oneid_meta_dept" VALUES(30,'ecb4455104b144d0aa22ec8edcb02e72',0,1,'2019-12-27 11:12:29.042957','2019-12-27 11:12:29.033620','bumenwusi','部门五（四）','',3,'[]','[]',5,6);
INSERT INTO "oneid_meta_dept" VALUES(31,'ff7687159c834fa2977d2a28a86f811b',0,1,'2019-12-27 11:12:37.036754','2019-12-27 11:12:37.023567','bumenwuwu','部门五（五）','',4,'[]','[]',4,6);
CREATE TABLE "oneid_meta_deptmember" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "owner_id" integer NOT NULL REFERENCES "oneid_meta_dept" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NOT NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED, "order_no" integer NOT NULL);
INSERT INTO "oneid_meta_deptmember" VALUES(1,'7122b8ea60514db99b69e4c157022805',0,1,'2019-11-16 10:13:51.043315','2019-11-16 10:13:51.043345',2,4,0);
INSERT INTO "oneid_meta_deptmember" VALUES(2,'7f092a1c1e174e25a9e3d38769ef3b52',0,1,'2019-11-16 10:14:05.433056','2019-11-16 10:14:05.433087',3,5,0);
INSERT INTO "oneid_meta_deptmember" VALUES(3,'078da6196c8b4a1b9074813e21686420',0,1,'2019-11-16 10:14:18.311593','2019-11-16 10:14:18.311622',4,6,0);
INSERT INTO "oneid_meta_deptmember" VALUES(4,'502ada72fd204feeac65f0effd8613e4',0,1,'2019-11-16 10:14:29.574559','2019-11-16 10:14:29.574587',5,7,0);
INSERT INTO "oneid_meta_deptmember" VALUES(5,'754b76a9b48141e698d5d783a5a245cd',0,1,'2019-11-16 10:14:40.986331','2019-11-16 10:14:40.986356',6,8,0);
INSERT INTO "oneid_meta_deptmember" VALUES(6,'447f70c5d4474767a16eb2625307912d',0,1,'2019-11-16 10:28:34.327169','2019-11-16 10:28:34.327197',7,9,0);
INSERT INTO "oneid_meta_deptmember" VALUES(7,'e439ca318ec14d4a8781f1104cadbfae',0,1,'2019-11-16 10:31:38.508640','2019-11-16 10:31:38.508663',8,10,0);
INSERT INTO "oneid_meta_deptmember" VALUES(8,'57d1b358ec2b48fcb84ac6f55fc49973',0,1,'2019-11-16 10:31:55.522789','2019-11-16 10:31:55.522819',9,11,0);
INSERT INTO "oneid_meta_deptmember" VALUES(9,'1f4b15131e934822a91651b0d0fab0f2',0,1,'2019-11-16 10:32:10.679779','2019-11-16 10:32:10.679806',10,12,0);
INSERT INTO "oneid_meta_deptmember" VALUES(10,'ae6c6747d96c41aeb2b2fba46ffe2921',0,1,'2019-11-16 10:33:09.081659','2019-11-16 10:33:09.081688',11,13,0);
INSERT INTO "oneid_meta_deptmember" VALUES(11,'f445596e508a4213a20783a1ee266dd3',0,1,'2019-12-27 11:09:03.467343','2019-12-27 11:09:03.467387',12,15,0);
INSERT INTO "oneid_meta_deptmember" VALUES(12,'d07eb1162cc449c69df7f63012cba496',0,1,'2019-12-27 11:09:23.525714','2019-12-27 11:09:23.525756',13,16,0);
INSERT INTO "oneid_meta_deptmember" VALUES(13,'37e0e0f6794644768a6057115cd6b7f6',0,1,'2019-12-27 11:09:37.944817','2019-12-27 11:09:37.944854',14,17,0);
INSERT INTO "oneid_meta_deptmember" VALUES(14,'1481082529964e9f8f3689097b7023cb',0,1,'2019-12-27 11:09:51.808918','2019-12-27 11:09:51.808954',15,18,0);
INSERT INTO "oneid_meta_deptmember" VALUES(15,'7e5c477e597e4a59a2f5d5a1dd97143d',0,1,'2019-12-27 11:10:08.532431','2019-12-27 11:10:08.532466',16,19,0);
INSERT INTO "oneid_meta_deptmember" VALUES(16,'c1571962640d4b14bc045358eefa493d',0,1,'2019-12-27 11:10:27.358199','2019-12-27 11:10:27.358242',17,20,0);
INSERT INTO "oneid_meta_deptmember" VALUES(17,'f6e7a0710e3d41438c1fe1c7e3316fb0',0,1,'2019-12-27 11:31:32.460996','2019-12-27 11:31:32.461028',20,21,0);
INSERT INTO "oneid_meta_deptmember" VALUES(18,'0f10930e14144084a0ba9346ec2bb0a8',0,1,'2019-12-27 11:31:51.940036','2019-12-27 11:31:51.940067',21,22,0);
INSERT INTO "oneid_meta_deptmember" VALUES(19,'0a1ce2d7522546728cb2d80b6c57f54e',0,1,'2019-12-27 11:32:05.807285','2019-12-27 11:32:05.807319',22,23,0);
INSERT INTO "oneid_meta_deptmember" VALUES(20,'e0379ef7aa564d588fe6a9026244c7ec',0,1,'2019-12-27 11:32:25.901728','2019-12-27 11:32:25.901760',23,34,0);
INSERT INTO "oneid_meta_deptmember" VALUES(21,'ec02135c59d1424abae4f5dc9ad90998',0,1,'2019-12-27 11:32:45.177886','2019-12-27 11:32:45.177916',18,25,0);
INSERT INTO "oneid_meta_deptmember" VALUES(22,'bd649873d8904acd929efc9ae6fabf45',0,1,'2019-12-27 11:32:58.904831','2019-12-27 11:32:58.904862',24,26,0);
INSERT INTO "oneid_meta_deptmember" VALUES(23,'f664c604508649c29ea6a6ed3435303f',0,1,'2019-12-27 11:33:12.327030','2019-12-27 11:33:12.327060',25,27,0);
INSERT INTO "oneid_meta_deptmember" VALUES(24,'32aec1e713c145209c9c57a1da55e8ca',0,1,'2019-12-27 11:33:25.097364','2019-12-27 11:33:25.097398',26,28,0);
INSERT INTO "oneid_meta_deptmember" VALUES(25,'53734033065e4167a274af1795dc94e0',0,1,'2019-12-27 11:33:39.567527','2019-12-27 11:33:39.567556',27,29,0);
INSERT INTO "oneid_meta_deptmember" VALUES(26,'7d3cf9a1cf05475197585242a67c8420',0,1,'2019-12-27 11:33:54.926484','2019-12-27 11:33:54.926516',19,30,0);
INSERT INTO "oneid_meta_deptmember" VALUES(27,'e4c3349e9cce47f3a733da7a9e996c1e',0,1,'2019-12-27 11:34:12.624039','2019-12-27 11:34:12.624084',28,31,0);
INSERT INTO "oneid_meta_deptmember" VALUES(28,'5be84a024bdd4ec4bb63b499ca2f21d5',0,1,'2019-12-27 11:34:27.377948','2019-12-27 11:34:27.377982',29,32,0);
INSERT INTO "oneid_meta_deptmember" VALUES(29,'26a1984c23684d5c92fd276ccbf11d17',0,1,'2019-12-27 11:34:45.350124','2019-12-27 11:34:45.350160',30,24,0);
INSERT INTO "oneid_meta_deptmember" VALUES(30,'0e74160e7fc440f6b66977a5c89c19ef',0,1,'2019-12-27 11:35:02.936884','2019-12-27 11:35:02.936917',31,33,0);
CREATE TABLE "oneid_meta_deptperm" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "status" integer NOT NULL, "value" bool NOT NULL, "perm_id" integer NOT NULL REFERENCES "oneid_meta_perm" ("id") DEFERRABLE INITIALLY DEFERRED, "owner_id" integer NOT NULL REFERENCES "oneid_meta_dept" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_deptperm" VALUES(1,'9c05ec5f96714f37bbc88af97c2d11cf',0,1,'2019-12-27 11:30:44.882078','2019-11-16 09:46:20.912549',0,0,1,2);
INSERT INTO "oneid_meta_deptperm" VALUES(2,'51564ef0b4464c0687ad35db5b59104e',0,1,'2019-12-27 11:30:44.892707','2019-11-16 09:46:20.914294',0,0,2,2);
INSERT INTO "oneid_meta_deptperm" VALUES(3,'a2914d7ba974496fa776743d4a9a6ef7',0,1,'2019-12-27 11:30:44.902561','2019-11-16 09:46:20.916062',0,0,3,2);
INSERT INTO "oneid_meta_deptperm" VALUES(4,'47077e87d982463ba469f84a4afb2313',0,1,'2019-12-27 11:30:44.912275','2019-11-16 09:46:20.917878',0,0,4,2);
INSERT INTO "oneid_meta_deptperm" VALUES(5,'6a4c9ae53f304c798b9c476e18161ef1',0,1,'2019-12-27 11:30:44.921300','2019-11-16 09:46:20.919245',0,0,5,2);
INSERT INTO "oneid_meta_deptperm" VALUES(6,'d1af3b02ef0f4773ab8ddc2948700e09',0,1,'2019-12-27 11:30:44.929328','2019-11-16 09:46:20.920710',0,0,6,2);
INSERT INTO "oneid_meta_deptperm" VALUES(7,'ab73747ccd904ee48d7f1830d25c89de',0,1,'2019-12-27 11:30:44.938043','2019-11-16 09:46:20.922915',0,0,7,2);
INSERT INTO "oneid_meta_deptperm" VALUES(8,'ec7fcf96f2044ac8a31b31a0678c8d7a',0,1,'2019-12-27 11:30:44.946025','2019-11-16 09:46:20.924679',0,0,8,2);
INSERT INTO "oneid_meta_deptperm" VALUES(9,'977312d6652b4c609c7e42f0b68e6ff7',0,1,'2019-12-27 11:30:44.956159','2019-11-16 09:46:20.926039',0,0,9,2);
INSERT INTO "oneid_meta_deptperm" VALUES(10,'8a6118bd6cca4b31ba8905296cbb7e9b',0,1,'2019-12-27 11:30:44.964829','2019-11-16 09:46:20.927363',0,0,10,2);
INSERT INTO "oneid_meta_deptperm" VALUES(11,'efff6515e6b0452daf6f6e7df9ee84a6',0,1,'2019-12-27 11:30:45.895220','2019-11-16 09:46:33.779100',0,0,1,3);
INSERT INTO "oneid_meta_deptperm" VALUES(12,'33a61d68df064f68989bec9892565bdb',0,1,'2019-12-27 11:30:45.904223','2019-11-16 09:46:33.780574',0,0,2,3);
INSERT INTO "oneid_meta_deptperm" VALUES(13,'4b311c8897b74c50be0b3137e9df4463',0,1,'2019-12-27 11:30:45.911934','2019-11-16 09:46:33.781936',0,0,3,3);
INSERT INTO "oneid_meta_deptperm" VALUES(14,'daed05dece6243f09ecab85cef9c309c',0,1,'2019-12-27 11:30:45.919892','2019-11-16 09:46:33.783862',0,0,4,3);
INSERT INTO "oneid_meta_deptperm" VALUES(15,'f1508f9e8d6f4acb88c574e29291e2de',0,1,'2019-12-27 11:30:45.927167','2019-11-16 09:46:33.785618',0,0,5,3);
INSERT INTO "oneid_meta_deptperm" VALUES(16,'86f93f2fc51647a5af856eaf1901da9c',0,1,'2019-12-27 11:30:45.934987','2019-11-16 09:46:33.787345',0,0,6,3);
INSERT INTO "oneid_meta_deptperm" VALUES(17,'02443547c2eb4933b4c5eb1868739848',0,1,'2019-12-27 11:30:45.942479','2019-11-16 09:46:33.789092',0,0,7,3);
INSERT INTO "oneid_meta_deptperm" VALUES(18,'e55a639489054e22b814f03c39e37c6c',0,1,'2019-12-27 11:30:45.950091','2019-11-16 09:46:33.790452',0,0,8,3);
INSERT INTO "oneid_meta_deptperm" VALUES(19,'6bc53b0c54104d70958906963f62754b',0,1,'2019-12-27 11:30:45.957587','2019-11-16 09:46:33.792142',0,0,9,3);
INSERT INTO "oneid_meta_deptperm" VALUES(20,'e21ff5e6f29d4962b402a1c86b4d659b',0,1,'2019-12-27 11:30:45.965241','2019-11-16 09:46:33.793757',0,0,10,3);
INSERT INTO "oneid_meta_deptperm" VALUES(21,'f1de2d3a15a3406684ca2acdc8802bb2',0,1,'2019-12-27 11:30:46.897018','2019-11-16 09:46:54.799264',0,0,1,4);
INSERT INTO "oneid_meta_deptperm" VALUES(22,'dfa57350653a4ca5bcc445f55bea503d',0,1,'2019-12-27 11:30:46.904480','2019-11-16 09:46:54.801140',0,0,2,4);
INSERT INTO "oneid_meta_deptperm" VALUES(23,'f2a2bcbd4ae844fda2846089eb28f19f',0,1,'2019-12-27 11:30:46.912159','2019-11-16 09:46:54.802989',0,0,3,4);
INSERT INTO "oneid_meta_deptperm" VALUES(24,'7146e4b49ed74fcea85e43330c155b45',0,1,'2019-12-27 11:30:46.920890','2019-11-16 09:46:54.805543',0,0,4,4);
INSERT INTO "oneid_meta_deptperm" VALUES(25,'d57efc0353a5438a95eeba30bb8f7c63',0,1,'2019-12-27 11:30:46.928424','2019-11-16 09:46:54.807404',0,0,5,4);
INSERT INTO "oneid_meta_deptperm" VALUES(26,'c3db933e981e4ddab377b6cc6143071d',0,1,'2019-12-27 11:30:46.936385','2019-11-16 09:46:54.808683',0,0,6,4);
INSERT INTO "oneid_meta_deptperm" VALUES(27,'61b7abf97d464b49ac5b9ef432a87646',0,1,'2019-12-27 11:30:46.943834','2019-11-16 09:46:54.810179',0,0,7,4);
INSERT INTO "oneid_meta_deptperm" VALUES(28,'9310d59599de480e8b4a2f01c1d0a5e1',0,1,'2019-12-27 11:30:46.952149','2019-11-16 09:46:54.811631',0,0,8,4);
INSERT INTO "oneid_meta_deptperm" VALUES(29,'8869f68b06fb4cbd80ca4123e1af4fff',0,1,'2019-12-27 11:30:46.959681','2019-11-16 09:46:54.813122',0,0,9,4);
INSERT INTO "oneid_meta_deptperm" VALUES(30,'08799ad0eb4f4daab75dce1dbe77cda5',0,1,'2019-12-27 11:30:46.967419','2019-11-16 09:46:54.815042',0,0,10,4);
INSERT INTO "oneid_meta_deptperm" VALUES(31,'9f5045844f82496eb7c44521da9a3926',0,1,'2019-12-27 11:30:47.893901','2019-11-16 09:48:52.405915',0,0,1,5);
INSERT INTO "oneid_meta_deptperm" VALUES(32,'c7387100f2b443d1b8e3174063f3296f',0,1,'2019-12-27 11:30:47.901781','2019-11-16 09:48:52.407448',0,0,2,5);
INSERT INTO "oneid_meta_deptperm" VALUES(33,'a6be6791faf8492b80b9ccdcb516a7d6',0,1,'2019-12-27 11:30:47.909374','2019-11-16 09:48:52.408914',0,0,3,5);
INSERT INTO "oneid_meta_deptperm" VALUES(34,'b3c1b0ee8ba349179b7f799d733c5686',0,1,'2019-12-27 11:30:47.916964','2019-11-16 09:48:52.410875',0,0,4,5);
INSERT INTO "oneid_meta_deptperm" VALUES(35,'5e5ead8f26f54619981d54a2ea162d9d',0,1,'2019-12-27 11:30:47.924524','2019-11-16 09:48:52.412730',0,0,5,5);
INSERT INTO "oneid_meta_deptperm" VALUES(36,'697fb3f57b5f495d9a8fab56259b23a3',0,1,'2019-12-27 11:30:47.931912','2019-11-16 09:48:52.415308',0,0,6,5);
INSERT INTO "oneid_meta_deptperm" VALUES(37,'5a661abc04324e8fba7d9e5169f063ab',0,1,'2019-12-27 11:30:47.939660','2019-11-16 09:48:52.417569',0,0,7,5);
INSERT INTO "oneid_meta_deptperm" VALUES(38,'8ac5c512fb0442f78cb66391095299c2',0,1,'2019-12-27 11:30:47.947119','2019-11-16 09:48:52.419543',0,0,8,5);
INSERT INTO "oneid_meta_deptperm" VALUES(39,'9b959583ca1f44d6b10ffac59ac4c41d',0,1,'2019-12-27 11:30:47.955300','2019-11-16 09:48:52.420926',0,0,9,5);
INSERT INTO "oneid_meta_deptperm" VALUES(40,'2b2326d11cc14cd49fd26969f9aba0b7',0,1,'2019-12-27 11:30:47.962712','2019-11-16 09:48:52.422255',0,0,10,5);
INSERT INTO "oneid_meta_deptperm" VALUES(41,'56b71564da8944d2b1ae959b653e5683',0,1,'2019-12-27 11:30:48.926644','2019-11-16 09:49:31.065743',0,0,1,6);
INSERT INTO "oneid_meta_deptperm" VALUES(42,'9cd133c62aac472ba2de4499883f388d',0,1,'2019-12-27 11:30:48.934515','2019-11-16 09:49:31.068016',0,0,2,6);
INSERT INTO "oneid_meta_deptperm" VALUES(43,'8029da6cf090450faf61b84958d4c47a',0,1,'2019-12-27 11:30:48.942248','2019-11-16 09:49:31.069689',0,0,3,6);
INSERT INTO "oneid_meta_deptperm" VALUES(44,'e741b0468bd34531a9f095c2e28acc00',0,1,'2019-12-27 11:30:48.949810','2019-11-16 09:49:31.071468',0,0,4,6);
INSERT INTO "oneid_meta_deptperm" VALUES(45,'43289676761743c4adb0c89811557654',0,1,'2019-12-27 11:30:48.957710','2019-11-16 09:49:31.073408',0,0,5,6);
INSERT INTO "oneid_meta_deptperm" VALUES(46,'9dcdb4dff46149879c0bf7b07864fd0b',0,1,'2019-12-27 11:30:48.965110','2019-11-16 09:49:31.074949',0,0,6,6);
INSERT INTO "oneid_meta_deptperm" VALUES(47,'b94fb81a60aa422f8ad164f67cdf9ace',0,1,'2019-12-27 11:30:48.972805','2019-11-16 09:49:31.076244',0,0,7,6);
INSERT INTO "oneid_meta_deptperm" VALUES(48,'f25dc201453549d288a8ddd1c92bc7ea',0,1,'2019-12-27 11:30:48.980213','2019-11-16 09:49:31.077658',0,0,8,6);
INSERT INTO "oneid_meta_deptperm" VALUES(49,'c131cc5e0eb149459f713e5c4c27f391',0,1,'2019-12-27 11:30:48.988627','2019-11-16 09:49:31.079318',0,0,9,6);
INSERT INTO "oneid_meta_deptperm" VALUES(50,'1a298cf0906c412782a3346926682467',0,1,'2019-12-27 11:30:48.996190','2019-11-16 09:49:31.081290',0,0,10,6);
INSERT INTO "oneid_meta_deptperm" VALUES(51,'ea61f1d61cb94d5e93f7504058e170ab',0,1,'2019-12-27 11:30:45.054405','2019-11-16 09:50:21.306763',0,0,1,7);
INSERT INTO "oneid_meta_deptperm" VALUES(52,'f7c7a84af6694be6a9cdffa1f232097d',0,1,'2019-12-27 11:30:45.063585','2019-11-16 09:50:21.308235',0,0,2,7);
INSERT INTO "oneid_meta_deptperm" VALUES(53,'9d0867aa531242f0ba4ee2d283f92c92',0,1,'2019-12-27 11:30:45.071198','2019-11-16 09:50:21.309578',0,0,3,7);
INSERT INTO "oneid_meta_deptperm" VALUES(54,'a1f2caf6d46549f991a81c63261fc79a',0,1,'2019-12-27 11:30:45.079232','2019-11-16 09:50:21.310814',0,0,4,7);
INSERT INTO "oneid_meta_deptperm" VALUES(55,'cc172662e05d4b21aea8af1265e5ad6d',0,1,'2019-12-27 11:30:45.087893','2019-11-16 09:50:21.312078',0,0,5,7);
INSERT INTO "oneid_meta_deptperm" VALUES(56,'9dc9ad6b8ce84c2e92c123379115e35e',0,1,'2019-12-27 11:30:45.095592','2019-11-16 09:50:21.313619',0,0,6,7);
INSERT INTO "oneid_meta_deptperm" VALUES(57,'c33f879f8332402a812a90d0e5ed021d',0,1,'2019-12-27 11:30:45.103128','2019-11-16 09:50:21.315549',0,0,7,7);
INSERT INTO "oneid_meta_deptperm" VALUES(58,'b9aff87970124e34a8d93fc8e145d90d',0,1,'2019-12-27 11:30:45.110411','2019-11-16 09:50:21.317531',0,0,8,7);
INSERT INTO "oneid_meta_deptperm" VALUES(59,'2a51f00fb8ce4c6ca98135b6fa7fa6c0',0,1,'2019-12-27 11:30:45.118168','2019-11-16 09:50:21.318912',0,0,9,7);
INSERT INTO "oneid_meta_deptperm" VALUES(60,'813b3610a7aa48d9a940d9d6dd5c58d7',0,1,'2019-12-27 11:30:45.127338','2019-11-16 09:50:21.320501',0,0,10,7);
INSERT INTO "oneid_meta_deptperm" VALUES(61,'646e3eef445d4184997a518068e1be8a',0,1,'2019-12-27 11:30:45.225989','2019-11-16 09:50:49.451423',0,0,1,8);
INSERT INTO "oneid_meta_deptperm" VALUES(62,'0b6d0fcf7ca9412087bccf6459d5c813',0,1,'2019-12-27 11:30:45.233917','2019-11-16 09:50:49.453962',0,0,2,8);
INSERT INTO "oneid_meta_deptperm" VALUES(63,'c640ba74147c4043ba7336a876bcefb3',0,1,'2019-12-27 11:30:45.241504','2019-11-16 09:50:49.455928',0,0,3,8);
INSERT INTO "oneid_meta_deptperm" VALUES(64,'a94c33d818a24cb0969f811967f02284',0,1,'2019-12-27 11:30:45.249121','2019-11-16 09:50:49.457206',0,0,4,8);
INSERT INTO "oneid_meta_deptperm" VALUES(65,'e5725be2c8c749d8bc85ebdd43b7740f',0,1,'2019-12-27 11:30:45.256515','2019-11-16 09:50:49.458416',0,0,5,8);
INSERT INTO "oneid_meta_deptperm" VALUES(66,'a0027b48007e47aa9861c7e64e15af7e',0,1,'2019-12-27 11:30:45.264102','2019-11-16 09:50:49.459632',0,0,6,8);
INSERT INTO "oneid_meta_deptperm" VALUES(67,'914d2d41f9ed4e4ca282e8e10c84f0db',0,1,'2019-12-27 11:30:45.271450','2019-11-16 09:50:49.460967',0,0,7,8);
INSERT INTO "oneid_meta_deptperm" VALUES(68,'d6ad65b4a9374d95be0284669fde2160',0,1,'2019-12-27 11:30:45.279571','2019-11-16 09:50:49.462446',0,0,8,8);
INSERT INTO "oneid_meta_deptperm" VALUES(69,'e9d3519c1f244bc5a417c6e45addd4bf',0,1,'2019-12-27 11:30:45.287164','2019-11-16 09:50:49.463647',0,0,9,8);
INSERT INTO "oneid_meta_deptperm" VALUES(70,'9ddea947e1894a3b915348971eaf3acb',0,1,'2019-12-27 11:30:45.295092','2019-11-16 09:50:49.464856',0,0,10,8);
INSERT INTO "oneid_meta_deptperm" VALUES(71,'e3f326938a3240eda067bb3a1a9c3e5d',0,1,'2019-12-27 11:30:45.389333','2019-11-16 09:51:01.684221',0,0,1,9);
INSERT INTO "oneid_meta_deptperm" VALUES(72,'b8a1ce89eed542e7a4005acc052d431f',0,1,'2019-12-27 11:30:45.398576','2019-11-16 09:51:01.685697',0,0,2,9);
INSERT INTO "oneid_meta_deptperm" VALUES(73,'03b1cc53bcb44262b4ee036716b196ec',0,1,'2019-12-27 11:30:45.406905','2019-11-16 09:51:01.687266',0,0,3,9);
INSERT INTO "oneid_meta_deptperm" VALUES(74,'6060dd3ad1be48cfa984e5b79fa5626e',0,1,'2019-12-27 11:30:45.415462','2019-11-16 09:51:01.688716',0,0,4,9);
INSERT INTO "oneid_meta_deptperm" VALUES(75,'896e319f6a0445c3a20d061dbb2fc221',0,1,'2019-12-27 11:30:45.423993','2019-11-16 09:51:01.690208',0,0,5,9);
INSERT INTO "oneid_meta_deptperm" VALUES(76,'f8f58a51b48c47c395333bf00e428e2e',0,1,'2019-12-27 11:30:45.433210','2019-11-16 09:51:01.691506',0,0,6,9);
INSERT INTO "oneid_meta_deptperm" VALUES(77,'d3c97a9822f947bab983b5c271d59f5d',0,1,'2019-12-27 11:30:45.441307','2019-11-16 09:51:01.692811',0,0,7,9);
INSERT INTO "oneid_meta_deptperm" VALUES(78,'9ef3a9a9512f4b1b9269428ab2090553',0,1,'2019-12-27 11:30:45.448653','2019-11-16 09:51:01.695071',0,0,8,9);
INSERT INTO "oneid_meta_deptperm" VALUES(79,'5a65e5c6154744059c8886010541ee5e',0,1,'2019-12-27 11:30:45.456399','2019-11-16 09:51:01.697015',0,0,9,9);
INSERT INTO "oneid_meta_deptperm" VALUES(80,'0698a1d5fcac4fd387e768cad3bf8279',0,1,'2019-12-27 11:30:45.463778','2019-11-16 09:51:01.698433',0,0,10,9);
INSERT INTO "oneid_meta_deptperm" VALUES(81,'5e6dd50f683f4be9800f4f59c9219aa1',0,1,'2019-12-27 11:30:45.565348','2019-11-16 09:51:11.821576',0,0,1,10);
INSERT INTO "oneid_meta_deptperm" VALUES(82,'82ddd7613c2046678b473af6a7e141ea',0,1,'2019-12-27 11:30:45.572747','2019-11-16 09:51:11.823326',0,0,2,10);
INSERT INTO "oneid_meta_deptperm" VALUES(83,'c322c2ec76b34f37a72cd59bb16640bc',0,1,'2019-12-27 11:30:45.580483','2019-11-16 09:51:11.824772',0,0,3,10);
INSERT INTO "oneid_meta_deptperm" VALUES(84,'fbaed597bbb74de2835152fc3137b99a',0,1,'2019-12-27 11:30:45.588146','2019-11-16 09:51:11.826335',0,0,4,10);
INSERT INTO "oneid_meta_deptperm" VALUES(85,'7e95ce8437a0450c839e0dc9b2be7a5a',0,1,'2019-12-27 11:30:45.595879','2019-11-16 09:51:11.827943',0,0,5,10);
INSERT INTO "oneid_meta_deptperm" VALUES(86,'8def2315e4864b209d38078cd64542cb',0,1,'2019-12-27 11:30:45.603221','2019-11-16 09:51:11.830277',0,0,6,10);
INSERT INTO "oneid_meta_deptperm" VALUES(87,'d1a03db7e3be4cad9b70e4af38a00f56',0,1,'2019-12-27 11:30:45.610719','2019-11-16 09:51:11.832604',0,0,7,10);
INSERT INTO "oneid_meta_deptperm" VALUES(88,'8be97a5afd98472abbcdc1504b732739',0,1,'2019-12-27 11:30:45.618289','2019-11-16 09:51:11.834836',0,0,8,10);
INSERT INTO "oneid_meta_deptperm" VALUES(89,'c97ad11e54af497fad8200d34f53877e',0,1,'2019-12-27 11:30:45.625930','2019-11-16 09:51:11.836732',0,0,9,10);
INSERT INTO "oneid_meta_deptperm" VALUES(90,'6dfd7ff369a746bb9f8917e5973f7177',0,1,'2019-12-27 11:30:45.633855','2019-11-16 09:51:11.838157',0,0,10,10);
INSERT INTO "oneid_meta_deptperm" VALUES(91,'7ec6ab8df07d4c14866c32e6a159a7fb',0,1,'2019-12-27 11:30:45.730143','2019-11-16 09:51:21.658443',0,0,1,11);
INSERT INTO "oneid_meta_deptperm" VALUES(92,'048ba509cfc04b84b9c6149684539779',0,1,'2019-12-27 11:30:45.738422','2019-11-16 09:51:21.660414',0,0,2,11);
INSERT INTO "oneid_meta_deptperm" VALUES(93,'48f9ef81651e4a9b80e64bffee63d5c4',0,1,'2019-12-27 11:30:45.745787','2019-11-16 09:51:21.662206',0,0,3,11);
INSERT INTO "oneid_meta_deptperm" VALUES(94,'ab2dc88f4829442789a0c47a3d711d37',0,1,'2019-12-27 11:30:45.753468','2019-11-16 09:51:21.663852',0,0,4,11);
INSERT INTO "oneid_meta_deptperm" VALUES(95,'9f3a2496620b4563828c1e878aa66a73',0,1,'2019-12-27 11:30:45.760870','2019-11-16 09:51:21.666499',0,0,5,11);
INSERT INTO "oneid_meta_deptperm" VALUES(96,'533f7d168f1240b99e57e8ab478483a2',0,1,'2019-12-27 11:30:45.768502','2019-11-16 09:51:21.667966',0,0,6,11);
INSERT INTO "oneid_meta_deptperm" VALUES(97,'9250c678323645d2898997f452603785',0,1,'2019-12-27 11:30:45.775971','2019-11-16 09:51:21.669405',0,0,7,11);
INSERT INTO "oneid_meta_deptperm" VALUES(98,'6fbc131a28aa44a1a36064a64c1bc4e0',0,1,'2019-12-27 11:30:45.785859','2019-11-16 09:51:21.670687',0,0,8,11);
INSERT INTO "oneid_meta_deptperm" VALUES(99,'cbcff1f4f9d24b8f8a587a531493142e',0,1,'2019-12-27 11:30:45.793466','2019-11-16 09:51:21.671941',0,0,9,11);
INSERT INTO "oneid_meta_deptperm" VALUES(100,'5462ad9232f74f99bf16356254491cfc',0,1,'2019-12-27 11:30:45.801216','2019-11-16 09:51:21.673210',0,0,10,11);
INSERT INTO "oneid_meta_deptperm" VALUES(101,'e8fde619a03a4a42b8f591be7f44daf1',0,1,'2019-12-27 11:30:46.063120','2019-11-16 09:51:35.506003',0,0,1,12);
INSERT INTO "oneid_meta_deptperm" VALUES(102,'c2c8ff0e62404f119a7ca9353b55e877',0,1,'2019-12-27 11:30:46.070641','2019-11-16 09:51:35.507597',0,0,2,12);
INSERT INTO "oneid_meta_deptperm" VALUES(103,'2aa77c03966b4724908a9b829ef3cda6',0,1,'2019-12-27 11:30:46.078315','2019-11-16 09:51:35.509209',0,0,3,12);
INSERT INTO "oneid_meta_deptperm" VALUES(104,'91a9b38b04aa4140b160dd62629a831e',0,1,'2019-12-27 11:30:46.085995','2019-11-16 09:51:35.511481',0,0,4,12);
INSERT INTO "oneid_meta_deptperm" VALUES(105,'20e388d936bc4373812dff80f46f2028',0,1,'2019-12-27 11:30:46.093782','2019-11-16 09:51:35.513862',0,0,5,12);
INSERT INTO "oneid_meta_deptperm" VALUES(106,'754dfd3e9b094c29ae3063fee497ec7a',0,1,'2019-12-27 11:30:46.101170','2019-11-16 09:51:35.515238',0,0,6,12);
INSERT INTO "oneid_meta_deptperm" VALUES(107,'03f413e4167b49c88716be864c5e1691',0,1,'2019-12-27 11:30:46.108851','2019-11-16 09:51:35.517089',0,0,7,12);
INSERT INTO "oneid_meta_deptperm" VALUES(108,'6f420047a211427bb42874361bdc2b24',0,1,'2019-12-27 11:30:46.118218','2019-11-16 09:51:35.519165',0,0,8,12);
INSERT INTO "oneid_meta_deptperm" VALUES(109,'38e9af82632b43f0aa838bed57f42570',0,1,'2019-12-27 11:30:46.129967','2019-11-16 09:51:35.520802',0,0,9,12);
INSERT INTO "oneid_meta_deptperm" VALUES(110,'6803c7f3d5624342ab77cbbf8affc605',0,1,'2019-12-27 11:30:46.138515','2019-11-16 09:51:35.522160',0,0,10,12);
INSERT INTO "oneid_meta_deptperm" VALUES(111,'07c5e2ed94fa4702b72335fb2e7c5f3c',0,1,'2019-12-27 11:30:46.237102','2019-11-16 09:51:44.958409',0,0,1,13);
INSERT INTO "oneid_meta_deptperm" VALUES(112,'09196927e7a64355b5c89407c6e6c883',0,1,'2019-12-27 11:30:46.244445','2019-11-16 09:51:44.960271',0,0,2,13);
INSERT INTO "oneid_meta_deptperm" VALUES(113,'b81d8b5a60304bcd8cbe95c767e8b058',0,1,'2019-12-27 11:30:46.251946','2019-11-16 09:51:44.962206',0,0,3,13);
INSERT INTO "oneid_meta_deptperm" VALUES(114,'5875a97d6c1b4deb93ea8ff7791c8ecb',0,1,'2019-12-27 11:30:46.259216','2019-11-16 09:51:44.963784',0,0,4,13);
INSERT INTO "oneid_meta_deptperm" VALUES(115,'7f7c11acce554b4a9c4e254bb9d888a3',0,1,'2019-12-27 11:30:46.266925','2019-11-16 09:51:44.965928',0,0,5,13);
INSERT INTO "oneid_meta_deptperm" VALUES(116,'f85fa20faef74c01826b5441a3a45b98',0,1,'2019-12-27 11:30:46.274372','2019-11-16 09:51:44.967977',0,0,6,13);
INSERT INTO "oneid_meta_deptperm" VALUES(117,'5101c4a61a5b4581b2542596daf1221d',0,1,'2019-12-27 11:30:46.282893','2019-11-16 09:51:44.969439',0,0,7,13);
INSERT INTO "oneid_meta_deptperm" VALUES(118,'e4234af3619b49ce94f1680be9bbc0be',0,1,'2019-12-27 11:30:46.290479','2019-11-16 09:51:44.970839',0,0,8,13);
INSERT INTO "oneid_meta_deptperm" VALUES(119,'e532267eb07049048ea2de2692629943',0,1,'2019-12-27 11:30:46.298254','2019-11-16 09:51:44.972001',0,0,9,13);
INSERT INTO "oneid_meta_deptperm" VALUES(120,'d60610385c644517969d9fff8e40d51e',0,1,'2019-12-27 11:30:46.305620','2019-11-16 09:51:44.973413',0,0,10,13);
INSERT INTO "oneid_meta_deptperm" VALUES(121,'31310301261946f390749e5d084ba0c0',0,1,'2019-12-27 11:30:46.401188','2019-11-16 09:51:55.229779',0,0,1,14);
INSERT INTO "oneid_meta_deptperm" VALUES(122,'04f3fbacc77848a5947cbca8ec4f238a',0,1,'2019-12-27 11:30:46.409008','2019-11-16 09:51:55.231755',0,0,2,14);
INSERT INTO "oneid_meta_deptperm" VALUES(123,'130bb43c028e4b3a81d9244cbf4fc0c4',0,1,'2019-12-27 11:30:46.416719','2019-11-16 09:51:55.233528',0,0,3,14);
INSERT INTO "oneid_meta_deptperm" VALUES(124,'06b66d9e99434fd386c61ff481381e65',0,1,'2019-12-27 11:30:46.424317','2019-11-16 09:51:55.235202',0,0,4,14);
INSERT INTO "oneid_meta_deptperm" VALUES(125,'3963eac263504202b4e2ea863022e9c1',0,1,'2019-12-27 11:30:46.431709','2019-11-16 09:51:55.236941',0,0,5,14);
INSERT INTO "oneid_meta_deptperm" VALUES(126,'874884b043154ed38b31342df2c675aa',0,1,'2019-12-27 11:30:46.439448','2019-11-16 09:51:55.238520',0,0,6,14);
INSERT INTO "oneid_meta_deptperm" VALUES(127,'7c5b2cd76a654c76a72620475e15f0c3',0,1,'2019-12-27 11:30:46.447705','2019-11-16 09:51:55.240097',0,0,7,14);
INSERT INTO "oneid_meta_deptperm" VALUES(128,'9acfd7e2ba084d15944c1582f4d08cce',0,1,'2019-12-27 11:30:46.455138','2019-11-16 09:51:55.241536',0,0,8,14);
INSERT INTO "oneid_meta_deptperm" VALUES(129,'a433e9bd3dc04373b9748b56045c6df6',0,1,'2019-12-27 11:30:46.462805','2019-11-16 09:51:55.242908',0,0,9,14);
INSERT INTO "oneid_meta_deptperm" VALUES(130,'e622e064fba24a88a45f4689462cbd0d',0,1,'2019-12-27 11:30:46.470070','2019-11-16 09:51:55.244238',0,0,10,14);
INSERT INTO "oneid_meta_deptperm" VALUES(131,'a3b95caa31294188af3284545b552d95',0,1,'2019-12-27 11:30:46.567582','2019-11-16 09:52:07.245433',0,0,1,15);
INSERT INTO "oneid_meta_deptperm" VALUES(132,'9d59b0d6c1b34011bd1a8b94951ff959',0,1,'2019-12-27 11:30:46.575267','2019-11-16 09:52:07.247102',0,0,2,15);
INSERT INTO "oneid_meta_deptperm" VALUES(133,'e4db9e81fe3f479aa2373f92bc1cb0a0',0,1,'2019-12-27 11:30:46.583146','2019-11-16 09:52:07.248734',0,0,3,15);
INSERT INTO "oneid_meta_deptperm" VALUES(134,'eb1c72235f6c4185a5a37b0a1def0dce',0,1,'2019-12-27 11:30:46.590958','2019-11-16 09:52:07.250326',0,0,4,15);
INSERT INTO "oneid_meta_deptperm" VALUES(135,'41bc783620c940d58bbc9fb8846a39ee',0,1,'2019-12-27 11:30:46.598394','2019-11-16 09:52:07.251606',0,0,5,15);
INSERT INTO "oneid_meta_deptperm" VALUES(136,'0b39fae745374d508d8bd2b14413304c',0,1,'2019-12-27 11:30:46.606193','2019-11-16 09:52:07.253093',0,0,6,15);
INSERT INTO "oneid_meta_deptperm" VALUES(137,'f543e623b13749cd915621cbc3648f12',0,1,'2019-12-27 11:30:46.613577','2019-11-16 09:52:07.254447',0,0,7,15);
INSERT INTO "oneid_meta_deptperm" VALUES(138,'9a989e5d3a1247d5b09c71682654da99',0,1,'2019-12-27 11:30:46.621164','2019-11-16 09:52:07.256961',0,0,8,15);
INSERT INTO "oneid_meta_deptperm" VALUES(139,'603a848944ab4b98bab8d83916df7218',0,1,'2019-12-27 11:30:46.631348','2019-11-16 09:52:07.258456',0,0,9,15);
INSERT INTO "oneid_meta_deptperm" VALUES(140,'5752a628cf1548b6b3386b3636ed6507',0,1,'2019-12-27 11:30:46.639701','2019-11-16 09:52:07.260058',0,0,10,15);
INSERT INTO "oneid_meta_deptperm" VALUES(141,'70747fd857434f9ea7c7bde8c902ea25',0,1,'2019-12-27 11:30:46.732738','2019-11-16 09:52:19.821905',0,0,1,16);
INSERT INTO "oneid_meta_deptperm" VALUES(142,'c7fc8c3bb5c648f0bd63a3b24cac4404',0,1,'2019-12-27 11:30:46.740205','2019-11-16 09:52:19.823499',0,0,2,16);
INSERT INTO "oneid_meta_deptperm" VALUES(143,'44c26c10a1ff4f96b649e612e06b4bae',0,1,'2019-12-27 11:30:46.748539','2019-11-16 09:52:19.825242',0,0,3,16);
INSERT INTO "oneid_meta_deptperm" VALUES(144,'15431c8822604af3bc55ad67f4214f42',0,1,'2019-12-27 11:30:46.755874','2019-11-16 09:52:19.827078',0,0,4,16);
INSERT INTO "oneid_meta_deptperm" VALUES(145,'305c9607a6cb4a9d9878038d1bbab979',0,1,'2019-12-27 11:30:46.763486','2019-11-16 09:52:19.828463',0,0,5,16);
INSERT INTO "oneid_meta_deptperm" VALUES(146,'e9d40b876e164810b681e54f5423642d',0,1,'2019-12-27 11:30:46.770694','2019-11-16 09:52:19.829798',0,0,6,16);
INSERT INTO "oneid_meta_deptperm" VALUES(147,'cc990602ea1e43bf988e4b01c8d5ae51',0,1,'2019-12-27 11:30:46.778178','2019-11-16 09:52:19.831948',0,0,7,16);
INSERT INTO "oneid_meta_deptperm" VALUES(148,'420c3836127a4f838f55be9648ea52b5',0,1,'2019-12-27 11:30:46.787705','2019-11-16 09:52:19.833850',0,0,8,16);
INSERT INTO "oneid_meta_deptperm" VALUES(149,'ed2606fd154143af95cca7c59410ee99',0,1,'2019-12-27 11:30:46.795363','2019-11-16 09:52:19.835568',0,0,9,16);
INSERT INTO "oneid_meta_deptperm" VALUES(150,'b923cc396fc7445292745a49274fc6db',0,1,'2019-12-27 11:30:46.802926','2019-11-16 09:52:19.836994',0,0,10,16);
INSERT INTO "oneid_meta_deptperm" VALUES(151,'8be3a60ca73d4a18b3ebd2334e8fd2ae',0,1,'2019-12-27 11:30:47.060933','2019-11-16 10:03:28.518655',0,0,1,17);
INSERT INTO "oneid_meta_deptperm" VALUES(152,'3e35c65530264b79baff716371cd42b6',0,1,'2019-12-27 11:30:47.068521','2019-11-16 10:03:28.520496',0,0,2,17);
INSERT INTO "oneid_meta_deptperm" VALUES(153,'78a8edb06891408fb0b08653d43123aa',0,1,'2019-12-27 11:30:47.076145','2019-11-16 10:03:28.522357',0,0,3,17);
INSERT INTO "oneid_meta_deptperm" VALUES(154,'356e93e6ec9b4ab180f868311027ce83',0,1,'2019-12-27 11:30:47.083742','2019-11-16 10:03:28.523940',0,0,4,17);
INSERT INTO "oneid_meta_deptperm" VALUES(155,'92de1a6746b04d60b4289bfad056f091',0,1,'2019-12-27 11:30:47.091902','2019-11-16 10:03:28.525530',0,0,5,17);
INSERT INTO "oneid_meta_deptperm" VALUES(156,'a8abf5405d404b4c852fa20702267ab8',0,1,'2019-12-27 11:30:47.099414','2019-11-16 10:03:28.527603',0,0,6,17);
INSERT INTO "oneid_meta_deptperm" VALUES(157,'388b0ee2313c4edebca8b6a25c7ed2ce',0,1,'2019-12-27 11:30:47.107195','2019-11-16 10:03:28.529553',0,0,7,17);
INSERT INTO "oneid_meta_deptperm" VALUES(158,'a583b8a0e49a4cb29646f1256974734f',0,1,'2019-12-27 11:30:47.114743','2019-11-16 10:03:28.530808',0,0,8,17);
INSERT INTO "oneid_meta_deptperm" VALUES(159,'bcff9de3e4524683ac29deb8114971c0',0,1,'2019-12-27 11:30:47.122842','2019-11-16 10:03:28.533069',0,0,9,17);
INSERT INTO "oneid_meta_deptperm" VALUES(160,'1741a9dd627b464592ee5df52614f1a9',0,1,'2019-12-27 11:30:47.132309','2019-11-16 10:03:28.535187',0,0,10,17);
INSERT INTO "oneid_meta_deptperm" VALUES(161,'a720746672c84e41aa16a0eb1743e1bc',0,1,'2019-12-27 11:30:48.058034','2019-11-16 10:03:39.676471',0,0,1,18);
INSERT INTO "oneid_meta_deptperm" VALUES(162,'44e2ad3ced534877922451a83dc05f43',0,1,'2019-12-27 11:30:48.065718','2019-11-16 10:03:39.678532',0,0,2,18);
INSERT INTO "oneid_meta_deptperm" VALUES(163,'1f870c576ee34150a386bbfa25d5723d',0,1,'2019-12-27 11:30:48.073272','2019-11-16 10:03:39.680118',0,0,3,18);
INSERT INTO "oneid_meta_deptperm" VALUES(164,'b38dfdf8a7e041339ba7c35d8bdbce2b',0,1,'2019-12-27 11:30:48.080646','2019-11-16 10:03:39.681795',0,0,4,18);
INSERT INTO "oneid_meta_deptperm" VALUES(165,'e2f46289b24145a3b2b3dc1aaf5aa814',0,1,'2019-12-27 11:30:48.088375','2019-11-16 10:03:39.683384',0,0,5,18);
INSERT INTO "oneid_meta_deptperm" VALUES(166,'0fa39262195c454c97e36211acf20b32',0,1,'2019-12-27 11:30:48.095777','2019-11-16 10:03:39.684923',0,0,6,18);
INSERT INTO "oneid_meta_deptperm" VALUES(167,'98910003ddb545f6a9a795dd2862c4f3',0,1,'2019-12-27 11:30:48.103887','2019-11-16 10:03:39.686483',0,0,7,18);
INSERT INTO "oneid_meta_deptperm" VALUES(168,'dc8f7696b7b24f688205811b00bdb5ec',0,1,'2019-12-27 11:30:48.113312','2019-11-16 10:03:39.687986',0,0,8,18);
INSERT INTO "oneid_meta_deptperm" VALUES(169,'adb68388ecac47c5ba2730f486ac56ab',0,1,'2019-12-27 11:30:48.122078','2019-11-16 10:03:39.689621',0,0,9,18);
INSERT INTO "oneid_meta_deptperm" VALUES(170,'8c8ebfe025634a7ea5d89206826e872b',0,1,'2019-12-27 11:30:48.129888','2019-11-16 10:03:39.691244',0,0,10,18);
INSERT INTO "oneid_meta_deptperm" VALUES(171,'8495987ae56747f2a16701eedd00d307',0,1,'2019-12-27 11:30:49.088566','2019-11-16 10:03:52.524184',0,0,1,19);
INSERT INTO "oneid_meta_deptperm" VALUES(172,'ffc010afea03461ca196d9f009e4216e',0,1,'2019-12-27 11:30:49.096345','2019-11-16 10:03:52.526188',0,0,2,19);
INSERT INTO "oneid_meta_deptperm" VALUES(173,'e1817c122bfb488f92a749e55a45437d',0,1,'2019-12-27 11:30:49.104278','2019-11-16 10:03:52.528640',0,0,3,19);
INSERT INTO "oneid_meta_deptperm" VALUES(174,'198bf1a76484415aaf98404369242846',0,1,'2019-12-27 11:30:49.112090','2019-11-16 10:03:52.530826',0,0,4,19);
INSERT INTO "oneid_meta_deptperm" VALUES(175,'3235616773d94f60b1d00779341bf14a',0,1,'2019-12-27 11:30:49.120095','2019-11-16 10:03:52.532352',0,0,5,19);
INSERT INTO "oneid_meta_deptperm" VALUES(176,'4bc4de70b88248c58680b61bbfaaa231',0,1,'2019-12-27 11:30:49.127514','2019-11-16 10:03:52.533582',0,0,6,19);
INSERT INTO "oneid_meta_deptperm" VALUES(177,'29b293bfdacf41409d3cca831e5897ba',0,1,'2019-12-27 11:30:49.135168','2019-11-16 10:03:52.534977',0,0,7,19);
INSERT INTO "oneid_meta_deptperm" VALUES(178,'6998fc21b90e429aa0038e47681a8adf',0,1,'2019-12-27 11:30:49.142798','2019-11-16 10:03:52.536611',0,0,8,19);
INSERT INTO "oneid_meta_deptperm" VALUES(179,'cd9f2df306184393aa75aa3071327165',0,1,'2019-12-27 11:30:49.150463','2019-11-16 10:03:52.538618',0,0,9,19);
INSERT INTO "oneid_meta_deptperm" VALUES(180,'8468ef3a1d324e0d965148a7138bd791',0,1,'2019-12-27 11:30:49.158231','2019-11-16 10:03:52.540870',0,0,10,19);
INSERT INTO "oneid_meta_deptperm" VALUES(181,'f34f2a9320b048a7b78748608efcd3b8',0,1,'2019-12-27 11:30:45.170882','2019-11-16 10:12:44.347438',0,0,15,7);
INSERT INTO "oneid_meta_deptperm" VALUES(182,'a49d69bd900c4bb6947424acb26b5f7d',0,1,'2019-12-27 11:30:45.162415','2019-11-16 10:12:44.366417',0,0,14,7);
INSERT INTO "oneid_meta_deptperm" VALUES(183,'1011025018e04ec3aad7cb436a39e470',0,1,'2019-12-27 11:30:45.154156','2019-11-16 10:12:44.383003',0,0,13,7);
INSERT INTO "oneid_meta_deptperm" VALUES(184,'abd28898320d4f4f8f92951600d9a253',0,1,'2019-12-27 11:30:45.144507','2019-11-16 10:12:44.399227',0,0,12,7);
INSERT INTO "oneid_meta_deptperm" VALUES(185,'e85df0a0e2fa4a6cbdc0296aa8ae362a',0,1,'2019-12-27 11:30:45.136767','2019-11-16 10:12:44.414721',0,0,11,7);
INSERT INTO "oneid_meta_deptperm" VALUES(186,'20677dbb521f46778de104a4ee3c8715',0,1,'2019-12-27 11:30:44.770982','2019-12-27 04:08:15.797277',0,0,1,1);
INSERT INTO "oneid_meta_deptperm" VALUES(187,'acfadc8a1090473cb51292529e1dd121',0,1,'2019-12-27 11:30:44.776413','2019-12-27 04:08:15.880536',0,0,2,1);
INSERT INTO "oneid_meta_deptperm" VALUES(188,'ae42f77cd1bb4d7f86d66c987fed53ae',0,1,'2019-12-27 11:30:44.782692','2019-12-27 04:08:15.965719',0,0,3,1);
INSERT INTO "oneid_meta_deptperm" VALUES(189,'9f06d368f0f047c2acb47db8fbd35522',0,1,'2019-12-27 11:30:44.788795','2019-12-27 04:08:16.054478',0,0,4,1);
INSERT INTO "oneid_meta_deptperm" VALUES(190,'2fc6e73be4754cebac963f6ec46bfa03',0,1,'2019-12-27 11:30:44.793330','2019-12-27 04:08:16.149091',0,0,5,1);
INSERT INTO "oneid_meta_deptperm" VALUES(191,'189026e7e574407388f942bc483c18e1',0,1,'2019-12-27 11:30:44.798566','2019-12-27 04:08:16.243474',0,0,6,1);
INSERT INTO "oneid_meta_deptperm" VALUES(192,'2ba19972b9cd4fa7807abedfd95bcc21',0,1,'2019-12-27 11:30:44.803460','2019-12-27 04:08:16.337866',0,0,7,1);
INSERT INTO "oneid_meta_deptperm" VALUES(193,'8ba57da7453b4ceaabf044073f3abf83',0,1,'2019-12-27 11:30:44.808045','2019-12-27 04:08:16.431323',0,0,8,1);
INSERT INTO "oneid_meta_deptperm" VALUES(194,'2e584b56c5f54bb880c0d051d324b037',0,1,'2019-12-27 11:30:44.812927','2019-12-27 04:08:16.530899',0,0,9,1);
INSERT INTO "oneid_meta_deptperm" VALUES(195,'2c372c3004464e34b1c66c3b0fa59010',0,1,'2019-12-27 11:30:44.817506','2019-12-27 04:08:16.647010',0,0,10,1);
INSERT INTO "oneid_meta_deptperm" VALUES(196,'1707107f7f0c4e07b5d1e6c04d812e40',0,1,'2019-12-27 11:30:44.822125','2019-12-27 04:08:16.811465',0,0,11,1);
INSERT INTO "oneid_meta_deptperm" VALUES(197,'2f7be22cdec14d7d8ebd67de947e57ab',0,1,'2019-12-27 11:30:44.973061','2019-12-27 04:08:16.813572',0,0,11,2);
INSERT INTO "oneid_meta_deptperm" VALUES(198,'91ff13441da74dd7950454a7fa1c2a3e',0,1,'2019-12-27 11:30:45.972789','2019-12-27 04:08:16.815520',0,0,11,3);
INSERT INTO "oneid_meta_deptperm" VALUES(199,'ffd533025bfd446d88c53dd3063f4ab1',0,1,'2019-12-27 11:30:46.974897','2019-12-27 04:08:16.817480',0,0,11,4);
INSERT INTO "oneid_meta_deptperm" VALUES(200,'7174631afc0840cbbced0a3120468f9b',0,1,'2019-12-27 11:30:47.970270','2019-12-27 04:08:16.819483',0,0,11,5);
INSERT INTO "oneid_meta_deptperm" VALUES(201,'3a2fa81827a24dbf847792c98f35e3a5',0,1,'2019-12-27 11:30:49.004198','2019-12-27 04:08:16.821434',0,0,11,6);
INSERT INTO "oneid_meta_deptperm" VALUES(202,'aa6d22f837b841f2bc2f66ba9b36a301',0,1,'2019-12-27 11:30:45.302412','2019-12-27 04:08:16.824911',0,0,11,8);
INSERT INTO "oneid_meta_deptperm" VALUES(203,'e63e8e04fdcb4182b4f4a8537d0916a0',0,1,'2019-12-27 11:30:45.471312','2019-12-27 04:08:16.827512',0,0,11,9);
INSERT INTO "oneid_meta_deptperm" VALUES(204,'5190c817500d4dcdb223a32567180dd6',0,1,'2019-12-27 11:30:45.642425','2019-12-27 04:08:16.829895',0,0,11,10);
INSERT INTO "oneid_meta_deptperm" VALUES(205,'d6d06a5bc673489d9ceebe216398e596',0,1,'2019-12-27 11:30:45.809170','2019-12-27 04:08:16.832034',0,0,11,11);
INSERT INTO "oneid_meta_deptperm" VALUES(206,'df6b8afeb727467e9021ec5f43309bd0',0,1,'2019-12-27 11:30:46.146963','2019-12-27 04:08:16.834360',0,0,11,12);
INSERT INTO "oneid_meta_deptperm" VALUES(207,'63691b4e60084af48db2703e2f3c7a44',0,1,'2019-12-27 11:30:46.313566','2019-12-27 04:08:16.837634',0,0,11,13);
INSERT INTO "oneid_meta_deptperm" VALUES(208,'d3e1a622b07e4934880e1237d8395906',0,1,'2019-12-27 11:30:46.477654','2019-12-27 04:08:16.839702',0,0,11,14);
INSERT INTO "oneid_meta_deptperm" VALUES(209,'6520bab97bf7468b94ad6162e7993d6c',0,1,'2019-12-27 11:30:46.648799','2019-12-27 04:08:16.841844',0,0,11,15);
INSERT INTO "oneid_meta_deptperm" VALUES(210,'7a9d68419acf4c96b42a4020897e8e41',0,1,'2019-12-27 11:30:46.810216','2019-12-27 04:08:16.844088',0,0,11,16);
INSERT INTO "oneid_meta_deptperm" VALUES(211,'ebc77aeaa76f446c9adc64faf4cf0dca',0,1,'2019-12-27 11:30:47.139934','2019-12-27 04:08:16.846716',0,0,11,17);
INSERT INTO "oneid_meta_deptperm" VALUES(212,'81b6d416a595432fa6261eceb6ea85ca',0,1,'2019-12-27 11:30:48.137541','2019-12-27 04:08:16.849665',0,0,11,18);
INSERT INTO "oneid_meta_deptperm" VALUES(213,'7f42a5b5b56a45168bdb30a73838c2be',0,1,'2019-12-27 11:30:49.165901','2019-12-27 04:08:16.851694',0,0,11,19);
INSERT INTO "oneid_meta_deptperm" VALUES(214,'7f98781db1bf43efb2ad260724e8b6f5',0,1,'2019-12-27 11:30:44.826904','2019-12-27 04:08:17.006835',0,0,12,1);
INSERT INTO "oneid_meta_deptperm" VALUES(215,'0654979a7459498da69cad4a1f8aa24d',0,1,'2019-12-27 11:30:44.981643','2019-12-27 04:08:17.008996',0,0,12,2);
INSERT INTO "oneid_meta_deptperm" VALUES(216,'dd7ca66069b34d07b14095123c059586',0,1,'2019-12-27 11:30:45.980647','2019-12-27 04:08:17.011095',0,0,12,3);
INSERT INTO "oneid_meta_deptperm" VALUES(217,'e156f990ec0942b1ad0c21e2c131a372',0,1,'2019-12-27 11:30:46.982818','2019-12-27 04:08:17.013132',0,0,12,4);
INSERT INTO "oneid_meta_deptperm" VALUES(218,'b82781ffd2b0417b935c27946fe083e8',0,1,'2019-12-27 11:30:47.977717','2019-12-27 04:08:17.015551',0,0,12,5);
INSERT INTO "oneid_meta_deptperm" VALUES(219,'29334f953aba45dbbcd0e6237240e542',0,1,'2019-12-27 11:30:49.011933','2019-12-27 04:08:17.017579',0,0,12,6);
INSERT INTO "oneid_meta_deptperm" VALUES(220,'8853a4ed3fc84bc68040d5294e93f4c4',0,1,'2019-12-27 11:30:45.310009','2019-12-27 04:08:17.020487',0,0,12,8);
INSERT INTO "oneid_meta_deptperm" VALUES(221,'fb405529b65c4c068312b57cfa64d645',0,1,'2019-12-27 11:30:45.478496','2019-12-27 04:08:17.022504',0,0,12,9);
INSERT INTO "oneid_meta_deptperm" VALUES(222,'23695acf75294d1ab4efd333897e430b',0,1,'2019-12-27 11:30:45.650179','2019-12-27 04:08:17.024520',0,0,12,10);
INSERT INTO "oneid_meta_deptperm" VALUES(223,'5db398b525d2419898d37ef0e716894c',0,1,'2019-12-27 11:30:45.816675','2019-12-27 04:08:17.026848',0,0,12,11);
INSERT INTO "oneid_meta_deptperm" VALUES(224,'7d665169a6124aceba36e8438337ef51',0,1,'2019-12-27 11:30:46.155468','2019-12-27 04:08:17.028931',0,0,12,12);
INSERT INTO "oneid_meta_deptperm" VALUES(225,'0c753e7d492e4116b38a5f97966fd0cd',0,1,'2019-12-27 11:30:46.321166','2019-12-27 04:08:17.031111',0,0,12,13);
INSERT INTO "oneid_meta_deptperm" VALUES(226,'72b98453bbfb4b89afac06ab9f685017',0,1,'2019-12-27 11:30:46.485102','2019-12-27 04:08:17.033207',0,0,12,14);
INSERT INTO "oneid_meta_deptperm" VALUES(227,'f93684dd8627468b905eb74528c4cc2b',0,1,'2019-12-27 11:30:46.656574','2019-12-27 04:08:17.035265',0,0,12,15);
INSERT INTO "oneid_meta_deptperm" VALUES(228,'bdaecde365dd458da66cde7245852f6d',0,1,'2019-12-27 11:30:46.817972','2019-12-27 04:08:17.037267',0,0,12,16);
INSERT INTO "oneid_meta_deptperm" VALUES(229,'4bc321cc857e45bc81af9ca90d2e1ac7',0,1,'2019-12-27 11:30:47.148588','2019-12-27 04:08:17.039182',0,0,12,17);
INSERT INTO "oneid_meta_deptperm" VALUES(230,'a2f65cfa3db8472699fdd099b9c0eeb7',0,1,'2019-12-27 11:30:48.144865','2019-12-27 04:08:17.041320',0,0,12,18);
INSERT INTO "oneid_meta_deptperm" VALUES(231,'cefaa84aa02f43f7b2d5e735ea171ae1',0,1,'2019-12-27 11:30:49.173338','2019-12-27 04:08:17.043294',0,0,12,19);
INSERT INTO "oneid_meta_deptperm" VALUES(232,'4f1140e5d55b40058acebe2cad628b4e',0,1,'2019-12-27 11:30:44.831797','2019-12-27 04:08:17.200542',0,0,13,1);
INSERT INTO "oneid_meta_deptperm" VALUES(233,'5032c026f9fd4789aee5b2d6833ad434',0,1,'2019-12-27 11:30:44.989298','2019-12-27 04:08:17.203407',0,0,13,2);
INSERT INTO "oneid_meta_deptperm" VALUES(234,'d591b6b789404003b45b37a06aa51e1b',0,1,'2019-12-27 11:30:45.988491','2019-12-27 04:08:17.205751',0,0,13,3);
INSERT INTO "oneid_meta_deptperm" VALUES(235,'0f03ada8569a48d09d2b6fcc3863b945',0,1,'2019-12-27 11:30:46.991020','2019-12-27 04:08:17.217035',0,0,13,4);
INSERT INTO "oneid_meta_deptperm" VALUES(236,'416997de00a6477fa13fa46f49716138',0,1,'2019-12-27 11:30:47.987026','2019-12-27 04:08:17.221889',0,0,13,5);
INSERT INTO "oneid_meta_deptperm" VALUES(237,'de1b4bed96dc4b8b8c5ddb45b0f550de',0,1,'2019-12-27 11:30:49.019803','2019-12-27 04:08:17.225042',0,0,13,6);
INSERT INTO "oneid_meta_deptperm" VALUES(238,'3340dd2da92c4b949d0b8c8ed7b3b23d',0,1,'2019-12-27 11:30:45.317460','2019-12-27 04:08:17.230621',0,0,13,8);
INSERT INTO "oneid_meta_deptperm" VALUES(239,'325524c4f27d4c8abc284dd6a71bcc81',0,1,'2019-12-27 11:30:45.486509','2019-12-27 04:08:17.234303',0,0,13,9);
INSERT INTO "oneid_meta_deptperm" VALUES(240,'160218b1ae6d4913879cca76ffcebaaf',0,1,'2019-12-27 11:30:45.657449','2019-12-27 04:08:17.237379',0,0,13,10);
INSERT INTO "oneid_meta_deptperm" VALUES(241,'f0e07dec5cdf43718eb3865ed0ec6276',0,1,'2019-12-27 11:30:45.824064','2019-12-27 04:08:17.240054',0,0,13,11);
INSERT INTO "oneid_meta_deptperm" VALUES(242,'cea5892e644c44229da31e5bd38b12f9',0,1,'2019-12-27 11:30:46.163135','2019-12-27 04:08:17.242729',0,0,13,12);
INSERT INTO "oneid_meta_deptperm" VALUES(243,'20b7306d4a5847d28d84c1b4dee648ef',0,1,'2019-12-27 11:30:46.328793','2019-12-27 04:08:17.245904',0,0,13,13);
INSERT INTO "oneid_meta_deptperm" VALUES(244,'74e96747d3234ed397ef8d3e61838737',0,1,'2019-12-27 11:30:46.492920','2019-12-27 04:08:17.248654',0,0,13,14);
INSERT INTO "oneid_meta_deptperm" VALUES(245,'8ae0c7ad2734414081bcada32e3df84d',0,1,'2019-12-27 11:30:46.663882','2019-12-27 04:08:17.251320',0,0,13,15);
INSERT INTO "oneid_meta_deptperm" VALUES(246,'83d16b8c3df44afb990d0b073224e900',0,1,'2019-12-27 11:30:46.825488','2019-12-27 04:08:17.254270',0,0,13,16);
INSERT INTO "oneid_meta_deptperm" VALUES(247,'93bb72d1bfc141d9bf5a4f18159b050c',0,1,'2019-12-27 11:30:47.156316','2019-12-27 04:08:17.257800',0,0,13,17);
INSERT INTO "oneid_meta_deptperm" VALUES(248,'66e7bfdc4f26412c8d2c610a078ddd1f',0,1,'2019-12-27 11:30:48.153089','2019-12-27 04:08:17.260555',0,0,13,18);
INSERT INTO "oneid_meta_deptperm" VALUES(249,'d69854db02254048a318d4250c17ab21',0,1,'2019-12-27 11:30:49.181117','2019-12-27 04:08:17.263234',0,0,13,19);
INSERT INTO "oneid_meta_deptperm" VALUES(250,'280972bfad6e45578426b39cf3e46480',0,1,'2019-12-27 11:30:44.836713','2019-12-27 04:08:17.489836',0,0,14,1);
INSERT INTO "oneid_meta_deptperm" VALUES(251,'30404dc8d5f745d3a31ae1b925970d89',0,1,'2019-12-27 11:30:44.996888','2019-12-27 04:08:17.491920',0,0,14,2);
INSERT INTO "oneid_meta_deptperm" VALUES(252,'95f21e1374234d3ba1d5eff49c42f328',0,1,'2019-12-27 11:30:45.997208','2019-12-27 04:08:17.494595',0,0,14,3);
INSERT INTO "oneid_meta_deptperm" VALUES(253,'bb4178e379b84d8f94366708604e5d0a',0,1,'2019-12-27 11:30:46.998804','2019-12-27 04:08:17.499227',0,0,14,4);
INSERT INTO "oneid_meta_deptperm" VALUES(254,'708cff98197546e29d5a86eaed37c80f',0,1,'2019-12-27 11:30:47.995503','2019-12-27 04:08:17.501867',0,0,14,5);
INSERT INTO "oneid_meta_deptperm" VALUES(255,'a5169d4e441a40c8a4555a9b35c951b9',0,1,'2019-12-27 11:30:49.027144','2019-12-27 04:08:17.504059',0,0,14,6);
INSERT INTO "oneid_meta_deptperm" VALUES(256,'e5df95f3c2454fd8a44ac9974d52d670',0,1,'2019-12-27 11:30:45.325009','2019-12-27 04:08:17.506734',0,0,14,8);
INSERT INTO "oneid_meta_deptperm" VALUES(257,'e925e556665941aebd94b5294f223944',0,1,'2019-12-27 11:30:45.494070','2019-12-27 04:08:17.508739',0,0,14,9);
INSERT INTO "oneid_meta_deptperm" VALUES(258,'73e3cc1beebc478ea581bf1a335a26f4',0,1,'2019-12-27 11:30:45.665237','2019-12-27 04:08:17.512953',0,0,14,10);
INSERT INTO "oneid_meta_deptperm" VALUES(259,'97ec8af637a2415cb36d95c5fcf0856c',0,1,'2019-12-27 11:30:45.831665','2019-12-27 04:08:17.516715',0,0,14,11);
INSERT INTO "oneid_meta_deptperm" VALUES(260,'77aa5545108145a486eef589eb16b9de',0,1,'2019-12-27 11:30:46.170778','2019-12-27 04:08:17.519017',0,0,14,12);
INSERT INTO "oneid_meta_deptperm" VALUES(261,'ac57a37683ee4f8ebcf5ab7235a8ddb7',0,1,'2019-12-27 11:30:46.336283','2019-12-27 04:08:17.521535',0,0,14,13);
INSERT INTO "oneid_meta_deptperm" VALUES(262,'07a0551fe9b94664b093f7d9882cfbca',0,1,'2019-12-27 11:30:46.500432','2019-12-27 04:08:17.523837',0,0,14,14);
INSERT INTO "oneid_meta_deptperm" VALUES(263,'79fa53af988e4de0b0496f5498144c86',0,1,'2019-12-27 11:30:46.671441','2019-12-27 04:08:17.525980',0,0,14,15);
INSERT INTO "oneid_meta_deptperm" VALUES(264,'45a10e5d40434334998b1a95ebeed47e',0,1,'2019-12-27 11:30:46.833104','2019-12-27 04:08:17.530402',0,0,14,16);
INSERT INTO "oneid_meta_deptperm" VALUES(265,'cc549a9bdaa24c0fa1e3a99b14123d21',0,1,'2019-12-27 11:30:47.164081','2019-12-27 04:08:17.534162',0,0,14,17);
INSERT INTO "oneid_meta_deptperm" VALUES(266,'f3fb2773dfff4aeb8487b260e68dcb96',0,1,'2019-12-27 11:30:48.160348','2019-12-27 04:08:17.536739',0,0,14,18);
INSERT INTO "oneid_meta_deptperm" VALUES(267,'049d2ac7a9f1434c8bf3dddacdb4eeee',0,1,'2019-12-27 11:30:49.188728','2019-12-27 04:08:17.538751',0,0,14,19);
INSERT INTO "oneid_meta_deptperm" VALUES(268,'cf0f01daa20e4dc9a4493ee4f181a75b',0,1,'2019-12-27 11:30:44.841578','2019-12-27 04:08:17.724062',0,0,15,1);
INSERT INTO "oneid_meta_deptperm" VALUES(269,'46949713e72441aeb081b04126d8e94c',0,1,'2019-12-27 11:30:45.004355','2019-12-27 04:08:17.726614',0,0,15,2);
INSERT INTO "oneid_meta_deptperm" VALUES(270,'0c3c40e9b2aa48498bcb65b32e963576',0,1,'2019-12-27 11:30:46.005180','2019-12-27 04:08:17.729525',0,0,15,3);
INSERT INTO "oneid_meta_deptperm" VALUES(271,'20d2fb40e4234fa080e2f1b0a46b5fe8',0,1,'2019-12-27 11:30:47.006387','2019-12-27 04:08:17.731688',0,0,15,4);
INSERT INTO "oneid_meta_deptperm" VALUES(272,'f4321fe9a5f647c0a36426a641a025ac',0,1,'2019-12-27 11:30:48.003488','2019-12-27 04:08:17.733648',0,0,15,5);
INSERT INTO "oneid_meta_deptperm" VALUES(273,'010b4b8bda054aa49b28afddea25a516',0,1,'2019-12-27 11:30:49.034922','2019-12-27 04:08:17.736461',0,0,15,6);
INSERT INTO "oneid_meta_deptperm" VALUES(274,'8d6e4fbfe53645d9b94d6578a1cf55e6',0,1,'2019-12-27 11:30:45.332296','2019-12-27 04:08:17.739525',0,0,15,8);
INSERT INTO "oneid_meta_deptperm" VALUES(275,'6a9645ddaae142479b5584d8ec686ebf',0,1,'2019-12-27 11:30:45.501820','2019-12-27 04:08:17.741541',0,0,15,9);
INSERT INTO "oneid_meta_deptperm" VALUES(276,'4dbcabc8782d4af1922e8a95ae71ee64',0,1,'2019-12-27 11:30:45.672667','2019-12-27 04:08:17.743569',0,0,15,10);
INSERT INTO "oneid_meta_deptperm" VALUES(277,'09146f14aa6e4495ba49717f157fd21b',0,1,'2019-12-27 11:30:45.839307','2019-12-27 04:08:17.746214',0,0,15,11);
INSERT INTO "oneid_meta_deptperm" VALUES(278,'a49250549e1e49eb90272f21383746a0',0,1,'2019-12-27 11:30:46.179929','2019-12-27 04:08:17.748557',0,0,15,12);
INSERT INTO "oneid_meta_deptperm" VALUES(279,'0cbda67fb62843cba2b376bcc2cf280d',0,1,'2019-12-27 11:30:46.344010','2019-12-27 04:08:17.750686',0,0,15,13);
INSERT INTO "oneid_meta_deptperm" VALUES(280,'147f8eb15fe14408b1ef2e8c1302b959',0,1,'2019-12-27 11:30:46.508145','2019-12-27 04:08:17.752736',0,0,15,14);
INSERT INTO "oneid_meta_deptperm" VALUES(281,'49bb53c0255f43908508a7cbf632f69a',0,1,'2019-12-27 11:30:46.678861','2019-12-27 04:08:17.754702',0,0,15,15);
INSERT INTO "oneid_meta_deptperm" VALUES(282,'7b9f8d8abe644ebf9e750d7f81156d85',0,1,'2019-12-27 11:30:46.840638','2019-12-27 04:08:17.756718',0,0,15,16);
INSERT INTO "oneid_meta_deptperm" VALUES(283,'a4a3c4d7f1404192a0c5b1696871896f',0,1,'2019-12-27 11:30:47.171822','2019-12-27 04:08:17.759833',0,0,15,17);
INSERT INTO "oneid_meta_deptperm" VALUES(284,'1acf395f8f6847a3b6e22328a8a1ba0c',0,1,'2019-12-27 11:30:48.167951','2019-12-27 04:08:17.762246',0,0,15,18);
INSERT INTO "oneid_meta_deptperm" VALUES(285,'154122c6e49e40de95c58b25a56a8194',0,1,'2019-12-27 11:30:49.196417','2019-12-27 04:08:17.764289',0,0,15,19);
INSERT INTO "oneid_meta_deptperm" VALUES(286,'34fd994b5dd3497b973a2d365f8f69a4',0,1,'2019-12-27 11:30:44.846473','2019-12-27 04:08:17.985299',0,0,16,1);
INSERT INTO "oneid_meta_deptperm" VALUES(287,'39b08a5e345a4dd68215c35ad95c636c',0,1,'2019-12-27 11:30:45.012090','2019-12-27 04:08:17.987452',0,0,16,2);
INSERT INTO "oneid_meta_deptperm" VALUES(288,'997839f88773431397806f09e8912e71',0,1,'2019-12-27 11:30:46.013251','2019-12-27 04:08:17.989416',0,0,16,3);
INSERT INTO "oneid_meta_deptperm" VALUES(289,'86d08b5440234b13a6059460e8b52356',0,1,'2019-12-27 11:30:47.014246','2019-12-27 04:08:17.991419',0,0,16,4);
INSERT INTO "oneid_meta_deptperm" VALUES(290,'5cbfe204977f442f9e8c8b152305e280',0,1,'2019-12-27 11:30:48.011168','2019-12-27 04:08:17.993795',0,0,16,5);
INSERT INTO "oneid_meta_deptperm" VALUES(291,'7cbc200906de4b559e5be9b5fa30b78b',0,1,'2019-12-27 11:30:49.042250','2019-12-27 04:08:17.996615',0,0,16,6);
INSERT INTO "oneid_meta_deptperm" VALUES(292,'6d3e93fd389a435caf0b24811d7f3292',0,1,'2019-12-27 11:30:45.178694','2019-12-27 04:08:17.999746',0,0,16,7);
INSERT INTO "oneid_meta_deptperm" VALUES(293,'d5711bf22edb4833ac05a84af647a852',0,1,'2019-12-27 11:30:45.340980','2019-12-27 04:08:18.002038',0,0,16,8);
INSERT INTO "oneid_meta_deptperm" VALUES(294,'e536cbfb325d4d7fbbd00a54fcd2ef74',0,1,'2019-12-27 11:30:45.510998','2019-12-27 04:08:18.004122',0,0,16,9);
INSERT INTO "oneid_meta_deptperm" VALUES(295,'328e8c3bf2c048278df40d4e51c2a33e',0,1,'2019-12-27 11:30:45.680467','2019-12-27 04:08:18.006597',0,0,16,10);
INSERT INTO "oneid_meta_deptperm" VALUES(296,'58ecdbcad26a44429837ce10f9c6dc68',0,1,'2019-12-27 11:30:45.847282','2019-12-27 04:08:18.008773',0,0,16,11);
INSERT INTO "oneid_meta_deptperm" VALUES(297,'99f9e651ca924dd6b1a89da1416ab945',0,1,'2019-12-27 11:30:46.189016','2019-12-27 04:08:18.010821',0,0,16,12);
INSERT INTO "oneid_meta_deptperm" VALUES(298,'22ed87dd995e4ae5bb9c377855104ee8',0,1,'2019-12-27 11:30:46.351878','2019-12-27 04:08:18.012959',0,0,16,13);
INSERT INTO "oneid_meta_deptperm" VALUES(299,'10c9f613241244ca96c01cf7246615a1',0,1,'2019-12-27 11:30:46.515693','2019-12-27 04:08:18.016384',0,0,16,14);
INSERT INTO "oneid_meta_deptperm" VALUES(300,'1fcecfb3ea084c4dbec6a9ed5acc019e',0,1,'2019-12-27 11:30:46.686621','2019-12-27 04:08:18.019001',0,0,16,15);
INSERT INTO "oneid_meta_deptperm" VALUES(301,'67d14e078e5b4a8d83f297c9c1c0cebb',0,1,'2019-12-27 11:30:46.848976','2019-12-27 04:08:18.021306',0,0,16,16);
INSERT INTO "oneid_meta_deptperm" VALUES(302,'92d3f55d4bc4487ea88b15179f4dd072',0,1,'2019-12-27 11:30:47.179240','2019-12-27 04:08:18.023475',0,0,16,17);
INSERT INTO "oneid_meta_deptperm" VALUES(303,'a743546df2b5443697e79214d1684969',0,1,'2019-12-27 11:30:48.175313','2019-12-27 04:08:18.025479',0,0,16,18);
INSERT INTO "oneid_meta_deptperm" VALUES(304,'606688f5e55c46f59cd228288a61946f',0,1,'2019-12-27 11:30:49.204369','2019-12-27 04:08:18.028053',0,0,16,19);
INSERT INTO "oneid_meta_deptperm" VALUES(305,'feb9b26be62e4a7b9301d728ddfe18b8',0,1,'2019-12-27 11:30:44.851148','2019-12-27 04:08:18.221204',0,0,17,1);
INSERT INTO "oneid_meta_deptperm" VALUES(306,'e5f166eb702a42448bd2a219acd38670',0,1,'2019-12-27 11:30:45.019660','2019-12-27 04:08:18.223656',0,0,17,2);
INSERT INTO "oneid_meta_deptperm" VALUES(307,'792df0459a514142a7b787188d3edd8f',0,1,'2019-12-27 11:30:46.022528','2019-12-27 04:08:18.226054',0,0,17,3);
INSERT INTO "oneid_meta_deptperm" VALUES(308,'64be91d68c094747af7517369794b28a',0,1,'2019-12-27 11:30:47.021639','2019-12-27 04:08:18.228483',0,0,17,4);
INSERT INTO "oneid_meta_deptperm" VALUES(309,'c5d999d5d7d54de0ad72180fe87d07a6',0,1,'2019-12-27 11:30:48.019021','2019-12-27 04:08:18.231598',0,0,17,5);
INSERT INTO "oneid_meta_deptperm" VALUES(310,'ce7a877ff350486e9ac18a274f766dbd',0,1,'2019-12-27 11:30:49.049906','2019-12-27 04:08:18.234524',0,0,17,6);
INSERT INTO "oneid_meta_deptperm" VALUES(311,'448c1b2cf97848c88a6efbaf9716ceba',0,1,'2019-12-27 11:30:45.186978','2019-12-27 04:08:18.237611',0,0,17,7);
INSERT INTO "oneid_meta_deptperm" VALUES(312,'08581098573f472cbffa3b0fdf50055c',0,1,'2019-12-27 11:30:45.348352','2019-12-27 04:08:18.240314',0,0,17,8);
INSERT INTO "oneid_meta_deptperm" VALUES(313,'1222c9679f334c11970f17b19eff9225',0,1,'2019-12-27 11:30:45.522329','2019-12-27 04:08:18.244423',0,0,17,9);
INSERT INTO "oneid_meta_deptperm" VALUES(314,'a79495d890904433bc80f4f34bbbd52d',0,1,'2019-12-27 11:30:45.688146','2019-12-27 04:08:18.247884',0,0,17,10);
INSERT INTO "oneid_meta_deptperm" VALUES(315,'e55230651e4442438552bffadbb78df5',0,1,'2019-12-27 11:30:45.854726','2019-12-27 04:08:18.250400',0,0,17,11);
INSERT INTO "oneid_meta_deptperm" VALUES(316,'ab7e2fbcfedc4ad8b70ccbdc2aef5e93',0,1,'2019-12-27 11:30:46.196959','2019-12-27 04:08:18.253239',0,0,17,12);
INSERT INTO "oneid_meta_deptperm" VALUES(317,'0d2798700b254eecaed04177de2a67b0',0,1,'2019-12-27 11:30:46.359654','2019-12-27 04:08:18.255765',0,0,17,13);
INSERT INTO "oneid_meta_deptperm" VALUES(318,'9de0bdfd103e47979d2b16762b841cca',0,1,'2019-12-27 11:30:46.523405','2019-12-27 04:08:18.258118',0,0,17,14);
INSERT INTO "oneid_meta_deptperm" VALUES(319,'57d30bd159ab4420b91cc11bae36a313',0,1,'2019-12-27 11:30:46.694146','2019-12-27 04:08:18.260546',0,0,17,15);
INSERT INTO "oneid_meta_deptperm" VALUES(320,'ea2b6f2c53ae4274893f5730699a9d98',0,1,'2019-12-27 11:30:46.856188','2019-12-27 04:08:18.263538',0,0,17,16);
INSERT INTO "oneid_meta_deptperm" VALUES(321,'707d7169c9fc41d7b435f3fc29bf24a0',0,1,'2019-12-27 11:30:47.187013','2019-12-27 04:08:18.266409',0,0,17,17);
INSERT INTO "oneid_meta_deptperm" VALUES(322,'04bb1861c58c4d27bc0a765d7d869ab3',0,1,'2019-12-27 11:30:48.182885','2019-12-27 04:08:18.268730',0,0,17,18);
INSERT INTO "oneid_meta_deptperm" VALUES(323,'3d683c9944334001ae6a5d4c5fa06f11',0,1,'2019-12-27 11:30:49.212110','2019-12-27 04:08:18.271026',0,0,17,19);
INSERT INTO "oneid_meta_deptperm" VALUES(324,'48930accece748f49ba2f17d94f89d12',0,1,'2019-12-27 11:30:44.855754','2019-12-27 04:08:18.462117',0,0,18,1);
INSERT INTO "oneid_meta_deptperm" VALUES(325,'bce73a18f1474ca488c573fd0e83d9b6',0,1,'2019-12-27 11:30:45.027271','2019-12-27 04:08:18.464303',0,0,18,2);
INSERT INTO "oneid_meta_deptperm" VALUES(326,'1d944d33d9eb41178aba5e5f09134110',0,1,'2019-12-27 11:30:46.030072','2019-12-27 04:08:18.466640',0,0,18,3);
INSERT INTO "oneid_meta_deptperm" VALUES(327,'616b5da46d0541ba8e810b7090b9e3ba',0,1,'2019-12-27 11:30:47.029171','2019-12-27 04:08:18.469021',0,0,18,4);
INSERT INTO "oneid_meta_deptperm" VALUES(328,'9ee35dc28df24c12ae6375abc804e645',0,1,'2019-12-27 11:30:48.026281','2019-12-27 04:08:18.470969',0,0,18,5);
INSERT INTO "oneid_meta_deptperm" VALUES(329,'5bf5612e2e8e4640af28e82affe0c665',0,1,'2019-12-27 11:30:49.057041','2019-12-27 04:08:18.473052',0,0,18,6);
INSERT INTO "oneid_meta_deptperm" VALUES(330,'2276795956184862a4e90df03a4dd18e',0,1,'2019-12-27 11:30:45.194543','2019-12-27 04:08:18.474986',0,0,18,7);
INSERT INTO "oneid_meta_deptperm" VALUES(331,'a23dde094e4640cebb303afe25b968d7',0,1,'2019-12-27 11:30:45.356037','2019-12-27 04:08:18.477033',0,0,18,8);
INSERT INTO "oneid_meta_deptperm" VALUES(332,'a0abbb8985444272b198318069983ab7',0,1,'2019-12-27 11:30:45.533206','2019-12-27 04:08:18.479248',0,0,18,9);
INSERT INTO "oneid_meta_deptperm" VALUES(333,'ad5ab94a973d444f9aa0241b535d72f8',0,1,'2019-12-27 11:30:45.696892','2019-12-27 04:08:18.481237',0,0,18,10);
INSERT INTO "oneid_meta_deptperm" VALUES(334,'05c8b7bbbc0a4696b1f336eef5e8ffa1',0,1,'2019-12-27 11:30:45.862215','2019-12-27 04:08:18.483517',0,0,18,11);
INSERT INTO "oneid_meta_deptperm" VALUES(335,'06be0eca56474a46afabb48d46fa7029',0,1,'2019-12-27 11:30:46.204345','2019-12-27 04:08:18.485536',0,0,18,12);
INSERT INTO "oneid_meta_deptperm" VALUES(336,'ff883ead3c0847eaa1d0ad6324259207',0,1,'2019-12-27 11:30:46.367475','2019-12-27 04:08:18.487480',0,0,18,13);
INSERT INTO "oneid_meta_deptperm" VALUES(337,'daa7b4ce818b488782af8679583027dd',0,1,'2019-12-27 11:30:46.531865','2019-12-27 04:08:18.489642',0,0,18,14);
INSERT INTO "oneid_meta_deptperm" VALUES(338,'e5c8beb34c114fb7a9403b20c247ea59',0,1,'2019-12-27 11:30:46.701862','2019-12-27 04:08:18.491623',0,0,18,15);
INSERT INTO "oneid_meta_deptperm" VALUES(339,'a3f3a3a2110345958d222e8d24ce8fc5',0,1,'2019-12-27 11:30:46.863760','2019-12-27 04:08:18.493606',0,0,18,16);
INSERT INTO "oneid_meta_deptperm" VALUES(340,'24ebea3e5d8d4137935a2e55e3075038',0,1,'2019-12-27 11:30:47.194819','2019-12-27 04:08:18.495545',0,0,18,17);
INSERT INTO "oneid_meta_deptperm" VALUES(341,'20255f3d03e64388a63769fe2ceaeabe',0,1,'2019-12-27 11:30:48.190280','2019-12-27 04:08:18.497566',0,0,18,18);
INSERT INTO "oneid_meta_deptperm" VALUES(342,'4c7c34c130c8460e9344d93487e8ee96',0,1,'2019-12-27 11:30:49.219531','2019-12-27 04:08:18.500057',0,0,18,19);
INSERT INTO "oneid_meta_deptperm" VALUES(343,'7cd4ccfc5c1a4108bb679ce9ae1746be',0,1,'2019-12-27 11:30:44.860447','2019-12-27 04:08:18.764574',0,0,19,1);
INSERT INTO "oneid_meta_deptperm" VALUES(344,'0dddabb5ec66481aab73d346e3ecf364',0,1,'2019-12-27 11:30:45.034850','2019-12-27 04:08:18.768025',0,0,19,2);
INSERT INTO "oneid_meta_deptperm" VALUES(345,'0ff62815bf434e5ea7618272a1a4ba06',0,1,'2019-12-27 11:30:46.039023','2019-12-27 04:08:18.770376',0,0,19,3);
INSERT INTO "oneid_meta_deptperm" VALUES(346,'69c7bfcd66a241f4bf38306c8c359147',0,1,'2019-12-27 11:30:47.036821','2019-12-27 04:08:18.772703',0,0,19,4);
INSERT INTO "oneid_meta_deptperm" VALUES(347,'a2e3ebcb42ee42f58ff36259218f893d',0,1,'2019-12-27 11:30:48.034033','2019-12-27 04:08:18.774807',0,0,19,5);
INSERT INTO "oneid_meta_deptperm" VALUES(348,'ef40bd3bb8134c14a94c5ff4df482c80',0,1,'2019-12-27 11:30:49.064790','2019-12-27 04:08:18.776952',0,0,19,6);
INSERT INTO "oneid_meta_deptperm" VALUES(349,'51c4330a31a54af981bec23188087f75',0,1,'2019-12-27 11:30:45.202414','2019-12-27 04:08:18.779532',0,0,19,7);
INSERT INTO "oneid_meta_deptperm" VALUES(350,'60418ca8cdcc4c939583da11bba800c3',0,1,'2019-12-27 11:30:45.363465','2019-12-27 04:08:18.782204',0,0,19,8);
INSERT INTO "oneid_meta_deptperm" VALUES(351,'fd2f6fc26ab245ecb009808c6f93cda4',0,1,'2019-12-27 11:30:45.541195','2019-12-27 04:08:18.784226',0,0,19,9);
INSERT INTO "oneid_meta_deptperm" VALUES(352,'5aaabb02e5c242ac819eac6c7040bc5c',0,1,'2019-12-27 11:30:45.705095','2019-12-27 04:08:18.786276',0,0,19,10);
INSERT INTO "oneid_meta_deptperm" VALUES(353,'16a096bf05fb48a6b5d95915255632e1',0,1,'2019-12-27 11:30:45.869420','2019-12-27 04:08:18.788429',0,0,19,11);
INSERT INTO "oneid_meta_deptperm" VALUES(354,'cb5236ced20d40eca5f849036dab479c',0,1,'2019-12-27 11:30:46.211926','2019-12-27 04:08:18.790413',0,0,19,12);
INSERT INTO "oneid_meta_deptperm" VALUES(355,'03667359349e4affa52e831d83899e32',0,1,'2019-12-27 11:30:46.374762','2019-12-27 04:08:18.792624',0,0,19,13);
INSERT INTO "oneid_meta_deptperm" VALUES(356,'86cd0e0315ca43eabe184157a855f7fd',0,1,'2019-12-27 11:30:46.542220','2019-12-27 04:08:18.794796',0,0,19,14);
INSERT INTO "oneid_meta_deptperm" VALUES(357,'d9e7885487534d6584316138aaf5d8ba',0,1,'2019-12-27 11:30:46.709175','2019-12-27 04:08:18.797352',0,0,19,15);
INSERT INTO "oneid_meta_deptperm" VALUES(358,'40b8d1b63084497482e20cc4dd53b42f',0,1,'2019-12-27 11:30:46.870997','2019-12-27 04:08:18.799685',0,0,19,16);
INSERT INTO "oneid_meta_deptperm" VALUES(359,'105367e5a361498b9ec37cd5b027e6d2',0,1,'2019-12-27 11:30:47.202507','2019-12-27 04:08:18.801716',0,0,19,17);
INSERT INTO "oneid_meta_deptperm" VALUES(360,'7ba6808e6af64f189b85037fb2d34a84',0,1,'2019-12-27 11:30:48.198337','2019-12-27 04:08:18.803945',0,0,19,18);
INSERT INTO "oneid_meta_deptperm" VALUES(361,'7877aa6278b14295b44f992b64cb922c',0,1,'2019-12-27 11:30:49.227297','2019-12-27 04:08:18.806001',0,0,19,19);
INSERT INTO "oneid_meta_deptperm" VALUES(362,'d733b10c64d54328b15c246443da744b',0,1,'2019-12-27 11:30:44.865021','2019-12-27 04:08:19.074136',0,0,20,1);
INSERT INTO "oneid_meta_deptperm" VALUES(363,'eafe21077eb947df9815936853160f21',0,1,'2019-12-27 11:30:45.037404','2019-12-27 04:08:19.076396',1,1,20,2);
INSERT INTO "oneid_meta_deptperm" VALUES(364,'ff8e97fcc5be4fc39cdc0e3b7facab1c',0,1,'2019-12-27 11:30:46.046626','2019-12-27 04:08:19.078358',0,0,20,3);
INSERT INTO "oneid_meta_deptperm" VALUES(365,'f9cf0617fe12410e931de89a29a9139f',0,1,'2019-12-27 11:30:47.044486','2019-12-27 04:08:19.080924',0,0,20,4);
INSERT INTO "oneid_meta_deptperm" VALUES(366,'49629c31321c415aa195e728c51a2ebc',0,1,'2019-12-27 11:30:48.041419','2019-12-27 04:08:19.085111',0,0,20,5);
INSERT INTO "oneid_meta_deptperm" VALUES(367,'d75c598395544e7296ec23c59b81b436',0,1,'2019-12-27 11:30:49.072156','2019-12-27 04:08:19.087717',0,0,20,6);
INSERT INTO "oneid_meta_deptperm" VALUES(368,'30eb7ba39026480a86da191af91ce6b3',0,1,'2019-12-27 11:30:45.209876','2019-12-27 04:08:19.089892',0,1,20,7);
INSERT INTO "oneid_meta_deptperm" VALUES(369,'3d83aad33c9947568aa7d282dfd10db4',0,1,'2019-12-27 11:30:45.371109','2019-12-27 04:08:19.092155',0,1,20,8);
INSERT INTO "oneid_meta_deptperm" VALUES(370,'07e6bd3db2f84b289ac79bec71358312',0,1,'2019-12-27 11:30:45.549192','2019-12-27 04:08:19.094197',0,1,20,9);
INSERT INTO "oneid_meta_deptperm" VALUES(371,'e95d183c057f41848d5edc1bbe1564c3',0,1,'2019-12-27 11:30:45.713206','2019-12-27 04:08:19.100097',0,1,20,10);
INSERT INTO "oneid_meta_deptperm" VALUES(372,'f26a3414e37744c8a5ada21ad0627a28',0,1,'2019-12-27 11:30:45.877188','2019-12-27 04:08:19.104615',0,1,20,11);
INSERT INTO "oneid_meta_deptperm" VALUES(373,'4b5dbebd7459401480c6b9f197f34bff',0,1,'2019-12-27 11:30:46.220057','2019-12-27 04:08:19.107077',0,0,20,12);
INSERT INTO "oneid_meta_deptperm" VALUES(374,'1cdf7c4ad58f48f69ab9226762496bee',0,1,'2019-12-27 11:30:46.382397','2019-12-27 04:08:19.109455',0,0,20,13);
INSERT INTO "oneid_meta_deptperm" VALUES(375,'bcd452054c664870afce8beb6249fa29',0,1,'2019-12-27 11:30:46.551468','2019-12-27 04:08:19.111502',0,0,20,14);
INSERT INTO "oneid_meta_deptperm" VALUES(376,'cbe2c129699448c9a67928817cc45b3a',0,1,'2019-12-27 11:30:46.716825','2019-12-27 04:08:19.114368',0,0,20,15);
INSERT INTO "oneid_meta_deptperm" VALUES(377,'79abc6b0242148a1930c54bd9efda543',0,1,'2019-12-27 11:30:46.878533','2019-12-27 04:08:19.117666',0,0,20,16);
INSERT INTO "oneid_meta_deptperm" VALUES(378,'bb173d1e132b4f60ab372cc6269281e4',0,1,'2019-12-27 11:30:47.209846','2019-12-27 04:08:19.120715',0,0,20,17);
INSERT INTO "oneid_meta_deptperm" VALUES(379,'01262279ad6241e3acda17f420e8f298',0,1,'2019-12-27 11:30:48.205663','2019-12-27 04:08:19.123170',0,0,20,18);
INSERT INTO "oneid_meta_deptperm" VALUES(380,'a35609a58a3a42cb822544283b7cb596',0,1,'2019-12-27 11:30:49.236950','2019-12-27 04:08:19.125295',0,0,20,19);
INSERT INTO "oneid_meta_deptperm" VALUES(381,'dccb70053a644821b32e3f4dd2a0d46e',0,1,'2019-12-27 11:30:44.871018','2019-12-27 04:08:19.312424',0,0,21,1);
INSERT INTO "oneid_meta_deptperm" VALUES(382,'1624309d9bd64402a82559b99162e9c1',0,1,'2019-12-27 11:30:45.045294','2019-12-27 04:08:19.314649',0,0,21,2);
INSERT INTO "oneid_meta_deptperm" VALUES(383,'f84a15316e2c4a4b8471c0991d32c948',0,1,'2019-12-27 11:30:46.054266','2019-12-27 04:08:19.316666',0,0,21,3);
INSERT INTO "oneid_meta_deptperm" VALUES(384,'e6b081a11cda4eeb9bce1244d5fe119b',0,1,'2019-12-27 11:30:47.051991','2019-12-27 04:08:19.318605',0,0,21,4);
INSERT INTO "oneid_meta_deptperm" VALUES(385,'f53e2625b1c7473a9564739f92b5f5b7',0,1,'2019-12-27 11:30:48.049400','2019-12-27 04:08:19.320584',0,0,21,5);
INSERT INTO "oneid_meta_deptperm" VALUES(386,'32b872bd7cc746e6b7dfc74de2cf2436',0,1,'2019-12-27 11:30:49.079672','2019-12-27 04:08:19.323355',0,0,21,6);
INSERT INTO "oneid_meta_deptperm" VALUES(387,'558fb0c771004391bcd687a9d37db371',0,1,'2019-12-27 11:30:45.217592','2019-12-27 04:08:19.325589',0,0,21,7);
INSERT INTO "oneid_meta_deptperm" VALUES(388,'6091bceac3194275a75e3b6d8001f203',0,1,'2019-12-27 11:30:45.378730','2019-12-27 04:08:19.327643',0,0,21,8);
INSERT INTO "oneid_meta_deptperm" VALUES(389,'ded6b3c669f94cc6aeb424abdcaa72c4',0,1,'2019-12-27 11:30:45.556659','2019-12-27 04:08:19.329712',0,0,21,9);
INSERT INTO "oneid_meta_deptperm" VALUES(390,'4f5aded3b3744dcf8022742fab59bcb3',0,1,'2019-12-27 11:30:45.721469','2019-12-27 04:08:19.331806',0,0,21,10);
INSERT INTO "oneid_meta_deptperm" VALUES(391,'698f0f07f51b4788a6602b0a4756c3c7',0,1,'2019-12-27 11:30:45.884991','2019-12-27 04:08:19.335152',0,0,21,11);
INSERT INTO "oneid_meta_deptperm" VALUES(392,'eb2edeef12f34108b2dd926cd44132aa',0,1,'2019-12-27 11:30:46.227953','2019-12-27 04:08:19.337547',0,0,21,12);
INSERT INTO "oneid_meta_deptperm" VALUES(393,'481d8cecc51d4d458c61bf46a9fe2268',0,1,'2019-12-27 11:30:46.391616','2019-12-27 04:08:19.339584',0,0,21,13);
INSERT INTO "oneid_meta_deptperm" VALUES(394,'791b432f9f834be199d70c9bb1648122',0,1,'2019-12-27 11:30:46.559128','2019-12-27 04:08:19.341641',0,0,21,14);
INSERT INTO "oneid_meta_deptperm" VALUES(395,'26fc1d6380934fb29ab018ff4a845603',0,1,'2019-12-27 11:30:46.724233','2019-12-27 04:08:19.343970',0,0,21,15);
INSERT INTO "oneid_meta_deptperm" VALUES(396,'bd77be61d376409fa6233bb34624ee53',0,1,'2019-12-27 11:30:46.885940','2019-12-27 04:08:19.346222',0,0,21,16);
INSERT INTO "oneid_meta_deptperm" VALUES(397,'94f088b86bb44f7fabcc13cd5b3c16d2',0,1,'2019-12-27 11:30:47.217731','2019-12-27 04:08:19.348439',0,0,21,17);
INSERT INTO "oneid_meta_deptperm" VALUES(398,'a28f35c1164e46be94bf514e37689b16',0,1,'2019-12-27 11:30:48.213213','2019-12-27 04:08:19.350413',0,0,21,18);
INSERT INTO "oneid_meta_deptperm" VALUES(399,'b9ef8d2edfe6427390eae03f079e3933',0,1,'2019-12-27 11:30:49.249032','2019-12-27 04:08:19.352669',0,0,21,19);
INSERT INTO "oneid_meta_deptperm" VALUES(400,'26f190418da3429d8ad46e14c8584f16',0,1,'2019-12-27 11:30:47.227473','2019-12-27 11:10:50.149060',0,0,1,20);
INSERT INTO "oneid_meta_deptperm" VALUES(401,'46daf5a4449c4ed38c2a1a36315066a9',0,1,'2019-12-27 11:30:47.236397','2019-12-27 11:10:50.150542',0,0,2,20);
INSERT INTO "oneid_meta_deptperm" VALUES(402,'e3e8a562f15047e1a1405597c194cc2b',0,1,'2019-12-27 11:30:47.244140','2019-12-27 11:10:50.152399',0,0,3,20);
INSERT INTO "oneid_meta_deptperm" VALUES(403,'dc4b2f3ad4ba4e959d676bb26ad8612a',0,1,'2019-12-27 11:30:47.251950','2019-12-27 11:10:50.153649',0,0,4,20);
INSERT INTO "oneid_meta_deptperm" VALUES(404,'0a1100d4afbf4df6be8eb719dc5c3552',0,1,'2019-12-27 11:30:47.259608','2019-12-27 11:10:50.154903',0,0,5,20);
INSERT INTO "oneid_meta_deptperm" VALUES(405,'a9bb0b949238406bb7ccad1fc6d7778f',0,1,'2019-12-27 11:30:47.266972','2019-12-27 11:10:50.160483',0,0,6,20);
INSERT INTO "oneid_meta_deptperm" VALUES(406,'345a6f85501f4d07a8fd1e01ba5ef562',0,1,'2019-12-27 11:30:47.275176','2019-12-27 11:10:50.162205',0,0,7,20);
INSERT INTO "oneid_meta_deptperm" VALUES(407,'44f64dee478a44af9ead9be484620a72',0,1,'2019-12-27 11:30:47.283138','2019-12-27 11:10:50.163951',0,0,8,20);
INSERT INTO "oneid_meta_deptperm" VALUES(408,'bd643c30d9604dd18d7257cfbdf490a0',0,1,'2019-12-27 11:30:47.290934','2019-12-27 11:10:50.166824',0,0,9,20);
INSERT INTO "oneid_meta_deptperm" VALUES(409,'5acf4b4a8bdc45f4a6613de534183b7c',0,1,'2019-12-27 11:30:47.298727','2019-12-27 11:10:50.172295',0,0,10,20);
INSERT INTO "oneid_meta_deptperm" VALUES(410,'7a0aa2eab09d4606a7865639c41e3f1f',0,1,'2019-12-27 11:30:47.306307','2019-12-27 11:10:50.173625',0,0,11,20);
INSERT INTO "oneid_meta_deptperm" VALUES(411,'b71f1573a498483cbfd56eb5a84216a8',0,1,'2019-12-27 11:30:47.313662','2019-12-27 11:10:50.174917',0,0,12,20);
INSERT INTO "oneid_meta_deptperm" VALUES(412,'5c9f120684cb4c62a6eff7e1b8cd6eeb',0,1,'2019-12-27 11:30:47.321224','2019-12-27 11:10:50.177480',0,0,13,20);
INSERT INTO "oneid_meta_deptperm" VALUES(413,'8dd8b23eea9345cba5a3e87d00953c91',0,1,'2019-12-27 11:30:47.328654','2019-12-27 11:10:50.179404',0,0,14,20);
INSERT INTO "oneid_meta_deptperm" VALUES(414,'45940003412a483aaee2cb5d23243ccd',0,1,'2019-12-27 11:30:47.336296','2019-12-27 11:10:50.181418',0,0,15,20);
INSERT INTO "oneid_meta_deptperm" VALUES(415,'15a65f6e5efe422b957545a30f05c9b3',0,1,'2019-12-27 11:30:47.344361','2019-12-27 11:10:50.184394',0,0,16,20);
INSERT INTO "oneid_meta_deptperm" VALUES(416,'93bf4247e7e44d9582dc4adea03dd561',0,1,'2019-12-27 11:30:47.352250','2019-12-27 11:10:50.186988',0,0,17,20);
INSERT INTO "oneid_meta_deptperm" VALUES(417,'55e4525448d546b68a7d6df3782cda2c',0,1,'2019-12-27 11:30:47.359726','2019-12-27 11:10:50.188271',0,0,18,20);
INSERT INTO "oneid_meta_deptperm" VALUES(418,'add7ecd6082641318bed7c00f67f10a8',0,1,'2019-12-27 11:30:47.367650','2019-12-27 11:10:50.189764',0,0,19,20);
INSERT INTO "oneid_meta_deptperm" VALUES(419,'1556fb07a8eb4378879434115a0a1513',0,1,'2019-12-27 11:30:47.375176','2019-12-27 11:10:50.192719',0,0,20,20);
INSERT INTO "oneid_meta_deptperm" VALUES(420,'e9de84f1b7bb40f5b11e30bcb95a1b2e',0,1,'2019-12-27 11:30:47.382884','2019-12-27 11:10:50.194567',0,0,21,20);
INSERT INTO "oneid_meta_deptperm" VALUES(421,'9fe5173a25a84a3aaf3c0350150ec8e1',0,1,'2019-12-27 11:30:47.393450','2019-12-27 11:11:00.325453',0,0,1,21);
INSERT INTO "oneid_meta_deptperm" VALUES(422,'279cb13394a14480a2b390ac32b1d304',0,1,'2019-12-27 11:30:47.402094','2019-12-27 11:11:00.326871',0,0,2,21);
INSERT INTO "oneid_meta_deptperm" VALUES(423,'a5372aff202540b5938166e1b5b6a6ba',0,1,'2019-12-27 11:30:47.409838','2019-12-27 11:11:00.328185',0,0,3,21);
INSERT INTO "oneid_meta_deptperm" VALUES(424,'1c0af63f7ca94a8a8062c1f946eb9236',0,1,'2019-12-27 11:30:47.417470','2019-12-27 11:11:00.329707',0,0,4,21);
INSERT INTO "oneid_meta_deptperm" VALUES(425,'7d6a5881c2cc4ca7b09bf10312ccbcce',0,1,'2019-12-27 11:30:47.425162','2019-12-27 11:11:00.331611',0,0,5,21);
INSERT INTO "oneid_meta_deptperm" VALUES(426,'e20e4e9293214b7b865f042e9468c73e',0,1,'2019-12-27 11:30:47.432594','2019-12-27 11:11:00.332925',0,0,6,21);
INSERT INTO "oneid_meta_deptperm" VALUES(427,'97c03883672249ce964edb542cd7019d',0,1,'2019-12-27 11:30:47.440140','2019-12-27 11:11:00.334763',0,0,7,21);
INSERT INTO "oneid_meta_deptperm" VALUES(428,'9b353e80022b4f8192ad541060b0f228',0,1,'2019-12-27 11:30:47.448332','2019-12-27 11:11:00.336959',0,0,8,21);
INSERT INTO "oneid_meta_deptperm" VALUES(429,'49adeeb713bc4441ab6ed67947faec5d',0,1,'2019-12-27 11:30:47.455964','2019-12-27 11:11:00.338865',0,0,9,21);
INSERT INTO "oneid_meta_deptperm" VALUES(430,'86f906747d6643a7b150e58a066de91b',0,1,'2019-12-27 11:30:47.463431','2019-12-27 11:11:00.340705',0,0,10,21);
INSERT INTO "oneid_meta_deptperm" VALUES(431,'fa70e8ed91d34317b2878c4e7f639b84',0,1,'2019-12-27 11:30:47.471192','2019-12-27 11:11:00.342578',0,0,11,21);
INSERT INTO "oneid_meta_deptperm" VALUES(432,'07d6dd351b084811bd297b215d5d3c9f',0,1,'2019-12-27 11:30:47.478351','2019-12-27 11:11:00.344060',0,0,12,21);
INSERT INTO "oneid_meta_deptperm" VALUES(433,'d65dda44376146cbb470713122a314e5',0,1,'2019-12-27 11:30:47.486204','2019-12-27 11:11:00.345333',0,0,13,21);
INSERT INTO "oneid_meta_deptperm" VALUES(434,'8f4a904f250e4feabc6df3519a49a4fe',0,1,'2019-12-27 11:30:47.493821','2019-12-27 11:11:00.346571',0,0,14,21);
INSERT INTO "oneid_meta_deptperm" VALUES(435,'d2f74c3b19bd4f79b0ba1b20c9afe970',0,1,'2019-12-27 11:30:47.501427','2019-12-27 11:11:00.347962',0,0,15,21);
INSERT INTO "oneid_meta_deptperm" VALUES(436,'467bd600b84446f2bc64fc67b13920d8',0,1,'2019-12-27 11:30:47.508740','2019-12-27 11:11:00.349355',0,0,16,21);
INSERT INTO "oneid_meta_deptperm" VALUES(437,'fdd363828ff2498f8bc02025540945d7',0,1,'2019-12-27 11:30:47.516452','2019-12-27 11:11:00.351026',0,0,17,21);
INSERT INTO "oneid_meta_deptperm" VALUES(438,'1cb79de3e9ff4373b9a2082c70e98f3f',0,1,'2019-12-27 11:30:47.523913','2019-12-27 11:11:00.352991',0,0,18,21);
INSERT INTO "oneid_meta_deptperm" VALUES(439,'10bcf248ffb04c2f95f0eb4ff0bf3e8d',0,1,'2019-12-27 11:30:47.532161','2019-12-27 11:11:00.354896',0,0,19,21);
INSERT INTO "oneid_meta_deptperm" VALUES(440,'7e8866c8702c4940bb2efd2f6b2228d0',0,1,'2019-12-27 11:30:47.539688','2019-12-27 11:11:00.356378',0,0,20,21);
INSERT INTO "oneid_meta_deptperm" VALUES(441,'fe3750ebfd034164a6cc6303aeba9e39',0,1,'2019-12-27 11:30:47.547306','2019-12-27 11:11:00.357601',0,0,21,21);
INSERT INTO "oneid_meta_deptperm" VALUES(442,'904ce22f9aa44ff3a1bb3b138d65595a',0,1,'2019-12-27 11:30:47.555760','2019-12-27 11:11:09.440345',0,0,1,22);
INSERT INTO "oneid_meta_deptperm" VALUES(443,'ff018144aa7c460eaeba11e0035ed3e0',0,1,'2019-12-27 11:30:47.563448','2019-12-27 11:11:09.442078',0,0,2,22);
INSERT INTO "oneid_meta_deptperm" VALUES(444,'5d8b55114ca94f02af0dba7c6f2ea1d1',0,1,'2019-12-27 11:30:47.570785','2019-12-27 11:11:09.444306',0,0,3,22);
INSERT INTO "oneid_meta_deptperm" VALUES(445,'226685b4403845f1bcea30e2b8444663',0,1,'2019-12-27 11:30:47.578359','2019-12-27 11:11:09.446456',0,0,4,22);
INSERT INTO "oneid_meta_deptperm" VALUES(446,'7572661673e2406292e52d4bb1183b78',0,1,'2019-12-27 11:30:47.585710','2019-12-27 11:11:09.448373',0,0,5,22);
INSERT INTO "oneid_meta_deptperm" VALUES(447,'597e1909c87a4baab363f26da56e62cc',0,1,'2019-12-27 11:30:47.595557','2019-12-27 11:11:09.449717',0,0,6,22);
INSERT INTO "oneid_meta_deptperm" VALUES(448,'be5be5a7b97846ed85c4a2478eca3b87',0,1,'2019-12-27 11:30:47.605904','2019-12-27 11:11:09.451362',0,0,7,22);
INSERT INTO "oneid_meta_deptperm" VALUES(449,'d557b8e273644ffb9ca486c2512a0249',0,1,'2019-12-27 11:30:47.613377','2019-12-27 11:11:09.452645',0,0,8,22);
INSERT INTO "oneid_meta_deptperm" VALUES(450,'e1560fc3089741db940d1dcef87804e5',0,1,'2019-12-27 11:30:47.623435','2019-12-27 11:11:09.454166',0,0,9,22);
INSERT INTO "oneid_meta_deptperm" VALUES(451,'37070030d4f942c9920f65152442fd72',0,1,'2019-12-27 11:30:47.632285','2019-12-27 11:11:09.455719',0,0,10,22);
INSERT INTO "oneid_meta_deptperm" VALUES(452,'21e93bd9b2f54a048b6184d8b2fc75dc',0,1,'2019-12-27 11:30:47.641570','2019-12-27 11:11:09.457065',0,0,11,22);
INSERT INTO "oneid_meta_deptperm" VALUES(453,'f1fb1e51b9e34215b7cb547091257a6e',0,1,'2019-12-27 11:30:47.649623','2019-12-27 11:11:09.459056',0,0,12,22);
INSERT INTO "oneid_meta_deptperm" VALUES(454,'5d69007b60c04de8a8db3fba2b8de6ee',0,1,'2019-12-27 11:30:47.657004','2019-12-27 11:11:09.461124',0,0,13,22);
INSERT INTO "oneid_meta_deptperm" VALUES(455,'41ad2616ba504f69839320cdd02fd7d8',0,1,'2019-12-27 11:30:47.664647','2019-12-27 11:11:09.462721',0,0,14,22);
INSERT INTO "oneid_meta_deptperm" VALUES(456,'0f7a987996d841358fdb5cabf63820ac',0,1,'2019-12-27 11:30:47.672074','2019-12-27 11:11:09.464069',0,0,15,22);
INSERT INTO "oneid_meta_deptperm" VALUES(457,'e097b4e351ee4e08baea02f9e7bec458',0,1,'2019-12-27 11:30:47.680159','2019-12-27 11:11:09.465623',0,0,16,22);
INSERT INTO "oneid_meta_deptperm" VALUES(458,'316f3c47de574a6494440f238fd04f06',0,1,'2019-12-27 11:30:47.687633','2019-12-27 11:11:09.467088',0,0,17,22);
INSERT INTO "oneid_meta_deptperm" VALUES(459,'c3976007c2dc48e68699cfe00697b79e',0,1,'2019-12-27 11:30:47.695645','2019-12-27 11:11:09.468430',0,0,18,22);
INSERT INTO "oneid_meta_deptperm" VALUES(460,'a938b5679c634da1a82605164f3a8a21',0,1,'2019-12-27 11:30:47.703185','2019-12-27 11:11:09.469722',0,0,19,22);
INSERT INTO "oneid_meta_deptperm" VALUES(461,'d7427cfdc86145afba0c739b09379df0',0,1,'2019-12-27 11:30:47.711025','2019-12-27 11:11:09.471204',0,0,20,22);
INSERT INTO "oneid_meta_deptperm" VALUES(462,'f0cd401a5bc944f0bc011408e7d3b62e',0,1,'2019-12-27 11:30:47.718384','2019-12-27 11:11:09.472448',0,0,21,22);
INSERT INTO "oneid_meta_deptperm" VALUES(463,'f952ca7e6f314457adb0b24f5cf6a87e',0,1,'2019-12-27 11:30:47.727574','2019-12-27 11:11:17.374607',0,0,1,23);
INSERT INTO "oneid_meta_deptperm" VALUES(464,'f6f40210387a48fe9d531cdd1b244bcb',0,1,'2019-12-27 11:30:47.734791','2019-12-27 11:11:17.376396',0,0,2,23);
INSERT INTO "oneid_meta_deptperm" VALUES(465,'801c4d3f6cd84ab483b7431e4c147f24',0,1,'2019-12-27 11:30:47.742412','2019-12-27 11:11:17.377648',0,0,3,23);
INSERT INTO "oneid_meta_deptperm" VALUES(466,'5d96b0e77278427eb6e90734743153cf',0,1,'2019-12-27 11:30:47.749854','2019-12-27 11:11:17.379126',0,0,4,23);
INSERT INTO "oneid_meta_deptperm" VALUES(467,'b3ba98af011c49178d3b3fe5e35e5bd3',0,1,'2019-12-27 11:30:47.757387','2019-12-27 11:11:17.380541',0,0,5,23);
INSERT INTO "oneid_meta_deptperm" VALUES(468,'f9d43f8600a340a283eb1817b56d93c8',0,1,'2019-12-27 11:30:47.765024','2019-12-27 11:11:17.382253',0,0,6,23);
INSERT INTO "oneid_meta_deptperm" VALUES(469,'90d1c42c41f84ea4baff3b7d60b653ea',0,1,'2019-12-27 11:30:47.772877','2019-12-27 11:11:17.384416',0,0,7,23);
INSERT INTO "oneid_meta_deptperm" VALUES(470,'338d561b9ce74532a9c95008113c4ab0',0,1,'2019-12-27 11:30:47.780607','2019-12-27 11:11:17.386016',0,0,8,23);
INSERT INTO "oneid_meta_deptperm" VALUES(471,'9d6260b53c6242a99213bdfa88a9480b',0,1,'2019-12-27 11:30:47.788698','2019-12-27 11:11:17.387430',0,0,9,23);
INSERT INTO "oneid_meta_deptperm" VALUES(472,'e454075466ad4171b77edd985b0eab4b',0,1,'2019-12-27 11:30:47.796744','2019-12-27 11:11:17.388710',0,0,10,23);
INSERT INTO "oneid_meta_deptperm" VALUES(473,'9a1947c758e04e20993fdc80c28a7225',0,1,'2019-12-27 11:30:47.804060','2019-12-27 11:11:17.390232',0,0,11,23);
INSERT INTO "oneid_meta_deptperm" VALUES(474,'acca774e90ef4018ad51a4abb0c17ddc',0,1,'2019-12-27 11:30:47.811613','2019-12-27 11:11:17.391507',0,0,12,23);
INSERT INTO "oneid_meta_deptperm" VALUES(475,'5fe6a44628424f59883ffd5ad6d14687',0,1,'2019-12-27 11:30:47.818986','2019-12-27 11:11:17.392964',0,0,13,23);
INSERT INTO "oneid_meta_deptperm" VALUES(476,'4fbf301140664498a78482842c69c6e5',0,1,'2019-12-27 11:30:47.826607','2019-12-27 11:11:17.394243',0,0,14,23);
INSERT INTO "oneid_meta_deptperm" VALUES(477,'18000607947a43e5ac43a6fff2b4f0e2',0,1,'2019-12-27 11:30:47.834045','2019-12-27 11:11:17.395710',0,0,15,23);
INSERT INTO "oneid_meta_deptperm" VALUES(478,'5a856f6149484adb9f527f8f23bb3d61',0,1,'2019-12-27 11:30:47.841786','2019-12-27 11:11:17.397196',0,0,16,23);
INSERT INTO "oneid_meta_deptperm" VALUES(479,'8301079b7b764fac86b900970a3778a3',0,1,'2019-12-27 11:30:47.850139','2019-12-27 11:11:17.399068',0,0,17,23);
INSERT INTO "oneid_meta_deptperm" VALUES(480,'4586f2d7b28a4457a5afcaa2331f0aee',0,1,'2019-12-27 11:30:47.858074','2019-12-27 11:11:17.400903',0,0,18,23);
INSERT INTO "oneid_meta_deptperm" VALUES(481,'db3f6ff464ec4042bee58fef22f04464',0,1,'2019-12-27 11:30:47.866264','2019-12-27 11:11:17.402762',0,0,19,23);
INSERT INTO "oneid_meta_deptperm" VALUES(482,'a44f93c6d9bc4cd399b534a2393235d4',0,1,'2019-12-27 11:30:47.875854','2019-12-27 11:11:17.404197',0,0,20,23);
INSERT INTO "oneid_meta_deptperm" VALUES(483,'8e148a021dee4771bfda4e194c36587c',0,1,'2019-12-27 11:30:47.884659','2019-12-27 11:11:17.405472',0,0,21,23);
INSERT INTO "oneid_meta_deptperm" VALUES(484,'ddcd0f85c3d24c08b80267c26b45fd26',0,1,'2019-12-27 11:30:48.221471','2019-12-27 11:11:31.412568',0,0,1,24);
INSERT INTO "oneid_meta_deptperm" VALUES(485,'af5d90e488204303b5fb78b011cc47b4',0,1,'2019-12-27 11:30:48.229077','2019-12-27 11:11:31.414386',0,0,2,24);
INSERT INTO "oneid_meta_deptperm" VALUES(486,'49877dcac8c4484f9d3ddede7d9fee36',0,1,'2019-12-27 11:30:48.236650','2019-12-27 11:11:31.416098',0,0,3,24);
INSERT INTO "oneid_meta_deptperm" VALUES(487,'f6d46ab6e9b34964a0493450f4a00964',0,1,'2019-12-27 11:30:48.244515','2019-12-27 11:11:31.417373',0,0,4,24);
INSERT INTO "oneid_meta_deptperm" VALUES(488,'b08dfe7b79ec4f56928e8b00c85d38d3',0,1,'2019-12-27 11:30:48.252208','2019-12-27 11:11:31.418683',0,0,5,24);
INSERT INTO "oneid_meta_deptperm" VALUES(489,'bab73a687c9d4bcea0509a7bdc38010c',0,1,'2019-12-27 11:30:48.259973','2019-12-27 11:11:31.420267',0,0,6,24);
INSERT INTO "oneid_meta_deptperm" VALUES(490,'6df63046b3ce48899122eb238a653dd0',0,1,'2019-12-27 11:30:48.267401','2019-12-27 11:11:31.421553',0,0,7,24);
INSERT INTO "oneid_meta_deptperm" VALUES(491,'579ea66b883b4e07b536a6df7da661c2',0,1,'2019-12-27 11:30:48.276567','2019-12-27 11:11:31.423011',0,0,8,24);
INSERT INTO "oneid_meta_deptperm" VALUES(492,'9eefb02e3f1f4b13a9f012456d8ca8c5',0,1,'2019-12-27 11:30:48.285462','2019-12-27 11:11:31.424985',0,0,9,24);
INSERT INTO "oneid_meta_deptperm" VALUES(493,'65ac9e3c61ec4143946e834ab8f20540',0,1,'2019-12-27 11:30:48.293252','2019-12-27 11:11:31.427315',0,0,10,24);
INSERT INTO "oneid_meta_deptperm" VALUES(494,'096288bd33b2433eb8b0cf576f0b159a',0,1,'2019-12-27 11:30:48.301310','2019-12-27 11:11:31.429040',0,0,11,24);
INSERT INTO "oneid_meta_deptperm" VALUES(495,'047ba387c1054ab8b49b8db32fc8f748',0,1,'2019-12-27 11:30:48.308789','2019-12-27 11:11:31.430814',0,0,12,24);
INSERT INTO "oneid_meta_deptperm" VALUES(496,'0a3a58b19d9b4295879ae1bc145903d0',0,1,'2019-12-27 11:30:48.316723','2019-12-27 11:11:31.432191',0,0,13,24);
INSERT INTO "oneid_meta_deptperm" VALUES(497,'aa5071b6d57f4c008aa07c29d0c9b02e',0,1,'2019-12-27 11:30:48.324331','2019-12-27 11:11:31.433507',0,0,14,24);
INSERT INTO "oneid_meta_deptperm" VALUES(498,'3e79094e3b7642dd92168d92c34ffdc4',0,1,'2019-12-27 11:30:48.332093','2019-12-27 11:11:31.434989',0,0,15,24);
INSERT INTO "oneid_meta_deptperm" VALUES(499,'e5c25262c08c414c8e348e31084fc938',0,1,'2019-12-27 11:30:48.339698','2019-12-27 11:11:31.436270',0,0,16,24);
INSERT INTO "oneid_meta_deptperm" VALUES(500,'3feb8bc2d00f47468a2ae0b309a514bd',0,1,'2019-12-27 11:30:48.350810','2019-12-27 11:11:31.437900',0,0,17,24);
INSERT INTO "oneid_meta_deptperm" VALUES(501,'1378df409f3a48d4a51cbbfd8258524a',0,1,'2019-12-27 11:30:48.361364','2019-12-27 11:11:31.439577',0,0,18,24);
INSERT INTO "oneid_meta_deptperm" VALUES(502,'130da9d5ad50406c9a58252470b33de6',0,1,'2019-12-27 11:30:48.370960','2019-12-27 11:11:31.441489',0,0,19,24);
INSERT INTO "oneid_meta_deptperm" VALUES(503,'6b18f2bbe3f14ebe95a5af1aa9e41fa1',0,1,'2019-12-27 11:30:48.381671','2019-12-27 11:11:31.443300',0,0,20,24);
INSERT INTO "oneid_meta_deptperm" VALUES(504,'3546603b5e7b4f65bbe8aacb4a53f996',0,1,'2019-12-27 11:30:48.390293','2019-12-27 11:11:31.444715',0,0,21,24);
INSERT INTO "oneid_meta_deptperm" VALUES(505,'44eea1f49d0e426b8c7a235aa7fcf8cb',0,1,'2019-12-27 11:30:48.400117','2019-12-27 11:11:40.996466',0,0,1,25);
INSERT INTO "oneid_meta_deptperm" VALUES(506,'ff57ae9d41074f648ddaf9a06c58f48f',0,1,'2019-12-27 11:30:48.408984','2019-12-27 11:11:40.998319',0,0,2,25);
INSERT INTO "oneid_meta_deptperm" VALUES(507,'e747694615c649169b11a20722efb29a',0,1,'2019-12-27 11:30:48.417706','2019-12-27 11:11:41.000989',0,0,3,25);
INSERT INTO "oneid_meta_deptperm" VALUES(508,'2c926378e98a4c6083a367dafbdb4ca4',0,1,'2019-12-27 11:30:48.426660','2019-12-27 11:11:41.003047',0,0,4,25);
INSERT INTO "oneid_meta_deptperm" VALUES(509,'a185c22527584b6f942e2fee86e8563b',0,1,'2019-12-27 11:30:48.434690','2019-12-27 11:11:41.004611',0,0,5,25);
INSERT INTO "oneid_meta_deptperm" VALUES(510,'6ce74ccea25943c4ac0c4e371f65735e',0,1,'2019-12-27 11:30:48.442841','2019-12-27 11:11:41.006167',0,0,6,25);
INSERT INTO "oneid_meta_deptperm" VALUES(511,'f4873474baae47f08b221d62ba416c5d',0,1,'2019-12-27 11:30:48.450914','2019-12-27 11:11:41.007694',0,0,7,25);
INSERT INTO "oneid_meta_deptperm" VALUES(512,'1a039d7822034df6b05d7049939df27a',0,1,'2019-12-27 11:30:48.458497','2019-12-27 11:11:41.008980',0,0,8,25);
INSERT INTO "oneid_meta_deptperm" VALUES(513,'84676f14370f456cb0ba56e2907e6eb8',0,1,'2019-12-27 11:30:48.466823','2019-12-27 11:11:41.010420',0,0,9,25);
INSERT INTO "oneid_meta_deptperm" VALUES(514,'5ad163d2fdbf45a3aa4eea368a9ffcfc',0,1,'2019-12-27 11:30:48.475449','2019-12-27 11:11:41.012251',0,0,10,25);
INSERT INTO "oneid_meta_deptperm" VALUES(515,'d8cd859fd9b248d293623a24cdd5322e',0,1,'2019-12-27 11:30:48.483985','2019-12-27 11:11:41.014233',0,0,11,25);
INSERT INTO "oneid_meta_deptperm" VALUES(516,'638b3535a2de4e4ab75a1468ed170185',0,1,'2019-12-27 11:30:48.492471','2019-12-27 11:11:41.016612',0,0,12,25);
INSERT INTO "oneid_meta_deptperm" VALUES(517,'7ae9f27debb44313b87b69aa902f62c5',0,1,'2019-12-27 11:30:48.500432','2019-12-27 11:11:41.018190',0,0,13,25);
INSERT INTO "oneid_meta_deptperm" VALUES(518,'56667dc316844b54ba1e4d96766932fe',0,1,'2019-12-27 11:30:48.508399','2019-12-27 11:11:41.019688',0,0,14,25);
INSERT INTO "oneid_meta_deptperm" VALUES(519,'75ba248eb9614c8b9390850880b6b951',0,1,'2019-12-27 11:30:48.515999','2019-12-27 11:11:41.020916',0,0,15,25);
INSERT INTO "oneid_meta_deptperm" VALUES(520,'200b7e54ed9f43bbbca1d287608f19b9',0,1,'2019-12-27 11:30:48.523799','2019-12-27 11:11:41.022387',0,0,16,25);
INSERT INTO "oneid_meta_deptperm" VALUES(521,'787e4c173bb2418bae2922bf3f535d6a',0,1,'2019-12-27 11:30:48.531387','2019-12-27 11:11:41.023820',0,0,17,25);
INSERT INTO "oneid_meta_deptperm" VALUES(522,'578fa834c4b14a5c99b9f57f19f45699',0,1,'2019-12-27 11:30:48.539267','2019-12-27 11:11:41.025273',0,0,18,25);
INSERT INTO "oneid_meta_deptperm" VALUES(523,'b0181771b546432c9cd55a32b3982632',0,1,'2019-12-27 11:30:48.546775','2019-12-27 11:11:41.026590',0,0,19,25);
INSERT INTO "oneid_meta_deptperm" VALUES(524,'4ca2445130204f6aaf796dad22c67f33',0,1,'2019-12-27 11:30:48.554596','2019-12-27 11:11:41.027871',0,0,20,25);
INSERT INTO "oneid_meta_deptperm" VALUES(525,'63a3a2847f6846d19cfc64953c5dc7d1',0,1,'2019-12-27 11:30:48.563887','2019-12-27 11:11:41.029285',0,0,21,25);
INSERT INTO "oneid_meta_deptperm" VALUES(526,'6a8bbcff5ee44feda4de0fe5b3f7378c',0,1,'2019-12-27 11:30:48.574053','2019-12-27 11:11:50.086462',0,0,1,26);
INSERT INTO "oneid_meta_deptperm" VALUES(527,'cdd3ea35844648f986c1de18b03f47e4',0,1,'2019-12-27 11:30:48.582006','2019-12-27 11:11:50.088171',0,0,2,26);
INSERT INTO "oneid_meta_deptperm" VALUES(528,'03a7d07f528242cf93690f02760c5db7',0,1,'2019-12-27 11:30:48.590737','2019-12-27 11:11:50.090776',0,0,3,26);
INSERT INTO "oneid_meta_deptperm" VALUES(529,'04fa28f6cbb24092923197606ced90ac',0,1,'2019-12-27 11:30:48.599068','2019-12-27 11:11:50.092544',0,0,4,26);
INSERT INTO "oneid_meta_deptperm" VALUES(530,'71ddce94b5ad4fcc8807bbfc7e4c1c06',0,1,'2019-12-27 11:30:48.608804','2019-12-27 11:11:50.094134',0,0,5,26);
INSERT INTO "oneid_meta_deptperm" VALUES(531,'1ecb6c1b15634bbcad127711a88e27ff',0,1,'2019-12-27 11:30:48.618245','2019-12-27 11:11:50.095749',0,0,6,26);
INSERT INTO "oneid_meta_deptperm" VALUES(532,'6a4e21215cd24c2a9eb0e3537b85407f',0,1,'2019-12-27 11:30:48.625997','2019-12-27 11:11:50.097840',0,0,7,26);
INSERT INTO "oneid_meta_deptperm" VALUES(533,'8cc908e2b08c44f29c070127261c4252',0,1,'2019-12-27 11:30:48.635100','2019-12-27 11:11:50.099387',0,0,8,26);
INSERT INTO "oneid_meta_deptperm" VALUES(534,'cf3dd68a67f44c1f935d4a147816828e',0,1,'2019-12-27 11:30:48.646632','2019-12-27 11:11:50.101603',0,0,9,26);
INSERT INTO "oneid_meta_deptperm" VALUES(535,'410ff7776684490fb6813666342bc853',0,1,'2019-12-27 11:30:48.655206','2019-12-27 11:11:50.103491',0,0,10,26);
INSERT INTO "oneid_meta_deptperm" VALUES(536,'24fb4e65d0d1467298f45d5c500ae509',0,1,'2019-12-27 11:30:48.662980','2019-12-27 11:11:50.105498',0,0,11,26);
INSERT INTO "oneid_meta_deptperm" VALUES(537,'f2d87825702f416f98ea056003a1a835',0,1,'2019-12-27 11:30:48.671467','2019-12-27 11:11:50.107636',0,0,12,26);
INSERT INTO "oneid_meta_deptperm" VALUES(538,'8eab9f3f829144ca9cb5bc26121be392',0,1,'2019-12-27 11:30:48.679353','2019-12-27 11:11:50.109081',0,0,13,26);
INSERT INTO "oneid_meta_deptperm" VALUES(539,'a637326ad59a43c6b92c43b8666c0f43',0,1,'2019-12-27 11:30:48.687530','2019-12-27 11:11:50.110303',0,0,14,26);
INSERT INTO "oneid_meta_deptperm" VALUES(540,'cc6ab3a100a34a54ae662ed36130c8ec',0,1,'2019-12-27 11:30:48.695220','2019-12-27 11:11:50.111570',0,0,15,26);
INSERT INTO "oneid_meta_deptperm" VALUES(541,'ab0fc61a23c84d4692b1136912543523',0,1,'2019-12-27 11:30:48.703584','2019-12-27 11:11:50.113090',0,0,16,26);
INSERT INTO "oneid_meta_deptperm" VALUES(542,'650d666069264ebbb21de675fee07e24',0,1,'2019-12-27 11:30:48.710992','2019-12-27 11:11:50.114565',0,0,17,26);
INSERT INTO "oneid_meta_deptperm" VALUES(543,'a89ac4b8f56a41f78e53d05cadbde079',0,1,'2019-12-27 11:30:48.719310','2019-12-27 11:11:50.115992',0,0,18,26);
INSERT INTO "oneid_meta_deptperm" VALUES(544,'feee879259c949b8a90d66ff414a5b22',0,1,'2019-12-27 11:30:48.726720','2019-12-27 11:11:50.117270',0,0,19,26);
INSERT INTO "oneid_meta_deptperm" VALUES(545,'1c2c68e9fe3441ceaff20245e582128d',0,1,'2019-12-27 11:30:48.735069','2019-12-27 11:11:50.118575',0,0,20,26);
INSERT INTO "oneid_meta_deptperm" VALUES(546,'24553ef298de4d5d93a64234fc278e33',0,1,'2019-12-27 11:30:48.742484','2019-12-27 11:11:50.120133',0,0,21,26);
INSERT INTO "oneid_meta_deptperm" VALUES(547,'994eb959a2704d99a0d0c955f4ce7939',0,1,'2019-12-27 11:30:48.752369','2019-12-27 11:11:58.558792',0,0,1,27);
INSERT INTO "oneid_meta_deptperm" VALUES(548,'53d057ae2a5848d289807fb3a4f84007',0,1,'2019-12-27 11:30:48.760740','2019-12-27 11:11:58.560563',0,0,2,27);
INSERT INTO "oneid_meta_deptperm" VALUES(549,'5aee78f757b8412aaa45a3182f267412',0,1,'2019-12-27 11:30:48.769141','2019-12-27 11:11:58.562498',0,0,3,27);
INSERT INTO "oneid_meta_deptperm" VALUES(550,'5a749ac7ac2747ff8cfb5bec3bc4863d',0,1,'2019-12-27 11:30:48.777336','2019-12-27 11:11:58.564162',0,0,4,27);
INSERT INTO "oneid_meta_deptperm" VALUES(551,'6d132de6d5ee47e7bb2d23ab5615abc5',0,1,'2019-12-27 11:30:48.785739','2019-12-27 11:11:58.565940',0,0,5,27);
INSERT INTO "oneid_meta_deptperm" VALUES(552,'26e558e2917e438a9d8046c0119b4871',0,1,'2019-12-27 11:30:48.793643','2019-12-27 11:11:58.567883',0,0,6,27);
INSERT INTO "oneid_meta_deptperm" VALUES(553,'195103b592c3490faa0901ec85c4d35a',0,1,'2019-12-27 11:30:48.801736','2019-12-27 11:11:58.569547',0,0,7,27);
INSERT INTO "oneid_meta_deptperm" VALUES(554,'3b455ade6ec2406bb2cefe2eeb5070bd',0,1,'2019-12-27 11:30:48.809123','2019-12-27 11:11:58.571092',0,0,8,27);
INSERT INTO "oneid_meta_deptperm" VALUES(555,'3f6be838bf9e4c06a1905949582c3669',0,1,'2019-12-27 11:30:48.817447','2019-12-27 11:11:58.572496',0,0,9,27);
INSERT INTO "oneid_meta_deptperm" VALUES(556,'0a45281632f6493ab933aa6c51541411',0,1,'2019-12-27 11:30:48.825689','2019-12-27 11:11:58.573789',0,0,10,27);
INSERT INTO "oneid_meta_deptperm" VALUES(557,'fb6d3c3422e54ad7b62a2746a3d2ae6e',0,1,'2019-12-27 11:30:48.834594','2019-12-27 11:11:58.575020',0,0,11,27);
INSERT INTO "oneid_meta_deptperm" VALUES(558,'87c1813ea14645a98efb7ae532189f37',0,1,'2019-12-27 11:30:48.842234','2019-12-27 11:11:58.576442',0,0,12,27);
INSERT INTO "oneid_meta_deptperm" VALUES(559,'5b5ec9e7ebf748ada135601b8de574e4',0,1,'2019-12-27 11:30:48.850273','2019-12-27 11:11:58.578363',0,0,13,27);
INSERT INTO "oneid_meta_deptperm" VALUES(560,'61d7438d85724173b4e42c4d7963d24d',0,1,'2019-12-27 11:30:48.859686','2019-12-27 11:11:58.580289',0,0,14,27);
INSERT INTO "oneid_meta_deptperm" VALUES(561,'2d07fa07a9b046539ee94a3d15728ef7',0,1,'2019-12-27 11:30:48.869472','2019-12-27 11:11:58.581727',0,0,15,27);
INSERT INTO "oneid_meta_deptperm" VALUES(562,'6fa5fdce7a354841bb936e31cfb0b3d7',0,1,'2019-12-27 11:30:48.877323','2019-12-27 11:11:58.583308',0,0,16,27);
INSERT INTO "oneid_meta_deptperm" VALUES(563,'f7e8b6cad278406ab15eff98f593f5e8',0,1,'2019-12-27 11:30:48.886490','2019-12-27 11:11:58.584771',0,0,17,27);
INSERT INTO "oneid_meta_deptperm" VALUES(564,'d74fadb51a864fbfa901bccf82a1e8db',0,1,'2019-12-27 11:30:48.894164','2019-12-27 11:11:58.586056',0,0,18,27);
INSERT INTO "oneid_meta_deptperm" VALUES(565,'394dfb1a7c8f416c881bd91dc87f6085',0,1,'2019-12-27 11:30:48.902741','2019-12-27 11:11:58.587273',0,0,19,27);
INSERT INTO "oneid_meta_deptperm" VALUES(566,'57f03bf2b8394a05b4ee5af5a9779536',0,1,'2019-12-27 11:30:48.910224','2019-12-27 11:11:58.588636',0,0,20,27);
INSERT INTO "oneid_meta_deptperm" VALUES(567,'3b5cb706f5414d8e9e8449a0da0d70b9',0,1,'2019-12-27 11:30:48.918100','2019-12-27 11:11:58.589910',0,0,21,27);
INSERT INTO "oneid_meta_deptperm" VALUES(568,'1864c8de0ffd420a82a29292b40592f4',0,1,'2019-12-27 11:30:49.262386','2019-12-27 11:12:11.261721',0,0,1,28);
INSERT INTO "oneid_meta_deptperm" VALUES(569,'91ca16cb286549b2b64d8c805a90cfff',0,1,'2019-12-27 11:30:49.271331','2019-12-27 11:12:11.263718',0,0,2,28);
INSERT INTO "oneid_meta_deptperm" VALUES(570,'62a5a22177f940bba9c708ab9ba96fd1',0,1,'2019-12-27 11:30:49.279558','2019-12-27 11:12:11.265433',0,0,3,28);
INSERT INTO "oneid_meta_deptperm" VALUES(571,'791998b9c586458ea1179b54370c3cd1',0,1,'2019-12-27 11:30:49.289707','2019-12-27 11:12:11.266740',0,0,4,28);
INSERT INTO "oneid_meta_deptperm" VALUES(572,'b1ba7783bcdf49ab977610f3d22cb693',0,1,'2019-12-27 11:30:49.300926','2019-12-27 11:12:11.267994',0,0,5,28);
INSERT INTO "oneid_meta_deptperm" VALUES(573,'f8af78cd915249d591de8fe3442e4cd1',0,1,'2019-12-27 11:30:49.312402','2019-12-27 11:12:11.269399',0,0,6,28);
INSERT INTO "oneid_meta_deptperm" VALUES(574,'960a334340154ee5bd72573d7f16548f',0,1,'2019-12-27 11:30:49.322786','2019-12-27 11:12:11.271577',0,0,7,28);
INSERT INTO "oneid_meta_deptperm" VALUES(575,'daa83926e37e4c2ea62b17cad2bfc0cb',0,1,'2019-12-27 11:30:49.332582','2019-12-27 11:12:11.273451',0,0,8,28);
INSERT INTO "oneid_meta_deptperm" VALUES(576,'7c64af74e9f040d0b130737263de0d29',0,1,'2019-12-27 11:30:49.340757','2019-12-27 11:12:11.275708',0,0,9,28);
INSERT INTO "oneid_meta_deptperm" VALUES(577,'5980d3766d73495a9adc7c98b4fef377',0,1,'2019-12-27 11:30:49.348755','2019-12-27 11:12:11.277327',0,0,10,28);
INSERT INTO "oneid_meta_deptperm" VALUES(578,'e91329b40e244105b628e1318205b4b6',0,1,'2019-12-27 11:30:49.357294','2019-12-27 11:12:11.278910',0,0,11,28);
INSERT INTO "oneid_meta_deptperm" VALUES(579,'82c8b3e8aa03420a8f7bc2f2ffed5736',0,1,'2019-12-27 11:30:49.364807','2019-12-27 11:12:11.280202',0,0,12,28);
INSERT INTO "oneid_meta_deptperm" VALUES(580,'da626a4c22e34d749257e9ce2ef756d9',0,1,'2019-12-27 11:30:49.372704','2019-12-27 11:12:11.281581',0,0,13,28);
INSERT INTO "oneid_meta_deptperm" VALUES(581,'28a3f5dd42014a459e438bf2519804c4',0,1,'2019-12-27 11:30:49.380096','2019-12-27 11:12:11.282798',0,0,14,28);
INSERT INTO "oneid_meta_deptperm" VALUES(582,'0c8fba6858c94ee2b1568e30602dd115',0,1,'2019-12-27 11:30:49.387771','2019-12-27 11:12:11.284098',0,0,15,28);
INSERT INTO "oneid_meta_deptperm" VALUES(583,'4f73d04d69ac4cb59216e68bcca7e1e1',0,1,'2019-12-27 11:30:49.395402','2019-12-27 11:12:11.285894',0,0,16,28);
INSERT INTO "oneid_meta_deptperm" VALUES(584,'1ca5882336c548c9af7835d76273eb12',0,1,'2019-12-27 11:30:49.405327','2019-12-27 11:12:11.287856',0,0,17,28);
INSERT INTO "oneid_meta_deptperm" VALUES(585,'4b81a17601844c0db4e4be5d5b7ae275',0,1,'2019-12-27 11:30:49.412813','2019-12-27 11:12:11.289613',0,0,18,28);
INSERT INTO "oneid_meta_deptperm" VALUES(586,'aba69bc6fbb0403e99ca5053a9046e76',0,1,'2019-12-27 11:30:49.421488','2019-12-27 11:12:11.291095',0,0,19,28);
INSERT INTO "oneid_meta_deptperm" VALUES(587,'c13014b0e4914ff680c57739987cd477',0,1,'2019-12-27 11:30:49.428904','2019-12-27 11:12:11.292543',0,0,20,28);
INSERT INTO "oneid_meta_deptperm" VALUES(588,'a8f8b3b240964047ad4e96703d30e538',0,1,'2019-12-27 11:30:49.438554','2019-12-27 11:12:11.293767',0,0,21,28);
INSERT INTO "oneid_meta_deptperm" VALUES(589,'70775cb799294095a338c9c6c8ad8cee',0,1,'2019-12-27 11:30:49.451360','2019-12-27 11:12:20.385266',0,0,1,29);
INSERT INTO "oneid_meta_deptperm" VALUES(590,'1d09ac7d2d044ba49bd0c7958a14c68f',0,1,'2019-12-27 11:30:49.460896','2019-12-27 11:12:20.387445',0,0,2,29);
INSERT INTO "oneid_meta_deptperm" VALUES(591,'6940456ee89341cf971e31bab7d2c39e',0,1,'2019-12-27 11:30:49.470178','2019-12-27 11:12:20.388848',0,0,3,29);
INSERT INTO "oneid_meta_deptperm" VALUES(592,'fa970ad070224bdc881dcc300636c86a',0,1,'2019-12-27 11:30:49.478268','2019-12-27 11:12:20.390157',0,0,4,29);
INSERT INTO "oneid_meta_deptperm" VALUES(593,'dc815c3ba6004daf829a2ccdd90c14bf',0,1,'2019-12-27 11:30:49.486495','2019-12-27 11:12:20.391447',0,0,5,29);
INSERT INTO "oneid_meta_deptperm" VALUES(594,'a4379d134a7f488b89b85bc0e29a9f44',0,1,'2019-12-27 11:30:49.497160','2019-12-27 11:12:20.392792',0,0,6,29);
INSERT INTO "oneid_meta_deptperm" VALUES(595,'18e48712324c45a3bc2c89c7da66e34e',0,1,'2019-12-27 11:30:49.510200','2019-12-27 11:12:20.394488',0,0,7,29);
INSERT INTO "oneid_meta_deptperm" VALUES(596,'c6aa088e7f4e4eff89bdb24d57d499f1',0,1,'2019-12-27 11:30:49.519939','2019-12-27 11:12:20.396423',0,0,8,29);
INSERT INTO "oneid_meta_deptperm" VALUES(597,'1dcb1ec4f56f4682a026cad936fc51f4',0,1,'2019-12-27 11:30:49.530232','2019-12-27 11:12:20.398019',0,0,9,29);
INSERT INTO "oneid_meta_deptperm" VALUES(598,'6b88049d3eda4124b2d461e6fcd4daf2',0,1,'2019-12-27 11:30:49.539226','2019-12-27 11:12:20.399813',0,0,10,29);
INSERT INTO "oneid_meta_deptperm" VALUES(599,'82162f3a4f394cd0b6662f8422d3a3d7',0,1,'2019-12-27 11:30:49.547294','2019-12-27 11:12:20.401244',0,0,11,29);
INSERT INTO "oneid_meta_deptperm" VALUES(600,'8b4b3636213f412683eab3512560bd05',0,1,'2019-12-27 11:30:49.555543','2019-12-27 11:12:20.402712',0,0,12,29);
INSERT INTO "oneid_meta_deptperm" VALUES(601,'16f076a10806405488c3774d8b528da6',0,1,'2019-12-27 11:30:49.563887','2019-12-27 11:12:20.404086',0,0,13,29);
INSERT INTO "oneid_meta_deptperm" VALUES(602,'fddab9cc30494a07ae0854f125cdd0a4',0,1,'2019-12-27 11:30:49.571598','2019-12-27 11:12:20.405620',0,0,14,29);
INSERT INTO "oneid_meta_deptperm" VALUES(603,'c4ae1f4fe5d7472492e67a08671be45d',0,1,'2019-12-27 11:30:49.579094','2019-12-27 11:12:20.406836',0,0,15,29);
INSERT INTO "oneid_meta_deptperm" VALUES(604,'96e163e674124697958d4e04cb6aaf52',0,1,'2019-12-27 11:30:49.586805','2019-12-27 11:12:20.408072',0,0,16,29);
INSERT INTO "oneid_meta_deptperm" VALUES(605,'c627c4b7deca445fb1fab51878c49d48',0,1,'2019-12-27 11:30:49.594647','2019-12-27 11:12:20.409682',0,0,17,29);
INSERT INTO "oneid_meta_deptperm" VALUES(606,'0a283667f0494118b0c29cc4942a9b49',0,1,'2019-12-27 11:30:49.603284','2019-12-27 11:12:20.411685',0,0,18,29);
INSERT INTO "oneid_meta_deptperm" VALUES(607,'c1d6f704ae6442f287169bf44fc4d6aa',0,1,'2019-12-27 11:30:49.611250','2019-12-27 11:12:20.413506',0,0,19,29);
INSERT INTO "oneid_meta_deptperm" VALUES(608,'8287e27da4d34df6b801a93375cc6ca0',0,1,'2019-12-27 11:30:49.620569','2019-12-27 11:12:20.414812',0,0,20,29);
INSERT INTO "oneid_meta_deptperm" VALUES(609,'d91e5abebb3a4b9e8aa350c1e6d55300',0,1,'2019-12-27 11:30:49.628359','2019-12-27 11:12:20.416108',0,0,21,29);
INSERT INTO "oneid_meta_deptperm" VALUES(610,'8117e2c2bea541a09175aa16c197f6e0',0,1,'2019-12-27 11:30:49.638152','2019-12-27 11:12:29.047246',0,0,1,30);
INSERT INTO "oneid_meta_deptperm" VALUES(611,'da43d640db494d3bbf5566e32dbe0766',0,1,'2019-12-27 11:30:49.646790','2019-12-27 11:12:29.048841',0,0,2,30);
INSERT INTO "oneid_meta_deptperm" VALUES(612,'97e3b65be5e74e89be98d3fc71bbe156',0,1,'2019-12-27 11:30:49.654551','2019-12-27 11:12:29.050611',0,0,3,30);
INSERT INTO "oneid_meta_deptperm" VALUES(613,'772fa74380a849bc9d58a17a133eed6a',0,1,'2019-12-27 11:30:49.662520','2019-12-27 11:12:29.052535',0,0,4,30);
INSERT INTO "oneid_meta_deptperm" VALUES(614,'6308aee4290a4561a680ea12511f3b76',0,1,'2019-12-27 11:30:49.670526','2019-12-27 11:12:29.054228',0,0,5,30);
INSERT INTO "oneid_meta_deptperm" VALUES(615,'c6d43e65076142c598c6f10ac4969345',0,1,'2019-12-27 11:30:49.678515','2019-12-27 11:12:29.055805',0,0,6,30);
INSERT INTO "oneid_meta_deptperm" VALUES(616,'99fc9b4793b14634be4f921a3203a788',0,1,'2019-12-27 11:30:49.686467','2019-12-27 11:12:29.057052',0,0,7,30);
INSERT INTO "oneid_meta_deptperm" VALUES(617,'25207d57cc05499e9b95d69075a9f9ca',0,1,'2019-12-27 11:30:49.694226','2019-12-27 11:12:29.058301',0,0,8,30);
INSERT INTO "oneid_meta_deptperm" VALUES(618,'c5726a6286d844e6ac5e7c1185b4bf5a',0,1,'2019-12-27 11:30:49.702179','2019-12-27 11:12:29.059526',0,0,9,30);
INSERT INTO "oneid_meta_deptperm" VALUES(619,'70a5e7c6670b41c38fbe0b203fb01474',0,1,'2019-12-27 11:30:49.710276','2019-12-27 11:12:29.060954',0,0,10,30);
INSERT INTO "oneid_meta_deptperm" VALUES(620,'8f122125fdde48e794e5ca865569b2bb',0,1,'2019-12-27 11:30:49.719738','2019-12-27 11:12:29.062640',0,0,11,30);
INSERT INTO "oneid_meta_deptperm" VALUES(621,'399babbf57a74ba492c978d8354b8ab1',0,1,'2019-12-27 11:30:49.727981','2019-12-27 11:12:29.063930',0,0,12,30);
INSERT INTO "oneid_meta_deptperm" VALUES(622,'a8b9685423364e5bb44c9be94ee0aafe',0,1,'2019-12-27 11:30:49.737815','2019-12-27 11:12:29.065300',0,0,13,30);
INSERT INTO "oneid_meta_deptperm" VALUES(623,'90dac5aa54274c44904b7f3150d0128f',0,1,'2019-12-27 11:30:49.746058','2019-12-27 11:12:29.066734',0,0,14,30);
INSERT INTO "oneid_meta_deptperm" VALUES(624,'6a78c0340bb64ce3b63476534dea29d2',0,1,'2019-12-27 11:30:49.754831','2019-12-27 11:12:29.068652',0,0,15,30);
INSERT INTO "oneid_meta_deptperm" VALUES(625,'66d52032f0dd43c095f1de1188024911',0,1,'2019-12-27 11:30:49.763892','2019-12-27 11:12:29.070131',0,0,16,30);
INSERT INTO "oneid_meta_deptperm" VALUES(626,'285ce068f7d440078b1859d7be4aaf52',0,1,'2019-12-27 11:30:49.771930','2019-12-27 11:12:29.071807',0,0,17,30);
INSERT INTO "oneid_meta_deptperm" VALUES(627,'a2597d38628b40c59a1113d7cdb09825',0,1,'2019-12-27 11:30:49.779674','2019-12-27 11:12:29.073484',0,0,18,30);
INSERT INTO "oneid_meta_deptperm" VALUES(628,'1e8e2d798b0e4d0ea80b56bfccd0cefe',0,1,'2019-12-27 11:30:49.787844','2019-12-27 11:12:29.074909',0,0,19,30);
INSERT INTO "oneid_meta_deptperm" VALUES(629,'e8eba48bacca459cae6aa40573bab99b',0,1,'2019-12-27 11:30:49.795571','2019-12-27 11:12:29.076188',0,0,20,30);
INSERT INTO "oneid_meta_deptperm" VALUES(630,'7e7d019d4b414a509446cf41f0040fe6',0,1,'2019-12-27 11:30:49.803807','2019-12-27 11:12:29.077556',0,0,21,30);
INSERT INTO "oneid_meta_deptperm" VALUES(631,'384f1421889b4ed9a651ec3f17a075dc',0,1,'2019-12-27 11:30:49.812745','2019-12-27 11:12:37.041379',0,0,1,31);
INSERT INTO "oneid_meta_deptperm" VALUES(632,'e40ccb787ee14244bd48405348094120',0,1,'2019-12-27 11:30:49.820370','2019-12-27 11:12:37.043215',0,0,2,31);
INSERT INTO "oneid_meta_deptperm" VALUES(633,'3ebe0e2fcbe7439bb5aea4924f6f790e',0,1,'2019-12-27 11:30:49.828363','2019-12-27 11:12:37.045175',0,0,3,31);
INSERT INTO "oneid_meta_deptperm" VALUES(634,'42d48af78ea64a5c94b6a10224a8ac43',0,1,'2019-12-27 11:30:49.835838','2019-12-27 11:12:37.047330',0,0,4,31);
INSERT INTO "oneid_meta_deptperm" VALUES(635,'1bc3c53da16b483eadc0b1617d4cce4f',0,1,'2019-12-27 11:30:49.843484','2019-12-27 11:12:37.049316',0,0,5,31);
INSERT INTO "oneid_meta_deptperm" VALUES(636,'ffe4fb8f9802409798c652b10565b5d8',0,1,'2019-12-27 11:30:49.850960','2019-12-27 11:12:37.051192',0,0,6,31);
INSERT INTO "oneid_meta_deptperm" VALUES(637,'d5f3fc87e4d3471387ac4f30c7919a79',0,1,'2019-12-27 11:30:49.858934','2019-12-27 11:12:37.052686',0,0,7,31);
INSERT INTO "oneid_meta_deptperm" VALUES(638,'88233865464f4fc3b5c91e53119fdb08',0,1,'2019-12-27 11:30:49.866543','2019-12-27 11:12:37.053981',0,0,8,31);
INSERT INTO "oneid_meta_deptperm" VALUES(639,'ed02198373064f9c9589e96db4cf5466',0,1,'2019-12-27 11:30:49.874400','2019-12-27 11:12:37.055504',0,0,9,31);
INSERT INTO "oneid_meta_deptperm" VALUES(640,'e87ee4687df64e88844acb5fcafdd871',0,1,'2019-12-27 11:30:49.881768','2019-12-27 11:12:37.057367',0,0,10,31);
INSERT INTO "oneid_meta_deptperm" VALUES(641,'6b7b40383126451fbf88d90c8da502bd',0,1,'2019-12-27 11:30:49.889410','2019-12-27 11:12:37.059536',0,0,11,31);
INSERT INTO "oneid_meta_deptperm" VALUES(642,'9d859403d41e4fd3b901e550f93c862c',0,1,'2019-12-27 11:30:49.896875','2019-12-27 11:12:37.061692',0,0,12,31);
INSERT INTO "oneid_meta_deptperm" VALUES(643,'e8abd6b74813406990127769300181d7',0,1,'2019-12-27 11:30:49.904759','2019-12-27 11:12:37.063056',0,0,13,31);
INSERT INTO "oneid_meta_deptperm" VALUES(644,'1e154fa2f56a4497bd7e490aa67609c0',0,1,'2019-12-27 11:30:49.912323','2019-12-27 11:12:37.064380',0,0,14,31);
INSERT INTO "oneid_meta_deptperm" VALUES(645,'6eb521cba3284b80a42722c01f275af3',0,1,'2019-12-27 11:30:49.919957','2019-12-27 11:12:37.065650',0,0,15,31);
INSERT INTO "oneid_meta_deptperm" VALUES(646,'0b3e9a0dd45d42ef9d3c0e07e87d712e',0,1,'2019-12-27 11:30:49.927365','2019-12-27 11:12:37.066909',0,0,16,31);
INSERT INTO "oneid_meta_deptperm" VALUES(647,'ef2589644d1847ab81442fbae9d40238',0,1,'2019-12-27 11:30:49.935063','2019-12-27 11:12:37.068217',0,0,17,31);
INSERT INTO "oneid_meta_deptperm" VALUES(648,'daa056972fd9455cb3664ef966555d2b',0,1,'2019-12-27 11:30:49.942404','2019-12-27 11:12:37.069676',0,0,18,31);
INSERT INTO "oneid_meta_deptperm" VALUES(649,'42b02f3a7b3345a9985447a37bf7e8f3',0,1,'2019-12-27 11:30:49.950057','2019-12-27 11:12:37.071176',0,0,19,31);
INSERT INTO "oneid_meta_deptperm" VALUES(650,'6dbe6f08e25449b8bd26ac2bd1ea0e70',0,1,'2019-12-27 11:30:49.957996','2019-12-27 11:12:37.073004',0,0,20,31);
INSERT INTO "oneid_meta_deptperm" VALUES(651,'6bca3787c8a74197954cb3129d65c42e',0,1,'2019-12-27 11:30:49.965909','2019-12-27 11:12:37.075041',0,0,21,31);
CREATE TABLE "oneid_meta_dingconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "app_key" varchar(255) NOT NULL, "app_secret" varchar(255) NOT NULL, "corp_id" varchar(255) NOT NULL, "corp_secret" varchar(255) NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED, "app_valid" bool NOT NULL, "corp_valid" bool NOT NULL, "qr_app_id" varchar(255) NOT NULL, "qr_app_secret" varchar(255) NOT NULL, "qr_app_valid" bool NOT NULL, "sync_state" varchar(128) NOT NULL);
CREATE TABLE "oneid_meta_dingdept" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "uid" integer NOT NULL, "data" text NOT NULL, "order_no" integer NOT NULL, "dept_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_dept" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_dinggroup" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "uid" integer NOT NULL, "data" text NOT NULL, "group_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_group" ("id") DEFERRABLE INITIALLY DEFERRED, "is_group" bool NOT NULL, "subject" varchar(128) NOT NULL);
CREATE TABLE "oneid_meta_dinguser" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "account" varchar(64) NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED, "data" text NOT NULL, "ding_id" text NOT NULL, "open_id" text NOT NULL, "union_id" text NOT NULL, "uid" varchar(255) NOT NULL);
CREATE TABLE "oneid_meta_emailconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "host" varchar(256) NOT NULL, "port" integer NOT NULL, "access_key" varchar(512) NOT NULL, "access_secret" varchar(512) NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED, "is_valid" bool NOT NULL, "nickname" varchar(128) NOT NULL);
INSERT INTO "oneid_meta_emailconfig" VALUES(1,'98632fef1d4d43f893c41329b1434860',0,1,'2019-11-16 11:35:31.696571','2019-11-16 11:35:31.696602','',587,'','',1,0,'OneID');
CREATE TABLE "oneid_meta_group" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "uid" varchar(255) NOT NULL, "name" varchar(255) NOT NULL, "remark" text NOT NULL, "accept_user" bool NOT NULL, "order_no" integer NOT NULL, "top" varchar(255) NOT NULL, "node_scope" text NOT NULL, "user_scope" text NOT NULL, "visibility" integer NOT NULL, "parent_id" integer NULL REFERENCES "oneid_meta_group" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_group" VALUES(1,'6f5daa53a55b4a8f9e89780895042c3d',0,1,'2019-11-16 11:35:29.407611','2019-11-16 11:35:29.407641','root','root','所有顶级的组的父级，可视为整个公司。请勿修改',0,0,'root','[]','[]',1,NULL);
INSERT INTO "oneid_meta_group" VALUES(2,'32862fc6af584e109d24c34ee282a3d6',0,1,'2019-11-16 11:35:30.554135','2019-11-16 11:35:30.554161','intra','内部联系人-角色','',1,0,'root','[]','[]',1,1);
INSERT INTO "oneid_meta_group" VALUES(3,'9b5c3b3c3b3c4c4db811fbfdad62921a',0,1,'2019-11-16 11:35:32.116394','2019-11-16 11:35:30.555546','extern','外部联系人','',1,0,'extern','[]','[]',1,1);
INSERT INTO "oneid_meta_group" VALUES(4,'4f124beebc4e45518667ecf536bd5e59',0,1,'2019-11-16 11:35:31.332689','2019-11-16 11:35:30.924386','manager','子管理员组','',1,0,'manager','[]','[]',1,2);
INSERT INTO "oneid_meta_group" VALUES(5,'9a52181778844ed2ad0875377cdb0244',0,1,'2019-11-16 11:35:31.370253','2019-11-16 11:35:31.369830','role','角色','',1,0,'role','[]','[]',1,2);
INSERT INTO "oneid_meta_group" VALUES(6,'74c4fc9958a747808337a934343c5fea',0,1,'2019-11-16 11:35:31.371929','2019-11-16 11:35:31.371589','label','标签','',1,0,'label','[]','[]',1,2);
INSERT INTO "oneid_meta_group" VALUES(7,'2695baf7161e4fb783853cad92587edc',0,1,'2019-11-16 09:52:57.752788','2019-11-16 09:52:57.748619','jueseyi','角色一','',1,0,'role','[]','[]',1,5);
INSERT INTO "oneid_meta_group" VALUES(8,'e98cd3e66c8d4fe8a7d7a0efb1b4211a',0,1,'2019-11-16 09:53:16.938958','2019-11-16 09:53:16.930518','jueseyiyi','角色一（一）','',1,0,'role','[]','[]',1,7);
INSERT INTO "oneid_meta_group" VALUES(9,'9d68ffea4b144ee38eda3f7d985ee77d',0,1,'2019-11-16 09:53:25.287258','2019-11-16 09:53:25.278405','jueseyier','角色一（二）','',1,1,'role','[]','[]',2,7);
INSERT INTO "oneid_meta_group" VALUES(10,'fb07dc5a04904a95aca2ee95bca3434d',0,1,'2019-11-16 09:53:39.797525','2019-11-16 09:53:39.789283','jueseyisan','角色一（三）','',1,2,'role','[]','[]',3,7);
INSERT INTO "oneid_meta_group" VALUES(11,'f2f5c7e958c14987948d6ae0d228240a',0,1,'2019-11-16 09:53:49.201012','2019-11-16 09:53:49.195269','jueseyisi','角色一（四）','',1,3,'role','[]','[]',5,7);
INSERT INTO "oneid_meta_group" VALUES(12,'a25b578e14154f54b4e9d42391855723',0,1,'2019-11-16 09:53:57.019956','2019-11-16 09:53:57.014528','jueseyiwu','角色一（五）','',1,4,'role','[]','[]',4,7);
INSERT INTO "oneid_meta_group" VALUES(13,'cadc45bcdaa340ed9abef97bf15acbdb',0,1,'2019-11-16 09:54:06.033472','2019-11-16 09:54:06.025294','jueseer','角色二','',1,1,'role','[]','[]',2,5);
INSERT INTO "oneid_meta_group" VALUES(14,'eb04caf128f648b8a582be005a7dc622',0,1,'2019-11-16 09:54:15.677785','2019-11-16 09:54:15.668865','juesesan','角色三','',1,2,'role','[]','[]',3,5);
INSERT INTO "oneid_meta_group" VALUES(15,'9acf40fec5554e7fb4a23bbd0cdb1eb5',0,1,'2019-11-16 09:54:23.360475','2019-11-16 09:54:23.351337','juesesi','角色四','',1,3,'role','[]','[]',5,5);
INSERT INTO "oneid_meta_group" VALUES(16,'750d4a09ebf74cce823a8eaea1132843',0,1,'2019-11-16 09:54:35.870693','2019-11-16 09:54:35.862207','juesewu','角色五','',1,4,'role','[]','[]',4,5);
INSERT INTO "oneid_meta_group" VALUES(17,'534f2c26fdea4fe588d77de8ef5dc00f',0,1,'2019-11-16 10:00:41.769917','2019-11-16 10:00:41.760956','jueseeryi','角色二（一）','',1,0,'role','[]','[]',1,13);
INSERT INTO "oneid_meta_group" VALUES(18,'30101fe3f0a44f6fbf68fa64833b2fbd',0,1,'2019-11-16 10:00:57.232222','2019-11-16 10:00:57.227598','jueseerer','角色二（二）','',1,1,'role','[]','[]',2,13);
INSERT INTO "oneid_meta_group" VALUES(19,'3fbabe4c429a4fc49e983a9fd83bd5cb',0,1,'2019-11-16 10:01:13.586022','2019-11-16 10:01:13.576538','jueseersan','角色二（三）','',1,2,'role','[]','[]',3,13);
INSERT INTO "oneid_meta_group" VALUES(20,'3652308f735145feb031dc3a8ad1bdcc',0,1,'2019-11-16 10:01:32.314565','2019-11-16 10:01:32.308336','jueseersi','角色二（四）','',1,3,'role','[]','[]',5,13);
INSERT INTO "oneid_meta_group" VALUES(21,'e5148eaa92eb4839bd1da436c03c7a11',0,1,'2019-11-16 10:01:46.859957','2019-11-16 10:01:46.856138','jueseerwu','角色二（五）','',1,4,'role','[]','[]',4,13);
INSERT INTO "oneid_meta_group" VALUES(22,'cf14f127682a4a2c9a182e503bd762c8',0,1,'2019-11-16 10:01:58.593084','2019-11-16 10:01:58.589004','biaoqianyi','标签一','',1,0,'label','[]','[]',1,6);
INSERT INTO "oneid_meta_group" VALUES(23,'0f4a7a18a6284f5b9e3f50213fb86264',0,1,'2019-11-16 10:02:09.001199','2019-11-16 10:02:08.995319','biaoqianer','标签二','',1,1,'label','[]','[]',2,6);
INSERT INTO "oneid_meta_group" VALUES(24,'7bd9738065cf4f0082e75ab75066a20c',0,1,'2019-11-16 10:02:16.327718','2019-11-16 10:02:16.322053','biaoqiansan','标签三','',1,2,'label','[]','[]',3,6);
INSERT INTO "oneid_meta_group" VALUES(25,'346e6ed171fd4579a3152bc33afd8a22',0,1,'2019-11-16 10:02:23.257356','2019-11-16 10:02:23.251876','biaoqiansi','标签四','',1,3,'label','[]','[]',5,6);
INSERT INTO "oneid_meta_group" VALUES(26,'dfcba11851a14f47bef1415111e7db0f',0,1,'2019-11-16 10:02:32.383770','2019-11-16 10:02:32.374559','biaoqianwu','标签五','',1,4,'label','[]','[]',4,6);
INSERT INTO "oneid_meta_group" VALUES(27,'58b379420cad44d3b5fe2b43352a6cc0',0,1,'2019-11-16 10:04:05.931455','2019-11-16 10:04:05.921084','juesesanyi','角色三（一）','',1,0,'role','[]','[]',1,14);
INSERT INTO "oneid_meta_group" VALUES(28,'880fee1dad3d41e39cbe6955de172e82',0,1,'2019-11-16 10:04:17.135122','2019-11-16 10:04:17.125951','juesesiyi','角色四（一）','',1,0,'role','[]','[]',1,15);
INSERT INTO "oneid_meta_group" VALUES(29,'e239c16ee26c4377868b903de6d8d2cc',0,1,'2019-11-16 10:04:35.913029','2019-11-16 10:04:35.903731','juesewuyi','角色五（一）','',1,0,'role','[]','[]',1,16);
INSERT INTO "oneid_meta_group" VALUES(30,'5d7f8306f52f413a81b27a64aa936e66',0,1,'2019-11-16 10:05:00.120099','2019-11-16 10:05:00.114141','biaoqianyiyi','标签一（一）','',1,0,'label','[]','[]',1,22);
INSERT INTO "oneid_meta_group" VALUES(31,'92ee985158964b869052362728038a8f',0,1,'2019-11-16 10:05:20.294680','2019-11-16 10:05:20.286039','biaoqianyier','标签一（二）','',1,1,'label','[]','[]',2,22);
INSERT INTO "oneid_meta_group" VALUES(32,'77a44cd2228147a7ba9400adc952ef43',0,1,'2019-11-16 10:05:28.235337','2019-11-16 10:05:28.229865','biaoqianyisan','标签一（三）','',1,2,'label','[]','[]',3,22);
INSERT INTO "oneid_meta_group" VALUES(33,'28561477aeda4ae3a3b0742487533a34',0,1,'2019-11-16 10:05:36.492888','2019-11-16 10:05:36.486671','biaoqianyisi','标签一（四）','',1,3,'label','[]','[]',5,22);
INSERT INTO "oneid_meta_group" VALUES(34,'7043532a59d2466a8198610932c807d5',0,1,'2019-11-16 10:05:47.420177','2019-11-16 10:05:47.410635','biaoqianyiwu','标签一（五）','',1,4,'label','[]','[]',4,22);
INSERT INTO "oneid_meta_group" VALUES(35,'0b25e3ffedfe42a29365b5e8281bda58',0,1,'2019-11-16 10:06:01.134304','2019-11-16 10:06:01.130158','biaoqianeryi','标签二（一）','',1,0,'label','[]','[]',1,23);
INSERT INTO "oneid_meta_group" VALUES(36,'16443665596a4b1a97df121d24a326b7',0,1,'2019-11-16 10:06:09.119013','2019-11-16 10:06:09.113318','biaoqianerer','标签二（二）','',1,1,'label','[]','[]',2,23);
INSERT INTO "oneid_meta_group" VALUES(37,'dfe28e06c11e49fea20aa2ebd5f3c239',0,1,'2019-11-16 10:06:16.580872','2019-11-16 10:06:16.571917','biaoqianersan','标签二（三）','',1,2,'label','[]','[]',3,23);
INSERT INTO "oneid_meta_group" VALUES(38,'17428ed1905f4bd3a4514ab7986c9b81',0,1,'2019-11-16 10:06:24.134961','2019-11-16 10:06:24.131843','biaoqianersi','标签二（四）','',1,3,'label','[]','[]',5,23);
INSERT INTO "oneid_meta_group" VALUES(39,'965a85d143404941bd5a07013f5b7adb',0,1,'2019-11-16 10:06:33.197849','2019-11-16 10:06:33.188648','biaoqianerwu','标签二（五）','',1,4,'label','[]','[]',4,23);
INSERT INTO "oneid_meta_group" VALUES(40,'d665f8cf09654838a4780459b9012d60',0,1,'2019-11-16 10:06:46.138029','2019-11-16 10:06:46.128503','biaoqiansanyi','标签三（一）','',1,0,'label','[]','[]',1,24);
INSERT INTO "oneid_meta_group" VALUES(41,'6e960f069cb64a4e994f0a0947872c17',0,1,'2019-11-16 10:06:57.846833','2019-11-16 10:06:57.837445','biaoqiansiyi','标签四（一）','',1,0,'label','[]','[]',1,25);
INSERT INTO "oneid_meta_group" VALUES(42,'90712bb9a7a14f31a688861132803080',0,1,'2019-11-16 10:07:07.309872','2019-11-16 10:07:07.300774','biaoqianwuyi','标签五（一）','',1,0,'label','[]','[]',1,26);
INSERT INTO "oneid_meta_group" VALUES(43,'add8b35534084cbfa543d1029602afe7',0,1,'2019-11-16 10:07:27.406636','2019-11-16 10:07:27.402644','zidingyifenzuyi','亲戚','',1,1,'zidingyifenzuyi','[]','[]',1,2);
INSERT INTO "oneid_meta_group" VALUES(44,'7fec4127666549dabbe91221936ef221',0,1,'2019-11-16 10:07:27.471913','2019-11-16 10:07:27.466895','65d18e','管理分组自定义分组一','',1,0,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(45,'f34ba94e3da5471a8da09712242e77fd',0,1,'2019-11-16 10:07:38.580700','2019-11-16 10:07:38.576932','zidingyifenzuer','校友','',1,2,'zidingyifenzuer','[]','[]',1,2);
INSERT INTO "oneid_meta_group" VALUES(46,'87f0d89828874052bdac27150bbedd76',0,1,'2019-11-16 10:07:38.642847','2019-11-16 10:07:38.637767','0e546d','管理分组自定义分组二','',1,1,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(47,'e66b19c65c7b467482a17f378dfc1df9',0,1,'2019-11-16 10:09:20.457736','2019-11-16 10:09:20.448779','tianxieyi','亲戚一','',1,6,'zidingyifenzuyi','[]','[]',1,43);
INSERT INTO "oneid_meta_group" VALUES(48,'748844a22eb4430aabffaa675a7395f3',0,1,'2019-11-16 10:09:43.436903','2019-11-16 10:09:43.433167','tianxieer','亲戚二','',1,7,'zidingyifenzuyi','[]','[]',2,43);
INSERT INTO "oneid_meta_group" VALUES(49,'87c9a5bf1645450f89f85f1acdcff988',0,1,'2019-11-16 10:09:48.264791','2019-11-16 10:09:48.261050','tianxiesan','亲戚三','',1,8,'zidingyifenzuyi','[]','[]',3,43);
INSERT INTO "oneid_meta_group" VALUES(50,'2a84e143001148e58745a072ab1481f7',0,1,'2019-11-16 10:10:32.516760','2019-11-16 10:10:32.507842','hudieyi','校友一','',1,3,'zidingyifenzuer','[]','[]',1,45);
INSERT INTO "oneid_meta_group" VALUES(51,'4510ff24baea477b95b022c650b5863b',0,1,'2019-11-16 10:10:42.774072','2019-11-16 10:10:42.767862','hudieer','校友二','',1,5,'zidingyifenzuer','[]','[]',2,45);
INSERT INTO "oneid_meta_group" VALUES(52,'51971f916ebf470ca06c79036bc48a0e',0,1,'2019-11-16 10:10:50.926002','2019-11-16 10:10:50.913440','hudiewu','校友五','',1,6,'zidingyifenzuer','[]','[]',4,45);
INSERT INTO "oneid_meta_group" VALUES(53,'be358495a24f4a7589424386f4bbe5db',0,1,'2019-11-16 10:11:16.129272','2019-11-16 10:11:16.123801','72e997','管理应用应用一','',1,2,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(54,'62eddf6a0c8645649a6119d51cac8a5d',0,1,'2019-11-16 10:11:32.637134','2019-11-16 10:11:32.633427','b47e72','管理应用应用二','',1,3,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(55,'a96d0a9374a04ef6a6eff219c456f386',0,1,'2019-11-16 10:11:37.996563','2019-11-16 10:11:37.909078','e02f20','管理应用应用三','',1,4,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(56,'39f1e73b17954a7d882be4a5cd4e0f7b',0,1,'2019-11-16 10:11:43.661737','2019-11-16 10:11:43.658855','017e88','管理应用应用四','',1,5,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(57,'8d280eea93f64f2b9403b78716b0d44e',0,1,'2019-11-16 10:11:51.626526','2019-11-16 10:11:51.623719','f6a100','管理应用应用五','',1,6,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(58,'5268a2cdcfe4495da7cd6c4bceecd740',0,1,'2019-11-16 10:24:30.388387','2019-11-16 10:24:30.384500','laoshi','老师','',1,3,'laoshi','[]','[]',1,2);
INSERT INTO "oneid_meta_group" VALUES(59,'e2009cf3167645c78acd527b88a12f69',0,1,'2019-11-16 10:24:30.453611','2019-11-16 10:24:30.447878','61aecf','管理分组老师','',1,7,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(60,'2471d4cd2a6342509fe5bb45c53bd6a9',0,1,'2019-11-16 10:36:53.315144','2019-11-16 10:36:53.312385','15dffe','管理应用应用六','',1,8,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(61,'6cce7184f91649cc8b6b716ccac36749',0,1,'2019-11-16 10:36:59.328158','2019-11-16 10:36:59.325223','9e2002','管理应用应用七','',1,9,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(62,'ef7a51de206b4fb4967ea0af92e645ad',0,1,'2019-11-16 10:37:06.204572','2019-11-16 10:37:06.199545','6fc12c','管理应用应用八','',1,10,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(63,'5d907f0b8a6043dfa2d4514c4ac62571',0,1,'2019-11-16 10:37:13.328135','2019-11-16 10:37:13.324718','3f556f','管理应用应用九','',1,11,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(64,'b652314975ae4a18a3c445d10f45211e',0,1,'2019-11-16 10:37:18.758033','2019-11-16 10:37:18.755275','b618da','管理应用应用十','',1,12,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(65,'48652d0fe4b24699b1976bba96a9723e',0,1,'2019-12-27 04:08:31.952147','2019-12-27 04:08:31.942661','wdexnpal','wdexnpal','',1,13,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(66,'d8ecb69ffef84b84b632508bd3aef21c',0,1,'2019-12-27 04:09:04.353510','2019-12-27 04:09:04.307614','jhomcpvf','jhomcpvf','',1,14,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(67,'39824c7ce79a4a31b75f3e951fa00a49',0,1,'2019-12-27 04:14:28.939075','2019-12-27 04:14:28.909126','skbykchp','skbykchp','',1,15,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(68,'a9aa10633377448dafd3cd38acf78be9',0,1,'2019-12-27 04:15:03.264880','2019-12-27 04:15:03.234976','zwmjfxzq','zwmjfxzq','',1,16,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(69,'38e52417ad9f417a936eba6dfcbaa625',0,1,'2020-02-25 08:51:35.345389','2020-02-25 08:51:34.624487','lbdbkhnb','lbdbkhnb','',1,17,'manager','[]','[]',1,4);
INSERT INTO "oneid_meta_group" VALUES(70,'d2a5c133e90841f1b0ce6f6cf0ccd192',0,1,'2020-02-25 08:52:11.953722','2020-02-25 08:52:11.921890','uqsbibkh','uqsbibkh','',1,18,'manager','[]','[]',1,4);
CREATE TABLE "oneid_meta_groupmember" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "owner_id" integer NOT NULL REFERENCES "oneid_meta_group" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NOT NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED, "order_no" integer NOT NULL);
INSERT INTO "oneid_meta_groupmember" VALUES(1,'07d2a2f9d312469fba879b3d028a4082',0,1,'2019-11-16 09:34:30.461996','2019-11-16 09:34:30.462025',3,2,0);
INSERT INTO "oneid_meta_groupmember" VALUES(2,'219d3a5d839c4a7dbb22673ca7ea3759',0,1,'2019-11-16 09:35:05.941276','2019-11-16 09:35:05.941302',3,3,1);
INSERT INTO "oneid_meta_groupmember" VALUES(3,'39a97a7ba1624d1cb28d0056482275bb',0,1,'2019-11-16 09:42:49.700035','2019-11-16 09:42:49.700061',3,4,2);
INSERT INTO "oneid_meta_groupmember" VALUES(4,'1d271ec8bf154405ad866d2ff0ad6a90',0,1,'2019-11-16 09:43:09.209694','2019-11-16 09:43:09.209719',3,5,3);
INSERT INTO "oneid_meta_groupmember" VALUES(5,'ab73161029974040bcf466e30a07b2ff',0,1,'2019-11-16 09:43:27.939734','2019-11-16 09:43:27.939760',3,6,4);
INSERT INTO "oneid_meta_groupmember" VALUES(6,'e15302b4a9ea4cad90ca9601042cae88',0,1,'2019-11-16 09:43:48.225352','2019-11-16 09:43:48.225377',3,7,5);
INSERT INTO "oneid_meta_groupmember" VALUES(7,'ab34a40b00144b6b993cc04cfc7280fb',0,1,'2019-11-16 09:44:07.646531','2019-11-16 09:44:07.646560',3,8,6);
INSERT INTO "oneid_meta_groupmember" VALUES(8,'226391997de24eac9a622562babdaad9',0,1,'2019-11-16 09:44:40.700097','2019-11-16 09:44:40.700125',3,9,7);
INSERT INTO "oneid_meta_groupmember" VALUES(9,'7b5a4417474e469b8ba694193035e41a',0,1,'2019-11-16 09:45:03.142969','2019-11-16 09:45:03.142992',3,10,8);
INSERT INTO "oneid_meta_groupmember" VALUES(10,'7a5735c4c57e4df49945fa726caf5f86',0,1,'2019-11-16 09:45:21.875065','2019-11-16 09:45:21.875089',3,11,9);
INSERT INTO "oneid_meta_groupmember" VALUES(11,'e9aa6491dfe14e6e89f47380b63b6685',0,1,'2019-11-16 09:45:38.615276','2019-11-16 09:45:38.615300',3,12,10);
INSERT INTO "oneid_meta_groupmember" VALUES(12,'8969954bc1264d82a4b13d91b6cc367b',0,1,'2019-11-16 10:07:27.525759','2019-11-16 10:07:27.525794',44,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(13,'7b70f689572e43caa6340d9f53b7d35e',0,1,'2019-11-16 10:07:38.688210','2019-11-16 10:07:38.688240',46,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(14,'e6d18f195b94488180e71d4363676ff9',0,1,'2019-11-16 10:11:16.167795','2019-11-16 10:11:16.167824',53,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(15,'81d5d92af8e34c2eb281a825d0e5c5f3',0,1,'2019-11-16 10:11:32.674405','2019-11-16 10:11:32.674434',54,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(16,'2e194a55f51b4624800bf41750ec447b',0,1,'2019-11-16 10:11:38.032759','2019-11-16 10:11:38.032785',55,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(17,'1c036fdca4724641a646148ab1da1b6d',0,1,'2019-11-16 10:11:43.701656','2019-11-16 10:11:43.701685',56,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(18,'19bfb6ed4cef4cb894c12807cb182e42',0,1,'2019-11-16 10:11:51.666385','2019-11-16 10:11:51.666413',57,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(19,'c74e03e9adee4e71a5c23a281912e5ef',0,1,'2019-11-16 10:24:30.512714','2019-11-16 10:24:30.512741',59,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(20,'e68337e3f4fc4bf786de9fc1c4edb312',0,1,'2019-11-16 10:36:53.357886','2019-11-16 10:36:53.357918',60,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(21,'628391a3de5e455ab968ec7ccddaab9f',0,1,'2019-11-16 10:36:59.370875','2019-11-16 10:36:59.370900',61,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(22,'da91e4b954674c88b2f71cb1b1685292',0,1,'2019-11-16 10:37:06.250088','2019-11-16 10:37:06.250138',62,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(23,'157ada62d8484eed8a45928e342d7f68',0,1,'2019-11-16 10:37:13.375438','2019-11-16 10:37:13.375467',63,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(24,'9e7919aaafb342b9a6828d4533c91bfb',0,1,'2019-11-16 10:37:18.805880','2019-11-16 10:37:18.805908',64,1,0);
INSERT INTO "oneid_meta_groupmember" VALUES(25,'adf432cad38042bdbe568a8295205407',0,1,'2019-12-27 04:08:32.177821','2019-12-27 04:08:32.165367',65,4,0);
INSERT INTO "oneid_meta_groupmember" VALUES(26,'a3db2fd4193f41a48ae7b7b4457a25b9',0,1,'2020-02-25 08:39:54.327581','2019-12-27 04:09:04.442792',66,5,0);
INSERT INTO "oneid_meta_groupmember" VALUES(27,'efd5f2771f6d472a86fe1766c41f93f7',0,1,'2019-12-27 04:14:29.051279','2019-12-27 04:14:29.037532',67,6,0);
INSERT INTO "oneid_meta_groupmember" VALUES(28,'9fc4f583278b415a8daa6c0fb961bf2d',0,1,'2019-12-27 04:15:03.369292','2019-12-27 04:15:03.357732',68,6,0);
INSERT INTO "oneid_meta_groupmember" VALUES(30,'b2c37ad120cc4e2aa2c1903d0efc0ab6',0,1,'2019-12-27 11:01:43.315902','2019-12-27 11:01:43.315932',3,15,11);
INSERT INTO "oneid_meta_groupmember" VALUES(31,'a32d3522dd0e4732be0a1974b6bc01d0',0,1,'2019-12-27 11:02:13.154261','2019-12-27 11:02:13.154291',3,16,12);
INSERT INTO "oneid_meta_groupmember" VALUES(32,'2fdcc3b21e1a4a0ab2540d5d1a94f92f',0,1,'2019-12-27 11:02:34.689251','2019-12-27 11:02:34.689283',3,17,13);
INSERT INTO "oneid_meta_groupmember" VALUES(33,'fe4c4583c43d4458b9e875c2bc88416e',0,1,'2019-12-27 11:02:53.261909','2019-12-27 11:02:53.261935',3,18,14);
INSERT INTO "oneid_meta_groupmember" VALUES(34,'d1335c7eaf434beebf68368382055e51',0,1,'2019-12-27 11:03:10.776994','2019-12-27 11:03:10.777018',3,19,15);
INSERT INTO "oneid_meta_groupmember" VALUES(35,'2a3fa2eae309438da101712bd129aa4f',0,1,'2019-12-27 11:03:32.587903','2019-12-27 11:03:32.587929',3,20,16);
INSERT INTO "oneid_meta_groupmember" VALUES(36,'0cd7c91143604e779b891b1e51519520',0,1,'2019-12-27 11:03:48.734842','2019-12-27 11:03:48.734865',3,21,17);
INSERT INTO "oneid_meta_groupmember" VALUES(37,'4b1c0e23cbeb463598e5d8aacfb0deda',0,1,'2019-12-27 11:04:07.093078','2019-12-27 11:04:07.093102',3,22,18);
INSERT INTO "oneid_meta_groupmember" VALUES(38,'4a930b9110d745e7bd3b1f8212a153fc',0,1,'2019-12-27 11:04:23.992748','2019-12-27 11:04:23.992773',3,23,19);
INSERT INTO "oneid_meta_groupmember" VALUES(39,'a09281d1af2842aeb370e078d90a4a79',0,1,'2019-12-27 11:04:39.851753','2019-12-27 11:04:39.851779',3,24,20);
INSERT INTO "oneid_meta_groupmember" VALUES(40,'b5b18a5ca4874f6eb141f1351645a8b4',0,1,'2019-12-27 11:04:56.495570','2019-12-27 11:04:56.495597',3,25,21);
INSERT INTO "oneid_meta_groupmember" VALUES(41,'7f9ff627276643298c3a3fb7882dac33',0,1,'2019-12-27 11:05:12.265302','2019-12-27 11:05:12.265331',3,26,22);
INSERT INTO "oneid_meta_groupmember" VALUES(42,'52aab061f0314cc18cfa9c725ffba128',0,1,'2019-12-27 11:05:31.464671','2019-12-27 11:05:31.464703',3,27,23);
INSERT INTO "oneid_meta_groupmember" VALUES(43,'2bc41ce07a1248b29cc31792c4a43be6',0,1,'2019-12-27 11:05:47.562781','2019-12-27 11:05:47.562811',3,28,24);
INSERT INTO "oneid_meta_groupmember" VALUES(44,'ae21d6009ed24a1dbe55ff4a7ccbc110',0,1,'2019-12-27 11:06:04.660390','2019-12-27 11:06:04.660419',3,29,25);
INSERT INTO "oneid_meta_groupmember" VALUES(45,'007d13753e6a411a9c13ddf684deeeed',0,1,'2019-12-27 11:06:23.634567','2019-12-27 11:06:23.634596',3,30,26);
INSERT INTO "oneid_meta_groupmember" VALUES(46,'f324d716dfe9460392030285dd421331',0,1,'2019-12-27 11:06:39.376203','2019-12-27 11:06:39.376229',3,31,27);
INSERT INTO "oneid_meta_groupmember" VALUES(47,'94a98a446303404cbae48b81d7a3790f',0,1,'2019-12-27 11:06:56.384537','2019-12-27 11:06:56.384563',3,32,28);
INSERT INTO "oneid_meta_groupmember" VALUES(48,'327e2fd711b14b8a9d9d708d7ef28832',0,1,'2019-12-27 11:07:33.965426','2019-12-27 11:07:33.965450',3,33,29);
INSERT INTO "oneid_meta_groupmember" VALUES(49,'e6ec52205d0242f287d73857706d84fb',0,1,'2019-12-27 11:14:52.902411','2019-12-27 11:14:52.902435',3,34,30);
INSERT INTO "oneid_meta_groupmember" VALUES(50,'ee1ec03807c841ee910e7981dbca26df',0,1,'2020-02-25 09:13:52.343768','2020-02-25 08:51:37.423105',69,7,0);
INSERT INTO "oneid_meta_groupmember" VALUES(51,'f972a89c0d2c4344b806a5b1b3ddf883',0,1,'2020-02-25 09:14:13.474002','2020-02-25 08:52:13.975486',70,7,0);
CREATE TABLE "oneid_meta_groupperm" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "status" integer NOT NULL, "value" bool NOT NULL, "perm_id" integer NOT NULL REFERENCES "oneid_meta_perm" ("id") DEFERRABLE INITIALLY DEFERRED, "owner_id" integer NOT NULL REFERENCES "oneid_meta_group" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_groupperm" VALUES(1,'1f8cd15be7174f60acc0014c7b7634af',0,1,'2019-12-27 11:30:53.445967','2019-11-16 09:52:57.758117',0,0,1,7);
INSERT INTO "oneid_meta_groupperm" VALUES(2,'04237f8d465347e9befc53c9b6440ef3',0,1,'2019-12-27 11:30:53.454601','2019-11-16 09:52:57.761211',0,0,2,7);
INSERT INTO "oneid_meta_groupperm" VALUES(3,'bc4c4a6225c5407aa33f188a89b8ce3e',0,1,'2019-12-27 11:30:53.463091','2019-11-16 09:52:57.764978',0,0,3,7);
INSERT INTO "oneid_meta_groupperm" VALUES(4,'14a31d46265647f0a9cac7192fbc98ac',0,1,'2019-12-27 11:30:53.471168','2019-11-16 09:52:57.768365',0,0,4,7);
INSERT INTO "oneid_meta_groupperm" VALUES(5,'d5a867772a3044f68247703ba8c59758',0,1,'2019-12-27 11:30:53.479306','2019-11-16 09:52:57.770876',0,0,5,7);
INSERT INTO "oneid_meta_groupperm" VALUES(6,'18125411e2924fd1a44b01253e710194',0,1,'2019-12-27 11:30:53.488573','2019-11-16 09:52:57.773109',0,0,6,7);
INSERT INTO "oneid_meta_groupperm" VALUES(7,'2a5000dd99234009b3c4944c9f3120aa',0,1,'2019-12-27 11:30:53.496622','2019-11-16 09:52:57.775905',0,0,7,7);
INSERT INTO "oneid_meta_groupperm" VALUES(8,'344a3b4cc73240c3aa56cbd23d39c0f2',0,1,'2019-12-27 11:30:53.504626','2019-11-16 09:52:57.779117',0,0,8,7);
INSERT INTO "oneid_meta_groupperm" VALUES(9,'5413399b7db0484fa4b51ff680ae3684',0,1,'2019-12-27 11:30:53.512682','2019-11-16 09:52:57.782191',0,0,9,7);
INSERT INTO "oneid_meta_groupperm" VALUES(10,'7fc3df234b264ccc8671a31c868448be',0,1,'2019-12-27 11:30:53.522580','2019-11-16 09:52:57.784452',0,0,10,7);
INSERT INTO "oneid_meta_groupperm" VALUES(11,'c8391f36e54c4e849cb53ebbad163ae6',0,1,'2019-12-27 11:30:53.627997','2019-11-16 09:53:16.944888',0,0,1,8);
INSERT INTO "oneid_meta_groupperm" VALUES(12,'98ffc343a13447fd9cf1428d46548b9f',0,1,'2019-12-27 11:30:53.636120','2019-11-16 09:53:16.948873',0,0,2,8);
INSERT INTO "oneid_meta_groupperm" VALUES(13,'e39bb2194a6443999fd123344b14b2ee',0,1,'2019-12-27 11:30:53.644042','2019-11-16 09:53:16.951380',0,0,3,8);
INSERT INTO "oneid_meta_groupperm" VALUES(14,'1198b7bcc4d8408ca07643b095e2534c',0,1,'2019-12-27 11:30:53.652673','2019-11-16 09:53:16.953679',0,0,4,8);
INSERT INTO "oneid_meta_groupperm" VALUES(15,'cda8a7df58bf42578ba37ee44d1f802b',0,1,'2019-12-27 11:30:53.660503','2019-11-16 09:53:16.956493',0,0,5,8);
INSERT INTO "oneid_meta_groupperm" VALUES(16,'abac7c8a870b4a3aae45f5dc1a7b28ac',0,1,'2019-12-27 11:30:53.668669','2019-11-16 09:53:16.959993',0,0,6,8);
INSERT INTO "oneid_meta_groupperm" VALUES(17,'dd4bf38e739c4febad71d0d438b60550',0,1,'2019-12-27 11:30:53.676345','2019-11-16 09:53:16.962788',0,0,7,8);
INSERT INTO "oneid_meta_groupperm" VALUES(18,'cdd18b3e951947ec80e45eedf6a6f4ed',0,1,'2019-12-27 11:30:53.684746','2019-11-16 09:53:16.965141',0,0,8,8);
INSERT INTO "oneid_meta_groupperm" VALUES(19,'de0ef100744c4ac68db787b0c6809e4c',0,1,'2019-12-27 11:30:53.692389','2019-11-16 09:53:16.967416',0,0,9,8);
INSERT INTO "oneid_meta_groupperm" VALUES(20,'eddc5effc4b842899726ab3affd7a8e6',0,1,'2019-12-27 11:30:53.701067','2019-11-16 09:53:16.969737',0,0,10,8);
INSERT INTO "oneid_meta_groupperm" VALUES(21,'8232344f5c41427780faa3c641195d8f',0,1,'2019-12-27 11:30:53.801257','2019-11-16 09:53:25.292054',0,0,1,9);
INSERT INTO "oneid_meta_groupperm" VALUES(22,'cd1943f009a54e3f84ed9334a1940766',0,1,'2019-12-27 11:30:53.809255','2019-11-16 09:53:25.296022',0,0,2,9);
INSERT INTO "oneid_meta_groupperm" VALUES(23,'a550585329614c23b48f07e178a676ce',0,1,'2019-12-27 11:30:53.818406','2019-11-16 09:53:25.300234',0,0,3,9);
INSERT INTO "oneid_meta_groupperm" VALUES(24,'eb7376ae4e454817bd67419ef216b9b4',0,1,'2019-12-27 11:30:53.826636','2019-11-16 09:53:25.302856',0,0,4,9);
INSERT INTO "oneid_meta_groupperm" VALUES(25,'a73f8670c20741808dac4a402f9ef02c',0,1,'2019-12-27 11:30:53.835111','2019-11-16 09:53:25.305274',0,0,5,9);
INSERT INTO "oneid_meta_groupperm" VALUES(26,'ccab1ef8ecc4437497bd75a774ddceb3',0,1,'2019-12-27 11:30:53.843084','2019-11-16 09:53:25.307498',0,0,6,9);
INSERT INTO "oneid_meta_groupperm" VALUES(27,'6eda65ab1c744796bbccd32837f33f7d',0,1,'2019-12-27 11:30:53.851389','2019-11-16 09:53:25.309904',0,0,7,9);
INSERT INTO "oneid_meta_groupperm" VALUES(28,'9514a08a03c8481fb4c8060b9edc221c',0,1,'2019-12-27 11:30:53.859247','2019-11-16 09:53:25.312193',0,0,8,9);
INSERT INTO "oneid_meta_groupperm" VALUES(29,'97fcb7a0421b4925a6b691515e7727b3',0,1,'2019-12-27 11:30:53.867924','2019-11-16 09:53:25.315300',0,0,9,9);
INSERT INTO "oneid_meta_groupperm" VALUES(30,'a863f6a6784f4291b5924d7b218f46a8',0,1,'2019-12-27 11:30:53.875678','2019-11-16 09:53:25.318520',0,0,10,9);
INSERT INTO "oneid_meta_groupperm" VALUES(31,'aa41e647341e470688d496511d1be5d1',0,1,'2019-12-27 11:30:53.977290','2019-11-16 09:53:39.801841',0,0,1,10);
INSERT INTO "oneid_meta_groupperm" VALUES(32,'8dbbe4577e92427c965212400a674900',0,1,'2019-12-27 11:30:53.985744','2019-11-16 09:53:39.805588',0,0,2,10);
INSERT INTO "oneid_meta_groupperm" VALUES(33,'79e08a1ecc974ffa946463dcc541bd67',0,1,'2019-12-27 11:30:53.993945','2019-11-16 09:53:39.809890',0,0,3,10);
INSERT INTO "oneid_meta_groupperm" VALUES(34,'2c936355771445bb8115d878c030f7dc',0,1,'2019-12-27 11:30:54.002413','2019-11-16 09:53:39.812605',0,0,4,10);
INSERT INTO "oneid_meta_groupperm" VALUES(35,'f9772484d7334213b676bbd0858c0968',0,1,'2019-12-27 11:30:54.009870','2019-11-16 09:53:39.815028',0,0,5,10);
INSERT INTO "oneid_meta_groupperm" VALUES(36,'c564611225854aeead1ecb594c1299e5',0,1,'2019-12-27 11:30:54.018492','2019-11-16 09:53:39.817306',0,0,6,10);
INSERT INTO "oneid_meta_groupperm" VALUES(37,'268b468b46b44b279fdb9895da995276',0,1,'2019-12-27 11:30:54.026721','2019-11-16 09:53:39.819594',0,0,7,10);
INSERT INTO "oneid_meta_groupperm" VALUES(38,'661c1c6e2be3429c89dba408b6774a35',0,1,'2019-12-27 11:30:54.034761','2019-11-16 09:53:39.821942',0,0,8,10);
INSERT INTO "oneid_meta_groupperm" VALUES(39,'cf7b6c0e089a442a9b327323788770b8',0,1,'2019-12-27 11:30:54.042529','2019-11-16 09:53:39.825351',0,0,9,10);
INSERT INTO "oneid_meta_groupperm" VALUES(40,'1436aed433e245ea9a7948f585162b4c',0,1,'2019-12-27 11:30:54.050348','2019-11-16 09:53:39.828089',0,0,10,10);
INSERT INTO "oneid_meta_groupperm" VALUES(41,'2fe44bc7cf7a4006a6a6e1b567af7494',0,1,'2019-12-27 11:30:54.145307','2019-11-16 09:53:49.205083',0,0,1,11);
INSERT INTO "oneid_meta_groupperm" VALUES(42,'d480ff11339147b2a970a46f29637efd',0,1,'2019-12-27 11:30:54.153320','2019-11-16 09:53:49.207723',0,0,2,11);
INSERT INTO "oneid_meta_groupperm" VALUES(43,'dbad605f517a4f29923d85aa7d322738',0,1,'2019-12-27 11:30:54.161082','2019-11-16 09:53:49.211896',0,0,3,11);
INSERT INTO "oneid_meta_groupperm" VALUES(44,'c27ddd22a8314dcebbb5b2918e4760c9',0,1,'2019-12-27 11:30:54.168569','2019-11-16 09:53:49.215569',0,0,4,11);
INSERT INTO "oneid_meta_groupperm" VALUES(45,'1e977fe861a34d09a8f121494c2e00a1',0,1,'2019-12-27 11:30:54.176290','2019-11-16 09:53:49.218551',0,0,5,11);
INSERT INTO "oneid_meta_groupperm" VALUES(46,'8d9befc6ac9b487b9af1ba97afe6f9f5',0,1,'2019-12-27 11:30:54.183787','2019-11-16 09:53:49.220791',0,0,6,11);
INSERT INTO "oneid_meta_groupperm" VALUES(47,'e4c0097655d4422db9de0f19e19eacab',0,1,'2019-12-27 11:30:54.191621','2019-11-16 09:53:49.222969',0,0,7,11);
INSERT INTO "oneid_meta_groupperm" VALUES(48,'cdb6141b679840bcbb922c865a02db8b',0,1,'2019-12-27 11:30:54.199186','2019-11-16 09:53:49.225148',0,0,8,11);
INSERT INTO "oneid_meta_groupperm" VALUES(49,'33658291d83e4d23a78ead69a8459125',0,1,'2019-12-27 11:30:54.207190','2019-11-16 09:53:49.227953',0,0,9,11);
INSERT INTO "oneid_meta_groupperm" VALUES(50,'52e6896e623a478c97c03bee5e5ba494',0,1,'2019-12-27 11:30:54.214872','2019-11-16 09:53:49.231198',0,0,10,11);
INSERT INTO "oneid_meta_groupperm" VALUES(51,'32fde405d9fa4e159c6ff87e80054b38',0,1,'2019-12-27 11:30:54.317108','2019-11-16 09:53:57.025545',0,0,1,12);
INSERT INTO "oneid_meta_groupperm" VALUES(52,'fa17356934384faa87b189784acd62de',0,1,'2019-12-27 11:30:54.325083','2019-11-16 09:53:57.028684',0,0,2,12);
INSERT INTO "oneid_meta_groupperm" VALUES(53,'55d81c8f9a884a509e5071d5c4fe6e29',0,1,'2019-12-27 11:30:54.334150','2019-11-16 09:53:57.032712',0,0,3,12);
INSERT INTO "oneid_meta_groupperm" VALUES(54,'ed7874460a934cf28f24b5ba0f63ce79',0,1,'2019-12-27 11:30:54.342458','2019-11-16 09:53:57.035265',0,0,4,12);
INSERT INTO "oneid_meta_groupperm" VALUES(55,'f87326be4c82429398cbe2a0fbaf6c1d',0,1,'2019-12-27 11:30:54.350696','2019-11-16 09:53:57.038186',0,0,5,12);
INSERT INTO "oneid_meta_groupperm" VALUES(56,'7637481b5fa849d884fd2caee7258751',0,1,'2019-12-27 11:30:54.358293','2019-11-16 09:53:57.041542',0,0,6,12);
INSERT INTO "oneid_meta_groupperm" VALUES(57,'2d91a4c00b53473ea51dde410f5c1121',0,1,'2019-12-27 11:30:54.366564','2019-11-16 09:53:57.044167',0,0,7,12);
INSERT INTO "oneid_meta_groupperm" VALUES(58,'350f136fc2b748aeab2e1229e545d582',0,1,'2019-12-27 11:30:54.375299','2019-11-16 09:53:57.046494',0,0,8,12);
INSERT INTO "oneid_meta_groupperm" VALUES(59,'eb78654cb67149b4beefe63af230d47c',0,1,'2019-12-27 11:30:54.383550','2019-11-16 09:53:57.048786',0,0,9,12);
INSERT INTO "oneid_meta_groupperm" VALUES(60,'54f51a58fff4485983c4d264779cf839',0,1,'2019-12-27 11:30:54.392910','2019-11-16 09:53:57.051287',0,0,10,12);
INSERT INTO "oneid_meta_groupperm" VALUES(61,'8699c9342c304ea486a4f1909169bc8a',0,1,'2019-12-27 11:30:54.489751','2019-11-16 09:54:06.038185',0,0,1,13);
INSERT INTO "oneid_meta_groupperm" VALUES(62,'570413936f2b4d3f9dae3eedc2dca09b',0,1,'2019-12-27 11:30:54.497509','2019-11-16 09:54:06.042326',0,0,2,13);
INSERT INTO "oneid_meta_groupperm" VALUES(63,'a291ecdf7c354f3b9d766cea5584cd8c',0,1,'2019-12-27 11:30:54.505297','2019-11-16 09:54:06.045628',0,0,3,13);
INSERT INTO "oneid_meta_groupperm" VALUES(64,'c366213d5c3347dbb2275922c3629b26',0,1,'2019-12-27 11:30:54.512906','2019-11-16 09:54:06.048551',0,0,4,13);
INSERT INTO "oneid_meta_groupperm" VALUES(65,'2db37870e2f24cc5a5eb60cd761c032c',0,1,'2019-12-27 11:30:54.520800','2019-11-16 09:54:06.051056',0,0,5,13);
INSERT INTO "oneid_meta_groupperm" VALUES(66,'74e91809531e4695ac05a0f1445571aa',0,1,'2019-12-27 11:30:54.528495','2019-11-16 09:54:06.053293',0,0,6,13);
INSERT INTO "oneid_meta_groupperm" VALUES(67,'02da585454e749a1b8950e762062ccac',0,1,'2019-12-27 11:30:54.537164','2019-11-16 09:54:06.055528',0,0,7,13);
INSERT INTO "oneid_meta_groupperm" VALUES(68,'2922b566aa414e4b98a18e82fd394fe1',0,1,'2019-12-27 11:30:54.544916','2019-11-16 09:54:06.058432',0,0,8,13);
INSERT INTO "oneid_meta_groupperm" VALUES(69,'dfef43c2a3fd405d90f2063a11eb1daa',0,1,'2019-12-27 11:30:54.552535','2019-11-16 09:54:06.061303',0,0,9,13);
INSERT INTO "oneid_meta_groupperm" VALUES(70,'0df092ed237448968f4f6aebb48fed21',0,1,'2019-12-27 11:30:54.560399','2019-11-16 09:54:06.064804',0,0,10,13);
INSERT INTO "oneid_meta_groupperm" VALUES(71,'cfd1372a522a4b1f95163be7eb2b0038',0,1,'2019-12-27 11:30:55.527638','2019-11-16 09:54:15.682103',0,0,1,14);
INSERT INTO "oneid_meta_groupperm" VALUES(72,'f7d294febd2548c8835d82c487dc74c8',0,1,'2019-12-27 11:30:55.535806','2019-11-16 09:54:15.685288',0,0,2,14);
INSERT INTO "oneid_meta_groupperm" VALUES(73,'8b3afcc331c44ec8b856ef4fe8772fdb',0,1,'2019-12-27 11:30:55.543716','2019-11-16 09:54:15.689330',0,0,3,14);
INSERT INTO "oneid_meta_groupperm" VALUES(74,'3e2e50196ae146c6bb304308bcab541a',0,1,'2019-12-27 11:30:55.551506','2019-11-16 09:54:15.691991',0,0,4,14);
INSERT INTO "oneid_meta_groupperm" VALUES(75,'a3be2372fee54a29ac20d005fb1cf2b6',0,1,'2019-12-27 11:30:55.559351','2019-11-16 09:54:15.694676',0,0,5,14);
INSERT INTO "oneid_meta_groupperm" VALUES(76,'bfb28215500547ca974f4a7920dcdde8',0,1,'2019-12-27 11:30:55.567242','2019-11-16 09:54:15.697012',0,0,6,14);
INSERT INTO "oneid_meta_groupperm" VALUES(77,'39e04472288348a79ef2ece324e80570',0,1,'2019-12-27 11:30:55.574650','2019-11-16 09:54:15.699394',0,0,7,14);
INSERT INTO "oneid_meta_groupperm" VALUES(78,'3b6371be24444e71a01b8e7882ef49e6',0,1,'2019-12-27 11:30:55.582628','2019-11-16 09:54:15.702920',0,0,8,14);
INSERT INTO "oneid_meta_groupperm" VALUES(79,'9e82610ed9b94ce28def5c167d0502fc',0,1,'2019-12-27 11:30:55.590667','2019-11-16 09:54:15.706254',0,0,9,14);
INSERT INTO "oneid_meta_groupperm" VALUES(80,'afab3db8876443d2bf2103995ec90eb5',0,1,'2019-12-27 11:30:55.598752','2019-11-16 09:54:15.708627',0,0,10,14);
INSERT INTO "oneid_meta_groupperm" VALUES(81,'d33edb39db934c0984c854696ca915df',0,1,'2019-12-27 11:30:55.867648','2019-11-16 09:54:23.365556',0,0,1,15);
INSERT INTO "oneid_meta_groupperm" VALUES(82,'eb2692b1611345dc995a01500468633b',0,1,'2019-12-27 11:30:55.876437','2019-11-16 09:54:23.369540',0,0,2,15);
INSERT INTO "oneid_meta_groupperm" VALUES(83,'294ed53fb70c47aaaf2dc67e077aacb8',0,1,'2019-12-27 11:30:55.884614','2019-11-16 09:54:23.371971',0,0,3,15);
INSERT INTO "oneid_meta_groupperm" VALUES(84,'9c631590898849dfb8aa45445cdb1985',0,1,'2019-12-27 11:30:55.894440','2019-11-16 09:54:23.375290',0,0,4,15);
INSERT INTO "oneid_meta_groupperm" VALUES(85,'6fea35dc623148acac75c16b8e9b0a0c',0,1,'2019-12-27 11:30:55.902171','2019-11-16 09:54:23.378214',0,0,5,15);
INSERT INTO "oneid_meta_groupperm" VALUES(86,'dabed8042ea64d73ba1a6637e9b84457',0,1,'2019-12-27 11:30:55.911041','2019-11-16 09:54:23.380525',0,0,6,15);
INSERT INTO "oneid_meta_groupperm" VALUES(87,'f93a4f0a3cfd43b78cfac268114c0646',0,1,'2019-12-27 11:30:55.919080','2019-11-16 09:54:23.382888',0,0,7,15);
INSERT INTO "oneid_meta_groupperm" VALUES(88,'3e45a4ed8dd2434f89b81f35df64c528',0,1,'2019-12-27 11:30:55.927500','2019-11-16 09:54:23.385242',0,0,8,15);
INSERT INTO "oneid_meta_groupperm" VALUES(89,'84199de1aaea4981bd1ca5780f2813ef',0,1,'2019-12-27 11:30:55.935291','2019-11-16 09:54:23.387765',0,0,9,15);
INSERT INTO "oneid_meta_groupperm" VALUES(90,'1a80a89d5d0b4728b5d6d1f475b155ab',0,1,'2019-12-27 11:30:55.943597','2019-11-16 09:54:23.390400',0,0,10,15);
INSERT INTO "oneid_meta_groupperm" VALUES(91,'b42fad0fd8924de9aad74d8ebefd3367',0,1,'2019-12-27 11:30:56.236101','2019-11-16 09:54:35.875073',0,0,1,16);
INSERT INTO "oneid_meta_groupperm" VALUES(92,'9b3e4d69d799446fa727203760401425',0,1,'2019-12-27 11:30:56.247669','2019-11-16 09:54:35.879067',0,0,2,16);
INSERT INTO "oneid_meta_groupperm" VALUES(93,'29c95900b6df4e299c88bd1cc897245a',0,1,'2019-12-27 11:30:56.257962','2019-11-16 09:54:35.883011',0,0,3,16);
INSERT INTO "oneid_meta_groupperm" VALUES(94,'3d1dfbec461c4fb78d400b7a5bc35be0',0,1,'2019-12-27 11:30:56.266159','2019-11-16 09:54:35.886740',0,0,4,16);
INSERT INTO "oneid_meta_groupperm" VALUES(95,'77ed116f0da64dbfba55c181da8534ae',0,1,'2019-12-27 11:30:56.275961','2019-11-16 09:54:35.889067',0,0,5,16);
INSERT INTO "oneid_meta_groupperm" VALUES(96,'b1b27cd6b40942529e3678f03dc46aa6',0,1,'2019-12-27 11:30:56.283418','2019-11-16 09:54:35.891430',0,0,6,16);
INSERT INTO "oneid_meta_groupperm" VALUES(97,'f772ed858c5f43848b99df844b9933be',0,1,'2019-12-27 11:30:56.293397','2019-11-16 09:54:35.895978',0,0,7,16);
INSERT INTO "oneid_meta_groupperm" VALUES(98,'592ee88e89c94cb79b00580be79b05a3',0,1,'2019-12-27 11:30:56.303621','2019-11-16 09:54:35.898549',0,0,8,16);
INSERT INTO "oneid_meta_groupperm" VALUES(99,'bf0c582f032346b18362aea0cebbfcbd',0,1,'2019-12-27 11:30:56.314093','2019-11-16 09:54:35.902010',0,0,9,16);
INSERT INTO "oneid_meta_groupperm" VALUES(100,'0ab8b25467904ee8b1c8a337145fd6bd',0,1,'2019-12-27 11:30:56.323843','2019-11-16 09:54:35.904851',0,0,10,16);
INSERT INTO "oneid_meta_groupperm" VALUES(101,'72cd4b577bf943a1a78ab43aab1d9ccc',0,1,'2019-12-27 11:30:54.659387','2019-11-16 10:00:41.776206',0,0,1,17);
INSERT INTO "oneid_meta_groupperm" VALUES(102,'caf660166fdb40baa32bb5a76ed6156c',0,1,'2019-12-27 11:30:54.667465','2019-11-16 10:00:41.778822',0,0,2,17);
INSERT INTO "oneid_meta_groupperm" VALUES(103,'3ae97a1dea68494b976774fa6a8d8632',0,1,'2019-12-27 11:30:54.675870','2019-11-16 10:00:41.781596',0,0,3,17);
INSERT INTO "oneid_meta_groupperm" VALUES(104,'fb7548f9e71a436d8384327ac2fcb490',0,1,'2019-12-27 11:30:54.686021','2019-11-16 10:00:41.784700',0,0,4,17);
INSERT INTO "oneid_meta_groupperm" VALUES(105,'5c5e28b7d8f84e8c90643f65c007a3f2',0,1,'2019-12-27 11:30:54.695271','2019-11-16 10:00:41.788333',0,0,5,17);
INSERT INTO "oneid_meta_groupperm" VALUES(106,'e3f9bf4291ad487aa1a2fe2a0db3408d',0,1,'2019-12-27 11:30:54.704358','2019-11-16 10:00:41.792175',0,0,6,17);
INSERT INTO "oneid_meta_groupperm" VALUES(107,'1ff0dc648f3442229914742f7e1751a2',0,1,'2019-12-27 11:30:54.713429','2019-11-16 10:00:41.795348',0,0,7,17);
INSERT INTO "oneid_meta_groupperm" VALUES(108,'f175b46a6725447098e4f6e18042d816',0,1,'2019-12-27 11:30:54.721943','2019-11-16 10:00:41.798278',0,0,8,17);
INSERT INTO "oneid_meta_groupperm" VALUES(109,'5f6df3501d26444496fc8cf91e662034',0,1,'2019-12-27 11:30:54.730122','2019-11-16 10:00:41.801352',0,0,9,17);
INSERT INTO "oneid_meta_groupperm" VALUES(110,'9241ff3d34b84ff5bcfe4bd79ade1508',0,1,'2019-12-27 11:30:54.739117','2019-11-16 10:00:41.804279',0,0,10,17);
INSERT INTO "oneid_meta_groupperm" VALUES(111,'c4d569061e154e5d8465b6562f52f7d2',0,1,'2019-12-27 11:30:54.839610','2019-11-16 10:00:57.237768',0,0,1,18);
INSERT INTO "oneid_meta_groupperm" VALUES(112,'fca581bf3c8e422a8f94e7ab8cf40a13',0,1,'2019-12-27 11:30:54.847875','2019-11-16 10:00:57.240616',0,0,2,18);
INSERT INTO "oneid_meta_groupperm" VALUES(113,'a7136cfa7bee40d3a9f7bfef8a3047b3',0,1,'2019-12-27 11:30:54.856127','2019-11-16 10:00:57.243765',0,0,3,18);
INSERT INTO "oneid_meta_groupperm" VALUES(114,'6ca49441d3b443adae066a2a144b8241',0,1,'2019-12-27 11:30:54.864323','2019-11-16 10:00:57.246607',0,0,4,18);
INSERT INTO "oneid_meta_groupperm" VALUES(115,'c8080824db8f4520887acc5f7a42e4bc',0,1,'2019-12-27 11:30:54.872885','2019-11-16 10:00:57.250817',0,0,5,18);
INSERT INTO "oneid_meta_groupperm" VALUES(116,'75976bab966e48da8f9bed7f58da57f3',0,1,'2019-12-27 11:30:54.881183','2019-11-16 10:00:57.254888',0,0,6,18);
INSERT INTO "oneid_meta_groupperm" VALUES(117,'bd96207513424239b1fbbd0a612b03d7',0,1,'2019-12-27 11:30:54.891283','2019-11-16 10:00:57.258088',0,0,7,18);
INSERT INTO "oneid_meta_groupperm" VALUES(118,'70f58fe0bc604cfb923d4ed09d042723',0,1,'2019-12-27 11:30:54.899047','2019-11-16 10:00:57.260885',0,0,8,18);
INSERT INTO "oneid_meta_groupperm" VALUES(119,'cb2cf5368bb2415fb4f862e53f942e82',0,1,'2019-12-27 11:30:54.908066','2019-11-16 10:00:57.263998',0,0,9,18);
INSERT INTO "oneid_meta_groupperm" VALUES(120,'db31a92bdd04493e8d11137f2adf846f',0,1,'2019-12-27 11:30:54.916348','2019-11-16 10:00:57.266459',0,0,10,18);
INSERT INTO "oneid_meta_groupperm" VALUES(121,'ce1913e628684a9f9fc4a7e353b26cc4',0,1,'2019-12-27 11:30:55.023881','2019-11-16 10:01:13.592455',0,0,1,19);
INSERT INTO "oneid_meta_groupperm" VALUES(122,'5a2b621409bf4769a0b5aeb3592f2a6b',0,1,'2019-12-27 11:30:55.033113','2019-11-16 10:01:13.596209',0,0,2,19);
INSERT INTO "oneid_meta_groupperm" VALUES(123,'6d65dc5eff804fdbbe22d12f8d678bdc',0,1,'2019-12-27 11:30:55.041892','2019-11-16 10:01:13.598874',0,0,3,19);
INSERT INTO "oneid_meta_groupperm" VALUES(124,'def4ba72c7e94022aa6031c9cf3f0c3d',0,1,'2019-12-27 11:30:55.049909','2019-11-16 10:01:13.601244',0,0,4,19);
INSERT INTO "oneid_meta_groupperm" VALUES(125,'cfb127941ad444e690d270c1fd99a35b',0,1,'2019-12-27 11:30:55.057454','2019-11-16 10:01:13.604338',0,0,5,19);
INSERT INTO "oneid_meta_groupperm" VALUES(126,'024b5355f0ed4756b43c09d0068a3dd2',0,1,'2019-12-27 11:30:55.065273','2019-11-16 10:01:13.607993',0,0,6,19);
INSERT INTO "oneid_meta_groupperm" VALUES(127,'4288dff20bda40379fde0f1e6c9e849f',0,1,'2019-12-27 11:30:55.072878','2019-11-16 10:01:13.611652',0,0,7,19);
INSERT INTO "oneid_meta_groupperm" VALUES(128,'be4f78d70f7d4cc2bffcc29dba00f873',0,1,'2019-12-27 11:30:55.080734','2019-11-16 10:01:13.615130',0,0,8,19);
INSERT INTO "oneid_meta_groupperm" VALUES(129,'a1ab9d55c1694566a3bc2e3e9ec9e327',0,1,'2019-12-27 11:30:55.088666','2019-11-16 10:01:13.617946',0,0,9,19);
INSERT INTO "oneid_meta_groupperm" VALUES(130,'779b899fd84e4a9198bd4c24e8181e01',0,1,'2019-12-27 11:30:55.096666','2019-11-16 10:01:13.621024',0,0,10,19);
INSERT INTO "oneid_meta_groupperm" VALUES(131,'2044fa15e24b4f3aaed6f247815890fb',0,1,'2019-12-27 11:30:55.191549','2019-11-16 10:01:32.321276',0,0,1,20);
INSERT INTO "oneid_meta_groupperm" VALUES(132,'547b28976a35417a994c23987af4d2e0',0,1,'2019-12-27 11:30:55.199228','2019-11-16 10:01:32.325163',0,0,2,20);
INSERT INTO "oneid_meta_groupperm" VALUES(133,'0f72712169634681972e5c29de09a822',0,1,'2019-12-27 11:30:55.207168','2019-11-16 10:01:32.328722',0,0,3,20);
INSERT INTO "oneid_meta_groupperm" VALUES(134,'64aa81a4944e48d99329314bf421b577',0,1,'2019-12-27 11:30:55.214657','2019-11-16 10:01:32.331001',0,0,4,20);
INSERT INTO "oneid_meta_groupperm" VALUES(135,'45b811788d884cabb658237b45c76d5f',0,1,'2019-12-27 11:30:55.222648','2019-11-16 10:01:32.333647',0,0,5,20);
INSERT INTO "oneid_meta_groupperm" VALUES(136,'2f95b9c348954b528835691c89ef8600',0,1,'2019-12-27 11:30:55.230424','2019-11-16 10:01:32.337041',0,0,6,20);
INSERT INTO "oneid_meta_groupperm" VALUES(137,'358d00d521c747a3a9b19c692e9779bd',0,1,'2019-12-27 11:30:55.238678','2019-11-16 10:01:32.340596',0,0,7,20);
INSERT INTO "oneid_meta_groupperm" VALUES(138,'bc2313d751184d0f83915e2895b9c166',0,1,'2019-12-27 11:30:55.246341','2019-11-16 10:01:32.344354',0,0,8,20);
INSERT INTO "oneid_meta_groupperm" VALUES(139,'05c3ae2223cf4e749863a3ae9a00a20d',0,1,'2019-12-27 11:30:55.254259','2019-11-16 10:01:32.346933',0,0,9,20);
INSERT INTO "oneid_meta_groupperm" VALUES(140,'3df35dc89919456fb286f0ad32700d88',0,1,'2019-12-27 11:30:55.262063','2019-11-16 10:01:32.349370',0,0,10,20);
INSERT INTO "oneid_meta_groupperm" VALUES(141,'b25869764e4d4c348b947c95998241e5',0,1,'2019-12-27 11:30:55.358205','2019-11-16 10:01:46.866968',0,0,1,21);
INSERT INTO "oneid_meta_groupperm" VALUES(142,'565a23c9d64b4edd84fdb43ff9ea100c',0,1,'2019-12-27 11:30:55.365827','2019-11-16 10:01:46.869365',0,0,2,21);
INSERT INTO "oneid_meta_groupperm" VALUES(143,'547d52469c734682a019e483d3289b36',0,1,'2019-12-27 11:30:55.373975','2019-11-16 10:01:46.871551',0,0,3,21);
INSERT INTO "oneid_meta_groupperm" VALUES(144,'78915abf77ab4a53a9bca081e1858d25',0,1,'2019-12-27 11:30:55.382931','2019-11-16 10:01:46.874242',0,0,4,21);
INSERT INTO "oneid_meta_groupperm" VALUES(145,'e3836f81be3e4399a3e8ad697619a89a',0,1,'2019-12-27 11:30:55.392748','2019-11-16 10:01:46.877263',0,0,5,21);
INSERT INTO "oneid_meta_groupperm" VALUES(146,'3ccc82c6f3c441489f97dc794e47354c',0,1,'2019-12-27 11:30:55.400846','2019-11-16 10:01:46.881041',0,0,6,21);
INSERT INTO "oneid_meta_groupperm" VALUES(147,'d73f0c4ef8bd4aaf87e5f25087959600',0,1,'2019-12-27 11:30:55.408868','2019-11-16 10:01:46.885167',0,0,7,21);
INSERT INTO "oneid_meta_groupperm" VALUES(148,'392d57c40cde420c9a1d865108db57f7',0,1,'2019-12-27 11:30:55.416710','2019-11-16 10:01:46.887647',0,0,8,21);
INSERT INTO "oneid_meta_groupperm" VALUES(149,'be706eba05674f83affd07b71f9ae166',0,1,'2019-12-27 11:30:55.424330','2019-11-16 10:01:46.890024',0,0,9,21);
INSERT INTO "oneid_meta_groupperm" VALUES(150,'512fc319ebda4688be0879194476858c',0,1,'2019-12-27 11:30:55.432175','2019-11-16 10:01:46.892764',0,0,10,21);
INSERT INTO "oneid_meta_groupperm" VALUES(151,'6cd45752a80740519dd2916ece28911d',0,1,'2019-12-27 11:30:56.853472','2019-11-16 10:01:58.598710',0,0,1,22);
INSERT INTO "oneid_meta_groupperm" VALUES(152,'1c8c1603cc9d4c3ba0f518357b94977b',0,1,'2019-12-27 11:30:56.862822','2019-11-16 10:01:58.602300',0,0,2,22);
INSERT INTO "oneid_meta_groupperm" VALUES(153,'ae86f35b473a429784463a8d5d2bc956',0,1,'2019-12-27 11:30:56.871987','2019-11-16 10:01:58.605487',0,0,3,22);
INSERT INTO "oneid_meta_groupperm" VALUES(154,'6a609499169f478a9f7cb972d293259e',0,1,'2019-12-27 11:30:56.880667','2019-11-16 10:01:58.609377',0,0,4,22);
INSERT INTO "oneid_meta_groupperm" VALUES(155,'4ad499c7b3db438cac0ff853ea331dca',0,1,'2019-12-27 11:30:56.889790','2019-11-16 10:01:58.612603',0,0,5,22);
INSERT INTO "oneid_meta_groupperm" VALUES(156,'ff4923a34a814b07b4ca518df0265aec',0,1,'2019-12-27 11:30:56.898117','2019-11-16 10:01:58.616710',0,0,6,22);
INSERT INTO "oneid_meta_groupperm" VALUES(157,'71a01800126a40c8a78cede28b73fe13',0,1,'2019-12-27 11:30:56.907214','2019-11-16 10:01:58.620784',0,0,7,22);
INSERT INTO "oneid_meta_groupperm" VALUES(158,'9a50203a86b44b36b9514f78c1306008',0,1,'2019-12-27 11:30:56.914917','2019-11-16 10:01:58.624028',0,0,8,22);
INSERT INTO "oneid_meta_groupperm" VALUES(159,'8f908ffe45d14fb7b5b7e8cd1cb008df',0,1,'2019-12-27 11:30:56.923904','2019-11-16 10:01:58.626475',0,0,9,22);
INSERT INTO "oneid_meta_groupperm" VALUES(160,'7a8661ecc2974ccbab3b6b81de7910be',0,1,'2019-12-27 11:30:56.931986','2019-11-16 10:01:58.629623',0,0,10,22);
INSERT INTO "oneid_meta_groupperm" VALUES(161,'4fcbe0b80eed4eafb8d3b29357f167e3',0,1,'2019-12-27 11:30:57.974548','2019-11-16 10:02:09.007015',0,0,1,23);
INSERT INTO "oneid_meta_groupperm" VALUES(162,'9c5ba40426c94a49944bae09d6b6c801',0,1,'2019-12-27 11:30:57.982799','2019-11-16 10:02:09.010918',0,0,2,23);
INSERT INTO "oneid_meta_groupperm" VALUES(163,'09d915e476cf470ab62479f47bb18b04',0,1,'2019-12-27 11:30:57.991276','2019-11-16 10:02:09.013708',0,0,3,23);
INSERT INTO "oneid_meta_groupperm" VALUES(164,'2a025500aa5e4edfa541467ce081df11',0,1,'2019-12-27 11:30:57.999505','2019-11-16 10:02:09.016574',0,0,4,23);
INSERT INTO "oneid_meta_groupperm" VALUES(165,'9b6012b4f0d14ef6812f3618a12cbd2e',0,1,'2019-12-27 11:30:58.008792','2019-11-16 10:02:09.019145',0,0,5,23);
INSERT INTO "oneid_meta_groupperm" VALUES(166,'dd6219f30db14ad1a43e749c85e539bf',0,1,'2019-12-27 11:30:58.016805','2019-11-16 10:02:09.021948',0,0,6,23);
INSERT INTO "oneid_meta_groupperm" VALUES(167,'2b9032ef6db540748a3ac845d22bf0bd',0,1,'2019-12-27 11:30:58.026462','2019-11-16 10:02:09.025642',0,0,7,23);
INSERT INTO "oneid_meta_groupperm" VALUES(168,'3cb3b7d684fc400bb917c11d9fac0970',0,1,'2019-12-27 11:30:58.035113','2019-11-16 10:02:09.029305',0,0,8,23);
INSERT INTO "oneid_meta_groupperm" VALUES(169,'eaf537198fdc487fa03327b53472a057',0,1,'2019-12-27 11:30:58.044677','2019-11-16 10:02:09.031975',0,0,9,23);
INSERT INTO "oneid_meta_groupperm" VALUES(170,'7e0239a1e6eb4ec781df4d991e1fa06d',0,1,'2019-12-27 11:30:58.052761','2019-11-16 10:02:09.034285',0,0,10,23);
INSERT INTO "oneid_meta_groupperm" VALUES(171,'099401a990394f5d959db69883f5b239',0,1,'2019-12-27 11:30:59.015772','2019-11-16 10:02:16.333851',0,0,1,24);
INSERT INTO "oneid_meta_groupperm" VALUES(172,'19e03fb05cc848ccbc71dd14b6dd2c3c',0,1,'2019-12-27 11:30:59.023550','2019-11-16 10:02:16.337461',0,0,2,24);
INSERT INTO "oneid_meta_groupperm" VALUES(173,'6132c383d1f642c09845e3800ae276a8',0,1,'2019-12-27 11:30:59.031463','2019-11-16 10:02:16.340854',0,0,3,24);
INSERT INTO "oneid_meta_groupperm" VALUES(174,'54aff2def09548d7b17b0efb87008b58',0,1,'2019-12-27 11:30:59.039007','2019-11-16 10:02:16.343954',0,0,4,24);
INSERT INTO "oneid_meta_groupperm" VALUES(175,'6fb3930e3fa14e8a914fbb68ce26440a',0,1,'2019-12-27 11:30:59.047072','2019-11-16 10:02:16.346694',0,0,5,24);
INSERT INTO "oneid_meta_groupperm" VALUES(176,'6a83ae99d8364369a2df435d7b6a8c36',0,1,'2019-12-27 11:30:59.054847','2019-11-16 10:02:16.349614',0,0,6,24);
INSERT INTO "oneid_meta_groupperm" VALUES(177,'cd87f30212ab446f88e956de1988ece4',0,1,'2019-12-27 11:30:59.062817','2019-11-16 10:02:16.353311',0,0,7,24);
INSERT INTO "oneid_meta_groupperm" VALUES(178,'184f2e4da5884a95a333a45db7eafcfa',0,1,'2019-12-27 11:30:59.070232','2019-11-16 10:02:16.356938',0,0,8,24);
INSERT INTO "oneid_meta_groupperm" VALUES(179,'44c9bcc3b53546538fc2073b175d47f6',0,1,'2019-12-27 11:30:59.078187','2019-11-16 10:02:16.359981',0,0,9,24);
INSERT INTO "oneid_meta_groupperm" VALUES(180,'d36361f80959444b8726df22d679440d',0,1,'2019-12-27 11:30:59.085698','2019-11-16 10:02:16.363158',0,0,10,24);
INSERT INTO "oneid_meta_groupperm" VALUES(181,'37c9c66e06f9496fa15875af6ef7be80',0,1,'2019-12-27 11:30:59.345949','2019-11-16 10:02:23.262488',0,0,1,25);
INSERT INTO "oneid_meta_groupperm" VALUES(182,'bec57725822b4a0199e59a9dfb626d8b',0,1,'2019-12-27 11:30:59.353584','2019-11-16 10:02:23.265763',0,0,2,25);
INSERT INTO "oneid_meta_groupperm" VALUES(183,'908c431a0e6847f5918aa4f2cb035577',0,1,'2019-12-27 11:30:59.361454','2019-11-16 10:02:23.268992',0,0,3,25);
INSERT INTO "oneid_meta_groupperm" VALUES(184,'ecfab07fa1c342ed9abb14e22ccd1b0b',0,1,'2019-12-27 11:30:59.369113','2019-11-16 10:02:23.272284',0,0,4,25);
INSERT INTO "oneid_meta_groupperm" VALUES(185,'a261dd6678914412bbd93b223c5951b3',0,1,'2019-12-27 11:30:59.377533','2019-11-16 10:02:23.275267',0,0,5,25);
INSERT INTO "oneid_meta_groupperm" VALUES(186,'bc854cf18d274e96a180fe859065194d',0,1,'2019-12-27 11:30:59.385094','2019-11-16 10:02:23.278336',0,0,6,25);
INSERT INTO "oneid_meta_groupperm" VALUES(187,'90bb7f3c392b457d9256524a708c2cc5',0,1,'2019-12-27 11:30:59.392888','2019-11-16 10:02:23.281662',0,0,7,25);
INSERT INTO "oneid_meta_groupperm" VALUES(188,'56657ca75eb1493196f6f4c0047c0f14',0,1,'2019-12-27 11:30:59.400334','2019-11-16 10:02:23.284402',0,0,8,25);
INSERT INTO "oneid_meta_groupperm" VALUES(189,'7ead0624dde34313beaebe0f58770766',0,1,'2019-12-27 11:30:59.408208','2019-11-16 10:02:23.287199',0,0,9,25);
INSERT INTO "oneid_meta_groupperm" VALUES(190,'3712cbbf9db64bd4b15f23f8761d02d4',0,1,'2019-12-27 11:30:59.415802','2019-11-16 10:02:23.290305',0,0,10,25);
INSERT INTO "oneid_meta_groupperm" VALUES(191,'d64fca0856eb44059e6b176c820fcc1f',0,1,'2019-12-27 11:30:59.675908','2019-11-16 10:02:32.389340',0,0,1,26);
INSERT INTO "oneid_meta_groupperm" VALUES(192,'76b917ee8b05471783ff7a165f7932ff',0,1,'2019-12-27 11:30:59.684314','2019-11-16 10:02:32.392418',0,0,2,26);
INSERT INTO "oneid_meta_groupperm" VALUES(193,'be80a9a1296e4efd969e60c4428390cd',0,1,'2019-12-27 11:30:59.692128','2019-11-16 10:02:32.395271',0,0,3,26);
INSERT INTO "oneid_meta_groupperm" VALUES(194,'a6a23b626f7b451e8f0ea3b887bb8a35',0,1,'2019-12-27 11:30:59.699769','2019-11-16 10:02:32.398287',0,0,4,26);
INSERT INTO "oneid_meta_groupperm" VALUES(195,'da2eedb6fc9b4a6484b0366aa8e5d438',0,1,'2019-12-27 11:30:59.707915','2019-11-16 10:02:32.401205',0,0,5,26);
INSERT INTO "oneid_meta_groupperm" VALUES(196,'750393dd203e43c7949f3c10cf8f1ba5',0,1,'2019-12-27 11:30:59.715428','2019-11-16 10:02:32.404361',0,0,6,26);
INSERT INTO "oneid_meta_groupperm" VALUES(197,'de643d89e8674b1e9f2d5f248b418dfe',0,1,'2019-12-27 11:30:59.723179','2019-11-16 10:02:32.408293',0,0,7,26);
INSERT INTO "oneid_meta_groupperm" VALUES(198,'078a67c53cf74330b5655471e00a4170',0,1,'2019-12-27 11:30:59.730623','2019-11-16 10:02:32.411619',0,0,8,26);
INSERT INTO "oneid_meta_groupperm" VALUES(199,'47e13e3bf7244b21a11970db740600f6',0,1,'2019-12-27 11:30:59.738459','2019-11-16 10:02:32.414792',0,0,9,26);
INSERT INTO "oneid_meta_groupperm" VALUES(200,'9dcfe5a4ca8b4864a6c925011e81a8e4',0,1,'2019-12-27 11:30:59.745920','2019-11-16 10:02:32.417959',0,0,10,26);
INSERT INTO "oneid_meta_groupperm" VALUES(201,'cd389cde66174a32b208ee9421a73855',0,1,'2019-12-27 11:30:55.698611','2019-11-16 10:04:05.938764',0,0,1,27);
INSERT INTO "oneid_meta_groupperm" VALUES(202,'e94070d1135146448fbf6aaec17479a1',0,1,'2019-12-27 11:30:55.706583','2019-11-16 10:04:05.942032',0,0,2,27);
INSERT INTO "oneid_meta_groupperm" VALUES(203,'4b04207360194005a5f09d8d892bfffb',0,1,'2019-12-27 11:30:55.714468','2019-11-16 10:04:05.944773',0,0,3,27);
INSERT INTO "oneid_meta_groupperm" VALUES(204,'70b50fea3a4e4f958516266f58dd81c4',0,1,'2019-12-27 11:30:55.722429','2019-11-16 10:04:05.947764',0,0,4,27);
INSERT INTO "oneid_meta_groupperm" VALUES(205,'4f3607738dbf4b0da9a4c82fbd0f8e22',0,1,'2019-12-27 11:30:55.730070','2019-11-16 10:04:05.951383',0,0,5,27);
INSERT INTO "oneid_meta_groupperm" VALUES(206,'ca0f3437b4ad40b4af03ca331da978c1',0,1,'2019-12-27 11:30:55.738560','2019-11-16 10:04:05.955120',0,0,6,27);
INSERT INTO "oneid_meta_groupperm" VALUES(207,'b582f4f3cfa34193b3ff2ce607503778',0,1,'2019-12-27 11:30:55.746411','2019-11-16 10:04:05.959041',0,0,7,27);
INSERT INTO "oneid_meta_groupperm" VALUES(208,'b3ea8c3a7828492a9ce385f1503d6d7d',0,1,'2019-12-27 11:30:55.754222','2019-11-16 10:04:05.961901',0,0,8,27);
INSERT INTO "oneid_meta_groupperm" VALUES(209,'45f67cdfae4847468d9c78ea86fce60c',0,1,'2019-12-27 11:30:55.762026','2019-11-16 10:04:05.964998',0,0,9,27);
INSERT INTO "oneid_meta_groupperm" VALUES(210,'d283e625acc549439972dc0cfedb308c',0,1,'2019-12-27 11:30:55.769823','2019-11-16 10:04:05.968040',0,0,10,27);
INSERT INTO "oneid_meta_groupperm" VALUES(211,'2930b78a1f5843e8be526573a5feda2e',0,1,'2019-12-27 11:30:56.043114','2019-11-16 10:04:17.141282',0,0,1,28);
INSERT INTO "oneid_meta_groupperm" VALUES(212,'58107c6c04734161b999dc7b21f13ff0',0,1,'2019-12-27 11:30:56.051167','2019-11-16 10:04:17.145727',0,0,2,28);
INSERT INTO "oneid_meta_groupperm" VALUES(213,'5094ba9700144c72bd2d8b169ebf02b9',0,1,'2019-12-27 11:30:56.059101','2019-11-16 10:04:17.148780',0,0,3,28);
INSERT INTO "oneid_meta_groupperm" VALUES(214,'c87456b09b4449149de29f5a88749608',0,1,'2019-12-27 11:30:56.067503','2019-11-16 10:04:17.151118',0,0,4,28);
INSERT INTO "oneid_meta_groupperm" VALUES(215,'8fb402c1bd474e81a6ad18fa6bd063cb',0,1,'2019-12-27 11:30:56.075775','2019-11-16 10:04:17.153971',0,0,5,28);
INSERT INTO "oneid_meta_groupperm" VALUES(216,'eb08699bf7194180bc49b7b23281a8ec',0,1,'2019-12-27 11:30:56.084171','2019-11-16 10:04:17.157586',0,0,6,28);
INSERT INTO "oneid_meta_groupperm" VALUES(217,'c8b52cb95e7c457e8187c870018bbcc8',0,1,'2019-12-27 11:30:56.092606','2019-11-16 10:04:17.161395',0,0,7,28);
INSERT INTO "oneid_meta_groupperm" VALUES(218,'fa929c77c1d84760941b4951b9a60999',0,1,'2019-12-27 11:30:56.100778','2019-11-16 10:04:17.164488',0,0,8,28);
INSERT INTO "oneid_meta_groupperm" VALUES(219,'22637890f3db4bb69ec49645d7305988',0,1,'2019-12-27 11:30:56.109382','2019-11-16 10:04:17.167277',0,0,9,28);
INSERT INTO "oneid_meta_groupperm" VALUES(220,'e85bfee21f65445ebf9283fae5f4d098',0,1,'2019-12-27 11:30:56.117408','2019-11-16 10:04:17.170411',0,0,10,28);
INSERT INTO "oneid_meta_groupperm" VALUES(221,'3e199f9cf4e34279840d604bc3f507d5',0,1,'2019-12-27 11:30:56.436153','2019-11-16 10:04:35.919085',0,0,1,29);
INSERT INTO "oneid_meta_groupperm" VALUES(222,'d6b9d915bcc44aed9b295d0014c0535d',0,1,'2019-12-27 11:30:56.445139','2019-11-16 10:04:35.922550',0,0,2,29);
INSERT INTO "oneid_meta_groupperm" VALUES(223,'b88cc3b86e3749df949bd5c984e025ad',0,1,'2019-12-27 11:30:56.453310','2019-11-16 10:04:35.925360',0,0,3,29);
INSERT INTO "oneid_meta_groupperm" VALUES(224,'1bc5bf4f07de4e6b9a72b437af12ecbc',0,1,'2019-12-27 11:30:56.462736','2019-11-16 10:04:35.928608',0,0,4,29);
INSERT INTO "oneid_meta_groupperm" VALUES(225,'d4becf92871f4028bb61f8d3eb5c4d92',0,1,'2019-12-27 11:30:56.471417','2019-11-16 10:04:35.931375',0,0,5,29);
INSERT INTO "oneid_meta_groupperm" VALUES(226,'7c73d697625a4c98aea50c683406172f',0,1,'2019-12-27 11:30:56.480382','2019-11-16 10:04:35.934875',0,0,6,29);
INSERT INTO "oneid_meta_groupperm" VALUES(227,'570e677108624102958f819368ce1cb3',0,1,'2019-12-27 11:30:56.489455','2019-11-16 10:04:35.939005',0,0,7,29);
INSERT INTO "oneid_meta_groupperm" VALUES(228,'92cb4bb8bae64a549a4b1f870d245171',0,1,'2019-12-27 11:30:56.497694','2019-11-16 10:04:35.942683',0,0,8,29);
INSERT INTO "oneid_meta_groupperm" VALUES(229,'e47478e88d4a46c8962d752e6a8b61e5',0,1,'2019-12-27 11:30:56.506772','2019-11-16 10:04:35.945764',0,0,9,29);
INSERT INTO "oneid_meta_groupperm" VALUES(230,'953823bda64c41608d4847bc763e5258',0,1,'2019-12-27 11:30:56.515658','2019-11-16 10:04:35.949209',0,0,10,29);
INSERT INTO "oneid_meta_groupperm" VALUES(231,'a5a07a3464e94ad9a2ceefaee9c64652',0,1,'2019-12-27 11:30:57.042734','2019-11-16 10:05:00.126396',0,0,1,30);
INSERT INTO "oneid_meta_groupperm" VALUES(232,'3c8149263a74480b8eda2b089386076c',0,1,'2019-12-27 11:30:57.050856','2019-11-16 10:05:00.129882',0,0,2,30);
INSERT INTO "oneid_meta_groupperm" VALUES(233,'05ec485ebd5e457aabd3366c6eb2d845',0,1,'2019-12-27 11:30:57.059851','2019-11-16 10:05:00.133974',0,0,3,30);
INSERT INTO "oneid_meta_groupperm" VALUES(234,'3f6567f0acde494cb0f0c32fbb727a70',0,1,'2019-12-27 11:30:57.071734','2019-11-16 10:05:00.137047',0,0,4,30);
INSERT INTO "oneid_meta_groupperm" VALUES(235,'d5e41e9a1271478c826f447ad6fc85b2',0,1,'2019-12-27 11:30:57.080629','2019-11-16 10:05:00.139893',0,0,5,30);
INSERT INTO "oneid_meta_groupperm" VALUES(236,'b063c3bf4c20403091bc609c46f4b847',0,1,'2019-12-27 11:30:57.092168','2019-11-16 10:05:00.143140',0,0,6,30);
INSERT INTO "oneid_meta_groupperm" VALUES(237,'832550a182694cb1a265fa43bb4a026b',0,1,'2019-12-27 11:30:57.101517','2019-11-16 10:05:00.147232',0,0,7,30);
INSERT INTO "oneid_meta_groupperm" VALUES(238,'0c71200de98243fb8978feae30b70e5a',0,1,'2019-12-27 11:30:57.112700','2019-11-16 10:05:00.150889',0,0,8,30);
INSERT INTO "oneid_meta_groupperm" VALUES(239,'8a3c77869d18480a8d798d6ff613e5e5',0,1,'2019-12-27 11:30:57.121506','2019-11-16 10:05:00.154246',0,0,9,30);
INSERT INTO "oneid_meta_groupperm" VALUES(240,'6d54199ccea84e51885d87b9302d649e',0,1,'2019-12-27 11:30:57.131318','2019-11-16 10:05:00.157226',0,0,10,30);
INSERT INTO "oneid_meta_groupperm" VALUES(241,'24c705d514a7438f8cfa936189260fb6',0,1,'2019-12-27 11:30:57.243859','2019-11-16 10:05:20.301115',0,0,1,31);
INSERT INTO "oneid_meta_groupperm" VALUES(242,'e6863cb9542a4bba9ec46be75f1e059c',0,1,'2019-12-27 11:30:57.251945','2019-11-16 10:05:20.304701',0,0,2,31);
INSERT INTO "oneid_meta_groupperm" VALUES(243,'f3bcb3e9d020464889fd0057c4a59d74',0,1,'2019-12-27 11:30:57.261073','2019-11-16 10:05:20.308672',0,0,3,31);
INSERT INTO "oneid_meta_groupperm" VALUES(244,'62da7c6445da424386797ae64accce7b',0,1,'2019-12-27 11:30:57.269260','2019-11-16 10:05:20.311169',0,0,4,31);
INSERT INTO "oneid_meta_groupperm" VALUES(245,'85e402dee4704344b55bc76d191eb5fa',0,1,'2019-12-27 11:30:57.278693','2019-11-16 10:05:20.313572',0,0,5,31);
INSERT INTO "oneid_meta_groupperm" VALUES(246,'b93492c8587545f4b9c1a511e54e52e8',0,1,'2019-12-27 11:30:57.286717','2019-11-16 10:05:20.316069',0,0,6,31);
INSERT INTO "oneid_meta_groupperm" VALUES(247,'f42d069cfe8c403e892f0b8962f5d592',0,1,'2019-12-27 11:30:57.296962','2019-11-16 10:05:20.319605',0,0,7,31);
INSERT INTO "oneid_meta_groupperm" VALUES(248,'9edd7c89541b4a8fa081ab90a697750a',0,1,'2019-12-27 11:30:57.305903','2019-11-16 10:05:20.322870',0,0,8,31);
INSERT INTO "oneid_meta_groupperm" VALUES(249,'da650120835a419e94da2e83c81a36d3',0,1,'2019-12-27 11:30:57.314192','2019-11-16 10:05:20.328096',0,0,9,31);
INSERT INTO "oneid_meta_groupperm" VALUES(250,'19f87fd052d04d1e82f1c2e0eee95273',0,1,'2019-12-27 11:30:57.324302','2019-11-16 10:05:20.331405',0,0,10,31);
INSERT INTO "oneid_meta_groupperm" VALUES(251,'1935ffaf5d534d00a7d1bf0fb1f3ecce',0,1,'2019-12-27 11:30:57.435426','2019-11-16 10:05:28.242079',0,0,1,32);
INSERT INTO "oneid_meta_groupperm" VALUES(252,'affb14d9a42742ceb62e1455c835a531',0,1,'2019-12-27 11:30:57.444913','2019-11-16 10:05:28.245754',0,0,2,32);
INSERT INTO "oneid_meta_groupperm" VALUES(253,'fafd7dd8126d4b4dbd98def789f139a5',0,1,'2019-12-27 11:30:57.452687','2019-11-16 10:05:28.248536',0,0,3,32);
INSERT INTO "oneid_meta_groupperm" VALUES(254,'5ac8eb4264bf4dc1b8b3289e21f5c4f6',0,1,'2019-12-27 11:30:57.462577','2019-11-16 10:05:28.251020',0,0,4,32);
INSERT INTO "oneid_meta_groupperm" VALUES(255,'eb53e080597e423c88b653df893a4ccf',0,1,'2019-12-27 11:30:57.470426','2019-11-16 10:05:28.253673',0,0,5,32);
INSERT INTO "oneid_meta_groupperm" VALUES(256,'e3731e1e02a94fb1927fa036ce36d222',0,1,'2019-12-27 11:30:57.479608','2019-11-16 10:05:28.257346',0,0,6,32);
INSERT INTO "oneid_meta_groupperm" VALUES(257,'c3f33970f0294cf8af0da98f3cc31add',0,1,'2019-12-27 11:30:57.487166','2019-11-16 10:05:28.261080',0,0,7,32);
INSERT INTO "oneid_meta_groupperm" VALUES(258,'db9a403f32064d8fbe6094064894083c',0,1,'2019-12-27 11:30:57.496810','2019-11-16 10:05:28.264804',0,0,8,32);
INSERT INTO "oneid_meta_groupperm" VALUES(259,'bf435ff9e4ea4140a0d97ce47ec52e18',0,1,'2019-12-27 11:30:57.505788','2019-11-16 10:05:28.267226',0,0,9,32);
INSERT INTO "oneid_meta_groupperm" VALUES(260,'fc8c85a72f0146a1b69ae4b9a3c42c58',0,1,'2019-12-27 11:30:57.513931','2019-11-16 10:05:28.269609',0,0,10,32);
INSERT INTO "oneid_meta_groupperm" VALUES(261,'9b1f6d926e144f429271cad9039ab24b',0,1,'2019-12-27 11:30:57.613731','2019-11-16 10:05:36.498859',0,0,1,33);
INSERT INTO "oneid_meta_groupperm" VALUES(262,'934ac7bef909454eacc1d986b3659a60',0,1,'2019-12-27 11:30:57.621816','2019-11-16 10:05:36.502372',0,0,2,33);
INSERT INTO "oneid_meta_groupperm" VALUES(263,'2e2f668791e34bbfa76f9adaf495cb87',0,1,'2019-12-27 11:30:57.630122','2019-11-16 10:05:36.506247',0,0,3,33);
INSERT INTO "oneid_meta_groupperm" VALUES(264,'4b6621ca446040cfb562c82b6dd37001',0,1,'2019-12-27 11:30:57.638180','2019-11-16 10:05:36.508559',0,0,4,33);
INSERT INTO "oneid_meta_groupperm" VALUES(265,'f2fbaabb1312455880dc1d725f08256f',0,1,'2019-12-27 11:30:57.646330','2019-11-16 10:05:36.511301',0,0,5,33);
INSERT INTO "oneid_meta_groupperm" VALUES(266,'d1d027ad9ea1479e8beddda2a4c008f8',0,1,'2019-12-27 11:30:57.654016','2019-11-16 10:05:36.514929',0,0,6,33);
INSERT INTO "oneid_meta_groupperm" VALUES(267,'888fc7e74ec34064a272942cacc45d60',0,1,'2019-12-27 11:30:57.663134','2019-11-16 10:05:36.519521',0,0,7,33);
INSERT INTO "oneid_meta_groupperm" VALUES(268,'5717c2c1415444a5b9819dacb82fc9f0',0,1,'2019-12-27 11:30:57.671444','2019-11-16 10:05:36.522453',0,0,8,33);
INSERT INTO "oneid_meta_groupperm" VALUES(269,'d970e8d56f2347c28d5d99f16c64d9c8',0,1,'2019-12-27 11:30:57.679675','2019-11-16 10:05:36.525044',0,0,9,33);
INSERT INTO "oneid_meta_groupperm" VALUES(270,'60db1c9b2d074330b8683724204e6228',0,1,'2019-12-27 11:30:57.687894','2019-11-16 10:05:36.527797',0,0,10,33);
INSERT INTO "oneid_meta_groupperm" VALUES(271,'8cd2285e9efb4dd6a4095f6dade6eaad',0,1,'2019-12-27 11:30:57.794049','2019-11-16 10:05:47.426274',0,0,1,34);
INSERT INTO "oneid_meta_groupperm" VALUES(272,'e3288bd35e464b3caf96000920257ec6',0,1,'2019-12-27 11:30:57.802180','2019-11-16 10:05:47.428979',0,0,2,34);
INSERT INTO "oneid_meta_groupperm" VALUES(273,'dafe1f2c53d0471f9c07adae5abd4b52',0,1,'2019-12-27 11:30:57.811381','2019-11-16 10:05:47.431636',0,0,3,34);
INSERT INTO "oneid_meta_groupperm" VALUES(274,'6d7d9c2c97e54eb9a4f92384e1829c14',0,1,'2019-12-27 11:30:57.819418','2019-11-16 10:05:47.435590',0,0,4,34);
INSERT INTO "oneid_meta_groupperm" VALUES(275,'4e9719ed5b48465bb61a0367d40acd4c',0,1,'2019-12-27 11:30:57.828745','2019-11-16 10:05:47.438896',0,0,5,34);
INSERT INTO "oneid_meta_groupperm" VALUES(276,'c90b445ca6ed41f0a9cf763bf4ea626a',0,1,'2019-12-27 11:30:57.836456','2019-11-16 10:05:47.442230',0,0,6,34);
INSERT INTO "oneid_meta_groupperm" VALUES(277,'2ad9964837754e149722ceee73714a4d',0,1,'2019-12-27 11:30:57.846073','2019-11-16 10:05:47.445473',0,0,7,34);
INSERT INTO "oneid_meta_groupperm" VALUES(278,'3d105880a0234ce0a8ea512af72f1f0c',0,1,'2019-12-27 11:30:57.854010','2019-11-16 10:05:47.449007',0,0,8,34);
INSERT INTO "oneid_meta_groupperm" VALUES(279,'e9dd688673f44ddf9ff2143a676af720',0,1,'2019-12-27 11:30:57.863345','2019-11-16 10:05:47.451858',0,0,9,34);
INSERT INTO "oneid_meta_groupperm" VALUES(280,'30122545c75c4d6c9e54280efad3bbf5',0,1,'2019-12-27 11:30:57.871383','2019-11-16 10:05:47.456549',0,0,10,34);
INSERT INTO "oneid_meta_groupperm" VALUES(281,'b8a9127f18d24ca3abd0730de1a4f1d7',0,1,'2019-12-27 11:30:58.161497','2019-11-16 10:06:01.140677',0,0,1,35);
INSERT INTO "oneid_meta_groupperm" VALUES(282,'6c3382b06b62471f9e61975bd129b24d',0,1,'2019-12-27 11:30:58.169850','2019-11-16 10:06:01.144509',0,0,2,35);
INSERT INTO "oneid_meta_groupperm" VALUES(283,'b24eb9ba94c24363aca0621832b2e65d',0,1,'2019-12-27 11:30:58.178910','2019-11-16 10:06:01.147039',0,0,3,35);
INSERT INTO "oneid_meta_groupperm" VALUES(284,'1ccafeabd953421fb03c691f84594d88',0,1,'2019-12-27 11:30:58.187208','2019-11-16 10:06:01.149955',0,0,4,35);
INSERT INTO "oneid_meta_groupperm" VALUES(285,'eea37342eb914adebf2086292501763d',0,1,'2019-12-27 11:30:58.195219','2019-11-16 10:06:01.152909',0,0,5,35);
INSERT INTO "oneid_meta_groupperm" VALUES(286,'4f7d902c358446479d9005122dc6011d',0,1,'2019-12-27 11:30:58.203436','2019-11-16 10:06:01.157017',0,0,6,35);
INSERT INTO "oneid_meta_groupperm" VALUES(287,'6ad10bf4e4014c0f897944809542f4d4',0,1,'2019-12-27 11:30:58.211974','2019-11-16 10:06:01.160745',0,0,7,35);
INSERT INTO "oneid_meta_groupperm" VALUES(288,'7b2616bb7f8f46888363b972780299ce',0,1,'2019-12-27 11:30:58.219583','2019-11-16 10:06:01.163487',0,0,8,35);
INSERT INTO "oneid_meta_groupperm" VALUES(289,'693bf2ac16014ff798cccbb5824e3460',0,1,'2019-12-27 11:30:58.227782','2019-11-16 10:06:01.166373',0,0,9,35);
INSERT INTO "oneid_meta_groupperm" VALUES(290,'e99f473ee79f4d81944a5e4002a8ccaa',0,1,'2019-12-27 11:30:58.235757','2019-11-16 10:06:01.168777',0,0,10,35);
INSERT INTO "oneid_meta_groupperm" VALUES(291,'345885bb8bf74f938b0bb3d7159b013a',0,1,'2019-12-27 11:30:58.332592','2019-11-16 10:06:09.125624',0,0,1,36);
INSERT INTO "oneid_meta_groupperm" VALUES(292,'f97fcda3a64d44f5b45e2b11b0ac97c4',0,1,'2019-12-27 11:30:58.340333','2019-11-16 10:06:09.129462',0,0,2,36);
INSERT INTO "oneid_meta_groupperm" VALUES(293,'15bdb88ba7054e658ab6beae8f7f9b98',0,1,'2019-12-27 11:30:58.348925','2019-11-16 10:06:09.133373',0,0,3,36);
INSERT INTO "oneid_meta_groupperm" VALUES(294,'3146119338534d5c92ae727271c78ba6',0,1,'2019-12-27 11:30:58.357138','2019-11-16 10:06:09.136478',0,0,4,36);
INSERT INTO "oneid_meta_groupperm" VALUES(295,'a7173c834d8e431b8c95b4005732dbc7',0,1,'2019-12-27 11:30:58.364979','2019-11-16 10:06:09.139464',0,0,5,36);
INSERT INTO "oneid_meta_groupperm" VALUES(296,'caffe564f6824c5bbec745522e311d61',0,1,'2019-12-27 11:30:58.373515','2019-11-16 10:06:09.143222',0,0,6,36);
INSERT INTO "oneid_meta_groupperm" VALUES(297,'a58e82cf18f44740b7bbb5b4f63ac9fb',0,1,'2019-12-27 11:30:58.382049','2019-11-16 10:06:09.146948',0,0,7,36);
INSERT INTO "oneid_meta_groupperm" VALUES(298,'25dace70a1fa45d1a34a67e8f2898b88',0,1,'2019-12-27 11:30:58.390066','2019-11-16 10:06:09.150204',0,0,8,36);
INSERT INTO "oneid_meta_groupperm" VALUES(299,'6a031d79b7d64ed5993a5f6641dbce09',0,1,'2019-12-27 11:30:58.398405','2019-11-16 10:06:09.153135',0,0,9,36);
INSERT INTO "oneid_meta_groupperm" VALUES(300,'426040c6d3454103b24b99411ea42d2b',0,1,'2019-12-27 11:30:58.405979','2019-11-16 10:06:09.156224',0,0,10,36);
INSERT INTO "oneid_meta_groupperm" VALUES(301,'e8c7dd7554814d8382e512fccbfa74bd',0,1,'2019-12-27 11:30:58.506180','2019-11-16 10:06:16.587735',0,0,1,37);
INSERT INTO "oneid_meta_groupperm" VALUES(302,'ce55d4d762264f358f70adc8930abb42',0,1,'2019-12-27 11:30:58.514372','2019-11-16 10:06:16.591565',0,0,2,37);
INSERT INTO "oneid_meta_groupperm" VALUES(303,'a0546772d33d4fefb5d3ef03c1d4cb27',0,1,'2019-12-27 11:30:58.522411','2019-11-16 10:06:16.594934',0,0,3,37);
INSERT INTO "oneid_meta_groupperm" VALUES(304,'51fb8ba066bb46aeb245e03741ee3b29',0,1,'2019-12-27 11:30:58.530434','2019-11-16 10:06:16.597502',0,0,4,37);
INSERT INTO "oneid_meta_groupperm" VALUES(305,'6438857cf60e4155b17789f42abd5607',0,1,'2019-12-27 11:30:58.538923','2019-11-16 10:06:16.601970',0,0,5,37);
INSERT INTO "oneid_meta_groupperm" VALUES(306,'f621e9d70b1d4059b7d8293bb97214aa',0,1,'2019-12-27 11:30:58.547034','2019-11-16 10:06:16.605334',0,0,6,37);
INSERT INTO "oneid_meta_groupperm" VALUES(307,'cc27e6886019461295af4004831c680f',0,1,'2019-12-27 11:30:58.554937','2019-11-16 10:06:16.608205',0,0,7,37);
INSERT INTO "oneid_meta_groupperm" VALUES(308,'afd44a3e39e64ad4a27a71bbe3183eea',0,1,'2019-12-27 11:30:58.563287','2019-11-16 10:06:16.611484',0,0,8,37);
INSERT INTO "oneid_meta_groupperm" VALUES(309,'1869a26277f04837960cd97cf4f73d71',0,1,'2019-12-27 11:30:58.571407','2019-11-16 10:06:16.614003',0,0,9,37);
INSERT INTO "oneid_meta_groupperm" VALUES(310,'621fecd71eea42b0b3dc02f3db5a4b5d',0,1,'2019-12-27 11:30:58.579394','2019-11-16 10:06:16.617394',0,0,10,37);
INSERT INTO "oneid_meta_groupperm" VALUES(311,'fbe785aa21184eb8acf634dc90411818',0,1,'2019-12-27 11:30:58.674373','2019-11-16 10:06:24.142016',0,0,1,38);
INSERT INTO "oneid_meta_groupperm" VALUES(312,'53941ecdfb5346f6ac6f4d4667c29676',0,1,'2019-12-27 11:30:58.683217','2019-11-16 10:06:24.145879',0,0,2,38);
INSERT INTO "oneid_meta_groupperm" VALUES(313,'779a08b225ed46b683e60997ce754082',0,1,'2019-12-27 11:30:58.691027','2019-11-16 10:06:24.148997',0,0,3,38);
INSERT INTO "oneid_meta_groupperm" VALUES(314,'c840cb001ad44ae7b9d89322ba6fa092',0,1,'2019-12-27 11:30:58.698816','2019-11-16 10:06:24.151969',0,0,4,38);
INSERT INTO "oneid_meta_groupperm" VALUES(315,'672f6bdcd5e64dcfb541b77126a72f4d',0,1,'2019-12-27 11:30:58.706822','2019-11-16 10:06:24.154565',0,0,5,38);
INSERT INTO "oneid_meta_groupperm" VALUES(316,'6c5be2dd0bbc4ceabbb4493eb5e808d3',0,1,'2019-12-27 11:30:58.714228','2019-11-16 10:06:24.157932',0,0,6,38);
INSERT INTO "oneid_meta_groupperm" VALUES(317,'946ba398e26445ee9f11c48afc214c2b',0,1,'2019-12-27 11:30:58.722063','2019-11-16 10:06:24.161890',0,0,7,38);
INSERT INTO "oneid_meta_groupperm" VALUES(318,'f122e86dec3c41d5b9f9b736216348ef',0,1,'2019-12-27 11:30:58.729583','2019-11-16 10:06:24.165767',0,0,8,38);
INSERT INTO "oneid_meta_groupperm" VALUES(319,'dedfea3be8da4fe4ac92e8633b2505fc',0,1,'2019-12-27 11:30:58.737470','2019-11-16 10:06:24.168713',0,0,9,38);
INSERT INTO "oneid_meta_groupperm" VALUES(320,'944baff3e9304e1f88b31efc51b01639',0,1,'2019-12-27 11:30:58.745004','2019-11-16 10:06:24.170905',0,0,10,38);
INSERT INTO "oneid_meta_groupperm" VALUES(321,'44aaa1c1fff440adbca7d2e65abf58e9',0,1,'2019-12-27 11:30:58.844923','2019-11-16 10:06:33.203440',0,0,1,39);
INSERT INTO "oneid_meta_groupperm" VALUES(322,'148fc099cd0e46d6932119f3562e2431',0,1,'2019-12-27 11:30:58.852635','2019-11-16 10:06:33.206466',0,0,2,39);
INSERT INTO "oneid_meta_groupperm" VALUES(323,'5c512207c1334e3b85a9deb69c6b01be',0,1,'2019-12-27 11:30:58.860649','2019-11-16 10:06:33.209831',0,0,3,39);
INSERT INTO "oneid_meta_groupperm" VALUES(324,'983288365d544362bcf10f3ac0ca8203',0,1,'2019-12-27 11:30:58.868184','2019-11-16 10:06:33.214235',0,0,4,39);
INSERT INTO "oneid_meta_groupperm" VALUES(325,'f000213c00a946c0af30c70e990fc9eb',0,1,'2019-12-27 11:30:58.877264','2019-11-16 10:06:33.217536',0,0,5,39);
INSERT INTO "oneid_meta_groupperm" VALUES(326,'f4a3f552e6ac45afb5050834b31c7910',0,1,'2019-12-27 11:30:58.885490','2019-11-16 10:06:33.220303',0,0,6,39);
INSERT INTO "oneid_meta_groupperm" VALUES(327,'81aff3d4b80a4ba39abb0ba35198ef29',0,1,'2019-12-27 11:30:58.893319','2019-11-16 10:06:33.223717',0,0,7,39);
INSERT INTO "oneid_meta_groupperm" VALUES(328,'3f7d1b4dbab54d56999575e9e7634d1b',0,1,'2019-12-27 11:30:58.901675','2019-11-16 10:06:33.226917',0,0,8,39);
INSERT INTO "oneid_meta_groupperm" VALUES(329,'87b2c7c49aa14fac99625ddf5cf25ea5',0,1,'2019-12-27 11:30:58.910024','2019-11-16 10:06:33.229528',0,0,9,39);
INSERT INTO "oneid_meta_groupperm" VALUES(330,'9c005257f24a4bf2b176ad76152238e1',0,1,'2019-12-27 11:30:58.918156','2019-11-16 10:06:33.232035',0,0,10,39);
INSERT INTO "oneid_meta_groupperm" VALUES(331,'1c1a6524bcbd42a8a783d6d435f77dab',0,1,'2019-12-27 11:30:59.180737','2019-11-16 10:06:46.144353',0,0,1,40);
INSERT INTO "oneid_meta_groupperm" VALUES(332,'fa72f71af10c4376b81bd1dc50e08af1',0,1,'2019-12-27 11:30:59.188399','2019-11-16 10:06:46.148030',0,0,2,40);
INSERT INTO "oneid_meta_groupperm" VALUES(333,'bb44a20d5a8641cb9c3cc9e2f048f1d4',0,1,'2019-12-27 11:30:59.196191','2019-11-16 10:06:46.151076',0,0,3,40);
INSERT INTO "oneid_meta_groupperm" VALUES(334,'c4bfcb4c7aa045608d3cf3f060196a18',0,1,'2019-12-27 11:30:59.204373','2019-11-16 10:06:46.154729',0,0,4,40);
INSERT INTO "oneid_meta_groupperm" VALUES(335,'fdd307a93d3e45bbb2f5d00ef8127c89',0,1,'2019-12-27 11:30:59.212250','2019-11-16 10:06:46.158965',0,0,5,40);
INSERT INTO "oneid_meta_groupperm" VALUES(336,'45db6054b55f470ba43d7e98cb219c71',0,1,'2019-12-27 11:30:59.219931','2019-11-16 10:06:46.163101',0,0,6,40);
INSERT INTO "oneid_meta_groupperm" VALUES(337,'d820ec96ebc5474ea9b0139fd21dcbca',0,1,'2019-12-27 11:30:59.227534','2019-11-16 10:06:46.166567',0,0,7,40);
INSERT INTO "oneid_meta_groupperm" VALUES(338,'0b5bbc4e564248f69d871f8e55b17f6b',0,1,'2019-12-27 11:30:59.235555','2019-11-16 10:06:46.169840',0,0,8,40);
INSERT INTO "oneid_meta_groupperm" VALUES(339,'877a4dfec1ac490a93e044c32d88f46e',0,1,'2019-12-27 11:30:59.243077','2019-11-16 10:06:46.172203',0,0,9,40);
INSERT INTO "oneid_meta_groupperm" VALUES(340,'e7f493eaceec43c8a3c7b5e5fcc6ad99',0,1,'2019-12-27 11:30:59.251067','2019-11-16 10:06:46.174471',0,0,10,40);
INSERT INTO "oneid_meta_groupperm" VALUES(341,'5435e3e4377546e7891fcf62dd5c71c3',0,1,'2019-12-27 11:30:59.509275','2019-11-16 10:06:57.853089',0,0,1,41);
INSERT INTO "oneid_meta_groupperm" VALUES(342,'2fa8154e505d42ca9a03a93585084434',0,1,'2019-12-27 11:30:59.516989','2019-11-16 10:06:57.856257',0,0,2,41);
INSERT INTO "oneid_meta_groupperm" VALUES(343,'22a46b12e94d40e8bdaeeb7e6ad49018',0,1,'2019-12-27 11:30:59.524695','2019-11-16 10:06:57.859159',0,0,3,41);
INSERT INTO "oneid_meta_groupperm" VALUES(344,'b32493d2c97c4320afc4888ccb0d113e',0,1,'2019-12-27 11:30:59.532049','2019-11-16 10:06:57.863053',0,0,4,41);
INSERT INTO "oneid_meta_groupperm" VALUES(345,'cc99eff1da5e4b579a13876ddd5fd207',0,1,'2019-12-27 11:30:59.540316','2019-11-16 10:06:57.866248',0,0,5,41);
INSERT INTO "oneid_meta_groupperm" VALUES(346,'66b8422f9e934a8faa0661fbd9472815',0,1,'2019-12-27 11:30:59.548421','2019-11-16 10:06:57.870410',0,0,6,41);
INSERT INTO "oneid_meta_groupperm" VALUES(347,'d55aa0f4d6df4129869ffb07eeebeeda',0,1,'2019-12-27 11:30:59.556394','2019-11-16 10:06:57.873683',0,0,7,41);
INSERT INTO "oneid_meta_groupperm" VALUES(348,'ee3b44b36c4c4d00b265c5b2dabd52f1',0,1,'2019-12-27 11:30:59.564510','2019-11-16 10:06:57.876106',0,0,8,41);
INSERT INTO "oneid_meta_groupperm" VALUES(349,'2844b765484f46d19677677c8951326d',0,1,'2019-12-27 11:30:59.572492','2019-11-16 10:06:57.878344',0,0,9,41);
INSERT INTO "oneid_meta_groupperm" VALUES(350,'17a293dd54fc4ef6880144088f3d91b0',0,1,'2019-12-27 11:30:59.580506','2019-11-16 10:06:57.881799',0,0,10,41);
INSERT INTO "oneid_meta_groupperm" VALUES(351,'414a4c2eb1bd435a9d8a5307473d812c',0,1,'2019-12-27 11:30:59.843634','2019-11-16 10:07:07.316145',0,0,1,42);
INSERT INTO "oneid_meta_groupperm" VALUES(352,'d3f290050738412da77da759db175843',0,1,'2019-12-27 11:30:59.851635','2019-11-16 10:07:07.320143',0,0,2,42);
INSERT INTO "oneid_meta_groupperm" VALUES(353,'7daf3bbe729a4cba89afbd603092e8a5',0,1,'2019-12-27 11:30:59.859583','2019-11-16 10:07:07.322896',0,0,3,42);
INSERT INTO "oneid_meta_groupperm" VALUES(354,'bb2eaf7410414704a25e32ed03ea94cc',0,1,'2019-12-27 11:30:59.867565','2019-11-16 10:07:07.325579',0,0,4,42);
INSERT INTO "oneid_meta_groupperm" VALUES(355,'5d05f569b07946caa169246131d85011',0,1,'2019-12-27 11:30:59.875747','2019-11-16 10:07:07.328671',0,0,5,42);
INSERT INTO "oneid_meta_groupperm" VALUES(356,'784f070341d0449981acdc445e152df7',0,1,'2019-12-27 11:30:59.883778','2019-11-16 10:07:07.332173',0,0,6,42);
INSERT INTO "oneid_meta_groupperm" VALUES(357,'49501ca4b69942e785a461752e908934',0,1,'2019-12-27 11:30:59.892205','2019-11-16 10:07:07.335045',0,0,7,42);
INSERT INTO "oneid_meta_groupperm" VALUES(358,'757306aeecea473b9e5d7359c6a41864',0,1,'2019-12-27 11:30:59.900167','2019-11-16 10:07:07.338900',0,0,8,42);
INSERT INTO "oneid_meta_groupperm" VALUES(359,'ca62fd717cd6457f9e41c05144242e4b',0,1,'2019-12-27 11:30:59.908051','2019-11-16 10:07:07.342843',0,0,9,42);
INSERT INTO "oneid_meta_groupperm" VALUES(360,'ef49c209f3bc4618a8ec740f67740276',0,1,'2019-12-27 11:30:59.916024','2019-11-16 10:07:07.346598',0,0,10,42);
INSERT INTO "oneid_meta_groupperm" VALUES(361,'607bea2ca5e7418b8ab37bfd24f8dd48',0,1,'2019-12-27 11:31:00.012368','2019-11-16 10:07:27.413669',0,0,1,43);
INSERT INTO "oneid_meta_groupperm" VALUES(362,'f5404ca7a8ad4c5c99f3efd3df585197',0,1,'2019-12-27 11:31:00.020417','2019-11-16 10:07:27.417781',0,0,2,43);
INSERT INTO "oneid_meta_groupperm" VALUES(363,'936f20d6fcfa42e68f58090e30af57a1',0,1,'2019-12-27 11:31:00.028249','2019-11-16 10:07:27.420780',0,0,3,43);
INSERT INTO "oneid_meta_groupperm" VALUES(364,'18f951d3bad14f82b130bee4a8e1963d',0,1,'2019-12-27 11:31:00.036123','2019-11-16 10:07:27.423455',0,0,4,43);
INSERT INTO "oneid_meta_groupperm" VALUES(365,'9c978dd1684f45c49bba7be0f9990b6e',0,1,'2019-12-27 11:31:00.043823','2019-11-16 10:07:27.426340',0,0,5,43);
INSERT INTO "oneid_meta_groupperm" VALUES(366,'4f4e9fdb0d724c2ca8801694d0e6e4dd',0,1,'2019-12-27 11:31:00.051749','2019-11-16 10:07:27.429181',0,0,6,43);
INSERT INTO "oneid_meta_groupperm" VALUES(367,'87a4552427a243f0850054566fb37988',0,1,'2019-12-27 11:31:00.059570','2019-11-16 10:07:27.433530',0,0,7,43);
INSERT INTO "oneid_meta_groupperm" VALUES(368,'4ac10fa366604e48aa344300789fa673',0,1,'2019-12-27 11:31:00.067511','2019-11-16 10:07:27.437381',0,0,8,43);
INSERT INTO "oneid_meta_groupperm" VALUES(369,'8327a84af5b2447ca80398d685617314',0,1,'2019-12-27 11:31:00.075435','2019-11-16 10:07:27.441019',0,0,9,43);
INSERT INTO "oneid_meta_groupperm" VALUES(370,'3da3d0e0e4414c7cb173ddde296b4bcd',0,1,'2019-12-27 11:31:00.082932','2019-11-16 10:07:27.444045',0,0,10,43);
INSERT INTO "oneid_meta_groupperm" VALUES(371,'5c45db0b01aa4bd187f018d3b05cfad7',0,1,'2019-12-27 11:30:50.416996','2019-11-16 10:07:27.476827',0,0,1,44);
INSERT INTO "oneid_meta_groupperm" VALUES(372,'31b01fb5a4574c44a4ae998051b6bc4f',0,1,'2019-12-27 11:30:50.424757','2019-11-16 10:07:27.480157',0,0,2,44);
INSERT INTO "oneid_meta_groupperm" VALUES(373,'8dc8fdfa2f804054819d4c04332c0d1c',0,1,'2019-12-27 11:30:50.432607','2019-11-16 10:07:27.482787',0,0,3,44);
INSERT INTO "oneid_meta_groupperm" VALUES(374,'11eb21e97534481aa912c5524caac6e1',0,1,'2019-12-27 11:30:50.440094','2019-11-16 10:07:27.485392',0,0,4,44);
INSERT INTO "oneid_meta_groupperm" VALUES(375,'4989d925c6754a4385ca2baabbf06d36',0,1,'2019-12-27 11:30:50.448268','2019-11-16 10:07:27.487769',0,0,5,44);
INSERT INTO "oneid_meta_groupperm" VALUES(376,'dd4ab201017642ba82e3a3d04d507527',0,1,'2019-12-27 11:30:50.455739','2019-11-16 10:07:27.490568',0,0,6,44);
INSERT INTO "oneid_meta_groupperm" VALUES(377,'ea920b32572a40029d51271d1dd2f6b9',0,1,'2019-12-27 11:30:50.463777','2019-11-16 10:07:27.494157',0,0,7,44);
INSERT INTO "oneid_meta_groupperm" VALUES(378,'8f7b914214924f75b4f8d90a5234f350',0,1,'2019-12-27 11:30:50.471311','2019-11-16 10:07:27.496691',0,0,8,44);
INSERT INTO "oneid_meta_groupperm" VALUES(379,'d90a11f9fcbb44fab9253dcacbce3696',0,1,'2019-12-27 11:30:50.479214','2019-11-16 10:07:27.499254',0,0,9,44);
INSERT INTO "oneid_meta_groupperm" VALUES(380,'51787f00686f47feaeee2b379532b4d2',0,1,'2019-12-27 11:30:50.486904','2019-11-16 10:07:27.501851',0,0,10,44);
INSERT INTO "oneid_meta_groupperm" VALUES(381,'7aa13075a9114959b332b695d657c862',0,1,'2019-12-27 11:31:00.694195','2019-11-16 10:07:38.587250',0,0,1,45);
INSERT INTO "oneid_meta_groupperm" VALUES(382,'cf7759923bfa4dd0aab4d88f797c2b0f',0,1,'2019-12-27 11:31:00.701804','2019-11-16 10:07:38.591155',0,0,2,45);
INSERT INTO "oneid_meta_groupperm" VALUES(383,'2fcf6259b83a4229a7d70a1e5cbd0856',0,1,'2019-12-27 11:31:00.709841','2019-11-16 10:07:38.594357',0,0,3,45);
INSERT INTO "oneid_meta_groupperm" VALUES(384,'cd49367cb1ac4d2590e2a0b1e022c978',0,1,'2019-12-27 11:31:00.717447','2019-11-16 10:07:38.596775',0,0,4,45);
INSERT INTO "oneid_meta_groupperm" VALUES(385,'6f32815a098f40bb8599f1dda46e6f1a',0,1,'2019-12-27 11:31:00.725300','2019-11-16 10:07:38.599135',0,0,5,45);
INSERT INTO "oneid_meta_groupperm" VALUES(386,'d9b718b3c8b34865a873bdcab9116690',0,1,'2019-12-27 11:31:00.732734','2019-11-16 10:07:38.602252',0,0,6,45);
INSERT INTO "oneid_meta_groupperm" VALUES(387,'eab510ebd04146f2979a93df935cb84c',0,1,'2019-12-27 11:31:00.740462','2019-11-16 10:07:38.606121',0,0,7,45);
INSERT INTO "oneid_meta_groupperm" VALUES(388,'2e6e9243c80943dfa37f459b1e561e95',0,1,'2019-12-27 11:31:00.747896','2019-11-16 10:07:38.609759',0,0,8,45);
INSERT INTO "oneid_meta_groupperm" VALUES(389,'cf77c509d923441b99e84d5919763579',0,1,'2019-12-27 11:31:00.755895','2019-11-16 10:07:38.613186',0,0,9,45);
INSERT INTO "oneid_meta_groupperm" VALUES(390,'a39f3ea583244d22a3f1b2b03867da30',0,1,'2019-12-27 11:31:00.763683','2019-11-16 10:07:38.615625',0,0,10,45);
INSERT INTO "oneid_meta_groupperm" VALUES(391,'14c246adc5d144f2bc5c02809b36eab6',0,1,'2019-12-27 11:30:50.589221','2019-11-16 10:07:38.646608',0,0,1,46);
INSERT INTO "oneid_meta_groupperm" VALUES(392,'d72f0a15345a414bbac486c68ad5925a',0,1,'2019-12-27 11:30:50.596828','2019-11-16 10:07:38.648858',0,0,2,46);
INSERT INTO "oneid_meta_groupperm" VALUES(393,'d8a7ed936c804d22a422dde90de1c3e3',0,1,'2019-12-27 11:30:50.604702','2019-11-16 10:07:38.652568',0,0,3,46);
INSERT INTO "oneid_meta_groupperm" VALUES(394,'641343843ab047b1b8b3040c751d13ac',0,1,'2019-12-27 11:30:50.612433','2019-11-16 10:07:38.655006',0,0,4,46);
INSERT INTO "oneid_meta_groupperm" VALUES(395,'6167d1074e0d4ac0b32f4c99bce37cfa',0,1,'2019-12-27 11:30:50.620292','2019-11-16 10:07:38.657285',0,0,5,46);
INSERT INTO "oneid_meta_groupperm" VALUES(396,'062040c563f34659bd9864bc4130ef96',0,1,'2019-12-27 11:30:50.628030','2019-11-16 10:07:38.659514',0,0,6,46);
INSERT INTO "oneid_meta_groupperm" VALUES(397,'a148dfd8949e450cb807470ff4f91b83',0,1,'2019-12-27 11:30:50.635864','2019-11-16 10:07:38.661841',0,0,7,46);
INSERT INTO "oneid_meta_groupperm" VALUES(398,'8660aa5c0cc242b28d760fc0f4e09fa1',0,1,'2019-12-27 11:30:50.643628','2019-11-16 10:07:38.664177',0,0,8,46);
INSERT INTO "oneid_meta_groupperm" VALUES(399,'8b13cabe62a64f0584fd4be3ddeae97d',0,1,'2019-12-27 11:30:50.651850','2019-11-16 10:07:38.667446',0,0,9,46);
INSERT INTO "oneid_meta_groupperm" VALUES(400,'b8ba844ab7db410e98347d55f6cd2ebf',0,1,'2019-12-27 11:30:50.659292','2019-11-16 10:07:38.670453',0,0,10,46);
INSERT INTO "oneid_meta_groupperm" VALUES(401,'147e980c84e94943ae4a701a518c7b3d',0,1,'2019-12-27 11:31:00.193842','2019-11-16 10:09:20.464112',0,0,1,47);
INSERT INTO "oneid_meta_groupperm" VALUES(402,'3dd6124fc3ca402d9359d2c50059d809',0,1,'2019-12-27 11:31:00.202125','2019-11-16 10:09:20.468709',0,0,2,47);
INSERT INTO "oneid_meta_groupperm" VALUES(403,'2e0fe69688b845cea04d269cd12fe743',0,1,'2019-12-27 11:31:00.215986','2019-11-16 10:09:20.471406',0,0,3,47);
INSERT INTO "oneid_meta_groupperm" VALUES(404,'7ca6396bfeda4abb9746ff59e4446233',0,1,'2019-12-27 11:31:00.223785','2019-11-16 10:09:20.474281',0,0,4,47);
INSERT INTO "oneid_meta_groupperm" VALUES(405,'f9e49f116a3c43a9ad64ca33a685ea9e',0,1,'2019-12-27 11:31:00.231552','2019-11-16 10:09:20.477370',0,0,5,47);
INSERT INTO "oneid_meta_groupperm" VALUES(406,'493cc102dec74424880fc78379927c9a',0,1,'2019-12-27 11:31:00.239415','2019-11-16 10:09:20.481462',0,0,6,47);
INSERT INTO "oneid_meta_groupperm" VALUES(407,'f7648c08e7384b6dba374fb212335537',0,1,'2019-12-27 11:31:00.247452','2019-11-16 10:09:20.484468',0,0,7,47);
INSERT INTO "oneid_meta_groupperm" VALUES(408,'9dfcd71ae65c4a92a5343c13d2c09674',0,1,'2019-12-27 11:31:00.255030','2019-11-16 10:09:20.487793',0,0,8,47);
INSERT INTO "oneid_meta_groupperm" VALUES(409,'2a3933be1f4046d78e5f10e1af77a03f',0,1,'2019-12-27 11:31:00.262991','2019-11-16 10:09:20.491286',0,0,9,47);
INSERT INTO "oneid_meta_groupperm" VALUES(410,'06d87e6fcd27435db5ba9e50edd298e0',0,1,'2019-12-27 11:31:00.270618','2019-11-16 10:09:20.494217',0,0,10,47);
INSERT INTO "oneid_meta_groupperm" VALUES(411,'63e4ee7331bb4b3a9f026534e31d4244',0,1,'2019-12-27 11:31:00.365945','2019-11-16 10:09:43.443792',0,0,1,48);
INSERT INTO "oneid_meta_groupperm" VALUES(412,'83d42eae4a2e4d67a762e1583d99e04e',0,1,'2019-12-27 11:31:00.373887','2019-11-16 10:09:43.447774',0,0,2,48);
INSERT INTO "oneid_meta_groupperm" VALUES(413,'813db1a0437f4b9b831bc4bfbc62e7b3',0,1,'2019-12-27 11:31:00.382024','2019-11-16 10:09:43.450215',0,0,3,48);
INSERT INTO "oneid_meta_groupperm" VALUES(414,'52dd96803e0443a3a1c68a2b712a11df',0,1,'2019-12-27 11:31:00.389973','2019-11-16 10:09:43.452774',0,0,4,48);
INSERT INTO "oneid_meta_groupperm" VALUES(415,'58a529c5ceb64dd88f0815d9adc80d17',0,1,'2019-12-27 11:31:00.397784','2019-11-16 10:09:43.455050',0,0,5,48);
INSERT INTO "oneid_meta_groupperm" VALUES(416,'8084880012c547768a6ea457ccbab0bd',0,1,'2019-12-27 11:31:00.405605','2019-11-16 10:09:43.458246',0,0,6,48);
INSERT INTO "oneid_meta_groupperm" VALUES(417,'1afe7f507d8c404591c52841d9c88c68',0,1,'2019-12-27 11:31:00.413399','2019-11-16 10:09:43.462072',0,0,7,48);
INSERT INTO "oneid_meta_groupperm" VALUES(418,'baf553cb28524543be5d838c23dfa64f',0,1,'2019-12-27 11:31:00.421266','2019-11-16 10:09:43.465897',0,0,8,48);
INSERT INTO "oneid_meta_groupperm" VALUES(419,'40cafa71e28b4bddb1a09c8210f314ff',0,1,'2019-12-27 11:31:00.428757','2019-11-16 10:09:43.468357',0,0,9,48);
INSERT INTO "oneid_meta_groupperm" VALUES(420,'1bdb5d8ce93e41c09022ae226018447b',0,1,'2019-12-27 11:31:00.436876','2019-11-16 10:09:43.470622',0,0,10,48);
INSERT INTO "oneid_meta_groupperm" VALUES(421,'c6651194a51546ed8ae04e1825c8bff8',0,1,'2019-12-27 11:31:00.530504','2019-11-16 10:09:48.271367',0,0,1,49);
INSERT INTO "oneid_meta_groupperm" VALUES(422,'70a76dc5d697412584a4e942ceb0cce6',0,1,'2019-12-27 11:31:00.538154','2019-11-16 10:09:48.274621',0,0,2,49);
INSERT INTO "oneid_meta_groupperm" VALUES(423,'38bcd8a3af124d7ca7b5aa1fde1d303d',0,1,'2019-12-27 11:31:00.545963','2019-11-16 10:09:48.277357',0,0,3,49);
INSERT INTO "oneid_meta_groupperm" VALUES(424,'08c4f2d4a94f4fc3b3c83f82f965b15d',0,1,'2019-12-27 11:31:00.553578','2019-11-16 10:09:48.280375',0,0,4,49);
INSERT INTO "oneid_meta_groupperm" VALUES(425,'f10cc984fe0a4d5e9897e65ae82d0956',0,1,'2019-12-27 11:31:00.561423','2019-11-16 10:09:48.283482',0,0,5,49);
INSERT INTO "oneid_meta_groupperm" VALUES(426,'de7e227c9ee746528002f3f239588629',0,1,'2019-12-27 11:31:00.568886','2019-11-16 10:09:48.287827',0,0,6,49);
INSERT INTO "oneid_meta_groupperm" VALUES(427,'3737c9ee9d8f4da894e7359469a15de4',0,1,'2019-12-27 11:31:00.576684','2019-11-16 10:09:48.291193',0,0,7,49);
INSERT INTO "oneid_meta_groupperm" VALUES(428,'5ec22da7efa4498cba7ac67b3839741e',0,1,'2019-12-27 11:31:00.584351','2019-11-16 10:09:48.293907',0,0,8,49);
INSERT INTO "oneid_meta_groupperm" VALUES(429,'13e1cae8e28f4d6db09e5952d709abba',0,1,'2019-12-27 11:31:00.592156','2019-11-16 10:09:48.296753',0,0,9,49);
INSERT INTO "oneid_meta_groupperm" VALUES(430,'5bec02271ed644478cb51fa52be5889a',0,1,'2019-12-27 11:31:00.599812','2019-11-16 10:09:48.299647',0,0,10,49);
INSERT INTO "oneid_meta_groupperm" VALUES(431,'8caeb1cab0b947db973cb1b222aa5793',0,1,'2019-12-27 11:31:00.860250','2019-11-16 10:10:32.522989',0,0,1,50);
INSERT INTO "oneid_meta_groupperm" VALUES(432,'f6352373caca43688e81b4056deb4b09',0,1,'2019-12-27 11:31:00.867919','2019-11-16 10:10:32.526164',0,0,2,50);
INSERT INTO "oneid_meta_groupperm" VALUES(433,'276101b1f3c8416f92eb29227014e52f',0,1,'2019-12-27 11:31:00.876490','2019-11-16 10:10:32.528961',0,0,3,50);
INSERT INTO "oneid_meta_groupperm" VALUES(434,'b44222830c114b78a0b749c4fbcbb479',0,1,'2019-12-27 11:31:00.885492','2019-11-16 10:10:32.531854',0,0,4,50);
INSERT INTO "oneid_meta_groupperm" VALUES(435,'b36b3939fd2644f19d5ca08a95d0fa6c',0,1,'2019-12-27 11:31:00.893373','2019-11-16 10:10:32.536023',0,0,5,50);
INSERT INTO "oneid_meta_groupperm" VALUES(436,'5ed3a9524ffe4a81abca8e1bf25e1810',0,1,'2019-12-27 11:31:00.901178','2019-11-16 10:10:32.539896',0,0,6,50);
INSERT INTO "oneid_meta_groupperm" VALUES(437,'45e258583ca04be4a4f8bb2e72b6a745',0,1,'2019-12-27 11:31:00.909004','2019-11-16 10:10:32.542787',0,0,7,50);
INSERT INTO "oneid_meta_groupperm" VALUES(438,'4dd126c0bc884463902b01d0d8d44180',0,1,'2019-12-27 11:31:00.916856','2019-11-16 10:10:32.545953',0,0,8,50);
INSERT INTO "oneid_meta_groupperm" VALUES(439,'20f603a0141d4265ad2bb17bf30d4ed6',0,1,'2019-12-27 11:31:00.924614','2019-11-16 10:10:32.549252',0,0,9,50);
INSERT INTO "oneid_meta_groupperm" VALUES(440,'9a326e1073e34fadba5c4b4105879aff',0,1,'2019-12-27 11:31:00.932426','2019-11-16 10:10:32.552036',0,0,10,50);
INSERT INTO "oneid_meta_groupperm" VALUES(441,'d26f54ec314b4beeb62ffcb190abf7f0',0,1,'2019-12-27 11:31:01.026840','2019-11-16 10:10:42.779951',0,0,1,51);
INSERT INTO "oneid_meta_groupperm" VALUES(442,'0d08feb5bb8940f79d89a5ba1baab287',0,1,'2019-12-27 11:31:01.034855','2019-11-16 10:10:42.782454',0,0,2,51);
INSERT INTO "oneid_meta_groupperm" VALUES(443,'a784e0c021fb4beda8a3183759586548',0,1,'2019-12-27 11:31:01.042728','2019-11-16 10:10:42.786611',0,0,3,51);
INSERT INTO "oneid_meta_groupperm" VALUES(444,'818c3cbb0d024f119a953ef130eb57f6',0,1,'2019-12-27 11:31:01.050233','2019-11-16 10:10:42.790432',0,0,4,51);
INSERT INTO "oneid_meta_groupperm" VALUES(445,'d65e2d62d3e44f12b6634488bf650675',0,1,'2019-12-27 11:31:01.058013','2019-11-16 10:10:42.793777',0,0,5,51);
INSERT INTO "oneid_meta_groupperm" VALUES(446,'479409c194f041858cf836f093008a66',0,1,'2019-12-27 11:31:01.065600','2019-11-16 10:10:42.797514',0,0,6,51);
INSERT INTO "oneid_meta_groupperm" VALUES(447,'caadf485c3b943c8943f85923684790d',0,1,'2019-12-27 11:31:01.073553','2019-11-16 10:10:42.800572',0,0,7,51);
INSERT INTO "oneid_meta_groupperm" VALUES(448,'4b973a64270f4c81be6ec964e2beaa9b',0,1,'2019-12-27 11:31:01.081119','2019-11-16 10:10:42.803447',0,0,8,51);
INSERT INTO "oneid_meta_groupperm" VALUES(449,'99724640f7544a87a7452060b4266280',0,1,'2019-12-27 11:31:01.089055','2019-11-16 10:10:42.805687',0,0,9,51);
INSERT INTO "oneid_meta_groupperm" VALUES(450,'ea0923e0153c4eff9734969708c9c746',0,1,'2019-12-27 11:31:01.096609','2019-11-16 10:10:42.809548',0,0,10,51);
INSERT INTO "oneid_meta_groupperm" VALUES(451,'eb2b4e25b3dd4754ac3f24638aeea71f',0,1,'2019-12-27 11:31:01.190418','2019-11-16 10:10:50.932307',0,0,1,52);
INSERT INTO "oneid_meta_groupperm" VALUES(452,'6ef879774bbb44fd890b3e0e71d3e111',0,1,'2019-12-27 11:31:01.198003','2019-11-16 10:10:50.935310',0,0,2,52);
INSERT INTO "oneid_meta_groupperm" VALUES(453,'e3acf327af094e1081315ac23d2c33e7',0,1,'2019-12-27 11:31:01.205860','2019-11-16 10:10:50.937568',0,0,3,52);
INSERT INTO "oneid_meta_groupperm" VALUES(454,'8db3112206e94c76a898c6aef07345d6',0,1,'2019-12-27 11:31:01.213357','2019-11-16 10:10:50.940648',0,0,4,52);
INSERT INTO "oneid_meta_groupperm" VALUES(455,'3120b3bdc8434a7ca11f21a4f4e7acdb',0,1,'2019-12-27 11:31:01.221229','2019-11-16 10:10:50.943541',0,0,5,52);
INSERT INTO "oneid_meta_groupperm" VALUES(456,'820d3ccda7974cd2a9df1cacec116507',0,1,'2019-12-27 11:31:01.228712','2019-11-16 10:10:50.947165',0,0,6,52);
INSERT INTO "oneid_meta_groupperm" VALUES(457,'6fe50cab9b2e4d3f91c52fce57066cc2',0,1,'2019-12-27 11:31:01.236559','2019-11-16 10:10:50.950571',0,0,7,52);
INSERT INTO "oneid_meta_groupperm" VALUES(458,'e10c3bc8c4934ec68d6edbf6c3201dff',0,1,'2019-12-27 11:31:01.244151','2019-11-16 10:10:50.953418',0,0,8,52);
INSERT INTO "oneid_meta_groupperm" VALUES(459,'9ced004f1b3b4dd6bd2be8c4f23a6752',0,1,'2019-12-27 11:31:01.252022','2019-11-16 10:10:50.956741',0,0,9,52);
INSERT INTO "oneid_meta_groupperm" VALUES(460,'f5e0b6dcb4f44deebabb1b0f94582644',0,1,'2019-12-27 11:31:01.259614','2019-11-16 10:10:50.959678',0,0,10,52);
INSERT INTO "oneid_meta_groupperm" VALUES(461,'b6641238c038491e92e90c752fd2395e',0,1,'2019-12-27 11:30:50.753424','2019-11-16 10:11:16.133332',0,0,1,53);
INSERT INTO "oneid_meta_groupperm" VALUES(462,'581ad2c01f1b48e089f2b081dccd42d8',0,1,'2019-12-27 11:30:50.761416','2019-11-16 10:11:16.135193',0,0,2,53);
INSERT INTO "oneid_meta_groupperm" VALUES(463,'014a8d7842da4bf09972571c44737a2c',0,1,'2019-12-27 11:30:50.769158','2019-11-16 10:11:16.136640',0,0,3,53);
INSERT INTO "oneid_meta_groupperm" VALUES(464,'6db38eb99f404ae4823d3286649a55db',0,1,'2019-12-27 11:30:50.777234','2019-11-16 10:11:16.138277',0,0,4,53);
INSERT INTO "oneid_meta_groupperm" VALUES(465,'435980783f27460187ba84c05f6c0a15',0,1,'2019-12-27 11:30:50.785425','2019-11-16 10:11:16.140284',0,0,5,53);
INSERT INTO "oneid_meta_groupperm" VALUES(466,'5ec8209ce95f4794ad1fbeea0bcd417f',0,1,'2019-12-27 11:30:50.794022','2019-11-16 10:11:16.142421',0,0,6,53);
INSERT INTO "oneid_meta_groupperm" VALUES(467,'014403e5c04947ad808613abc50f83a3',0,1,'2019-12-27 11:30:50.801836','2019-11-16 10:11:16.145063',0,0,7,53);
INSERT INTO "oneid_meta_groupperm" VALUES(468,'2ff7c1ade1cd469696ccf8d0e6d51b0a',0,1,'2019-12-27 11:30:50.809238','2019-11-16 10:11:16.147772',0,0,8,53);
INSERT INTO "oneid_meta_groupperm" VALUES(469,'87f8b9e4f6ec4a67afd10151bcaba353',0,1,'2019-12-27 11:30:50.817539','2019-11-16 10:11:16.149563',0,0,9,53);
INSERT INTO "oneid_meta_groupperm" VALUES(470,'a541a50723d54598b90974c7d2b37d3e',0,1,'2019-12-27 11:30:50.825101','2019-11-16 10:11:16.151779',0,0,10,53);
INSERT INTO "oneid_meta_groupperm" VALUES(471,'040a4593d44542699caae8c531053a4b',0,1,'2019-12-27 11:30:50.832960','2019-11-16 10:11:16.153672',0,0,11,53);
INSERT INTO "oneid_meta_groupperm" VALUES(472,'5a4788293e534b56afba30184f22447d',0,1,'2019-12-27 11:30:50.927962','2019-11-16 10:11:32.641654',0,0,1,54);
INSERT INTO "oneid_meta_groupperm" VALUES(473,'76fc0191332a4b5eaf8ad9b36b63f7c0',0,1,'2019-12-27 11:30:50.936344','2019-11-16 10:11:32.643512',0,0,2,54);
INSERT INTO "oneid_meta_groupperm" VALUES(474,'2877bed56afd407aa2ef897dd0526e64',0,1,'2019-12-27 11:30:50.944233','2019-11-16 10:11:32.645198',0,0,3,54);
INSERT INTO "oneid_meta_groupperm" VALUES(475,'6b6a3b533a16460e87422601d2ab2cee',0,1,'2019-12-27 11:30:50.952948','2019-11-16 10:11:32.646707',0,0,4,54);
INSERT INTO "oneid_meta_groupperm" VALUES(476,'1f4a2e2b2ff7472fbffa914b230d064d',0,1,'2019-12-27 11:30:50.960455','2019-11-16 10:11:32.648418',0,0,5,54);
INSERT INTO "oneid_meta_groupperm" VALUES(477,'0f386049c9a94cc08a39ce68c382af0a',0,1,'2019-12-27 11:30:50.968755','2019-11-16 10:11:32.650420',0,0,6,54);
INSERT INTO "oneid_meta_groupperm" VALUES(478,'2da61ea6fb3d491398cfea8a15aa33d8',0,1,'2019-12-27 11:30:50.976550','2019-11-16 10:11:32.651900',0,0,7,54);
INSERT INTO "oneid_meta_groupperm" VALUES(479,'fc6e89800fee4de7bc8b7f3ab2e02db7',0,1,'2019-12-27 11:30:50.984936','2019-11-16 10:11:32.653645',0,0,8,54);
INSERT INTO "oneid_meta_groupperm" VALUES(480,'45eb28607bf84c2fbf068e1967a5e45c',0,1,'2019-12-27 11:30:50.993097','2019-11-16 10:11:32.656389',0,0,9,54);
INSERT INTO "oneid_meta_groupperm" VALUES(481,'e6257887f14947c294ef358e307d03b8',0,1,'2019-12-27 11:30:51.001643','2019-11-16 10:11:32.658060',0,0,10,54);
INSERT INTO "oneid_meta_groupperm" VALUES(482,'00bca992effc43b18282721d1a53f499',0,1,'2019-12-27 11:30:51.009720','2019-11-16 10:11:32.659884',0,0,11,54);
INSERT INTO "oneid_meta_groupperm" VALUES(483,'37776f0bb24f493fb34ce4193cd2d8ea',0,1,'2019-12-27 11:30:51.018983','2019-11-16 10:11:32.661506',0,0,12,54);
INSERT INTO "oneid_meta_groupperm" VALUES(484,'e82a264ef13d46058fb3a94e62236bcb',0,1,'2019-12-27 11:30:51.101146','2019-11-16 10:11:37.999659',0,0,1,55);
INSERT INTO "oneid_meta_groupperm" VALUES(485,'6d03628034aa4e0fa0727fa2139088d5',0,1,'2019-12-27 11:30:51.108888','2019-11-16 10:11:38.001228',0,0,2,55);
INSERT INTO "oneid_meta_groupperm" VALUES(486,'16d588b0e2d44a77ba562a0f59b858d8',0,1,'2019-12-27 11:30:51.117039','2019-11-16 10:11:38.002648',0,0,3,55);
INSERT INTO "oneid_meta_groupperm" VALUES(487,'41426f8fe6ab4017900424ac91aa2359',0,1,'2019-12-27 11:30:51.125023','2019-11-16 10:11:38.004563',0,0,4,55);
INSERT INTO "oneid_meta_groupperm" VALUES(488,'7fd5896973ef4629b92d208df99367b5',0,1,'2019-12-27 11:30:51.132461','2019-11-16 10:11:38.006570',0,0,5,55);
INSERT INTO "oneid_meta_groupperm" VALUES(489,'6d27d310a4434f508513605da1b6eae2',0,1,'2019-12-27 11:30:51.140514','2019-11-16 10:11:38.009194',0,0,6,55);
INSERT INTO "oneid_meta_groupperm" VALUES(490,'afa964ea49464dad83945d886632e4a4',0,1,'2019-12-27 11:30:51.148336','2019-11-16 10:11:38.010895',0,0,7,55);
INSERT INTO "oneid_meta_groupperm" VALUES(491,'0f78b368cd9f4f68bcb9d5a2e0bd6999',0,1,'2019-12-27 11:30:51.156250','2019-11-16 10:11:38.012340',0,0,8,55);
INSERT INTO "oneid_meta_groupperm" VALUES(492,'15ca17fa8888439d8bf1c3e81588eaf9',0,1,'2019-12-27 11:30:51.164161','2019-11-16 10:11:38.013727',0,0,9,55);
INSERT INTO "oneid_meta_groupperm" VALUES(493,'9a20ff210f1c4fc7b419cdac05c6daca',0,1,'2019-12-27 11:30:51.172539','2019-11-16 10:11:38.015438',0,0,10,55);
INSERT INTO "oneid_meta_groupperm" VALUES(494,'fa17195e65c145be80f24ca969e10a2d',0,1,'2019-12-27 11:30:51.180813','2019-11-16 10:11:38.016987',0,0,11,55);
INSERT INTO "oneid_meta_groupperm" VALUES(495,'ddf8082c640d4bc79763eae4816bfeec',0,1,'2019-12-27 11:30:51.189250','2019-11-16 10:11:38.018388',0,0,12,55);
INSERT INTO "oneid_meta_groupperm" VALUES(496,'046d77d63202462cbdb76d2a6eb5c514',0,1,'2019-12-27 11:30:51.197565','2019-11-16 10:11:38.019761',0,0,13,55);
INSERT INTO "oneid_meta_groupperm" VALUES(497,'d9f1a73d2b4949cda25195d21d3ef6d7',0,1,'2019-12-27 11:30:51.273172','2019-11-16 10:11:43.666606',0,0,1,56);
INSERT INTO "oneid_meta_groupperm" VALUES(498,'b341fc9a901d41bd9ea83dc86e350364',0,1,'2019-12-27 11:30:51.280720','2019-11-16 10:11:43.668349',0,0,2,56);
INSERT INTO "oneid_meta_groupperm" VALUES(499,'94e8cac8fbad453191eed5a54bcc4493',0,1,'2019-12-27 11:30:51.288945','2019-11-16 10:11:43.669731',0,0,3,56);
INSERT INTO "oneid_meta_groupperm" VALUES(500,'3b2d0b79f8ae47b9978d6d51adb192dc',0,1,'2019-12-27 11:30:51.296902','2019-11-16 10:11:43.671144',0,0,4,56);
INSERT INTO "oneid_meta_groupperm" VALUES(501,'092080543409482aa9d78ee3098b5ed5',0,1,'2019-12-27 11:30:51.304771','2019-11-16 10:11:43.672553',0,0,5,56);
INSERT INTO "oneid_meta_groupperm" VALUES(502,'d2d683abcac4466a824985483ae1b4e1',0,1,'2019-12-27 11:30:51.312487','2019-11-16 10:11:43.674405',0,0,6,56);
INSERT INTO "oneid_meta_groupperm" VALUES(503,'6bdc6818e4ef4d10826a4703441e95e7',0,1,'2019-12-27 11:30:51.322015','2019-11-16 10:11:43.675996',0,0,7,56);
INSERT INTO "oneid_meta_groupperm" VALUES(504,'07816fa956f84b3ea3e85e2fba7714ff',0,1,'2019-12-27 11:30:51.329531','2019-11-16 10:11:43.677411',0,0,8,56);
INSERT INTO "oneid_meta_groupperm" VALUES(505,'cb117a84bdd44948a00202365278b76b',0,1,'2019-12-27 11:30:51.338236','2019-11-16 10:11:43.679568',0,0,9,56);
INSERT INTO "oneid_meta_groupperm" VALUES(506,'071ff814f3a7476c8589869324a5e7de',0,1,'2019-12-27 11:30:51.345764','2019-11-16 10:11:43.682067',0,0,10,56);
INSERT INTO "oneid_meta_groupperm" VALUES(507,'6ee2e33e94314b93b9ab81b3906ced74',0,1,'2019-12-27 11:30:51.353609','2019-11-16 10:11:43.683732',0,0,11,56);
INSERT INTO "oneid_meta_groupperm" VALUES(508,'d70a628f9d974c72bd29608f9378d91f',0,1,'2019-12-27 11:30:51.361527','2019-11-16 10:11:43.685461',0,0,12,56);
INSERT INTO "oneid_meta_groupperm" VALUES(509,'bfeafe08386c470e8c2efd9848e82117',0,1,'2019-12-27 11:30:51.369375','2019-11-16 10:11:43.687069',0,0,13,56);
INSERT INTO "oneid_meta_groupperm" VALUES(510,'52c838a29ccc46b2912688119982939e',0,1,'2019-12-27 11:30:51.377040','2019-11-16 10:11:43.688471',0,0,14,56);
INSERT INTO "oneid_meta_groupperm" VALUES(511,'1d86a13fb37645e9a306d42cf5da5ccd',0,1,'2019-12-27 11:30:51.442371','2019-11-16 10:11:51.630612',0,0,1,57);
INSERT INTO "oneid_meta_groupperm" VALUES(512,'420cedc386774e3fb032989b37de77d2',0,1,'2019-12-27 11:30:51.450092','2019-11-16 10:11:51.632284',0,0,2,57);
INSERT INTO "oneid_meta_groupperm" VALUES(513,'e60d3f689d62443e884431ad76366565',0,1,'2019-12-27 11:30:51.457922','2019-11-16 10:11:51.633734',0,0,3,57);
INSERT INTO "oneid_meta_groupperm" VALUES(514,'2853f7aac49e43f18cfb075aa3447322',0,1,'2019-12-27 11:30:51.465714','2019-11-16 10:11:51.635375',0,0,4,57);
INSERT INTO "oneid_meta_groupperm" VALUES(515,'121cbc348fb7474dba68b7db1764697c',0,1,'2019-12-27 11:30:51.474815','2019-11-16 10:11:51.637532',0,0,5,57);
INSERT INTO "oneid_meta_groupperm" VALUES(516,'408418f62de0453581f160b797b5f832',0,1,'2019-12-27 11:30:51.483042','2019-11-16 10:11:51.640041',0,0,6,57);
INSERT INTO "oneid_meta_groupperm" VALUES(517,'6c7bea42b0384170bda417286270b958',0,1,'2019-12-27 11:30:51.492032','2019-11-16 10:11:51.641645',0,0,7,57);
INSERT INTO "oneid_meta_groupperm" VALUES(518,'b42f662577bb4b71aeee40576914d2fb',0,1,'2019-12-27 11:30:51.500052','2019-11-16 10:11:51.643077',0,0,8,57);
INSERT INTO "oneid_meta_groupperm" VALUES(519,'b1ba1331eea1414093881570f5d1052a',0,1,'2019-12-27 11:30:51.507743','2019-11-16 10:11:51.644515',0,0,9,57);
INSERT INTO "oneid_meta_groupperm" VALUES(520,'51d4e9228768452f857b9f8e16f63326',0,1,'2019-12-27 11:30:51.516228','2019-11-16 10:11:51.645929',0,0,10,57);
INSERT INTO "oneid_meta_groupperm" VALUES(521,'c5d7de2036c2473895057c427872fbec',0,1,'2019-12-27 11:30:51.525055','2019-11-16 10:11:51.647343',0,0,11,57);
INSERT INTO "oneid_meta_groupperm" VALUES(522,'57c9d48994ac4e07b198cd78bd56eab6',0,1,'2019-12-27 11:30:51.533812','2019-11-16 10:11:51.648803',0,0,12,57);
INSERT INTO "oneid_meta_groupperm" VALUES(523,'36d4d45f7c2943bea7dc351aea0e2d8a',0,1,'2019-12-27 11:30:51.542570','2019-11-16 10:11:51.650517',0,0,13,57);
INSERT INTO "oneid_meta_groupperm" VALUES(524,'b94980cd5f144dd1b9dca4c9d630958f',0,1,'2019-12-27 11:30:51.550568','2019-11-16 10:11:51.652510',0,0,14,57);
INSERT INTO "oneid_meta_groupperm" VALUES(525,'e6867da72d984b09adce6a24ddb19fdb',0,1,'2019-12-27 11:30:51.558915','2019-11-16 10:11:51.654796',0,0,15,57);
INSERT INTO "oneid_meta_groupperm" VALUES(526,'c4783809cf0044f8ba6eaad10daea818',0,1,'2019-12-27 11:31:01.353405','2019-11-16 10:24:30.392616',0,0,1,58);
INSERT INTO "oneid_meta_groupperm" VALUES(527,'8c2aa334befb4e8f992db40b2f704fba',0,1,'2019-12-27 11:31:01.361155','2019-11-16 10:24:30.395252',0,0,2,58);
INSERT INTO "oneid_meta_groupperm" VALUES(528,'83869e7d835a4c70b5012225c69243af',0,1,'2019-12-27 11:31:01.368713','2019-11-16 10:24:30.397623',0,0,3,58);
INSERT INTO "oneid_meta_groupperm" VALUES(529,'2977c4839a9e43b5a740e3ac09aac005',0,1,'2019-12-27 11:31:01.376662','2019-11-16 10:24:30.400320',0,0,4,58);
INSERT INTO "oneid_meta_groupperm" VALUES(530,'5062be9278fb477481c9be9e58d15918',0,1,'2019-12-27 11:31:01.384288','2019-11-16 10:24:30.404018',0,0,5,58);
INSERT INTO "oneid_meta_groupperm" VALUES(531,'ec1b5f45c3494fbaa0e7b5a784a45c0c',0,1,'2019-12-27 11:31:01.391994','2019-11-16 10:24:30.406375',0,0,6,58);
INSERT INTO "oneid_meta_groupperm" VALUES(532,'4b806cba60b2468f885c288f7dcd2a39',0,1,'2019-12-27 11:31:01.399790','2019-11-16 10:24:30.408712',0,0,7,58);
INSERT INTO "oneid_meta_groupperm" VALUES(533,'476777ced4e74907aebad5e826a546fb',0,1,'2019-12-27 11:31:01.407294','2019-11-16 10:24:30.411108',0,0,8,58);
INSERT INTO "oneid_meta_groupperm" VALUES(534,'4f4263b9633e434c881263438ec54596',0,1,'2019-12-27 11:31:01.415150','2019-11-16 10:24:30.413518',0,0,9,58);
INSERT INTO "oneid_meta_groupperm" VALUES(535,'409fb434e08541b3a3d0633196de6f68',0,1,'2019-12-27 11:31:01.422519','2019-11-16 10:24:30.415905',0,0,10,58);
INSERT INTO "oneid_meta_groupperm" VALUES(536,'ed7625081001445591c749dc1542f50a',0,1,'2019-12-27 11:31:01.430221','2019-11-16 10:24:30.419436',0,0,11,58);
INSERT INTO "oneid_meta_groupperm" VALUES(537,'57d0ccb196b34adeb065ee4f3a92af6e',0,1,'2019-12-27 11:31:01.437823','2019-11-16 10:24:30.422542',0,0,12,58);
INSERT INTO "oneid_meta_groupperm" VALUES(538,'64bea414a14f4618abe3acdf8763d5f6',0,1,'2019-12-27 11:31:01.445613','2019-11-16 10:24:30.425002',0,0,13,58);
INSERT INTO "oneid_meta_groupperm" VALUES(539,'ebb5aa5681304607b5a52286b163cc09',0,1,'2019-12-27 11:31:01.452961','2019-11-16 10:24:30.427404',0,0,14,58);
INSERT INTO "oneid_meta_groupperm" VALUES(540,'b2fd60a28c6c45d8ac195bd3cd0c3a74',0,1,'2019-12-27 11:31:01.460878','2019-11-16 10:24:30.429664',0,0,15,58);
INSERT INTO "oneid_meta_groupperm" VALUES(541,'173161e50b3a42b19ca13e28fa433276',0,1,'2019-12-27 11:30:51.614795','2019-11-16 10:24:30.457731',0,0,1,59);
INSERT INTO "oneid_meta_groupperm" VALUES(542,'fc00dd1d73d345709a640d7bd9051754',0,1,'2019-12-27 11:30:51.622516','2019-11-16 10:24:30.459992',0,0,2,59);
INSERT INTO "oneid_meta_groupperm" VALUES(543,'ed6038aa543945868ba82c2722f28442',0,1,'2019-12-27 11:30:51.630304','2019-11-16 10:24:30.462226',0,0,3,59);
INSERT INTO "oneid_meta_groupperm" VALUES(544,'c7da581e973348c58b571afa0accd17a',0,1,'2019-12-27 11:30:51.637865','2019-11-16 10:24:30.464755',0,0,4,59);
INSERT INTO "oneid_meta_groupperm" VALUES(545,'e0f5abfb1ad84378a9c138f26c0dd335',0,1,'2019-12-27 11:30:51.645632','2019-11-16 10:24:30.467539',0,0,5,59);
INSERT INTO "oneid_meta_groupperm" VALUES(546,'beece03d874349ecbc34868c04e11a06',0,1,'2019-12-27 11:30:51.653868','2019-11-16 10:24:30.471195',0,0,6,59);
INSERT INTO "oneid_meta_groupperm" VALUES(547,'779bbeaaaa914cc9a4f827a0210f9edb',0,1,'2019-12-27 11:30:51.661525','2019-11-16 10:24:30.473648',0,0,7,59);
INSERT INTO "oneid_meta_groupperm" VALUES(548,'522269c9fdae4f3892b75bc712849c43',0,1,'2019-12-27 11:30:51.669215','2019-11-16 10:24:30.476003',0,0,8,59);
INSERT INTO "oneid_meta_groupperm" VALUES(549,'6d76af054e134cd6be101fbc24a64d5d',0,1,'2019-12-27 11:30:51.676741','2019-11-16 10:24:30.478309',0,0,9,59);
INSERT INTO "oneid_meta_groupperm" VALUES(550,'460e8a48cfd748d19212651a9f602aa6',0,1,'2019-12-27 11:30:51.685012','2019-11-16 10:24:30.480852',0,0,10,59);
INSERT INTO "oneid_meta_groupperm" VALUES(551,'93f9a2f388344c548bcb996f265340d1',0,1,'2019-12-27 11:30:51.692518','2019-11-16 10:24:30.483635',0,0,11,59);
INSERT INTO "oneid_meta_groupperm" VALUES(552,'d7713da15bbc4122a06ee24326550e0c',0,1,'2019-12-27 11:30:51.700305','2019-11-16 10:24:30.487182',0,0,12,59);
INSERT INTO "oneid_meta_groupperm" VALUES(553,'b7d9c386ce4c4f33bd07f4d78290aa7f',0,1,'2019-12-27 11:30:51.707780','2019-11-16 10:24:30.489659',0,0,13,59);
INSERT INTO "oneid_meta_groupperm" VALUES(554,'6d8ff677bb7e4174983afdfe6260a86c',0,1,'2019-12-27 11:30:51.715842','2019-11-16 10:24:30.492114',0,0,14,59);
INSERT INTO "oneid_meta_groupperm" VALUES(555,'2191b7a953c84190aa5e28d28e331287',0,1,'2019-12-27 11:30:51.723475','2019-11-16 10:24:30.494357',0,0,15,59);
INSERT INTO "oneid_meta_groupperm" VALUES(556,'dbb6ba77bc5d4441a4e51ba3bb2e53e2',0,1,'2019-12-27 11:30:51.779925','2019-11-16 10:36:53.318607',0,0,1,60);
INSERT INTO "oneid_meta_groupperm" VALUES(557,'fa8b5c249cc641f1b754361b8ec6d4a6',0,1,'2019-12-27 11:30:51.788565','2019-11-16 10:36:53.320845',0,0,2,60);
INSERT INTO "oneid_meta_groupperm" VALUES(558,'c8fdb3f86c214b5fa92b19fbc7475803',0,1,'2019-12-27 11:30:51.796418','2019-11-16 10:36:53.322712',0,0,3,60);
INSERT INTO "oneid_meta_groupperm" VALUES(559,'99c9cfb93e26480899eaac065284a83e',0,1,'2019-12-27 11:30:51.805860','2019-11-16 10:36:53.324888',0,0,4,60);
INSERT INTO "oneid_meta_groupperm" VALUES(560,'9f06ddb27fa0479aa29056fd2596c86d',0,1,'2019-12-27 11:30:51.813931','2019-11-16 10:36:53.326857',0,0,5,60);
INSERT INTO "oneid_meta_groupperm" VALUES(561,'1934a6084ed94cc2ae5ceec83156ad3f',0,1,'2019-12-27 11:30:51.821786','2019-11-16 10:36:53.328516',0,0,6,60);
INSERT INTO "oneid_meta_groupperm" VALUES(562,'139da51eb54b424fbf7b456fc94aeb21',0,1,'2019-12-27 11:30:51.829487','2019-11-16 10:36:53.330094',0,0,7,60);
INSERT INTO "oneid_meta_groupperm" VALUES(563,'b208f616e1334a89aca97d575bf88222',0,1,'2019-12-27 11:30:51.836949','2019-11-16 10:36:53.331608',0,0,8,60);
INSERT INTO "oneid_meta_groupperm" VALUES(564,'4e26f7230407457297a60d785f6b4388',0,1,'2019-12-27 11:30:51.844635','2019-11-16 10:36:53.333074',0,0,9,60);
INSERT INTO "oneid_meta_groupperm" VALUES(565,'a5f688a4d3304b9abf69884e5366addd',0,1,'2019-12-27 11:30:51.852187','2019-11-16 10:36:53.334780',0,0,10,60);
INSERT INTO "oneid_meta_groupperm" VALUES(566,'d6ab2b48bcb04aceaa4b9ae548a1b681',0,1,'2019-12-27 11:30:51.860064','2019-11-16 10:36:53.336301',0,0,11,60);
INSERT INTO "oneid_meta_groupperm" VALUES(567,'f891709f58a34addb6ddc0e4c4c8253f',0,1,'2019-12-27 11:30:51.868460','2019-11-16 10:36:53.337999',0,0,12,60);
INSERT INTO "oneid_meta_groupperm" VALUES(568,'5b1903b7f0174b0d85d9a94dde5b6cdb',0,1,'2019-12-27 11:30:51.876410','2019-11-16 10:36:53.340043',0,0,13,60);
INSERT INTO "oneid_meta_groupperm" VALUES(569,'e4a317e9779a412ea6ae951f0c4375b7',0,1,'2019-12-27 11:30:51.884348','2019-11-16 10:36:53.342203',0,0,14,60);
INSERT INTO "oneid_meta_groupperm" VALUES(570,'a1bc98b0caf143e8a95f09ccee80143e',0,1,'2019-12-27 11:30:51.892084','2019-11-16 10:36:53.343938',0,0,15,60);
INSERT INTO "oneid_meta_groupperm" VALUES(571,'782cf2c37c9d475c870791d2a9ed42b6',0,1,'2019-12-27 11:30:51.899580','2019-11-16 10:36:53.345662',0,0,16,60);
INSERT INTO "oneid_meta_groupperm" VALUES(572,'8a092c2f850243938d66c2fe4c081c8b',0,1,'2019-12-27 11:30:51.947385','2019-11-16 10:36:59.333156',0,0,1,61);
INSERT INTO "oneid_meta_groupperm" VALUES(573,'08806789db0c4795b576cf5bae4e2050',0,1,'2019-12-27 11:30:51.955204','2019-11-16 10:36:59.335070',0,0,2,61);
INSERT INTO "oneid_meta_groupperm" VALUES(574,'0b35a8e92c1a48fc9a274f91f9977315',0,1,'2019-12-27 11:30:51.962883','2019-11-16 10:36:59.336570',0,0,3,61);
INSERT INTO "oneid_meta_groupperm" VALUES(575,'63dae8fdd5004cd5bf5c4df057988337',0,1,'2019-12-27 11:30:51.970880','2019-11-16 10:36:59.338017',0,0,4,61);
INSERT INTO "oneid_meta_groupperm" VALUES(576,'e89d3cfd20cc4ef1bacecfe0f5db76b6',0,1,'2019-12-27 11:30:51.978710','2019-11-16 10:36:59.339484',0,0,5,61);
INSERT INTO "oneid_meta_groupperm" VALUES(577,'8ad07987d8d64947a4e98388d8bd2378',0,1,'2019-12-27 11:30:51.986192','2019-11-16 10:36:59.340925',0,0,6,61);
INSERT INTO "oneid_meta_groupperm" VALUES(578,'3bf391451fdf4b0198ab8f1d00fc676d',0,1,'2019-12-27 11:30:51.994011','2019-11-16 10:36:59.342493',0,0,7,61);
INSERT INTO "oneid_meta_groupperm" VALUES(579,'45f0c15fadc2401b96092fb5fd8ebd58',0,1,'2019-12-27 11:30:52.001705','2019-11-16 10:36:59.344063',0,0,8,61);
INSERT INTO "oneid_meta_groupperm" VALUES(580,'f72954f9ad714ea6bdab1ab4b79adc68',0,1,'2019-12-27 11:30:52.009583','2019-11-16 10:36:59.346571',0,0,9,61);
INSERT INTO "oneid_meta_groupperm" VALUES(581,'af53009157804217afee365f1fb3a9fb',0,1,'2019-12-27 11:30:52.018483','2019-11-16 10:36:59.348404',0,0,10,61);
INSERT INTO "oneid_meta_groupperm" VALUES(582,'290ade213afd4ce9889993e0a8512862',0,1,'2019-12-27 11:30:52.026632','2019-11-16 10:36:59.349905',0,0,11,61);
INSERT INTO "oneid_meta_groupperm" VALUES(583,'f0bd66bc936c497eb6231ecc735e21a8',0,1,'2019-12-27 11:30:52.035118','2019-11-16 10:36:59.351304',0,0,12,61);
INSERT INTO "oneid_meta_groupperm" VALUES(584,'9326a4e459d544b697b635f90e04bf66',0,1,'2019-12-27 11:30:52.043020','2019-11-16 10:36:59.352769',0,0,13,61);
INSERT INTO "oneid_meta_groupperm" VALUES(585,'f3bf14c26b894c3ab6c9b68a6c6bda10',0,1,'2019-12-27 11:30:52.051176','2019-11-16 10:36:59.354195',0,0,14,61);
INSERT INTO "oneid_meta_groupperm" VALUES(586,'d52a34448c6e4865bbe2a5a60feccbe1',0,1,'2019-12-27 11:30:52.058679','2019-11-16 10:36:59.355587',0,0,15,61);
INSERT INTO "oneid_meta_groupperm" VALUES(587,'b84975050d414b2e9d703d330cd44dbd',0,1,'2019-12-27 11:30:52.066536','2019-11-16 10:36:59.357096',0,0,16,61);
INSERT INTO "oneid_meta_groupperm" VALUES(588,'33990d1e41bf4388a0fe45519adf778e',0,1,'2019-12-27 11:30:52.074628','2019-11-16 10:36:59.358487',0,0,17,61);
INSERT INTO "oneid_meta_groupperm" VALUES(589,'aea374c895de414c881b2d646654ab55',0,1,'2019-12-27 11:30:52.114306','2019-11-16 10:37:06.208785',0,0,1,62);
INSERT INTO "oneid_meta_groupperm" VALUES(590,'e6f33ccb714a486aac5de231ea11b4d7',0,1,'2019-12-27 11:30:52.123245','2019-11-16 10:37:06.210408',0,0,2,62);
INSERT INTO "oneid_meta_groupperm" VALUES(591,'30d4cd882dd04e5991019826e651e9c3',0,1,'2019-12-27 11:30:52.133044','2019-11-16 10:37:06.211836',0,0,3,62);
INSERT INTO "oneid_meta_groupperm" VALUES(592,'03ef5badb2b94d828d779a25d4fc6f4f',0,1,'2019-12-27 11:30:52.144646','2019-11-16 10:37:06.213259',0,0,4,62);
INSERT INTO "oneid_meta_groupperm" VALUES(593,'5b08e61610ba438caec0f4e98a1f2d98',0,1,'2019-12-27 11:30:52.152653','2019-11-16 10:37:06.214680',0,0,5,62);
INSERT INTO "oneid_meta_groupperm" VALUES(594,'21c4bf2c35464bb39ff041c906a6852b',0,1,'2019-12-27 11:30:52.160565','2019-11-16 10:37:06.216719',0,0,6,62);
INSERT INTO "oneid_meta_groupperm" VALUES(595,'8da9921ae5ce473e86749762b94760d1',0,1,'2019-12-27 11:30:52.169357','2019-11-16 10:37:06.219299',0,0,7,62);
INSERT INTO "oneid_meta_groupperm" VALUES(596,'20abbff559054438be73af62a218d81d',0,1,'2019-12-27 11:30:52.178312','2019-11-16 10:37:06.221217',0,0,8,62);
INSERT INTO "oneid_meta_groupperm" VALUES(597,'743affc8b3ad48bd818f8659e7713783',0,1,'2019-12-27 11:30:52.186490','2019-11-16 10:37:06.222654',0,0,9,62);
INSERT INTO "oneid_meta_groupperm" VALUES(598,'7f05d9ea319549f79bd27356a8d2707c',0,1,'2019-12-27 11:30:52.194076','2019-11-16 10:37:06.224034',0,0,10,62);
INSERT INTO "oneid_meta_groupperm" VALUES(599,'af4356ab9bfc4d9c9eb6f0d84bc2e7b6',0,1,'2019-12-27 11:30:52.201836','2019-11-16 10:37:06.225413',0,0,11,62);
INSERT INTO "oneid_meta_groupperm" VALUES(600,'6548c71ad1ce4bdf815a4fc1bdbda9c0',0,1,'2019-12-27 11:30:52.209334','2019-11-16 10:37:06.226790',0,0,12,62);
INSERT INTO "oneid_meta_groupperm" VALUES(601,'f6450d7f3c6a4f128fe0859f1f1ac325',0,1,'2019-12-27 11:30:52.217351','2019-11-16 10:37:06.228478',0,0,13,62);
INSERT INTO "oneid_meta_groupperm" VALUES(602,'ac655382caf945f6b0a4f265fb28f39b',0,1,'2019-12-27 11:30:52.224850','2019-11-16 10:37:06.230099',0,0,14,62);
INSERT INTO "oneid_meta_groupperm" VALUES(603,'cb633d604ee84f059dd94f259df6f2f4',0,1,'2019-12-27 11:30:52.234222','2019-11-16 10:37:06.231492',0,0,15,62);
INSERT INTO "oneid_meta_groupperm" VALUES(604,'6b88089d25b94ac68aa60fcef51a655b',0,1,'2019-12-27 11:30:52.241772','2019-11-16 10:37:06.233536',0,0,16,62);
INSERT INTO "oneid_meta_groupperm" VALUES(605,'0907d5f7a3814b868f08a4e167f8b745',0,1,'2019-12-27 11:30:52.251564','2019-11-16 10:37:06.235759',0,0,17,62);
INSERT INTO "oneid_meta_groupperm" VALUES(606,'6ffb21e2fc9d40048d8a55758f6466e6',0,1,'2019-12-27 11:30:52.261136','2019-11-16 10:37:06.238039',0,0,18,62);
INSERT INTO "oneid_meta_groupperm" VALUES(607,'d58d656fadea4c2a9978dd0069cbdf23',0,1,'2019-12-27 11:30:52.297107','2019-11-16 10:37:13.331519',0,0,1,63);
INSERT INTO "oneid_meta_groupperm" VALUES(608,'4d44827a337e4ba591e28a1c25260966',0,1,'2019-12-27 11:30:52.305746','2019-11-16 10:37:13.333151',0,0,2,63);
INSERT INTO "oneid_meta_groupperm" VALUES(609,'eba83bc414cd4052a9d1afd822e2aa0b',0,1,'2019-12-27 11:30:52.313488','2019-11-16 10:37:13.334574',0,0,3,63);
INSERT INTO "oneid_meta_groupperm" VALUES(610,'42091562dea6430fa9ecc5d5c09f9919',0,1,'2019-12-27 11:30:52.321381','2019-11-16 10:37:13.336199',0,0,4,63);
INSERT INTO "oneid_meta_groupperm" VALUES(611,'43787ffa881742088a62401031575a65',0,1,'2019-12-27 11:30:52.329171','2019-11-16 10:37:13.338794',0,0,5,63);
INSERT INTO "oneid_meta_groupperm" VALUES(612,'f66b9f99037147839718fa2f55a740f9',0,1,'2019-12-27 11:30:52.336876','2019-11-16 10:37:13.340840',0,0,6,63);
INSERT INTO "oneid_meta_groupperm" VALUES(613,'29da8c4f293e476cb3432fbbd2e39f89',0,1,'2019-12-27 11:30:52.344581','2019-11-16 10:37:13.342514',0,0,7,63);
INSERT INTO "oneid_meta_groupperm" VALUES(614,'454d53ef2daa449e89db2f603fc646bc',0,1,'2019-12-27 11:30:52.352501','2019-11-16 10:37:13.343960',0,0,8,63);
INSERT INTO "oneid_meta_groupperm" VALUES(615,'2d7fb31e70f84fb0ac5dfe39c8b96ffb',0,1,'2019-12-27 11:30:52.361227','2019-11-16 10:37:13.345342',0,0,9,63);
INSERT INTO "oneid_meta_groupperm" VALUES(616,'977ffd507c2944779b31afc779407724',0,1,'2019-12-27 11:30:52.371026','2019-11-16 10:37:13.346748',0,0,10,63);
INSERT INTO "oneid_meta_groupperm" VALUES(617,'b3fc4bc886a34ac4b4581d0fd4ac1060',0,1,'2019-12-27 11:30:52.379961','2019-11-16 10:37:13.348860',0,0,11,63);
INSERT INTO "oneid_meta_groupperm" VALUES(618,'b989c4a070144b60b09a34283557979f',0,1,'2019-12-27 11:30:52.390303','2019-11-16 10:37:13.350459',0,0,12,63);
INSERT INTO "oneid_meta_groupperm" VALUES(619,'236a1463d2cf48c090330c990d3e0391',0,1,'2019-12-27 11:30:52.398597','2019-11-16 10:37:13.352011',0,0,13,63);
INSERT INTO "oneid_meta_groupperm" VALUES(620,'fc4b312d5e3c44b1913e02b337708b28',0,1,'2019-12-27 11:30:52.406928','2019-11-16 10:37:13.353847',0,0,14,63);
INSERT INTO "oneid_meta_groupperm" VALUES(621,'4f2ab24f5a954b2682ac9d614e03bb25',0,1,'2019-12-27 11:30:52.414495','2019-11-16 10:37:13.356361',0,0,15,63);
INSERT INTO "oneid_meta_groupperm" VALUES(622,'50db5eb7e3734a48a5f5b2ae2a64b566',0,1,'2019-12-27 11:30:52.422946','2019-11-16 10:37:13.357961',0,0,16,63);
INSERT INTO "oneid_meta_groupperm" VALUES(623,'a97fa6e364014a458783209ce3f68058',0,1,'2019-12-27 11:30:52.431417','2019-11-16 10:37:13.359822',0,0,17,63);
INSERT INTO "oneid_meta_groupperm" VALUES(624,'d8056d63d4bd4ac0895cb570d0aaed1d',0,1,'2019-12-27 11:30:52.439166','2019-11-16 10:37:13.361408',0,0,18,63);
INSERT INTO "oneid_meta_groupperm" VALUES(625,'b2e36eb3364b44d0aafb8b4b8203bdaf',0,1,'2019-12-27 11:30:52.446618','2019-11-16 10:37:13.362797',0,0,19,63);
INSERT INTO "oneid_meta_groupperm" VALUES(626,'f9b16ef4711c491f9cd6519c72e33091',0,1,'2019-12-27 11:30:52.472099','2019-11-16 10:37:18.762792',0,0,1,64);
INSERT INTO "oneid_meta_groupperm" VALUES(627,'c13d9bbccd1b4f5383d478e05c0a49e2',0,1,'2019-12-27 11:30:52.482094','2019-11-16 10:37:18.764628',0,0,2,64);
INSERT INTO "oneid_meta_groupperm" VALUES(628,'9ccade811b294f8ca9ac00fb23909857',0,1,'2019-12-27 11:30:52.491322','2019-11-16 10:37:18.766079',0,0,3,64);
INSERT INTO "oneid_meta_groupperm" VALUES(629,'dec72dfe2e9b4500ac7b998579fd3506',0,1,'2019-12-27 11:30:52.499204','2019-11-16 10:37:18.767498',0,0,4,64);
INSERT INTO "oneid_meta_groupperm" VALUES(630,'44ed91da65e24bc8addb8fc457be2142',0,1,'2019-12-27 11:30:52.507227','2019-11-16 10:37:18.768916',0,0,5,64);
INSERT INTO "oneid_meta_groupperm" VALUES(631,'986ab81873e6439c9c3fe76538e70875',0,1,'2019-12-27 11:30:52.515533','2019-11-16 10:37:18.770337',0,0,6,64);
INSERT INTO "oneid_meta_groupperm" VALUES(632,'33e0a6a9fa014c9c9fcd8dc5ad949896',0,1,'2019-12-27 11:30:52.523926','2019-11-16 10:37:18.771806',0,0,7,64);
INSERT INTO "oneid_meta_groupperm" VALUES(633,'2a45328ee0f249ffaca29999e9fe3733',0,1,'2019-12-27 11:30:52.531578','2019-11-16 10:37:18.773252',0,0,8,64);
INSERT INTO "oneid_meta_groupperm" VALUES(634,'cbfc6f665f244cc5b462894d3a9c7290',0,1,'2019-12-27 11:30:52.539385','2019-11-16 10:37:18.774762',0,0,9,64);
INSERT INTO "oneid_meta_groupperm" VALUES(635,'50e7d2beb7624863a3e94119de8fc8cf',0,1,'2019-12-27 11:30:52.547194','2019-11-16 10:37:18.777046',0,0,10,64);
INSERT INTO "oneid_meta_groupperm" VALUES(636,'0d7ca6d420344458be59b550884c5e9f',0,1,'2019-12-27 11:30:52.555108','2019-11-16 10:37:18.779078',0,0,11,64);
INSERT INTO "oneid_meta_groupperm" VALUES(637,'f45a3024c6ee4706afb23130ffda15a8',0,1,'2019-12-27 11:30:52.562490','2019-11-16 10:37:18.780545',0,0,12,64);
INSERT INTO "oneid_meta_groupperm" VALUES(638,'8decb77210c743908423ac36fe451214',0,1,'2019-12-27 11:30:52.570775','2019-11-16 10:37:18.782033',0,0,13,64);
INSERT INTO "oneid_meta_groupperm" VALUES(639,'5684a22da255418db042042874215581',0,1,'2019-12-27 11:30:52.580525','2019-11-16 10:37:18.783772',0,0,14,64);
INSERT INTO "oneid_meta_groupperm" VALUES(640,'7f35b349170d4ee5b1924e59aa53ebaa',0,1,'2019-12-27 11:30:52.590023','2019-11-16 10:37:18.785256',0,0,15,64);
INSERT INTO "oneid_meta_groupperm" VALUES(641,'47aef2c315a9472b85f9ec9b9465985d',0,1,'2019-12-27 11:30:52.597737','2019-11-16 10:37:18.786649',0,0,16,64);
INSERT INTO "oneid_meta_groupperm" VALUES(642,'130b50725d7d46188d0282f4eb277f03',0,1,'2019-12-27 11:30:52.606300','2019-11-16 10:37:18.788191',0,0,17,64);
INSERT INTO "oneid_meta_groupperm" VALUES(643,'d717bbf566364404b3c43afed619d199',0,1,'2019-12-27 11:30:52.613881','2019-11-16 10:37:18.789580',0,0,18,64);
INSERT INTO "oneid_meta_groupperm" VALUES(644,'a8050ae8673c4bc3a003903ef3172d92',0,1,'2019-12-27 11:30:52.622501','2019-11-16 10:37:18.790993',0,0,19,64);
INSERT INTO "oneid_meta_groupperm" VALUES(645,'ec5adc0eafc140639cfd5217ff32f6d9',0,1,'2019-12-27 11:30:52.631019','2019-11-16 10:37:18.793200',0,0,20,64);
INSERT INTO "oneid_meta_groupperm" VALUES(646,'50870b549b244af6a95a863fe3a61d1d',0,1,'2019-12-27 11:30:49.974348','2019-12-27 04:08:15.744110',0,0,1,1);
INSERT INTO "oneid_meta_groupperm" VALUES(647,'fe365e722f8e4559ab5d9a118dfeac04',0,1,'2019-12-27 11:30:50.083616','2019-12-27 04:08:15.746404',0,0,1,2);
INSERT INTO "oneid_meta_groupperm" VALUES(648,'f7274c163f074e3a820b29e15646fd10',0,1,'2019-12-27 11:31:01.515311','2019-12-27 04:08:15.748386',0,0,1,3);
INSERT INTO "oneid_meta_groupperm" VALUES(649,'0fb0052257434df5972d437bb69a8c59',0,1,'2019-12-27 11:30:50.248987','2019-12-27 04:08:15.750412',0,0,1,4);
INSERT INTO "oneid_meta_groupperm" VALUES(650,'5b13c550d2c648aa8072f9b9c5e43506',0,1,'2019-12-27 11:30:53.256234','2019-12-27 04:08:15.752449',0,0,1,5);
INSERT INTO "oneid_meta_groupperm" VALUES(651,'2690355f54b6446985e798c6b7db23e9',0,1,'2019-12-27 11:30:56.625351','2019-12-27 04:08:15.754416',0,0,1,6);
INSERT INTO "oneid_meta_groupperm" VALUES(652,'337c49db5399439686a316bc1a9c91c5',0,1,'2019-12-27 11:30:49.979149','2019-12-27 04:08:15.826413',0,0,2,1);
INSERT INTO "oneid_meta_groupperm" VALUES(653,'e60ed560b58844518eafed3a9ba9c345',0,1,'2019-12-27 11:30:50.091338','2019-12-27 04:08:15.828583',0,0,2,2);
INSERT INTO "oneid_meta_groupperm" VALUES(654,'50b7ab7918804805becfccf8fb5cf041',0,1,'2019-12-27 11:31:01.522758','2019-12-27 04:08:15.830563',0,0,2,3);
INSERT INTO "oneid_meta_groupperm" VALUES(655,'fdc1aa55a6374183ab6d5d74c060345a',0,1,'2019-12-27 11:30:50.256559','2019-12-27 04:08:15.832564',0,0,2,4);
INSERT INTO "oneid_meta_groupperm" VALUES(656,'629a9b76ad9547f0998190c3d423c6b5',0,1,'2019-12-27 11:30:53.264700','2019-12-27 04:08:15.834589',0,0,2,5);
INSERT INTO "oneid_meta_groupperm" VALUES(657,'38ed61dbb2f7424c8ceaf9f8ccef1fac',0,1,'2019-12-27 11:30:56.633227','2019-12-27 04:08:15.836597',0,0,2,6);
INSERT INTO "oneid_meta_groupperm" VALUES(658,'42b6f22e16224ff08bf872f7afd3719b',0,1,'2019-12-27 11:30:49.983845','2019-12-27 04:08:15.911161',0,0,3,1);
INSERT INTO "oneid_meta_groupperm" VALUES(659,'e9da6fd8d74a41b58dbb327ecb176b44',0,1,'2019-12-27 11:30:50.099132','2019-12-27 04:08:15.913261',0,0,3,2);
INSERT INTO "oneid_meta_groupperm" VALUES(660,'8c43a79a396a4ff397ab53c88bf46f90',0,1,'2019-12-27 11:31:01.530769','2019-12-27 04:08:15.915289',0,0,3,3);
INSERT INTO "oneid_meta_groupperm" VALUES(661,'919b13aca9804c9eba9cc1f6d88df3dc',0,1,'2019-12-27 11:30:50.264552','2019-12-27 04:08:15.917340',0,0,3,4);
INSERT INTO "oneid_meta_groupperm" VALUES(662,'af5b4e822020442bb4167ab3b786353e',0,1,'2019-12-27 11:30:53.273504','2019-12-27 04:08:15.919328',0,0,3,5);
INSERT INTO "oneid_meta_groupperm" VALUES(663,'023c91805107433d9d5400b15ae4df3f',0,1,'2019-12-27 11:30:56.642996','2019-12-27 04:08:15.921747',0,0,3,6);
INSERT INTO "oneid_meta_groupperm" VALUES(664,'cae99d9f825a43dda6833367c034d018',0,1,'2019-12-27 11:30:49.988949','2019-12-27 04:08:15.996585',0,0,4,1);
INSERT INTO "oneid_meta_groupperm" VALUES(665,'1ee9d1780e544b5194f56af1f842fea6',0,1,'2019-12-27 11:30:50.107493','2019-12-27 04:08:15.998609',0,0,4,2);
INSERT INTO "oneid_meta_groupperm" VALUES(666,'39175a9de9f349c09321b6dbbeeb5cf1',0,1,'2019-12-27 11:31:01.538311','2019-12-27 04:08:16.000696',0,0,4,3);
INSERT INTO "oneid_meta_groupperm" VALUES(667,'2653efaacd4c404ba347bd990eb5540a',0,1,'2019-12-27 11:30:50.272042','2019-12-27 04:08:16.002724',0,0,4,4);
INSERT INTO "oneid_meta_groupperm" VALUES(668,'323ed4775d984aa8b0c457b7b78c5059',0,1,'2019-12-27 11:30:53.281948','2019-12-27 04:08:16.004707',0,0,4,5);
INSERT INTO "oneid_meta_groupperm" VALUES(669,'58c4c127a0f44a0fbcdfafefb1fc624b',0,1,'2019-12-27 11:30:56.650553','2019-12-27 04:08:16.006688',0,0,4,6);
INSERT INTO "oneid_meta_groupperm" VALUES(670,'d930361404044877b827851dc0b5edf7',0,1,'2019-12-27 11:30:49.993577','2019-12-27 04:08:16.089104',0,0,5,1);
INSERT INTO "oneid_meta_groupperm" VALUES(671,'fdb3fbbbbdd04fa2904dd8eaec080027',0,1,'2019-12-27 11:30:50.115010','2019-12-27 04:08:16.091231',0,0,5,2);
INSERT INTO "oneid_meta_groupperm" VALUES(672,'eed9f04e691c41a5b506a1fe80655c6e',0,1,'2019-12-27 11:31:01.546036','2019-12-27 04:08:16.093783',0,0,5,3);
INSERT INTO "oneid_meta_groupperm" VALUES(673,'6f35d7b5323049d881c65a32fabc7857',0,1,'2019-12-27 11:30:50.279848','2019-12-27 04:08:16.096310',0,0,5,4);
INSERT INTO "oneid_meta_groupperm" VALUES(674,'9c42abff2f2b42b9bd9633771c501e33',0,1,'2019-12-27 11:30:53.290344','2019-12-27 04:08:16.098435',0,0,5,5);
INSERT INTO "oneid_meta_groupperm" VALUES(675,'937ac406e81949b8a582f948b8d72fce',0,1,'2019-12-27 11:30:56.659911','2019-12-27 04:08:16.100509',0,0,5,6);
INSERT INTO "oneid_meta_groupperm" VALUES(676,'06bd9c237b93483d8eb265147728388b',0,1,'2019-12-27 11:30:49.998502','2019-12-27 04:08:16.182484',0,0,6,1);
INSERT INTO "oneid_meta_groupperm" VALUES(677,'bc97d802766541a48880fc5e74c60521',0,1,'2019-12-27 11:30:50.122752','2019-12-27 04:08:16.185070',0,0,6,2);
INSERT INTO "oneid_meta_groupperm" VALUES(678,'e1b72edb80fc43c0a7b0577c1819cc06',0,1,'2019-12-27 11:31:01.553454','2019-12-27 04:08:16.187096',0,0,6,3);
INSERT INTO "oneid_meta_groupperm" VALUES(679,'88571502cc7c46b0a5b99fe518bfe34e',0,1,'2019-12-27 11:30:50.288191','2019-12-27 04:08:16.189114',0,0,6,4);
INSERT INTO "oneid_meta_groupperm" VALUES(680,'a5cf48e7cb024d9bb049b2ff2725c7b8',0,1,'2019-12-27 11:30:53.298443','2019-12-27 04:08:16.191174',0,0,6,5);
INSERT INTO "oneid_meta_groupperm" VALUES(681,'3f13a398f41e4649b67e9a490886b1b4',0,1,'2019-12-27 11:30:56.667387','2019-12-27 04:08:16.193395',0,0,6,6);
INSERT INTO "oneid_meta_groupperm" VALUES(682,'e118ac9f89d44c489425641a2115ff9b',0,1,'2019-12-27 11:30:50.004403','2019-12-27 04:08:16.277523',0,0,7,1);
INSERT INTO "oneid_meta_groupperm" VALUES(683,'5a3a8fa5235d42639cb4fca1d929b400',0,1,'2019-12-27 11:30:50.130352','2019-12-27 04:08:16.280208',0,0,7,2);
INSERT INTO "oneid_meta_groupperm" VALUES(684,'7cb637261821471a91c8a3080141417e',0,1,'2019-12-27 11:31:01.561063','2019-12-27 04:08:16.282453',0,0,7,3);
INSERT INTO "oneid_meta_groupperm" VALUES(685,'530a33d24e864c74a1163c897cdbccab',0,1,'2019-12-27 11:30:50.295712','2019-12-27 04:08:16.284904',0,0,7,4);
INSERT INTO "oneid_meta_groupperm" VALUES(686,'52a2c68b4d7442918886057833049a86',0,1,'2019-12-27 11:30:53.307216','2019-12-27 04:08:16.287077',0,0,7,5);
INSERT INTO "oneid_meta_groupperm" VALUES(687,'18e34de137dc44bd858bac8264128e1f',0,1,'2019-12-27 11:30:56.681571','2019-12-27 04:08:16.289326',0,0,7,6);
INSERT INTO "oneid_meta_groupperm" VALUES(688,'723794ab89074bb2a555eb20f48be9be',0,1,'2019-12-27 11:30:50.009185','2019-12-27 04:08:16.370958',0,0,8,1);
INSERT INTO "oneid_meta_groupperm" VALUES(689,'011604fadafb446f821e7b35e00b79e7',0,1,'2019-12-27 11:30:50.138183','2019-12-27 04:08:16.373232',0,0,8,2);
INSERT INTO "oneid_meta_groupperm" VALUES(690,'c73056af9b5244068d8a7a473530c94d',0,1,'2019-12-27 11:31:01.568716','2019-12-27 04:08:16.376071',0,0,8,3);
INSERT INTO "oneid_meta_groupperm" VALUES(691,'0f98a61af01a4042b0877b6eb450dc84',0,1,'2019-12-27 11:30:50.303553','2019-12-27 04:08:16.378316',0,0,8,4);
INSERT INTO "oneid_meta_groupperm" VALUES(692,'e93b3f8da44942dda2e601ce406a8a6b',0,1,'2019-12-27 11:30:53.315529','2019-12-27 04:08:16.380672',0,0,8,5);
INSERT INTO "oneid_meta_groupperm" VALUES(693,'1236f5000c96455a8d6048c18900462c',0,1,'2019-12-27 11:30:56.691267','2019-12-27 04:08:16.383069',0,0,8,6);
INSERT INTO "oneid_meta_groupperm" VALUES(694,'ce5eb4068d4d45219e1e4e1d574106b7',0,1,'2019-12-27 11:30:50.013916','2019-12-27 04:08:16.465659',0,0,9,1);
INSERT INTO "oneid_meta_groupperm" VALUES(695,'3d57403d4998489eb9ed6210dd3812c7',0,1,'2019-12-27 11:30:50.146014','2019-12-27 04:08:16.467736',0,0,9,2);
INSERT INTO "oneid_meta_groupperm" VALUES(696,'3b073504be794479aed5edd3adb3e3da',0,1,'2019-12-27 11:31:01.576471','2019-12-27 04:08:16.469783',0,0,9,3);
INSERT INTO "oneid_meta_groupperm" VALUES(697,'3405add52c1b40b5a9bb499ae9f88d27',0,1,'2019-12-27 11:30:50.311621','2019-12-27 04:08:16.471866',0,0,9,4);
INSERT INTO "oneid_meta_groupperm" VALUES(698,'72014518c4224ceabe079ffc93d0e4c3',0,1,'2019-12-27 11:30:53.323963','2019-12-27 04:08:16.473853',0,0,9,5);
INSERT INTO "oneid_meta_groupperm" VALUES(699,'7226c96ca09b4a5697e3727f457332d7',0,1,'2019-12-27 11:30:56.699068','2019-12-27 04:08:16.476428',0,0,9,6);
INSERT INTO "oneid_meta_groupperm" VALUES(700,'8b09da0d557b4891bb46e6983f6a8393',0,1,'2019-12-27 11:30:50.020088','2019-12-27 04:08:16.578479',0,0,10,1);
INSERT INTO "oneid_meta_groupperm" VALUES(701,'b370c7df123d4bf0b6656a65ec7b8b02',0,1,'2019-12-27 11:30:50.153973','2019-12-27 04:08:16.581673',0,0,10,2);
INSERT INTO "oneid_meta_groupperm" VALUES(702,'80d3c5d0e4f840559417deadb7666e54',0,1,'2019-12-27 11:31:01.584291','2019-12-27 04:08:16.584565',0,0,10,3);
INSERT INTO "oneid_meta_groupperm" VALUES(703,'0033bf002c1649888997eb732cdbf475',0,1,'2019-12-27 11:30:50.319451','2019-12-27 04:08:16.587256',0,0,10,4);
INSERT INTO "oneid_meta_groupperm" VALUES(704,'2d9103d07ff64c509e5e6a6bd96d4417',0,1,'2019-12-27 11:30:53.332257','2019-12-27 04:08:16.589606',0,0,10,5);
INSERT INTO "oneid_meta_groupperm" VALUES(705,'44c7f84159654e23a5601598f8d72129',0,1,'2019-12-27 11:30:56.708140','2019-12-27 04:08:16.592426',0,0,10,6);
INSERT INTO "oneid_meta_groupperm" VALUES(706,'0d91cf61fa33492a80dc4297f425a8fb',0,1,'2019-12-27 11:30:50.025024','2019-12-27 04:08:16.691280',0,0,11,1);
INSERT INTO "oneid_meta_groupperm" VALUES(707,'a84ed7cc74164cc2b2054702c956dc81',0,1,'2019-12-27 11:30:50.161823','2019-12-27 04:08:16.693619',0,0,11,2);
INSERT INTO "oneid_meta_groupperm" VALUES(708,'2bb54ce609c64323acf3c8cb6d77c1c4',0,1,'2019-12-27 11:31:01.592266','2019-12-27 04:08:16.695763',0,0,11,3);
INSERT INTO "oneid_meta_groupperm" VALUES(709,'654e02776b72493a8d0fb7e8f1562602',0,1,'2019-12-27 11:30:50.327128','2019-12-27 04:08:16.697719',0,0,11,4);
INSERT INTO "oneid_meta_groupperm" VALUES(710,'c110585766a741d395cc82463fbd6de0',0,1,'2019-12-27 11:30:53.340647','2019-12-27 04:08:16.699695',0,0,11,5);
INSERT INTO "oneid_meta_groupperm" VALUES(711,'b8c6efb779644243b77377427baadf79',0,1,'2019-12-27 11:30:56.716528','2019-12-27 04:08:16.701632',0,0,11,6);
INSERT INTO "oneid_meta_groupperm" VALUES(712,'49e9d08905504de390a52d5175ced6d5',0,1,'2019-12-27 11:30:53.533836','2019-12-27 04:08:16.703800',0,0,11,7);
INSERT INTO "oneid_meta_groupperm" VALUES(713,'e70dbe983f0a49fa83f92ed9e46ab4e5',0,1,'2019-12-27 11:30:53.709092','2019-12-27 04:08:16.705817',0,0,11,8);
INSERT INTO "oneid_meta_groupperm" VALUES(714,'ae4612a8b8b14f6eae8d40e8f4b9cf1e',0,1,'2019-12-27 11:30:53.883967','2019-12-27 04:08:16.707809',0,0,11,9);
INSERT INTO "oneid_meta_groupperm" VALUES(715,'1488f97bba8b40a4adce3d3785c77548',0,1,'2019-12-27 11:30:54.058207','2019-12-27 04:08:16.709812',0,0,11,10);
INSERT INTO "oneid_meta_groupperm" VALUES(716,'25ddaba5d5b44409a4aad1fdc361e657',0,1,'2019-12-27 11:30:54.222997','2019-12-27 04:08:16.711766',0,0,11,11);
INSERT INTO "oneid_meta_groupperm" VALUES(717,'43ac0394e85743578c334c62d00df030',0,1,'2019-12-27 11:30:54.400818','2019-12-27 04:08:16.713960',0,0,11,12);
INSERT INTO "oneid_meta_groupperm" VALUES(718,'2e4cfc63413e49629d2cc2d1430bfbc3',0,1,'2019-12-27 11:30:54.567861','2019-12-27 04:08:16.716067',0,0,11,13);
INSERT INTO "oneid_meta_groupperm" VALUES(719,'d211fde3b82144918c2c4882915ec024',0,1,'2019-12-27 11:30:55.606260','2019-12-27 04:08:16.718056',0,0,11,14);
INSERT INTO "oneid_meta_groupperm" VALUES(720,'5003bb01c190491b91ef73c9d7d50652',0,1,'2019-12-27 11:30:55.951997','2019-12-27 04:08:16.720121',0,0,11,15);
INSERT INTO "oneid_meta_groupperm" VALUES(721,'e33a30e174804cc6b092ababbfe0118d',0,1,'2019-12-27 11:30:56.333375','2019-12-27 04:08:16.722760',0,0,11,16);
INSERT INTO "oneid_meta_groupperm" VALUES(722,'9a8ba889930d434f9c20f7ad84eb4b1c',0,1,'2019-12-27 11:30:54.747165','2019-12-27 04:08:16.725324',0,0,11,17);
INSERT INTO "oneid_meta_groupperm" VALUES(723,'40fb19557c454af1939abb71206fe809',0,1,'2019-12-27 11:30:54.925055','2019-12-27 04:08:16.727976',0,0,11,18);
INSERT INTO "oneid_meta_groupperm" VALUES(724,'cb062f6b17cb45578a51081a1c216730',0,1,'2019-12-27 11:30:55.104416','2019-12-27 04:08:16.730310',0,0,11,19);
INSERT INTO "oneid_meta_groupperm" VALUES(725,'c169c4cc53ab4d1f8e3b9aaff3b8a118',0,1,'2019-12-27 11:30:55.270039','2019-12-27 04:08:16.732451',0,0,11,20);
INSERT INTO "oneid_meta_groupperm" VALUES(726,'528a3f09d4da42939fac76d61b0d8370',0,1,'2019-12-27 11:30:55.440175','2019-12-27 04:08:16.734490',0,0,11,21);
INSERT INTO "oneid_meta_groupperm" VALUES(727,'3241a1ddd58545ab934ceb25c48e239c',0,1,'2019-12-27 11:30:56.941387','2019-12-27 04:08:16.736490',0,0,11,22);
INSERT INTO "oneid_meta_groupperm" VALUES(728,'312065b0998d422da4e9e3a00452a46f',0,1,'2019-12-27 11:30:58.062416','2019-12-27 04:08:16.738662',0,0,11,23);
INSERT INTO "oneid_meta_groupperm" VALUES(729,'0a67071342d2480abbf82ef2b56e1d0d',0,1,'2019-12-27 11:30:59.093460','2019-12-27 04:08:16.740696',0,0,11,24);
INSERT INTO "oneid_meta_groupperm" VALUES(730,'bc14d09db5c748bca1e3b52a65e3f7d2',0,1,'2019-12-27 11:30:59.423588','2019-12-27 04:08:16.743043',0,0,11,25);
INSERT INTO "oneid_meta_groupperm" VALUES(731,'da9d39df777d4ae5bdd8ffb2dcab8b72',0,1,'2019-12-27 11:30:59.754048','2019-12-27 04:08:16.745199',0,0,11,26);
INSERT INTO "oneid_meta_groupperm" VALUES(732,'13b673ea8c1542bba1a60c325138b710',0,1,'2019-12-27 11:30:55.777388','2019-12-27 04:08:16.747235',0,0,11,27);
INSERT INTO "oneid_meta_groupperm" VALUES(733,'bfd33c9c65e346519dcec9b743e9c88b',0,1,'2019-12-27 11:30:56.125830','2019-12-27 04:08:16.749325',0,0,11,28);
INSERT INTO "oneid_meta_groupperm" VALUES(734,'2717e489d36e4eb9aebe9b6ce3fad2bd',0,1,'2019-12-27 11:30:56.525465','2019-12-27 04:08:16.751284',0,0,11,29);
INSERT INTO "oneid_meta_groupperm" VALUES(735,'705080a7c19f4d919a85c7e3415707d1',0,1,'2019-12-27 11:30:57.142008','2019-12-27 04:08:16.753225',0,0,11,30);
INSERT INTO "oneid_meta_groupperm" VALUES(736,'4337dd3678d44910bc3154d33d932a81',0,1,'2019-12-27 11:30:57.333145','2019-12-27 04:08:16.755318',0,0,11,31);
INSERT INTO "oneid_meta_groupperm" VALUES(737,'05443310b268473388829abc78c792de',0,1,'2019-12-27 11:30:57.522591','2019-12-27 04:08:16.757319',0,0,11,32);
INSERT INTO "oneid_meta_groupperm" VALUES(738,'2158fadaee464f00ab0d498fee17b596',0,1,'2019-12-27 11:30:57.696571','2019-12-27 04:08:16.759469',0,0,11,33);
INSERT INTO "oneid_meta_groupperm" VALUES(739,'d3a14676052346c9b66432f67efedb45',0,1,'2019-12-27 11:30:57.880411','2019-12-27 04:08:16.761495',0,0,11,34);
INSERT INTO "oneid_meta_groupperm" VALUES(740,'50fb84830f114ea7b4bfcaee434fd1fc',0,1,'2019-12-27 11:30:58.244298','2019-12-27 04:08:16.763434',0,0,11,35);
INSERT INTO "oneid_meta_groupperm" VALUES(741,'851132b03d974fa0bac4ddf404c4a965',0,1,'2019-12-27 11:30:58.414781','2019-12-27 04:08:16.765425',0,0,11,36);
INSERT INTO "oneid_meta_groupperm" VALUES(742,'95eb264a6bc44e89921339e3dc0a8a24',0,1,'2019-12-27 11:30:58.587085','2019-12-27 04:08:16.767345',0,0,11,37);
INSERT INTO "oneid_meta_groupperm" VALUES(743,'1ea257ac47744a56aa0d305c4a3c51ba',0,1,'2019-12-27 11:30:58.753208','2019-12-27 04:08:16.769329',0,0,11,38);
INSERT INTO "oneid_meta_groupperm" VALUES(744,'c2d699ee3ef14d04b7fc2defafac45a1',0,1,'2019-12-27 11:30:58.926029','2019-12-27 04:08:16.771557',0,0,11,39);
INSERT INTO "oneid_meta_groupperm" VALUES(745,'06a212d4343e44fca6b7bd13bf0e37af',0,1,'2019-12-27 11:30:59.258563','2019-12-27 04:08:16.773667',0,0,11,40);
INSERT INTO "oneid_meta_groupperm" VALUES(746,'b5d1c1f88972485398d00b5251ea16f7',0,1,'2019-12-27 11:30:59.588002','2019-12-27 04:08:16.776032',0,0,11,41);
INSERT INTO "oneid_meta_groupperm" VALUES(747,'997e018f7a0042749498e59a95297647',0,1,'2019-12-27 11:30:59.923822','2019-12-27 04:08:16.778090',0,0,11,42);
INSERT INTO "oneid_meta_groupperm" VALUES(748,'62a5f77dc6ef4c5b82620c309cfd804b',0,1,'2019-12-27 11:31:00.091996','2019-12-27 04:08:16.780153',0,0,11,43);
INSERT INTO "oneid_meta_groupperm" VALUES(749,'e1f35a7d0ba94431805f9381a1bb70ac',0,1,'2019-12-27 11:30:50.494669','2019-12-27 04:08:16.782327',0,0,11,44);
INSERT INTO "oneid_meta_groupperm" VALUES(750,'ae87cb9f7b3d47a0bbc9a37520124e9f',0,1,'2019-12-27 11:31:00.771689','2019-12-27 04:08:16.784301',0,0,11,45);
INSERT INTO "oneid_meta_groupperm" VALUES(751,'4d323fbf8d1546ad97e4b2713e49448e',0,1,'2019-12-27 11:30:50.667129','2019-12-27 04:08:16.786428',0,0,11,46);
INSERT INTO "oneid_meta_groupperm" VALUES(752,'7330866ab83f4423b0f11c9dce553679',0,1,'2019-12-27 11:31:00.278400','2019-12-27 04:08:16.788322',0,0,11,47);
INSERT INTO "oneid_meta_groupperm" VALUES(753,'28cc9c4df8e94a1994814ca61084af13',0,1,'2019-12-27 11:31:00.444348','2019-12-27 04:08:16.790339',0,0,11,48);
INSERT INTO "oneid_meta_groupperm" VALUES(754,'7159df6fbe43438288a92e6e84729341',0,1,'2019-12-27 11:31:00.607724','2019-12-27 04:08:16.792328',0,0,11,49);
INSERT INTO "oneid_meta_groupperm" VALUES(755,'bc21293a95194149aaa4ced1e926f3b2',0,1,'2019-12-27 11:31:00.939848','2019-12-27 04:08:16.794788',0,0,11,50);
INSERT INTO "oneid_meta_groupperm" VALUES(756,'0e5bde56d7634a70940716cd50885651',0,1,'2019-12-27 11:31:01.104486','2019-12-27 04:08:16.796818',0,0,11,51);
INSERT INTO "oneid_meta_groupperm" VALUES(757,'f7f1fae805d5404ca8648b502650d5a7',0,1,'2019-12-27 11:31:01.267821','2019-12-27 04:08:16.798883',0,0,11,52);
INSERT INTO "oneid_meta_groupperm" VALUES(758,'c6d9c4524843405f853f516ad122fdd7',0,1,'2019-12-27 11:30:50.029776','2019-12-27 04:08:16.882635',0,0,12,1);
INSERT INTO "oneid_meta_groupperm" VALUES(759,'063cefa7e93945a29b1cbf9050ac992d',0,1,'2019-12-27 11:30:50.169678','2019-12-27 04:08:16.884711',0,0,12,2);
INSERT INTO "oneid_meta_groupperm" VALUES(760,'01b14848e70f45f488a3051fb47ac1c1',0,1,'2019-12-27 11:31:01.600006','2019-12-27 04:08:16.886710',0,0,12,3);
INSERT INTO "oneid_meta_groupperm" VALUES(761,'f999262ea6bf44329dfbfc715aecf67f',0,1,'2019-12-27 11:30:50.335306','2019-12-27 04:08:16.888684',0,0,12,4);
INSERT INTO "oneid_meta_groupperm" VALUES(762,'bb3c338a038f482abe214d50bdd8cc24',0,1,'2019-12-27 11:30:53.349116','2019-12-27 04:08:16.890915',0,0,12,5);
INSERT INTO "oneid_meta_groupperm" VALUES(763,'54389a7307b64f2d99a9c8b881188f20',0,1,'2019-12-27 11:30:56.725781','2019-12-27 04:08:16.893357',0,0,12,6);
INSERT INTO "oneid_meta_groupperm" VALUES(764,'3e05c70dd5ba4ad3abedc6126b524ce3',0,1,'2019-12-27 11:30:53.542419','2019-12-27 04:08:16.895915',0,0,12,7);
INSERT INTO "oneid_meta_groupperm" VALUES(765,'7efbc4b617f848c5a2c9b5f182adb381',0,1,'2019-12-27 11:30:53.716974','2019-12-27 04:08:16.898406',0,0,12,8);
INSERT INTO "oneid_meta_groupperm" VALUES(766,'5afe55849c94437a9b6842f989e7d5ac',0,1,'2019-12-27 11:30:53.893795','2019-12-27 04:08:16.900431',0,0,12,9);
INSERT INTO "oneid_meta_groupperm" VALUES(767,'b3dc1de1bbc841878cf5cac9dfc93c5b',0,1,'2019-12-27 11:30:54.065691','2019-12-27 04:08:16.902719',0,0,12,10);
INSERT INTO "oneid_meta_groupperm" VALUES(768,'8bf5f7fc233d4c3291e9684227e160bf',0,1,'2019-12-27 11:30:54.231679','2019-12-27 04:08:16.905127',0,0,12,11);
INSERT INTO "oneid_meta_groupperm" VALUES(769,'c7fdab73ab724baf9bfa499017030685',0,1,'2019-12-27 11:30:54.409465','2019-12-27 04:08:16.907091',0,0,12,12);
INSERT INTO "oneid_meta_groupperm" VALUES(770,'a8c816caf9364e1ea826e775e2d45137',0,1,'2019-12-27 11:30:54.576708','2019-12-27 04:08:16.909088',0,0,12,13);
INSERT INTO "oneid_meta_groupperm" VALUES(771,'504103a25a2041e9b1eb3497f1690c43',0,1,'2019-12-27 11:30:55.614065','2019-12-27 04:08:16.911152',0,0,12,14);
INSERT INTO "oneid_meta_groupperm" VALUES(772,'9b702ea03ec44427941b67e76b9bb8a7',0,1,'2019-12-27 11:30:55.960627','2019-12-27 04:08:16.914663',0,0,12,15);
INSERT INTO "oneid_meta_groupperm" VALUES(773,'f62a8f4dce1c4482b21a77f50f9649da',0,1,'2019-12-27 11:30:56.344083','2019-12-27 04:08:16.916783',0,0,12,16);
INSERT INTO "oneid_meta_groupperm" VALUES(774,'a251f3ca13a84e1c891ceacf717245e9',0,1,'2019-12-27 11:30:54.755264','2019-12-27 04:08:16.918849',0,0,12,17);
INSERT INTO "oneid_meta_groupperm" VALUES(775,'1db045ef7dd44907aa61f90cbe70dcc5',0,1,'2019-12-27 11:30:54.933071','2019-12-27 04:08:16.920860',0,0,12,18);
INSERT INTO "oneid_meta_groupperm" VALUES(776,'1f7b6d6d0f5e4eb888c77f2a33f7303e',0,1,'2019-12-27 11:30:55.112336','2019-12-27 04:08:16.922886',0,0,12,19);
INSERT INTO "oneid_meta_groupperm" VALUES(777,'6cf13fa9273f4f84941b8c1f6bd6123f',0,1,'2019-12-27 11:30:55.277752','2019-12-27 04:08:16.925651',0,0,12,20);
INSERT INTO "oneid_meta_groupperm" VALUES(778,'78915b41316241898da5b2d4647fca2f',0,1,'2019-12-27 11:30:55.448249','2019-12-27 04:08:16.928489',0,0,12,21);
INSERT INTO "oneid_meta_groupperm" VALUES(779,'a792e649a99a40e2a561974423f0b66c',0,1,'2019-12-27 11:30:56.949111','2019-12-27 04:08:16.931106',0,0,12,22);
INSERT INTO "oneid_meta_groupperm" VALUES(780,'46a1dd7b7ea34b6e9e8347c9dc446243',0,1,'2019-12-27 11:30:58.070529','2019-12-27 04:08:16.933118',0,0,12,23);
INSERT INTO "oneid_meta_groupperm" VALUES(781,'06beef2996814b49a64cce5a4863f300',0,1,'2019-12-27 11:30:59.102072','2019-12-27 04:08:16.935178',0,0,12,24);
INSERT INTO "oneid_meta_groupperm" VALUES(782,'ef7e2bddfcc344ebbb3585e1741fbeea',0,1,'2019-12-27 11:30:59.430946','2019-12-27 04:08:16.937399',0,0,12,25);
INSERT INTO "oneid_meta_groupperm" VALUES(783,'426c1ffefb484493abb1f68031819c9e',0,1,'2019-12-27 11:30:59.761818','2019-12-27 04:08:16.939345',0,0,12,26);
INSERT INTO "oneid_meta_groupperm" VALUES(784,'d3907749aa3a4d20b0e889c892effe1b',0,1,'2019-12-27 11:30:55.785286','2019-12-27 04:08:16.941339',0,0,12,27);
INSERT INTO "oneid_meta_groupperm" VALUES(785,'dd512ef577ec41f3a8a5e8b4d770f6f1',0,1,'2019-12-27 11:30:56.135798','2019-12-27 04:08:16.943380',0,0,12,28);
INSERT INTO "oneid_meta_groupperm" VALUES(786,'7983b6dbe97548199d7a680fe13d112f',0,1,'2019-12-27 11:30:56.533748','2019-12-27 04:08:16.945729',0,0,12,29);
INSERT INTO "oneid_meta_groupperm" VALUES(787,'f9e5a957aa0b40d8954e3f4347f9b5c0',0,1,'2019-12-27 11:30:57.150386','2019-12-27 04:08:16.947933',0,0,12,30);
INSERT INTO "oneid_meta_groupperm" VALUES(788,'8f32382353cf4fe3b422902868781eb0',0,1,'2019-12-27 11:30:57.343616','2019-12-27 04:08:16.949885',0,0,12,31);
INSERT INTO "oneid_meta_groupperm" VALUES(789,'43c13841006e4f668fa4acd1798e4406',0,1,'2019-12-27 11:30:57.531160','2019-12-27 04:08:16.951886',0,0,12,32);
INSERT INTO "oneid_meta_groupperm" VALUES(790,'9bc793c005664667954c2f96fd38ed67',0,1,'2019-12-27 11:30:57.704601','2019-12-27 04:08:16.954085',0,0,12,33);
INSERT INTO "oneid_meta_groupperm" VALUES(791,'b8fd8928dc2c466fbe30e111c36adeeb',0,1,'2019-12-27 11:30:57.888943','2019-12-27 04:08:16.956057',0,0,12,34);
INSERT INTO "oneid_meta_groupperm" VALUES(792,'2241857260eb4e899c0ec00f9c6c70d7',0,1,'2019-12-27 11:30:58.252016','2019-12-27 04:08:16.958235',0,0,12,35);
INSERT INTO "oneid_meta_groupperm" VALUES(793,'b4927fad0d564dde82c29c678f2b8b96',0,1,'2019-12-27 11:30:58.422724','2019-12-27 04:08:16.960199',0,0,12,36);
INSERT INTO "oneid_meta_groupperm" VALUES(794,'bab1092bcd5f4881a8a6f03e1339e655',0,1,'2019-12-27 11:30:58.594771','2019-12-27 04:08:16.962253',0,0,12,37);
INSERT INTO "oneid_meta_groupperm" VALUES(795,'4e6a24cea24e4cb49c4b1c0f81cfe3f8',0,1,'2019-12-27 11:30:58.761221','2019-12-27 04:08:16.964185',0,0,12,38);
INSERT INTO "oneid_meta_groupperm" VALUES(796,'bf24c5307dec48958cf2af1c6a310a2e',0,1,'2019-12-27 11:30:58.934333','2019-12-27 04:08:16.966118',0,0,12,39);
INSERT INTO "oneid_meta_groupperm" VALUES(797,'e0e077c484fc42a897d6b54c6557c3a3',0,1,'2019-12-27 11:30:59.266507','2019-12-27 04:08:16.968310',0,0,12,40);
INSERT INTO "oneid_meta_groupperm" VALUES(798,'014db2aaa0d6468ea0bc617cb8490cea',0,1,'2019-12-27 11:30:59.595864','2019-12-27 04:08:16.970560',0,0,12,41);
INSERT INTO "oneid_meta_groupperm" VALUES(799,'4e6d133dba54472bb7eda47ec43fb1d5',0,1,'2019-12-27 11:30:59.931753','2019-12-27 04:08:16.972640',0,0,12,42);
INSERT INTO "oneid_meta_groupperm" VALUES(800,'d48ac19d527f4a8481cdf528c2c6b7de',0,1,'2019-12-27 11:31:00.100780','2019-12-27 04:08:16.974585',0,0,12,43);
INSERT INTO "oneid_meta_groupperm" VALUES(801,'6ba484fff0164f5787b798be80f09d30',0,1,'2019-12-27 11:30:50.502508','2019-12-27 04:08:16.976557',0,0,12,44);
INSERT INTO "oneid_meta_groupperm" VALUES(802,'9e027093ba684f09ac3a922437460eb3',0,1,'2019-12-27 11:31:00.779242','2019-12-27 04:08:16.978624',0,0,12,45);
INSERT INTO "oneid_meta_groupperm" VALUES(803,'9c1e06c35ed344c0ac7759ccaf22f1b6',0,1,'2019-12-27 11:30:50.674581','2019-12-27 04:08:16.980771',0,0,12,46);
INSERT INTO "oneid_meta_groupperm" VALUES(804,'93c526c44cf54d70a83798c3d9ca1519',0,1,'2019-12-27 11:31:00.285789','2019-12-27 04:08:16.982733',0,0,12,47);
INSERT INTO "oneid_meta_groupperm" VALUES(805,'0b52a3eb6e4d46d9ac376ab1edd1dfda',0,1,'2019-12-27 11:31:00.452094','2019-12-27 04:08:16.984664',0,0,12,48);
INSERT INTO "oneid_meta_groupperm" VALUES(806,'9545b1857ace42b3bc66026775387a03',0,1,'2019-12-27 11:31:00.615181','2019-12-27 04:08:16.986860',0,0,12,49);
INSERT INTO "oneid_meta_groupperm" VALUES(807,'7c758bfa499640dca12cbfd048eadb3f',0,1,'2019-12-27 11:31:00.947932','2019-12-27 04:08:16.988825',0,0,12,50);
INSERT INTO "oneid_meta_groupperm" VALUES(808,'ce9d5a312f044a59a846aa3775a7d793',0,1,'2019-12-27 11:31:01.112264','2019-12-27 04:08:16.990923',0,0,12,51);
INSERT INTO "oneid_meta_groupperm" VALUES(809,'ffaadc642bcd4060a93bf4f8799fe80b',0,1,'2019-12-27 11:31:01.275179','2019-12-27 04:08:16.992974',0,0,12,52);
INSERT INTO "oneid_meta_groupperm" VALUES(810,'430438ffda0c439aa7be54e2b2cf282a',0,1,'2019-12-27 11:30:50.840915','2019-12-27 04:08:16.995212',0,0,12,53);
INSERT INTO "oneid_meta_groupperm" VALUES(811,'506f2bf36e1544f9aa7a455baf1a23d2',0,1,'2019-12-27 11:30:50.035844','2019-12-27 04:08:17.070874',0,0,13,1);
INSERT INTO "oneid_meta_groupperm" VALUES(812,'898ee57e85bf413cb2a1f6bd12c6903c',0,1,'2019-12-27 11:30:50.177240','2019-12-27 04:08:17.073162',0,0,13,2);
INSERT INTO "oneid_meta_groupperm" VALUES(813,'b6fe172f523d4d8aa31acf91ae0f6dfc',0,1,'2019-12-27 11:31:01.607786','2019-12-27 04:08:17.075323',0,0,13,3);
INSERT INTO "oneid_meta_groupperm" VALUES(814,'f536aee1226845b5a32c6db40959e7e4',0,1,'2019-12-27 11:30:50.343023','2019-12-27 04:08:17.077431',0,0,13,4);
INSERT INTO "oneid_meta_groupperm" VALUES(815,'8dc7f0f3bf554a54bf4a6edbdc65b1b7',0,1,'2019-12-27 11:30:53.356756','2019-12-27 04:08:17.079788',0,0,13,5);
INSERT INTO "oneid_meta_groupperm" VALUES(816,'450659bd5f0a4b54a65829e66a86e850',0,1,'2019-12-27 11:30:56.733235','2019-12-27 04:08:17.081978',0,0,13,6);
INSERT INTO "oneid_meta_groupperm" VALUES(817,'a4b6359510d64825a9b93ea8f3314bdc',0,1,'2019-12-27 11:30:53.551067','2019-12-27 04:08:17.084197',0,0,13,7);
INSERT INTO "oneid_meta_groupperm" VALUES(818,'4f7daeae613f44e1abb23157fb151fb4',0,1,'2019-12-27 11:30:53.725650','2019-12-27 04:08:17.086835',0,0,13,8);
INSERT INTO "oneid_meta_groupperm" VALUES(819,'c887442ac06441ee8bc48f16fff1067c',0,1,'2019-12-27 11:30:53.902260','2019-12-27 04:08:17.089019',0,0,13,9);
INSERT INTO "oneid_meta_groupperm" VALUES(820,'5829590b49af478d84014179965683d5',0,1,'2019-12-27 11:30:54.073561','2019-12-27 04:08:17.090946',0,0,13,10);
INSERT INTO "oneid_meta_groupperm" VALUES(821,'bbc8d65b4895423d9dc4281bcc3948f8',0,1,'2019-12-27 11:30:54.240365','2019-12-27 04:08:17.092893',0,0,13,11);
INSERT INTO "oneid_meta_groupperm" VALUES(822,'84021cca80c34750b280a6fa36e5660c',0,1,'2019-12-27 11:30:54.417645','2019-12-27 04:08:17.095556',0,0,13,12);
INSERT INTO "oneid_meta_groupperm" VALUES(823,'40d35f68f2234e96badc2d57fac7b96d',0,1,'2019-12-27 11:30:54.585955','2019-12-27 04:08:17.097609',0,0,13,13);
INSERT INTO "oneid_meta_groupperm" VALUES(824,'f657ba915dc3458392655aa69635116b',0,1,'2019-12-27 11:30:55.621764','2019-12-27 04:08:17.099642',0,0,13,14);
INSERT INTO "oneid_meta_groupperm" VALUES(825,'fdbad42db6184df6aadfef0b59f00c73',0,1,'2019-12-27 11:30:55.968031','2019-12-27 04:08:17.101699',0,0,13,15);
INSERT INTO "oneid_meta_groupperm" VALUES(826,'5fa2c2b1a1984049835418473a4cbbfa',0,1,'2019-12-27 11:30:56.352035','2019-12-27 04:08:17.103668',0,0,13,16);
INSERT INTO "oneid_meta_groupperm" VALUES(827,'dbcc13f5476941858e7eb5df2737feeb',0,1,'2019-12-27 11:30:54.763202','2019-12-27 04:08:17.106149',0,0,13,17);
INSERT INTO "oneid_meta_groupperm" VALUES(828,'81698060cd164ea3b6b750fbf4de77ec',0,1,'2019-12-27 11:30:54.941642','2019-12-27 04:08:17.108256',0,0,13,18);
INSERT INTO "oneid_meta_groupperm" VALUES(829,'dc8ab9085f484624ab03e7fc0990f123',0,1,'2019-12-27 11:30:55.120089','2019-12-27 04:08:17.110203',0,0,13,19);
INSERT INTO "oneid_meta_groupperm" VALUES(830,'7b78b91c8d2a4b159fe6b57aebbcd0c6',0,1,'2019-12-27 11:30:55.285747','2019-12-27 04:08:17.112733',0,0,13,20);
INSERT INTO "oneid_meta_groupperm" VALUES(831,'827e1db8e7794a8887a87259110d2b49',0,1,'2019-12-27 11:30:55.455825','2019-12-27 04:08:17.114746',0,0,13,21);
INSERT INTO "oneid_meta_groupperm" VALUES(832,'e450380717a348b891edc6ae00def02e',0,1,'2019-12-27 11:30:56.957793','2019-12-27 04:08:17.116928',0,0,13,22);
INSERT INTO "oneid_meta_groupperm" VALUES(833,'bbc02f5a09d341ccb73d48a2005e06a4',0,1,'2019-12-27 11:30:58.079665','2019-12-27 04:08:17.118887',0,0,13,23);
INSERT INTO "oneid_meta_groupperm" VALUES(834,'6a551b9b72134410a88c36ebbfeaec12',0,1,'2019-12-27 11:30:59.110060','2019-12-27 04:08:17.121210',0,0,13,24);
INSERT INTO "oneid_meta_groupperm" VALUES(835,'1aa0b8e642064dd3a960b55f73c9341a',0,1,'2019-12-27 11:30:59.438793','2019-12-27 04:08:17.123499',0,0,13,25);
INSERT INTO "oneid_meta_groupperm" VALUES(836,'6f63d78c16114c989aec7a28c75f4a12',0,1,'2019-12-27 11:30:59.769627','2019-12-27 04:08:17.126028',0,0,13,26);
INSERT INTO "oneid_meta_groupperm" VALUES(837,'5ab4e67c2eb044708b8f8a748d7df24a',0,1,'2019-12-27 11:30:55.793534','2019-12-27 04:08:17.128767',0,0,13,27);
INSERT INTO "oneid_meta_groupperm" VALUES(838,'7b33e1b2b63a418eab4b6a459305e6a8',0,1,'2019-12-27 11:30:56.146830','2019-12-27 04:08:17.130823',0,0,13,28);
INSERT INTO "oneid_meta_groupperm" VALUES(839,'1923f21b34394c4e8b8bd3bd563728fe',0,1,'2019-12-27 11:30:56.543372','2019-12-27 04:08:17.132792',0,0,13,29);
INSERT INTO "oneid_meta_groupperm" VALUES(840,'d7748dbb6b4f49aba0697c209e6bde0a',0,1,'2019-12-27 11:30:57.160874','2019-12-27 04:08:17.134900',0,0,13,30);
INSERT INTO "oneid_meta_groupperm" VALUES(841,'933c69368d194784951c0c14babb52fc',0,1,'2019-12-27 11:30:57.351518','2019-12-27 04:08:17.136906',0,0,13,31);
INSERT INTO "oneid_meta_groupperm" VALUES(842,'35989ffcdfda49f6ac10f9b5cdd83abd',0,1,'2019-12-27 11:30:57.540086','2019-12-27 04:08:17.139548',0,0,13,32);
INSERT INTO "oneid_meta_groupperm" VALUES(843,'f6ad36ae506a45faa6844e81b0722750',0,1,'2019-12-27 11:30:57.712485','2019-12-27 04:08:17.141619',0,0,13,33);
INSERT INTO "oneid_meta_groupperm" VALUES(844,'b9d8284d1fa0437587ac84b6007eae54',0,1,'2019-12-27 11:30:57.898473','2019-12-27 04:08:17.143649',0,0,13,34);
INSERT INTO "oneid_meta_groupperm" VALUES(845,'c7fc4653768e4c3fa74eb0c7f57f6a4b',0,1,'2019-12-27 11:30:58.260062','2019-12-27 04:08:17.146177',0,0,13,35);
INSERT INTO "oneid_meta_groupperm" VALUES(846,'d141717406be4019b7145c5b8f37ff5d',0,1,'2019-12-27 11:30:58.430916','2019-12-27 04:08:17.148185',0,0,13,36);
INSERT INTO "oneid_meta_groupperm" VALUES(847,'ffc1499766524fd5aa0cff2914f4ac48',0,1,'2019-12-27 11:30:58.602834','2019-12-27 04:08:17.150367',0,0,13,37);
INSERT INTO "oneid_meta_groupperm" VALUES(848,'0725f78914a14dda86618a32d92dbdd8',0,1,'2019-12-27 11:30:58.768596','2019-12-27 04:08:17.152423',0,0,13,38);
INSERT INTO "oneid_meta_groupperm" VALUES(849,'03b0a70072c14d7fb2047233c6e459d8',0,1,'2019-12-27 11:30:58.942280','2019-12-27 04:08:17.154618',0,0,13,39);
INSERT INTO "oneid_meta_groupperm" VALUES(850,'0470ea0a1a644cf1ac8ee4f8ee9272b1',0,1,'2019-12-27 11:30:59.273920','2019-12-27 04:08:17.156927',0,0,13,40);
INSERT INTO "oneid_meta_groupperm" VALUES(851,'0e97b39786014df8b2dfd34c3b346d1b',0,1,'2019-12-27 11:30:59.604109','2019-12-27 04:08:17.158907',0,0,13,41);
INSERT INTO "oneid_meta_groupperm" VALUES(852,'7862286c4ed341d39599e4bc837c3b4a',0,1,'2019-12-27 11:30:59.939246','2019-12-27 04:08:17.161716',0,0,13,42);
INSERT INTO "oneid_meta_groupperm" VALUES(853,'90a4b961d10149e984d29f5a0c96b937',0,1,'2019-12-27 11:31:00.108536','2019-12-27 04:08:17.164339',0,0,13,43);
INSERT INTO "oneid_meta_groupperm" VALUES(854,'0512dc51b63c4eaf915b678cf7689ca7',0,1,'2019-12-27 11:30:50.511301','2019-12-27 04:08:17.166330',0,0,13,44);
INSERT INTO "oneid_meta_groupperm" VALUES(855,'f9a6b092361d4e9aa1cd09955d3b9c87',0,1,'2019-12-27 11:31:00.787050','2019-12-27 04:08:17.168311',0,0,13,45);
INSERT INTO "oneid_meta_groupperm" VALUES(856,'ca0328fa047043fdbb9ebeb65ace6e5e',0,1,'2019-12-27 11:30:50.682586','2019-12-27 04:08:17.170749',0,0,13,46);
INSERT INTO "oneid_meta_groupperm" VALUES(857,'9decefc9f6854514af7455fa9de65072',0,1,'2019-12-27 11:31:00.294102','2019-12-27 04:08:17.172828',0,0,13,47);
INSERT INTO "oneid_meta_groupperm" VALUES(858,'ef5d286b078b4380a38bc680ad036fea',0,1,'2019-12-27 11:31:00.459827','2019-12-27 04:08:17.174805',0,0,13,48);
INSERT INTO "oneid_meta_groupperm" VALUES(859,'7a2173d2a63c4134907e484608f991b3',0,1,'2019-12-27 11:31:00.623231','2019-12-27 04:08:17.176751',0,0,13,49);
INSERT INTO "oneid_meta_groupperm" VALUES(860,'925b771ea53f4ab089791328649f6c3a',0,1,'2019-12-27 11:31:00.955407','2019-12-27 04:08:17.179638',0,0,13,50);
INSERT INTO "oneid_meta_groupperm" VALUES(861,'1887c78497f54bd6a3f9b7a9bd6941b8',0,1,'2019-12-27 11:31:01.120119','2019-12-27 04:08:17.181849',0,0,13,51);
INSERT INTO "oneid_meta_groupperm" VALUES(862,'b5654cbf96a447f492543da1f2918d3d',0,1,'2019-12-27 11:31:01.282892','2019-12-27 04:08:17.184180',0,0,13,52);
INSERT INTO "oneid_meta_groupperm" VALUES(863,'42367ef72c504dad8576b3ea70bea853',0,1,'2019-12-27 11:30:50.849304','2019-12-27 04:08:17.186927',0,0,13,53);
INSERT INTO "oneid_meta_groupperm" VALUES(864,'de9a3dd27e974a969487ddbc344cfe60',0,1,'2019-12-27 11:30:51.027309','2019-12-27 04:08:17.188999',0,0,13,54);
INSERT INTO "oneid_meta_groupperm" VALUES(865,'f46a99a33bf14d7dbb2dd7dabbbaaf44',0,1,'2019-12-27 11:30:50.040538','2019-12-27 04:08:17.294355',0,0,14,1);
INSERT INTO "oneid_meta_groupperm" VALUES(866,'f93acedd102f47deae44990a7de44622',0,1,'2019-12-27 11:30:50.185109','2019-12-27 04:08:17.298449',0,0,14,2);
INSERT INTO "oneid_meta_groupperm" VALUES(867,'de10698ba5654ecbb49eb8fef301bd33',0,1,'2019-12-27 11:31:01.615510','2019-12-27 04:08:17.300687',0,0,14,3);
INSERT INTO "oneid_meta_groupperm" VALUES(868,'8b9c21b23da646d4a3bfb34dda27eb75',0,1,'2019-12-27 11:30:50.351157','2019-12-27 04:08:17.303051',0,0,14,4);
INSERT INTO "oneid_meta_groupperm" VALUES(869,'b9762511bc634043af7cf15d49949ffd',0,1,'2019-12-27 11:30:53.364764','2019-12-27 04:08:17.305339',0,0,14,5);
INSERT INTO "oneid_meta_groupperm" VALUES(870,'ea086eafcc4e4ea28061a0289424a99b',0,1,'2019-12-27 11:30:56.742828','2019-12-27 04:08:17.308429',0,0,14,6);
INSERT INTO "oneid_meta_groupperm" VALUES(871,'20479baa010b48baa446790e108f5f6a',0,1,'2019-12-27 11:30:53.558982','2019-12-27 04:08:17.310823',0,0,14,7);
INSERT INTO "oneid_meta_groupperm" VALUES(872,'6b76b1516ebe437bb0d21271e85523b4',0,1,'2019-12-27 11:30:53.733930','2019-12-27 04:08:17.313394',0,0,14,8);
INSERT INTO "oneid_meta_groupperm" VALUES(873,'270b1eabb53f4d8a909cd54c312396e9',0,1,'2019-12-27 11:30:53.910616','2019-12-27 04:08:17.316042',0,0,14,9);
INSERT INTO "oneid_meta_groupperm" VALUES(874,'ccd3199f9d004b7290f18e2d94a2cd56',0,1,'2019-12-27 11:30:54.081260','2019-12-27 04:08:17.318452',0,0,14,10);
INSERT INTO "oneid_meta_groupperm" VALUES(875,'4eb84dad178940c2a98a254e06328bf4',0,1,'2019-12-27 11:30:54.248258','2019-12-27 04:08:17.321021',0,0,14,11);
INSERT INTO "oneid_meta_groupperm" VALUES(876,'98d9b91914904f2dae527053c31e99bd',0,1,'2019-12-27 11:30:54.425406','2019-12-27 04:08:17.323450',0,0,14,12);
INSERT INTO "oneid_meta_groupperm" VALUES(877,'2a8359b4b2a8469b9b1264f771fc62ad',0,1,'2019-12-27 11:30:54.593711','2019-12-27 04:08:17.325815',0,0,14,13);
INSERT INTO "oneid_meta_groupperm" VALUES(878,'307efb87ac134ab7947c0f9bafdaa192',0,1,'2019-12-27 11:30:55.631602','2019-12-27 04:08:17.328792',0,0,14,14);
INSERT INTO "oneid_meta_groupperm" VALUES(879,'d1da41257d094ff19a017f98ddae5668',0,1,'2019-12-27 11:30:55.976301','2019-12-27 04:08:17.331573',0,0,14,15);
INSERT INTO "oneid_meta_groupperm" VALUES(880,'40f11e7032be49a19ce7578052703341',0,1,'2019-12-27 11:30:56.362156','2019-12-27 04:08:17.334716',0,0,14,16);
INSERT INTO "oneid_meta_groupperm" VALUES(881,'1071771ae11c4aed8f71b3001111679b',0,1,'2019-12-27 11:30:54.771677','2019-12-27 04:08:17.337167',0,0,14,17);
INSERT INTO "oneid_meta_groupperm" VALUES(882,'d6aa08a9c7724c2baa4d405114868328',0,1,'2019-12-27 11:30:54.949871','2019-12-27 04:08:17.339628',0,0,14,18);
INSERT INTO "oneid_meta_groupperm" VALUES(883,'96849a6caf1947608ac915a219e74b0b',0,1,'2019-12-27 11:30:55.127942','2019-12-27 04:08:17.342246',0,0,14,19);
INSERT INTO "oneid_meta_groupperm" VALUES(884,'4151ca229c524074aa204d22f2be7716',0,1,'2019-12-27 11:30:55.294106','2019-12-27 04:08:17.344643',0,0,14,20);
INSERT INTO "oneid_meta_groupperm" VALUES(885,'8c1bc29223774701baf9b6f03f354c85',0,1,'2019-12-27 11:30:55.463718','2019-12-27 04:08:17.347337',0,0,14,21);
INSERT INTO "oneid_meta_groupperm" VALUES(886,'a7969aa4f5f74cadb3a11ad180ed23f7',0,1,'2019-12-27 11:30:56.965377','2019-12-27 04:08:17.350023',0,0,14,22);
INSERT INTO "oneid_meta_groupperm" VALUES(887,'c2b3602d9846481f990f2041bcdcb5a8',0,1,'2019-12-27 11:30:58.087776','2019-12-27 04:08:17.352959',0,0,14,23);
INSERT INTO "oneid_meta_groupperm" VALUES(888,'73e02b909a9e405fa6070e7f8894541f',0,1,'2019-12-27 11:30:59.117459','2019-12-27 04:08:17.355609',0,0,14,24);
INSERT INTO "oneid_meta_groupperm" VALUES(889,'fe5e65891eda4a5786f7a21f12763129',0,1,'2019-12-27 11:30:59.446361','2019-12-27 04:08:17.358372',0,0,14,25);
INSERT INTO "oneid_meta_groupperm" VALUES(890,'e04958cba22549cf9cf1b19e4a5a2035',0,1,'2019-12-27 11:30:59.777279','2019-12-27 04:08:17.363916',0,0,14,26);
INSERT INTO "oneid_meta_groupperm" VALUES(891,'a62671fe137c4c16a7c3bb839ad0e78b',0,1,'2019-12-27 11:30:55.801514','2019-12-27 04:08:17.368534',0,0,14,27);
INSERT INTO "oneid_meta_groupperm" VALUES(892,'b9617bcdd2c94ed9a6a687a099582614',0,1,'2019-12-27 11:30:56.156433','2019-12-27 04:08:17.370726',0,0,14,28);
INSERT INTO "oneid_meta_groupperm" VALUES(893,'5706079b998b4258b23374f16e0a922b',0,1,'2019-12-27 11:30:56.551177','2019-12-27 04:08:17.372852',0,0,14,29);
INSERT INTO "oneid_meta_groupperm" VALUES(894,'cf24b24f7d1147c8977072bdd7d7878c',0,1,'2019-12-27 11:30:57.168915','2019-12-27 04:08:17.375427',0,0,14,30);
INSERT INTO "oneid_meta_groupperm" VALUES(895,'f152c15c99a64076bef8802d365de12a',0,1,'2019-12-27 11:30:57.362287','2019-12-27 04:08:17.378088',0,0,14,31);
INSERT INTO "oneid_meta_groupperm" VALUES(896,'69625eb00ff349bfba7c38a2c248fb39',0,1,'2019-12-27 11:30:57.547933','2019-12-27 04:08:17.385257',0,0,14,32);
INSERT INTO "oneid_meta_groupperm" VALUES(897,'13257765ef8041a8ba3ac1d69264a0c9',0,1,'2019-12-27 11:30:57.721850','2019-12-27 04:08:17.389313',0,0,14,33);
INSERT INTO "oneid_meta_groupperm" VALUES(898,'7021d15079a64026a4699f0e72f3e0ba',0,1,'2019-12-27 11:30:57.907019','2019-12-27 04:08:17.391730',0,0,14,34);
INSERT INTO "oneid_meta_groupperm" VALUES(899,'1cc955e1ff1c430f866cfc7e732f68cf',0,1,'2019-12-27 11:30:58.267697','2019-12-27 04:08:17.394717',0,0,14,35);
INSERT INTO "oneid_meta_groupperm" VALUES(900,'7a4ff3d8d123413fb92af05202bf7e9c',0,1,'2019-12-27 11:30:58.439115','2019-12-27 04:08:17.401373',0,0,14,36);
INSERT INTO "oneid_meta_groupperm" VALUES(901,'b64c9d38d0a64197bdf28c760b62fa82',0,1,'2019-12-27 11:30:58.610523','2019-12-27 04:08:17.405085',0,0,14,37);
INSERT INTO "oneid_meta_groupperm" VALUES(902,'acde092fe22540b184e4e6cd22f8f570',0,1,'2019-12-27 11:30:58.778015','2019-12-27 04:08:17.410277',0,0,14,38);
INSERT INTO "oneid_meta_groupperm" VALUES(903,'ba66f916280542c3bc13a142c14a4397',0,1,'2019-12-27 11:30:58.949853','2019-12-27 04:08:17.418842',0,0,14,39);
INSERT INTO "oneid_meta_groupperm" VALUES(904,'d918c896ff614702b28e449f6a53ddb6',0,1,'2019-12-27 11:30:59.281937','2019-12-27 04:08:17.423055',0,0,14,40);
INSERT INTO "oneid_meta_groupperm" VALUES(905,'21f3c78811ba4d0bb88d5fcec9da1cc3',0,1,'2019-12-27 11:30:59.611993','2019-12-27 04:08:17.425448',0,0,14,41);
INSERT INTO "oneid_meta_groupperm" VALUES(906,'bd5a40ca3f054a469efa565bd3f7717c',0,1,'2019-12-27 11:30:59.947357','2019-12-27 04:08:17.431009',0,0,14,42);
INSERT INTO "oneid_meta_groupperm" VALUES(907,'4fcae83e32ad45c9a82a55b3fd5914ee',0,1,'2019-12-27 11:31:00.116782','2019-12-27 04:08:17.434347',0,0,14,43);
INSERT INTO "oneid_meta_groupperm" VALUES(908,'3836df875d8940b4a2fae935bd2f3506',0,1,'2019-12-27 11:30:50.525135','2019-12-27 04:08:17.437014',0,0,14,44);
INSERT INTO "oneid_meta_groupperm" VALUES(909,'3562da8fd60b4a2f8eef82175d88d131',0,1,'2019-12-27 11:31:00.794760','2019-12-27 04:08:17.440599',0,0,14,45);
INSERT INTO "oneid_meta_groupperm" VALUES(910,'d55b9d726f8445a4b7f80226c730d85a',0,1,'2019-12-27 11:30:50.690123','2019-12-27 04:08:17.442864',0,0,14,46);
INSERT INTO "oneid_meta_groupperm" VALUES(911,'ef81691d2b3542c6acc35682f8d0955a',0,1,'2019-12-27 11:31:00.302231','2019-12-27 04:08:17.447270',0,0,14,47);
INSERT INTO "oneid_meta_groupperm" VALUES(912,'a6ab888f307549cbb5640cc06bb7ed44',0,1,'2019-12-27 11:31:00.467808','2019-12-27 04:08:17.450388',0,0,14,48);
INSERT INTO "oneid_meta_groupperm" VALUES(913,'560550fe99fe4be99cd8729fe8894b4d',0,1,'2019-12-27 11:31:00.630663','2019-12-27 04:08:17.455827',0,0,14,49);
INSERT INTO "oneid_meta_groupperm" VALUES(914,'80f81a11eea242c98754d925faa4d17b',0,1,'2019-12-27 11:31:00.963414','2019-12-27 04:08:17.458356',0,0,14,50);
INSERT INTO "oneid_meta_groupperm" VALUES(915,'c8b78deefc5d4df9adc1a20f84593d8a',0,1,'2019-12-27 11:31:01.127612','2019-12-27 04:08:17.462213',0,0,14,51);
INSERT INTO "oneid_meta_groupperm" VALUES(916,'7c13fa68b6bd4fff85eb1479cf419695',0,1,'2019-12-27 11:31:01.290321','2019-12-27 04:08:17.466390',0,0,14,52);
INSERT INTO "oneid_meta_groupperm" VALUES(917,'8d1a79e5f27a47cc888f33b82cf78cb5',0,1,'2019-12-27 11:30:50.859016','2019-12-27 04:08:17.469177',0,0,14,53);
INSERT INTO "oneid_meta_groupperm" VALUES(918,'b9562242bd2d4cd7b7555ce12b7e8595',0,1,'2019-12-27 11:30:51.035863','2019-12-27 04:08:17.471701',0,0,14,54);
INSERT INTO "oneid_meta_groupperm" VALUES(919,'b0ec2401658a42faa50bf0fa245be459',0,1,'2019-12-27 11:30:51.206279','2019-12-27 04:08:17.474253',0,0,14,55);
INSERT INTO "oneid_meta_groupperm" VALUES(920,'9407c1d1e221413a8786c308a9919a68',0,1,'2019-12-27 11:30:50.045432','2019-12-27 04:08:17.576818',0,0,15,1);
INSERT INTO "oneid_meta_groupperm" VALUES(921,'6c8876d964fd4237bb91b824878ccfc9',0,1,'2019-12-27 11:30:50.193096','2019-12-27 04:08:17.581364',0,0,15,2);
INSERT INTO "oneid_meta_groupperm" VALUES(922,'b1afe4982d774f9097d97ebde7baf11c',0,1,'2019-12-27 11:31:01.623248','2019-12-27 04:08:17.583669',0,0,15,3);
INSERT INTO "oneid_meta_groupperm" VALUES(923,'13ae3b33b16745dd872847761b007497',0,1,'2019-12-27 11:30:50.359085','2019-12-27 04:08:17.585621',0,0,15,4);
INSERT INTO "oneid_meta_groupperm" VALUES(924,'7a2214da5920481ea7fcba30de1912cb',0,1,'2019-12-27 11:30:53.384435','2019-12-27 04:08:17.587705',0,0,15,5);
INSERT INTO "oneid_meta_groupperm" VALUES(925,'be0a6177fef6475d9b394d59e3cc6d20',0,1,'2019-12-27 11:30:56.770600','2019-12-27 04:08:17.589958',0,0,15,6);
INSERT INTO "oneid_meta_groupperm" VALUES(926,'2560af99015147c49151c72d4fd76356',0,1,'2019-12-27 11:30:53.567562','2019-12-27 04:08:17.592084',0,0,15,7);
INSERT INTO "oneid_meta_groupperm" VALUES(927,'eb78586de20c40fba61db263f0a37df6',0,1,'2019-12-27 11:30:53.742225','2019-12-27 04:08:17.594509',0,0,15,8);
INSERT INTO "oneid_meta_groupperm" VALUES(928,'b20377cf6af74db3952658b61ec65609',0,1,'2019-12-27 11:30:53.918900','2019-12-27 04:08:17.598043',0,0,15,9);
INSERT INTO "oneid_meta_groupperm" VALUES(929,'3780294e3d414bab837d63e5ba4b4a7e',0,1,'2019-12-27 11:30:54.089248','2019-12-27 04:08:17.600605',0,0,15,10);
INSERT INTO "oneid_meta_groupperm" VALUES(930,'216785c4342e41ed91c5cc80140780f3',0,1,'2019-12-27 11:30:54.256569','2019-12-27 04:08:17.602650',0,0,15,11);
INSERT INTO "oneid_meta_groupperm" VALUES(931,'b841ba13d4d446fa823f49051c7ea880',0,1,'2019-12-27 11:30:54.433679','2019-12-27 04:08:17.604798',0,0,15,12);
INSERT INTO "oneid_meta_groupperm" VALUES(932,'d1d32b14ad284bf49e038803daba925d',0,1,'2019-12-27 11:30:54.601385','2019-12-27 04:08:17.606784',0,0,15,13);
INSERT INTO "oneid_meta_groupperm" VALUES(933,'889ed7053a2f4be59ccc40dc69f7e982',0,1,'2019-12-27 11:30:55.640707','2019-12-27 04:08:17.608854',0,0,15,14);
INSERT INTO "oneid_meta_groupperm" VALUES(934,'64e8ae118bc14c879a0c29938f735603',0,1,'2019-12-27 11:30:55.984211','2019-12-27 04:08:17.611368',0,0,15,15);
INSERT INTO "oneid_meta_groupperm" VALUES(935,'660195739503450a85df9deef78d3605',0,1,'2019-12-27 11:30:56.370313','2019-12-27 04:08:17.615102',0,0,15,16);
INSERT INTO "oneid_meta_groupperm" VALUES(936,'a82d95c9a242468c92276a26526616ba',0,1,'2019-12-27 11:30:54.779792','2019-12-27 04:08:17.617445',0,0,15,17);
INSERT INTO "oneid_meta_groupperm" VALUES(937,'7909dd73ab424b07944bd37fe544fb80',0,1,'2019-12-27 11:30:54.957977','2019-12-27 04:08:17.619479',0,0,15,18);
INSERT INTO "oneid_meta_groupperm" VALUES(938,'66df142bc91f4c688e630ca09d99d944',0,1,'2019-12-27 11:30:55.135688','2019-12-27 04:08:17.621568',0,0,15,19);
INSERT INTO "oneid_meta_groupperm" VALUES(939,'6c50bc5fa8b44ed59101016ece2736ed',0,1,'2019-12-27 11:30:55.302111','2019-12-27 04:08:17.623814',0,0,15,20);
INSERT INTO "oneid_meta_groupperm" VALUES(940,'281fd575d0a94e78944b5165cd87d883',0,1,'2019-12-27 11:30:55.471208','2019-12-27 04:08:17.625906',0,0,15,21);
INSERT INTO "oneid_meta_groupperm" VALUES(941,'aa6524e114e14197ad99f88f37ea6d54',0,1,'2019-12-27 11:30:56.974779','2019-12-27 04:08:17.629820',0,0,15,22);
INSERT INTO "oneid_meta_groupperm" VALUES(942,'faee5acbb65c47938708e454dc62fd43',0,1,'2019-12-27 11:30:58.097339','2019-12-27 04:08:17.632494',0,0,15,23);
INSERT INTO "oneid_meta_groupperm" VALUES(943,'94c9e7fb348343f3bd52bfe25898ade9',0,1,'2019-12-27 11:30:59.125384','2019-12-27 04:08:17.634743',0,0,15,24);
INSERT INTO "oneid_meta_groupperm" VALUES(944,'df9865c559c24895ab2aab9dc8a1fca6',0,1,'2019-12-27 11:30:59.454422','2019-12-27 04:08:17.636713',0,0,15,25);
INSERT INTO "oneid_meta_groupperm" VALUES(945,'19b71f20da004caf894b125ba2ca8e3f',0,1,'2019-12-27 11:30:59.785350','2019-12-27 04:08:17.638710',0,0,15,26);
INSERT INTO "oneid_meta_groupperm" VALUES(946,'873fbb6306f54986918d95109db144c6',0,1,'2019-12-27 11:30:55.809262','2019-12-27 04:08:17.640761',0,0,15,27);
INSERT INTO "oneid_meta_groupperm" VALUES(947,'0e7ed4ce28ff4cfa8d96aa1790c08a38',0,1,'2019-12-27 11:30:56.166830','2019-12-27 04:08:17.643029',0,0,15,28);
INSERT INTO "oneid_meta_groupperm" VALUES(948,'1c175e4f37144d3da3a9155a59b1cba3',0,1,'2019-12-27 11:30:56.561393','2019-12-27 04:08:17.646388',0,0,15,29);
INSERT INTO "oneid_meta_groupperm" VALUES(949,'d0399685270d400297063f072dcaaea7',0,1,'2019-12-27 11:30:57.178257','2019-12-27 04:08:17.649131',0,0,15,30);
INSERT INTO "oneid_meta_groupperm" VALUES(950,'041dcdce6ea0456aa2bc7995b18700aa',0,1,'2019-12-27 11:30:57.370702','2019-12-27 04:08:17.651120',0,0,15,31);
INSERT INTO "oneid_meta_groupperm" VALUES(951,'73f41e03fca94ff49ae5c21596365aa0',0,1,'2019-12-27 11:30:57.556519','2019-12-27 04:08:17.653155',0,0,15,32);
INSERT INTO "oneid_meta_groupperm" VALUES(952,'23887a6e79ea4e51934a378706035505',0,1,'2019-12-27 11:30:57.732393','2019-12-27 04:08:17.655243',0,0,15,33);
INSERT INTO "oneid_meta_groupperm" VALUES(953,'c072e60c34ac418c97c07bd3da9c678a',0,1,'2019-12-27 11:30:57.915070','2019-12-27 04:08:17.657322',0,0,15,34);
INSERT INTO "oneid_meta_groupperm" VALUES(954,'0aee43581e9147e288b3a2f37efffca3',0,1,'2019-12-27 11:30:58.275521','2019-12-27 04:08:17.659249',0,0,15,35);
INSERT INTO "oneid_meta_groupperm" VALUES(955,'4682272c3564456899c591914c857969',0,1,'2019-12-27 11:30:58.447540','2019-12-27 04:08:17.661304',0,0,15,36);
INSERT INTO "oneid_meta_groupperm" VALUES(956,'983f6a9905f94795aa301f0268d0d99e',0,1,'2019-12-27 11:30:58.618449','2019-12-27 04:08:17.665171',0,0,15,37);
INSERT INTO "oneid_meta_groupperm" VALUES(957,'05f5fbac43954b15b37949df21693729',0,1,'2019-12-27 11:30:58.786381','2019-12-27 04:08:17.667470',0,0,15,38);
INSERT INTO "oneid_meta_groupperm" VALUES(958,'1cb52e8818b841b4a4cea3ef582b767e',0,1,'2019-12-27 11:30:58.958177','2019-12-27 04:08:17.669489',0,0,15,39);
INSERT INTO "oneid_meta_groupperm" VALUES(959,'839168947c4e4e94b3b1cbeecec23fe3',0,1,'2019-12-27 11:30:59.289745','2019-12-27 04:08:17.671488',0,0,15,40);
INSERT INTO "oneid_meta_groupperm" VALUES(960,'6ec08c32564e47b08cf8214d2d245fcd',0,1,'2019-12-27 11:30:59.620046','2019-12-27 04:08:17.674688',0,0,15,41);
INSERT INTO "oneid_meta_groupperm" VALUES(961,'82011b79e14740afad2d9c0a2fff32df',0,1,'2019-12-27 11:30:59.955292','2019-12-27 04:08:17.679510',0,0,15,42);
INSERT INTO "oneid_meta_groupperm" VALUES(962,'c5e1c4be2a524f88be298caf8794cd34',0,1,'2019-12-27 11:31:00.124310','2019-12-27 04:08:17.683501',0,0,15,43);
INSERT INTO "oneid_meta_groupperm" VALUES(963,'83b14ff6680a4c3a99390ffdbfc3042c',0,1,'2019-12-27 11:30:50.533153','2019-12-27 04:08:17.685538',0,0,15,44);
INSERT INTO "oneid_meta_groupperm" VALUES(964,'29d208c625b54802b842a4f6f91c96b1',0,1,'2019-12-27 11:31:00.803252','2019-12-27 04:08:17.687906',0,0,15,45);
INSERT INTO "oneid_meta_groupperm" VALUES(965,'d4d76a513a214653ba1ba2d3bd87090d',0,1,'2019-12-27 11:30:50.698017','2019-12-27 04:08:17.690078',0,0,15,46);
INSERT INTO "oneid_meta_groupperm" VALUES(966,'62a0590fea65474e803fedac591dbe94',0,1,'2019-12-27 11:31:00.309833','2019-12-27 04:08:17.692049',0,0,15,47);
INSERT INTO "oneid_meta_groupperm" VALUES(967,'6800df7c3fe04fb7b367bda810cff9fd',0,1,'2019-12-27 11:31:00.475333','2019-12-27 04:08:17.694520',0,0,15,48);
INSERT INTO "oneid_meta_groupperm" VALUES(968,'c40d6d4aee324567b1567aba797e9be6',0,1,'2019-12-27 11:31:00.638464','2019-12-27 04:08:17.698155',0,0,15,49);
INSERT INTO "oneid_meta_groupperm" VALUES(969,'15da847f64564496b35e49b86762dc26',0,1,'2019-12-27 11:31:00.970742','2019-12-27 04:08:17.700179',0,0,15,50);
INSERT INTO "oneid_meta_groupperm" VALUES(970,'3a256f8afb52414e9e786cfede765e74',0,1,'2019-12-27 11:31:01.135329','2019-12-27 04:08:17.702309',0,0,15,51);
INSERT INTO "oneid_meta_groupperm" VALUES(971,'bd8f586ff8904a8fb2175de34920e9bb',0,1,'2019-12-27 11:31:01.298447','2019-12-27 04:08:17.704330',0,0,15,52);
INSERT INTO "oneid_meta_groupperm" VALUES(972,'c80be7ba29ee4f5d8f3e578b28432057',0,1,'2019-12-27 11:30:50.867329','2019-12-27 04:08:17.706323',0,0,15,53);
INSERT INTO "oneid_meta_groupperm" VALUES(973,'e759a57840d24babace4c0a2afd98793',0,1,'2019-12-27 11:30:51.043672','2019-12-27 04:08:17.708557',0,0,15,54);
INSERT INTO "oneid_meta_groupperm" VALUES(974,'9344edce3d424441b8fc9d8088f97bf8',0,1,'2019-12-27 11:30:51.216331','2019-12-27 04:08:17.710541',0,0,15,55);
INSERT INTO "oneid_meta_groupperm" VALUES(975,'f1f4876aef1e443a91cb14a646e2f46b',0,1,'2019-12-27 11:30:51.384875','2019-12-27 04:08:17.713598',0,0,15,56);
INSERT INTO "oneid_meta_groupperm" VALUES(976,'55a5d5f3342b4ed2a4529b48da78bfd2',0,1,'2019-12-27 11:30:50.050182','2019-12-27 04:08:17.801507',0,0,16,1);
INSERT INTO "oneid_meta_groupperm" VALUES(977,'8bf6f2c225ad4dd28011eabb14358ab2',0,1,'2019-12-27 11:30:50.200881','2019-12-27 04:08:17.804353',0,0,16,2);
INSERT INTO "oneid_meta_groupperm" VALUES(978,'dc6c96c03c3a443ea920fe5799c1f57c',0,1,'2019-12-27 11:31:01.630613','2019-12-27 04:08:17.806528',0,0,16,3);
INSERT INTO "oneid_meta_groupperm" VALUES(979,'8b338426afb44a129b6aa00a23f0ab7b',0,1,'2019-12-27 11:30:50.366946','2019-12-27 04:08:17.808649',0,0,16,4);
INSERT INTO "oneid_meta_groupperm" VALUES(980,'e8793968f88a47748a8ea0b69b3376cd',0,1,'2019-12-27 11:30:53.393819','2019-12-27 04:08:17.810793',0,0,16,5);
INSERT INTO "oneid_meta_groupperm" VALUES(981,'1ee509a1455c440d86f82333463a7f87',0,1,'2019-12-27 11:30:56.782647','2019-12-27 04:08:17.815550',0,0,16,6);
INSERT INTO "oneid_meta_groupperm" VALUES(982,'9a6209cef022418daf591bf85314bba7',0,1,'2019-12-27 11:30:53.577027','2019-12-27 04:08:17.817662',0,0,16,7);
INSERT INTO "oneid_meta_groupperm" VALUES(983,'b1df6bf728aa44408b6b890c5a12c1c4',0,1,'2019-12-27 11:30:53.750331','2019-12-27 04:08:17.819920',0,0,16,8);
INSERT INTO "oneid_meta_groupperm" VALUES(984,'346701c17e8c4a91ad10a9cdeb9b8546',0,1,'2019-12-27 11:30:53.927084','2019-12-27 04:08:17.822025',0,0,16,9);
INSERT INTO "oneid_meta_groupperm" VALUES(985,'ccfb4c21667d4d188533a89057693588',0,1,'2019-12-27 11:30:54.096884','2019-12-27 04:08:17.833392',0,0,16,10);
INSERT INTO "oneid_meta_groupperm" VALUES(986,'c46415be6f254504a68d320ac2c7e865',0,1,'2019-12-27 11:30:54.264956','2019-12-27 04:08:17.835578',0,0,16,11);
INSERT INTO "oneid_meta_groupperm" VALUES(987,'d34d0529bb064c729d9d06be1e08647c',0,1,'2019-12-27 11:30:54.441831','2019-12-27 04:08:17.837966',0,0,16,12);
INSERT INTO "oneid_meta_groupperm" VALUES(988,'e433bf449ac143208a963541a3b97249',0,1,'2019-12-27 11:30:54.608907','2019-12-27 04:08:17.840036',0,0,16,13);
INSERT INTO "oneid_meta_groupperm" VALUES(989,'b24c47f113ab4b7bb27a2de968beac3c',0,1,'2019-12-27 11:30:55.649209','2019-12-27 04:08:17.842124',0,0,16,14);
INSERT INTO "oneid_meta_groupperm" VALUES(990,'49d2c17ed40a4703a80a0782275cb2c9',0,1,'2019-12-27 11:30:55.992686','2019-12-27 04:08:17.844376',0,0,16,15);
INSERT INTO "oneid_meta_groupperm" VALUES(991,'efa3518293ca4c718d4672b1285c5448',0,1,'2019-12-27 11:30:56.380380','2019-12-27 04:08:17.850154',0,0,16,16);
INSERT INTO "oneid_meta_groupperm" VALUES(992,'e417b8d0af05471a97e73296156e4d19',0,1,'2019-12-27 11:30:54.788296','2019-12-27 04:08:17.852572',0,0,16,17);
INSERT INTO "oneid_meta_groupperm" VALUES(993,'7e40754e3beb46a994ea8f7805b16da3',0,1,'2019-12-27 11:30:54.965542','2019-12-27 04:08:17.854909',0,0,16,18);
INSERT INTO "oneid_meta_groupperm" VALUES(994,'dd16831cf0214d12ba23cc1cb73d6ccb',0,1,'2019-12-27 11:30:55.143848','2019-12-27 04:08:17.857029',0,0,16,19);
INSERT INTO "oneid_meta_groupperm" VALUES(995,'9fa8ddd9394a421081289d4af7a9c160',0,1,'2019-12-27 11:30:55.310041','2019-12-27 04:08:17.859452',0,0,16,20);
INSERT INTO "oneid_meta_groupperm" VALUES(996,'91628b1a33fc4728ad1abb7045f042db',0,1,'2019-12-27 11:30:55.479168','2019-12-27 04:08:17.862581',0,0,16,21);
INSERT INTO "oneid_meta_groupperm" VALUES(997,'f75b91b958ef475b9872dd63fbc109dc',0,1,'2019-12-27 11:30:56.982728','2019-12-27 04:08:17.866862',0,0,16,22);
INSERT INTO "oneid_meta_groupperm" VALUES(998,'9437559a2676495a8898cb307c4db3af',0,1,'2019-12-27 11:30:58.105463','2019-12-27 04:08:17.869144',0,0,16,23);
INSERT INTO "oneid_meta_groupperm" VALUES(999,'39040f52142140b9b8bbf1f770cd95da',0,1,'2019-12-27 11:30:59.132837','2019-12-27 04:08:17.871905',0,0,16,24);
INSERT INTO "oneid_meta_groupperm" VALUES(1000,'6c22377b95f147d682d728cdab1cfa09',0,1,'2019-12-27 11:30:59.462216','2019-12-27 04:08:17.874025',0,0,16,25);
INSERT INTO "oneid_meta_groupperm" VALUES(1001,'bb271a4ab91442649340b79a4a119333',0,1,'2019-12-27 11:30:59.792913','2019-12-27 04:08:17.876229',0,0,16,26);
INSERT INTO "oneid_meta_groupperm" VALUES(1002,'f98208ac178a45398c67bfa6a4a240f5',0,1,'2019-12-27 11:30:55.817483','2019-12-27 04:08:17.879889',0,0,16,27);
INSERT INTO "oneid_meta_groupperm" VALUES(1003,'21eadc1a78d740fab6df1d065e795e24',0,1,'2019-12-27 11:30:56.176921','2019-12-27 04:08:17.884506',0,0,16,28);
INSERT INTO "oneid_meta_groupperm" VALUES(1004,'7edc0c597994433386776f60630434fc',0,1,'2019-12-27 11:30:56.569426','2019-12-27 04:08:17.887919',0,0,16,29);
INSERT INTO "oneid_meta_groupperm" VALUES(1005,'7ad1933815c446cbb03b069d6d280a10',0,1,'2019-12-27 11:30:57.187835','2019-12-27 04:08:17.890426',0,0,16,30);
INSERT INTO "oneid_meta_groupperm" VALUES(1006,'46365a9e3179486ebbb953569b799ac5',0,1,'2019-12-27 11:30:57.381451','2019-12-27 04:08:17.893689',0,0,16,31);
INSERT INTO "oneid_meta_groupperm" VALUES(1007,'4dc5ca210dac499f86ce2501cd0aa6b3',0,1,'2019-12-27 11:30:57.564126','2019-12-27 04:08:17.898032',0,0,16,32);
INSERT INTO "oneid_meta_groupperm" VALUES(1008,'e7850a347597427b9f0fc71f1977c5ae',0,1,'2019-12-27 11:30:57.740848','2019-12-27 04:08:17.900781',0,0,16,33);
INSERT INTO "oneid_meta_groupperm" VALUES(1009,'68166d14072c493d8874fdd3ca96b4c6',0,1,'2019-12-27 11:30:57.923457','2019-12-27 04:08:17.902975',0,0,16,34);
INSERT INTO "oneid_meta_groupperm" VALUES(1010,'cbd708dca2d34b8aaa0cad584742e3f4',0,1,'2019-12-27 11:30:58.283113','2019-12-27 04:08:17.905993',0,0,16,35);
INSERT INTO "oneid_meta_groupperm" VALUES(1011,'4fc0121db6c540eb8521cfb3d46b287c',0,1,'2019-12-27 11:30:58.455016','2019-12-27 04:08:17.908163',0,0,16,36);
INSERT INTO "oneid_meta_groupperm" VALUES(1012,'5f480b4f0a7c4f708cd92748f5f4839a',0,1,'2019-12-27 11:30:58.626128','2019-12-27 04:08:17.910330',0,0,16,37);
INSERT INTO "oneid_meta_groupperm" VALUES(1013,'ce47ae4486094492ab799136567ba550',0,1,'2019-12-27 11:30:58.794311','2019-12-27 04:08:17.914422',0,0,16,38);
INSERT INTO "oneid_meta_groupperm" VALUES(1014,'45cce2bf7fc44e2880e2f6655cdd0433',0,1,'2019-12-27 11:30:58.966000','2019-12-27 04:08:17.917719',0,0,16,39);
INSERT INTO "oneid_meta_groupperm" VALUES(1015,'64e7db29ccd045a7bb883e933a995876',0,1,'2019-12-27 11:30:59.297909','2019-12-27 04:08:17.919856',0,0,16,40);
INSERT INTO "oneid_meta_groupperm" VALUES(1016,'bcab5520655a40a190cd337fc94824a5',0,1,'2019-12-27 11:30:59.627659','2019-12-27 04:08:17.922319',0,0,16,41);
INSERT INTO "oneid_meta_groupperm" VALUES(1017,'0f17122b0d4443b285b5d92a460fd1ba',0,1,'2019-12-27 11:30:59.963215','2019-12-27 04:08:17.926528',0,0,16,42);
INSERT INTO "oneid_meta_groupperm" VALUES(1018,'c5bcd70f4ace4c5cb6083d8798cf63d0',0,1,'2019-12-27 11:31:00.139066','2019-12-27 04:08:17.932794',0,0,16,43);
INSERT INTO "oneid_meta_groupperm" VALUES(1019,'510e8be7f2244bad8b8c8fb405f784f2',0,1,'2019-12-27 11:30:50.541495','2019-12-27 04:08:17.935349',0,0,16,44);
INSERT INTO "oneid_meta_groupperm" VALUES(1020,'6e30e508840349f8ae874c45604314a0',0,1,'2019-12-27 11:31:00.812045','2019-12-27 04:08:17.938017',0,0,16,45);
INSERT INTO "oneid_meta_groupperm" VALUES(1021,'0fe08b3e0806420884e133fb863008d3',0,1,'2019-12-27 11:30:50.705689','2019-12-27 04:08:17.940130',0,0,16,46);
INSERT INTO "oneid_meta_groupperm" VALUES(1022,'a3d057e936404654b62ef35789db2392',0,1,'2019-12-27 11:31:00.317734','2019-12-27 04:08:17.942168',0,0,16,47);
INSERT INTO "oneid_meta_groupperm" VALUES(1023,'df5847eb0e324591964f078e097f12a7',0,1,'2019-12-27 11:31:00.483275','2019-12-27 04:08:17.944533',0,0,16,48);
INSERT INTO "oneid_meta_groupperm" VALUES(1024,'1d83bb61619c47c99d85897319d668d6',0,1,'2019-12-27 11:31:00.646027','2019-12-27 04:08:17.947885',0,0,16,49);
INSERT INTO "oneid_meta_groupperm" VALUES(1025,'4a3f08923ad04cc580db1a9ef50b222d',0,1,'2019-12-27 11:31:00.978598','2019-12-27 04:08:17.951869',0,0,16,50);
INSERT INTO "oneid_meta_groupperm" VALUES(1026,'c1e4892536fa40b69f6e06de9c1c770e',0,1,'2019-12-27 11:31:01.142777','2019-12-27 04:08:17.954626',0,0,16,51);
INSERT INTO "oneid_meta_groupperm" VALUES(1027,'e686f9f6195b44558a0fec05f023d5af',0,1,'2019-12-27 11:31:01.306586','2019-12-27 04:08:17.956832',0,0,16,52);
INSERT INTO "oneid_meta_groupperm" VALUES(1028,'b460560109024630913df61ac1d1cf43',0,1,'2019-12-27 11:30:50.875770','2019-12-27 04:08:17.958855',0,0,16,53);
INSERT INTO "oneid_meta_groupperm" VALUES(1029,'abc5930f09cc4b6abd690134afd553b9',0,1,'2019-12-27 11:30:51.052740','2019-12-27 04:08:17.961540',0,0,16,54);
INSERT INTO "oneid_meta_groupperm" VALUES(1030,'123785d608354611b99d511a57b461e6',0,1,'2019-12-27 11:30:51.224378','2019-12-27 04:08:17.965521',0,0,16,55);
INSERT INTO "oneid_meta_groupperm" VALUES(1031,'07a883291ae04a86b56c410bfe3b9bcc',0,1,'2019-12-27 11:30:51.392344','2019-12-27 04:08:17.967965',0,0,16,56);
INSERT INTO "oneid_meta_groupperm" VALUES(1032,'6c6a5a19326e42c28388d4249bddfa7c',0,1,'2019-12-27 11:30:51.566575','2019-12-27 04:08:17.970183',0,0,16,57);
INSERT INTO "oneid_meta_groupperm" VALUES(1033,'545e27073e5340909390024bde32c7ee',0,1,'2019-12-27 11:31:01.468436','2019-12-27 04:08:17.972792',0,0,16,58);
INSERT INTO "oneid_meta_groupperm" VALUES(1034,'7b094de7ab82433298e0c0bef52a2f89',0,1,'2019-12-27 11:30:51.731239','2019-12-27 04:08:17.974837',0,0,16,59);
INSERT INTO "oneid_meta_groupperm" VALUES(1035,'f1c9ebe53c7d4394b2512b0f57b36df2',0,1,'2019-12-27 11:30:50.055049','2019-12-27 04:08:18.064127',0,0,17,1);
INSERT INTO "oneid_meta_groupperm" VALUES(1036,'d9c5fdcb5b6243d3afe7892151eb9920',0,1,'2019-12-27 11:30:50.208979','2019-12-27 04:08:18.066176',0,0,17,2);
INSERT INTO "oneid_meta_groupperm" VALUES(1037,'b71a834892374063beb9945a4f7e5c98',0,1,'2019-12-27 11:31:01.638204','2019-12-27 04:08:18.068177',0,0,17,3);
INSERT INTO "oneid_meta_groupperm" VALUES(1038,'4f8041a9f8bd4e77beb9d4d6b51cdf0b',0,1,'2019-12-27 11:30:50.375364','2019-12-27 04:08:18.070216',0,0,17,4);
INSERT INTO "oneid_meta_groupperm" VALUES(1039,'e8ac07f73a1443a18a4c3f0fed877065',0,1,'2019-12-27 11:30:53.401992','2019-12-27 04:08:18.072626',0,0,17,5);
INSERT INTO "oneid_meta_groupperm" VALUES(1040,'d9859bbc097042e1a7cd094674a3cf3b',0,1,'2019-12-27 11:30:56.795299','2019-12-27 04:08:18.074987',0,0,17,6);
INSERT INTO "oneid_meta_groupperm" VALUES(1041,'66e3bcf234ed48c4ad1efd0c2d90b8c1',0,1,'2019-12-27 11:30:53.585820','2019-12-27 04:08:18.076994',0,0,17,7);
INSERT INTO "oneid_meta_groupperm" VALUES(1042,'9871e194e09d4943a4953a59aa3d3867',0,1,'2019-12-27 11:30:53.758191','2019-12-27 04:08:18.079071',0,0,17,8);
INSERT INTO "oneid_meta_groupperm" VALUES(1043,'abbb801663224b5eb5fdc034d5f776d9',0,1,'2019-12-27 11:30:53.935569','2019-12-27 04:08:18.081529',0,0,17,9);
INSERT INTO "oneid_meta_groupperm" VALUES(1044,'8f2f808565eb4f828ecb0102dd1cc7df',0,1,'2019-12-27 11:30:54.104743','2019-12-27 04:08:18.084438',0,0,17,10);
INSERT INTO "oneid_meta_groupperm" VALUES(1045,'42c2be011cf44d0199192301badc017d',0,1,'2019-12-27 11:30:54.273137','2019-12-27 04:08:18.087130',0,0,17,11);
INSERT INTO "oneid_meta_groupperm" VALUES(1046,'cf0893abfd8f4af295f4f308cec254fa',0,1,'2019-12-27 11:30:54.449596','2019-12-27 04:08:18.089688',0,0,17,12);
INSERT INTO "oneid_meta_groupperm" VALUES(1047,'b30b2d75e54b4202845d65be7f2ee31a',0,1,'2019-12-27 11:30:54.616681','2019-12-27 04:08:18.092071',0,0,17,13);
INSERT INTO "oneid_meta_groupperm" VALUES(1048,'323e5073a0f24f99a97e973eff3e76dd',0,1,'2019-12-27 11:30:55.657862','2019-12-27 04:08:18.094598',0,0,17,14);
INSERT INTO "oneid_meta_groupperm" VALUES(1049,'33937d84ddc84ac493cabf34c680ffe8',0,1,'2019-12-27 11:30:56.000534','2019-12-27 04:08:18.097626',0,0,17,15);
INSERT INTO "oneid_meta_groupperm" VALUES(1050,'58440570f06747f180459eb2f6974fe7',0,1,'2019-12-27 11:30:56.389960','2019-12-27 04:08:18.100095',0,0,17,16);
INSERT INTO "oneid_meta_groupperm" VALUES(1051,'614d4ee6abe14ca8b60f91103e4c617b',0,1,'2019-12-27 11:30:54.796462','2019-12-27 04:08:18.102262',0,0,17,17);
INSERT INTO "oneid_meta_groupperm" VALUES(1052,'daef5921e088487b8cfa5a8942def616',0,1,'2019-12-27 11:30:54.974062','2019-12-27 04:08:18.104553',0,0,17,18);
INSERT INTO "oneid_meta_groupperm" VALUES(1053,'3d5af3acd711491faff7c81ddae145e6',0,1,'2019-12-27 11:30:55.151506','2019-12-27 04:08:18.107265',0,0,17,19);
INSERT INTO "oneid_meta_groupperm" VALUES(1054,'1696d228297449928cc56f8621a922b1',0,1,'2019-12-27 11:30:55.317842','2019-12-27 04:08:18.109384',0,0,17,20);
INSERT INTO "oneid_meta_groupperm" VALUES(1055,'8851013943ff42e1bec69656eb41d974',0,1,'2019-12-27 11:30:55.487390','2019-12-27 04:08:18.111593',0,0,17,21);
INSERT INTO "oneid_meta_groupperm" VALUES(1056,'6b505d8705bf49fdb06f6df9903e833c',0,1,'2019-12-27 11:30:56.993671','2019-12-27 04:08:18.114038',0,0,17,22);
INSERT INTO "oneid_meta_groupperm" VALUES(1057,'1d8d70fe27c24d01b0ec75e5e5bad598',0,1,'2019-12-27 11:30:58.114258','2019-12-27 04:08:18.116249',0,0,17,23);
INSERT INTO "oneid_meta_groupperm" VALUES(1058,'b70e28f62a02408a9c8f180c699c49da',0,1,'2019-12-27 11:30:59.140504','2019-12-27 04:08:18.119078',0,0,17,24);
INSERT INTO "oneid_meta_groupperm" VALUES(1059,'de6315f514564c08b923834287ad6f7c',0,1,'2019-12-27 11:30:59.469987','2019-12-27 04:08:18.122267',0,0,17,25);
INSERT INTO "oneid_meta_groupperm" VALUES(1060,'196216d3d35a4410bcf448f726cb4f42',0,1,'2019-12-27 11:30:59.801057','2019-12-27 04:08:18.124943',0,0,17,26);
INSERT INTO "oneid_meta_groupperm" VALUES(1061,'0e00d0387e41479c8d03a77e827d7469',0,1,'2019-12-27 11:30:55.825782','2019-12-27 04:08:18.127249',0,0,17,27);
INSERT INTO "oneid_meta_groupperm" VALUES(1062,'b14f7a9e291042e9a5d4cbd60ff766ed',0,1,'2019-12-27 11:30:56.185548','2019-12-27 04:08:18.130049',0,0,17,28);
INSERT INTO "oneid_meta_groupperm" VALUES(1063,'7e257801ad6642a085176fe3ce96ad55',0,1,'2019-12-27 11:30:56.579335','2019-12-27 04:08:18.133095',0,0,17,29);
INSERT INTO "oneid_meta_groupperm" VALUES(1064,'63b97dacf7cf477a9a97f66e7db41083',0,1,'2019-12-27 11:30:57.196821','2019-12-27 04:08:18.135493',0,0,17,30);
INSERT INTO "oneid_meta_groupperm" VALUES(1065,'f54f883272d848e0a536544a60cce528',0,1,'2019-12-27 11:30:57.391266','2019-12-27 04:08:18.137815',0,0,17,31);
INSERT INTO "oneid_meta_groupperm" VALUES(1066,'b980f760e1e8436680a4d4e8c73c5ac9',0,1,'2019-12-27 11:30:57.572263','2019-12-27 04:08:18.140186',0,0,17,32);
INSERT INTO "oneid_meta_groupperm" VALUES(1067,'5ac3fe01184f4e2a935ddefb8e285ed9',0,1,'2019-12-27 11:30:57.749029','2019-12-27 04:08:18.142500',0,0,17,33);
INSERT INTO "oneid_meta_groupperm" VALUES(1068,'76dff10a33574e90a16c2a090ff535e0',0,1,'2019-12-27 11:30:57.931601','2019-12-27 04:08:18.144536',0,0,17,34);
INSERT INTO "oneid_meta_groupperm" VALUES(1069,'201e8e9bee4643f0acdf9fbafe8a66ab',0,1,'2019-12-27 11:30:58.291249','2019-12-27 04:08:18.146804',0,0,17,35);
INSERT INTO "oneid_meta_groupperm" VALUES(1070,'37e9642f446d492a9e34d4ca161acded',0,1,'2019-12-27 11:30:58.463563','2019-12-27 04:08:18.149612',0,0,17,36);
INSERT INTO "oneid_meta_groupperm" VALUES(1071,'236c34bdd1f449d09ebd010e86e3fdf4',0,1,'2019-12-27 11:30:58.633847','2019-12-27 04:08:18.152599',0,0,17,37);
INSERT INTO "oneid_meta_groupperm" VALUES(1072,'37e5b20af30c45aa9c46ea1775ab2e84',0,1,'2019-12-27 11:30:58.803446','2019-12-27 04:08:18.155561',0,0,17,38);
INSERT INTO "oneid_meta_groupperm" VALUES(1073,'78b98e0f16c84ce0911e0d2ccc3e0287',0,1,'2019-12-27 11:30:58.974189','2019-12-27 04:08:18.158109',0,0,17,39);
INSERT INTO "oneid_meta_groupperm" VALUES(1074,'5a3f38771fb2489886658840f396d848',0,1,'2019-12-27 11:30:59.305879','2019-12-27 04:08:18.160554',0,0,17,40);
INSERT INTO "oneid_meta_groupperm" VALUES(1075,'3c8d853bc4c24497b0ef240ed2ae28b3',0,1,'2019-12-27 11:30:59.635455','2019-12-27 04:08:18.163309',0,0,17,41);
INSERT INTO "oneid_meta_groupperm" VALUES(1076,'5955df3ec3d644e1a1b524150ac5a64a',0,1,'2019-12-27 11:30:59.970842','2019-12-27 04:08:18.166224',0,0,17,42);
INSERT INTO "oneid_meta_groupperm" VALUES(1077,'5474f2fce11945ca9230f856826e25bc',0,1,'2019-12-27 11:31:00.152096','2019-12-27 04:08:18.168775',0,0,17,43);
INSERT INTO "oneid_meta_groupperm" VALUES(1078,'ea39984f096f4f5a886ec2fe690b9691',0,1,'2019-12-27 11:30:50.549222','2019-12-27 04:08:18.171332',0,0,17,44);
INSERT INTO "oneid_meta_groupperm" VALUES(1079,'4ca689b288214c4f9510e74a51cdf7e0',0,1,'2019-12-27 11:31:00.819962','2019-12-27 04:08:18.173796',0,0,17,45);
INSERT INTO "oneid_meta_groupperm" VALUES(1080,'cd104eaf80d344609869ba3f57b53b8c',0,1,'2019-12-27 11:30:50.713787','2019-12-27 04:08:18.176319',0,0,17,46);
INSERT INTO "oneid_meta_groupperm" VALUES(1081,'ac9e855bffea49c085b9cad25b579e8f',0,1,'2019-12-27 11:31:00.325415','2019-12-27 04:08:18.178763',0,0,17,47);
INSERT INTO "oneid_meta_groupperm" VALUES(1082,'d883f5e4f4684f88a0366819f6c58636',0,1,'2019-12-27 11:31:00.490789','2019-12-27 04:08:18.181162',0,0,17,48);
INSERT INTO "oneid_meta_groupperm" VALUES(1083,'b26a4030bfca4f69bd63e6046d53bb30',0,1,'2019-12-27 11:31:00.653918','2019-12-27 04:08:18.183903',0,0,17,49);
INSERT INTO "oneid_meta_groupperm" VALUES(1084,'f4e9aef2a1554c679829e7ecf3dca454',0,1,'2019-12-27 11:31:00.986637','2019-12-27 04:08:18.187315',0,0,17,50);
INSERT INTO "oneid_meta_groupperm" VALUES(1085,'dbc1b7ebc2294b259eed85d5b220d222',0,1,'2019-12-27 11:31:01.150652','2019-12-27 04:08:18.189719',0,0,17,51);
INSERT INTO "oneid_meta_groupperm" VALUES(1086,'73d76431261548d394cb9bc452b0f9a4',0,1,'2019-12-27 11:31:01.314576','2019-12-27 04:08:18.192087',0,0,17,52);
INSERT INTO "oneid_meta_groupperm" VALUES(1087,'8f950cc006b147cc844a4f157b74e632',0,1,'2019-12-27 11:30:50.884443','2019-12-27 04:08:18.194475',0,0,17,53);
INSERT INTO "oneid_meta_groupperm" VALUES(1088,'356a3936e811469bbeb03189ab1c7c9e',0,1,'2019-12-27 11:30:51.060225','2019-12-27 04:08:18.196919',0,0,17,54);
INSERT INTO "oneid_meta_groupperm" VALUES(1089,'bd0c9e2d725843c49da5972c8fd57562',0,1,'2019-12-27 11:30:51.232108','2019-12-27 04:08:18.199887',0,0,17,55);
INSERT INTO "oneid_meta_groupperm" VALUES(1090,'ada977f6dde04b3097d398958f86cd30',0,1,'2019-12-27 11:30:51.400442','2019-12-27 04:08:18.202412',0,0,17,56);
INSERT INTO "oneid_meta_groupperm" VALUES(1091,'91eafc6255e44ec88815fc240cee85c6',0,1,'2019-12-27 11:30:51.574660','2019-12-27 04:08:18.204868',0,0,17,57);
INSERT INTO "oneid_meta_groupperm" VALUES(1092,'95d6b8bddeb84b1489453d6617b6a270',0,1,'2019-12-27 11:31:01.476224','2019-12-27 04:08:18.207374',0,0,17,58);
INSERT INTO "oneid_meta_groupperm" VALUES(1093,'4213bd273069409c8abe7af3a94a12b8',0,1,'2019-12-27 11:30:51.738940','2019-12-27 04:08:18.210026',0,0,17,59);
INSERT INTO "oneid_meta_groupperm" VALUES(1094,'96cb7e2c60674993870923450243124e',0,1,'2019-12-27 11:30:51.907274','2019-12-27 04:08:18.212458',0,0,17,60);
INSERT INTO "oneid_meta_groupperm" VALUES(1095,'dc7a1750b46744aa94dd4ea83966f4e0',0,1,'2019-12-27 11:30:50.059775','2019-12-27 04:08:18.308522',0,0,18,1);
INSERT INTO "oneid_meta_groupperm" VALUES(1096,'c749166fb3764b0aa2fb8c8f7b9baab7',0,1,'2019-12-27 11:30:50.216592','2019-12-27 04:08:18.311109',0,0,18,2);
INSERT INTO "oneid_meta_groupperm" VALUES(1097,'7f1ffd7637374339bc080eb84523ab6b',0,1,'2019-12-27 11:31:01.645676','2019-12-27 04:08:18.314100',0,0,18,3);
INSERT INTO "oneid_meta_groupperm" VALUES(1098,'77b5bc9b1c404ac28d5df0db866f8ce2',0,1,'2019-12-27 11:30:50.383894','2019-12-27 04:08:18.316580',0,0,18,4);
INSERT INTO "oneid_meta_groupperm" VALUES(1099,'4464a1a4f0dc4ebcb7fa6679146f1915',0,1,'2019-12-27 11:30:53.410795','2019-12-27 04:08:18.318638',0,0,18,5);
INSERT INTO "oneid_meta_groupperm" VALUES(1100,'52c0eb33366a48e1b2e8540a0a4bbcda',0,1,'2019-12-27 11:30:56.811057','2019-12-27 04:08:18.321388',0,0,18,6);
INSERT INTO "oneid_meta_groupperm" VALUES(1101,'7f44ecd36e5d48679a65ce1aca04dffc',0,1,'2019-12-27 11:30:53.593537','2019-12-27 04:08:18.323676',0,0,18,7);
INSERT INTO "oneid_meta_groupperm" VALUES(1102,'3ed9f4523001496099c0b7cee1a6ea44',0,1,'2019-12-27 11:30:53.766215','2019-12-27 04:08:18.325874',0,0,18,8);
INSERT INTO "oneid_meta_groupperm" VALUES(1103,'545b974cc30542dfbe5d1051ab2b94f1',0,1,'2019-12-27 11:30:53.943084','2019-12-27 04:08:18.328011',0,0,18,9);
INSERT INTO "oneid_meta_groupperm" VALUES(1104,'a9af0fc3703e4b3ea67d11ee967f7d99',0,1,'2019-12-27 11:30:54.112115','2019-12-27 04:08:18.330848',0,0,18,10);
INSERT INTO "oneid_meta_groupperm" VALUES(1105,'559efc5f28c64bd5ac41deb0d74c7da3',0,1,'2019-12-27 11:30:54.281129','2019-12-27 04:08:18.334009',0,0,18,11);
INSERT INTO "oneid_meta_groupperm" VALUES(1106,'a460e8e91b804cfc813ad8b1e0dd64e0',0,1,'2019-12-27 11:30:54.457219','2019-12-27 04:08:18.336044',0,0,18,12);
INSERT INTO "oneid_meta_groupperm" VALUES(1107,'70b3bf86946745218a3aeec2939b67af',0,1,'2019-12-27 11:30:54.624598','2019-12-27 04:08:18.338068',0,0,18,13);
INSERT INTO "oneid_meta_groupperm" VALUES(1108,'eed7036191b540ef806ed85e8577c566',0,1,'2019-12-27 11:30:55.665495','2019-12-27 04:08:18.340064',0,0,18,14);
INSERT INTO "oneid_meta_groupperm" VALUES(1109,'a0405e1da4b943d9af3972ad1e379661',0,1,'2019-12-27 11:30:56.009027','2019-12-27 04:08:18.342176',0,0,18,15);
INSERT INTO "oneid_meta_groupperm" VALUES(1110,'97da6d9bc99149a79ef4ce2628d03c32',0,1,'2019-12-27 11:30:56.399566','2019-12-27 04:08:18.344185',0,0,18,16);
INSERT INTO "oneid_meta_groupperm" VALUES(1111,'e700dfedddc147849fdb3890c27cf21b',0,1,'2019-12-27 11:30:54.805259','2019-12-27 04:08:18.346815',0,0,18,17);
INSERT INTO "oneid_meta_groupperm" VALUES(1112,'90c1f50ccbb44b91a42c8741948bd6b9',0,1,'2019-12-27 11:30:54.981900','2019-12-27 04:08:18.349599',0,0,18,18);
INSERT INTO "oneid_meta_groupperm" VALUES(1113,'90c36be9fed94cbb8c4e601e35efa628',0,1,'2019-12-27 11:30:55.159402','2019-12-27 04:08:18.351578',0,0,18,19);
INSERT INTO "oneid_meta_groupperm" VALUES(1114,'dce41cdc98984dd8aa1462b55602dd45',0,1,'2019-12-27 11:30:55.325733','2019-12-27 04:08:18.354004',0,0,18,20);
INSERT INTO "oneid_meta_groupperm" VALUES(1115,'03e5187bc549425aabc14486eb7c5f13',0,1,'2019-12-27 11:30:55.495351','2019-12-27 04:08:18.356659',0,0,18,21);
INSERT INTO "oneid_meta_groupperm" VALUES(1116,'02aa1e162c434b7c8a1bf6755b100924',0,1,'2019-12-27 11:30:57.002529','2019-12-27 04:08:18.358675',0,0,18,22);
INSERT INTO "oneid_meta_groupperm" VALUES(1117,'56d367cfc14744ecb31d54688d689051',0,1,'2019-12-27 11:30:58.123406','2019-12-27 04:08:18.360617',0,0,18,23);
INSERT INTO "oneid_meta_groupperm" VALUES(1118,'dd8c0d47acf247a5a4fa85c4a466eca5',0,1,'2019-12-27 11:30:59.148350','2019-12-27 04:08:18.363980',0,0,18,24);
INSERT INTO "oneid_meta_groupperm" VALUES(1119,'601719feda0945a49f395468611c95da',0,1,'2019-12-27 11:30:59.477360','2019-12-27 04:08:18.366885',0,0,18,25);
INSERT INTO "oneid_meta_groupperm" VALUES(1120,'deaae94042be4860b5e9af929b60e061',0,1,'2019-12-27 11:30:59.808763','2019-12-27 04:08:18.368999',0,0,18,26);
INSERT INTO "oneid_meta_groupperm" VALUES(1121,'8a33b9c1da1f4483ba5fe50db98a4fff',0,1,'2019-12-27 11:30:55.833363','2019-12-27 04:08:18.370971',0,0,18,27);
INSERT INTO "oneid_meta_groupperm" VALUES(1122,'68a937bb2a7c4c1a886816e3133debe2',0,1,'2019-12-27 11:30:56.196654','2019-12-27 04:08:18.372981',0,0,18,28);
INSERT INTO "oneid_meta_groupperm" VALUES(1123,'362429c3714847399922e00892ad2e89',0,1,'2019-12-27 11:30:56.587754','2019-12-27 04:08:18.375068',0,0,18,29);
INSERT INTO "oneid_meta_groupperm" VALUES(1124,'32f074817cb84583a049c65659153b1f',0,1,'2019-12-27 11:30:57.206594','2019-12-27 04:08:18.377666',0,0,18,30);
INSERT INTO "oneid_meta_groupperm" VALUES(1125,'ad230d99c7be4e55a506b85ff750c628',0,1,'2019-12-27 11:30:57.399819','2019-12-27 04:08:18.381971',0,0,18,31);
INSERT INTO "oneid_meta_groupperm" VALUES(1126,'b680c481ee7a4df58c74f783528856e1',0,1,'2019-12-27 11:30:57.580437','2019-12-27 04:08:18.384381',0,0,18,32);
INSERT INTO "oneid_meta_groupperm" VALUES(1127,'fb013f32de644b9bb93d29eb392a0b13',0,1,'2019-12-27 11:30:57.758059','2019-12-27 04:08:18.386383',0,0,18,33);
INSERT INTO "oneid_meta_groupperm" VALUES(1128,'9e4e749ba1324029a461dfe971878d2d',0,1,'2019-12-27 11:30:57.939810','2019-12-27 04:08:18.389137',0,0,18,34);
INSERT INTO "oneid_meta_groupperm" VALUES(1129,'016d9a6920864c73bfeed62f6df4fc71',0,1,'2019-12-27 11:30:58.299980','2019-12-27 04:08:18.391446',0,0,18,35);
INSERT INTO "oneid_meta_groupperm" VALUES(1130,'4646295e0a55434b9f751f5f6aaf51e6',0,1,'2019-12-27 11:30:58.471550','2019-12-27 04:08:18.393480',0,0,18,36);
INSERT INTO "oneid_meta_groupperm" VALUES(1131,'19db0c2b696247488938ca11bcc0cf4a',0,1,'2019-12-27 11:30:58.641510','2019-12-27 04:08:18.396897',0,0,18,37);
INSERT INTO "oneid_meta_groupperm" VALUES(1132,'72e94f9c298f42f8a70eb5197257fc4a',0,1,'2019-12-27 11:30:58.811740','2019-12-27 04:08:18.399717',0,0,18,38);
INSERT INTO "oneid_meta_groupperm" VALUES(1133,'89727c2e7cef4d9884c8acb0bc15dc40',0,1,'2019-12-27 11:30:58.981856','2019-12-27 04:08:18.402314',0,0,18,39);
INSERT INTO "oneid_meta_groupperm" VALUES(1134,'779dae316dab45d6b05b5ce4f06dbc6f',0,1,'2019-12-27 11:30:59.313784','2019-12-27 04:08:18.404420',0,0,18,40);
INSERT INTO "oneid_meta_groupperm" VALUES(1135,'57d305f12e8645cba999678f310c6826',0,1,'2019-12-27 11:30:59.643295','2019-12-27 04:08:18.406448',0,0,18,41);
INSERT INTO "oneid_meta_groupperm" VALUES(1136,'3268706fc6e949e2acfe5e12cd9a080d',0,1,'2019-12-27 11:30:59.978788','2019-12-27 04:08:18.408566',0,0,18,42);
INSERT INTO "oneid_meta_groupperm" VALUES(1137,'ca2da16af6d5467aa18deaecd6815ca1',0,1,'2019-12-27 11:31:00.160800','2019-12-27 04:08:18.411455',0,0,18,43);
INSERT INTO "oneid_meta_groupperm" VALUES(1138,'4a8038f0fb9147c6bae85a3a34520938',0,1,'2019-12-27 11:30:50.557029','2019-12-27 04:08:18.415437',0,0,18,44);
INSERT INTO "oneid_meta_groupperm" VALUES(1139,'0bb97cd461754e8ca8a7c37dfe404ce9',0,1,'2019-12-27 11:31:00.827493','2019-12-27 04:08:18.417583',0,0,18,45);
INSERT INTO "oneid_meta_groupperm" VALUES(1140,'cbeb86d9be2e4b7997999881f7575693',0,1,'2019-12-27 11:30:50.721329','2019-12-27 04:08:18.419702',0,0,18,46);
INSERT INTO "oneid_meta_groupperm" VALUES(1141,'9f848cb8f94a4122b37c164b71b5f58c',0,1,'2019-12-27 11:31:00.333220','2019-12-27 04:08:18.422339',0,0,18,47);
INSERT INTO "oneid_meta_groupperm" VALUES(1142,'4a90515fa2f74df48a56a55d1cd5e7ed',0,1,'2019-12-27 11:31:00.498653','2019-12-27 04:08:18.424571',0,0,18,48);
INSERT INTO "oneid_meta_groupperm" VALUES(1143,'0f22e0505de142ce9079d0ab40e0573d',0,1,'2019-12-27 11:31:00.661844','2019-12-27 04:08:18.426562',0,0,18,49);
INSERT INTO "oneid_meta_groupperm" VALUES(1144,'18b8583fb93f41d8b6965365e7d4f019',0,1,'2019-12-27 11:31:00.994491','2019-12-27 04:08:18.429622',0,0,18,50);
INSERT INTO "oneid_meta_groupperm" VALUES(1145,'6f3d274e917e415bbf2626c754b6f48c',0,1,'2019-12-27 11:31:01.158459','2019-12-27 04:08:18.433762',0,0,18,51);
INSERT INTO "oneid_meta_groupperm" VALUES(1146,'30e0f3a7609e47b39bd1b00692dbe8f4',0,1,'2019-12-27 11:31:01.322134','2019-12-27 04:08:18.435788',0,0,18,52);
INSERT INTO "oneid_meta_groupperm" VALUES(1147,'0aa1dff18c77469a8ff1ee8fb8835f8d',0,1,'2019-12-27 11:30:50.892686','2019-12-27 04:08:18.437921',0,0,18,53);
INSERT INTO "oneid_meta_groupperm" VALUES(1148,'12cc2775af7a4fd6957db990a34ab421',0,1,'2019-12-27 11:30:51.068548','2019-12-27 04:08:18.439869',0,0,18,54);
INSERT INTO "oneid_meta_groupperm" VALUES(1149,'07b28fb62e83466c9fdb2cb127345d09',0,1,'2019-12-27 11:30:51.240885','2019-12-27 04:08:18.441903',0,0,18,55);
INSERT INTO "oneid_meta_groupperm" VALUES(1150,'0ba2fb3dadd142938d93179c7b655eb1',0,1,'2019-12-27 11:30:51.407868','2019-12-27 04:08:18.444561',0,0,18,56);
INSERT INTO "oneid_meta_groupperm" VALUES(1151,'64918374710e4f6789b73934653978e5',0,1,'2019-12-27 11:30:51.582501','2019-12-27 04:08:18.447117',0,0,18,57);
INSERT INTO "oneid_meta_groupperm" VALUES(1152,'36f3deab029e4886beca79f10df8e74c',0,1,'2019-12-27 11:31:01.483661','2019-12-27 04:08:18.449330',0,0,18,58);
INSERT INTO "oneid_meta_groupperm" VALUES(1153,'257b7568f4374afb803cecc3cd3f1328',0,1,'2019-12-27 11:30:51.746832','2019-12-27 04:08:18.451304',0,0,18,59);
INSERT INTO "oneid_meta_groupperm" VALUES(1154,'d1b54c95aa4f4142aac6c9d7f6a014f3',0,1,'2019-12-27 11:30:51.915125','2019-12-27 04:08:18.453276',0,0,18,60);
INSERT INTO "oneid_meta_groupperm" VALUES(1155,'68a002dada6941d7ab64296cefce06e2',0,1,'2019-12-27 11:30:52.082494','2019-12-27 04:08:18.455811',0,0,18,61);
INSERT INTO "oneid_meta_groupperm" VALUES(1156,'54e0805996fe4c1fb8408067b2edd811',0,1,'2019-12-27 11:30:50.065024','2019-12-27 04:08:18.530479',0,0,19,1);
INSERT INTO "oneid_meta_groupperm" VALUES(1157,'fee19b705d1046138bd28b85fa1fcfce',0,1,'2019-12-27 11:30:50.224287','2019-12-27 04:08:18.533451',0,0,19,2);
INSERT INTO "oneid_meta_groupperm" VALUES(1158,'f5eb2a81687e46b295af515f99db2fbd',0,1,'2019-12-27 11:31:01.653302','2019-12-27 04:08:18.535651',0,0,19,3);
INSERT INTO "oneid_meta_groupperm" VALUES(1159,'5073a969e1454dc0926736bd225bb0da',0,1,'2019-12-27 11:30:50.391614','2019-12-27 04:08:18.537606',0,0,19,4);
INSERT INTO "oneid_meta_groupperm" VALUES(1160,'3135f39dd90048428b19a3696be60d68',0,1,'2019-12-27 11:30:53.420118','2019-12-27 04:08:18.539754',0,0,19,5);
INSERT INTO "oneid_meta_groupperm" VALUES(1161,'527aa555858e449bb1f02c40a6732ee7',0,1,'2019-12-27 11:30:56.822435','2019-12-27 04:08:18.541809',0,0,19,6);
INSERT INTO "oneid_meta_groupperm" VALUES(1162,'91cdf6bcdf0642ff8f0be296083dff30',0,1,'2019-12-27 11:30:53.602105','2019-12-27 04:08:18.544002',0,0,19,7);
INSERT INTO "oneid_meta_groupperm" VALUES(1163,'42f0dbee90d7423598bb7305185bc909',0,1,'2019-12-27 11:30:53.774104','2019-12-27 04:08:18.546029',0,0,19,8);
INSERT INTO "oneid_meta_groupperm" VALUES(1164,'8113c0a5b8b24439a75c7c351c111c62',0,1,'2019-12-27 11:30:53.951913','2019-12-27 04:08:18.548559',0,0,19,9);
INSERT INTO "oneid_meta_groupperm" VALUES(1165,'ce266a58d6004e7380dbccbb8ea32a1f',0,1,'2019-12-27 11:30:54.120060','2019-12-27 04:08:18.550587',0,0,19,10);
INSERT INTO "oneid_meta_groupperm" VALUES(1166,'3613886c641a47d5ac93036eb33666ba',0,1,'2019-12-27 11:30:54.290137','2019-12-27 04:08:18.552601',0,0,19,11);
INSERT INTO "oneid_meta_groupperm" VALUES(1167,'d77602152d05440aa6de189e0ad783c0',0,1,'2019-12-27 11:30:54.465052','2019-12-27 04:08:18.554862',0,0,19,12);
INSERT INTO "oneid_meta_groupperm" VALUES(1168,'ccdd3739e4c14c599e28d02685b76ae4',0,1,'2019-12-27 11:30:54.633003','2019-12-27 04:08:18.556980',0,0,19,13);
INSERT INTO "oneid_meta_groupperm" VALUES(1169,'b73cb0be25054deebb3a582b9142383a',0,1,'2019-12-27 11:30:55.673704','2019-12-27 04:08:18.559059',0,0,19,14);
INSERT INTO "oneid_meta_groupperm" VALUES(1170,'ec10fc7d7b604bb9bbf552a0dadae949',0,1,'2019-12-27 11:30:56.016869','2019-12-27 04:08:18.561028',0,0,19,15);
INSERT INTO "oneid_meta_groupperm" VALUES(1171,'acf455ecd7224596ab01808d387f2885',0,1,'2019-12-27 11:30:56.409025','2019-12-27 04:08:18.563068',0,0,19,16);
INSERT INTO "oneid_meta_groupperm" VALUES(1172,'34e077fa914f4f93872b2633c297ba27',0,1,'2019-12-27 11:30:54.813409','2019-12-27 04:08:18.565239',0,0,19,17);
INSERT INTO "oneid_meta_groupperm" VALUES(1173,'00e4aa848f134e39ae9eee831ade7039',0,1,'2019-12-27 11:30:54.989767','2019-12-27 04:08:18.567682',0,0,19,18);
INSERT INTO "oneid_meta_groupperm" VALUES(1174,'2eab93cd7fa744a79212d279d1e6feab',0,1,'2019-12-27 11:30:55.166785','2019-12-27 04:08:18.570550',0,0,19,19);
INSERT INTO "oneid_meta_groupperm" VALUES(1175,'0243340fc1a24d7182f09c1df651b582',0,1,'2019-12-27 11:30:55.333518','2019-12-27 04:08:18.572568',0,0,19,20);
INSERT INTO "oneid_meta_groupperm" VALUES(1176,'fb1657ff925b4de1b234c11f298ad73c',0,1,'2019-12-27 11:30:55.503029','2019-12-27 04:08:18.574467',0,0,19,21);
INSERT INTO "oneid_meta_groupperm" VALUES(1177,'dfff443b6f864f5fba0b303622da83b8',0,1,'2019-12-27 11:30:57.012322','2019-12-27 04:08:18.576629',0,0,19,22);
INSERT INTO "oneid_meta_groupperm" VALUES(1178,'15a5cf84b0f5482485a91dab76bdf834',0,1,'2019-12-27 11:30:58.132841','2019-12-27 04:08:18.580188',0,0,19,23);
INSERT INTO "oneid_meta_groupperm" VALUES(1179,'1f391ca31b3241dd8336eeb4e68a5af7',0,1,'2019-12-27 11:30:59.156495','2019-12-27 04:08:18.583523',0,0,19,24);
INSERT INTO "oneid_meta_groupperm" VALUES(1180,'56cc3ba733e94e9d9128384b144605de',0,1,'2019-12-27 11:30:59.485145','2019-12-27 04:08:18.586247',0,0,19,25);
INSERT INTO "oneid_meta_groupperm" VALUES(1181,'b71d9c2469374dcbad21a678bf8b8f1d',0,1,'2019-12-27 11:30:59.816614','2019-12-27 04:08:18.588998',0,0,19,26);
INSERT INTO "oneid_meta_groupperm" VALUES(1182,'f7e8da7b87034b49966271dc87bffa40',0,1,'2019-12-27 11:30:55.842049','2019-12-27 04:08:18.591682',0,0,19,27);
INSERT INTO "oneid_meta_groupperm" VALUES(1183,'95947dabf1c744deb9fc593a69a30f2c',0,1,'2019-12-27 11:30:56.205136','2019-12-27 04:08:18.594925',0,0,19,28);
INSERT INTO "oneid_meta_groupperm" VALUES(1184,'c35129ea6ac248ccbc7c7e44197db927',0,1,'2019-12-27 11:30:56.597284','2019-12-27 04:08:18.599087',0,0,19,29);
INSERT INTO "oneid_meta_groupperm" VALUES(1185,'43c9af4777e6452aa493a6a7663cb88e',0,1,'2019-12-27 11:30:57.214968','2019-12-27 04:08:18.601982',0,0,19,30);
INSERT INTO "oneid_meta_groupperm" VALUES(1186,'8eec2d4433344e1bb0b8e407aa78cfd4',0,1,'2019-12-27 11:30:57.409534','2019-12-27 04:08:18.604121',0,0,19,31);
INSERT INTO "oneid_meta_groupperm" VALUES(1187,'d607133071854b6a94f79305c9c2d101',0,1,'2019-12-27 11:30:57.588543','2019-12-27 04:08:18.606321',0,0,19,32);
INSERT INTO "oneid_meta_groupperm" VALUES(1188,'918676b42d434230abc9cd42b577885b',0,1,'2019-12-27 11:30:57.765834','2019-12-27 04:08:18.608654',0,0,19,33);
INSERT INTO "oneid_meta_groupperm" VALUES(1189,'503d16e586dd4bdea8cd03cb2f3a527a',0,1,'2019-12-27 11:30:57.947698','2019-12-27 04:08:18.610869',0,0,19,34);
INSERT INTO "oneid_meta_groupperm" VALUES(1190,'b46f3cd433e049319a43f8022505d815',0,1,'2019-12-27 11:30:58.307725','2019-12-27 04:08:18.614908',0,0,19,35);
INSERT INTO "oneid_meta_groupperm" VALUES(1191,'d0391951fc6f41b6b5a82abaae149085',0,1,'2019-12-27 11:30:58.479863','2019-12-27 04:08:18.617179',0,0,19,36);
INSERT INTO "oneid_meta_groupperm" VALUES(1192,'796fde63fe7740b581cf86fd45e57004',0,1,'2019-12-27 11:30:58.649828','2019-12-27 04:08:18.619629',0,0,19,37);
INSERT INTO "oneid_meta_groupperm" VALUES(1193,'7fcf184b10484b7fa3d442ec333faea3',0,1,'2019-12-27 11:30:58.820518','2019-12-27 04:08:18.621955',0,0,19,38);
INSERT INTO "oneid_meta_groupperm" VALUES(1194,'dd35421177e04dc8bc58699fd7307452',0,1,'2019-12-27 11:30:58.990038','2019-12-27 04:08:18.625323',0,0,19,39);
INSERT INTO "oneid_meta_groupperm" VALUES(1195,'790e7dec19c44c78a5a378176eb62539',0,1,'2019-12-27 11:30:59.321284','2019-12-27 04:08:18.632668',0,0,19,40);
INSERT INTO "oneid_meta_groupperm" VALUES(1196,'6c4137b2680b41ffb721e24a9c69cc16',0,1,'2019-12-27 11:30:59.651463','2019-12-27 04:08:18.635436',0,0,19,41);
INSERT INTO "oneid_meta_groupperm" VALUES(1197,'a770373fa60c491b82fd608d78b4e782',0,1,'2019-12-27 11:30:59.986506','2019-12-27 04:08:18.637401',0,0,19,42);
INSERT INTO "oneid_meta_groupperm" VALUES(1198,'eb738b21dd774d4db730615e7158643e',0,1,'2019-12-27 11:31:00.168653','2019-12-27 04:08:18.639318',0,0,19,43);
INSERT INTO "oneid_meta_groupperm" VALUES(1199,'4e158a6da5de47fb898bd5583d4fb178',0,1,'2019-12-27 11:30:50.564641','2019-12-27 04:08:18.641301',0,0,19,44);
INSERT INTO "oneid_meta_groupperm" VALUES(1200,'0b124018a34a4ab58bd04cb41b2e631d',0,1,'2019-12-27 11:31:00.835397','2019-12-27 04:08:18.643286',0,0,19,45);
INSERT INTO "oneid_meta_groupperm" VALUES(1201,'c484e36c3e8f4930bbb4ec69042acc96',0,1,'2019-12-27 11:30:50.729285','2019-12-27 04:08:18.647804',0,0,19,46);
INSERT INTO "oneid_meta_groupperm" VALUES(1202,'676653b1f00e494ebde7c4d1aed0c9da',0,1,'2019-12-27 11:31:00.340922','2019-12-27 04:08:18.651488',0,0,19,47);
INSERT INTO "oneid_meta_groupperm" VALUES(1203,'9baa0ab4c1d540939169f37c6a4e94aa',0,1,'2019-12-27 11:31:00.506074','2019-12-27 04:08:18.653720',0,0,19,48);
INSERT INTO "oneid_meta_groupperm" VALUES(1204,'8dcddcdc9d6d4cafb7deeb88fbff5331',0,1,'2019-12-27 11:31:00.669954','2019-12-27 04:08:18.655901',0,0,19,49);
INSERT INTO "oneid_meta_groupperm" VALUES(1205,'b17c6eb254f349bc83c8a676e0bbaf51',0,1,'2019-12-27 11:31:01.002247','2019-12-27 04:08:18.658566',0,0,19,50);
INSERT INTO "oneid_meta_groupperm" VALUES(1206,'3dd8aa0b7e57475f9a4932def877f178',0,1,'2019-12-27 11:31:01.166684','2019-12-27 04:08:18.661806',0,0,19,51);
INSERT INTO "oneid_meta_groupperm" VALUES(1207,'f0e9ab2e27e8413896f61c58780fbb7f',0,1,'2019-12-27 11:31:01.329868','2019-12-27 04:08:18.672638',0,0,19,52);
INSERT INTO "oneid_meta_groupperm" VALUES(1208,'50dd674b270c4e5b984b77ad6dda6c21',0,1,'2019-12-27 11:30:50.901458','2019-12-27 04:08:18.676930',0,0,19,53);
INSERT INTO "oneid_meta_groupperm" VALUES(1209,'3e74100ce5a94a8a9d9c47303f5169e9',0,1,'2019-12-27 11:30:51.076063','2019-12-27 04:08:18.683530',0,0,19,54);
INSERT INTO "oneid_meta_groupperm" VALUES(1210,'8cf08653a9b744048ddc98213a874b7f',0,1,'2019-12-27 11:30:51.248577','2019-12-27 04:08:18.689260',0,0,19,55);
INSERT INTO "oneid_meta_groupperm" VALUES(1211,'1aea59eaf4174087a19fb8b374e25f86',0,1,'2019-12-27 11:30:51.415870','2019-12-27 04:08:18.692389',0,0,19,56);
INSERT INTO "oneid_meta_groupperm" VALUES(1212,'b05b947cce064f4c80db144100685b1b',0,1,'2019-12-27 11:30:51.590395','2019-12-27 04:08:18.718790',0,0,19,57);
INSERT INTO "oneid_meta_groupperm" VALUES(1213,'ee2a1f30c5954f74887c686b698545da',0,1,'2019-12-27 11:31:01.491223','2019-12-27 04:08:18.723654',0,0,19,58);
INSERT INTO "oneid_meta_groupperm" VALUES(1214,'9316a632b9af48a4b1a121dfd18ada06',0,1,'2019-12-27 11:30:51.754266','2019-12-27 04:08:18.726496',0,0,19,59);
INSERT INTO "oneid_meta_groupperm" VALUES(1215,'1a0fcfe9c9dd41b1abb2e4a81a82cc48',0,1,'2019-12-27 11:30:51.923365','2019-12-27 04:08:18.751299',0,0,19,60);
INSERT INTO "oneid_meta_groupperm" VALUES(1216,'9353df0b153c4a14b80cb8e95f7530f1',0,1,'2019-12-27 11:30:52.090071','2019-12-27 04:08:18.754930',0,0,19,61);
INSERT INTO "oneid_meta_groupperm" VALUES(1217,'0eda2a3dabab4b2280fe7d3ff4bbfac2',0,1,'2019-12-27 11:30:52.271298','2019-12-27 04:08:18.757281',0,0,19,62);
INSERT INTO "oneid_meta_groupperm" VALUES(1218,'b0ff4707f52d4d3894ddf47dd7d12576',0,1,'2019-12-27 11:30:50.069785','2019-12-27 04:08:18.847717',0,0,20,1);
INSERT INTO "oneid_meta_groupperm" VALUES(1219,'ecab6d1fe5844670836ed46786b58c7d',0,1,'2019-12-27 11:30:50.232024','2019-12-27 04:08:18.850127',0,0,20,2);
INSERT INTO "oneid_meta_groupperm" VALUES(1220,'d78cb74d96c94b368ff39e13b3dbd55e',0,1,'2019-12-27 11:31:01.661086','2019-12-27 04:08:18.852444',0,0,20,3);
INSERT INTO "oneid_meta_groupperm" VALUES(1221,'b22e422829e24d3cb3e27fc10eb2c8c9',0,1,'2019-12-27 11:30:50.399156','2019-12-27 04:08:18.855403',0,0,20,4);
INSERT INTO "oneid_meta_groupperm" VALUES(1222,'23673cea6ff84989b8c033e9bb3c196a',0,1,'2019-12-27 11:30:53.428217','2019-12-27 04:08:18.858120',0,0,20,5);
INSERT INTO "oneid_meta_groupperm" VALUES(1223,'4826505cd0eb4ed39ad85a423166318a',0,1,'2019-12-27 11:30:56.832264','2019-12-27 04:08:18.861260',0,0,20,6);
INSERT INTO "oneid_meta_groupperm" VALUES(1224,'3c453d37e33d4922bb149020ee49f619',0,1,'2019-12-27 11:30:53.610106','2019-12-27 04:08:18.867617',0,0,20,7);
INSERT INTO "oneid_meta_groupperm" VALUES(1225,'7da895c114cf460d9f90584a440d907a',0,1,'2019-12-27 11:30:53.782535','2019-12-27 04:08:18.869721',0,0,20,8);
INSERT INTO "oneid_meta_groupperm" VALUES(1226,'5ac64b39927c492b9efb455794d28045',0,1,'2019-12-27 11:30:53.959927','2019-12-27 04:08:18.873109',0,0,20,9);
INSERT INTO "oneid_meta_groupperm" VALUES(1227,'c63ac1df8df94dff8a4a13adcf724924',0,1,'2019-12-27 11:30:54.127845','2019-12-27 04:08:18.875114',0,0,20,10);
INSERT INTO "oneid_meta_groupperm" VALUES(1228,'0b1d70ff48494f44b4308f103d25ac1a',0,1,'2019-12-27 11:30:54.299353','2019-12-27 04:08:18.877075',0,0,20,11);
INSERT INTO "oneid_meta_groupperm" VALUES(1229,'285a03305f2e4c7d8f1a63198c20f339',0,1,'2019-12-27 11:30:54.472423','2019-12-27 04:08:18.879533',0,0,20,12);
INSERT INTO "oneid_meta_groupperm" VALUES(1230,'ff1d83bc9503471287da025e5fe5db6a',0,1,'2019-12-27 11:30:54.640924','2019-12-27 04:08:18.884375',0,0,20,13);
INSERT INTO "oneid_meta_groupperm" VALUES(1231,'10e38c60c5e64dcfbecb03389b7937bb',0,1,'2019-12-27 11:30:55.681713','2019-12-27 04:08:18.887345',0,0,20,14);
INSERT INTO "oneid_meta_groupperm" VALUES(1232,'71d5681bd7974f268a5c1816b0fa9e46',0,1,'2019-12-27 11:30:56.024955','2019-12-27 04:08:18.889784',0,0,20,15);
INSERT INTO "oneid_meta_groupperm" VALUES(1233,'2bcef8ca5dc447d3bf7f450bb082d009',0,1,'2019-12-27 11:30:56.416764','2019-12-27 04:08:18.892038',0,0,20,16);
INSERT INTO "oneid_meta_groupperm" VALUES(1234,'657a48d4029d4e8a99e78f367067df25',0,1,'2019-12-27 11:30:54.821432','2019-12-27 04:08:18.894175',0,0,20,17);
INSERT INTO "oneid_meta_groupperm" VALUES(1235,'a8009aee6dc544339781c56620bcea60',0,1,'2019-12-27 11:30:55.000362','2019-12-27 04:08:18.896847',0,0,20,18);
INSERT INTO "oneid_meta_groupperm" VALUES(1236,'abfdc4de9b634ce996864e323a4aa6a8',0,1,'2019-12-27 11:30:55.174979','2019-12-27 04:08:18.900063',0,0,20,19);
INSERT INTO "oneid_meta_groupperm" VALUES(1237,'22b3aefa195e44ce85c0ff461c464faf',0,1,'2019-12-27 11:30:55.341623','2019-12-27 04:08:18.903909',0,0,20,20);
INSERT INTO "oneid_meta_groupperm" VALUES(1238,'182358c8c0814a29a8207dd4ed414492',0,1,'2019-12-27 11:30:55.510839','2019-12-27 04:08:18.906378',0,0,20,21);
INSERT INTO "oneid_meta_groupperm" VALUES(1239,'0aaf1dc547894068ad1848684d2e9061',0,1,'2019-12-27 11:30:57.022220','2019-12-27 04:08:18.908515',0,0,20,22);
INSERT INTO "oneid_meta_groupperm" VALUES(1240,'ea783bde21a740008e66af3a082ef278',0,1,'2019-12-27 11:30:58.142056','2019-12-27 04:08:18.910510',0,0,20,23);
INSERT INTO "oneid_meta_groupperm" VALUES(1241,'0a4f2e271f1c45e6be269f9d6060321e',0,1,'2019-12-27 11:30:59.163996','2019-12-27 04:08:18.912747',0,0,20,24);
INSERT INTO "oneid_meta_groupperm" VALUES(1242,'b6e847def40e402690454d823c683bb6',0,1,'2019-12-27 11:30:59.492716','2019-12-27 04:08:18.915763',0,0,20,25);
INSERT INTO "oneid_meta_groupperm" VALUES(1243,'9cf80df964c14998a307647f4a19f1f8',0,1,'2019-12-27 11:30:59.824263','2019-12-27 04:08:18.918417',0,0,20,26);
INSERT INTO "oneid_meta_groupperm" VALUES(1244,'e8a0f5e6e1f948a2a81701bd0f4a293d',0,1,'2019-12-27 11:30:55.850299','2019-12-27 04:08:18.920942',0,0,20,27);
INSERT INTO "oneid_meta_groupperm" VALUES(1245,'a57599ca90374728980082891f00ead3',0,1,'2019-12-27 11:30:56.215442','2019-12-27 04:08:18.923120',0,0,20,28);
INSERT INTO "oneid_meta_groupperm" VALUES(1246,'65ca99e5503f47178f3657369305d740',0,1,'2019-12-27 11:30:56.605575','2019-12-27 04:08:18.925187',0,0,20,29);
INSERT INTO "oneid_meta_groupperm" VALUES(1247,'00debc4b2b2e49e6b4185f97b423db71',0,1,'2019-12-27 11:30:57.224410','2019-12-27 04:08:18.927742',0,0,20,30);
INSERT INTO "oneid_meta_groupperm" VALUES(1248,'c50d4eeb6750495990a49c9d761bb1a3',0,1,'2019-12-27 11:30:57.417125','2019-12-27 04:08:18.930560',0,0,20,31);
INSERT INTO "oneid_meta_groupperm" VALUES(1249,'df672de415334fc0a085591e6fa5aba7',0,1,'2019-12-27 11:30:57.596558','2019-12-27 04:08:18.934298',0,0,20,32);
INSERT INTO "oneid_meta_groupperm" VALUES(1250,'be3d307423694be2ab24e40150066c31',0,1,'2019-12-27 11:30:57.775574','2019-12-27 04:08:18.936998',0,0,20,33);
INSERT INTO "oneid_meta_groupperm" VALUES(1251,'e94c27f0d4e7471198082f0eae9dcebb',0,1,'2019-12-27 11:30:57.956151','2019-12-27 04:08:18.939349',0,0,20,34);
INSERT INTO "oneid_meta_groupperm" VALUES(1252,'db85260d0c2a4418ad871105d56aef92',0,1,'2019-12-27 11:30:58.315833','2019-12-27 04:08:18.941517',0,0,20,35);
INSERT INTO "oneid_meta_groupperm" VALUES(1253,'7988c9692bca41ff95ef5b6fe23357e5',0,1,'2019-12-27 11:30:58.487402','2019-12-27 04:08:18.943531',0,0,20,36);
INSERT INTO "oneid_meta_groupperm" VALUES(1254,'b682f3f3d987470bb127ae2fee0d1dbe',0,1,'2019-12-27 11:30:58.657521','2019-12-27 04:08:18.945983',0,0,20,37);
INSERT INTO "oneid_meta_groupperm" VALUES(1255,'417db940fe0b4dfe86c529db3eda07b2',0,1,'2019-12-27 11:30:58.828604','2019-12-27 04:08:18.949426',0,0,20,38);
INSERT INTO "oneid_meta_groupperm" VALUES(1256,'d15774fcdfbe4f0f873f6d3463447507',0,1,'2019-12-27 11:30:58.998164','2019-12-27 04:08:18.951887',0,0,20,39);
INSERT INTO "oneid_meta_groupperm" VALUES(1257,'a1d3a3e5f14045a6b4be783a3ba9eb4a',0,1,'2019-12-27 11:30:59.329339','2019-12-27 04:08:18.954624',0,0,20,40);
INSERT INTO "oneid_meta_groupperm" VALUES(1258,'934a80b90380499abe80730d469b92ab',0,1,'2019-12-27 11:30:59.658890','2019-12-27 04:08:18.958310',0,0,20,41);
INSERT INTO "oneid_meta_groupperm" VALUES(1259,'d2d1a9b42e2d4ef2951e74a0358c4933',0,1,'2019-12-27 11:30:59.994442','2019-12-27 04:08:18.961231',0,0,20,42);
INSERT INTO "oneid_meta_groupperm" VALUES(1260,'39f1f89290f346b1ae71c6fc5fee9a9b',0,1,'2019-12-27 11:31:00.176742','2019-12-27 04:08:18.964006',0,0,20,43);
INSERT INTO "oneid_meta_groupperm" VALUES(1261,'ba8291c218364a1a92c552d9ce805fe1',0,1,'2019-12-27 11:30:50.572475','2019-12-27 04:08:18.967831',0,0,20,44);
INSERT INTO "oneid_meta_groupperm" VALUES(1262,'6b3f1ffce94149ce9ec7190a75f34696',0,1,'2019-12-27 11:31:00.842834','2019-12-27 04:08:18.971082',0,0,20,45);
INSERT INTO "oneid_meta_groupperm" VALUES(1263,'a7abfa9277714ae9b97754d501353f34',0,1,'2019-12-27 11:30:50.736930','2019-12-27 04:08:18.995432',0,0,20,46);
INSERT INTO "oneid_meta_groupperm" VALUES(1264,'42a092ef0566449ab40fad848559d54e',0,1,'2019-12-27 11:31:00.348832','2019-12-27 04:08:19.003296',0,0,20,47);
INSERT INTO "oneid_meta_groupperm" VALUES(1265,'acdcef2681b340a59225304e4256ae9b',0,1,'2019-12-27 11:31:00.513826','2019-12-27 04:08:19.009596',0,0,20,48);
INSERT INTO "oneid_meta_groupperm" VALUES(1266,'86e6a0f00df64e4bb9507f00f3382aad',0,1,'2019-12-27 11:31:00.677802','2019-12-27 04:08:19.022962',0,0,20,49);
INSERT INTO "oneid_meta_groupperm" VALUES(1267,'39b59b98592148848e5c4540d5500a63',0,1,'2019-12-27 11:31:01.009817','2019-12-27 04:08:19.026430',0,0,20,50);
INSERT INTO "oneid_meta_groupperm" VALUES(1268,'d307af68f1bd480f9324eb08e9d51659',0,1,'2019-12-27 11:31:01.174075','2019-12-27 04:08:19.034298',0,0,20,51);
INSERT INTO "oneid_meta_groupperm" VALUES(1269,'513821bd1ee448d5952c378752d687a1',0,1,'2019-12-27 11:31:01.337401','2019-12-27 04:08:19.037547',0,0,20,52);
INSERT INTO "oneid_meta_groupperm" VALUES(1270,'c4ecaa9cfffc4987a33e536c544cdf5b',0,1,'2019-12-27 11:30:50.909520','2019-12-27 04:08:19.040464',0,0,20,53);
INSERT INTO "oneid_meta_groupperm" VALUES(1271,'0426bbdbf99e40d3ac59e43b35ecc5af',0,1,'2019-12-27 11:30:51.083818','2019-12-27 04:08:19.043062',0,0,20,54);
INSERT INTO "oneid_meta_groupperm" VALUES(1272,'55929e9980fa47fbbd746d40c5c423bd',0,1,'2019-12-27 11:30:51.256572','2019-12-27 04:08:19.046091',0,0,20,55);
INSERT INTO "oneid_meta_groupperm" VALUES(1273,'baf06d46145a42ca861fa8c1ca4c7c8d',0,1,'2019-12-27 11:30:51.425034','2019-12-27 04:08:19.048744',0,0,20,56);
INSERT INTO "oneid_meta_groupperm" VALUES(1274,'7ec4020c9b984f9595ae9143e6298217',0,1,'2019-12-27 11:30:51.597967','2019-12-27 04:08:19.052544',0,0,20,57);
INSERT INTO "oneid_meta_groupperm" VALUES(1275,'5c085d74cbff44f4972e789c12ba5e9e',0,1,'2019-12-27 11:31:01.498960','2019-12-27 04:08:19.056295',0,0,20,58);
INSERT INTO "oneid_meta_groupperm" VALUES(1276,'a74f19310e844d1e8c2393a7572269a6',0,1,'2019-12-27 11:30:51.762075','2019-12-27 04:08:19.058790',0,0,20,59);
INSERT INTO "oneid_meta_groupperm" VALUES(1277,'4826e509d7204a289a392ee1fab8fd4e',0,1,'2019-12-27 11:30:51.930967','2019-12-27 04:08:19.060901',0,0,20,60);
INSERT INTO "oneid_meta_groupperm" VALUES(1278,'7fdaab08c5ac4290b342e0dd0cd41cb2',0,1,'2019-12-27 11:30:52.097881','2019-12-27 04:08:19.063949',0,0,20,61);
INSERT INTO "oneid_meta_groupperm" VALUES(1279,'3340555db901425abe021cdc8846f5dd',0,1,'2019-12-27 11:30:52.279179','2019-12-27 04:08:19.067092',0,0,20,62);
INSERT INTO "oneid_meta_groupperm" VALUES(1280,'e2bb4e4f5e3c4c7c8793caf6f20f2682',0,1,'2019-12-27 11:30:52.454386','2019-12-27 04:08:19.069311',0,0,20,63);
INSERT INTO "oneid_meta_groupperm" VALUES(1281,'1573f267de0c4d0cae39036509352edc',0,1,'2019-12-27 11:30:50.074557','2019-12-27 04:08:19.162562',0,0,21,1);
INSERT INTO "oneid_meta_groupperm" VALUES(1282,'004380a8a53945299b855fece1b967cf',0,1,'2019-12-27 11:30:50.239986','2019-12-27 04:08:19.166875',0,0,21,2);
INSERT INTO "oneid_meta_groupperm" VALUES(1283,'a9b8eda7e34349a79817b34dfec80139',0,1,'2019-12-27 11:31:01.669647','2019-12-27 04:08:19.169384',0,0,21,3);
INSERT INTO "oneid_meta_groupperm" VALUES(1284,'38461cb72b7f43bea68e4f89ce65cd2d',0,1,'2019-12-27 11:30:50.406868','2019-12-27 04:08:19.171614',0,0,21,4);
INSERT INTO "oneid_meta_groupperm" VALUES(1285,'425415880fbb481d9bb757490cae164b',0,1,'2019-12-27 11:30:53.436534','2019-12-27 04:08:19.173693',0,0,21,5);
INSERT INTO "oneid_meta_groupperm" VALUES(1286,'def055d1d0bb411f933c0d3fec001cf0',0,1,'2019-12-27 11:30:56.843412','2019-12-27 04:08:19.176394',0,0,21,6);
INSERT INTO "oneid_meta_groupperm" VALUES(1287,'6c684b7e1f624ae88838a66a6fe86f0d',0,1,'2019-12-27 11:30:53.618604','2019-12-27 04:08:19.178757',0,0,21,7);
INSERT INTO "oneid_meta_groupperm" VALUES(1288,'5ac5cdc8892e49569ba87ef74ef94304',0,1,'2019-12-27 11:30:53.790840','2019-12-27 04:08:19.182234',0,0,21,8);
INSERT INTO "oneid_meta_groupperm" VALUES(1289,'a1b0d740cf3a4a82a16b14d3004e77b3',0,1,'2019-12-27 11:30:53.967995','2019-12-27 04:08:19.185334',0,0,21,9);
INSERT INTO "oneid_meta_groupperm" VALUES(1290,'ec9659cb43ef43c1be86f1ee3e377089',0,1,'2019-12-27 11:30:54.136627','2019-12-27 04:08:19.188159',0,0,21,10);
INSERT INTO "oneid_meta_groupperm" VALUES(1291,'ccec8d060f544c43a0870115f38999bf',0,1,'2019-12-27 11:30:54.307918','2019-12-27 04:08:19.190168',0,0,21,11);
INSERT INTO "oneid_meta_groupperm" VALUES(1292,'9c86e4b4f293426ebf40eae5bec42065',0,1,'2019-12-27 11:30:54.480405','2019-12-27 04:08:19.192259',0,0,21,12);
INSERT INTO "oneid_meta_groupperm" VALUES(1293,'0d0784bb3a5f45eea6d9cb25bd6fcc28',0,1,'2019-12-27 11:30:54.649130','2019-12-27 04:08:19.194203',0,0,21,13);
INSERT INTO "oneid_meta_groupperm" VALUES(1294,'026d0f22803b46d78c19e9f1bf7097d5',0,1,'2019-12-27 11:30:55.689926','2019-12-27 04:08:19.197833',0,0,21,14);
INSERT INTO "oneid_meta_groupperm" VALUES(1295,'a6b5356ef5cb4694b8332b7d80da037e',0,1,'2019-12-27 11:30:56.033196','2019-12-27 04:08:19.200407',0,0,21,15);
INSERT INTO "oneid_meta_groupperm" VALUES(1296,'82abc1f3f77243f68685f465c926ca82',0,1,'2019-12-27 11:30:56.426035','2019-12-27 04:08:19.202363',0,0,21,16);
INSERT INTO "oneid_meta_groupperm" VALUES(1297,'cb9d41f7e07442fa8f41e69a4e7241ad',0,1,'2019-12-27 11:30:54.829650','2019-12-27 04:08:19.204325',0,0,21,17);
INSERT INTO "oneid_meta_groupperm" VALUES(1298,'74fdb8d7dab249609a392715ab058ea5',0,1,'2019-12-27 11:30:55.013255','2019-12-27 04:08:19.206330',0,0,21,18);
INSERT INTO "oneid_meta_groupperm" VALUES(1299,'2c0b1ade61514ef9a39e76b5a560cf11',0,1,'2019-12-27 11:30:55.182684','2019-12-27 04:08:19.208563',0,0,21,19);
INSERT INTO "oneid_meta_groupperm" VALUES(1300,'17c0ee1c2169435b914eeef91eb46ad6',0,1,'2019-12-27 11:30:55.349039','2019-12-27 04:08:19.211269',0,0,21,20);
INSERT INTO "oneid_meta_groupperm" VALUES(1301,'300b674524db4d3cbc026679b36962e4',0,1,'2019-12-27 11:30:55.518590','2019-12-27 04:08:19.213411',0,0,21,21);
INSERT INTO "oneid_meta_groupperm" VALUES(1302,'1363f91bbc1247b7b73a0b44884c2bd5',0,1,'2019-12-27 11:30:57.031233','2019-12-27 04:08:19.215362',0,0,21,22);
INSERT INTO "oneid_meta_groupperm" VALUES(1303,'069285981e284b83ad0e9beeb258ae48',0,1,'2019-12-27 11:30:58.150221','2019-12-27 04:08:19.217268',0,0,21,23);
INSERT INTO "oneid_meta_groupperm" VALUES(1304,'e1ec02d73b5f48ec82546cf40f618f9c',0,1,'2019-12-27 11:30:59.171840','2019-12-27 04:08:19.219170',0,0,21,24);
INSERT INTO "oneid_meta_groupperm" VALUES(1305,'515966c456c544a0b6a74f067edf2985',0,1,'2019-12-27 11:30:59.500557','2019-12-27 04:08:19.221903',0,0,21,25);
INSERT INTO "oneid_meta_groupperm" VALUES(1306,'467a661576dd43cb924ab449aa655cc0',0,1,'2019-12-27 11:30:59.834358','2019-12-27 04:08:19.224163',0,0,21,26);
INSERT INTO "oneid_meta_groupperm" VALUES(1307,'cc335664a8fc4877b050861ec576697d',0,1,'2019-12-27 11:30:55.858981','2019-12-27 04:08:19.226145',0,0,21,27);
INSERT INTO "oneid_meta_groupperm" VALUES(1308,'8c95305e1e464acfb2a273d93244fa91',0,1,'2019-12-27 11:30:56.226210','2019-12-27 04:08:19.228319',0,0,21,28);
INSERT INTO "oneid_meta_groupperm" VALUES(1309,'6946e65a72974ae2b800a3d6715a5a7c',0,1,'2019-12-27 11:30:56.614459','2019-12-27 04:08:19.231209',0,0,21,29);
INSERT INTO "oneid_meta_groupperm" VALUES(1310,'a9f7043a60c5401c9eef850d8bac44f6',0,1,'2019-12-27 11:30:57.232769','2019-12-27 04:08:19.234154',0,0,21,30);
INSERT INTO "oneid_meta_groupperm" VALUES(1311,'12bc2f1c9c80422cbe8991a27625aec8',0,1,'2019-12-27 11:30:57.426755','2019-12-27 04:08:19.236167',0,0,21,31);
INSERT INTO "oneid_meta_groupperm" VALUES(1312,'f19f8866a7db44a1a6d05963ce37b757',0,1,'2019-12-27 11:30:57.604941','2019-12-27 04:08:19.238489',0,0,21,32);
INSERT INTO "oneid_meta_groupperm" VALUES(1313,'f39084031d05462395b8af0aa0a51424',0,1,'2019-12-27 11:30:57.783392','2019-12-27 04:08:19.240521',0,0,21,33);
INSERT INTO "oneid_meta_groupperm" VALUES(1314,'fe87e719bb024202a3f1e932555563c7',0,1,'2019-12-27 11:30:57.964585','2019-12-27 04:08:19.243061',0,0,21,34);
INSERT INTO "oneid_meta_groupperm" VALUES(1315,'0997671d65e344a586239ed8a6751066',0,1,'2019-12-27 11:30:58.323488','2019-12-27 04:08:19.245138',0,0,21,35);
INSERT INTO "oneid_meta_groupperm" VALUES(1316,'652cf0650c914db487423d62a5770556',0,1,'2019-12-27 11:30:58.495525','2019-12-27 04:08:19.247200',0,0,21,36);
INSERT INTO "oneid_meta_groupperm" VALUES(1317,'d406f5c1c8484e28a453d31ad9c44709',0,1,'2019-12-27 11:30:58.665619','2019-12-27 04:08:19.249261',0,0,21,37);
INSERT INTO "oneid_meta_groupperm" VALUES(1318,'b5c739c8c5924bff84b7e93b7d15f6cd',0,1,'2019-12-27 11:30:58.836072','2019-12-27 04:08:19.251856',0,0,21,38);
INSERT INTO "oneid_meta_groupperm" VALUES(1319,'09e10cf519ef41d9a4636d6180be21ae',0,1,'2019-12-27 11:30:59.006261','2019-12-27 04:08:19.254445',0,0,21,39);
INSERT INTO "oneid_meta_groupperm" VALUES(1320,'b31b7f279f2f4cc3a05893ca6cb29e90',0,1,'2019-12-27 11:30:59.337053','2019-12-27 04:08:19.256730',0,0,21,40);
INSERT INTO "oneid_meta_groupperm" VALUES(1321,'ebb38ee40efe495eb8c536c1687492bf',0,1,'2019-12-27 11:30:59.667309','2019-12-27 04:08:19.258758',0,0,21,41);
INSERT INTO "oneid_meta_groupperm" VALUES(1322,'3e64423009ca4053ba0f754c8bbbc1dc',0,1,'2019-12-27 11:31:00.002614','2019-12-27 04:08:19.260763',0,0,21,42);
INSERT INTO "oneid_meta_groupperm" VALUES(1323,'8bc37dacf0314eaea4724c3a3b3af37c',0,1,'2019-12-27 11:31:00.184530','2019-12-27 04:08:19.262743',0,0,21,43);
INSERT INTO "oneid_meta_groupperm" VALUES(1324,'84cbf1a7bf5b4169b7bdb8bf2839d143',0,1,'2019-12-27 11:30:50.580364','2019-12-27 04:08:19.265301',0,0,21,44);
INSERT INTO "oneid_meta_groupperm" VALUES(1325,'edf34f3af4b24a93b1fce23a254e5678',0,1,'2019-12-27 11:31:00.850929','2019-12-27 04:08:19.267557',0,0,21,45);
INSERT INTO "oneid_meta_groupperm" VALUES(1326,'51456aef81db4f20911f7bee3d4b3994',0,1,'2019-12-27 11:30:50.744785','2019-12-27 04:08:19.269537',0,0,21,46);
INSERT INTO "oneid_meta_groupperm" VALUES(1327,'cafffc953ff545c28b1c31390a3597a9',0,1,'2019-12-27 11:31:00.356939','2019-12-27 04:08:19.271492',0,0,21,47);
INSERT INTO "oneid_meta_groupperm" VALUES(1328,'369016b057c14b7697f6f213cdfeec1b',0,1,'2019-12-27 11:31:00.521568','2019-12-27 04:08:19.273465',0,0,21,48);
INSERT INTO "oneid_meta_groupperm" VALUES(1329,'5e941b1270c04bdfa5ad3d709c5cc976',0,1,'2019-12-27 11:31:00.685321','2019-12-27 04:08:19.275420',0,0,21,49);
INSERT INTO "oneid_meta_groupperm" VALUES(1330,'aaa690e80593493f82894be97391f61a',0,1,'2019-12-27 11:31:01.017817','2019-12-27 04:08:19.277867',0,0,21,50);
INSERT INTO "oneid_meta_groupperm" VALUES(1331,'372f90bec40345669d9b3b7b6073d8e2',0,1,'2019-12-27 11:31:01.181837','2019-12-27 04:08:19.280344',0,0,21,51);
INSERT INTO "oneid_meta_groupperm" VALUES(1332,'4300f79e2e8a4ccdbbb3a37afc65771a',0,1,'2019-12-27 11:31:01.344994','2019-12-27 04:08:19.282383',0,0,21,52);
INSERT INTO "oneid_meta_groupperm" VALUES(1333,'e25e9afa647549309357f64e113b1a59',0,1,'2019-12-27 11:30:50.918747','2019-12-27 04:08:19.284775',0,0,21,53);
INSERT INTO "oneid_meta_groupperm" VALUES(1334,'4af003c25dc14972accee67776adb0d7',0,1,'2019-12-27 11:30:51.091745','2019-12-27 04:08:19.287216',0,0,21,54);
INSERT INTO "oneid_meta_groupperm" VALUES(1335,'986f621d26554ddfb6fd18202c7d16b9',0,1,'2019-12-27 11:30:51.264235','2019-12-27 04:08:19.289684',0,0,21,55);
INSERT INTO "oneid_meta_groupperm" VALUES(1336,'ba74dded5d93479d97976d033580acf3',0,1,'2019-12-27 11:30:51.433430','2019-12-27 04:08:19.291816',0,0,21,56);
INSERT INTO "oneid_meta_groupperm" VALUES(1337,'5f026585d31340a89fa8e90553e60542',0,1,'2019-12-27 11:30:51.605845','2019-12-27 04:08:19.293771',0,0,21,57);
INSERT INTO "oneid_meta_groupperm" VALUES(1338,'d9e777bdb92b44dda6be07b915a301fe',0,1,'2019-12-27 11:31:01.506646','2019-12-27 04:08:19.295736',0,0,21,58);
INSERT INTO "oneid_meta_groupperm" VALUES(1339,'4a84bd893b9c419889e2ae9d07dfec51',0,1,'2019-12-27 11:30:51.769605','2019-12-27 04:08:19.297751',0,0,21,59);
INSERT INTO "oneid_meta_groupperm" VALUES(1340,'cca162a487724ea2b390ac736b07bc69',0,1,'2019-12-27 11:30:51.938724','2019-12-27 04:08:19.300195',0,0,21,60);
INSERT INTO "oneid_meta_groupperm" VALUES(1341,'3202ab41b0694af7b16eac8cab00de3a',0,1,'2019-12-27 11:30:52.105368','2019-12-27 04:08:19.302223',0,0,21,61);
INSERT INTO "oneid_meta_groupperm" VALUES(1342,'b90242f0cb6c4c08b941d12aeb5d40d5',0,1,'2019-12-27 11:30:52.288159','2019-12-27 04:08:19.304194',0,0,21,62);
INSERT INTO "oneid_meta_groupperm" VALUES(1343,'f85fc7b32169484fa35cc6ee8d187622',0,1,'2019-12-27 11:30:52.461728','2019-12-27 04:08:19.306147',0,0,21,63);
INSERT INTO "oneid_meta_groupperm" VALUES(1344,'2d0e84d000f84304a139ae4cac970244',0,1,'2019-12-27 11:30:52.639155','2019-12-27 04:08:19.308103',0,0,21,64);
INSERT INTO "oneid_meta_groupperm" VALUES(1345,'89af76a8afdb4b038b0d993288180794',0,1,'2019-12-27 11:30:52.648215','2019-12-27 04:08:31.959452',0,0,1,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1346,'d3f342f9f93f49f0b794569433870d87',0,1,'2019-12-27 11:30:52.658250','2019-12-27 04:08:31.964450',0,0,2,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1347,'eefdd8487b5641208fa2547810309b2b',0,1,'2019-12-27 11:30:52.666081','2019-12-27 04:08:31.971670',0,0,3,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1348,'fb61a3ffd8e145a9bdf1b7fddc810181',0,1,'2019-12-27 11:30:52.674602','2019-12-27 04:08:31.975916',0,0,4,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1349,'76ab5118c2dc4d1bb756bbe373ffbd00',0,1,'2019-12-27 11:30:52.683070','2019-12-27 04:08:31.982452',0,0,5,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1350,'1d93a6d09f964758a9ddab47b051e2ff',0,1,'2019-12-27 11:30:52.690844','2019-12-27 04:08:31.985079',0,0,6,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1351,'ea403e24f0354ebd8f5a2c9afb08d82b',0,1,'2019-12-27 11:30:52.698507','2019-12-27 04:08:31.992179',0,0,7,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1352,'aea4f458ee5f44ee84341d6004dde810',0,1,'2019-12-27 11:30:52.706167','2019-12-27 04:08:31.995119',0,0,8,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1353,'39132e1686cb4b0ca6b1969962a91ec6',0,1,'2019-12-27 11:30:52.713978','2019-12-27 04:08:32.000881',0,0,9,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1354,'cb7b4bde64c24be6abd8f7628f7876ba',0,1,'2019-12-27 11:30:52.721949','2019-12-27 04:08:32.005782',0,0,10,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1355,'63dde349d2244bfeae547dc10f296a34',0,1,'2019-12-27 11:30:52.729787','2019-12-27 04:08:32.009200',0,0,11,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1356,'d8f7c74479504e4bb380a91af46fc12c',0,1,'2019-12-27 11:30:52.737351','2019-12-27 04:08:32.012259',0,0,12,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1357,'53f136bb1278429587b6504561cf73c9',0,1,'2019-12-27 11:30:52.745082','2019-12-27 04:08:32.015994',0,0,13,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1358,'df25024103784dae942f965c019066ff',0,1,'2019-12-27 11:30:52.753119','2019-12-27 04:08:32.019158',0,0,14,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1359,'e90fd065d2664de7aab00b0087b0c00f',0,1,'2019-12-27 11:30:52.760866','2019-12-27 04:08:32.023907',0,0,15,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1360,'69f8cec5a2b44867aa50d1fab483598b',0,1,'2019-12-27 11:30:52.768745','2019-12-27 04:08:32.028292',0,0,16,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1361,'b20b6634d821404cb7868b235e28eaa7',0,1,'2019-12-27 11:30:52.776118','2019-12-27 04:08:32.031070',0,0,17,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1362,'05a0e9411551447bbc18d4b4cac34117',0,1,'2019-12-27 11:30:52.783891','2019-12-27 04:08:32.033738',0,0,18,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1363,'9b8c84cb75df44bba459f5f7ef69f43e',0,1,'2019-12-27 11:30:52.792267','2019-12-27 04:08:32.036555',0,0,19,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1364,'8d658c5288b34945826e2c4335f2fd94',0,1,'2019-12-27 11:30:52.800291','2019-12-27 04:08:32.043918',0,0,20,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1365,'12c64982f4a8436ab0876dd784f2b42b',0,1,'2019-12-27 11:30:52.807996','2019-12-27 04:08:32.047059',0,0,21,65);
INSERT INTO "oneid_meta_groupperm" VALUES(1366,'747a6915ace745dfb5f02451e8aefecb',0,1,'2019-12-27 11:30:52.841997','2019-12-27 04:09:04.325705',1,1,5,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1367,'ffa6189e8a644548a878f83c087822cd',0,1,'2019-12-27 11:30:52.844721','2019-12-27 04:09:04.330891',1,1,6,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1368,'cb399c5343bf4e3c865b058717d1eb26',0,1,'2019-12-27 11:30:52.847088','2019-12-27 04:09:04.336031',1,1,7,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1369,'c3955b9cbfe344179c214d5e4f73ce00',0,1,'2019-12-27 11:30:52.849514','2019-12-27 04:09:04.340333',1,1,8,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1370,'823d2d98db64477f9f98f6175930b4cf',0,1,'2019-12-27 11:30:52.852004','2019-12-27 04:09:04.343930',1,1,9,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1371,'6ee986f7bded4535b839619e420f1662',0,1,'2019-12-27 11:30:52.854644','2019-12-27 04:09:04.349693',1,1,10,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1372,'1d57d38e7bb64e889e21e9c84419376c',0,1,'2019-12-27 11:30:52.816425','2019-12-27 04:09:04.358020',0,0,1,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1373,'82a73e7001b24ce1b6138ecdabd28c40',0,1,'2019-12-27 11:30:52.824484','2019-12-27 04:09:04.360219',0,0,2,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1374,'4da30a7d891341ddb5d1f6b9a7fbcaed',0,1,'2019-12-27 11:30:52.832164','2019-12-27 04:09:04.363059',0,0,3,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1375,'c624fe8f03ed435d9be35c0d13e286fa',0,1,'2019-12-27 11:30:52.839604','2019-12-27 04:09:04.366795',0,0,4,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1376,'eaf1868a041544d2ac21643a79bc593c',0,1,'2019-12-27 11:30:52.862073','2019-12-27 04:09:04.375587',0,0,11,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1377,'ac94ed7c8d6240b7a68e5203d06d441d',0,1,'2019-12-27 11:30:52.870102','2019-12-27 04:09:04.378230',0,0,12,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1378,'698127073c384ceeb0b92b9ff5651268',0,1,'2019-12-27 11:30:52.879935','2019-12-27 04:09:04.381685',0,0,13,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1379,'42140e85a7814980851e948e3430bf4e',0,1,'2019-12-27 11:30:52.889039','2019-12-27 04:09:04.384087',0,0,14,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1380,'980b2c15743146ccb90c977918f40442',0,1,'2019-12-27 11:30:52.897152','2019-12-27 04:09:04.386395',0,0,15,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1381,'c166741ebff84773a3a3bc2c14fe4c8f',0,1,'2019-12-27 11:30:52.905366','2019-12-27 04:09:04.388571',0,0,16,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1382,'b8315594c20243eeb13acd8e5dbf873a',0,1,'2019-12-27 11:30:52.912727','2019-12-27 04:09:04.391267',0,0,17,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1383,'7a382cf88caf452ab0677695cf2ecc97',0,1,'2019-12-27 11:30:52.921042','2019-12-27 04:09:04.393475',0,0,18,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1384,'d19fd23f1c0c4d83bbf2725b0a028c31',0,1,'2019-12-27 11:30:52.928461','2019-12-27 04:09:04.396180',0,0,19,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1385,'97d93df664e04ef68cd25e6abbe70b57',0,1,'2019-12-27 11:30:52.936381','2019-12-27 04:09:04.399260',0,0,20,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1386,'41e6630720ee40618cb829d8ac7cadad',0,1,'2019-12-27 11:30:52.944066','2019-12-27 04:09:04.401752',0,0,21,66);
INSERT INTO "oneid_meta_groupperm" VALUES(1387,'14a380c4e4ef4df1ac5e235ef06e18e0',0,1,'2019-12-27 11:30:52.986767','2019-12-27 04:14:28.924806',1,1,6,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1388,'3ffa8ef16e5940aaa6306d05a03416d3',0,1,'2019-12-27 11:30:52.989357','2019-12-27 04:14:28.929523',1,1,7,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1389,'4718c694e5bf485687242b2771430e98',0,1,'2019-12-27 11:30:53.007281','2019-12-27 04:14:28.934208',1,1,10,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1390,'e99492a2e56d45aaa2eb0063f2e144de',0,1,'2019-12-27 11:30:52.952938','2019-12-27 04:14:28.943624',0,0,1,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1391,'1b932f2fb50f42b291b448467be9c652',0,1,'2019-12-27 11:30:52.960322','2019-12-27 04:14:28.945886',0,0,2,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1392,'d60cdfb509314c788eb2ebbd922deb14',0,1,'2019-12-27 11:30:52.968504','2019-12-27 04:14:28.948844',0,0,3,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1393,'552c10d96c434b76b0ad65777c436919',0,1,'2019-12-27 11:30:52.976564','2019-12-27 04:14:28.951958',0,0,4,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1394,'74fd8c478bdf4a3eba510fe7f8b07f4e',0,1,'2019-12-27 11:30:52.984218','2019-12-27 04:14:28.954316',0,0,5,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1395,'b2e16fce06cb404a8203de8cbf6a4397',0,1,'2019-12-27 11:30:52.996834','2019-12-27 04:14:28.958906',0,0,8,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1396,'fcc52fcd00bd4203906cbcc62353fb0b',0,1,'2019-12-27 11:30:53.004776','2019-12-27 04:14:28.961109',0,0,9,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1397,'846422f014e9459bb077a613781d907a',0,1,'2019-12-27 11:30:53.015152','2019-12-27 04:14:28.965102',0,0,11,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1398,'150dcb22f0d74cd7b950a874b4aedc54',0,1,'2019-12-27 11:30:53.023374','2019-12-27 04:14:28.968511',0,0,12,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1399,'57bd0ea435274770acaa4da649ee9ac2',0,1,'2019-12-27 11:30:53.031120','2019-12-27 04:14:28.970956',0,0,13,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1400,'9622f6b355be4626b84014332e8ac443',0,1,'2019-12-27 11:30:53.038919','2019-12-27 04:14:28.973122',0,0,14,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1401,'15973087d6664d6faacaadc9dc0b92b8',0,1,'2019-12-27 11:30:53.046375','2019-12-27 04:14:28.975427',0,0,15,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1402,'132b332be3514edc8c12af5715d77e69',0,1,'2019-12-27 11:30:53.054122','2019-12-27 04:14:28.977761',0,0,16,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1403,'1d14ab796581450488181fcde6cc8ded',0,1,'2019-12-27 11:30:53.061688','2019-12-27 04:14:28.980285',0,0,17,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1404,'70733715aa8845778988fde4bda9b057',0,1,'2019-12-27 11:30:53.069694','2019-12-27 04:14:28.983708',0,0,18,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1405,'a1a54b1288b94361a757d636c5f69523',0,1,'2019-12-27 11:30:53.077143','2019-12-27 04:14:28.986515',0,0,19,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1406,'efc67b5c46d64d11b0442ce2feb4c6e5',0,1,'2019-12-27 11:30:53.084886','2019-12-27 04:14:28.989441',0,0,20,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1407,'adb0f06395e240cd88e42e86fb49c138',0,1,'2019-12-27 11:30:53.092420','2019-12-27 04:14:28.991826',0,0,21,67);
INSERT INTO "oneid_meta_groupperm" VALUES(1408,'1a89ae8c2f63413287daaeafd8eafe2e',0,1,'2019-12-27 11:30:53.128050','2019-12-27 04:15:03.249349',1,1,5,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1409,'13bb76974a6d4a809e727004a1cfa2e4',0,1,'2019-12-27 11:30:53.145910','2019-12-27 04:15:03.254624',1,1,8,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1410,'c3a9330f65944bc4bcc96013bdb658cc',0,1,'2019-12-27 11:30:53.148635','2019-12-27 04:15:03.259915',1,1,9,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1411,'8a8378817e084342ac92db4d3493e855',0,1,'2019-12-27 11:30:53.101532','2019-12-27 04:15:03.269277',0,0,1,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1412,'635202866cdb46de8c04b692ca8ae7e2',0,1,'2019-12-27 11:30:53.108951','2019-12-27 04:15:03.272057',0,0,2,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1413,'5e1ac33644db41f793e55e51aa2c9e11',0,1,'2019-12-27 11:30:53.116733','2019-12-27 04:15:03.275697',0,0,3,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1414,'1457a331111245baa11218677a700adf',0,1,'2019-12-27 11:30:53.124778','2019-12-27 04:15:03.278118',0,0,4,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1415,'05bd3617a4034515a6fee7e1ed8eade3',0,1,'2019-12-27 11:30:53.135612','2019-12-27 04:15:03.281626',0,0,6,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1416,'5da2c59024a7464d8ede1d515c0a9ba2',0,1,'2019-12-27 11:30:53.143439','2019-12-27 04:15:03.284231',0,0,7,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1417,'72ca9b6993c649e4b25a0aeccc66f0cd',0,1,'2019-12-27 11:30:53.156163','2019-12-27 04:15:03.288677',0,0,10,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1418,'0e6a8cc9336343d4b81a217c2fb05ff2',0,1,'2019-12-27 11:30:53.163818','2019-12-27 04:15:03.292535',0,0,11,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1419,'c775a5973b4340a49076e90dd18296f0',0,1,'2019-12-27 11:30:53.171872','2019-12-27 04:15:03.295232',0,0,12,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1420,'e1d05975f708474bae65ca192b5b42c5',0,1,'2019-12-27 11:30:53.179289','2019-12-27 04:15:03.297705',0,0,13,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1421,'387dac0bd2dc4117be9fc64b9915e558',0,1,'2019-12-27 11:30:53.187162','2019-12-27 04:15:03.299998',0,0,14,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1422,'efd3869393ce4ec4a772d93160b77d3d',0,1,'2019-12-27 11:30:53.195115','2019-12-27 04:15:03.302219',0,0,15,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1423,'34e8df5f9d47415099aeeef74cdd0bb4',0,1,'2019-12-27 11:30:53.205147','2019-12-27 04:15:03.304680',0,0,16,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1424,'b45cc81d04ab42e4bbf18a6268331eb8',0,1,'2019-12-27 11:30:53.213578','2019-12-27 04:15:03.308234',0,0,17,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1425,'c3b75d50aba44596b0959e50607ee124',0,1,'2019-12-27 11:30:53.222192','2019-12-27 04:15:03.310826',0,0,18,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1426,'914e6daab4b543d2baa554897469be24',0,1,'2019-12-27 11:30:53.230781','2019-12-27 04:15:03.313119',0,0,19,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1427,'357e8faf98a94eefa33eae909061916b',0,1,'2019-12-27 11:30:53.238952','2019-12-27 04:15:03.315333',0,0,20,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1428,'21d988674fc745549b008e496ddcdd5d',0,1,'2019-12-27 11:30:53.246666','2019-12-27 04:15:03.317550',0,0,21,68);
INSERT INTO "oneid_meta_groupperm" VALUES(1429,'824ca0a62b334b06aa2dd761d3687f1c',0,1,'2020-02-25 08:51:34.909105','2020-02-25 08:51:34.790109',1,1,5,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1430,'0630f3e1f1c2455fa2d4687d4e17f1ed',0,1,'2020-02-25 08:51:34.946976','2020-02-25 08:51:34.927551',1,1,6,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1431,'726b3661c04c4e3d94074f54b4e46fcc',0,1,'2020-02-25 08:51:35.023647','2020-02-25 08:51:34.964934',1,1,7,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1432,'f41142929ae243a1bb03d1ac55858e05',0,1,'2020-02-25 08:51:35.173256','2020-02-25 08:51:35.158470',1,1,8,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1433,'11c4230d5cc241aa897d8a4f8bff4928',0,1,'2020-02-25 08:51:35.204564','2020-02-25 08:51:35.191169',1,1,9,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1434,'b24e51a8750e487491c359d8c0961b9e',0,1,'2020-02-25 08:51:35.249601','2020-02-25 08:51:35.221437',1,1,10,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1435,'d4609adaef13410caff7cb2ff668bf33',0,1,'2020-02-25 08:51:35.424542','2020-02-25 08:51:35.424599',0,0,1,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1436,'9e6e493cba16403dba98bf335efeb9b7',0,1,'2020-02-25 08:51:35.599930','2020-02-25 08:51:35.599986',0,0,2,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1437,'97d6428aac914c92ae6457e998c93d78',0,1,'2020-02-25 08:51:35.618237','2020-02-25 08:51:35.618298',0,0,3,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1438,'f2d5f5a38e07462f91dce1a801601ee0',0,1,'2020-02-25 08:51:35.635640','2020-02-25 08:51:35.635699',0,0,4,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1439,'c7716b59aaf34d77a8f02eabe815b105',0,1,'2020-02-25 08:51:35.670594','2020-02-25 08:51:35.670647',0,0,11,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1440,'03614e93829c4e50820a27efa9cb2634',0,1,'2020-02-25 08:51:35.794720','2020-02-25 08:51:35.794789',0,0,12,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1441,'cd09771bd02d4f05a23139bcd55171cc',0,1,'2020-02-25 08:51:35.813889','2020-02-25 08:51:35.813951',0,0,13,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1442,'07c1f8aee6ae4eb182f23a867eeecb75',0,1,'2020-02-25 08:51:35.844188','2020-02-25 08:51:35.844249',0,0,14,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1443,'6b81f41e00f44bddb853b8c28550d4a7',0,1,'2020-02-25 08:51:35.871053','2020-02-25 08:51:35.871120',0,0,15,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1444,'03a9439f7bf3435abec9661c813a96b6',0,1,'2020-02-25 08:51:35.891191','2020-02-25 08:51:35.891254',0,0,16,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1445,'2e3d195b77224b77927bcaa87e9392ee',0,1,'2020-02-25 08:51:36.013748','2020-02-25 08:51:36.013809',0,0,17,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1446,'c108c6e4770a432999af4d2412965235',0,1,'2020-02-25 08:51:36.032014','2020-02-25 08:51:36.032076',0,0,18,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1447,'923386942e814e9bb0c3fe65bd01a5a4',0,1,'2020-02-25 08:51:36.048986','2020-02-25 08:51:36.049048',0,0,19,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1448,'00a3fa03334142c79bb827632fcbcd2c',0,1,'2020-02-25 08:51:36.065937','2020-02-25 08:51:36.065998',0,0,20,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1449,'a0e464cdbc4d473e975dd2aa4e4780bb',0,1,'2020-02-25 08:51:36.083142','2020-02-25 08:51:36.083204',0,0,21,69);
INSERT INTO "oneid_meta_groupperm" VALUES(1450,'deff08ec45034b1e86a6363940aea2b9',0,1,'2020-02-25 08:52:11.976994','2020-02-25 08:52:11.977057',0,0,1,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1451,'dd37bf4ef5744de28b773811c46f4835',0,1,'2020-02-25 08:52:12.074155','2020-02-25 08:52:12.074218',0,0,2,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1452,'fa79cf688e814df2b62fb519d6d76c01',0,1,'2020-02-25 08:52:12.092299','2020-02-25 08:52:12.092360',0,0,3,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1453,'753690835040405484e8a7c9b387a4d5',0,1,'2020-02-25 08:52:12.265783','2020-02-25 08:52:12.265850',0,0,4,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1454,'dd15ea955af34b96b65edb37a6e7422d',0,1,'2020-02-25 08:52:12.283179','2020-02-25 08:52:12.283238',0,0,5,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1455,'b1a3d4df811f4c7fb006c138d771692d',0,1,'2020-02-25 08:52:12.299271','2020-02-25 08:52:12.299329',0,0,6,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1456,'7991f407a27c422a92e1d7a8a922c942',0,1,'2020-02-25 08:52:12.316508','2020-02-25 08:52:12.316562',0,0,7,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1457,'34e6872b5e8841838bf525f127834599',0,1,'2020-02-25 08:52:12.411967','2020-02-25 08:52:12.412027',0,0,8,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1458,'aaeedfeec689434cbc59ea5d07d7a61f',0,1,'2020-02-25 08:52:12.443239','2020-02-25 08:52:12.443302',0,0,9,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1459,'4382ee7e541e4ed7859ace6b22226084',0,1,'2020-02-25 08:52:12.464588','2020-02-25 08:52:12.464651',0,0,10,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1460,'00b5432331b941349c2837ef3183dabb',0,1,'2020-02-25 08:52:12.558830','2020-02-25 08:52:12.558892',0,0,11,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1461,'8abb816f95da428183a15e0d5dc5e2b7',0,1,'2020-02-25 08:52:12.604838','2020-02-25 08:52:12.604901',0,0,12,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1462,'62a75748378946fa8d3f72eaca062865',0,1,'2020-02-25 08:52:12.704486','2020-02-25 08:52:12.704557',0,0,13,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1463,'082f1022aabf4046b0b82ad54c9ac3e9',0,1,'2020-02-25 08:52:12.794842','2020-02-25 08:52:12.794905',0,0,14,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1464,'419ee6f6f0204f878cf9e0ec373a9cef',0,1,'2020-02-25 08:52:12.837040','2020-02-25 08:52:12.837103',0,0,15,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1465,'9400a42a151e46feb31dc9c4baa91309',0,1,'2020-02-25 08:52:12.858147','2020-02-25 08:52:12.858489',0,0,16,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1466,'6096a6e7929642e9ba554ee6a55843fb',0,1,'2020-02-25 08:52:12.876690','2020-02-25 08:52:12.876751',0,0,17,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1467,'fa5556678ca14a61969b2190789c3b7d',0,1,'2020-02-25 08:52:12.894936','2020-02-25 08:52:12.894998',0,0,18,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1468,'cc6356fc5b774ebf88b47a55b45c1e60',0,1,'2020-02-25 08:52:12.972516','2020-02-25 08:52:12.972591',0,0,19,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1469,'5894f72234154ab59f30e11f373d5eee',0,1,'2020-02-25 08:52:13.128040','2020-02-25 08:52:13.128102',0,0,20,70);
INSERT INTO "oneid_meta_groupperm" VALUES(1470,'5f7e7c4662624f17900be5a26888df37',0,1,'2020-02-25 08:52:13.191002','2020-02-25 08:52:13.191064',0,0,21,70);
CREATE TABLE "oneid_meta_httpapp" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "app_id" integer NULL UNIQUE REFERENCES "oneid_meta_app" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_idpconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "cert" varchar(2500) NOT NULL, "key" varchar(2500) NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_idpconfig" VALUES(1,'d56f1fc835384f9ea59a7c184fbaaa73',0,1,'2019-12-20 08:46:43.040478','2019-12-20 08:46:43.039773','[''-----BEGIN CERTIFICATE-----\n'', ''MIIBwDCCASkCAgPoMA0GCSqGSIb3DQEBBQUAMCgxCzAJBgNVBAYTAkNOMRkwFwYD\n'', ''VQQDDBB1c2VyZGVpTWFjLmxvY2FsMB4XDTE5MTIyMDA4NDY0MloXDTI5MTIxNzA4\n'', ''NDY0MlowKDELMAkGA1UEBhMCQ04xGTAXBgNVBAMMEHVzZXJkZWlNYWMubG9jYWww\n'', ''gZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALbjjE+1NDfJMjMbFNIma0QaiCMy\n'', ''H1h3V8M1OmkbHg3pOs2rcJDt77scPSFEtXhFnzf+tnpzRV04If9tVBx5yvqAdIZ9\n'', ''8xpajTVtkHm6sLWUB1NmthO6dlWirrvta7ThdTT2gK7Eelu+Ao8h+QPVf4Ym9u6F\n'', ''h0wd9cEY3jEzZYzLAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEAoZE1I2nOSkvb2aEi\n'', ''NMpWnNG2lKWCYR6a5PLsEIeLLfI7mPh63BngeBrZ+bjALAhBZzDZT4GDR/tdCpIz\n'', ''gqgaZYJVWisz6t1hp0faM1q+SyY359juFsp8Yg6DdUv/+IQPyjEBFNWfz5DFjIiY\n'', ''3AknVXhsNC4/Xv29osB2pThVsZI=\n'', ''-----END CERTIFICATE-----\n'']','[''-----BEGIN PRIVATE KEY-----\n'', ''MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALbjjE+1NDfJMjMb\n'', ''FNIma0QaiCMyH1h3V8M1OmkbHg3pOs2rcJDt77scPSFEtXhFnzf+tnpzRV04If9t\n'', ''VBx5yvqAdIZ98xpajTVtkHm6sLWUB1NmthO6dlWirrvta7ThdTT2gK7Eelu+Ao8h\n'', ''+QPVf4Ym9u6Fh0wd9cEY3jEzZYzLAgMBAAECgYEAjRUkHCjwy0gNzZbKjQLOJI9D\n'', ''DcOQorINpazeDk649IpCrn3eLC8gi/rQvWU/iDRNCukW44cgrzSqJVy1UfIyPZYX\n'', ''F98nUQ0U1jWks9c/cFgPDcsPeXbQ34Y51kdg9sVSaBlX5wz5w/wvjHb1SpEeBcfX\n'', ''IzXfV3/lvOZ3nfa8SCECQQDaoDRmJx2vv9zREWWBiNhqdYDk8egQ5AAbdVQWbI9X\n'', ''nH877R2h0YldgKQwIPIc9uTu1Vx8Or+tgGY+O/fFI0JlAkEA1idgI21bDWm8neZE\n'', ''/zsRR8rznNxaIq7sBpROdFbrfzogy/mrUgLPEMl+q5dy5BlGTnJ+ONgjMwopokhF\n'', ''Tu8HbwJAbsF0aj/swSlww5WNl+bsxFoM129ZwpzPFRoGZGnQ4HCO4JwKQ/00GuNd\n'', ''ymgWX+gQKJJ8jQ7yJgKDSYn1xrBLJQJAYuVyL0ocB1iyIxUo/dkQROBDmkfkVCoF\n'', ''k5A/nthZDrsQVEIrTMdBSpZSqflZtF67qhSTl7qwnqxtx6SqZSZbfwJAJJvUKCI3\n'', ''5eEe2ZteXJZMYr/4Mw1VXDxGib1c+WpDbwNgvQqsvLgTV767Ve4QbD5QAz6NmXs9\n'', ''QqedeR+UyZQpaw==\n'', ''-----END PRIVATE KEY-----\n'']',1);
CREATE TABLE "oneid_meta_invitation" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "duration" bigint NOT NULL, "is_accepted" bool NOT NULL, "invitee_id" integer NOT NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED, "inviter_id" integer NOT NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_invitation" VALUES(1,'c95b02be297e4ae3be63c45498f4dd63',0,1,'2019-11-16 09:54:41.059641','2019-11-16 09:54:41.059670',0,0,4,1);
INSERT INTO "oneid_meta_invitation" VALUES(2,'46506ad66ad241a98a925fdfa88ad514',0,1,'2019-11-16 09:54:52.692893','2019-11-16 09:54:52.692938',86400000000,0,4,1);
INSERT INTO "oneid_meta_invitation" VALUES(3,'3437d3e635884436868beb2dd10777b9',0,1,'2019-11-16 09:55:28.117470','2019-11-16 09:55:28.117496',86400000000,0,5,1);
INSERT INTO "oneid_meta_invitation" VALUES(4,'411adc05e5c942ef8ddb4a8e167a0876',0,1,'2019-11-16 09:55:54.582277','2019-11-16 09:55:54.582304',86400000000,0,6,1);
INSERT INTO "oneid_meta_invitation" VALUES(5,'49bd759b88174c36975140ecf731e94f',0,1,'2019-11-16 09:56:45.971497','2019-11-16 09:56:45.971523',86400000000,0,7,1);
CREATE TABLE "oneid_meta_ldapapp" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "app_id" integer NULL UNIQUE REFERENCES "oneid_meta_app" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_ldapapp" VALUES(1,'ee871b4d57aa45bfa1b14e14ab7d98f1',0,1,'2019-11-16 10:11:32.628107','2019-11-16 10:11:32.628129',6);
CREATE TABLE "oneid_meta_log" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "created" datetime NULL, "subject" varchar(128) NOT NULL, "summary" varchar(512) NOT NULL, "access_id" integer NULL REFERENCES "oneid_meta_requestaccesslog" ("id") DEFERRABLE INITIALLY DEFERRED, "data_id" integer NULL REFERENCES "oneid_meta_requestdataclientlog" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_log" VALUES(1,'9dc88b2a1551403aac73afaa3eb77993','2019-11-16 12:20:47.009811','ucenter_login','(admin)登录',1,1,1);
INSERT INTO "oneid_meta_log" VALUES(2,'8eb5f1e1e30d4e65bc90a51bc8bec3ab','2019-11-16 09:25:46.659208','ucenter_login','(admin)登录',2,2,1);
INSERT INTO "oneid_meta_log" VALUES(3,'c6f731b0040b45aa8bbf1aa4435cd510','2019-11-16 09:29:00.599354','ucenter_login','Admin(admin)登录',3,3,1);
INSERT INTO "oneid_meta_log" VALUES(4,'e7e066c0d3d645b58e8694a379e090ef','2019-11-16 09:31:55.741421','config','Admin(admin)更新系统配置',4,4,1);
INSERT INTO "oneid_meta_log" VALUES(5,'408362fdc6334b448b84c9583a36738d','2019-11-16 09:32:03.238363','config','Admin(admin)更新系统配置',5,5,1);
INSERT INTO "oneid_meta_log" VALUES(6,'975ba167743b403a99465ff5828af548','2019-11-16 09:32:15.780406','ucenter_login','Admin(admin)登录',6,6,1);
INSERT INTO "oneid_meta_log" VALUES(7,'212ad02a0dcb45dda64a8205c7981e9f','2019-11-16 09:32:21.918792','config','Admin(admin)更新系统配置',7,7,1);
INSERT INTO "oneid_meta_log" VALUES(8,'a32cb03ac4c34d15bfd77b90daf569c2','2019-11-16 09:34:30.444566','ucenter_register','用户注册: (dept1)',8,8,2);
INSERT INTO "oneid_meta_log" VALUES(9,'2d79325aefd14d1bb4a0289653d15150','2019-11-16 09:34:30.452491','ucenter_reset_pwd','(dept1) 修改用户((dept1))密码',8,8,2);
INSERT INTO "oneid_meta_log" VALUES(10,'4403838c95a74acf9b48d673c8791042','2019-11-16 09:34:30.465275','group_member','(dept1)添加一批用户[(dept1)]至组(外部联系人)',9,9,2);
INSERT INTO "oneid_meta_log" VALUES(11,'34d58121739741ebbd30728c9d37e92b','2019-11-16 09:35:05.926343','ucenter_register','用户注册: (dept2)',10,10,3);
INSERT INTO "oneid_meta_log" VALUES(12,'74b7fd6eaf5542ffae15e91cbd33b475','2019-11-16 09:35:05.933576','ucenter_reset_pwd','(dept2) 修改用户((dept2))密码',10,10,3);
INSERT INTO "oneid_meta_log" VALUES(13,'03144bed7cbd40dd8643325577465680','2019-11-16 09:35:05.944600','group_member','(dept2)添加一批用户[(dept2)]至组(外部联系人)',11,11,3);
INSERT INTO "oneid_meta_log" VALUES(14,'dd8a84574cf549feae06964fee7400ca','2019-11-16 09:42:49.684649','ucenter_register','用户注册: (13899990001)',12,12,4);
INSERT INTO "oneid_meta_log" VALUES(15,'605cbe61164f4dbea18da9d6a51d5fbb','2019-11-16 09:42:49.693195','ucenter_reset_pwd','(13899990001) 修改用户((13899990001))密码',12,12,4);
INSERT INTO "oneid_meta_log" VALUES(16,'35a3fa8d051b4a209fcbf5e7fa9487af','2019-11-16 09:42:49.703924','group_member','(13899990001)添加一批用户[(13899990001)]至组(外部联系人)',13,13,4);
INSERT INTO "oneid_meta_log" VALUES(17,'22c428502dfb46fa8af67d05f96eee1d','2019-11-16 09:43:09.194982','ucenter_register','用户注册: (13899990002)',14,14,5);
INSERT INTO "oneid_meta_log" VALUES(18,'ef0accdab54445b38a0e3b5c3bfcdc00','2019-11-16 09:43:09.202535','ucenter_reset_pwd','(13899990002) 修改用户((13899990002))密码',14,14,5);
INSERT INTO "oneid_meta_log" VALUES(19,'161011d0724148f5bc67d4314c1f662b','2019-11-16 09:43:09.212959','group_member','(13899990002)添加一批用户[(13899990002)]至组(外部联系人)',15,15,5);
INSERT INTO "oneid_meta_log" VALUES(20,'d18c5765503b43e580dc257bb3e9aa5b','2019-11-16 09:43:27.924121','ucenter_register','用户注册: (13899990003)',16,16,6);
INSERT INTO "oneid_meta_log" VALUES(21,'dcb61d983a1e4e409d1848125d2148f3','2019-11-16 09:43:27.932239','ucenter_reset_pwd','(13899990003) 修改用户((13899990003))密码',16,16,6);
INSERT INTO "oneid_meta_log" VALUES(22,'0cfa83d144f3493ea85d167d48695099','2019-11-16 09:43:27.942966','group_member','(13899990003)添加一批用户[(13899990003)]至组(外部联系人)',17,17,6);
INSERT INTO "oneid_meta_log" VALUES(23,'2a6ab3f3429949ac9fd944e39012b556','2019-11-16 09:43:48.209993','ucenter_register','用户注册: (13899990004)',18,18,7);
INSERT INTO "oneid_meta_log" VALUES(24,'3f6f8cd178a64e968a60045d89600a5d','2019-11-16 09:43:48.218315','ucenter_reset_pwd','(13899990004) 修改用户((13899990004))密码',18,18,7);
INSERT INTO "oneid_meta_log" VALUES(25,'fcb4f5adec8244678e61fbc403f6b804','2019-11-16 09:43:48.228862','group_member','(13899990004)添加一批用户[(13899990004)]至组(外部联系人)',19,19,7);
INSERT INTO "oneid_meta_log" VALUES(26,'de3f772a8c3c4925b54b95ae76013f74','2019-11-16 09:44:07.631359','ucenter_register','用户注册: (13899990005)',20,20,8);
INSERT INTO "oneid_meta_log" VALUES(27,'7d391a4934204ecca623044c202c178b','2019-11-16 09:44:07.638600','ucenter_reset_pwd','(13899990005) 修改用户((13899990005))密码',20,20,8);
INSERT INTO "oneid_meta_log" VALUES(28,'3c58f891e96a461eb13005b403c042fc','2019-11-16 09:44:07.649944','group_member','(13899990005)添加一批用户[(13899990005)]至组(外部联系人)',21,21,8);
INSERT INTO "oneid_meta_log" VALUES(29,'26b166a6caa04086b2c06b0106af54ce','2019-11-16 09:44:40.685685','ucenter_register','用户注册: (13899990006)',22,22,9);
INSERT INTO "oneid_meta_log" VALUES(30,'e5c88c8d5d894905ba192be040652ba6','2019-11-16 09:44:40.693499','ucenter_reset_pwd','(13899990006) 修改用户((13899990006))密码',22,22,9);
INSERT INTO "oneid_meta_log" VALUES(31,'3f39b161d18c4cf98f413fd1fb371716','2019-11-16 09:44:40.703921','group_member','(13899990006)添加一批用户[(13899990006)]至组(外部联系人)',23,23,9);
INSERT INTO "oneid_meta_log" VALUES(32,'6bee5f68ac904d508c7bdd0fa0f0296d','2019-11-16 09:45:03.128122','ucenter_register','用户注册: (13899990007)',24,24,10);
INSERT INTO "oneid_meta_log" VALUES(33,'d6f43cac6ee142228243bc191d28e6bc','2019-11-16 09:45:03.136361','ucenter_reset_pwd','(13899990007) 修改用户((13899990007))密码',24,24,10);
INSERT INTO "oneid_meta_log" VALUES(34,'9226d4ccee164cadb3cb6b8b8830c8ac','2019-11-16 09:45:03.146221','group_member','(13899990007)添加一批用户[(13899990007)]至组(外部联系人)',25,25,10);
INSERT INTO "oneid_meta_log" VALUES(35,'a35a8d8e18a044ee84d8090bd39da2ad','2019-11-16 09:45:21.860622','ucenter_register','用户注册: (13899990008)',26,26,11);
INSERT INTO "oneid_meta_log" VALUES(36,'728de5de2004437aa24f191c072d6b04','2019-11-16 09:45:21.868549','ucenter_reset_pwd','(13899990008) 修改用户((13899990008))密码',26,26,11);
INSERT INTO "oneid_meta_log" VALUES(37,'4dd0df1c03924b5a95e90e14337513b1','2019-11-16 09:45:21.878374','group_member','(13899990008)添加一批用户[(13899990008)]至组(外部联系人)',27,27,11);
INSERT INTO "oneid_meta_log" VALUES(38,'e1fcb6759e8a4a54b9dbac38f87d4143','2019-11-16 09:45:38.600840','ucenter_register','用户注册: (13899990009)',28,28,12);
INSERT INTO "oneid_meta_log" VALUES(39,'2702b0857f244cbcb40d80dd22b41f32','2019-11-16 09:45:38.608367','ucenter_reset_pwd','(13899990009) 修改用户((13899990009))密码',28,28,12);
INSERT INTO "oneid_meta_log" VALUES(40,'691fb60c94014226ab705a385d7157aa','2019-11-16 09:45:38.618401','group_member','(13899990009)添加一批用户[(13899990009)]至组(外部联系人)',29,29,12);
INSERT INTO "oneid_meta_log" VALUES(41,'8d7f3b87932f46d8a0c6ad9a8fb54ad7','2019-11-16 09:45:45.718761','ucenter_login','Admin(admin)登录',30,30,1);
INSERT INTO "oneid_meta_log" VALUES(42,'78910b31d62546afb1928df5aefb5b88','2019-11-16 09:46:20.931219','dept_create','Admin(admin)创建部门(部门一)',31,31,1);
INSERT INTO "oneid_meta_log" VALUES(43,'e53df38707584175b25184c5a87d9606','2019-11-16 09:46:20.935321','dept_move','Admin(admin)将新部门(部门一)加入到部门(Dept: root(部门))下',31,31,1);
INSERT INTO "oneid_meta_log" VALUES(44,'f9d6908e518141c29b7d627bfe683768','2019-11-16 09:46:33.797120','dept_create','Admin(admin)创建部门(部门二)',32,32,1);
INSERT INTO "oneid_meta_log" VALUES(45,'ec00393b92574013adb222d5dbb6521d','2019-11-16 09:46:33.802698','dept_move','Admin(admin)将新部门(部门二)加入到部门(Dept: root(部门))下',32,32,1);
INSERT INTO "oneid_meta_log" VALUES(46,'91ab4bee8569480f97403d08bb7ac0f5','2019-11-16 09:46:46.170365','dept_update','Admin(admin)编辑部门(部门二)信息',33,33,1);
INSERT INTO "oneid_meta_log" VALUES(47,'bd539e1ba6b6405cac511e0218f8efd8','2019-11-16 09:46:46.192739','dept_move','Admin(admin)将部门(部门二)移到部门(部门)下',34,34,1);
INSERT INTO "oneid_meta_log" VALUES(48,'48308d8203b8487781996fcfef7940f5','2019-11-16 09:46:54.819717','dept_create','Admin(admin)创建部门(部门三)',35,35,1);
INSERT INTO "oneid_meta_log" VALUES(49,'42a3e589253f46b6b46bd592fc0861c7','2019-11-16 09:46:54.824297','dept_move','Admin(admin)将新部门(部门三)加入到部门(Dept: root(部门))下',35,35,1);
INSERT INTO "oneid_meta_log" VALUES(50,'0589ef14d9bd4189af959d250972f7a2','2019-11-16 09:47:06.246105','dept_update','Admin(admin)编辑部门(所有可见部门)信息',36,36,1);
INSERT INTO "oneid_meta_log" VALUES(51,'52f5b3b0beda4c9a8519cd033c93e1de','2019-11-16 09:47:06.267785','dept_move','Admin(admin)将部门(所有可见部门)移到部门(部门)下',37,37,1);
INSERT INTO "oneid_meta_log" VALUES(52,'be873fd66a744440b81c697e984aa311','2019-11-16 09:47:36.982985','dept_update','Admin(admin)编辑部门(部门（组内可见下属不可见）)信息',38,38,1);
INSERT INTO "oneid_meta_log" VALUES(53,'afdbf27d4285401b840db63f819e610c','2019-11-16 09:47:37.004466','dept_move','Admin(admin)将部门(部门（组内可见下属不可见）)移到部门(部门)下',39,39,1);
INSERT INTO "oneid_meta_log" VALUES(54,'e26af4dff1c547978803b9b224ea1253','2019-11-16 09:47:47.702971','dept_update','Admin(admin)编辑部门(部门（所有可见）)信息',40,40,1);
INSERT INTO "oneid_meta_log" VALUES(55,'7f0414ba0013492294b4cb03e325a5f6','2019-11-16 09:47:47.726479','dept_move','Admin(admin)将部门(部门（所有可见）)移到部门(部门)下',41,41,1);
INSERT INTO "oneid_meta_log" VALUES(56,'45a0c8f608214a2493fd81b05cbb03dc','2019-11-16 09:48:03.351589','dept_update','Admin(admin)编辑部门(部门一（所有可见）)信息',42,42,1);
INSERT INTO "oneid_meta_log" VALUES(57,'4d76c5637e1042e7abdb50792cd44fab','2019-11-16 09:48:03.374009','dept_move','Admin(admin)将部门(部门一（所有可见）)移到部门(部门)下',43,43,1);
INSERT INTO "oneid_meta_log" VALUES(58,'a942003dd171499b8bd4cbf46dbb5788','2019-11-16 09:48:10.857086','dept_update','Admin(admin)编辑部门(部门二（组内可见下属不可见）)信息',44,44,1);
INSERT INTO "oneid_meta_log" VALUES(59,'8d0ed70f16de48f194b8d6d8c03524ed','2019-11-16 09:48:10.879255','dept_move','Admin(admin)将部门(部门二（组内可见下属不可见）)移到部门(部门)下',45,45,1);
INSERT INTO "oneid_meta_log" VALUES(60,'2b0a86be691a4fc49b1f54e9994d0ac3','2019-11-16 09:48:33.999138','dept_update','Admin(admin)编辑部门(部门三（组内成员及下属分组可见）)信息',46,46,1);
INSERT INTO "oneid_meta_log" VALUES(61,'3bb86097ecef4767b8f861e375a0e1f2','2019-11-16 09:48:34.022036','dept_move','Admin(admin)将部门(部门三（组内成员及下属分组可见）)移到部门(部门)下',47,47,1);
INSERT INTO "oneid_meta_log" VALUES(62,'a7e1d1a1e20e4131b28673785e7b63d8','2019-11-16 09:48:52.425610','dept_create','Admin(admin)创建部门(部门四（所有人不可见）)',48,48,1);
INSERT INTO "oneid_meta_log" VALUES(63,'c4706bfc6bee409994749da94d0f8f70','2019-11-16 09:48:52.429615','dept_move','Admin(admin)将新部门(部门四（所有人不可见）)加入到部门(Dept: root(部门))下',48,48,1);
INSERT INTO "oneid_meta_log" VALUES(64,'79a3b8e03f464a9b9551a0c53c557cbe','2019-11-16 09:49:31.085671','dept_create','Admin(admin)创建部门(部门五（部分人可见）)',49,49,1);
INSERT INTO "oneid_meta_log" VALUES(65,'943111cb00b5448eaa457b6d018a0141','2019-11-16 09:49:31.090212','dept_move','Admin(admin)将新部门(部门五（部分人可见）)加入到部门(Dept: root(部门))下',49,49,1);
INSERT INTO "oneid_meta_log" VALUES(66,'36db49dfb53448a5a38b42faa7a85a4b','2019-11-16 09:50:21.324186','dept_create','Admin(admin)创建部门(部门一（一）)',50,50,1);
INSERT INTO "oneid_meta_log" VALUES(67,'7ed9a95b2d9949e68a5f4e0eb2ba97ca','2019-11-16 09:50:21.328834','dept_move','Admin(admin)将新部门(部门一（一）)加入到部门(Dept: bumenyi(部门一（所有可见）))下',50,50,1);
INSERT INTO "oneid_meta_log" VALUES(68,'5b474f600b5f4d0d9033d8a114d4c581','2019-11-16 09:50:49.469097','dept_create','Admin(admin)创建部门(部门一（二）)',51,51,1);
INSERT INTO "oneid_meta_log" VALUES(69,'6dc80b2827d64047ad356aee94e562c1','2019-11-16 09:50:49.474826','dept_move','Admin(admin)将新部门(部门一（二）)加入到部门(Dept: bumenyi(部门一（所有可见）))下',51,51,1);
INSERT INTO "oneid_meta_log" VALUES(70,'ecaff35c78b8404cbcb127e0fa63657d','2019-11-16 09:51:01.701746','dept_create','Admin(admin)创建部门(部门一（三）)',52,52,1);
INSERT INTO "oneid_meta_log" VALUES(71,'dcda0ebebc3547c2b4d4ea66275112b5','2019-11-16 09:51:01.706639','dept_move','Admin(admin)将新部门(部门一（三）)加入到部门(Dept: bumenyi(部门一（所有可见）))下',52,52,1);
INSERT INTO "oneid_meta_log" VALUES(72,'9660131449c24196bf94a2ff531fae87','2019-11-16 09:51:11.841407','dept_create','Admin(admin)创建部门(部门一（四）)',53,53,1);
INSERT INTO "oneid_meta_log" VALUES(73,'cf2747f8649042c39ee2a6df59ebc952','2019-11-16 09:51:11.846705','dept_move','Admin(admin)将新部门(部门一（四）)加入到部门(Dept: bumenyi(部门一（所有可见）))下',53,53,1);
INSERT INTO "oneid_meta_log" VALUES(74,'c87938a6ce144b03913632f90f94c2cf','2019-11-16 09:51:21.677812','dept_create','Admin(admin)创建部门(部门一（五）)',54,54,1);
INSERT INTO "oneid_meta_log" VALUES(75,'88d39fc59e64470ca7bd1fa1794f3435','2019-11-16 09:51:21.683283','dept_move','Admin(admin)将新部门(部门一（五）)加入到部门(Dept: bumenyi(部门一（所有可见）))下',54,54,1);
INSERT INTO "oneid_meta_log" VALUES(76,'56db3c993f0442bcb439b2d9d79957d3','2019-11-16 09:51:35.525751','dept_create','Admin(admin)创建部门(部门二（一）)',55,55,1);
INSERT INTO "oneid_meta_log" VALUES(77,'ed71a54c81a5430d9c0e6af03622e491','2019-11-16 09:51:35.530901','dept_move','Admin(admin)将新部门(部门二（一）)加入到部门(Dept: bumener(部门二（组内可见下属不可见）))下',55,55,1);
INSERT INTO "oneid_meta_log" VALUES(78,'c41c1f6625224b69b9aec10da99df252','2019-11-16 09:51:44.978040','dept_create','Admin(admin)创建部门(部门二（二）)',56,56,1);
INSERT INTO "oneid_meta_log" VALUES(79,'bf732b93e98a490196e3dd9d67c041c0','2019-11-16 09:51:44.983191','dept_move','Admin(admin)将新部门(部门二（二）)加入到部门(Dept: bumener(部门二（组内可见下属不可见）))下',56,56,1);
INSERT INTO "oneid_meta_log" VALUES(80,'8f1930f1ed2e4086b25c258d72c95813','2019-11-16 09:51:55.247972','dept_create','Admin(admin)创建部门(部门二（三）)',57,57,1);
INSERT INTO "oneid_meta_log" VALUES(81,'522f1a79449d4005a68b22a5858cba8e','2019-11-16 09:51:55.254497','dept_move','Admin(admin)将新部门(部门二（三）)加入到部门(Dept: bumener(部门二（组内可见下属不可见）))下',57,57,1);
INSERT INTO "oneid_meta_log" VALUES(82,'ed2e7fe4c13045f4a5ffed145bcca6b0','2019-11-16 09:52:07.263540','dept_create','Admin(admin)创建部门(部门二（四）)',58,58,1);
INSERT INTO "oneid_meta_log" VALUES(83,'84461cf382bd4f359abf9a63f46f2555','2019-11-16 09:52:07.268815','dept_move','Admin(admin)将新部门(部门二（四）)加入到部门(Dept: bumener(部门二（组内可见下属不可见）))下',58,58,1);
INSERT INTO "oneid_meta_log" VALUES(84,'3855f96a352849868c3010fb35d2d4d7','2019-11-16 09:52:19.840251','dept_create','Admin(admin)创建部门(部门二（五）)',59,59,1);
INSERT INTO "oneid_meta_log" VALUES(85,'3bdf92fd54c54fb1bc75013d6ae69add','2019-11-16 09:52:19.845271','dept_move','Admin(admin)将新部门(部门二（五）)加入到部门(Dept: bumener(部门二（组内可见下属不可见）))下',59,59,1);
INSERT INTO "oneid_meta_log" VALUES(86,'dcd75327087a43bcabf91f02561c0135','2019-11-16 09:52:57.787757','group_create','Admin(admin)创建组(角色一)',60,60,1);
INSERT INTO "oneid_meta_log" VALUES(87,'77efa995fd6741ca9f2e15cd28e75780','2019-11-16 09:52:57.795595','group_move','Admin(admin)将新组(角色一)加入到组(角色)下',60,60,1);
INSERT INTO "oneid_meta_log" VALUES(88,'3fc0e8a04a4e4bc2b999f9ac557865ea','2019-11-16 09:53:16.973586','group_create','Admin(admin)创建组(角色一（一）)',61,61,1);
INSERT INTO "oneid_meta_log" VALUES(89,'7972d44954b34f78be809845056fda0e','2019-11-16 09:53:16.981516','group_move','Admin(admin)将新组(角色一（一）)加入到组(角色一)下',61,61,1);
INSERT INTO "oneid_meta_log" VALUES(90,'1c6d2d8a2c5e4279936dfd7bb6b76796','2019-11-16 09:53:25.322210','group_create','Admin(admin)创建组(角色一（二）)',62,62,1);
INSERT INTO "oneid_meta_log" VALUES(91,'d6772f6feda44d25baab57eab6c2a5a7','2019-11-16 09:53:25.329122','group_move','Admin(admin)将新组(角色一（二）)加入到组(角色一)下',62,62,1);
INSERT INTO "oneid_meta_log" VALUES(92,'049086d7d689457fa4cbdc55a15e60da','2019-11-16 09:53:39.831457','group_create','Admin(admin)创建组(角色一（三）)',63,63,1);
INSERT INTO "oneid_meta_log" VALUES(93,'52b69bf81a1047208b211d70c10bd874','2019-11-16 09:53:39.838328','group_move','Admin(admin)将新组(角色一（三）)加入到组(角色一)下',63,63,1);
INSERT INTO "oneid_meta_log" VALUES(94,'355118792a99485eae001abd50890b84','2019-11-16 09:53:49.235440','group_create','Admin(admin)创建组(角色一（四）)',64,64,1);
INSERT INTO "oneid_meta_log" VALUES(95,'0f0574d04e294c3cbb415f83b55d2e20','2019-11-16 09:53:49.242593','group_move','Admin(admin)将新组(角色一（四）)加入到组(角色一)下',64,64,1);
INSERT INTO "oneid_meta_log" VALUES(96,'a47f205333cf432484a6814e47702aca','2019-11-16 09:53:57.056056','group_create','Admin(admin)创建组(角色一（五）)',65,65,1);
INSERT INTO "oneid_meta_log" VALUES(97,'6df7a9f1705247dcb7a1ad8d74cd7dc5','2019-11-16 09:53:57.063444','group_move','Admin(admin)将新组(角色一（五）)加入到组(角色一)下',65,65,1);
INSERT INTO "oneid_meta_log" VALUES(98,'f6f90df0ce2845d4a66ef3dc62da1cff','2019-11-16 09:54:06.068308','group_create','Admin(admin)创建组(角色二)',66,66,1);
INSERT INTO "oneid_meta_log" VALUES(99,'b3144626681e423d9354dccc6bd96037','2019-11-16 09:54:06.074715','group_move','Admin(admin)将新组(角色二)加入到组(角色)下',66,66,1);
INSERT INTO "oneid_meta_log" VALUES(100,'29dcfa5aa2f5443499d75d203be99142','2019-11-16 09:54:15.712177','group_create','Admin(admin)创建组(角色三)',67,67,1);
INSERT INTO "oneid_meta_log" VALUES(101,'d1bb3bb5fd8b4e9c86f02e33b16caf9e','2019-11-16 09:54:15.718310','group_move','Admin(admin)将新组(角色三)加入到组(角色)下',67,67,1);
INSERT INTO "oneid_meta_log" VALUES(102,'742708c25cc1490aab94363ee2657843','2019-11-16 09:54:23.395289','group_create','Admin(admin)创建组(角色四)',68,68,1);
INSERT INTO "oneid_meta_log" VALUES(103,'f864b2ff42d1494fa375c22bcb43793d','2019-11-16 09:54:23.401224','group_move','Admin(admin)将新组(角色四)加入到组(角色)下',68,68,1);
INSERT INTO "oneid_meta_log" VALUES(104,'b713aaf6dff0447fbbaaf50f48405f67','2019-11-16 09:54:35.908170','group_create','Admin(admin)创建组(角色五)',69,69,1);
INSERT INTO "oneid_meta_log" VALUES(105,'ce33be307c634873bca379046991a64f','2019-11-16 09:54:35.914177','group_move','Admin(admin)将新组(角色五)加入到组(角色)下',69,69,1);
INSERT INTO "oneid_meta_log" VALUES(106,'1c0f138e4ccd4406a4d5dad4b1e35ce8','2019-11-16 09:55:21.068021','ucenter_reset_pwd','(13899990001) 修改用户((13899990001))密码',70,70,4);
INSERT INTO "oneid_meta_log" VALUES(107,'bd5e276c3d1a4687a6ba1ef8e5280846','2019-11-16 09:55:21.071863','ucenter_activate','(13899990001)激活成功',71,71,4);
INSERT INTO "oneid_meta_log" VALUES(108,'1f3a6d5c276d48d4bb7baf69cce37e59','2019-11-16 09:55:51.485151','ucenter_reset_pwd','(13899990002) 修改用户((13899990002))密码',72,72,5);
INSERT INTO "oneid_meta_log" VALUES(109,'0bafd2b904ba482890d3511a0efc6ee3','2019-11-16 09:55:51.489064','ucenter_activate','(13899990002)激活成功',73,73,5);
INSERT INTO "oneid_meta_log" VALUES(110,'8dc6d6c3ce7b4c0bb8452bd6d99319c1','2019-11-16 09:56:39.752637','ucenter_reset_pwd','(13899990003) 修改用户((13899990003))密码',74,74,6);
INSERT INTO "oneid_meta_log" VALUES(111,'890240392ef74dc1bf57f5d23ae87a2c','2019-11-16 09:56:39.756860','ucenter_activate','(13899990003)激活成功',75,75,6);
INSERT INTO "oneid_meta_log" VALUES(112,'40fa519c07144627a06431c47a0cc3e8','2019-11-16 09:57:01.284633','ucenter_login','Admin(admin)登录',76,76,1);
INSERT INTO "oneid_meta_log" VALUES(113,'3ee1b60b880b4684850dbf2b653eecce','2019-11-16 09:58:16.360950','ucenter_login','(13899990001)登录',77,77,4);
INSERT INTO "oneid_meta_log" VALUES(114,'699849b3c1884d6da92dd30b36077340','2019-11-16 09:58:24.429486','ucenter_login','Admin(admin)登录',78,78,1);
INSERT INTO "oneid_meta_log" VALUES(115,'7d673c69fa0d4609af97c4c657f6e697','2019-11-16 09:58:36.674189','ucenter_login','(13899990002)登录',79,79,5);
INSERT INTO "oneid_meta_log" VALUES(116,'ef406cad026448a5b7b046c0008074af','2019-11-16 09:58:46.356211','ucenter_login','(13899990003)登录',80,80,6);
INSERT INTO "oneid_meta_log" VALUES(117,'ed847718796c43acbbe4c1d5e1a58dcc','2019-11-16 09:58:53.977084','ucenter_login','(13899990004)登录',81,81,7);
INSERT INTO "oneid_meta_log" VALUES(118,'097e0f779e314c508b1a6dbe2d7c6f90','2019-11-16 09:59:00.388262','ucenter_login','(13899990005)登录',82,82,8);
INSERT INTO "oneid_meta_log" VALUES(119,'1d216a6dce4c4e29b8e95f74c5ed86bf','2019-11-16 09:59:07.683093','ucenter_login','(13899990006)登录',83,83,9);
INSERT INTO "oneid_meta_log" VALUES(120,'8a4e4870680443b4b1562e227670aae7','2019-11-16 09:59:14.036148','ucenter_login','(13899990007)登录',84,84,10);
INSERT INTO "oneid_meta_log" VALUES(121,'0ea3e2b3062d4f57b5098445dd0ec8df','2019-11-16 09:59:20.473867','ucenter_login','(13899990008)登录',85,85,11);
INSERT INTO "oneid_meta_log" VALUES(122,'4fb72728bad44457b332e7af14ab553b','2019-11-16 09:59:34.320459','ucenter_login','(13899990009)登录',86,86,12);
INSERT INTO "oneid_meta_log" VALUES(123,'0b87e9a3f95b4e8e9555bd40930a4e5d','2019-11-16 09:59:39.773679','ucenter_login','Admin(admin)登录',87,87,1);
INSERT INTO "oneid_meta_log" VALUES(124,'fcb74b11339746bbb08458e13899d743','2019-11-16 10:00:41.808015','group_create','Admin(admin)创建组(角色二（一）)',88,88,1);
INSERT INTO "oneid_meta_log" VALUES(125,'5e1cad6d149a4db9954c7b4dc7d10835','2019-11-16 10:00:41.815956','group_move','Admin(admin)将新组(角色二（一）)加入到组(角色二)下',88,88,1);
INSERT INTO "oneid_meta_log" VALUES(126,'d0d3c684f75d43aca74655251790ec38','2019-11-16 10:00:57.270656','group_create','Admin(admin)创建组(角色二（二）)',89,89,1);
INSERT INTO "oneid_meta_log" VALUES(127,'2d8d1c193f5c43f7abb59de32c12a89d','2019-11-16 10:00:57.278962','group_move','Admin(admin)将新组(角色二（二）)加入到组(角色二)下',89,89,1);
INSERT INTO "oneid_meta_log" VALUES(128,'10cabeab10fc49b39153fa081e3f7065','2019-11-16 10:01:13.625092','group_create','Admin(admin)创建组(角色二（三）)',90,90,1);
INSERT INTO "oneid_meta_log" VALUES(129,'eac370f96dd146c2b82b3a6f75036c90','2019-11-16 10:01:13.632585','group_move','Admin(admin)将新组(角色二（三）)加入到组(角色二)下',90,90,1);
INSERT INTO "oneid_meta_log" VALUES(130,'fe2e7473f8c74b9d967ff59050d8135c','2019-11-16 10:01:32.354196','group_create','Admin(admin)创建组(角色二（四）)',91,91,1);
INSERT INTO "oneid_meta_log" VALUES(131,'64ede70306c242ceaf43fc208a02f9eb','2019-11-16 10:01:32.361627','group_move','Admin(admin)将新组(角色二（四）)加入到组(角色二)下',91,91,1);
INSERT INTO "oneid_meta_log" VALUES(132,'f08060d88c804bb996ad8b0f28b6f577','2019-11-16 10:01:46.897186','group_create','Admin(admin)创建组(角色二（五）)',92,92,1);
INSERT INTO "oneid_meta_log" VALUES(133,'74c891e57f6349ceb0215bbb3029a9ac','2019-11-16 10:01:46.904513','group_move','Admin(admin)将新组(角色二（五）)加入到组(角色二)下',92,92,1);
INSERT INTO "oneid_meta_log" VALUES(134,'6e9581287c2043fdb86d0371782052ad','2019-11-16 10:01:58.633496','group_create','Admin(admin)创建组(标签一)',93,93,1);
INSERT INTO "oneid_meta_log" VALUES(135,'8333fe11ca8f415897ed62a19b987f62','2019-11-16 10:01:58.641047','group_move','Admin(admin)将新组(标签一)加入到组(标签)下',93,93,1);
INSERT INTO "oneid_meta_log" VALUES(136,'2f3bf1eeb881484a8a158325bda71a2c','2019-11-16 10:02:09.037964','group_create','Admin(admin)创建组(标签二)',94,94,1);
INSERT INTO "oneid_meta_log" VALUES(137,'b7c775109e2d44e382be4ffcfab3d468','2019-11-16 10:02:09.045902','group_move','Admin(admin)将新组(标签二)加入到组(标签)下',94,94,1);
INSERT INTO "oneid_meta_log" VALUES(138,'b0a6821c97a149cab13a94fab6bb2cc9','2019-11-16 10:02:16.367179','group_create','Admin(admin)创建组(标签三)',95,95,1);
INSERT INTO "oneid_meta_log" VALUES(139,'cef86c77749a42f98c32f1fbe0acf7d9','2019-11-16 10:02:16.374742','group_move','Admin(admin)将新组(标签三)加入到组(标签)下',95,95,1);
INSERT INTO "oneid_meta_log" VALUES(140,'46c3e0e6a12445a8b0d0b88e31608cad','2019-11-16 10:02:23.294329','group_create','Admin(admin)创建组(标签四)',96,96,1);
INSERT INTO "oneid_meta_log" VALUES(141,'4209e4c7534145358a184b11133a1c94','2019-11-16 10:02:23.300394','group_move','Admin(admin)将新组(标签四)加入到组(标签)下',96,96,1);
INSERT INTO "oneid_meta_log" VALUES(142,'6c23bb959e8a47e089921672dd38542c','2019-11-16 10:02:32.423121','group_create','Admin(admin)创建组(标签五)',97,97,1);
INSERT INTO "oneid_meta_log" VALUES(143,'ae2d9b0d9ea74a1687db7737d46b3a6b','2019-11-16 10:02:32.431854','group_move','Admin(admin)将新组(标签五)加入到组(标签)下',97,97,1);
INSERT INTO "oneid_meta_log" VALUES(144,'a8a5fcea3e0b47b0a046715774860274','2019-11-16 10:03:28.540199','dept_create','Admin(admin)创建部门(部门三（一）)',98,98,1);
INSERT INTO "oneid_meta_log" VALUES(145,'12c825b062c049ca827e1ff41e58e8df','2019-11-16 10:03:28.546306','dept_move','Admin(admin)将新部门(部门三（一）)加入到部门(Dept: bumensan(部门三（组内成员及下属分组可见）))下',98,98,1);
INSERT INTO "oneid_meta_log" VALUES(146,'04a017fb3c0d49b89a9ace22a6057fe0','2019-11-16 10:03:39.696395','dept_create','Admin(admin)创建部门(部门四（一）)',99,99,1);
INSERT INTO "oneid_meta_log" VALUES(147,'c42bbacaac63475b9d9dd7712e2d0928','2019-11-16 10:03:39.702687','dept_move','Admin(admin)将新部门(部门四（一）)加入到部门(Dept: bumensisuoyourenbukejian(部门四（所有人不可见）))下',99,99,1);
INSERT INTO "oneid_meta_log" VALUES(148,'6e3aa53735e546c8ab3df5badd13f735','2019-11-16 10:03:52.546154','dept_create','Admin(admin)创建部门(部门五（一）)',100,100,1);
INSERT INTO "oneid_meta_log" VALUES(149,'d64479261eff442e80cc987e7254f653','2019-11-16 10:03:52.551578','dept_move','Admin(admin)将新部门(部门五（一）)加入到部门(Dept: bumenwubufenrenkejian(部门五（部分人可见）))下',100,100,1);
INSERT INTO "oneid_meta_log" VALUES(150,'86456e620f9d42289110c9bf6f9dedf1','2019-11-16 10:04:05.971899','group_create','Admin(admin)创建组(角色三（一）)',101,101,1);
INSERT INTO "oneid_meta_log" VALUES(151,'fa24cd0f02204478bcbfae0272d9a464','2019-11-16 10:04:05.980923','group_move','Admin(admin)将新组(角色三（一）)加入到组(角色三)下',101,101,1);
INSERT INTO "oneid_meta_log" VALUES(152,'e4b2a2b79067435d9d0a0560ac973cb5','2019-11-16 10:04:17.174341','group_create','Admin(admin)创建组(角色四（一）)',102,102,1);
INSERT INTO "oneid_meta_log" VALUES(153,'132e1a4f1bd34f229f19f0c6c0970aa4','2019-11-16 10:04:17.182165','group_move','Admin(admin)将新组(角色四（一）)加入到组(角色四)下',102,102,1);
INSERT INTO "oneid_meta_log" VALUES(154,'4dbaa22bc16041efb4d35a74d7fd0a4a','2019-11-16 10:04:35.953016','group_create','Admin(admin)创建组(角色五（一）)',103,103,1);
INSERT INTO "oneid_meta_log" VALUES(155,'85145b1c62384731803f1622408977f8','2019-11-16 10:04:35.961637','group_move','Admin(admin)将新组(角色五（一）)加入到组(角色五)下',103,103,1);
INSERT INTO "oneid_meta_log" VALUES(156,'943a54dd828a4b34938e09a17dc71d6b','2019-11-16 10:05:00.160511','group_create','Admin(admin)创建组(标签一（一）)',104,104,1);
INSERT INTO "oneid_meta_log" VALUES(157,'20ea826e05cf4cc0b23365d5281e0d88','2019-11-16 10:05:00.169360','group_move','Admin(admin)将新组(标签一（一）)加入到组(标签一)下',104,104,1);
INSERT INTO "oneid_meta_log" VALUES(158,'e54bddeef3be40008b5a82e7c3563db4','2019-11-16 10:05:20.335708','group_create','Admin(admin)创建组(标签一（二）)',105,105,1);
INSERT INTO "oneid_meta_log" VALUES(159,'c0873030e71d4012bc78f096a0559c38','2019-11-16 10:05:20.344770','group_move','Admin(admin)将新组(标签一（二）)加入到组(标签一)下',105,105,1);
INSERT INTO "oneid_meta_log" VALUES(160,'0f8cbe7674b547f4a567d1be7c7d7fdb','2019-11-16 10:05:28.274014','group_create','Admin(admin)创建组(标签一（三）)',106,106,1);
INSERT INTO "oneid_meta_log" VALUES(161,'4434f608219543b6b43c3d371b021891','2019-11-16 10:05:28.282005','group_move','Admin(admin)将新组(标签一（三）)加入到组(标签一)下',106,106,1);
INSERT INTO "oneid_meta_log" VALUES(162,'a37ef6506a19467daff6fb16c646060f','2019-11-16 10:05:36.531887','group_create','Admin(admin)创建组(标签一（四）)',107,107,1);
INSERT INTO "oneid_meta_log" VALUES(163,'37586771caf146169f5f526664a70134','2019-11-16 10:05:36.539598','group_move','Admin(admin)将新组(标签一（四）)加入到组(标签一)下',107,107,1);
INSERT INTO "oneid_meta_log" VALUES(164,'7529982c1d744080bf22d244e4f5d265','2019-11-16 10:05:47.461505','group_create','Admin(admin)创建组(标签一（五）)',108,108,1);
INSERT INTO "oneid_meta_log" VALUES(165,'9f775a2358c1416b92911847794b6cb3','2019-11-16 10:05:47.469156','group_move','Admin(admin)将新组(标签一（五）)加入到组(标签一)下',108,108,1);
INSERT INTO "oneid_meta_log" VALUES(166,'48c09d8cedbe4e92b1353729405e0e23','2019-11-16 10:06:01.172903','group_create','Admin(admin)创建组(标签二（一）)',109,109,1);
INSERT INTO "oneid_meta_log" VALUES(167,'c40e7ace17a34d4a93c76934fd9d24af','2019-11-16 10:06:01.180381','group_move','Admin(admin)将新组(标签二（一）)加入到组(标签二)下',109,109,1);
INSERT INTO "oneid_meta_log" VALUES(168,'66b3cc85ff8c46b9ae8e4e6a2114db05','2019-11-16 10:06:09.160100','group_create','Admin(admin)创建组(标签二（二）)',110,110,1);
INSERT INTO "oneid_meta_log" VALUES(169,'727433a4adcf4cf2b8eeb6c68a9f340e','2019-11-16 10:06:09.168539','group_move','Admin(admin)将新组(标签二（二）)加入到组(标签二)下',110,110,1);
INSERT INTO "oneid_meta_log" VALUES(170,'baa6ce59263f4215b78f9890b515a36a','2019-11-16 10:06:16.620987','group_create','Admin(admin)创建组(标签二（三）)',111,111,1);
INSERT INTO "oneid_meta_log" VALUES(171,'2ff9dbfc3ec64cb390a6210afdd7a8ef','2019-11-16 10:06:16.630193','group_move','Admin(admin)将新组(标签二（三）)加入到组(标签二)下',111,111,1);
INSERT INTO "oneid_meta_log" VALUES(172,'e42e9425476d450ebc3a1bf93bb4aec4','2019-11-16 10:06:24.174996','group_create','Admin(admin)创建组(标签二（四）)',112,112,1);
INSERT INTO "oneid_meta_log" VALUES(173,'b0a92cd1211d4975add99b79b4335f72','2019-11-16 10:06:24.184162','group_move','Admin(admin)将新组(标签二（四）)加入到组(标签二)下',112,112,1);
INSERT INTO "oneid_meta_log" VALUES(174,'1a3ffe1750e14887b034e2c9d3e8efd1','2019-11-16 10:06:33.235587','group_create','Admin(admin)创建组(标签二（五）)',113,113,1);
INSERT INTO "oneid_meta_log" VALUES(175,'e73b13114b24410db61f862627e0232b','2019-11-16 10:06:33.244190','group_move','Admin(admin)将新组(标签二（五）)加入到组(标签二)下',113,113,1);
INSERT INTO "oneid_meta_log" VALUES(176,'859aef3f5d454e86a458cb220fd32847','2019-11-16 10:06:46.178907','group_create','Admin(admin)创建组(标签三（一）)',114,114,1);
INSERT INTO "oneid_meta_log" VALUES(177,'b6c93c52e080443ab346393ce7219140','2019-11-16 10:06:46.188299','group_move','Admin(admin)将新组(标签三（一）)加入到组(标签三)下',114,114,1);
INSERT INTO "oneid_meta_log" VALUES(178,'03c6c4236c3c4aa9b1383358696af60b','2019-11-16 10:06:57.886074','group_create','Admin(admin)创建组(标签四（一）)',115,115,1);
INSERT INTO "oneid_meta_log" VALUES(179,'21cd2bfb638447999e2cc8a1521086a7','2019-11-16 10:06:57.896169','group_move','Admin(admin)将新组(标签四（一）)加入到组(标签四)下',115,115,1);
INSERT INTO "oneid_meta_log" VALUES(180,'bb2bbf8a5a4b41df89bec1445c38bd66','2019-11-16 10:07:07.350913','group_create','Admin(admin)创建组(标签五（一）)',116,116,1);
INSERT INTO "oneid_meta_log" VALUES(181,'06f090b78af64e4092360216efadab04','2019-11-16 10:07:07.358627','group_move','Admin(admin)将新组(标签五（一）)加入到组(标签五)下',116,116,1);
INSERT INTO "oneid_meta_log" VALUES(182,'05a545e9c3d54c9780a49ac1de9f0b03','2019-11-16 10:07:27.448628','group_create','Admin(admin)创建组(自定义分组一)',117,117,1);
INSERT INTO "oneid_meta_log" VALUES(183,'7936310294b2448696ce4669c4d15246','2019-11-16 10:07:27.456056','group_move','Admin(admin)将新组(自定义分组一)加入到组(内部联系人-角色)下',117,117,1);
INSERT INTO "oneid_meta_log" VALUES(184,'68be010363004da8a406586b74298d6f','2019-11-16 10:07:27.505119','group_create','Admin(admin)创建组(管理分组自定义分组一)',118,118,1);
INSERT INTO "oneid_meta_log" VALUES(185,'49ba2b3ece2c4ee2a93234a611b300d6','2019-11-16 10:07:27.513291','group_move','Admin(admin)将新组(管理分组自定义分组一)加入到组(子管理员组)下',118,118,1);
INSERT INTO "oneid_meta_log" VALUES(186,'e585a40f531541d586a67b955264acee','2019-11-16 10:07:27.529589','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理分组自定义分组一)',118,118,1);
INSERT INTO "oneid_meta_log" VALUES(187,'8076e0ab75b741289ae789e3dbabd9d1','2019-11-16 10:07:38.619963','group_create','Admin(admin)创建组(自定义分组二)',119,119,1);
INSERT INTO "oneid_meta_log" VALUES(188,'595780cf294e447e998c491a87a4b9ec','2019-11-16 10:07:38.627638','group_move','Admin(admin)将新组(自定义分组二)加入到组(内部联系人-角色)下',119,119,1);
INSERT INTO "oneid_meta_log" VALUES(189,'4d1b839b965749ca82c0da169085625e','2019-11-16 10:07:38.673871','group_create','Admin(admin)创建组(管理分组自定义分组二)',120,120,1);
INSERT INTO "oneid_meta_log" VALUES(190,'3323f60bad9849c9a8e143f036623cbe','2019-11-16 10:07:38.680486','group_move','Admin(admin)将新组(管理分组自定义分组二)加入到组(子管理员组)下',120,120,1);
INSERT INTO "oneid_meta_log" VALUES(191,'02fafdc2eebc4666b2a7d888a1dc61ef','2019-11-16 10:07:38.689540','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理分组自定义分组二)',120,120,1);
INSERT INTO "oneid_meta_log" VALUES(192,'f991297f5bc942a9ab29630a83775793','2019-11-16 10:08:40.415915','group_update','Admin(admin)编辑组(自定)信息',121,121,1);
INSERT INTO "oneid_meta_log" VALUES(193,'f0a1e1e112db458ebc22fd74508e7260','2019-11-16 10:08:55.858326','group_update','Admin(admin)编辑组(天蝎)信息',122,122,1);
INSERT INTO "oneid_meta_log" VALUES(194,'3e3f43d1914540d091679f6822b78885','2019-11-16 10:09:02.708510','group_update','Admin(admin)编辑组(蝴蝶)信息',123,123,1);
INSERT INTO "oneid_meta_log" VALUES(195,'7f40229d5c6546509b049db6952a359f','2019-11-16 10:09:20.498196','group_create','Admin(admin)创建组(天蝎一)',124,124,1);
INSERT INTO "oneid_meta_log" VALUES(196,'ed9eb6fbfe5c4def9ce4690947b9ec70','2019-11-16 10:09:20.504983','group_move','Admin(admin)将新组(天蝎一)加入到组(天蝎)下',124,124,1);
INSERT INTO "oneid_meta_log" VALUES(197,'1f509207448c44cba92d68e089c9679d','2019-11-16 10:09:43.474407','group_create','Admin(admin)创建组(天蝎二)',125,125,1);
INSERT INTO "oneid_meta_log" VALUES(198,'236291620a3e47a28f837ee856c1d062','2019-11-16 10:09:43.481239','group_move','Admin(admin)将新组(天蝎二)加入到组(天蝎)下',125,125,1);
INSERT INTO "oneid_meta_log" VALUES(199,'dd1123f0ca7f47aabb09cf05a8998a39','2019-11-16 10:09:48.303745','group_create','Admin(admin)创建组(天蝎三)',126,126,1);
INSERT INTO "oneid_meta_log" VALUES(200,'b11e8dcc1eec40e9a24346d2a6a991a2','2019-11-16 10:09:48.311035','group_move','Admin(admin)将新组(天蝎三)加入到组(天蝎)下',126,126,1);
INSERT INTO "oneid_meta_log" VALUES(201,'bef69204b1a348d08da6b940546ac6b0','2019-11-16 10:10:02.616327','group_update','Admin(admin)编辑组(天蝎一)信息',127,127,1);
INSERT INTO "oneid_meta_log" VALUES(202,'f638ea9dd9764e1d8b91960fd0256267','2019-11-16 10:10:02.651099','group_move','Admin(admin)将组(天蝎一)移到组(天蝎)下',128,128,1);
INSERT INTO "oneid_meta_log" VALUES(203,'be880fda63074adea3f4875273911668','2019-11-16 10:10:08.202621','group_update','Admin(admin)编辑组(天蝎二)信息',129,129,1);
INSERT INTO "oneid_meta_log" VALUES(204,'cbc4def8d24048b0947f93412ee9f2f8','2019-11-16 10:10:08.233966','group_move','Admin(admin)将组(天蝎二)移到组(天蝎)下',130,130,1);
INSERT INTO "oneid_meta_log" VALUES(205,'ea2138c75b8d4420880345df7ee8e489','2019-11-16 10:10:13.189566','group_update','Admin(admin)编辑组(天蝎三)信息',131,131,1);
INSERT INTO "oneid_meta_log" VALUES(206,'6ac6cf2b76c14161922ddad40d9a1859','2019-11-16 10:10:13.218636','group_move','Admin(admin)将组(天蝎三)移到组(天蝎)下',132,132,1);
INSERT INTO "oneid_meta_log" VALUES(207,'2bcc0615a8ad49b1817404e7a2421035','2019-11-16 10:10:32.555631','group_create','Admin(admin)创建组(蝴蝶一)',133,133,1);
INSERT INTO "oneid_meta_log" VALUES(208,'ad2a742959374fe8969a3b51d7d64e2c','2019-11-16 10:10:32.562625','group_move','Admin(admin)将新组(蝴蝶一)加入到组(蝴蝶)下',133,133,1);
INSERT INTO "oneid_meta_log" VALUES(209,'7d8a71c48c194400a2299574414af299','2019-11-16 10:10:42.813247','group_create','Admin(admin)创建组(蝴蝶二)',134,134,1);
INSERT INTO "oneid_meta_log" VALUES(210,'e7f565ac14804cff91d6146a1bb4cc98','2019-11-16 10:10:42.821367','group_move','Admin(admin)将新组(蝴蝶二)加入到组(蝴蝶)下',134,134,1);
INSERT INTO "oneid_meta_log" VALUES(211,'5989d736df9d48668b8a0f57b6923cbb','2019-11-16 10:10:50.962842','group_create','Admin(admin)创建组(蝴蝶五)',135,135,1);
INSERT INTO "oneid_meta_log" VALUES(212,'f687721a66594e889af97adc6ee1ff4f','2019-11-16 10:10:50.969559','group_move','Admin(admin)将新组(蝴蝶五)加入到组(蝴蝶)下',135,135,1);
INSERT INTO "oneid_meta_log" VALUES(213,'767313a82b8b46ce8318495c289e01ec','2019-11-16 10:11:16.115610','app_create','Admin(admin)创建应用(应用一)',136,136,1);
INSERT INTO "oneid_meta_log" VALUES(214,'c444f37bac74407bacbed1ea070c275f','2019-11-16 10:11:16.154482','group_create','Admin(admin)创建组(管理应用应用一)',137,137,1);
INSERT INTO "oneid_meta_log" VALUES(215,'a73661870ba1404d9be8be8d5c3a401c','2019-11-16 10:11:16.160768','group_move','Admin(admin)将新组(管理应用应用一)加入到组(子管理员组)下',137,137,1);
INSERT INTO "oneid_meta_log" VALUES(216,'842963089cd547e780d7f26f4713b8e7','2019-11-16 10:11:16.168336','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用一)',137,137,1);
INSERT INTO "oneid_meta_log" VALUES(217,'30c230464a6f4b19a384d7ad520d7952','2019-11-16 10:11:32.629118','app_create','Admin(admin)创建应用(应用二)',138,138,1);
INSERT INTO "oneid_meta_log" VALUES(218,'4cde438b171b4960b98a7270eb23fc72','2019-11-16 10:11:32.662261','group_create','Admin(admin)创建组(管理应用应用二)',139,139,1);
INSERT INTO "oneid_meta_log" VALUES(219,'7bb0ea8b987047d5ab26c76c89bb1630','2019-11-16 10:11:32.667017','group_move','Admin(admin)将新组(管理应用应用二)加入到组(子管理员组)下',139,139,1);
INSERT INTO "oneid_meta_log" VALUES(220,'106433e55a3340c9926cf908594e3fb9','2019-11-16 10:11:32.674937','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用二)',139,139,1);
INSERT INTO "oneid_meta_log" VALUES(221,'04134e3576fb4b4d8036920220bc1980','2019-11-16 10:11:37.903223','app_create','Admin(admin)创建应用(应用三)',140,140,1);
INSERT INTO "oneid_meta_log" VALUES(222,'d70b531aca6b459987d109e3c75d3cd0','2019-11-16 10:11:38.020496','group_create','Admin(admin)创建组(管理应用应用三)',141,141,1);
INSERT INTO "oneid_meta_log" VALUES(223,'f303a0cc2d1f4d11808089aa52f3d9de','2019-11-16 10:11:38.027729','group_move','Admin(admin)将新组(管理应用应用三)加入到组(子管理员组)下',141,141,1);
INSERT INTO "oneid_meta_log" VALUES(224,'4a6169ff35964627a4a15dcd3b66a2ee','2019-11-16 10:11:38.033268','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用三)',141,141,1);
INSERT INTO "oneid_meta_log" VALUES(225,'f9cda36fad5c44a090886af591c06e47','2019-11-16 10:11:43.654677','app_create','Admin(admin)创建应用(应用四)',142,142,1);
INSERT INTO "oneid_meta_log" VALUES(226,'c1d3bdce3f3b4d01be8144354cb07f96','2019-11-16 10:11:43.689215','group_create','Admin(admin)创建组(管理应用应用四)',143,143,1);
INSERT INTO "oneid_meta_log" VALUES(227,'140e0731dcc6478c87075d6f13a10b28','2019-11-16 10:11:43.694044','group_move','Admin(admin)将新组(管理应用应用四)加入到组(子管理员组)下',143,143,1);
INSERT INTO "oneid_meta_log" VALUES(228,'6e61f7745cca41ee8af3a9594ba5b692','2019-11-16 10:11:43.702182','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用四)',143,143,1);
INSERT INTO "oneid_meta_log" VALUES(229,'6394261c3b0a4b7084271716b34600ca','2019-11-16 10:11:51.617735','app_create','Admin(admin)创建应用(应用五)',144,144,1);
INSERT INTO "oneid_meta_log" VALUES(230,'287b6e930b6d414daac721695fc96351','2019-11-16 10:11:51.655748','group_create','Admin(admin)创建组(管理应用应用五)',145,145,1);
INSERT INTO "oneid_meta_log" VALUES(231,'38913aeffd944e5ab8fac5d64c4dbb98','2019-11-16 10:11:51.660863','group_move','Admin(admin)将新组(管理应用应用五)加入到组(子管理员组)下',145,145,1);
INSERT INTO "oneid_meta_log" VALUES(232,'91659924034e4ddb9df196e84ccf42e8','2019-11-16 10:11:51.666907','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用五)',145,145,1);
INSERT INTO "oneid_meta_log" VALUES(233,'219622e8e3f947208db9504b11c4efdd','2019-11-16 10:13:50.997605','user_update','Admin(admin) 编辑用户(一号(13899990001))信息',146,146,1);
INSERT INTO "oneid_meta_log" VALUES(234,'3b98e25b011041a79296cea1e0482753','2019-11-16 10:13:51.034959','group_member','Admin(admin)添加用户(一号(13899990001))至一批组()',147,147,1);
INSERT INTO "oneid_meta_log" VALUES(235,'54d2bb6a644e47d99d7ec5d112cf2033','2019-11-16 10:13:51.036486','group_member','Admin(admin)将用户(一号(13899990001))从一批组[]删除',147,147,1);
INSERT INTO "oneid_meta_log" VALUES(236,'8449c182867d480bb64670897a1205ec','2019-11-16 10:13:51.044239','dept_member','Admin(admin)添加用户(f一号(13899990001))至一批部门[部门一（所有可见）]',148,148,1);
INSERT INTO "oneid_meta_log" VALUES(237,'da860ff2d93549d0b124dbc514f3df74','2019-11-16 10:13:51.045499','dept_member','Admin(admin)将用户(一号(13899990001))从一批部门()删除',148,148,1);
INSERT INTO "oneid_meta_log" VALUES(238,'bd4f6f5c12ce4c1480052035baf7ddb7','2019-11-16 10:14:05.385904','user_update','Admin(admin) 编辑用户(二号(13899990002))信息',149,149,1);
INSERT INTO "oneid_meta_log" VALUES(239,'333d06d949314ac7ace0e9e861339470','2019-11-16 10:14:05.425078','group_member','Admin(admin)添加用户(二号(13899990002))至一批组()',150,150,1);
INSERT INTO "oneid_meta_log" VALUES(240,'3031cbf544ae45299c1accad4b612862','2019-11-16 10:14:05.426353','group_member','Admin(admin)将用户(二号(13899990002))从一批组[]删除',150,150,1);
INSERT INTO "oneid_meta_log" VALUES(241,'338c3a6435b647139de7a786fb657b5f','2019-11-16 10:14:05.434062','dept_member','Admin(admin)添加用户(f二号(13899990002))至一批部门[部门二（组内可见下属不可见）]',151,151,1);
INSERT INTO "oneid_meta_log" VALUES(242,'c0cdfa645c80475fb837077c0ee585c8','2019-11-16 10:14:05.435168','dept_member','Admin(admin)将用户(二号(13899990002))从一批部门()删除',151,151,1);
INSERT INTO "oneid_meta_log" VALUES(243,'4fe445ad27814635821a88bd5053de1b','2019-11-16 10:14:18.267060','user_update','Admin(admin) 编辑用户(三号(13899990003))信息',152,152,1);
INSERT INTO "oneid_meta_log" VALUES(244,'684820c43c9c42f6a18e4f51cb34c5e5','2019-11-16 10:14:18.303016','group_member','Admin(admin)添加用户(三号(13899990003))至一批组()',153,153,1);
INSERT INTO "oneid_meta_log" VALUES(245,'101954d483a64a74a51ae997510af03d','2019-11-16 10:14:18.304918','group_member','Admin(admin)将用户(三号(13899990003))从一批组[]删除',153,153,1);
INSERT INTO "oneid_meta_log" VALUES(246,'845e387a43a64be2818abca1dcda0b85','2019-11-16 10:14:18.312500','dept_member','Admin(admin)添加用户(f三号(13899990003))至一批部门[部门三（组内成员及下属分组可见）]',154,154,1);
INSERT INTO "oneid_meta_log" VALUES(247,'71c55c13738143c0a38589837dbe1923','2019-11-16 10:14:18.313711','dept_member','Admin(admin)将用户(三号(13899990003))从一批部门()删除',154,154,1);
INSERT INTO "oneid_meta_log" VALUES(248,'31443606b5574ff9aaa87590a426d6de','2019-11-16 10:14:29.525595','user_update','Admin(admin) 编辑用户(四号(13899990004))信息',155,155,1);
INSERT INTO "oneid_meta_log" VALUES(249,'f6a97c52735a4874b19255007cdae328','2019-11-16 10:14:29.567058','group_member','Admin(admin)添加用户(四号(13899990004))至一批组()',156,156,1);
INSERT INTO "oneid_meta_log" VALUES(250,'0d18568feb104e258389a91834147cdd','2019-11-16 10:14:29.569022','group_member','Admin(admin)将用户(四号(13899990004))从一批组[]删除',156,156,1);
INSERT INTO "oneid_meta_log" VALUES(251,'1a241e1bcbdf450698c7b18a45c13767','2019-11-16 10:14:29.575495','dept_member','Admin(admin)添加用户(f四号(13899990004))至一批部门[部门四（所有人不可见）]',157,157,1);
INSERT INTO "oneid_meta_log" VALUES(252,'2ee283b09b1348ffa8fe25b5ed1168c4','2019-11-16 10:14:29.576809','dept_member','Admin(admin)将用户(四号(13899990004))从一批部门()删除',157,157,1);
INSERT INTO "oneid_meta_log" VALUES(253,'30085294cd404a969a2450cc02a5dbfa','2019-11-16 10:14:40.939036','user_update','Admin(admin) 编辑用户(五号(13899990005))信息',158,158,1);
INSERT INTO "oneid_meta_log" VALUES(254,'4c05a925203c40d284ab9c220f8b6a92','2019-11-16 10:14:40.979770','group_member','Admin(admin)添加用户(五号(13899990005))至一批组()',159,159,1);
INSERT INTO "oneid_meta_log" VALUES(255,'3927e54ecc4e429789e68b6d61a24309','2019-11-16 10:14:40.981321','group_member','Admin(admin)将用户(五号(13899990005))从一批组[]删除',159,159,1);
INSERT INTO "oneid_meta_log" VALUES(256,'72d3d00c68b940d0ab264963329dc55a','2019-11-16 10:14:40.987224','dept_member','Admin(admin)添加用户(f五号(13899990005))至一批部门[部门五（部分人可见）]',160,160,1);
INSERT INTO "oneid_meta_log" VALUES(257,'be587cdd30ba46b19ab28b04af1e3f2d','2019-11-16 10:14:40.988247','dept_member','Admin(admin)将用户(五号(13899990005))从一批部门()删除',160,160,1);
INSERT INTO "oneid_meta_log" VALUES(258,'ccd5c48434cf401f84b8a113299dfbb0','2019-11-16 10:23:07.545909','group_update','Admin(admin)编辑组(性别)信息',161,161,1);
INSERT INTO "oneid_meta_log" VALUES(259,'0a00b392bc1741ff972a865344ae8853','2019-11-16 10:23:41.287953','group_update','Admin(admin)编辑组(自定义分组一)信息',162,162,1);
INSERT INTO "oneid_meta_log" VALUES(260,'a1497e649560405393efa3c0c5f60251','2019-11-16 10:24:10.638196','group_update','Admin(admin)编辑组(亲戚)信息',163,163,1);
INSERT INTO "oneid_meta_log" VALUES(261,'0ad03e94390641d790b94f2a3063db6e','2019-11-16 10:24:16.621766','group_update','Admin(admin)编辑组(校友)信息',164,164,1);
INSERT INTO "oneid_meta_log" VALUES(262,'428847644e5c4ea98c089a229c1ef798','2019-11-16 10:24:30.433348','group_create','Admin(admin)创建组(老师)',165,165,1);
INSERT INTO "oneid_meta_log" VALUES(263,'9f7506284f004854915283e3e24e4a03','2019-11-16 10:24:30.439714','group_move','Admin(admin)将新组(老师)加入到组(内部联系人-角色)下',165,165,1);
INSERT INTO "oneid_meta_log" VALUES(264,'ea40ff22795c47408a9c85f91656a06b','2019-11-16 10:24:30.497601','group_create','Admin(admin)创建组(管理分组老师)',166,166,1);
INSERT INTO "oneid_meta_log" VALUES(265,'6a8d9c4ca1564acea9b61c1fcb40a61e','2019-11-16 10:24:30.506503','group_move','Admin(admin)将新组(管理分组老师)加入到组(子管理员组)下',166,166,1);
INSERT INTO "oneid_meta_log" VALUES(266,'bba2f49e79c34bdfbb7a020fd00d70da','2019-11-16 10:24:30.514166','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理分组老师)',166,166,1);
INSERT INTO "oneid_meta_log" VALUES(267,'0e05b48da2904b81b288a75896bbcb6f','2019-11-16 10:25:14.727140','group_update','Admin(admin)编辑组(亲戚一)信息',167,167,1);
INSERT INTO "oneid_meta_log" VALUES(268,'6bbd2b9e1dc24b4ea3ae7df4fa541066','2019-11-16 10:25:14.752730','group_move','Admin(admin)将组(亲戚一)移到组(亲戚)下',168,168,1);
INSERT INTO "oneid_meta_log" VALUES(269,'00cc8647b1eb42059343b7ffd5f3597b','2019-11-16 10:25:30.660280','group_update','Admin(admin)编辑组(亲戚二)信息',169,169,1);
INSERT INTO "oneid_meta_log" VALUES(270,'2ee2e92b34e0490dbe4cea92299be03d','2019-11-16 10:25:30.688342','group_move','Admin(admin)将组(亲戚二)移到组(亲戚)下',170,170,1);
INSERT INTO "oneid_meta_log" VALUES(271,'a46d6e168347410db1bcecd51520f8e0','2019-11-16 10:25:37.214746','group_update','Admin(admin)编辑组(亲戚三)信息',171,171,1);
INSERT INTO "oneid_meta_log" VALUES(272,'09153922aa734cf9849c246d64c169f8','2019-11-16 10:25:37.242290','group_move','Admin(admin)将组(亲戚三)移到组(亲戚)下',172,172,1);
INSERT INTO "oneid_meta_log" VALUES(273,'9294b7dc59934992928979054915f2c2','2019-11-16 10:25:45.708874','group_update','Admin(admin)编辑组(校友一)信息',173,173,1);
INSERT INTO "oneid_meta_log" VALUES(274,'95decc08b8514fd2ae7e3c1c5aacb15d','2019-11-16 10:25:45.735757','group_move','Admin(admin)将组(校友一)移到组(校友)下',174,174,1);
INSERT INTO "oneid_meta_log" VALUES(275,'0367df86398a421684a442ae5263dffb','2019-11-16 10:25:51.975379','group_update','Admin(admin)编辑组(校友二)信息',175,175,1);
INSERT INTO "oneid_meta_log" VALUES(276,'87d870cf19a44628b91027b69c6e9d99','2019-11-16 10:25:52.003147','group_move','Admin(admin)将组(校友二)移到组(校友)下',176,176,1);
INSERT INTO "oneid_meta_log" VALUES(277,'82be3c294eb5401f908908ba5b64ff5e','2019-11-16 10:25:57.262443','group_update','Admin(admin)编辑组(校友二)信息',177,177,1);
INSERT INTO "oneid_meta_log" VALUES(278,'609841e8360441d5af2093a6b7d32647','2019-11-16 10:25:57.290412','group_move','Admin(admin)将组(校友二)移到组(校友)下',178,178,1);
INSERT INTO "oneid_meta_log" VALUES(279,'804583c83d9849df8cdfd425e7afbea4','2019-11-16 10:26:07.475926','group_update','Admin(admin)编辑组(校友五)信息',179,179,1);
INSERT INTO "oneid_meta_log" VALUES(280,'5b9e4ff764e643ca86e08e1fbf7b2301','2019-11-16 10:26:07.501125','group_move','Admin(admin)将组(校友五)移到组(校友)下',180,180,1);
INSERT INTO "oneid_meta_log" VALUES(281,'cd0c9bb624de4c5186f14d51321b9a51','2019-11-16 10:26:29.316330','user_update','Admin(admin) 编辑用户(六号(13899990006))信息',181,181,1);
INSERT INTO "oneid_meta_log" VALUES(282,'b693e406ba1944f799848387f6d758d2','2019-11-16 10:26:29.353835','group_member','Admin(admin)添加用户(六号(13899990006))至一批组()',182,182,1);
INSERT INTO "oneid_meta_log" VALUES(283,'a7d061c6f50f4d588576403f4281d0b8','2019-11-16 10:26:29.355735','group_member','Admin(admin)将用户(六号(13899990006))从一批组[]删除',182,182,1);
INSERT INTO "oneid_meta_log" VALUES(284,'7dd4b3ec878448b38ece3becee2d9c24','2019-11-16 10:26:29.359903','dept_member','Admin(admin)添加用户(f六号(13899990006))至一批部门[]',183,183,1);
INSERT INTO "oneid_meta_log" VALUES(285,'e03b04893f324a77b5d7ac61e123ee61','2019-11-16 10:26:29.361263','dept_member','Admin(admin)将用户(六号(13899990006))从一批部门()删除',183,183,1);
INSERT INTO "oneid_meta_log" VALUES(286,'c1739b1ec39d472a89d6c70cb9f388ce','2019-11-16 10:27:22.035242','user_update','Admin(admin) 编辑用户(部门一admin(13899990001))信息',184,184,1);
INSERT INTO "oneid_meta_log" VALUES(287,'35239bc10e984cfdbc13259fa1d23a6f','2019-11-16 10:27:22.083617','group_member','Admin(admin)添加用户(部门一admin(13899990001))至一批组()',185,185,1);
INSERT INTO "oneid_meta_log" VALUES(288,'a95ab9d1f3fc42f692956f4737831a58','2019-11-16 10:27:22.084916','group_member','Admin(admin)将用户(部门一admin(13899990001))从一批组[]删除',185,185,1);
INSERT INTO "oneid_meta_log" VALUES(289,'4390ab6006f2494195ead2d153ed112e','2019-11-16 10:27:22.089842','dept_member','Admin(admin)添加用户(f部门一admin(13899990001))至一批部门[]',186,186,1);
INSERT INTO "oneid_meta_log" VALUES(290,'5b8ec7ee904a47bd937a011aef41eaeb','2019-11-16 10:27:22.090880','dept_member','Admin(admin)将用户(部门一admin(13899990001))从一批部门()删除',186,186,1);
INSERT INTO "oneid_meta_log" VALUES(291,'685fde6825144bcc87e7442bc2d157f4','2019-11-16 10:27:31.204533','user_update','Admin(admin) 编辑用户(部门二admin(13899990002))信息',187,187,1);
INSERT INTO "oneid_meta_log" VALUES(292,'2ff17caead844788bdf1cacf584aeaa0','2019-11-16 10:27:31.251799','group_member','Admin(admin)添加用户(部门二admin(13899990002))至一批组()',188,188,1);
INSERT INTO "oneid_meta_log" VALUES(293,'9237e05efbe7497b8aedef6741a8e1aa','2019-11-16 10:27:31.253772','group_member','Admin(admin)将用户(部门二admin(13899990002))从一批组[]删除',188,188,1);
INSERT INTO "oneid_meta_log" VALUES(294,'849b90eb474d4534bf7137f179e034e2','2019-11-16 10:27:31.258979','dept_member','Admin(admin)添加用户(f部门二admin(13899990002))至一批部门[]',189,189,1);
INSERT INTO "oneid_meta_log" VALUES(295,'0a8779f4fa494cdebd16c8c82ff6abd5','2019-11-16 10:27:31.259998','dept_member','Admin(admin)将用户(部门二admin(13899990002))从一批部门()删除',189,189,1);
INSERT INTO "oneid_meta_log" VALUES(296,'fc724e20391d43708e602d8c0f78958a','2019-11-16 10:27:41.376883','user_update','Admin(admin) 编辑用户(部门三admin(13899990003))信息',190,190,1);
INSERT INTO "oneid_meta_log" VALUES(297,'94640148f2c94a2f98fc268c04b10570','2019-11-16 10:27:41.421958','group_member','Admin(admin)添加用户(部门三admin(13899990003))至一批组()',191,191,1);
INSERT INTO "oneid_meta_log" VALUES(298,'fa2b44ebea7346a8a174fb94f019e22e','2019-11-16 10:27:41.423851','group_member','Admin(admin)将用户(部门三admin(13899990003))从一批组[]删除',191,191,1);
INSERT INTO "oneid_meta_log" VALUES(299,'9a1796eb7e55482d94536b1383b8a52f','2019-11-16 10:27:41.430716','dept_member','Admin(admin)添加用户(f部门三admin(13899990003))至一批部门[]',192,192,1);
INSERT INTO "oneid_meta_log" VALUES(300,'1cd39e78eb88426ab38420b14b3233a0','2019-11-16 10:27:41.431849','dept_member','Admin(admin)将用户(部门三admin(13899990003))从一批部门()删除',192,192,1);
INSERT INTO "oneid_meta_log" VALUES(301,'ffcb7416110543d9a391358fe8651320','2019-11-16 10:27:50.221308','user_update','Admin(admin) 编辑用户(部门四admin(13899990004))信息',193,193,1);
INSERT INTO "oneid_meta_log" VALUES(302,'f65ac28a1ddd4fdd9a8269b2e854f612','2019-11-16 10:27:50.269039','group_member','Admin(admin)添加用户(部门四admin(13899990004))至一批组()',194,194,1);
INSERT INTO "oneid_meta_log" VALUES(303,'afb22853c7a044fc8b2702e78a8582fc','2019-11-16 10:27:50.270588','group_member','Admin(admin)将用户(部门四admin(13899990004))从一批组[]删除',194,194,1);
INSERT INTO "oneid_meta_log" VALUES(304,'55576b2b71584a5bae2c30efe21958de','2019-11-16 10:27:50.275664','dept_member','Admin(admin)添加用户(f部门四admin(13899990004))至一批部门[]',195,195,1);
INSERT INTO "oneid_meta_log" VALUES(305,'5e920cdbf8f2441e91f84bd0eec36d81','2019-11-16 10:27:50.276808','dept_member','Admin(admin)将用户(部门四admin(13899990004))从一批部门()删除',195,195,1);
INSERT INTO "oneid_meta_log" VALUES(306,'3456d6da40e643ed95fb0ab618e782f9','2019-11-16 10:28:03.707162','user_update','Admin(admin) 编辑用户(部门五admin(13899990005))信息',196,196,1);
INSERT INTO "oneid_meta_log" VALUES(307,'51ba031dd8494f1c9e0a2e557edbffed','2019-11-16 10:28:03.756591','group_member','Admin(admin)添加用户(部门五admin(13899990005))至一批组()',197,197,1);
INSERT INTO "oneid_meta_log" VALUES(308,'7c62136d0ad4492bbd55c0ed0955f58e','2019-11-16 10:28:03.758720','group_member','Admin(admin)将用户(部门五admin(13899990005))从一批组[]删除',197,197,1);
INSERT INTO "oneid_meta_log" VALUES(309,'ddc57fc5fe8648d3b02ad55559e72eb8','2019-11-16 10:28:03.764370','dept_member','Admin(admin)添加用户(f部门五admin(13899990005))至一批部门[]',198,198,1);
INSERT INTO "oneid_meta_log" VALUES(310,'a93ddda2ed164dc798956f2b0df5e9f0','2019-11-16 10:28:03.765954','dept_member','Admin(admin)将用户(部门五admin(13899990005))从一批部门()删除',198,198,1);
INSERT INTO "oneid_meta_log" VALUES(311,'598c6a5531a54fe2964bf1328778ae25','2019-11-16 10:28:34.279654','user_update','Admin(admin) 编辑用户(六号(13899990006))信息',199,199,1);
INSERT INTO "oneid_meta_log" VALUES(312,'2e4b8cc76f4c4e7ba629720a0c55d5cc','2019-11-16 10:28:34.319980','group_member','Admin(admin)添加用户(六号(13899990006))至一批组()',200,200,1);
INSERT INTO "oneid_meta_log" VALUES(313,'2475e12e2f3f4529a3cb205849b711fe','2019-11-16 10:28:34.321725','group_member','Admin(admin)将用户(六号(13899990006))从一批组[]删除',200,200,1);
INSERT INTO "oneid_meta_log" VALUES(314,'aa420359a50e4f1e9f48761f5be98441','2019-11-16 10:28:34.328310','dept_member','Admin(admin)添加用户(f六号(13899990006))至一批部门[部门一（一）]',201,201,1);
INSERT INTO "oneid_meta_log" VALUES(315,'5c1a1753211b4efa863bdf4b25fe084d','2019-11-16 10:28:34.330240','dept_member','Admin(admin)将用户(六号(13899990006))从一批部门()删除',201,201,1);
INSERT INTO "oneid_meta_log" VALUES(316,'c2964f3227de4fd88354a7a4533c5aba','2019-11-16 10:31:18.670324','user_update','Admin(admin) 编辑用户(部门一一admin(13899990006))信息',202,202,1);
INSERT INTO "oneid_meta_log" VALUES(317,'9f84719a715b405a809e81e9c6112b41','2019-11-16 10:31:18.713964','group_member','Admin(admin)添加用户(部门一一admin(13899990006))至一批组()',203,203,1);
INSERT INTO "oneid_meta_log" VALUES(318,'3a8fad512f7140eba5fbbc7aba5479cf','2019-11-16 10:31:18.716367','group_member','Admin(admin)将用户(部门一一admin(13899990006))从一批组[]删除',203,203,1);
INSERT INTO "oneid_meta_log" VALUES(319,'fb040679c8fa4e5cb3bae10b2f73b6c2','2019-11-16 10:31:18.722773','dept_member','Admin(admin)添加用户(f部门一一admin(13899990006))至一批部门[]',204,204,1);
INSERT INTO "oneid_meta_log" VALUES(320,'096f8d601bed4424a9ca8437384d931f','2019-11-16 10:31:18.724110','dept_member','Admin(admin)将用户(部门一一admin(13899990006))从一批部门()删除',204,204,1);
INSERT INTO "oneid_meta_log" VALUES(321,'ffafea60b55e4bc4b55a1276a6f86fda','2019-11-16 10:31:38.460760','user_update','Admin(admin) 编辑用户(部门一二adm(13899990007))信息',205,205,1);
INSERT INTO "oneid_meta_log" VALUES(322,'8f57c849c958427d9f2ccac57d1c00ca','2019-11-16 10:31:38.502413','group_member','Admin(admin)添加用户(部门一二adm(13899990007))至一批组()',206,206,1);
INSERT INTO "oneid_meta_log" VALUES(323,'3005aa4d99f743beb3c94cc0620aac3d','2019-11-16 10:31:38.503702','group_member','Admin(admin)将用户(部门一二adm(13899990007))从一批组[]删除',206,206,1);
INSERT INTO "oneid_meta_log" VALUES(324,'449c5278e91e47eaabfcab63827ff43a','2019-11-16 10:31:38.509515','dept_member','Admin(admin)添加用户(f部门一二adm(13899990007))至一批部门[部门一（二）]',207,207,1);
INSERT INTO "oneid_meta_log" VALUES(325,'26e1daf2582a4398ac1714d2ba13be8d','2019-11-16 10:31:38.510749','dept_member','Admin(admin)将用户(部门一二adm(13899990007))从一批部门()删除',207,207,1);
INSERT INTO "oneid_meta_log" VALUES(326,'5dbe77684cd242cfaab134171748304c','2019-11-16 10:31:55.477920','user_update','Admin(admin) 编辑用户(部门一三adm(13899990008))信息',208,208,1);
INSERT INTO "oneid_meta_log" VALUES(327,'5a9e52373823442b964339176404d911','2019-11-16 10:31:55.515977','group_member','Admin(admin)添加用户(部门一三adm(13899990008))至一批组()',209,209,1);
INSERT INTO "oneid_meta_log" VALUES(328,'df3b227d100a43838a049b82015c7e31','2019-11-16 10:31:55.517431','group_member','Admin(admin)将用户(部门一三adm(13899990008))从一批组[]删除',209,209,1);
INSERT INTO "oneid_meta_log" VALUES(329,'faa54dfdcc8b45f485f926c174bd6048','2019-11-16 10:31:55.524934','dept_member','Admin(admin)添加用户(f部门一三adm(13899990008))至一批部门[部门一（三）]',210,210,1);
INSERT INTO "oneid_meta_log" VALUES(330,'fd47f129928045508ed707231fda699d','2019-11-16 10:31:55.526735','dept_member','Admin(admin)将用户(部门一三adm(13899990008))从一批部门()删除',210,210,1);
INSERT INTO "oneid_meta_log" VALUES(331,'4ac2bee5976946d18ca02491c374ef26','2019-11-16 10:32:10.633852','user_update','Admin(admin) 编辑用户(部门一四admin(13899990009))信息',211,211,1);
INSERT INTO "oneid_meta_log" VALUES(332,'4df44588116741c58ad7f6973d7e479e','2019-11-16 10:32:10.672996','group_member','Admin(admin)添加用户(部门一四admin(13899990009))至一批组()',212,212,1);
INSERT INTO "oneid_meta_log" VALUES(333,'5f27f8605ec5495c81f3a3e601fda4e4','2019-11-16 10:32:10.674503','group_member','Admin(admin)将用户(部门一四admin(13899990009))从一批组[]删除',212,212,1);
INSERT INTO "oneid_meta_log" VALUES(334,'790b7fd25e11410d83750d75365abbff','2019-11-16 10:32:10.680665','dept_member','Admin(admin)添加用户(f部门一四admin(13899990009))至一批部门[部门一（四）]',213,213,1);
INSERT INTO "oneid_meta_log" VALUES(335,'1c0f101adaa744a486f29a5d537c23c8','2019-11-16 10:32:10.681728','dept_member','Admin(admin)将用户(部门一四admin(13899990009))从一批部门()删除',213,213,1);
INSERT INTO "oneid_meta_log" VALUES(336,'16b63a3a5d754e6eb513d4bc53da1358','2019-11-16 10:33:09.073544','user_create','Admin(admin) 创建新用户 部门一五adm(13899990010)',214,214,1);
INSERT INTO "oneid_meta_log" VALUES(337,'dd975818690e4c798d0a810bf87db731','2019-11-16 10:33:09.076242','ucenter_reset_pwd','Admin(admin) 修改用户(部门一五adm(13899990010))密码',214,214,1);
INSERT INTO "oneid_meta_log" VALUES(338,'6de23b711fe048c4b1f057b8f1a5efd5','2019-11-16 10:33:09.082812','dept_member','Admin(admin)添加用户(f部门一五adm(13899990010))至一批部门[部门一（五）]',215,215,1);
INSERT INTO "oneid_meta_log" VALUES(339,'c2eecb75f5b0445fb8644ea78b3421a9','2019-11-16 10:33:09.084112','group_member','Admin(admin)添加用户(部门一五adm(13899990010))至一批组()',215,215,1);
INSERT INTO "oneid_meta_log" VALUES(340,'98fe6881ac914719ab85cfc955dd5d9f','2019-11-16 10:33:54.315243','user_update','Admin(admin) 编辑用户(部门一五adm(13899990010))信息',216,216,1);
INSERT INTO "oneid_meta_log" VALUES(341,'7a43028662d64da1af75ef756858f3a6','2019-11-16 10:33:54.352900','group_member','Admin(admin)添加用户(部门一五adm(13899990010))至一批组()',217,217,1);
INSERT INTO "oneid_meta_log" VALUES(342,'d7dcacbc59cb49cb9aebf45675295374','2019-11-16 10:33:54.354221','group_member','Admin(admin)将用户(部门一五adm(13899990010))从一批组[]删除',217,217,1);
INSERT INTO "oneid_meta_log" VALUES(343,'ae9419da7ccc423b86a7a4fd2cc6c4e7','2019-11-16 10:33:54.359171','dept_member','Admin(admin)添加用户(f部门一五adm(13899990010))至一批部门[]',218,218,1);
INSERT INTO "oneid_meta_log" VALUES(344,'89fa55298df242d0a4f659ccabad41e5','2019-11-16 10:33:54.360959','dept_member','Admin(admin)将用户(部门一五adm(13899990010))从一批部门()删除',218,218,1);
INSERT INTO "oneid_meta_log" VALUES(345,'41bb1ff9a795405e9b307913da738c79','2019-11-16 10:34:07.541675','ucenter_login','部门一五adm(13899990010)登录',219,219,13);
INSERT INTO "oneid_meta_log" VALUES(346,'951b8f871131436ab0320a6077f119bd','2019-11-16 10:36:53.306961','app_create','Admin(admin)创建应用(应用六)',220,220,1);
INSERT INTO "oneid_meta_log" VALUES(347,'946edaea2f524af9a08c7d7008e0f45a','2019-11-16 10:36:53.346446','group_create','Admin(admin)创建组(管理应用应用六)',221,221,1);
INSERT INTO "oneid_meta_log" VALUES(348,'22f9aba8f7ef4edbb060163fb9e84096','2019-11-16 10:36:53.351460','group_move','Admin(admin)将新组(管理应用应用六)加入到组(子管理员组)下',221,221,1);
INSERT INTO "oneid_meta_log" VALUES(349,'0777c35d54b64154b02035a2ff71c3df','2019-11-16 10:36:53.358661','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用六)',221,221,1);
INSERT INTO "oneid_meta_log" VALUES(350,'fcf831f8baa240369549eda7431a8323','2019-11-16 10:36:59.320881','app_create','Admin(admin)创建应用(应用七)',222,222,1);
INSERT INTO "oneid_meta_log" VALUES(351,'9305708872394fcb86bf6f1861cbc7d6','2019-11-16 10:36:59.359234','group_create','Admin(admin)创建组(管理应用应用七)',223,223,1);
INSERT INTO "oneid_meta_log" VALUES(352,'8bd82f7a956f4d7fbc9163b9e70633b5','2019-11-16 10:36:59.365837','group_move','Admin(admin)将新组(管理应用应用七)加入到组(子管理员组)下',223,223,1);
INSERT INTO "oneid_meta_log" VALUES(353,'3f076ce881af4db5865daee65fc5be3a','2019-11-16 10:36:59.371391','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用七)',223,223,1);
INSERT INTO "oneid_meta_log" VALUES(354,'ae950212e3534fd7ba3a6670605dde6a','2019-11-16 10:37:06.195291','app_create','Admin(admin)创建应用(应用八)',224,224,1);
INSERT INTO "oneid_meta_log" VALUES(355,'92af0770a07e496696cde4c219ea4a1b','2019-11-16 10:37:06.239010','group_create','Admin(admin)创建组(管理应用应用八)',225,225,1);
INSERT INTO "oneid_meta_log" VALUES(356,'51ac7d399b1f43539b8c7493ab25ab7c','2019-11-16 10:37:06.243881','group_move','Admin(admin)将新组(管理应用应用八)加入到组(子管理员组)下',225,225,1);
INSERT INTO "oneid_meta_log" VALUES(357,'e92460950f2e40f881e6fdcc79c715e3','2019-11-16 10:37:06.251113','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用八)',225,225,1);
INSERT INTO "oneid_meta_log" VALUES(358,'76686eee29da4ac8a8922e122cc66bee','2019-11-16 10:37:13.317598','app_create','Admin(admin)创建应用(应用九)',226,226,1);
INSERT INTO "oneid_meta_log" VALUES(359,'b8b65711bc7a485c8fec2cf8f3e281a3','2019-11-16 10:37:13.363537','group_create','Admin(admin)创建组(管理应用应用九)',227,227,1);
INSERT INTO "oneid_meta_log" VALUES(360,'9e18ab4c63cd4ec6ba0d43f38384a979','2019-11-16 10:37:13.368335','group_move','Admin(admin)将新组(管理应用应用九)加入到组(子管理员组)下',227,227,1);
INSERT INTO "oneid_meta_log" VALUES(361,'34284c51488945a798df3e978c99cc45','2019-11-16 10:37:13.376053','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用九)',227,227,1);
INSERT INTO "oneid_meta_log" VALUES(362,'3627630f5ccc423590d54be15c4c16cb','2019-11-16 10:37:18.750875','app_create','Admin(admin)创建应用(应用十)',228,228,1);
INSERT INTO "oneid_meta_log" VALUES(363,'1d5ee45690544833bdc83d33c2587ac6','2019-11-16 10:37:18.794570','group_create','Admin(admin)创建组(管理应用应用十)',229,229,1);
INSERT INTO "oneid_meta_log" VALUES(364,'b9f1b96fa2234984ae64f06f0de78cff','2019-11-16 10:37:18.800232','group_move','Admin(admin)将新组(管理应用应用十)加入到组(子管理员组)下',229,229,1);
INSERT INTO "oneid_meta_log" VALUES(365,'f399565fcf5b4a7d9be47db632474e5f','2019-11-16 10:37:18.806408','group_member','Admin(admin)添加一批用户[Admin(admin)]至组(管理应用应用十)',229,229,1);
INSERT INTO "oneid_meta_log" VALUES(366,'a6801bdc8a4148f29d26666771b82d9a','2019-11-16 10:41:08.002604','ucenter_login','部门一admin(13899990001)登录',230,230,4);
INSERT INTO "oneid_meta_log" VALUES(367,'a61280cfecc54f88864fe6263759f6f8','2019-11-16 10:41:55.362064','ucenter_login','Admin(admin)登录',231,231,1);
INSERT INTO "oneid_meta_log" VALUES(368,'605bba8d35ab4487af149dafbcd6a922','2019-11-16 10:43:05.432708','ucenter_login','部门二admin(13899990002)登录',232,232,5);
INSERT INTO "oneid_meta_log" VALUES(369,'2619248ad8b94bcfa301de8831ae456a','2019-11-16 10:43:14.125703','ucenter_login','Admin(admin)登录',233,233,1);
INSERT INTO "oneid_meta_log" VALUES(370,'e495d3ee2afb471582c702a40116d045','2019-11-16 11:11:28.669221','ucenter_login','Admin(admin)登录',234,234,1);
INSERT INTO "oneid_meta_log" VALUES(371,'0a2e705bf4e44be79195ce78cbff8c63','2019-12-20 07:02:27.392836','ucenter_login','(admin)登录',235,235,1);
INSERT INTO "oneid_meta_log" VALUES(372,'f5f8092c8b314e9aa89fce968683b2e5','2019-12-20 08:46:55.761832','ucenter_login','(admin)登录',236,236,1);
INSERT INTO "oneid_meta_log" VALUES(373,'20e67264433243ca92a45dbdd434251d','2019-12-27 04:08:32.051043','group_create','ADMIN(admin)创建组(wdexnpal)',237,237,1);
INSERT INTO "oneid_meta_log" VALUES(374,'35316b03e82c4498bedae868e03f5031','2019-12-27 04:08:32.060725','group_move','ADMIN(admin)将新组(wdexnpal)加入到组(子管理员组)下',237,237,1);
INSERT INTO "oneid_meta_log" VALUES(375,'fb0df995af434ba9bb7bc638c2ca3119','2019-12-27 04:08:32.170644','group_member','ADMIN(admin)添加一批用户[部门一admin(13899990001)]至组(wdexnpal)',238,238,1);
INSERT INTO "oneid_meta_log" VALUES(376,'2fbf03b6ba84491581c0a3ca9d119318','2019-12-27 04:08:32.173588','group_member','ADMIN(admin)将一批用户[]从组(wdexnpal)删除',238,238,1);
INSERT INTO "oneid_meta_log" VALUES(377,'09527968025d4420a896a76be46df541','2019-12-27 04:08:32.183542','group_member','ADMIN(admin)调整一批用户[部门一admin(13899990001)]在组(wdexnpal)中的顺序',238,238,1);
INSERT INTO "oneid_meta_log" VALUES(378,'9bf655b8367848d1a77fdb4a22ef15a7','2019-12-27 04:09:04.405143','group_create','ADMIN(admin)创建组(jhomcpvf)',239,239,1);
INSERT INTO "oneid_meta_log" VALUES(379,'3e47c7584b05405fa79fba1bfa3bc6e2','2019-12-27 04:09:04.411232','group_move','ADMIN(admin)将新组(jhomcpvf)加入到组(子管理员组)下',239,239,1);
INSERT INTO "oneid_meta_log" VALUES(380,'ca336460c3874c57bed67fa4383bd1f0','2019-12-27 04:09:04.447812','group_member','ADMIN(admin)添加一批用户[部门二admin(13899990002)]至组(jhomcpvf)',240,240,1);
INSERT INTO "oneid_meta_log" VALUES(381,'1c3f2677531748b6bd23da667f12c94b','2019-12-27 04:09:04.450290','group_member','ADMIN(admin)将一批用户[]从组(jhomcpvf)删除',240,240,1);
INSERT INTO "oneid_meta_log" VALUES(382,'815c2e15cfd04224a77c5312b2558df8','2019-12-27 04:09:04.456141','group_member','ADMIN(admin)调整一批用户[部门二admin(13899990002)]在组(jhomcpvf)中的顺序',240,240,1);
INSERT INTO "oneid_meta_log" VALUES(383,'f349c87ba76347b2ad978c05f958d9a8','2019-12-27 04:14:28.995164','group_create','ADMIN(admin)创建组(skbykchp)',241,241,1);
INSERT INTO "oneid_meta_log" VALUES(384,'6b93b68df44d415199ef18e3fbde9eee','2019-12-27 04:14:29.003529','group_move','ADMIN(admin)将新组(skbykchp)加入到组(子管理员组)下',241,241,1);
INSERT INTO "oneid_meta_log" VALUES(385,'54620c85ab8942f3a39cbbf7d3789475','2019-12-27 04:14:29.041986','group_member','ADMIN(admin)添加一批用户[部门三admin(13899990003)]至组(skbykchp)',242,242,1);
INSERT INTO "oneid_meta_log" VALUES(386,'2f43c8c4f9884b78a956416f5457c093','2019-12-27 04:14:29.044515','group_member','ADMIN(admin)将一批用户[]从组(skbykchp)删除',242,242,1);
INSERT INTO "oneid_meta_log" VALUES(387,'5967fc1e717443f69a7a4bbaad3bf2ef','2019-12-27 04:14:29.054512','group_member','ADMIN(admin)调整一批用户[部门三admin(13899990003)]在组(skbykchp)中的顺序',242,242,1);
INSERT INTO "oneid_meta_log" VALUES(388,'bbc9b8651e6b4df491eec0779101d8f0','2019-12-27 04:15:03.320932','group_create','ADMIN(admin)创建组(zwmjfxzq)',243,243,1);
INSERT INTO "oneid_meta_log" VALUES(389,'8fb922d1ec2242f9b3265e0ab04a3fd1','2019-12-27 04:15:03.328222','group_move','ADMIN(admin)将新组(zwmjfxzq)加入到组(子管理员组)下',243,243,1);
INSERT INTO "oneid_meta_log" VALUES(390,'083eddd06e524711a7698b66f3d2edd4','2019-12-27 04:15:03.362379','group_member','ADMIN(admin)添加一批用户[部门三admin(13899990003)]至组(zwmjfxzq)',244,244,1);
INSERT INTO "oneid_meta_log" VALUES(391,'895b4a1eb77c406db737671499b27d03','2019-12-27 04:15:03.365301','group_member','ADMIN(admin)将一批用户[]从组(zwmjfxzq)删除',244,244,1);
INSERT INTO "oneid_meta_log" VALUES(392,'d47c6121ee504bfd8766f00c3f6ae0d8','2019-12-27 04:15:03.371108','group_member','ADMIN(admin)调整一批用户[部门三admin(13899990003)]在组(zwmjfxzq)中的顺序',244,244,1);
INSERT INTO "oneid_meta_log" VALUES(393,'30467b0cf30a459c96e1977c8b7e209e','2019-12-27 05:22:39.800848','ucenter_login','ADMIN(admin)登录',245,245,1);
INSERT INTO "oneid_meta_log" VALUES(394,'00d2e7eeac5f476c96e2bc60dc46cc88','2019-12-27 05:22:53.018223','dept_update','ADMIN(admin)编辑部门(部门一（所有人可见）)信息',246,246,1);
INSERT INTO "oneid_meta_log" VALUES(395,'6efe401eb7f44ac1b56bd97215ae42ff','2019-12-27 05:27:14.444738','perm_assign','ADMIN(admin)修改权限(访问应用十(app_yingyongshi_access))的黑白名单',247,247,1);
INSERT INTO "oneid_meta_log" VALUES(396,'647c63fcbe5349b698d17e946fd3bca6','2019-12-27 09:01:37.754939','ucenter_login','ADMIN(admin)登录',248,248,1);
INSERT INTO "oneid_meta_log" VALUES(397,'ff9a43d5934a41de9f7ee5371852a51b','2019-12-27 09:01:46.380754','perm_assign','ADMIN(admin)修改权限(访问应用十(app_yingyongshi_access))的黑白名单',249,249,1);
INSERT INTO "oneid_meta_log" VALUES(398,'c2eb19702cc7428b824d161e3cba89b9','2019-12-27 09:02:07.113299','perm_assign','ADMIN(admin)修改权限(访问应用十(app_yingyongshi_access))的黑白名单',250,250,1);
INSERT INTO "oneid_meta_log" VALUES(399,'61eb4c9f21a24a2ebf1c697ea6988027','2019-12-27 09:08:16.573716','ucenter_login','部门一一admin(13899990006)登录',251,251,9);
INSERT INTO "oneid_meta_log" VALUES(400,'7cd1fc7533a649f0803e42119e3634a3','2019-12-27 09:08:24.486461','ucenter_login','部门一二adm(13899990007)登录',252,252,10);
INSERT INTO "oneid_meta_log" VALUES(401,'8e521d7c7d1343eda939e3f72311ada5','2019-12-27 09:09:47.378805','ucenter_login','部门一一admin(13899990006)登录',253,253,9);
INSERT INTO "oneid_meta_log" VALUES(402,'9f1c26da574f4084af3a6b5cdf644640','2019-12-27 09:16:34.018216','ucenter_login','部门一二adm(13899990007)登录',254,254,10);
INSERT INTO "oneid_meta_log" VALUES(403,'1e995f595d834b489732c5628abfecf2','2019-12-27 09:17:54.433073','ucenter_login','ADMIN(admin)登录',255,255,1);
INSERT INTO "oneid_meta_log" VALUES(404,'a5ec781446574307bdcd2e7cd5710e46','2019-12-27 09:18:56.221041','ucenter_login','部门三admin(13899990003)登录',256,256,6);
INSERT INTO "oneid_meta_log" VALUES(405,'9b379e3b00384d27a8da854df8d54718','2019-12-27 09:19:15.131043','user_create','部门三admin(13899990003) 创建新用户 1234(1234)',257,257,6);
INSERT INTO "oneid_meta_log" VALUES(406,'d88da9ed52604a5c9123b56edb3b329e','2019-12-27 09:19:15.135663','dept_member','部门三admin(13899990003)添加用户(f1234(1234))至一批部门[]',258,258,6);
INSERT INTO "oneid_meta_log" VALUES(407,'ed71177ce35140bcbb58aaf160d1c75e','2019-12-27 09:19:15.140584','group_member','部门三admin(13899990003)添加用户(1234(1234))至一批组(角色三（一）)',258,258,6);
INSERT INTO "oneid_meta_log" VALUES(408,'dfe06caf413c4f42a1f3d7c35c847da3','2019-12-27 09:19:42.993801','ucenter_login','ADMIN(admin)登录',259,259,1);
INSERT INTO "oneid_meta_log" VALUES(409,'d76786d132ee4aab90d9381540c4cc83','2019-12-27 09:25:11.132787','ucenter_login','ADMIN(admin)登录',260,260,1);
INSERT INTO "oneid_meta_log" VALUES(410,'610236248b1b41cfb18ddf54d100636a','2019-12-27 09:25:22.150730','user_delete','ADMIN(admin)批量删除用户[1234(1234)]',261,261,1);
INSERT INTO "oneid_meta_log" VALUES(411,'bd79e3c257384cf88ef4adcfd94eea96','2019-12-27 10:53:53.899489','ucenter_login','ADMIN(admin)登录',262,262,1);
INSERT INTO "oneid_meta_log" VALUES(412,'3ff5b537ea8e43ef83062457adf7cd15','2019-12-27 10:57:55.893430','config','ADMIN(admin)更新系统配置',263,263,1);
INSERT INTO "oneid_meta_log" VALUES(413,'1bf817e2fddb4bc4a20c8ecd62e5d3a6','2019-12-27 11:01:04.824189','ucenter_login','ADMIN(admin)登录',264,264,1);
INSERT INTO "oneid_meta_log" VALUES(414,'68b2407775a247a1a14fa98f252b6f8e','2019-12-27 11:01:12.231304','config','ADMIN(admin)更新系统配置',265,265,1);
INSERT INTO "oneid_meta_log" VALUES(415,'f3e418ae21de40e0b514ae63db72a2d6','2019-12-27 11:01:43.299596','ucenter_register','用户注册: (13899990011)',266,266,15);
INSERT INTO "oneid_meta_log" VALUES(416,'27766e1e3e3f46b2b46e3d89254ecc58','2019-12-27 11:01:43.306964','ucenter_reset_pwd','(13899990011) 修改用户((13899990011))密码',266,266,15);
INSERT INTO "oneid_meta_log" VALUES(417,'144a887224ca4bfa9b733cc4de0178d1','2019-12-27 11:01:43.319308','group_member','(13899990011)添加一批用户[(13899990011)]至组(外部联系人)',267,267,15);
INSERT INTO "oneid_meta_log" VALUES(418,'60bd09d755ad4dcfb4092b14306d5872','2019-12-27 11:02:13.140020','ucenter_register','用户注册: (13899990012)',268,268,16);
INSERT INTO "oneid_meta_log" VALUES(419,'113caf9a36e54f0a882346b4d226ad98','2019-12-27 11:02:13.147010','ucenter_reset_pwd','(13899990012) 修改用户((13899990012))密码',268,268,16);
INSERT INTO "oneid_meta_log" VALUES(420,'fcd67bd3d15c43b4bf2bb612ee87d77e','2019-12-27 11:02:13.157535','group_member','(13899990012)添加一批用户[(13899990012)]至组(外部联系人)',269,269,16);
INSERT INTO "oneid_meta_log" VALUES(421,'311ead35e1a142f594ebba8ce00eaaa0','2019-12-27 11:02:34.670565','ucenter_register','用户注册: (13899990013)',270,270,17);
INSERT INTO "oneid_meta_log" VALUES(422,'5cf1d34c20d14b96a886c50212cbdbab','2019-12-27 11:02:34.679513','ucenter_reset_pwd','(13899990013) 修改用户((13899990013))密码',270,270,17);
INSERT INTO "oneid_meta_log" VALUES(423,'25c65d15a2c248f091b746f686e3303d','2019-12-27 11:02:34.692948','group_member','(13899990013)添加一批用户[(13899990013)]至组(外部联系人)',271,271,17);
INSERT INTO "oneid_meta_log" VALUES(424,'64a89943ff2c469ebf7ea86899afb907','2019-12-27 11:02:53.245310','ucenter_register','用户注册: (13899990014)',272,272,18);
INSERT INTO "oneid_meta_log" VALUES(425,'b4d251f31c2d459d8304221e7a5de5f5','2019-12-27 11:02:53.254376','ucenter_reset_pwd','(13899990014) 修改用户((13899990014))密码',272,272,18);
INSERT INTO "oneid_meta_log" VALUES(426,'44031feeffcd46b4943fee7e4fa31fab','2019-12-27 11:02:53.265587','group_member','(13899990014)添加一批用户[(13899990014)]至组(外部联系人)',273,273,18);
INSERT INTO "oneid_meta_log" VALUES(427,'5b97ff26df6b4fe8a20cc766b2d4c0f6','2019-12-27 11:03:10.763114','ucenter_register','用户注册: (13899990015)',274,274,19);
INSERT INTO "oneid_meta_log" VALUES(428,'c6a1c37ec1ae49339bb1122b2a748ee1','2019-12-27 11:03:10.770513','ucenter_reset_pwd','(13899990015) 修改用户((13899990015))密码',274,274,19);
INSERT INTO "oneid_meta_log" VALUES(429,'0271a6e6ca1843fea9141a46ececa05b','2019-12-27 11:03:10.780950','group_member','(13899990015)添加一批用户[(13899990015)]至组(外部联系人)',275,275,19);
INSERT INTO "oneid_meta_log" VALUES(430,'3474c84aa7ba40c684ed308b6e926ceb','2019-12-27 11:03:32.572917','ucenter_register','用户注册: (13899990016)',276,276,20);
INSERT INTO "oneid_meta_log" VALUES(431,'879c541b6ac44644a49cfee4db37ebd0','2019-12-27 11:03:32.581083','ucenter_reset_pwd','(13899990016) 修改用户((13899990016))密码',276,276,20);
INSERT INTO "oneid_meta_log" VALUES(432,'538740a4a70c482eb687e6842f9fc8da','2019-12-27 11:03:32.591061','group_member','(13899990016)添加一批用户[(13899990016)]至组(外部联系人)',277,277,20);
INSERT INTO "oneid_meta_log" VALUES(433,'86ca17304e3a4fbba0d97f0909d5ff79','2019-12-27 11:03:48.720610','ucenter_register','用户注册: (13899990017)',278,278,21);
INSERT INTO "oneid_meta_log" VALUES(434,'2320f07176d84e7d8faebf34a713b61f','2019-12-27 11:03:48.728488','ucenter_reset_pwd','(13899990017) 修改用户((13899990017))密码',278,278,21);
INSERT INTO "oneid_meta_log" VALUES(435,'5ee6225edc15496ab5b6c378b220256e','2019-12-27 11:03:48.738418','group_member','(13899990017)添加一批用户[(13899990017)]至组(外部联系人)',279,279,21);
INSERT INTO "oneid_meta_log" VALUES(436,'e7ede587e3134f689c29f03fa39275d5','2019-12-27 11:04:07.078508','ucenter_register','用户注册: (13899990018)',280,280,22);
INSERT INTO "oneid_meta_log" VALUES(437,'6686962e3214450f82e9afa2eb85a755','2019-12-27 11:04:07.085879','ucenter_reset_pwd','(13899990018) 修改用户((13899990018))密码',280,280,22);
INSERT INTO "oneid_meta_log" VALUES(438,'b0eb68158e744bdea61f15ea54a52444','2019-12-27 11:04:07.096432','group_member','(13899990018)添加一批用户[(13899990018)]至组(外部联系人)',281,281,22);
INSERT INTO "oneid_meta_log" VALUES(439,'705e018d6a6640aa9d40b207df760544','2019-12-27 11:04:23.978439','ucenter_register','用户注册: (13899990019)',282,282,23);
INSERT INTO "oneid_meta_log" VALUES(440,'7ce082ed75fb4aeea67ce573f26c4692','2019-12-27 11:04:23.986019','ucenter_reset_pwd','(13899990019) 修改用户((13899990019))密码',282,282,23);
INSERT INTO "oneid_meta_log" VALUES(441,'55944c07274c4f69a459f2fff8d4d0de','2019-12-27 11:04:23.996152','group_member','(13899990019)添加一批用户[(13899990019)]至组(外部联系人)',283,283,23);
INSERT INTO "oneid_meta_log" VALUES(442,'2842eab4bfdb4a4081aaa06402883ea5','2019-12-27 11:04:39.837268','ucenter_register','用户注册: (13899990029)',284,284,24);
INSERT INTO "oneid_meta_log" VALUES(443,'bdb0bb0f86654d45b16fbf39ffcbe105','2019-12-27 11:04:39.844795','ucenter_reset_pwd','(13899990029) 修改用户((13899990029))密码',284,284,24);
INSERT INTO "oneid_meta_log" VALUES(444,'2abf51895cc243b996555ad5d470fc66','2019-12-27 11:04:39.855007','group_member','(13899990029)添加一批用户[(13899990029)]至组(外部联系人)',285,285,24);
INSERT INTO "oneid_meta_log" VALUES(445,'d9167d901cc447429b45a628bd4e3add','2019-12-27 11:04:56.480576','ucenter_register','用户注册: (13899990021)',286,286,25);
INSERT INTO "oneid_meta_log" VALUES(446,'661602c7d1a54ccb902d8188b22135a9','2019-12-27 11:04:56.487740','ucenter_reset_pwd','(13899990021) 修改用户((13899990021))密码',286,286,25);
INSERT INTO "oneid_meta_log" VALUES(447,'f63ee37a112b4f4c975fafecb134d4c4','2019-12-27 11:04:56.498751','group_member','(13899990021)添加一批用户[(13899990021)]至组(外部联系人)',287,287,25);
INSERT INTO "oneid_meta_log" VALUES(448,'fb081307a47e43eabddbeec1505cb979','2019-12-27 11:05:12.250738','ucenter_register','用户注册: (13899990022)',288,288,26);
INSERT INTO "oneid_meta_log" VALUES(449,'128e04ddf12d4d9bbf5fbee5edbfee31','2019-12-27 11:05:12.257969','ucenter_reset_pwd','(13899990022) 修改用户((13899990022))密码',288,288,26);
INSERT INTO "oneid_meta_log" VALUES(450,'7ff80612080a48a4850d4b21c4fda59c','2019-12-27 11:05:12.269086','group_member','(13899990022)添加一批用户[(13899990022)]至组(外部联系人)',289,289,26);
INSERT INTO "oneid_meta_log" VALUES(451,'599fba432cef41feb7909a68195e4b02','2019-12-27 11:05:31.447806','ucenter_register','用户注册: (13899990023)',290,290,27);
INSERT INTO "oneid_meta_log" VALUES(452,'087105b485e84d05918f5314a6680ec3','2019-12-27 11:05:31.456546','ucenter_reset_pwd','(13899990023) 修改用户((13899990023))密码',290,290,27);
INSERT INTO "oneid_meta_log" VALUES(453,'b3d3eef9c16748aaa983fcc3fbd00f51','2019-12-27 11:05:31.468375','group_member','(13899990023)添加一批用户[(13899990023)]至组(外部联系人)',291,291,27);
INSERT INTO "oneid_meta_log" VALUES(454,'1231546151534790ba5aedfb4b06e041','2019-12-27 11:05:47.541858','ucenter_register','用户注册: (13899990024)',292,292,28);
INSERT INTO "oneid_meta_log" VALUES(455,'9777b9a949534b8bab94edc90f75f65a','2019-12-27 11:05:47.553626','ucenter_reset_pwd','(13899990024) 修改用户((13899990024))密码',292,292,28);
INSERT INTO "oneid_meta_log" VALUES(456,'99ee75fdf2144880a40d661c6f89e13a','2019-12-27 11:05:47.570060','group_member','(13899990024)添加一批用户[(13899990024)]至组(外部联系人)',293,293,28);
INSERT INTO "oneid_meta_log" VALUES(457,'da57f7de077e41e79c15f5cb1e4e4546','2019-12-27 11:06:04.645154','ucenter_register','用户注册: (13899990025)',294,294,29);
INSERT INTO "oneid_meta_log" VALUES(458,'03d13c6e54ee489998db41013e641b57','2019-12-27 11:06:04.652458','ucenter_reset_pwd','(13899990025) 修改用户((13899990025))密码',294,294,29);
INSERT INTO "oneid_meta_log" VALUES(459,'7cf12effec1f4d71a5cdfe53bdcadf2e','2019-12-27 11:06:04.664879','group_member','(13899990025)添加一批用户[(13899990025)]至组(外部联系人)',295,295,29);
INSERT INTO "oneid_meta_log" VALUES(460,'188fda73512b424e90355ff21579b9e6','2019-12-27 11:06:23.619719','ucenter_register','用户注册: (13899990026)',296,296,30);
INSERT INTO "oneid_meta_log" VALUES(461,'0764eda79ba0425c889ce4086f140e38','2019-12-27 11:06:23.627168','ucenter_reset_pwd','(13899990026) 修改用户((13899990026))密码',296,296,30);
INSERT INTO "oneid_meta_log" VALUES(462,'823f9cf6017340f0a974e8561b1b3b26','2019-12-27 11:06:23.638529','group_member','(13899990026)添加一批用户[(13899990026)]至组(外部联系人)',297,297,30);
INSERT INTO "oneid_meta_log" VALUES(463,'e5874239cada438ab02750392d3ffdd2','2019-12-27 11:06:39.362162','ucenter_register','用户注册: (13899990027)',298,298,31);
INSERT INTO "oneid_meta_log" VALUES(464,'5124f6d1110040c5bb681ab8d4637131','2019-12-27 11:06:39.369384','ucenter_reset_pwd','(13899990027) 修改用户((13899990027))密码',298,298,31);
INSERT INTO "oneid_meta_log" VALUES(465,'99468665c2a645cc811477da5cbe1a02','2019-12-27 11:06:39.379600','group_member','(13899990027)添加一批用户[(13899990027)]至组(外部联系人)',299,299,31);
INSERT INTO "oneid_meta_log" VALUES(466,'7bce5de8cfd0440cbae805edeca2c1be','2019-12-27 11:06:56.369781','ucenter_register','用户注册: (13899990028)',300,300,32);
INSERT INTO "oneid_meta_log" VALUES(467,'35e3fc830b28447eab810efca94ca4b4','2019-12-27 11:06:56.377616','ucenter_reset_pwd','(13899990028) 修改用户((13899990028))密码',300,300,32);
INSERT INTO "oneid_meta_log" VALUES(468,'2364da35a2bd4cea93acbef62a7087f7','2019-12-27 11:06:56.387737','group_member','(13899990028)添加一批用户[(13899990028)]至组(外部联系人)',301,301,32);
INSERT INTO "oneid_meta_log" VALUES(469,'a83e1852eeab4f09a56b214811cbb948','2019-12-27 11:07:33.951442','ucenter_register','用户注册: (13899990030)',302,302,33);
INSERT INTO "oneid_meta_log" VALUES(470,'febf6d3f293f43dc86e12a8114b0289e','2019-12-27 11:07:33.959048','ucenter_reset_pwd','(13899990030) 修改用户((13899990030))密码',302,302,33);
INSERT INTO "oneid_meta_log" VALUES(471,'3e8955c1ca784c9dabe459ddd79da9f5','2019-12-27 11:07:33.969058','group_member','(13899990030)添加一批用户[(13899990030)]至组(外部联系人)',303,303,33);
INSERT INTO "oneid_meta_log" VALUES(472,'30d73a88c3b24a548138c03cbc0a74a4','2019-12-27 11:07:38.855192','ucenter_login','ADMIN(admin)登录',304,304,1);
INSERT INTO "oneid_meta_log" VALUES(473,'fcefe637d4ed4cc8a1242f69a6ee9f35','2019-12-27 11:08:00.132836','user_update','ADMIN(admin) 编辑用户(部门一一user(13899990006))信息',305,305,1);
INSERT INTO "oneid_meta_log" VALUES(474,'7e717000838b457d9756e85e83f09488','2019-12-27 11:08:00.188244','group_member','ADMIN(admin)添加用户(部门一一user(13899990006))至一批组()',306,306,1);
INSERT INTO "oneid_meta_log" VALUES(475,'d79baff9f4f74c2d81faf29ce7e39da0','2019-12-27 11:08:00.190323','group_member','ADMIN(admin)将用户(部门一一user(13899990006))从一批组[]删除',306,306,1);
INSERT INTO "oneid_meta_log" VALUES(476,'ed8c8dd6913b4082aa2ff19768ee4004','2019-12-27 11:08:00.197109','dept_member','ADMIN(admin)添加用户(f部门一一user(13899990006))至一批部门[]',307,307,1);
INSERT INTO "oneid_meta_log" VALUES(477,'b5c17ccd90fc40a88850d30928753cef','2019-12-27 11:08:00.199453','dept_member','ADMIN(admin)将用户(部门一一user(13899990006))从一批部门()删除',307,307,1);
INSERT INTO "oneid_meta_log" VALUES(478,'5dcb8d06706343ca8da8a69d9e4bdbaa','2019-12-27 11:08:07.406441','user_update','ADMIN(admin) 编辑用户(部门一二user(13899990007))信息',308,308,1);
INSERT INTO "oneid_meta_log" VALUES(479,'8578d2fda657435e9e8a46d27256363e','2019-12-27 11:08:07.458784','group_member','ADMIN(admin)添加用户(部门一二user(13899990007))至一批组()',309,309,1);
INSERT INTO "oneid_meta_log" VALUES(480,'5a9f5d72bbd14314a83317aa2b0c22a0','2019-12-27 11:08:07.461208','group_member','ADMIN(admin)将用户(部门一二user(13899990007))从一批组[]删除',309,309,1);
INSERT INTO "oneid_meta_log" VALUES(481,'93eb16ca51fd4e5ca18db3f39a5f7cdd','2019-12-27 11:08:07.467891','dept_member','ADMIN(admin)添加用户(f部门一二user(13899990007))至一批部门[]',310,310,1);
INSERT INTO "oneid_meta_log" VALUES(482,'474b40fefaa44647a10e8bf5155b118b','2019-12-27 11:08:07.469165','dept_member','ADMIN(admin)将用户(部门一二user(13899990007))从一批部门()删除',310,310,1);
INSERT INTO "oneid_meta_log" VALUES(483,'b1f265d6eafe4b5d875f1715c5b0c522','2019-12-27 11:08:13.610868','user_update','ADMIN(admin) 编辑用户(部门一三user(13899990008))信息',311,311,1);
INSERT INTO "oneid_meta_log" VALUES(484,'497be6f8a99847918cef02b1ecad6c50','2019-12-27 11:08:13.661377','group_member','ADMIN(admin)添加用户(部门一三user(13899990008))至一批组()',312,312,1);
INSERT INTO "oneid_meta_log" VALUES(485,'b573cb288f0e4f919e89e00afff3319e','2019-12-27 11:08:13.662962','group_member','ADMIN(admin)将用户(部门一三user(13899990008))从一批组[]删除',312,312,1);
INSERT INTO "oneid_meta_log" VALUES(486,'54258d9ca5be4b9ab1cf5483ab252d53','2019-12-27 11:08:13.670635','dept_member','ADMIN(admin)添加用户(f部门一三user(13899990008))至一批部门[]',313,313,1);
INSERT INTO "oneid_meta_log" VALUES(487,'b379ef6f2d4d481ba15ab29fa8e892da','2019-12-27 11:08:13.672657','dept_member','ADMIN(admin)将用户(部门一三user(13899990008))从一批部门()删除',313,313,1);
INSERT INTO "oneid_meta_log" VALUES(488,'483e4c1ac5044aa78b3c96b69fb21944','2019-12-27 11:08:20.311694','user_update','ADMIN(admin) 编辑用户(部门一四user(13899990009))信息',314,314,1);
INSERT INTO "oneid_meta_log" VALUES(489,'0698d3465cc9471ab3c7460ad8a517ee','2019-12-27 11:08:20.362169','group_member','ADMIN(admin)添加用户(部门一四user(13899990009))至一批组()',315,315,1);
INSERT INTO "oneid_meta_log" VALUES(490,'704d3f29b0914840a95435b20829e7fb','2019-12-27 11:08:20.363909','group_member','ADMIN(admin)将用户(部门一四user(13899990009))从一批组[]删除',315,315,1);
INSERT INTO "oneid_meta_log" VALUES(491,'dfccd47f147546fc9557837c48d6e247','2019-12-27 11:08:20.370734','dept_member','ADMIN(admin)添加用户(f部门一四user(13899990009))至一批部门[]',316,316,1);
INSERT INTO "oneid_meta_log" VALUES(492,'70a93b2c47854fb99f8b40305ed9e886','2019-12-27 11:08:20.373811','dept_member','ADMIN(admin)将用户(部门一四user(13899990009))从一批部门()删除',316,316,1);
INSERT INTO "oneid_meta_log" VALUES(493,'1acc176f4e154fe69d704759aad12e23','2019-12-27 11:08:28.617712','user_update','ADMIN(admin) 编辑用户(部门一五user(13899990010))信息',317,317,1);
INSERT INTO "oneid_meta_log" VALUES(494,'545b37007ae1491789ab80319be1e378','2019-12-27 11:08:28.661866','group_member','ADMIN(admin)添加用户(部门一五user(13899990010))至一批组()',318,318,1);
INSERT INTO "oneid_meta_log" VALUES(495,'acf0b13f96b94444b58b2d17ca089cce','2019-12-27 11:08:28.663277','group_member','ADMIN(admin)将用户(部门一五user(13899990010))从一批组[]删除',318,318,1);
INSERT INTO "oneid_meta_log" VALUES(496,'0402d6af560d40198cf3a30cc58509aa','2019-12-27 11:08:28.669778','dept_member','ADMIN(admin)添加用户(f部门一五user(13899990010))至一批部门[]',319,319,1);
INSERT INTO "oneid_meta_log" VALUES(497,'9bd018e6df9641fa8d267935fdb188a9','2019-12-27 11:08:28.671333','dept_member','ADMIN(admin)将用户(部门一五user(13899990010))从一批部门()删除',319,319,1);
INSERT INTO "oneid_meta_log" VALUES(498,'4d778e6be8d843958f06f7850786372f','2019-12-27 11:09:03.414169','user_update','ADMIN(admin) 编辑用户(部门二一user(13899990011))信息',320,320,1);
INSERT INTO "oneid_meta_log" VALUES(499,'82a3601d16bc4fbaaac6b47af3f57800','2019-12-27 11:09:03.459177','group_member','ADMIN(admin)添加用户(部门二一user(13899990011))至一批组()',321,321,1);
INSERT INTO "oneid_meta_log" VALUES(500,'aa4068d236584e85930b7aed36e3bb7b','2019-12-27 11:09:03.460606','group_member','ADMIN(admin)将用户(部门二一user(13899990011))从一批组[]删除',321,321,1);
INSERT INTO "oneid_meta_log" VALUES(501,'f5115e8054b14acb85e563cadba64261','2019-12-27 11:09:03.468504','dept_member','ADMIN(admin)添加用户(f部门二一user(13899990011))至一批部门[部门二（一）]',322,322,1);
INSERT INTO "oneid_meta_log" VALUES(502,'6bcf2e42bba94806a15f4d620556af85','2019-12-27 11:09:03.470519','dept_member','ADMIN(admin)将用户(部门二一user(13899990011))从一批部门()删除',322,322,1);
INSERT INTO "oneid_meta_log" VALUES(503,'9c343f406e904d74b40aec37c31aae47','2019-12-27 11:09:23.472301','user_update','ADMIN(admin) 编辑用户(部门二二user(13899990012))信息',323,323,1);
INSERT INTO "oneid_meta_log" VALUES(504,'e6eb718265644e60a0e14754dcf7c5d2','2019-12-27 11:09:23.515602','group_member','ADMIN(admin)添加用户(部门二二user(13899990012))至一批组()',324,324,1);
INSERT INTO "oneid_meta_log" VALUES(505,'6b9da7a5c1f244ccafa8c4b3000d995e','2019-12-27 11:09:23.517963','group_member','ADMIN(admin)将用户(部门二二user(13899990012))从一批组[]删除',324,324,1);
INSERT INTO "oneid_meta_log" VALUES(506,'bbfd0d1d0b6748a8b11f4c1059ed77a8','2019-12-27 11:09:23.526993','dept_member','ADMIN(admin)添加用户(f部门二二user(13899990012))至一批部门[部门二（二）]',325,325,1);
INSERT INTO "oneid_meta_log" VALUES(507,'8cd0809ec8c34fb3a585189baf08b13c','2019-12-27 11:09:23.530145','dept_member','ADMIN(admin)将用户(部门二二user(13899990012))从一批部门()删除',325,325,1);
INSERT INTO "oneid_meta_log" VALUES(508,'0c75b06b08034b33a368fef8399c1d13','2019-12-27 11:09:37.892239','user_update','ADMIN(admin) 编辑用户(部门二三user(13899990013))信息',326,326,1);
INSERT INTO "oneid_meta_log" VALUES(509,'ecef3caee5664b0abf6cc35e83a7be52','2019-12-27 11:09:37.936446','group_member','ADMIN(admin)添加用户(部门二三user(13899990013))至一批组()',327,327,1);
INSERT INTO "oneid_meta_log" VALUES(510,'3cab2f7ed370442d8b073a28a6f5e191','2019-12-27 11:09:37.938024','group_member','ADMIN(admin)将用户(部门二三user(13899990013))从一批组[]删除',327,327,1);
INSERT INTO "oneid_meta_log" VALUES(511,'2247e85fc3e042e0bd1d9e5d9f21a70e','2019-12-27 11:09:37.946341','dept_member','ADMIN(admin)添加用户(f部门二三user(13899990013))至一批部门[部门二（三）]',328,328,1);
INSERT INTO "oneid_meta_log" VALUES(512,'862f40198fcf4978bed9b2f3f3c7fe90','2019-12-27 11:09:37.949533','dept_member','ADMIN(admin)将用户(部门二三user(13899990013))从一批部门()删除',328,328,1);
INSERT INTO "oneid_meta_log" VALUES(513,'c04151ea25cd4b29bec2c2aa6a71309f','2019-12-27 11:09:51.754890','user_update','ADMIN(admin) 编辑用户(部门二四user(13899990014))信息',329,329,1);
INSERT INTO "oneid_meta_log" VALUES(514,'1e93bd50cb234862ac9978c1d2e19ac4','2019-12-27 11:09:51.799256','group_member','ADMIN(admin)添加用户(部门二四user(13899990014))至一批组()',330,330,1);
INSERT INTO "oneid_meta_log" VALUES(515,'5ea64be105914c7ebff8b8d825559a5f','2019-12-27 11:09:51.800711','group_member','ADMIN(admin)将用户(部门二四user(13899990014))从一批组[]删除',330,330,1);
INSERT INTO "oneid_meta_log" VALUES(516,'6785820a4f3947a8aefc0bdde09f35f9','2019-12-27 11:09:51.810077','dept_member','ADMIN(admin)添加用户(f部门二四user(13899990014))至一批部门[部门二（四）]',331,331,1);
INSERT INTO "oneid_meta_log" VALUES(517,'d24f8c025a4b40b99819b023c8177ba5','2019-12-27 11:09:51.812044','dept_member','ADMIN(admin)将用户(部门二四user(13899990014))从一批部门()删除',331,331,1);
INSERT INTO "oneid_meta_log" VALUES(518,'0b24051bcc3c46b59cc915c6fff7de56','2019-12-27 11:10:08.479462','user_update','ADMIN(admin) 编辑用户(部门二五user(13899990015))信息',332,332,1);
INSERT INTO "oneid_meta_log" VALUES(519,'aab166fea37e4be385e3f2ac107d44e4','2019-12-27 11:10:08.524008','group_member','ADMIN(admin)添加用户(部门二五user(13899990015))至一批组()',333,333,1);
INSERT INTO "oneid_meta_log" VALUES(520,'dd49722db9684a608d4a30886a2d1750','2019-12-27 11:10:08.525596','group_member','ADMIN(admin)将用户(部门二五user(13899990015))从一批组[]删除',333,333,1);
INSERT INTO "oneid_meta_log" VALUES(521,'79fe5393828b4f5aaaaadc1d67de9b14','2019-12-27 11:10:08.534075','dept_member','ADMIN(admin)添加用户(f部门二五user(13899990015))至一批部门[部门二（五）]',334,334,1);
INSERT INTO "oneid_meta_log" VALUES(522,'b317b02afec943b78d12043ca2bc9f53','2019-12-27 11:10:08.536629','dept_member','ADMIN(admin)将用户(部门二五user(13899990015))从一批部门()删除',334,334,1);
INSERT INTO "oneid_meta_log" VALUES(523,'ad834f0d644d45678eae882ac772ab86','2019-12-27 11:10:27.306014','user_update','ADMIN(admin) 编辑用户(部门三一user(13899990016))信息',335,335,1);
INSERT INTO "oneid_meta_log" VALUES(524,'24b32d52cafe4698a0cffe500fa2e034','2019-12-27 11:10:27.350247','group_member','ADMIN(admin)添加用户(部门三一user(13899990016))至一批组()',336,336,1);
INSERT INTO "oneid_meta_log" VALUES(525,'b9acf61a5c3c4b02a44ce35f30a2081c','2019-12-27 11:10:27.351709','group_member','ADMIN(admin)将用户(部门三一user(13899990016))从一批组[]删除',336,336,1);
INSERT INTO "oneid_meta_log" VALUES(526,'b5b370d6ce91457dbc0814bf049ce45c','2019-12-27 11:10:27.359236','dept_member','ADMIN(admin)添加用户(f部门三一user(13899990016))至一批部门[部门三（一）]',337,337,1);
INSERT INTO "oneid_meta_log" VALUES(527,'759a9e8a8b1c472fb02f87a5ea163ff5','2019-12-27 11:10:27.360552','dept_member','ADMIN(admin)将用户(部门三一user(13899990016))从一批部门()删除',337,337,1);
INSERT INTO "oneid_meta_log" VALUES(528,'59637ff44fa348d78bd885a3070cdbd1','2019-12-27 11:10:50.199561','dept_create','ADMIN(admin)创建部门(部门三（二）)',338,338,1);
INSERT INTO "oneid_meta_log" VALUES(529,'187f9e14b8204deb8a70c788c62a8e45','2019-12-27 11:10:50.206501','dept_move','ADMIN(admin)将新部门(部门三（二）)加入到部门(Dept: bumensan(部门三（组内成员及下属分组可见）))下',338,338,1);
INSERT INTO "oneid_meta_log" VALUES(530,'ccc7f3d3bc9f4c3a96d150aabb638091','2019-12-27 11:11:00.361101','dept_create','ADMIN(admin)创建部门(部门三（三）)',339,339,1);
INSERT INTO "oneid_meta_log" VALUES(531,'1eefd60e1f9a4f8ea5bb7217b2c0748f','2019-12-27 11:11:00.368795','dept_move','ADMIN(admin)将新部门(部门三（三）)加入到部门(Dept: bumensan(部门三（组内成员及下属分组可见）))下',339,339,1);
INSERT INTO "oneid_meta_log" VALUES(532,'3d409e3d24ca4ac5973f0ca80870220f','2019-12-27 11:11:09.477063','dept_create','ADMIN(admin)创建部门(部门三（四）)',340,340,1);
INSERT INTO "oneid_meta_log" VALUES(533,'84fad0e67e1d4060a3ef10d02164e235','2019-12-27 11:11:09.482588','dept_move','ADMIN(admin)将新部门(部门三（四）)加入到部门(Dept: bumensan(部门三（组内成员及下属分组可见）))下',340,340,1);
INSERT INTO "oneid_meta_log" VALUES(534,'06484b674a46404c9642ceab3a8948c7','2019-12-27 11:11:17.408706','dept_create','ADMIN(admin)创建部门(部门三（五）)',341,341,1);
INSERT INTO "oneid_meta_log" VALUES(535,'96925cb34ad74546a424982cdbcdb6eb','2019-12-27 11:11:17.413857','dept_move','ADMIN(admin)将新部门(部门三（五）)加入到部门(Dept: bumensan(部门三（组内成员及下属分组可见）))下',341,341,1);
INSERT INTO "oneid_meta_log" VALUES(536,'d00046f9164249d4b94e808fa75c12f5','2019-12-27 11:11:31.448025','dept_create','ADMIN(admin)创建部门(部门四（二）)',342,342,1);
INSERT INTO "oneid_meta_log" VALUES(537,'87a65ac5af524198affa8bb96e9628f9','2019-12-27 11:11:31.453504','dept_move','ADMIN(admin)将新部门(部门四（二）)加入到部门(Dept: bumensisuoyourenbukejian(部门四（所有人不可见）))下',342,342,1);
INSERT INTO "oneid_meta_log" VALUES(538,'9bf93edd1a384f439777634471f834ec','2019-12-27 11:11:41.033580','dept_create','ADMIN(admin)创建部门(部门四（三）)',343,343,1);
INSERT INTO "oneid_meta_log" VALUES(539,'16634aa49b634fcea53dc16597e710da','2019-12-27 11:11:41.039333','dept_move','ADMIN(admin)将新部门(部门四（三）)加入到部门(Dept: bumensisuoyourenbukejian(部门四（所有人不可见）))下',343,343,1);
INSERT INTO "oneid_meta_log" VALUES(540,'7b864d7ac6144f27bf41a3e16f6e3d46','2019-12-27 11:11:50.125376','dept_create','ADMIN(admin)创建部门(部门四（四）)',344,344,1);
INSERT INTO "oneid_meta_log" VALUES(541,'fba46aa3a5a241e196a7a97bbc488e4d','2019-12-27 11:11:50.130379','dept_move','ADMIN(admin)将新部门(部门四（四）)加入到部门(Dept: bumensisuoyourenbukejian(部门四（所有人不可见）))下',344,344,1);
INSERT INTO "oneid_meta_log" VALUES(542,'077ce5def60547e180d4d2ebb399409a','2019-12-27 11:11:58.593401','dept_create','ADMIN(admin)创建部门(部门四（五）)',345,345,1);
INSERT INTO "oneid_meta_log" VALUES(543,'f1ab9ef3ee81429493b4183c1913aba1','2019-12-27 11:11:58.599757','dept_move','ADMIN(admin)将新部门(部门四（五）)加入到部门(Dept: bumensisuoyourenbukejian(部门四（所有人不可见）))下',345,345,1);
INSERT INTO "oneid_meta_log" VALUES(544,'b094ab2d86ce47b4a1e6f7035ef5dceb','2019-12-27 11:12:11.297121','dept_create','ADMIN(admin)创建部门(部门五（二）)',346,346,1);
INSERT INTO "oneid_meta_log" VALUES(545,'29da4e9c0ce9489786811b30be708ea3','2019-12-27 11:12:11.302692','dept_move','ADMIN(admin)将新部门(部门五（二）)加入到部门(Dept: bumenwubufenrenkejian(部门五（部分人可见）))下',346,346,1);
INSERT INTO "oneid_meta_log" VALUES(546,'4df6ee6044874ac7ae4200f314f2874d','2019-12-27 11:12:20.419301','dept_create','ADMIN(admin)创建部门(部门五（三）)',347,347,1);
INSERT INTO "oneid_meta_log" VALUES(547,'d3060aadb01c4083b9d679d104f1a66c','2019-12-27 11:12:20.424915','dept_move','ADMIN(admin)将新部门(部门五（三）)加入到部门(Dept: bumenwubufenrenkejian(部门五（部分人可见）))下',347,347,1);
INSERT INTO "oneid_meta_log" VALUES(548,'a880275e79014ee7b63ccfc636aae7c8','2019-12-27 11:12:29.080612','dept_create','ADMIN(admin)创建部门(部门五（四）)',348,348,1);
INSERT INTO "oneid_meta_log" VALUES(549,'d949b4ff3bf947a7885b6b035c87045b','2019-12-27 11:12:29.087161','dept_move','ADMIN(admin)将新部门(部门五（四）)加入到部门(Dept: bumenwubufenrenkejian(部门五（部分人可见）))下',348,348,1);
INSERT INTO "oneid_meta_log" VALUES(550,'20372331b89e4fc5af8da0fad0650c5f','2019-12-27 11:12:37.078920','dept_create','ADMIN(admin)创建部门(部门五（五）)',349,349,1);
INSERT INTO "oneid_meta_log" VALUES(551,'22fe2684e1e64397becf1b3d01c71e68','2019-12-27 11:12:37.084667','dept_move','ADMIN(admin)将新部门(部门五（五）)加入到部门(Dept: bumenwubufenrenkejian(部门五（部分人可见）))下',349,349,1);
INSERT INTO "oneid_meta_log" VALUES(552,'48db27e42157484088f004eb4eb805c8','2019-12-27 11:14:52.887035','ucenter_register','用户注册: (13899990020)',350,350,34);
INSERT INTO "oneid_meta_log" VALUES(553,'21106351c3c943a882cf46d6e2392cfb','2019-12-27 11:14:52.895232','ucenter_reset_pwd','(13899990020) 修改用户((13899990020))密码',350,350,34);
INSERT INTO "oneid_meta_log" VALUES(554,'ee8aca9510c94e39b7731abc1fdfe98e','2019-12-27 11:14:52.906520','group_member','(13899990020)添加一批用户[(13899990020)]至组(外部联系人)',351,351,34);
INSERT INTO "oneid_meta_log" VALUES(555,'4ea46f15ee724c449ef8c744ac96fcbf','2019-12-27 11:17:13.617854','ucenter_login','ADMIN(admin)登录',352,352,1);
INSERT INTO "oneid_meta_log" VALUES(556,'c960778bfbb24090a95ce005c03426b2','2019-12-27 11:31:32.406266','user_update','ADMIN(admin) 编辑用户(部门三二user(13899990017))信息',353,353,1);
INSERT INTO "oneid_meta_log" VALUES(557,'c4b949943fe74a36803f047296de6249','2019-12-27 11:31:32.452406','group_member','ADMIN(admin)添加用户(部门三二user(13899990017))至一批组()',354,354,1);
INSERT INTO "oneid_meta_log" VALUES(558,'45716c0e648f44888e7832734e373623','2019-12-27 11:31:32.454404','group_member','ADMIN(admin)将用户(部门三二user(13899990017))从一批组[]删除',354,354,1);
INSERT INTO "oneid_meta_log" VALUES(559,'bea9862b43344ebbafb22f1b357646c8','2019-12-27 11:31:32.462231','dept_member','ADMIN(admin)添加用户(f部门三二user(13899990017))至一批部门[部门三（二）]',355,355,1);
INSERT INTO "oneid_meta_log" VALUES(560,'c97e8541ebaa46639fb18296581665c1','2019-12-27 11:31:32.465752','dept_member','ADMIN(admin)将用户(部门三二user(13899990017))从一批部门()删除',355,355,1);
INSERT INTO "oneid_meta_log" VALUES(561,'db1a804904904ad5b14e1abecfbdd0c0','2019-12-27 11:31:51.887389','user_update','ADMIN(admin) 编辑用户(部门三三user(13899990018))信息',356,356,1);
INSERT INTO "oneid_meta_log" VALUES(562,'d3992ef0efde4938b0864787e5257517','2019-12-27 11:31:51.931768','group_member','ADMIN(admin)添加用户(部门三三user(13899990018))至一批组()',357,357,1);
INSERT INTO "oneid_meta_log" VALUES(563,'70d00514d1534610a7db8d9497ca2174','2019-12-27 11:31:51.933229','group_member','ADMIN(admin)将用户(部门三三user(13899990018))从一批组[]删除',357,357,1);
INSERT INTO "oneid_meta_log" VALUES(564,'e8cefb12127b4a6d9d9d0b59040fddb3','2019-12-27 11:31:51.940985','dept_member','ADMIN(admin)添加用户(f部门三三user(13899990018))至一批部门[部门三（三）]',358,358,1);
INSERT INTO "oneid_meta_log" VALUES(565,'9b1f1c0d61d544a1b82767300e451da1','2019-12-27 11:31:51.942443','dept_member','ADMIN(admin)将用户(部门三三user(13899990018))从一批部门()删除',358,358,1);
INSERT INTO "oneid_meta_log" VALUES(566,'205494c8092c48a4934b530559b98947','2019-12-27 11:32:05.753504','user_update','ADMIN(admin) 编辑用户(部门三四user(13899990019))信息',359,359,1);
INSERT INTO "oneid_meta_log" VALUES(567,'6644cc075d3947d48bd0ec390aa2609e','2019-12-27 11:32:05.798669','group_member','ADMIN(admin)添加用户(部门三四user(13899990019))至一批组()',360,360,1);
INSERT INTO "oneid_meta_log" VALUES(568,'9e3a261f302549edb9e2e16706a67f3b','2019-12-27 11:32:05.800159','group_member','ADMIN(admin)将用户(部门三四user(13899990019))从一批组[]删除',360,360,1);
INSERT INTO "oneid_meta_log" VALUES(569,'c856ed210f8a47a18ce9a46803a55305','2019-12-27 11:32:05.808599','dept_member','ADMIN(admin)添加用户(f部门三四user(13899990019))至一批部门[部门三（四）]',361,361,1);
INSERT INTO "oneid_meta_log" VALUES(570,'1377558c61ce4d73ba1f8b101321339a','2019-12-27 11:32:05.810884','dept_member','ADMIN(admin)将用户(部门三四user(13899990019))从一批部门()删除',361,361,1);
INSERT INTO "oneid_meta_log" VALUES(571,'b39952f1dc0147369f46e12275509505','2019-12-27 11:32:25.849875','user_update','ADMIN(admin) 编辑用户(部门三五user(13899990020))信息',362,362,1);
INSERT INTO "oneid_meta_log" VALUES(572,'0888c3f0984f43e691a1160e689a9b19','2019-12-27 11:32:25.893727','group_member','ADMIN(admin)添加用户(部门三五user(13899990020))至一批组()',363,363,1);
INSERT INTO "oneid_meta_log" VALUES(573,'cadf1a20a3644d3ab3b60b364f5e92b7','2019-12-27 11:32:25.895232','group_member','ADMIN(admin)将用户(部门三五user(13899990020))从一批组[]删除',363,363,1);
INSERT INTO "oneid_meta_log" VALUES(574,'7eab2a2dd0624faaa5091af2ff492f14','2019-12-27 11:32:25.903063','dept_member','ADMIN(admin)添加用户(f部门三五user(13899990020))至一批部门[部门三（五）]',364,364,1);
INSERT INTO "oneid_meta_log" VALUES(575,'3aeb5b4711274db3a70fa0db5dbbc3d3','2019-12-27 11:32:25.905178','dept_member','ADMIN(admin)将用户(部门三五user(13899990020))从一批部门()删除',364,364,1);
INSERT INTO "oneid_meta_log" VALUES(576,'de54005699194b2e8686a4887a67256f','2019-12-27 11:32:45.124419','user_update','ADMIN(admin) 编辑用户(部门四一user(13899990021))信息',365,365,1);
INSERT INTO "oneid_meta_log" VALUES(577,'28155c0d5f754dc09abe3d36300e7462','2019-12-27 11:32:45.168805','group_member','ADMIN(admin)添加用户(部门四一user(13899990021))至一批组()',366,366,1);
INSERT INTO "oneid_meta_log" VALUES(578,'12e7c020a3a94245b7c271cba0f2585a','2019-12-27 11:32:45.170766','group_member','ADMIN(admin)将用户(部门四一user(13899990021))从一批组[]删除',366,366,1);
INSERT INTO "oneid_meta_log" VALUES(579,'bb90a24a25f84024b8748b38949e4300','2019-12-27 11:32:45.178892','dept_member','ADMIN(admin)添加用户(f部门四一user(13899990021))至一批部门[部门四（一）]',367,367,1);
INSERT INTO "oneid_meta_log" VALUES(580,'3e0c67cf87074fe4b5e35b70002ecc4f','2019-12-27 11:32:45.180676','dept_member','ADMIN(admin)将用户(部门四一user(13899990021))从一批部门()删除',367,367,1);
INSERT INTO "oneid_meta_log" VALUES(581,'445923c7c6ba4f998048c207eb7f3265','2019-12-27 11:32:58.850924','user_update','ADMIN(admin) 编辑用户(部门四二user(13899990022))信息',368,368,1);
INSERT INTO "oneid_meta_log" VALUES(582,'0c80354c22fe49a282a2eac026315b19','2019-12-27 11:32:58.896506','group_member','ADMIN(admin)添加用户(部门四二user(13899990022))至一批组()',369,369,1);
INSERT INTO "oneid_meta_log" VALUES(583,'ac9620ca9dd54cce9c5e6322cbff395f','2019-12-27 11:32:58.898000','group_member','ADMIN(admin)将用户(部门四二user(13899990022))从一批组[]删除',369,369,1);
INSERT INTO "oneid_meta_log" VALUES(584,'05a816709c1448f289fd305cfec74e57','2019-12-27 11:32:58.905811','dept_member','ADMIN(admin)添加用户(f部门四二user(13899990022))至一批部门[部门四（二）]',370,370,1);
INSERT INTO "oneid_meta_log" VALUES(585,'ff2ef6c1705d4c37b8fdebcc17cdeb8d','2019-12-27 11:32:58.907106','dept_member','ADMIN(admin)将用户(部门四二user(13899990022))从一批部门()删除',370,370,1);
INSERT INTO "oneid_meta_log" VALUES(586,'717b454262174316a2b75824b7661abe','2019-12-27 11:33:12.270744','user_update','ADMIN(admin) 编辑用户(部门四三user(13899990023))信息',371,371,1);
INSERT INTO "oneid_meta_log" VALUES(587,'ec280d9f859041dbbbd26ae54d82204e','2019-12-27 11:33:12.315561','group_member','ADMIN(admin)添加用户(部门四三user(13899990023))至一批组()',372,372,1);
INSERT INTO "oneid_meta_log" VALUES(588,'44f1cdea01764894a613418798b668a2','2019-12-27 11:33:12.319725','group_member','ADMIN(admin)将用户(部门四三user(13899990023))从一批组[]删除',372,372,1);
INSERT INTO "oneid_meta_log" VALUES(589,'c73e5c085c514d42affb43c4b0fd10ee','2019-12-27 11:33:12.328161','dept_member','ADMIN(admin)添加用户(f部门四三user(13899990023))至一批部门[部门四（三）]',373,373,1);
INSERT INTO "oneid_meta_log" VALUES(590,'1cf01d3c543d430e8af1f443a12a2d2d','2019-12-27 11:33:12.329490','dept_member','ADMIN(admin)将用户(部门四三user(13899990023))从一批部门()删除',373,373,1);
INSERT INTO "oneid_meta_log" VALUES(591,'fa624c449b1a4f34b7a2ab3398330a13','2019-12-27 11:33:25.033535','user_update','ADMIN(admin) 编辑用户(部门四四user(13899990024))信息',374,374,1);
INSERT INTO "oneid_meta_log" VALUES(592,'40dcc05ef35c4fd8a164e7e7ecb2adff','2019-12-27 11:33:25.088641','group_member','ADMIN(admin)添加用户(部门四四user(13899990024))至一批组()',375,375,1);
INSERT INTO "oneid_meta_log" VALUES(593,'5192c601dfc94565b4aea111e41caa9f','2019-12-27 11:33:25.090073','group_member','ADMIN(admin)将用户(部门四四user(13899990024))从一批组[]删除',375,375,1);
INSERT INTO "oneid_meta_log" VALUES(594,'636fa1d534d54f7aab5873945496db8c','2019-12-27 11:33:25.098628','dept_member','ADMIN(admin)添加用户(f部门四四user(13899990024))至一批部门[部门四（四）]',376,376,1);
INSERT INTO "oneid_meta_log" VALUES(595,'9e3aa3ca0b7b47368b27f33e4769530b','2019-12-27 11:33:25.101139','dept_member','ADMIN(admin)将用户(部门四四user(13899990024))从一批部门()删除',376,376,1);
INSERT INTO "oneid_meta_log" VALUES(596,'e5ae2e585ae448d18b2aead2389b91d7','2019-12-27 11:33:39.516326','user_update','ADMIN(admin) 编辑用户(部门四五user(13899990025))信息',377,377,1);
INSERT INTO "oneid_meta_log" VALUES(597,'f9a19059c61c4f99b85bd9c15f00f1b1','2019-12-27 11:33:39.559067','group_member','ADMIN(admin)添加用户(部门四五user(13899990025))至一批组()',378,378,1);
INSERT INTO "oneid_meta_log" VALUES(598,'47be1db88aad4506844cd5e909c49f73','2019-12-27 11:33:39.560929','group_member','ADMIN(admin)将用户(部门四五user(13899990025))从一批组[]删除',378,378,1);
INSERT INTO "oneid_meta_log" VALUES(599,'5236e5d2b60c4f86bfb7bfe8dbcbfc29','2019-12-27 11:33:39.568497','dept_member','ADMIN(admin)添加用户(f部门四五user(13899990025))至一批部门[部门四（五）]',379,379,1);
INSERT INTO "oneid_meta_log" VALUES(600,'4926fe3d83c546c5acdbd0377ad81b9c','2019-12-27 11:33:39.569918','dept_member','ADMIN(admin)将用户(部门四五user(13899990025))从一批部门()删除',379,379,1);
INSERT INTO "oneid_meta_log" VALUES(601,'e06b026e0b474bf5be69dd3d553620d2','2019-12-27 11:33:54.873122','user_update','ADMIN(admin) 编辑用户(部门五一user(13899990026))信息',380,380,1);
INSERT INTO "oneid_meta_log" VALUES(602,'47b03ef10dc945a4800fe6cb48799301','2019-12-27 11:33:54.918206','group_member','ADMIN(admin)添加用户(部门五一user(13899990026))至一批组()',381,381,1);
INSERT INTO "oneid_meta_log" VALUES(603,'928e1ac6425a48b8aa3217dad0a59b1e','2019-12-27 11:33:54.919863','group_member','ADMIN(admin)将用户(部门五一user(13899990026))从一批组[]删除',381,381,1);
INSERT INTO "oneid_meta_log" VALUES(604,'2f66b9e282e14deba3ef6b2ec31505af','2019-12-27 11:33:54.927610','dept_member','ADMIN(admin)添加用户(f部门五一user(13899990026))至一批部门[部门五（一）]',382,382,1);
INSERT INTO "oneid_meta_log" VALUES(605,'6df7a6dcc44b4e078504d79a51a8bccb','2019-12-27 11:33:54.929142','dept_member','ADMIN(admin)将用户(部门五一user(13899990026))从一批部门()删除',382,382,1);
INSERT INTO "oneid_meta_log" VALUES(606,'255f0582c66c4d629e7ee4dd4f73d463','2019-12-27 11:34:12.570652','user_update','ADMIN(admin) 编辑用户(部门五二user(13899990027))信息',383,383,1);
INSERT INTO "oneid_meta_log" VALUES(607,'d340ccd0aa20418cbb28f9408cdd8868','2019-12-27 11:34:12.615993','group_member','ADMIN(admin)添加用户(部门五二user(13899990027))至一批组()',384,384,1);
INSERT INTO "oneid_meta_log" VALUES(608,'6da50670058044b3afc150ad5ade6f23','2019-12-27 11:34:12.617408','group_member','ADMIN(admin)将用户(部门五二user(13899990027))从一批组[]删除',384,384,1);
INSERT INTO "oneid_meta_log" VALUES(609,'442af233ad894f15ac2d3efef44e85f4','2019-12-27 11:34:12.625058','dept_member','ADMIN(admin)添加用户(f部门五二user(13899990027))至一批部门[部门五（二）]',385,385,1);
INSERT INTO "oneid_meta_log" VALUES(610,'68f81336654a40679cc4daa733a5c99a','2019-12-27 11:34:12.626479','dept_member','ADMIN(admin)将用户(部门五二user(13899990027))从一批部门()删除',385,385,1);
INSERT INTO "oneid_meta_log" VALUES(611,'ba19f27ea8cd4678954847992d583427','2019-12-27 11:34:27.323429','user_update','ADMIN(admin) 编辑用户(部门五三user(13899990028))信息',386,386,1);
INSERT INTO "oneid_meta_log" VALUES(612,'138ef35fc36d42c19d5a113c270a0da8','2019-12-27 11:34:27.369250','group_member','ADMIN(admin)添加用户(部门五三user(13899990028))至一批组()',387,387,1);
INSERT INTO "oneid_meta_log" VALUES(613,'d1c9d13fccdd4cf89bf6567b06b968a3','2019-12-27 11:34:27.370762','group_member','ADMIN(admin)将用户(部门五三user(13899990028))从一批组[]删除',387,387,1);
INSERT INTO "oneid_meta_log" VALUES(614,'ea77bd0ea89749299c5a3be62b0de943','2019-12-27 11:34:27.379028','dept_member','ADMIN(admin)添加用户(f部门五三user(13899990028))至一批部门[部门五（三）]',388,388,1);
INSERT INTO "oneid_meta_log" VALUES(615,'3e880a4e613b453cb1b7c9af87a72762','2019-12-27 11:34:27.380767','dept_member','ADMIN(admin)将用户(部门五三user(13899990028))从一批部门()删除',388,388,1);
INSERT INTO "oneid_meta_log" VALUES(616,'02befb27e2c448a2b639afb08fe4fe1d','2019-12-27 11:34:45.296654','user_update','ADMIN(admin) 编辑用户(部门五四user(13899990029))信息',389,389,1);
INSERT INTO "oneid_meta_log" VALUES(617,'0b136b4af984448f801a366112377edb','2019-12-27 11:34:45.341948','group_member','ADMIN(admin)添加用户(部门五四user(13899990029))至一批组()',390,390,1);
INSERT INTO "oneid_meta_log" VALUES(618,'46fb6ac94b6848b0ab5789a20484646e','2019-12-27 11:34:45.343401','group_member','ADMIN(admin)将用户(部门五四user(13899990029))从一批组[]删除',390,390,1);
INSERT INTO "oneid_meta_log" VALUES(619,'dda6d757a3f0477fa82f289655995e96','2019-12-27 11:34:45.351268','dept_member','ADMIN(admin)添加用户(f部门五四user(13899990029))至一批部门[部门五（四）]',391,391,1);
INSERT INTO "oneid_meta_log" VALUES(620,'c80d60a637a940a4bb7dd32cbc64fdff','2019-12-27 11:34:45.354133','dept_member','ADMIN(admin)将用户(部门五四user(13899990029))从一批部门()删除',391,391,1);
INSERT INTO "oneid_meta_log" VALUES(621,'153ca68ad466456d9ec0076deb9ccc1e','2019-12-27 11:35:02.881579','user_update','ADMIN(admin) 编辑用户(部门五五user(13899990030))信息',392,392,1);
INSERT INTO "oneid_meta_log" VALUES(622,'be1b86f0a3994caa83955d93238b655f','2019-12-27 11:35:02.927025','group_member','ADMIN(admin)添加用户(部门五五user(13899990030))至一批组()',393,393,1);
INSERT INTO "oneid_meta_log" VALUES(623,'064ed5290f22413586632b5b0774a8c2','2019-12-27 11:35:02.928426','group_member','ADMIN(admin)将用户(部门五五user(13899990030))从一批组[]删除',393,393,1);
INSERT INTO "oneid_meta_log" VALUES(624,'2b172f4759b84904b0fa0f5f0eeadcef','2019-12-27 11:35:02.938158','dept_member','ADMIN(admin)添加用户(f部门五五user(13899990030))至一批部门[部门五（五）]',394,394,1);
INSERT INTO "oneid_meta_log" VALUES(625,'b4c7d491a8224fb8842de0b035db3596','2019-12-27 11:35:02.941032','dept_member','ADMIN(admin)将用户(部门五五user(13899990030))从一批部门()删除',394,394,1);
INSERT INTO "oneid_meta_log" VALUES(626,'cafe6d020ac7471b9826d6f132e674de','2020-02-25 03:25:58.817571','ucenter_login','部门四二user(13899990022)登录',395,395,26);
INSERT INTO "oneid_meta_log" VALUES(627,'3bad07d2f87742148f5bea3fae8df606','2020-02-25 08:31:38.579496','ucenter_login','ADMIN(admin)登录',396,396,1);
INSERT INTO "oneid_meta_log" VALUES(628,'dcc6cc350f39466494962bb0fcef8d39','2020-02-25 08:32:57.372630','ucenter_login','部门三admin(13899990003)登录',397,397,6);
INSERT INTO "oneid_meta_log" VALUES(629,'0028b140a72f47f2a48a9d699f68b489','2020-02-25 08:37:21.487661','ucenter_login','部门一一user(13899990006)登录',398,398,9);
INSERT INTO "oneid_meta_log" VALUES(630,'3765843d18a84ff4b75d738e18dc1979','2020-02-25 08:37:55.214990','ucenter_login','ADMIN(admin)登录',399,399,1);
INSERT INTO "oneid_meta_log" VALUES(631,'7a5843de0ad24c268ae64aa9ce6fd2f4','2020-02-25 08:39:49.012067','group_update','ADMIN(admin)编辑组(jhomcpvf)信息',400,400,1);
INSERT INTO "oneid_meta_log" VALUES(632,'452bc97824014ea39f94dbad5e3f70bf','2020-02-25 08:39:49.612067','group_member','ADMIN(admin)添加一批用户[]至组(jhomcpvf)',401,401,1);
INSERT INTO "oneid_meta_log" VALUES(633,'563ce51f4bbe403bbbd3c534a9a27973','2020-02-25 08:39:54.233263','group_member','ADMIN(admin)将一批用户[]从组(jhomcpvf)删除',401,401,1);
INSERT INTO "oneid_meta_log" VALUES(634,'35bf8cee06c84236ac28734b1b008f75','2020-02-25 08:39:54.366141','group_member','ADMIN(admin)调整一批用户[部门二admin(13899990002)]在组(jhomcpvf)中的顺序',401,401,1);
INSERT INTO "oneid_meta_log" VALUES(635,'8c14b26465054e28a98d5e383a1741e1','2020-02-25 08:40:03.120301','ucenter_login','部门二admin(13899990002)登录',402,402,5);
INSERT INTO "oneid_meta_log" VALUES(636,'c6d6c663b4264cc2a998232d251d2288','2020-02-25 08:44:35.139064','ucenter_login','部门一一user(13899990006)登录',403,403,9);
INSERT INTO "oneid_meta_log" VALUES(637,'2f3547263f414c63842e57b1f5371017','2020-02-25 08:46:09.683332','ucenter_login','ADMIN(admin)登录',404,404,1);
INSERT INTO "oneid_meta_log" VALUES(638,'e41edab0ec2f404baf228f98ec0fe6c0','2020-02-25 08:46:36.148805','ucenter_login','部门二admin(13899990002)登录',405,405,5);
INSERT INTO "oneid_meta_log" VALUES(639,'bf4468f3ba6645129583db9b04aebf90','2020-02-25 08:48:24.871404','ucenter_login','部门三admin(13899990003)登录',406,406,6);
INSERT INTO "oneid_meta_log" VALUES(640,'553a3c2417864351b7efbe81b7f0b90d','2020-02-25 08:50:11.991170','ucenter_login','部门四admin(13899990004)登录',407,407,7);
INSERT INTO "oneid_meta_log" VALUES(641,'a3ee05e655de4515a33548f7268df70f','2020-02-25 08:50:19.400147','ucenter_login','ADMIN(admin)登录',408,408,1);
INSERT INTO "oneid_meta_log" VALUES(642,'05245d9e0de3451792131d69efdc5fb7','2020-02-25 08:51:36.361566','group_create','ADMIN(admin)创建组(lbdbkhnb)',409,409,1);
INSERT INTO "oneid_meta_log" VALUES(643,'80decc4160804c5e9176b7300c31e655','2020-02-25 08:51:36.417253','group_move','ADMIN(admin)将新组(lbdbkhnb)加入到组(子管理员组)下',409,409,1);
INSERT INTO "oneid_meta_log" VALUES(644,'7ec258aafbdb48898820ac59f2828bc7','2020-02-25 08:51:37.457573','group_member','ADMIN(admin)添加一批用户[部门四admin(13899990004)]至组(lbdbkhnb)',410,410,1);
INSERT INTO "oneid_meta_log" VALUES(645,'d318a901c2bd4d03980e97945436fab0','2020-02-25 08:51:37.473793','group_member','ADMIN(admin)将一批用户[]从组(lbdbkhnb)删除',410,410,1);
INSERT INTO "oneid_meta_log" VALUES(646,'df7ab0cd050144898be74466e879755c','2020-02-25 08:51:37.603038','group_member','ADMIN(admin)调整一批用户[部门四admin(13899990004)]在组(lbdbkhnb)中的顺序',410,410,1);
INSERT INTO "oneid_meta_log" VALUES(647,'ba4a8eec006a4515bf88525550fbccef','2020-02-25 08:52:13.463982','group_create','ADMIN(admin)创建组(uqsbibkh)',411,411,1);
INSERT INTO "oneid_meta_log" VALUES(648,'f102ef27a6cd4ee098caaead13b9ca8e','2020-02-25 08:52:13.824238','group_move','ADMIN(admin)将新组(uqsbibkh)加入到组(子管理员组)下',411,411,1);
INSERT INTO "oneid_meta_log" VALUES(649,'f560cc3dac414e3ca02981ae43f3baac','2020-02-25 08:52:14.172202','group_member','ADMIN(admin)添加一批用户[部门四admin(13899990004)]至组(uqsbibkh)',412,412,1);
INSERT INTO "oneid_meta_log" VALUES(650,'a891befa087242b68758eb116a6ce380','2020-02-25 08:52:14.186330','group_member','ADMIN(admin)将一批用户[]从组(uqsbibkh)删除',412,412,1);
INSERT INTO "oneid_meta_log" VALUES(651,'411216881fa14ea7a74b5b5e874099c6','2020-02-25 08:52:14.219505','group_member','ADMIN(admin)调整一批用户[部门四admin(13899990004)]在组(uqsbibkh)中的顺序',412,412,1);
INSERT INTO "oneid_meta_log" VALUES(652,'e09138e645b04fa69e17e39689c04e86','2020-02-25 09:00:43.776859','ucenter_login','部门三admin(13899990003)登录',413,413,6);
INSERT INTO "oneid_meta_log" VALUES(653,'04ae3e1895a74d29a2ebd3868c0e8879','2020-02-25 09:11:59.334850','ucenter_login','部门四admin(13899990004)登录',414,414,7);
INSERT INTO "oneid_meta_log" VALUES(654,'f681f6bb3951406da5b9a840211f58c8','2020-02-25 09:13:08.132064','ucenter_login','ADMIN(admin)登录',415,415,1);
INSERT INTO "oneid_meta_log" VALUES(655,'b4f13af2cce84177a0314bf0cbde624e','2020-02-25 09:13:50.394492','group_update','ADMIN(admin)编辑组(lbdbkhnb)信息',416,416,1);
INSERT INTO "oneid_meta_log" VALUES(656,'fb166aefe4d74f16952db0e951910723','2020-02-25 09:13:50.557911','group_member','ADMIN(admin)添加一批用户[]至组(lbdbkhnb)',417,417,1);
INSERT INTO "oneid_meta_log" VALUES(657,'073532e70460403abd0eaed51f104dbf','2020-02-25 09:13:52.290270','group_member','ADMIN(admin)将一批用户[]从组(lbdbkhnb)删除',417,417,1);
INSERT INTO "oneid_meta_log" VALUES(658,'b2311ac3557c40d680324638433c235b','2020-02-25 09:13:52.407290','group_member','ADMIN(admin)调整一批用户[部门四admin(13899990004)]在组(lbdbkhnb)中的顺序',417,417,1);
INSERT INTO "oneid_meta_log" VALUES(659,'efb1e6e01d104bd3bf991335ee685ac7','2020-02-25 09:14:12.848237','group_update','ADMIN(admin)编辑组(uqsbibkh)信息',418,418,1);
INSERT INTO "oneid_meta_log" VALUES(660,'a15613dcb7ae473f9747b4321fbf36ef','2020-02-25 09:14:13.085992','group_member','ADMIN(admin)添加一批用户[]至组(uqsbibkh)',419,419,1);
INSERT INTO "oneid_meta_log" VALUES(661,'65fbc5cda2a04d7f96074f1e478c12f6','2020-02-25 09:14:13.310348','group_member','ADMIN(admin)将一批用户[]从组(uqsbibkh)删除',419,419,1);
INSERT INTO "oneid_meta_log" VALUES(662,'ff92ca59dc004d3b8f4d755d113c61e3','2020-02-25 09:14:13.491197','group_member','ADMIN(admin)调整一批用户[部门四admin(13899990004)]在组(uqsbibkh)中的顺序',419,419,1);
CREATE TABLE "oneid_meta_managergroup" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "group_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_group" ("id") DEFERRABLE INITIALLY DEFERRED, "nodes" text NOT NULL, "perms" text NOT NULL, "scope_subject" integer NOT NULL, "users" text NOT NULL, "apps" text NOT NULL);
INSERT INTO "oneid_meta_managergroup" VALUES(1,'fbe91a53d6e94659b5c9c17adf14c37b',0,1,'2020-02-25 09:14:13.832753','2019-11-16 10:07:27.468922',44,'["g_zidingyifenzuyi"]','[]',2,'["admin"]','[]');
INSERT INTO "oneid_meta_managergroup" VALUES(2,'ec81ee5e2dad4d19bc2b901ccc36b99c',0,1,'2020-02-25 09:14:13.884323','2019-11-16 10:07:38.640101',46,'["g_zidingyifenzuer"]','[]',2,'["admin"]','[]');
INSERT INTO "oneid_meta_managergroup" VALUES(3,'a2ab2c4f4df24ea9adc7f91dc3b9b23d',0,1,'2019-11-16 10:24:10.625812','2019-11-16 10:08:40.402328',43,'[]','[]',1,'[]','[]');
INSERT INTO "oneid_meta_managergroup" VALUES(4,'9c90e54f76eb4928a47d7e2983d83911',0,1,'2019-11-16 10:24:16.610300','2019-11-16 10:09:02.696244',45,'[]','[]',1,'[]','[]');
INSERT INTO "oneid_meta_managergroup" VALUES(5,'ad6d56c6cc884d3ab7be891e343cab66',0,1,'2020-02-25 09:14:13.922214','2019-11-16 10:11:16.125801',53,'[]','[]',2,'["admin"]','["yingyongyi"]');
INSERT INTO "oneid_meta_managergroup" VALUES(6,'10f93dc4a7b74676a63c3e9e5fa2c369',0,1,'2020-02-25 09:14:13.964228','2019-11-16 10:11:32.634467',54,'[]','[]',2,'["admin"]','["yingyonger"]');
INSERT INTO "oneid_meta_managergroup" VALUES(7,'b3b7ce5b139341a2bbd388051428dc90',0,1,'2020-02-25 09:14:14.007056','2019-11-16 10:11:37.994613',55,'[]','[]',2,'["admin"]','["yingyongsan"]');
INSERT INTO "oneid_meta_managergroup" VALUES(8,'a6fd64f6e11a4f49a753a559bc820c90',0,1,'2020-02-25 09:14:14.070401','2019-11-16 10:11:43.659885',56,'[]','[]',2,'["admin"]','["yingyongsi"]');
INSERT INTO "oneid_meta_managergroup" VALUES(9,'2e6b9276503c44ccab39777cd0aa9a81',0,1,'2020-02-25 09:14:14.134080','2019-11-16 10:11:51.624861',57,'[]','[]',2,'["admin"]','["yingyongwu"]');
INSERT INTO "oneid_meta_managergroup" VALUES(10,'595c8e4a6eb846ab863e1764b9085156',0,1,'2020-02-25 09:14:14.201375','2019-11-16 10:24:30.450016',59,'["g_laoshi"]','[]',2,'["admin"]','[]');
INSERT INTO "oneid_meta_managergroup" VALUES(11,'5cd8e65c198b435fa734e4b6d83a0a4c',0,1,'2020-02-25 09:14:14.240800','2019-11-16 10:36:53.313484',60,'[]','[]',2,'["admin"]','["yingyongliu"]');
INSERT INTO "oneid_meta_managergroup" VALUES(12,'db289e4420784471b13217a60420f685',0,1,'2020-02-25 09:14:14.284053','2019-11-16 10:36:59.326253',61,'[]','[]',2,'["admin"]','["yingyongqi"]');
INSERT INTO "oneid_meta_managergroup" VALUES(13,'84a7551385264de584dcea56a3e297ff',0,1,'2020-02-25 09:14:14.324491','2019-11-16 10:37:06.201717',62,'[]','[]',2,'["admin"]','["yingyongba"]');
INSERT INTO "oneid_meta_managergroup" VALUES(14,'67254ff6486e48ad9af5406e73330889',0,1,'2020-02-25 09:14:14.364830','2019-11-16 10:37:13.325896',63,'[]','[]',2,'["admin"]','["yingyongjiu"]');
INSERT INTO "oneid_meta_managergroup" VALUES(15,'81bb5511a82849e1ba6a1dd6ef5af5a8',0,1,'2020-02-25 09:14:14.404485','2019-11-16 10:37:18.756287',64,'[]','[]',2,'["admin"]','["yingyongshi"]');
INSERT INTO "oneid_meta_managergroup" VALUES(16,'62d5d5fb77ff43578dc7dee96b2c175c',0,1,'2020-02-25 09:14:14.460565','2019-12-27 04:08:31.945742',65,'[]','[]',1,'[]','["yingyonger"]');
INSERT INTO "oneid_meta_managergroup" VALUES(17,'f760ce31f6c04ae49ce011d0586ead1d',0,1,'2020-02-25 09:14:14.577285','2019-12-27 04:09:04.322801',66,'["d_bumenyi", "d_bumener"]','["system_account_sync", "system_app_create", "system_category_create", "system_config_write", "system_log_read", "system_user_create"]',2,'[]','["yingyongyi", "yingyonger", "yingyongsan", "yingyongsi", "yingyongwu", "yingyongliu", "yingyongqi", "yingyongba", "yingyongjiu", "yingyongshi"]');
INSERT INTO "oneid_meta_managergroup" VALUES(18,'260afa99c3f541afafbd0350cf14c440',0,1,'2020-02-25 09:14:14.628869','2019-12-27 04:14:28.921349',67,'["d_bumenyi", "g_juesesan"]','["system_account_sync", "system_app_create", "system_category_create"]',2,'["13899990002"]','["yingyongyi", "yingyonger", "yingyongsan", "yingyongsi", "yingyongwu"]');
INSERT INTO "oneid_meta_managergroup" VALUES(19,'3ee92b04e21e4e11aa45ba5479ae9029',0,1,'2020-02-25 09:14:14.668821','2019-12-27 04:15:03.246184',68,'["d_bumenyi"]','["system_config_write", "system_log_read", "system_user_create"]',2,'[]','["yingyongliu", "yingyongqi", "yingyongba", "yingyongjiu", "yingyongshi"]');
INSERT INTO "oneid_meta_managergroup" VALUES(20,'9b32757300924839becff564b6418ee4',0,1,'2020-02-25 09:14:14.710309','2020-02-25 08:51:34.670791',69,'["d_bumenyi"]','["system_account_sync", "system_app_create", "system_category_create", "system_config_write", "system_log_read", "system_user_create"]',2,'["13899990001", "13899990002"]','[]');
INSERT INTO "oneid_meta_managergroup" VALUES(21,'92659b35d6f140919ba6657621d854c6',0,1,'2020-02-25 09:14:14.749081','2020-02-25 08:52:11.937011',70,'["d_bumener"]','[]',2,'["13899990003", "13899990004"]','["yingyongyi", "yingyonger", "yingyongsan"]');
CREATE TABLE "oneid_meta_minioconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "end_point" varchar(225) NOT NULL, "access_key" varchar(225) NOT NULL, "secret_key" varchar(225) NOT NULL, "secure" bool NOT NULL, "location" varchar(225) NOT NULL, "bucket" varchar(225) NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_nativefield" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "name" varchar(128) NOT NULL, "key" varchar(256) NOT NULL, "schema" text NOT NULL, "is_visible" bool NOT NULL, "is_visible_editable" bool NOT NULL, "subject" varchar(128) NOT NULL);
INSERT INTO "oneid_meta_nativefield" VALUES(1,'c637bc6c0ebd43e3bb4c5d85c4ae984f',0,1,'2019-11-16 11:35:32.248129','2019-11-16 11:35:31.076656','姓名','name','{"type": "string"}',1,0,'user');
INSERT INTO "oneid_meta_nativefield" VALUES(2,'0e45c2f57fde4f3180ef735c0b5f012d',0,1,'2019-11-16 11:35:32.248727','2019-11-16 11:35:31.077110','邮箱','email','{"type": "string"}',1,0,'user');
INSERT INTO "oneid_meta_nativefield" VALUES(3,'58d2f7ab6c5a4c319cd3adc286b478c8',0,1,'2019-11-16 11:35:32.249231','2019-11-16 11:35:31.077481','部门','depts','{"type": "array", "items": {"type": "object", "properties": {"uid": {"type": "string"}, "name": {"type": "string"}}}}',1,0,'user');
INSERT INTO "oneid_meta_nativefield" VALUES(4,'49eb7731972a429cab17ba2f78542471',0,1,'2019-11-16 11:35:32.249730','2019-11-16 11:35:31.077898','手机','mobile','{"type": "string"}',1,1,'user');
INSERT INTO "oneid_meta_nativefield" VALUES(5,'95813ffcef294d858136f6ff85d964b5',0,1,'2019-11-16 11:35:32.250223','2019-11-16 11:35:31.078277','工号','employee_number','{"type": "string"}',1,1,'user');
INSERT INTO "oneid_meta_nativefield" VALUES(6,'e484fb80747240b4be1c68cccd8320c3',0,1,'2019-11-16 11:35:32.250718','2019-11-16 11:35:31.078640','性别','gender','{"type": "interger"}',1,1,'user');
INSERT INTO "oneid_meta_nativefield" VALUES(7,'6eb2e401ff454add8fd05c28d5371638',0,1,'2019-11-16 11:35:32.251213','2019-11-16 11:35:31.145528','职位','position','{"type": "string"}',1,1,'user');
INSERT INTO "oneid_meta_nativefield" VALUES(8,'29fbc82b55db4bf5bc3eaa5bacf86300',0,1,'2019-11-16 11:35:32.251706','2019-11-16 11:35:31.146050','私人邮箱','private_email','{"type": "string"}',1,1,'user');
INSERT INTO "oneid_meta_nativefield" VALUES(9,'788f43fd5bca4c64a4f68aa5b37cf961',0,1,'2019-11-16 11:35:32.252335','2019-11-16 11:35:32.252355','手机号','mobile','{"type": "string"}',1,0,'extern_user');
INSERT INTO "oneid_meta_nativefield" VALUES(10,'1636785ad05541d686302b758a000277',0,1,'2019-11-16 11:35:32.252726','2019-11-16 11:35:32.252745','邮箱','email','{"type": "string"}',1,0,'extern_user');
INSERT INTO "oneid_meta_nativefield" VALUES(11,'dc932916c0d24663bd17557a394bda94',0,1,'2019-11-16 11:35:32.253113','2019-11-16 11:35:32.253132','用户名','username','{"type": "string"}',1,0,'extern_user');
INSERT INTO "oneid_meta_nativefield" VALUES(12,'7a81f78e318f4763bd50529502253d28',0,1,'2019-11-16 11:35:32.253475','2019-11-16 11:35:32.253494','标签','nodes','{"type": "array", "items": {"type": "object", "properties": {"uid": {"type": "string"}, "name": {"type": "string"}}}}',1,0,'extern_user');
INSERT INTO "oneid_meta_nativefield" VALUES(13,'0c4cd5edd09f4e7f87f12279b9fb9af4',0,1,'2019-11-16 11:35:32.253862','2019-11-16 11:35:32.253881','姓名','name','{"type": "string"}',1,1,'extern_user');
INSERT INTO "oneid_meta_nativefield" VALUES(14,'9640b6ed30b24663abeb853c0225d92d',0,1,'2019-11-16 11:35:32.254239','2019-11-16 11:35:32.254258','备注','remark','{"type": "string"}',1,1,'extern_user');
CREATE TABLE "oneid_meta_perm" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "uid" varchar(255) NOT NULL UNIQUE, "name" varchar(255) NOT NULL, "remark" text NOT NULL, "scope" varchar(128) NOT NULL, "action" varchar(128) NOT NULL, "subject" varchar(255) NOT NULL, "default_value" bool NOT NULL, "editable" bool NOT NULL, "sub_account_id" integer NULL REFERENCES "oneid_meta_subaccount" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_perm" VALUES(1,'118fe2123b5146fdb954953298de2171',0,1,'2019-11-16 11:35:30.519255','2019-11-16 11:35:29.781342','system_oneid_all','OneID所有接口','','oneid','all','system',0,0,NULL);
INSERT INTO "oneid_meta_perm" VALUES(2,'02e28ac51619440696aa2118c4586ba4',0,1,'2019-11-16 11:35:30.520825','2019-11-16 11:35:29.854951','system_ark-meta-server_all','访问ark-meta-server所有接口','','ark-meta-server','all','system',0,0,NULL);
INSERT INTO "oneid_meta_perm" VALUES(3,'f3584ddffebf4b34b426d44d8793da07',0,1,'2019-11-16 11:35:30.750696','2019-11-16 11:35:30.750721','app_noah-admin_access','访问noah管理后台','','noah-admin','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(4,'60437ab0530540d9b553ea0e05ede2f3',0,1,'2019-11-16 11:35:30.867749','2019-11-16 11:35:30.867771','app_arker-editor_access','访问Arker编辑器','','arker-editor','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(5,'ec69116f1b63469da845408fadb50d4f',0,1,'2019-11-16 11:35:31.638457','2019-11-16 11:35:31.637797','system_user_create','创建用户','','user','create','system',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(6,'4f96c84d51b64c7ea7db0a3e6acd40ad',0,1,'2019-11-16 11:35:31.640543','2019-11-16 11:35:31.640142','system_category_create','创建大类','','category','create','system',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(7,'f2d3d93aad764ad68b68d0ce5f3595be',0,1,'2019-11-16 11:35:31.642810','2019-11-16 11:35:31.642452','system_app_create','创建应用','','app','create','system',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(8,'80f547b178fb4019b6cdae07644ca07f',0,1,'2019-11-16 11:35:32.015813','2019-11-16 11:35:32.015187','system_log_read','查看日志','','log','read','system',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(9,'0a11b21f5662401d912fc56f07d35a88',0,1,'2019-11-16 11:35:32.017830','2019-11-16 11:35:32.017487','system_config_write','公司配置、基础设施配置','','config','write','system',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(10,'804afe51214c47f99c3743d6023715de',0,1,'2019-11-16 11:35:32.019743','2019-11-16 11:35:32.019404','system_account_sync','账号同步','','account','sync','system',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(11,'319e020a489244199381907b72c6c16c',0,1,'2019-11-16 10:11:16.116889','2019-11-16 10:11:16.116922','app_yingyongyi_access','访问应用一','','yingyongyi','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(12,'6b0e5fc88b674ed9b03b281fa3a9434f',0,1,'2019-11-16 10:11:32.629697','2019-11-16 10:11:32.629718','app_yingyonger_access','访问应用二','','yingyonger','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(13,'114f758e08b94bd6b87b87fdb8b4bb55',0,1,'2019-11-16 10:11:37.903801','2019-11-16 10:11:37.903822','app_yingyongsan_access','访问应用三','','yingyongsan','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(14,'256bffb5087e4e5a9ba6f9902d35d262',0,1,'2019-11-16 10:11:43.655250','2019-11-16 10:11:43.655271','app_yingyongsi_access','访问应用四','','yingyongsi','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(15,'d6604e7d1806442c9d117c0fb4d526af',0,1,'2019-11-16 10:11:51.618534','2019-11-16 10:11:51.618574','app_yingyongwu_access','访问应用五','','yingyongwu','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(16,'5ab21e2b97b14a6286876db7e9bc8d01',0,1,'2019-11-16 10:36:53.307860','2019-11-16 10:36:53.307886','app_yingyongliu_access','访问应用六','','yingyongliu','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(17,'3f9b7687502049d2b8d1e5ea1c389597',0,1,'2019-11-16 10:36:59.321464','2019-11-16 10:36:59.321484','app_yingyongqi_access','访问应用七','','yingyongqi','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(18,'87e4a1c8f61c4a209f3a86293871e197',0,1,'2019-11-16 10:37:06.195872','2019-11-16 10:37:06.195893','app_yingyongba_access','访问应用八','','yingyongba','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(19,'46e4f6fad25a4751bffd367c5022b65c',0,1,'2019-11-16 10:37:13.318175','2019-11-16 10:37:13.318196','app_yingyongjiu_access','访问应用九','','yingyongjiu','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(20,'d911bf9ad69f41f99d7a420d6ad1a986',0,1,'2019-11-16 10:37:18.751513','2019-11-16 10:37:18.751534','app_yingyongshi_access','访问应用十','','yingyongshi','access','app',0,1,NULL);
INSERT INTO "oneid_meta_perm" VALUES(21,'032202a21a68435d977c7a0c57cb3c31',0,1,'2019-12-27 04:08:15.706562','2019-12-27 04:08:15.706592','app_oneid_access','','','oneid','access','app',0,1,NULL);
CREATE TABLE "oneid_meta_posixuser" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "uid" integer NOT NULL, "gid" integer NOT NULL, "home" varchar(255) NOT NULL, "pub_key" varchar(255) NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_qqconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "app_id" varchar(255) NOT NULL, "app_key" varchar(255) NOT NULL, "qr_app_valid" bool NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_qquser" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "open_id" text NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_requestaccesslog" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "ip" varchar(64) NULL, "agent" varchar(512) NULL, "url" text NULL, "method" varchar(16) NULL);
INSERT INTO "oneid_meta_requestaccesslog" VALUES(1,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(2,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(3,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(4,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/config/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(5,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/config/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(6,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(7,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/config/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(8,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(9,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(10,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(11,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(12,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(13,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(14,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(15,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(16,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(17,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(18,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(19,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(20,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(21,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(22,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(23,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(24,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(25,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(26,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(27,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(28,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(29,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(30,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(31,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(32,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(33,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumener/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(34,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(35,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(36,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumenyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(37,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(38,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumener/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(39,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(40,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumenyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(41,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(42,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumenyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(43,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(44,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumener/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(45,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(46,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumensan/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(47,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(48,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(49,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_root/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(50,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumenyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(51,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumenyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(52,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumenyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(53,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumenyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(54,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumenyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(55,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumener/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(56,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumener/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(57,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumener/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(58,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumener/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(59,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumener/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(60,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_role/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(61,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(62,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(63,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(64,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(65,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(66,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_role/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(67,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_role/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(68,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_role/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(69,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_role/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(70,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15','/siteapi/oneid/ucenter/profile/invited/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(71,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15','/siteapi/oneid/ucenter/profile/invited/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(72,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15','/siteapi/oneid/ucenter/profile/invited/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(73,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15','/siteapi/oneid/ucenter/profile/invited/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(74,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15','/siteapi/oneid/ucenter/profile/invited/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(75,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15','/siteapi/oneid/ucenter/profile/invited/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(76,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(77,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(78,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(79,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(80,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(81,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(82,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(83,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(84,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(85,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(86,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(87,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(88,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(89,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(90,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(91,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(92,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_jueseer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(93,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_label/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(94,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_label/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(95,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_label/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(96,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_label/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(97,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_label/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(98,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumensan/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(99,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumensisuoyourenbukejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(100,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/d_bumenwubufenrenkejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(101,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_juesesan/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(102,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_juesesi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(103,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_juesewu/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(104,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(105,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(106,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(107,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(108,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(109,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(110,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(111,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(112,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(113,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(114,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqiansan/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(115,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqiansi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(116,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_biaoqianwu/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(117,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_intra/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(118,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_intra/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(119,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_intra/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(120,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_intra/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(121,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(122,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(123,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuer/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(124,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(125,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(126,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(127,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_tianxieyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(128,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(129,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_tianxieer/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(130,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(131,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_tianxiesan/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(132,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(133,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(134,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(135,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuer/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(136,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(137,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(138,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(139,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(140,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(141,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(142,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(143,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(144,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(145,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(146,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990001/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(147,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990001/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(148,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990001/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(149,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990002/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(150,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990002/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(151,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990002/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(152,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990003/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(153,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990003/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(154,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990003/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(155,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990004/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(156,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990004/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(157,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990004/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(158,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990005/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(159,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990005/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(160,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990005/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(161,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(162,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(163,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(164,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuer/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(165,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_intra/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(166,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_intra/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(167,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_tianxieyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(168,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(169,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_tianxieer/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(170,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(171,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_tianxiesan/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(172,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuyi/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(173,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_hudieyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(174,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuer/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(175,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_hudieer/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(176,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuer/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(177,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_hudieer/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(178,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuer/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(179,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_hudiewu/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(180,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/node/g_zidingyifenzuer/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(181,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990006/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(182,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990006/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(183,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990006/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(184,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990001/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(185,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990001/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(186,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990001/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(187,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990002/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(188,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990002/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(189,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990002/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(190,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990003/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(191,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990003/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(192,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990003/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(193,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990004/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(194,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990004/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(195,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990004/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(196,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990005/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(197,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990005/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(198,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990005/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(199,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990006/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(200,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990006/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(201,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990006/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(202,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990006/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(203,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990006/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(204,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990006/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(205,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990007/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(206,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990007/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(207,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990007/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(208,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990008/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(209,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990008/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(210,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990008/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(211,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990009/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(212,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990009/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(213,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990009/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(214,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(215,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(216,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990010/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(217,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990010/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(218,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/user/13899990010/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(219,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(220,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(221,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(222,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(223,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(224,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(225,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(226,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(227,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(228,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(229,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/app/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(230,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(231,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(232,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(233,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(234,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(235,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(236,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(237,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/group/manager/group/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(238,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/g_wdexnpal/user/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(239,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/group/manager/group/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(240,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/g_jhomcpvf/user/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(241,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/group/manager/group/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(242,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/g_skbykchp/user/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(243,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/group/manager/group/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(244,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/g_zwmjfxzq/user/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(245,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(246,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumenyi/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(247,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/perm/app_yingyongshi_access/owner/?owner_subject=app&value=true','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(248,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(249,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/perm/app_yingyongshi_access/owner/?owner_subject=undefined&value=true','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(250,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/perm/app_yingyongshi_access/owner/?owner_subject=app&value=true','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(251,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(252,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(253,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(254,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(255,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(256,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(257,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(258,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(259,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(260,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(261,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/1234/','DELETE');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(262,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(263,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/config/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(264,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(265,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/config/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(266,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(267,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(268,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(269,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(270,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(271,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(272,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(273,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(274,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(275,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(276,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(277,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(278,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(279,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(280,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(281,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(282,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(283,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(284,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(285,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(286,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(287,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(288,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(289,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(290,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(291,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(292,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(293,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(294,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(295,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(296,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(297,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(298,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(299,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(300,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(301,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(302,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(303,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(304,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(305,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990006/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(306,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990006/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(307,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990006/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(308,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990007/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(309,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990007/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(310,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990007/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(311,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990008/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(312,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990008/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(313,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990008/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(314,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990009/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(315,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990009/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(316,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990009/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(317,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990010/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(318,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990010/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(319,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990010/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(320,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990011/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(321,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990011/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(322,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990011/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(323,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990012/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(324,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990012/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(325,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990012/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(326,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990013/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(327,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990013/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(328,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990013/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(329,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990014/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(330,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990014/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(331,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990014/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(332,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990015/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(333,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990015/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(334,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990015/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(335,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990016/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(336,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990016/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(337,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990016/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(338,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumensan/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(339,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumensan/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(340,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumensan/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(341,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumensan/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(342,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumensisuoyourenbukejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(343,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumensisuoyourenbukejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(344,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumensisuoyourenbukejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(345,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumensisuoyourenbukejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(346,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumenwubufenrenkejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(347,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumenwubufenrenkejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(348,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumenwubufenrenkejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(349,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/node/d_bumenwubufenrenkejian/node/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(350,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(351,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/register/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(352,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(353,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990017/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(354,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990017/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(355,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990017/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(356,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990018/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(357,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990018/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(358,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990018/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(359,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990019/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(360,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990019/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(361,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990019/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(362,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990020/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(363,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990020/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(364,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990020/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(365,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990021/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(366,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990021/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(367,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990021/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(368,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990022/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(369,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990022/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(370,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990022/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(371,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990023/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(372,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990023/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(373,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990023/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(374,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990024/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(375,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990024/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(376,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990024/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(377,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990025/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(378,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990025/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(379,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990025/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(380,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990026/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(381,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990026/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(382,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990026/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(383,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990027/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(384,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990027/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(385,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990027/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(386,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990028/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(387,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990028/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(388,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990028/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(389,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990029/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(390,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990029/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(391,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990029/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(392,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990030/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(393,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990030/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(394,'36.110.106.42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36','/siteapi/oneid/user/13899990030/node/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(395,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(396,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(397,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(398,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(399,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(400,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/node/g_jhomcpvf/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(401,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/node/g_jhomcpvf/user/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(402,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(403,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(404,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(405,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(406,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(407,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(408,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(409,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/group/manager/group/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(410,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/node/g_lbdbkhnb/user/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(411,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/group/manager/group/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(412,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/node/g_uqsbibkh/user/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(413,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(414,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(415,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/ucenter/login/','POST');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(416,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/node/g_lbdbkhnb/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(417,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/node/g_lbdbkhnb/user/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(418,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/node/g_uqsbibkh/','PATCH');
INSERT INTO "oneid_meta_requestaccesslog" VALUES(419,'36.110.106.42','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.87 Safari/537.36','/siteapi/oneid/node/g_uqsbibkh/user/','PATCH');
CREATE TABLE "oneid_meta_requestdataclientlog" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "content" text NULL, "content_type" text NULL);
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(1,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(2,'{"username":"admin","password":"******"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(3,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(4,'{"sms_config":{"vendor":"aliyun","access_key":"LTAIOWvU6MD0np72","access_secret":"******","template_code":"SMS_158010015","signature":"龙归科技"}}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(5,'{"account_config":{"allow_register":true,"allow_mobile":true,"allow_email":false,"allow_ding_qr":false,"allow_alipay_qr":false,"allow_work_wechat_qr":false,"allow_wechat_qr":false,"allow_qq_qr":false}}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(6,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(7,'{"account_config":{"allow_register":true,"allow_mobile":true,"allow_email":false,"allow_ding_qr":false,"allow_alipay_qr":false,"allow_work_wechat_qr":false,"allow_wechat_qr":false,"allow_qq_qr":false}}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(8,'{"sms_token":"******","password":"******","username":"dept1"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(9,'{"sms_token":"******","password":"******","username":"dept1"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(10,'{"sms_token":"******","password":"******","username":"dept2"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(11,'{"sms_token":"******","password":"******","username":"dept2"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(12,'{"sms_token":"******","password":"******","username":"13899990001"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(13,'{"sms_token":"******","password":"******","username":"13899990001"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(14,'{"sms_token":"******","password":"******","username":"13899990002"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(15,'{"sms_token":"******","password":"******","username":"13899990002"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(16,'{"sms_token":"******","password":"******","username":"13899990003"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(17,'{"sms_token":"******","password":"******","username":"13899990003"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(18,'{"sms_token":"******","password":"******","username":"13899990004"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(19,'{"sms_token":"******","password":"******","username":"13899990004"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(20,'{"sms_token":"******","password":"******","username":"13899990005"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(21,'{"sms_token":"******","password":"******","username":"13899990005"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(22,'{"sms_token":"******","password":"******","username":"13899990006"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(23,'{"sms_token":"******","password":"******","username":"13899990006"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(24,'{"sms_token":"******","password":"******","username":"13899990007"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(25,'{"sms_token":"******","password":"******","username":"13899990007"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(26,'{"sms_token":"******","password":"******","username":"13899990008"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(27,'{"sms_token":"******","password":"******","username":"13899990008"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(28,'{"sms_token":"******","password":"******","username":"13899990009"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(29,'{"sms_token":"******","password":"******","username":"13899990009"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(30,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(31,'{"node_uid":"","name":"部门一","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(32,'{"node_uid":"","name":"部门二","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(33,'{"node_uid":"d_bumener","name":"部门二","visibility":2,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(34,'{"node_uids":["d_bumener"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(35,'{"node_uid":"","name":"部门三","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(36,'{"node_uid":"d_bumenyi","name":"所有可见部门","visibility":1,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(37,'{"node_uids":["d_bumenyi"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(38,'{"node_uid":"d_bumener","name":"部门（组内可见下属不可见）","visibility":2,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(39,'{"node_uids":["d_bumener"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(40,'{"node_uid":"d_bumenyi","name":"部门（所有可见）","visibility":1,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(41,'{"node_uids":["d_bumenyi"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(42,'{"node_uid":"d_bumenyi","name":"部门一（所有可见）","visibility":1,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(43,'{"node_uids":["d_bumenyi"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(44,'{"node_uid":"d_bumener","name":"部门二（组内可见下属不可见）","visibility":2,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(45,'{"node_uids":["d_bumener"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(46,'{"node_uid":"d_bumensan","name":"部门三（组内成员及下属分组可见）","visibility":3,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(47,'{"node_uids":["d_bumensan"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(48,'{"node_uid":"","name":"部门四（所有人不可见）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(49,'{"node_uid":"","name":"部门五（部分人可见）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(50,'{"node_uid":"","name":"部门一（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(51,'{"node_uid":"","name":"部门一（二）","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(52,'{"node_uid":"","name":"部门一（三）","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(53,'{"node_uid":"","name":"部门一（四）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(54,'{"node_uid":"","name":"部门一（五）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(55,'{"node_uid":"","name":"部门二（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(56,'{"node_uid":"","name":"部门二（二）","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(57,'{"node_uid":"","name":"部门二（三）","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(58,'{"node_uid":"","name":"部门二（四）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(59,'{"node_uid":"","name":"部门二（五）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(60,'{"node_uid":"","name":"角色一","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(61,'{"node_uid":"","name":"角色一（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(62,'{"node_uid":"","name":"角色一（二）","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(63,'{"node_uid":"","name":"角色一（三）","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(64,'{"node_uid":"","name":"角色一（四）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(65,'{"node_uid":"","name":"角色一（五）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(66,'{"node_uid":"","name":"角色二","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(67,'{"node_uid":"","name":"角色三","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(68,'{"node_uid":"","name":"角色四","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(69,'{"node_uid":"","name":"角色五","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(70,'{"username":"13899990001","password":"******","sms_token":"******","key":"gAAAAABdz8dsyvAFRUmsHUlb078g4Fi-20B6GyND6HzbbRDbd8iSEVqEKiaHcRy3eDBUneB9D8flI3tzpLZQ_zY_lmi3uCsz1GbrCHYO7ICN60lbBEtBuBVwxJz3P8z0GGmVAWvk4P9J7DeCnc4tGxge34Wt2iqaB8dYL1LKn6ocj9tF3V87eXFtcaUIQb47p4Me_lLuE43NMGVrrN3H3E3kTeYWS_6ioTxJ9mIpXGo1M2B8ZCG5u1lbW_WE620o1UvytdAAav85"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(71,'{"username":"13899990001","password":"******","sms_token":"******","key":"gAAAAABdz8dsyvAFRUmsHUlb078g4Fi-20B6GyND6HzbbRDbd8iSEVqEKiaHcRy3eDBUneB9D8flI3tzpLZQ_zY_lmi3uCsz1GbrCHYO7ICN60lbBEtBuBVwxJz3P8z0GGmVAWvk4P9J7DeCnc4tGxge34Wt2iqaB8dYL1LKn6ocj9tF3V87eXFtcaUIQb47p4Me_lLuE43NMGVrrN3H3E3kTeYWS_6ioTxJ9mIpXGo1M2B8ZCG5u1lbW_WE620o1UvytdAAav85"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(72,'{"username":"13899990002","password":"******","sms_token":"******","key":"gAAAAABdz8eQi0G217kP6NFwgT5WVNZ_ILJMrj8h9AIreveUYT6sxyemU4LzLbZO6ZUDK_lLbH9S6MlkAzYjrXUel3wUcyz8LYFbG6r3BCuLG8JGSy-sghdjaJHlRStvAg8AEHhDiL_uYO8XHuIkYmzPvMcB6aThQcezRGhFytKk8BzVJBXfn-uqIdFBXOuFvfQ7yqISk5W0Qo22UO4felkfwBNJ1PmwmRrjQeTXGFAnz_8ST-UcTPQYsqUHnWVO9bzWZIUW4_zA"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(73,'{"username":"13899990002","password":"******","sms_token":"******","key":"gAAAAABdz8eQi0G217kP6NFwgT5WVNZ_ILJMrj8h9AIreveUYT6sxyemU4LzLbZO6ZUDK_lLbH9S6MlkAzYjrXUel3wUcyz8LYFbG6r3BCuLG8JGSy-sghdjaJHlRStvAg8AEHhDiL_uYO8XHuIkYmzPvMcB6aThQcezRGhFytKk8BzVJBXfn-uqIdFBXOuFvfQ7yqISk5W0Qo22UO4felkfwBNJ1PmwmRrjQeTXGFAnz_8ST-UcTPQYsqUHnWVO9bzWZIUW4_zA"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(74,'{"username":"13899990003","password":"******","sms_token":"******","key":"gAAAAABdz8eq4mj9zsgSgyJ0Y54wDYDhID755CELDMX9CExiW1bOxLtRLmW4eZY6VKnkV4B50ZI08eEuIIrw7MqN4v0vIbhMx9bCnGWShwNNRCCIGkHWBqWzd6OLe0BUndLSkdhqmMUES4GjLEwkdEodHuOmE7TaygHmY5GVO-SfSbOylwMxBqfw6f9wcvITjRHBCLwEBYIgIrKCjlnWdY0TSi_30D74Nwy8oy6MQUaFoZnklTUXn1hog3xsDmGNZcLLrYBtcMQ0"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(75,'{"username":"13899990003","password":"******","sms_token":"******","key":"gAAAAABdz8eq4mj9zsgSgyJ0Y54wDYDhID755CELDMX9CExiW1bOxLtRLmW4eZY6VKnkV4B50ZI08eEuIIrw7MqN4v0vIbhMx9bCnGWShwNNRCCIGkHWBqWzd6OLe0BUndLSkdhqmMUES4GjLEwkdEodHuOmE7TaygHmY5GVO-SfSbOylwMxBqfw6f9wcvITjRHBCLwEBYIgIrKCjlnWdY0TSi_30D74Nwy8oy6MQUaFoZnklTUXn1hog3xsDmGNZcLLrYBtcMQ0"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(76,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(77,'{"password":"******","username":"13899990001"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(78,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(79,'{"password":"******","username":"13899990002"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(80,'{"password":"******","username":"13899990003"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(81,'{"password":"******","username":"13899990004"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(82,'{"password":"******","username":"13899990005"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(83,'{"password":"******","username":"13899990006"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(84,'{"password":"******","username":"13899990007"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(85,'{"password":"******","username":"13899990008"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(86,'{"password":"******","username":"13899990009"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(87,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(88,'{"node_uid":"","name":"角色二（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(89,'{"node_uid":"","name":"角色二（二）","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(90,'{"node_uid":"","name":"角色二（三）","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(91,'{"node_uid":"","name":"角色二（四）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(92,'{"node_uid":"","name":"角色二（五）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(93,'{"node_uid":"","name":"标签一","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(94,'{"node_uid":"","name":"标签二","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(95,'{"node_uid":"","name":"标签三","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(96,'{"node_uid":"","name":"标签四","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(97,'{"node_uid":"","name":"标签五","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(98,'{"node_uid":"","name":"部门三（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(99,'{"node_uid":"","name":"部门四（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(100,'{"node_uid":"","name":"部门五（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(101,'{"node_uid":"","name":"角色三（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(102,'{"node_uid":"","name":"角色四（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(103,'{"node_uid":"","name":"角色五（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(104,'{"node_uid":"","name":"标签一（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(105,'{"node_uid":"","name":"标签一（二）","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(106,'{"node_uid":"","name":"标签一（三）","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(107,'{"node_uid":"","name":"标签一（四）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(108,'{"node_uid":"","name":"标签一（五）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(109,'{"node_uid":"","name":"标签二（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(110,'{"node_uid":"","name":"标签二（二）","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(111,'{"node_uid":"","name":"标签二（三）","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(112,'{"node_uid":"","name":"标签二（四）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(113,'{"node_uid":"","name":"标签二（五）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(114,'{"node_uid":"","name":"标签三（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(115,'{"node_uid":"","name":"标签四（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(116,'{"node_uid":"","name":"标签五（一）","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(117,'{"node_uid":"","name":"自定义分组一","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(118,'{"node_uid":"","name":"自定义分组一","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(119,'{"node_uid":"","name":"自定义分组二","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(120,'{"node_uid":"","name":"自定义分组二","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(121,'{"node_uid":"g_zidingyifenzuyi","name":"自定","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(122,'{"node_uid":"g_zidingyifenzuyi","name":"天蝎","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(123,'{"node_uid":"g_zidingyifenzuer","name":"蝴蝶","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(124,'{"node_uid":"","name":"天蝎一","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(125,'{"node_uid":"","name":"天蝎二","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(126,'{"node_uid":"","name":"天蝎三","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(127,'{"node_uid":"g_tianxieyi","name":"天蝎一","visibility":1,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(128,'{"node_uids":["g_tianxieyi"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(129,'{"node_uid":"g_tianxieer","name":"天蝎二","visibility":2,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(130,'{"node_uids":["g_tianxieer"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(131,'{"node_uid":"g_tianxiesan","name":"天蝎三","visibility":3,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(132,'{"node_uids":["g_tianxiesan"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(133,'{"node_uid":"","name":"蝴蝶一","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(134,'{"node_uid":"","name":"蝴蝶二","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(135,'{"node_uid":"","name":"蝴蝶五","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(136,'{"name":"应用一","remark":"","logo":"","auth_protocols":["OAuth 2.0"],"index":"","oauth_app":{"redirect_uris":"adad","client_type":"confidential","authorization_grant_type":"authorization-code"},"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(137,'{"name":"应用一","remark":"","logo":"","auth_protocols":["OAuth 2.0"],"index":"","oauth_app":{"redirect_uris":"adad","client_type":"confidential","authorization_grant_type":"authorization-code"},"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(138,'{"name":"应用二","remark":"","logo":"","auth_protocols":["LDAP"],"index":"","oauth_app":null,"ldap_app":{},"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(139,'{"name":"应用二","remark":"","logo":"","auth_protocols":["LDAP"],"index":"","oauth_app":null,"ldap_app":{},"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(140,'{"name":"应用三","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(141,'{"name":"应用三","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(142,'{"name":"应用四","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(143,'{"name":"应用四","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(144,'{"name":"应用五","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(145,'{"name":"应用五","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(146,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990001","name":"一号","position":"","private_email":"","username":"13899990001","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyi","name":"部门一（所有可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(147,'{"node_uids":["d_bumenyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(148,'{"node_uids":["d_bumenyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(149,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990002","name":"二号","position":"","private_email":"","username":"13899990002","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumener","name":"部门二（组内可见下属不可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(150,'{"node_uids":["d_bumener"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(151,'{"node_uids":["d_bumener"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(152,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990003","name":"三号","position":"","private_email":"","username":"13899990003","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensan","name":"部门三（组内成员及下属分组可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(153,'{"node_uids":["d_bumensan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(154,'{"node_uids":["d_bumensan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(155,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990004","name":"四号","position":"","private_email":"","username":"13899990004","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensisuoyourenbukejian","name":"部门四（所有人不可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(156,'{"node_uids":["d_bumensisuoyourenbukejian"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(157,'{"node_uids":["d_bumensisuoyourenbukejian"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(158,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990005","name":"五号","position":"","private_email":"","username":"13899990005","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenwubufenrenkejian","name":"部门五（部分人可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(159,'{"node_uids":["d_bumenwubufenrenkejian"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(160,'{"node_uids":["d_bumenwubufenrenkejian"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(161,'{"node_uid":"g_zidingyifenzuyi","name":"性别","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(162,'{"node_uid":"g_zidingyifenzuyi","name":"自定义分组一","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(163,'{"node_uid":"g_zidingyifenzuyi","name":"亲戚","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(164,'{"node_uid":"g_zidingyifenzuer","name":"校友","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(165,'{"node_uid":"","name":"老师","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(166,'{"node_uid":"","name":"老师","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(167,'{"node_uid":"g_tianxieyi","name":"亲戚一","visibility":1,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(168,'{"node_uids":["g_tianxieyi"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(169,'{"node_uid":"g_tianxieer","name":"亲戚二","visibility":2,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(170,'{"node_uids":["g_tianxieer"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(171,'{"node_uid":"g_tianxiesan","name":"亲戚三","visibility":3,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(172,'{"node_uids":["g_tianxiesan"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(173,'{"node_uid":"g_hudieyi","name":"校友一","visibility":1,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(174,'{"node_uids":["g_hudieyi"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(175,'{"node_uid":"g_hudieer","name":"校友二","visibility":2,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(176,'{"node_uids":["g_hudieer"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(177,'{"node_uid":"g_hudieer","name":"校友二","visibility":2,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(178,'{"node_uids":["g_hudieer"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(179,'{"node_uid":"g_hudiewu","name":"校友五","visibility":4,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(180,'{"node_uids":["g_hudiewu"],"subject":"add"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(181,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990006","name":"六号","position":"","private_email":"","username":"13899990006","depts":null,"roles":null,"nodes":[],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(182,'{"node_uids":[],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(183,'{"node_uids":[],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(184,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990001","name":"部门一admin","position":"","private_email":"","username":"13899990001","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyi","name":"部门一（所有可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(185,'{"node_uids":["d_bumenyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(186,'{"node_uids":["d_bumenyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(187,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990002","name":"部门二admin","position":"","private_email":"","username":"13899990002","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumener","name":"部门二（组内可见下属不可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(188,'{"node_uids":["d_bumener"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(189,'{"node_uids":["d_bumener"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(190,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990003","name":"部门三admin","position":"","private_email":"","username":"13899990003","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensan","name":"部门三（组内成员及下属分组可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(191,'{"node_uids":["d_bumensan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(192,'{"node_uids":["d_bumensan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(193,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990004","name":"部门四admin","position":"","private_email":"","username":"13899990004","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensisuoyourenbukejian","name":"部门四（所有人不可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(194,'{"node_uids":["d_bumensisuoyourenbukejian"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(195,'{"node_uids":["d_bumensisuoyourenbukejian"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(196,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990005","name":"部门五admin","position":"","private_email":"","username":"13899990005","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenwubufenrenkejian","name":"部门五（部分人可见）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(197,'{"node_uids":["d_bumenwubufenrenkejian"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(198,'{"node_uids":["d_bumenwubufenrenkejian"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(199,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990006","name":"六号","position":"","private_email":"","username":"13899990006","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyiyi","name":"部门一（一）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(200,'{"node_uids":["d_bumenyiyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(201,'{"node_uids":["d_bumenyiyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(202,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990006","name":"部门一一admin","position":"","private_email":"","username":"13899990006","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyiyi","name":"部门一（一）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(203,'{"node_uids":["d_bumenyiyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(204,'{"node_uids":["d_bumenyiyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(205,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990007","name":"部门一二adm","position":"","private_email":"","username":"13899990007","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyier","name":"部门一（二）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(206,'{"node_uids":["d_bumenyier"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(207,'{"node_uids":["d_bumenyier"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(208,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990008","name":"部门一三adm","position":"","private_email":"","username":"13899990008","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyisan","name":"部门一（三）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(209,'{"node_uids":["d_bumenyisan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(210,'{"node_uids":["d_bumenyisan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(211,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990009","name":"部门一四admin","position":"","private_email":"","username":"13899990009","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyisi","name":"部门一（四）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(212,'{"node_uids":["d_bumenyisi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(213,'{"node_uids":["d_bumenyisi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(214,'{"user":{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"","name":"部门一五adm","position":"","private_email":"","username":"13899990010","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyiwu","name":"部门一（五）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"password":"******","require_reset_password":false,"has_password":true},"node_uids":["d_bumenyiwu"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(215,'{"user":{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"","name":"部门一五adm","position":"","private_email":"","username":"13899990010","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyiwu","name":"部门一（五）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"password":"******","require_reset_password":false,"has_password":true},"node_uids":["d_bumenyiwu"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(216,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990010","name":"部门一五adm","position":"","private_email":"","username":"13899990010","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyiwu","name":"部门一（五）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(217,'{"node_uids":["d_bumenyiwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(218,'{"node_uids":["d_bumenyiwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(219,'{"password":"******","username":"13899990010"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(220,'{"name":"应用六","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(221,'{"name":"应用六","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(222,'{"name":"应用七","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(223,'{"name":"应用七","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(224,'{"name":"应用八","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(225,'{"name":"应用八","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(226,'{"name":"应用九","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(227,'{"name":"应用九","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(228,'{"name":"应用十","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(229,'{"name":"应用十","remark":"","logo":"","auth_protocols":[],"index":"","oauth_app":null,"ldap_app":null,"http_app":null}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(230,'{"password":"******","username":"13899990001"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(231,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(232,'{"password":"******","username":"13899990002"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(233,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(234,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(235,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(236,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(237,'{"node_uid":"","name":"","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":["yingyonger"],"scope_subject":1},"users":["13899990001"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(238,'{"user_uids":["13899990001"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(239,'{"node_uid":"","name":"","node_scope":[],"user_scope":[],"manager_group":{"nodes":["d_bumenyi","d_bumener"],"users":[],"perms":["system_user_create","system_category_create","system_app_create","system_log_read","system_config_write","system_account_sync"],"apps":["yingyongshi","yingyongjiu","yingyongba","yingyongqi","yingyongliu","yingyongwu","yingyongsi","yingyongsan","yingyonger","yingyongyi"],"scope_subject":2},"users":["13899990002"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(240,'{"user_uids":["13899990002"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(241,'{"node_uid":"","name":"","node_scope":[],"user_scope":[],"manager_group":{"nodes":["d_bumenyi","g_juesesan"],"users":["13899990002"],"perms":["system_category_create","system_app_create","system_account_sync"],"apps":["yingyongwu","yingyongsi","yingyongsan","yingyonger","yingyongyi"],"scope_subject":2},"users":["13899990003"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(242,'{"user_uids":["13899990003"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(243,'{"node_uid":"","name":"","node_scope":[],"user_scope":[],"manager_group":{"nodes":["d_bumenyi"],"users":[],"perms":["system_user_create","system_log_read","system_config_write"],"apps":["yingyongshi","yingyongjiu","yingyongba","yingyongqi","yingyongliu"],"scope_subject":2},"users":["13899990003"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(244,'{"user_uids":["13899990003"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(245,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(246,'{"node_uid":"d_bumenyi","name":"部门一（所有人可见）","visibility":1,"node_scope":[],"user_scope":[],"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(247,'{"user_perm_status":[{"uid":"13899990001","status":1}]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(248,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(249,'{"node_perm_status":[{"uid":"d_bumenyi","status":1}]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(250,'{"user_perm_status":[{"uid":"13899990006","status":-1}]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(251,'{"password":"******","username":"13899990006"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(252,'{"password":"******","username":"13899990007"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(253,'{"password":"******","username":"13899990006"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(254,'{"password":"******","username":"13899990007"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(255,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(256,'{"password":"******","username":"13899990003"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(257,'{"user":{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"12341234123","name":"1234","position":"","private_email":"","username":"1234","depts":null,"roles":null,"nodes":[{"node_uid":"g_juesesanyi","name":"角色三（一）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"password":"******"require_reset_password":false,"has_password":false},"node_uids":["g_juesesanyi"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(258,'{"user":{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"12341234123","name":"1234","position":"","private_email":"","username":"1234","depts":null,"roles":null,"nodes":[{"node_uid":"g_juesesanyi","name":"角色三（一）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"password":"******"require_reset_password":false,"has_password":false},"node_uids":["g_juesesanyi"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(259,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(260,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(261,'','text/plain');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(262,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(263,'{"account_config":{"allow_register":false,"allow_mobile":true,"allow_email":false,"allow_ding_qr":false,"allow_alipay_qr":false,"allow_work_wechat_qr":false,"allow_wechat_qr":false,"allow_qq_qr":false}}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(264,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(265,'{"account_config":{"allow_register":true,"allow_mobile":true,"allow_email":false,"allow_ding_qr":false,"allow_alipay_qr":false,"allow_work_wechat_qr":false,"allow_wechat_qr":false,"allow_qq_qr":false}}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(266,'{"sms_token":"******","password":"******","username":"13899990011"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(267,'{"sms_token":"******","password":"******","username":"13899990011"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(268,'{"sms_token":"******","password":"******","username":"13899990012"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(269,'{"sms_token":"******","password":"******","username":"13899990012"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(270,'{"sms_token":"******","password":"******","username":"13899990013"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(271,'{"sms_token":"******","password":"******","username":"13899990013"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(272,'{"sms_token":"******","password":"******","username":"13899990014"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(273,'{"sms_token":"******","password":"******","username":"13899990014"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(274,'{"sms_token":"******","password":"******","username":"13899990015"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(275,'{"sms_token":"******","password":"******","username":"13899990015"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(276,'{"sms_token":"******","password":"******","username":"13899990016"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(277,'{"sms_token":"******","password":"******","username":"13899990016"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(278,'{"sms_token":"******","password":"******","username":"13899990017"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(279,'{"sms_token":"******","password":"******","username":"13899990017"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(280,'{"sms_token":"******","password":"******","username":"13899990018"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(281,'{"sms_token":"******","password":"******","username":"13899990018"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(282,'{"sms_token":"******","password":"******","username":"13899990019"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(283,'{"sms_token":"******","password":"******","username":"13899990019"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(284,'{"sms_token":"******","password":"******","username":"13899990029"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(285,'{"sms_token":"******","password":"******","username":"13899990029"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(286,'{"sms_token":"******","password":"******","username":"13899990021"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(287,'{"sms_token":"******","password":"******","username":"13899990021"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(288,'{"sms_token":"******","password":"******","username":"13899990022"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(289,'{"sms_token":"******","password":"******","username":"13899990022"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(290,'{"sms_token":"******","password":"******","username":"13899990023"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(291,'{"sms_token":"******","password":"******","username":"13899990023"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(292,'{"sms_token":"******","password":"******","username":"13899990024"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(293,'{"sms_token":"******","password":"******","username":"13899990024"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(294,'{"sms_token":"******","password":"******","username":"13899990025"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(295,'{"sms_token":"******","password":"******","username":"13899990025"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(296,'{"sms_token":"******","password":"******","username":"13899990026"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(297,'{"sms_token":"******","password":"******","username":"13899990026"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(298,'{"sms_token":"******","password":"******","username":"13899990027"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(299,'{"sms_token":"******","password":"******","username":"13899990027"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(300,'{"sms_token":"******","password":"******","username":"13899990028"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(301,'{"sms_token":"******","password":"******","username":"13899990028"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(302,'{"sms_token":"******","password":"******","username":"13899990030"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(303,'{"sms_token":"******","password":"******","username":"13899990030"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(304,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(305,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990006","name":"部门一一user","position":"","private_email":"","username":"13899990006","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyiyi","name":"部门一（一）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(306,'{"node_uids":["d_bumenyiyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(307,'{"node_uids":["d_bumenyiyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(308,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990007","name":"部门一二user","position":"","private_email":"","username":"13899990007","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyier","name":"部门一（二）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(309,'{"node_uids":["d_bumenyier"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(310,'{"node_uids":["d_bumenyier"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(311,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990008","name":"部门一三user","position":"","private_email":"","username":"13899990008","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyisan","name":"部门一（三）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(312,'{"node_uids":["d_bumenyisan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(313,'{"node_uids":["d_bumenyisan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(314,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990009","name":"部门一四user","position":"","private_email":"","username":"13899990009","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyisi","name":"部门一（四）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(315,'{"node_uids":["d_bumenyisi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(316,'{"node_uids":["d_bumenyisi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(317,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990010","name":"部门一五user","position":"","private_email":"","username":"13899990010","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenyiwu","name":"部门一（五）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":true,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(318,'{"node_uids":["d_bumenyiwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(319,'{"node_uids":["d_bumenyiwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(320,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990011","name":"部门二一user","position":"","private_email":"","username":"13899990011","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumeneryi","name":"部门二（一）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(321,'{"node_uids":["d_bumeneryi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(322,'{"node_uids":["d_bumeneryi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(323,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990012","name":"部门二二user","position":"","private_email":"","username":"13899990012","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenerer","name":"部门二（二）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(324,'{"node_uids":["d_bumenerer"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(325,'{"node_uids":["d_bumenerer"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(326,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990013","name":"部门二三user","position":"","private_email":"","username":"13899990013","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenersan","name":"部门二（三）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(327,'{"node_uids":["d_bumenersan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(328,'{"node_uids":["d_bumenersan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(329,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990014","name":"部门二四user","position":"","private_email":"","username":"13899990014","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenersi","name":"部门二（四）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(330,'{"node_uids":["d_bumenersi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(331,'{"node_uids":["d_bumenersi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(332,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990015","name":"部门二五user","position":"","private_email":"","username":"13899990015","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenerwu","name":"部门二（五）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(333,'{"node_uids":["d_bumenerwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(334,'{"node_uids":["d_bumenerwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(335,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990016","name":"部门三一user","position":"","private_email":"","username":"13899990016","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensanyi","name":"部门三（一）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(336,'{"node_uids":["d_bumensanyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(337,'{"node_uids":["d_bumensanyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(338,'{"node_uid":"","name":"部门三（二）","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(339,'{"node_uid":"","name":"部门三（三）","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(340,'{"node_uid":"","name":"部门三（四）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(341,'{"node_uid":"","name":"部门三（五）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(342,'{"node_uid":"","name":"部门四（二）","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(343,'{"node_uid":"","name":"部门四（三）","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(344,'{"node_uid":"","name":"部门四（四）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(345,'{"node_uid":"","name":"部门四（五）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(346,'{"node_uid":"","name":"部门五（二）","visibility":2,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(347,'{"node_uid":"","name":"部门五（三）","visibility":3,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(348,'{"node_uid":"","name":"部门五（四）","visibility":5,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(349,'{"node_uid":"","name":"部门五（五）","visibility":4,"node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":[],"perms":[],"apps":[],"scope_subject":1},"users":[]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(350,'{"sms_token":"******","password":"******","username":"13899990020"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(351,'{"sms_token":"******","password":"******","username":"13899990020"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(352,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(353,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990017","name":"部门三二user","position":"","private_email":"","username":"13899990017","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensaner","name":"部门三（二）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(354,'{"node_uids":["d_bumensaner"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(355,'{"node_uids":["d_bumensaner"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(356,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990018","name":"部门三三user","position":"","private_email":"","username":"13899990018","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensansan","name":"部门三（三）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(357,'{"node_uids":["d_bumensansan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(358,'{"node_uids":["d_bumensansan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(359,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990019","name":"部门三四user","position":"","private_email":"","username":"13899990019","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensansi","name":"部门三（四）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(360,'{"node_uids":["d_bumensansi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(361,'{"node_uids":["d_bumensansi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(362,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990020","name":"部门三五user","position":"","private_email":"","username":"13899990020","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensanwu","name":"部门三（五）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(363,'{"node_uids":["d_bumensanwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(364,'{"node_uids":["d_bumensanwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(365,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990021","name":"部门四一user","position":"","private_email":"","username":"13899990021","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensiyi","name":"部门四（一）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(366,'{"node_uids":["d_bumensiyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(367,'{"node_uids":["d_bumensiyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(368,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990022","name":"部门四二user","position":"","private_email":"","username":"13899990022","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensier","name":"部门四（二）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(369,'{"node_uids":["d_bumensier"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(370,'{"node_uids":["d_bumensier"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(371,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990023","name":"部门四三user","position":"","private_email":"","username":"13899990023","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensisan","name":"部门四（三）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(372,'{"node_uids":["d_bumensisan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(373,'{"node_uids":["d_bumensisan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(374,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990024","name":"部门四四user","position":"","private_email":"","username":"13899990024","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensisi","name":"部门四（四）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(375,'{"node_uids":["d_bumensisi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(376,'{"node_uids":["d_bumensisi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(377,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990025","name":"部门四五user","position":"","private_email":"","username":"13899990025","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumensiwu","name":"部门四（五）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(378,'{"node_uids":["d_bumensiwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(379,'{"node_uids":["d_bumensiwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(380,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990026","name":"部门五一user","position":"","private_email":"","username":"13899990026","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenwuyi","name":"部门五（一）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(381,'{"node_uids":["d_bumenwuyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(382,'{"node_uids":["d_bumenwuyi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(383,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990027","name":"部门五二user","position":"","private_email":"","username":"13899990027","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenwuer","name":"部门五（二）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(384,'{"node_uids":["d_bumenwuer"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(385,'{"node_uids":["d_bumenwuer"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(386,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990028","name":"部门五三user","position":"","private_email":"","username":"13899990028","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenwusan","name":"部门五（三）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(387,'{"node_uids":["d_bumenwusan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(388,'{"node_uids":["d_bumenwusan"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(389,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990029","name":"部门五四user","position":"","private_email":"","username":"13899990029","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenwusi","name":"部门五（四）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(390,'{"node_uids":["d_bumenwusi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(391,'{"node_uids":["d_bumenwusi"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(392,'{"avatar":"","email":"","employee_number":"","gender":0,"mobile":"13899990030","name":"部门五五user","position":"","private_email":"","username":"13899990030","depts":null,"roles":null,"nodes":[{"node_uid":"d_bumenwuwu","name":"部门五（五）","node_scope":[],"user_scope":[],"users":[]}],"is_settled":false,"require_reset_password":false,"has_password":true}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(393,'{"node_uids":["d_bumenwuwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(394,'{"node_uids":["d_bumenwuwu"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(395,'{"password":"******","username":"13899990022"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(396,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(397,'{"password":"******","username":"13899990003"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(398,'{"password":"******","username":"13899990006"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(399,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(400,'{"node_uid":"g_jhomcpvf","name":"jhomcpvf","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":["d_bumenyi","d_bumener"],"users":[],"perms":["system_account_sync","system_app_create","system_category_create","system_config_write","system_log_read","system_user_create"],"apps":["yingyongyi","yingyonger","yingyongsan","yingyongsi","yingyongwu","yingyongliu","yingyongqi","yingyongba","yingyongjiu","yingyongshi"],"scope_subject":2},"users":["13899990002"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(401,'{"user_uids":["13899990002"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(402,'{"password":"******","username":"13899990002"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(403,'{"password":"******","username":"13899990006"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(404,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(405,'{"password":"******","username":"13899990002"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(406,'{"password":"******","username":"13899990003"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(407,'{"password":"******","username":"13899990004"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(408,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(409,'{"node_uid":"","name":"","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":["13899990001","13899990002"],"perms":["system_user_create","system_category_create","system_app_create","system_log_read","system_config_write","system_account_sync"],"apps":[],"scope_subject":2},"users":["13899990004"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(410,'{"user_uids":["13899990004"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(411,'{"node_uid":"","name":"","node_scope":[],"user_scope":[],"manager_group":{"nodes":[],"users":["13899990003","13899990004"],"perms":[],"apps":["yingyongsan","yingyonger","yingyongyi"],"scope_subject":2},"users":["13899990004"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(412,'{"user_uids":["13899990004"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(413,'{"password":"******","username":"13899990003"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(414,'{"password":"******","username":"13899990004"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(415,'{"password":"******","username":"admin"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(416,'{"node_uid":"g_lbdbkhnb","name":"lbdbkhnb","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":["d_bumenyi"],"users":["13899990001","13899990002"],"perms":["system_account_sync","system_app_create","system_category_create","system_config_write","system_log_read","system_user_create"],"apps":[],"scope_subject":2},"users":["13899990004"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(417,'{"user_uids":["13899990004"],"subject":"override"}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(418,'{"node_uid":"g_uqsbibkh","name":"uqsbibkh","visibility":1,"node_scope":[],"user_scope":[],"manager_group":{"nodes":["d_bumener"],"users":["13899990003","13899990004"],"perms":[],"apps":["yingyongyi","yingyonger","yingyongsan"],"scope_subject":2},"users":["13899990004"]}','application/json');
INSERT INTO "oneid_meta_requestdataclientlog" VALUES(419,'{"user_uids":["13899990004"],"subject":"override"}','application/json');
CREATE TABLE "oneid_meta_samlapp" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "entity_id" varchar(255) NOT NULL, "acs" varchar(255) NOT NULL, "sls" varchar(255) NOT NULL, "cert" varchar(2200) NOT NULL, "xmldata" varchar(5000) NOT NULL, "app_id" integer NULL UNIQUE REFERENCES "oneid_meta_app" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_smsconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "vendor" varchar(128) NOT NULL, "access_key" varchar(255) NOT NULL, "access_secret" varchar(255) NOT NULL, "signature" varchar(64) NOT NULL, "template_code" varchar(255) NOT NULL, "template_register" varchar(255) NOT NULL, "template_reset_pwd" varchar(255) NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED, "is_valid" bool NOT NULL, "template_activate" varchar(255) NOT NULL, "template_reset_mobile" varchar(255) NOT NULL);
INSERT INTO "oneid_meta_smsconfig" VALUES(1,'995179d8b37f49a9a4290811e2cd3ee6',0,1,'2019-12-30 08:20:46.484595','2019-12-30 08:20:46.484627','aliyun','','','','','','',1,0,'','');
CREATE TABLE "oneid_meta_storageconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "method" varchar(225) NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_storageconfig" VALUES(1,'2cb3b665e92447e0b61ed5e4e324425f',0,1,'2019-12-27 04:06:28.020779','2019-12-27 04:06:28.020817','local',1);
CREATE TABLE "oneid_meta_subaccount" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "domain" varchar(255) NOT NULL, "username" varchar(255) NULL, "password" varchar(512) NOT NULL);
CREATE TABLE "oneid_meta_user" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "username" varchar(255) NOT NULL, "password" varchar(1024) NOT NULL, "name" varchar(255) NOT NULL, "email" varchar(255) NOT NULL, "mobile" varchar(64) NOT NULL, "employee_number" varchar(255) NOT NULL, "gender" integer NOT NULL, "django_user_id" integer NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "from_register" bool NOT NULL, "is_boss" bool NOT NULL, "avatar" varchar(1024) NOT NULL, "position" varchar(255) NOT NULL, "private_email" varchar(255) NOT NULL, "origin" integer NOT NULL, "hiredate" datetime NULL, "remark" varchar(512) NOT NULL, "last_active_time" datetime NULL, "require_reset_password" bool NOT NULL);
INSERT INTO "oneid_meta_user" VALUES(1,'fc0b4d3d38c542b88b795a1a585d729b',0,1,'2019-12-27 04:06:34.975879','2019-11-16 11:35:29.805532','admin','{SMD5}YlwmpuFuCfoVB/lzdvNrlQag1Ho=','ADMIN','','','',0,NULL,0,0,'','','',0,NULL,'','2020-02-25 09:13:08.172041',0);
INSERT INTO "oneid_meta_user" VALUES(4,'8660b69adf964ee8b5ea7875fc309c79',0,1,'2019-11-16 10:27:22.031212','2019-11-16 09:42:49.664667','13899990001','{SMD5}tUQN+4dpOmjobYbjeBwBnnxvrVU=','部门一admin','','13899990001','',0,NULL,1,0,'','','',3,NULL,'','2019-11-16 10:41:08.003624',0);
INSERT INTO "oneid_meta_user" VALUES(5,'dd329c530f2a45b2b8ce6d33950c0180',0,1,'2019-11-16 10:27:31.199828','2019-11-16 09:43:09.170166','13899990002','{SMD5}uUxhXTyJ2POgUpn0T+QQakZoTUk=','部门二admin','','13899990002','',0,NULL,1,0,'','','',3,NULL,'','2020-02-25 08:46:36.180547',0);
INSERT INTO "oneid_meta_user" VALUES(6,'08231d36b25d4b04875883db97a94c85',0,1,'2019-11-16 13:12:57.747968','2019-11-16 13:12:57.748006','13899990003','{SMD5}dMKqWY/id8z/tOGQmwLjrCklxPg=','部门三admin','','13899990003','',0,NULL,1,0,'','','',3,NULL,'','2020-02-25 09:11:51.114987',0);
INSERT INTO "oneid_meta_user" VALUES(7,'569761a93e0b42c3b619a626ffb73f4c',0,1,'2019-11-16 10:27:50.216820','2019-11-16 09:43:48.186522','13899990004','{SMD5}Dd16DYideoP30Rbnv8sD/wWg9H4=','部门四admin','','13899990004','',0,NULL,1,0,'','','',3,NULL,'','2020-02-25 09:11:59.425185',0);
INSERT INTO "oneid_meta_user" VALUES(8,'288b5de4f2924fb593a52e479ac48394',0,1,'2019-11-16 10:28:03.702525','2019-11-16 09:44:07.605701','13899990005','{SMD5}n4TPNZNOeUXGSC4iPP7jLJ9Tylk=','部门五admin','','13899990005','',0,NULL,1,0,'','','',3,NULL,'','2019-11-16 09:59:00.389427',0);
INSERT INTO "oneid_meta_user" VALUES(9,'776df52260394daabde15e43364dcf38',0,1,'2019-12-27 11:08:00.127074','2019-11-16 09:44:40.660558','13899990006','{SMD5}bhvalOAeeo8GLzi/voUoTw6h9L4=','部门一一user','','13899990006','',0,NULL,1,0,'','','',3,NULL,'','2020-02-25 08:44:35.346432',0);
INSERT INTO "oneid_meta_user" VALUES(10,'4ecf2781d71a4fd5ba2103041007fc96',0,1,'2019-12-27 11:08:07.400734','2019-11-16 09:45:03.101917','13899990007','{SMD5}I1EJa9mdvTQQ5IfxtNEku+Rcy1k=','部门一二user','','13899990007','',0,NULL,1,0,'','','',3,NULL,'','2019-12-27 09:16:34.019409',0);
INSERT INTO "oneid_meta_user" VALUES(11,'3657563a1d4c4af9be25857d59886f53',0,1,'2019-12-27 11:08:13.600680','2019-11-16 09:45:21.835815','13899990008','{SMD5}j/+SsxVgE3wDM9HxABf1UkGIcU4=','部门一三user','','13899990008','',0,NULL,1,0,'','','',3,NULL,'','2019-11-16 09:59:20.475121',0);
INSERT INTO "oneid_meta_user" VALUES(12,'c29980b16fb245d19941e1653472e663',0,1,'2019-12-27 11:08:20.305827','2019-11-16 09:45:38.573998','13899990009','{SMD5}z/r60dbiKkEXRut9MOLL5M1ZizE=','部门一四user','','13899990009','',0,NULL,1,0,'','','',3,NULL,'','2019-11-16 09:59:34.321646',0);
INSERT INTO "oneid_meta_user" VALUES(13,'1e6ebb8b5bac405c85689dfd10227484',0,1,'2019-12-27 11:08:28.608080','2019-11-16 10:33:09.063893','13899990010','{SMD5}1/KxDfWELE6wAT+x5mquva61dg4=','部门一五user','','13899990010','',0,NULL,0,0,'','','',1,NULL,'','2019-11-16 10:34:07.542981',0);
INSERT INTO "oneid_meta_user" VALUES(14,'80b824a0ea054c4ab7c5ce87371af293',1,1,'2019-12-27 09:25:22.146202','2019-12-27 09:19:15.112894','1234','','1234','','12341234123','',0,NULL,0,0,'','','',1,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(15,'b3a839f0a137438abe9ecdaa01b100bc',0,1,'2019-12-27 11:09:03.408612','2019-12-27 11:01:43.259484','13899990011','{SMD5}gsfhW9AprQ0f162e0Bwb8FYKoTQ=','部门二一user','','13899990011','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(16,'4a37e87432844579923102e5aafa4f2c',0,1,'2019-12-27 11:09:23.465330','2019-12-27 11:02:13.101396','13899990012','{SMD5}MNz/rZ7JiX9u2KVWsgReri5FCKE=','部门二二user','','13899990012','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(17,'823b658ccb314a99aa100d49f1a8f415',0,1,'2019-12-27 11:09:37.886292','2019-12-27 11:02:34.627152','13899990013','{SMD5}C0ndnl3K/PPgSWzBjmtXSwBgzBk=','部门二三user','','13899990013','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(18,'94a0ab531e2547799fa1cb21e31f0038',0,1,'2019-12-27 11:09:51.747231','2019-12-27 11:02:53.205334','13899990014','{SMD5}WIA0CphwO9GBoW6fu69BNpDSGiM=','部门二四user','','13899990014','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(19,'5d148b44c3be4f929e8c497e7d6969fb',0,1,'2019-12-27 11:10:08.475315','2019-12-27 11:03:10.721438','13899990015','{SMD5}Ok+b/7P3Hwj/F+txaE3SiM85Z8w=','部门二五user','','13899990015','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(20,'bf20d6fd49764661a475030783c3220d',0,1,'2019-12-27 11:10:27.298127','2019-12-27 11:03:32.530286','13899990016','{SMD5}mJ5VwaWeKhVtNmnDpEN1rpCSEsI=','部门三一user','','13899990016','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(21,'10b1d109311f43719beb5bd78691ea4d',0,1,'2019-12-27 11:31:32.395892','2019-12-27 11:03:48.678093','13899990017','{SMD5}tWS0GvLIg3yINAl77+Yv3oFQCsE=','部门三二user','','13899990017','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(22,'84624434c9b14eed918d7186d059f8b5',0,1,'2019-12-27 11:31:51.882191','2019-12-27 11:04:07.039228','13899990018','{SMD5}cn69lKkCXjnpWXw4+s22S54zpnQ=','部门三三user','','13899990018','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(23,'1aa6aa9544364e5ebd86d406525dcb5c',0,1,'2019-12-27 11:32:05.743632','2019-12-27 11:04:23.937321','13899990019','{SMD5}HhhoqrsUi4LAFLcblE1jdUaolfI=','部门三四user','','13899990019','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(24,'530f75ae20e04bb18d0d8d61fb0305cd',0,1,'2019-12-27 11:34:45.289651','2019-12-27 11:04:39.793498','13899990029','{SMD5}hn3dSl02Yk3GywTBiA+joG2tdS4=','部门五四user','','13899990029','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(25,'2f36bd9505fb4df1a4c2d9dd2c4da679',0,1,'2019-12-27 11:32:45.114693','2019-12-27 11:04:56.436436','13899990021','{SMD5}xtfAMbcT3AcygWk7+FH9nOS8l7I=','部门四一user','','13899990021','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(26,'6d162f957f044500b2146ae523b7f83f',0,1,'2019-12-27 11:32:58.843317','2019-12-27 11:05:12.208361','13899990022','{SMD5}t/X/CoLnpTaR5bcWoiaBeu0dA6A=','部门四二user','','13899990022','',0,NULL,1,0,'','','',3,NULL,'','2020-02-25 03:25:58.854524',0);
INSERT INTO "oneid_meta_user" VALUES(27,'c14caa1501d64eb7abd7008cbba6f352',0,1,'2019-12-27 11:33:12.263531','2019-12-27 11:05:31.401316','13899990023','{SMD5}WWtJbFwqxVl9b6T7cE9aMU5J6X0=','部门四三user','','13899990023','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(28,'1486105a9fad4d208ce47f51102e1be9',0,1,'2019-12-27 11:33:25.022968','2019-12-27 11:05:47.490703','13899990024','{SMD5}nenob5izaOuMUO2kmhRdNBRCqBU=','部门四四user','','13899990024','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(29,'600184edf79c44a89a60e5ac7affcee5',0,1,'2019-12-27 11:33:39.508663','2019-12-27 11:06:04.593505','13899990025','{SMD5}+sejYyVFzMuEQAwgzQH9MQ3BWAs=','部门四五user','','13899990025','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(30,'0554a35378bf47658a796b18f100d79a',0,1,'2019-12-27 11:33:54.868065','2019-12-27 11:06:23.576906','13899990026','{SMD5}/G7q0HBLA+8LhB3E2mhBImdsLcU=','部门五一user','','13899990026','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(31,'0174d22368ee4a4f86fd84ec65039b42',0,1,'2019-12-27 11:34:12.563227','2019-12-27 11:06:39.319593','13899990027','{SMD5}DcgWnNchqqhXDJ0k5GZIZmJsjfE=','部门五二user','','13899990027','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(32,'4043ceb3ee8b450086c16ae62cf1630f',0,1,'2019-12-27 11:34:27.313305','2019-12-27 11:06:56.327943','13899990028','{SMD5}H7E8ObR1dc/9hzXDx2p/MhqDkLI=','部门五三user','','13899990028','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(33,'ccf77d80a34447f099d48ceb135d708f',0,1,'2019-12-27 11:35:02.874689','2019-12-27 11:07:33.908191','13899990030','{SMD5}VjEcwgHgWyETyqT9FrCMCzaGkFI=','部门五五user','','13899990030','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
INSERT INTO "oneid_meta_user" VALUES(34,'c48f56993a334660804236c4f99463b0',0,1,'2019-12-27 11:32:25.844862','2019-12-27 11:14:52.848065','13899990020','{SMD5}MVEaTcbVh2nN/ZLmQBxKtU3J2Ts=','部门三五user','','13899990020','',0,NULL,1,0,'','','',3,NULL,'',NULL,0);
CREATE TABLE "oneid_meta_userperm" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "status" integer NOT NULL, "value" bool NOT NULL, "dept_perm_value" bool NOT NULL, "group_perm_value" bool NOT NULL, "perm_id" integer NOT NULL REFERENCES "oneid_meta_perm" ("id") DEFERRABLE INITIALLY DEFERRED, "owner_id" integer NOT NULL REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "oneid_meta_userperm" VALUES(1,'36023288d6974f52b1525297613bb2f0',0,1,'2020-01-07 12:19:56.207582','2019-11-16 11:35:29.807517',1,1,0,0,1,1);
INSERT INTO "oneid_meta_userperm" VALUES(2,'38ac10d3d487476184ef0847fa1b41fb',0,1,'2020-01-07 12:19:56.241372','2019-11-16 11:35:29.879186',1,1,0,0,2,1);
INSERT INTO "oneid_meta_userperm" VALUES(3,'55fbdd4b8a2440d68ad94910b203ef2c',0,1,'2019-11-16 09:34:30.427358','2019-11-16 09:34:30.427386',0,0,0,0,1,2);
INSERT INTO "oneid_meta_userperm" VALUES(4,'7ed8798c70664831b20737d0fd163e2a',0,1,'2019-11-16 09:34:30.429137','2019-11-16 09:34:30.429164',0,0,0,0,2,2);
INSERT INTO "oneid_meta_userperm" VALUES(5,'a6adc5c06d08465baea89187a7cc1343',0,1,'2019-11-16 09:34:30.430504','2019-11-16 09:34:30.430541',0,0,0,0,3,2);
INSERT INTO "oneid_meta_userperm" VALUES(6,'080da54f82814d6e9ebd304349365aec',0,1,'2019-11-16 09:34:30.432187','2019-11-16 09:34:30.432215',0,0,0,0,4,2);
INSERT INTO "oneid_meta_userperm" VALUES(7,'4934ba9de6bb453e85b9f3b13eb8971c',0,1,'2019-11-16 09:34:30.433664','2019-11-16 09:34:30.433691',0,0,0,0,5,2);
INSERT INTO "oneid_meta_userperm" VALUES(8,'6e76b7618dee47b39b604307fe0eff1e',0,1,'2019-11-16 09:34:30.435250','2019-11-16 09:34:30.435304',0,0,0,0,6,2);
INSERT INTO "oneid_meta_userperm" VALUES(9,'c566898d07d244969fedbe3b5276e59d',0,1,'2019-11-16 09:34:30.436601','2019-11-16 09:34:30.436623',0,0,0,0,7,2);
INSERT INTO "oneid_meta_userperm" VALUES(10,'7fd897f39b174794bf13233569c7ca5c',0,1,'2019-11-16 09:34:30.437809','2019-11-16 09:34:30.437831',0,0,0,0,8,2);
INSERT INTO "oneid_meta_userperm" VALUES(11,'3e6e90cabd344bae8d6cb2621019bbb8',0,1,'2019-11-16 09:34:30.438986','2019-11-16 09:34:30.439008',0,0,0,0,9,2);
INSERT INTO "oneid_meta_userperm" VALUES(12,'9ef8c12a5eb3434da73dbb3d56795827',0,1,'2019-11-16 09:34:30.440209','2019-11-16 09:34:30.440231',0,0,0,0,10,2);
INSERT INTO "oneid_meta_userperm" VALUES(13,'586612556c2a45b49e835828816ead71',0,1,'2019-11-16 09:35:05.909234','2019-11-16 09:35:05.909261',0,0,0,0,1,3);
INSERT INTO "oneid_meta_userperm" VALUES(14,'880c59e920164e6d8b202738dd834e03',0,1,'2019-11-16 09:35:05.910889','2019-11-16 09:35:05.910912',0,0,0,0,2,3);
INSERT INTO "oneid_meta_userperm" VALUES(15,'edf41b6817c14fbb8cb10f4d122dcf9c',0,1,'2019-11-16 09:35:05.912330','2019-11-16 09:35:05.912352',0,0,0,0,3,3);
INSERT INTO "oneid_meta_userperm" VALUES(16,'1747f06aa2f04aaa984f95050f1ac16e',0,1,'2019-11-16 09:35:05.913511','2019-11-16 09:35:05.913532',0,0,0,0,4,3);
INSERT INTO "oneid_meta_userperm" VALUES(17,'2341dc1b733f40f1b701823620b10e08',0,1,'2019-11-16 09:35:05.914874','2019-11-16 09:35:05.914899',0,0,0,0,5,3);
INSERT INTO "oneid_meta_userperm" VALUES(18,'d8cbd938d334441d8f140dc74ea672f5',0,1,'2019-11-16 09:35:05.916511','2019-11-16 09:35:05.916537',0,0,0,0,6,3);
INSERT INTO "oneid_meta_userperm" VALUES(19,'c29865f1764d477a876997dc360b018f',0,1,'2019-11-16 09:35:05.917847','2019-11-16 09:35:05.917869',0,0,0,0,7,3);
INSERT INTO "oneid_meta_userperm" VALUES(20,'28f1797e01d24253b53e77ae20ad352d',0,1,'2019-11-16 09:35:05.919371','2019-11-16 09:35:05.919396',0,0,0,0,8,3);
INSERT INTO "oneid_meta_userperm" VALUES(21,'b417f8f7de0f4e26a795b9f0b61fed1b',0,1,'2019-11-16 09:35:05.921478','2019-11-16 09:35:05.921536',0,0,0,0,9,3);
INSERT INTO "oneid_meta_userperm" VALUES(22,'3f3d62c08aca4fc5be5bd6a015acb6aa',0,1,'2019-11-16 09:35:05.922952','2019-11-16 09:35:05.922975',0,0,0,0,10,3);
INSERT INTO "oneid_meta_userperm" VALUES(23,'83759afed5ba49f793aee9f95245786d',0,1,'2020-01-07 12:19:56.986634','2019-11-16 09:42:49.668080',0,0,0,0,1,4);
INSERT INTO "oneid_meta_userperm" VALUES(24,'7d333fbc5e6044419017b69c9e4f3f8c',0,1,'2020-01-07 12:19:57.007130','2019-11-16 09:42:49.669866',0,0,0,0,2,4);
INSERT INTO "oneid_meta_userperm" VALUES(25,'b4377051156c4c8bbf7bd36af3840e46',0,1,'2020-01-07 12:19:57.020226','2019-11-16 09:42:49.671668',0,0,0,0,3,4);
INSERT INTO "oneid_meta_userperm" VALUES(26,'c19caf0969bf400ab2de0b499b2cc8da',0,1,'2020-01-07 12:19:57.034403','2019-11-16 09:42:49.673374',0,0,0,0,4,4);
INSERT INTO "oneid_meta_userperm" VALUES(27,'a0c1a59a4ab048648e651d7ea78d64a7',0,1,'2020-01-07 12:19:57.057910','2019-11-16 09:42:49.674613',0,0,0,0,5,4);
INSERT INTO "oneid_meta_userperm" VALUES(28,'3638d17cc1114b1a809181c0878d6e51',0,1,'2020-01-07 12:19:57.073448','2019-11-16 09:42:49.675962',0,0,0,0,6,4);
INSERT INTO "oneid_meta_userperm" VALUES(29,'e7fcc12b919148ca9c1cb78c967b5382',0,1,'2020-01-07 12:19:57.086539','2019-11-16 09:42:49.677207',0,0,0,0,7,4);
INSERT INTO "oneid_meta_userperm" VALUES(30,'607ab977d4fc499bbc967e1c6ccc0d97',0,1,'2020-01-07 12:19:57.104169','2019-11-16 09:42:49.678457',0,0,0,0,8,4);
INSERT INTO "oneid_meta_userperm" VALUES(31,'ec54407b932b4309ac71d9b70daf5d7d',0,1,'2020-01-07 12:19:57.118955','2019-11-16 09:42:49.679746',0,0,0,0,9,4);
INSERT INTO "oneid_meta_userperm" VALUES(32,'4c04dae9ad074cc9aae77481b5dc0b92',0,1,'2020-01-07 12:19:57.134733','2019-11-16 09:42:49.680973',0,0,0,0,10,4);
INSERT INTO "oneid_meta_userperm" VALUES(33,'4940cf31c00b49ecb5b400f76fdd557d',0,1,'2020-01-07 12:19:57.404488','2019-11-16 09:43:09.178799',0,0,0,0,1,5);
INSERT INTO "oneid_meta_userperm" VALUES(34,'5210e5351f2e40d6a289eccfae8c332b',0,1,'2020-01-07 12:19:57.466004','2019-11-16 09:43:09.180559',0,0,0,0,2,5);
INSERT INTO "oneid_meta_userperm" VALUES(35,'7b53b468125b4ddf804c79c2ac7590f4',0,1,'2020-01-07 12:19:57.488883','2019-11-16 09:43:09.181832',0,0,0,0,3,5);
INSERT INTO "oneid_meta_userperm" VALUES(36,'ee217a301ec74df1ae482972ef49c0d1',0,1,'2020-01-07 12:19:57.526109','2019-11-16 09:43:09.182986',0,0,0,0,4,5);
INSERT INTO "oneid_meta_userperm" VALUES(37,'e9c73dd6ac5348f8b86c2c3d072aa646',0,1,'2020-01-07 12:19:57.546359','2019-11-16 09:43:09.184378',0,1,0,1,5,5);
INSERT INTO "oneid_meta_userperm" VALUES(38,'f21aeb46a03d44c7b546ac4d153cec65',0,1,'2020-01-07 12:19:57.579852','2019-11-16 09:43:09.186400',0,1,0,1,6,5);
INSERT INTO "oneid_meta_userperm" VALUES(39,'30b3e4fadc0648bebe7fb31a09ee1b26',0,1,'2020-01-07 12:19:57.609448','2019-11-16 09:43:09.187866',0,1,0,1,7,5);
INSERT INTO "oneid_meta_userperm" VALUES(40,'0173c67664ea4a279d0310f3c1a1ce55',0,1,'2020-01-07 12:19:57.629000','2019-11-16 09:43:09.189349',0,1,0,1,8,5);
INSERT INTO "oneid_meta_userperm" VALUES(41,'3749899e126f4a9e92ed6f76ea449f01',0,1,'2020-01-07 12:19:57.645622','2019-11-16 09:43:09.190630',0,1,0,1,9,5);
INSERT INTO "oneid_meta_userperm" VALUES(42,'c7739c249e4c4dedabb9fb1ef9174187',0,1,'2020-01-07 12:19:57.661103','2019-11-16 09:43:09.192030',0,1,0,1,10,5);
INSERT INTO "oneid_meta_userperm" VALUES(43,'6d26fa864af04817a2cfcc36ce61f6f9',0,1,'2020-01-07 12:19:57.864376','2019-11-16 09:43:27.907353',0,0,0,0,1,6);
INSERT INTO "oneid_meta_userperm" VALUES(44,'bddfd8f924b64187952b5d71a3462d78',0,1,'2020-01-07 12:19:57.889013','2019-11-16 09:43:27.909135',0,0,0,0,2,6);
INSERT INTO "oneid_meta_userperm" VALUES(45,'a37150afc768441586f3428adabc5764',0,1,'2020-01-07 12:19:57.903693','2019-11-16 09:43:27.910429',0,0,0,0,3,6);
INSERT INTO "oneid_meta_userperm" VALUES(46,'0df6115fa0e54cf1b2afaa7a8decba1b',0,1,'2020-01-07 12:19:57.917491','2019-11-16 09:43:27.911677',0,0,0,0,4,6);
INSERT INTO "oneid_meta_userperm" VALUES(47,'dfc349d39f9c4a8081cb3a99b3370ec1',0,1,'2020-01-07 12:19:57.934237','2019-11-16 09:43:27.912865',0,1,0,1,5,6);
INSERT INTO "oneid_meta_userperm" VALUES(48,'ce0b6ec52d044b73a88446d274ef2d97',0,1,'2020-01-07 12:19:57.946653','2019-11-16 09:43:27.914192',0,1,0,1,6,6);
INSERT INTO "oneid_meta_userperm" VALUES(49,'5245aeb92eba497bb6a598ab5dc99f4f',0,1,'2020-01-07 12:19:57.961518','2019-11-16 09:43:27.916008',0,1,0,1,7,6);
INSERT INTO "oneid_meta_userperm" VALUES(50,'6d51073d80804a79890ec0592436ddc0',0,1,'2020-01-07 12:19:57.988671','2019-11-16 09:43:27.917777',0,1,0,1,8,6);
INSERT INTO "oneid_meta_userperm" VALUES(51,'c9d6c8f332a348a3b3e71af78a3785e6',0,1,'2020-01-07 12:19:58.009159','2019-11-16 09:43:27.919157',0,1,0,1,9,6);
INSERT INTO "oneid_meta_userperm" VALUES(52,'23ae2b75ec844354b4b52a9973e09468',0,1,'2020-01-07 12:19:58.029741','2019-11-16 09:43:27.920423',0,1,0,1,10,6);
INSERT INTO "oneid_meta_userperm" VALUES(53,'a11747dd475649e3aace642118ea3a24',0,1,'2020-01-07 12:19:58.247449','2019-11-16 09:43:48.192398',0,0,0,0,1,7);
INSERT INTO "oneid_meta_userperm" VALUES(54,'4e10f118ad5c494fa47282f0a6200fd5',0,1,'2020-01-07 12:19:58.272764','2019-11-16 09:43:48.194060',0,0,0,0,2,7);
INSERT INTO "oneid_meta_userperm" VALUES(55,'f5e1454b231e46e493d345a74771ad19',0,1,'2020-01-07 12:19:58.304453','2019-11-16 09:43:48.195578',0,0,0,0,3,7);
INSERT INTO "oneid_meta_userperm" VALUES(56,'e506e85513cb4b9a8fc19403a4f124a2',0,1,'2020-01-07 12:19:58.318738','2019-11-16 09:43:48.197393',0,0,0,0,4,7);
INSERT INTO "oneid_meta_userperm" VALUES(57,'60c878a8b4444936b56d139531da26f5',0,1,'2020-01-07 12:19:58.331906','2019-11-16 09:43:48.199057',0,1,0,1,5,7);
INSERT INTO "oneid_meta_userperm" VALUES(58,'b946b068c0704403b83194c3ec51eaf9',0,1,'2020-01-07 12:19:58.344441','2019-11-16 09:43:48.200590',0,1,0,1,6,7);
INSERT INTO "oneid_meta_userperm" VALUES(59,'f00a382752b84db5b9761c735462509e',0,1,'2020-01-07 12:19:58.357783','2019-11-16 09:43:48.202112',0,1,0,1,7,7);
INSERT INTO "oneid_meta_userperm" VALUES(60,'e27eb69a10ff447ab76a245a65f2003f',0,1,'2020-01-07 12:19:58.374899','2019-11-16 09:43:48.203552',0,1,0,1,8,7);
INSERT INTO "oneid_meta_userperm" VALUES(61,'7addb60a66b44edd8c8a1845aa65c095',0,1,'2020-01-07 12:19:58.412875','2019-11-16 09:43:48.204880',0,1,0,1,9,7);
INSERT INTO "oneid_meta_userperm" VALUES(62,'637360cfb2734514b1bc78c5a264af4c',0,1,'2020-01-07 12:19:58.428364','2019-11-16 09:43:48.206309',0,1,0,1,10,7);
INSERT INTO "oneid_meta_userperm" VALUES(63,'283e13f348d6470e8190f944a886c78b',0,1,'2020-01-07 12:19:58.662687','2019-11-16 09:44:07.614280',0,0,0,0,1,8);
INSERT INTO "oneid_meta_userperm" VALUES(64,'58ece6b77d874460969a5fb6df76b1e2',0,1,'2020-01-07 12:19:58.675910','2019-11-16 09:44:07.615752',0,0,0,0,2,8);
INSERT INTO "oneid_meta_userperm" VALUES(65,'81813681780d4411adaa01f7bcad330a',0,1,'2020-01-07 12:19:58.686873','2019-11-16 09:44:07.617198',0,0,0,0,3,8);
INSERT INTO "oneid_meta_userperm" VALUES(66,'9dc1ff15c2824fcb92a25e84f46d497d',0,1,'2020-01-07 12:19:58.707091','2019-11-16 09:44:07.618549',0,0,0,0,4,8);
INSERT INTO "oneid_meta_userperm" VALUES(67,'5ef9a689d7e24a60a3d9c131fd05c5be',0,1,'2020-01-07 12:19:58.718636','2019-11-16 09:44:07.619800',0,0,0,0,5,8);
INSERT INTO "oneid_meta_userperm" VALUES(68,'7919fb8b6d2e4aef9cfe4772b4825763',0,1,'2020-01-07 12:19:58.728489','2019-11-16 09:44:07.621112',0,0,0,0,6,8);
INSERT INTO "oneid_meta_userperm" VALUES(69,'6404786de1f345bfb7485bda34bc9cf9',0,1,'2020-01-07 12:19:58.739215','2019-11-16 09:44:07.622605',0,0,0,0,7,8);
INSERT INTO "oneid_meta_userperm" VALUES(70,'16c23f920bcc47f68627afda7a48c8a1',0,1,'2020-01-07 12:19:58.749186','2019-11-16 09:44:07.624469',0,0,0,0,8,8);
INSERT INTO "oneid_meta_userperm" VALUES(71,'44ecb3e28fd14f2b8886ae58f890463e',0,1,'2020-01-07 12:19:58.759144','2019-11-16 09:44:07.625812',0,0,0,0,9,8);
INSERT INTO "oneid_meta_userperm" VALUES(72,'a2c190893b7a45ef9b02735827d773d0',0,1,'2020-01-07 12:19:58.769099','2019-11-16 09:44:07.627430',0,0,0,0,10,8);
INSERT INTO "oneid_meta_userperm" VALUES(73,'e7b004c1e3a94f7d8420b18350274481',0,1,'2020-01-07 12:19:58.915373','2019-11-16 09:44:40.666935',0,0,0,0,1,9);
INSERT INTO "oneid_meta_userperm" VALUES(74,'5073a559e3a847fe8f9e044d616b518b',0,1,'2020-01-07 12:19:58.929259','2019-11-16 09:44:40.669054',0,0,0,0,2,9);
INSERT INTO "oneid_meta_userperm" VALUES(75,'6aaa61839be641089086b978edd741f2',0,1,'2020-01-07 12:19:58.940700','2019-11-16 09:44:40.671294',0,0,0,0,3,9);
INSERT INTO "oneid_meta_userperm" VALUES(76,'fa148a11302a4909ae5d485778b3c5da',0,1,'2020-01-07 12:19:58.951973','2019-11-16 09:44:40.672814',0,0,0,0,4,9);
INSERT INTO "oneid_meta_userperm" VALUES(77,'5ccc0fae591c42e28a6510376f80f578',0,1,'2020-01-07 12:19:58.964205','2019-11-16 09:44:40.674703',0,0,0,0,5,9);
INSERT INTO "oneid_meta_userperm" VALUES(78,'bd0ead36a735487e97d9fbe71c53deca',0,1,'2020-01-07 12:19:58.975836','2019-11-16 09:44:40.676082',0,0,0,0,6,9);
INSERT INTO "oneid_meta_userperm" VALUES(79,'ae7f009b8c69439092f2fb8958937689',0,1,'2020-01-07 12:19:58.986414','2019-11-16 09:44:40.677451',0,0,0,0,7,9);
INSERT INTO "oneid_meta_userperm" VALUES(80,'13555d7d7bb2466da4657c4783fc6a12',0,1,'2020-01-07 12:19:58.998449','2019-11-16 09:44:40.678769',0,0,0,0,8,9);
INSERT INTO "oneid_meta_userperm" VALUES(81,'cefadd24892c4938af4d1840c0f441fe',0,1,'2020-01-07 12:19:59.022124','2019-11-16 09:44:40.680264',0,0,0,0,9,9);
INSERT INTO "oneid_meta_userperm" VALUES(82,'ff87d9c0059a4ab6bd8d42a026d2660f',0,1,'2020-01-07 12:19:59.035739','2019-11-16 09:44:40.681532',0,0,0,0,10,9);
INSERT INTO "oneid_meta_userperm" VALUES(83,'efed0a26d41f4bc0a07b5897b21d054e',0,1,'2020-01-07 12:19:59.194027','2019-11-16 09:45:03.110523',0,0,0,0,1,10);
INSERT INTO "oneid_meta_userperm" VALUES(84,'53337cee3ca244319c0331ad401e8976',0,1,'2020-01-07 12:19:59.208395','2019-11-16 09:45:03.112254',0,0,0,0,2,10);
INSERT INTO "oneid_meta_userperm" VALUES(85,'66f0811186714b46a60124c37f15812c',0,1,'2020-01-07 12:19:59.234094','2019-11-16 09:45:03.113877',0,0,0,0,3,10);
INSERT INTO "oneid_meta_userperm" VALUES(86,'adf3edac5774452daf83b06eda0e41b2',0,1,'2020-01-07 12:19:59.249878','2019-11-16 09:45:03.115138',0,0,0,0,4,10);
INSERT INTO "oneid_meta_userperm" VALUES(87,'217f56822ae64a96a311d5a990efc104',0,1,'2020-01-07 12:19:59.265556','2019-11-16 09:45:03.116321',0,0,0,0,5,10);
INSERT INTO "oneid_meta_userperm" VALUES(88,'3b76280da4b548e29566b6cee6357991',0,1,'2020-01-07 12:19:59.283871','2019-11-16 09:45:03.117947',0,0,0,0,6,10);
INSERT INTO "oneid_meta_userperm" VALUES(89,'d91a2f0f617143f5b8460b5196d25dfa',0,1,'2020-01-07 12:19:59.296185','2019-11-16 09:45:03.120234',0,0,0,0,7,10);
INSERT INTO "oneid_meta_userperm" VALUES(90,'e124b1b9959446a48e6d2c3aa952d7a5',0,1,'2020-01-07 12:19:59.311313','2019-11-16 09:45:03.121773',0,0,0,0,8,10);
INSERT INTO "oneid_meta_userperm" VALUES(91,'2266e7f298404706932f6648dd619466',0,1,'2020-01-07 12:19:59.336822','2019-11-16 09:45:03.123093',0,0,0,0,9,10);
INSERT INTO "oneid_meta_userperm" VALUES(92,'bae1cad53a97418aad2faacec3222a96',0,1,'2020-01-07 12:19:59.351103','2019-11-16 09:45:03.124604',0,0,0,0,10,10);
INSERT INTO "oneid_meta_userperm" VALUES(93,'55b73b5df5054ecd80e861b4057cb970',0,1,'2020-01-07 12:19:59.521859','2019-11-16 09:45:21.842058',0,0,0,0,1,11);
INSERT INTO "oneid_meta_userperm" VALUES(94,'7895e6ee551c41a4bba9f628b430cf53',0,1,'2020-01-07 12:19:59.547771','2019-11-16 09:45:21.844057',0,0,0,0,2,11);
INSERT INTO "oneid_meta_userperm" VALUES(95,'5aa0b4e6db344ce3a94407ed23f18f79',0,1,'2020-01-07 12:19:59.560300','2019-11-16 09:45:21.845774',0,0,0,0,3,11);
INSERT INTO "oneid_meta_userperm" VALUES(96,'442c976ae88a4870b4e578e682b647c2',0,1,'2020-01-07 12:19:59.572206','2019-11-16 09:45:21.847453',0,0,0,0,4,11);
INSERT INTO "oneid_meta_userperm" VALUES(97,'8d817ef122f841289bd2d127d90f0592',0,1,'2020-01-07 12:19:59.585714','2019-11-16 09:45:21.849532',0,0,0,0,5,11);
INSERT INTO "oneid_meta_userperm" VALUES(98,'f3fd1d8ade2646baa3cef1a413d1ab32',0,1,'2020-01-07 12:19:59.598693','2019-11-16 09:45:21.851141',0,0,0,0,6,11);
INSERT INTO "oneid_meta_userperm" VALUES(99,'ee5a4d04e7b046aba84a29a03c0938fb',0,1,'2020-01-07 12:19:59.611735','2019-11-16 09:45:21.852663',0,0,0,0,7,11);
INSERT INTO "oneid_meta_userperm" VALUES(100,'feb039de775f45c1879dd48988709754',0,1,'2020-01-07 12:19:59.624668','2019-11-16 09:45:21.854035',0,0,0,0,8,11);
INSERT INTO "oneid_meta_userperm" VALUES(101,'940bf198cdbb47f7be85ffef63aeded6',0,1,'2020-01-07 12:19:59.649415','2019-11-16 09:45:21.855389',0,0,0,0,9,11);
INSERT INTO "oneid_meta_userperm" VALUES(102,'a9dedafb468e49299e5a874102e0ed2e',0,1,'2020-01-07 12:19:59.661859','2019-11-16 09:45:21.856963',0,0,0,0,10,11);
INSERT INTO "oneid_meta_userperm" VALUES(103,'c63abd824c764ec1b63e9a5ed5a8cc24',0,1,'2020-01-07 12:19:59.818184','2019-11-16 09:45:38.583716',0,0,0,0,1,12);
INSERT INTO "oneid_meta_userperm" VALUES(104,'017d9bb2f310497a977bf988aa592293',0,1,'2020-01-07 12:19:59.829778','2019-11-16 09:45:38.585275',0,0,0,0,2,12);
INSERT INTO "oneid_meta_userperm" VALUES(105,'298d6d1fa0f14dc9a4145125634797c2',0,1,'2020-01-07 12:19:59.840134','2019-11-16 09:45:38.586832',0,0,0,0,3,12);
INSERT INTO "oneid_meta_userperm" VALUES(106,'e25fd98d242941029958a7b4d039bdc0',0,1,'2020-01-07 12:19:59.852204','2019-11-16 09:45:38.588153',0,0,0,0,4,12);
INSERT INTO "oneid_meta_userperm" VALUES(107,'47a0b07831e045daafed73d3ad0e00b0',0,1,'2020-01-07 12:19:59.864404','2019-11-16 09:45:38.589380',0,0,0,0,5,12);
INSERT INTO "oneid_meta_userperm" VALUES(108,'92f03a428e1a4b9f8c02106a2dcd26ef',0,1,'2020-01-07 12:19:59.876522','2019-11-16 09:45:38.591227',0,0,0,0,6,12);
INSERT INTO "oneid_meta_userperm" VALUES(109,'90773dc42264464facf72d80f2e9c5d2',0,1,'2020-01-07 12:19:59.887434','2019-11-16 09:45:38.592717',0,0,0,0,7,12);
INSERT INTO "oneid_meta_userperm" VALUES(110,'29772900c8b14b5297854f4cd9e97e5b',0,1,'2020-01-07 12:19:59.898900','2019-11-16 09:45:38.594661',0,0,0,0,8,12);
INSERT INTO "oneid_meta_userperm" VALUES(111,'32bba419b621441d829ad9865890cec3',0,1,'2020-01-07 12:19:59.910999','2019-11-16 09:45:38.596014',0,0,0,0,9,12);
INSERT INTO "oneid_meta_userperm" VALUES(112,'b793933d6306441095e70c130e254981',0,1,'2020-01-07 12:19:59.922246','2019-11-16 09:45:38.597475',0,0,0,0,10,12);
INSERT INTO "oneid_meta_userperm" VALUES(113,'0bf10565c47845439e5e5d44d1782f2f',0,1,'2020-01-07 12:19:57.244198','2019-11-16 10:13:04.633394',0,0,0,0,15,4);
INSERT INTO "oneid_meta_userperm" VALUES(114,'e3dcd9ac531d42dbb808f2de1578b3cf',0,1,'2020-01-07 12:19:57.214976','2019-11-16 10:13:04.650471',0,0,0,0,14,4);
INSERT INTO "oneid_meta_userperm" VALUES(115,'54356796a0a8470b9842a919dd8c41a0',0,1,'2020-01-07 12:19:57.201166','2019-11-16 10:13:04.665428',0,0,0,0,13,4);
INSERT INTO "oneid_meta_userperm" VALUES(116,'cfd71ee6b8a04a7db8f0f42eaad0f574',0,1,'2020-01-07 12:19:57.179325','2019-11-16 10:13:04.680523',0,0,0,0,12,4);
INSERT INTO "oneid_meta_userperm" VALUES(117,'2e4711969a4f441c8e390451debba760',0,1,'2020-01-07 12:19:57.149784','2019-11-16 10:13:04.695878',0,0,0,0,11,4);
INSERT INTO "oneid_meta_userperm" VALUES(118,'ab3e149313fc44c6981bceff84f03ce2',0,1,'2020-01-07 12:20:00.062912','2019-11-16 10:33:09.066259',0,0,0,0,1,13);
INSERT INTO "oneid_meta_userperm" VALUES(119,'99e9bcaff0a24cdd8bb42b8e2b63809e',0,1,'2020-01-07 12:20:00.072575','2019-11-16 10:33:09.066906',0,0,0,0,2,13);
INSERT INTO "oneid_meta_userperm" VALUES(120,'7e5b3c7eb6294b52a55fb1247897178f',0,1,'2020-01-07 12:20:00.082516','2019-11-16 10:33:09.067337',0,0,0,0,3,13);
INSERT INTO "oneid_meta_userperm" VALUES(121,'5905bd22021c46aba7d51663ad35e22d',0,1,'2020-01-07 12:20:00.092675','2019-11-16 10:33:09.067800',0,0,0,0,4,13);
INSERT INTO "oneid_meta_userperm" VALUES(122,'7bc3b8c9d2524b04baff24ac590d7cd5',0,1,'2020-01-07 12:20:00.101215','2019-11-16 10:33:09.068369',0,0,0,0,5,13);
INSERT INTO "oneid_meta_userperm" VALUES(123,'07b9f873eeaa4700b80df1a93883c0fe',0,1,'2020-01-07 12:20:00.110447','2019-11-16 10:33:09.068810',0,0,0,0,6,13);
INSERT INTO "oneid_meta_userperm" VALUES(124,'c31b33c5f4cb4b37bf2629af5503f052',0,1,'2020-01-07 12:20:00.119104','2019-11-16 10:33:09.069234',0,0,0,0,7,13);
INSERT INTO "oneid_meta_userperm" VALUES(125,'761955e9f8ab41c2a7bb1db587f8f604',0,1,'2020-01-07 12:20:00.128211','2019-11-16 10:33:09.069655',0,0,0,0,8,13);
INSERT INTO "oneid_meta_userperm" VALUES(126,'23e1b3fb04ee4a6cad6f2e4f41b05922',0,1,'2020-01-07 12:20:00.137364','2019-11-16 10:33:09.070077',0,0,0,0,9,13);
INSERT INTO "oneid_meta_userperm" VALUES(127,'addf85b8d5434a5fa1a0180e97d29fc6',0,1,'2020-01-07 12:20:00.146242','2019-11-16 10:33:09.070497',0,0,0,0,10,13);
INSERT INTO "oneid_meta_userperm" VALUES(128,'e087af4ee0464f4dbcf1855e22477a0a',0,1,'2020-01-07 12:20:00.154549','2019-11-16 10:33:09.070915',0,0,0,0,11,13);
INSERT INTO "oneid_meta_userperm" VALUES(129,'54257e3a11a64373995ae8238a698af8',0,1,'2020-01-07 12:20:00.164454','2019-11-16 10:33:09.071335',0,0,0,0,12,13);
INSERT INTO "oneid_meta_userperm" VALUES(130,'dc38cc9e51124478b1e9397d03fed589',0,1,'2020-01-07 12:20:00.173027','2019-11-16 10:33:09.071755',0,0,0,0,13,13);
INSERT INTO "oneid_meta_userperm" VALUES(131,'23846011305e4647a565a7066c7ec29c',0,1,'2020-01-07 12:20:00.181441','2019-11-16 10:33:09.072176',0,0,0,0,14,13);
INSERT INTO "oneid_meta_userperm" VALUES(132,'c8fbe94e94114e268cc2480e569834cf',0,1,'2020-01-07 12:20:00.189933','2019-11-16 10:33:09.072596',0,0,0,0,15,13);
INSERT INTO "oneid_meta_userperm" VALUES(133,'c270452d79244208b0bf787ac709cf1b',0,1,'2020-01-07 12:19:56.263840','2019-12-27 04:08:15.898006',0,0,0,0,3,1);
INSERT INTO "oneid_meta_userperm" VALUES(134,'d80125b3ef444a849bd83d1f03bdb95d',0,1,'2020-01-07 12:19:56.289825','2019-12-27 04:08:15.983827',0,0,0,0,4,1);
INSERT INTO "oneid_meta_userperm" VALUES(135,'ee9d58b3ef3b415da2aa04466c21f09b',0,1,'2020-01-07 12:19:56.313318','2019-12-27 04:08:16.075064',0,0,0,0,5,1);
INSERT INTO "oneid_meta_userperm" VALUES(136,'173173dbb44a481d8c6a3016d23180bc',0,1,'2020-01-07 12:19:56.350686','2019-12-27 04:08:16.168422',0,0,0,0,6,1);
INSERT INTO "oneid_meta_userperm" VALUES(137,'e9003beeb5ac4e10885b0274da97372a',0,1,'2020-01-07 12:19:56.375601','2019-12-27 04:08:16.263764',0,0,0,0,7,1);
INSERT INTO "oneid_meta_userperm" VALUES(138,'dfc2b75fa5264fd6a370466ad6a980ce',0,1,'2020-01-07 12:19:56.397030','2019-12-27 04:08:16.356765',0,0,0,0,8,1);
INSERT INTO "oneid_meta_userperm" VALUES(139,'e98523e5e54640f7ad5b371524b15975',0,1,'2020-01-07 12:19:56.418683','2019-12-27 04:08:16.450720',0,0,0,0,9,1);
INSERT INTO "oneid_meta_userperm" VALUES(140,'5024e81d0a704a69b8d30af52a680663',0,1,'2020-01-07 12:19:56.452340','2019-12-27 04:08:16.558071',0,0,0,0,10,1);
INSERT INTO "oneid_meta_userperm" VALUES(141,'c62dfe0f28fb4e2388e89e2383cfcf15',0,1,'2020-01-07 12:19:56.481757','2019-12-27 04:08:16.666912',0,0,0,0,11,1);
INSERT INTO "oneid_meta_userperm" VALUES(142,'9c78f8e5cdec4241bb04879e147714ae',0,1,'2020-01-07 12:19:57.689102','2019-12-27 04:08:16.670109',0,0,0,0,11,5);
INSERT INTO "oneid_meta_userperm" VALUES(143,'2039b6e6d12d471f813e8c245bccf133',0,1,'2020-01-07 12:19:58.044374','2019-12-27 04:08:16.672181',0,0,0,0,11,6);
INSERT INTO "oneid_meta_userperm" VALUES(144,'bc4d20b8d4c842889df1d82c2d7e8ffc',0,1,'2020-01-07 12:19:58.443771','2019-12-27 04:08:16.674175',0,0,0,0,11,7);
INSERT INTO "oneid_meta_userperm" VALUES(145,'b46fa73c239a4e47a19c60b4c0c9b1ae',0,1,'2020-01-07 12:19:58.779140','2019-12-27 04:08:16.676175',0,0,0,0,11,8);
INSERT INTO "oneid_meta_userperm" VALUES(146,'712bf58ea8da4754b74ee3e97da16715',0,1,'2020-01-07 12:19:59.050770','2019-12-27 04:08:16.678682',0,0,0,0,11,9);
INSERT INTO "oneid_meta_userperm" VALUES(147,'ccb498a69f1f4f038a49db07df64c743',0,1,'2020-01-07 12:19:59.365728','2019-12-27 04:08:16.680745',0,0,0,0,11,10);
INSERT INTO "oneid_meta_userperm" VALUES(148,'faf4529adeaf4e1aa2a2c4e18a04c967',0,1,'2020-01-07 12:19:59.673583','2019-12-27 04:08:16.682760',0,0,0,0,11,11);
INSERT INTO "oneid_meta_userperm" VALUES(149,'650de11c223343c98e65dbab5aafcb65',0,1,'2020-01-07 12:19:59.933344','2019-12-27 04:08:16.684778',0,0,0,0,11,12);
INSERT INTO "oneid_meta_userperm" VALUES(150,'490fbd3cafee499abec8417e867af6c6',0,1,'2020-01-07 12:19:56.545928','2019-12-27 04:08:16.855264',0,0,0,0,12,1);
INSERT INTO "oneid_meta_userperm" VALUES(151,'c60857215da14137bcf6ad6c6af06786',0,1,'2020-01-07 12:19:57.707416','2019-12-27 04:08:16.858759',0,0,0,0,12,5);
INSERT INTO "oneid_meta_userperm" VALUES(152,'9ba2f5312b564aa78815db26652b5718',0,1,'2020-01-07 12:19:58.059729','2019-12-27 04:08:16.860927',0,0,0,0,12,6);
INSERT INTO "oneid_meta_userperm" VALUES(153,'a6a5e2bb80a4496d881dd556bfbb62e4',0,1,'2020-01-07 12:19:58.458752','2019-12-27 04:08:16.863631',0,0,0,0,12,7);
INSERT INTO "oneid_meta_userperm" VALUES(154,'633d016b15014082a4fe4f8439d3d5d2',0,1,'2020-01-07 12:19:58.789012','2019-12-27 04:08:16.865886',0,0,0,0,12,8);
INSERT INTO "oneid_meta_userperm" VALUES(155,'7953d789bd674cb1b194c72b3eae287b',0,1,'2020-01-07 12:19:59.064957','2019-12-27 04:08:16.868080',0,0,0,0,12,9);
INSERT INTO "oneid_meta_userperm" VALUES(156,'6bb199fcdb4648639cddefd650cd9962',0,1,'2020-01-07 12:19:59.378904','2019-12-27 04:08:16.870498',0,0,0,0,12,10);
INSERT INTO "oneid_meta_userperm" VALUES(157,'ee0e75e69b7943a5afb3efc353d0c589',0,1,'2020-01-07 12:19:59.683273','2019-12-27 04:08:16.872503',0,0,0,0,12,11);
INSERT INTO "oneid_meta_userperm" VALUES(158,'a89b7a83ddb74c658c61d4c59e13bcad',0,1,'2020-01-07 12:19:59.945565','2019-12-27 04:08:16.874536',0,0,0,0,12,12);
INSERT INTO "oneid_meta_userperm" VALUES(159,'bd0d7984264546808b0c2aca387cfc63',0,1,'2020-01-07 12:19:56.579770','2019-12-27 04:08:17.047083',0,0,0,0,13,1);
INSERT INTO "oneid_meta_userperm" VALUES(160,'ee24e058907b4f10a2d9b0e96822417a',0,1,'2020-01-07 12:19:57.724746','2019-12-27 04:08:17.049836',0,0,0,0,13,5);
INSERT INTO "oneid_meta_userperm" VALUES(161,'951513bfad1c4890b46bd1a9ec1e0a05',0,1,'2020-01-07 12:19:58.074785','2019-12-27 04:08:17.052042',0,0,0,0,13,6);
INSERT INTO "oneid_meta_userperm" VALUES(162,'1f5269a024cd4988805fdd165473cb90',0,1,'2020-01-07 12:19:58.478631','2019-12-27 04:08:17.054032',0,0,0,0,13,7);
INSERT INTO "oneid_meta_userperm" VALUES(163,'833100badfea4e09a11f1d9c1a1888fe',0,1,'2020-01-07 12:19:58.799242','2019-12-27 04:08:17.056175',0,0,0,0,13,8);
INSERT INTO "oneid_meta_userperm" VALUES(164,'8c3e78ecdf67437c9ba9f71b3b5b20f7',0,1,'2020-01-07 12:19:59.078806','2019-12-27 04:08:17.058195',0,0,0,0,13,9);
INSERT INTO "oneid_meta_userperm" VALUES(165,'9792c0fd12e643f78d1a2941b17a66ad',0,1,'2020-01-07 12:19:59.391213','2019-12-27 04:08:17.060220',0,0,0,0,13,10);
INSERT INTO "oneid_meta_userperm" VALUES(166,'6dafab302cbf4fb9ab385c92177d3cce',0,1,'2020-01-07 12:19:59.697407','2019-12-27 04:08:17.062446',0,0,0,0,13,11);
INSERT INTO "oneid_meta_userperm" VALUES(167,'422a4959029242cd9975aa2bedcd36d2',0,1,'2020-01-07 12:19:59.959453','2019-12-27 04:08:17.064472',0,0,0,0,13,12);
INSERT INTO "oneid_meta_userperm" VALUES(168,'8dc9e06b94204615bfe28ac77b79996b',0,1,'2020-01-07 12:19:56.655061','2019-12-27 04:08:17.267106',0,0,0,0,14,1);
INSERT INTO "oneid_meta_userperm" VALUES(169,'337e1f6420a54486a9d37c9e8816c62e',0,1,'2020-01-07 12:19:57.744182','2019-12-27 04:08:17.269761',0,0,0,0,14,5);
INSERT INTO "oneid_meta_userperm" VALUES(170,'5e54ce6cb8d74673aa2dd4a36a13e770',0,1,'2020-01-07 12:19:58.103120','2019-12-27 04:08:17.271774',0,0,0,0,14,6);
INSERT INTO "oneid_meta_userperm" VALUES(171,'bf55ace9388f4c0188e0e707cd43a88d',0,1,'2020-01-07 12:19:58.513158','2019-12-27 04:08:17.273777',0,0,0,0,14,7);
INSERT INTO "oneid_meta_userperm" VALUES(172,'b570f138437c4d2696124807e6acef0c',0,1,'2020-01-07 12:19:58.819677','2019-12-27 04:08:17.275731',0,0,0,0,14,8);
INSERT INTO "oneid_meta_userperm" VALUES(173,'b319d53ca7564170af9759b711689de6',0,1,'2020-01-07 12:19:59.090585','2019-12-27 04:08:17.278178',0,0,0,0,14,9);
INSERT INTO "oneid_meta_userperm" VALUES(174,'83b8d5eab5914f24ac2d9a29471bddc1',0,1,'2020-01-07 12:19:59.403364','2019-12-27 04:08:17.281136',0,0,0,0,14,10);
INSERT INTO "oneid_meta_userperm" VALUES(175,'a593d7fbc84b409a829aa6f38a8392b2',0,1,'2020-01-07 12:19:59.709327','2019-12-27 04:08:17.283634',0,0,0,0,14,11);
INSERT INTO "oneid_meta_userperm" VALUES(176,'b8d36647a94f4ceca2256f11ff8b107c',0,1,'2020-01-07 12:19:59.970492','2019-12-27 04:08:17.286456',0,0,0,0,14,12);
INSERT INTO "oneid_meta_userperm" VALUES(177,'19677c905ba14d2ab140ebc41fe672cb',0,1,'2020-01-07 12:19:56.707982','2019-12-27 04:08:17.542255',0,0,0,0,15,1);
INSERT INTO "oneid_meta_userperm" VALUES(178,'846ce43ab7dc4502b73035d423f8dc82',0,1,'2020-01-07 12:19:57.758879','2019-12-27 04:08:17.548569',0,0,0,0,15,5);
INSERT INTO "oneid_meta_userperm" VALUES(179,'1660504e8fd94ea6967c815fdc67914c',0,1,'2020-01-07 12:19:58.118482','2019-12-27 04:08:17.551966',0,0,0,0,15,6);
INSERT INTO "oneid_meta_userperm" VALUES(180,'02ef739da60a438db2580b3a2a4262d6',0,1,'2020-01-07 12:19:58.531318','2019-12-27 04:08:17.554543',0,0,0,0,15,7);
INSERT INTO "oneid_meta_userperm" VALUES(181,'b9306bbb8b744d2db1284774dd337f5e',0,1,'2020-01-07 12:19:58.828902','2019-12-27 04:08:17.557273',0,0,0,0,15,8);
INSERT INTO "oneid_meta_userperm" VALUES(182,'43f9e08c72d043d2ae4bb955a809fe31',0,1,'2020-01-07 12:19:59.103151','2019-12-27 04:08:17.559351',0,0,0,0,15,9);
INSERT INTO "oneid_meta_userperm" VALUES(183,'7d2574b1dc0b4ef3a4d2d79f135582e2',0,1,'2020-01-07 12:19:59.419270','2019-12-27 04:08:17.562834',0,0,0,0,15,10);
INSERT INTO "oneid_meta_userperm" VALUES(184,'c44f90b632964697bc19878b687ae930',0,1,'2020-01-07 12:19:59.719872','2019-12-27 04:08:17.567499',0,0,0,0,15,11);
INSERT INTO "oneid_meta_userperm" VALUES(185,'eabff267ef1a4faeae31b7f1fb5b4839',0,1,'2020-01-07 12:19:59.982848','2019-12-27 04:08:17.569993',0,0,0,0,15,12);
INSERT INTO "oneid_meta_userperm" VALUES(186,'39122d4738c442989b6039f90395e0fb',0,1,'2020-01-07 12:19:56.772007','2019-12-27 04:08:17.767824',0,0,0,0,16,1);
INSERT INTO "oneid_meta_userperm" VALUES(187,'802ff74a01604f199e12f8d3d09e93d7',0,1,'2020-01-07 12:19:57.277255','2019-12-27 04:08:17.770484',0,0,0,0,16,4);
INSERT INTO "oneid_meta_userperm" VALUES(188,'867ea62e93304a429331eb5d42976d41',0,1,'2020-01-07 12:19:57.783463','2019-12-27 04:08:17.772498',0,0,0,0,16,5);
INSERT INTO "oneid_meta_userperm" VALUES(189,'e2650ed2c0d247d4a8d36e8df7dc7f9b',0,1,'2020-01-07 12:19:58.131640','2019-12-27 04:08:17.774585',0,0,0,0,16,6);
INSERT INTO "oneid_meta_userperm" VALUES(190,'1fc8ef06d8d14c27b24fbba4c6529807',0,1,'2020-01-07 12:19:58.548951','2019-12-27 04:08:17.776638',0,0,0,0,16,7);
INSERT INTO "oneid_meta_userperm" VALUES(191,'b92013edeb374c989ef711b302573068',0,1,'2020-01-07 12:19:58.839229','2019-12-27 04:08:17.778916',0,0,0,0,16,8);
INSERT INTO "oneid_meta_userperm" VALUES(192,'f69c742b91ac4f309b4030742f0f26c6',0,1,'2020-01-07 12:19:59.131062','2019-12-27 04:08:17.782202',0,0,0,0,16,9);
INSERT INTO "oneid_meta_userperm" VALUES(193,'9b4e8804a9d7460d9439f830d672b654',0,1,'2020-01-07 12:19:59.447717','2019-12-27 04:08:17.784494',0,0,0,0,16,10);
INSERT INTO "oneid_meta_userperm" VALUES(194,'90433ca04e1b4ee8b8835133340f572d',0,1,'2020-01-07 12:19:59.747076','2019-12-27 04:08:17.787008',0,0,0,0,16,11);
INSERT INTO "oneid_meta_userperm" VALUES(195,'9542082f5a8142f5a569ecd39542f041',0,1,'2020-01-07 12:19:59.994672','2019-12-27 04:08:17.789774',0,0,0,0,16,12);
INSERT INTO "oneid_meta_userperm" VALUES(196,'e2b0caa3f60341f5bcd6db6d069342f4',0,1,'2020-01-07 12:20:00.198159','2019-12-27 04:08:17.792753',0,0,0,0,16,13);
INSERT INTO "oneid_meta_userperm" VALUES(197,'c3b0688ff30d47e0b141b464d18a8903',0,1,'2020-01-07 12:19:56.800167','2019-12-27 04:08:18.033046',0,0,0,0,17,1);
INSERT INTO "oneid_meta_userperm" VALUES(198,'2b2dcc22e2e34ec48d5e01067b2ec01d',0,1,'2020-01-07 12:19:57.307723','2019-12-27 04:08:18.035392',0,0,0,0,17,4);
INSERT INTO "oneid_meta_userperm" VALUES(199,'50b5da4016a74aa797cc2cfcbb3a78b9',0,1,'2020-01-07 12:19:57.795976','2019-12-27 04:08:18.037600',0,0,0,0,17,5);
INSERT INTO "oneid_meta_userperm" VALUES(200,'68558612c256431a9a9972e62a4c6feb',0,1,'2020-01-07 12:19:58.145311','2019-12-27 04:08:18.040196',0,0,0,0,17,6);
INSERT INTO "oneid_meta_userperm" VALUES(201,'32bafa6b33a54cc49f92dc089e08a08d',0,1,'2020-01-07 12:19:58.568450','2019-12-27 04:08:18.042400',0,0,0,0,17,7);
INSERT INTO "oneid_meta_userperm" VALUES(202,'6009ffd7ec5c4f42add78eba74e8ffb0',0,1,'2020-01-07 12:19:58.852181','2019-12-27 04:08:18.044420',0,0,0,0,17,8);
INSERT INTO "oneid_meta_userperm" VALUES(203,'54eabc4e2b5a4589a9540648cc2bf309',0,1,'2020-01-07 12:19:59.143094','2019-12-27 04:08:18.047140',0,0,0,0,17,9);
INSERT INTO "oneid_meta_userperm" VALUES(204,'732ca3e5acd44de8a1f50661eb69d209',0,1,'2020-01-07 12:19:59.462124','2019-12-27 04:08:18.050715',0,0,0,0,17,10);
INSERT INTO "oneid_meta_userperm" VALUES(205,'713c380d963445deb73179fd3a3aeb66',0,1,'2020-01-07 12:19:59.760494','2019-12-27 04:08:18.053110',0,0,0,0,17,11);
INSERT INTO "oneid_meta_userperm" VALUES(206,'81745a36a5c64979addf930902577150',0,1,'2020-01-07 12:20:00.006043','2019-12-27 04:08:18.055299',0,0,0,0,17,12);
INSERT INTO "oneid_meta_userperm" VALUES(207,'76ff4ac13e6e4c9fbf3ebed9d8c43022',0,1,'2020-01-07 12:20:00.206496','2019-12-27 04:08:18.057630',0,0,0,0,17,13);
INSERT INTO "oneid_meta_userperm" VALUES(208,'a91953725ac7477bbf280ffdcedbe410',0,1,'2020-01-07 12:19:56.857941','2019-12-27 04:08:18.275334',0,0,0,0,18,1);
INSERT INTO "oneid_meta_userperm" VALUES(209,'197644f2a8d4458d98838c3a945c232d',0,1,'2020-01-07 12:19:57.325162','2019-12-27 04:08:18.277889',0,0,0,0,18,4);
INSERT INTO "oneid_meta_userperm" VALUES(210,'d205efac96a041cfb5264e85b0c5b04c',0,1,'2020-01-07 12:19:57.809607','2019-12-27 04:08:18.281116',0,0,0,0,18,5);
INSERT INTO "oneid_meta_userperm" VALUES(211,'01002c0d7d5b45c7a15dfc26db62397f',0,1,'2020-01-07 12:19:58.157928','2019-12-27 04:08:18.283873',0,0,0,0,18,6);
INSERT INTO "oneid_meta_userperm" VALUES(212,'7375d246386e4b6cb2d7c12a49461602',0,1,'2020-01-07 12:19:58.584434','2019-12-27 04:08:18.286181',0,0,0,0,18,7);
INSERT INTO "oneid_meta_userperm" VALUES(213,'09c06fe71b2344ae8906731be95c1398',0,1,'2020-01-07 12:19:58.862660','2019-12-27 04:08:18.289158',0,0,0,0,18,8);
INSERT INTO "oneid_meta_userperm" VALUES(214,'a7ce0b8bbb2c48999a3faa4c9b64e5d3',0,1,'2020-01-07 12:19:59.152592','2019-12-27 04:08:18.291600',0,0,0,0,18,9);
INSERT INTO "oneid_meta_userperm" VALUES(215,'3e70a0af61ec4554a9830162ff286aa7',0,1,'2020-01-07 12:19:59.475694','2019-12-27 04:08:18.293893',0,0,0,0,18,10);
INSERT INTO "oneid_meta_userperm" VALUES(216,'d2af60637ab64b6dbfdd97edfdb5313b',0,1,'2020-01-07 12:19:59.770855','2019-12-27 04:08:18.296573',0,0,0,0,18,11);
INSERT INTO "oneid_meta_userperm" VALUES(217,'2bd5d6b62bf1426cb35e8a355c590196',0,1,'2020-01-07 12:20:00.018810','2019-12-27 04:08:18.299675',0,0,0,0,18,12);
INSERT INTO "oneid_meta_userperm" VALUES(218,'1d0813358b7b42a09b3a653ae7918f58',0,1,'2020-01-07 12:20:00.214719','2019-12-27 04:08:18.302222',0,0,0,0,18,13);
INSERT INTO "oneid_meta_userperm" VALUES(219,'e5c063f25e29426187c9d0719ed905b4',0,1,'2020-01-07 12:19:56.899471','2019-12-27 04:08:18.503731',0,0,0,0,19,1);
INSERT INTO "oneid_meta_userperm" VALUES(220,'a4d21a933cf04bb9a713c6ccbcb39093',0,1,'2020-01-07 12:19:57.340585','2019-12-27 04:08:18.505736',0,0,0,0,19,4);
INSERT INTO "oneid_meta_userperm" VALUES(221,'05f172d4fe9a47be878e564e8cfbd21c',0,1,'2020-01-07 12:19:57.823317','2019-12-27 04:08:18.507690',0,0,0,0,19,5);
INSERT INTO "oneid_meta_userperm" VALUES(222,'ecf19daab353498aa3b830fb70b11409',0,1,'2020-01-07 12:19:58.174748','2019-12-27 04:08:18.509709',0,0,0,0,19,6);
INSERT INTO "oneid_meta_userperm" VALUES(223,'d04b6fbb83274cb296840224900d4d52',0,1,'2020-01-07 12:19:58.619692','2019-12-27 04:08:18.511930',0,0,0,0,19,7);
INSERT INTO "oneid_meta_userperm" VALUES(224,'06b1298988c3498689e099e40f266fc3',0,1,'2020-01-07 12:19:58.874672','2019-12-27 04:08:18.513896',0,0,0,0,19,8);
INSERT INTO "oneid_meta_userperm" VALUES(225,'a0adc6ec3ea447bbbeafa07db7e199f2',0,1,'2020-01-07 12:19:59.162356','2019-12-27 04:08:18.515992',0,0,0,0,19,9);
INSERT INTO "oneid_meta_userperm" VALUES(226,'4bc64d97797749ac8ce2194c6cf439e4',0,1,'2020-01-07 12:19:59.486539','2019-12-27 04:08:18.518257',0,0,0,0,19,10);
INSERT INTO "oneid_meta_userperm" VALUES(227,'45543071e5594f56a9910bc309ab4fb8',0,1,'2020-01-07 12:19:59.783230','2019-12-27 04:08:18.520226',0,0,0,0,19,11);
INSERT INTO "oneid_meta_userperm" VALUES(228,'b49ea5621c0148d29638bf44ae86022d',0,1,'2020-01-07 12:20:00.030412','2019-12-27 04:08:18.522424',0,0,0,0,19,12);
INSERT INTO "oneid_meta_userperm" VALUES(229,'e2c8ed9e321d48ed9a2050c9ec34f2e6',0,1,'2020-01-07 12:20:00.222744','2019-12-27 04:08:18.524772',0,0,0,0,19,13);
INSERT INTO "oneid_meta_userperm" VALUES(230,'cf41073259704251a91367d58536febc',0,1,'2020-01-07 12:19:56.924283','2019-12-27 04:08:18.809657',0,0,0,0,20,1);
INSERT INTO "oneid_meta_userperm" VALUES(231,'32e2880345e74078a2a8c5b47bdb6c67',0,1,'2020-01-07 12:19:57.370039','2019-12-27 04:08:18.812119',1,1,1,0,20,4);
INSERT INTO "oneid_meta_userperm" VALUES(232,'1ed4a9e38696414f9f3ef1d264446fc9',0,1,'2020-01-07 12:19:57.837220','2019-12-27 04:08:18.815469',0,0,0,0,20,5);
INSERT INTO "oneid_meta_userperm" VALUES(233,'9a1ec3968333486bbdebe3a4438324cc',0,1,'2020-01-07 12:19:58.204330','2019-12-27 04:08:18.819553',0,0,0,0,20,6);
INSERT INTO "oneid_meta_userperm" VALUES(234,'966c9e93d03a4a4dabbfd96736e7ca46',0,1,'2020-01-07 12:19:58.635754','2019-12-27 04:08:18.822570',0,0,0,0,20,7);
INSERT INTO "oneid_meta_userperm" VALUES(235,'9bbdbb7e060f49feaff00f047b6a58d2',0,1,'2020-01-07 12:19:58.884183','2019-12-27 04:08:18.827356',0,0,0,0,20,8);
INSERT INTO "oneid_meta_userperm" VALUES(236,'4b35e98289b048ff82f825d999b3949e',0,1,'2020-01-07 12:19:59.171708','2019-12-27 04:08:18.830137',-1,0,1,0,20,9);
INSERT INTO "oneid_meta_userperm" VALUES(237,'8aa5647c40a44b0a9451be397f3f65b1',0,1,'2020-01-07 12:19:59.498926','2019-12-27 04:08:18.833910',0,1,1,0,20,10);
INSERT INTO "oneid_meta_userperm" VALUES(238,'447a934da1784b8f8d8d5f7b0885a6e6',0,1,'2020-01-07 12:19:59.795176','2019-12-27 04:08:18.836254',0,1,1,0,20,11);
INSERT INTO "oneid_meta_userperm" VALUES(239,'24bad53855de486ea78f4be4dabc6db7',0,1,'2020-01-07 12:20:00.041039','2019-12-27 04:08:18.838749',0,1,1,0,20,12);
INSERT INTO "oneid_meta_userperm" VALUES(240,'c2fd06325dc149ac8f4322ce58b6db9f',0,1,'2020-01-07 12:20:00.231508','2019-12-27 04:08:18.841007',0,1,1,0,20,13);
INSERT INTO "oneid_meta_userperm" VALUES(241,'0713643fb03140b482e0092952b6d342',0,1,'2020-01-07 12:19:56.970539','2019-12-27 04:08:19.129723',0,0,0,0,21,1);
INSERT INTO "oneid_meta_userperm" VALUES(242,'6c9010b835a34cfc99314613d8b16ffd',0,1,'2020-01-07 12:19:57.388783','2019-12-27 04:08:19.133947',0,0,0,0,21,4);
INSERT INTO "oneid_meta_userperm" VALUES(243,'669e9cfcfc8a428a8a819bd91b43c2ae',0,1,'2020-01-07 12:19:57.850077','2019-12-27 04:08:19.136240',0,0,0,0,21,5);
INSERT INTO "oneid_meta_userperm" VALUES(244,'bf312a7bcfa24612b4ca7af754ca002c',0,1,'2020-01-07 12:19:58.225285','2019-12-27 04:08:19.138431',0,0,0,0,21,6);
INSERT INTO "oneid_meta_userperm" VALUES(245,'087d2e8f71cc49049b67328c7a738bf4',0,1,'2020-01-07 12:19:58.650052','2019-12-27 04:08:19.140646',0,0,0,0,21,7);
INSERT INTO "oneid_meta_userperm" VALUES(246,'4bbeda7463a6484d972f6c72a195afc6',0,1,'2020-01-07 12:19:58.895619','2019-12-27 04:08:19.143098',0,0,0,0,21,8);
INSERT INTO "oneid_meta_userperm" VALUES(247,'bf4262dca4a04ed6b347cccc9cfc824d',0,1,'2020-01-07 12:19:59.181904','2019-12-27 04:08:19.145124',0,0,0,0,21,9);
INSERT INTO "oneid_meta_userperm" VALUES(248,'dd2af19b0da2455c9b7646ab3e3fadaa',0,1,'2020-01-07 12:19:59.511043','2019-12-27 04:08:19.147825',0,0,0,0,21,10);
INSERT INTO "oneid_meta_userperm" VALUES(249,'c1c202a0da124e55a0cba76d777d268d',0,1,'2020-01-07 12:19:59.805545','2019-12-27 04:08:19.151275',0,0,0,0,21,11);
INSERT INTO "oneid_meta_userperm" VALUES(250,'d31ecaeab03846dfa07efd3e0e95d302',0,1,'2020-01-07 12:20:00.052005','2019-12-27 04:08:19.154242',0,0,0,0,21,12);
INSERT INTO "oneid_meta_userperm" VALUES(251,'84c84cddd0974265a7f615cfe9090258',0,1,'2020-01-07 12:20:00.241062','2019-12-27 04:08:19.156276',0,0,0,0,21,13);
INSERT INTO "oneid_meta_userperm" VALUES(273,'0f9ce3b1b4ba4d65a10d17175f60acb3',0,1,'2020-01-07 12:20:00.252094','2019-12-27 11:01:43.264054',0,0,0,0,1,15);
INSERT INTO "oneid_meta_userperm" VALUES(274,'786ad0161f484335a6ed756882f0f1f4',0,1,'2020-01-07 12:20:00.263849','2019-12-27 11:01:43.266224',0,0,0,0,2,15);
INSERT INTO "oneid_meta_userperm" VALUES(275,'397dc1c919cc43f99886d08905a448c1',0,1,'2020-01-07 12:20:00.277301','2019-12-27 11:01:43.268447',0,0,0,0,3,15);
INSERT INTO "oneid_meta_userperm" VALUES(276,'d9bef1ab8b904a83932efacb914b1ffa',0,1,'2020-01-07 12:20:00.289284','2019-12-27 11:01:43.270526',0,0,0,0,4,15);
INSERT INTO "oneid_meta_userperm" VALUES(277,'cd9e728cfe284eea8280095b968a4668',0,1,'2020-01-07 12:20:00.300026','2019-12-27 11:01:43.271999',0,0,0,0,5,15);
INSERT INTO "oneid_meta_userperm" VALUES(278,'b86d59cdb08c4ba1912632247242d350',0,1,'2020-01-07 12:20:00.309970','2019-12-27 11:01:43.273681',0,0,0,0,6,15);
INSERT INTO "oneid_meta_userperm" VALUES(279,'b306e9eac41c48ab870b099eccaca45a',0,1,'2020-01-07 12:20:00.320057','2019-12-27 11:01:43.275587',0,0,0,0,7,15);
INSERT INTO "oneid_meta_userperm" VALUES(280,'64ba71cdf1a8434aac8aefd9ed850093',0,1,'2020-01-07 12:20:00.330672','2019-12-27 11:01:43.277040',0,0,0,0,8,15);
INSERT INTO "oneid_meta_userperm" VALUES(281,'0c72958e52e1433aa6d93f90f19e4f39',0,1,'2020-01-07 12:20:00.341627','2019-12-27 11:01:43.278581',0,0,0,0,9,15);
INSERT INTO "oneid_meta_userperm" VALUES(282,'f627bb8537144eb0b000cf25647d77e7',0,1,'2020-01-07 12:20:00.351833','2019-12-27 11:01:43.280205',0,0,0,0,10,15);
INSERT INTO "oneid_meta_userperm" VALUES(283,'68b0ef8422484ebf9e487487d8531b87',0,1,'2020-01-07 12:20:00.362620','2019-12-27 11:01:43.281461',0,0,0,0,11,15);
INSERT INTO "oneid_meta_userperm" VALUES(284,'c05e6d4b47d34980840338b29d69fb12',0,1,'2020-01-07 12:20:00.373012','2019-12-27 11:01:43.283031',0,0,0,0,12,15);
INSERT INTO "oneid_meta_userperm" VALUES(285,'ea51c4d395f4499f931c586c6993e2d6',0,1,'2020-01-07 12:20:00.383635','2019-12-27 11:01:43.284687',0,0,0,0,13,15);
INSERT INTO "oneid_meta_userperm" VALUES(286,'3baca0aaccec4fb28f8688600719eb43',0,1,'2020-01-07 12:20:00.394961','2019-12-27 11:01:43.286102',0,0,0,0,14,15);
INSERT INTO "oneid_meta_userperm" VALUES(287,'1c5973c9965d4bd196ab31f4094acb11',0,1,'2020-01-07 12:20:00.404813','2019-12-27 11:01:43.287429',0,0,0,0,15,15);
INSERT INTO "oneid_meta_userperm" VALUES(288,'aa8745bc34ed4b13a0576758add52c84',0,1,'2020-01-07 12:20:00.415961','2019-12-27 11:01:43.288673',0,0,0,0,16,15);
INSERT INTO "oneid_meta_userperm" VALUES(289,'2871b970f68947779e8defa32cd1063e',0,1,'2020-01-07 12:20:00.427215','2019-12-27 11:01:43.290032',0,0,0,0,17,15);
INSERT INTO "oneid_meta_userperm" VALUES(290,'57dfeaa4693f47d3946b1a7296a54ff4',0,1,'2020-01-07 12:20:00.437609','2019-12-27 11:01:43.291427',0,0,0,0,18,15);
INSERT INTO "oneid_meta_userperm" VALUES(291,'4d29249fef854237bc30fb4ecded99df',0,1,'2020-01-07 12:20:00.456757','2019-12-27 11:01:43.292676',0,0,0,0,19,15);
INSERT INTO "oneid_meta_userperm" VALUES(292,'46c31132e5bc458194b0b3a3b25ccdc2',0,1,'2020-01-07 12:20:00.468438','2019-12-27 11:01:43.294095',0,0,0,0,20,15);
INSERT INTO "oneid_meta_userperm" VALUES(293,'6f76169b97ca4f79b8a03576ec588aca',0,1,'2020-01-07 12:20:00.478579','2019-12-27 11:01:43.295545',0,0,0,0,21,15);
INSERT INTO "oneid_meta_userperm" VALUES(294,'d1a17e09d5c34ad290fde2c903d6696d',0,1,'2020-01-07 12:20:00.488113','2019-12-27 11:02:13.106148',0,0,0,0,1,16);
INSERT INTO "oneid_meta_userperm" VALUES(295,'b7142c6859704748b55a0b0ee9f644d7',0,1,'2020-01-07 12:20:00.498661','2019-12-27 11:02:13.108195',0,0,0,0,2,16);
INSERT INTO "oneid_meta_userperm" VALUES(296,'530e39166443492b8d5b47bf0f912ca8',0,1,'2020-01-07 12:20:00.508910','2019-12-27 11:02:13.109820',0,0,0,0,3,16);
INSERT INTO "oneid_meta_userperm" VALUES(297,'ccb90cfc1273462089c77de39e8fc155',0,1,'2020-01-07 12:20:00.519971','2019-12-27 11:02:13.111259',0,0,0,0,4,16);
INSERT INTO "oneid_meta_userperm" VALUES(298,'7fe3a269490845b280cd74006a8efe15',0,1,'2020-01-07 12:20:00.531545','2019-12-27 11:02:13.112733',0,0,0,0,5,16);
INSERT INTO "oneid_meta_userperm" VALUES(299,'f4db3a7626b74484a6eef7427d276c6a',0,1,'2020-01-07 12:20:00.542244','2019-12-27 11:02:13.114021',0,0,0,0,6,16);
INSERT INTO "oneid_meta_userperm" VALUES(300,'55612d1333b44ed693873f913afb6069',0,1,'2020-01-07 12:20:00.569926','2019-12-27 11:02:13.115365',0,0,0,0,7,16);
INSERT INTO "oneid_meta_userperm" VALUES(301,'81a0c71a9216478c97a76edcfdec0973',0,1,'2020-01-07 12:20:00.587959','2019-12-27 11:02:13.116653',0,0,0,0,8,16);
INSERT INTO "oneid_meta_userperm" VALUES(302,'6dbbe8cc87df4fafad702efcc1198a44',0,1,'2020-01-07 12:20:00.607560','2019-12-27 11:02:13.117935',0,0,0,0,9,16);
INSERT INTO "oneid_meta_userperm" VALUES(303,'668e58291a4d4ddc951de9a05b2b31fc',0,1,'2020-01-07 12:20:00.619027','2019-12-27 11:02:13.119857',0,0,0,0,10,16);
INSERT INTO "oneid_meta_userperm" VALUES(304,'f4f60e6d27254ab0a17cb54228bdb1b5',0,1,'2020-01-07 12:20:00.635045','2019-12-27 11:02:13.121366',0,0,0,0,11,16);
INSERT INTO "oneid_meta_userperm" VALUES(305,'16e6e7080f264f51912c57c97a6dc6fb',0,1,'2020-01-07 12:20:00.650276','2019-12-27 11:02:13.123468',0,0,0,0,12,16);
INSERT INTO "oneid_meta_userperm" VALUES(306,'21420002770b4b62a65fffd72daae617',0,1,'2020-01-07 12:20:00.680879','2019-12-27 11:02:13.124856',0,0,0,0,13,16);
INSERT INTO "oneid_meta_userperm" VALUES(307,'8b0335563f2f4cc894991489cb479719',0,1,'2020-01-07 12:20:00.691623','2019-12-27 11:02:13.126158',0,0,0,0,14,16);
INSERT INTO "oneid_meta_userperm" VALUES(308,'d5fcc276d7a7431480dd9c4d14045bb3',0,1,'2020-01-07 12:20:00.702676','2019-12-27 11:02:13.127448',0,0,0,0,15,16);
INSERT INTO "oneid_meta_userperm" VALUES(309,'2cbd1c9d043745e9ad191aa994a5ca9e',0,1,'2020-01-07 12:20:00.718291','2019-12-27 11:02:13.128763',0,0,0,0,16,16);
INSERT INTO "oneid_meta_userperm" VALUES(310,'5ad41fef0d2c4b35b91a35517883dfb0',0,1,'2020-01-07 12:20:00.743223','2019-12-27 11:02:13.130030',0,0,0,0,17,16);
INSERT INTO "oneid_meta_userperm" VALUES(311,'bdfcb066b9954279a2a49e944b6cabda',0,1,'2020-01-07 12:20:00.768958','2019-12-27 11:02:13.131510',0,0,0,0,18,16);
INSERT INTO "oneid_meta_userperm" VALUES(312,'2eeaf80a2842447281ee8aba81e3c03c',0,1,'2020-01-07 12:20:00.784914','2019-12-27 11:02:13.132808',0,0,0,0,19,16);
INSERT INTO "oneid_meta_userperm" VALUES(313,'2f80a3d159064f0f9d22b18eb12398a0',0,1,'2020-01-07 12:20:00.803697','2019-12-27 11:02:13.134151',0,0,0,0,20,16);
INSERT INTO "oneid_meta_userperm" VALUES(314,'24adfc2551ae4ddaabc9df00450c167c',0,1,'2020-01-07 12:20:00.817120','2019-12-27 11:02:13.135612',0,0,0,0,21,16);
INSERT INTO "oneid_meta_userperm" VALUES(315,'6c48a65b6c884dfc8121b09c8b82f297',0,1,'2020-01-07 12:20:00.828466','2019-12-27 11:02:34.633061',0,0,0,0,1,17);
INSERT INTO "oneid_meta_userperm" VALUES(316,'db584f7d12ce4ffe98823f31a3be99f9',0,1,'2020-01-07 12:20:00.839650','2019-12-27 11:02:34.635121',0,0,0,0,2,17);
INSERT INTO "oneid_meta_userperm" VALUES(317,'9b37d13ce20d49729ff1abc730ce3450',0,1,'2020-01-07 12:20:00.850973','2019-12-27 11:02:34.637440',0,0,0,0,3,17);
INSERT INTO "oneid_meta_userperm" VALUES(318,'b511e45f971145e9962ba8a92a60baa1',0,1,'2020-01-07 12:20:00.877469','2019-12-27 11:02:34.639261',0,0,0,0,4,17);
INSERT INTO "oneid_meta_userperm" VALUES(319,'2c6d38a4d8ee4ac58341fb23bb2089d8',0,1,'2020-01-07 12:20:00.891425','2019-12-27 11:02:34.640995',0,0,0,0,5,17);
INSERT INTO "oneid_meta_userperm" VALUES(320,'2300dc4ffaa74dd98d52bc2349907186',0,1,'2020-01-07 12:20:00.907626','2019-12-27 11:02:34.642291',0,0,0,0,6,17);
INSERT INTO "oneid_meta_userperm" VALUES(321,'4fe59a9f97bc4d239af6a7a1ddc4e377',0,1,'2020-01-07 12:20:00.918821','2019-12-27 11:02:34.644172',0,0,0,0,7,17);
INSERT INTO "oneid_meta_userperm" VALUES(322,'6a9de9154df243179e923ef4ccae1d5c',0,1,'2020-01-07 12:20:00.929420','2019-12-27 11:02:34.645927',0,0,0,0,8,17);
INSERT INTO "oneid_meta_userperm" VALUES(323,'e73aa6f2f62d4b609a08705693cd088c',0,1,'2020-01-07 12:20:00.942042','2019-12-27 11:02:34.647812',0,0,0,0,9,17);
INSERT INTO "oneid_meta_userperm" VALUES(324,'62c71ac4a75944f5a0297b707ab8a9bd',0,1,'2020-01-07 12:20:00.959459','2019-12-27 11:02:34.649507',0,0,0,0,10,17);
INSERT INTO "oneid_meta_userperm" VALUES(325,'89ff996619f346d5a3db7d4029169c38',0,1,'2020-01-07 12:20:00.988918','2019-12-27 11:02:34.650986',0,0,0,0,11,17);
INSERT INTO "oneid_meta_userperm" VALUES(326,'9246ce8b30d842f2a0918c91c3b8ee92',0,1,'2020-01-07 12:20:00.999993','2019-12-27 11:02:34.652560',0,0,0,0,12,17);
INSERT INTO "oneid_meta_userperm" VALUES(327,'80d068256f734b42836c63796034c41d',0,1,'2020-01-07 12:20:01.012388','2019-12-27 11:02:34.654299',0,0,0,0,13,17);
INSERT INTO "oneid_meta_userperm" VALUES(328,'6047251540734f56be07b617631ff53c',0,1,'2020-01-07 12:20:01.024458','2019-12-27 11:02:34.655608',0,0,0,0,14,17);
INSERT INTO "oneid_meta_userperm" VALUES(329,'5804a04b1950445abff731b659f7cae4',0,1,'2020-01-07 12:20:01.036093','2019-12-27 11:02:34.657433',0,0,0,0,15,17);
INSERT INTO "oneid_meta_userperm" VALUES(330,'2bf4e80232e14765ad6f07e0a3e09fdf',0,1,'2020-01-07 12:20:01.048160','2019-12-27 11:02:34.659018',0,0,0,0,16,17);
INSERT INTO "oneid_meta_userperm" VALUES(331,'7ca0850106dd4335b5e1bab381c189c5',0,1,'2020-01-07 12:20:01.070883','2019-12-27 11:02:34.660542',0,0,0,0,17,17);
INSERT INTO "oneid_meta_userperm" VALUES(332,'404d200d8cce49fea1041f414e512613',0,1,'2020-01-07 12:20:01.083301','2019-12-27 11:02:34.661795',0,0,0,0,18,17);
INSERT INTO "oneid_meta_userperm" VALUES(333,'a61b02ac0176473ab2f21b939bd020a9',0,1,'2020-01-07 12:20:01.094966','2019-12-27 11:02:34.663108',0,0,0,0,19,17);
INSERT INTO "oneid_meta_userperm" VALUES(334,'feac24d76fd24278a8824f3a379e0a04',0,1,'2020-01-07 12:20:01.108639','2019-12-27 11:02:34.664641',0,0,0,0,20,17);
INSERT INTO "oneid_meta_userperm" VALUES(335,'e9515947c6a44ea4908c2e799875e575',0,1,'2020-01-07 12:20:01.119487','2019-12-27 11:02:34.665960',0,0,0,0,21,17);
INSERT INTO "oneid_meta_userperm" VALUES(336,'64ea4ba79b89491aaf767fd278a5ac87',0,1,'2020-01-07 12:20:01.130860','2019-12-27 11:02:53.212733',0,0,0,0,1,18);
INSERT INTO "oneid_meta_userperm" VALUES(337,'8577d13cab344ea7895175d0aeb88242',0,1,'2020-01-07 12:20:01.147225','2019-12-27 11:02:53.214490',0,0,0,0,2,18);
INSERT INTO "oneid_meta_userperm" VALUES(338,'3ef9e9a2f27a404e8a09b4e9c636cae4',0,1,'2020-01-07 12:20:01.178758','2019-12-27 11:02:53.216338',0,0,0,0,3,18);
INSERT INTO "oneid_meta_userperm" VALUES(339,'1bd28f21ad37431abf00ff07babffe04',0,1,'2020-01-07 12:20:01.193487','2019-12-27 11:02:53.218257',0,0,0,0,4,18);
INSERT INTO "oneid_meta_userperm" VALUES(340,'369ade4346ee49fcb8a6945891a4a837',0,1,'2020-01-07 12:20:01.203976','2019-12-27 11:02:53.219751',0,0,0,0,5,18);
INSERT INTO "oneid_meta_userperm" VALUES(341,'3d04c4e968254e6b8c090211bfc8a0f1',0,1,'2020-01-07 12:20:01.215846','2019-12-27 11:02:53.221002',0,0,0,0,6,18);
INSERT INTO "oneid_meta_userperm" VALUES(342,'cc1d8be9ae6b4ad680cf6ea79f692d72',0,1,'2020-01-07 12:20:01.228026','2019-12-27 11:02:53.222273',0,0,0,0,7,18);
INSERT INTO "oneid_meta_userperm" VALUES(343,'1ae90fe261dc487783adb5cd13a3228e',0,1,'2020-01-07 12:20:01.238168','2019-12-27 11:02:53.223541',0,0,0,0,8,18);
INSERT INTO "oneid_meta_userperm" VALUES(344,'89c76845943349b3bbf4ae35f3920a9f',0,1,'2020-01-07 12:20:01.252291','2019-12-27 11:02:53.224979',0,0,0,0,9,18);
INSERT INTO "oneid_meta_userperm" VALUES(345,'7c99f896abd34878921762701561f8a7',0,1,'2020-01-07 12:20:01.281186','2019-12-27 11:02:53.226280',0,0,0,0,10,18);
INSERT INTO "oneid_meta_userperm" VALUES(346,'2499051ac535490195b45b8fb3b9d6ec',0,1,'2020-01-07 12:20:01.294109','2019-12-27 11:02:53.227553',0,0,0,0,11,18);
INSERT INTO "oneid_meta_userperm" VALUES(347,'fc643c80e9a7469fbcbb1b19a6f0b4e9',0,1,'2020-01-07 12:20:01.304310','2019-12-27 11:02:53.228855',0,0,0,0,12,18);
INSERT INTO "oneid_meta_userperm" VALUES(348,'e8a1a95f6afe414eac8034faba35036c',0,1,'2020-01-07 12:20:01.317819','2019-12-27 11:02:53.230249',0,0,0,0,13,18);
INSERT INTO "oneid_meta_userperm" VALUES(349,'480de443705b44d1a5680adacd69c566',0,1,'2020-01-07 12:20:01.331738','2019-12-27 11:02:53.231507',0,0,0,0,14,18);
INSERT INTO "oneid_meta_userperm" VALUES(350,'bde05ddd9aa9494e88b4eb6596cb0cad',0,1,'2020-01-07 12:20:01.346576','2019-12-27 11:02:53.233449',0,0,0,0,15,18);
INSERT INTO "oneid_meta_userperm" VALUES(351,'56fe26aa0e16472dad6a2bb59ed4a98f',0,1,'2020-01-07 12:20:01.361957','2019-12-27 11:02:53.234836',0,0,0,0,16,18);
INSERT INTO "oneid_meta_userperm" VALUES(352,'6b1ebbd98ad641a8aaf830c0e158be24',0,1,'2020-01-07 12:20:01.390759','2019-12-27 11:02:53.236267',0,0,0,0,17,18);
INSERT INTO "oneid_meta_userperm" VALUES(353,'a9ff6cd7c3af443496999ae41415670c',0,1,'2020-01-07 12:20:01.406778','2019-12-27 11:02:53.237509',0,0,0,0,18,18);
INSERT INTO "oneid_meta_userperm" VALUES(354,'4dbb9ad59a4b4f808d686c3761079dad',0,1,'2020-01-07 12:20:01.419058','2019-12-27 11:02:53.238829',0,0,0,0,19,18);
INSERT INTO "oneid_meta_userperm" VALUES(355,'43bd7f840be74d89a28ae37a85678b0e',0,1,'2020-01-07 12:20:01.432516','2019-12-27 11:02:53.240194',0,0,0,0,20,18);
INSERT INTO "oneid_meta_userperm" VALUES(356,'7855e12b8ba84ab0ae1d3de1824745bb',0,1,'2020-01-07 12:20:01.447917','2019-12-27 11:02:53.241580',0,0,0,0,21,18);
INSERT INTO "oneid_meta_userperm" VALUES(357,'a17fb5b6948445fe8040660df187e87e',0,1,'2020-01-07 12:20:01.461887','2019-12-27 11:03:10.727413',0,0,0,0,1,19);
INSERT INTO "oneid_meta_userperm" VALUES(358,'83e8f0d6f9a24c628c506afbdf1ba80a',0,1,'2020-01-07 12:20:01.478651','2019-12-27 11:03:10.729930',0,0,0,0,2,19);
INSERT INTO "oneid_meta_userperm" VALUES(359,'eaa612a47e674b9fbed0400ed948d085',0,1,'2020-01-07 12:20:01.493697','2019-12-27 11:03:10.732487',0,0,0,0,3,19);
INSERT INTO "oneid_meta_userperm" VALUES(360,'26bb7d5e68f8439d9b6ceb410c743cfe',0,1,'2020-01-07 12:20:01.505443','2019-12-27 11:03:10.734003',0,0,0,0,4,19);
INSERT INTO "oneid_meta_userperm" VALUES(361,'144105e875bf450a80bb3519042f7310',0,1,'2020-01-07 12:20:01.516869','2019-12-27 11:03:10.735902',0,0,0,0,5,19);
INSERT INTO "oneid_meta_userperm" VALUES(362,'1c003d9a40114066be76640353503e40',0,1,'2020-01-07 12:20:01.528236','2019-12-27 11:03:10.737448',0,0,0,0,6,19);
INSERT INTO "oneid_meta_userperm" VALUES(363,'60b70f98b2ed4759995547bf5681ceb9',0,1,'2020-01-07 12:20:01.539745','2019-12-27 11:03:10.738800',0,0,0,0,7,19);
INSERT INTO "oneid_meta_userperm" VALUES(364,'1e3d609d2e854494ba500d7d6da8487f',0,1,'2020-01-07 12:20:01.549996','2019-12-27 11:03:10.740024',0,0,0,0,8,19);
INSERT INTO "oneid_meta_userperm" VALUES(365,'581652b37d554833b861caad69d689e7',0,1,'2020-01-07 12:20:01.563460','2019-12-27 11:03:10.741463',0,0,0,0,9,19);
INSERT INTO "oneid_meta_userperm" VALUES(366,'9e9e9e85e4644537b966eb0720b89014',0,1,'2020-01-07 12:20:01.574234','2019-12-27 11:03:10.742744',0,0,0,0,10,19);
INSERT INTO "oneid_meta_userperm" VALUES(367,'a1d1367e90704b769f2e477750cfab03',0,1,'2020-01-07 12:20:01.591929','2019-12-27 11:03:10.744061',0,0,0,0,11,19);
INSERT INTO "oneid_meta_userperm" VALUES(368,'c8f095950c5a4a35a95eb010bac2b341',0,1,'2020-01-07 12:20:01.604686','2019-12-27 11:03:10.746145',0,0,0,0,12,19);
INSERT INTO "oneid_meta_userperm" VALUES(369,'445cb8bf9ec54a5d8a92a9227f214c72',0,1,'2020-01-07 12:20:01.615063','2019-12-27 11:03:10.748195',0,0,0,0,13,19);
INSERT INTO "oneid_meta_userperm" VALUES(370,'042ff02f9c8047c79025db2d6c4f843b',0,1,'2020-01-07 12:20:01.624951','2019-12-27 11:03:10.749565',0,0,0,0,14,19);
INSERT INTO "oneid_meta_userperm" VALUES(371,'dd0c5a75fdd14797922b1a52667fdf89',0,1,'2020-01-07 12:20:01.636963','2019-12-27 11:03:10.750841',0,0,0,0,15,19);
INSERT INTO "oneid_meta_userperm" VALUES(372,'710397c063544c7c88661af0a4af4f0f',0,1,'2020-01-07 12:20:01.647602','2019-12-27 11:03:10.752348',0,0,0,0,16,19);
INSERT INTO "oneid_meta_userperm" VALUES(373,'9ff16b6a53b64b2cbd976de4b57acbc7',0,1,'2020-01-07 12:20:01.657776','2019-12-27 11:03:10.753689',0,0,0,0,17,19);
INSERT INTO "oneid_meta_userperm" VALUES(374,'30f7ffbd16804f58ad74807701d04152',0,1,'2020-01-07 12:20:01.668145','2019-12-27 11:03:10.755110',0,0,0,0,18,19);
INSERT INTO "oneid_meta_userperm" VALUES(375,'e97b7e61caa741c0bcac30910c46a5fa',0,1,'2020-01-07 12:20:01.695670','2019-12-27 11:03:10.756381',0,0,0,0,19,19);
INSERT INTO "oneid_meta_userperm" VALUES(376,'a3a25ef582424bac9bcc53f9b305e606',0,1,'2020-01-07 12:20:01.706100','2019-12-27 11:03:10.757779',0,0,0,0,20,19);
INSERT INTO "oneid_meta_userperm" VALUES(377,'890f63d8965e424fb3f408a09ae22189',0,1,'2020-01-07 12:20:01.716457','2019-12-27 11:03:10.759045',0,0,0,0,21,19);
INSERT INTO "oneid_meta_userperm" VALUES(378,'8d39b237701f4b128401429f5ae2a13d',0,1,'2020-01-07 12:20:01.728276','2019-12-27 11:03:32.540185',0,0,0,0,1,20);
INSERT INTO "oneid_meta_userperm" VALUES(379,'6db25df963624708b2d5036528ba8411',0,1,'2020-01-07 12:20:01.739930','2019-12-27 11:03:32.541603',0,0,0,0,2,20);
INSERT INTO "oneid_meta_userperm" VALUES(380,'1c8a4ee4d6e74d08b099fc5e596c4370',0,1,'2020-01-07 12:20:01.750108','2019-12-27 11:03:32.543019',0,0,0,0,3,20);
INSERT INTO "oneid_meta_userperm" VALUES(381,'304d8417cbea43ac8091c1a0df576a84',0,1,'2020-01-07 12:20:01.759862','2019-12-27 11:03:32.544891',0,0,0,0,4,20);
INSERT INTO "oneid_meta_userperm" VALUES(382,'1dd9099d5b58451ea131b5481efcb6b7',0,1,'2020-01-07 12:20:01.770543','2019-12-27 11:03:32.546252',0,0,0,0,5,20);
INSERT INTO "oneid_meta_userperm" VALUES(383,'ca7b5fdaae5e4defb11d0889b66df7ae',0,1,'2020-01-07 12:20:01.780913','2019-12-27 11:03:32.548106',0,0,0,0,6,20);
INSERT INTO "oneid_meta_userperm" VALUES(384,'6ecdd5ffbbfa465cbc36e16643c1d417',0,1,'2020-01-07 12:20:01.800790','2019-12-27 11:03:32.549602',0,0,0,0,7,20);
INSERT INTO "oneid_meta_userperm" VALUES(385,'e453099edbd04f1fb48ff1b40b02548a',0,1,'2020-01-07 12:20:01.811114','2019-12-27 11:03:32.551133',0,0,0,0,8,20);
INSERT INTO "oneid_meta_userperm" VALUES(386,'690a3b38406d42aca98643b25e5b05f8',0,1,'2020-01-07 12:20:01.821705','2019-12-27 11:03:32.552450',0,0,0,0,9,20);
INSERT INTO "oneid_meta_userperm" VALUES(387,'27e45a52ae544fb4885333776664a53c',0,1,'2020-01-07 12:20:01.832659','2019-12-27 11:03:32.554115',0,0,0,0,10,20);
INSERT INTO "oneid_meta_userperm" VALUES(388,'c50d1653be174a02820bc91ae99ae685',0,1,'2020-01-07 12:20:01.842316','2019-12-27 11:03:32.555369',0,0,0,0,11,20);
INSERT INTO "oneid_meta_userperm" VALUES(389,'8cb75e4f64044d25ba31ab062c18d4ab',0,1,'2020-01-07 12:20:01.851851','2019-12-27 11:03:32.556695',0,0,0,0,12,20);
INSERT INTO "oneid_meta_userperm" VALUES(390,'77e4ee7a0fef4d288cff90ec938d6e7c',0,1,'2020-01-07 12:20:01.861754','2019-12-27 11:03:32.558000',0,0,0,0,13,20);
INSERT INTO "oneid_meta_userperm" VALUES(391,'c7ed4d461191485ab52ed09c5ff36fd7',0,1,'2020-01-07 12:20:01.871240','2019-12-27 11:03:32.559253',0,0,0,0,14,20);
INSERT INTO "oneid_meta_userperm" VALUES(392,'cde3e9efc4624c369f5911733a590893',0,1,'2020-01-07 12:20:01.881197','2019-12-27 11:03:32.561039',0,0,0,0,15,20);
INSERT INTO "oneid_meta_userperm" VALUES(393,'b47fd550f90347da9fa3c3d581b60865',0,1,'2020-01-07 12:20:01.901811','2019-12-27 11:03:32.562622',0,0,0,0,16,20);
INSERT INTO "oneid_meta_userperm" VALUES(394,'75dc9469e6ad426e8feb0003d29ec62d',0,1,'2020-01-07 12:20:01.912307','2019-12-27 11:03:32.563928',0,0,0,0,17,20);
INSERT INTO "oneid_meta_userperm" VALUES(395,'f14a2acc2b2c4630a90579e39d7333be',0,1,'2020-01-07 12:20:01.923169','2019-12-27 11:03:32.565302',0,0,0,0,18,20);
INSERT INTO "oneid_meta_userperm" VALUES(396,'36f1ea84be424f7b9a0bdcfd079d4bc2',0,1,'2020-01-07 12:20:01.933288','2019-12-27 11:03:32.566591',0,0,0,0,19,20);
INSERT INTO "oneid_meta_userperm" VALUES(397,'8fa6c1c5650a4e59812d8bcf27a428a3',0,1,'2020-01-07 12:20:01.943386','2019-12-27 11:03:32.567945',0,0,0,0,20,20);
INSERT INTO "oneid_meta_userperm" VALUES(398,'bb638f192dab47979d787cbbb0267297',0,1,'2020-01-07 12:20:01.953369','2019-12-27 11:03:32.569206',0,0,0,0,21,20);
INSERT INTO "oneid_meta_userperm" VALUES(399,'3e6352255691411d9426ca41ea86f0b1',0,1,'2020-01-07 12:20:01.963932','2019-12-27 11:03:48.687258',0,0,0,0,1,21);
INSERT INTO "oneid_meta_userperm" VALUES(400,'c1de26f43fae4fa5a8240e5876aba6c4',0,1,'2020-01-07 12:20:01.974781','2019-12-27 11:03:48.689593',0,0,0,0,2,21);
INSERT INTO "oneid_meta_userperm" VALUES(401,'cb58a2f6101a43ff90da0a7b09a32769',0,1,'2020-01-07 12:20:01.984688','2019-12-27 11:03:48.691673',0,0,0,0,3,21);
INSERT INTO "oneid_meta_userperm" VALUES(402,'99cb74f118334f87864c5eefc4f5f6fa',0,1,'2020-01-07 12:20:02.005398','2019-12-27 11:03:48.693484',0,0,0,0,4,21);
INSERT INTO "oneid_meta_userperm" VALUES(403,'14ca1b6b820b442f92ccb4d7039d1d5a',0,1,'2020-01-07 12:20:02.016622','2019-12-27 11:03:48.694733',0,0,0,0,5,21);
INSERT INTO "oneid_meta_userperm" VALUES(404,'f73b96ea6a2e4c69b1fe6938de3ad697',0,1,'2020-01-07 12:20:02.027737','2019-12-27 11:03:48.695919',0,0,0,0,6,21);
INSERT INTO "oneid_meta_userperm" VALUES(405,'8cde62321d6e4699a39d20d271697dc9',0,1,'2020-01-07 12:20:02.038820','2019-12-27 11:03:48.697110',0,0,0,0,7,21);
INSERT INTO "oneid_meta_userperm" VALUES(406,'50ea6d7163104c4089f1fe3ce95b0809',0,1,'2020-01-07 12:20:02.048857','2019-12-27 11:03:48.698486',0,0,0,0,8,21);
INSERT INTO "oneid_meta_userperm" VALUES(407,'f59621019f064fc7b0e9aa5abb49e93b',0,1,'2020-01-07 12:20:02.059572','2019-12-27 11:03:48.699733',0,0,0,0,9,21);
INSERT INTO "oneid_meta_userperm" VALUES(408,'de2ae7871b684780969b50a62b9c48ca',0,1,'2020-01-07 12:20:02.069715','2019-12-27 11:03:48.701162',0,0,0,0,10,21);
INSERT INTO "oneid_meta_userperm" VALUES(409,'1ee88d66196f42699ddda8bf7d71ff7f',0,1,'2020-01-07 12:20:02.079880','2019-12-27 11:03:48.702520',0,0,0,0,11,21);
INSERT INTO "oneid_meta_userperm" VALUES(410,'420f3054bd9945c2a46478854d4920a7',0,1,'2020-01-07 12:20:02.099345','2019-12-27 11:03:48.704045',0,0,0,0,12,21);
INSERT INTO "oneid_meta_userperm" VALUES(411,'61891844609a4babbb45f25e5540a6c6',0,1,'2020-01-07 12:20:02.114237','2019-12-27 11:03:48.705478',0,0,0,0,13,21);
INSERT INTO "oneid_meta_userperm" VALUES(412,'d9638691175d4c6b96a894dd26717105',0,1,'2020-01-07 12:20:02.124083','2019-12-27 11:03:48.707291',0,0,0,0,14,21);
INSERT INTO "oneid_meta_userperm" VALUES(413,'e0cf9ac70dd3426d93a2354be73dbefa',0,1,'2020-01-07 12:20:02.136040','2019-12-27 11:03:48.708810',0,0,0,0,15,21);
INSERT INTO "oneid_meta_userperm" VALUES(414,'c1e4de04619145fd9883f48b9e1f9144',0,1,'2020-01-07 12:20:02.146244','2019-12-27 11:03:48.710208',0,0,0,0,16,21);
INSERT INTO "oneid_meta_userperm" VALUES(415,'f1a1e5306e9145969f036a630b02b3a8',0,1,'2020-01-07 12:20:02.155783','2019-12-27 11:03:48.711583',0,0,0,0,17,21);
INSERT INTO "oneid_meta_userperm" VALUES(416,'0a01114f44e746fcb80abc8ef7a694e7',0,1,'2020-01-07 12:20:02.166032','2019-12-27 11:03:48.712821',0,0,0,0,18,21);
INSERT INTO "oneid_meta_userperm" VALUES(417,'ef4c8963d177405eb70824af69e1f200',0,1,'2020-01-07 12:20:02.177510','2019-12-27 11:03:48.714155',0,0,0,0,19,21);
INSERT INTO "oneid_meta_userperm" VALUES(418,'8c273f2bbc2f40f883bcb7aa71ab32c6',0,1,'2020-01-07 12:20:02.189292','2019-12-27 11:03:48.715472',0,0,0,0,20,21);
INSERT INTO "oneid_meta_userperm" VALUES(419,'a34315b67cee4e069006e6c8380139e6',0,1,'2020-01-07 12:20:02.212332','2019-12-27 11:03:48.716833',0,0,0,0,21,21);
INSERT INTO "oneid_meta_userperm" VALUES(420,'e42a2b3dc67e4f71bbd8a9cd135beb0f',0,1,'2020-01-07 12:20:02.225231','2019-12-27 11:04:07.044873',0,0,0,0,1,22);
INSERT INTO "oneid_meta_userperm" VALUES(421,'18c4eaba2ee94efaad6ff5bfe124bb9d',0,1,'2020-01-07 12:20:02.236794','2019-12-27 11:04:07.046242',0,0,0,0,2,22);
INSERT INTO "oneid_meta_userperm" VALUES(422,'7472015add5e4681bf48ba3636709e05',0,1,'2020-01-07 12:20:02.248618','2019-12-27 11:04:07.047572',0,0,0,0,3,22);
INSERT INTO "oneid_meta_userperm" VALUES(423,'35cb55cc628746d89277a493b99599cf',0,1,'2020-01-07 12:20:02.260238','2019-12-27 11:04:07.048888',0,0,0,0,4,22);
INSERT INTO "oneid_meta_userperm" VALUES(424,'a05b871bb2a34e7db9f61acc2b9add26',0,1,'2020-01-07 12:20:02.270974','2019-12-27 11:04:07.050239',0,0,0,0,5,22);
INSERT INTO "oneid_meta_userperm" VALUES(425,'f27451dcf25d4407bfde090e46b0ca38',0,1,'2020-01-07 12:20:02.282284','2019-12-27 11:04:07.051816',0,0,0,0,6,22);
INSERT INTO "oneid_meta_userperm" VALUES(426,'a484dbb43ec744b4a964e2c996f7687a',0,1,'2020-01-07 12:20:02.292157','2019-12-27 11:04:07.053696',0,0,0,0,7,22);
INSERT INTO "oneid_meta_userperm" VALUES(427,'fe3f78c8fefb44d5b03e42d0b34a5375',0,1,'2020-01-07 12:20:02.301922','2019-12-27 11:04:07.055881',0,0,0,0,8,22);
INSERT INTO "oneid_meta_userperm" VALUES(428,'9b56600b0a1e4c63a454dbf37d304bdc',0,1,'2020-01-07 12:20:02.312274','2019-12-27 11:04:07.057338',0,0,0,0,9,22);
INSERT INTO "oneid_meta_userperm" VALUES(429,'ca9c702ed1684a7ca393625cc87087c6',0,1,'2020-01-07 12:20:02.324754','2019-12-27 11:04:07.058588',0,0,0,0,10,22);
INSERT INTO "oneid_meta_userperm" VALUES(430,'74f54e209c3344528e8b21f9d242de36',0,1,'2020-01-07 12:20:02.335857','2019-12-27 11:04:07.059998',0,0,0,0,11,22);
INSERT INTO "oneid_meta_userperm" VALUES(431,'8c586899e6cb4238b3f968b6927a80e7',0,1,'2020-01-07 12:20:02.347525','2019-12-27 11:04:07.061337',0,0,0,0,12,22);
INSERT INTO "oneid_meta_userperm" VALUES(432,'8c55357f88824b05a38c0e92b4417d89',0,1,'2020-01-07 12:20:02.358409','2019-12-27 11:04:07.062761',0,0,0,0,13,22);
INSERT INTO "oneid_meta_userperm" VALUES(433,'52cfe324f9c24be182cff42ea18a1c83',0,1,'2020-01-07 12:20:02.370456','2019-12-27 11:04:07.064086',0,0,0,0,14,22);
INSERT INTO "oneid_meta_userperm" VALUES(434,'ae8d7a2741d1440784ebae3c4bb0ed7b',0,1,'2020-01-07 12:20:02.382489','2019-12-27 11:04:07.065624',0,0,0,0,15,22);
INSERT INTO "oneid_meta_userperm" VALUES(435,'b4d3cb64579241e7ba4e962051603a4a',0,1,'2020-01-07 12:20:02.393989','2019-12-27 11:04:07.066989',0,0,0,0,16,22);
INSERT INTO "oneid_meta_userperm" VALUES(436,'d3b57fa63fb64ece902d246c63b35da6',0,1,'2020-01-07 12:20:02.403758','2019-12-27 11:04:07.068410',0,0,0,0,17,22);
INSERT INTO "oneid_meta_userperm" VALUES(437,'6dc97c5638a74b1daab7567f8c44ae9e',0,1,'2020-01-07 12:20:02.416002','2019-12-27 11:04:07.070220',0,0,0,0,18,22);
INSERT INTO "oneid_meta_userperm" VALUES(438,'f4b826ffc3f740499d7b12c3fb1d5d73',0,1,'2020-01-07 12:20:02.428074','2019-12-27 11:04:07.072126',0,0,0,0,19,22);
INSERT INTO "oneid_meta_userperm" VALUES(439,'4a8fe73d87ba497fb8f05c06c709495b',0,1,'2020-01-07 12:20:02.439081','2019-12-27 11:04:07.073551',0,0,0,0,20,22);
INSERT INTO "oneid_meta_userperm" VALUES(440,'0a8bc95e449c4f3a9d4495567d45d637',0,1,'2020-01-07 12:20:02.450772','2019-12-27 11:04:07.074981',0,0,0,0,21,22);
INSERT INTO "oneid_meta_userperm" VALUES(441,'1163cba00bdf4d2eabe2f27193868bc1',0,1,'2020-01-07 12:20:02.463567','2019-12-27 11:04:23.946009',0,0,0,0,1,23);
INSERT INTO "oneid_meta_userperm" VALUES(442,'f855086d05dd4844a7666ed899fe1caa',0,1,'2020-01-07 12:20:02.475220','2019-12-27 11:04:23.947410',0,0,0,0,2,23);
INSERT INTO "oneid_meta_userperm" VALUES(443,'642cecb191af490b86c57526ad8d8337',0,1,'2020-01-07 12:20:02.485404','2019-12-27 11:04:23.949093',0,0,0,0,3,23);
INSERT INTO "oneid_meta_userperm" VALUES(444,'6bfe5840f16a4ae6b7f014bf15420638',0,1,'2020-01-07 12:20:02.497120','2019-12-27 11:04:23.950813',0,0,0,0,4,23);
INSERT INTO "oneid_meta_userperm" VALUES(445,'97ab85009e5848698fb20b599ad519c0',0,1,'2020-01-07 12:20:02.508944','2019-12-27 11:04:23.952417',0,0,0,0,5,23);
INSERT INTO "oneid_meta_userperm" VALUES(446,'761302d79e974330963311646af61e82',0,1,'2020-01-07 12:20:02.520556','2019-12-27 11:04:23.953755',0,0,0,0,6,23);
INSERT INTO "oneid_meta_userperm" VALUES(447,'5d6ce2159f574fc7a7062043fc486657',0,1,'2020-01-07 12:20:02.532436','2019-12-27 11:04:23.955059',0,0,0,0,7,23);
INSERT INTO "oneid_meta_userperm" VALUES(448,'c7d7caf177274db9b4514523338a1e23',0,1,'2020-01-07 12:20:02.542871','2019-12-27 11:04:23.956507',0,0,0,0,8,23);
INSERT INTO "oneid_meta_userperm" VALUES(449,'6c4e307821d948fe905f2e34b50b2cfc',0,1,'2020-01-07 12:20:02.552183','2019-12-27 11:04:23.957849',0,0,0,0,9,23);
INSERT INTO "oneid_meta_userperm" VALUES(450,'75dc931a327d4b02a1e68af760276df5',0,1,'2020-01-07 12:20:02.562393','2019-12-27 11:04:23.959167',0,0,0,0,10,23);
INSERT INTO "oneid_meta_userperm" VALUES(451,'bfeb322d2f584038a494f195086d2739',0,1,'2020-01-07 12:20:02.572149','2019-12-27 11:04:23.960655',0,0,0,0,11,23);
INSERT INTO "oneid_meta_userperm" VALUES(452,'982d0d4855d84c85b47fd1cd744b9b9c',0,1,'2020-01-07 12:20:02.583111','2019-12-27 11:04:23.961995',0,0,0,0,12,23);
INSERT INTO "oneid_meta_userperm" VALUES(453,'8f736d6c6e7641019e7177ac8a38e8f0',0,1,'2020-01-07 12:20:02.592690','2019-12-27 11:04:23.963387',0,0,0,0,13,23);
INSERT INTO "oneid_meta_userperm" VALUES(454,'00efc8d599cf49aeb2338e5397e0b400',0,1,'2020-01-07 12:20:02.602195','2019-12-27 11:04:23.964659',0,0,0,0,14,23);
INSERT INTO "oneid_meta_userperm" VALUES(455,'2f3734a1d6ba4d009fb26bd4b9234956',0,1,'2020-01-07 12:20:02.612096','2019-12-27 11:04:23.966550',0,0,0,0,15,23);
INSERT INTO "oneid_meta_userperm" VALUES(456,'d9232b7c8f4e489bb147d73bc87e6a99',0,1,'2020-01-07 12:20:02.622201','2019-12-27 11:04:23.968165',0,0,0,0,16,23);
INSERT INTO "oneid_meta_userperm" VALUES(457,'8879f192def24400984e969e66d5de9f',0,1,'2020-01-07 12:20:02.632595','2019-12-27 11:04:23.969482',0,0,0,0,17,23);
INSERT INTO "oneid_meta_userperm" VALUES(458,'0436e1faaa824d9ba6a94a08355afaca',0,1,'2020-01-07 12:20:02.643010','2019-12-27 11:04:23.970928',0,0,0,0,18,23);
INSERT INTO "oneid_meta_userperm" VALUES(459,'9879646a875743db9ca9049dfe33027f',0,1,'2020-01-07 12:20:02.652426','2019-12-27 11:04:23.972209',0,0,0,0,19,23);
INSERT INTO "oneid_meta_userperm" VALUES(460,'cd891eb0680b463686f70b7404b752e4',0,1,'2020-01-07 12:20:02.662633','2019-12-27 11:04:23.973482',0,0,0,0,20,23);
INSERT INTO "oneid_meta_userperm" VALUES(461,'898f6714f90749619952c2428677d986',0,1,'2020-01-07 12:20:02.672277','2019-12-27 11:04:23.974898',0,0,0,0,21,23);
INSERT INTO "oneid_meta_userperm" VALUES(462,'91def8279793496f86f50bcad4fa61d1',0,1,'2020-01-07 12:20:02.681958','2019-12-27 11:04:39.803836',0,0,0,0,1,24);
INSERT INTO "oneid_meta_userperm" VALUES(463,'8e74482a7be643e38e3453e62a9d6bfd',0,1,'2020-01-07 12:20:02.692590','2019-12-27 11:04:39.805570',0,0,0,0,2,24);
INSERT INTO "oneid_meta_userperm" VALUES(464,'5a72198844404109ba3c771df59a2106',0,1,'2020-01-07 12:20:02.702676','2019-12-27 11:04:39.806875',0,0,0,0,3,24);
INSERT INTO "oneid_meta_userperm" VALUES(465,'2485e44e54894ceca1568e6084d67124',0,1,'2020-01-07 12:20:02.723416','2019-12-27 11:04:39.808645',0,0,0,0,4,24);
INSERT INTO "oneid_meta_userperm" VALUES(466,'59005341d8d64f40a91da9774ead803c',0,1,'2020-01-07 12:20:02.734939','2019-12-27 11:04:39.810290',0,0,0,0,5,24);
INSERT INTO "oneid_meta_userperm" VALUES(467,'9f728a78b0564a30b21630cfe9cd42b4',0,1,'2020-01-07 12:20:02.744990','2019-12-27 11:04:39.812154',0,0,0,0,6,24);
INSERT INTO "oneid_meta_userperm" VALUES(468,'d3998e64ca4f456d9cd4de84cceb2a71',0,1,'2020-01-07 12:20:02.754778','2019-12-27 11:04:39.813589',0,0,0,0,7,24);
INSERT INTO "oneid_meta_userperm" VALUES(469,'712434f562bb4c9196dfd07b48b24cbc',0,1,'2020-01-07 12:20:02.764441','2019-12-27 11:04:39.815143',0,0,0,0,8,24);
INSERT INTO "oneid_meta_userperm" VALUES(470,'e5b455ea773d432fbd7f5f051050cd9f',0,1,'2020-01-07 12:20:02.775079','2019-12-27 11:04:39.816519',0,0,0,0,9,24);
INSERT INTO "oneid_meta_userperm" VALUES(471,'8d2f6c89700245e29be98e21261d266d',0,1,'2020-01-07 12:20:02.788332','2019-12-27 11:04:39.817814',0,0,0,0,10,24);
INSERT INTO "oneid_meta_userperm" VALUES(472,'094b4f4700674e93a5eb9f86f30c76f8',0,1,'2020-01-07 12:20:02.801089','2019-12-27 11:04:39.819118',0,0,0,0,11,24);
INSERT INTO "oneid_meta_userperm" VALUES(473,'08dce2ff647649b394d5cedb4f3abf53',0,1,'2020-01-07 12:20:02.814863','2019-12-27 11:04:39.820423',0,0,0,0,12,24);
INSERT INTO "oneid_meta_userperm" VALUES(474,'a2a880352cb7431d8fd7399ffbd18e5c',0,1,'2020-01-07 12:20:02.837161','2019-12-27 11:04:39.821663',0,0,0,0,13,24);
INSERT INTO "oneid_meta_userperm" VALUES(475,'8beed4a740ec46a397997dcf32e9c73a',0,1,'2020-01-07 12:20:02.850320','2019-12-27 11:04:39.823169',0,0,0,0,14,24);
INSERT INTO "oneid_meta_userperm" VALUES(476,'04e38d61b0004ad0af4ceb60964e380f',0,1,'2020-01-07 12:20:02.862597','2019-12-27 11:04:39.824683',0,0,0,0,15,24);
INSERT INTO "oneid_meta_userperm" VALUES(477,'90075c64858547e488cc20981ce3fe5a',0,1,'2020-01-07 12:20:02.876421','2019-12-27 11:04:39.826473',0,0,0,0,16,24);
INSERT INTO "oneid_meta_userperm" VALUES(478,'33b3d0b88c1548a09bcfa0fb5a272ee5',0,1,'2020-01-07 12:20:02.888778','2019-12-27 11:04:39.827961',0,0,0,0,17,24);
INSERT INTO "oneid_meta_userperm" VALUES(479,'85f6b7e0497b40b2a74ebb22d14c6a89',0,1,'2020-01-07 12:20:02.903152','2019-12-27 11:04:39.829362',0,0,0,0,18,24);
INSERT INTO "oneid_meta_userperm" VALUES(480,'b43a78055f2d4708b4ece39a36f2eeb2',0,1,'2020-01-07 12:20:02.917151','2019-12-27 11:04:39.830630',0,0,0,0,19,24);
INSERT INTO "oneid_meta_userperm" VALUES(481,'f80bde6ac0014aada7cb99eab7b38c48',0,1,'2020-01-07 12:20:02.939684','2019-12-27 11:04:39.832173',0,0,0,0,20,24);
INSERT INTO "oneid_meta_userperm" VALUES(482,'e57ba0373b604192aac5a08384af07f4',0,1,'2020-01-07 12:20:02.953555','2019-12-27 11:04:39.833502',0,0,0,0,21,24);
INSERT INTO "oneid_meta_userperm" VALUES(483,'14f0ac8135854824bc52a69ea72092b3',0,1,'2020-01-07 12:20:02.969289','2019-12-27 11:04:56.446422',0,0,0,0,1,25);
INSERT INTO "oneid_meta_userperm" VALUES(484,'478bd5744b334ccfad988b03b9be98fe',0,1,'2020-01-07 12:20:02.985653','2019-12-27 11:04:56.448184',0,0,0,0,2,25);
INSERT INTO "oneid_meta_userperm" VALUES(485,'c1aba014562f46d982577d77da2dc9ad',0,1,'2020-01-07 12:20:02.999118','2019-12-27 11:04:56.450551',0,0,0,0,3,25);
INSERT INTO "oneid_meta_userperm" VALUES(486,'77026f99b3e54881ae4ea4afedd058e3',0,1,'2020-01-07 12:20:03.014409','2019-12-27 11:04:56.452093',0,0,0,0,4,25);
INSERT INTO "oneid_meta_userperm" VALUES(487,'b0d19eb7dbcf443eafefbdef360917fc',0,1,'2020-01-07 12:20:03.040767','2019-12-27 11:04:56.453697',0,0,0,0,5,25);
INSERT INTO "oneid_meta_userperm" VALUES(488,'7740f71244ec485ba2c13e2bba866556',0,1,'2020-01-07 12:20:03.054811','2019-12-27 11:04:56.455225',0,0,0,0,6,25);
INSERT INTO "oneid_meta_userperm" VALUES(489,'6247a8ee9dab4cbd88504671c07ec470',0,1,'2020-01-07 12:20:03.069459','2019-12-27 11:04:56.456952',0,0,0,0,7,25);
INSERT INTO "oneid_meta_userperm" VALUES(490,'23aec853ac914a6a800d025f05ac568e',0,1,'2020-01-07 12:20:03.084487','2019-12-27 11:04:56.458756',0,0,0,0,8,25);
INSERT INTO "oneid_meta_userperm" VALUES(491,'88e5dce983bf4205ace03ef34995e0a7',0,1,'2020-01-07 12:20:03.097917','2019-12-27 11:04:56.460288',0,0,0,0,9,25);
INSERT INTO "oneid_meta_userperm" VALUES(492,'632fbbe76c144874944dfd616441dd78',0,1,'2020-01-07 12:20:03.109354','2019-12-27 11:04:56.461627',0,0,0,0,10,25);
INSERT INTO "oneid_meta_userperm" VALUES(493,'ad8d36eb829442aea5a11ac38a6cfa9d',0,1,'2020-01-07 12:20:03.120535','2019-12-27 11:04:56.462899',0,0,0,0,11,25);
INSERT INTO "oneid_meta_userperm" VALUES(494,'519cff0d8ca9451cb3f8ff93712294c6',0,1,'2020-01-07 12:20:03.140533','2019-12-27 11:04:56.464155',0,0,0,0,12,25);
INSERT INTO "oneid_meta_userperm" VALUES(495,'179cfd7648554d8ea3a3026e12335de7',0,1,'2020-01-07 12:20:03.151864','2019-12-27 11:04:56.465494',0,0,0,0,13,25);
INSERT INTO "oneid_meta_userperm" VALUES(496,'85ddff55a6bb410fbd432b7572cddf76',0,1,'2020-01-07 12:20:03.161209','2019-12-27 11:04:56.466972',0,0,0,0,14,25);
INSERT INTO "oneid_meta_userperm" VALUES(497,'7e36df10f16843e6b83db3957773a5a6',0,1,'2020-01-07 12:20:03.171187','2019-12-27 11:04:56.468299',0,0,0,0,15,25);
INSERT INTO "oneid_meta_userperm" VALUES(498,'bb3ed14137374c52917fc2b5268d70da',0,1,'2020-01-07 12:20:03.182040','2019-12-27 11:04:56.469879',0,0,0,0,16,25);
INSERT INTO "oneid_meta_userperm" VALUES(499,'4d326da6f3944193877540b05d1111ed',0,1,'2020-01-07 12:20:03.192201','2019-12-27 11:04:56.471137',0,0,0,0,17,25);
INSERT INTO "oneid_meta_userperm" VALUES(500,'3ca745f3aa1a460b808b14c92cd9a190',0,1,'2020-01-07 12:20:03.202231','2019-12-27 11:04:56.472967',0,0,0,0,18,25);
INSERT INTO "oneid_meta_userperm" VALUES(501,'7d64d781bc5b4d66b94f08e093dcfc95',0,1,'2020-01-07 12:20:03.212717','2019-12-27 11:04:56.474312',0,0,0,0,19,25);
INSERT INTO "oneid_meta_userperm" VALUES(502,'759f154611d949cf83e3d7c22065f8de',0,1,'2020-01-07 12:20:03.226093','2019-12-27 11:04:56.475708',0,0,0,0,20,25);
INSERT INTO "oneid_meta_userperm" VALUES(503,'eb4af9da84cf48fa9099fcce2c9686c3',0,1,'2020-01-07 12:20:03.249601','2019-12-27 11:04:56.477078',0,0,0,0,21,25);
INSERT INTO "oneid_meta_userperm" VALUES(504,'a8d08d04554946bba0fd20373f55348e',0,1,'2020-01-07 12:20:03.263471','2019-12-27 11:05:12.218095',0,0,0,0,1,26);
INSERT INTO "oneid_meta_userperm" VALUES(505,'b868dabe418b4279825648289e61ad3d',0,1,'2020-01-07 12:20:03.277383','2019-12-27 11:05:12.220223',0,0,0,0,2,26);
INSERT INTO "oneid_meta_userperm" VALUES(506,'2f8c36cfbdaf402386278a1363cccf4e',0,1,'2020-01-07 12:20:03.292690','2019-12-27 11:05:12.221662',0,0,0,0,3,26);
INSERT INTO "oneid_meta_userperm" VALUES(507,'61fb0a7a33c443a1b105f2ca97253ad1',0,1,'2020-01-07 12:20:03.304969','2019-12-27 11:05:12.223024',0,0,0,0,4,26);
INSERT INTO "oneid_meta_userperm" VALUES(508,'8a901449b7644e80b73676b229bb3491',0,1,'2020-01-07 12:20:03.318913','2019-12-27 11:05:12.224382',0,0,0,0,5,26);
INSERT INTO "oneid_meta_userperm" VALUES(509,'646aaff4a9444c68ab3a270c10bf9726',0,1,'2020-01-07 12:20:03.332517','2019-12-27 11:05:12.225657',0,0,0,0,6,26);
INSERT INTO "oneid_meta_userperm" VALUES(510,'900bcd6bd92c48d380166f9fa6d7cf43',0,1,'2020-01-07 12:20:03.354585','2019-12-27 11:05:12.227147',0,0,0,0,7,26);
INSERT INTO "oneid_meta_userperm" VALUES(511,'324824c72eb74b618367d231c6711224',0,1,'2020-01-07 12:20:03.366503','2019-12-27 11:05:12.228500',0,0,0,0,8,26);
INSERT INTO "oneid_meta_userperm" VALUES(512,'af2623144f6f4675923b4e17111d5c65',0,1,'2020-01-07 12:20:03.379124','2019-12-27 11:05:12.229823',0,0,0,0,9,26);
INSERT INTO "oneid_meta_userperm" VALUES(513,'b42abba3c3d7496c9233307cf9950dea',0,1,'2020-01-07 12:20:03.390150','2019-12-27 11:05:12.231358',0,0,0,0,10,26);
INSERT INTO "oneid_meta_userperm" VALUES(514,'47da597debdc489da2e160f6875f571b',0,1,'2020-01-07 12:20:03.400438','2019-12-27 11:05:12.232924',0,0,0,0,11,26);
INSERT INTO "oneid_meta_userperm" VALUES(515,'36d8763d8af045b88c922b2b3d78d661',0,1,'2020-01-07 12:20:03.411659','2019-12-27 11:05:12.234261',0,0,0,0,12,26);
INSERT INTO "oneid_meta_userperm" VALUES(516,'8cd63932d9194dda9d0717ce908b1884',0,1,'2020-01-07 12:20:03.422961','2019-12-27 11:05:12.236055',0,0,0,0,13,26);
INSERT INTO "oneid_meta_userperm" VALUES(517,'8bffb49ec3e54249ad62beb219ca7969',0,1,'2020-01-07 12:20:03.433153','2019-12-27 11:05:12.237490',0,0,0,0,14,26);
INSERT INTO "oneid_meta_userperm" VALUES(518,'7006c87dd8524b57a12bff3dca8bfa52',0,1,'2020-01-07 12:20:03.453057','2019-12-27 11:05:12.238912',0,0,0,0,15,26);
INSERT INTO "oneid_meta_userperm" VALUES(519,'853ac8fe30d743c69854d2f0ff643d0c',0,1,'2020-01-07 12:20:03.465555','2019-12-27 11:05:12.240248',0,0,0,0,16,26);
INSERT INTO "oneid_meta_userperm" VALUES(520,'1bf5b1c3e9384b2da7fcfff83ee31030',0,1,'2020-01-07 12:20:03.476451','2019-12-27 11:05:12.241540',0,0,0,0,17,26);
INSERT INTO "oneid_meta_userperm" VALUES(521,'b5fde7ffdac3470b9f1ac371121961a9',0,1,'2020-01-07 12:20:03.486770','2019-12-27 11:05:12.242834',0,0,0,0,18,26);
INSERT INTO "oneid_meta_userperm" VALUES(522,'d3d4c2952d7c42138f4e64b7ef0a6012',0,1,'2020-01-07 12:20:03.497526','2019-12-27 11:05:12.244108',0,0,0,0,19,26);
INSERT INTO "oneid_meta_userperm" VALUES(523,'af699e16e42f44268eb21fd7a14fdc32',0,1,'2020-01-07 12:20:03.508274','2019-12-27 11:05:12.245369',0,0,0,0,20,26);
INSERT INTO "oneid_meta_userperm" VALUES(524,'d991da66314d4d88a1182d8b7e00dff1',0,1,'2020-01-07 12:20:03.519472','2019-12-27 11:05:12.246694',0,0,0,0,21,26);
INSERT INTO "oneid_meta_userperm" VALUES(525,'11d4815502fe4140bcca82e06c9e72a7',0,1,'2020-01-07 12:20:03.531473','2019-12-27 11:05:31.410748',0,0,0,0,1,27);
INSERT INTO "oneid_meta_userperm" VALUES(526,'a53ab50e6ea745cbb0acbe79c785ae4a',0,1,'2020-01-07 12:20:03.560051','2019-12-27 11:05:31.412321',0,0,0,0,2,27);
INSERT INTO "oneid_meta_userperm" VALUES(527,'2ef87e6e1c4047fd806a03e7e77430b3',0,1,'2020-01-07 12:20:03.571977','2019-12-27 11:05:31.414478',0,0,0,0,3,27);
INSERT INTO "oneid_meta_userperm" VALUES(528,'9e4abcbe68af45f5aefcaaa9aeef31f3',0,1,'2020-01-07 12:20:03.586165','2019-12-27 11:05:31.416577',0,0,0,0,4,27);
INSERT INTO "oneid_meta_userperm" VALUES(529,'f3f95fb635df43d698e72497f3228b29',0,1,'2020-01-07 12:20:03.597520','2019-12-27 11:05:31.418607',0,0,0,0,5,27);
INSERT INTO "oneid_meta_userperm" VALUES(530,'c6851ce216124f7482667f03b72780e5',0,1,'2020-01-07 12:20:03.609342','2019-12-27 11:05:31.420629',0,0,0,0,6,27);
INSERT INTO "oneid_meta_userperm" VALUES(531,'b6a77600120d4b2ca0f67881e8adc045',0,1,'2020-01-07 12:20:03.620347','2019-12-27 11:05:31.422418',0,0,0,0,7,27);
INSERT INTO "oneid_meta_userperm" VALUES(532,'4180068f589d4aeb81456d1562559d54',0,1,'2020-01-07 12:20:03.630066','2019-12-27 11:05:31.423996',0,0,0,0,8,27);
INSERT INTO "oneid_meta_userperm" VALUES(533,'ed1426a481394350a7219f091cc3a3be',0,1,'2020-01-07 12:20:03.640339','2019-12-27 11:05:31.425338',0,0,0,0,9,27);
INSERT INTO "oneid_meta_userperm" VALUES(534,'7c2d32a80289415b9d29b3a1799bddbd',0,1,'2020-01-07 12:20:03.661266','2019-12-27 11:05:31.426619',0,0,0,0,10,27);
INSERT INTO "oneid_meta_userperm" VALUES(535,'4a37bef78ee044869fa5b4adbecbd382',0,1,'2020-01-07 12:20:03.672319','2019-12-27 11:05:31.428125',0,0,0,0,11,27);
INSERT INTO "oneid_meta_userperm" VALUES(536,'3b16b85636c3448b9da10d5fbb7fd4e6',0,1,'2020-01-07 12:20:03.683583','2019-12-27 11:05:31.429878',0,0,0,0,12,27);
INSERT INTO "oneid_meta_userperm" VALUES(537,'1aecec7e83bb46de9d966050a678076a',0,1,'2020-01-07 12:20:03.693693','2019-12-27 11:05:31.431705',0,0,0,0,13,27);
INSERT INTO "oneid_meta_userperm" VALUES(538,'388654899c934535bd6c37d1d19e3054',0,1,'2020-01-07 12:20:03.706464','2019-12-27 11:05:31.433443',0,0,0,0,14,27);
INSERT INTO "oneid_meta_userperm" VALUES(539,'5f0d4f472378493cb54eaa1cd1f74ac9',0,1,'2020-01-07 12:20:03.721038','2019-12-27 11:05:31.435060',0,0,0,0,15,27);
INSERT INTO "oneid_meta_userperm" VALUES(540,'a6977a629e664967bdf1e6ac75ad2c13',0,1,'2020-01-07 12:20:03.733615','2019-12-27 11:05:31.436321',0,0,0,0,16,27);
INSERT INTO "oneid_meta_userperm" VALUES(541,'9f0a0e9eb9cb4522addbb6a18855727f',0,1,'2020-01-07 12:20:03.748484','2019-12-27 11:05:31.437660',0,0,0,0,17,27);
INSERT INTO "oneid_meta_userperm" VALUES(542,'569a057c262b40ee83af6035563805c2',0,1,'2020-01-07 12:20:03.770934','2019-12-27 11:05:31.439011',0,0,0,0,18,27);
INSERT INTO "oneid_meta_userperm" VALUES(543,'f96435c10525406ab77ee0a60d92a4ff',0,1,'2020-01-07 12:20:03.783213','2019-12-27 11:05:31.440319',0,0,0,0,19,27);
INSERT INTO "oneid_meta_userperm" VALUES(544,'d0d7670ee5ce420399c5b6d610f48955',0,1,'2020-01-07 12:20:03.795017','2019-12-27 11:05:31.441925',0,0,0,0,20,27);
INSERT INTO "oneid_meta_userperm" VALUES(545,'f4ff893dfb58430f9061afb2fb7d225e',0,1,'2020-01-07 12:20:03.804827','2019-12-27 11:05:31.443791',0,0,0,0,21,27);
INSERT INTO "oneid_meta_userperm" VALUES(546,'0cccc1a34f5c4dafaa5f522f84c5fbeb',0,1,'2020-01-07 12:20:03.816944','2019-12-27 11:05:47.497168',0,0,0,0,1,28);
INSERT INTO "oneid_meta_userperm" VALUES(547,'6b9c141c4581400292e68fe91a696c84',0,1,'2020-01-07 12:20:03.830506','2019-12-27 11:05:47.498826',0,0,0,0,2,28);
INSERT INTO "oneid_meta_userperm" VALUES(548,'ebf7f84c0d4849d5a78327506e3971c7',0,1,'2020-01-07 12:20:03.841832','2019-12-27 11:05:47.500467',0,0,0,0,3,28);
INSERT INTO "oneid_meta_userperm" VALUES(549,'2633e3f365934a8587deccc471028b64',0,1,'2020-01-07 12:20:03.853396','2019-12-27 11:05:47.501925',0,0,0,0,4,28);
INSERT INTO "oneid_meta_userperm" VALUES(550,'d151c6c2158446f1bff7f0c472058e54',0,1,'2020-01-07 12:20:03.876918','2019-12-27 11:05:47.503275',0,0,0,0,5,28);
INSERT INTO "oneid_meta_userperm" VALUES(551,'6e056d75e7354ca4a432c5efe1287e44',0,1,'2020-01-07 12:20:03.887343','2019-12-27 11:05:47.504528',0,0,0,0,6,28);
INSERT INTO "oneid_meta_userperm" VALUES(552,'356538a1f7174bd9bf2605f08f693c34',0,1,'2020-01-07 12:20:03.901142','2019-12-27 11:05:47.505775',0,0,0,0,7,28);
INSERT INTO "oneid_meta_userperm" VALUES(553,'a9dfb384d5e141bdb96311c1fd3f985d',0,1,'2020-01-07 12:20:03.913995','2019-12-27 11:05:47.507298',0,0,0,0,8,28);
INSERT INTO "oneid_meta_userperm" VALUES(554,'c00e9a12d36c48d0b3205fa41266025a',0,1,'2020-01-07 12:20:03.925685','2019-12-27 11:05:47.510317',0,0,0,0,9,28);
INSERT INTO "oneid_meta_userperm" VALUES(555,'751a61ad2da8471e9cd2ee5bcc0bd9d9',0,1,'2020-01-07 12:20:03.937599','2019-12-27 11:05:47.513384',0,0,0,0,10,28);
INSERT INTO "oneid_meta_userperm" VALUES(556,'f6534ce7f6d14bc6addc0dc85fe66125',0,1,'2020-01-07 12:20:03.950339','2019-12-27 11:05:47.516071',0,0,0,0,11,28);
INSERT INTO "oneid_meta_userperm" VALUES(557,'c44697a8ea224d44a82e95ef0f84933c',0,1,'2020-01-07 12:20:03.972984','2019-12-27 11:05:47.517439',0,0,0,0,12,28);
INSERT INTO "oneid_meta_userperm" VALUES(558,'420d68c9ee72499d91eef1297a3b50d4',0,1,'2020-01-07 12:20:03.988452','2019-12-27 11:05:47.519011',0,0,0,0,13,28);
INSERT INTO "oneid_meta_userperm" VALUES(559,'d381d4a7edd0451fbebe80e0f5686d20',0,1,'2020-01-07 12:20:04.018457','2019-12-27 11:05:47.520332',0,0,0,0,14,28);
INSERT INTO "oneid_meta_userperm" VALUES(560,'2be6eb29b11b49ce9c63489c1e13ed41',0,1,'2020-01-07 12:20:04.033970','2019-12-27 11:05:47.521683',0,0,0,0,15,28);
INSERT INTO "oneid_meta_userperm" VALUES(561,'75dc9dd61c8a4b4da25d171adabda8ae',0,1,'2020-01-07 12:20:04.048693','2019-12-27 11:05:47.523147',0,0,0,0,16,28);
INSERT INTO "oneid_meta_userperm" VALUES(562,'47b0da9ff8f845b6b94bb9720a2f4c81',0,1,'2020-01-07 12:20:04.078672','2019-12-27 11:05:47.524618',0,0,0,0,17,28);
INSERT INTO "oneid_meta_userperm" VALUES(563,'1eb28df88e7845b6a1162bcb65d5876a',0,1,'2020-01-07 12:20:04.092964','2019-12-27 11:05:47.530187',0,0,0,0,18,28);
INSERT INTO "oneid_meta_userperm" VALUES(564,'dfad0b13fe984c1fb8e9c7de4520cad6',0,1,'2020-01-07 12:20:04.105320','2019-12-27 11:05:47.531738',0,0,0,0,19,28);
INSERT INTO "oneid_meta_userperm" VALUES(565,'7fb02f2abd5249cc9bf920bc3a043ad8',0,1,'2020-01-07 12:20:04.118651','2019-12-27 11:05:47.533039',0,0,0,0,20,28);
INSERT INTO "oneid_meta_userperm" VALUES(566,'622b966b12bf436e8e3f1006a440226e',0,1,'2020-01-07 12:20:04.134153','2019-12-27 11:05:47.534479',0,0,0,0,21,28);
INSERT INTO "oneid_meta_userperm" VALUES(567,'5728a74735d142159c198b368531235f',0,1,'2020-01-07 12:20:04.148202','2019-12-27 11:06:04.597324',0,0,0,0,1,29);
INSERT INTO "oneid_meta_userperm" VALUES(568,'304a85983afe4ce5855d20b02e8ed13c',0,1,'2020-01-07 12:20:04.164425','2019-12-27 11:06:04.599012',0,0,0,0,2,29);
INSERT INTO "oneid_meta_userperm" VALUES(569,'108928ce129843b7b6bfe4d7a60c73b8',0,1,'2020-01-07 12:20:04.190595','2019-12-27 11:06:04.604521',0,0,0,0,3,29);
INSERT INTO "oneid_meta_userperm" VALUES(570,'6f5114e8b45d41979ed7977b3a2862c7',0,1,'2020-01-07 12:20:04.203517','2019-12-27 11:06:04.607485',0,0,0,0,4,29);
INSERT INTO "oneid_meta_userperm" VALUES(571,'e467c800ad4442b691bf5e091484f9d9',0,1,'2020-01-07 12:20:04.216461','2019-12-27 11:06:04.608907',0,0,0,0,5,29);
INSERT INTO "oneid_meta_userperm" VALUES(572,'ee6b6be26ee946d28a812f2461184f45',0,1,'2020-01-07 12:20:04.229165','2019-12-27 11:06:04.610301',0,0,0,0,6,29);
INSERT INTO "oneid_meta_userperm" VALUES(573,'0589cbfd2a7e409697990db685dae0a0',0,1,'2020-01-07 12:20:04.240021','2019-12-27 11:06:04.612972',0,0,0,0,7,29);
INSERT INTO "oneid_meta_userperm" VALUES(574,'8aed092f4284464787af93bca0696f6a',0,1,'2020-01-07 12:20:04.250959','2019-12-27 11:06:04.615753',0,0,0,0,8,29);
INSERT INTO "oneid_meta_userperm" VALUES(575,'6888d70f50384042a99498f26862cba0',0,1,'2020-01-07 12:20:04.261903','2019-12-27 11:06:04.618745',0,0,0,0,9,29);
INSERT INTO "oneid_meta_userperm" VALUES(576,'b4e0934ca8a94dbe9ae658a559d950ee',0,1,'2020-01-07 12:20:04.284276','2019-12-27 11:06:04.620269',0,0,0,0,10,29);
INSERT INTO "oneid_meta_userperm" VALUES(577,'88f6926ab598467c96f05e098e1ba43b',0,1,'2020-01-07 12:20:04.297205','2019-12-27 11:06:04.622041',0,0,0,0,11,29);
INSERT INTO "oneid_meta_userperm" VALUES(578,'601dbda39e3248bc928d8d2443e17efa',0,1,'2020-01-07 12:20:04.308577','2019-12-27 11:06:04.624640',0,0,0,0,12,29);
INSERT INTO "oneid_meta_userperm" VALUES(579,'57b0219f2b7f4ec5a4e5102cdf3674e5',0,1,'2020-01-07 12:20:04.318867','2019-12-27 11:06:04.626025',0,0,0,0,13,29);
INSERT INTO "oneid_meta_userperm" VALUES(580,'193c9a4e683c4a288ae6d76eeaf0399c',0,1,'2020-01-07 12:20:04.329745','2019-12-27 11:06:04.628490',0,0,0,0,14,29);
INSERT INTO "oneid_meta_userperm" VALUES(581,'3c1bc8b885b14c13b37a960759e9a070',0,1,'2020-01-07 12:20:04.341857','2019-12-27 11:06:04.629817',0,0,0,0,15,29);
INSERT INTO "oneid_meta_userperm" VALUES(582,'234ce854748d4f9eac4608e76215d94e',0,1,'2020-01-07 12:20:04.353135','2019-12-27 11:06:04.631049',0,0,0,0,16,29);
INSERT INTO "oneid_meta_userperm" VALUES(583,'a13de6cbb1264706b4798779810e523f',0,1,'2020-01-07 12:20:04.364527','2019-12-27 11:06:04.633780',0,0,0,0,17,29);
INSERT INTO "oneid_meta_userperm" VALUES(584,'0e02074ec1464e9593b5a5561d1f09bc',0,1,'2020-01-07 12:20:04.388347','2019-12-27 11:06:04.636416',0,0,0,0,18,29);
INSERT INTO "oneid_meta_userperm" VALUES(585,'7cfd12c2f2924567818d7cb2e97b5e15',0,1,'2020-01-07 12:20:04.399780','2019-12-27 11:06:04.638030',0,0,0,0,19,29);
INSERT INTO "oneid_meta_userperm" VALUES(586,'66407d69e10f423eb26aa73347f0dffa',0,1,'2020-01-07 12:20:04.410411','2019-12-27 11:06:04.639924',0,0,0,0,20,29);
INSERT INTO "oneid_meta_userperm" VALUES(587,'47f1202ba28b4aa68295781d3f154b7b',0,1,'2020-01-07 12:20:04.422029','2019-12-27 11:06:04.641639',0,0,0,0,21,29);
INSERT INTO "oneid_meta_userperm" VALUES(588,'59ef7e1bf55847e096fe3d7c226d27fb',0,1,'2020-01-07 12:20:04.432405','2019-12-27 11:06:23.586475',0,0,0,0,1,30);
INSERT INTO "oneid_meta_userperm" VALUES(589,'557361df50f04beeaaa725ff0e88ff64',0,1,'2020-01-07 12:20:04.443356','2019-12-27 11:06:23.588689',0,0,0,0,2,30);
INSERT INTO "oneid_meta_userperm" VALUES(590,'67df68a954a040a8b43962691fb28bbd',0,1,'2020-01-07 12:20:04.453263','2019-12-27 11:06:23.590058',0,0,0,0,3,30);
INSERT INTO "oneid_meta_userperm" VALUES(591,'17fbe90eeec34c40928f68d997971bef',0,1,'2020-01-07 12:20:04.464601','2019-12-27 11:06:23.591263',0,0,0,0,4,30);
INSERT INTO "oneid_meta_userperm" VALUES(592,'c737000e0c7140c183c6e69a05782fc4',0,1,'2020-01-07 12:20:04.475253','2019-12-27 11:06:23.592446',0,0,0,0,5,30);
INSERT INTO "oneid_meta_userperm" VALUES(593,'8c04217ac91b4e7d99460e0008f0586e',0,1,'2020-01-07 12:20:04.497253','2019-12-27 11:06:23.593592',0,0,0,0,6,30);
INSERT INTO "oneid_meta_userperm" VALUES(594,'8552d41898bd4e958892728b7b2badd9',0,1,'2020-01-07 12:20:04.507302','2019-12-27 11:06:23.594904',0,0,0,0,7,30);
INSERT INTO "oneid_meta_userperm" VALUES(595,'317f3d0883284bcea449ce306ae2e6cf',0,1,'2020-01-07 12:20:04.518389','2019-12-27 11:06:23.596177',0,0,0,0,8,30);
INSERT INTO "oneid_meta_userperm" VALUES(596,'08364ad11f6a4250975ccace9e11f5ab',0,1,'2020-01-07 12:20:04.529954','2019-12-27 11:06:23.597684',0,0,0,0,9,30);
INSERT INTO "oneid_meta_userperm" VALUES(597,'08a42f226e8c45818dfcb4d6cec56ed4',0,1,'2020-01-07 12:20:04.542667','2019-12-27 11:06:23.599603',0,0,0,0,10,30);
INSERT INTO "oneid_meta_userperm" VALUES(598,'e924c5b312ba4e34b8f99fa6f6c5b21c',0,1,'2020-01-07 12:20:04.552744','2019-12-27 11:06:23.601107',0,0,0,0,11,30);
INSERT INTO "oneid_meta_userperm" VALUES(599,'6efec74dc5614de094e3358c698cfc22',0,1,'2020-01-07 12:20:04.563609','2019-12-27 11:06:23.602682',0,0,0,0,12,30);
INSERT INTO "oneid_meta_userperm" VALUES(600,'b364ee4458cc41879b9d7aa950fb9d6d',0,1,'2020-01-07 12:20:04.573793','2019-12-27 11:06:23.604148',0,0,0,0,13,30);
INSERT INTO "oneid_meta_userperm" VALUES(601,'de342adb41dc4243aee62b31aaad22b9',0,1,'2020-01-07 12:20:04.598882','2019-12-27 11:06:23.605479',0,0,0,0,14,30);
INSERT INTO "oneid_meta_userperm" VALUES(602,'eeba1ef88c844d52897f9fdd4e498a7c',0,1,'2020-01-07 12:20:04.616966','2019-12-27 11:06:23.607038',0,0,0,0,15,30);
INSERT INTO "oneid_meta_userperm" VALUES(603,'b8c54aabc43d43d386e06fb5aacaad05',0,1,'2020-01-07 12:20:04.633908','2019-12-27 11:06:23.608407',0,0,0,0,16,30);
INSERT INTO "oneid_meta_userperm" VALUES(604,'f916c6fc3bbb4302ba3da9ae292d9176',0,1,'2020-01-07 12:20:04.654409','2019-12-27 11:06:23.610072',0,0,0,0,17,30);
INSERT INTO "oneid_meta_userperm" VALUES(605,'782de95f1cd64b628a198bb8d0078bb3',0,1,'2020-01-07 12:20:04.667839','2019-12-27 11:06:23.611389',0,0,0,0,18,30);
INSERT INTO "oneid_meta_userperm" VALUES(606,'27cdd1c4abeb4291adcf7cd53c59f0cf',0,1,'2020-01-07 12:20:04.697550','2019-12-27 11:06:23.612625',0,0,0,0,19,30);
INSERT INTO "oneid_meta_userperm" VALUES(607,'6f9a6d9a838b41e2a1ff7b680eec06f5',0,1,'2020-01-07 12:20:04.717154','2019-12-27 11:06:23.613863',0,0,0,0,20,30);
INSERT INTO "oneid_meta_userperm" VALUES(608,'3756f6f35bf4416b98ce7c810604ffc0',0,1,'2020-01-07 12:20:04.731064','2019-12-27 11:06:23.615152',0,0,0,0,21,30);
INSERT INTO "oneid_meta_userperm" VALUES(609,'cad6bc81851c4eaf902db614f30542ba',0,1,'2020-01-07 12:20:04.744457','2019-12-27 11:06:39.328750',0,0,0,0,1,31);
INSERT INTO "oneid_meta_userperm" VALUES(610,'2bd6e12f4949426baa8387ab5a918c2b',0,1,'2020-01-07 12:20:04.754919','2019-12-27 11:06:39.331132',0,0,0,0,2,31);
INSERT INTO "oneid_meta_userperm" VALUES(611,'45d4cff87190425e908c5372a5bdb7fa',0,1,'2020-01-07 12:20:04.767977','2019-12-27 11:06:39.332935',0,0,0,0,3,31);
INSERT INTO "oneid_meta_userperm" VALUES(612,'c6be85432c094ed4822cabbe906d66eb',0,1,'2020-01-07 12:20:04.780890','2019-12-27 11:06:39.334531',0,0,0,0,4,31);
INSERT INTO "oneid_meta_userperm" VALUES(613,'7f4619469f3347eea2ea21793553f1a2',0,1,'2020-01-07 12:20:04.803239','2019-12-27 11:06:39.335809',0,0,0,0,5,31);
INSERT INTO "oneid_meta_userperm" VALUES(614,'925426c1456b4c829336edf49d198e19',0,1,'2020-01-07 12:20:04.813965','2019-12-27 11:06:39.337422',0,0,0,0,6,31);
INSERT INTO "oneid_meta_userperm" VALUES(615,'1fdf81df2df8454d86c65fff17f5228c',0,1,'2020-01-07 12:20:04.824944','2019-12-27 11:06:39.338674',0,0,0,0,7,31);
INSERT INTO "oneid_meta_userperm" VALUES(616,'1df456239ba649fc9bb7acc8e7317db7',0,1,'2020-01-07 12:20:04.834420','2019-12-27 11:06:39.340084',0,0,0,0,8,31);
INSERT INTO "oneid_meta_userperm" VALUES(617,'9ae202b663f34bc990550c0be41b4da9',0,1,'2020-01-07 12:20:04.844960','2019-12-27 11:06:39.341475',0,0,0,0,9,31);
INSERT INTO "oneid_meta_userperm" VALUES(618,'78e66d0e3eb642b28c5c7baf119fbe93',0,1,'2020-01-07 12:20:04.854917','2019-12-27 11:06:39.342858',0,0,0,0,10,31);
INSERT INTO "oneid_meta_userperm" VALUES(619,'8fc29d8cdf664bb4a0b794018f1e862e',0,1,'2020-01-07 12:20:04.865112','2019-12-27 11:06:39.344148',0,0,0,0,11,31);
INSERT INTO "oneid_meta_userperm" VALUES(620,'4c81ea75a2a94bf984acee6fe8a5275a',0,1,'2020-01-07 12:20:04.875422','2019-12-27 11:06:39.345638',0,0,0,0,12,31);
INSERT INTO "oneid_meta_userperm" VALUES(621,'957754a9c33445ae8051a73713799d2a',0,1,'2020-01-07 12:20:04.895212','2019-12-27 11:06:39.347566',0,0,0,0,13,31);
INSERT INTO "oneid_meta_userperm" VALUES(622,'7445b5a88ce1474c86193c740375a1a2',0,1,'2020-01-07 12:20:04.906702','2019-12-27 11:06:39.349076',0,0,0,0,14,31);
INSERT INTO "oneid_meta_userperm" VALUES(623,'5a11b8d344404a07a9491bc7ac50ea60',0,1,'2020-01-07 12:20:04.918662','2019-12-27 11:06:39.350708',0,0,0,0,15,31);
INSERT INTO "oneid_meta_userperm" VALUES(624,'b664dd21ef6e45b78c20d8bff8a99794',0,1,'2020-01-07 12:20:04.929592','2019-12-27 11:06:39.352013',0,0,0,0,16,31);
INSERT INTO "oneid_meta_userperm" VALUES(625,'c59f03efc63d4bae9c1bb1f648c0d53e',0,1,'2020-01-07 12:20:04.940120','2019-12-27 11:06:39.353396',0,0,0,0,17,31);
INSERT INTO "oneid_meta_userperm" VALUES(626,'fdbc28ffa7d2463b8b2dfc89c6f6cc57',0,1,'2020-01-07 12:20:04.950111','2019-12-27 11:06:39.354659',0,0,0,0,18,31);
INSERT INTO "oneid_meta_userperm" VALUES(627,'084cae59322d464296e527bd67ee72ec',0,1,'2020-01-07 12:20:04.961220','2019-12-27 11:06:39.355959',0,0,0,0,19,31);
INSERT INTO "oneid_meta_userperm" VALUES(628,'fc87858c885f49149d4b564c771a33dd',0,1,'2020-01-07 12:20:04.974014','2019-12-27 11:06:39.357183',0,0,0,0,20,31);
INSERT INTO "oneid_meta_userperm" VALUES(629,'b6bae139b2fc424f8bdf309260ec3402',0,1,'2020-01-07 12:20:04.986874','2019-12-27 11:06:39.358485',0,0,0,0,21,31);
INSERT INTO "oneid_meta_userperm" VALUES(630,'33d01a6757904342aba71251f5963849',0,1,'2020-01-07 12:20:05.011720','2019-12-27 11:06:56.337085',0,0,0,0,1,32);
INSERT INTO "oneid_meta_userperm" VALUES(631,'a32ff6f6eacf4226825d54e8f0ca78ec',0,1,'2020-01-07 12:20:05.023524','2019-12-27 11:06:56.338914',0,0,0,0,2,32);
INSERT INTO "oneid_meta_userperm" VALUES(632,'ee0a152627be4542a9476e263ef77f16',0,1,'2020-01-07 12:20:05.036688','2019-12-27 11:06:56.340388',0,0,0,0,3,32);
INSERT INTO "oneid_meta_userperm" VALUES(633,'3fd9ce4c086e4ae99272191520569013',0,1,'2020-01-07 12:20:05.050510','2019-12-27 11:06:56.341759',0,0,0,0,4,32);
INSERT INTO "oneid_meta_userperm" VALUES(634,'fad9fdda91044a05be81a207f2ae6d6b',0,1,'2020-01-07 12:20:05.065274','2019-12-27 11:06:56.343661',0,0,0,0,5,32);
INSERT INTO "oneid_meta_userperm" VALUES(635,'1679daf3eb1a4922b1b2de4e57936a93',0,1,'2020-01-07 12:20:05.079182','2019-12-27 11:06:56.345143',0,0,0,0,6,32);
INSERT INTO "oneid_meta_userperm" VALUES(636,'fa62da593fe94de1aab3784cf890f755',0,1,'2020-01-07 12:20:05.090245','2019-12-27 11:06:56.346642',0,0,0,0,7,32);
INSERT INTO "oneid_meta_userperm" VALUES(637,'17851aa0629442efb88509d7aa543988',0,1,'2020-01-07 12:20:05.114188','2019-12-27 11:06:56.348058',0,0,0,0,8,32);
INSERT INTO "oneid_meta_userperm" VALUES(638,'57dd4d97265b45d59d4bedda14919ad8',0,1,'2020-01-07 12:20:05.126336','2019-12-27 11:06:56.349450',0,0,0,0,9,32);
INSERT INTO "oneid_meta_userperm" VALUES(639,'c9b97dc0c76a4f879dfba1bbd4783ed8',0,1,'2020-01-07 12:20:05.136701','2019-12-27 11:06:56.350960',0,0,0,0,10,32);
INSERT INTO "oneid_meta_userperm" VALUES(640,'26637459873446e985429f3c4e03e1f3',0,1,'2020-01-07 12:20:05.148724','2019-12-27 11:06:56.352219',0,0,0,0,11,32);
INSERT INTO "oneid_meta_userperm" VALUES(641,'5c33df1fe4d24f61827848d903ef7977',0,1,'2020-01-07 12:20:05.160992','2019-12-27 11:06:56.353535',0,0,0,0,12,32);
INSERT INTO "oneid_meta_userperm" VALUES(642,'2d54c4d0c9584c028d0b5bec4ca58c1e',0,1,'2020-01-07 12:20:05.173247','2019-12-27 11:06:56.354946',0,0,0,0,13,32);
INSERT INTO "oneid_meta_userperm" VALUES(643,'4f8d7f8d6ba04c0a83472a8dfaeb5a3c',0,1,'2020-01-07 12:20:05.183914','2019-12-27 11:06:56.356565',0,0,0,0,14,32);
INSERT INTO "oneid_meta_userperm" VALUES(644,'89c122ee7a974aecbff06b1ebd4f07cb',0,1,'2020-01-07 12:20:05.206829','2019-12-27 11:06:56.357939',0,0,0,0,15,32);
INSERT INTO "oneid_meta_userperm" VALUES(645,'2d340d2eae244944b5015f4f9dfc5dd3',0,1,'2020-01-07 12:20:05.221499','2019-12-27 11:06:56.359739',0,0,0,0,16,32);
INSERT INTO "oneid_meta_userperm" VALUES(646,'8671b2dcf45740feb6b20a397a4c4677',0,1,'2020-01-07 12:20:05.234695','2019-12-27 11:06:56.361234',0,0,0,0,17,32);
INSERT INTO "oneid_meta_userperm" VALUES(647,'e9bbd68535234ed5ba80aa7a4e67a174',0,1,'2020-01-07 12:20:05.247089','2019-12-27 11:06:56.362524',0,0,0,0,18,32);
INSERT INTO "oneid_meta_userperm" VALUES(648,'f1ff2e35b33f442ba41add3ad1391858',0,1,'2020-01-07 12:20:05.262941','2019-12-27 11:06:56.363835',0,0,0,0,19,32);
INSERT INTO "oneid_meta_userperm" VALUES(649,'73bc4a5da78f445c8986715f9c2e0791',0,1,'2020-01-07 12:20:05.284067','2019-12-27 11:06:56.365134',0,0,0,0,20,32);
INSERT INTO "oneid_meta_userperm" VALUES(650,'59d788325ddc41c4986aa8ad3618cd95',0,1,'2020-01-07 12:20:05.315382','2019-12-27 11:06:56.366372',0,0,0,0,21,32);
INSERT INTO "oneid_meta_userperm" VALUES(651,'17fcb1dfe353400198b90044e18e5b0b',0,1,'2020-01-07 12:20:05.329762','2019-12-27 11:07:33.916924',0,0,0,0,1,33);
INSERT INTO "oneid_meta_userperm" VALUES(652,'89ee0b38bdab4aefb63fb8a963dc5680',0,1,'2020-01-07 12:20:05.338917','2019-12-27 11:07:33.918570',0,0,0,0,2,33);
INSERT INTO "oneid_meta_userperm" VALUES(653,'f75b3763ff7548e191b093120dcef263',0,1,'2020-01-07 12:20:05.362094','2019-12-27 11:07:33.920741',0,0,0,0,3,33);
INSERT INTO "oneid_meta_userperm" VALUES(654,'ea5eb828efd949e9bad0db9e216c24d5',0,1,'2020-01-07 12:20:05.376737','2019-12-27 11:07:33.922784',0,0,0,0,4,33);
INSERT INTO "oneid_meta_userperm" VALUES(655,'36247fc83cf644fda8bd6e7a88dd7e29',0,1,'2020-01-07 12:20:05.389371','2019-12-27 11:07:33.924716',0,0,0,0,5,33);
INSERT INTO "oneid_meta_userperm" VALUES(656,'0ea32a88aed244aa97c94e02f5948152',0,1,'2020-01-07 12:20:05.416347','2019-12-27 11:07:33.926356',0,0,0,0,6,33);
INSERT INTO "oneid_meta_userperm" VALUES(657,'e2a5310844bc4c0691400a133c79d831',0,1,'2020-01-07 12:20:05.432926','2019-12-27 11:07:33.927634',0,0,0,0,7,33);
INSERT INTO "oneid_meta_userperm" VALUES(658,'8b9fb69483e844d7a3d39c75c37b6078',0,1,'2020-01-07 12:20:05.447364','2019-12-27 11:07:33.929090',0,0,0,0,8,33);
INSERT INTO "oneid_meta_userperm" VALUES(659,'e6cebae526a34fcb94e2ffc34faa50bb',0,1,'2020-01-07 12:20:05.465208','2019-12-27 11:07:33.930437',0,0,0,0,9,33);
INSERT INTO "oneid_meta_userperm" VALUES(660,'afda02471dc9432ca4f48d19492b4b7d',0,1,'2020-01-07 12:20:05.481712','2019-12-27 11:07:33.931900',0,0,0,0,10,33);
INSERT INTO "oneid_meta_userperm" VALUES(661,'9c741ebeb0da4d59bc04a8c865b8cf04',0,1,'2020-01-07 12:20:05.499545','2019-12-27 11:07:33.933210',0,0,0,0,11,33);
INSERT INTO "oneid_meta_userperm" VALUES(662,'4d7174156ed34a1785ca3859c6cd2f96',0,1,'2020-01-07 12:20:05.556053','2019-12-27 11:07:33.934631',0,0,0,0,12,33);
INSERT INTO "oneid_meta_userperm" VALUES(663,'5213169b08b545ddb1c8630aa276f7ae',0,1,'2020-01-07 12:20:05.572112','2019-12-27 11:07:33.936350',0,0,0,0,13,33);
INSERT INTO "oneid_meta_userperm" VALUES(664,'f50acd0f3ded4b8d9c5ec1d11b7e9b49',0,1,'2020-01-07 12:20:05.593707','2019-12-27 11:07:33.937737',0,0,0,0,14,33);
INSERT INTO "oneid_meta_userperm" VALUES(665,'d6357779afad4a88bb25dca07e346d0a',0,1,'2020-01-07 12:20:05.631592','2019-12-27 11:07:33.939205',0,0,0,0,15,33);
INSERT INTO "oneid_meta_userperm" VALUES(666,'3f60f30ef0e74c8b96966471ac903260',0,1,'2020-01-07 12:20:05.652232','2019-12-27 11:07:33.940528',0,0,0,0,16,33);
INSERT INTO "oneid_meta_userperm" VALUES(667,'8204564fdee44906afa71d16ba8332cf',0,1,'2020-01-07 12:20:05.672967','2019-12-27 11:07:33.941803',0,0,0,0,17,33);
INSERT INTO "oneid_meta_userperm" VALUES(668,'7c8ef3e7f7934ebd87e5b54e810146d0',0,1,'2020-01-07 12:20:05.689006','2019-12-27 11:07:33.943263',0,0,0,0,18,33);
INSERT INTO "oneid_meta_userperm" VALUES(669,'dfc167f9a8dd4650b68b30df7faea0c4',0,1,'2020-01-07 12:20:05.706817','2019-12-27 11:07:33.944634',0,0,0,0,19,33);
INSERT INTO "oneid_meta_userperm" VALUES(670,'28b37688e6b94db5ac0b4f397d8291c2',0,1,'2020-01-07 12:20:05.733740','2019-12-27 11:07:33.946006',0,0,0,0,20,33);
INSERT INTO "oneid_meta_userperm" VALUES(671,'3fa87ad1b04c406a96cb0ccf4d5bddd3',0,1,'2020-01-07 12:20:05.747314','2019-12-27 11:07:33.947341',0,0,0,0,21,33);
INSERT INTO "oneid_meta_userperm" VALUES(672,'ce670f2da31c4585842454d8f72cb509',0,1,'2020-01-07 12:20:05.759291','2019-12-27 11:14:52.857909',0,0,0,0,1,34);
INSERT INTO "oneid_meta_userperm" VALUES(673,'533a1f8fd1b5459797ebabeb08aafbdb',0,1,'2020-01-07 12:20:05.770421','2019-12-27 11:14:52.859914',0,0,0,0,2,34);
INSERT INTO "oneid_meta_userperm" VALUES(674,'f74025e0d05846339d327931bf2e1303',0,1,'2020-01-07 12:20:05.783647','2019-12-27 11:14:52.861616',0,0,0,0,3,34);
INSERT INTO "oneid_meta_userperm" VALUES(675,'d5574d02ce1d4400833abcd2d48b64ad',0,1,'2020-01-07 12:20:05.797733','2019-12-27 11:14:52.862934',0,0,0,0,4,34);
INSERT INTO "oneid_meta_userperm" VALUES(676,'67a94c5e47b145d39cbb3975383defef',0,1,'2020-01-07 12:20:05.809154','2019-12-27 11:14:52.864085',0,0,0,0,5,34);
INSERT INTO "oneid_meta_userperm" VALUES(677,'ef77817b4f814d6ebec24bcccfaf2325',0,1,'2020-01-07 12:20:05.831807','2019-12-27 11:14:52.865239',0,0,0,0,6,34);
INSERT INTO "oneid_meta_userperm" VALUES(678,'68d9a7a2768545298da1891f2093c939',0,1,'2020-01-07 12:20:05.843664','2019-12-27 11:14:52.866396',0,0,0,0,7,34);
INSERT INTO "oneid_meta_userperm" VALUES(679,'6e8d31f602d5411aa2c9ece5399fca6b',0,1,'2020-01-07 12:20:05.855189','2019-12-27 11:14:52.867550',0,0,0,0,8,34);
INSERT INTO "oneid_meta_userperm" VALUES(680,'88da9225ebb9466fbb7383ece6e3ac13',0,1,'2020-01-07 12:20:05.869206','2019-12-27 11:14:52.868694',0,0,0,0,9,34);
INSERT INTO "oneid_meta_userperm" VALUES(681,'ad7269720c9b49ffa2125bd1794dff86',0,1,'2020-01-07 12:20:05.883060','2019-12-27 11:14:52.870028',0,0,0,0,10,34);
INSERT INTO "oneid_meta_userperm" VALUES(682,'2a71887d33f14f0598a0ad4e4dd1b17d',0,1,'2020-01-07 12:20:05.896997','2019-12-27 11:14:52.871440',0,0,0,0,11,34);
INSERT INTO "oneid_meta_userperm" VALUES(683,'f20fb86aaaa34013bd8ef8a953fcb63d',0,1,'2020-01-07 12:20:05.908438','2019-12-27 11:14:52.872903',0,0,0,0,12,34);
INSERT INTO "oneid_meta_userperm" VALUES(684,'c93c5439c5244ab1ac6822c73059e9eb',0,1,'2020-01-07 12:20:05.920522','2019-12-27 11:14:52.874134',0,0,0,0,13,34);
INSERT INTO "oneid_meta_userperm" VALUES(685,'258c06f96fec4511b6323f8d0d0848d6',0,1,'2020-01-07 12:20:05.941505','2019-12-27 11:14:52.875282',0,0,0,0,14,34);
INSERT INTO "oneid_meta_userperm" VALUES(686,'c44b0f2328f64e46afa9f1f34aeb53e2',0,1,'2020-01-07 12:20:05.952536','2019-12-27 11:14:52.876504',0,0,0,0,15,34);
INSERT INTO "oneid_meta_userperm" VALUES(687,'b45585ea261a42cf83e8313cf8812df5',0,1,'2020-01-07 12:20:05.963536','2019-12-27 11:14:52.877778',0,0,0,0,16,34);
INSERT INTO "oneid_meta_userperm" VALUES(688,'1ca6f054572a43128c542641526d2e02',0,1,'2020-01-07 12:20:05.975612','2019-12-27 11:14:52.878972',0,0,0,0,17,34);
INSERT INTO "oneid_meta_userperm" VALUES(689,'71bc278d94b24f5396d9c07075cd2417',0,1,'2020-01-07 12:20:05.986619','2019-12-27 11:14:52.880125',0,0,0,0,18,34);
INSERT INTO "oneid_meta_userperm" VALUES(690,'66f03b2ad73649be901c52501137c5e0',0,1,'2020-01-07 12:20:06.000604','2019-12-27 11:14:52.881376',0,0,0,0,19,34);
INSERT INTO "oneid_meta_userperm" VALUES(691,'84c71233770e44fb942e9919a0b2392d',0,1,'2020-01-07 12:20:06.011535','2019-12-27 11:14:52.882588',0,0,0,0,20,34);
INSERT INTO "oneid_meta_userperm" VALUES(692,'8179f49f07964fe58155007420f8397a',0,1,'2020-01-07 12:20:06.023028','2019-12-27 11:14:52.883891',0,0,0,0,21,34);
CREATE TABLE "oneid_meta_wechatconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "appid" varchar(255) NOT NULL, "secret" varchar(255) NOT NULL, "qr_app_valid" bool NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_wechatuser" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "unionid" text NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_workwechatconfig" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "corp_id" varchar(255) NOT NULL, "agent_id" varchar(64) NOT NULL, "secret" varchar(255) NOT NULL, "qr_app_valid" bool NOT NULL, "site_id" integer NOT NULL UNIQUE REFERENCES "django_site" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "oneid_meta_workwechatuser" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uuid" char(32) NOT NULL UNIQUE, "is_del" bool NOT NULL, "is_active" bool NOT NULL, "updated" datetime NULL, "created" datetime NULL, "work_wechat_user_id" text NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "oneid_meta_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "organization" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(128) NOT NULL, "o" varchar(128) NOT NULL);
INSERT INTO "organization" VALUES(1,'example','Example Inc.');
CREATE TABLE "organization_unit" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(128) NOT NULL, "ou" varchar(128) NOT NULL);
INSERT INTO "organization_unit" VALUES(1,'用户','people');
INSERT INTO "organization_unit" VALUES(2,'部门','dept');
INSERT INTO "organization_unit" VALUES(3,'组','group');
CREATE TABLE "raw_ldap_entries" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "dn" varchar(256) NOT NULL, "keyval" integer NOT NULL, "subject" integer NOT NULL, "oc_map_id" integer NOT NULL REFERENCES "ldap_oc_mappings" ("id") DEFERRABLE INITIALLY DEFERRED, "parent_id" integer NULL REFERENCES "raw_ldap_entries" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO "raw_ldap_entries" VALUES(1,'dc=example,dc=org',1,0,1,NULL);
INSERT INTO "raw_ldap_entries" VALUES(2,'ou=people,dc=example,dc=org',1,0,3,1);
INSERT INTO "raw_ldap_entries" VALUES(3,'ou=dept,dc=example,dc=org',2,0,3,1);
INSERT INTO "raw_ldap_entries" VALUES(4,'ou=group,dc=example,dc=org',3,0,3,1);
DELETE FROM "sqlite_sequence";
INSERT INTO "sqlite_sequence" VALUES('django_admin_log',0);
INSERT INTO "sqlite_sequence" VALUES('django_content_type',63);
INSERT INTO "sqlite_sequence" VALUES('auth_permission',189);
INSERT INTO "sqlite_sequence" VALUES('auth_user',1);
INSERT INTO "sqlite_sequence" VALUES('django_celery_beat_periodictask',6);
INSERT INTO "sqlite_sequence" VALUES('django_celery_beat_solarschedule',0);
INSERT INTO "sqlite_sequence" VALUES('django_celery_beat_crontabschedule',0);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_deptmember',30);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_groupmember',51);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_posixuser',0);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_dingdept',0);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_deptperm',651);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_groupperm',1470);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_userperm',692);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_dinggroup',0);
INSERT INTO "sqlite_sequence" VALUES('oauth2_provider_accesstoken',0);
INSERT INTO "sqlite_sequence" VALUES('oauth2_provider_grant',0);
INSERT INTO "sqlite_sequence" VALUES('oauth2_provider_refreshtoken',0);
INSERT INTO "sqlite_sequence" VALUES('oauth2_provider_application',1);
INSERT INTO "sqlite_sequence" VALUES('django_site',1);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_log',662);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_dept',31);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_group',70);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_companyconfig',1);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_app',14);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_managergroup',21);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_smsconfig',1);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_customfield',0);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_nativefield',14);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_dingconfig',2);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_accountconfig',1);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_dinguser',0);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_user',34);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_emailconfig',1);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_perm',21);
INSERT INTO "sqlite_sequence" VALUES('django_celery_beat_intervalschedule',2);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_requestaccesslog',419);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_requestdataclientlog',419);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_invitation',5);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_ldapapp',1);
INSERT INTO "sqlite_sequence" VALUES('oneid_meta_storageconfig',1);
INSERT INTO "sqlite_sequence" VALUES('django_celery_results_taskresult',253);
CREATE UNIQUE INDEX auth_group_permissions_group_id_permission_id_0cd325b0_uniq ON "auth_group_permissions" ("group_id", "permission_id");
CREATE INDEX "auth_group_permissions_group_id_b120cbf9" ON "auth_group_permissions" ("group_id");
CREATE INDEX "auth_group_permissions_permission_id_84c5c92e" ON "auth_group_permissions" ("permission_id");
CREATE UNIQUE INDEX auth_user_groups_user_id_group_id_94350c0c_uniq ON "auth_user_groups" ("user_id", "group_id");
CREATE INDEX "auth_user_groups_user_id_6a12ed8b" ON "auth_user_groups" ("user_id");
CREATE INDEX "auth_user_groups_group_id_97559544" ON "auth_user_groups" ("group_id");
CREATE UNIQUE INDEX auth_user_user_permissions_user_id_permission_id_14a6b632_uniq ON "auth_user_user_permissions" ("user_id", "permission_id");
CREATE INDEX "auth_user_user_permissions_user_id_a95ead1b" ON "auth_user_user_permissions" ("user_id");
CREATE INDEX "auth_user_user_permissions_permission_id_1fbb5f2c" ON "auth_user_user_permissions" ("permission_id");
CREATE INDEX "django_admin_log_content_type_id_c4bce8eb" ON "django_admin_log" ("content_type_id");
CREATE INDEX "django_admin_log_user_id_c564eba6" ON "django_admin_log" ("user_id");
CREATE UNIQUE INDEX django_content_type_app_label_model_76bd3d3b_uniq ON "django_content_type" ("app_label", "model");
CREATE UNIQUE INDEX auth_permission_content_type_id_codename_01ab375a_uniq ON "auth_permission" ("content_type_id", "codename");
CREATE INDEX "auth_permission_content_type_id_2f476e4b" ON "auth_permission" ("content_type_id");
CREATE INDEX "django_celery_beat_periodictask_crontab_id_d3cba168" ON "django_celery_beat_periodictask" ("crontab_id");
CREATE INDEX "django_celery_beat_periodictask_interval_id_a8ca27da" ON "django_celery_beat_periodictask" ("interval_id");
CREATE INDEX "django_celery_beat_periodictask_solar_id_a87ce72c" ON "django_celery_beat_periodictask" ("solar_id");
CREATE UNIQUE INDEX django_celery_beat_solarschedule_event_latitude_longitude_ba64999a_uniq ON "django_celery_beat_solarschedule" ("event", "latitude", "longitude");
CREATE INDEX "django_celery_results_taskresult_hidden_cd77412f" ON "django_celery_results_taskresult" ("hidden");
CREATE INDEX "oneid_meta_deptmember_owner_id_bdae7f90" ON "oneid_meta_deptmember" ("owner_id");
CREATE INDEX "oneid_meta_deptmember_user_id_07cf7165" ON "oneid_meta_deptmember" ("user_id");
CREATE INDEX "oneid_meta_groupmember_owner_id_c62a9300" ON "oneid_meta_groupmember" ("owner_id");
CREATE INDEX "oneid_meta_groupmember_user_id_5e898bfd" ON "oneid_meta_groupmember" ("user_id");
CREATE INDEX "oneid_meta_deptperm_perm_id_e04aec20" ON "oneid_meta_deptperm" ("perm_id");
CREATE INDEX "oneid_meta_deptperm_owner_id_96944119" ON "oneid_meta_deptperm" ("owner_id");
CREATE INDEX "oneid_meta_groupperm_perm_id_ec0cc4fe" ON "oneid_meta_groupperm" ("perm_id");
CREATE INDEX "oneid_meta_groupperm_owner_id_e9c02476" ON "oneid_meta_groupperm" ("owner_id");
CREATE INDEX "oneid_meta_userperm_perm_id_07055248" ON "oneid_meta_userperm" ("perm_id");
CREATE INDEX "oneid_meta_userperm_owner_id_7cd3c154" ON "oneid_meta_userperm" ("owner_id");
CREATE UNIQUE INDEX oneid_meta_deptmember_user_id_owner_id_7def58ad_uniq ON "oneid_meta_deptmember" ("user_id", "owner_id");
CREATE UNIQUE INDEX oneid_meta_groupmember_user_id_owner_id_795bb584_uniq ON "oneid_meta_groupmember" ("user_id", "owner_id");
CREATE INDEX "oauth2_provider_accesstoken_application_id_b22886e1" ON "oauth2_provider_accesstoken" ("application_id");
CREATE INDEX "oauth2_provider_accesstoken_user_id_6e4c9a65" ON "oauth2_provider_accesstoken" ("user_id");
CREATE INDEX "oauth2_provider_grant_application_id_81923564" ON "oauth2_provider_grant" ("application_id");
CREATE INDEX "oauth2_provider_grant_user_id_e8f62af8" ON "oauth2_provider_grant" ("user_id");
CREATE UNIQUE INDEX oauth2_provider_refreshtoken_token_revoked_af8a5134_uniq ON "oauth2_provider_refreshtoken" ("token", "revoked");
CREATE INDEX "oauth2_provider_refreshtoken_application_id_2d1c311b" ON "oauth2_provider_refreshtoken" ("application_id");
CREATE INDEX "oauth2_provider_refreshtoken_user_id_da837fce" ON "oauth2_provider_refreshtoken" ("user_id");
CREATE INDEX "oauth2_provider_application_client_secret_53133678" ON "oauth2_provider_application" ("client_secret");
CREATE INDEX "oauth2_provider_application_user_id_79829054" ON "oauth2_provider_application" ("user_id");
CREATE UNIQUE INDEX oneid_meta_deptperm_owner_id_perm_id_f934c3e6_uniq ON "oneid_meta_deptperm" ("owner_id", "perm_id");
CREATE UNIQUE INDEX oneid_meta_groupperm_owner_id_perm_id_c8097eca_uniq ON "oneid_meta_groupperm" ("owner_id", "perm_id");
CREATE UNIQUE INDEX oneid_meta_userperm_owner_id_perm_id_67e375da_uniq ON "oneid_meta_userperm" ("owner_id", "perm_id");
CREATE INDEX "oneid_meta_invitation_invitee_id_6d6216e1" ON "oneid_meta_invitation" ("invitee_id");
CREATE INDEX "oneid_meta_invitation_inviter_id_a0d8cdc8" ON "oneid_meta_invitation" ("inviter_id");
CREATE INDEX "oneid_meta_log_access_id_83245304" ON "oneid_meta_log" ("access_id");
CREATE INDEX "oneid_meta_log_data_id_a5e18508" ON "oneid_meta_log" ("data_id");
CREATE INDEX "oneid_meta_log_user_id_d82583a3" ON "oneid_meta_log" ("user_id");
CREATE INDEX "oneid_meta_dept_parent_id_1816bcc8" ON "oneid_meta_dept" ("parent_id");
CREATE INDEX "oneid_meta_group_parent_id_9a86291d" ON "oneid_meta_group" ("parent_id");
CREATE INDEX "oneid_meta_user_django_user_id_f1d43285" ON "oneid_meta_user" ("django_user_id");
CREATE INDEX "django_session_expire_date_a5c62663" ON "django_session" ("expire_date");
CREATE INDEX "oneid_meta_perm_sub_account_id_f29cb92f" ON "oneid_meta_perm" ("sub_account_id");
COMMIT;
