import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type JFrog::Artifactory::Core::MODULE
 *
 * @schema CfnCoreModuleProps
 */
export interface CfnCoreModuleProps {
    /**
     * @schema CfnCoreModuleProps#Parameters
     */
    readonly parameters?: CfnCoreModulePropsParameters;
    /**
     * @schema CfnCoreModuleProps#Resources
     */
    readonly resources?: CfnCoreModulePropsResources;
}
/**
 * Converts an object of type 'CfnCoreModuleProps' to JSON representation.
 */
export declare function toJson_CfnCoreModuleProps(obj: CfnCoreModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParameters
 */
export interface CfnCoreModulePropsParameters {
    /**
     * Availability Zone 1 to use for the subnets in the VPC. Two Availability Zones are used for this deployment.
     *
     * @schema CfnCoreModulePropsParameters#AvailabilityZone1
     */
    readonly availabilityZone1?: CfnCoreModulePropsParametersAvailabilityZone1;
    /**
     * Availability Zone 2 to use for the subnets in the VPC. Two Availability Zones are used for this deployment.
     *
     * @schema CfnCoreModulePropsParameters#AvailabilityZone2
     */
    readonly availabilityZone2?: CfnCoreModulePropsParametersAvailabilityZone2;
    /**
     * @schema CfnCoreModulePropsParameters#VpcId
     */
    readonly vpcId?: CfnCoreModulePropsParametersVpcId;
    /**
     * CIDR block for the VPC
     *
     * @schema CfnCoreModulePropsParameters#VpcCidr
     */
    readonly vpcCidr?: CfnCoreModulePropsParametersVpcCidr;
    /**
     * @schema CfnCoreModulePropsParameters#PrivateSubnet1Cidr
     */
    readonly privateSubnet1Cidr?: CfnCoreModulePropsParametersPrivateSubnet1Cidr;
    /**
     * @schema CfnCoreModulePropsParameters#PrivateSubnet2Cidr
     */
    readonly privateSubnet2Cidr?: CfnCoreModulePropsParametersPrivateSubnet2Cidr;
    /**
     * @schema CfnCoreModulePropsParameters#PrivateSubnet3Cidr
     */
    readonly privateSubnet3Cidr?: CfnCoreModulePropsParametersPrivateSubnet3Cidr;
    /**
     * ID of the private subnet in Availability Zone 1 of your existing VPC (e.g., subnet-z0376dab).
     *
     * @schema CfnCoreModulePropsParameters#PrivateSubnet1Id
     */
    readonly privateSubnet1Id?: CfnCoreModulePropsParametersPrivateSubnet1Id;
    /**
     * ID of the private subnet in Availability Zone 1 of your existing VPC (e.g., subnet-z0376dab).
     *
     * @schema CfnCoreModulePropsParameters#PrivateSubnet2Id
     */
    readonly privateSubnet2Id?: CfnCoreModulePropsParametersPrivateSubnet2Id;
    /**
     * @schema CfnCoreModulePropsParameters#DatabaseAllocatedStorage
     */
    readonly databaseAllocatedStorage?: CfnCoreModulePropsParametersDatabaseAllocatedStorage;
    /**
     * @schema CfnCoreModulePropsParameters#DatabasePreferredAz
     */
    readonly databasePreferredAz?: CfnCoreModulePropsParametersDatabasePreferredAz;
    /**
     * Choose false to create an Amazon RDS instance in a single Availability Zone.
     *
     * @schema CfnCoreModulePropsParameters#MultiAzDatabase
     */
    readonly multiAzDatabase?: CfnCoreModulePropsParametersMultiAzDatabase;
    /**
     * @schema CfnCoreModulePropsParameters#DatabaseEngine
     */
    readonly databaseEngine?: CfnCoreModulePropsParametersDatabaseEngine;
    /**
     * @schema CfnCoreModulePropsParameters#DatabaseUser
     */
    readonly databaseUser?: CfnCoreModulePropsParametersDatabaseUser;
    /**
     * @schema CfnCoreModulePropsParameters#DatabasePassword
     */
    readonly databasePassword?: CfnCoreModulePropsParametersDatabasePassword;
    /**
     * @schema CfnCoreModulePropsParameters#DatabaseInstance
     */
    readonly databaseInstance?: CfnCoreModulePropsParametersDatabaseInstance;
    /**
     * @schema CfnCoreModulePropsParameters#DatabaseName
     */
    readonly databaseName?: CfnCoreModulePropsParametersDatabaseName;
    /**
     * @schema CfnCoreModulePropsParameters#ArtifactoryProduct
     */
    readonly artifactoryProduct?: CfnCoreModulePropsParametersArtifactoryProduct;
    /**
     * @schema CfnCoreModulePropsParameters#ReleaseStage
     */
    readonly releaseStage?: CfnCoreModulePropsParametersReleaseStage;
    /**
     * @schema CfnCoreModulePropsParameters#InstanceType
     */
    readonly instanceType?: CfnCoreModulePropsParametersInstanceType;
    /**
     * @schema CfnCoreModulePropsParameters#ArtifactoryHostRole
     */
    readonly artifactoryHostRole?: CfnCoreModulePropsParametersArtifactoryHostRole;
    /**
     * @schema CfnCoreModulePropsParameters#EfsSecurityGroup
     */
    readonly efsSecurityGroup?: CfnCoreModulePropsParametersEfsSecurityGroup;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParameters(obj: CfnCoreModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsResources
 */
export interface CfnCoreModulePropsResources {
    /**
     * @schema CfnCoreModulePropsResources#ArtifactoryDatabaseSubnetGroup
     */
    readonly artifactoryDatabaseSubnetGroup?: CfnCoreModulePropsResourcesArtifactoryDatabaseSubnetGroup;
    /**
     * @schema CfnCoreModulePropsResources#ArtifactoryDatabase
     */
    readonly artifactoryDatabase?: CfnCoreModulePropsResourcesArtifactoryDatabase;
    /**
     * @schema CfnCoreModulePropsResources#ArtifactoryDatabaseSG
     */
    readonly artifactoryDatabaseSg?: CfnCoreModulePropsResourcesArtifactoryDatabaseSg;
    /**
     * @schema CfnCoreModulePropsResources#ArtifactoryS3Bucket
     */
    readonly artifactoryS3Bucket?: CfnCoreModulePropsResourcesArtifactoryS3Bucket;
    /**
     * @schema CfnCoreModulePropsResources#ArtifactoryS3IAMPolicy
     */
    readonly artifactoryS3IamPolicy?: CfnCoreModulePropsResourcesArtifactoryS3IamPolicy;
    /**
     * @schema CfnCoreModulePropsResources#ArtifactoryEfsFileSystem
     */
    readonly artifactoryEfsFileSystem?: CfnCoreModulePropsResourcesArtifactoryEfsFileSystem;
    /**
     * @schema CfnCoreModulePropsResources#ArtifactoryEfsMountTarget1
     */
    readonly artifactoryEfsMountTarget1?: CfnCoreModulePropsResourcesArtifactoryEfsMountTarget1;
    /**
     * @schema CfnCoreModulePropsResources#ArtifactoryEfsMountTarget2
     */
    readonly artifactoryEfsMountTarget2?: CfnCoreModulePropsResourcesArtifactoryEfsMountTarget2;
}
/**
 * Converts an object of type 'CfnCoreModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsResources(obj: CfnCoreModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Availability Zone 1 to use for the subnets in the VPC. Two Availability Zones are used for this deployment.
 *
 * @schema CfnCoreModulePropsParametersAvailabilityZone1
 */
export interface CfnCoreModulePropsParametersAvailabilityZone1 {
    /**
     * @schema CfnCoreModulePropsParametersAvailabilityZone1#Type
     */
    readonly type: string;
    /**
     * @schema CfnCoreModulePropsParametersAvailabilityZone1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersAvailabilityZone1' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersAvailabilityZone1(obj: CfnCoreModulePropsParametersAvailabilityZone1 | undefined): Record<string, any> | undefined;
/**
 * Availability Zone 2 to use for the subnets in the VPC. Two Availability Zones are used for this deployment.
 *
 * @schema CfnCoreModulePropsParametersAvailabilityZone2
 */
export interface CfnCoreModulePropsParametersAvailabilityZone2 {
    /**
     * @schema CfnCoreModulePropsParametersAvailabilityZone2#Type
     */
    readonly type: string;
    /**
     * @schema CfnCoreModulePropsParametersAvailabilityZone2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersAvailabilityZone2' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersAvailabilityZone2(obj: CfnCoreModulePropsParametersAvailabilityZone2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersVpcId
 */
export interface CfnCoreModulePropsParametersVpcId {
    /**
     * @schema CfnCoreModulePropsParametersVpcId#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersVpcId' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersVpcId(obj: CfnCoreModulePropsParametersVpcId | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the VPC
 *
 * @schema CfnCoreModulePropsParametersVpcCidr
 */
export interface CfnCoreModulePropsParametersVpcCidr {
    /**
     * @schema CfnCoreModulePropsParametersVpcCidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnCoreModulePropsParametersVpcCidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersVpcCidr' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersVpcCidr(obj: CfnCoreModulePropsParametersVpcCidr | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersPrivateSubnet1Cidr
 */
export interface CfnCoreModulePropsParametersPrivateSubnet1Cidr {
    /**
     * @schema CfnCoreModulePropsParametersPrivateSubnet1Cidr#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersPrivateSubnet1Cidr' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersPrivateSubnet1Cidr(obj: CfnCoreModulePropsParametersPrivateSubnet1Cidr | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersPrivateSubnet2Cidr
 */
export interface CfnCoreModulePropsParametersPrivateSubnet2Cidr {
    /**
     * @schema CfnCoreModulePropsParametersPrivateSubnet2Cidr#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersPrivateSubnet2Cidr' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersPrivateSubnet2Cidr(obj: CfnCoreModulePropsParametersPrivateSubnet2Cidr | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersPrivateSubnet3Cidr
 */
export interface CfnCoreModulePropsParametersPrivateSubnet3Cidr {
    /**
     * @schema CfnCoreModulePropsParametersPrivateSubnet3Cidr#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersPrivateSubnet3Cidr' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersPrivateSubnet3Cidr(obj: CfnCoreModulePropsParametersPrivateSubnet3Cidr | undefined): Record<string, any> | undefined;
/**
 * ID of the private subnet in Availability Zone 1 of your existing VPC (e.g., subnet-z0376dab).
 *
 * @schema CfnCoreModulePropsParametersPrivateSubnet1Id
 */
export interface CfnCoreModulePropsParametersPrivateSubnet1Id {
    /**
     * @schema CfnCoreModulePropsParametersPrivateSubnet1Id#Type
     */
    readonly type: string;
    /**
     * @schema CfnCoreModulePropsParametersPrivateSubnet1Id#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersPrivateSubnet1Id' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersPrivateSubnet1Id(obj: CfnCoreModulePropsParametersPrivateSubnet1Id | undefined): Record<string, any> | undefined;
/**
 * ID of the private subnet in Availability Zone 1 of your existing VPC (e.g., subnet-z0376dab).
 *
 * @schema CfnCoreModulePropsParametersPrivateSubnet2Id
 */
export interface CfnCoreModulePropsParametersPrivateSubnet2Id {
    /**
     * @schema CfnCoreModulePropsParametersPrivateSubnet2Id#Type
     */
    readonly type: string;
    /**
     * @schema CfnCoreModulePropsParametersPrivateSubnet2Id#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersPrivateSubnet2Id' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersPrivateSubnet2Id(obj: CfnCoreModulePropsParametersPrivateSubnet2Id | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersDatabaseAllocatedStorage
 */
export interface CfnCoreModulePropsParametersDatabaseAllocatedStorage {
    /**
     * @schema CfnCoreModulePropsParametersDatabaseAllocatedStorage#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersDatabaseAllocatedStorage' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersDatabaseAllocatedStorage(obj: CfnCoreModulePropsParametersDatabaseAllocatedStorage | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersDatabasePreferredAz
 */
export interface CfnCoreModulePropsParametersDatabasePreferredAz {
    /**
     * @schema CfnCoreModulePropsParametersDatabasePreferredAz#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersDatabasePreferredAz' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersDatabasePreferredAz(obj: CfnCoreModulePropsParametersDatabasePreferredAz | undefined): Record<string, any> | undefined;
/**
 * Choose false to create an Amazon RDS instance in a single Availability Zone.
 *
 * @schema CfnCoreModulePropsParametersMultiAzDatabase
 */
export interface CfnCoreModulePropsParametersMultiAzDatabase {
    /**
     * @schema CfnCoreModulePropsParametersMultiAzDatabase#Type
     */
    readonly type: string;
    /**
     * @schema CfnCoreModulePropsParametersMultiAzDatabase#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersMultiAzDatabase' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersMultiAzDatabase(obj: CfnCoreModulePropsParametersMultiAzDatabase | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersDatabaseEngine
 */
export interface CfnCoreModulePropsParametersDatabaseEngine {
    /**
     * @schema CfnCoreModulePropsParametersDatabaseEngine#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersDatabaseEngine' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersDatabaseEngine(obj: CfnCoreModulePropsParametersDatabaseEngine | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersDatabaseUser
 */
export interface CfnCoreModulePropsParametersDatabaseUser {
    /**
     * @schema CfnCoreModulePropsParametersDatabaseUser#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersDatabaseUser' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersDatabaseUser(obj: CfnCoreModulePropsParametersDatabaseUser | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersDatabasePassword
 */
export interface CfnCoreModulePropsParametersDatabasePassword {
    /**
     * @schema CfnCoreModulePropsParametersDatabasePassword#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersDatabasePassword' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersDatabasePassword(obj: CfnCoreModulePropsParametersDatabasePassword | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersDatabaseInstance
 */
export interface CfnCoreModulePropsParametersDatabaseInstance {
    /**
     * @schema CfnCoreModulePropsParametersDatabaseInstance#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersDatabaseInstance' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersDatabaseInstance(obj: CfnCoreModulePropsParametersDatabaseInstance | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersDatabaseName
 */
export interface CfnCoreModulePropsParametersDatabaseName {
    /**
     * @schema CfnCoreModulePropsParametersDatabaseName#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersDatabaseName' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersDatabaseName(obj: CfnCoreModulePropsParametersDatabaseName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersArtifactoryProduct
 */
export interface CfnCoreModulePropsParametersArtifactoryProduct {
    /**
     * @schema CfnCoreModulePropsParametersArtifactoryProduct#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersArtifactoryProduct' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersArtifactoryProduct(obj: CfnCoreModulePropsParametersArtifactoryProduct | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersReleaseStage
 */
export interface CfnCoreModulePropsParametersReleaseStage {
    /**
     * @schema CfnCoreModulePropsParametersReleaseStage#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersReleaseStage' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersReleaseStage(obj: CfnCoreModulePropsParametersReleaseStage | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersInstanceType
 */
export interface CfnCoreModulePropsParametersInstanceType {
    /**
     * @schema CfnCoreModulePropsParametersInstanceType#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersInstanceType' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersInstanceType(obj: CfnCoreModulePropsParametersInstanceType | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersArtifactoryHostRole
 */
export interface CfnCoreModulePropsParametersArtifactoryHostRole {
    /**
     * @schema CfnCoreModulePropsParametersArtifactoryHostRole#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersArtifactoryHostRole' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersArtifactoryHostRole(obj: CfnCoreModulePropsParametersArtifactoryHostRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsParametersEfsSecurityGroup
 */
export interface CfnCoreModulePropsParametersEfsSecurityGroup {
    /**
     * @schema CfnCoreModulePropsParametersEfsSecurityGroup#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'CfnCoreModulePropsParametersEfsSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsParametersEfsSecurityGroup(obj: CfnCoreModulePropsParametersEfsSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsResourcesArtifactoryDatabaseSubnetGroup
 */
export interface CfnCoreModulePropsResourcesArtifactoryDatabaseSubnetGroup {
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryDatabaseSubnetGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryDatabaseSubnetGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCoreModulePropsResourcesArtifactoryDatabaseSubnetGroup' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsResourcesArtifactoryDatabaseSubnetGroup(obj: CfnCoreModulePropsResourcesArtifactoryDatabaseSubnetGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsResourcesArtifactoryDatabase
 */
export interface CfnCoreModulePropsResourcesArtifactoryDatabase {
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryDatabase#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryDatabase#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCoreModulePropsResourcesArtifactoryDatabase' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsResourcesArtifactoryDatabase(obj: CfnCoreModulePropsResourcesArtifactoryDatabase | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsResourcesArtifactoryDatabaseSg
 */
export interface CfnCoreModulePropsResourcesArtifactoryDatabaseSg {
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryDatabaseSg#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryDatabaseSg#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCoreModulePropsResourcesArtifactoryDatabaseSg' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsResourcesArtifactoryDatabaseSg(obj: CfnCoreModulePropsResourcesArtifactoryDatabaseSg | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsResourcesArtifactoryS3Bucket
 */
export interface CfnCoreModulePropsResourcesArtifactoryS3Bucket {
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryS3Bucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryS3Bucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCoreModulePropsResourcesArtifactoryS3Bucket' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsResourcesArtifactoryS3Bucket(obj: CfnCoreModulePropsResourcesArtifactoryS3Bucket | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsResourcesArtifactoryS3IamPolicy
 */
export interface CfnCoreModulePropsResourcesArtifactoryS3IamPolicy {
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryS3IamPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryS3IamPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCoreModulePropsResourcesArtifactoryS3IamPolicy' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsResourcesArtifactoryS3IamPolicy(obj: CfnCoreModulePropsResourcesArtifactoryS3IamPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsResourcesArtifactoryEfsFileSystem
 */
export interface CfnCoreModulePropsResourcesArtifactoryEfsFileSystem {
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryEfsFileSystem#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryEfsFileSystem#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCoreModulePropsResourcesArtifactoryEfsFileSystem' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsResourcesArtifactoryEfsFileSystem(obj: CfnCoreModulePropsResourcesArtifactoryEfsFileSystem | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsResourcesArtifactoryEfsMountTarget1
 */
export interface CfnCoreModulePropsResourcesArtifactoryEfsMountTarget1 {
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryEfsMountTarget1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryEfsMountTarget1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCoreModulePropsResourcesArtifactoryEfsMountTarget1' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsResourcesArtifactoryEfsMountTarget1(obj: CfnCoreModulePropsResourcesArtifactoryEfsMountTarget1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCoreModulePropsResourcesArtifactoryEfsMountTarget2
 */
export interface CfnCoreModulePropsResourcesArtifactoryEfsMountTarget2 {
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryEfsMountTarget2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCoreModulePropsResourcesArtifactoryEfsMountTarget2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCoreModulePropsResourcesArtifactoryEfsMountTarget2' to JSON representation.
 */
export declare function toJson_CfnCoreModulePropsResourcesArtifactoryEfsMountTarget2(obj: CfnCoreModulePropsResourcesArtifactoryEfsMountTarget2 | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `JFrog::Artifactory::Core::MODULE`
 *
 * @cloudformationResource JFrog::Artifactory::Core::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnCoreModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "JFrog::Artifactory::Core::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnCoreModuleProps;
    /**
     * Create a new `JFrog::Artifactory::Core::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnCoreModuleProps);
}
