# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['poetry2conda']

package_data = \
{'': ['*']}

install_requires = \
['poetry-semver>=0.1.0,<0.2.0', 'toml>=0.10.0,<0.11.0']

entry_points = \
{'console_scripts': ['poetry2conda = poetry2conda.convert:main']}

setup_kwargs = {
    'name': 'poetry2conda',
    'version': '0.3.0',
    'description': 'Convert pyproject.toml to environment.yaml',
    'long_description': '============\npoetry2conda\n============\n\n.. image:: https://img.shields.io/pypi/v/poetry2conda.svg\n    :target: https://pypi.org/project/poetry2conda/\n.. image:: https://img.shields.io/pypi/l/poetry2conda.svg\n    :target: https://pypi.org/project/poetry2conda/\n.. image:: https://github.com/dojeda/poetry2conda/workflows/unit%20tests/badge.svg?branch=master\n    :target: https://github.com/dojeda/poetry2conda/actions\n\nA script to convert a Python project declared on a pyproject.toml to a conda\nenvironment.\n\nThis is not an attempt to move away from pyproject.toml to conda. It is a tool\nto help teams maintain a single file for dependencies when there are\ncollaborators that prefer regular Python/PyPI and others that prefer conda.\n\nFeatures\n--------\n\n- Set conda channels for each dependency.\n- Rename conda dependencies.\n- Convert tilde and caret dependencies to regular version specifiers.\n- Handle pure pip dependencies.\n\nInstallation\n------------\n\nYou will be able to install poetry2conda by running:\n\n.. code-block:: bash\n\n    $ pip install poetry2conda\n\nUsage\n-----\n\nThe most straightforward use-case for poetry2conda is to convert a pyproject.toml\nthat uses poetry. This can be achieved by adding the following section to your\npyproject.toml:\n\n.. code-block:: toml\n\n    [tool.poetry.dependencies]\n    foo = "^1.2.3"\n    # ...\n\n    [tool.poetry2conda]\n    name = "some-name-env"\n\nThen, use the command line to create a conda environment file:\n\n.. code-block:: bash\n\n    $ poetry2conda pyproject.toml environment.yaml\n\n    # or if you want to see the contents but not write the file:\n    $ poetry2conda pyproject.toml -\n\nThis will create a yaml file like:\n\n.. code-block:: yaml\n\n    name: some-name-env\n    dependencies:\n      - foo>=1.2.3,<2.0.0\n      # ...\n\nIf you want to include extras in the created environment, you can use\nthe `--extra` or `-E` arguments. They can be used multiple times to\nspecify multiple extras\n\nIf you also want to include development dependencies, the `--dev`\nargument will do that.\n\nSometimes, a dependency is handled differently on conda. For this case,\nthe section ``tool.poetry2conda.dependencies`` can be used to inform on specific\nchannels, or package names.\n\nFor example, if a dependency should be installed from a specific channel, like\nconda-forge, declare it as follows:\n\n\n.. code-block:: toml\n\n    [tool.poetry.dependencies]\n    foo = "^1.2.3"\n    # ...\n\n    [tool.poetry2conda]\n    name = "my-env-with-channels"\n\n    [tool.poetry2conda.dependencies]\n    foo = { channel = "conda-forge" }\n\nAfter conversion, the yaml file will look like:\n\n.. code-block:: yaml\n\n    name: my-env-with-channels\n    dependencies:\n      - conda-forge::foo>=1.2.3,<2.0.0\n      # ...\n\nSometimes, a package on PyPI does not have the same name on conda\n(why? why not? confusion!). For example, ``tables`` and ``pytables``,\n``docker`` and ``docker-py``. To change the name when converting to a conda\nenvironment file, you can set it as:\n\n.. code-block:: toml\n\n    [tool.poetry.dependencies]\n    docker = "^4.2.0"\n    # ...\n\n    [tool.poetry2conda]\n    name = "another-example"\n\n    [tool.poetry2conda.dependencies]\n    docker = { name = "docker-py" }\n\nThe converted yaml file will look like:\n\n.. code-block:: yaml\n\n    name: another-example\n    dependencies:\n      - docker-py>=4.2.0,<5.0.0\n      # ...\n\nWhen a package does not exist on conda, declare it on the pip channel:\n\n.. code-block:: toml\n\n\n    [tool.poetry.dependencies]\n    quetzal-client = "^0.5.2"\n    # ...\n\n    [tool.poetry2conda]\n    name = "example-with-pip"\n\n    [tool.poetry2conda.dependencies]\n    quetzal-client = { channel = "pip" }\n\nWhich would give:\n\n.. code-block:: yaml\n\n    name: example-with-pip\n    dependencies:\n      - pip\n      - pip:\n        - quetzal-client>=0.5.2,<0.6.0\n\n\nNot all poetry dependency types are supported, only regular ones and git\ndependencies:\n\n.. code-block:: toml\n\n\n    [tool.poetry.dependencies]\n    my_private_lib = { git = "https://github.com/company/repo.git", tag = "v1.2.3" }\n    # ...\n\n    [tool.poetry2conda]\n    name = "example-with-git"\n\nThis is handled like a pure pip dependency:\n\n.. code-block:: yaml\n\n    name: example-with-git\n    dependencies:\n      - pip\n      - pip:\n        - git+https://github.com/company/repo.git@v1.2.3#egg=my_private_lib\n\nPackages with extras are supported on a pyproject.toml, but conda does not\nsupport extras. For the moment, this information is dropped:\n\n.. code-block:: toml\n\n\n    [tool.poetry.dependencies]\n    dask = { extras = ["bag"], version = "^2.15.0" }\n    # ...\n\n    [tool.poetry2conda]\n    name = "example-with-extras"\n\nWhich will be translated to:\n\n.. code-block:: yaml\n\n    name: example-with-extras\n    dependencies:\n      - dask>=2.15.0,<3.0.0\n\nSometimes (very rarely) a package is not available on PyPI but conda does have\nit. Poetry can handle this with a git dependency and poetry2conda can keep\nthese as pip installable packages. But if you prefer to transform it to its\nconda package, use the following configuration:\n\n.. code-block:: toml\n\n    [tool.poetry.dependencies]\n    weird = { git = "https://github.com/org/weird.git", tag = "v2.3" }\n\n    [tool.poetry2conda]\n    name = "strange-example"\n\n    [tool.poetry2conda.dependencies]\n    weird = { name = "bob", channel = "conda-forge", version = "^2.3" }  # You need to declare the version here\n\nWhich will be translated to:\n\n.. code-block:: yaml\n\n    name: strange-example\n    dependencies:\n      - conda-forge::bob>=2.3.0,<3.0.0\n\n\nContribute\n----------\n\n- Issue Tracker: https://github.com/dojeda/poetry2conda/issues\n- Source Code: https://github.com/dojeda/poetry2conda\n\n\nLicense\n-------\n\nThe project is licensed under the BSD license.\n\n\n\nWhy poetry2conda?\n-----------------\n\nThis part is an opinion.\n\nPython is a great language with great libraries, but environment management has\nbeen notoriously bad. Bad enough to have its own `XKCD comic <https://xkcd.com>`_:\n\n.. image:: https://imgs.xkcd.com/comics/python_environment.png\n  :alt: Python environment bankrupcty.\n  :width: 50%\n  :align: center\n\nThere is a lack of agreement on how and where to declare dependencies.\n``setup.py`` contains abstract dependencies (but only apply to packages), and\n``requirements.txt`` file has concrete dependencies\n(with version specifications). But development dependencies go somewhere else in\n``requirements-dev.txt`` and testing dependencies in ``requirements-test.txt``.\nBecause dependencies are now declared in two or more\nseparate files, this is a burden. Some people read and parse ``requirements-*.txt``\nfiles on their ``setup.py``. Others say that this is a bad practice.\n\nThen, there is the environment management problem. ``virtualenv`` was created a\nlong time ago to isolate environments so you one does end up with the\ndependencies of another project. I do not know why, this was not enough,\n``venv`` was created. And then some other ones that can handle different Python\nversions.\n\nAt some point on this story, a new generation of clever developers brought\nideas from other package managers to improve on how packages, environments, etc.\nshould be managed. ``requirements.txt`` were replaced (in theory) by\n``Pipfile`` and ``Pipfile.lock``. New tools were created to manage packages and\nenvironments, such as Pipenv and poetry, tackling even more problems such as\nvirtual environments, Python versions, and many other distribution problems.\n\nDependencies, environemnts, package managers... this confused a lot of people\n(including me).\n\nEventually, I decided to give the\n`PEP 5128 <https://www.python.org/dev/peps/pep-0518/>`_ and poetry a try.\nIt was not easy: a new markup language, TOML (Tom\'s Obvious Markup Language,\nwhich has this strange old man smell, like naphtalene, because it looks like\na new INI file). I encountered many new problems with poetry.\nI abandoned many times but always came back because at least it helps me\ndefine my dependencies in only file. After two or three tries, I decided to\nmigrate my code base to poetry and drop the requirement and setup files.\n\nBut wait...\n\nTo add a bit of entropy to the Python situation, a company called Continuum\nAnalytics (later renamed Anaconda) created a *different* Python distribution \nand package management, Anaconda (and its less obese brother, Miniconda).\nI think they were tired of the current Python situation, and they were right.\nThey replaced all of the virtual environment problems with their own\nenvironments and they distribute their own packages without using the current\nPython package authority, PyPI. This worked\nwell, in my opinion, because Anaconda distributes compiled versions of some\npackages, giving massive performance improvements in some cases (like NumPy),\nbecause it is easier to setup on Windows,\nbut more importantly because Anaconda was targeted for the\n*scientific computing community* (e.g. data scientists).\n\nCool! I should migrate to conda then! Alas, some people (like me),\nwho used Python before Anaconda ever existed, tried it and got confused.\n\nI have three main problems with conda: First, not all packages are distributed\nby Anaconda, so you eventually need to mix conda and pip to work together. It is\ndifficult to summarize how many problems I have encountered when mixing these\ntwo. Second, every single day I use conda, I ran into problems: maybe something\nwas installed on the root environment (this also happens without conda),\nmaybe I wrote a command the wrong way (errors are often misleading),\nmaybe the command syntax changed recently,\nmaybe my network is slow and that explains why adding a new dependency takes\nages (among other examples). I can go on. Third, I said to myself, if you are\ngoing to use conda, you should go all the way and write packages for their conda\nrepositories. Oh boy, I tried\nthat and it is very complicated and the documentation is so confusing.\nI eventually managed to do it, but I have PTSD.\n\nSo to summarize, I am not convinced by Anaconda, buy I have colleagues or\ncollaborators that do use it. I don\'t understand why (yes, apparently tensorflow\nis faster with anaconda, sigh...). But I have to admit that conda is not going\nto go anywhere.\n\nThis leaves me in an uncomfortable situation: I want to use poetry, but I don\'t\nlike forcing others to use it to. And by others I mean my conda friends. I\nsearched for some tool to auto-convert from one to another. Dephell does this,\nbut it does not address all of my use-cases. There is an open issue for some\nof them. I saw that changing dephell was going to be a complicated endeavor,\nso I decided to just write a new tool to do it.\n\nSo that\'s why poetry2conda exists.\n',
    'author': 'David Ojeda',
    'author_email': 'david.ojeda@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dojeda/poetry2conda',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
