# Copyright (c) 2017-2022 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import builtins as _builtins, sys, typing as _typing

from google.protobuf.descriptor import EnumDescriptor
from google.protobuf.message import Message as _Message

from .experimental_features_pb2 import ExperimentalFeatures

if sys.version_info >= (3, 8):
    from typing import Literal as _L
else:
    from typing_extensions import Literal as _L

__all__ = [
    "GetLedgerApiVersionRequest",
    "GetLedgerApiVersionResponse",
    "FeaturesDescriptor",
    "UserManagementFeature",
    "CommandDeduplicationFeatures",
    "DeduplicationPeriodSupport",
]

class ParticipantDeduplicationSupport:
    DESCRIPTOR: _typing.ClassVar[EnumDescriptor] = ...
    PARTICIPANT_DEDUPLICATION_NOT_SUPPORTED: _typing.ClassVar[_L[0]] = ...
    PARTICIPANT_DEDUPLICATION_PARALLEL_ONLY: _typing.ClassVar[_L[1]] = ...
    PARTICIPANT_DEDUPLICATION_SUPPORTED: _typing.ClassVar[_L[2]] = ...
PARTICIPANT_DEDUPLICATION_NOT_SUPPORTED = _L[0]
PARTICIPANT_DEDUPLICATION_PARALLEL_ONLY = _L[1]
PARTICIPANT_DEDUPLICATION_SUPPORTED = _L[2]


class GetLedgerApiVersionRequest(_Message):
    ledger_id: _builtins.str
    def __init__(self, *, ledger_id: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["ledger_id"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["ledger_id"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetLedgerApiVersionResponse(_Message):
    version: _builtins.str
    @property
    def features(self) -> FeaturesDescriptor: ...
    def __init__(self, *, version: _typing.Optional[_builtins.str] = ..., features: _typing.Optional[FeaturesDescriptor] = ...): ...
    def HasField(self, field_name: _L["version", "features"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["version", "features"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class FeaturesDescriptor(_Message):
    @property
    def user_management(self) -> UserManagementFeature: ...
    @property
    def experimental(self) -> ExperimentalFeatures: ...
    @property
    def command_deduplication(self) -> CommandDeduplicationFeatures: ...
    def __init__(self, *, user_management: _typing.Optional[UserManagementFeature] = ..., experimental: _typing.Optional[ExperimentalFeatures] = ..., command_deduplication: _typing.Optional[CommandDeduplicationFeatures] = ...): ...
    def HasField(self, field_name: _L["user_management", "experimental", "command_deduplication"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user_management", "experimental", "command_deduplication"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class UserManagementFeature(_Message):
    def __init__(self): ...
    def HasField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def ClearField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class CommandDeduplicationFeatures(_Message):
    @property
    def deduplication_period_support(self) -> DeduplicationPeriodSupport: ...
    @property
    def participant_deduplication_support(self) -> _L[0, 1, 2]: ...
    def __init__(self, *, deduplication_period_support: _typing.Optional[DeduplicationPeriodSupport] = ..., participant_deduplication_support: _typing.Optional[_L['PARTICIPANT_DEDUPLICATION_NOT_SUPPORTED', 0, 'PARTICIPANT_DEDUPLICATION_PARALLEL_ONLY', 1, 'PARTICIPANT_DEDUPLICATION_SUPPORTED', 2]] = ...): ...
    def HasField(self, field_name: _L["deduplication_period_support", "participant_deduplication_support"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["deduplication_period_support", "participant_deduplication_support"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class DeduplicationPeriodSupport(_Message):
    @property
    def offset_support(self) -> _L[0, 1, 2]: ...
    @property
    def duration_support(self) -> _L[0, 1]: ...
    def __init__(self, *, offset_support: _typing.Optional[_L['OFFSET_NATIVE_SUPPORT', 0, 'OFFSET_CONVERT_TO_DURATION', 1, 'OFFSET_NOT_SUPPORTED', 2]] = ..., duration_support: _typing.Optional[_L['DURATION_NATIVE_SUPPORT', 0, 'DURATION_CONVERT_TO_OFFSET', 1]] = ...): ...
    def HasField(self, field_name: _L["offset_support", "duration_support"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["offset_support", "duration_support"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
