[![FactSet](https://raw.githubusercontent.com/factset/enterprise-sdk/main/docs/images/factset-logo.svg)](https://www.factset.com)

# Securitized Derivatives API for Digital Portals client library for Python

[![API Version](https://img.shields.io/badge/api-v4.0.0-blue)](https://developer.factset.com/api-catalog/)
[![PyPi](https://img.shields.io/pypi/v/fds.sdk.SecuritizedDerivativesAPIforDigitalPortals/0.40.1)](https://pypi.org/project/fds.sdk.SecuritizedDerivativesAPIforDigitalPortals/v/0.40.1)
[![Apache-2 license](https://img.shields.io/badge/license-Apache2-brightgreen.svg)](https://www.apache.org/licenses/LICENSE-2.0)

Search for securitized derivative instruments, using a criteria-based screener. The API provides also fundamental data, notation-based
key figures, list of barrier types, and details regarding the underlyings, their respective barriers and related cash flows, coupon lists
and derived basic interest rate information.

The screener is based on securitized derivatives-specific parameters. The result is limited to the notations that satisfy all the selected
filters. If more than one notation of an instrument matches the parameters, and no market priority has been specified, only the notation
with the highest trading volume, averaged over one month, is considered. All identifier types used as parameters must be valid and application
must have permissions for them.

Available search criteria include:

* validation: filter for only active listings, by price quality and latest/previous available price dates
* traded markets: filter and indicate a market priority for the validation
* life cycle: important dates in and features of the life cycle of the securitized derivatives instruments
* filter by issuer, country of registration of the securitized derivatives
* underlying and related barriers, including level and distance, and resulting cash flows
* coupon data: where applicable, occurrence and frequency of coupon payments, current interest rate range
* performance and volatility
* product-specific ask-based key figures (not all key figures are available for all product types):
    * bonus yield, sideways yield, maximum yield based on the ask price
    * agio, discount
    * spread
    * break even, outperformance point, parity
    * delta, weekly theta, vega, implied volatility
    * leverage, omega
    * intrinsic value, time value       

Since some underlyings, e.g. an index or a performance difference of a stock and an index (alpha structure), do not represent a directly
tradable asset, they do not have a price in the classical sense. Therefore, the term *level* is used instead of *price*, e.g. underlying
level instead of underlying price.
The endpoint does not support the search for securitized derivatives with multiple underlyings, thus only securitized derivatives with
a single underlying are returned in the result.

The search can be restricted to a specific set of products by using customer-specific instrument or notation lists. Such restriction
lists are set up by FactSet upon request.

This API is fully integrated with the corresponding [Quotes API](https://developer.factset.com/api-catalog/quotes-api-digital-portals),
allowing access to detailed price and performance information of instruments, as well as basic security identifier cross-reference.
For direct access to price histories, please refer to the
[Time Series API for Digital Portals](https://developer.factset.com/api-catalog/time-series-api-digital-portals).

Similar criteria based screener APIs exist for equity and fixed income instruments: See the
[Stocks API](https://developer.factset.com/api-catalog/stocks-api-digital-portals) and the
[Bonds API](https://developer.factset.com/api-catalog/bonds-api-digital-portals) for details.



This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 4.0.0
- SDK version: 0.40.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

For more information, please visit [https://developer.factset.com/contact](https://developer.factset.com/contact)

## Requirements

* Python >= 3.7

## Installation

### Poetry

```shell
poetry add fds.sdk.utils fds.sdk.SecuritizedDerivativesAPIforDigitalPortals==0.40.1
```

### pip

```shell
pip install fds.sdk.utils fds.sdk.SecuritizedDerivativesAPIforDigitalPortals==0.40.1
```

## Usage

1. [Generate authentication credentials](../../../../README.md#authentication).
2. Setup Python environment.
   1. Install and activate python 3.7+. If you're using [pyenv](https://github.com/pyenv/pyenv):

      ```sh
      pyenv install 3.9.7
      pyenv shell 3.9.7
      ```

   2. (optional) [Install poetry](https://python-poetry.org/docs/#installation).
3. [Install dependencies](#installation).
4. Run the following:

> [!IMPORTANT]
> The parameter variables defined below are just examples and may potentially contain non valid values. Please replace them with valid values.

### Example Code

```python
from fds.sdk.utils.authentication import ConfidentialClient

import fds.sdk.SecuritizedDerivativesAPIforDigitalPortals
from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.api import securitized_derivative_api
from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.models import *
from dateutil.parser import parse as dateutil_parser
from pprint import pprint

# See configuration.py for a list of all supported configuration parameters.

# Examples for each supported authentication method are below,
# choose one that satisfies your use case.

# (Preferred) OAuth 2.0: FactSetOAuth2
# See https://github.com/FactSet/enterprise-sdk#oauth-20
# for information on how to create the app-config.json file
#
# The confidential client instance should be reused in production environments.
# See https://github.com/FactSet/enterprise-sdk-utils-python#authentication
# for more information on using the ConfidentialClient class
configuration = fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.Configuration(
    fds_oauth_client=ConfidentialClient('/path/to/app-config.json')
)

# Basic authentication: FactSetApiKey
# See https://github.com/FactSet/enterprise-sdk#api-key
# for information how to create an API key
# configuration = fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.Configuration(
#     username='USERNAME-SERIAL',
#     password='API-KEY'
# )

# Enter a context with an instance of the API client
with fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = securitized_derivative_api.SecuritizedDerivativeApi(api_client)
    attributes = [
        "_attributes_example",
    ] # [str] | Limit the attributes returned in the response to the specified set. (optional)

    try:
        # List of barrier types.
        # example passing only required values which don't have defaults set
        # and optional values
        api_response = api_instance.get_securitized_derivative_barrier_type_list(attributes=attributes)

        pprint(api_response)
    except fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.ApiException as e:
        print("Exception when calling SecuritizedDerivativeApi->get_securitized_derivative_barrier_type_list: %s\n" % e)

    # # Get response, http status code and response headers
    # try:
    #     # List of barrier types.
    #     api_response, http_status_code, response_headers = api_instance.get_securitized_derivative_barrier_type_list_with_http_info(attributes=attributes)


    #     pprint(api_response)
    #     pprint(http_status_code)
    #     pprint(response_headers)
    # except fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.ApiException as e:
    #     print("Exception when calling SecuritizedDerivativeApi->get_securitized_derivative_barrier_type_list: %s\n" % e)

    # # Get response asynchronous
    # try:
    #     # List of barrier types.
    #     async_result = api_instance.get_securitized_derivative_barrier_type_list_async(attributes=attributes)
    #     api_response = async_result.get()


    #     pprint(api_response)
    # except fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.ApiException as e:
    #     print("Exception when calling SecuritizedDerivativeApi->get_securitized_derivative_barrier_type_list: %s\n" % e)

    # # Get response, http status code and response headers asynchronous
    # try:
    #     # List of barrier types.
    #     async_result = api_instance.get_securitized_derivative_barrier_type_list_with_http_info_async(attributes=attributes)
    #     api_response, http_status_code, response_headers = async_result.get()


    #     pprint(api_response)
    #     pprint(http_status_code)
    #     pprint(response_headers)
    # except fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.ApiException as e:
    #     print("Exception when calling SecuritizedDerivativeApi->get_securitized_derivative_barrier_type_list: %s\n" % e)

```

### Using Pandas

To convert an API response to a Pandas DataFrame, it is necessary to transform it first to a dictionary.
```python
import pandas as pd

response_dict = api_response.to_dict()['data']

simple_json_response = pd.DataFrame(response_dict)
nested_json_response = pd.json_normalize(response_dict)
```

### Debugging

The SDK uses the standard library [`logging`](https://docs.python.org/3/library/logging.html#module-logging) module.

Setting `debug` to `True` on an instance of the `Configuration` class sets the log-level of related packages to `DEBUG`
and enables additional logging in Pythons [HTTP Client](https://docs.python.org/3/library/http.client.html).

**Note**: This prints out sensitive information (e.g. the full request and response). Use with care.

```python
import logging
import fds.sdk.SecuritizedDerivativesAPIforDigitalPortals

logging.basicConfig(level=logging.DEBUG)

configuration = fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.Configuration(...)
configuration.debug = True
```

### Configure a Proxy

You can pass proxy settings to the Configuration class:

* `proxy`: The URL of the proxy to use.
* `proxy_headers`: a dictionary to pass additional headers to the proxy (e.g. `Proxy-Authorization`).

```python
import fds.sdk.SecuritizedDerivativesAPIforDigitalPortals

configuration = fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.Configuration(
    # ...
    proxy="http://secret:password@localhost:5050",
    proxy_headers={
        "Custom-Proxy-Header": "Custom-Proxy-Header-Value"
    }
)
```

### Custom SSL Certificate

TLS/SSL certificate verification can be configured with the following Configuration parameters:

* `ssl_ca_cert`: a path to the certificate to use for verification in `PEM` format.
* `verify_ssl`: setting this to `False` disables the verification of certificates.
  Disabling the verification is not recommended, but it might be useful during
  local development or testing.

```python
import fds.sdk.SecuritizedDerivativesAPIforDigitalPortals

configuration = fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.Configuration(
    # ...
    ssl_ca_cert='/path/to/ca.pem'
)
```

### Request Retries

In case the request retry behaviour should be customized, it is possible to pass a `urllib3.Retry` object to the `retry` property of the Configuration.

```python
from urllib3 import Retry
import fds.sdk.SecuritizedDerivativesAPIforDigitalPortals

configuration = fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.Configuration(
    # ...
)

configuration.retries = Retry(total=3, status_forcelist=[500, 502, 503, 504])
```


## Documentation for API Endpoints

All URIs are relative to *https://api.factset.com/wealth/v4*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SecuritizedDerivativeApi* | [**get_securitized_derivative_barrier_type_list**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/SecuritizedDerivativeApi.md#get_securitized_derivative_barrier_type_list) | **GET** /securitized-derivative/barrier/type/list | List of barrier types.
*SecuritizedDerivativeApi* | [**get_securitized_derivative_get**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/SecuritizedDerivativeApi.md#get_securitized_derivative_get) | **GET** /securitized-derivative/get | Fundamental data for a single securitized derivative.
*SecuritizedDerivativeApi* | [**get_securitized_derivative_key_figures_notation_get**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/SecuritizedDerivativeApi.md#get_securitized_derivative_key_figures_notation_get) | **GET** /securitized-derivative/key-figures/notation/get | Notation-based key figures of a securitized derivative.
*SecuritizedDerivativeApi* | [**get_securitized_derivative_underlying_list**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/SecuritizedDerivativeApi.md#get_securitized_derivative_underlying_list) | **GET** /securitized-derivative/underlying/list | List of underlyings with barrier and cash flow information.
*SecuritizedDerivativeApi* | [**post_securitized_derivative_issuer_search**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/SecuritizedDerivativeApi.md#post_securitized_derivative_issuer_search) | **POST** /securitized-derivative/issuer/search | Search for issuers of securitized derivatives.
*SecuritizedDerivativeApi* | [**post_securitized_derivative_notation_ranking_intraday_list**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/SecuritizedDerivativeApi.md#post_securitized_derivative_notation_ranking_intraday_list) | **POST** /securitized-derivative/notation/ranking/intraday/list | Ranking of securitized derivatives&#39; notations using intraday figures.
*SecuritizedDerivativeApi* | [**post_securitized_derivative_notation_screener_search**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/SecuritizedDerivativeApi.md#post_securitized_derivative_notation_screener_search) | **POST** /securitized-derivative/notation/screener/search | Screener for securitized derivatives&#39;s notations based on securitized derivatives-specific parameters.
*SecuritizedDerivativeApi* | [**post_securitized_derivative_notation_screener_value_ranges_get**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/SecuritizedDerivativeApi.md#post_securitized_derivative_notation_screener_value_ranges_get) | **POST** /securitized-derivative/notation/screener/value-ranges/get | Possible values and value ranges for the parameters used in the endpoint &#x60;/securitized-derivative/notation/screener/search&#x60;.


## Documentation For Models

 - [AttributesMember](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/AttributesMember.md)
 - [GetSecuritizedDerivativeBarrierTypeListDataItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeBarrierTypeListDataItems.md)
 - [GetSecuritizedDerivativeGetDataCountrySecurityRegistrationItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeGetDataCountrySecurityRegistrationItems.md)
 - [GetSecuritizedDerivativeGetDataTypeItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeGetDataTypeItems.md)
 - [GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItems.md)
 - [GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItemsLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItemsLevel.md)
 - [GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItemsNotation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItemsNotation.md)
 - [GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItemsNotationInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItemsNotationInstrument.md)
 - [GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItemsValueUnit](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeKeyFiguresNotationGetDataUnderlyingsItemsValueUnit.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItems.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRange](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRange.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLower](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLower.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLowerBreach](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLowerBreach.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLowerDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLowerDistance.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLowerLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLowerLevel.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLowerParticipationFactor](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeLowerParticipationFactor.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpper](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpper.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpperBreach](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpperBreach.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpperDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpperDistance.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpperLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpperLevel.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpperParticipationFactor](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsRangeUpperParticipationFactor.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingle](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingle.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingleBreach](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingleBreach.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingleDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingleDistance.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingleLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingleLevel.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingleParticipationFactor](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsBarriersItemsSingleParticipationFactor.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItems.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsCashFlow.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsCashFlowAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsCashFlowAbsolute.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsCashFlowCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsCashFlowCurrency.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsCashFlowRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsCashFlowRelative.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsObservation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsObservation.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsObservationPeriod](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsConditionsItemsObservationPeriod.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsItems.md)
 - [GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsItemsBarrierType](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataBarrierTypeConditionsItemsBarrierType.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItems.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsCalculationLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsCalculationLevel.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotation.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationFsym](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationFsym.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationFsymListing](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationFsymListing.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationFsymRegional](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationFsymRegional.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrument.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsym](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsym.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsymSecurity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsymSecurity.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsOperatingMIC](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsOperatingMIC.md)
 - [GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsValueUnit](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsValueUnit.md)
 - [InlineResponse200](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200.md)
 - [InlineResponse2001](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2001.md)
 - [InlineResponse2002](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2002.md)
 - [InlineResponse2003](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003.md)
 - [InlineResponse2003Data](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003Data.md)
 - [InlineResponse2003DataAgio](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataAgio.md)
 - [InlineResponse2003DataBonusYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataBonusYield.md)
 - [InlineResponse2003DataBreakEven](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataBreakEven.md)
 - [InlineResponse2003DataBreakEvenDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataBreakEvenDistance.md)
 - [InlineResponse2003DataCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataCurrency.md)
 - [InlineResponse2003DataDelta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataDelta.md)
 - [InlineResponse2003DataDiscount](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataDiscount.md)
 - [InlineResponse2003DataMaximumYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataMaximumYield.md)
 - [InlineResponse2003DataPerformanceIssue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataPerformanceIssue.md)
 - [InlineResponse2003DataPerformanceIssueAsk](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataPerformanceIssueAsk.md)
 - [InlineResponse2003DataPerformanceIssueBid](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataPerformanceIssueBid.md)
 - [InlineResponse2003DataPrices](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataPrices.md)
 - [InlineResponse2003DataPricesAsk](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataPricesAsk.md)
 - [InlineResponse2003DataPricesBid](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataPricesBid.md)
 - [InlineResponse2003DataPricesValueUnit](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataPricesValueUnit.md)
 - [InlineResponse2003DataSidewaysYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataSidewaysYield.md)
 - [InlineResponse2003DataSpread](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataSpread.md)
 - [InlineResponse2003DataThetaOneWeek](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataThetaOneWeek.md)
 - [InlineResponse2003DataVega](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2003DataVega.md)
 - [InlineResponse2004](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2004.md)
 - [InlineResponse2004Meta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2004Meta.md)
 - [InlineResponse2005](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005.md)
 - [InlineResponse2005Data](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005Data.md)
 - [InlineResponse2005DataBonusLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataBonusLevel.md)
 - [InlineResponse2005DataBonusLevelDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataBonusLevelDistance.md)
 - [InlineResponse2005DataBonusLevelDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataBonusLevelDistanceAbsolute.md)
 - [InlineResponse2005DataBonusLevelDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataBonusLevelDistanceRelative.md)
 - [InlineResponse2005DataBonusLevelValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataBonusLevelValue.md)
 - [InlineResponse2005DataCap](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCap.md)
 - [InlineResponse2005DataCapCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapCashFlow.md)
 - [InlineResponse2005DataCapDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapDistance.md)
 - [InlineResponse2005DataCapDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapDistanceAbsolute.md)
 - [InlineResponse2005DataCapDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapDistanceRelative.md)
 - [InlineResponse2005DataCapValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapValue.md)
 - [InlineResponse2005DataCapitalGuarantee](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapitalGuarantee.md)
 - [InlineResponse2005DataCapitalGuaranteeDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapitalGuaranteeDistance.md)
 - [InlineResponse2005DataCapitalGuaranteeDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapitalGuaranteeDistanceAbsolute.md)
 - [InlineResponse2005DataCapitalGuaranteeDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapitalGuaranteeDistanceRelative.md)
 - [InlineResponse2005DataCapitalGuaranteeValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapitalGuaranteeValue.md)
 - [InlineResponse2005DataCapitalProtection](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCapitalProtection.md)
 - [InlineResponse2005DataCategorization](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCategorization.md)
 - [InlineResponse2005DataCouponTriggerLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCouponTriggerLevel.md)
 - [InlineResponse2005DataCouponTriggerLevelCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCouponTriggerLevelCashFlow.md)
 - [InlineResponse2005DataCouponTriggerLevelDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCouponTriggerLevelDistance.md)
 - [InlineResponse2005DataCouponTriggerLevelDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCouponTriggerLevelDistanceAbsolute.md)
 - [InlineResponse2005DataCouponTriggerLevelDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCouponTriggerLevelDistanceRelative.md)
 - [InlineResponse2005DataCouponTriggerLevelValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCouponTriggerLevelValue.md)
 - [InlineResponse2005DataCurrentInterestRate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCurrentInterestRate.md)
 - [InlineResponse2005DataCurrentInterestRateValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataCurrentInterestRateValue.md)
 - [InlineResponse2005DataExercise](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataExercise.md)
 - [InlineResponse2005DataIssuer](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataIssuer.md)
 - [InlineResponse2005DataKeyFigures](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFigures.md)
 - [InlineResponse2005DataKeyFiguresAgio](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresAgio.md)
 - [InlineResponse2005DataKeyFiguresAgioAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresAgioAbsolute.md)
 - [InlineResponse2005DataKeyFiguresAgioAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresAgioAnnualized.md)
 - [InlineResponse2005DataKeyFiguresAgioRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresAgioRelative.md)
 - [InlineResponse2005DataKeyFiguresBonusYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresBonusYield.md)
 - [InlineResponse2005DataKeyFiguresBonusYieldAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresBonusYieldAbsolute.md)
 - [InlineResponse2005DataKeyFiguresBonusYieldAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresBonusYieldAnnualized.md)
 - [InlineResponse2005DataKeyFiguresBonusYieldRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresBonusYieldRelative.md)
 - [InlineResponse2005DataKeyFiguresBreakEven](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresBreakEven.md)
 - [InlineResponse2005DataKeyFiguresBreakEvenBreakEvenPoint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresBreakEvenBreakEvenPoint.md)
 - [InlineResponse2005DataKeyFiguresBreakEvenDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresBreakEvenDistance.md)
 - [InlineResponse2005DataKeyFiguresBreakEvenDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresBreakEvenDistanceAbsolute.md)
 - [InlineResponse2005DataKeyFiguresBreakEvenDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresBreakEvenDistanceRelative.md)
 - [InlineResponse2005DataKeyFiguresDelta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresDelta.md)
 - [InlineResponse2005DataKeyFiguresDeltaEffective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresDeltaEffective.md)
 - [InlineResponse2005DataKeyFiguresDeltaUnadjusted](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresDeltaUnadjusted.md)
 - [InlineResponse2005DataKeyFiguresDiscount](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresDiscount.md)
 - [InlineResponse2005DataKeyFiguresDiscountAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresDiscountAbsolute.md)
 - [InlineResponse2005DataKeyFiguresDiscountRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresDiscountRelative.md)
 - [InlineResponse2005DataKeyFiguresImpliedVolatility](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresImpliedVolatility.md)
 - [InlineResponse2005DataKeyFiguresIntrinsicValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresIntrinsicValue.md)
 - [InlineResponse2005DataKeyFiguresLeverage](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresLeverage.md)
 - [InlineResponse2005DataKeyFiguresMaximumYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresMaximumYield.md)
 - [InlineResponse2005DataKeyFiguresMaximumYieldAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresMaximumYieldAbsolute.md)
 - [InlineResponse2005DataKeyFiguresMaximumYieldAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresMaximumYieldAnnualized.md)
 - [InlineResponse2005DataKeyFiguresMaximumYieldRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresMaximumYieldRelative.md)
 - [InlineResponse2005DataKeyFiguresOmega](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresOmega.md)
 - [InlineResponse2005DataKeyFiguresOutperformancePoint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresOutperformancePoint.md)
 - [InlineResponse2005DataKeyFiguresParity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresParity.md)
 - [InlineResponse2005DataKeyFiguresSidewaysYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresSidewaysYield.md)
 - [InlineResponse2005DataKeyFiguresSidewaysYieldAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresSidewaysYieldAbsolute.md)
 - [InlineResponse2005DataKeyFiguresSidewaysYieldAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresSidewaysYieldAnnualized.md)
 - [InlineResponse2005DataKeyFiguresSidewaysYieldRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresSidewaysYieldRelative.md)
 - [InlineResponse2005DataKeyFiguresSpread](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresSpread.md)
 - [InlineResponse2005DataKeyFiguresSpreadHarmonized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresSpreadHarmonized.md)
 - [InlineResponse2005DataKeyFiguresSpreadRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresSpreadRelative.md)
 - [InlineResponse2005DataKeyFiguresThetaOneWeek](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresThetaOneWeek.md)
 - [InlineResponse2005DataKeyFiguresThetaOneWeekEffective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresThetaOneWeekEffective.md)
 - [InlineResponse2005DataKeyFiguresThetaOneWeekUnadjusted](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresThetaOneWeekUnadjusted.md)
 - [InlineResponse2005DataKeyFiguresTimeValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresTimeValue.md)
 - [InlineResponse2005DataKeyFiguresVega](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresVega.md)
 - [InlineResponse2005DataKeyFiguresVegaEffective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresVegaEffective.md)
 - [InlineResponse2005DataKeyFiguresVegaUnadjusted](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKeyFiguresVegaUnadjusted.md)
 - [InlineResponse2005DataKnockIn](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockIn.md)
 - [InlineResponse2005DataKnockInCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockInCashFlow.md)
 - [InlineResponse2005DataKnockInDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockInDistance.md)
 - [InlineResponse2005DataKnockInDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockInDistanceAbsolute.md)
 - [InlineResponse2005DataKnockInDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockInDistanceRelative.md)
 - [InlineResponse2005DataKnockInValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockInValue.md)
 - [InlineResponse2005DataKnockOut](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockOut.md)
 - [InlineResponse2005DataKnockOutDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockOutDistance.md)
 - [InlineResponse2005DataKnockOutDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockOutDistanceAbsolute.md)
 - [InlineResponse2005DataKnockOutDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockOutDistanceRelative.md)
 - [InlineResponse2005DataKnockOutValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataKnockOutValue.md)
 - [InlineResponse2005DataLifeCycle](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLifeCycle.md)
 - [InlineResponse2005DataLifeCycleIssue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLifeCycleIssue.md)
 - [InlineResponse2005DataLifeCycleMaturity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLifeCycleMaturity.md)
 - [InlineResponse2005DataLifeCycleMaturityDate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLifeCycleMaturityDate.md)
 - [InlineResponse2005DataLifeCycleMaturityRemainingTermDays](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLifeCycleMaturityRemainingTermDays.md)
 - [InlineResponse2005DataLifeCycleRepayment](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLifeCycleRepayment.md)
 - [InlineResponse2005DataLifeCycleValuation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLifeCycleValuation.md)
 - [InlineResponse2005DataLockIn](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockIn.md)
 - [InlineResponse2005DataLockInCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockInCashFlow.md)
 - [InlineResponse2005DataLockInDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockInDistance.md)
 - [InlineResponse2005DataLockInDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockInDistanceAbsolute.md)
 - [InlineResponse2005DataLockInDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockInDistanceRelative.md)
 - [InlineResponse2005DataLockInValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockInValue.md)
 - [InlineResponse2005DataLockOut](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockOut.md)
 - [InlineResponse2005DataLockOutCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockOutCashFlow.md)
 - [InlineResponse2005DataLockOutDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockOutDistance.md)
 - [InlineResponse2005DataLockOutDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockOutDistanceAbsolute.md)
 - [InlineResponse2005DataLockOutDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockOutDistanceRelative.md)
 - [InlineResponse2005DataLockOutValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataLockOutValue.md)
 - [InlineResponse2005DataPerformance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformance.md)
 - [InlineResponse2005DataPerformanceEndOfDay](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDay.md)
 - [InlineResponse2005DataPerformanceEndOfDayDay1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDayDay1.md)
 - [InlineResponse2005DataPerformanceEndOfDayMonth1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDayMonth1.md)
 - [InlineResponse2005DataPerformanceEndOfDayMonths3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDayMonths3.md)
 - [InlineResponse2005DataPerformanceEndOfDayMonths6](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDayMonths6.md)
 - [InlineResponse2005DataPerformanceEndOfDayWeek1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDayWeek1.md)
 - [InlineResponse2005DataPerformanceEndOfDayYear1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDayYear1.md)
 - [InlineResponse2005DataPerformanceEndOfDayYearToDate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDayYearToDate.md)
 - [InlineResponse2005DataPerformanceEndOfDayYears3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDayYears3.md)
 - [InlineResponse2005DataPerformanceEndOfDayYears5](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceEndOfDayYears5.md)
 - [InlineResponse2005DataPerformanceIntraday](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceIntraday.md)
 - [InlineResponse2005DataPerformanceSinceIssue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceSinceIssue.md)
 - [InlineResponse2005DataPerformanceSinceIssueAsk](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceSinceIssueAsk.md)
 - [InlineResponse2005DataPerformanceSinceIssueBid](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataPerformanceSinceIssueBid.md)
 - [InlineResponse2005DataRangeKnockOut](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataRangeKnockOut.md)
 - [InlineResponse2005DataRangeKnockOutLower](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataRangeKnockOutLower.md)
 - [InlineResponse2005DataRangeKnockOutLowerValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataRangeKnockOutLowerValue.md)
 - [InlineResponse2005DataRangeKnockOutUpper](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataRangeKnockOutUpper.md)
 - [InlineResponse2005DataRangeKnockOutUpperValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataRangeKnockOutUpperValue.md)
 - [InlineResponse2005DataStrike](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataStrike.md)
 - [InlineResponse2005DataStrikeDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataStrikeDistance.md)
 - [InlineResponse2005DataStrikeDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataStrikeDistanceAbsolute.md)
 - [InlineResponse2005DataStrikeDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataStrikeDistanceRelative.md)
 - [InlineResponse2005DataStrikeValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataStrikeValue.md)
 - [InlineResponse2005DataUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataUnderlying.md)
 - [InlineResponse2005DataUnderlyingEffectiveUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataUnderlyingEffectiveUnderlying.md)
 - [InlineResponse2005DataVolatility](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataVolatility.md)
 - [InlineResponse2005DataVolatilityMonth1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataVolatilityMonth1.md)
 - [InlineResponse2005DataVolatilityMonths3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataVolatilityMonths3.md)
 - [InlineResponse2005DataVolatilityMonths6](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataVolatilityMonths6.md)
 - [InlineResponse2005DataVolatilityWeek1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataVolatilityWeek1.md)
 - [InlineResponse2005DataVolatilityYear1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataVolatilityYear1.md)
 - [InlineResponse2005DataVolatilityYearToDate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataVolatilityYearToDate.md)
 - [InlineResponse2005DataVolatilityYears3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataVolatilityYears3.md)
 - [InlineResponse2005DataVolatilityYears5](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2005DataVolatilityYears5.md)
 - [InlineResponse2006](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2006.md)
 - [InlineResponse2007](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2007.md)
 - [InlineResponse2007Data](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse2007Data.md)
 - [InlineResponse200Data](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200Data.md)
 - [InlineResponse200DataExercise](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataExercise.md)
 - [InlineResponse200DataIssue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataIssue.md)
 - [InlineResponse200DataIssueValueUnit](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataIssueValueUnit.md)
 - [InlineResponse200DataIssuer](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataIssuer.md)
 - [InlineResponse200DataIssuerGroup](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataIssuerGroup.md)
 - [InlineResponse200DataLifeCycle](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataLifeCycle.md)
 - [InlineResponse200DataLifeCycleIntradayActivation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataLifeCycleIntradayActivation.md)
 - [InlineResponse200DataLifeCycleMaturity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataLifeCycleMaturity.md)
 - [InlineResponse200DataLifeCycleSubscriptionPeriod](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataLifeCycleSubscriptionPeriod.md)
 - [InlineResponse200DataLifeCycleTradingPeriod](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataLifeCycleTradingPeriod.md)
 - [InlineResponse200DataNominal](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataNominal.md)
 - [InlineResponse200DataNominalCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataNominalCurrency.md)
 - [InlineResponse200DataNsin](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataNsin.md)
 - [InlineResponse200DataOrderVolume](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataOrderVolume.md)
 - [InlineResponse200DataReferenceDebtor](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataReferenceDebtor.md)
 - [InlineResponse200DataReferenceDebtorInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataReferenceDebtorInstrument.md)
 - [InlineResponse200DataReferenceDebtorLegalEntity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200DataReferenceDebtorLegalEntity.md)
 - [InlineResponse200Meta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/InlineResponse200Meta.md)
 - [LanguageMember](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/LanguageMember.md)
 - [OffsetBasedPaginationOutputObject](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/OffsetBasedPaginationOutputObject.md)
 - [PartialOutputObject](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PartialOutputObject.md)
 - [PostSecuritizedDerivativeIssuerSearchDataItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchDataItems.md)
 - [PostSecuritizedDerivativeIssuerSearchRequest](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequest.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestData.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataCategory](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataCategory.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataFactorCertificates](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataFactorCertificates.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataFactorCertificatesEffectiveUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataFactorCertificatesEffectiveUnderlying.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataFactorCertificatesEffectiveUnderlyingInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataFactorCertificatesEffectiveUnderlyingInstrument.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataMarket](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataMarket.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataMarketExclude](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataMarketExclude.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataMarketRestrict](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataMarketRestrict.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataName](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataName.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataRegistrationCountry](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataRegistrationCountry.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataRegistrationCountryExclude](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataRegistrationCountryExclude.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataRegistrationCountryRestrict](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataRegistrationCountryRestrict.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataUnderlying.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestDataUnderlyingInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestDataUnderlyingInstrument.md)
 - [PostSecuritizedDerivativeIssuerSearchRequestMeta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeIssuerSearchRequestMeta.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataCategorizationDdvItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataCategorizationDdvItems.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataCategorizationEusipaItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataCategorizationEusipaItems.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItems.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsAccumulated](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsAccumulated.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsAccumulatedCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsAccumulatedCurrency.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsCategorization](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsCategorization.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsExercise](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsExercise.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsFsym](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsFsym.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsFsymListing](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsFsymListing.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsFsymRegional](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsFsymRegional.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsInstrument.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsIssuer](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsIssuer.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsIssuerGroup](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsIssuerGroup.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsLifeCycle](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsLifeCycle.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsLifeCycleMaturity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsLifeCycleMaturity.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsMarket](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsMarket.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsTrade](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsTrade.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsTradePerformance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsTradePerformance.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlying.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlyingEffectiveUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlyingEffectiveUnderlying.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlyingEffectiveUnderlyingInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlyingEffectiveUnderlyingInstrument.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlyingNotation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlyingNotation.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlyingNotationInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsUnderlyingNotationInstrument.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListDataItemsValueUnit](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListDataItemsValueUnit.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequest](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequest.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestData.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataCategory](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataCategory.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataCurrency.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataExercise](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataExercise.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataFactorCertificates](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataFactorCertificates.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataFactorCertificatesEffectiveUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataFactorCertificatesEffectiveUnderlying.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataFactorCertificatesEffectiveUnderlyingInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataFactorCertificatesEffectiveUnderlyingInstrument.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataInstrumentRestrictionList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataInstrumentRestrictionList.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataIssuer](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataIssuer.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataLifeCycle](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataLifeCycle.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataLifeCycleMaturity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataLifeCycleMaturity.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataMarket](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataMarket.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataNotationRestrictionList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataNotationRestrictionList.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPerformance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPerformance.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPerformanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPerformanceRelative.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPerformanceRelativeMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPerformanceRelativeMaximum.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPerformanceRelativeMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPerformanceRelativeMinimum.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPrices](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataPrices.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataRegistrationCountry](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataRegistrationCountry.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataUnderlying.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataUnderlyingInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataUnderlyingInstrument.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataUnderlyingNotation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataUnderlyingNotation.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestDataValueUnit](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestDataValueUnit.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestMeta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestMeta.md)
 - [PostSecuritizedDerivativeNotationRankingIntradayListRequestMetaPagination](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationRankingIntradayListRequestMetaPagination.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItems.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsFsym](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsFsym.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrument.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevelDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevelDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCap](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCap.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuarantee](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuarantee.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuaranteeDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuaranteeDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorization](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorization.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationDdv](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationDdv.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationDdvLevel1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationDdvLevel1.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationDdvLevel2](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationDdvLevel2.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationDdvLevel3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationDdvLevel3.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationEusipa](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationEusipa.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationEusipaLevel2](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationEusipaLevel2.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationEusipaLevel3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorizationEusipaLevel3.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevelDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevelDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCurrentInterestRate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCurrentInterestRate.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentExercise](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentExercise.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuer](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuer.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuerGroup](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuerGroup.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockIn](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockIn.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockInBreach](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockInBreach.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockInDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockInDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOut](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOut.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOutBreach](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOutBreach.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOutDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOutDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOutObservation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOutObservation.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycle](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycle.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycleMaturity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycleMaturity.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockIn](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockIn.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockInDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockInDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockInObservation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockInObservation.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOut](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOut.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOutDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOutDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentNominalCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentNominalCurrency.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOut](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOut.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOutBreach](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOutBreach.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOutLower](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOutLower.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOutUpper](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOutUpper.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrike](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrike.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrikeDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrikeDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlying.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlyingNotation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlyingNotation.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlyingNotationInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlyingNotationInstrument.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlyingValueUnit](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlyingValueUnit.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFigures](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFigures.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresAgio](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresAgio.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresBonusYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresBonusYield.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresBreakEven](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresBreakEven.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresBreakEvenDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresBreakEvenDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresCurrency.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresDelta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresDelta.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresDiscount](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresDiscount.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresMaximumYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresMaximumYield.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresSidewaysYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresSidewaysYield.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresSpread](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresSpread.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresThetaOneWeek](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresThetaOneWeek.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresVega](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsKeyFiguresVega.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsMarket](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsMarket.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsPerformance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsPerformance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsPerformanceEndOfDay](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsPerformanceEndOfDay.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsPerformanceSinceIssue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsPerformanceSinceIssue.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataItemsVolatility](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataItemsVolatility.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItems.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsCashFlow.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsLower](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsLower.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsLowerLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsLowerLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsLowerLevelAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsLowerLevelAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsObservation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsObservation.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsUpper](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsUpper.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsUpperLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsUpperLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsUpperLevelAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataRangeBarriersItemsUpperLevelAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItems.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsCashFlow.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsDistanceAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsDistanceRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsLevelAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsLevelAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsObservation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchDataSingleBarriersItemsObservation.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequest](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequest.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestData.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataCapitalProtection](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataCapitalProtection.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataCashFlowCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataCashFlowCurrency.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataCategory](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataCategory.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataCurrentInterestRate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataCurrentInterestRate.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataCurrentInterestRateValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataCurrentInterestRateValue.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataExercise](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataExercise.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataFactorCertificates](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataFactorCertificates.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataFactorCertificatesConstantLeverage](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataFactorCertificatesConstantLeverage.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataFactorCertificatesEffectiveUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataFactorCertificatesEffectiveUnderlying.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataFactorCertificatesEffectiveUnderlyingInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataFactorCertificatesEffectiveUnderlyingInstrument.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFigures](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFigures.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresAgio](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresAgio.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresAgioAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresAgioAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresAgioAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresAgioAnnualized.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresAgioRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresAgioRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBonusYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBonusYield.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBonusYieldAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBonusYieldAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBonusYieldAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBonusYieldAnnualized.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBonusYieldRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBonusYieldRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEven](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEven.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEvenBreakEvenPoint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEvenBreakEvenPoint.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEvenDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEvenDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEvenDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEvenDistanceAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEvenDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresBreakEvenDistanceRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDelta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDelta.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDeltaEffective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDeltaEffective.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDeltaUnadjusted](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDeltaUnadjusted.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDiscount](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDiscount.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDiscountAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDiscountAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDiscountRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresDiscountRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresImpliedVolatility](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresImpliedVolatility.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresIntrinsicValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresIntrinsicValue.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresLeverage](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresLeverage.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresMaximumYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresMaximumYield.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresMaximumYieldAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresMaximumYieldAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresMaximumYieldAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresMaximumYieldAnnualized.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresMaximumYieldRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresMaximumYieldRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresOmega](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresOmega.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresOutperformancePoint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresOutperformancePoint.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresParity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresParity.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSidewaysYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSidewaysYield.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSidewaysYieldAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSidewaysYieldAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSidewaysYieldAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSidewaysYieldAnnualized.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSidewaysYieldRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSidewaysYieldRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSpread](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSpread.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSpreadHarmonized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSpreadHarmonized.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSpreadRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresSpreadRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresThetaOneWeek](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresThetaOneWeek.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresThetaOneWeekEffective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresThetaOneWeekEffective.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresThetaOneWeekUnadjusted](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresThetaOneWeekUnadjusted.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresTimeValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresTimeValue.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresVega](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresVega.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresVegaEffective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresVegaEffective.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresVegaEffectiveMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresVegaEffectiveMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresVegaUnadjusted](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataKeyFiguresVegaUnadjusted.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycle](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycle.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleIssue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleIssue.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturity.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturityRestriction](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturityRestriction.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturityRestrictionDate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturityRestrictionDate.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturityRestrictionRemainingTermDays](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturityRestrictionRemainingTermDays.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturityRestrictionRemainingTermDaysMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleMaturityRestrictionRemainingTermDaysMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleRepayment](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataLifeCycleRepayment.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataNominalCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataNominalCurrency.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformance.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDay](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDay.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayDay1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayDay1.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayMonth1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayMonth1.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayMonths3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayMonths3.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayWeek1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayWeek1.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayYear1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayYear1.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayYearToDate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayYearToDate.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayYears3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceEndOfDayYears3.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceIntraday](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceIntraday.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceSinceIssue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceSinceIssue.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceSinceIssueAsk](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceSinceIssueAsk.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceSinceIssueBid](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataPerformanceSinceIssueBid.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataRegistrationCountry](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataRegistrationCountry.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataUnderlying.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataUnderlyingNotation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataUnderlyingNotation.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidation.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationInstrumentRestrictionList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationInstrumentRestrictionList.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarket](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarket.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarketPriority](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarketPriority.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarketSelection](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarketSelection.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarketSelectionExclude](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarketSelectionExclude.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarketSelectionRestrict](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationMarketSelectionRestrict.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationNotationRestrictionList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationNotationRestrictionList.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationPrices](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationPrices.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationPricesLatest](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationPricesLatest.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationValueUnit](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationValueUnit.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationValueUnitSelection](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationValueUnitSelection.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationValueUnitSelectionExclude](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataValidationValueUnitSelectionExclude.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatility](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatility.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityMonth1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityMonth1.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityMonths3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityMonths3.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityMonths6](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityMonths6.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityWeek1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityWeek1.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityYearToDate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityYearToDate.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityYears3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityYears3.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityYears5](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestDataVolatilityYears5.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestMeta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestMeta.md)
 - [PostSecuritizedDerivativeNotationScreenerSearchRequestMetaPagination](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerSearchRequestMetaPagination.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationDdvCategoriesItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationDdvCategoriesItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationDdvItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationDdvItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationDdvItemsLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationDdvItemsLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationEusipaCategoriesItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationEusipaCategoriesItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationEusipaCategoriesItemsParent](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationEusipaCategoriesItemsParent.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationEusipaItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationEusipaItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationEusipaItemsLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCategorizationEusipaItemsLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCollateralizedItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCollateralizedItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataConstantLeverageItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataConstantLeverageItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCurrentInterestRateTypesItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataCurrentInterestRateTypesItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataExerciseRightItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataExerciseRightItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataExerciseStyleItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataExerciseStyleItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataIssuerGroupItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataIssuerGroupItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataIssuerJuristicPersonItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataIssuerJuristicPersonItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataKnockInBreachedItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataKnockInBreachedItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataKnockInObservationItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataKnockInObservationItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataKnockOutBreachedItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataKnockOutBreachedItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataKnockOutObservationItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataKnockOutObservationItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataLifeCycleCallableItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataLifeCycleCallableItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataLifeCycleMaturityPerpetualItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataLifeCycleMaturityPerpetualItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataLockInObservationItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataLockInObservationItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataLockOutObservationItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataLockOutObservationItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataMarketItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataMarketItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataNominalCurrencyItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataNominalCurrencyItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataParticipationItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataParticipationItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataQuantoItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataQuantoItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsCashFlow.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsLower](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsLower.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsLowerLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsLowerLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsLowerLevelAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsLowerLevelAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsObservation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsObservation.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsUpper](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsUpper.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsUpperLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsUpperLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsUpperLevelAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeBarriersItemsUpperLevelAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeKnockOutBreachedItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeKnockOutBreachedItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeKnockOutObservationItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataRangeKnockOutObservationItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSettlementItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSettlementItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsBreach](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsBreach.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsCashFlow](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsCashFlow.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsDistanceAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsDistanceRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsLevel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsLevel.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsLevelAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsLevelAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsObservation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataSingleBarriersItemsObservation.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataUnderlyingEffectiveUnderlyingInstrumentItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataUnderlyingEffectiveUnderlyingInstrumentItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataUnderlyingInstrumentItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataUnderlyingInstrumentItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetDataUnderlyingNotationItems](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetDataUnderlyingNotationItems.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequest](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequest.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestData.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCapitalProtection](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCapitalProtection.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCapitalProtectionMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCapitalProtectionMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCapitalProtectionMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCapitalProtectionMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCashFlowCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCashFlowCurrency.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCategory](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCategory.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCurrentInterestRate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCurrentInterestRate.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCurrentInterestRateValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCurrentInterestRateValue.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCurrentInterestRateValueMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCurrentInterestRateValueMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCurrentInterestRateValueMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataCurrentInterestRateValueMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataExercise](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataExercise.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificates](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificates.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesConstantLeverage](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesConstantLeverage.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesConstantLeverageMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesConstantLeverageMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesConstantLeverageMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesConstantLeverageMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesEffectiveUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesEffectiveUnderlying.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesEffectiveUnderlyingInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataFactorCertificatesEffectiveUnderlyingInstrument.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFigures](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFigures.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresAgio](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresAgio.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresAgioAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresAgioAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresAgioAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresAgioAnnualized.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresAgioRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresAgioRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYield.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldAbsoluteMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldAbsoluteMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldAbsoluteMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldAbsoluteMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldAnnualized.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldRelativeMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldRelativeMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldRelativeMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBonusYieldRelativeMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEven](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEven.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenBreakEvenPoint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenBreakEvenPoint.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenBreakEvenPointMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenBreakEvenPointMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistance.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistanceAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistanceAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistanceAbsoluteMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistanceAbsoluteMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistanceRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistanceRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistanceRelativeMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresBreakEvenDistanceRelativeMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDelta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDelta.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDeltaEffective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDeltaEffective.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDeltaEffectiveMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDeltaEffectiveMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDeltaUnadjusted](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDeltaUnadjusted.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDeltaUnadjustedMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDeltaUnadjustedMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDiscount](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDiscount.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDiscountAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDiscountAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDiscountRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresDiscountRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresImpliedVolatility](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresImpliedVolatility.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresIntrinsicValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresIntrinsicValue.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresLeverage](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresLeverage.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYield.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAbsoluteMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAbsoluteMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAnnualized.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAnnualizedMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAnnualizedMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAnnualizedMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldAnnualizedMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresMaximumYieldRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresOmega](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresOmega.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresOutperformancePoint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresOutperformancePoint.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresParity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresParity.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYield](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYield.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldAbsolute](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldAbsolute.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldAbsoluteMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldAbsoluteMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldAnnualized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldAnnualized.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldAnnualizedMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldAnnualizedMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldRelativeMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSidewaysYieldRelativeMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSpread](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSpread.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSpreadHarmonized](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSpreadHarmonized.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSpreadHarmonizedMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSpreadHarmonizedMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSpreadRelative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresSpreadRelative.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresThetaOneWeek](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresThetaOneWeek.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresThetaOneWeekEffective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresThetaOneWeekEffective.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresThetaOneWeekUnadjusted](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresThetaOneWeekUnadjusted.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresTimeValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresTimeValue.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresVega](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresVega.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresVegaEffective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresVegaEffective.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresVegaUnadjusted](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataKeyFiguresVegaUnadjusted.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycle](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycle.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleIssue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleIssue.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturity.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestriction](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestriction.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestrictionDate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestrictionDate.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestrictionRemainingTermDays](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestrictionRemainingTermDays.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestrictionRemainingTermDaysMaximum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestrictionRemainingTermDaysMaximum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestrictionRemainingTermDaysMinimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleMaturityRestrictionRemainingTermDaysMinimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleRepayment](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleRepayment.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleValuation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataLifeCycleValuation.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataNominalCurrency](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataNominalCurrency.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformance.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDay](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDay.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayDay1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayDay1.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayDay1Minimum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayDay1Minimum.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayMonth1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayMonth1.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayMonths3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayMonths3.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayMonths6](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayMonths6.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayWeek1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayWeek1.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayYear1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayYear1.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayYearToDate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayYearToDate.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayYears3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayYears3.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayYears5](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceEndOfDayYears5.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceIntraday](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceIntraday.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceSinceIssue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceSinceIssue.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceSinceIssueAsk](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceSinceIssueAsk.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceSinceIssueBid](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataPerformanceSinceIssueBid.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataRegistrationCountry](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataRegistrationCountry.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataUnderlying](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataUnderlying.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataUnderlyingInstrument](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataUnderlyingInstrument.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataUnderlyingNotation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataUnderlyingNotation.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidation.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationInstrumentRestrictionList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationInstrumentRestrictionList.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarket](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarket.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarketPriority](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarketPriority.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarketSelection](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarketSelection.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarketSelectionExclude](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarketSelectionExclude.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarketSelectionRestrict](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationMarketSelectionRestrict.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationNotationRestrictionList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationNotationRestrictionList.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationPrices](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationPrices.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationPricesLatest](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationPricesLatest.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationPricesPrevious](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationPricesPrevious.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationValueUnit](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationValueUnit.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationValueUnitSelection](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationValueUnitSelection.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationValueUnitSelectionExclude](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationValueUnitSelectionExclude.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationValueUnitSelectionRestrict](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataValidationValueUnitSelectionRestrict.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatility](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatility.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityMonth1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityMonth1.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityMonths3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityMonths3.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityMonths6](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityMonths6.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityYear1](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityYear1.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityYearToDate](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityYearToDate.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityYears3](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityYears3.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityYears5](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestDataVolatilityYears5.md)
 - [PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestMeta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/PostSecuritizedDerivativeNotationScreenerValueRangesGetRequestMeta.md)
 - [StatusObject](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/SecuritizedDerivativesAPIforDigitalPortals/v4/docs/StatusObject.md)


## Documentation For Authorization


## FactSetApiKey

- **Type**: HTTP basic authentication


## FactSetOAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.apis and fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.api.default_api import DefaultApi`
- `from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import fds.sdk.SecuritizedDerivativesAPIforDigitalPortals
from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.apis import *
from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.models import *
```

## Contributing

Please refer to the [contributing guide](../../../../CONTRIBUTING.md).

## Copyright

Copyright 2022 FactSet Research Systems Inc

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

