"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const contextproviders = require("../../lib/context-providers");
const settings_1 = require("../../lib/settings");
const mock_sdk_1 = require("../util/mock-sdk");
const mockSDK = new mock_sdk_1.MockSdkProvider();
const TEST_PROVIDER = 'testprovider';
test('errors are reported into the context value', async () => {
    // GIVEN
    contextproviders.registerContextProvider(TEST_PROVIDER, class {
        async getValue(_) {
            throw new Error('Something went wrong');
        }
    });
    const context = new settings_1.Context();
    // WHEN
    await contextproviders.provideContextValues([
        { key: 'asdf', props: { account: '1234', region: 'us-east-1' }, provider: TEST_PROVIDER },
    ], context, mockSDK);
    // THEN - error is now in context
    // NOTE: error key is inlined here because it's part of the CX-API
    // compatibility surface.
    expect(context.get('asdf').$providerError).toBe('Something went wrong');
});
test('lookup role ARN is resolved', async () => {
    // GIVEN
    contextproviders.registerContextProvider(TEST_PROVIDER, class {
        async getValue(args) {
            if (args.lookupRoleArn == null) {
                throw new Error('No lookupRoleArn');
            }
            if (args.lookupRoleArn.includes('${AWS::Partition}')) {
                throw new Error('Partition not resolved');
            }
            return 'some resolved value';
        }
    });
    const context = new settings_1.Context();
    // WHEN
    await contextproviders.provideContextValues([
        {
            key: 'asdf',
            props: {
                account: '1234',
                region: 'us-east-1',
                lookupRoleArn: 'arn:${AWS::Partition}:iam::280619947791:role/cdk-hnb659fds-lookup-role-280619947791-us-east-1',
            },
            provider: TEST_PROVIDER,
        },
    ], context, mockSDK);
    // THEN - Value gets resolved
    expect(context.get('asdf')).toEqual('some resolved value');
});
test('errors are marked transient', async () => {
    // GIVEN
    contextproviders.registerContextProvider(TEST_PROVIDER, class {
        async getValue(_) {
            throw new Error('Something went wrong');
        }
    });
    const context = new settings_1.Context();
    // WHEN
    await contextproviders.provideContextValues([
        { key: 'asdf', props: { account: '1234', region: 'us-east-1' }, provider: TEST_PROVIDER },
    ], context, mockSDK);
    // THEN - error is marked transient
    expect(context.get('asdf')[settings_1.TRANSIENT_CONTEXT_KEY]).toBeTruthy();
});
//# sourceMappingURL=data:application/json;base64,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