"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const resource_pool_1 = require("./resource-pool");
test('take and dispose', async () => {
    const pool = new resource_pool_1.ResourcePool(['a']);
    const take1 = pool.take();
    const take2 = pool.take();
    let released = false;
    const lease1 = await take1;
    // awaiting 'take2' would now block but we add an async
    // handler to it to flip a boolean to see when it gets activated.
    void (take2.then(() => released = true));
    expect(lease1.value).toEqual('a');
    await waitTick();
    expect(released).toEqual(false);
    lease1.dispose();
    await waitTick(); // This works because setImmediate is scheduled in LIFO order
    expect(released).toEqual(true);
});
test('double dispose throws', async () => {
    const pool = new resource_pool_1.ResourcePool(['a']);
    const lease = await pool.take();
    lease.dispose();
    expect(() => lease.dispose()).toThrow();
});
test('more consumers than values', async () => {
    const pool = new resource_pool_1.ResourcePool(['a', 'b']);
    const values = await Promise.all([
        pool.using(x => x),
        pool.using(x => x),
        pool.using(x => x),
    ]);
    expect(values).toEqual(['a', 'b', 'a']);
});
function waitTick() {
    return new Promise(setImmediate);
}
//# sourceMappingURL=data:application/json;base64,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