import { DockerImageManifestEntry } from '../../asset-manifest';
import { IAssetHandler, IHandlerHost } from '../asset-handler';
export declare class ContainerImageAssetHandler implements IAssetHandler {
    private readonly workDir;
    private readonly asset;
    private readonly host;
    private readonly docker;
    constructor(workDir: string, asset: DockerImageManifestEntry, host: IHandlerHost);
    publish(): Promise<void>;
    /**
     * Build a (local) Docker asset from a directory with a Dockerfile
     *
     * Tags under a deterministic, unique, local identifier wich will skip
     * the build if it already exists.
     */
    private buildDirectoryAsset;
    /**
     * Build a (local) Docker asset by running an external command
     *
     * External command is responsible for deduplicating the build if possible,
     * and is expected to return the generated image identifier on stdout.
     */
    private buildExternalAsset;
    /**
     * Check whether the image already exists in the ECR repo
     *
     * Use the fields from the destination to do the actual check. The imageUri
     * should correspond to that, but is only used to print Docker image location
     * for user benefit (the format is slightly different).
     */
    private destinationAlreadyExists;
    private buildImage;
    private isImageCached;
}
