"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeAssetHandler = void 0;
const asset_manifest_1 = require("../../asset-manifest");
const container_images_1 = require("./container-images");
const files_1 = require("./files");
function makeAssetHandler(manifest, asset, host) {
    if (asset instanceof asset_manifest_1.FileManifestEntry) {
        return new files_1.FileAssetHandler(manifest.directory, asset, host);
    }
    if (asset instanceof asset_manifest_1.DockerImageManifestEntry) {
        return new container_images_1.ContainerImageAssetHandler(manifest.directory, asset, host);
    }
    throw new Error(`Unrecognized asset type: '${asset}'`);
}
exports.makeAssetHandler = makeAssetHandler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx5REFBa0g7QUFFbEgseURBQWdFO0FBQ2hFLG1DQUEyQztBQUUzQyxTQUFnQixnQkFBZ0IsQ0FBQyxRQUF1QixFQUFFLEtBQXFCLEVBQUUsSUFBa0I7SUFDakcsSUFBSSxLQUFLLFlBQVksa0NBQWlCLEVBQUU7UUFDdEMsT0FBTyxJQUFJLHdCQUFnQixDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxDQUFDO0tBQzlEO0lBQ0QsSUFBSSxLQUFLLFlBQVkseUNBQXdCLEVBQUU7UUFDN0MsT0FBTyxJQUFJLDZDQUEwQixDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxDQUFDO0tBQ3hFO0lBRUQsTUFBTSxJQUFJLEtBQUssQ0FBQyw2QkFBNkIsS0FBSyxHQUFHLENBQUMsQ0FBQztBQUN6RCxDQUFDO0FBVEQsNENBU0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBc3NldE1hbmlmZXN0LCBEb2NrZXJJbWFnZU1hbmlmZXN0RW50cnksIEZpbGVNYW5pZmVzdEVudHJ5LCBJTWFuaWZlc3RFbnRyeSB9IGZyb20gJy4uLy4uL2Fzc2V0LW1hbmlmZXN0JztcbmltcG9ydCB7IElBc3NldEhhbmRsZXIsIElIYW5kbGVySG9zdCB9IGZyb20gJy4uL2Fzc2V0LWhhbmRsZXInO1xuaW1wb3J0IHsgQ29udGFpbmVySW1hZ2VBc3NldEhhbmRsZXIgfSBmcm9tICcuL2NvbnRhaW5lci1pbWFnZXMnO1xuaW1wb3J0IHsgRmlsZUFzc2V0SGFuZGxlciB9IGZyb20gJy4vZmlsZXMnO1xuXG5leHBvcnQgZnVuY3Rpb24gbWFrZUFzc2V0SGFuZGxlcihtYW5pZmVzdDogQXNzZXRNYW5pZmVzdCwgYXNzZXQ6IElNYW5pZmVzdEVudHJ5LCBob3N0OiBJSGFuZGxlckhvc3QpOiBJQXNzZXRIYW5kbGVyIHtcbiAgaWYgKGFzc2V0IGluc3RhbmNlb2YgRmlsZU1hbmlmZXN0RW50cnkpIHtcbiAgICByZXR1cm4gbmV3IEZpbGVBc3NldEhhbmRsZXIobWFuaWZlc3QuZGlyZWN0b3J5LCBhc3NldCwgaG9zdCk7XG4gIH1cbiAgaWYgKGFzc2V0IGluc3RhbmNlb2YgRG9ja2VySW1hZ2VNYW5pZmVzdEVudHJ5KSB7XG4gICAgcmV0dXJuIG5ldyBDb250YWluZXJJbWFnZUFzc2V0SGFuZGxlcihtYW5pZmVzdC5kaXJlY3RvcnksIGFzc2V0LCBob3N0KTtcbiAgfVxuXG4gIHRocm93IG5ldyBFcnJvcihgVW5yZWNvZ25pemVkIGFzc2V0IHR5cGU6ICcke2Fzc2V0fSdgKTtcbn1cbiJdfQ==