import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [autoscaling-plans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsautoscaling.html).
 *
 * @experimental
 */
export declare class AutoscalingPlans extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Creates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CreateScalingPlan.html
     *
     * @experimental
     */
    toCreateScalingPlan(): this;
    /**
     * (experimental) Deletes the specified scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DeleteScalingPlan.html
     *
     * @experimental
     */
    toDeleteScalingPlan(): this;
    /**
     * (experimental) Describes the scalable resources in the specified scaling plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlanResources.html
     *
     * @experimental
     */
    toDescribeScalingPlanResources(): this;
    /**
     * (experimental) Describes the specified scaling plans or all of your scaling plans.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlans.html
     *
     * @experimental
     */
    toDescribeScalingPlans(): this;
    /**
     * (experimental) Retrieves the forecast data for a scalable resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_GetScalingPlanResourceForecastData.html
     *
     * @experimental
     */
    toGetScalingPlanResourceForecastData(): this;
    /**
     * (experimental) Updates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_UpdateScalingPlan.html
     *
     * @experimental
     */
    toUpdateScalingPlan(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [autoscaling-plans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsautoscaling.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
