import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [codecommit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodecommit.html).
 *
 * @experimental
 */
export declare class Codecommit extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to associate an approval rule template with a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_AssociateApprovalRuleTemplateWithRepository.html
     *
     * @experimental
     */
    toAssociateApprovalRuleTemplateWithRepository(): this;
    /**
     * (experimental) Grants permission to associate an approval rule template with multiple repositories in a single operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchAssociateApprovalRuleTemplateWithRepositories.html
     *
     * @experimental
     */
    toBatchAssociateApprovalRuleTemplateWithRepositories(): this;
    /**
     * (experimental) Grants permission to get information about multiple merge conflicts when attempting to merge two commits using either the three-way merge or the squash merge option.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchDescribeMergeConflicts.html
     *
     * @experimental
     */
    toBatchDescribeMergeConflicts(): this;
    /**
     * (experimental) Grants permission to remove the association between an approval rule template and multiple repositories in a single operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchDisassociateApprovalRuleTemplateFromRepositories.html
     *
     * @experimental
     */
    toBatchDisassociateApprovalRuleTemplateFromRepositories(): this;
    /**
     * (experimental) Grants permission to get return information about one or more commits in an AWS CodeCommit repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchGetCommits.html
     *
     * @experimental
     */
    toBatchGetCommits(): this;
    /**
     * (experimental) Grants permission to return information about one or more pull requests in an AWS CodeCommit repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-pr
     *
     * @experimental
     */
    toBatchGetPullRequests(): this;
    /**
     * (experimental) Grants permission to get information about multiple repositories.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchGetRepositories.html
     *
     * @experimental
     */
    toBatchGetRepositories(): this;
    /**
     * (experimental) Grants permission to cancel the uploading of an archive to a pipeline in AWS CodePipeline.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-acp
     *
     * @experimental
     */
    toCancelUploadArchive(): this;
    /**
     * (experimental) Grants permission to create an approval rule template that will automatically create approval rules in pull requests that match the conditions defined in the template;
     *
     * does not grant permission to create approval rules for individual pull requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateApprovalRuleTemplate.html
     *
     * @experimental
     */
    toCreateApprovalRuleTemplate(): this;
    /**
     * (experimental) Grants permission to create a branch in an AWS CodeCommit repository with this API;
     *
     * does not control Git create branch actions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateBranch.html
     *
     * @experimental
     */
    toCreateBranch(): this;
    /**
     * (experimental) Grants permission to add, copy, move or update single or multiple files in a branch in an AWS CodeCommit repository, and generate a commit for the changes in the specified branch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateCommit.html
     *
     * @experimental
     */
    toCreateCommit(): this;
    /**
     * (experimental) Grants permission to create a pull request in the specified repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreatePullRequest.html
     *
     * @experimental
     */
    toCreatePullRequest(): this;
    /**
     * (experimental) Grants permission to create an approval rule specific to an individual pull request;
     *
     * does not grant permission to create approval rule templates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreatePullRequestApprovalRule.html
     *
     * @experimental
     */
    toCreatePullRequestApprovalRule(): this;
    /**
     * (experimental) Grants permission to create an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateRepository.html
     *
     * @experimental
     */
    toCreateRepository(): this;
    /**
     * (experimental) Grants permission to create an unreferenced commit that contains the result of merging two commits using either the three-way or the squash merge option;
     *
     * does not control Git merge actions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateUnreferencedMergeCommit.html
     *
     * @experimental
     */
    toCreateUnreferencedMergeCommit(): this;
    /**
     * (experimental) Grants permission to delete an approval rule template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteApprovalRuleTemplate.html
     *
     * @experimental
     */
    toDeleteApprovalRuleTemplate(): this;
    /**
     * (experimental) Grants permission to delete a branch in an AWS CodeCommit repository with this API;
     *
     * does not control Git delete branch actions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteBranch.html
     *
     * @experimental
     */
    toDeleteBranch(): this;
    /**
     * (experimental) Grants permission to delete the content of a comment made on a change, file, or commit in a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteCommentContent.html
     *
     * @experimental
     */
    toDeleteCommentContent(): this;
    /**
     * (experimental) Grants permission to delete a specified file from a specified branch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteFile.html
     *
     * @experimental
     */
    toDeleteFile(): this;
    /**
     * (experimental) Grants permission to delete approval rule created for a pull request if the rule was not created by an approval rule template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeletePullRequestApprovalRule.html
     *
     * @experimental
     */
    toDeletePullRequestApprovalRule(): this;
    /**
     * (experimental) Grants permission to delete an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteRepository.html
     *
     * @experimental
     */
    toDeleteRepository(): this;
    /**
     * (experimental) Grants permission to get information about specific merge conflicts when attempting to merge two commits using either the three-way or the squash merge option.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DescribeMergeConflicts.html
     *
     * @experimental
     */
    toDescribeMergeConflicts(): this;
    /**
     * (experimental) Grants permission to return information about one or more pull request events.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DescribePullRequestEvents.html
     *
     * @experimental
     */
    toDescribePullRequestEvents(): this;
    /**
     * (experimental) Grants permission to remove the association between an approval rule template and a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DisassociateApprovalRuleTemplateFromRepository.html
     *
     * @experimental
     */
    toDisassociateApprovalRuleTemplateFromRepository(): this;
    /**
     * (experimental) Grants permission to evaluate whether a pull request is mergable based on its current approval state and approval rule requirements.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_EvaluatePullRequestApprovalRules.html
     *
     * @experimental
     */
    toEvaluatePullRequestApprovalRules(): this;
    /**
     * (experimental) Grants permission to return information about an approval rule template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetApprovalRuleTemplate.html
     *
     * @experimental
     */
    toGetApprovalRuleTemplate(): this;
    /**
     * (experimental) Grants permission to view the encoded content of an individual file in an AWS CodeCommit repository from the AWS CodeCommit console.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetBlob.html
     *
     * @experimental
     */
    toGetBlob(): this;
    /**
     * (experimental) Grants permission to get details about a branch in an AWS CodeCommit repository with this API;
     *
     * does not control Git branch actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetBranch.html
     *
     * @experimental
     */
    toGetBranch(): this;
    /**
     * (experimental) Grants permission to get the content of a comment made on a change, file, or commit in a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetComment.html
     *
     * @experimental
     */
    toGetComment(): this;
    /**
     * (experimental) Grants permission to get the reactions on a comment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommentReactions.html
     *
     * @experimental
     */
    toGetCommentReactions(): this;
    /**
     * (experimental) Grants permission to get information about comments made on the comparison between two commits.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommentsForComparedCommit.html
     *
     * @experimental
     */
    toGetCommentsForComparedCommit(): this;
    /**
     * (experimental) Grants permission to get comments made on a pull request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommentsForPullRequest.html
     *
     * @experimental
     */
    toGetCommentsForPullRequest(): this;
    /**
     * (experimental) Grants permission to return information about a commit, including commit message and committer information, with this API;
     *
     * does not control Git log actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommit.html
     *
     * @experimental
     */
    toGetCommit(): this;
    /**
     * (experimental) Grants permission to get information about the history of commits in a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     *
     * @experimental
     */
    toGetCommitHistory(): this;
    /**
     * (experimental) Grants permission to get information about the difference between commits in the context of a potential merge.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-pr
     *
     * @experimental
     */
    toGetCommitsFromMergeBase(): this;
    /**
     * (experimental) Grants permission to view information about the differences between valid commit specifiers such as a branch, tag, HEAD, commit ID, or other fully qualified reference.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetDifferences.html
     *
     * @experimental
     */
    toGetDifferences(): this;
    /**
     * (experimental) Grants permission to return the base-64 encoded contents of a specified file and its metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetFile.html
     *
     * @experimental
     */
    toGetFile(): this;
    /**
     * (experimental) Grants permission to return the contents of a specified folder in a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetFolder.html
     *
     * @experimental
     */
    toGetFolder(): this;
    /**
     * (experimental) Grants permission to get information about a merge commit created by one of the merge options for pull requests that creates merge commits.
     *
     * Not all merge options create merge commits. This permission does not control Git merge actions
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetMergeCommit.html
     *
     * @experimental
     */
    toGetMergeCommit(): this;
    /**
     * (experimental) Grants permission to get information about merge conflicts between the before and after commit IDs for a pull request in a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetMergeConflicts.html
     *
     * @experimental
     */
    toGetMergeConflicts(): this;
    /**
     * (experimental) Grants permission to get information about merge options for pull requests that can be used to merge two commits;
     *
     * does not control Git merge actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetMergeOptions.html
     *
     * @experimental
     */
    toGetMergeOptions(): this;
    /**
     * (experimental) Grants permission to resolve blobs, trees, and commits to their identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     *
     * @experimental
     */
    toGetObjectIdentifier(): this;
    /**
     * (experimental) Grants permission to get information about a pull request in a specified repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetPullRequest.html
     *
     * @experimental
     */
    toGetPullRequest(): this;
    /**
     * (experimental) Grants permission to retrieve the current approvals on an inputted pull request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetPullRequestApprovalStates.html
     *
     * @experimental
     */
    toGetPullRequestApprovalStates(): this;
    /**
     * (experimental) Grants permission to retrieve the current override state of a given pull request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetPullRequestOverrideState.html
     *
     * @experimental
     */
    toGetPullRequestOverrideState(): this;
    /**
     * (experimental) Grants permission to get details about references in an AWS CodeCommit repository; does not control Git reference actions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     *
     * @experimental
     */
    toGetReferences(): this;
    /**
     * (experimental) Grants permission to get information about an AWS CodeCommit repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html
     *
     * @experimental
     */
    toGetRepository(): this;
    /**
     * (experimental) Grants permission to get information about triggers configured for a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepositoryTriggers.html
     *
     * @experimental
     */
    toGetRepositoryTriggers(): this;
    /**
     * (experimental) Grants permission to view the contents of a specified tree in an AWS CodeCommit repository from the AWS CodeCommit console.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     *
     * @experimental
     */
    toGetTree(): this;
    /**
     * (experimental) Grants permission to get status information about an archive upload to a pipeline in AWS CodePipeline.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-acp
     *
     * @experimental
     */
    toGetUploadArchiveStatus(): this;
    /**
     * (experimental) Grants permission to pull information from an AWS CodeCommit repository to a local repo.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-git
     *
     * @experimental
     */
    toGitPull(): this;
    /**
     * (experimental) Grants permission to push information from a local repo to an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-git
     *
     * @experimental
     */
    toGitPush(): this;
    /**
     * (experimental) Grants permission to list all approval rule templates in an AWS Region for the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListApprovalRuleTemplates.html
     *
     * @experimental
     */
    toListApprovalRuleTemplates(): this;
    /**
     * (experimental) Grants permission to list approval rule templates that are associated with a repository.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListAssociatedApprovalRuleTemplatesForRepository.html
     *
     * @experimental
     */
    toListAssociatedApprovalRuleTemplatesForRepository(): this;
    /**
     * (experimental) Grants permission to list branches for an AWS CodeCommit repository with this API; does not control Git branch actions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListBranches.html
     *
     * @experimental
     */
    toListBranches(): this;
    /**
     * (experimental) Grants permission to list pull requests for a specified repository.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListPullRequests.html
     *
     * @experimental
     */
    toListPullRequests(): this;
    /**
     * (experimental) Grants permission to list information about AWS CodeCommit repositories in the current Region for your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListRepositories.html
     *
     * @experimental
     */
    toListRepositories(): this;
    /**
     * (experimental) Grants permission to list repositories that are associated with an approval rule template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListRepositoriesForApprovalRuleTemplate.html
     *
     * @experimental
     */
    toListRepositoriesForApprovalRuleTemplate(): this;
    /**
     * (experimental) Grants permission to list the resource attached to a CodeCommit resource ARN.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to merge two commits into the specified destination branch using the fast-forward merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergeBranchesByFastForward.html
     *
     * @experimental
     */
    toMergeBranchesByFastForward(): this;
    /**
     * (experimental) Grants permission to merge two commits into the specified destination branch using the squash merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergeBranchesBySquash.html
     *
     * @experimental
     */
    toMergeBranchesBySquash(): this;
    /**
     * (experimental) Grants permission to merge two commits into the specified destination branch using the three-way merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergeBranchesByThreeWay.html
     *
     * @experimental
     */
    toMergeBranchesByThreeWay(): this;
    /**
     * (experimental) Grants permission to close a pull request and attempt to merge it into the specified destination branch for that pull request at the specified commit using the fast-forward merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergePullRequestByFastForward.html
     *
     * @experimental
     */
    toMergePullRequestByFastForward(): this;
    /**
     * (experimental) Grants permission to close a pull request and attempt to merge it into the specified destination branch for that pull request at the specified commit using the squash merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergePullRequestBySquash.html
     *
     * @experimental
     */
    toMergePullRequestBySquash(): this;
    /**
     * (experimental) Grants permission to close a pull request and attempt to merge it into the specified destination branch for that pull request at the specified commit using the three-way merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergePullRequestByThreeWay.html
     *
     * @experimental
     */
    toMergePullRequestByThreeWay(): this;
    /**
     * (experimental) Grants permission to override all approval rules for a pull request, including approval rules created by a template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_OverridePullRequestApprovalRules.html
     *
     * @experimental
     */
    toOverridePullRequestApprovalRules(): this;
    /**
     * (experimental) Grants permission to post a comment on the comparison between two commits.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PostCommentForComparedCommit.html
     *
     * @experimental
     */
    toPostCommentForComparedCommit(): this;
    /**
     * (experimental) Grants permission to post a comment on a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PostCommentForPullRequest.html
     *
     * @experimental
     */
    toPostCommentForPullRequest(): this;
    /**
     * (experimental) Grants permission to post a comment in reply to a comment on a comparison between commits or a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PostCommentReply.html
     *
     * @experimental
     */
    toPostCommentReply(): this;
    /**
     * (experimental) Grants permission to post a reaction on a comment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PutCommentReaction.html
     *
     * @experimental
     */
    toPutCommentReaction(): this;
    /**
     * (experimental) Grants permission to add or update a file in a branch in an AWS CodeCommit repository, and generate a commit for the addition in the specified branch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PutFile.html
     *
     * @experimental
     */
    toPutFile(): this;
    /**
     * (experimental) Grants permission to create, update, or delete triggers for a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PutRepositoryTriggers.html
     *
     * @experimental
     */
    toPutRepositoryTriggers(): this;
    /**
     * (experimental) Grants permission to attach resource tags to a CodeCommit resource ARN.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to test the functionality of repository triggers by sending information to the trigger target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_TestRepositoryTriggers.html
     *
     * @experimental
     */
    toTestRepositoryTriggers(): this;
    /**
     * (experimental) Grants permission to disassociate resource tags from a CodeCommit resource ARN.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the content of approval rule templates;
     *
     * does not grant permission to update content of approval rules created specifically for pull requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateApprovalRuleTemplateContent.html
     *
     * @experimental
     */
    toUpdateApprovalRuleTemplateContent(): this;
    /**
     * (experimental) Grants permission to update the description of approval rule templates.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateApprovalRuleTemplateDescription.html
     *
     * @experimental
     */
    toUpdateApprovalRuleTemplateDescription(): this;
    /**
     * (experimental) Grants permission to update the name of approval rule templates.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateApprovalRuleTemplateName.html
     *
     * @experimental
     */
    toUpdateApprovalRuleTemplateName(): this;
    /**
     * (experimental) Grants permission to update the contents of a comment if the identity matches the identity used to create the comment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateComment.html
     *
     * @experimental
     */
    toUpdateComment(): this;
    /**
     * (experimental) Grants permission to change the default branch in an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateDefaultBranch.html
     *
     * @experimental
     */
    toUpdateDefaultBranch(): this;
    /**
     * (experimental) Grants permission to update the content for approval rules created for a specific pull requests;
     *
     * does not grant permission to update approval rule content for rules created with an approval rule template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestApprovalRuleContent.html
     *
     * @experimental
     */
    toUpdatePullRequestApprovalRuleContent(): this;
    /**
     * (experimental) Grants permission to update the approval state for pull requests.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestApprovalState.html
     *
     * @experimental
     */
    toUpdatePullRequestApprovalState(): this;
    /**
     * (experimental) Grants permission to update the description of a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestDescription.html
     *
     * @experimental
     */
    toUpdatePullRequestDescription(): this;
    /**
     * (experimental) Grants permission to update the status of a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestStatus.html
     *
     * @experimental
     */
    toUpdatePullRequestStatus(): this;
    /**
     * (experimental) Grants permission to update the title of a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestTitle.html
     *
     * @experimental
     */
    toUpdatePullRequestTitle(): this;
    /**
     * (experimental) Grants permission to change the description of an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateRepositoryDescription.html
     *
     * @experimental
     */
    toUpdateRepositoryDescription(): this;
    /**
     * (experimental) Grants permission to change the name of an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateRepositoryName.html
     *
     * @experimental
     */
    toUpdateRepositoryName(): this;
    /**
     * (experimental) Grants permission to the service role for AWS CodePipeline to upload repository changes into a pipeline.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-acp
     *
     * @experimental
     */
    toUploadArchive(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type repository to the statement.
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats
     *
     * @param repositoryName - Identifier for the repositoryName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRepository(repositoryName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by Git reference to specified AWS CodeCommit actions.
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-conditional-branch.html
     *
     * Applies to actions:
     * - .toCreateBranch()
     * - .toCreateCommit()
     * - .toCreateUnreferencedMergeCommit()
     * - .toDeleteBranch()
     * - .toDeleteFile()
     * - .toGetMergeCommit()
     * - .toGitPush()
     * - .toMergeBranchesByFastForward()
     * - .toMergeBranchesBySquash()
     * - .toMergeBranchesByThreeWay()
     * - .toMergePullRequestByFastForward()
     * - .toMergePullRequestBySquash()
     * - .toMergePullRequestByThreeWay()
     * - .toPutFile()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifReferences(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [codecommit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodecommit.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
