import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [codeguru-profiler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodeguruprofiler.html).
 *
 * @experimental
 */
export declare class CodeguruProfiler extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to add up to 2 topic ARNs of existing AWS SNS topics to publish notifications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AddNotificationChannels.html
     *
     * @experimental
     */
    toAddNotificationChannels(): this;
    /**
     * (experimental) Grants permission to get the frame metric data for a Profiling Group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_BatchGetFrameMetricData.html
     *
     * @experimental
     */
    toBatchGetFrameMetricData(): this;
    /**
     * (experimental) Grants permission for an agent to register with the orchestration service and retrieve profiling configuration information.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html
     *
     * @experimental
     */
    toConfigureAgent(): this;
    /**
     * (experimental) Grants permission to create a profiling group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_CreateProfilingGroup.html
     *
     * @experimental
     */
    toCreateProfilingGroup(): this;
    /**
     * (experimental) Grants permission to delete a profiling group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_DeleteProfilingGroup.html
     *
     * @experimental
     */
    toDeleteProfilingGroup(): this;
    /**
     * (experimental) Grants permission to describe a profiling group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_DescribeProfilingGroup.html
     *
     * @experimental
     */
    toDescribeProfilingGroup(): this;
    /**
     * (experimental) Grants permission to get a summary of recent recommendations for each profiling group in the account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetFindingsReportAccountSummary.html
     *
     * @experimental
     */
    toGetFindingsReportAccountSummary(): this;
    /**
     * (experimental) Grants permission to get the notification configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetNotificationConfiguration.html
     *
     * @experimental
     */
    toGetNotificationConfiguration(): this;
    /**
     * (experimental) Grants permission to get the resource policy associated with the specified Profiling Group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetPolicy.html
     *
     * @experimental
     */
    toGetPolicy(): this;
    /**
     * (experimental) Grants permission to get aggregated profiles for a specific profiling group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html
     *
     * @experimental
     */
    toGetProfile(): this;
    /**
     * (experimental) Grants permission to get recommendations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetRecommendations.html
     *
     * @experimental
     */
    toGetRecommendations(): this;
    /**
     * (experimental) Grants permission to list the available recommendations reports for a specific profiling group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListFindingsReports.html
     *
     * @experimental
     */
    toListFindingsReports(): this;
    /**
     * (experimental) Grants permission to list the start times of the available aggregated profiles for a specific profiling group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html
     *
     * @experimental
     */
    toListProfileTimes(): this;
    /**
     * (experimental) Grants permission to list profiling groups in the account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfilingGroups.html
     *
     * @experimental
     */
    toListProfilingGroups(): this;
    /**
     * (experimental) Grants permission to list tags for a Profiling Group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to submit a profile collected by an agent belonging to a specific profiling group for aggregation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html
     *
     * @experimental
     */
    toPostAgentProfile(): this;
    /**
     * (experimental) Grants permission to update the list of principals allowed for an action group in the resource policy associated with the specified Profiling Group.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PutPermission.html
     *
     * @experimental
     */
    toPutPermission(): this;
    /**
     * (experimental) Grants permission to delete an already configured SNStopic arn from the notification configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_RemoveNotificationChannel.html
     *
     * @experimental
     */
    toRemoveNotificationChannel(): this;
    /**
     * (experimental) Grants permission to remove the permission of specified Action Group from the resource policy associated with the specified Profiling Group.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_RemovePermission.html
     *
     * @experimental
     */
    toRemovePermission(): this;
    /**
     * (experimental) Grants permission to submit user feedback for useful or non useful anomaly.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_SubmitFeedback.html
     *
     * @experimental
     */
    toSubmitFeedback(): this;
    /**
     * (experimental) Grants permission to add or overwrite tags to a Profiling Group.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a Profiling Group.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a specific profiling group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_UpdateProfilingGroup.html
     *
     * @experimental
     */
    toUpdateProfilingGroup(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type ProfilingGroup to the statement.
     *
     * https://docs.aws.amazon.com/codeguru/latest/profiler-ug/working-with-profiling-groups.html
     *
     * @param profilingGroupName - Identifier for the profilingGroupName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onProfilingGroup(profilingGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [codeguru-profiler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodeguruprofiler.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
