import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [deepcomposer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepcomposer.html).
 *
 * @experimental
 */
export declare class Deepcomposer extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to associate a DeepComposer coupon (or DSN) with the account associated with the sender of the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/what-it-is-keyboard.html
     *
     * @experimental
     */
    toAssociateCoupon(): this;
    /**
     * (experimental) Grants permission to create an audio file by converting the midi composition into a wav or mp3 file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @experimental
     */
    toCreateAudio(): this;
    /**
     * (experimental) Grants permission to create a multi-track midi composition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @experimental
     */
    toCreateComposition(): this;
    /**
     * (experimental) Grants permission to start creating/training a generative-model that is able to perform inference against the user-provided piano-melody to create a multi-track midi composition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-custom-model.html
     *
     * @experimental
     */
    toCreateModel(): this;
    /**
     * (experimental) Grants permission to delete the composition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @experimental
     */
    toDeleteComposition(): this;
    /**
     * (experimental) Grants permission to delete the model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-custom-model.html
     *
     * @experimental
     */
    toDeleteModel(): this;
    /**
     * (experimental) Grants permission to get information about the composition.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @experimental
     */
    toGetComposition(): this;
    /**
     * (experimental) Grants permission to get information about the model.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-custom-model.html
     *
     * @experimental
     */
    toGetModel(): this;
    /**
     * (experimental) Grants permission to get information about the sample/pre-trained DeepComposer model.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @experimental
     */
    toGetSampleModel(): this;
    /**
     * (experimental) Grants permission to list all the compositions owned by the sender of the request.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @experimental
     */
    toListCompositions(): this;
    /**
     * (experimental) Grants permission to list all the models owned by the sender of the request.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-custom-model.html
     *
     * @experimental
     */
    toListModels(): this;
    /**
     * (experimental) Grants permission to list all the sample/pre-trained models provided by the DeepComposer service.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @experimental
     */
    toListSampleModels(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/deepcomposer-tagging.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list all the training options or topic for creating/training a model.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-custom-model.html
     *
     * @experimental
     */
    toListTrainingTopics(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/deepcomposer-tagging.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/deepcomposer-tagging.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to modify the mutable properties associated with a composition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @experimental
     */
    toUpdateComposition(): this;
    /**
     * (experimental) Grants permission to to modify the mutable properties associated with a model.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-custom-model.html
     *
     * @experimental
     */
    toUpdateModel(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type model to the statement.
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-custom-model.html
     *
     * @param modelId - Identifier for the modelId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onModel(modelId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type composition to the statement.
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @param compositionId - Identifier for the compositionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onComposition(compositionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type audio to the statement.
     *
     * https://docs.aws.amazon.com/deepcomposer/latest/devguide/get-started-learn-from-pre-trained-models.html
     *
     * @param audioId - Identifier for the audioId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAudio(audioId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [deepcomposer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepcomposer.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
