// Generated by CoffeeScript 1.12.7
(function() {
  var Theme, color, colorize, colorizeToArray, colorizeToCallback, extendedTypeOf, subcolorizeToCallback,
    hasProp = {}.hasOwnProperty;

  color = require('cli-color');

  extendedTypeOf = require('./util').extendedTypeOf;

  Theme = {
    ' ': function(s) {
      return s;
    },
    '+': color.green,
    '-': color.red
  };

  subcolorizeToCallback = function(key, diff, output, color, indent) {
    var i, item, j, k, len, len1, len2, looksLikeDiff, m, op, prefix, ref, ref1, subindent, subkey, subvalue;
    prefix = key ? key + ": " : '';
    subindent = indent + '  ';
    switch (extendedTypeOf(diff)) {
      case 'object':
        if (('__old' in diff) && ('__new' in diff) && (Object.keys(diff).length === 2)) {
          subcolorizeToCallback(key, diff.__old, output, '-', indent);
          return subcolorizeToCallback(key, diff.__new, output, '+', indent);
        } else {
          output(color, "" + indent + prefix + "{");
          for (subkey in diff) {
            if (!hasProp.call(diff, subkey)) continue;
            subvalue = diff[subkey];
            if (m = subkey.match(/^(.*)__deleted$/)) {
              subcolorizeToCallback(m[1], subvalue, output, '-', subindent);
            } else if (m = subkey.match(/^(.*)__added$/)) {
              subcolorizeToCallback(m[1], subvalue, output, '+', subindent);
            } else {
              subcolorizeToCallback(subkey, subvalue, output, color, subindent);
            }
          }
          return output(color, indent + "}");
        }
        break;
      case 'array':
        output(color, "" + indent + prefix + "[");
        looksLikeDiff = true;
        for (i = 0, len = diff.length; i < len; i++) {
          item = diff[i];
          if ((extendedTypeOf(item) !== 'array') || !((item.length === 2) || ((item.length === 1) && (item[0] === ' '))) || !(typeof item[0] === 'string') || item[0].length !== 1 || !((ref = item[0]) === ' ' || ref === '-' || ref === '+' || ref === '~')) {
            looksLikeDiff = false;
          }
        }
        if (looksLikeDiff) {
          for (j = 0, len1 = diff.length; j < len1; j++) {
            ref1 = diff[j], op = ref1[0], subvalue = ref1[1];
            if (op === ' ' && (subvalue == null)) {
              output(' ', subindent + '...');
            } else {
              if (op !== ' ' && op !== '~' && op !== '+' && op !== '-') {
                throw new Error("Unexpected op '" + op + "' in " + (JSON.stringify(diff, null, 2)));
              }
              if (op === '~') {
                op = ' ';
              }
              subcolorizeToCallback('', subvalue, output, op, subindent);
            }
          }
        } else {
          for (k = 0, len2 = diff.length; k < len2; k++) {
            subvalue = diff[k];
            subcolorizeToCallback('', subvalue, output, color, subindent);
          }
        }
        return output(color, indent + "]");
      default:
        if (diff === 0 || diff === null || diff === false || diff) {
          return output(color, indent + prefix + JSON.stringify(diff));
        }
    }
  };

  colorizeToCallback = function(diff, output) {
    return subcolorizeToCallback('', diff, output, ' ', '');
  };

  colorizeToArray = function(diff) {
    var output;
    output = [];
    colorizeToCallback(diff, function(color, line) {
      return output.push("" + color + line);
    });
    return output;
  };

  colorize = function(diff, options) {
    var output;
    if (options == null) {
      options = {};
    }
    output = [];
    colorizeToCallback(diff, function(color, line) {
      var ref, ref1, ref2;
      if ((ref = options.color) != null ? ref : true) {
        return output.push(((ref1 = (ref2 = options.theme) != null ? ref2[color] : void 0) != null ? ref1 : Theme[color])("" + color + line) + "\n");
      } else {
        return output.push("" + color + line + "\n");
      }
    });
    return output.join('');
  };

  module.exports = {
    colorize: colorize,
    colorizeToArray: colorizeToArray,
    colorizeToCallback: colorizeToCallback
  };

}).call(this);
