"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
class ProfilerGroupIntegrationTest extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const profilingGroup = new lib_1.ProfilingGroup(this, 'MyProfilingGroup');
        const publishAppRole = new aws_iam_1.Role(this, 'PublishAppRole', {
            assumedBy: new aws_iam_1.AccountRootPrincipal(),
        });
        profilingGroup.grantPublish(publishAppRole);
        const readAppRole = new aws_iam_1.Role(this, 'ReadAppRole', {
            assumedBy: new aws_iam_1.AccountRootPrincipal(),
        });
        profilingGroup.grantRead(readAppRole);
    }
}
const app = new core_1.App();
new ProfilerGroupIntegrationTest(app, 'ProfilerGroupIntegrationTest');
app.synth();
//# sourceMappingURL=data:application/json;base64,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