"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSipMediaApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const customResource_1 = require("./customResource");
const sipMediaApplicationValidator_1 = require("./sipMediaApplicationValidator");
class ChimeSipMediaApp extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, endpoint, region } = props;
        sipMediaApplicationValidator_1.sipMediaApplicationValidator(props);
        const sipMediaAppRequest = new customResource_1.ChimeResources(this, 'sipMediaAppRequest', {
            resourceType: 'SMA',
            uid: uid,
            properties: {
                region: region || cdk.Stack.of(this).region,
                name: name !== null && name !== void 0 ? name : uid,
                endpoint: endpoint,
            },
        });
        this.sipMediaAppId =
            sipMediaAppRequest.chimeCustomResource.getAttString('sipMediaAppId');
    }
}
exports.ChimeSipMediaApp = ChimeSipMediaApp;
_a = JSII_RTTI_SYMBOL_1;
ChimeSipMediaApp[_a] = { fqn: "cdk-amazon-chime-resources.ChimeSipMediaApp", version: "0.0.29" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2lwTWVkaWFBcHBsaWNhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9zaXBNZWRpYUFwcGxpY2F0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsbUNBQW1DO0FBRW5DLDJDQUF1QztBQUN2QyxxREFBa0Q7QUFDbEQsaUZBQThFO0FBNEI5RSxNQUFhLGdCQUFpQixTQUFRLHNCQUFTO0lBRzdDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBdUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEdBQUcsR0FBVyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUU3QyxNQUFNLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxNQUFNLEVBQUUsR0FBRyxLQUFLLENBQUM7UUFFekMsMkRBQTRCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFcEMsTUFBTSxrQkFBa0IsR0FBRyxJQUFJLCtCQUFjLENBQUMsSUFBSSxFQUFFLG9CQUFvQixFQUFFO1lBQ3hFLFlBQVksRUFBRSxLQUFLO1lBQ25CLEdBQUcsRUFBRSxHQUFHO1lBQ1IsVUFBVSxFQUFFO2dCQUNWLE1BQU0sRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTTtnQkFDM0MsSUFBSSxFQUFFLElBQUksYUFBSixJQUFJLGNBQUosSUFBSSxHQUFJLEdBQUc7Z0JBQ2pCLFFBQVEsRUFBRSxRQUFRO2FBQ25CO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGFBQWE7WUFDaEIsa0JBQWtCLENBQUMsbUJBQW1CLENBQUMsWUFBWSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ3pFLENBQUM7O0FBeEJILDRDQXlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBGdW5jdGlvbiB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDaGltZVJlc291cmNlcyB9IGZyb20gJy4vY3VzdG9tUmVzb3VyY2UnO1xuaW1wb3J0IHsgc2lwTWVkaWFBcHBsaWNhdGlvblZhbGlkYXRvciB9IGZyb20gJy4vc2lwTWVkaWFBcHBsaWNhdGlvblZhbGlkYXRvcic7XG5cbi8qKlxuICogUHJvcHMgZm9yIGBTaXBNZWRpYUFwcGxpY2F0aW9uYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTaXBNZWRpYUFwcFByb3BzIHtcbiAgLyoqXG4gICAqIHJlZ2lvbiBmb3IgU2lwTWVkaWFBcHBsaWNhdGlvbihyZXF1aXJlZCkgLSBNdXN0IHVzLWVhc3QtMSBvciB1cy13ZXN0LTIgYW5kIGluIHRoZSBzYW1lIHJlZ2lvbiBhcyB0aGUgU2lwTWVkaWFBcHBsaWNhdGlvbiBMYW1iZGEgaGFuZGxlclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHNhbWUgcmVnaW9uIGFzIHN0YWNrIGRlcGxveW1lbnRcbiAgICovXG4gIHJlYWRvbmx5IHJlZ2lvbj86IHN0cmluZztcblxuICAvKipcbiAgICogZW5kcG9pbnQgZm9yIFNpcE1lZGlhQXBwbGljYXRpb24ocmVxdWlyZWQpXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZW5kcG9pbnQ6IEZ1bmN0aW9uWydmdW5jdGlvbkFybiddO1xuXG4gIC8qKlxuICAgKiBuYW1lIGZvciBTaXBNZWRpYUFwcGxpY2F0aW9uIChvcHRpb25hbClcbiAgICpcbiAgICogQGRlZmF1bHQgLSB1bmlxdWUgSUQgZm9yIHJlc291cmNlXG4gICAqL1xuICByZWFkb25seSBuYW1lPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgQ2hpbWVTaXBNZWRpYUFwcCBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyByZWFkb25seSBzaXBNZWRpYUFwcElkOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFNpcE1lZGlhQXBwUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgdWlkOiBzdHJpbmcgPSBjZGsuTmFtZXMudW5pcXVlSWQodGhpcyk7XG5cbiAgICBjb25zdCB7IG5hbWUsIGVuZHBvaW50LCByZWdpb24gfSA9IHByb3BzO1xuXG4gICAgc2lwTWVkaWFBcHBsaWNhdGlvblZhbGlkYXRvcihwcm9wcyk7XG5cbiAgICBjb25zdCBzaXBNZWRpYUFwcFJlcXVlc3QgPSBuZXcgQ2hpbWVSZXNvdXJjZXModGhpcywgJ3NpcE1lZGlhQXBwUmVxdWVzdCcsIHtcbiAgICAgIHJlc291cmNlVHlwZTogJ1NNQScsXG4gICAgICB1aWQ6IHVpZCxcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgcmVnaW9uOiByZWdpb24gfHwgY2RrLlN0YWNrLm9mKHRoaXMpLnJlZ2lvbixcbiAgICAgICAgbmFtZTogbmFtZSA/PyB1aWQsXG4gICAgICAgIGVuZHBvaW50OiBlbmRwb2ludCxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnNpcE1lZGlhQXBwSWQgPVxuICAgICAgc2lwTWVkaWFBcHBSZXF1ZXN0LmNoaW1lQ3VzdG9tUmVzb3VyY2UuZ2V0QXR0U3RyaW5nKCdzaXBNZWRpYUFwcElkJyk7XG4gIH1cbn1cbiJdfQ==