import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::Athena::NamedQuery`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html
 */
export interface CfnNamedQueryProps {
    /**
     * `AWS::Athena::NamedQuery.Database`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-database
     */
    readonly database: string;
    /**
     * `AWS::Athena::NamedQuery.QueryString`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-querystring
     */
    readonly queryString: string;
    /**
     * `AWS::Athena::NamedQuery.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-description
     */
    readonly description?: string;
    /**
     * `AWS::Athena::NamedQuery.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-name
     */
    readonly name?: string;
}
/**
 * A CloudFormation `AWS::Athena::NamedQuery`
 *
 * @cloudformationResource AWS::Athena::NamedQuery
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html
 */
export declare class CfnNamedQuery extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Athena::NamedQuery";
    readonly namedQueryName: string;
    /**
     * Create a new `AWS::Athena::NamedQuery`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNamedQueryProps);
    readonly propertyOverrides: CfnNamedQueryProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
