# coding: utf-8

import json

import requests
from sentry.plugins.bases.notify import NotificationPlugin

import sentry_dingding
from .forms import DingDingOptionsForm

DingTalk_API = "https://oapi.dingtalk.com/robot/send?access_token={token}"


class DingDingPlugin(NotificationPlugin):
    """
    Sentry plugin to send error counts to DingDing.
    """
    author = 'hsw10151'
    version = sentry_dingding.VERSION
    description = 'upgraded DingTalk integrations for sentry. '
    slug = 'DingTalk-2021'
    title = 'DingTalk-2021'
    conf_key = slug
    conf_title = title
    project_conf_form = DingDingOptionsForm

    def is_configured(self, project):
        """
        Check if plugin is configured.
        """
        return bool(self.get_option('access_token', project))

    def notify_users(self, group, event, *args, **kwargs):
        self.post_process(group, event, *args, **kwargs)

    def post_process(self, group, event, *args, **kwargs):
        """
        Process error.
        """
        if not self.is_configured(group.project):
            return

        if group.is_ignored():
            return

        access_token = self.get_option('access_token', group.project)
        keyword = self.get_option('keyword', group.project)
        send_url = DingTalk_API.format(token=access_token)
        title = u"=====>异常通知: \n [{}]".format(event.project.slug)

        data = {
            "msgtype": "markdown",
            "markdown": {
                "title": title,
                "text": u"#### {title} \n > {message}  \n  event:{event}  \n  {url}".format(
                    title=title,
                    message=event.message,
                    url=u"{}events/{}/".format(group.get_absolute_url(), event.event_id),
                    event=str(event.message)
                    # env=event.environment,
                    # proj=event.tags.project,
                    # id=event.event_id,
                    # requestFrom=event.request.url
                    #Environment: {env} \n Project: {proj} \n Id: {id} \n RequestFrom:{requestFrom}
                )
            }
        }
        requests.post(
            url=send_url,
            headers={"Content-Type": "application/json"},
            data=json.dumps(data).encode("utf-8")
        )