import math


###############################################################################
#
###############################################################################
class SiVector2:


    ###############################################################################
    #
    ###############################################################################
    def __init__(self, x, y):

        self.x = x
        self.y = y

    ########################################################################################
    #
    # return self.vector - in_vector
    #
    #######################################################################################
    def subtract(self, v: 'SiVector2'):
        
        return SiVector2((self.x - v.x),
                         (self.y - v.y))


###############################################################################
#
###############################################################################
class SiVector3:


    ###############################################################################
    #
    ###############################################################################
    def __init__(self, x, y, z):

        self.x = x
        self.y = y
        self.z = z


    ########################################################################################
    #
    # '+' operator overload
    #
    #######################################################################################
    def __add__(self, v: 'SiVector3'):

        return SiVector3((self.x + v.x),
                         (self.y + v.y),
                         (self.z + v.z))


    ########################################################################################
    #
    # '-' operator overload
    #
    #######################################################################################
    def __sub__(self, v: 'SiVector3'):

        return SiVector3((self.x - v.x),
                         (self.y - v.y),
                         (self.z - v.z))


    ########################################################################################
    #
    # '*' operator overload
    #
    #######################################################################################
    def __mul__(self, scaler: float):

        return SiVector3((self.x * scaler),
                         (self.y * scaler),
                         (self.z * scaler))




    ########################################################################################
    #
    #######################################################################################
    def normalize(self):
        
        v = SiVector3(0.0, 0.0, 0.0)

        len = math.sqrt(self.x*self.x + self.y*self.y + self.z*self.z)
        v.x = self.x / len
        v.y = self.y / len
        v.z = self.z / len

        return v;



###############################################################################
#
###############################################################################
class SiVector4:

    ###############################################################################
    #
    ###############################################################################
    def __init__(self, x, y, z, w):

        self.x = x
        self.y = y
        self.z = z
        self.w = w


    ########################################################################################
    #
    # return self.vector - in_vector
    #
    #######################################################################################
    def subtract(self, v: 'SiVector4'):
        
        return SiVector4((self.x - v.x),
                         (self.y - v.y),
                         (self.z - v.z),
                         (self.w - v.w))

