# Generated by Django 1.11.10 on 2018-02-07 06:56

from django.conf import settings
import django.contrib.sites.models
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import promgen.models
import promgen.validators


class Migration(migrations.Migration):

    replaces = [('promgen', '0001_initial'), ('promgen', '0002_audit'), ('promgen', '0003_setting'), ('promgen', '0004_auto_20161019_0755'), ('promgen', '0005_sender'), ('promgen', '0006_auto_20161019_1214'), ('promgen', '0007_auto_20161020_0253'), ('promgen', '0008_auto_20161020_0528'), ('promgen', '0009_auto_20161021_0640'), ('promgen', '0010_auto_20161025_0034'), ('promgen', '0011_auto_20161025_0737'), ('promgen', '0012_auto_20161027_0306'), ('promgen', '0013_auto_20161027_0307'), ('promgen', '0014_stat'), ('promgen', '0015_delete_stat'), ('promgen', '0016_auto_20161121_0714'), ('promgen', '0017_auto_20161215_2352'), ('promgen', '0018_rule_enabled'), ('promgen', '0019_url'), ('promgen', '0020_auto_20161226_0337'), ('promgen', '0021_auto_20161228_0049'), ('promgen', '0022_auto_20170116_0824'), ('promgen', '0023_shard'), ('promgen', '0024_auto_20170220_0324'), ('promgen', '0025_shard_url'), ('promgen', '0026_auto_20170315_0344'), ('promgen', '0027_prometheus_server'), ('promgen', '0028_url_sort_fields'), ('promgen', '0029_auto_20170406_0236'), ('promgen', '0030_exporter_enabled'), ('promgen', '0031_sender_to_notification'), ('promgen', '0032_audit_diff'), ('promgen', '0033_diff_old'), ('promgen', '0034_auto_20170622_0518'), ('promgen', '0035_rule_parent'), ('promgen', '0036_auto_20170626_0231'), ('promgen', '0037_shard_proxy'), ('promgen', '0038_audit_user'), ('promgen', '0039_auto_20170725_0257'), ('promgen', '0040_default_farm'), ('promgen', '0041_sender_owner'), ('promgen', '0042_description_field'), ('promgen', '0043_rule_description'), ('promgen', '0044_common-rules')]

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Audit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('body', models.TextField()),
                ('created', models.DateTimeField()),
                ('data', models.TextField(blank=True)),
                ('old', models.TextField(blank=True)),
                ('object_id', models.PositiveIntegerField(default=0)),
                ('content_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('user', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Exporter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('job', models.CharField(max_length=128)),
                ('port', models.IntegerField()),
                ('path', models.CharField(blank=True, max_length=128)),
                ('enabled', models.BooleanField(default=True)),
            ],
            options={
                'ordering': ['job', 'port'],
            },
        ),
        migrations.CreateModel(
            name='Farm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('source', models.CharField(max_length=128)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Host',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('farm', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='promgen.Farm')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, unique=True)),
                ('description', models.TextField(blank=True)),
                ('farm', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='promgen.Farm')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Prometheus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('host', models.CharField(max_length=128)),
                ('port', models.IntegerField()),
            ],
            options={
                'verbose_name_plural': 'prometheis',
                'ordering': ['shard', 'host'],
            },
        ),
        migrations.CreateModel(
            name='Rule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, unique=True, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z_]*$', 'Only alphanumeric characters are allowed.')])),
                ('clause', models.TextField(help_text='Prometheus query')),
                ('duration', models.CharField(help_text='Duration field with postfix. Example 30s, 5m, 1d', max_length=128, validators=[promgen.validators.duration])),
                ('enabled', models.BooleanField(default=True)),
                ('object_id', models.PositiveIntegerField()),
                ('description', models.TextField(blank=True)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='overrides', to='promgen.Rule')),
            ],
            options={
                'ordering': ['content_type', 'object_id', 'name'],
            },
        ),
        migrations.CreateModel(
            name='RuleAnnotation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('value', models.TextField()),
                ('rule', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='promgen.Rule')),
            ],
        ),
        migrations.CreateModel(
            name='RuleLabel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('value', models.CharField(max_length=128)),
                ('rule', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='promgen.Rule')),
            ],
        ),
        migrations.CreateModel(
            name='Sender',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sender', models.CharField(max_length=128)),
                ('value', models.CharField(max_length=128)),
                ('alias', models.CharField(blank=True, max_length=128)),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, unique=True)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'ordering': ['shard', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Shard',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, unique=True)),
                ('url', models.URLField(max_length=256)),
                ('proxy', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='URL',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=256)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='promgen.Project')),
            ],
            options={
                'ordering': ['project__service', 'project', 'url'],
            },
        ),
        migrations.CreateModel(
            name='Site',
            fields=[
            ],
            options={
                'indexes': [],
                'proxy': True,
            },
            bases=('sites.site',),
            managers=[
                ('objects', django.contrib.sites.models.SiteManager()),
            ],
        ),
        migrations.AddField(
            model_name='service',
            name='shard',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='promgen.Shard'),
        ),
        migrations.AddField(
            model_name='prometheus',
            name='shard',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='promgen.Shard'),
        ),
        migrations.AddField(
            model_name='project',
            name='service',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='promgen.Service'),
        ),
        migrations.AlterUniqueTogether(
            name='farm',
            unique_together={('name', 'source')},
        ),
        migrations.AddField(
            model_name='exporter',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='promgen.Project'),
        ),
        migrations.AlterUniqueTogether(
            name='prometheus',
            unique_together={('host', 'port')},
        ),
        migrations.AlterUniqueTogether(
            name='host',
            unique_together={('name', 'farm')},
        ),
        migrations.AlterUniqueTogether(
            name='exporter',
            unique_together={('job', 'port', 'project')},
        ),
    ]
