# Generated by Django 2.1.8 on 2019-04-22 07:15

from django.db import migrations, models
import django.db.models.deletion


def project_to_shard(apps, schema_editor):
    Project = apps.get_model("promgen", "Project")
    for project in Project.objects.all():
        project.shard_id = project.service.shard_id
        project.save()


def project_to_service(apps, schema_editor):
    Project = apps.get_model("promgen", "Project")
    for project in Project.objects.all():
        project.service.shard_id = project.shard_id
        project.service.save()


class Migration(migrations.Migration):

    dependencies = [("promgen", "0007_message_filter")]

    operations = [
        migrations.AddField(
            model_name="project",
            name="shard",
            field=models.ForeignKey(
                default=1,
                on_delete=django.db.models.deletion.CASCADE,
                to="promgen.Shard",
            ),
            preserve_default=False,
        ),
        migrations.RunPython(project_to_shard, project_to_service),
        migrations.AlterModelOptions(name="service", options={"ordering": ["name"]}),
        migrations.RemoveField(model_name="service", name="shard"),
    ]
